# !!!
# WARNING: This file is autogenerated
# Only modify code within MANUAL() sections
# or your changes may be overwritten later!
# !!!

from __future__ import annotations

import datetime
import enum
from typing import Any, Dict, List, Optional

import pydantic

from stytch.b2b.models.mfa import MfaRequired
from stytch.b2b.models.organizations import Member, Organization
from stytch.consumer.models.device_history import DeviceInfo
from stytch.consumer.models.sessions import JWK, AuthenticationFactor
from stytch.core.response_base import ResponseBase
from stytch.shared.method_options import Authorization


class ExchangeRequestLocale(str, enum.Enum):
    EN = "en"
    ES = "es"
    PTBR = "pt-br"
    FR = "fr"
    IT = "it"
    DEDE = "de-DE"
    ZHHANS = "zh-Hans"
    CAES = "ca-ES"


class AuthorizationCheck(pydantic.BaseModel):
    """
    Fields:
      - organization_id: Globally unique UUID that identifies a specific Organization. The Organization's ID must match the Member's Organization
      - resource_id: A unique identifier of the RBAC Resource, provided by the developer and intended to be human-readable.

      A `resource_id` is not allowed to start with `stytch`, which is a special prefix used for Stytch default Resources with reserved `resource_id`s. These include:

      * `stytch.organization`
      * `stytch.member`
      * `stytch.sso`
      * `stytch.self`

      Check out the [guide on Stytch default Resources](https://stytch.com/docs/b2b/guides/rbac/stytch-default) for a more detailed explanation.


      - action: An action to take on a Resource.
    """  # noqa

    organization_id: str
    resource_id: str
    action: str


class AuthorizationVerdict(pydantic.BaseModel):
    """
    Fields:
      - authorized: Whether the Member was authorized to perform the specified action on the specified Resource. Always true if the request succeeds.
      - granting_roles: The complete list of Roles that gave the Member permission to perform the specified action on the specified Resource.
    """  # noqa

    authorized: bool
    granting_roles: List[str]


class MemberSession(pydantic.BaseModel):
    """
    Fields:
      - member_session_id: Globally unique UUID that identifies a specific Session.
      - member_id: Globally unique UUID that identifies a specific Member.
      - started_at: The timestamp when the Session was created. Values conform to the RFC 3339 standard and are expressed in UTC, e.g. `2021-12-29T12:33:09Z`.
      - last_accessed_at: The timestamp when the Session was last accessed. Values conform to the RFC 3339 standard and are expressed in UTC, e.g. `2021-12-29T12:33:09Z`.
      - expires_at: The timestamp when the Session expires. Values conform to the RFC 3339 standard and are expressed in UTC, e.g. `2021-12-29T12:33:09Z`.
      - authentication_factors: An array of different authentication factors that comprise a Session.
      - organization_id: Globally unique UUID that identifies a specific Organization. The `organization_id` is critical to perform operations on an Organization, so be sure to preserve this value.
      - roles: (no documentation yet)
      - organization_slug: The unique URL slug of the Organization. The slug only accepts alphanumeric characters and the following reserved characters: `-` `.` `_` `~`. Must be between 2 and 128 characters in length. Wherever an organization_id is expected in a path or request parameter, you may also use the organization_slug as a convenience.
      - custom_claims: The custom claims map for a Session. Claims can be added to a session during a Sessions authenticate call.
    """  # noqa

    member_session_id: str
    member_id: str
    started_at: datetime.datetime
    last_accessed_at: datetime.datetime
    expires_at: datetime.datetime
    authentication_factors: List[AuthenticationFactor]
    organization_id: str
    roles: List[str]
    organization_slug: str
    custom_claims: Optional[Dict[str, Any]] = None


class PrimaryRequired(pydantic.BaseModel):
    """
    Fields:
      - allowed_auth_methods: Details the auth method that the member must also complete to fulfill the primary authentication requirements of the Organization. For example, a value of `[magic_link]` indicates that the Member must also complete a magic link authentication step. If you have an intermediate session token, you must pass it into that primary authentication step.
    """  # noqa

    allowed_auth_methods: List[str]


class RevokeRequestOptions(pydantic.BaseModel):
    """
    Fields:
      - authorization: Optional authorization object.
    Pass in an active Stytch Member session token or session JWT and the request
    will be run using that member's permissions.
    """  # noqa

    authorization: Optional[Authorization] = None

    def add_headers(self, headers: Dict[str, str]) -> Dict[str, str]:
        if self.authorization is not None:
            headers = self.authorization.add_headers(headers)
        return headers


class AttestResponse(ResponseBase):
    """Response type for `Sessions.attest`.
    Fields:
      - member_id: Globally unique UUID that identifies a specific Member.
      - member_session: The [Session object](https://stytch.com/docs/b2b/api/session-object).
      - session_token: A secret token for a given Stytch Session.
      - session_jwt: The JSON Web Token (JWT) for a given Stytch Session.
      - member: The [Member object](https://stytch.com/docs/b2b/api/member-object)
      - organization: The [Organization object](https://stytch.com/docs/b2b/api/organization-object).
      - member_device: If a valid `telemetry_id` was passed in the request and the [Fingerprint Lookup API](https://stytch.com/docs/fraud/api/fingerprint-lookup) returned results, the `member_device` response field will contain information about the member's device attributes.
    """  # noqa

    member_id: str
    member_session: MemberSession
    session_token: str
    session_jwt: str
    member: Member
    organization: Organization
    member_device: Optional[DeviceInfo] = None


class AuthenticateResponse(ResponseBase):
    """Response type for `Sessions.authenticate`.
    Fields:
      - member_session: The [Session object](https://stytch.com/docs/b2b/api/session-object).
      - session_token: A secret token for a given Stytch Session.
      - session_jwt: The JSON Web Token (JWT) for a given Stytch Session.
      - member: The [Member object](https://stytch.com/docs/b2b/api/member-object)
      - organization: The [Organization object](https://stytch.com/docs/b2b/api/organization-object).
      - verdict: If an `authorization_check` is provided in the request and the check succeeds, this field will return
      information about why the Member was granted permission.
    """  # noqa

    member_session: MemberSession
    session_token: str
    session_jwt: str
    member: Member
    organization: Organization
    verdict: Optional[AuthorizationVerdict] = None


class ExchangeAccessTokenResponse(ResponseBase):
    """Response type for `Sessions.exchange_access_token`.
    Fields:
      - member_id: Globally unique UUID that identifies a specific Member.
      - session_token: A secret token for a given Stytch Session.
      - session_jwt: The JSON Web Token (JWT) for a given Stytch Session.
      - member: The [Member object](https://stytch.com/docs/b2b/api/member-object)
      - organization: The [Organization object](https://stytch.com/docs/b2b/api/organization-object).
      - member_session: The [Session object](https://stytch.com/docs/b2b/api/session-object).
      - member_device: If a valid `telemetry_id` was passed in the request and the [Fingerprint Lookup API](https://stytch.com/docs/fraud/api/fingerprint-lookup) returned results, the `member_device` response field will contain information about the member's device attributes.
    """  # noqa

    member_id: str
    session_token: str
    session_jwt: str
    member: Member
    organization: Organization
    member_session: Optional[MemberSession] = None
    member_device: Optional[DeviceInfo] = None


class ExchangeResponse(ResponseBase):
    """Response type for `Sessions.exchange`.
    Fields:
      - member_id: Globally unique UUID that identifies a specific Member.
      - session_token: A secret token for a given Stytch Session.
      - session_jwt: The JSON Web Token (JWT) for a given Stytch Session.
      - member: The [Member object](https://stytch.com/docs/b2b/api/member-object)
      - organization: The [Organization object](https://stytch.com/docs/b2b/api/organization-object).
      - member_authenticated: Indicates whether the Member is fully authenticated. If false, the Member needs to complete an MFA step to log in to the Organization.
      - intermediate_session_token: The returned Intermediate Session Token contains any Email Magic Link or OAuth factors from the original member session that are valid for the target Organization. If this value is non-empty, the member must complete an MFA step to finish logging in to the Organization. The token can be used with the [OTP SMS Authenticate endpoint](https://stytch.com/docs/b2b/api/authenticate-otp-sms), [TOTP Authenticate endpoint](https://stytch.com/docs/b2b/api/authenticate-totp), or [Recovery Codes Recover endpoint](https://stytch.com/docs/b2b/api/recovery-codes-recover) to complete an MFA flow and log in to the Organization. The token has a default expiry of 10 minutes. It can also be used with the [Exchange Intermediate Session endpoint](https://stytch.com/docs/b2b/api/exchange-intermediate-session) to join a specific Organization that allows the factors represented by the intermediate session token; or the [Create Organization via Discovery endpoint](https://stytch.com/docs/b2b/api/create-organization-via-discovery) to create a new Organization and Member. Intermediate Session Tokens have a default expiry of 10 minutes.
      - member_session: The [Session object](https://stytch.com/docs/b2b/api/session-object).
      - mfa_required: Information about the MFA requirements of the Organization and the Member's options for fulfilling MFA.
      - primary_required: Information about the primary authentication requirements of the Organization.
      - member_device: If a valid `telemetry_id` was passed in the request and the [Fingerprint Lookup API](https://stytch.com/docs/fraud/api/fingerprint-lookup) returned results, the `member_device` response field will contain information about the member's device attributes.
    """  # noqa

    member_id: str
    session_token: str
    session_jwt: str
    member: Member
    organization: Organization
    member_authenticated: bool
    intermediate_session_token: str
    member_session: Optional[MemberSession] = None
    mfa_required: Optional[MfaRequired] = None
    primary_required: Optional[PrimaryRequired] = None
    member_device: Optional[DeviceInfo] = None


class GetJWKSResponse(ResponseBase):
    """Response type for `Sessions.get_jwks`.
    Fields:
      - keys: The list of JWKs associated with the project.
    """  # noqa

    keys: List[JWK]


class GetResponse(ResponseBase):
    """Response type for `Sessions.get`.
    Fields:
      - member_sessions: An array of [Session objects](https://stytch.com/docs/b2b/api/session-object).
    """  # noqa

    member_sessions: List[MemberSession]


class MigrateResponse(ResponseBase):
    """Response type for `Sessions.migrate`.
    Fields:
      - member_id: Globally unique UUID that identifies a specific Member.
      - session_token: A secret token for a given Stytch Session.
      - session_jwt: The JSON Web Token (JWT) for a given Stytch Session.
      - member: The [Member object](https://stytch.com/docs/b2b/api/member-object)
      - organization: The [Organization object](https://stytch.com/docs/b2b/api/organization-object).
      - member_session: The [Session object](https://stytch.com/docs/b2b/api/session-object).
    """  # noqa

    member_id: str
    session_token: str
    session_jwt: str
    member: Member
    organization: Organization
    member_session: Optional[MemberSession] = None


class RevokeResponse(ResponseBase):
    """Response type for `Sessions.revoke`.
    Fields:
    """  # noqa


# MANUAL(LocalJWTResponse)(Types)
class LocalJWTResponse(pydantic.BaseModel):
    member_session: MemberSession
    roles_claim: Optional[List[str]]


# ENDMANUAL(LocalJWTResponse)


# MANUAL(AuthenticateJWTLocalResponse)(Types)
class AuthenticateJWTLocalResponse(ResponseBase):
    member_session: MemberSession
    session_jwt: str


# ENDMANUAL(AuthenticateJWTLocalResponse)
