# !!!
# WARNING: This file is autogenerated
# Only modify code within MANUAL() sections
# or your changes may be overwritten later!
# !!!

from __future__ import annotations

from typing import List, Optional

from stytch.b2b.models.organizations import Member, Organization
from stytch.b2b.models.sessions import MemberSession
from stytch.consumer.models.device_history import DeviceInfo
from stytch.core.response_base import ResponseBase


class AuthenticateResponse(ResponseBase):
    """Response type for `TOTPs.authenticate`.
    Fields:
      - member_id: Globally unique UUID that identifies a specific Member.
      - member: The [Member object](https://stytch.com/docs/b2b/api/member-object)
      - organization: The [Organization object](https://stytch.com/docs/b2b/api/organization-object).
      - session_token: A secret token for a given Stytch Session.
      - session_jwt: The JSON Web Token (JWT) for a given Stytch Session.
      - member_session: The [Session object](https://stytch.com/docs/b2b/api/session-object).
      - member_device: If a valid `telemetry_id` was passed in the request and the [Fingerprint Lookup API](https://stytch.com/docs/fraud/api/fingerprint-lookup) returned results, the `member_device` response field will contain information about the member's device attributes.
    """  # noqa

    member_id: str
    member: Member
    organization: Organization
    session_token: str
    session_jwt: str
    member_session: Optional[MemberSession] = None
    member_device: Optional[DeviceInfo] = None


class CreateResponse(ResponseBase):
    """Response type for `TOTPs.create`.
    Fields:
      - member_id: Globally unique UUID that identifies a specific Member.
      - totp_registration_id: The unique ID for a TOTP instance.
      - secret: The TOTP secret key shared between the authenticator app and the server used to generate TOTP codes.
      - qr_code: The QR code image encoded in base64.
      - recovery_codes: An array of recovery codes that can be used to recover a Member's account.
      - member: The [Member object](https://stytch.com/docs/b2b/api/member-object)
      - organization: The [Organization object](https://stytch.com/docs/b2b/api/organization-object).
    """  # noqa

    member_id: str
    totp_registration_id: str
    secret: str
    qr_code: str
    recovery_codes: List[str]
    member: Member
    organization: Organization


class MigrateResponse(ResponseBase):
    """Response type for `TOTPs.migrate`.
    Fields:
      - member_id: Globally unique UUID that identifies a specific Member.
      - member: The [Member object](https://stytch.com/docs/b2b/api/member-object)
      - organization: The [Organization object](https://stytch.com/docs/b2b/api/organization-object).
      - totp_registration_id: The unique ID for a TOTP instance.
      - recovery_codes: An array of recovery codes that can be used to recover a Member's account.
    """  # noqa

    member_id: str
    member: Member
    organization: Organization
    totp_registration_id: str
    recovery_codes: List[str]
