# !!!
# WARNING: This file is autogenerated
# Only modify code within MANUAL() sections
# or your changes may be overwritten later!
# !!!

from __future__ import annotations

from typing import Any, Dict, Optional, Union

from stytch.consumer.models.fraud_verdict_reasons import (
    ListResponse,
    OverrideRequestAction,
    OverrideResponse,
)
from stytch.core.api_base import ApiBase
from stytch.core.http.client import AsyncClient, SyncClient


class VerdictReasons:
    def __init__(
        self, api_base: ApiBase, sync_client: SyncClient, async_client: AsyncClient
    ) -> None:
        self.api_base = api_base
        self.sync_client = sync_client
        self.async_client = async_client

    def override(
        self,
        verdict_reason: str,
        override_action: Union[OverrideRequestAction, str],
        override_description: Optional[str] = None,
    ) -> OverrideResponse:
        """Use this endpoint to override the action returned for a specific verdict reason during a fingerprint lookup. For example, Stytch Device Fingerprinting returns a `CHALLENGE` verdict action by default for the verdict reason `VIRTUAL_MACHINE`. You can use this endpoint to override that reason to return an `ALLOW` verdict instead if you expect many legitimate users to be using a browser that runs in a virtual machine.

        Fields:
          - verdict_reason: The verdict reason that you wish to override. For a list of possible reasons to override, see [Warning Flags (Verdict Reasons)](https://stytch.com/docs/docs/fraud/guides/device-fingerprinting/reference/warning-flags-verdict-reasons). You may not override the `RULE_MATCH` reason.
          - override_action: The action that you want to be returned for the specified verdict reason. The override action must be one of `ALLOW`, `BLOCK`, or `CHALLENGE`.
          - override_description: An optional description for the verdict reason override.
        """  # noqa
        headers: Dict[str, str] = {}
        data: Dict[str, Any] = {
            "verdict_reason": verdict_reason,
            "override_action": override_action,
        }
        if override_description is not None:
            data["override_description"] = override_description

        url = self.api_base.url_for("/v1/verdict_reasons/override", data)
        res = self.sync_client.post(url, data, headers)
        return OverrideResponse.from_json(res.response.status_code, res.json)

    async def override_async(
        self,
        verdict_reason: str,
        override_action: OverrideRequestAction,
        override_description: Optional[str] = None,
    ) -> OverrideResponse:
        """Use this endpoint to override the action returned for a specific verdict reason during a fingerprint lookup. For example, Stytch Device Fingerprinting returns a `CHALLENGE` verdict action by default for the verdict reason `VIRTUAL_MACHINE`. You can use this endpoint to override that reason to return an `ALLOW` verdict instead if you expect many legitimate users to be using a browser that runs in a virtual machine.

        Fields:
          - verdict_reason: The verdict reason that you wish to override. For a list of possible reasons to override, see [Warning Flags (Verdict Reasons)](https://stytch.com/docs/docs/fraud/guides/device-fingerprinting/reference/warning-flags-verdict-reasons). You may not override the `RULE_MATCH` reason.
          - override_action: The action that you want to be returned for the specified verdict reason. The override action must be one of `ALLOW`, `BLOCK`, or `CHALLENGE`.
          - override_description: An optional description for the verdict reason override.
        """  # noqa
        headers: Dict[str, str] = {}
        data: Dict[str, Any] = {
            "verdict_reason": verdict_reason,
            "override_action": override_action,
        }
        if override_description is not None:
            data["override_description"] = override_description

        url = self.api_base.url_for("/v1/verdict_reasons/override", data)
        res = await self.async_client.post(url, data, headers)
        return OverrideResponse.from_json(res.response.status, res.json)

    def list(
        self,
        overrides_only: Optional[bool] = None,
    ) -> ListResponse:
        """Get the list of verdict reasons returned by the Stytch Device Fingerprinting product along with their default actions and any overrides you may have defined. This is not an exhaustive list of verdict reasons, but it contains all verdict reasons that you may set an override on.

        For a full list of possible verdict reasons, see [Warning Flags (Verdict Reasons)](https://stytch.com/docs/docs/fraud/guides/device-fingerprinting/reference/warning-flags-verdict-reasons).

        Fields:
          - overrides_only: Whether to return only verdict reasons that have overrides set. Defaults to false.
        """  # noqa
        headers: Dict[str, str] = {}
        data: Dict[str, Any] = {}
        if overrides_only is not None:
            data["overrides_only"] = overrides_only

        url = self.api_base.url_for("/v1/verdict_reasons/list", data)
        res = self.sync_client.post(url, data, headers)
        return ListResponse.from_json(res.response.status_code, res.json)

    async def list_async(
        self,
        overrides_only: Optional[bool] = None,
    ) -> ListResponse:
        """Get the list of verdict reasons returned by the Stytch Device Fingerprinting product along with their default actions and any overrides you may have defined. This is not an exhaustive list of verdict reasons, but it contains all verdict reasons that you may set an override on.

        For a full list of possible verdict reasons, see [Warning Flags (Verdict Reasons)](https://stytch.com/docs/docs/fraud/guides/device-fingerprinting/reference/warning-flags-verdict-reasons).

        Fields:
          - overrides_only: Whether to return only verdict reasons that have overrides set. Defaults to false.
        """  # noqa
        headers: Dict[str, str] = {}
        data: Dict[str, Any] = {}
        if overrides_only is not None:
            data["overrides_only"] = overrides_only

        url = self.api_base.url_for("/v1/verdict_reasons/list", data)
        res = await self.async_client.post(url, data, headers)
        return ListResponse.from_json(res.response.status, res.json)
