# !!!
# WARNING: This file is autogenerated
# Only modify code within MANUAL() sections
# or your changes may be overwritten later!
# !!!

from __future__ import annotations

from typing import List, Optional

import pydantic


class ConnectedApp(pydantic.BaseModel):
    """
    Fields:
      - client_id: The ID of the Connected App client.
      - client_name: A human-readable name for the client.
      - client_description: A human-readable description for the client.
      - status: (no documentation yet)
      - full_access_allowed: Valid for first party clients only. If `true`, an authorization token granted to this Client can be exchanged for a full Stytch session.
      - client_type: The type of Connected App. Supported values are `first_party`, `first_party_public`, `third_party`, and `third_party_public`.
      - redirect_urls: Array of redirect URI values for use in OAuth Authorization flows.
      - access_token_expiry_minutes: (no documentation yet)
      - access_token_template_content: (no documentation yet)
      - post_logout_redirect_urls: Array of redirect URI values for use in OIDC Logout flows.
      - bypass_consent_for_offline_access: Valid for first party clients only. If true, the client does not need to request explicit user consent for the `offline_access` scope.
      - client_secret_last_four: The last four characters of the client secret.
      - next_client_secret_last_four: The last four characters of the `next_client_secret`. Null if no `next_client_secret` exists.
      - access_token_custom_audience: (no documentation yet)
      - logo_url: The logo URL of the Connected App, if any.
      - client_id_metadata_url: (no documentation yet)
    """  # noqa

    client_id: str
    client_name: str
    client_description: str
    status: str
    full_access_allowed: bool
    client_type: str
    redirect_urls: List[str]
    access_token_expiry_minutes: int
    access_token_template_content: str
    post_logout_redirect_urls: List[str]
    bypass_consent_for_offline_access: bool
    client_secret_last_four: Optional[str] = None
    next_client_secret_last_four: Optional[str] = None
    access_token_custom_audience: Optional[str] = None
    logo_url: Optional[str] = None
    client_id_metadata_url: Optional[str] = None


class ConnectedAppPublic(pydantic.BaseModel):
    client_id: str
    client_name: str
    client_description: str
    client_type: str
    logo_url: Optional[str] = None


class ConnectedAppWithClientSecret(pydantic.BaseModel):
    """
    Fields:
      - client_id: The ID of the Connected App client.
      - client_name: A human-readable name for the client.
      - client_description: A human-readable description for the client.
      - status: (no documentation yet)
      - full_access_allowed: Valid for first party clients only. If `true`, an authorization token granted to this Client can be exchanged for a full Stytch session.
      - client_type: The type of Connected App. Supported values are `first_party`, `first_party_public`, `third_party`, and `third_party_public`.
      - redirect_urls: Array of redirect URI values for use in OAuth Authorization flows.
      - access_token_expiry_minutes: (no documentation yet)
      - access_token_template_content: (no documentation yet)
      - post_logout_redirect_urls: Array of redirect URI values for use in OIDC Logout flows.
      - bypass_consent_for_offline_access: Valid for first party clients only. If true, the client does not need to request explicit user consent for the `offline_access` scope.
      - client_secret_last_four: The last four characters of the client secret.
      - next_client_secret_last_four: The last four characters of the `next_client_secret`. Null if no `next_client_secret` exists.
      - client_secret: The secret of the Connected App client. **Required for confidential clients**
      - access_token_custom_audience: (no documentation yet)
      - logo_url: The logo URL of the Connected App, if any.
      - client_id_metadata_url: (no documentation yet)
    """  # noqa

    client_id: str
    client_name: str
    client_description: str
    status: str
    full_access_allowed: bool
    client_type: str
    redirect_urls: List[str]
    access_token_expiry_minutes: int
    access_token_template_content: str
    post_logout_redirect_urls: List[str]
    bypass_consent_for_offline_access: bool
    client_secret_last_four: Optional[str] = None
    next_client_secret_last_four: Optional[str] = None
    client_secret: Optional[str] = None
    access_token_custom_audience: Optional[str] = None
    logo_url: Optional[str] = None
    client_id_metadata_url: Optional[str] = None


class ConnectedAppWithNextClientSecret(pydantic.BaseModel):
    """
    Fields:
      - client_id: The ID of the Connected App client.
      - client_name: A human-readable name for the client.
      - client_description: A human-readable description for the client.
      - status: (no documentation yet)
      - client_secret_last_four: The last four characters of the client secret.
      - full_access_allowed: Valid for first party clients only. If `true`, an authorization token granted to this Client can be exchanged for a full Stytch session.
      - client_type: The type of Connected App. Supported values are `first_party`, `first_party_public`, `third_party`, and `third_party_public`.
      - redirect_urls: Array of redirect URI values for use in OAuth Authorization flows.
      - next_client_secret: (no documentation yet)
      - access_token_expiry_minutes: (no documentation yet)
      - access_token_template_content: (no documentation yet)
      - post_logout_redirect_urls: Array of redirect URI values for use in OIDC Logout flows.
      - bypass_consent_for_offline_access: Valid for first party clients only. If true, the client does not need to request explicit user consent for the `offline_access` scope.
      - next_client_secret_last_four: The last four characters of the `next_client_secret`. Null if no `next_client_secret` exists.
      - access_token_custom_audience: (no documentation yet)
      - logo_url: The logo URL of the Connected App, if any.
      - client_id_metadata_url: (no documentation yet)
    """  # noqa

    client_id: str
    client_name: str
    client_description: str
    status: str
    client_secret_last_four: str
    full_access_allowed: bool
    client_type: str
    redirect_urls: List[str]
    next_client_secret: str
    access_token_expiry_minutes: int
    access_token_template_content: str
    post_logout_redirect_urls: List[str]
    bypass_consent_for_offline_access: bool
    next_client_secret_last_four: Optional[str] = None
    access_token_custom_audience: Optional[str] = None
    logo_url: Optional[str] = None
    client_id_metadata_url: Optional[str] = None


class ResultsMetadata(pydantic.BaseModel):
    """
    Fields:
      - total: The total number of results returned by your search query. If totals have been disabled for your Stytch Workspace to improve search performance, the value will always be -1.
      - next_cursor: The `next_cursor` string is returned when your search result contains more than one page of results. This value is passed into your next search call in the `cursor` field.
    """  # noqa

    total: int
    next_cursor: Optional[str] = None
