# !!!
# WARNING: This file is autogenerated
# Only modify code within MANUAL() sections
# or your changes may be overwritten later!
# !!!

from __future__ import annotations

import datetime
from typing import Optional

import pydantic


class DeviceAttributeDetails(pydantic.BaseModel):
    """
    Fields:
      - is_new: Whether this `ip_geo_country` has been seen before for this user.
      - first_seen_at: When this `ip_geo_country` was first seen for this user. Values conform to the RFC 3339 standard and are expressed in UTC, e.g. `2021-12-29T12:33:09Z`.
      - last_seen_at: When this `ip_geo_country` was last seen for this user. Values conform to the RFC 3339 standard and are expressed in UTC, e.g. `2021-12-29T12:33:09Z`.
    """  # noqa

    is_new: bool
    first_seen_at: Optional[datetime.datetime] = None
    last_seen_at: Optional[datetime.datetime] = None


class DeviceInfo(pydantic.BaseModel):
    """
    Fields:
      - visitor_id: The `visitor_id` (a unique identifier) of the user's device. See the [Device Fingerprinting documentation](https://stytch.com/docs/fraud/guides/device-fingerprinting/fingerprints) for more details on the `visitor_id`.
      - visitor_id_details: Information about the `visitor_id`.
      - ip_address: The IP address of the user's device.
      - ip_address_details: Information about the `ip_address`.
      - ip_geo_city: The city where the IP address is located.
      - ip_geo_region: The region where the IP address is located.
      - ip_geo_country: The country code where the IP address is located.
      - ip_geo_country_details: Information about the `ip_geo_country`.
    """  # noqa

    visitor_id: str
    visitor_id_details: Optional[DeviceAttributeDetails] = None
    ip_address: Optional[str] = None
    ip_address_details: Optional[DeviceAttributeDetails] = None
    ip_geo_city: Optional[str] = None
    ip_geo_region: Optional[str] = None
    ip_geo_country: Optional[str] = None
    ip_geo_country_details: Optional[DeviceAttributeDetails] = None
