# !!!
# WARNING: This file is autogenerated
# Only modify code within MANUAL() sections
# or your changes may be overwritten later!
# !!!

from __future__ import annotations

import datetime
import enum
from typing import List, Optional

import pydantic


class RuleAction(str, enum.Enum):
    ALLOW = "ALLOW"
    CHALLENGE = "CHALLENGE"
    BLOCK = "BLOCK"
    NONE = "NONE"


class RuleType(str, enum.Enum):
    VISITOR_ID = "VISITOR_ID"
    BROWSER_ID = "BROWSER_ID"
    VISITOR_FINGERPRINT = "VISITOR_FINGERPRINT"
    BROWSER_FINGERPRINT = "BROWSER_FINGERPRINT"
    HARDWARE_FINGERPRINT = "HARDWARE_FINGERPRINT"
    NETWORK_FINGERPRINT = "NETWORK_FINGERPRINT"
    CIDR_BLOCK = "CIDR_BLOCK"
    ASN = "ASN"
    COUNTRY_CODE = "COUNTRY_CODE"


class VerdictAction(str, enum.Enum):
    ALLOW = "ALLOW"
    CHALLENGE = "CHALLENGE"
    BLOCK = "BLOCK"


class VerdictReasonActionAction(str, enum.Enum):
    ALLOW = "ALLOW"
    CHALLENGE = "CHALLENGE"
    BLOCK = "BLOCK"


class VerdictReasonOverrideAction(str, enum.Enum):
    ALLOW = "ALLOW"
    CHALLENGE = "CHALLENGE"
    BLOCK = "BLOCK"


class ASNProperties(pydantic.BaseModel):
    """
    Fields:
      - asn: The Autonomous System Number of the user's network.
      - name: Public name associated with the ASN.
      - network: The CIDR block associated with the ASN.
    """  # noqa

    asn: str
    name: str
    network: str


class BrowserProperties(pydantic.BaseModel):
    """
    Fields:
      - user_agent: The user agent of the user's browser.
    """  # noqa

    user_agent: str


class Fingerprints(pydantic.BaseModel):
    """
    Fields:
      - network_fingerprint: Combination of signals associated with a specific network commonly known as TLS fingerprinting.
      - hardware_fingerprint: Combinations of signals to identify an operating system and architecture.
      - browser_fingerprint: Combination of signals to identify a browser and its specific version.
      - visitor_fingerprint: Cookie-less way of identifying a unique user.
      - visitor_id: The cookie stored on the user's device that uniquely identifies them.
      - browser_id: Combination of VisitorID and NetworkFingerprint to create a clear identifier of a browser.
    """  # noqa

    network_fingerprint: str
    hardware_fingerprint: str
    browser_fingerprint: str
    visitor_fingerprint: str
    visitor_id: Optional[str] = None
    browser_id: Optional[str] = None


class IPGeoProperties(pydantic.BaseModel):
    """
    Fields:
      - city: The city where the IP is located.
      - region: The region where the IP is located.
      - country: The country where the IP is located.
    """  # noqa

    city: str
    region: str
    country: str


class Metadata(pydantic.BaseModel):
    """
    Fields:
      - external_id: An external ID, such as a user ID, that you wish to associate with the telemetry ID.
      - organization_id: The organization ID you wish to associate with the telemetry ID.
      - user_action: The user action, such as 'login', that you wish to associate with the telemetry ID.
    """  # noqa

    external_id: Optional[str] = None
    organization_id: Optional[str] = None
    user_action: Optional[str] = None


class NetworkProperties(pydantic.BaseModel):
    """
    Fields:
      - ip_address: The IP address of the client.
      - asn: Information about the network's ASN (Autonomous System Number).
      - ip_geolocation: Information about the geolocation of the user's IP address.
      - is_proxy: Whether the user is using a proxy.
      - is_vpn: Whether the user is using a VPN.
    """  # noqa

    ip_address: str
    asn: ASNProperties
    ip_geolocation: IPGeoProperties
    is_proxy: bool
    is_vpn: bool


class Properties(pydantic.BaseModel):
    """
    Fields:
      - network_properties: (no documentation yet)
      - browser_properties: (no documentation yet)
    """  # noqa

    network_properties: NetworkProperties
    browser_properties: BrowserProperties


class Rule(pydantic.BaseModel):
    """
    Fields:
      - rule_type: The rule type. The possible values are `VISITOR_ID`, `BROWSER_ID`, `VISITOR_FINGERPRINT`, `BROWSER_FINGERPRINT`, `HARDWARE_FINGERPRINT`, `NETWORK_FINGERPRINT`, `CIDR_BLOCK`, `ASN`, or `COUNTRY_CODE`.
      - action: The action (`ALLOW`, `BLOCK`, or `CHALLENGE`) that will be returned for this rule.
      - created_at: The time when the rule was created. Values conform to the RFC 3339 standard and are expressed in UTC, e.g. `2021-12-29T12:33:09Z`.
      - visitor_id: The visitor ID that a rule was set for.
      - browser_id: The browser ID that a rule was set for.
      - visitor_fingerprint: The visitor fingerprint that a rule was set for.
      - browser_fingerprint: The browser fingerprint that a rule was set for.
      - hardware_fingerprint: The hardware fingerprint that a rule was set for.
      - network_fingerprint: The network fingerprint that a rule was set for.
      - cidr_block: The CIDR block that a rule was set for. If an end user's IP address is within this CIDR block, this rule will be applied.
      - country_code: The country code that a rule was set for.
      - asn: The ASN that a rule was set for.
      - description: A description for the rule.
      - expires_at: The timestamp when the rule expires. Values conform to the RFC 3339 standard and are expressed in UTC, e.g. `2021-12-29T12:33:09Z`.
      - last_updated_at: The time when the rule was last updated. Will be null if the rule has never been updated. Values conform to the RFC 3339 standard and are expressed in UTC, e.g. `2021-12-29T12:33:09Z`.
    """  # noqa

    rule_type: RuleType
    action: RuleAction
    created_at: datetime.datetime
    visitor_id: Optional[str] = None
    browser_id: Optional[str] = None
    visitor_fingerprint: Optional[str] = None
    browser_fingerprint: Optional[str] = None
    hardware_fingerprint: Optional[str] = None
    network_fingerprint: Optional[str] = None
    cidr_block: Optional[str] = None
    country_code: Optional[str] = None
    asn: Optional[str] = None
    description: Optional[str] = None
    expires_at: Optional[datetime.datetime] = None
    last_updated_at: Optional[datetime.datetime] = None


class VerdictReasonAction(pydantic.BaseModel):
    """
    Fields:
      - verdict_reason: The verdict reason.
      - default_action: The default action returned for the specified verdict reason in a fingerprint lookup when no overrides are specified.
      - override_action: If not null, this action will be returned for the specified verdict reason in a fingerprint lookup, in place of the default action.
      - override_created_at: The time when the override was created, if one exists. Values conform to the RFC 3339 standard and are expressed in UTC, e.g. `2021-12-29T12:33:09Z`.
      - override_description: A description of the override, if one exists.
    """  # noqa

    verdict_reason: str
    default_action: VerdictReasonActionAction
    override_action: Optional[VerdictReasonActionAction] = None
    override_created_at: Optional[datetime.datetime] = None
    override_description: Optional[str] = None


class VerdictReasonOverride(pydantic.BaseModel):
    """
    Fields:
      - verdict_reason: The verdict reason that was overridden.
      - override_action: The action that was applied for the given verdict reason.
    """  # noqa

    verdict_reason: str
    override_action: VerdictReasonOverrideAction


class Verdict(pydantic.BaseModel):
    """
    Fields:
      - action: The suggested action based on the fingerprint review. The available actions are:
      * `ALLOW` - This is a known valid device grouping or device profile that is part of the default ALLOW listed set of known devices by Stytch. This grouping is made up of verified device profiles that match the characteristics of known/authentic traffic origins
      * `BLOCK` - This is a known bad or malicious device profile that is undesirable and should be blocked from completing the privileged action in question
      * `CHALLENGE` - This is an unknown or potentially malicious device that should be put through increased friction such as 2FA or other forms of extended user verification before allowing the privileged action to proceed

      - reasons: A set of contextual clues to inform why a `CHALLENGE` or `BLOCK` action was suggested. For a list of possible Reasons, see [Warning Flags (Verdict Reasons)](https://stytch.com/docs/docs/fraud/guides/device-fingerprinting/reference/warning-flags-verdict-reasons).
      - detected_device_type: The operating system and architecture that took the fingerprint.
      - is_authentic_device: The assessment of whether this is an authentic device. It will be false if hardware or browser deception is detected.
      - verdict_reason_overrides: A list of verdict reason overrides that were applied, if any.
      - rule_match_type: The type of rule match that was applied (e.g. `VISITOR_ID`), if any. This field will only be present if there is a `RULE_MATCH` reason in the list of verdict reasons.
      - rule_match_identifier: The rule that was applied (e.g. a specific visitor ID value), if any. This field will only be present if there is a `RULE_MATCH` reason in the list of verdict reasons.
    """  # noqa

    action: VerdictAction
    reasons: List[str]
    detected_device_type: str
    is_authentic_device: bool
    verdict_reason_overrides: List[VerdictReasonOverride]
    rule_match_type: Optional[RuleType] = None
    rule_match_identifier: Optional[str] = None
