# !!!
# WARNING: This file is autogenerated
# Only modify code within MANUAL() sections
# or your changes may be overwritten later!
# !!!

from __future__ import annotations

import datetime
from typing import List, Optional

from stytch.consumer.models.fraud import Rule, RuleAction
from stytch.core.response_base import ResponseBase


class ListResponse(ResponseBase):
    """Response type for `Rules.list`.
    Fields:
      - next_cursor: The `next_cursor` string is returned when your result contains more than one page of results. This value is passed into your next request in the `cursor` field.
      - rules: A list of rules for the project
    """  # noqa

    next_cursor: str
    rules: List[Rule]


class SetResponse(ResponseBase):
    """Response type for `Rules.set`.
    Fields:
      - action: The action that will be returned for the specified identifier.
      - visitor_id: The visitor ID that a rule was set for.
      - browser_id: The browser ID that a rule was set for.
      - visitor_fingerprint: The visitor fingerprint that a rule was set for.
      - browser_fingerprint: The browser fingerprint that a rule was set for.
      - hardware_fingerprint: The hardware fingerprint that a rule was set for.
      - network_fingerprint: The network fingerprint that a rule was set for.
      - expires_at: The timestamp when the rule expires. Values conform to the RFC 3339 standard and are expressed in UTC, e.g. `2021-12-29T12:33:09Z`.
      - cidr_block: The CIDR block that a rule was set for. If an end user's IP address is within this CIDR block, this rule will be applied.
      - country_code: The country code that a rule was set for.
      - asn: The ASN that a rule was set for.
    """  # noqa

    action: RuleAction
    visitor_id: Optional[str] = None
    browser_id: Optional[str] = None
    visitor_fingerprint: Optional[str] = None
    browser_fingerprint: Optional[str] = None
    hardware_fingerprint: Optional[str] = None
    network_fingerprint: Optional[str] = None
    expires_at: Optional[datetime.datetime] = None
    cidr_block: Optional[str] = None
    country_code: Optional[str] = None
    asn: Optional[str] = None
