# !!!
# WARNING: This file is autogenerated
# Only modify code within MANUAL() sections
# or your changes may be overwritten later!
# !!!

from __future__ import annotations

from typing import List, Optional

from stytch.consumer.models.connected_apps import ConnectedAppPublic
from stytch.consumer.models.idp import ScopeResult
from stytch.consumer.models.users import User
from stytch.core.response_base import ResponseBase


class AuthorizeResponse(ResponseBase):
    """Response type for `OAuth.authorize`.
    Fields:
      - redirect_uri: The callback URI used to redirect the user after authentication. This is the same URI provided at the start of the OAuth flow.  This field is required when using the `authorization_code` grant.
      - authorization_code: A one-time use code that can be exchanged for tokens.
    """  # noqa

    redirect_uri: str
    authorization_code: Optional[str] = None


class AuthorizeStartResponse(ResponseBase):
    """Response type for `OAuth.authorize_start`.
    Fields:
      - user_id: The unique ID of the affected User.
      - user: The `user` object affected by this API call. See the [Get user endpoint](https://stytch.com/docs/api/get-user) for complete response field details.
      - client: (no documentation yet)
      - consent_required: Whether the user must provide explicit consent for the authorization request.
      - scope_results: Details about each requested scope.
    """  # noqa

    user_id: str
    user: User
    client: ConnectedAppPublic
    consent_required: bool
    scope_results: List[ScopeResult]
