# !!!
# WARNING: This file is autogenerated
# Only modify code within MANUAL() sections
# or your changes may be overwritten later!
# !!!

from __future__ import annotations

import datetime
from typing import List, Optional

import pydantic

from stytch.consumer.models.device_history import DeviceInfo
from stytch.consumer.models.sessions import Session
from stytch.consumer.models.users import User
from stytch.core.response_base import ResponseBase


class ProviderValues(pydantic.BaseModel):
    """
    Fields:
      - access_token: The `access_token` that you may use to access the User's data in the provider's API.
      - refresh_token: The `refresh_token` that you may use to obtain a new `access_token` for the User within the provider's API.
      - id_token: The `id_token` returned by the OAuth provider. ID Tokens are JWTs that contain structured information about a user. The exact content of each ID Token varies from provider to provider. ID Tokens are returned from OAuth providers that conform to the [OpenID Connect](https://openid.net/foundation/) specification, which is based on OAuth.
      - scopes: The OAuth scopes included for a given provider. See each provider's section above to see which scopes are included by default and how to add custom scopes.
      - expires_at: The timestamp when the Session expires. Values conform to the RFC 3339 standard and are expressed in UTC, e.g. `2021-12-29T12:33:09Z`.
    """  # noqa

    access_token: str
    refresh_token: str
    id_token: str
    scopes: List[str]
    expires_at: Optional[datetime.datetime] = None


class AttachResponse(ResponseBase):
    """Response type for `OAuth.attach`.
    Fields:
      - oauth_attach_token: A single-use token for connecting the Stytch User selection from an OAuth Attach request to the corresponding OAuth Start request.
    """  # noqa

    oauth_attach_token: str


class AuthenticateResponse(ResponseBase):
    """Response type for `OAuth.authenticate`.
    Fields:
      - user_id: The unique ID of the affected User.
      - provider_subject: The unique identifier for the User within a given OAuth provider. Also commonly called the "sub" or "Subject field" in OAuth protocols.
      - provider_type: Denotes the OAuth identity provider that the user has authenticated with, e.g. Google, Facebook, GitHub etc.
      - session_token: A secret token for a given Stytch Session.
      - session_jwt: The JSON Web Token (JWT) for a given Stytch Session.
      - provider_values: The `provider_values` object lists relevant identifiers, values, and scopes for a given OAuth provider. For example this object will include a provider's `access_token` that you can use to access the provider's API for a given user.

      Note that these values will vary based on the OAuth provider in question, e.g. `id_token` is only returned by OIDC compliant identity providers.
      - user: The `user` object affected by this API call. See the [Get user endpoint](https://stytch.com/docs/api/get-user) for complete response field details.
      - reset_sessions: Indicates if all other of the User's Sessions need to be reset. You should check this field if you aren't using Stytch's Session product. If you are using Stytch's Session product, we revoke the User's other sessions for you.
      - oauth_user_registration_id: The unique ID for an OAuth registration.
      - user_session: A `Session` object. For backwards compatibility reasons, the session from an OAuth authenticate call is labeled as `user_session`, but is otherwise just a standard stytch `Session` object.

      See [Session object](https://stytch.com/docs/api/session-object) for complete response fields.

      - user_device: If a valid `telemetry_id` was passed in the request and the [Fingerprint Lookup API](https://stytch.com/docs/fraud/api/fingerprint-lookup) returned results, the `user_device` response field will contain information about the user's device attributes.
    """  # noqa

    user_id: str
    provider_subject: str
    provider_type: str
    session_token: str
    session_jwt: str
    provider_values: ProviderValues
    user: User
    reset_sessions: bool
    oauth_user_registration_id: str
    user_session: Optional[Session] = None
    user_device: Optional[DeviceInfo] = None
