# !!!
# WARNING: This file is autogenerated
# Only modify code within MANUAL() sections
# or your changes may be overwritten later!
# !!!

from __future__ import annotations

from typing import Optional

from stytch.consumer.models.device_history import DeviceInfo
from stytch.consumer.models.sessions import Session
from stytch.consumer.models.users import User
from stytch.core.response_base import ResponseBase


class AuthenticateResponse(ResponseBase):
    """Response type for `OTPs.authenticate`.
    Fields:
      - user_id: The unique ID of the affected User.
      - method_id: The `email_id` or `phone_id` involved in the given authentication.
      - session_token: A secret token for a given Stytch Session.
      - session_jwt: The JSON Web Token (JWT) for a given Stytch Session.
      - user: The `user` object affected by this API call. See the [Get user endpoint](https://stytch.com/docs/api/get-user) for complete response field details.
      - reset_sessions: Indicates if all other of the User's Sessions need to be reset. You should check this field if you aren't using Stytch's Session product. If you are using Stytch's Session product, we revoke the User's other sessions for you.
      - session: If you initiate a Session, by including `session_duration_minutes` in your authenticate call, you'll receive a full Session object in the response.

      See [Session object](https://stytch.com/docs/api/session-object) for complete response fields.

      - user_device: If a valid `telemetry_id` was passed in the request and the [Fingerprint Lookup API](https://stytch.com/docs/fraud/api/fingerprint-lookup) returned results, the `user_device` response field will contain information about the user's device attributes.
    """  # noqa

    user_id: str
    method_id: str
    session_token: str
    session_jwt: str
    user: User
    reset_sessions: bool
    session: Optional[Session] = None
    user_device: Optional[DeviceInfo] = None
