# !!!
# WARNING: This file is autogenerated
# Only modify code within MANUAL() sections
# or your changes may be overwritten later!
# !!!

from __future__ import annotations

import enum
from typing import List, Optional

import pydantic

from stytch.consumer.models.device_history import DeviceInfo
from stytch.consumer.models.sessions import Session
from stytch.consumer.models.users import User
from stytch.core.response_base import ResponseBase


class MigrateRequestHashType(str, enum.Enum):
    BCRYPT = "bcrypt"
    MD_5 = "md_5"
    ARGON_2I = "argon_2i"
    ARGON_2ID = "argon_2id"
    SHA_1 = "sha_1"
    SHA_512 = "sha_512"
    SCRYPT = "scrypt"
    PHPASS = "phpass"
    PBKDF_2 = "pbkdf_2"


class Argon2Config(pydantic.BaseModel):
    """
    Fields:
      - salt: The salt value.
      - iteration_amount: The iteration amount.
      - memory: The memory in kibibytes.
      - threads: The thread value, also known as the parallelism factor.
      - key_length: The key length, also known as the hash length.
    """  # noqa

    salt: str
    iteration_amount: int
    memory: int
    threads: int
    key_length: int


class LUDSRequirements(pydantic.BaseModel):
    """
    Fields:
      - has_lower_case: For LUDS validation, whether the password contains at least one lowercase letter.
      - has_upper_case: For LUDS validation, whether the password contains at least one uppercase letter.
      - has_digit: For LUDS validation, whether the password contains at least one digit.
      - has_symbol: For LUDS validation, whether the password contains at least one symbol. Any UTF8 character outside of a-z or A-Z may count as a valid symbol.
      - missing_complexity: For LUDS validation, the number of complexity requirements that are missing from the password. Check the complexity fields to see which requirements are missing.
      - missing_characters: For LUDS validation, this is the required length of the password that you've set minus the length of the password being checked. The user will need to add this many characters to the password to make it valid.
    """  # noqa

    has_lower_case: bool
    has_upper_case: bool
    has_digit: bool
    has_symbol: bool
    missing_complexity: int
    missing_characters: int


class Feedback(pydantic.BaseModel):
    """
    Fields:
      - warning: For `zxcvbn` validation, contains an end user consumable warning if the password is valid but not strong enough.
      - suggestions: For `zxcvbn` validation, contains end user consumable suggestions on how to improve the strength of the password.
      - luds_requirements: Contains which LUDS properties are fulfilled by the password and which are missing to convert an invalid password into a valid one. You'll use these fields to provide feedback to the user on how to improve the password.
    """  # noqa

    warning: str
    suggestions: List[str]
    luds_requirements: Optional[LUDSRequirements] = None


class MD5Config(pydantic.BaseModel):
    """
    Fields:
      - prepend_salt: The salt that should be prepended to the migrated password.
      - append_salt: The salt that should be appended to the migrated password.
    """  # noqa

    prepend_salt: str
    append_salt: str


class PBKDF2Config(pydantic.BaseModel):
    """
    Fields:
      - salt: The salt value, which should be in a base64 encoded string form.
      - iteration_amount: The iteration amount.
      - key_length: The key length, also known as the hash length.
      - algorithm: The algorithm that was used to generate the HMAC hash. Accepted values are "sha512" and sha256". Defaults to sha256.
    """  # noqa

    salt: str
    iteration_amount: int
    key_length: int
    algorithm: str


class SHA1Config(pydantic.BaseModel):
    """
    Fields:
      - prepend_salt: The salt that should be prepended to the migrated password.
      - append_salt: The salt that should be appended to the migrated password.
    """  # noqa

    prepend_salt: str
    append_salt: str


class SHA512Config(pydantic.BaseModel):
    """
    Fields:
      - prepend_salt: The salt that should be prepended to the migrated password.
      - append_salt: The salt that should be appended to the migrated password.
    """  # noqa

    prepend_salt: str
    append_salt: str


class ScryptConfig(pydantic.BaseModel):
    """
    Fields:
      - salt: The salt value, which should be in a base64 encoded string form.
      - n_parameter: The N value, also known as the iterations count. It must be a power of two greater than 1 and less than 262,145.
          If your application's N parameter is larger than 262,144, please reach out to [support@stytch.com](mailto:support@stytch.com)
      - r_parameter: The r parameter, also known as the block size.
      - p_parameter: The p parameter, also known as the parallelism factor.
      - key_length: The key length, also known as the hash length.
    """  # noqa

    salt: str
    n_parameter: int
    r_parameter: int
    p_parameter: int
    key_length: int


class AuthenticateResponse(ResponseBase):
    """Response type for `Passwords.authenticate`.
    Fields:
      - user_id: The unique ID of the affected User.
      - session_token: A secret token for a given Stytch Session.
      - session_jwt: The JSON Web Token (JWT) for a given Stytch Session.
      - user: The `user` object affected by this API call. See the [Get user endpoint](https://stytch.com/docs/api/get-user) for complete response field details.
      - session: If you initiate a Session, by including `session_duration_minutes` in your authenticate call, you'll receive a full Session object in the response.

      See [Session object](https://stytch.com/docs/api/session-object) for complete response fields.

      - user_device: If a valid `telemetry_id` was passed in the request and the [Fingerprint Lookup API](https://stytch.com/docs/fraud/api/fingerprint-lookup) returned results, the `user_device` response field will contain information about the user's device attributes.
    """  # noqa

    user_id: str
    session_token: str
    session_jwt: str
    user: User
    session: Optional[Session] = None
    user_device: Optional[DeviceInfo] = None


class CreateResponse(ResponseBase):
    """Response type for `Passwords.create`.
    Fields:
      - user_id: The unique ID of the affected User.
      - email_id: The unique ID of a specific email address.
      - session_token: A secret token for a given Stytch Session.
      - session_jwt: The JSON Web Token (JWT) for a given Stytch Session.
      - user: The `user` object affected by this API call. See the [Get user endpoint](https://stytch.com/docs/api/get-user) for complete response field details.
      - session: If you initiate a Session, by including `session_duration_minutes` in your authenticate call, you'll receive a full Session object in the response.

      See [Session object](https://stytch.com/docs/api/session-object) for complete response fields.

      - user_device: If a valid `telemetry_id` was passed in the request and the [Fingerprint Lookup API](https://stytch.com/docs/fraud/api/fingerprint-lookup) returned results, the `user_device` response field will contain information about the user's device attributes.
    """  # noqa

    user_id: str
    email_id: str
    session_token: str
    session_jwt: str
    user: User
    session: Optional[Session] = None
    user_device: Optional[DeviceInfo] = None


class MigrateResponse(ResponseBase):
    """Response type for `Passwords.migrate`.
    Fields:
      - user_id: The unique ID of the affected User.
      - email_id: The unique ID of a specific email address.
      - user_created: In `login_or_create` endpoints, this field indicates whether or not a User was just created.
      - user: The `user` object affected by this API call. See the [Get user endpoint](https://stytch.com/docs/api/get-user) for complete response field details.
    """  # noqa

    user_id: str
    email_id: str
    user_created: bool
    user: User


class StrengthCheckResponse(ResponseBase):
    """Response type for `Passwords.strength_check`.
    Fields:
      - valid_password: Returns `true` if the password passes our password validation. We offer two validation options, [zxcvbn](https://stytch.com/docs/guides/passwords/strength-policy) is the default option which offers a high level of sophistication. We also offer [LUDS](https://stytch.com/docs/guides/passwords/strength-policy). If an email address is included in the call we also require that the password hasn't been compromised using built-in breach detection powered by [HaveIBeenPwned](https://haveibeenpwned.com/).
      - score: The score of the password determined by [zxcvbn](https://github.com/dropbox/zxcvbn). Values will be between 1 and 4, a 3 or greater is required to pass validation.
      - breached_password: Returns `true` if the password has been breached. Powered by [HaveIBeenPwned](https://haveibeenpwned.com/).
      - strength_policy: The strength policy type enforced, either `zxcvbn` or `luds`.
      - breach_detection_on_create: Will return `true` if breach detection will be evaluated. By default this option is enabled. This option can be disabled by contacting [support@stytch.com](mailto:support@stytch.com?subject=Password%20strength%20configuration). If this value is `false` then `breached_password` will always be `false` as well.
      - feedback: Feedback for how to improve the password's strength [HaveIBeenPwned](https://haveibeenpwned.com/).
    """  # noqa

    valid_password: bool
    score: int
    breached_password: bool
    strength_policy: str
    breach_detection_on_create: bool
    feedback: Optional[Feedback] = None
