# !!!
# WARNING: This file is autogenerated
# Only modify code within MANUAL() sections
# or your changes may be overwritten later!
# !!!

from __future__ import annotations

from typing import List, Optional

import pydantic

from stytch.consumer.models.device_history import DeviceInfo
from stytch.consumer.models.sessions import Session
from stytch.consumer.models.users import User
from stytch.core.response_base import ResponseBase


class TOTP(pydantic.BaseModel):
    """
    Fields:
      - totp_id: The unique ID for a TOTP instance.
      - verified: The verified boolean denotes whether or not this send method, e.g. phone number, email address, etc., has been successfully authenticated by the User.
      - recovery_codes: The recovery codes used to authenticate the user without an authenticator app.
    """  # noqa

    totp_id: str
    verified: bool
    recovery_codes: List[str]


class AuthenticateResponse(ResponseBase):
    """Response type for `TOTPs.authenticate`.
    Fields:
      - user_id: The unique ID of the affected User.
      - session_token: A secret token for a given Stytch Session.
      - totp_id: The unique ID for a TOTP instance.
      - session_jwt: The JSON Web Token (JWT) for a given Stytch Session.
      - user: The `user` object affected by this API call. See the [Get user endpoint](https://stytch.com/docs/api/get-user) for complete response field details.
      - session: If you initiate a Session, by including `session_duration_minutes` in your authenticate call, you'll receive a full Session object in the response.

      See [Session object](https://stytch.com/docs/api/session-object) for complete response fields.

      - user_device: If a valid `telemetry_id` was passed in the request and the [Fingerprint Lookup API](https://stytch.com/docs/fraud/api/fingerprint-lookup) returned results, the `user_device` response field will contain information about the user's device attributes.
    """  # noqa

    user_id: str
    session_token: str
    totp_id: str
    session_jwt: str
    user: User
    session: Optional[Session] = None
    user_device: Optional[DeviceInfo] = None


class CreateResponse(ResponseBase):
    """Response type for `TOTPs.create`.
    Fields:
      - totp_id: The unique ID for a TOTP instance.
      - secret: The TOTP secret key shared between the authenticator app and the server used to generate TOTP codes.
      - qr_code: The QR code image encoded in base64.
      - recovery_codes: The recovery codes used to authenticate the user without an authenticator app.
      - user: The `user` object affected by this API call. See the [Get user endpoint](https://stytch.com/docs/api/get-user) for complete response field details.
      - user_id: The unique ID of the affected User.
    """  # noqa

    totp_id: str
    secret: str
    qr_code: str
    recovery_codes: List[str]
    user: User
    user_id: str


class RecoverResponse(ResponseBase):
    """Response type for `TOTPs.recover`.
    Fields:
      - totp_id: The unique ID for a TOTP instance.
      - user_id: The unique ID of the affected User.
      - session_token: A secret token for a given Stytch Session.
      - session_jwt: The JSON Web Token (JWT) for a given Stytch Session.
      - user: The `user` object affected by this API call. See the [Get user endpoint](https://stytch.com/docs/api/get-user) for complete response field details.
      - session: If you initiate a Session, by including `session_duration_minutes` in your authenticate call, you'll receive a full Session object in the response.

      See [Session object](https://stytch.com/docs/api/session-object) for complete response fields.

      - user_device: If a valid `telemetry_id` was passed in the request and the [Fingerprint Lookup API](https://stytch.com/docs/fraud/api/fingerprint-lookup) returned results, the `user_device` response field will contain information about the user's device attributes.
    """  # noqa

    totp_id: str
    user_id: str
    session_token: str
    session_jwt: str
    user: User
    session: Optional[Session] = None
    user_device: Optional[DeviceInfo] = None


class RecoveryCodesResponse(ResponseBase):
    """Response type for `TOTPs.recovery_codes`.
    Fields:
      - user_id: The unique ID of the affected User.
      - totps: An array containing a list of all TOTP instances (along with their recovery codes) for a given User in the Stytch API.
    """  # noqa

    user_id: str
    totps: List[TOTP]
