# !!!
# WARNING: This file is autogenerated
# Only modify code within MANUAL() sections
# or your changes may be overwritten later!
# !!!

from __future__ import annotations

from typing import List, Optional

import pydantic

from stytch.consumer.models.device_history import DeviceInfo
from stytch.consumer.models.sessions import Session
from stytch.consumer.models.users import User, WebAuthnRegistration
from stytch.core.response_base import ResponseBase


class WebAuthnCredential(pydantic.BaseModel):
    """
    Fields:
      - credential_id: The unique, public ID of the WebAuthn credential.
      - webauthn_registration_id: The unique ID for the Passkey or WebAuthn registration.
      - type: The type of the WebAuthn credential. Examples include `public-key`.
      - public_key: The public key for the WebAuthn credential in base64 format.
    """  # noqa

    credential_id: str
    webauthn_registration_id: str
    type: str
    public_key: str


class AuthenticateResponse(ResponseBase):
    """Response type for `WebAuthn.authenticate`.
    Fields:
      - user_id: The unique ID of the affected User.
      - webauthn_registration_id: The unique ID for the Passkey or WebAuthn registration.
      - session_token: A secret token for a given Stytch Session.
      - session_jwt: The JSON Web Token (JWT) for a given Stytch Session.
      - user: The `user` object affected by this API call. See the [Get user endpoint](https://stytch.com/docs/api/get-user) for complete response field details.
      - session: If you initiate a Session, by including `session_duration_minutes` in your authenticate call, you'll receive a full Session object in the response.

      See [Session object](https://stytch.com/docs/api/session-object) for complete response fields.

      - user_device: If a valid `telemetry_id` was passed in the request and the [Fingerprint Lookup API](https://stytch.com/docs/fraud/api/fingerprint-lookup) returned results, the `user_device` response field will contain information about the user's device attributes.
    """  # noqa

    user_id: str
    webauthn_registration_id: str
    session_token: str
    session_jwt: str
    user: User
    session: Optional[Session] = None
    user_device: Optional[DeviceInfo] = None


class AuthenticateStartResponse(ResponseBase):
    """Response type for `WebAuthn.authenticate_start`.
    Fields:
      - user_id: The unique ID of the affected User.
      - public_key_credential_request_options: Options used for Passkey or WebAuthn authentication.
    """  # noqa

    user_id: str
    public_key_credential_request_options: str


class ListCredentialsResponse(ResponseBase):
    """Response type for `WebAuthn.list_credentials`.
    Fields:
      - credentials: A list of WebAuthn credential objects.
    """  # noqa

    credentials: List[WebAuthnCredential]


class RegisterResponse(ResponseBase):
    """Response type for `WebAuthn.register`.
    Fields:
      - user_id: The unique ID of the affected User.
      - webauthn_registration_id: The unique ID for the Passkey or WebAuthn registration.
      - session_token: A secret token for a given Stytch Session.
      - session_jwt: The JSON Web Token (JWT) for a given Stytch Session.
      - user: (no documentation yet)
      - session: If you initiate a Session, by including `session_duration_minutes` in your authenticate call, you'll receive a full Session object in the response.

      See [Session object](https://stytch.com/docs/api/session-object) for complete response fields.

      - user_device: If a valid `telemetry_id` was passed in the request and the [Fingerprint Lookup API](https://stytch.com/docs/fraud/api/fingerprint-lookup) returned results, the `user_device` response field will contain information about the user's device attributes.
    """  # noqa

    user_id: str
    webauthn_registration_id: str
    session_token: str
    session_jwt: str
    user: User
    session: Optional[Session] = None
    user_device: Optional[DeviceInfo] = None


class RegisterStartResponse(ResponseBase):
    """Response type for `WebAuthn.register_start`.
    Fields:
      - user_id: The unique ID of the affected User.
      - public_key_credential_creation_options: Options used for Passkey or WebAuthn registration.
    """  # noqa

    user_id: str
    public_key_credential_creation_options: str


class UpdateResponse(ResponseBase):
    """Response type for `WebAuthn.update`.
    Fields:
      - webauthn_registration: A Passkey or WebAuthn registration.
    """  # noqa

    webauthn_registration: Optional[WebAuthnRegistration] = None
