# 更新日志 (Changelog)

## [v2.5.10.2] - 2025-01-15

### 📸 示例图片修复 (Example Images Fix)
- **修复README.md示例图片链接**：更正了示例图片的链接地址，确保图片能正常显示
- **使用正确的链接格式**：采用i.postimg.cc的正确链接格式，提升图片加载稳定性

## [v2.5.10.1] - 2025-01-15

### 📸 示例图片更新 (Example Images Update)
- **更新README.md示例图片**：更新了示例图片的链接地址，优化了图片显示效果
- **改进视觉展示**：使用更清晰的图片链接，提升用户浏览体验

## [v2.5.10] - 2025-01-15

### 📚 文档重大更新 (Documentation Major Update)
- **推荐安装方式调整**：将开发模式安装提升为推荐方式，确保用户获得最佳稳定性
- **完善三大核心文档**：
  - **README.md**：重新排序安装方式，优先展示开发模式配置
  - **安装与配置指南.md**：重新组织目录结构，详细对比各种安装方式优劣
  - **功能说明.md**：更新快速开始部分，同步最新配置示例
- **配置示例标准化**：统一所有文档中的开发模式配置格式
- **优势说明增强**：详细解释开发模式的稳定性优势和PyPI安装可能遇到的问题

### 🎨 UI视觉增强 (UI Visual Enhancements)
- **重大改进：选项控件选中状态视觉效果**：完全重新设计单选按钮和复选框的选中状态显示
- **主题协调的选中颜色**：
  - **深色主题**：选中状态使用协调的灰色背景 (#555555)，与深色界面完美融合
  - **浅色主题**：选中状态使用深灰色背景 (#6B6B6B)，提供良好的对比度
- **增强的悬停效果**：改进鼠标悬停时的视觉反馈，使用稍亮的灰色调
- **改进的边框设计**：将边框宽度从1px增加到2px，提供更清晰的边界定义
- **完善的禁用状态**：为禁用控件提供专门的灰色样式，确保可访问性

### 🔧 技术改进 (Technical Improvements)
- **增强的样式系统**：创建新的 `apply_enhanced_control_styling` 函数，统一管理所有控件样式
- **主题感知优化**：改进 `apply_theme_aware_styling` 函数，支持更复杂的样式配置
- **设置对话框样式应用**：为所有设置对话框（主设置、音频设置、优化设置）添加自动样式应用
- **SVG图标增强**：为复选框勾选标记添加描边效果，提高在不同背景下的可见性

## [v2.5.9.13] - 2025-01-15

### 🚀 重大修复 (Major Fixes)
- **修复uv安装用户预定义选项问题**：默认启用自定义选项功能，解决uv安装用户看不到预定义选项的问题
- **改进音频文件兼容性**：优化音频文件在uv安装环境下的路径解析和资源加载
- **完善配置文件位置说明**：明确不同安装方式下配置文件的存储位置

### 🔧 技术改进 (Technical Improvements)
- **配置管理优化**：将 `enable_custom_options` 默认值改为 `true`
- **音频资源加载增强**：改进 `importlib.resources` 的使用，增加临时文件回退机制
- **设置界面改进**：在音频设置页面显示默认音频文件状态
- **文档完善**：添加uv安装用户常见问题解决方案

### 📋 配置变更 (Configuration Changes)
- **默认配置更新**：`enable_custom_options` 从 `false` 改为 `true`
- **配置模板更新**：同步更新 `config.template.json`
- **版本说明**：在配置模板中添加版本变更说明

### 🐛 问题解决 (Bug Fixes)
- 修复uv安装用户只能看到通用AI选项（"继续"、"取消"等）的问题
- 修复音频设置页面显示空白自定义音频路径的问题
- 修复默认音频文件在uv安装环境下无法正确加载的问题

## [v2.5.9.11] - 2025-01-14

### 🔧 强力修复 (Powerful Fix)
- **内联代码样式终极解决方案**：采用增强的内联样式完全绕过CSS优先级问题
- **HTML处理优化**：修复了双分号问题，确保样式语法正确
- **CSS规则简化**：移除了复杂的属性选择器，专注于class选择器
- **内联样式增强**：直接在HTML中嵌入完整的代码样式，包括：
  - 蓝色文字颜色 (#4A90E2)
  - 灰色背景高亮
  - 等宽字体设置
  - 圆角边框和内边距

### 🎯 彻底解决 (Complete Resolution)
- **uv环境兼容性**：确保在所有安装环境中内联代码都正确显示
- **样式独立性**：不再依赖外部CSS规则，使用自包含的内联样式
- **视觉一致性**：所有代码文字（文件名、方法名、选择器等）统一显示效果

### 📋 技术改进 (Technical)
- 修复了样式字符串处理中的双分号问题
- 简化了CSS选择器，提高兼容性
- 增强了HTML处理的健壮性

## [v2.5.9.10] - 2025-01-14

### 🔧 关键修复 (Critical Fix)
- **内联代码样式优先级问题修复**：彻底解决了uv安装环境中内联代码文字无法正确显示蓝色的问题
- **CSS选择器特异性增强**：增加了多种引号格式的支持，确保CSS规则能够覆盖QTextDocument生成的内联样式
  - 新增支持：`font-family:'Courier New'` 和 `font-family:"Courier New"`
  - 使用 `!important` 确保代码颜色优先级最高
- **HTML处理逻辑改进**：强制移除冲突的颜色样式，确保代码文字始终显示为蓝色
  - 改进了正则表达式以处理更多HTML格式变体
  - 增强了颜色样式的替换逻辑

### 🎯 问题解决 (Issue Resolution)
- **内联代码显示**：文件名、类名、方法名等内联代码现在在所有环境中都正确显示蓝色
- **环境一致性**：确保uv安装用户和源代码用户获得完全相同的内联代码显示效果
- **样式稳定性**：消除了CSS优先级冲突，提高了样式应用的可靠性

### 📋 技术改进 (Technical)
- 增强了正则表达式的兼容性，支持更多HTML格式
- 优化了样式处理流程，减少了样式冲突的可能性
- 提高了代码样式渲染的稳定性和一致性

## [v2.5.9.9] - 2025-01-14

### 🎨 重要样式修复 (Critical Style Fix)
- **代码样式回退问题修复**：彻底解决了uv安装用户GUI窗口中代码文本样式回退的问题
- **样式冲突消除**：移除了dark_theme.qss中重复且冲突的代码样式定义
  - 删除了导致代码文本颜色回退到默认样式的重复定义
  - 确保代码文本始终显示为预期的蓝色 (#4A90E2)
- **QTextEdit代码样式支持**：新增对QTextEdit组件的代码样式支持
  - 内联代码和代码块在所有UI组件中统一显示蓝色
  - 深色和浅色主题都完全支持

### 🔧 代码质量优化 (Code Quality)
- **消除冗余代码**：移除了约15行重复的CSS样式定义
- **优化样式结构**：合并了相似样式规则，提高加载效率
- **增强维护性**：统一了样式管理，便于后续维护

### 🎯 用户体验改进 (UX Improvements)
- **统一显示效果**：确保uv安装用户和本地开发用户获得完全一致的代码样式
- **稳定性提升**：消除了样式冲突，提高了显示一致性
- **兼容性保证**：所有现有功能和样式保持不变

## [v2.5.9.8] - 2025-01-14

### 🔧 重要修复 (Critical Fix)
- **uv环境Markdown渲染问题修复**：解决了uv安装用户GUI窗口显示模式异常的问题
- **多重导入策略**：实现了text_formatter模块的多重导入策略，确保在不同环境中都能正确导入
  - 策略1：相对导入（开发环境）
  - 策略2：绝对导入（uv安装环境）
  - 策略3：动态导入（兼容性回退）
- **改进的回退检测**：优化了Markdown检测的回退逻辑，大幅减少误判
  - 更严格的检测条件，避免普通AI回复被误识别为Markdown
  - 成对标记验证，确保格式标记的完整性
  - 行首标记检测，提高检测准确性

### 🎯 用户体验改进 (UX Improvements)
- **统一体验**：确保uv安装用户和源代码用户获得完全一致的显示效果
- **稳定性增强**：添加了全面的异常处理，确保在任何情况下都能正常显示文本
- **调试支持**：添加了调试模式，便于问题诊断和排查

### 🔧 技术改进 (Technical)
- 增强了错误处理机制，确保Markdown转换失败时能优雅回退
- 优化了导入逻辑，提高了模块加载的成功率
- 添加了详细的调试信息，便于开发和维护

## [v2.5.9.7] - 2025-01-13

### ✨ 新功能 (Features)
- **Markdown渲染**：GUI窗口现在支持自动检测和渲染Markdown格式文本
- **智能文本显示**：自动识别Markdown内容并正确渲染，隐藏语法符号
- **主题兼容**：Markdown渲染完美兼容现有的深色/浅色主题系统

### 🎨 界面优化 (UI/UX)
- **文本格式化**：标题、粗体、斜体、代码块等Markdown元素正确显示
- **视觉层次**：通过字体大小和样式区分文本层次，而非颜色
- **阅读体验**：消除原始Markdown语法符号的干扰，提升专业感

### 🔧 技术改进 (Technical)
- 使用PySide6原生QTextDocument.setMarkdown()方法
- 保持向后兼容，普通文本正常显示
- 最小化代码改动，不影响现有功能

## [v2.5.9.6] - 2025-01-13

### 🔧 修复 (Fixed)
- **依赖兼容性**：移除playsound依赖，解决Windows环境下构建失败问题
- **音频播放**：使用原生音频播放方案替代playsound，提升跨平台兼容性
  - Windows: 使用winsound和PowerShell
  - macOS: 使用afplay
  - Linux: 使用系统原生音频播放器和系统提示音

### 📚 文档 (Documentation)
- 更新安装指南，添加playsound构建失败的故障排除说明
- 更新版本信息到v2.5.9.6

### ⚡ 性能优化 (Performance)
- 减少包体积，移除不必要的可选依赖
- 提升音频播放稳定性和响应速度

## [v2.5.9.3] - 2025-01-12

### ✨ 新增功能
#### 提交方式设置功能
- **功能描述**：在设置页面新增提交方式选择选项，支持两种提交模式
- **提交模式**：
  - Enter键直接提交：按Enter键直接提交反馈
  - Ctrl+Enter组合键提交：按Ctrl+Enter（Windows/Linux）或Cmd+Enter（macOS）提交反馈
- **跨平台兼容**：
  - Windows/Linux系统：显示"Ctrl+Enter组合键提交"
  - macOS系统：显示"⌘+Enter组合键提交"
  - 自动检测操作系统并显示相应的快捷键说明
- **用户体验**：
  - 设置变更立即生效，无需重启应用
  - 动态更新输入框占位符文本，显示当前提交方式的快捷键提示
  - 完整的中英文双语支持

### 🔧 技术改进
#### 代码结构优化
- **新增模块**：创建 `platform_utils.py` 工具模块，提供跨平台兼容性支持
- **性能优化**：
  - 消除重复的模块导入逻辑
  - 缓存配置获取函数，减少重复调用开销
  - 移除未使用的冗余代码和函数
- **配置管理**：
  - 在默认配置中添加 `submit_method` 字段
  - 增强配置验证，确保提交方式设置的有效性
  - 支持配置的持久化保存和加载

### 📋 界面优化
#### 设置窗口布局改进
- **窗口尺寸**：设置窗口高度从650px增加到700px，为新功能提供充足空间
- **布局优化**：
  - 提交方式选项位于"精简模式"/"完整模式"下方，"启用自定义选择"上方
  - 优化语言选择区域布局，避免文字被挤压
  - 改用水平布局替代网格布局，提供更好的视觉效果
- **响应式设计**：确保在不同分辨率下都有良好的显示效果

### 🌐 国际化支持
#### 多语言适配
- **文本本地化**：所有新增的界面文本都支持中英文双语
- **平台适配**：根据操作系统自动显示对应的快捷键文本
- **动态更新**：语言切换时同步更新所有相关文本

---

## [v2.5.9.1] - 2025-01-12

### 🔧 重要修复
#### uvx环境配置文件路径问题修复
- **问题描述**：修复了uvx运行环境下配置文件路径错误的问题
- **解决方案**：
  - 智能检测uvx运行环境，自动使用用户主目录配置路径
  - 优化配置文件路径计算逻辑，避免在临时缓存目录中查找配置
  - 自动创建默认配置文件，提升首次使用体验
  - 改进错误消息，明确显示运行环境和配置文件路径
- **技术改进**：
  - 检测uvx环境特征（路径包含"uv"和"cache"或"archive"）
  - 在uvx环境中直接使用 `~/.interactive-feedback/config.json`
  - 首次运行时自动创建默认配置文件
- **用户体验**：解决了uvx用户看到配置文件路径错误的困扰

---

## [v2.5.9] - 2025-01-12

### 🎨 提示文字显示效果优化
- **工具提示优化**：创建专门的工具提示格式化工具类，支持长文本自动换行
- **样式统一**：在明暗主题中设置统一的字体、边距、圆角边框和阴影效果
- **动态提示**：优化工具提示显示延迟，添加加载状态动态提示
- **占位符优化**：根据用户配置和语言动态更新占位符文本，支持跨平台
- **文本渲染**：启用抗锯齿、字母间距和单词间距调整，提升可读性
- **语法高亮**：为文件引用添加蓝色高亮显示
- **反馈消息**：优化成功状态显示和加载状态提示，智能自动隐藏
- **格式化工具**：创建Markdown格式处理工具，支持撤销的文本替换

---

## [v2.5.8.3] - 2025-01-12

### 🔧 重要修复
#### MCP服务连续调用问题修复
- **问题描述**：修复了MCP服务连续调用两次的问题，原因是严格的参数验证逻辑导致第一次调用失败
- **解决方案**：实现智能回退机制，当主要参数为空时自动使用备用参数
- **技术改进**：
  - 完整模式：优先使用 `full_response`，如果为空则回退到 `message`
  - 精简模式：优先使用 `message`，如果为空则回退到 `full_response`
  - 只有当两个参数都为空时才返回错误
  - 保持实时模式检测，支持动态切换
- **代码优化**：
  - 提取公共参数验证函数，减少重复代码
  - 使用元组解包简化参数优先级逻辑
  - 更新工具文档，添加智能回退说明
- **用户体验**：避免了不必要的错误提示，提升了工具的稳定性和可靠性

---

## [当前版本] - 项目现状

### 🎯 项目概述
interactive-feedback-mcp 是一个专业的AI助手交互式反馈工具，提供图形化界面用于AI助手与用户之间的高效沟通。

### 🌟 核心功能
- **交互式反馈窗口**：支持文本输入、预定义选项选择、快捷键操作
- **多媒体处理**：图片粘贴/拖拽、文件引用、窗口截图功能
- **常用语管理**：预设管理、hover预览、快速插入
- **原生终端集成**：支持PowerShell、Git Bash、Command Prompt
- **文本优化功能**：多AI提供商支持、一键优化、自定义增强
- **界面布局**：垂直/水平布局、可拖拽分割器、主题切换
- **显示模式**：简单模式/完整模式、实时切换
- **音频提示**：窗口弹出提示音、自定义音频支持

### 🏗️ 技术架构
- **基于PySide6**：现代化的Qt图形界面框架
- **MCP协议**：标准的模型上下文协议集成
- **模块化设计**：清晰的代码结构和组件分离
- **主题系统**：统一的颜色管理和样式应用
- **配置管理**：灵活的配置文件和UI设置

### 📚 文档体系
- **README.md**：项目简介和使用技巧
- **功能说明.md**：详细的功能描述和操作指南
- **安装与配置指南.md**：完整的安装配置说明
- **CHANGELOG.md**：项目发展历程记录

---

## [主要版本历程]

### v4.x - 界面优化与文档重构期
#### UI界面稳定性提升
- 解决了UI窗口布局闪烁问题，优化初始化流程
- 实现主题一致性，所有UI元素统一使用主题感知颜色系统
- 调整按钮布局逻辑，提升用户操作体验
- 移除不协调的hover效果，保持视觉一致性

#### 代码质量改进
- 清理约50行冗余代码，统一配置读取和样式应用逻辑
- 优化初始化流程，减少定时器冲突，提升UI响应性
- 改进窗口显示和样式更新时序，提供更稳定的用户体验

#### 文档体系重构
- 重构README.md，突出使用技巧，更新AI助手工作流规则
- 精简功能说明.md，移除时间性描述，突出核心功能
- 优化安装与配置指南.md，移除重复内容，保持文档简洁

### v3.x - 功能扩展与体验优化期
#### 文本优化功能
- 集成多AI提供商支持（OpenAI、Gemini、DeepSeek、火山引擎）
- 实现一键优化和自定义增强功能
- 添加API密钥管理和加载动画
- 支持撤销功能和自动光标定位

#### 多媒体功能增强
- 添加窗口截图功能，支持矩形选择和智能窗口管理
- 实现音频提示功能，支持自定义音频文件
- 优化图片处理流程，提供更好的预览和管理体验

#### 界面布局系统
- 实现垂直/水平双布局模式
- 添加可拖拽分割器，支持双击重置
- 实现显示模式配置（简单模式/完整模式）
- 优化设置页面，统一UI风格

### v2.x - 核心功能完善期
#### 文件处理系统
- 实现文件拖拽功能，支持蓝色文件引用显示
- 添加文件选择按钮，支持多文件选择
- 智能处理图片文件和普通文件
- 实现智能光标定位和重复检测

#### 常用语系统
- 实现常用语管理功能，支持添加、编辑、删除和排序
- 添加hover预览功能，支持无限滚动
- 实现流畅的鼠标交互和主题适配
- 优化管理界面布局和用户体验

#### 终端集成
- 集成原生终端功能，支持PowerShell、Git Bash、Command Prompt
- 实现直接输入模式和完整键盘支持
- 添加ANSI转义序列支持，正确显示彩色输出
- 实现智能提示符识别和窗口管理

### v1.x - 基础功能建立期
#### 核心反馈系统
- 建立基础的交互式反馈窗口
- 实现文本输入和预定义选项选择
- 添加快捷键支持（Enter、Shift+Enter、Ctrl+V）
- 集成MCP协议，实现与AI助手的通信

#### 图片处理功能
- 实现图片粘贴和拖拽功能
- 添加图片预览和管理功能
- 支持多种图片格式和尺寸调整
- 实现图片与文本的混合处理

#### 基础UI框架
- 建立基于PySide6的图形界面框架
- 实现深色主题UI
- 添加基础的窗口控制功能
- 建立配置管理系统

---

## [发展里程碑]

### 🎯 项目成就
- **功能完整性**：从基础反馈工具发展为功能完整的AI助手交互平台
- **用户体验**：持续优化界面和交互，提供专业级的用户体验
- **技术架构**：建立了稳定、可扩展的技术架构
- **文档体系**：完善的文档体系，便于用户使用和开发者参与

### 🔮 技术演进
- **界面技术**：从基础Qt界面发展为主题感知的现代化UI
- **功能集成**：从单一反馈功能扩展为多媒体、终端、AI优化的综合平台
- **代码质量**：持续重构和优化，保持高质量的代码标准
- **用户导向**：始终以用户体验为中心，不断改进和完善功能
