from pyqcm import *
set_global_parameter("nosym")
new_cluster_model('2x2_C2', 4, 0, generators=None, bath_irrep=False)
add_cluster('2x2_C2', [0, 0, 0], [[0, 0, 0], ( 1, 0, 0), ( 0, 1, 0), ( 1, 1, 0)], ref = 0)
lattice_model('2x2_C2', [( 2, 0, 0), ( 0, 2, 0)], None)
interaction_operator('U')
interaction_operator('J', link=( 1, 0, 0), type='Hund')
hopping_operator('t', ( 0, 1, 0), -1)
hopping_operator('t', ( 1, 0, 0), -1)
hopping_operator('t2', ( 1, 1, 0), -1)
hopping_operator('t2', (-1, 1, 0), -1)
density_wave('M', 'Z', ( 1, 1, 0))
density_wave('H', 'Z', [0, 0, 0])
hopping_operator('t3', ( 2, 0, 0), -1)
hopping_operator('t3', ( 0, 2, 0), -1)
anomalous_operator('D', ( 1, 0, 0), 1)
anomalous_operator('D', ( 0, 1, 0), -1)
anomalous_operator('p', ( 1, 0, 0), 1, type='dz')

try:
    import model_extra
except:
    pass		
set_target_sectors(['R0:N4:S0'])
set_parameters("""

t = 1
U = 4
mu = 2
""")
set_parameter("U", 4.0)
set_parameter("mu", 2.0)
set_parameter("t", 1.0)

new_model_instance(0)

solution=[None]*1

#--------------------- cluster no 1 -----------------
solution[0] = """
U	4
mu	2
t	1

GS_energy: -10.1027 GS_sector: R0:N4:S0:1
GF_format: bl
mixing	0
state
R0:N4:S0	-10.1027	1
w	4	40
-1.350590526885	-0.37908848115009	0.28774885476146	-0.28774885476146	0.37908848115009
-1.350590526885	0.28774885476146	0.37908848115009	-0.37908848115009	-0.28774885476146
-2.6386468683243	-0.23060186194656	-0.23060186194656	-0.23060186194656	-0.23060186194656
-2.6386468683243	-0.41645012175972	-0.41645012175972	-0.41645012175972	-0.41645012175972
-4.1027484834621	-0.1048439075821	0.1048439075821	0.1048439075821	-0.1048439075821
-4.1027484834621	0.098793733785099	-0.0987937337851	-0.0987937337851	0.0987937337851
-4.1027484834621	-0.034652098424037	0.034652098424039	0.034652098424038	-0.034652098424037
-4.1027484834621	0.029409311919041	-0.029409311919041	-0.029409311919041	0.029409311919041
-4.9123725950379	0.1269321320693	-0.081881824556218	0.081881824556219	-0.1269321320693
-4.9123725950379	-0.081881824556218	-0.1269321320693	0.1269321320693	0.081881824556219
-7.2931243718862	0.024784881221317	0.0075883980204204	-0.0075883980204208	-0.024784881221317
-7.2931243718862	0.0075883980204205	-0.024784881221317	0.024784881221317	-0.0075883980204205
-8.1027484834621	0.0022148714191381	-0.0022148714191379	-0.002214871419138	0.0022148714191381
-8.1027484834621	-0.011244727707346	0.011244727707345	0.011244727707346	-0.011244727707346
-8.1027484834621	0.014236306104242	-0.014236306104242	-0.014236306104242	0.014236306104242
-8.1027484834621	0.014875953496114	-0.014875953496114	-0.014875953496114	0.014875953496114
-9.5668500985998	-0.0017589304472455	-0.0017589304472454	-0.0017589304472457	-0.0017589304472455
-9.5668500985998	0.0039427415866137	0.0039427415866136	0.0039427415866137	0.0039427415866137
-10.854906440039	-0.0016653301346228	0.0012137760670647	-0.0012137760670646	0.001665330134623
-10.854906440039	0.0012137760670646	0.001665330134623	-0.0016653301346232	-0.0012137760670647
1.350590526885	-0.29903457060572	0.37025100342858	-0.37025100342858	0.29903457060572
1.350590526885	-0.37025100342858	-0.29903457060572	0.29903457060572	0.37025100342858
2.6386468683243	-0.0091593445907051	0.0091593445907058	0.0091593445907068	-0.0091593445907068
2.6386468683243	-0.47594540553889	0.47594540553889	0.47594540553889	-0.47594540553889
4.1027484834621	0.056622486218156	0.056622486218156	0.056622486218156	0.056622486218157
4.1027484834621	0.10944219843485	0.10944219843484	0.10944219843485	0.10944219843485
4.1027484834621	0.067770136900599	0.067770136900598	0.067770136900599	0.067770136900599
4.1027484834621	0.055150975927197	0.055150975927198	0.055150975927198	0.055150975927197
4.9123725950379	-0.063554563856744	-0.13702998488394	0.13702998488394	0.063554563856744
4.9123725950379	0.13702998488394	-0.063554563856743	0.063554563856743	-0.13702998488394
7.2931243718862	0.025281666425205	-0.0057193937122543	0.0057193937122541	-0.025281666425205
7.2931243718862	-0.0057193937122539	-0.025281666425205	0.025281666425205	0.0057193937122539
8.1027484834621	-0.015611664207753	-0.015611664207753	-0.015611664207753	-0.015611664207753
8.1027484834621	-0.010815412202269	-0.010815412202269	-0.010815412202269	-0.010815412202269
8.1027484834621	0.0020741877831787	0.0020741877831789	0.0020741877831791	0.002074187783179
8.1027484834621	0.01379552482247	0.01379552482247	0.01379552482247	0.01379552482247
9.5668500985998	0.0027072201739625	-0.0027072201739623	-0.0027072201739624	0.0027072201739625
9.5668500985998	-0.003363035305606	0.003363035305606	0.0033630353056059	-0.0033630353056058
10.854906440039	0.0016196362287809	0.0012741096046582	-0.0012741096046583	-0.0016196362287808
10.854906440039	0.0012741096046583	-0.001619636228781	0.001619636228781	-0.0012741096046583

"""
read_cluster_model_instance(solution[0], 0)
