from pyqcm import *
set_global_parameter("nosym")
new_cluster_model('2x2_C2', 4, 0, generators=None, bath_irrep=False)
add_cluster('2x2_C2', [0, 0, 0], [(0, 0, 0), ( 1, 0, 0), ( 0, 1, 0), ( 1, 1, 0)], ref = 0)
lattice_model('2x2_C2', [( 2, 0, 0), ( 0, 2, 0)], None)
interaction_operator('U')
interaction_operator('J', link=( 1, 0, 0), type='Hund')
hopping_operator('t', ( 0, 1, 0), -1)
hopping_operator('t', ( 1, 0, 0), -1)
hopping_operator('t2', ( 1, 1, 0), -1)
hopping_operator('t2', (-1, 1, 0), -1)
density_wave('M', 'Z', ( 1, 1, 0))
density_wave('H', 'Z', [0, 0, 0])
hopping_operator('t3', ( 2, 0, 0), -1)
hopping_operator('t3', ( 0, 2, 0), -1)
anomalous_operator('D', ( 1, 0, 0), 1)
anomalous_operator('D', ( 0, 1, 0), -1)
anomalous_operator('p', ( 1, 0, 0), 1, type='dz')
hopping_operator('lambda', ( 0, 1, 0), -1, tau=1, sigma=1)
hopping_operator('lambda', ( 1, 0, 0), -1, tau=2, sigma=2)

try:
    import model_extra
except:
    pass		
set_target_sectors(['R0'])
set_parameters("""

t = 1
U = 4
mu = 1
lambda = 0.2
D = 0.2
""")
set_parameter("D", 0.2)
set_parameter("U", 4.0)
set_parameter("lambda", 0.2)
set_parameter("mu", 1.0)
set_parameter("t", 1.0)

new_model_instance(9)

solution=[None]*1

#--------------------- cluster no 1 -----------------
solution[0] = """
D	0.2
U	4
lambda	0.2
mu	1
t	1

GS_energy: -6.45695 GS_sector: R0:1
GF_format: bl
mixing	3
state
R0	-6.45695	1
w	16	328
-0.42118492590352	-0.17182854902125	-0.20424807339638	0.17182854797617	0.20424807427291	-0.20424807343169	-0.17182854907762	0.20424807432279	0.1718285480189	0.17751785970039	0.14203905855645	-0.17751785892184	-0.14203905951318	-0.14203905851517	-0.17751785967456	0.14203905945865	0.17751785891075
-0.42118493647078	-0.098326457790153	-0.11687807449713	0.098326459660153	0.11687807292806	-0.11687807442848	-0.098326457689753	0.11687807283986	0.098326459578005	0.10158208510985	0.081279844620446	-0.1015820864974	-0.081279842914171	-0.081279844698924	-0.10158208515475	0.081279843010323	0.10158208652247
-0.42598704446323	0.17564725843369	-0.14748246732681	0.17564725865711	-0.14748246705731	-0.14748246733765	0.17564725841695	-0.147482467042	0.17564725867124	-0.12882994467879	0.15868709378887	-0.12882994493583	0.15868709358262	-0.15868709377824	0.12882994468901	-0.15868709359657	0.12882994492974
-0.42598709227377	0.14228282266135	-0.11946797120253	0.14228282234422	-0.11946797158025	-0.11946797119989	0.14228282267051	-0.11946797158936	0.1422828223394	-0.10435852191946	0.12854426461431	-0.10435852158001	0.12854426488349	-0.12854426461785	0.10435852191363	-0.12854426487481	0.10435852157964
-0.75154137209245	-0.23434459821877	-0.19854677012715	0.23434459837913	0.19854676988023	0.19854677009028	0.23434459811374	-0.19854676977938	-0.23434459834747	-0.15449255426539	-0.20527424651086	0.15449255452811	0.20527424626932	-0.20527424650394	-0.15449255436007	0.20527424633433	0.15449255456698
-0.75154884854997	-0.0087369692424122	-0.0074023352031385	0.0087369706139412	0.0074023341504324	0.0074023358159232	0.0087369728685381	-0.0074023375561064	-0.0087369710305255	-0.0057598961399725	-0.0076531865635452	0.0057598946270677	0.0076531883550054	-0.0076531873337498	-0.0057598929083806	0.0076531860022262	0.0057598938414898
-0.81367400658393	-0.16015236272978	0.24821255362088	-0.16015236281401	0.24821255354837	-0.24821255362192	0.16015236274158	-0.24821255355914	0.16015236281691	-0.19919724412575	0.17287830681544	-0.19919724417576	0.17287830674466	0.17287830681168	-0.19919724411716	0.17287830673469	-0.19919724417322
-0.81367590947818	-0.001810537729022	0.0028060299498651	-0.0018104998592459	0.002806062151643	-0.002806030146463	0.0018105361675377	-0.0028060607414514	0.0018104999340398	-0.0022519355432077	0.0019543703715575	-0.0022519113310741	0.0019544038092983	0.0019543707542783	-0.0022519368211214	0.0019544048267682	-0.002251911177708
-1.2400343860201	-0.012592972101422	-0.010676082286639	0.012592971290821	0.010676079381464	0.010676083402758	0.012592971135472	-0.01067607967611	-0.012592971166498	-0.011435207446851	-0.015906706123088	0.011435209236489	0.015906704571555	-0.015906703096576	-0.011435209281261	0.015906702489611	0.011435210340773
-1.2819810853048	-0.0081237358380114	0.016082216954224	0.0081237358072428	-0.01608221708176	0.016082216527764	-0.0081237364572885	-0.016082216400107	0.008123736491123	0.026551997276205	-0.050184156386185	-0.026551997229332	0.050184156351736	0.050184157220984	-0.026551996613868	-0.050184157256847	0.026551996662562
-1.4110451647298	0.013689902189758	5.8169202094853e-06	-0.013689902190613	-5.8169178088291e-06	-5.8169116581262e-06	-0.013689902189719	5.8169121195711e-06	0.013689902187669	0.072442695413178	-0.05380547144916	-0.072442695412028	0.053805471447562	-0.053805471434912	0.07244269540569	0.053805471436734	-0.072442695407251
-1.5189855765697	0.37564834802927	0.28098102381449	0.37564834808222	0.28098102384431	-0.28098102379474	-0.37564834801959	-0.28098102386992	-0.37564834808755	0.0086426794227792	-0.0087354288585391	0.008642679502314	-0.0087354287217408	-0.0087354288305929	0.0086426794070098	-0.0087354287558961	0.0086426795226764
-1.6325604133074	-0.0050897723537913	-0.0062216265373147	0.0050897731538187	0.0062216268738199	-0.0062216268851009	-0.0050897731256199	0.0062216265345207	0.0050897724114817	-0.0045060326388954	-0.0039940482647958	0.0045060327181786	0.0039940482284198	0.0039940482047071	0.0045060327751744	-0.0039940483094401	-0.0045060326363963
-1.8379917891415	0.0037219195529356	-0.012228730872094	-0.0037219197085756	0.01222873080588	0.012228730835995	-0.0037219195613242	-0.012228730849821	0.0037219196972757	-0.21148618979	0.16731613002504	0.21148618974327	-0.16731612998961	0.16731613000007	-0.2114861897733	-0.16731613000141	0.21148618975403
-1.8895501143281	0.30358954054864	0.35814878613776	0.30358954054785	0.35814878613964	0.35814878613795	0.30358954054357	0.35814878613755	0.30358954054368	-0.006325322872267	0.0072237496496765	-0.0063253228494599	0.0072237496171121	-0.0072237496281852	0.0063253228561754	-0.0072237496393426	0.006325322867368
-2.007098325356	-0.0043315075869294	0.0085047427859467	0.0043315074549434	-0.0085047427669266	0.00850474280527	-0.0043315074361941	-0.0085047427538679	0.0043315076023284	0.15970159701662	-0.19771468809915	-0.15970159704022	0.19771468809909	0.1977146881739	-0.15970159709863	-0.19771468815178	0.15970159705306
-2.53074158351	-0.017798418318025	-0.015456190736477	-0.017798417911176	-0.015456190525835	-0.015456190313722	-0.017798419105733	-0.015456191078443	-0.017798419796037	-0.17039294967173	0.20646652043253	-0.17039293425148	0.20646652705739	-0.20646651875235	0.17039294892826	-0.20646652831882	0.17039293519651
-2.534777144731	-1.3611791807984e-05	-8.5666805327672e-06	-1.5999075236263e-05	-1.0149383694112e-05	-9.5510025583133e-06	-1.229860870953e-05	-8.8481713366427e-06	-1.2168070201567e-05	-6.3641389622348e-05	0.00015146532418452	-0.00014318085205477	9.7088767445466e-05	-0.00015510057593262	6.5133916267742e-05	-9.4521809949675e-05	0.00014154676561737
-2.5364301720149	0.0051653843874087	0.0034307786292169	-0.0051653798975384	-0.0034307760895013	0.0034307788133438	0.0051653841128699	-0.0034307763305268	-0.00516538064032	0.19659354440782	0.16245680173284	-0.19659351616922	-0.16245683555654	-0.16245680104789	-0.1965935446852	0.16245683508993	0.19659351646947
-2.8551418817855	-0.0044791048236829	-0.012051419768554	-0.0044790976046682	-0.012051410863119	0.012051417894425	0.0044791023165977	0.012051413868032	0.0044790969540927	-0.20361600680332	0.16988415501605	-0.20361601285784	0.16988413615821	0.16988415400778	-0.20361600772862	0.16988413717306	-0.2036160110203
-2.9216888740392	-0.00055890941798334	0.0050246624167929	0.00055889962316129	-0.0050246639393773	-0.0050246624770289	0.00055891075533258	0.0050246629852879	-0.00055889854231985	-0.15366879041909	-0.20697804117229	0.15366876458948	0.20697805863615	-0.20697804087196	-0.15366879062537	0.2069780582012	0.15366876425901
-3.1545514255087	-0.011095323477678	-0.014134450746759	-0.011095359092273	-0.014134519173222	-0.01413454273378	-0.011095041677846	-0.01413450442806	-0.01109498052117	0.00089001539151283	-0.002759629912974	0.00088990745044002	-0.0027595585046474	0.0027596490944423	-0.0008901987848164	0.0027595999556619	-0.00089020149666443
-3.1853197446772	-0.030353457300887	0.010709905132393	-0.030354121504542	0.010708435540497	-0.01070930831615	0.030353519174896	-0.010708751806278	0.030354558574729	-0.0036801263351907	-0.0042664749528737	-0.0036819065324455	-0.0042651449682034	-0.0042654833539354	-0.0036809778991631	-0.0042663797651214	-0.0036810608448938
-3.201869411218	0.001638423101416	-0.0015348981348455	-0.0016422577068206	0.0015374916754576	-0.0015372688868523	0.0016420419411971	0.0015344273085716	-0.0016392074372531	-0.0057890377068967	0.0063826358073769	0.0057934719014285	-0.0063845885881061	-0.0063842951597911	0.0057931436703201	0.0063827614672183	-0.0057887259385083
-3.2506657035214	-0.0079048403880667	1.8367098537771e-05	-0.0079173363621705	0	-1.6579737523544e-05	0.0079085732295706	0	0.0079180566688993	-0.019224726750962	-0.00081916858519468	-0.019233291575372	-0.00081901939204791	-0.00082363541917992	-0.019221181948342	-0.00081782408230965	-0.019237378011452
-3.2799085381637	-0.022561560507701	-0.0053895103038793	-0.022566425793561	-0.0054047140065392	0.0053907352948106	0.022562463712629	0.0054054916708108	0.022566852357792	-0.012456818499769	0.030722519026443	-0.012462701238378	0.030722705760769	0.030721217905854	-0.012456673775206	0.030722090245343	-0.012463656028973
-3.2866681530001	0.0044008718970221	0.019396389203657	0.0043996392376594	0.019390148938239	0.019390161815703	0.0043976737108906	0.019396348177478	0.0043988099431263	0.0080938836229179	0.013738097287114	0.0080919195155452	0.013737900329955	-0.013739630300929	-0.0080893774772708	-0.01373965975285	-0.0080915704115122
-3.2895917863535	0.0030852115677774	0.02505593903006	-0.0030554980636861	-0.025063446721465	-0.025061331834056	-0.0030845641491957	0.025057688158092	0.0030557756154591	0.0069256009612957	0.001316767333406	-0.0068880813266654	-0.0013398068303482	0.0013194168152326	0.0069283453993223	-0.0013366503497013	-0.0068861752591696
-3.3110928533662	-0.083172301408995	0.093514943672063	0.083170244998972	-0.093513743990614	-0.093514792087522	0.083171955890739	0.093513963108288	-0.08317053408964	-0.051018886895074	0.051667189599403	0.051015088038418	-0.051666548983581	0.05166732493172	-0.051019022113625	-0.051666479389494	0.051015075262602
-3.3614188105412	0.0046510909691659	-0.0013302831568837	0.0045778812340586	-0.0013656879199792	-0.0016652365124513	0.0043584696608698	-0.0016403128586487	0.0043715458105669	-0.00058101067482451	0.0025804034096702	-0.00058151702327366	0.0025676734764557	-0.002583057508974	0.00047425167474776	-0.0025035132942972	0.00035612398655531
-3.3631818024897	-0.024929539207133	0.0082686659810507	-0.024944677833736	0.0082612175201451	0.0081819479413853	-0.025007193709131	0.0081868227404247	-0.025003171458983	0.0026717579605397	-0.014388554588701	0.0026703427866338	-0.014390001410017	0.014390086980282	-0.0027011430769153	0.014405277055043	-0.0027242223679193
-3.3771319536601	0.06228393762267	0.056410068616345	0.062281523175954	0.056411256767841	-0.056417472528326	-0.062272288278351	-0.056412223804796	-0.062265767843816	-0.011466026992789	0.007194757912582	-0.011474031133377	0.007198636803163	0.0071881146932921	-0.011469057601214	0.0071882331086742	-0.011468596012506
-3.4190780242223	0.0090736055347268	0.018492941634194	-0.0089986634475492	-0.018453027437618	0.018453080995709	0.0089995862359505	-0.018493471619097	-0.0090735169278383	-0.019964347537538	0.0080266409209943	0.019993187149649	-0.0080127431482034	-0.0080127578113623	0.019992812068734	0.0080260848957021	-0.019963751587818
-3.4337755012237	-0.021131695085647	-0.010013995226183	-0.021168318813991	-0.010076100818238	0.010064810330336	0.021166317502618	0.010018906460613	0.021155959326713	-0.010581564380823	-0.0047938618347251	-0.010537162227879	-0.0048104719896357	-0.004824805488671	-0.01052600851363	-0.0047971912487969	-0.010592308906144
-3.5149471435905	0.10131217445441	-0.080635668553841	-0.10131214324741	0.080635777353525	-0.080635765205698	0.10131215940048	0.080635656657206	-0.10131218546555	0.028628300742101	-0.041678226775988	-0.028628491105446	0.041678092360304	0.041678105124037	-0.028628515829442	-0.041678243831334	0.028628324340405
-3.5692219292771	-0.014679536909519	-0.010405505797792	-0.014690025413612	-0.010410520777227	0.010402192572324	0.014687905592216	0.010401749162784	0.014690120823643	8.9934091951011e-06	0.0016810687101224	2.3860221948744e-05	0.0016706549618561	0.001668036046509	4.7363738259592e-06	0.0016583556213231	1.3486009956104e-05
-3.5902396935536	0.0024942843094622	-0.0041319252114896	-0.0024871933840717	0.0041336027095169	0.0041273123440225	-0.0024965420283052	-0.0041379487356401	0.0024851784827442	-0.04407338671665	0.033277088067003	0.044084076722687	-0.033270590829818	0.033270361889795	-0.044083272738005	-0.033277450293613	0.044074507716817
-3.5917131671207	0.004888350308918	0.0072914613020782	0.0048878004119906	0.0072939876238807	0.0073000600052963	0.0048970684131121	0.0072977807880661	0.0048978324453743	-0.017517532527415	-0.010597336220723	-0.017495821699737	-0.010613652905865	0.010613939737294	0.017494648548505	0.010597492567716	0.017516654436373
-3.5949518145342	2.7932970291377e-05	2.1891829700877e-05	6.5246431975759e-05	-2.0908616665181e-05	-0.00016579511551321	-0.00014795795596786	-0.00010034896588968	-0.00016709253748605	0.00046625709426973	-0.0001365290216242	-0.00011517269029936	0.00029839347975636	-0.00030127430279103	0.00012395060139933	0.00012021973752629	-0.0004297359379254
-3.6327688422179	0.0049337672866715	-0.0027303540593489	0.0049322797416587	-0.0027322565533153	-0.0027420326451287	0.0049168032911309	-0.0027396848424226	0.0049184899415319	-0.0053196106670465	0.0057687777182691	-0.005329577484843	0.0057758941987695	-0.0057746995629971	0.0053324585801623	-0.0057680921203246	0.0053231836419551
-3.7723919319643	0.062247251453998	0.070454127690292	0.062247111341865	0.07045381016615	0.070453148045469	0.062246135468744	0.070453480867619	0.062246281489079	0.0017363915817965	0.0026669375438494	0.0017330932011803	0.0026694384537076	-0.0026691788911996	-0.0017327808736698	-0.002666724882331	-0.0017360315144422
-3.7976051448733	-0.0060683813412477	0.013618229523855	0.0060683803644541	-0.013618457780448	-0.013618974680685	0.0060677163049084	0.013617697285493	-0.0060690600563775	0.29557402584538	-0.2292534036504	-0.29557379750771	0.22925349349978	-0.22925326604958	0.29557403877759	0.22925361437939	-0.2955737784995
-3.8511003999602	2.9040146901212e-05	7.8738509166051e-05	-2.1819149280052e-06	3.9115194351618e-05	0.00017666039282651	0.00017340177021999	0.00015946230053611	0.00016437733422594	-2.2718456476951e-05	1.6094438325356e-05	-2.9281200577449e-05	1.6558825993151e-05	-9.253437629109e-05	8.6618237021968e-06	-2.3278291456545e-05	-8.3612987505463e-05
-4.0233538526832	-0.012038556248636	-0.023058784102756	-0.012019058868305	-0.023036367329528	0.023042962870799	0.012026188518621	0.023055806348449	0.012033603661926	-0.0068512342040054	-0.010833281108844	-0.0068659986431423	-0.010821602418304	-0.010826665519127	-0.0068635237532386	-0.010829840125302	-0.0068545706997953
-4.0579630858306	-0.05575713873566	-0.072975339032931	0.055759525101939	0.072980909844452	-0.072980796681126	-0.05575906127554	0.072975153414403	0.055757234003085	0.048112730171431	-0.032436522816034	-0.048111294318072	0.032439151305527	0.032438990173691	-0.048111306205406	-0.032436552666803	0.048112707194979
-4.0805413269326	-7.5179341260806e-05	-3.3210047049447e-05	4.5676415910393e-05	0.00012440451816508	-0.00012954964213508	-8.6755365049993e-05	1.9447918287481e-05	2.3113112727951e-05	3.106244043102e-05	5.803329328901e-06	-2.043414725418e-05	1.8960880739047e-05	3.1518318976259e-05	-7.214905614538e-06	3.2878431423295e-05	3.0569756432107e-05
-4.1081718994984	0.0027454464418019	0.018860979192041	-0.0027453534768551	-0.01886101903666	0.018860952553652	0.0027454349484409	-0.018861022996161	-0.0027453371891279	0.25468670966888	-0.30487552086736	-0.25468671418987	0.30487555008881	0.30487553396555	-0.25468671213465	-0.30487555127375	0.25468671729422
-4.1504124841317	-0.068049360048404	0.043612553168195	-0.068049634430196	0.043612401512495	0.043613234157713	-0.068050069877929	0.043613907999952	-0.0680493443241	0.005726768074422	-0.01766770212568	0.0057262186019495	-0.0176672839985	0.017667519949434	-0.0057268519971483	0.017666683815212	-0.0057262408692737
-4.200434452671	0.027403122461801	-0.045430750469243	0.027401060237976	-0.045432404444132	-0.045426450961137	0.027397129316602	-0.045424427205765	0.027399480256316	-0.011724320959631	0.0012841373343513	-0.011724519175046	0.001283459060092	-0.0012849524430581	0.011725184917152	-0.0012858632469169	0.011725236187094
-4.2192784894706	0.00015081841452405	-0.00034634377743033	0.00011016328355587	-0.00038163223199122	-0.00063957937671608	0.00032145432399137	-0.00061054804855882	0.00035749386923267	-0.00016870482050503	2.5302106803732e-05	-0.00016823619267515	1.0273454331497e-05	4.903807440893e-05	0.00011178855708683	3.289847067227e-05	0.00011236233963467
-4.2394778716985	0.067575866953893	-0.073936252971973	0.067574043324221	-0.073937657920857	0.073936878180371	-0.067576809218582	0.073939034444015	-0.067574394892494	0.01905920486639	-0.013391332794764	0.019058770023303	-0.01339178669016	-0.013391019926284	0.019058680862262	-0.013391973859781	0.019058744806076
-4.3505373799519	0.073353142087422	0.062738545242776	-0.073356236351608	-0.062736728849082	-0.0627373593275	-0.073354140315322	0.062738377093862	0.073355596662919	0.016490258015529	0.01992489756864	-0.016490855536983	-0.019925396429469	0.019925076909689	0.016489691393445	-0.019925404994543	-0.016491265319987
-5.2570889154297	0.0040105487134964	-0.0054816712855566	-0.0040074547244692	0.0054769319221995	0.0054833319037172	-0.0040153643694765	-0.0054733811551013	0.0040070337354834	0.0070911054834424	0.0066425563632933	-0.0070857945156204	-0.0066496292474533	0.0066474550764023	0.007088109265961	-0.0066551568976737	-0.0070830933966653
-5.2722075951629	0.002536007641189	-0.0029239352471588	0.0026297696416904	-0.0028789148725347	0.0028555176393533	-0.0025705708489332	0.0028852253010319	-0.0025316574746685	0.003515394873712	-0.0035715365386122	0.0035325092834087	-0.0033779415241119	-0.003430794714201	0.0034457184951869	-0.0035014265027231	0.0036033841850804
-5.2807086014493	0.007121615064013	0.0099310812558888	-0.007110050296034	-0.0099429868011789	0.0099407421891948	0.0071109305418942	-0.0099325018705594	-0.0071187223165379	0.003094165731859	-0.0011363047147999	-0.0030782102718298	0.001122761662861	0.0011249844188252	-0.0030748665101824	-0.0011393741047949	0.0030903695414276
-5.3090657022279	-0.0026962317213188	0.00015828664657723	0.0026690497575268	-0.00014276948657522	0.00013357175943643	-0.0026244586395769	-0.00020150235602351	0.0027069874812418	0.0057030420452553	-0.0092197566039299	-0.0058632281337723	0.0092620952047021	0.0092285232092089	-0.0059669867916005	-0.0091015783956869	0.0058086854279512
-5.3140906815495	-0.0057850847286063	0.0058014449679577	-0.0057814683803601	0.0058098458565729	0.0058294783589692	-0.0057858542205222	0.0058132412254158	-0.0058035875868419	-0.0010118090588063	0.0018767289503496	-0.00092662661313318	0.0019168246142781	-0.0019957939305449	0.00090278508611142	-0.0019294827684681	0.0009717447993049
-5.324208263307	-0.0027326886634877	0.0008251627652268	-0.0027322976499975	0.00082479918119154	-0.00082242658373077	0.0027294112155892	-0.00082215986570276	0.0027302236590922	0.082186012875649	0.10209700524468	0.082182610575969	0.10209763602421	0.10209844114396	0.082185343770631	0.10209492610216	0.082184619145007
-5.3450839619218	0.0034054047275532	-0.0038151384834975	0.0033725208354604	-0.0038197620904637	-0.0038280999052389	0.0034090203916044	-0.0038179494217511	0.0033797782717797	-0.00067870160759	-0.0063004994851346	-0.00067562635955901	-0.0064524385611438	0.0063500041770006	0.00071786623615393	0.0064062634179781	0.00058092877517125
-5.3668680162575	0.0012630258454263	-0.0013333628190134	-0.0012527752213584	0.0013067099172951	0.0013000135032915	-0.0012179350295332	-0.0013351611826948	0.0012611268863514	-0.023819446187817	-0.018154590147802	0.023731974067611	0.018188657774875	-0.018179374001849	-0.023778662075682	0.018288742660093	0.023685717970236
-5.4017786882012	0.0024562712887007	0.00068979541252255	0.0024423180033632	0.00069132907933303	0.00068549711611037	0.0024534332399932	0.00068963734062035	0.002449904063322	0.0083910955074892	-0.00015695931837885	0.0084419666362728	-0.00016549282486365	0.00014097399134769	-0.0084362023119668	0.00019664727246504	-0.0084330765904693
-5.4306834541217	-0.00031731305700489	-3.1289562885986e-05	-0.00030633247520378	2.0154099941909e-05	9.241324446189e-06	0.0003709613371641	-1.49792766375e-06	0.00025133726196076	-0.014630920030217	0.0082243866041687	-0.014670807319399	0.0078343621642492	0.0080146733032246	-0.014461590345618	0.0080226075733366	-0.014826074717765
-5.4910019867948	-0.0051938859095093	0.0036729032055771	0.0052081313488864	-0.0036449022853644	0.0036327074193335	-0.0052192644568016	-0.0036649436442318	0.0052133080265615	0.022851572697835	-0.021004703746612	-0.023010241945802	0.021051446736778	0.02104554956628	-0.023047080328431	-0.02095466415535	0.022860453163742
-5.5021434321063	-0.0024963638484663	0.0024080368251635	0.0024983528776723	-0.0024022335435213	0.0024006837693958	-0.0024996954378211	-0.0024069583292347	0.002498645130672	-0.011484072009437	-0.028223332200712	0.011463434030896	0.028228362714228	0.028227807908276	0.011458434301438	-0.02821698007042	-0.011484732974334
-5.5132004002652	-0.00057875170996973	-0.0030460393171552	-0.00045537594723764	-0.0030346419832419	0.0030869909328931	0.00053384388267004	0.0029838695977076	0.00051272962326559	0.0083329714706907	-0.0022302574849007	0.0080483293791313	-0.0021088144944611	-0.0019450617238133	0.0080573157157997	-0.0023588475407966	0.0082114221631772
-5.5253525569581	-0.0014351241755422	-0.00042061496615146	-0.0014347681642136	-0.00042036288463804	-0.00042109914885137	-0.0014349695720899	-0.00042143171093216	-0.0014352860207375	0.10455489333698	0.082481213694596	0.10455441974702	0.082480530540368	-0.082480067196261	-0.10455654873457	-0.082480899940428	-0.10455643973115
-5.5610072563731	0.0002882639331091	-0.00061121295009401	0.0002468253791281	-0.00068668407165128	-0.00068538897965819	0.00025376234578049	-0.00061222836774261	0.00029571686440654	-0.012139251244682	0.017742537760732	-0.012251240024096	0.017985516979282	-0.017978742743491	0.012259998178264	-0.017764438527776	0.012169304237869
-5.5769965434939	-0.0025930538944978	0.0084410774586337	0.0025915503129032	-0.0084469342931506	-0.0084352825390055	0.0025881960887694	0.0084535339771429	-0.0025957204453643	0.033757416738295	-0.037811778600507	-0.033687549466677	0.037718385993097	-0.037717123331183	0.033690675377852	0.037823655589292	-0.033762542271392
-5.5956522526538	0.0052559793309481	-0.0042496302446104	-0.0052583768623358	0.0042544020048268	-0.0042512758361826	0.0052656588715675	0.0042486284174223	-0.0052655710646464	-0.0063219419270265	0.00070443431781839	0.0063275471866096	-0.0007146276483771	-0.00071510598532199	0.0063414243140699	0.00071902370712479	-0.0063452958835607
-5.6590346995017	-0.013302041918855	-0.006971271075212	0.013236405586012	0.0070533625160569	0.0069645384726993	0.013312725043785	-0.0070766936861218	-0.013215901232391	0.015092563914897	-0.00070306993173371	-0.015095382297383	0.0007121163192457	-0.00075737688972747	0.01512219443217	0.00063212130852049	-0.01501876242147
-5.6775465556979	0.0018604254759173	-0.0014200616119472	0.0018269267709467	-0.0014363273066023	-0.0014384052167593	0.0018251366629947	-0.0014160668531368	0.0018552782991147	0.0045981679069069	-0.0080178139887197	0.0046351148248626	-0.0080162306482703	0.0080127611609659	-0.0046255822716461	0.0080199507520661	-0.0046058460207875
-5.6826203806523	0.011880941004821	-0.010950321889345	0.011970667197144	-0.010899420145318	0.010948237074702	-0.011879666979357	0.010900290084989	-0.011970924717452	-0.0038249561447596	0.0038834341828753	-0.0039122209982989	0.0038858552117087	0.0038719977956089	-0.0038140251585413	0.0038779892066623	-0.0039097680750285
-5.714243203426	0.0016532078415174	-0.00083902286433953	-0.0016383469540013	0.0008293135269992	0.0008411222872734	-0.0016534915177554	-0.00083309722694013	0.0016405012350025	-0.0049689744614626	0.0045522948745327	0.0049700953049818	-0.0045628822682294	0.0045591404419704	-0.0049797863788942	-0.0045610122773749	0.0049761859646672
-5.7478755291377	-0.00031425697212014	0.00030487126079565	-0.00027994101550849	0.00033990143982035	-0.00031023005790326	0.00031500536204005	-0.00033178788640068	0.00027619660243129	0.0015067560361778	0.0014262647896547	0.0015121025582346	0.0014096006131473	0.0014281477365832	0.0015217552344458	0.0014174886376394	0.0014876108845636
-5.8864020949549	4.0893461981737e-05	-5.2640281723061e-05	-7.3594908753382e-06	2.030492393416e-05	-5.3502378186908e-05	-1.9997653490011e-05	6.0094372719766e-05	9.7788912033737e-06	-0.00029283232259922	0.00011479639467311	2.9742196908271e-05	0.0001920567533086	-0.00011755664220308	0.000234254773416	-0.00020760116275644	-7.3939159640409e-05
-6.0712808378591	0.0043380400685426	-0.0023438055142092	0.0043424650339093	-0.002340379336268	-0.0023400025362128	0.004342148411409	-0.0023432580299155	0.0043378169619883	0.055786871521024	-0.079133737420499	0.055789594577892	-0.079130376235373	0.079131028937062	-0.055789805838698	0.079133796374498	-0.055787932323571
-6.214882936856	-0.00032480201955435	-0.0016544491848142	0.00032448149021985	0.0016544543748879	-0.0016540548703159	-0.00032491168838959	0.0016546600914928	0.00032444325034468	-0.072745877537059	-0.061070717207533	0.072742139483025	0.061074313206156	0.061060139949577	0.072732166693705	-0.06105951610821	-0.072733958452756
-6.2243478616129	-0.0045115815166782	-0.0028724067272751	0.0045117217840795	0.0028729991987343	0.0028721286639622	0.0045119149037986	-0.0028732564721061	-0.0045113668377402	0.0684859976355	0.079251430138991	-0.068476806390728	-0.07925926869078	0.079262310737956	0.068496124812415	-0.079267589163005	-0.068488646804875
-6.2731381035515	9.0181585910229e-05	-0.00023703073296253	0.000311443379978	-7.4593343094605e-05	-6.2331753867991e-05	0.00031466915468011	-0.00024781941045783	8.7683399204019e-05	0.00058244035596145	-0.0002859897056499	0.00014559915512745	-0.00083476516389084	0.00098636965691001	-3.0745088340924e-05	0.00017679101657969	-0.0007433426768034
-6.3710632262732	0.0017408692975959	-0.0030066296127288	0.0017508293986206	-0.0029978899663919	0.0030065277501381	-0.001742160533147	0.0029995979680062	-0.0017515800278057	-0.076514128170864	0.063347354079373	-0.076526880390928	0.063331480995757	0.063343274712629	-0.076514534082361	0.063331781177146	-0.076524168591396
-6.3792576381415	-7.4983834894337e-05	6.5021063836124e-05	-8.755907728538e-05	7.1224230862915e-05	3.7569921913983e-05	-8.6611060407115e-05	7.0623024445363e-05	-6.1345924215876e-05	0.00016642590393179	-4.6129770267462e-05	0.00013698872727902	-7.5606909574246e-05	-0.00036581559533825	0.00028031060542132	-0.00028758513310149	0.00034798502856782
-6.4985743580481	0.012023751384174	-0.0093897613771669	0.012019161274788	-0.0093869325235475	-0.009397655990347	0.012014476746346	-0.0093798445374988	0.012028557600258	0.0069964461084443	-0.012761906555281	0.0070046226137539	-0.012755814984611	0.012752791190581	-0.0070039080540523	0.012765543656189	-0.0069984255723803
-6.5048095319836	0.0017704347867352	-0.0013017633111542	0.0017116291665288	-0.0014161397823289	-0.0013151850653522	0.0017672971888349	-0.0014124624453954	0.0017247056424978	0.00098415517335925	-0.0018113325556765	0.00096585599938252	-0.001786716984661	0.0018214372801759	-0.0010046529195965	0.0018040184942195	-0.00096823239933206
-6.530334484211	-0.001037941460666	0.00059956969372477	-0.00074749030469872	0.00079290024421099	0.00087972147689683	-0.00069611844492604	0.00050514232745997	-0.0010815601341504	-0.00029918052623091	0.00099416075572696	-0.00057586867291999	0.0006812459986548	-0.00069604825336527	0.00052429888143646	-0.00098022233171317	0.00035847791841984
-6.6007008421098	-0.0075241570878313	-0.010950809249499	0.0075232252152874	0.010951034839726	-0.010939475795466	-0.0075126041033951	0.010941418228214	0.0075107453603741	-0.016762503974374	-0.012368839319697	0.016765331879941	0.012366873670261	0.012375412358036	0.016772809969527	-0.012379370475066	-0.016769118774169
-6.685960258329	-0.010936595006097	-0.010265493483927	0.010992606919658	0.010205287836626	0.010249416885614	0.010976638661545	-0.010237417839005	-0.010969832305716	0.0056534581365561	0.0078326424932458	-0.0056292093514092	-0.0078684879443251	0.0078284543621857	0.0056277559365683	-0.0078317238182726	-0.0056140193919725
-6.7752713278555	-0.0081628741841269	0.010051755459943	-0.0081257394745281	0.010099606741936	-0.010051644553944	0.0081608639124982	-0.010098488175348	0.0081261258023454	0.014082779202045	-0.012032780134033	0.014066451436592	-0.012054577467095	-0.012029796763397	0.014085628484436	-0.012058052641051	0.014063643628698
-6.8130500255485	0.013106034244863	-0.017654192858079	-0.01310291428604	0.017650211831859	0.017654827665003	-0.013107195872299	-0.017649458611974	0.013102233545908	0.00097448141553436	-0.0045314123041666	-0.00098404407357786	0.0045401061960786	-0.0045310646451602	0.00097493934928826	0.0045392084008452	-0.00098454666897138
-7.0862288174211	8.5509661067373e-06	-0.00016559642389896	0.00018539925684782	3.0596876014545e-05	5.5112336496174e-06	0.00021841124727324	-0.00013574519565238	-3.1892533391984e-05	0	7.0228332684961e-05	-9.2654827525618e-05	-6.0625472555141e-05	4.7083078684058e-05	4.7099449872945e-05	-2.7700046798557e-05	7.3484788600803e-06
-7.1522789634478	-0.018222827283007	0.015429869706504	0.018224058724811	-0.015430632025406	0.015432841804516	-0.01822101322355	-0.015432371096909	0.018220191783922	-0.001898156768582	0.0013495216257484	0.0018932876096649	-0.0013446528852693	-0.0013434103885882	0.0018940437163348	0.0013483089921137	-0.0018986362697873
-7.2779427717145	0.00046176138363428	0.00040513453504989	-0.00046261918065451	-0.00040482321835066	-0.00040328085319892	-0.00046395736732364	0.00040304762375751	0.00046456032997322	0.00056520940707282	0.00085202172949889	-0.00056228726202419	-0.00085696233952295	0.00084805147617208	0.00056344125199207	-0.00085310109817686	-0.00056080901149359
-7.3159587444682	-0.00029261343321303	0.00075739420728178	-0.00028826163373796	0.00076418513065674	-0.00075870054130384	0.0002940125127726	-0.0007625894866641	0.0002863017223112	0.015834252371928	0.022846560148601	0.01583399664787	0.022848758598771	0.022850867509995	0.015835157996187	0.022844358750118	0.015832574040811
-7.3763401194034	-0.00088697078346283	0.00073703554393681	0.00084332351187053	-0.00072658486506713	0.00067972144342741	-0.00089570761934047	-0.00068830079971786	0.00093650560553686	0.0005728703401083	0.0034731157722041	-0.00032733985389205	-0.0035942684367701	-0.0036149526152817	-0.00033872755863406	0.0034903970159058	0.00057684840328531
-7.379974042394	-0.00017492349594774	0.00012935199268157	0.00019586005085103	-0.00013884960203708	0.00014970377815585	-0.00016861819133432	-0.00015169834388638	0.00017447672977919	6.9590814027155e-06	0.00076311385648656	-8.4322616750209e-05	-0.00075247581616685	-0.00072318960569236	-6.8809715530592e-05	0.00076049441530211	4.5039552875742e-05
-7.4157532679533	0.0028176911474561	0.00094106776363856	0.0027928895984332	0.00091828106817471	0.00091734956685056	0.002802651901121	0.00094051981356773	0.0028268575945243	-0.0093404370915049	-0.0079279874603771	-0.0093344913916295	-0.0079208454272086	0.0078931861274352	0.0093831974965693	0.0078976050403531	0.0093892474554791
-7.4295684759802	0.0017126105326988	-0.00018877671184133	0.0020431420933083	0.00010925145663405	0.00020649210311809	-0.0017126996717428	-0.00010455346495752	-0.002024817065587	-0.0093380638179024	0.0057178554470887	-0.0094146546938168	0.0055918940214561	0.0057109230174751	-0.009274259997088	0.0057061557631514	-0.0093698838314249
-7.4778459068464	-0.0033080864303095	-0.0030452439047282	0.0030889636780474	0.0030597184051017	0.0030998258613739	0.0032764479387571	-0.0030058398653302	-0.0031180398609079	0.0018713475012058	-0.00037943342253434	-0.0011633979289243	-0.00022047860673457	-0.00025520719749627	0.001973311216198	-5.7138845619686e-05	-0.0010839569987901
-7.5071471448826	0.00027264047150872	0.00065383973428938	-0.0001560419833129	-0.00066891165090295	-0.00070077407273105	-0.00023602998522836	0.00061975145143862	0.00019690378692274	0.0018798368423999	-0.0016016604398851	-0.0020631716168911	0.0018690716693357	-0.0017431835983085	0.0017769390472403	0.0017281887646395	-0.0021350174825121
-7.5277096706408	0.0010470959630404	-0.00034183261166656	0.0010602617924043	-0.00032575327535209	-0.00032617014893651	0.0010594218670586	-0.00034234578962094	0.0010464855608659	0.01957303922762	0.017084596859209	0.019577868797347	0.017075447170354	-0.0170753046053	-0.019580471528779	-0.017083478939362	-0.019574417287722
-7.5475554976264	0.0045113950147127	-0.0052613937418754	0.0045340314454535	-0.0052335597723956	-0.0052365734893812	0.0045305166140968	-0.0052645547314838	0.004508180648749	-0.0061765454709612	0.0031302168270094	-0.0061731935357671	0.003119330517451	-0.0031216960984738	0.0061667001150114	-0.0031309306074226	0.0061721935783957
-7.5604273529539	-0.0024876195221896	-0.0029301547795365	-0.0025245795789958	-0.0029713919449304	0.0029235073962358	0.0024961962140446	0.002966555738756	0.002526604218841	0.0012609460813408	0.0044761305519201	0.0012729550100609	0.004498836273848	0.0044805155377427	0.0012799750287397	0.0044814037720333	0.0012608402914317
-7.6141777300649	0.0026359038367907	-0.00012266437160062	-0.0026334221630141	0.00012561910382357	-0.00013497176752616	0.0026298274312262	0.0001293312699858	-0.0026293641625104	-0.011942701095496	-0.01183205285962	0.011955744169646	0.011816872774227	0.011812250616579	0.01195724000048	-0.011832748902122	-0.011944302574908
-7.6751592813513	0.0008305014408651	0.00020830717988491	-0.00083238983556694	-0.00020836517100588	0.00022349144737824	0.00083450709936126	-0.0002194574923981	-0.00083706746097982	-0.0036952208107414	-0.0035435619384008	0.0036850199954202	0.0035528100310371	0.0035560360169462	0.0036834343724338	-0.0035399353120465	-0.0036959590852485
-7.7478102639516	0.0028991653805984	-0.0028333230983027	-0.0028999225216878	0.0028330561344896	0.0028349020422207	-0.0029010512397283	-0.0028316551517055	0.0028982817004659	0.00048021482351722	-0.0011397034928183	-0.00049365812530478	0.0011519384112474	-0.0011353732063508	0.00047899672866734	0.0011531412648647	-0.00049511818526122
-7.7851951913111	3.172179393643e-05	-1.1965088391338e-05	-1.8516884527287e-05	9.8877700818947e-06	-1.4431281463397e-05	-4.0688180350387e-05	-1.9271074486002e-06	5.5345328093189e-05	0.00011093739006372	5.8873660337036e-05	-6.3869920015169e-05	-7.6001849313196e-05	-0.00012918060330842	-4.4930107099314e-05	4.9898736748371e-05	8.6976044215912e-05
-8.1129065530256	-0.0030501627756294	0.0026521760909479	0.0030504674977157	-0.0026523968000048	0.0026525542072515	-0.0030499853086055	-0.002652453864129	0.0030498428940454	-0.00034489346290329	0.001294857666019	0.00034194603067576	-0.0012920034215926	-0.0012924362090402	0.0003417677207382	0.0012948326119513	-0.00034428295739524
-8.4296920348984	-2.122899855462e-05	-1.3914964130036e-05	2.6984754361816e-05	1.1300665196647e-05	-6.9801200456669e-06	-1.3656493538769e-05	4.4315792189048e-06	1.310126318375e-05	-0.00012565313626182	1.7751684035536e-05	-2.3005899655933e-05	0.0001628372202271	-0.00010370847105317	0.00010910516485726	-5.0932688396642e-05	-9.1025246145175e-06
-8.4712970026862	2.46745083398e-05	1.8959693298162e-05	-2.4038631077991e-05	-2.1564995168927e-05	2.187828584886e-05	2.5084662899541e-05	-1.982784435233e-05	-2.4738758846214e-05	0.00013685100550109	0.00012015978671883	-0.00014214364846831	-0.00012607668238784	-7.3069625454057e-05	-0.00018816268428062	0.00012344704913369	0.00015462003799614
-8.4984083689145	-0.00075689846924898	-0.0010562070434686	0.00075669749740085	0.0010563626532951	-0.0010564418797533	-0.00075671617410838	0.0010562235156502	0.00075704036696702	-0.010420433447022	-0.0084937979651262	0.010424884104624	0.0084893220827993	0.0084925669847742	0.010423631478711	-0.008493711021306	-0.010421398551633
-8.5366518460723	-9.721218944201e-06	8.0394688631421e-06	-5.7362839697435e-06	0	1.0018071579061e-05	-8.9747867795897e-06	0	-1.0314949088445e-05	-3.0448587247713e-05	0.00015827230667021	-0.00016826188108209	0.00011293250380179	-0.00022991705707817	1.5192463895301e-05	-2.3556496777627e-05	0.0001514671101991
-8.6111792539204	0.00088350500327973	-0.00044278476952093	0.00088369828422816	-0.00044284269884963	-0.00044251368173062	0.00088312856175679	-0.00044245426335212	0.0008834869179249	0.0046920948042697	-0.0073703146941785	0.0046917273225961	-0.0073638127174954	0.0073651854529644	-0.0046986757131687	0.0073764439041023	-0.0046941422736023
-8.6678645325368	-3.8679828135624e-05	3.2920738368801e-05	-3.6339659666172e-05	3.7494667516768e-05	-9.1209893463863e-06	-5.2131220563692e-06	-1.5010807484941e-05	-2.0549728307353e-05	0.00013357051439072	5.3148078817695e-05	0.00017719238383129	-0.00014377694825254	-0.00021588813639785	0.00035583327335443	-0.00051824941039195	0.00031631073687105
-8.6746230063983	0.00046770112935477	-0.0010758392775285	0.00046458896975912	-0.001077107662978	0.0010764945290682	-0.0004684261086654	0.0010779473919373	-0.00046714386258113	-0.010491901433095	0.0089884647448341	-0.010470295912411	0.0090438195750957	0.0089871370249899	-0.010481565754865	0.0090249941534304	-0.010469228225597
-8.7360707912228	-1.3455317030699e-05	-9.3138290191256e-06	9.7702906958455e-06	3.0067231088783e-06	7.6637238096123e-06	-2.2346687177479e-06	2.8679374100812e-06	-6.1145227624805e-06	9.5200825260331e-05	0.00010792921864957	-0.00017202864038647	-1.5977780569198e-05	1.8219400242032e-05	4.9602016142269e-05	6.4358870605375e-06	-0.00011020793717254
-8.7550631946647	-0.00013753423383231	-8.3610974591843e-05	0.00013848390395469	7.4743049161547e-05	8.2841746778218e-05	0.00013910602811798	-7.539937142791e-05	-0.00013585518296418	-0.0035975180283084	0.0047938396736356	0.0035578939989119	-0.0047582489986481	0.0047995236193115	-0.0036030556034212	-0.0047439142779139	0.0035554902105597
-8.7797526432264	0.00079629741245348	0.00051543557568307	-0.00079284304224953	-0.00050208979263689	-0.00051482000221705	-0.00079802306047278	0.00050277583610173	0.00079009513336238	-0.0060558356289524	-0.0062082710505024	0.0060935846489811	0.006159576962654	-0.0062132277207438	-0.0060522283062865	0.0061441786552682	0.0060962462884165
-8.8247984628747	-0.0018453027417369	-0.001202575305445	-0.0018499562957805	-0.0012056732524823	0.0012024989756115	0.0018451587762639	0.0012056918086872	0.001850363503466	0.0046123783168213	0.002995921952113	0.0046336414099282	0.003034637344543	0.0029940529986822	0.0046117967816913	0.0030375424866443	0.0046339749600008
-8.965843013819	-0.0010672321057864	-0.0012821298174265	-0.0010666110813557	-0.0012817331051262	-0.0012818209679118	-0.001066640984407	-0.0012821114839341	-0.0010671101377527	0.0068641564844923	0.0052461979309508	0.0068625095209137	0.0052420836459467	-0.0052423204354483	-0.0068624267191153	-0.0052460081197071	-0.0068633443700181
-9.1279688594768	-1.7062036586118e-05	-0.00013577306865048	1.6137598906457e-05	0.00013918368295023	-0.00013725753631975	-1.5105297135709e-05	0.00013581089697003	1.5126481563204e-05	0.0030032224616415	-0.0031535651920197	-0.0029876075226691	0.0031651177814402	0.0031735901742198	-0.0029797917561718	-0.003162359852848	0.0030032644703021
-9.1458335518786	2.6651625548859e-05	3.7061484319523e-05	-3.7464296819382e-05	-1.3617797583256e-05	1.1958872442638e-05	-2.3943387324206e-05	2.2986458481332e-05	6.3092008203758e-06	-0.00018651268146988	-0.00016132617297296	1.3807738944027e-05	0.00013162989077819	-0.00028452556637139	0.00014646405344064	0.00023831139370619	-9.5482937194132e-05
-9.2119370800537	-0.00059384792577249	-0.0010051288535605	-0.00059658322887908	-0.0010065888745263	0.00100397979266	0.00059302687869771	0.0010073795543983	0.00059772587120322	-0.0080047668930841	-0.011309818228777	-0.0080159600416179	-0.011274599154009	-0.011307439586075	-0.0080142954009532	-0.011277059730734	-0.0080083085114751
-9.2796613838778	0.0001386008348727	0.00010580046794923	-0.00012855834483275	-0.0001045948673415	-0.00010885191167138	-0.00013811191347432	0.00010512538603662	0.00013292705428726	0.0031933482609819	-0.0042348380513079	-0.0031461534030409	0.0043211318339525	-0.0042400395225995	0.0031643979554558	0.004314749096165	-0.0031503173486499
-9.2957720811768	-0.00087981173102506	-0.0013108765633772	-0.00087975317793768	-0.0013108578418119	-0.0013108570280444	-0.00087972061054537	-0.0013108625986011	-0.0008797622634539	-0.011246397789492	-0.0094689537474964	-0.011249720323366	-0.0094660525410382	0.0094656034198227	0.011249601599809	0.0094686302213412	0.011246263910394
-9.4181966900985	-0.00081417671863234	-0.00057435100084455	0.00078555104270414	0.00059074508075616	0.0005873091152872	0.00081917426245894	-0.00059377440412475	-0.00079811005207497	0.0040056158661209	0.0026427930469217	-0.0040339130869006	-0.002793514527523	0.0026612399323337	0.0040390288115493	-0.0028259171377947	-0.0040485275527272
-9.4377097433575	7.9461954880637e-05	8.0720669826624e-05	-7.7056033601224e-05	-8.6940080427312e-05	-6.7270580093036e-05	-4.8060841984958e-05	5.5907962625617e-05	5.9776741675205e-05	-0.00034015398038469	-0.00036105508623445	0.00035669033544956	0.00032283939116677	-0.00024137363156808	-0.00033172191996813	0.00022319926518529	0.0003092657202977
-9.4395435274008	0.0005595612038478	0.00075000541047944	-0.0005702054451316	-0.0007429976202776	-0.00074711663328324	-0.00056066754386681	0.00074461915751442	0.00056772211249	-0.0029304446470235	-0.0027366822558634	0.0029202194858961	0.0026864069753736	-0.0027403089095927	-0.0029215479764808	0.0026842812605394	0.0029204922968861
-9.4889730570874	-0.00044213093569597	0.00035105244084804	-0.00049333788161257	0.00031413083012204	-0.00032495914452132	0.00046757729326544	-0.00033754493599328	0.0004656506743406	-0.00030603025414091	-0.0026068625955782	-0.00016925712811329	-0.002405976801829	-0.0025033617892142	-0.00026869092139517	-0.0025134780945701	-0.00020234890560894
-9.5558334871657	-0.00047660473140678	-0.00041306807906083	0.00043727562160928	0.0004521725167736	-0.00043362966466897	-0.00044064296366808	0.00042165987772849	0.00045530190466772	-9.9047863976593e-05	0.0022614953361868	5.6148565924483e-05	-0.0023754760819884	-0.0023516188136742	0.00012101020221025	0.0022100634451378	-0.00010876759442766
-9.6159138040279	0.0001879081584207	0.00018165262977146	-0.00023365738780596	-0.0001334101191441	0.00018006125835501	0.00018969489982495	-0.00013539126054448	-0.00023248880338643	-0.0009323037836409	0.00027083890233508	0.00085089385842498	-0.00022801448397471	-0.00027647787714182	0.00093273906839441	0.00022052637497968	-0.0008538214905733
-9.6176539886268	0.0010372719125898	-0.0010855848594901	0.0010354233125791	-0.0010860967050859	-0.0010854439489834	0.0010395528642783	-0.0010877455206918	0.0010342789847788	0.0018375724275919	-0.0011309873413652	0.0018842960151616	-0.0011892851324235	0.0011367472867768	-0.0018318388943421	0.0011779173087764	-0.0018911546789147
-9.6813302529605	-8.8607852579694e-05	-8.5551874890566e-05	8.9340239153958e-05	8.8180667384987e-05	-9.0836566144604e-05	-8.3394715134424e-05	8.0599772965406e-05	9.034909764522e-05	0.0038728560577622	-0.0032968059260381	-0.0038748592028745	0.0032741674251928	0.0032892284520033	-0.0038708570377277	-0.0033025581959039	0.0038596657833343
-9.7551594571433	0.00057066376987342	0.00063804916262962	0.00056961355882019	0.00063677192650976	-0.00063644538999435	-0.00056940333739125	-0.00063809022514052	-0.00057117541513103	-0.0016089648984612	-0.0018924817405451	-0.0016012564729656	-0.0018976617877332	-0.0018956409015315	-0.0015996946596012	-0.0018947389736356	-0.0016101673632067
-9.8629692349015	0.00068946966648873	-0.00012543637382579	0.00068904165282633	-0.00012587747182741	-0.00012544605714083	0.00068942742122029	-0.00012585835634869	0.00068906578280251	-0.0060938586523717	-0.0049647239865815	-0.0060927317646039	-0.0049641419096447	0.0049644857225314	0.0060937254686731	0.0049643836463352	0.0060928568259328
-10.013973915801	-0.00095333269963418	-0.0010786211298281	0.00095628692551563	0.0010758214940879	-0.0010768776214347	-0.00095536802513595	0.0010778405775789	0.00095474920772238	0.001142445133805	0.00095693082904056	-0.0011414234466742	-0.00095646024427577	-0.00095830018140985	-0.0011429584973921	0.00095745093523711	0.0011445043516886
-10.022198791168	-0.00020546267813615	-0.00022617647289753	0.00019936528013344	0.00023187003038487	-0.00022562339156815	-0.00020678756508295	0.00023261357734367	0.00019891530238961	0.00022473577652946	0.00019419467610386	-0.00023013476482287	-0.00020461829011475	-0.00020037938206692	-0.00022639510171932	0.00020990848562022	0.00023230457650893
-10.095567604079	-0.00065141251023225	0.00047487357973674	-0.00057867337427726	0.00055856632626222	0.0004749293380874	-0.00065121365778216	0.00055814952801875	-0.00057869841880839	8.7809643515573e-05	-0.0010922173415055	4.0530432297254e-05	-0.0011480868386716	0.0010894005163269	-8.6467442421963e-05	0.0011504595633518	-4.231807615377e-05
-10.096072333716	-0.00087528556402212	0.00078491980313688	-0.00092489047558058	0.00072776903709713	0.00078478795388444	-0.0008752697009237	0.0007279475972787	-0.00092484790709111	8.0006860631494e-05	-0.0016645994117177	0.00011172367614242	-0.0016274517678624	0.0016674362261551	-8.0541606654418e-05	0.001624965974287	-0.00011102337704757
-10.399339997759	-0.0010179213384318	-0.0011544422490308	0.0012782770851584	0.00080189295182949	0.0011546777981671	0.0010180771519934	-0.00080210329905525	-0.0012784780437846	-0.00068019222453627	-0.0012078512310001	0.00099113697032943	0.00095517435589292	-0.0012076816216367	-0.00068086318857861	0.0009552914276628	0.00099155543262101
-10.399485774132	0.00096580522383031	-0.00087982763793484	0.00057781314966121	-0.0012104838632866	0.00088046368122969	-0.0009653261172625	0.0012098724253991	-0.00057833182787924	0.0010627933413901	-0.00056747106453319	0.00078003512574932	-0.0009299507115846	-0.00056724239035597	0.0010611402573973	-0.00092989749185946	0.00078146323621097
-10.757234382687	-0.00076667314950217	-0.00052431860935882	-0.00076665862008847	-0.00052431105643169	0.00052431335352743	0.00076666931262629	0.00052431628762392	0.000766662834389	-5.2200701501504e-05	1.2967132617879e-05	-5.2096091131573e-05	1.2872125625239e-05	1.2974602763599e-05	-5.2136540648678e-05	1.2857292230253e-05	-5.2152697313561e-05
-10.846193004668	6.7846038961229e-05	-8.2284826815354e-05	-6.7988998549499e-05	8.2437062579446e-05	8.2320563509168e-05	-6.7824986080849e-05	-8.2474510069112e-05	6.7946965935167e-05	0.0023659849239066	-0.0020741893078567	-0.0023658601642258	0.0020740628878956	-0.0020741244424228	0.0023650753663592	0.0020742817710835	-0.0023652609449326
-10.999787840957	9.3551586720533e-05	-8.3143469281258e-05	-9.3591427880087e-05	8.3213394368635e-05	-8.3234433403e-05	9.3572692350026e-05	8.3171610562145e-05	-9.3517797800658e-05	0.0014664552883062	-0.0023336039761405	-0.0014664890814153	0.0023336232789528	0.0023335279199651	-0.0014669472634476	-0.0023336326984307	0.0014670546303215
-11.128400069131	-0.00047488901683231	-0.00059081853183278	-0.00047490211256677	-0.00059082013459775	-0.000590821949461	-0.00047489181418917	-0.00059081953581473	-0.00047489732533608	0.00015186765420219	-0.00023917913445432	0.00015220364657025	-0.00023890296964166	0.00023915236734595	-0.00015194095046422	0.0002389292965129	-0.00015212995678886
-11.282042867669	4.9837326027769e-05	-0.00015496769064042	5.0431971909168e-05	-0.00015465594776824	-0.00015496411895584	4.9848918052129e-05	-0.00015465098031705	5.0414278339969e-05	-0.0014567644478249	0.001332637213823	-0.0014672087577647	0.0013247322042681	-0.0013324191970743	0.0014571590557822	-0.0013249563604425	0.0014668199648471
-11.325612559923	0.00010228959301232	5.6724139416958e-05	-0.0001014993299004	-5.821656976066e-05	5.7157388272927e-05	0.0001022584820636	-5.7660602035915e-05	-0.00010204263896061	-0.00157946093432	-0.0011434462897732	0.0015664488709149	0.001155724436696	0.0011516306067014	0.0015846949486203	-0.0011579397264388	-0.0015775074252803
-11.521208850527	-0.00021135040256768	0.00019301176236031	0.00021137260791466	-0.00019306948191343	0.00019285433836129	-0.00021130569209347	-0.00019287391895201	0.00021135393050205	0.0009039654292729	-0.0010448717145064	-0.00090599954073413	0.0010469024868133	0.0010487778800402	-0.00090224819133203	-0.0010474622793168	0.00090094911070561
-11.635948238308	0.00011789225056608	-0.00017432678452959	-0.00011380978495829	0.00017039358098526	0.00017811034967156	-0.00011634277088021	-0.00017365900122085	0.00011173465982045	-0.0012025847391264	0.00032493638900187	0.0013082672772142	-0.00042983030822233	0.00035419345644728	-0.0011781757938849	-0.00045465378171376	0.0012794946325819
-11.665648492641	-1.3835116938204e-05	2.4457703332317e-05	-8.1311036133531e-05	7.5090511889715e-05	-3.9144741606345e-05	7.2678662300512e-06	-6.2704941836241e-05	9.0235728154313e-05	-0.0008774792418935	0.001428607628904	-0.001098403381209	0.00052543767313757	0.0013173743434093	-0.00097252182170641	0.00061752520704027	-0.00098466397368741
-11.682819009679	9.0785270454142e-05	-6.5402483475956e-05	8.610275176332e-06	-4.1822493673147e-05	5.0904833761434e-05	-9.7330177635432e-05	5.3728223325188e-05	0	0.0012185727960893	-0.00029450364315252	0.00062998913742008	-0.0015293441988404	-0.00040291694539493	0.0011266271280666	-0.0014421360449362	0.00074255889893798
-11.722103975181	8.9640079673546e-05	5.1357159044446e-05	-0.00010458404601572	-3.449483035542e-05	-4.2032974090982e-05	-8.5275187199076e-05	2.7031373737614e-05	9.8283589187677e-05	0.00076804665763802	0.0014261895554676	-0.00099120635608873	-0.0012073775529966	0.0014937527786632	0.00082568008961609	-0.0012602465615285	-0.0010629619161119
-11.996473615199	5.1477229246567e-05	-4.8547843456116e-05	5.2720679501066e-05	-4.7230114317838e-05	-4.8745573200172e-05	5.3539428553584e-05	-4.9569311141677e-05	5.2619052838169e-05	-0.00027739272913067	0.00030886183955678	-0.00026979733269248	0.00031797832703068	-0.00031012042191773	0.00025840431695591	-0.00029799740290845	0.00026894700855438
-12.11110425806	-0.00012442695007674	0.00011252963313526	-0.00012327143432039	0.00011377827811399	0.00011303716962763	-0.00012314052828725	0.00011237897353864	-0.00012388033119316	0.00054587384898284	-0.00067253380171704	0.00055093154025882	-0.00066621101414175	0.00066744746106063	-0.00055586097838978	0.00067706650898557	-0.00054719777476728
-12.166457901731	9.3696270684667e-05	0.00013106489395932	-9.3519690712632e-05	-0.00013135554460459	0.00013234295081139	9.42386938054e-05	-0.00013180282023431	-9.4688755263939e-05	-0.00079883180251892	-0.00071490195269244	0.00080221484286521	0.00071162347648721	0.00070560680042536	0.00079582636670597	-0.00070745178514218	-0.00079358862351408
-12.442680123554	-7.4414210548049e-05	-6.7138583622887e-05	6.9306697402619e-05	7.4717605108099e-05	6.4638235990321e-05	7.5077931946004e-05	-7.4902195181309e-05	-6.69793731282e-05	-0.00038770689967478	-0.00039679819228912	0.0003297160059777	0.00044847710042903	-0.00040932032945723	-0.00038946837356671	0.00044709799631362	0.00034047614940113
-12.469841014019	-6.4480187130342e-05	0.00010510663316679	-7.9682738633628e-05	9.0080330253914e-05	-0.00010491703343833	6.484820684179e-05	-9.0522841054959e-05	7.9597024257156e-05	-0.00054578615664922	0.0005241111593193	-0.00061811916850394	0.0004384774219603	0.00052497299756557	-0.00054371423798558	0.00043631455390226	-0.00061940717046235
-12.506824087098	-7.9285667253827e-05	8.5974492336554e-05	-6.0833951283079e-05	0.00010407030326547	-8.590749849783e-05	7.9028538040609e-05	-0.00010380532646353	6.072035668419e-05	-0.00060459284668778	0.00040454807020143	-0.00051712393094556	0.00050783641835035	0.00040492458671847	-0.00060561088241421	0.00050915140916593	-0.00051710364472139
-12.528167250951	8.0589216968081e-05	8.7150890215931e-05	-8.7684749907514e-05	-7.7175677826505e-05	-8.8281815943734e-05	-8.021896401344e-05	7.7016807739051e-05	8.8755587193202e-05	0.0003655429054265	0.0004958786646885	-0.00043000978709246	-0.00044221738682145	0.00049033612757608	0.00036493309358462	-0.00044322096887223	-0.0004255037797826
-13.351400383519	-4.944015604822e-06	3.6915686933858e-06	-4.9424908932335e-06	3.6941146562048e-06	-3.6939244114818e-06	4.9422099421352e-06	-3.6913269233006e-06	4.9439824825525e-06	0.00023368352734415	0.00024189659237546	0.00023367278777744	0.00024188740314216	0.00024188089323861	0.0002336593567018	0.00024188749731656	0.00023367664159626
-13.352351151541	5.0700242952083e-06	-3.835439822475e-06	5.0732472452299e-06	-3.8311710239684e-06	3.8327096895783e-06	-5.0721383375038e-06	3.8343885582674e-06	-5.0715142863151e-06	-0.00023277019209865	-0.00024231099456699	-0.00023277848775878	-0.00024231682820109	-0.00024232803372529	-0.00023279591691879	-0.00024231493050438	-0.0002327729484622
-13.742846303578	-2.7838372017228e-06	2.8299691288509e-06	-2.7843013389837e-06	2.8291409438811e-06	2.8300847406531e-06	-2.7839643572508e-06	2.8292386675286e-06	-2.7845262770529e-06	0.00022987092058508	0.00021145404168946	0.00022987416334744	0.00021145676584328	-0.00021145923496025	-0.00022987311298934	-0.00021146076648535	-0.00022987936098944
-13.743725197233	2.839156861551e-06	-2.862815675938e-06	2.8384154244101e-06	-2.8638900862373e-06	-2.862980282541e-06	2.8387486203333e-06	-2.8635391189073e-06	2.8384932380942e-06	-0.00022975706262426	-0.00021113028137715	-0.00022975462652636	-0.00021112849782678	0.00021112606292342	0.00022975557687239	0.00021112373068361	0.00022974870102507
0.4211849284624	-0.20451499796653	-0.16364053563289	0.20451499640289	0.16364053755868	0.16364053562964	0.20451499796481	-0.16364053755675	-0.20451499639973	0.19796045023799	0.235310375467	-0.19796044810376	-0.23531037725952	0.23531037547091	0.19796045024128	-0.2353103772616	-0.19796044810785
0.42118530237742	-0.0022641110735033	-0.0018117207248503	0.0022642251991962	0.0018115801455343	0.0018117209759006	0.002264111158388	-0.0018115802340348	-0.0022642254637288	0.0021915260035245	0.0026051671420557	-0.002191681854578	-0.0026050362207937	0.0026051668341648	0.0021915258108674	-0.0026050361273384	-0.0021916815442283
0.42598705254046	0.15072685625729	-0.1856587504945	0.15072685486044	-0.18565875165154	0.18565875062034	-0.15072685626931	0.185658751627	-0.15072685496376	-0.20550159417831	0.1725497007019	-0.20550159295275	0.17254970218084	0.17254970054234	-0.20550159421489	0.17254970218254	-0.2055015928097
0.42598711526542	0.069059905024495	-0.085064975940066	0.069059908986075	-0.085064972680862	0.085064975648218	-0.069059905011027	0.08506497274995	-0.069059908745975	-0.094156549036944	0.079058681920801	-0.094156552560696	0.079058677677858	0.079058682288667	-0.094156548935654	0.07905867765633	-0.094156552895628
0.75154137973654	-0.1545939448829	-0.20540896359526	0.1545939442372	0.20540896423996	-0.20540896388689	-0.15459394473317	0.2054089640151	0.15459394450012	-0.23449839312984	-0.19867707137926	0.23449839302898	0.19867707166927	0.19867707107946	0.23449839333442	-0.19867707183393	-0.2344983926932
0.75157294110242	0.0013557227881642	0.0018013951585014	-0.0013557492903421	-0.0018013640730522	0.001801365357896	0.0013557375606048	-0.001801387048952	-0.0013557218355366	0.0020564535696855	0.0017422965170244	-0.0020564302251452	-0.001742313656913	-0.0017423274455156	-0.0020564330507864	0.0017422973060194	0.0020564650486895
0.81367400682279	0.19920996386464	-0.17288934633376	0.19920996426331	-0.17288934579843	-0.17288934632062	0.19920996385828	-0.17288934578861	0.19920996425132	0.16016258911001	-0.24822840370245	0.16016258969397	-0.24822840320835	0.24822840371607	-0.16016258911849	0.24822840321489	-0.16016258970935
1.2400342308808	-0.011435210922719	-0.015906706216464	0.011435208852584	0.015906707523417	-0.015906705255657	-0.011435211570775	0.015906707703067	0.011435208640522	-0.01259297482061	-0.010676080938044	0.012592975401325	0.010676087614751	0.010676081705365	0.012592974403396	-0.010676087260379	-0.012592975918069
1.2819810851943	0.026551997009153	-0.050184156774755	-0.02655199695149	0.050184156701379	0.050184156852281	-0.026551996923162	-0.050184156781887	0.026551996869627	-0.0081237361597993	0.016082216774235	0.0081237360973858	-0.016082216715401	0.016082216719925	-0.0081237362330563	-0.016082216652658	0.0081237361699361
1.4110451647232	-0.072442695487465	0.05380547132728	0.072442695483425	-0.053805471317676	0.053805471339072	-0.072442695489367	-0.0538054713574	0.07244269550675	-0.013689902267891	-5.8169940487624e-06	0.013689902246428	5.8169405246081e-06	5.8169961172343e-06	0.013689902281985	-5.8169674315098e-06	-0.013689902238073
1.5189855765676	0.0086426795569526	-0.008735428684739	0.0086426793713659	-0.0087354288995838	-0.0087354286837203	0.0086426795542798	-0.0087354289019209	0.0086426793754364	0.37564834811464	0.28098102388256	0.37564834799422	0.28098102377547	-0.28098102387863	-0.37564834811052	-0.28098102377952	-0.37564834799626
1.6325604125246	-0.0045060322438137	-0.0039940485776291	0.0045060331366403	0.0039940474412619	0.0039940484559086	0.0045060319458993	-0.0039940473558085	-0.0045060327759409	-0.0050897728277674	-0.0062216259418683	0.0050897723451995	0.0062216270560393	-0.0062216260609445	-0.0050897730613817	0.0062216267772483	0.0050897719143074
1.8379917890838	0.2114861897697	-0.16731612991273	-0.2114861898229	0.1673161299294	-0.16731612984551	0.21148618973534	0.16731612989126	-0.21148618980799	-0.0037219197484289	0.012228730855392	0.0037219195024199	-0.01222873083399	-0.012228730768109	0.0037219197982589	0.012228730925918	-0.0037219194436419
1.8895501143256	0.0063253229037162	-0.0072237496990783	0.0063253228194728	-0.0072237495674169	0.0072237496315884	-0.0063253228533591	0.0072237496338279	-0.0063253228681723	-0.30358954054304	-0.35814878613113	-0.30358954054075	-0.3581487861404	-0.35814878613593	-0.30358954054523	-0.35814878613863	-0.30358954054481
2.0070983251791	-0.15970159683974	0.19771468794164	0.15970159705677	-0.19771468821541	-0.19771468805723	0.15970159690503	0.19771468832298	-0.15970159709511	0.0043315073957309	-0.0085047427892197	-0.0043315076334376	0.0085047427948586	-0.0085047428052538	0.0043315073352288	0.0085047427997574	-0.004331507692108
2.5307415874132	-0.17039297599564	0.20646655963936	-0.1703929711262	0.20646656288631	-0.20646656020973	0.17039297626526	-0.20646656267142	0.17039297114445	-0.017798424902781	-0.01545619229572	-0.017798425235327	-0.015456192773344	-0.015456192510636	-0.017798424970721	-0.015456192591396	-0.017798424853792
2.536430171951	0.19659353257929	0.16245682297473	-0.1965935360995	-0.16245681871545	-0.16245682300325	-0.19659353257176	0.16245681876695	0.19659353608959	0.0051653820633569	0.003430777292806	-0.0051653824825293	-0.0034307775827273	0.0034307772737641	0.0051653820052066	-0.0034307775617098	-0.0051653825016997
2.8551418799369	-0.20361600842978	0.16988412463153	-0.20361600264903	0.16988416099645	0.16988412651903	-0.20361601157226	0.16988415988881	-0.20361600099451	-0.0044790927836486	-0.012051409448511	-0.004479104175106	-0.012051420797752	0.012051407320173	0.0044790933374103	0.012051420677208	0.0044791062288234
2.92168887277	-0.15366874987314	-0.20697806735858	0.15366879946172	0.20697803480093	-0.20697806706293	-0.15366875058773	0.20697803357801	0.1536687999171	-0.00055889120637752	0.0050246663941726	0.00055891363033932	-0.0050246638519452	-0.0050246661484742	0.00055889265152466	0.0050246637680635	-0.00055891203099977
3.1545523184501	0.00089024472313892	-0.0027597660364555	0.00089029993808527	-0.0027597473431716	0.0027597479784196	-0.00088985995544625	0.0027597459908731	-0.00088994876519047	-0.011095267624704	-0.014134384939789	-0.011095320231077	-0.014134493548074	-0.014134286673559	-0.011095935448543	-0.014134379988261	-0.011095965970583
3.185320112995	0.0036822448282242	0.0042654441257201	0.0036799128765753	0.0042664522990839	0.0042658177504887	0.0036816954197968	0.0042657055737686	0.0036804460150679	0.030354945492283	-0.010707916601002	0.030353504081875	-0.010709876376293	0.01070829308059	-0.030354703287729	0.010710079520783	-0.030352950086957
3.2018709885235	0.0057925920648327	-0.0063841335642488	-0.0057905083770443	0.0063833017818781	0.0063831733538185	-0.0057899354735322	-0.0063839725962443	0.005792051433946	-0.0016410614347866	0.0015368651384477	0.0016395729728302	-0.0015355707415038	0.001534949517313	-0.0016400231774556	-0.001536249458443	0.0016416121592088
3.2506527767474	-0.019240387175572	-0.00081555165175936	-0.019216806069898	-0.00082065976477819	-0.00081293627256446	-0.01924053467029	-0.00082004541882985	-0.019215601103509	-0.007925424527338	-1.1291208055269e-05	-0.007903968850126	2.2866370813546e-05	1.0114448761643e-05	0.0079236937158578	-2.5230409440614e-05	0.0079025838227533
3.2799080880125	0.012464439418891	-0.030722202936237	0.012451950906203	-0.030721186262933	-0.030723326399578	0.012463930898132	-0.030722122075117	0.012451345829401	0.022568400240322	0.0054130642600938	0.022559386588669	0.0053842551143257	-0.0054117398756243	-0.022567950607317	-0.0053827687253543	-0.022558959996393
3.2866675280138	-0.0080929331328273	-0.013740228096923	-0.0080868642216343	-0.01373978071704	0.013737721902672	0.0080900883892367	0.013738066965655	0.0080965924563647	-0.0044000658609681	-0.019402792213088	-0.0043963726827436	-0.019383547188418	-0.0193836707409	-0.0043991742559158	-0.01940246973842	-0.0044026524704166
3.2895809634018	-0.006868625996888	-0.0013391542761787	0.0069522272854884	0.0013102976238758	-0.0013490203030385	-0.0068759316812893	0.0012997005579047	0.0069456398761263	-0.0030475464561041	-0.025046236246944	0.0031045313909452	0.025058787448829	0.025062942301278	0.0030487706199608	-0.025042249183685	-0.0031030258792416
3.3110926277419	0.051012609160091	-0.051666181214308	-0.051020336646012	0.051667703142893	-0.051666267851514	0.051012841143038	0.051667704781323	-0.051020196050328	0.083169588439706	-0.093515417649154	-0.083172403558455	0.0935170252989	0.093514959169874	-0.083169132109321	-0.093517467464867	0.083172820561179
3.3631584154748	0.0027449505814081	-0.014623481682923	0.0027365650688849	-0.014620059409618	0.014621356809422	-0.0027379841095471	0.014620159704055	-0.0027337102893701	-0.025378129280692	0.0083547938135749	-0.025377738281904	0.0083596645157058	0.0083643534338301	-0.025371762556725	0.0083708827610412	-0.025366123739691
3.3771279345528	0.011476813397851	-0.0071918956182115	0.011469638887455	-0.0071879430459391	-0.0071957149085746	0.011477638167934	-0.0071916170351834	0.011469528957678	-0.062261530310964	-0.056408251683813	-0.06227100742045	-0.056412995131778	0.056407318423448	0.062267457849453	0.056410793560119	0.062276534166303
3.4190756269841	0.019975609046228	-0.0080165375441099	-0.019981094642278	0.0080222841720496	0.0080143276543165	-0.019980266793201	-0.0080245076248077	0.019976434896701	-0.0090366491616053	-0.018478047213405	0.0090358568685533	0.018468023113208	-0.018471584043467	-0.009024733782441	0.018474494481156	0.0090478703474742
3.4337297968872	0.010573628314569	0.0048022710088185	0.010544820004356	0.004815738611017	0.0048020265672788	0.010563441809017	0.0048069327992985	0.010553842987023	0.02119037160919	0.010064241411191	0.021169007575088	0.010057047452505	-0.010073098224664	-0.021190222400842	-0.010049850339237	-0.021159765406576
3.5149471438697	0.028628427931372	-0.04167823099097	-0.028628403063546	0.041678115134589	0.041678247254189	-0.028628390741364	-0.041678085847782	0.028628429793031	0.10131208485416	-0.080635707401378	-0.10131222809094	0.080635739968653	-0.080635674186925	0.10131211455087	0.080635759888465	-0.10131222621863
3.543109379763	0.00011335880583215	0.0001670253160922	6.0189282538764e-05	0.00020544844100169	-0.00016384850194135	4.0933205036548e-05	-7.5687434419528e-05	-7.6444928975423e-05	-4.3889641815729e-05	-0.00014790106923789	-3.5614408729166e-05	-0.00018607477737694	6.7072007001649e-05	0.00022721801956224	5.0223372737116e-05	0.00022596044320639
3.5691817466149	-2.9184744100703e-05	-0.0016473642756684	9.0659174626402e-06	-0.001678531082792	-0.0016635892281813	-4.1199242506414e-05	-0.0016958273003215	-1.5962760713979e-06	0.014692460066569	0.010401700823959	0.014678378090855	0.010398952190881	-0.010409738804288	-0.014688104725053	-0.010406010408544	-0.014674010518206
3.5902386291271	-0.044057146756725	0.033289566935111	0.044100452115982	-0.03325826439381	0.033258930643478	-0.044102802009193	-0.033288917818606	0.04405466734123	0.0024743089598112	-0.0041502159938065	-0.0025082323389561	0.0041146217489042	0.0041301449597291	-0.0024849776598654	-0.0041348375175651	0.0024973348279987
3.5917141426044	-0.017561863258857	-0.010554923558786	-0.017444945903483	-0.010643766402144	0.010644218539059	0.017443988068922	0.010553372157739	0.017565614637881	0.0049036041259152	0.0072888153355671	0.0048996702553901	0.0073025426448764	0.0072916628548634	0.0048846209972301	0.0072819285447975	0.0048920975011047
3.6025720520049	-0.00065754110230866	-9.2797208819129e-06	-0.00059386339533224	-6.1781759384498e-05	6.0755176054338e-05	0.00058386665084385	4.7963875208855e-06	0.00066320196420747	0.00036433154114646	8.4528725263649e-05	0.00036872646127747	9.8451748374641e-05	0.0001004699492501	0.00037258494102468	0.00010221075712048	0.00038539843971577
3.6330506885614	0.005292377204741	-0.0057696502886161	0.0053063793880975	-0.0057825590970285	0.005786846168155	-0.0053130214390906	0.0057656960449188	-0.0052805800148403	-0.0048947868072206	0.0027417147005764	-0.0048862913848077	0.0027536106085938	0.0027375465650142	-0.0049053473462648	0.0027421693534095	-0.004900238532388
3.7723917338741	-0.0017373231805627	-0.0026658162489493	-0.0017309724356856	-0.0026708350649441	0.0026715915716463	0.0017301633775063	0.0026653635189162	0.0017386444680025	-0.062246588687951	-0.070454351763513	-0.062245568031655	-0.07045265969522	-0.070454177026026	-0.062247037002285	-0.070453859471073	-0.062246544933564
3.797604957458	0.2955737500086	-0.22925389786697	-0.29557436789854	0.22925314780638	-0.22925362061402	0.29557379429615	0.22925338185628	-0.29557430604987	-0.0060697612308495	0.013617059347273	0.0060667027642918	-0.013619893336627	-0.013618673836966	0.0060682929058553	0.013618244384284	-0.0060682069798558
4.0233393927643	-0.0068618015521975	-0.010824917166042	-0.0068574684233127	-0.010831829521979	-0.010821173360827	-0.0068637558985898	-0.010832735415043	-0.0068543805675453	-0.012027413748696	-0.023044823890826	-0.012037899420746	-0.023052425756076	0.023041096340733	0.01202357701147	0.023052101526943	0.012036680943116
4.040950501958	0.00026043096692506	-0.00013133795678284	-0.00022321027173726	0.00023171518390776	0.00014697754395239	-0.00027871019551981	-0.00024134296180955	0.0002330040188816	-0.00012692938726394	-0.00023301212597688	0.00032508143763051	0.00035945750022197	-0.0002430859687477	-0.00012487746565197	0.00035774963049981	0.00033784473191173
4.057962708572	-0.048112257753377	0.032437594157271	0.048111714993939	-0.032438268995995	-0.032437734452226	0.048112001223644	0.032437939025958	-0.04811176769329	0.055757747891636	0.072976222668051	-0.055757863908209	-0.072978697821964	0.072976721792662	0.055757943167843	-0.072978138579562	-0.055757584000499
4.0983478567508	0.00020468821394733	-9.6539064438795e-05	-0.00010941330151684	0.00028112807941264	6.5990675203097e-05	-0.00023565464637088	-0.00034414320379069	0.00010133506095522	0.0002105238980106	0.00013470071020118	0.00017340651070382	7.8143912960096e-05	0.0002271460550136	0.00020732422542966	0.00020450621884206	0.00021201878603671
4.1081718912976	-0.25468657289873	0.30487537050585	0.25468654047042	-0.30487540276272	-0.30487547507898	0.25468653765701	0.30487533058451	-0.25468657747979	-0.0027454552048845	-0.018861288174787	0.0027456035881767	0.018861024289441	-0.018861038250015	-0.0027453850820525	0.018861202055112	0.002745586136279
4.1504100586086	-0.0057265307825955	0.01766763328491	-0.0057242433011333	0.017665830401539	-0.017668834696159	0.0057267240605661	-0.017665491267328	0.0057239722782469	0.068046193560857	-0.043608334431443	0.068046323278077	-0.043608819748217	-0.043605894358278	0.068047558366122	-0.043608987616877	0.068044512270798
4.2004357037826	-0.011722889101631	0.0012857656522873	-0.0117290103302	0.0012903757023395	-0.0012827158334295	0.011722450168512	-0.0012913618079194	0.011728911772462	0.027409389628982	-0.04543345029832	0.02740868236886	-0.045432430725154	-0.045440745004698	0.027406135196086	-0.04543168993615	0.027415121388767
4.2167709863275	4.5426456788133e-05	-4.2609092385248e-05	2.8120715979028e-06	-1.8488898349083e-05	4.1220947023725e-05	-2.0988956034135e-05	-2.1220890727881e-05	2.1917612283385e-05	-3.2192259862435e-05	9.2055372901894e-06	-4.0286995878583e-05	1.9450809307031e-05	6.1865878322227e-05	-0.00016187163169208	0.000152339144122	-7.3703803012707e-05
4.2394770567266	0.019058439970184	-0.013392627558874	0.01905868426505	-0.013390906785065	-0.013392453277484	0.019058711901949	-0.013390979585268	0.019059159177954	0.067573156891066	-0.073940482009536	0.067577813974083	-0.073936583513713	0.073939265491247	-0.067572655375518	0.073935341633324	-0.067577312444816
4.325065125347	-0.000124450608288	6.0670511666126e-05	-0.00012337369156808	-6.0400365288281e-05	1.8779991552175e-06	0.00014916140298146	-1.4168506597318e-05	6.360842097113e-05	0.0002730045422906	-0.00022610993605067	2.348678418503e-05	-0.00044055618883747	-0.00043217960652271	7.5732449464306e-05	-0.00024815718521019	0.00029336776159166
4.3505303751462	0.016491404221764	0.01992588368787	-0.016487943610446	-0.019925046543838	0.019925555649291	0.016490487082843	-0.01992488039498	-0.016489261593421	0.073356231769565	0.062738039321286	-0.073352407203326	-0.062736486774242	-0.062735020150094	-0.073357598093549	0.062739645222183	0.073351088798154
4.460709716754	2.2359022807121e-05	2.2124896012965e-06	3.4053925113222e-05	-3.2121643153087e-05	4.9859265244814e-06	-1.2759285550258e-05	2.7076113380002e-05	-4.1884479204441e-05	-4.0959780180258e-05	0.00010030791597092	-8.3215978047182e-05	5.9611803995485e-05	7.4026616279749e-05	-6.6513240402117e-05	7.8250325225008e-05	-5.7377077735435e-05
4.7163594328584	-9.3175946118806e-05	6.0372358572073e-05	-4.1999239330153e-05	-1.2756881841563e-05	-6.8797008637834e-05	7.1531429930221e-05	8.5679408014477e-06	3.096100709065e-05	0.00011057951851042	-0.00013272512511968	8.840159655137e-05	-0.00015116621747362	-0.00011375786445946	0.00012830584465385	-0.00014436964040264	9.0681597509295e-05
5.0581591149791	1.6661979661782e-06	4.7152384796369e-05	8.354291745335e-05	-0.00012848864561261	-4.5972537725722e-05	2.3924379914704e-06	0.00012694422586279	-9.3674025688187e-05	-0.00012839555044637	0.00017778212451987	-0.00019769309205834	0.00013722462646986	0.00015729482175672	-0.0001226998334434	0.00012944308049372	-0.00018307260389092
5.2570837638039	0.0070810687096727	0.0066462057298396	-0.0070800847566694	-0.0066378762800384	0.0066491830692289	0.0070783535929619	-0.0066440482982575	-0.0070786378148278	0.004002211731385	-0.0054766835250277	-0.0040109532649188	0.0054878525222872	0.005480009571772	-0.0040101119029447	-0.0054804758691963	0.004008621941053
5.2726197093662	0.0036021919802348	-0.0034906695573746	0.0035120455161192	-0.0034946750456507	-0.0034404682356304	0.0035760711233976	-0.0035251016275302	0.0035371007591584	0.0026081184995467	-0.0029088597236409	0.002597237021093	-0.0029186492770017	0.0028513807050919	-0.0025552001035645	0.0028536974079184	-0.0025264417293073
5.2807090331402	0.0030798376399364	-0.0011172352853676	-0.00308296453432	0.0011135643713568	0.0011240545171207	-0.0030735937826555	-0.0011188182388021	0.003070695108162	0.0071266880942621	0.0099307922371273	-0.0071138008228781	-0.0099439793359241	0.0099287241499303	0.0071253679849976	-0.0099439440448401	-0.0071101491124586
5.3057289606704	0.0056444916429414	-0.0087443038399324	-0.0057582336657682	0.0092589760883165	0.0088200886176458	-0.0056309677259659	-0.0092305502174597	0.0057335127946984	-0.0032119102539964	0.00076496847737131	0.002009656968311	0.00045344417676644	0.0007408795445812	-0.0032016135088138	0.00045365866798964	0.0020260901122697
5.3153459273523	-0.0015540123224401	0.0027176880620584	-0.00036385370748783	0.0010432569489043	-0.0028532252772614	0.0015017000923816	-0.0010706752026168	0.0004823983389219	-0.0054435607309976	0.005709653234949	-0.0059451787317846	0.0057434153922142	0.0057547630498391	-0.0054643412306811	0.0057648269255972	-0.0059882036810541
5.3242080103758	0.082178921359448	0.10209468504083	0.08219138994184	0.1020983683421	0.10209131708308	0.082181459572849	0.10210186308718	0.082189476663367	-0.002731643868114	0.00082365373965478	-0.002731673163298	0.00082518286580365	-0.00082243592363914	0.0027315623152862	-0.00082398663227761	0.002729443477661
5.3451072567423	0.0004308032165565	0.0065303296922107	0.00088269826790866	0.00630503901304	-0.0066565518454633	-0.00063218283506912	-0.0061434889508805	-0.00067645453415266	-0.0033812934839568	0.0038493481969013	-0.0034851666200823	0.0038812474123363	0.0038783302930468	-0.0033781428778024	0.0038676699361633	-0.0034932970012207
5.3665544326513	0.023687602475985	0.018292953440926	-0.023790215587318	-0.018082430796689	0.018194175741445	0.023706497534365	-0.018138603613753	-0.023796578473101	-0.0012531892932459	0.0013583529813146	0.0011842319079828	-0.0013124825273325	-0.0013109772237405	0.001206539374839	0.001369559683086	-0.0012362270425883
5.4018877531134	-0.0084702691956135	0.00023541494744979	-0.0084502035705715	0.00021587459946317	-0.00022769028704163	0.0084628261046562	-0.00020718161256172	0.0084506364766642	-0.0024765970727703	-0.00066165640572029	-0.0024835144048988	-0.00066087110686206	-0.00065577269164747	-0.0024793238376432	-0.00065470717881819	-0.0024850804310222
5.4309663753631	-0.014799576002986	0.0078797147866063	-0.014470470496866	0.0081686087344307	0.007862937518039	-0.014786058461958	0.008191771953823	-0.014483445477846	-0.00024570353890699	9.5441493351936e-06	-0.00035366335004637	-3.7868945084552e-05	-9.3485222135394e-06	0.00024974816261605	4.4128397933778e-05	0.00034926596097587
5.4905448487126	-0.022930082146983	0.021147790582846	0.022915512988183	-0.021249890232069	-0.021120908406123	0.022892881584228	0.021227939994016	-0.022927298426777	0.0052476529837548	-0.0036699049876412	-0.0052333969552878	0.0036631912182025	-0.0036749717322385	0.0052501120905154	0.0036497069589137	-0.0052353677177948
5.5021383454507	-0.011564574724234	-0.028133406462369	0.011568829998162	0.028141199522415	0.028136971068409	0.011567839330798	-0.028142892111732	-0.01157415828986	-0.0024794797600967	0.0023884008666891	0.002479289298953	-0.002387797907017	0.0023900741288979	-0.0024773566878005	-0.0023890488234331	0.0024766960916673
5.5130228306905	-0.0081020493061227	0.0023145124084496	-0.008300323752767	0.002058166439335	0.0023232160909331	-0.0081100199849523	0.0019269528136368	-0.0081545751377987	0.00042625609199481	0.0029917800122713	0.0005918977294514	0.003102046542697	-0.0029739644664338	-0.00044963561701184	-0.0031114036784641	-0.00058630679437885
5.5253526145578	-0.10454633306311	-0.08249076094151	-0.10455402582009	-0.082483821506111	0.082491818390468	0.1045482778949	0.082481534696122	0.10455544774747	0.0014341071447683	0.00042097593368509	0.0014362731988879	0.00042013778429133	0.00042199259190242	0.0014350791719002	0.00041989514347683	0.0014358584717167
5.5618423881287	0.012038958355649	-0.017643314015378	0.012192948121881	-0.017820962667756	0.017701956858623	-0.012121925934579	0.017792497596071	-0.012193575371843	-0.00027188839467697	0.00064870155688267	-0.00027758442684996	0.00067053081579934	0.00065371364288807	-0.00029626009996082	0.00065839611355384	-0.00029277875675779
5.5768936866485	0.033568613147202	-0.037715753190215	-0.033637747762474	0.037783853237291	-0.037825973446833	0.033658502195331	0.037745856936766	-0.033603905718222	-0.002533152469134	0.0084860213615042	0.0025325835889955	-0.0084620726833261	-0.0084832868369808	0.0025215131911413	0.0084572086037985	-0.0025186658831358
5.5954490869897	-0.0057183444993671	0.00013884904047193	0.0061926855600407	-0.00074774087569784	-0.000497575820784	0.0061559146840397	0.0010992233484361	-0.0066206750778218	0.0051292340529103	-0.0041468511180971	-0.0051815826926468	0.004188320260398	-0.0041864263259186	0.0052369588307206	0.0042423517476213	-0.0052809572969263
5.6084990357235	-0.0045991414555927	0.0036406270764505	0.0012547020201037	0.00064302951251816	-0.0018882771273117	0.0018183204374093	-0.0023560809985939	0.0014907465658406	0.0014727085881323	-0.00089921538694639	-0.00099012708837739	0.00051935539409229	-0.00095892174982964	0.00043696520179845	0.00047177645227891	-2.0836878597295e-05
5.6576213828213	0.015229264459328	-0.00080232784059336	-0.015302318992029	0.00083673073310455	-0.00080749833525973	0.015295166370677	0.00089585608383639	-0.015347196227975	-0.01318735440871	-0.0070588680629889	0.013336474956486	0.0068835306002945	0.0069845141539624	0.013266751176386	-0.0069169374876856	-0.013289745468187
5.6773783213466	-0.0044923292575289	0.0080122543380836	-0.0046733094896596	0.0079413915774725	-0.0079675382185402	0.004735578641671	-0.0080050385353828	0.0044603369862061	-0.0019998254171046	0.0013591964219169	-0.001739147326867	0.0015466894780163	0.0014908857429354	-0.0016846150184568	0.001336886207529	-0.0019649701957589
5.6826326950497	0.0039245446253159	-0.0039007067775888	0.0038328585209039	-0.0039008655753697	-0.0038529997171774	0.0038944579018234	-0.0038529732305825	0.0038016999182953	-0.011970418508342	0.010894970133747	-0.011875797976833	0.010948473068507	-0.010897987276001	0.011974944531567	-0.010951123546134	0.011880182491263
5.714368463976	-0.0048406696417154	0.0044463892155359	0.0049986611340878	-0.0046731613143774	0.0046737010400061	-0.00499644194266	-0.0044416506538313	0.0048303290674796	0.0015698882144779	-0.00086866833813827	-0.0015888960721082	0.00088426852336534	0.00088148726488451	-0.0015818285633592	-0.00086705479434849	0.0015746729283445
5.7479771958765	0.0015299592649824	0.0013964628749799	0.0015220242022373	0.0013952308469943	0.0014399594842365	0.0015008824441332	0.0014389448152128	0.0014902723145706	-0.00030009393510212	0.00031584361992031	-0.00028573313729602	0.00032550578407272	-0.00031338841284056	0.00029769448405241	-0.00032213617640728	0.00028304845831398
6.0596371122636	0.012814064997139	-0.018259888873319	0.012994382919283	-0.018181194944263	0.01825006824559	-0.012627717171792	0.01802998256346	-0.01297334310103	0.00084399696654243	-0.00030350782801087	0.00070108648763061	-0.00037237043697682	-0.00043964853974306	0.00070236442228419	-0.0002716446773253	0.00084317349343098
6.0719658315077	-0.054273539205784	0.076988192835361	-0.054252801566715	0.07698975826859	-0.076980483391682	0.054321203641721	-0.077032878021235	0.054250732192118	-0.004261068539414	0.0023423028438524	-0.0043018612365346	0.0023178354460782	0.0023052514146238	-0.0043007116528584	0.0023458152844592	-0.0042605466701124
6.2148801947395	-0.072738790313442	-0.061071385610946	0.07274207131695	0.061065242431293	0.06106662604779	0.072731871789777	-0.061057746824771	-0.07273867867754	-0.00032370984442207	-0.0016554849836249	0.00032568165442308	0.0016538460682981	-0.0016553184868942	-0.00032376037267891	0.0016540724432068	0.00032560105121542
6.2243347139323	-0.068475007909304	-0.079258188695198	0.068486457015688	0.079250059171622	-0.079266491292144	-0.068480732684402	0.079253952294574	0.068495200890566	0.0045046630245799	0.0028686203212619	-0.0045054723879333	-0.0028667277539428	-0.0028681745070411	-0.004505165391348	0.0028670502880484	0.004505050615607
6.2435860168158	0.0016608365923361	-0.0012465173494706	0.00060408417069899	-0.0022776449960382	0.0017855047957469	-0.0015203783647958	0.0020472865792773	-0.001131239007889	0.00051632263686007	-0.00045760769130176	0.00058074569041931	-0.00039489442615656	-0.00039483714986969	0.00057272367257938	-0.0004222263012501	0.0005118403784515
6.371067225631	-0.076529338330613	0.063327695228346	-0.076510988297216	0.063350210997314	0.063326755016417	-0.076529019290526	0.063349689939658	-0.076510279609307	0.0017542911963939	-0.0029960385290908	0.0017381340523569	-0.0030089609678283	0.0029962670460835	-0.0017546408785959	0.0030092820506777	-0.0017384980810037
6.3989425965738	-7.4267160718606e-06	-0.00014293226969299	0.00017645372248513	8.6600852759147e-05	-0.00021027202228926	0.00017270446721793	-0.00018489654114612	0.00020321730541313	4.2378712834038e-06	0.00010999449948797	-0.00011712065782511	-2.1380233870365e-05	2.3261668199792e-05	-9.8185666645465e-05	5.6388786935693e-05	-6.9321700022315e-06
6.49650615384	-0.0067217942743401	0.012156070290737	-0.00670698195155	0.012170118146213	-0.012107590546918	0.0066265253039432	-0.012079690962698	0.0066391506629759	-0.011330018558287	0.0088559714019981	-0.011341215559627	0.0088551163392997	0.0088340650518316	-0.011347903241731	0.0088695279423144	-0.011321557638971
6.5217807147937	0.0021138076374544	-0.0042898502995468	0.0022433825339203	-0.0041089961275747	0.0042573311403998	-0.0024284484601617	0.0044457327146673	-0.0022839452880449	0.0045000033057164	-0.0033400041748349	0.004298736637239	-0.0035121469039419	-0.0035269841231061	0.0043089954664516	-0.0033599615318594	0.0045063291599076
6.6006895989213	-0.016764159960574	-0.012373613909584	0.016767087067874	0.01236796938328	0.012372706743392	0.016764794428478	-0.012368324879735	-0.016766351645674	-0.007513595716944	-0.010948313626831	0.0075207989287036	0.010942647749153	-0.010948489838654	-0.0075138765324976	0.010943290294869	0.00752076545779
6.6350945274615	7.9470051709172e-06	0.00024047052670519	-0.00016858082447329	0.00020857395919049	-0.00054232910944564	-0.00018071419710252	4.941006604798e-05	0.00039218037156515	-0.00010957669562407	0.00053762682585758	-0.00062396300921831	2.7132560046075e-05	0.00022108927269018	-0.00048382175354624	0.00037020978970939	-0.00026879738752707
6.6831085248104	0.0056479738808225	0.0078834695500253	-0.0056744164272544	-0.007870435606073	0.0078968263926134	0.0056350654754248	-0.007845986387258	-0.0056730765140906	-0.010988326114199	-0.010197765761665	0.010985340036915	0.01023003244372	0.010172615172884	0.011028258397721	-0.010262175600242	-0.010949870286413
6.775271782453	0.014059141978064	-0.012065153086188	0.014091672357734	-0.012023135758316	-0.012065701420546	0.014059421718523	-0.012024270178926	0.014091322522732	-0.0081153458199469	0.010116252507796	-0.0081749886216909	0.010036429567809	-0.010114409960991	0.0081128085122803	-0.010034582317171	0.0081726786382789
6.8130404231758	-0.00099378209730492	0.0045337955165096	0.00097691080826691	-0.0045195958756263	0.0045337365547597	-0.00099426413090471	-0.004518553921435	0.00097754282641376	-0.013085606643884	0.017661011221438	0.01309451002135	-0.017670545393886	-0.017662225602761	0.013087546391239	0.017669142148259	-0.013092936969304
6.9256364320446	-3.8091847095319e-06	-7.5498640537118e-05	0.000100626527848	-1.3690777418372e-05	0.00012079526478318	0.00017143197007428	-0.00020642127996098	-7.1758432617432e-05	-0.0001761192290263	-4.8422834824086e-05	0.00014998383546708	7.0193093649483e-05	7.2411835287665e-05	9.0021209912585e-05	-0.00010210814463567	-6.0207306571713e-05
7.1522711687808	0.0018956332472608	-0.0013438341383172	-0.0018993288811618	0.0013445402015278	0.0013454014563581	-0.0018956109654757	-0.0013446341931308	0.0018976459797853	0.01822114854338	-0.015432295051247	-0.018215190932606	0.015428371489552	-0.015429892503333	0.018223604594785	0.015426161117929	-0.018218001425186
7.1690435933789	-8.5031413119988e-05	0.00016579957805677	-0.00015118905668326	-3.9984289968588e-05	2.5969851507439e-06	-3.1668657447096e-06	0.00012358987729652	-1.7016228111939e-05	-0.00024516698589903	0.00012196226121431	0.00048442166350593	-0.00027346695879103	0.00025191189036872	-0.00013766465007491	-0.000372285321344	0.00032204477370824
7.2779306529656	0.00056365487430885	0.00085487745762765	-0.00056342752235232	-0.00085297680560843	0.00085589641025726	0.00056311372456608	-0.00085438007065265	-0.00056550164542538	0.00045783793127759	0.00039988391135088	-0.00045907575981325	-0.00039915414140875	-0.00039955279289502	-0.00045872123698377	0.00040055872029815	0.00045700017408386
7.3159594856952	-0.015833541253577	-0.022844581024282	-0.015836510792937	-0.022848788430123	-0.022845375752461	-0.015834349563181	-0.022848159478428	-0.015836576828542	0.0002847903953924	-0.0007652123384356	0.00029575161926704	-0.00075614022119804	0.00076574113344533	-0.00028560214581264	0.00075612634021608	-0.00029589633727284
7.3764563181467	0.0004854159146125	0.0036200877368722	-0.00043452305056018	-0.0036284208871374	-0.0036411083918678	-0.0004536092448912	0.003614402593662	0.00046742115208674	-0.00091477326692431	0.00073011798678814	0.0008973419705515	-0.00072477821023765	0.00072105629853325	-0.00091801078993728	-0.00071845294871497	0.00091188339845323
7.4148158635992	0.0093840696324536	0.0074743751395106	0.0093700261553392	0.0075133109211808	-0.0077644625197598	-0.0089162916020747	-0.0077928910871504	-0.0088972486110271	-0.0028584407036009	-0.0008277462377854	-0.0028768860338329	-0.00083882354825508	-0.00084976775626175	-0.0027825995674583	-0.00083221124473875	-0.002771116601934
7.4294485961717	-0.0088486163271588	0.0060596820166711	-0.008656906637628	0.0061591309237155	0.0050683731579322	-0.0098083666456179	0.0051858329553751	-0.0096669564322508	0.0020630591248158	0.00012202090520814	0.0014771351103971	-0.00042675613094597	-0.00033715088077927	-0.0022250609136189	0.00021366475466634	-0.0016447905964383
7.4428157263744	-0.0031766470410062	-0.0017903917308644	-0.0031581340610045	-0.0016228698222197	0.0030140956355895	0.00073014804138326	0.0031072441213708	0.0010857444498486	0.00062368088184061	0.0010428588696644	-4.9488043297094e-05	0.0003735985710871	0.00036322716223002	-0.00054108629965216	0.0010157785134386	0.00017279213179932
7.4713147724186	0.00031924191602573	0.00032586708741975	-0.0023768237502898	0.00011619402485273	0.00087451895001087	0.00066513201861295	0.00067365627789668	-0.0020017359596636	-0.0030959069227553	-0.0029669205115239	0.0033818571085022	0.0032375811488267	0.0031756288119699	0.0029909329294478	-0.0030325770818549	-0.00347823118737
7.5058450540185	-0.0023603423163379	0.0016792134554815	0.0018272878070123	-0.0018179362708944	0.0019871360559914	-0.0021727076688984	-0.0015118587721612	0.0020122375738197	7.1170655798892e-05	-0.0003057824764043	-5.9276410405405e-05	0.00045106964573282	0.00041279774675776	-0.00015622517474835	-0.00034412846373274	-2.5366953012287e-05
7.5278711720597	0.019679757419537	0.016991931317595	0.019663878174712	0.016953063190685	-0.016971467069439	-0.019710231993078	-0.016967021281942	-0.019669682622705	0.00093660655523926	-0.00021284709429986	0.00096472476274858	-0.00018715817742422	-0.00018985649821832	0.00095096269505113	-0.00022008117490916	0.00093594765338601
7.5488308515984	0.0057753266702162	-0.0034639379438869	0.0058678598011574	-0.0033548195394316	0.0034715191618004	-0.0057192862544583	0.0034039689280531	-0.0058355099841626	-0.0045137080797403	0.0052244795099078	-0.0045755992853149	0.0051816098845969	0.0052069829054466	-0.0045184750885756	0.0052635984134498	-0.0045049313726007
7.5604693545537	-0.00123792605899	-0.0045205719327483	-0.0012414015512592	-0.0045077166572597	-0.004475070085677	-0.0012779432380308	-0.0044588441594735	-0.0012789182284929	0.0025084755092546	0.0030018354449123	0.0024605507760867	0.0029418796355905	-0.0029531897782885	-0.0025531678356833	-0.0028934164437167	-0.0025045085952954
7.6141174960752	0.011958894069701	0.011795154360042	-0.0119361554058	-0.011846984699646	-0.011792387688855	-0.011960772256401	0.011847985161224	0.011935744393366	-0.0026524861176372	0.00014687325328781	0.002612007139702	-0.00010827314989335	0.00014978207459025	-0.002651619930502	-0.00011019494569067	0.0026114981980346
7.6751596226954	-0.0036906701107902	-0.0035632516906412	0.0036999606485378	0.003544247220383	0.0035634169980681	0.0036904967159169	-0.0035435053440501	-0.0037002699965844	0.00082682993600244	0.00021765171731679	-0.00084083070137692	-0.00020519073438604	0.00022520919244282	0.00082853046249295	-0.00021249958195556	-0.00084240816687421
7.7476738620208	0.00050019233065876	-0.0011621299898905	-0.00047203840152276	0.0011308395359512	-0.0011534301291159	0.00049797251671131	0.0011356459547009	-0.00047673881806162	0.0028896414899488	-0.0028381980146941	-0.002895999725247	0.0028445796488334	0.0028419987008495	-0.0028938809101666	-0.0028409043562923	0.0028913436792928
7.7715309777625	3.5023729036246e-06	0.00026470144953238	-0.00022339707866642	5.6209312497779e-05	-0.00017833542496245	-0.00010477923838739	9.2666834588583e-05	8.2810890950939e-05	7.8478623343041e-05	-9.2437766265218e-05	5.809933029559e-05	-2.3257977793723e-05	-3.9477542692519e-05	1.9365633231589e-05	-5.265193618725e-05	9.7531148519456e-05
8.1104704510677	-5.1081135092588e-05	0.00012413574687773	2.9824280535599e-05	-0.00010262249686929	-0.0001196468371192	5.4184809763079e-05	9.036781777081e-05	-2.4972504822371e-05	-0.00027557810878225	0.00024798285971807	0.00028313608530507	-0.00025489750107046	0.00024459692417173	-0.00028007538214948	-0.00025154536573176	0.00028871172455013
8.1129190191891	-0.00034013966349356	0.0012868172895961	0.00034255640965735	-0.0012895765711772	-0.001286323940376	0.00033900979053578	0.0012913468198066	-0.00034377128016931	-0.0030377676070311	0.0026411045579909	0.0030366463970331	-0.0026401476371124	0.0026414008060161	-0.003037456099973	-0.0026403426837623	0.003036109475256
8.468625018271	7.805921058578e-05	6.3248756613469e-05	-9.7881370849044e-05	-2.3332474474037e-05	-0.00013633436314477	-6.8445121265185e-05	4.1061293190557e-05	0.00015281816527332	1.1932096767511e-05	1.1864125595554e-05	-1.5801680513663e-05	-1.0067461037301e-05	1.3572114792245e-05	2.0729165937645e-05	-1.4937169685464e-05	-1.9242970056093e-05
8.4983924491557	0.010420602280823	0.0084936162249583	-0.010424027157166	-0.0084895780729081	-0.0084926759578556	-0.010421942024506	0.008490669493396	0.010423043939514	0.00075726024981856	0.001056451888048	-0.00075730434938853	-0.0010564769218428	0.0010565319337189	0.0007572098187347	-0.0010563998802584	-0.00075740723921687
8.5428345786905	0.00053365223813855	-0.00038958740450733	0.00023577668403861	-0.00067475879184773	0.00038311563187572	-0.00047468240080899	0.00062509241963255	-0.00022794831158323	3.3103494404939e-05	-8.8875776626105e-06	3.9268352343562e-05	-2.6855541268413e-05	-1.2219868396233e-05	3.2894606375908e-05	-2.8984902768096e-05	4.3113651455138e-05
8.61148972444	0.0046735471614796	-0.0073619610402772	0.0046911996967293	-0.007342200766432	0.0073492386414005	-0.0046681937505265	0.0073384115968933	-0.0046775901155421	0.00088288298087076	-0.00044166321708882	0.00088131355882955	-0.0004415429407356	-0.0004425226705812	0.00088352274367157	-0.00044222679129048	0.00088187112004663
8.6589971846843	-0.00026374125246844	0.00052196720677129	-0.00042799146067211	0.00029402708617817	-3.7707545537959e-05	-0.00012593403661296	-1.159596712002e-05	-8.2687181574696e-05	-3.1238273894166e-05	-8.3640334540998e-06	-1.0328596468245e-05	-3.8039362457782e-06	3.71978727581e-05	-5.0404273961776e-05	3.5741244662778e-05	-3.7070865177696e-05
8.6746789350907	0.010464680275248	-0.0090454050070231	0.010480696221627	-0.0089567163863161	-0.0090686129235805	0.010472016832507	-0.0089722160712781	0.010494844899289	-0.00046673309911207	0.0010788394294038	-0.0004701166369641	0.0010764818183786	-0.0010775436516522	0.00046299054180401	-0.0010749439500133	0.00046765213360461
8.7545079240758	0.0033736467097059	-0.0048787886811223	-0.0034626393292299	0.0049751327693456	-0.0048789525911242	0.0033738796364725	0.0049739838344126	-0.003462243775144	0.00015378640574976	8.1866660802434e-05	-0.00015710255114823	-9.9247108194198e-05	-8.1866067399469e-05	-0.00015408690166371	9.9325889676811e-05	0.00015701081026245
8.7789841052463	0.0061979946870791	0.0059875236599158	-0.0061323203212729	-0.0060898831661006	0.0059931438474681	0.0061965348496436	-0.0060834457273251	-0.0061344857321607	-0.00078065781932734	-0.00049365450941219	0.0007920942104273	0.00051436890275133	0.00049334725938637	0.00078219093128513	-0.00051480535714722	-0.0007908740188185
8.8013920624741	9.072661076986e-05	0.00023485175474389	-0.00010771740691035	-0.00012355007507948	0.00017062257051511	0.00011163923317495	-0.00021309236487674	-9.9558064337269e-05	-3.2922133544073e-05	-1.5737791902765e-05	7.2680852793403e-06	1.0343039604921e-05	2.0377641956218e-05	1.7484461900765e-05	-6.8398615775971e-06	-2.6216211129612e-05
8.8247985299129	-0.0046406425581961	-0.0030531868187634	-0.0046061782764972	-0.0029791250868647	-0.0030504494149484	-0.0046405560251321	-0.0029773085109721	-0.0046070410811524	0.0018522847811335	0.001206697482977	0.0018436707452576	0.0012012331703438	-0.0012067484725735	-0.0018516265374734	-0.0012013943581512	-0.0018432437911315
8.9657640852517	-0.0068544484302157	-0.0052443807943752	-0.0068556025560002	-0.0052492653344973	0.0052466169717463	0.006859518187803	0.0052459480023396	0.0068610348191739	0.001067376824674	0.0012806142249538	0.0010680585349525	0.0012810652250657	0.0012804769097922	0.0010682007996707	0.0012805243779208	0.0010683562322763
9.1280511370077	0.0029968242657372	-0.0031608243422474	-0.0029955685479186	0.0031601594200186	0.0031668958257452	-0.0029973761802242	-0.0031676310056736	0.0029937783104555	-1.6450999496598e-05	-0.00013789199591712	1.6775810298756e-05	0.00013720866867156	-0.00013719527899682	-1.5596445409807e-05	0.00013678110731023	1.5841696841341e-05
9.2119352258343	-0.0080200354097866	-0.011261432272414	-0.0080134293926622	-0.011321781637676	-0.011263838744845	-0.008008675530633	-0.011319377908746	-0.0079998475745375	-0.00059963604730371	-0.001006603804163	-0.00059289114738976	-0.0010021499735694	0.0010088730961799	0.00059701543915645	0.0010052392597973	0.0005913499910342
9.2780731310632	0.0030082370925985	-0.0044083063752988	-0.0031782813566931	0.004245856915796	-0.0043763791864598	0.0031199089677391	0.0042937000098504	-0.0030449736223311	0.00013441754965436	0.00011794993653999	-0.00016437522109104	-0.00011143701998909	-0.0001099258241277	-0.00015556041710618	0.00012453210642623	0.00014885657425247
9.295743376438	0.011270638457536	0.0094298095495375	0.011233901105996	0.009469084895083	-0.0094826338377364	-0.011236608971872	-0.0094483487442164	-0.011278299312535	0.00088199179985943	0.0013057046706924	0.00088154677431022	0.0013050223714966	0.0013060028414457	0.00088402146462001	0.0013053169292107	0.00088287312835568
9.3166171139759	0.00015773790808909	-0.00075826222658034	-0.00034912067798298	-0.000420964663639	0.00013484636787871	0.00030840921749309	0.0003692855992739	-0.00029684472188662	2.7221387592454e-05	-0.00015831416550075	4.5137880465284e-05	-0.00015336648162272	-0.00013813876132543	0.00010037125819977	-0.00017149403154114	4.9772810896988e-05
9.3955061652618	0.0012236115283745	-2.6897849314375e-05	-0.00065331370854087	-0.00071251814466957	0.00073573237694218	0.00075521048833148	-0.00055910055159051	-0.0014005367316561	-4.9284823689381e-05	-0.00023972531107424	0.0002419538582339	-6.6826983982062e-05	-1.4146688145883e-05	0.00036072012992519	-0.00032355152842749	-8.3611440978576e-05
9.414494568471	0.0036827620419003	0.0025783709639494	-0.0037333349548418	-0.002216106534066	0.0025275970791666	0.003775412187011	-0.0022912947784181	-0.0036521351792558	-0.00072470805319601	-0.00050542163027258	0.00073738469965525	0.00053028228716822	0.00055371863579899	0.00069306441150449	-0.00048747977889687	-0.00077456238192606
9.4370777993631	-0.0022124958708447	-0.002575430585452	0.0026468350707469	0.0019910037859263	-0.0018109660962931	-0.0025208864983212	0.0018309565498028	0.0020276795225258	0.00059187953173824	0.00046163197786472	-0.00045510379545079	-0.00066900930391067	-0.00059336066260396	-0.00029764324478373	0.00033642207885202	0.00052820791832133
9.4401016359434	0.0023323556115257	0.0017071767888914	-0.0020396655796239	-0.0022113950205926	0.0022209668335227	0.0021087066415132	-0.0023056826008211	-0.0024624398141079	-0.00035093453940343	-0.00063224650536171	0.00043017723228958	0.00049699489817742	0.00053640598139044	0.00055205973093557	-0.00072469758421325	-0.00037419859592354
9.489887634649	-0.00018902551268126	-0.0023270533171886	-0.00039010805495111	-0.0025878772684515	-0.0024713465694543	-9.7998888062195e-05	-0.0025741552879134	-0.00026356767790022	-0.00051990575112408	0.00033942016379	-0.00045595201837807	0.00037832564209864	-0.00030206956617266	0.00045569012715626	-0.00030705840072816	0.00042798893010378
9.5523627256195	-0.00021197817713221	-0.0020388329494313	-0.00038590633881959	0.0023631244185406	0.0020502483721797	0.00023809580497494	-0.0024284681214371	0.00035205361547691	0.00029142240684095	0.00057303107381041	-0.0005786657524064	-0.00025566618530994	0.00057270388540656	0.00030469384542662	-0.00026595135845431	-0.00058137815687676
9.6158126747749	-0.00070185227233357	9.8764514818984e-05	0.0010260926707132	-0.00029912769700045	-8.6581838027029e-05	0.00071013887143821	0.00028852552231845	-0.0010340242080719	0.00030643239657742	6.957376247543e-05	-0.00012675706939704	-0.00025819369396697	7.0900367755524e-05	0.00030853578106841	-0.00025906898893317	-0.00012916938914699
9.6292462470859	0.0020709090956117	-0.0015559016091345	0.0014202097584805	-0.00069409965099974	0.0015734302225282	-0.0020446006206432	0.00060931471246695	-0.0014637714894767	0.001030072866695	-0.0010120156738533	0.00098123351202854	-0.0010731926943292	-0.0010165972164516	0.0010463081795861	-0.0010877783631092	0.00097775366677241
9.6810401061395	0.0037814181476614	-0.0032470294121797	-0.0039351243645679	0.0033631627361756	0.0032468929432015	-0.0037820052990696	-0.0033558110189373	0.0039390381300944	-0.00013676514184438	-2.7181566241014e-05	2.8100910376947e-05	0.00013444011600801	-2.6393519099407e-05	-0.00013770180219065	0.00013613075120272	2.8436760999649e-05
9.7551619993415	0.0016062933027798	0.0018963873192373	0.0016051769138456	0.0018915248915832	0.0018977852469009	0.0016061368375241	0.0018943763014677	0.0016022726405708	-0.00056954331469964	-0.00063829821659862	-0.00056899574553244	-0.00063810280321668	0.00063659122848405	0.00057167103523641	0.00063611196955387	0.000570863349446
9.8630084555645	-0.0060924869245767	-0.0049632894367073	-0.0060986232189785	-0.0049639991912924	0.0049623227455413	0.0060919395718841	0.0049648795172578	0.0060990288403172	0.00068555250798105	-0.0001245424718602	0.00068783858792588	-0.00012198768312019	-0.00012450905023961	0.00068522012804236	-0.00012185145519376	0.00068775721912421
9.9109846808998	-3.6213107673287e-05	0	0.00016281915475203	8.055958534695e-05	1.3596301264879e-05	4.3797637165994e-05	-9.3254268825829e-05	-0.00016983951856317	6.3041765556597e-05	3.6575039513377e-05	-3.4084849542355e-05	-7.1051462651764e-05	3.7860953916148e-05	6.4095363443167e-05	-7.0972259180244e-05	-3.6380369224868e-05
10.01392265449	-0.0011754692064132	-0.00098935416880452	0.0011608253367735	0.00096814701061045	0.00099003970209048	0.0011755914872634	-0.00096874932115083	-0.0011613376047011	0.00096849481845204	0.0011085351639278	-0.00098411075156187	-0.0010942542085177	0.0011082015747755	0.00096885937249246	-0.0010945222356934	-0.00098385767075796
10.044610936871	8.1736577439774e-05	0.00013466755217821	-2.8647193191464e-05	1.5735215018961e-05	-0.00012409611677683	-7.7485473077889e-05	-2.5287122558742e-05	2.3193692873996e-05	-7.317147993038e-06	-0.00010676878980301	0.00010499358623697	2.0195150715482e-05	-0.00010757952859069	-5.2163699473056e-06	1.9005891119143e-05	0.00010536168584442
10.09645939987	-0.0001244350070383	0.0019821544201486	-0.00012006052687069	0.0019907231664023	-0.0019847591433877	0.00012359469303753	-0.0019884179208568	0.00012133132278369	0.0010888362170891	-0.00090770893215403	0.001082030825988	-0.00091537075681433	-0.00090738693922942	0.0010883403568522	-0.00091505753647848	0.0010818423664993
10.182709544604	-5.0383416711282e-05	6.7287741967795e-05	-4.8190940823595e-05	0.00012606807768729	-9.1091804140639e-05	4.0026933398703e-05	-0.00010317539402669	5.906978355832e-05	6.521838079459e-05	3.1553680201443e-06	1.0254422014984e-05	-6.0252917335395e-05	4.2839021977081e-06	6.4162982987763e-05	-6.08468208732e-05	1.0124623737751e-05
10.399322650145	0.0010396205393633	0.00089421094522268	-0.00061100815352389	-0.0012423160381894	0.00089362247680832	0.0010400739035511	-0.0012428034706931	-0.00061047068963327	0.0013130284532445	0.0007222027483344	-0.0009534623046958	-0.0012089938335585	-0.00072219868476432	-0.0013129054611728	0.0012088983996568	0.00095350963880724
10.399517379798	0.00071543587838962	-0.00098892910173778	0.001103561290207	-0.00048914977158907	-0.00098874605345255	0.00071510142495574	-0.00048878493134007	0.0011033328156528	0.00049427549878452	-0.0012593446760621	0.0010292211283322	-0.00080378635447924	0.0012594399808125	-0.00049426219928745	0.00080373285698765	-0.0010293236874717
10.757234460845	-5.2134137983714e-05	1.2875402657674e-05	-5.2250886181107e-05	1.3041552515982e-05	1.2783294129958e-05	-5.2079687626289e-05	1.2972951382134e-05	-5.2124364133634e-05	-0.00076665476145291	-0.00052430799344252	-0.00076667463632152	-0.00052431498649494	0.00052431219202166	0.00076666367374842	0.00052431207508327	0.0007666781706086
10.846141472377	0.002365728303993	-0.0020755199788628	-0.0023642403324529	0.0020742139370657	-0.0020741251378812	0.0023643253699355	0.002075367462425	-0.0023656875555731	6.8088073742785e-05	-8.2474615650615e-05	-6.7942601069333e-05	8.2168697234316e-05	8.244820007838e-05	-6.8188264463193e-05	-8.2173283381648e-05	6.7847205442865e-05
10.999786598677	0.0014677793959451	-0.0023341394875737	-0.0014660839715595	0.0023326203623338	0.0023341537756223	-0.0014679128367354	-0.0023326260539008	0.0014662120804562	9.3478790754928e-05	-8.3216312159734e-05	-9.3646270442935e-05	8.3142919842555e-05	-8.3217453965907e-05	9.3468176424281e-05	8.3153180886191e-05	-9.3644744941328e-05
11.12844041576	0.00015088406721314	-0.00023449060907488	0.00014754727465044	-0.00023857343641136	0.0002340973717558	-0.00015215087302866	0.00023904145686645	-0.00014635351165681	-0.00047487306148765	-0.00059103163032154	-0.00047476531282477	-0.00059107839049279	-0.00059104492841387	-0.00047494860192249	-0.00059101991402821	-0.00047471217620434
11.283495030434	-0.0015499562366839	0.0012498798280614	-0.0013612557621488	0.0013967564259224	-0.0012432629643279	0.00156416415905	-0.001405349478426	0.0013489711924032	5.6353427490453e-05	-0.00015040488967781	4.5112366978987e-05	-0.00015670113888022	-0.00015061289229197	5.6970514266088e-05	-0.00015693451390171	4.4732635198564e-05
11.324027996679	-0.0014680177658707	-0.0012419825892601	0.0016708348249971	0.0010557454185598	0.0012423956362898	0.0014690702620921	-0.0010562186436598	-0.0016718553105552	9.6153667465513e-05	6.7033954111447e-05	-0.00010605763596397	-4.6885505082482e-05	6.702051458375e-05	9.6201654143603e-05	-4.686847875755e-05	-0.00010609716453681
11.521164754006	0.00091142806136852	-0.0010475817195539	-0.0009037466185751	0.0010401505250131	0.0010488623718832	-0.0009082517314992	-0.0010423297497546	0.00090146058556	-0.00021193411950834	0.0001931868942347	0.0002112560448775	-0.00019241545115164	0.00019303712242163	-0.00021190646434553	-0.00019227532859434	0.00021122161602355
11.627368551616	-0.0013455004162203	0.00016677250880703	0.00092206553568458	0.00025394361056678	0.00010979132745344	-0.0011443699050441	4.7312316811239e-05	0.00098608334475152	7.1212374605529e-05	-0.0001268657239199	-6.7519875149856e-05	0.00012194127736181	0.00012088607782969	-5.1613254448809e-05	-0.00014741190651017	7.8476030324451e-05
11.646325286428	0.00024135643782729	-0.00045294515871095	-0.00084509166431967	0.0010525098834321	-0.00050510344215264	0.00044816870009359	0.00084195288172547	-0.00078925410858697	-0.00010708072948784	0.00012478506463979	0.00010169827616467	-0.00011976695251551	-0.00013027098023504	0.00012786902147242	9.3436053258624e-05	-9.1210672877123e-05
11.675143876734	-0.0012305190359464	0.0014982626391809	-0.0013843846515498	0.0010836106766926	0.0015111141146597	-0.0012990647438636	0.0011528067095354	-0.0013970798086558	-5.5125036934009e-05	6.8496618931136e-05	-8.5624795545621e-05	8.1149670308016e-05	-6.7193460212778e-05	4.7976274174989e-05	-7.2285736244953e-05	8.26205412803e-05
11.722323352708	0.00087532586756846	0.0013087088233291	-0.0008694520314168	-0.0013100824740359	0.0012954082706019	0.0010640885815221	-0.0014985723698164	-0.00086164877153222	0.00010831698376038	3.5167188385232e-05	-8.8749510866965e-05	-5.5361730927095e-05	-3.5960458394653e-05	-8.7690832150374e-05	3.0199228727681e-05	9.4606258591756e-05
11.789675840931	-0.00047024679216799	-0.00024880356525512	0.00020395530573299	0.00051927482385969	-0.00017552190663406	-9.6085289032284e-05	0.00015203765176383	0.00010882083572606	-3.6980740134501e-06	-3.9141726769331e-06	1.5304897927496e-05	-4.8759968761257e-06	1.6297803905028e-05	4.5528675984813e-05	-4.7312284923853e-05	-1.552151758817e-05
12.099826831855	0.00058705773242246	-0.00074209620428984	0.00061729206495164	-0.00071667299699188	0.00074560305075088	-0.00057742659085054	0.00070642318266522	-0.00061959798124369	-0.00013055295724998	0.00012478608884889	-0.0001354779040713	0.00011817663358868	0.00012448127337137	-0.00013174993143108	0.00011950832541495	-0.00013506718922337
12.167554756718	-0.00080110351716407	-0.00069712876156634	0.0007868013864637	0.0007158019521945	0.00069648656845257	0.00080387487026332	-0.00071856606019896	-0.0007858352299622	9.5823109795263e-05	0.00012933549554345	-9.1728344337318e-05	-0.00013314594437145	0.00012948021633576	9.5478879872342e-05	-0.00013273675184691	-9.1801993457404e-05
12.452427211943	0.00050271895581482	0.00035707433434951	-0.00026768149705575	-0.0005491955868653	0.00035007420865707	0.00050828992018562	-0.00055744804499192	-0.00026349816226636	9.2487585808661e-05	5.4828741556389e-05	-6.1177349528799e-05	-9.6414873892068e-05	-5.617398516451e-05	-9.0754729565524e-05	9.4806300576533e-05	6.2733415773959e-05
12.463966494884	-0.00033454477971471	0.00055189483624806	-0.0006099267953325	0.00022710512482678	0.00056200484228461	-0.00033699636221514	0.00023271431599232	-0.00061743950575275	-3.1542261180915e-05	0.00010806502032929	-8.7804594605762e-05	5.2622938932878e-05	-0.00010607475668448	3.0179046402962e-05	-5.1576953505322e-05	8.5768240967884e-05
12.501760639854	0.00067993672518467	-0.00048814245274216	0.00061210098894127	-0.00056843820537472	-0.0004815634105807	0.00067766729206812	-0.00056387549183619	0.00060756702847104	8.6928049402811e-05	-0.00010122969662023	7.2430627075993e-05	-0.00011549486545833	0.00010253057235688	-8.7992216987903e-05	0.00011636767846274	-7.3801063950287e-05
12.539355684523	-0.00034068874464683	-0.00041833144767866	0.00035758598520732	0.0004057946286373	-0.00041909617610003	-0.00033826473174015	0.0004027157017582	0.00035740978737173	-7.3373148819406e-05	-7.4632384603902e-05	7.6049696523555e-05	7.117834354765e-05	7.4498863380857e-05	7.3971880525573e-05	-7.1812094005245e-05	-7.5799593057713e-05
13.3513939905	-0.00023367342372798	-0.00024188748772559	-0.00023367372046531	-0.00024188765432407	-0.00024188886521916	-0.00023367386341489	-0.00024188827387136	-0.00023367329749205	4.9431847713763e-06	-3.6929394083592e-06	4.9433216749222e-06	-3.692809139297e-06	3.6927807198874e-06	-4.9430908135093e-06	3.6928450753441e-06	-4.9430744579625e-06
13.352356963972	0.00023277700540275	0.00024231517060457	0.00023278384736434	0.00024232349874176	0.0002423107975931	0.0002327761550117	0.00024231944014016	0.00023278330521258	-5.0724951612955e-06	3.8317156027201e-06	-5.0700078027597e-06	3.8340052607285e-06	-3.8322723702741e-06	5.0731570473218e-06	-3.8344889999402e-06	5.0707361668734e-06
13.742842563636	-0.00022988314756162	-0.00021146527510052	-0.00022988309079326	-0.00021146514769072	0.00021146590605404	0.00022988322954079	0.00021146543116031	0.00022988268244373	2.7842910150241e-06	-2.829613967988e-06	2.7841900120179e-06	-2.8298262660307e-06	-2.8298934114092e-06	2.7843389122948e-06	-2.8298552495195e-06	2.7843708354586e-06
13.743726329794	0.00022974625931501	0.00021112131696279	0.00022974515852521	0.0002111204532108	-0.00021112203225786	-0.00022974593490696	-0.00021112109230414	-0.00022974498473649	-2.8382757121833e-06	2.8626733459263e-06	-2.8380717320865e-06	2.8628589374705e-06	2.8626479110333e-06	-2.8382977848733e-06	2.8629589644222e-06	-2.8381031449319e-06

"""
