from pyqcm import *
set_global_parameter("nosym")
new_cluster_model('clus', 4, 0, generators=None, bath_irrep=False)
add_cluster('clus', [0, 0, 0], [[0, 0, 0], ( 1, 0, 0), ( 0, 1, 0), ( 1, 1, 0)], ref = 0)
lattice_model('WSM_2x2', [( 2, 0, 0), ( 0, 2, 0), [0, 0, 1]], None)
interaction_operator('U')
hopping_operator('t', ( 1, 0, 0), 1, tau=1, sigma=1)
hopping_operator('t', ( 0, 1, 0), 1, tau=2, sigma=2)
hopping_operator('t', [0, 0, 1], 1, tau=2, sigma=3)
hopping_operator('t', [0, 0, 0], -0.765367, tau=0, sigma=1)
hopping_operator('m', ( 0, 1, 0), -0.5, tau=1, sigma=1)
hopping_operator('m', [0, 0, 1], -0.5, tau=1, sigma=1)
hopping_operator('m', [0, 0, 0], 2, tau=0, sigma=1)

try:
    import model_extra
except:
    pass		
set_target_sectors(['R0:N4'])
set_parameters("""

U = 4
mu= 0.5*U
t = 1
m = 1.5
""")
set_parameter("U", 4.0)
set_parameter("m", 1.5)
set_parameter("t", 1.0)

new_model_instance(9)

solution=[None]*1

#--------------------- cluster no 1 -----------------
solution[0] = """
U	4
m	1.5
mu	2
t	1

GS_energy: -17.4375 GS_sector: R0:N4:1
GF_format: bl
mixing	2
state
R0:N4	-17.4375	1
w	8	90
-2.5292978336778	(-0.29251944963641,0)	(0.29251944963641,0)	(-0.40243307387129,0)	(0.40243307387129,0)	(0.40243307387129,0)	(-0.40243307387129,0)	(0.29251944963641,0)	(-0.29251944963641,0)
-4.028171582233	(0.40231417510459,0)	(-0.40231417510458,0)	(-0.29241270178227,0)	(0.29241270178227,0)	(-0.29241270178227,0)	(0.29241270178227,0)	(0.40231417510459,0)	(-0.40231417510459,0)
-4.4436989738392	(-0.31366354016743,0)	(-0.31366354016743,0)	(-0.38227692222544,0)	(-0.38227692222544,0)	(0.38227692222544,0)	(0.38227692222544,0)	(0.31366354016743,0)	(0.31366354016743,0)
-5.9351364593511	(0.37991806564244,0)	(0.37991806564244,0)	(-0.31171253424975,0)	(-0.31171253424975,0)	(-0.31171253424975,0)	(-0.31171253424975,0)	(0.37991806564244,0)	(0.37991806564244,0)
-6.6787506357468	(0.031981551398576,0)	(-0.031981551398578,0)	(0.031835340626014,0)	(-0.031835340626013,0)	(-0.031835340626012,0)	(0.031835340626014,0)	(-0.031981551398577,0)	(0.031981551398576,0)
-6.9033815740834	(0.045452372076121,0)	(0.045452372076122,0)	(-0.03778870273515,0)	(-0.037788702735148,0)	(-0.037788702735148,0)	(-0.037788702735149,0)	(0.045452372076122,0)	(0.045452372076121,0)
-7.3582568870464	(-0.033431964059396,0)	(-0.033431964059396,0)	(-0.036332337618466,0)	(-0.036332337618466,0)	(0.036332337618466,0)	(0.036332337618467,0)	(0.033431964059395,0)	(0.033431964059396,0)
-7.7357600159511	(-0.029905893588311,0)	(0.029905893588311,0)	(0.028795755758007,0)	(-0.028795755758007,0)	(0.028795755758007,0)	(-0.028795755758007,0)	(-0.029905893588311,0)	(0.029905893588311,0)
-7.8842295913636	(-0.037022875161782,0)	(-0.037022875161782,0)	(-0.038048320116193,0)	(-0.038048320116193,0)	(0.038048320116193,0)	(0.038048320116193,0)	(0.037022875161782,0)	(0.037022875161782,0)
-8.8615011725687	(0.038814754314673,0)	(0.038814754314673,0)	(-0.035725751881963,0)	(-0.035725751881963,0)	(-0.035725751881964,0)	(-0.035725751881963,0)	(0.038814754314673,0)	(0.038814754314673,0)
-9.0531265423402	(0.01043233180179,0)	(0.010432331801791,0)	(0.0086608986187103,0)	(0.0086608986187093,0)	(-0.0086608986187089,0)	(-0.0086608986187094,0)	(-0.010432331801792,0)	(-0.010432331801791,0)
-9.1667735192164	(-0.015211928783704,0)	(0.015211928783705,0)	(0.016730145088775,0)	(-0.016730145088776,0)	(0.016730145088775,0)	(-0.016730145088776,0)	(-0.015211928783705,0)	(0.015211928783706,0)
-9.1975158990693	(-0.011381607591765,0)	(0.011381607591765,0)	(-0.0098285808426783,0)	(0.0098285808426786,0)	(0.0098285808426795,0)	(-0.0098285808426797,0)	(0.011381607591764,0)	(-0.011381607591764,0)
-9.7300293522364	(-0.032717525166154,0)	(-0.032717525166154,0)	(0.033401501189014,0)	(0.033401501189014,0)	(0.033401501189014,0)	(0.033401501189014,0)	(-0.032717525166154,0)	(-0.032717525166154,0)
-9.8623141040568	(0.0095173902620753,0)	(-0.0095173902620747,0)	(0.0085605770943801,0)	(-0.0085605770943806,0)	(-0.0085605770943804,0)	(0.0085605770943798,0)	(-0.009517390262075,0)	(0.0095173902620755,0)
-10.202839545768	(-0.0020473834851246,0)	(-0.0020473834851245,0)	(-0.0016508911472284,0)	(-0.0016508911472285,0)	(0.0016508911472286,0)	(0.0016508911472285,0)	(0.0020473834851244,0)	(0.0020473834851244,0)
-10.707099425553	(0.010962250935228,0)	(-0.010962250935228,0)	(-0.012686513474787,0)	(0.012686513474787,0)	(-0.012686513474787,0)	(0.012686513474787,0)	(0.010962250935228,0)	(-0.010962250935227,0)
-11.344845704266	(-0.0024250239422277,0)	(0.0024250239422277,0)	(-0.0028885108942402,0)	(0.0028885108942402,0)	(0.0028885108942403,0)	(-0.0028885108942402,0)	(0.0024250239422278,0)	(-0.0024250239422278,0)
-11.415403083791	(0.00054446995751548,0)	(0.00054446995751518,0)	(-0.00032969716588676,0)	(-0.00032969716588691,0)	(-0.00032969716588699,0)	(-0.00032969716588666,0)	(0.00054446995751516,0)	(0.00054446995751525,0)
-11.82560818152	(-0.0006733369260672,0)	(0.00067333692606698,0)	(0.00076241315397951,0)	(-0.00076241315397963,0)	(0.00076241315398005,0)	(-0.00076241315397975,0)	(-0.00067333692606698,0)	(0.00067333692606691,0)
-12.215638384551	(-0.00077071403281911,0)	(-0.00077071403281918,0)	(0.0011834471027998,0)	(0.0011834471027998,0)	(0.0011834471027998,0)	(0.0011834471027998,0)	(-0.00077071403281909,0)	(-0.00077071403281917,0)
-12.277841601456	(0.0033927375909601,0)	(-0.0033927375909602,0)	(0.0037791690005553,0)	(-0.0037791690005554,0)	(-0.0037791690005553,0)	(0.0037791690005554,0)	(-0.0033927375909601,0)	(0.0033927375909601,0)
-12.322837372254	(0.00074105395148902,0)	(0.00074105395148897,0)	(0.00054469412702659,0)	(0.0005446941270266,0)	(-0.00054469412702667,0)	(-0.00054469412702658,0)	(-0.00074105395148891,0)	(-0.00074105395148892,0)
-12.580898831521	(-0.0072344852562221,0)	(0.007234485256222,0)	(0.0069318106305525,0)	(-0.0069318106305526,0)	(0.0069318106305526,0)	(-0.0069318106305525,0)	(-0.0072344852562221,0)	(0.0072344852562222,0)
-12.667008723865	(0.0019298121011467,0)	(-0.001929812101147,0)	(0.0021535640584194,0)	(-0.0021535640584195,0)	(-0.0021535640584192,0)	(0.0021535640584194,0)	(-0.0019298121011471,0)	(0.0019298121011471,0)
-12.722821387341	(-0.0020532165243646,0)	(-0.0020532165243646,0)	(-0.0018769272320132,0)	(-0.0018769272320132,0)	(0.001876927232013,0)	(0.0018769272320131,0)	(0.0020532165243648,0)	(0.0020532165243648,0)
-13.160919525192	(0.002150812327099,0)	(-0.0021508123270989,0)	(-0.0022734960005041,0)	(0.0022734960005041,0)	(-0.0022734960005041,0)	(0.0022734960005039,0)	(0.0021508123270989,0)	(-0.0021508123270988,0)
-13.230621628521	(0.00061884795220794,0)	(0.00061884795220817,0)	(-0.00051948987398718,0)	(-0.00051948987398747,0)	(-0.00051948987398734,0)	(-0.00051948987398744,0)	(0.0006188479522081,0)	(0.00061884795220828,0)
-13.779046414932	(-0.0023950125742698,0)	(-0.0023950125742698,0)	(-0.0028094458341435,0)	(-0.0028094458341436,0)	(0.0028094458341436,0)	(0.0028094458341435,0)	(0.0023950125742697,0)	(0.0023950125742697,0)
-13.822601923621	(-0.00038647068731405,0)	(0.00038647068731404,0)	(-0.00042183647997572,0)	(0.00042183647997588,0)	(0.00042183647997588,0)	(-0.00042183647997581,0)	(0.00038647068731406,0)	(-0.00038647068731413,0)
-14.069812355903	(-0.0015011766082614,0)	(0.0015011766082614,0)	(0.0012779416296881,0)	(-0.0012779416296882,0)	(0.0012779416296882,0)	(-0.0012779416296881,0)	(-0.0015011766082614,0)	(0.0015011766082615,0)
-14.217884548105	(-0.00063181273047723,0)	(0.00063181273047724,0)	(-0.00072902658900599,0)	(0.00072902658900595,0)	(0.00072902658900588,0)	(-0.00072902658900588,0)	(0.00063181273047723,0)	(-0.00063181273047722,0)
-14.351564129456	(0.0013460323735202,0)	(0.0013460323735202,0)	(-0.0013237490451972,0)	(-0.0013237490451972,0)	(-0.0013237490451973,0)	(-0.0013237490451971,0)	(0.0013460323735202,0)	(0.0013460323735201,0)
-14.441529297923	(0.0015000322154703,0)	(0.0015000322154705,0)	(0.0016805835302725,0)	(0.0016805835302725,0)	(-0.0016805835302726,0)	(-0.0016805835302727,0)	(-0.0015000322154703,0)	(-0.0015000322154703,0)
-14.45071230499	(0.0018099561737813,0)	(-0.0018099561737813,0)	(-0.0016081446276935,0)	(0.0016081446276935,0)	(-0.0016081446276935,0)	(0.0016081446276935,0)	(0.0018099561737813,0)	(-0.0018099561737813,0)
-14.933280441852	(-0.0033216188794548,0)	(-0.0033216188794547,0)	(0.0031368944318423,0)	(0.0031368944318422,0)	(0.0031368944318423,0)	(0.0031368944318423,0)	(-0.0033216188794548,0)	(-0.0033216188794547,0)
-15.018507185378	(-0.0012150239518917,0)	(0.0012150239518919,0)	(-0.0015619358821456,0)	(0.0015619358821457,0)	(0.0015619358821456,0)	(-0.0015619358821458,0)	(0.0012150239518918,0)	(-0.0012150239518918,0)
-15.071529763542	(-0.0015363164652958,0)	(-0.0015363164652956,0)	(-0.0016861678358641,0)	(-0.001686167835864,0)	(0.0016861678358642,0)	(0.001686167835864,0)	(0.0015363164652956,0)	(0.0015363164652957,0)
-15.51984085256	(0.00080251422823546,0)	(-0.00080251422823539,0)	(-0.00072073719701864,0)	(0.00072073719701874,0)	(-0.00072073719701875,0)	(0.00072073719701865,0)	(0.00080251422823536,0)	(-0.0008025142282354,0)
-15.838391280702	(-0.00012176553921104,0)	(0.00012176553921099,0)	(-8.4396109423804e-05,0)	(8.4396109423943e-05,0)	(8.4396109423901e-05,0)	(-8.4396109423877e-05,0)	(0.00012176553921087,0)	(-0.00012176553921105,0)
-15.987619286375	(-0.00012253469241841,0)	(-0.00012253469241841,0)	(-0.00013297787200042,0)	(-0.00013297787200048,0)	(0.0001329778720005,0)	(0.00013297787200047,0)	(0.00012253469241828,0)	(0.00012253469241836,0)
-16.054904656831	(-0.0019030057990715,0)	(-0.0019030057990716,0)	(0.0017999151951287,0)	(0.0017999151951288,0)	(0.0017999151951287,0)	(0.0017999151951288,0)	(-0.0019030057990715,0)	(-0.0019030057990717,0)
-17.379140317401	(0.00015448041799272,0)	(0.00015448041799274,0)	(0.00016803700407647,0)	(0.00016803700407643,0)	(-0.00016803700407656,0)	(-0.00016803700407655,0)	(-0.0001544804179927,0)	(-0.00015448041799266,0)
-17.388233110607	(0.00020385953133582,0)	(-0.00020385953133588,0)	(-0.00019982178441133,0)	(0.00019982178441142,0)	(-0.00019982178441138,0)	(0.00019982178441142,0)	(0.00020385953133573,0)	(-0.00020385953133586,0)
-17.83655865885	(-0.00042366045542678,0)	(-0.00042366045542674,0)	(0.00040564159522692,0)	(0.00040564159522669,0)	(0.00040564159522685,0)	(0.00040564159522693,0)	(-0.00042366045542679,0)	(-0.00042366045542658,0)
2.5292978336778	(-0.29251944963641,0)	(0.29251944963641,0)	(-0.40243307387129,0)	(0.40243307387129,0)	(-0.40243307387129,0)	(0.40243307387129,0)	(-0.29251944963641,0)	(0.29251944963641,0)
4.028171582233	(-0.40231417510458,0)	(0.40231417510459,0)	(0.29241270178227,0)	(-0.29241270178226,0)	(-0.29241270178226,0)	(0.29241270178227,0)	(0.40231417510459,0)	(-0.40231417510458,0)
4.4436989738392	(0.31366354016743,0)	(0.31366354016742,0)	(0.38227692222544,0)	(0.38227692222544,0)	(0.38227692222544,0)	(0.38227692222544,0)	(0.31366354016742,0)	(0.31366354016743,0)
5.9351364593511	(0.37991806564244,0)	(0.37991806564244,0)	(-0.31171253424975,0)	(-0.31171253424975,0)	(0.31171253424975,0)	(0.31171253424975,0)	(-0.37991806564244,0)	(-0.37991806564244,0)
6.6787506357468	(0.031981551398577,0)	(-0.031981551398576,0)	(0.031835340626013,0)	(-0.031835340626013,0)	(0.031835340626013,0)	(-0.031835340626013,0)	(0.031981551398577,0)	(-0.031981551398577,0)
6.9033815740834	(0.045452372076122,0)	(0.045452372076123,0)	(-0.03778870273515,0)	(-0.037788702735149,0)	(0.037788702735149,0)	(0.03778870273515,0)	(-0.045452372076123,0)	(-0.045452372076122,0)
7.3582568870464	(0.033431964059396,0)	(0.033431964059396,0)	(0.036332337618466,0)	(0.036332337618466,0)	(0.036332337618466,0)	(0.036332337618466,0)	(0.033431964059396,0)	(0.033431964059396,0)
7.7357600159511	(0.02990589358831,0)	(-0.029905893588312,0)	(-0.028795755758006,0)	(0.028795755758007,0)	(0.028795755758006,0)	(-0.028795755758008,0)	(-0.02990589358831,0)	(0.029905893588311,0)
7.8842295913636	(0.037022875161782,0)	(0.037022875161782,0)	(0.038048320116193,0)	(0.038048320116193,0)	(0.038048320116193,0)	(0.038048320116192,0)	(0.037022875161782,0)	(0.037022875161782,0)
8.8615011725687	(0.038814754314673,0)	(0.038814754314673,0)	(-0.035725751881963,0)	(-0.035725751881963,0)	(0.035725751881963,0)	(0.035725751881963,0)	(-0.038814754314673,0)	(-0.038814754314673,0)
9.0531265423402	(-0.01043233180179,0)	(-0.010432331801791,0)	(-0.0086608986187093,0)	(-0.0086608986187096,0)	(-0.0086608986187089,0)	(-0.0086608986187101,0)	(-0.01043233180179,0)	(-0.010432331801791,0)
9.1667735192164	(0.015211928783706,0)	(-0.015211928783705,0)	(-0.016730145088775,0)	(0.016730145088775,0)	(0.016730145088777,0)	(-0.016730145088776,0)	(-0.015211928783704,0)	(0.015211928783704,0)
9.1975158990693	(-0.011381607591763,0)	(0.011381607591763,0)	(-0.0098285808426809,0)	(0.0098285808426803,0)	(-0.0098285808426774,0)	(0.0098285808426777,0)	(-0.011381607591766,0)	(0.011381607591766,0)
9.7300293522364	(-0.032717525166153,0)	(-0.032717525166154,0)	(0.033401501189014,0)	(0.033401501189014,0)	(-0.033401501189014,0)	(-0.033401501189014,0)	(0.032717525166154,0)	(0.032717525166154,0)
9.8623141040568	(0.0095173902620757,0)	(-0.0095173902620747,0)	(0.0085605770943799,0)	(-0.0085605770943806,0)	(0.0085605770943808,0)	(-0.0085605770943798,0)	(0.0095173902620747,0)	(-0.0095173902620755,0)
10.202839545768	(0.0020473834851244,0)	(0.0020473834851244,0)	(0.0016508911472289,0)	(0.0016508911472286,0)	(0.0016508911472286,0)	(0.0016508911472285,0)	(0.0020473834851249,0)	(0.0020473834851245,0)
10.707099425553	(-0.010962250935228,0)	(0.010962250935228,0)	(0.012686513474787,0)	(-0.012686513474787,0)	(-0.012686513474787,0)	(0.012686513474787,0)	(0.010962250935228,0)	(-0.010962250935227,0)
11.344845704266	(-0.0024250239422277,0)	(0.0024250239422278,0)	(-0.0028885108942401,0)	(0.0028885108942401,0)	(-0.0028885108942401,0)	(0.0028885108942401,0)	(-0.0024250239422277,0)	(0.0024250239422276,0)
11.415403083791	(0.00054446995751507,0)	(0.00054446995751514,0)	(-0.00032969716588667,0)	(-0.0003296971658867,0)	(0.00032969716588678,0)	(0.00032969716588686,0)	(-0.00054446995751512,0)	(-0.0005444699575152,0)
11.82560818152	(0.00067333692606714,0)	(-0.00067333692606696,0)	(-0.00076241315397969,0)	(0.00076241315397967,0)	(0.00076241315397977,0)	(-0.00076241315397973,0)	(-0.00067333692606691,0)	(0.00067333692606697,0)
12.215638384551	(-0.000770714032819,0)	(-0.00077071403281927,0)	(0.0011834471027998,0)	(0.0011834471027999,0)	(-0.0011834471027997,0)	(-0.0011834471027999,0)	(0.00077071403281914,0)	(0.00077071403281933,0)
12.277841601456	(0.0033927375909601,0)	(-0.0033927375909602,0)	(0.0037791690005554,0)	(-0.0037791690005553,0)	(0.0037791690005553,0)	(-0.0037791690005553,0)	(0.0033927375909602,0)	(-0.0033927375909602,0)
12.322837372254	(-0.00074105395148906,0)	(-0.0007410539514887,0)	(-0.00054469412702673,0)	(-0.00054469412702657,0)	(-0.0005446941270268,0)	(-0.00054469412702641,0)	(-0.00074105395148904,0)	(-0.00074105395148896,0)
12.580898831521	(0.0072344852562222,0)	(-0.0072344852562221,0)	(-0.0069318106305526,0)	(0.0069318106305525,0)	(0.0069318106305526,0)	(-0.0069318106305526,0)	(-0.0072344852562222,0)	(0.007234485256222,0)
12.667008723865	(0.0019298121011469,0)	(-0.001929812101147,0)	(0.0021535640584196,0)	(-0.0021535640584196,0)	(0.0021535640584192,0)	(-0.0021535640584194,0)	(0.0019298121011471,0)	(-0.0019298121011471,0)
12.722821387341	(0.0020532165243649,0)	(0.0020532165243645,0)	(0.001876927232013,0)	(0.001876927232013,0)	(0.0018769272320133,0)	(0.0018769272320129,0)	(0.0020532165243646,0)	(0.0020532165243647,0)
13.160919525192	(-0.0021508123270987,0)	(0.0021508123270989,0)	(0.002273496000504,0)	(-0.002273496000504,0)	(-0.0022734960005039,0)	(0.0022734960005041,0)	(0.0021508123270988,0)	(-0.0021508123270989,0)
13.230621628521	(0.00061884795220815,0)	(0.00061884795220808,0)	(-0.00051948987398714,0)	(-0.00051948987398729,0)	(0.00051948987398732,0)	(0.00051948987398725,0)	(-0.00061884795220781,0)	(-0.00061884795220799,0)
13.779046414932	(0.0023950125742698,0)	(0.0023950125742697,0)	(0.0028094458341435,0)	(0.0028094458341435,0)	(0.0028094458341435,0)	(0.0028094458341435,0)	(0.0023950125742697,0)	(0.0023950125742699,0)
13.822601923621	(-0.00038647068731427,0)	(0.00038647068731401,0)	(-0.00042183647997602,0)	(0.00042183647997576,0)	(-0.00042183647997596,0)	(0.00042183647997578,0)	(-0.00038647068731412,0)	(0.000386470687314,0)
14.069812355903	(0.0015011766082615,0)	(-0.0015011766082615,0)	(-0.0012779416296881,0)	(0.0012779416296882,0)	(0.0012779416296882,0)	(-0.0012779416296882,0)	(-0.0015011766082614,0)	(0.0015011766082615,0)
14.217884548105	(-0.00063181273047708,0)	(0.00063181273047711,0)	(-0.00072902658900587,0)	(0.00072902658900593,0)	(-0.00072902658900592,0)	(0.00072902658900589,0)	(-0.00063181273047724,0)	(0.00063181273047726,0)
14.351564129456	(0.0013460323735202,0)	(0.00134603237352,0)	(-0.0013237490451973,0)	(-0.0013237490451971,0)	(0.0013237490451972,0)	(0.0013237490451972,0)	(-0.0013460323735202,0)	(-0.0013460323735201,0)
14.441529297923	(-0.0015000322154703,0)	(-0.0015000322154703,0)	(-0.0016805835302726,0)	(-0.0016805835302726,0)	(-0.0016805835302725,0)	(-0.0016805835302726,0)	(-0.0015000322154702,0)	(-0.0015000322154703,0)
14.45071230499	(-0.0018099561737812,0)	(0.0018099561737813,0)	(0.0016081446276934,0)	(-0.0016081446276935,0)	(-0.0016081446276935,0)	(0.0016081446276936,0)	(0.0018099561737812,0)	(-0.0018099561737813,0)
14.933280441852	(-0.0033216188794547,0)	(-0.0033216188794547,0)	(0.0031368944318423,0)	(0.0031368944318423,0)	(-0.0031368944318423,0)	(-0.0031368944318422,0)	(0.0033216188794548,0)	(0.0033216188794547,0)
15.018507185378	(-0.0012150239518918,0)	(0.0012150239518918,0)	(-0.0015619358821457,0)	(0.0015619358821457,0)	(-0.0015619358821457,0)	(0.0015619358821457,0)	(-0.0012150239518919,0)	(0.0012150239518918,0)
15.071529763542	(0.0015363164652956,0)	(0.0015363164652956,0)	(0.0016861678358641,0)	(0.0016861678358642,0)	(0.0016861678358641,0)	(0.001686167835864,0)	(0.0015363164652958,0)	(0.0015363164652957,0)
15.51984085256	(-0.00080251422823541,0)	(0.00080251422823545,0)	(0.0007207371970187,0)	(-0.00072073719701875,0)	(-0.00072073719701873,0)	(0.0007207371970188,0)	(0.00080251422823539,0)	(-0.0008025142282355,0)
15.838391280702	(-0.00012176553921087,0)	(0.00012176553921097,0)	(-8.4396109423835e-05,0)	(8.4396109423759e-05,0)	(-8.4396109423758e-05,0)	(8.4396109423848e-05,0)	(-0.00012176553921098,0)	(0.0001217655392109,0)
15.987619286375	(0.00012253469241839,0)	(0.00012253469241815,0)	(0.00013297787200043,0)	(0.00013297787200037,0)	(0.00013297787200053,0)	(0.00013297787200028,0)	(0.00012253469241827,0)	(0.00012253469241836,0)
16.054904656831	(-0.0019030057990716,0)	(-0.0019030057990716,0)	(0.0017999151951288,0)	(0.0017999151951288,0)	(-0.0017999151951288,0)	(-0.0017999151951287,0)	(0.0019030057990717,0)	(0.0019030057990716,0)
17.379140317401	(-0.00015448041799271,0)	(-0.00015448041799257,0)	(-0.00016803700407662,0)	(-0.00016803700407665,0)	(-0.00016803700407645,0)	(-0.00016803700407637,0)	(-0.00015448041799277,0)	(-0.00015448041799288,0)
17.388233110607	(-0.00020385953133579,0)	(0.00020385953133593,0)	(0.00019982178441134,0)	(-0.00019982178441135,0)	(-0.00019982178441141,0)	(0.00019982178441153,0)	(0.00020385953133579,0)	(-0.00020385953133585,0)
17.83655865885	(-0.00042366045542676,0)	(-0.0004236604554268,0)	(0.00040564159522681,0)	(0.00040564159522677,0)	(-0.00040564159522689,0)	(-0.00040564159522691,0)	(0.00042366045542673,0)	(0.00042366045542665,0)

"""
read_cluster_model_instance(solution[0], 9)
