from pyqcm import *
set_global_parameter("nosym")
new_cluster_model('tet', 8, 0, generators=None, bath_irrep=False)
add_cluster('tet', [0, 0, 0], [[0, 0, 0], ( 1, 0, 0), ( 0, 1, 0), ( 1, 1, 0), [0, 0, 1], [0, 1, 1], [1, 0, 1], [1, 1, 1]], ref = 0)
lattice_model('lattice_tet', [( 2, 0, 0), ( 0, 2, 0), [0, 0, 2]], None)
interaction_operator('U')
hopping_operator('wz', [0, 0, 1], 0.5, tau=2)
hopping_operator('a', ( 1, 0, 0), 1, tau=2, sigma=1)
hopping_operator('a', ( 0, 1, 0), 1, tau=2, sigma=2)
hopping_operator('vz', [0, 0, 1], 0.5, tau=2, sigma=3)
density_wave('AF1', 'Z', [0, 0, 1])

try:
    import model_extra
except:
    pass		
set_target_sectors(['R0:N8'])
set_parameters("""

U = 2
mu = 0.5*U
a = 1
vz = 1
wz = 0.2
AF1 = 0
AF1_1 = 0.2
""")
set_parameter("AF1", 0.0)
set_parameter("AF1_1", 0.2)
set_parameter("U", 2.0)
set_parameter("a", 1.0)
set_parameter("vz", 1.0)
set_parameter("wz", 0.2)

new_model_instance(0)

solution=[None]*1

#--------------------- cluster no 1 -----------------
solution[0] = """
AF1@1	0.2
U	2
a	1
mu	1
vz	1
wz	0.2

GS_energy: -16.6832 GS_sector: R0:N8:1
GF_format: bl
mixing	2
state
R0:N8	-16.6832	1
w	16	325
-1.4806183763277	(-0.010154657143264,0)	(-0.015806384660522,0.01646925422573)	(-0.17982832561898,0.033949843541463)	(0.29808095066874,0.074078723356318)	(0,0.012349145279675)	(0.041286627820184,0.21869040846367)	(0.020028368285792,0.019222248251743)	(0.090087622255868,-0.36249820284226)	(0.24834614391219,-0.022954221105901)	(-0.37711751072443,-0.10656797323894)	(0.080873617289426,-0.37711751072446)	(-0.062949158208423,-0.20667394618768)	(-0.016840853070916,-0.18220443643262)	(-0.27668029158018,-0.059334651339297)	(-0.078185862683014,0.27668029158018)	(-0.15163074125984,0.046183990275002)
-1.4806183763277	(-0.0007236907516276,0)	(0.04079112512349,-0.35519599324804)	(-0.0012927460381787,0.014649896655365)	(0.020038185526567,-0.0029105651498986)	(0,0.00088008507853411)	(0.017815835589241,0.0015721169518668)	(-0.43195618143411,-0.049606355307155)	(-0.0035395574045391,-0.024368569092739)	(-0.44774116335058,-0.070141282354186)	(-0.025351337038692,0.0027667270501221)	(-0.0045978836817485,-0.025351337038675)	(0.033072609923753,-0.45101220208571)	(-0.051460645294031,0.32849483809509)	(-0.018599548215975,0.0033733352643107)	(0.0020298682113133,0.018599548215977)	(-0.33089470531224,-0.024264424474605)
-1.4806183763278	(-0.35812741453804,0)	(0.00016744903389749,5.1217779715692e-05)	(-0.0032189541548499,0.00031463730141565)	(-0.013309032998873,-0.0034723826985083)	(0,0.43552110212783)	(0.00038263248978826,0.003914591299921)	(6.2286278476791e-05,-0.00020363587045239)	(-0.004222787417199,0.016185202485557)	(0.0041372623672775,-0.00060991216754841)	(0.016837940778934,-0.44869228467353)	(-0.45747846384134,0.0168379407789)	(-0.0001862154321901,-0.0040076658831726)	(-0.00044747504837423,-0.0030353906290892)	(0.012353513777104,0.3356388159333)	(-0.32919264850566,-0.012353513777113)	(-0.0029403094090808,0.00013662091684245)
-1.4806183763278	(-0.0097999150961225,0)	(0.007247018635127,0.0072929136152767)	(0.30406653929383,-0.047758705523307)	(0.17601359363272,0.05034918619726)	(0,0.011917741145081)	(-0.058079675616387,-0.36977731650126)	(0.0088689601703475,-0.0088131469834205)	(0.061229976186446,-0.21405128782809)	(-0.37546354677636,0.051253414484346)	(-0.22268383180983,-0.076097715406448)	(0.051300964201328,-0.22268383180982)	(0.06959056499146,0.39391682547367)	(0.037603158858281,0.27546682571229)	(-0.16337673473974,-0.037638044720605)	(-0.055830709231175,0.16337673473974)	(0.28900546654806,-0.05105659977461)
-1.666379518186	(-0.0094390017420683,0)	(-0.025564771089129,-0.0024389649508142)	(-0.078378219205968,-0.0080562217659468)	(-0.44627350550878,0.15223386766818)	(0,-0.012475575230956)	(0.010647948105625,-0.10359287951134)	(0.0032235920239188,-0.033789084237956)	(-0.20120825492921,-0.58984189681289)	(0.048277799802671,0.021374288938503)	(0.28371496622551,-0.10278228960067)	(0.090780743340831,0.2837149662255)	(-0.011130926256131,-0.051378906411526)	(-0.018109178086776,0.040902940761163)	(-0.24037500681482,0.076913185404049)	(0.087081389790219,0.24037500681482)	(0.043530326027983,-0.0094305792544933)
-1.666379518186	(0,0)	(0.17539786889586,0.44453402250834)	(-0.00078346043938288,0.011875702629074)	(-0.019375343569525,-0.019997032823725)	(0,0)	(-0.015696174830569,-0.0010355035330101)	(-0.58754281353836,0.2318242297816)	(0.026430177068047,-0.02560848730965)	(0.28310718219779,-0.11905774007252)	(0.012317726413476,0.012712995517438)	(-0.012712925681822,0.012317726413464)	(0.10395796592633,0.28211102423925)	(0.1008706218852,0.23986006714946)	(-0.01043608523713,-0.010770914337227)	(-0.010770973504836,0.010436085237135)	(-0.239016081091,0.088077471204487)
-1.666379518186	(-0.017025038953849,0)	(-0.016006242268015,-0.00026244586845038)	(0.4440484352897,0.15977920548827)	(-0.077444332399875,0.0062998676761508)	(0,-0.022502078088642)	(-0.2111809651999,0.58690101051268)	(0.00034687600079633,-0.021155529476143)	(-0.0083265662287783,-0.10235855670632)	(-0.28246724281264,-0.09140256121113)	(0.049234641716256,-0.014828630906955)	(-0.0068184455703909,0.049234641716273)	(-0.11175425329418,0.2821335469074)	(0.077440015119128,-0.23931788414051)	(-0.041713616646734,-0.0057768679680569)	(0.012563426958868,0.041713616646729)	(-0.23903516322323,-0.09468280702482)
-1.666379518186	(-0.47844842382312,0)	(0.0010739348799399,5.7506640165347e-05)	(-0.014254681307362,-0.0055266225621144)	(0.011560009046366,-0.0032275000943668)	(0,-0.63236764529243)	(0.0073045643417422,-0.018840482701773)	(-7.6006810394295e-05,0.0014194250360287)	(0.0042658028185133,0.015278921062796)	(0.009098863970241,0.0028307621218029)	(-0.0073491872935957,-0.30211806585209)	(-0.30622178282817,-0.007349187293615)	(0.0041962538860672,-0.0090257451573493)	(-0.00239833828075,0.0077089323765695)	(0.0062265342194794,-0.25944370899233)	(0.25596687092061,-0.006226534219477)	(0.0076469831062174,0.0035552391538658)
-3.6855229638185	(0.0028475829988754,0)	(-0.00020744303837493,0.00029024940017561)	(0.00045986128971609,0.00027506182292974)	(0.0018901321843198,0.00049671020312267)	(0,0.03474042572481)	(-0.003355730176162,0.0056102988254407)	(-0.0035410402068443,-0.0025307869013759)	(-0.0060598366562017,0.02305957456926)	(0.000729631379103,0.00029087768397393)	(0.0081309193437319,-0.010112931577815)	(-0.014386393402468,0.0081309433567899)	(0.002075615956854,-0.0032268110784677)	(0.00015017353516999,-0.0003766918055869)	(0.0041978165886673,0.0074273611017662)	(-0.0052210717714736,-0.0041978054261256)	(-0.0016659277257332,-0.0010715930964936)
-3.6855229646028	(0.0014950133806643,0)	(-0.00070445569814534,-0.0013917583935301)	(-0.0020736019358639,-0.0011646949566955)	(-0.0012801141359137,-0.00061572250597766)	(0,0.018239128512121)	(0.014209230371202,-0.025297888498634)	(0.016979405085659,-0.00859434644784)	(0.0075117921029829,-0.015617353164247)	(-0.0029331378877941,-0.0080406650274759)	(-0.0055067599069817,-0.0090799158225622)	(-0.0037825178433296,-0.0055067715877387)	(-0.0019798403106419,0.014907204509817)	(-0.0041512086583656,0.0015143118053882)	(-0.0028430174051299,0.0019528257835067)	(-0.0046877492625627,0.0028430126408094)	(0.0076962434524613,0.0010221454212716)
-3.6855229655535	(0.00084129898626519,0)	(0.0025391869138692,-0.00070659478605015)	(-6.9982370469026e-05,0.0018598891495818)	(-0.0010237158702882,-0.00041934220007068)	(0,0.010263837023915)	(-0.022690596132453,-0.00085377713546755)	(0.0086204355502425,0.0309780136144)	(0.0051159454810297,-0.012489293416704)	(0.0027385636782888,0.018923845360036)	(-0.0044037914574371,-0.0054229953465064)	(-0.0018151732530395,-0.0044037922000273)	(-0.0029221873240839,0.003340657158044)	(0.009769941512052,-0.0014138576256094)	(-0.0022735760779577,0.00093713155835101)	(-0.0027997665663039,0.002273576122289)	(0.0017247041555091,0.0015086575220435)
-3.6855229691343	(0.0011361687172484,0)	(-0.00043332795786134,0.001627087459409)	(0.001627791771336,-0.00053403500364524)	(-0.0022947909295657,-0.00012420577034281)	(0,0.013861227889849)	(0.0065152227782972,0.019859029295678)	(-0.019850414033821,-0.0052865837273427)	(0.0015153020727675,-0.027996377014465)	(3.0366461229714e-06,-0.0041613817631345)	(-0.0098716834907782,-0.0054218498307089)	(-0.0043532409420626,-0.0098716718552712)	(-0.00043322467786189,-0.014001768705957)	(-0.0021484246717835,-1.5673688776658e-06)	(-0.0050965145854614,0.0022474771940122)	(-0.002799175014291,0.0050965203725276)	(-0.0072287875702889,0.00022366382832676)
-3.7066297253428	(-0.0062582098481733,0)	(-0.01370703834754,-0.0050899215939275)	(0.01524734460845,-0.0051032966689398)	(-0.0021046241116733,-0.020009381053486)	(0,0.00068253625749581)	(-0.00055657819109581,-0.0016629152530998)	(-0.00055511984803648,0.0014949272288532)	(-0.0021822801332779,0.00022953768762006)	(0.001447140348824,-0.0013384921330982)	(-0.00014975889336921,-0.00097849327616763)	(0.0018691263102877,-0.00014975685474838)	(0.00061221450670885,-0.00072277709155814)	(-0.0046224859857019,-0.0049977163596628)	(-0.00051719252905739,-0.0064550444365057)	(-0.0033792370186929,0.00051719424720358)	(-0.0024961044052494,-0.0021142978766798)
-3.7066297255011	(0.017324930487893,0)	(-0.0090715570267241,0.00102157438385)	(0.0010984219457357,0.019380207921047)	(-0.012280291418767,-0.0022783394691131)	(0,-0.0018895029088191)	(0.0021136558136658,-0.00011979854928547)	(0.0001114169989454,0.00098936620374795)	(-0.00024848264445892,0.0013393244536486)	(5.4635267484107e-06,0.00073353617272983)	(-0.00087383321254292,-0.0013949110852351)	(-0.0010706666122221,-0.00087383378056355)	(0.0020245470919523,-0.0001508474568672)	(0.0025332671498646,-1.8883207629639e-05)	(-0.003017781950304,0.0036975748936321)	(-0.0048173422214407,0.0030177809554011)	(-0.00052096952682711,-0.0069917882869604)
-3.7066297268815	(0.018092603428397,0)	(0.0013610110501364,-0.017723188590728)	(0.0040264021294968,-0.015154986908415)	(-0.0014396701645201,0.0050021140182138)	(0,-0.001973228638099)	(-0.0016528446322763,-0.00043912730836216)	(-0.0019329399488946,-0.0001484318304346)	(0.00054554507080841,0.00015701408221014)	(0.0015476402874546,-0.00098153643483208)	(-0.00010244315538008,-0.00093148219809511)	(-0.0016433535834542,-0.00010244585486151)	(-0.0011752267822032,0.00097462160580353)	(-0.0033897549107589,-0.0053447840072446)	(-0.00035378814852747,0.0056753369824316)	(-0.0032168802481933,0.00035378688442769)	(0.0033658717832431,0.0040586698798871)
-3.7066297291384	(0.01579951770016,0)	(0.0029594805991017,0.017159143276913)	(0.00022424143528641,-0.00591822593212)	(0.014280908674179,-0.011155539825256)	(0,-0.0017231333763406)	(-0.00064545901406813,-2.446076002488e-05)	(0.0018714215982305,-0.00032277233078811)	(-0.0012166541735487,-0.0015575121625563)	(-0.0012050325392175,-0.00021053461500249)	(0.0010161831105354,-0.0019180398645737)	(-0.00033045465251591,0.0010161878442992)	(-0.00063170983556798,-0.0012369510836188)	(-0.00072708740969615,0.0041616114790227)	(0.0035094155299688,0.0011412210493044)	(-0.0066239828026023,-0.0035094153003278)	(-0.0042718236608764,0.0021816221313976)
-3.7264563724134	(-0.0011975296860064,0)	(0.0055227806950644,-0.0016701932779943)	(-0.0056514374902781,0.0046450310049062)	(-0.0060484560053408,0.0041681457236976)	(0,-0.001213330222992)	(-0.0047062728986105,-0.0057259618680755)	(0.0016922280548359,0.0055956088308875)	(-0.0042230998675266,-0.0061282080715829)	(0.0067516314149966,-0.017243192746805)	(0.010257335730948,-0.0090994399386004)	(0.0050377253253383,0.010257333737677)	(0.0014885449496364,-0.012416486110144)	(-0.0026510645231956,-0.0010380348684537)	(0.001577019360251,-0.00077452465259615)	(-0.001398998461082,-0.0015770200298719)	(-0.0019089811946025,-0.00022885760034264)
-3.7264563796409	(0.0041794072850931,0)	(0.001250174309485,0.0040231540312339)	(0.0078372529478629,0.0026171296097637)	(-0.006219615902155,-0.0001593000470905)	(0,0.0042345149647149)	(-0.0026516374800474,0.0079405962240498)	(-0.0040761978848536,0.0012666649058496)	(0.00016140164125064,-0.0063016459379691)	(-0.0064681746924307,-0.0065584276238981)	(0.010547606493601,0.0073578419371982)	(0.0068175299212623,0.01054761034465)	(-0.0023181664075098,0.020113590611129)	(-0.0010083322651726,0.00099445100433391)	(0.0016216481930312,-0.0010481638106751)	(0.0011312359162566,-0.0016216472673383)	(0.0030923751838418,0.00035640963972446)
-3.7264563917031	(0.002617778084977,0)	(-0.00043426012988261,-0.009518116586615)	(0.00093836557873165,-0.0020965050482731)	(-0.0040625115002325,-0.0047729767808275)	(0,0.0026522946053488)	(0.0021241548917155,0.00095073334362237)	(0.0096436294208349,-0.0004400002318371)	(0.0048359126065493,-0.0041160840975422)	(-0.017732741694393,0.0042918212906837)	(0.0068894627813817,0.012533682760917)	(-0.0036549264183289,0.0068894497306883)	(0.0028189372156944,-0.014550062554556)	(0.00065984433962156,0.0027263324576036)	(0.0010592216829209,0.00056193089153124)	(0.0019269985456625,-0.0010592250832245)	(-0.0022370066045849,-0.00043340139753339)
-3.7264563972209	(0.010790861946973,0)	(0.00023403790541411,0.00056545299242752)	(-0.0038902623487507,1.0445964437275e-05)	(0.0027232089098087,0.0016821562554645)	(0,0.010933155915715)	(-1.0588694041958e-05,-0.0039415578009273)	(-0.00057291559477822,0.00023712750756306)	(-0.0017043337287209,0.0027591177577721)	(0.0075562746727988,-0.00041461689923959)	(-0.0046181788542028,0.015447118983646)	(0.021152504170987,-0.0046181915423459)	(0.00037917983266945,-0.0056384052872787)	(-6.3744602593042e-05,-0.0011617439120571)	(-0.0007100250537664,-0.0032521059466097)	(0.0023749284299302,0.00071002604015742)	(-0.00086688038384196,-5.8297349489244e-05)
-3.8373158126634	(0.0074527098790141,0)	(0.0011296846100034,0.001982990448494)	(-0.0018856991139113,0.00225119403925)	(0.0029547036818088,-0.00014647747536699)	(0,-0.019643787125329)	(0.005933690649242,0.0049703041499588)	(0.0052267368615699,-0.0029776222162258)	(-0.00038608131484209,-0.0077879821724656)	(0.0023188423107007,-0.0020264312230855)	(-0.0017710246697936,0.0045548263493149)	(0.0043792570036171,-0.0017709894222316)	(-0.00067221917043825,5.8307134588163e-05)	(-0.006369771938876,-0.0072888372500595)	(-0.0055668273360384,-0.013765380560823)	(0.014317304512188,0.0055668439435164)	(0.00018329652884033,0.0021129913623051)
-3.8373158709711	(0.0031626105455719,0)	(-0.0024016844787299,-0.0074000886256837)	(-0.0012984982714659,-0.00090473260371503)	(-0.0022436474865667,-0.00023804224573723)	(0,-0.0083359966202386)	(-0.0023846956379572,0.0034225879689127)	(-0.019505079354295,0.0063303695171036)	(-0.00062742341471518,0.0059137879492753)	(-0.0036572145226099,0.0019818029680451)	(0.0013448110310239,0.0020382985258007)	(0.0017529405788591,0.001344813821851)	(-0.0008972336261132,-0.0052138050719722)	(0.006229493498535,0.011495753596056)	(0.0042271657640325,-0.0055100672095112)	(0.0064070344375853,-0.0042271696978085)	(-0.016388663441086,0.002820342187631)
-3.8373158822034	(0.0021374065572101,0)	(-0.0011416170488144,-0.00029178428224371)	(0.0067784957061541,-0.0039553846871753)	(0.0026726126619885,0.00185310657221)	(0,-0.0056337541677604)	(-0.01042558212366,-0.017866680409694)	(-0.00076908297440609,0.0030090655694436)	(0.0048843978793243,-0.0070444543385087)	(-0.0042378196533646,0.0030550601853526)	(-0.001601929237355,0.00017040288392107)	(0.0023918514030982,-0.0016019261681979)	(0.0016865330187627,0.0038880347145862)	(0.0096030546287858,0.013320821944609)	(-0.005035362260755,-0.0075183646391166)	(0.00053563438962881,0.005035365196666)	(0.012221340256519,-0.0053013058945037)
-3.8373159316362	(0.0028307732933478,0)	(0.00057104151006254,0.0032671806342817)	(0.0012971191612849,-0.0019294772486411)	(-0.0072903120816514,-0.00074763508416711)	(0,-0.0074613301479858)	(-0.0050857027124721,-0.0034189269863736)	(0.0086116002294797,-0.0015051329049652)	(-0.0019705970835452,0.01921574146503)	(0.001180822719971,0.00081423323226249)	(0.0043697021731481,0.0021448524712904)	(0.0012486020085944,0.0043697020328186)	(0.0014987663387042,0.0027357799005637)	(0.0025593878565971,-0.0037117113571707)	(0.013735388621563,-0.0039247621282295)	(0.0067419397726325,-0.013735384997047)	(0.0085994140077599,-0.0047111187047906)
-4.0005404567534	(0.021822992861268,0)	(-0.0063165334970157,-0.0017756278601785)	(-0.010286771085429,0.0029001527697061)	(-1.1229347569542e-05,0.0078374992084172)	(0,-0.0030772214799638)	(0.0004087699378242,0.0014505756791791)	(-0.00025057474137192,0.0008907402014853)	(0.0011053017140284,1.7607125879848e-06)	(-0.0070809535116273,-0.0028424393646384)	(-9.3325253914678e-06,-0.011635446766033)	(-0.024676731151257,-9.4975332658119e-06)	(0.0076679600923298,0.010035671822879)	(0.002110638210566,-0.0052587050164517)	(6.6841901903008e-06,-0.018325632057907)	(0.0086410863547747,-6.9480364894826e-06)	(-0.0074525746066258,0.0056946071500889)
-4.0005404783343	(0.010473086152605,0)	(0.016232215884801,-0.0096984040098032)	(0.0066794023145711,-0.00061256144633484)	(0.0098393013879653,-0.00926930043056)	(0,-0.001476824589373)	(-8.6255531459063e-05,-0.00094184079584895)	(-0.0013674061900283,-0.0022890758896541)	(-0.0013070671048386,-0.0013875858935656)	(0.013625787185976,0.012995234413088)	(0.0081861491660933,-0.016425118541531)	(-0.0010015083684107,0.0081860203568306)	(-0.014014400297718,0.0025116656429089)	(-0.0096504138130682,0.010119118536307)	(-0.0060792187037353,-0.00074375357469438)	(0.012197796158934,0.0060789838011651)	(-0.0018653656745576,-0.010407485110586)
-4.0005405230816	(-0.0034860845570303,0)	(0.0045342158219962,0.0044767732944339)	(-0.020893213672247,0.0025659917943824)	(0.0018026682544365,-0.013994217565878)	(0,0.00049160796677381)	(0.00036172540856653,0.002946308087964)	(0.00063127578081918,-0.00063926199494043)	(-0.0019734006393036,-0.00025432423419647)	(-0.021107190040838,0.0059070930738065)	(0.0014998080327407,-0.008742487925225)	(0.01454317211874,0.0014998071624686)	(-0.001637482034545,0.013658091864169)	(-0.0043869605335061,-0.015674716461765)	(-0.0011137158574319,0.010800084587105)	(0.0064923992877406,0.0011137135900329)	(-0.01014276976129,-0.0012161038800411)
-4.0005405495612	(-0.009842158166624,0)	(0.0016611566893137,-0.015842877310602)	(-0.0083009789933775,0.0048699370080502)	(0.0098068694696106,0.012471294988705)	(0,0.0013879710502521)	(0.00068670314372686,0.0011706103981131)	(-0.0022341838749888,-0.00023445359697869)	(0.001758722787196,-0.0013829731388033)	(0.0062746960709959,0.0054337853421227)	(0.0081590296816737,0.018564294137512)	(-0.0021873789512591,0.0081591467761931)	(0.0026695246015327,0.020087130115761)	(-0.0040350566495519,0.0046596898091193)	(-0.0060589721084221,-0.0016243941460918)	(-0.013786124515194,0.006059184639841)	(-0.014917060636663,0.0019827000389157)
-4.0124427688722	(0.004393656858873,0)	(0.0013311801797015,-0.0006664669034329)	(0.00012278255539583,0.0076320935477479)	(0.00015117995765071,0.0032889465078181)	(0,-0.013964806358211)	(0.024258525644947,-0.00039082083986141)	(-0.0021186775426409,-0.0042313005093995)	(0.010453693367365,-0.00048050116582154)	(0.0015559428451363,0.01766720462294)	(0.00029778123470058,-0.0021773557505604)	(-0.015142645067917,0.00029812358367886)	(0.012419398410916,0.0010715825886924)	(0.013493858972617,-0.0011886947078558)	(0.00022790769686464,0.011565450509517)	(-0.001662939965844,-0.00022725131759879)	(0.00081834637731035,-0.009485552373752)
-4.0124428993854	(0.0053797916213616,0)	(-0.0040395597984777,-0.0048594098344195)	(-0.0021018050766422,-0.001325555003914)	(0.0018829130549892,-0.0034682449444374)	(0,-0.017099403807098)	(-0.0042130763500722,0.0066806540978769)	(-0.015445098227727,0.012840341433372)	(-0.011024218846482,-0.0059848556051036)	(0.0054351920506256,-0.010575103004834)	(0.0037111831117215,-0.017440058928838)	(-0.0037675483768087,0.0037115232494222)	(0.0053497540989647,0.013720815150743)	(-0.0080771734553141,-0.0041510808958044)	(0.0028349528698875,0.0028773412399386)	(-0.013320420238351,-0.0028343929228784)	(0.010479565088997,-0.0040863351918031)
-4.0124429672688	(-0.0048688597867615,0)	(0.00023211915294963,-0.00094872886279879)	(-0.0021266305168001,0.0045476978482819)	(0.0045624458644928,-0.0044653832164879)	(0,0.015475964760524)	(0.014455009007659,0.0067592514125841)	(-0.0030158294988066,-0.00073774740340063)	(-0.014193659756704,-0.014501992485686)	(-0.0023215371327493,0.0094213539955364)	(0.0089931430248207,0.00079520571473764)	(0.018398614788589,0.0089927853051376)	(0.0085063160749852,0.0060617301874045)	(0.0071959482927231,0.0017729554308131)	(0.0068684118743773,-0.014052787586788)	(0.00060729718142265,-0.0068690915645257)	(0.0046298706104198,-0.0064970510566385)
-4.0124430061925	(-0.0043212444455042,0)	(-0.0039372298689349,-0.0056584732588908)	(-9.5455874627439e-05,0.0009853800148064)	(-0.0026433215191323,0.0040575072895536)	(0,0.013734540301098)	(0.0031322684375899,0.00030389661926198)	(-0.017985021920642,0.012515195572051)	(0.012897196716006,0.0084012372817832)	(0.010964695149349,-0.0058184218106417)	(-0.0052098118936311,0.016514965430251)	(0.00051954067457688,-0.0052100846334551)	(0.00970309040636,0.011341389039871)	(-0.0044441503272047,-0.0083742945701694)	(-0.0039792744302004,-0.00039648893367226)	(0.012613735134123,0.0039788374584014)	(0.0086623580799565,-0.0074113662091302)
-4.1182884250263	(0.011812190599131,0)	(0.0010304553386857,0.0094374409160716)	(-0.00083429242831302,-0.0022535033984545)	(0.0079256248578251,-0.0051708890669422)	(0,0.050294983616575)	(0.0095951224352896,-0.0035522674574098)	(-0.040183595593654,0.0043878725478428)	(0.022017254813435,0.033746351355765)	(0.0015384385473712,0.00018316984158536)	(-0.0011870146806594,0.0025436469751188)	(0.00099470197512689,-0.0011870677630002)	(0.00049185602238297,0.0012885401029599)	(-0.00084043993572167,0.0070582867741129)	(0.0054461810791035,0.0045636170383663)	(-0.011670052588212,-0.0054461295626422)	(-0.0059117551902352,0.0022566179157554)
-4.1182886138645	(-0.0083417059884448,0)	(-0.0028173836343192,0.0051868248719134)	(-0.0097176238785712,-0.010845309852622)	(0.00066279081086339,-0.0028402070664407)	(0,-0.035518006865381)	(0.046178110335752,-0.041376660230313)	(-0.022084966101438,-0.011996029596805)	(0.012093027461526,0.0028221747143159)	(0.0022323195880895,0.0020463790079717)	(-9.9279047427843e-05,-0.00082400751878521)	(-0.0016747375084649,-9.931474204201e-05)	(0.0012024428179716,-0.00067860579446066)	(-0.0093884397078189,0.010241682668108)	(0.00045545057590111,-0.0076837115293133)	(0.0037803858313742,-0.00045544735291839)	(0.0031133501361398,0.0055164405371108)
-4.1182886680354	(-0.0082885860145975,0)	(0.00090027166774948,0.012487130477423)	(0.0084712755670651,0.0048453289888913)	(-0.0013762588293062,-0.0015522325477475)	(0,-0.035292123804735)	(-0.020630850744498,0.036069731152686)	(-0.053168884797297,0.0038334523491099)	(0.0066091588430998,-0.0058599907220589)	(0.00060152327911213,-0.0008605580322423)	(0.00020612631396981,-0.0010089702944131)	(-0.0014739176223361,0.0002061313458907)	(-0.00059087590056576,0.0031390629117916)	(0.0039481415861897,0.0027595343470391)	(-0.00094570947238203,-0.006762197889174)	(0.0046289490328765,0.00094570401775531)	(-0.014401708951391,-0.0027108891523945)
-4.1182887916153	(-0.006868062309121,0)	(0.004107669471308,-0.0051384065788581)	(0.00014438437912871,0.0034490379249896)	(0.014486966861669,-0.0035703672751098)	(0,-0.029243552951443)	(-0.014685571777966,0.00061488149726024)	(0.021878867959498,0.017489930743856)	(0.015202330136928,0.061684051193874)	(-0.00079126240695214,-0.0011317885950123)	(-0.002169817396512,-0.00049391797613426)	(-0.0015634228606024,-0.0021698633446173)	(9.8628928042113e-05,-0.00074797523250848)	(0.0051926305900238,-0.0036300901958759)	(0.00995483354397,-0.0071728258466306)	(0.0022660460907429,-0.0099548417850899)	(0.0034316530871845,0.00045257910496702)
-4.2126279188087	(0.010853775638408,0)	(0.0037084141496405,0.015331553507015)	(0.0072101831388154,-0.0075024318316659)	(-0.026158129996318,-0.0069836542837206)	(0,-0.0098387126142424)	(-0.0068008305146741,-0.0065358277899605)	(0.013897920274728,-0.0033617627465158)	(-0.0063305767042319,0.023712039361161)	(0.010022820258117,0.0046822896205105)	(0.03228251940711,0.022013718292615)	(0.0047762208908348,0.03228247070337)	(0.01383563229041,0.0278194499708)	(-0.00080147296899321,0.001715690745707)	(-0.0055259557713142,0.00081755667343238)	(-0.0037681701459854,0.005525900625142)	(-0.0047619714300227,0.0023682974750161)
-4.2126279924356	(0.0082036174084462,0)	(-0.011662719044331,-0.0021442764853954)	(0.026800043696852,-0.0070385740281125)	(0.0061810069538679,0.013928305330235)	(0,-0.0074365385534309)	(-0.0063806281216897,-0.024294117445337)	(-0.0019436398332869,0.010572096637523)	(0.012625674120989,-0.0056032222180908)	(-0.035721144129042,0.023079803586117)	(-0.0076281737940563,-0.007065030411703)	(0.02731370306492,-0.0076281193906038)	(-0.0057068235971265,0.030428452703039)	(-0.0039507140922884,-0.0061145582397947)	(0.0013058450161727,0.0046753656394215)	(0.0012093054679088,-0.0013057637768979)	(-0.0052086266881271,-0.00097676765672191)
-4.2126280419897	(-0.009333372794556,0)	(0.002527259273227,0.028135086860631)	(0.0031648201458958,0.013102571432899)	(0.0076677542018217,0.0090738417600758)	(0,0.008460552893451)	(0.011877328815044,-0.0028688974861994)	(0.025504088054745,-0.0022910705456459)	(0.0082253069724374,-0.0069507746790906)	(0.030816685708984,-0.019289171350051)	(-0.0094630319209561,-0.022716944244172)	(-0.0003202572555413,-0.0094630118917661)	(-0.013051396094745,0.038628201670109)	(0.0033018015386838,0.0052750366499926)	(0.001619878641975,-5.4808788486296e-05)	(0.0038885611814731,-0.001619815599349)	(-0.006612147539699,-0.0022340643112043)
-4.2126281395424	(-0.030589002100008,0)	(-0.0025830807432159,-0.003719656131509)	(0.0087801621199817,-0.0085475582794529)	(-0.0099634651165222,-0.0015112067636852)	(0,0.027728660180044)	(-0.0077483940331342,-0.0079590129157351)	(-0.0033718231529614,0.0023416101552196)	(-0.0013696606062595,0.0090318498287956)	(-0.015426508783184,0.013736660495476)	(0.012296302245313,-0.035885936008046)	(-0.039616034189159,0.012296232223891)	(0.0073609650236987,0.0062453605309423)	(-0.0023513706150279,-0.0026406048964147)	(-0.0021048061991194,-0.0067812420513457)	(0.0061427861448993,0.0021048465617001)	(-0.001069053931665,0.0012600261268842)
-4.2797994264478	(0.0086200835048049,0)	(-0.0017928554837957,0.0042801926356391)	(0.0032622224616821,-0.0032695014956308)	(0.0085125860709938,-0.0024175968784078)	(0,0.046553335386556)	(0.017657691069249,0.017617680499658)	(-0.023115751401312,-0.0096822743411249)	(0.013057083968082,0.045973334228965)	(0.0017199709840302,0.0085542351140611)	(-0.014384277683421,0.018650895142013)	(0.01048067367423,-0.01438439701219)	(0.0024951179547022,0.012744861329581)	(0.010169829292823,-0.0020450945477939)	(-0.017101103635594,-0.012459859269329)	(0.022173615499819,0.017100903648894)	(0.015151870401936,-0.0029666307817063)
-4.2797994966397	(0.0076898502465059,0)	(0.0043393519125864,0.00074868912693172)	(-0.0042601598084776,0.0097748209667551)	(-0.0016631716714388,0.00070217448509824)	(0,0.041530193274988)	(-0.052790087675424,-0.02300686391167)	(-0.0040433569347737,0.023435257028846)	(-0.0037923494391916,-0.0089819382937217)	(0.0084637489583235,-0.023849917323201)	(0.0028104765153344,0.011807481246011)	(0.01418098579361,0.0028103605299699)	(-0.0091846232031625,-0.0059334785632956)	(-0.028354084885307,-0.010062118788804)	(0.0033410266317256,-0.016859010400013)	(0.014037590467001,-0.0033411366311453)	(-0.0070540020618126,0.010919305505053)
-4.27979954135	(-0.0062643082325636,0)	(0.00099827975056404,0.010899291463722)	(0.0025107685133894,0.0051130638609184)	(0.0018869825980843,-0.00066221899752609)	(0,-0.033831245007226)	(-0.027613689420076,0.013559994175699)	(-0.05886289508195,0.005391660708403)	(0.0035765004061019,0.01019078486575)	(0.014174282849897,-0.01032694786299)	(-0.0031885197535286,-0.0094660911378747)	(-0.011704280037145,-0.003188214247082)	(-0.0069528573575553,0.02266010978057)	(-0.012277227142057,-0.016851625023911)	(-0.0037906904502323,0.013914823499248)	(-0.011254078817028,0.003790743841872)	(0.026939675564398,0.008266116514707)
-4.2797996570131	(0.0047747749262853,0)	(-0.0024421636090214,0.0053664607854669)	(0.0042656491251692,-0.0031318116832813)	(-0.010213659107603,0.0023648615098553)	(0,0.025787084663186)	(0.016914108108734,0.023037439780247)	(-0.028982537263976,-0.013189238253366)	(-0.012771981230212,-0.055160104145922)	(0.0018599903994182,0.0094189856342865)	(0.017259034044693,0.0040721703887727)	(0.012064489874601,0.017258401442137)	(0.0011653588081983,0.016276215432633)	(0.011197800220701,-0.0022113989761045)	(0.020518227282245,-0.014343092672144)	(0.0048413330986241,-0.020518446334757)	(0.019350255867667,-0.0013855325136101)
-4.3168514571911	(0.011120376921325,0)	(-0.0017386044673685,0.008032727799703)	(-3.0207301530271e-05,-0.0063557269003417)	(-0.026448611269694,0.0057371333928255)	(0,0.0046373294656613)	(0.0026503852406047,-1.2595680366489e-05)	(-0.0033498294212792,-0.00072496043283113)	(-0.0023923911196828,-0.011029493706868)	(-0.016633455029102,-0.016698424323618)	(-0.0545629806474,-0.011105499015675)	(-0.034776555852403,-0.054562601372979)	(-0.0095251023571711,-0.016509003373466)	(0.00057714152112668,-0.00057505305921058)	(0.0018862547963462,-0.0012021218852208)	(0.00038390270903486,-0.0018860768300268)	(0.00057068887066297,-0.00032927908011227)
-4.3168515836518	(0.010362863891423,0)	(-0.00029885318097614,-0.023534525245053)	(-0.010462490636721,-0.013864232829894)	(0.00036861532183105,-0.00094053421900813)	(0,0.004321394617849)	(0.0057815657742905,-0.0043628379786742)	(0.0098142402341815,-0.00012442702222505)	(0.00039225942657251,0.00015368283427542)	(0.02696722071171,-0.029217953038889)	(0.00076037242790708,-0.02331846328599)	(-0.019437921705772,0.00076054692311341)	(-0.027985010169997,0.070134804310557)	(0.0010099765130915,0.00093228803247553)	(-2.6242043826312e-05,-0.00067191397094272)	(0.00080610073534453,2.6326069458148e-05)	(-0.0024243831707344,-0.00096742797670443)
-4.3168516195956	(0.011056324689134,0)	(-0.007968661436077,-0.011404940159327)	(0.02140014988343,0.011115397685787)	(0.00077693932536802,0.0081312065372173)	(0,0.0046106693477979)	(-0.0046353686596604,0.008924260183215)	(0.0047559353838862,-0.0033229879311717)	(-0.0033907341733689,0.00032400812508927)	(0.067675897266861,0.0064917011711131)	(0.0016028351773656,-0.0060342341614043)	(-0.039583314500759,0.0016027683350963)	(0.039369777330849,-0.02061964494485)	(-0.00022446080297021,0.0023394582301534)	(-5.5359623943276e-05,-0.0013682783967997)	(0.00020869091284744,5.5411279419662e-05)	(0.00071290177487029,0.0013610203992694)
-4.3168517905692	(0.024713605920075,0)	(0.0044726477707311,0.011356282648093)	(-0.0051733095748533,0.0037007083391814)	(0.011398999174415,-0.0058248665393612)	(0,0.010305792055327)	(-0.0015432701716713,-0.0021574211379823)	(-0.0047356242739717,0.0018650170169213)	(0.0024290325484602,0.0047534412158104)	(-0.034100037109156,0.016861111287486)	(0.023515796896093,-0.062999677905977)	(-0.038966824314508,0.023515736937505)	(-0.0015925509779298,-0.012755382394215)	(-0.00058289843713145,-0.0011787589309534)	(-0.00081287282830397,-0.0013469494427756)	(0.0021778182384608,0.00081283519380153)	(0.00044088583175682,-5.5010465924892e-05)
-4.5820369877859	(0.025611370712112,0)	(-0.0065436249389688,0.030008465714653)	(0.0032286642890182,-0.017366573465712)	(0.022732152753116,-0.019097066104621)	(1.3772211391671e-06,0.047937797166686)	(0.032505203736727,0.006042737235803)	(-0.056168449469783,-0.012245742485127)	(0.03574540594598,0.042548508557469)	(0.010512914330344,0.0093872570713239)	(-0.0089244080118,0.017551388474722)	(0.0025576983556983,-0.0089238594804013)	(0.0042484357960896,0.013048246552283)	(-0.018959421884314,0.021236776404304)	(0.018027186260636,0.0051654101818594)	(-0.035454017896863,-0.01802580500209)	(-0.026356904946675,0.0085834601236268)
-4.5820371814525	(-0.026380942663947,0)	(-0.012729523547825,-0.0018053288866641)	(-0.021299337052237,-0.038257869392313)	(0.0034708588539215,0.0014653772715222)	(-1.3578633915396e-06,-0.04937798296455)	(0.071607355384499,-0.039867646642027)	(0.0033784371696562,-0.023826873616442)	(-0.0027438648486181,0.0064960570530839)	(0.0076524241760447,0.020016904196103)	(-0.0013624416872814,-0.01093173172178)	(-0.009781480868877,-0.0013631318339234)	(0.010022488984026,-0.0090702916316447)	(-0.040432352227593,0.015459421354079)	(0.0027513507020546,-0.019757360519586)	(0.022082408122866,-0.0027527680008076)	(0.018322038908988,0.020242861800096)
-4.5820373765214	(-0.026275553690527,0)	(-0.01479717385907,0.032404437490448)	(0.017042962134272,0.00995037436888)	(-0.019316734446964,-0.0084117573834968)	(0,-0.049182067948444)	(-0.018624218663719,0.031899728487372)	(-0.0606520794417,-0.027695187605136)	(0.015743396894374,-0.036155770272006)	(0.0060308296054287,0.0019030362443406)	(0.0075835223345343,-0.0070124986973824)	(-0.013617607261666,0.0075832731669919)	(-0.0097157434372014,0.019412245462119)	(-0.0038429876226491,0.01218137451986)	(-0.015318266366371,-0.027506789430731)	(0.014167064275281,0.015317739430709)	(-0.039211086336313,-0.019623945509854)
-4.5820375328855	(0.027393883562278,0)	(-0.020334338924925,0.0012868618036449)	(-0.007182483758085,-0.011062672351452)	(-0.036440122868857,0.011197512193672)	(0,0.051274507021009)	(0.0207055290996,-0.013444334113176)	(-0.0024093882085766,-0.038060715455138)	(-0.020959120794786,-0.068204528544114)	(0.0033245557554613,0.012326010874591)	(0.014306252559709,0.0063584186691095)	(0.015150050435956,0.014306255881286)	(-0.0036395647853655,-0.0023145740972508)	(-0.024897246403708,0.0067167438880104)	(-0.028895920442656,0.030603051816521)	(-0.012843646069503,0.028895705524779)	(0.0046751610871321,-0.0073529005568454)
-4.5999381977705	(0.025063639925169,0)	(0.012512159799573,0.013432629988141)	(0.016690515477908,-0.015439363659471)	(-0.039300669541496,-0.005135922682666)	(0,-0.018366887486099)	(-0.011314856670885,-0.01223101111202)	(0.0098437971335737,-0.0091691911368578)	(-0.003763165078965,0.028801523798678)	(-0.0037133165381612,0.0033365745759934)	(0.044794594897571,0.034420927599407)	(0.022713474430423,0.044794661536737)	(0.031858900374794,0.034334020162071)	(0.0016209855998998,0.0018037108790524)	(0.021759963118019,-0.011033318272405)	(0.016719904720757,-0.021759615940247)	(0.016677939408202,-0.015475904244708)
-4.59993826056	(0.01366144708302,0)	(3.5895767876785e-05,0.041977137672538)	(-0.0008887536673158,-0.015672355960977)	(0.027550974922653,0.0099468727557689)	(-1.8971315480442e-06,-0.010010073069119)	(-0.011485056855869,0.00065121723190471)	(0.030761258457936,-2.8642186367508e-05)	(0.0072877838922803,-0.020189285081616)	(0.0488578882855,0.017821872227384)	(-0.031401752775173,0.0042337563685528)	(0.026907950079393,-0.031402443709122)	(0.017904484550155,0.046831982771888)	(0.0086562019031491,-0.023732762968123)	(-0.015254375546433,-0.013069766910053)	(0.002056615135155,0.015252668450084)	(0.022748927294581,-0.0086980197012715)
-4.5999383623799	(0.033622641350509,0)	(-0.015419959297438,-0.026027668475454)	(-0.0084077864019244,-0.022776381688833)	(0.01485011330618,-0.014050965205681)	(0,-0.024638153778358)	(-0.016690907794309,0.0061618373159043)	(-0.019072597745191,0.011300957831591)	(-0.010297913666174,-0.010882287627055)	(-0.020082645018732,0.043535834915601)	(-0.016925824637399,0.054337722808737)	(0.022307140188251,-0.016926114612251)	(0.0083845521826897,-0.039249048215514)	(0.021148118867996,0.0097547307494379)	(-0.0082222664831526,-0.010835053561133)	(0.026394806345835,0.0082214512609581)	(-0.019065193472383,-0.0040724445056915)
-4.5999385344208	(-0.033284179964927,0)	(-0.0061403255499158,0.0010519303767878)	(0.0037107448874384,-0.04106689264228)	(-0.0032859565776489,-0.013978433335529)	(1.3433403007201e-06,0.024390698259488)	(-0.030094867295769,-0.0027171594471483)	(0.00077135048161301,0.004500264192976)	(-0.01024295161262,0.0024084015114872)	(-0.0030300515564173,0.053806367501977)	(0.0037450838528714,-0.022004463012983)	(-0.053869168725017,0.0037456561820738)	(0.03980875408108,0.0054281388514738)	(0.026137044124931,0.0014709281052498)	(0.0018200130804042,0.026166638659898)	(-0.010688757741507,-0.0018187586710628)	(0.0026362221856678,-0.019337183278016)
-4.7016818792198	(-0.0016472175787478,0)	(-0.00032204577944953,0.0013962583287846)	(-0.0025997380767118,-0.0042719716762892)	(-0.00095234908886146,-0.0027811838233842)	(-3.1627781161069e-06,-0.014923143192311)	(0.038695734790591,-0.023553913948316)	(-0.012647955702885,-0.0029173901354892)	(0.025193875761239,-0.0086305657290467)	(0.02384679013672,0.027412302711943)	(0.0056826860569772,0.0067664674580165)	(-0.026426378063873,0.0056872540503103)	(0.023567592528604,-0.0071831477310943)	(0.0036654973290515,-0.0031883583287844)	(0.00076042307991256,0.0035336124509692)	(0.00090480830042375,-0.0007598204467881)	(-0.0009603620788791,-0.0031511846048118)
-4.7016825502657	(-0.0028279647146588,0)	(0.0037117420888552,-0.00060010788897348)	(0.0014293326355039,-0.0019458606973971)	(-0.0011917158240487,0.0030048038541205)	(0,-0.025618287116957)	(0.017629655142376,0.012947548330081)	(0.0054372589323707,0.033624788686339)	(-0.027222189460113,-0.010795388384552)	(-0.012109922472869,-0.010535954290963)	(0.0071111468729041,-0.034807321814599)	(0.0010567785713111,0.007110998428948)	(0.033763410078496,0.004947591591271)	(-0.0014088653321175,0.0016190938689197)	(0.00095069125801366,-0.00014108750269482)	(-0.0046540734989991,-0.00095098667077853)	(0.00066186919717251,-0.0045146004854664)
-4.701682786046	(0.0046780356357639,0)	(0.0027852969083118,-0.0015401717662724)	(0.00041835227764434,-0.0016832336579879)	(-0.0014038039752291,-0.0011913721976713)	(0,0.04237965132042)	(0.015250231525731,0.0037892267079327)	(0.013954244484541,0.02523132276575)	(0.010792842405226,-0.012717822102459)	(-0.011688086147279,-0.0065737541684579)	(0.0083775758035,0.035025258412377)	(0.020808041679721,0.008377765990209)	(0.026666448251822,-0.0066960142391713)	(-0.00087904188378068,0.001562768510744)	(0.0011202332606365,-0.0027823960945136)	(0.0046832741441874,-0.0011199786540417)	(-0.00089524114805629,-0.0035656447306498)
-4.7016829219889	(-0.0024121163574352,0)	(0.0012699733091072,-0.0032371966454311)	(0.0009106408563966,0.0019338063357406)	(-0.00067590486630013,-0.0039337387114661)	(-2.9522862062163e-06,-0.021852216572619)	(-0.017519466779196,0.0082509107707313)	(0.029329200473173,0.011502583002752)	(0.035636278897609,-0.0061252122634983)	(-0.024755018639681,-0.019117995401359)	(0.0040315734407954,0.0090814640633539)	(-0.037869033818053,0.0040366104112438)	(-0.0039633167257982,-0.013884957611634)	(-0.0025566001914274,0.0033099238427515)	(0.00053950136981632,0.0050635432879743)	(0.0012145015872284,-0.00053898922264609)	(-0.0018564634628055,0.00052985379089359)
-4.7518406604569	(0.0071711395877987,0)	(-0.0028743506215778,-0.0080590953770997)	(-0.0042216423587554,-0.0045247682861613)	(-0.010941496047925,0.00062863507673476)	(0,0.013525158017845)	(0.0085337541746607,-0.007961205267091)	(0.015199700368936,-0.0054205045027395)	(-0.0011856326134694,-0.0206365743878)	(0.006454006339167,-0.012443545712704)	(-0.018401509671511,-0.011002811337116)	(-0.013117964651986,-0.018400772588197)	(-0.0027754903279236,0.020653598515064)	(0.00085080446195958,0.00044127092968515)	(0.0012583062718385,-0.00089681962345598)	(0.00075246272113775,-0.0012580417956341)	(-0.0014120927490333,-0.00018981488354219)
-4.7518410129157	(-0.0095202049871516,0)	(0.0012273128441408,0.0041828327009302)	(-0.0031371953598727,0.0057629852607155)	(-0.010992821929605,-0.0030841414275932)	(0,-0.017954649502022)	(-0.010869583177174,-0.0059167685759014)	(-0.0078892149506651,0.0023142591113192)	(0.0058163504968976,-0.020732623127225)	(-0.012310187172059,0.011756994284671)	(-0.018488015561956,0.010824117928634)	(0.021197137266828,-0.018488346251055)	(0.0076284322218396,-0.0017586385474332)	(-0.00080359127164617,-0.00084189817406628)	(0.0012639796668122,0.001449374078521)	(-0.00074007613424766,-0.0012637857710427)	(0.00012016556510722,0.00052149739201413)
-4.7518413677655	(0.00790708070099,0)	(0.0050112681414333,0.012838955155926)	(-0.0023501625427804,-0.0038510010529716)	(-0.0030335863253712,0.0010066952510784)	(0,0.014912725546478)	(0.0072634134822663,-0.0044327107754477)	(-0.024214673860127,0.009451244638852)	(-0.0018987715299778,-0.0057219228453102)	(-0.025544871509976,0.0019509895303247)	(-0.0051017679220397,-0.011605434708391)	(-0.01499071314533,-0.0051012215958652)	(-0.014904871775641,-0.017640168675266)	(-0.00013346983434637,-0.001746483091531)	(0.00034892615467295,-0.0010250621546661)	(0.00079322272782555,-0.00034902994808384)	(0.0012060426990953,-0.0010190750942628)
-4.7518416771916	(-0.0088581564577082,0)	(0.00082724047727549,0.00044086376588734)	(-0.0021436015580298,-0.013294673476024)	(0.00024859689413367,0.0047220664286113)	(0,-0.016706054173832)	(0.025073702382141,-0.0040429975769845)	(-0.00083120584718654,0.001561037867723)	(-0.008906265541563,0.00046877573374133)	(-0.0043467525163554,-0.020967506343221)	(0.00041795299535968,0.022838962082109)	(0.0069566587103329,0.00041758334674883)	(-0.023749350264875,0.0028643716536827)	(0.0014336410212592,-0.00029707237937438)	(-2.85735970996e-05,0.00047532304836515)	(-0.0015616143805507,2.8730256441256e-05)	(-0.00019568666450048,-0.0016239125866898)
-4.9331221556033	(-0.023054257148091,0)	(-0.0046943425340877,-0.0088723595863802)	(0.0059043805936573,-0.0010010091992971)	(-0.011429552750941,0.0011809750731198)	(0,0.025682361859408)	(-0.0011152413780903,-0.0065779270883107)	(-0.0098834234894608,0.005229086522947)	(0.0013158592305936,0.012732575438185)	(-0.012668067039238,0.0048821941643843)	(0.0097988305178545,-0.020776269819435)	(-0.018751975004392,0.0097980649984445)	(-0.0031660370155853,-0.0025441042697202)	(0.0032261253689485,0.0083714053823226)	(0.0064746948662957,0.012391637293057)	(-0.013729694558041,-0.0064753845129539)	(-0.001681068081157,0.002091984762053)
-4.933122670875	(0.01308824417671,0)	(-0.008142072378495,-0.021129319986948)	(-0.0044235278411334,-0.0049652562507429)	(-0.0084754644358481,0.00028102377183635)	(0,-0.014579874799391)	(-0.0055309652627955,0.0049269555265699)	(-0.02353746384298,0.0090695239333029)	(0.00031296762817676,0.0094413978635693)	(-0.01432188285826,0.011236341814904)	(0.0072658207575027,0.01097940608668)	(0.011461168623298,0.0072659723298908)	(-0.0027230668670877,-0.02190598632176)	(0.0074246490503021,0.0094643972661845)	(0.004801571522458,-0.0075733838991381)	(0.0072552027086184,-0.0048011469153359)	(-0.014475330388499,0.001799233421924)
-4.9331231041556	(-0.0095164814963561,0)	(0.0022764423436308,-0.0048380892028587)	(-0.023650068354026,-0.0043439950240371)	(0.010014436622928,-0.0015967257466566)	(0,0.010600938717811)	(-0.0048389610199221,0.026345307343406)	(-0.0053898908581289,-0.0025355639109264)	(-0.0017786881353717,-0.011154474176923)	(0.016127021345612,0.0017725356298725)	(-0.008584974953506,-0.0067894453667435)	(-0.0095272215810245,-0.0085847479296709)	(0.0056756113756119,-0.024422301593506)	(0.0011716737143495,-0.010656559308989)	(-0.0056724631036744,0.0062954922547775)	(-0.0044864411149841,0.0056726535078152)	(-0.016138429272209,-0.0037504896030886)
-4.9331233601382	(0.002606274305749,0)	(0.0076746130066395,0.0099595885613266)	(-0.011909940693047,0.00021372886409903)	(-0.021980493027789,0.0032051069257034)	(0,-0.002903207976695)	(0.00023878063377875,0.013267439978394)	(0.011094339424121,-0.0085489073928141)	(0.0035706231308819,0.024484779226694)	(0.018748265245467,-0.0067621925769101)	(0.01884327763021,-0.00051329778119052)	(0.0049819880346473,0.018843347255648)	(0.006395807395585,-0.0016718404202402)	(-0.0044686984906385,-0.01238891129366)	(0.012451544473758,-0.0032918265865472)	(-0.00033930740699993,-0.012451215888283)	(-0.0011051510366735,-0.0042261995320741)
-4.9788104779798	(0.018197997971476,0)	(0.0072906752567344,0.0070022414377451)	(-0.0045639782830115,0.017524218176686)	(0.0020082092465138,-0.0088164517375111)	(0,0.013482197091253)	(-0.012983574445848,-0.0033815798243718)	(-0.0051878474913932,0.0054010098789734)	(0.0065321622653005,0.0014877013873145)	(0.0081489427011653,-0.017483520840712)	(-0.0014145400653319,0.019033081701803)	(0.0066096649696015,-0.0014151570975789)	(-0.0072099181429931,0.0017178428033716)	(0.020851876340894,0.0097194938856513)	(0.0016873829874085,0.0078830164453007)	(-0.022700412625024,-0.0016875818823132)	(-0.002048939494034,-0.0085996441474759)
-4.978810651604	(0.011937351435395,0)	(-0.01076962052802,0.015185315185537)	(0.015019646832539,-0.010811304852494)	(0.0033105088092245,-0.00071628379423715)	(0,0.0088442512260411)	(0.0080103205094127,0.011127929317706)	(-0.011250846600493,-0.0079789747743013)	(0.00053081857334715,0.0024521314554305)	(0.00011662835732013,0.015204589931585)	(-0.0023320401695993,0.0089150674582301)	(0.007905853149237,-0.0023323741203557)	(2.941601296738e-05,0.021281028456144)	(-0.018135072962023,0.00013924742396418)	(0.0027816354780024,0.0094289884248731)	(-0.010633231259486,-0.0027815279822732)	(-0.025381925945116,3.5456286869308e-05)
-4.9788109980652	(-0.012913745406322,0)	(-0.0078032358016183,0.014193588903482)	(-0.0018688233725807,0.0067892193080699)	(-0.015644111747953,-0.01093526519995)	(0,-0.0095675269410066)	(-0.0050300240807091,-0.0013847083424575)	(-0.010516324479365,-0.0057817484301567)	(0.0081018394867434,-0.011590773993961)	(0.011316905143091,0.00071444925130829)	(0.01102200519273,-0.0013941158639941)	(-0.016802908330455,0.011022171896149)	(-0.010280910946159,0.008683403212786)	(-0.00085229453534686,0.013497843298299)	(-0.013146386786316,-0.020040497610733)	(0.0016623763194176,0.01314607782366)	(-0.010356894806274,-0.012262669460758)
-4.9788113443607	(-0.014233931364867,0)	(0.0073683783368783,0.0088100899181832)	(0.0084570004987604,0.0071775504570861)	(0.019535818340463,-0.0019512480670054)	(0,-0.010546081098696)	(-0.0053179621372181,0.0062653396734837)	(-0.0065274069047673,0.0054589846448672)	(0.0014456802445774,0.014474687126335)	(0.00024864409340225,-0.010248372344026)	(-0.013763968310274,-0.0086538982044593)	(-0.011403305628322,-0.013763959289237)	(0.00013452240474111,0.012165609965653)	(0.012223088500478,0.00029721612515904)	(0.016416959255877,-0.013600956171428)	(0.01032159196715,-0.01641670245096)	(-0.014509622362438,0.00016002753236006)
-5.1098975943418	(0.024636931550501,0)	(-0.0017292662594175,0.0031255043054346)	(0.0050057809165696,-0.0025613909862264)	(0.019936010107739,0.0031152578670623)	(0,0.032096361847416)	(0.0033368242069034,0.0065215400761643)	(-0.0040720829154574,-0.0022527520979119)	(-0.004058118323425,0.025972504560397)	(0.00053269432987407,-0.0012157786008866)	(0.0056483423982164,-0.0060973326265232)	(-0.0078625167154943,0.0056479048655093)	(-0.00023591010518722,-0.0023035921783072)	(0.0046673602215012,0.0020454238894211)	(-0.02168887695603,-0.030190345887192)	(0.023412914226531,0.021686978948499)	(0.0088461101749972,-0.00090518238531602)
-5.1098976056756	(-0.01457846301471,0)	(0.0081999049165837,0.017973749720121)	(0.012814315177618,0.0099641127030326)	(0.013837993713202,0.00085867750439882)	(0,-0.018992272278101)	(-0.012980399159897,0.01669490552552)	(-0.02341477793103,0.010683339341262)	(-0.0011183505746786,0.018026820406109)	(-0.0014623240361527,0.0051460407466804)	(0.0039206298436057,0.0043737028671894)	(0.003887034114976,0.0039210164774753)	(0.00050017785656513,-0.0087227292341984)	(-0.019760097355184,-0.0056111295191305)	(-0.015052369090163,0.014925341766893)	(-0.016793110520582,0.015053398474031)	(0.033493000684463,0.0019180215266339)
-5.1098976644234	(0.011661998626247,0)	(0.01950354160411,0.0027849132640784)	(-0.0094506346801044,0.019438986437105)	(-0.0080331453366183,-0.0016228193778126)	(0,0.015193495436498)	(-0.025324612114045,-0.012311520397651)	(-0.0036276688196647,0.025409266813343)	(0.0021138543807317,-0.010465446103884)	(-0.0034667478129241,0.011032844499423)	(-0.0022757168299196,-0.0037636965386188)	(-0.0028440583045085,-0.0022760401014694)	(-1.8091817622961e-05,0.0018884396738223)	(-0.0423646456337,-0.013309808956264)	(0.0087384633706423,-0.010922080670498)	(0.014452284197453,-0.0087394874712027)	(-0.0072513520633187,-7.0812143293333e-05)
-5.1098977875828	(0.010148742519429,0)	(-0.0064350498386086,0.015030734089668)	(0.017115468663577,-0.0018082068864963)	(-0.019289323809754,-0.0044637412378365)	(1.0610550390631e-06,0.01322149146516)	(0.002356017778988,0.022297925221528)	(-0.019581070133298,-0.0083829475379642)	(0.0058147414532282,-0.025128841598879)	(0.00059035636890119,-0.0023355299633114)	(-0.0054648855086473,-0.0041401472150076)	(-0.0016105448978992,-0.0054655036748131)	(0.0013109981183749,-0.0091076970790119)	(0.0089673422165804,0.0022688657581353)	(0.020982374356794,-0.0061849018573554)	(0.015895838295708,-0.020984484008777)	(0.034970352519529,0.0050326898290591)
-5.119373008427	(-0.013736546106363,0)	(0.0019947227974273,-0.016702001820902)	(0.0062783030716179,0.0059860189459588)	(0.036038067871129,-0.012687460700763)	(0,0.0046544784841678)	(0.0020283566432195,-0.0021269457953379)	(-0.0056589813692726,-0.00067581196053023)	(-0.004299197481895,-0.012210500596532)	(0.017112415325107,0.0059429814359871)	(0.026836405320041,0.00078116836917595)	(0.019676980246371,0.026835940279625)	(0.0029722650007841,0.0077621360719196)	(0.0034153663262997,-0.0098332381350881)	(0.01542054295497,-0.011307749701509)	(0.00044880003822344,-0.015421869799119)	(0.0044607577055312,-0.0017080626763906)
-5.1193731350158	(-0.013228177602803,0)	(0.013543099223248,0.0081342238071617)	(0.0050693248062515,-0.039292304146413)	(0.003522945498197,-0.00028015469825697)	(0,0.0044816466026919)	(-0.01331264097185,-0.0017171841351467)	(0.0027557192383151,-0.0045883644549651)	(-9.4771778195619e-05,-0.0011936905013736)	(-0.0022822529192406,-0.01917442384373)	(0.0026235376585669,0.009641770028596)	(0.010058936866769,0.0026233756957323)	(-0.039344195274701,-0.0098320743493392)	(-0.011018354878295,0.0013115865781595)	(0.0015072069064439,-0.0057801003332238)	(0.005540392485725,-0.0015078863891426)	(-0.0056493807286954,0.022608167451116)
-5.1193731957766	(-0.026292671836682,0)	(-0.00035009326672409,0.030669488886833)	(-0.011847301740371,0.013750585154541)	(0.0017031454979904,-0.0064983914720961)	(0,0.0089083778719466)	(0.004659325082721,0.0040132784212178)	(0.010391474461515,0.00011780939923582)	(-0.0022020889819001,-0.00057698802781799)	(-0.031660396336813,0.0099790106258492)	(0.001268421695577,0.014739815736697)	(0.024418238588177,0.0012680837093839)	(0.010500083739198,-0.014016349874217)	(0.005735195056152,0.018192671609695)	(0.00072811884590754,-0.01403185313744)	(0.0084697276398814,-0.00072924039224148)	(-0.0080550517607634,-0.0060335652922812)
-5.1193734654165	(-0.030848885260162,0)	(-0.006397278190093,-0.022190736681743)	(0.0051282527843965,0.0024628994755665)	(-0.019010082426574,0.011308390823397)	(0,0.010451567747587)	(0.00083460497918374,-0.001736967234801)	(-0.0075185673141338,0.0021680521367784)	(0.0038315563346212,0.0064407917240128)	(0.020343164778377,-0.0029297624185974)	(-0.014155830901311,0.03139262023614)	(0.014550904800967,-0.01415614776584)	(0.0065979486444548,0.012705944306461)	(-0.0016837516616043,-0.011689485003752)	(-0.0081348583153731,-0.008361063936708)	(0.018038813288052,0.008134032865272)	(0.0073015802886073,-0.0037918230182755)
-5.5188585902961	(0.0022714948301691,0)	(0.00041703466706109,0.0011366287129033)	(-0.00045307406147587,0.00023564582693699)	(0.0011458852235035,-0.0004712755568577)	(2.3317997309067e-06,-0.013895397711238)	(0.0014413009871882,0.0027730123535178)	(0.0069528117994416,-0.0025492188323737)	(-0.0028820040088978,-0.0070098948602721)	(-6.6228798856131e-05,2.7006528609873e-05)	(4.7817519746711e-05,-0.00011408423678591)	(-7.4930236652755e-05,4.7525552961855e-05)	(-7.4093548269388e-06,-2.8304168207237e-05)	(-0.0026319118411727,-0.0064149788047831)	(-0.0046219569034785,-0.0072642324704209)	(0.011065926234699,0.0046251884022884)	(0.0027569216230501,-0.00073073083112612)
-5.5188596821848	(0.001354400831922,0)	(-0.00080485530924527,-0.0017774046449495)	(0.00084824923852822,0.001253450177959)	(-0.00028915923343538,0.00063758961638635)	(0,-0.0082846288030705)	(0.0076674775479432,-0.0051896594970691)	(-0.010872288127949,0.0049218986589685)	(0.0039006492195638,0.001768336609713)	(0.00010931806922878,1.8807479631e-05)	(-1.193290443541e-05,-2.9789130743012e-05)	(-8.2848151152774e-05,-1.206745397358e-05)	(8.5574132440008e-05,3.8512507165089e-05)	(-0.001811032836183,0.010594077919625)	(0.0011668173001078,-0.0080370862265239)	(0.0028914825898022,-0.0011659186195439)	(-0.0037481893531432,0.0083035867370065)
-5.5188598232534	(0.00072159998322449,0)	(0.00036977355596884,-0.001463123425502)	(-0.00020086686575883,-0.0023469461658678)	(0.00022315343858696,-0.00016182982077019)	(0,-0.004412859396279)	(-0.014355645520713,0.0012277751731659)	(-0.0089496871978404,-0.0022637145602825)	(-0.0009907956132248,-0.0013647170671311)	(5.260392089736e-05,-8.2047729894501e-05)	(9.2476786904303e-06,-3.6727423388189e-05)	(-2.3120302369218e-05,9.2621863174175e-06)	(-0.00011312306326802,6.9096738396903e-05)	(0.0079754532465574,0.0050932401202013)	(-0.00090022693334417,-0.0022570852621004)	(0.0035640948931417,0.00090007166340357)	(-0.0067127120197304,-0.010961770969092)
-5.5188605977712	(0.00095252412980418,0)	(-0.00013036751162357,0.00092483504181239)	(2.6481675219579e-05,-0.00056690377829173)	(-0.002491250809809,0.00034007284792141)	(0,-0.0058259881413622)	(-0.0034675235455475,-0.00016244508610163)	(0.0056569918275431,0.00079753751802757)	(0.0020796803294289,0.015237228149806)	(-3.7359504576143e-05,-2.8932525752462e-05)	(-0.00010349220716662,-2.5463755466429e-05)	(-5.3672884420791e-05,-0.00010356618896278)	(-1.8174826694787e-05,-3.9589993762624e-05)	(0.0028131338591233,-0.003623998189531)	(0.010050132972143,-0.0052142990486264)	(0.0024710084887907,-0.010050042188984)	(0.0038383647788349,-0.0017610771732727)
-5.5627056245632	(-0.0062344175173524,0)	(-0.001053134748621,-0.0088523521866206)	(-0.0061069082107017,0.0032356336358439)	(0.010761363909589,0.0043016911201878)	(0,-0.00093198686510352)	(-0.00048363767738569,-0.0009128390481781)	(0.0013233083339219,-0.00015729888348753)	(-0.00064302093101874,0.0016086142088905)	(-0.0019715075016023,-0.0015672347579351)	(-0.0077276455970058,-0.0075659111552997)	(-0.0013878975611071,-0.0077276639452862)	(-0.0030797007838621,-0.010742165302842)	(0.001069149282704,-0.0013449486425248)	(0.0052714816843212,-0.00094676279242712)	(0.0051611421948916,-0.0052713165984197)	(0.0073277972006669,-0.0021007493029315)
-5.5627060651051	(-0.0024146973894481,0)	(0.0085411053180433,-5.1129484292571e-05)	(-0.009374349488681,0.0069497434297814)	(-0.0048748806030883,-0.0078543104792318)	(0,-0.00036090698952131)	(-0.0010388491301602,-0.001401217431067)	(7.5250382233768e-06,0.0012765648264929)	(0.0011740649534094,-0.00072861912323548)	(0.0066950433633855,-0.011123853444159)	(0.00350058521264,0.0039061682394673)	(-0.007374114131149,0.0035005582475056)	(0.0011427001781195,-0.0067683565849704)	(0.0075881377141313,0.0045670811509516)	(-0.0023879866635655,-0.0050301764791305)	(-0.002664582856733,0.0023879161924486)	(0.0046169612833368,0.00077928527901356)
-5.5627065035002	(0.0047666058024427,0)	(0.0056083278362764,-0.010759939601741)	(0.0040701200354398,-0.007125871351492)	(0.0019863323061223,-0.0076924593078502)	(0,0.0007125369069923)	(0.0010650046294363,0.00060843831480689)	(0.0016082908139405,0.00083852032037382)	(0.0011499540180184,0.00029693024042063)	(-0.01064942280225,0.0010895621353324)	(-0.0014264115666687,0.0089468596072275)	(-0.0021010911369653,-0.0014263794558422)	(0.0091444122435335,-0.0048038770897063)	(-0.00074303193239516,-0.0072644775765862)	(0.00097292721534583,-0.0014333778442694)	(-0.0061032084861764,-0.00097309088482501)	(0.003276913688462,0.0062379349980653)
-5.5627069367875	(0.015264133278003,0)	(-0.00083031826428266,-0.00026359682964676)	(-0.0052481754932639,0.0046461726133296)	(0.0030038407367829,0.0029165859118444)	(0,0.002281512498862)	(-0.00069430965460229,-0.00078454759155629)	(3.9529862590465e-05,-0.00012423302727686)	(-0.00043612228180469,0.0004489166422241)	(0.0035794205411692,-0.0027400707164493)	(-0.0021570815562202,0.0088667415708773)	(0.013055605028123,-0.0021569943647091)	(-0.0039326369487667,-0.0039580619003988)	(0.0018689520468851,0.0024416460164078)	(0.001471261521879,0.008905950956218)	(-0.0060483373278974,-0.0014715829856462)	(0.0027000876895516,-0.0026826139298326)
-5.6809122053052	(-0.0040190965494234,0)	(0.0022930224602751,0.0016827664267004)	(0.00078780135856897,0.0021942919524179)	(0.0071883228831393,-0.0025554568140728)	(0,-0.0030166934141127)	(-0.0016470322503417,0.00059124811222143)	(-0.0012630659999317,0.0017210708469999)	(0.0019181150465615,0.005395494029589)	(-0.00069322061876301,0.0034751922329364)	(0.0055671184875411,0.0011335476073873)	(0.0050917368099943,0.0055671341649198)	(-7.6374335801868e-05,-0.0019132827943851)	(-0.0038520717038551,-0.00076835632383164)	(-0.0061707804675645,0.005643915225735)	(-0.0012564457673481,0.0061708186958607)	(0.0021208015238813,-8.4707564839862e-05)
-5.680912300477	(-0.0024546442106997,0)	(-0.0043522459435583,0.0062449893642849)	(-0.00080178796739915,0.0027753200700503)	(-0.0030814184183008,-0.0024643503892501)	(0,-0.0018423847632814)	(-0.0020831147953165,-0.00060179871283762)	(-0.0046874019880718,-0.0032667906059959)	(0.001849706196477,-0.0023128816754046)	(-0.0054574532804885,-0.0012213687354469)	(-0.0023864362806723,-7.5684322083663e-06)	(0.0038095278855511,-0.0023864565598999)	(0.0055200794836901,-0.0042155211217421)	(0.0013537349359891,-0.0060493072124794)	(0.002645273420297,0.0042226553272728)	(8.3602085176954e-06,-0.0026452304516729)	(0.0046727236248315,0.0061186338375373)
-5.680912372652	(0.0024868882306325,0)	(-0.0025722701712931,0.0034245667435889)	(0.0048231607319672,-0.005804304695256)	(0.0024855476365927,-0.0004697510783501)	(0,0.0018666150427687)	(0.0043566781122458,0.0036201727727597)	(-0.002570428262065,-0.0019307099765228)	(0.00035263192643758,0.0018656388332496)	(0.0010831696095789,-0.0064873680141665)	(0.0019249488483196,-0.0022898320419665)	(-0.0015621484901875,0.001924950860079)	(-0.002503124145333,-0.0063875571817033)	(0.0071908934559445,0.0012006228513235)	(-0.0021337297851543,-0.0017315855675085)	(0.0025381458623394,0.0021336890600774)	(0.0070802759785958,-0.0027745849377257)
-5.6809124727954	(-0.0077148230646157,0)	(-0.00063897713002047,-0.0017596829432945)	(0.0013995080724182,-0.0038972354052784)	(-0.0019632160790921,0.0019639215865112)	(0,-0.0057905878636555)	(0.0029251636639102,0.0010504536963568)	(0.0013207968402577,-0.00047954901172462)	(-0.0014740795997698,-0.0014735649395512)	(0.0024466966669782,-0.0035130131360391)	(-0.0015204873619641,0.0074957511371185)	(0.0044537749077537,-0.0015203704285549)	(-0.0025233995418844,0.00027894724414767)	(0.0038940765338083,0.0027120294675875)	(0.0016853599246161,0.0049367920622168)	(-0.0083087159839863,-0.0016852894514741)	(-0.00030924473115141,-0.0027970169990587)
-5.7891990759062	(0.00087980752280287,0)	(-0.00053107981861479,0.0011510498998382)	(0.00035230262758282,-0.00069010771540543)	(-0.0020649398853092,0.00072930595820239)	(0,-0.0010862216463601)	(-0.00085201867666277,-0.00043493292486544)	(0.001421107474685,0.00065564907850344)	(0.00090044158289492,0.0025494375854864)	(-0.0020758343015213,-0.0031736916419784)	(-0.0053666031732635,-0.0003910992956342)	(-0.0041818271899764,-0.005366536342879)	(-0.00041329067568557,-0.0039069464877647)	(-0.0034585034913515,0.0022621021538794)	(-0.0058480611690673,0.0045571267062823)	(-0.00042619258897552,0.0058481844525741)	(-0.0042575628485832,0.00045038806799698)
-5.7891992464034	(0.0018582179812111,0)	(-0.00043900144873655,-0.0011587398955463)	(-0.0014447993374759,0.00078277863712805)	(-0.00016097767731916,0.00025027091082598)	(0,-0.0022942122548055)	(0.00096646042692744,0.0017838065779948)	(-0.0014306223440801,0.00054202936640801)	(0.00030898072978075,0.00019876591578055)	(-0.00074350402213539,0.00089345672429758)	(-0.00041842633460217,-0.0041788438683773)	(-0.0054797108097449,-0.00041840133959027)	(0.0031752734713369,0.0067664059875863)	(0.00097362391504131,0.00081021989783311)	(-0.00045590569126113,0.0059714447613546)	(-0.0045538150917245,0.00045597739704582)	(0.0073735317817841,-0.0034602162362097)
-5.7891994099178	(0.0012570125869773,0)	(0.0010969550185322,-0.0008993695264494)	(0.0020244327962797,0)	(0.00017997087804296,0.00023267654338194)	(0,-0.0015519486916299)	(-1.1006847876245e-06,-0.0024994342421251)	(-0.0011104069241176,-0.0013543325311022)	(0.00028727629461374,-0.00022219637185617)	(0.0075986840727275,0.0028486161015088)	(0.00046772789124251,-0.0026620716006655)	(-0.0038716293171257,0.00046773769179287)	(-0.0028531409626552,-0.0029239107040541)	(0.0031041545050365,-0.0082805202392722)	(0.00050976008614055,0.0042190167117347)	(-0.0029009358765953,-0.00050968907954621)	(-0.0031862436889308,0.0031092162905642)
-5.7891996780092	(0.0014035909374382,0)	(-6.8299050611839e-05,0.0016180234874173)	(-0.00012107682282076,-0.00060295902818875)	(0.0013462834676189,-0.00099687631378601)	(0,-0.0017329452478825)	(-0.00074443929692629,0.00014946018303667)	(0.0019976704939187,8.431382992467e-05)	(-0.0012307700990845,-0.0016621669609211)	(-0.0045196450993253,-0.0017446070345902)	(0.0034988468246766,-0.0062385251346044)	(-0.0010571525297382,0.0034988645042261)	(-0.0013894603422019,-0.0038904717970353)	(-0.0019011213413167,0.0049251880482726)	(0.0038128021810905,0.0011519435486205)	(-0.0067982743733207,-0.0038127725545828)	(-0.0042395326418824,0.0015141549762798)
-6.9455294493353	(0.0013250480946653,0)	(0.00023638036724911,0.00083199831855025)	(-0.00019830814826863,-3.6199315394183e-05)	(0.0007704024925505,-0.00036939905349588)	(0,0.0033510446739858)	(9.1539869103449e-05,-0.00050133013947221)	(-0.0021042010465171,0.00059820377468455)	(0.00093437420910736,0.0019484064461497)	(-0.0010679062591201,0.00020782646555336)	(0.00079842702281847,-0.0017565466025744)	(-0.0009904969724606,0.00079887911008519)	(-0.00028288832806815,-0.00065711861811947)	(0.00038205731234407,0.0019643571891634)	(0.0014692580912468,0.0018219800190689)	(-0.0032309121385485,-0.0014687077646168)	(-0.0012085365194561,0.00052011337802614)
-6.9455325917438	(0.0010737421491087,0)	(-0.00026191086017729,-0.0013114629187649)	(0.00015401285735015,0.00044614634493715)	(-0.00014680934520006,0.00029759285492064)	(0,0.0027157401200573)	(-0.0011280879390416,0.00038930030476004)	(0.0033167728102717,-0.00066267621241949)	(-0.00075261274435271,-0.00037124297429955)	(0.0015189983162385,0.00019052704299631)	(-0.00015232330591433,-0.00080474755651461)	(-0.0014217774914694,-0.00015196421108124)	(0.00073400721399822,0.0012001080103969)	(0.00035076892207275,-0.0027940833095056)	(-0.00027968051802445,0.0026149813217032)	(-0.0014801015400238,0.00028008333939548)	(0.0022072273780202,-0.001350100703286)
-6.9455329252124	(0.00016759247106133,0)	(0.00042688605138692,-0.00035700354480089)	(0.00082718727520072,-0.0014916801849893)	(0.00014624138622587,7.7549664269014e-05)	(0,0.00042390080578512)	(0.0037727150413488,0.0020916934258294)	(0.0009030131952783,0.0010793826006952)	(-0.00019624503498627,0.0003697585325938)	(0.0012274343101487,-0.0011041919725374)	(0.0001516649827321,-9.3282719164767e-05)	(-0.00025426648382582,0.00015139258133158)	(-0.0019888306953399,-0.00048702413594632)	(-0.0020307119929105,-0.0022577828508648)	(0.0002785982391655,0.00046759864623312)	(-0.00017161909231242,-0.00027891935381509)	(-0.00089608500632364,0.0036581549695546)
-6.9455347912724	(-0.00058095018195999,0)	(0.00017815200945924,-0.00062944878179081)	(7.0790720234651e-05,0.00031126472527338)	(0.0015276530740714,-0.0002699906188075)	(0,-0.0014694547406988)	(-0.00078722208022322,0.00017899290772207)	(0.0015919798429846,0.00045068561800067)	(0.00068297698476995,0.0038636880255003)	(0.0007259095350528,0.0005075397543432)	(0.0015838844729505,0.00032241922044919)	(0.0008824603781595,0.0015837671778934)	(0.0001378764842183,0.00057925706820306)	(0.00093338088885049,-0.0013351895848357)	(0.002912988258489,-0.0016228905206845)	(0.000592987667178,-0.0029131101935974)	(0.0010653462039747,-0.00025369085913169)
-6.9809518032653	(-0.0015924410761306,0)	(8.1518480836656e-05,-0.0019537449370997)	(-0.0018552541104089,0.00088357917483941)	(0.0029023040779798,0.00023017957629583)	(0,-0.00093397605245879)	(-0.00051818972611684,-0.0010880682531743)	(0.0011458975307188,4.7815520771762e-05)	(-0.00013497969053016,0.0017022605655726)	(-8.2634825803889e-05,-0.00081062773943061)	(-0.0024377636419914,-0.0015308564635784)	(-0.0011441706487476,-0.002437583188044)	(-0.00067369006851734,-0.0031992764904149)	(-0.00019868808618609,2.0184404767304e-05)	(-0.00059730106198104,0.00028039161453432)	(-0.0003751846006169,0.00059748362299698)	(-0.00078408692306612,0.00016512359025283)
-6.980953559234	(-0.00012260509319846,0)	(-0.0015693600499018,-0.0028281565639302)	(0.0019463332028397,0.00042027830893838)	(-0.00096317217253515,0.0019207143126754)	(0,-7.1918825776983e-05)	(-0.00024650540273998,0.0011415279107182)	(0.0016586892199018,-0.00092031560195761)	(-0.0011264080796047,-0.00056499677782399)	(-0.0040102436228016,0.00096525342185448)	(0.00080894065464392,-0.001716310545922)	(0.00151034836857,0.0008089005066956)	(-0.0016712860068865,-0.00074073306960797)	(0.00023666676128002,0.00098285628079039)	(0.00019817027476851,-0.00037022661122386)	(-0.0004207095790752,-0.00019821134353308)	(-0.00018159709267983,0.00040971594244129)
-6.9809544600973	(-0.001729338039957,0)	(-0.00058347174209605,0.0020847583364665)	(-0.00034506151645398,0.0026815417085959)	(-0.0007156349992019,0.0018865941785086)	(0,-0.001014301808098)	(-0.0015726352410648,-0.00020246769414186)	(-0.0012227536097944,-0.00034231851563251)	(-0.0011065200948173,-0.00041968923263614)	(0.0020407799270101,-0.001762449811383)	(0.00060107995166028,-0.0030370475196532)	(0.0001320584808788,0.00060119035763942)	(-0.002742354478202,0.0014612593102034)	(-0.00043213827772482,-0.00050007728166901)	(0.00014743128013328,-3.2340529154467e-05)	(-0.00074426992091672,-0.00014731094932668)	(0.00035816168000718,0.0006720875630627)
-6.9809553347897	(0.0036764996912433,0)	(-0.00029149088073014,4.0033212456218e-05)	(-0.0009009976055546,0.0016579654716864)	(0.00088828654113362,0.0010511803855401)	(0,0.0021562475715475)	(-0.00097232037204629,-0.00052851996622405)	(-2.3412485154677e-05,-0.00017103608009154)	(-0.00061657469421763,0.0005209042677225)	(0.00079041322092133,-0.001147943470659)	(-0.00074607811458221,0.0022051907275313)	(0.0039709300141425,-0.00074623894638533)	(-0.0016374328701287,-0.00072302388938231)	(-0.00028150678663092,-0.00019372439053486)	(-0.00018299781598492,-0.00097321265118923)	(0.00054053688980006,0.00018284407832866)	(-0.00017709602834591,0.0004013329247271)
-7.1630494545997	(-0.00039351961089795,0)	(-0.0011765281042075,-0.00097099252747129)	(0.0016602637681597,-0.00044714564120984)	(0.0025705842192127,-0.0012605673671919)	(0,0.00017756662536739)	(-0.00020178263823456,-0.0007492119337274)	(-0.00043813780204259,0.00053095680276741)	(-0.00056883982588211,-0.0011599906845161)	(-0.00032547932501681,0.00020088581795354)	(-0.00031793342265458,0.00010725958210997)	(-0.00020464865336599,-0.0003179967098115)	(-9.018368181672e-05,8.5270169920777e-05)	(-0.00026310191521045,-0.00042641888053514)	(0.00041657284610253,-0.00026802465476902)	(-0.00014050340113454,-0.00041658801701676)	(-0.00011169993796806,-0.00011820805169996)
-7.1630497510597	(0.0012604012073358,0)	(-0.00047580932884689,0.00067901949494646)	(0.0029164366078624,0.00087592761127802)	(-0.0014391614715508,0.00012323990691821)	(0,-0.00056874151993395)	(0.00039525602685565,-0.0013160463545715)	(0.00030640340235897,0.00021470270085099)	(5.5602188856471e-05,0.000649479177871)	(-0.00027676382359271,-4.9477265327773e-05)	(0.00017800414841868,0.0001406681464285)	(0.00017115218674393,0.00017798621863721)	(-0.00016718735314487,0.00044478984935906)	(6.4862676475373e-05,-0.00036258210384901)	(-0.0002332215133651,0.00022423176419728)	(-0.00018428398780919,0.00023321792839312)	(-0.00058265304965088,-0.00021907707048783)
-7.1630502216893	(-0.001852884787267,0)	(0.001016951182754,0.002719530451771)	(0.00054834079970843,0.00079080393612012)	(0.00090064266229869,-0.00018721656603073)	(0,0.00083610748507187)	(0.00035683992327784,-0.0002474614797987)	(0.0012271486350019,-0.00045895480636786)	(-8.4486442247797e-05,-0.00040640664705904)	(0.00026857262381402,-0.00022363061281074)	(-0.00011139100382068,-0.00020606153664793)	(-0.00025237300075751,-0.00011141956743616)	(2.799255180878e-05,0.00040421513692304)	(0.00029292973230871,0.00035188330755244)	(0.00014596315607208,-0.00033059752525134)	(0.00026992495911296,-0.00014595583433645)	(-0.00052958532754703,3.6617340579036e-05)
-7.1630509045198	(-0.0029084284836927,0)	(-0.00069488579227606,-0.0013068888083699)	(0.00068993662846148,-6.3742779849287e-05)	(-0.0015452964661468,0.00034322272190838)	(0,0.0013123812301404)	(-2.8771242750693e-05,-0.00031127870506574)	(-0.00058972600365004,0.0003136072025254)	(0.00015492140556685,0.00069728293615777)	(-0.00024700386627778,9.387152955386e-05)	(0.00019114663085372,-0.0004022638957054)	(-0.00031728757461883,0.00019116930883692)	(-7.8074160264491e-05,-7.6294350288473e-05)	(-0.0001229114331159,-0.00032361977811604)	(-0.00025040609121157,-0.00041574570203075)	(0.000526946686891,0.00025045702840285)	(9.9979820161093e-05,-0.0001022666040643)
-7.2923671826806	(0.00064816625749048,0)	(-2.7949816570361e-05,0.00053287629336287)	(8.2029978204655e-05,-0.00028980061556782)	(0.00064107173339373,-0.00033614626119032)	(0,-0.00047745335745034)	(-0.00021349495490855,-6.0437669662408e-05)	(0.00039254200117841,2.0573392713988e-05)	(-0.00024763206431377,-0.00047224226940852)	(-0.00033245476396473,-0.00023428752314128)	(0.00047266108119796,-0.00072578669134934)	(-0.00022998672969429,0.00047271754735408)	(-0.00019312697733247,-0.0004533845356288)	(0.00072574655873207,-0.0010297856979373)	(-0.0014643093188668,-0.00071255650343989)	(0.0022482493045906,0.0014641697349516)	(0.0014044780762578,-0.0005981774390461)
-7.2923681042972	(0.00060123827868144,0)	(0.00018921411186183,-0.00082006164227487)	(0.00029956584240445,-0.00038201064711585)	(-8.6781089717958e-05,8.0505884605127e-05)	(0,-0.00044293295986103)	(-0.00028142126708057,-0.00022068997922136)	(-0.00060413847593692,-0.00013940240124507)	(5.9285274424584e-05,6.3938068368841e-05)	(0.00082555379444098,-0.00014217329398173)	(-6.3984987216647e-05,-0.00038398826755611)	(-0.00050266444444491,-6.4000609103681e-05)	(-0.00042121081465536,0.00038379528859686)	(0.0004403607365885,0.0025573938311675)	(0.00019829682568499,-0.0015571465972906)	(0.0011894963459717,-0.00019820898234261)	(-0.0011888753167137,-0.0013047745089616)
-7.2923683315996	(-0.000665337577892,0)	(1.1763262823416e-06,1.4335042320229e-06)	(0.0005367404129602,-0.00071378800999886)	(0.00015796752914451,-0.00023309597692611)	(0,0.00049015566819942)	(-0.0005258208240129,-0.00039540759018478)	(1.0544661926482e-06,0)	(-0.00017172377495019,-0.00011637267101963)	(0.00039466621324844,-0.00052541046063165)	(0.00011648426336883,0.00031871603351986)	(0.00066247684998008,0.00011642641879203)	(-0.00052716740284271,-0.00039677038804981)	(0.0016276167679571,0.0012226511082933)	(-0.00036073781528292,0.0020521462548448)	(-0.00098730668388912,0.00036085489176054)	(0.0012292113475969,-0.0016330588823334)
-7.2923690975334	(-0.00030860247118419,0)	(0.00030737638201735,-0.00048162232103792)	(-0.00040128501911016,0.00018584225265376)	(0.00083666986036123,-4.6578797172987e-05)	(0,0.0002273537710498)	(0.00013691013375118,0.00029562307200124)	(-0.00035481025740762,-0.00022643586682081)	(-3.4317160925713e-05,-0.00061641328243637)	(5.9242140170972e-05,0.00036367440836135)	(0.00061692023385169,0.00019320761815691)	(0.00026192061701476,0.0006169384831346)	(-8.9586386144854e-05,0.00065102686206119)	(-0.0011265670222303,0.00018354041660643)	(-0.0019111939192427,0.00081132754673979)	(-0.00059850821959167,0.0019111056228612)	(-0.0020167102068121,-0.00027755657360138)
-7.7390182009897	(-0.0020268717260902,0)	(-0.00080504083617049,-0.0019307297424717)	(0.00021225093242443,0.00047022970266566)	(-0.0014618634479085,0.00091617085302604)	(0,0.0018863657354883)	(0.00043750325847047,-0.00019770663688458)	(-0.0017966454512954,0.00074879443304451)	(0.00085233629936201,0.0013604608761422)	(-0.0018767856007976,0.00029314560990588)	(0.0012803321127892,-0.0025774041675395)	(-0.00097282395528536,0.0012802127993776)	(-0.0011167335985905,-0.0015049320265548)	(0.00032504931071859,0.002082189935495)	(0.0014201877532918,0.0010795211758297)	(-0.0028593659138557,-0.0014205863160017)	(-0.0016694470998119,0.0012386433594875)
-7.7390194100975	(0.0021762562107883,0)	(-1.552962171476e-05,-0.0013524019050042)	(0.00020472123609451,-0.0016844234156846)	(-0.0010595042783904,0.0010776827465863)	(0,-0.0020248331346103)	(-0.0015671898369667,-0.0001906393706184)	(-0.0012585031683135,1.4239648406308e-05)	(0.0010026025744689,0.00098574985002567)	(-0.0013637032878816,0.0014886512157723)	(0.00092779228057886,0.00096207178731999)	(0.002849553955401,0.00092787043144488)	(0.0014615468312792,-0.0010050709951481)	(0.001651202496994,0.0015129709696914)	(0.0010293813469395,-0.0031609370544971)	(0.001067274479921,-0.0010290656828953)	(-0.0011149425998099,-0.0016213862317695)
-7.7390199835667	(-0.0011708015203084,0)	(0.0021194933538056,0.000707988808569)	(-3.6856926339467e-05,-0.0010892030751436)	(0.00041915827995846,0.002000290063898)	(0,0.0010894751151176)	(-0.0010133981482561,3.420630852177e-05)	(0.00065890621301911,-0.001971992348326)	(0.001860901254795,-0.00038991443529432)	(0.00065231408177562,-0.0009022477502696)	(-0.00036705502547745,-0.0027770108044925)	(0.0007263216223234,-0.0003670442438244)	(0.0028099480103595,0.00058779952204767)	(-0.001000853187617,-0.00072365604447738)	(-0.00040708766033466,-0.00080550624003403)	(-0.0030804801333132,0.00040714634097543)	(0.00065220234198618,-0.0031170241412109)
-7.7390210957177	(0.0012296099963395,0)	(0.00071845774136205,-0.00011508092391561)	(-4.7346419119195e-05,0.0027189329519371)	(-0.00013624826326841,0.0015076275584227)	(0,-0.0011441912828492)	(0.0025299588330749,4.4285746508582e-05)	(-0.00010698195080908,-0.00066836049640664)	(0.0014027859315632,0.00012682281220022)	(-5.923437613115e-05,-0.0030102497363828)	(0.0001192789126956,-0.00024345439963115)	(0.0023971364760181,0.00011937989501208)	(-0.0017519418055269,-0.00014227464940303)	(-0.0033393177925394,6.5508708167424e-05)	(0.00013261377889883,-0.0026592291591368)	(-0.00027002202097119,-0.00013221838057177)	(-0.00015792599800628,0.0019436104672944)
-7.7791678557514	(0.0022100928959743,0)	(-0.00046704394662909,0.0031428525958981)	(4.8997492409677e-05,-0.0015624445766485)	(0.0014970862078452,-0.001988522537277)	(0,0.0018542871388638)	(0.0013109766553675,4.1116275400605e-05)	(-0.002636865153145,-0.00039209944907196)	(0.0016683463282121,0.0012560252995128)	(0.0014854197989476,0.00097431793217083)	(-0.00071874328348043,0.002015839130106)	(0.0001063797208554,-0.00071882618295209)	(0.00052596588640936,0.0015324714325241)	(-0.0010942684594864,0.001667710192465)	(0.00080683444521134,0.00011946217607856)	(-0.0022632087522895,-0.00080709163036743)	(-0.0017205393301326,0.00059032258694657)
-7.7791688210843	(0.0021188089099998,0)	(0.000553079618881,0.00021154370119816)	(0.002754387911081,0.0031734291657419)	(-0.00090588391389837,-0.00054830922554282)	(0,0.0017777364321215)	(-0.0026627183746872,0.0023109251910186)	(-0.00017762576850131,0.00046392749249226)	(0.000460050398889,-0.00076014032297597)	(-0.0012208951496938,-0.001789156950727)	(0.00043496137405569,0.0012805223744213)	(0.00075400747463301,0.00043486848782675)	(-0.0012580147074463,0.0014239686554952)	(0.0020088158588323,-0.0013705597189227)	(-0.00048854808884395,0.00084659800008529)	(-0.0014377382227754,0.00048822065488033)	(-0.0015988686995855,-0.0014127337763496)
-7.7791701443829	(-0.0024422764469837,0)	(-0.0021924123833594,0.0019839354745603)	(0.00068550747923254,0.00032615066471126)	(-0.002598064218349,-0.0012588287561465)	(0,-0.0020490046225764)	(-0.00027363287432488,0.00057521429172488)	(-0.0016646480616222,-0.0018396148601574)	(0.0010563685350745,-0.0021798834082068)	(0.00062339510820688,0.0008959904900694)	(0.0012473385528678,-0.00056826888103296)	(-0.001776943389417,0.0012473770361565)	(-0.0012091661543227,0.0012816055053516)	(-0.0010061420982067,0.00069994173339436)	(-0.0014004819767996,-0.0019951539003774)	(0.00063768210172783,0.0014006101614654)	(-0.0014390957677714,-0.0013577533052593)
-7.7791712398593	(0.0028776220791689,0)	(-0.0019092069928018,-0.0008856720596687)	(-0.001483973331823,-0.00085969587364631)	(-0.0026874715643488,0.00086250164950211)	(0,0.0024143870409085)	(0.00072145965583362,-0.0012450067008477)	(0.00074324091426898,-0.0016018349227624)	(-0.00072366187335173,-0.0022551494911211)	(0.00028730158196497,0.0013293597238567)	(0.0012902351187281,0.00096749630061927)	(0.0017956850480795,0.0012902220103502)	(-0.00050392614636546,-0.0011376882611971)	(-0.001492698182403,0.00032231791410766)	(-0.0014489859619055,0.0020161395015479)	(-0.0010862579868868,0.0014489226175084)	(0.0012774258619967,-0.00056557996473496)
-8.1772238869454	(0.00084553813113119,0)	(-0.00045382645358758,0.00076874912938845)	(-2.5713373991758e-05,-0.00042332063244069)	(-0.0018197451256329,0.00054265074507261)	(0,-8.3443207857504e-05)	(-4.1774317509187e-05,2.5485900157605e-06)	(7.5872063791514e-05,4.4778433988341e-05)	(5.3550814947682e-05,0.00017960771075387)	(-0.00029518643719881,-0.00032591053506032)	(-0.00067615674567714,-0.00011254208767857)	(-0.0005157812271231,-0.00067615073382047)	(1.1331420084959e-05,-0.0002760727882984)	(-0.00018430873579272,0.00016691699063423)	(-0.00038234591807719,0.00029164455675586)	(-6.3643715525715e-05,0.00038234256356614)	(-0.00015611793828908,-6.4145129708508e-06)
-8.1772247200752	(-0.0011033130155073,0)	(0.00042842228093076,0.0012686071627557)	(0.0014526977914754,-0.00039401031168193)	(-5.3560183339075e-05,-0.00013788774431653)	(0,0.00010888901721928)	(-3.8883512662658e-05,-0.00014337055388628)	(0.00012521367244244,-4.2283936197501e-05)	(-1.3598385033009e-05,5.283656755899e-06)	(6.8401384370666e-05,1.2787254036339e-05)	(-1.9898665964594e-05,0.00035870767950375)	(0.00046117265111702,-1.9893747416097e-05)	(-0.00030556985079818,-0.0010111373071901)	(7.2171059432435e-06,-3.867834890284e-05)	(-1.1223263832825e-05,-0.00026078196084051)	(0.00020282550981784,1.1269271456986e-05)	(-0.00057179110583434,0.00017277465325819)
-8.1772250389288	(-0.0011112124882492,0)	(-0.00055742826708604,0.00093365443061761)	(-0.0016212791779953,-0.00033681146406929)	(7.4627032514459e-06,-0.00037196963655263)	(0,0.00010966861853444)	(-3.3268196984612e-05,0.00016001820483297)	(9.2140293710102e-05,5.50143614137e-05)	(-3.6702910717539e-05,0)	(-0.00094931109045505,-0.00033229075376285)	(2.771112033418e-06,0.00027466424740987)	(0.00055109659089615,2.7808639512806e-06)	(8.1959440043956e-05,0.00025549442461532)	(-0.00018792386164983,0.00053681155639795)	(1.5704228901256e-06,-0.00031164988132703)	(0.00015531444955663,-1.5590013996231e-06)	(0.00014449139695369,-4.633905306788e-05)
-8.1772265038394	(-0.001459677932936,0)	(-0.00016235992128004,-0.0012243490932464)	(0.00012131219781198,0.00030901647346904)	(-0.0010193094499125,0.0007017309305073)	(0,0.0001440661643219)	(3.0494444831861e-05,-1.1971057646106e-05)	(-0.00012083342973295,1.6022828848818e-05)	(6.9255257468582e-05,0.00010059255260822)	(0.0004999875666417,5.4508648960594e-05)	(-0.00037873692505229,0.0008030846350509)	(0.00028163554011,-0.00037873093064492)	(0.00017513435063437,0.00040985104218806)	(3.0844183223713e-05,-0.00028274299088042)	(-0.00021413678244757,-0.00015928368637752)	(0.00045412335347739,0.00021420537653811)	(0.00023174647309189,-9.900562357243e-05)
-8.2482170469161	(-0.00079113440412129,0)	(-3.290101457932e-05,-3.7374503824951e-05)	(0.00017429329720239,-0.0004491772572592)	(-0.00019773608601535,-0.00017721353282202)	(0,-0.00078111095935191)	(0.00044346953950461,0.00017209500327947)	(3.6894431298545e-05,-3.246213188666e-05)	(0.00017498070598059,-0.00019523301714085)	(-3.6883757872206e-05,8.397723808071e-05)	(3.4452500896935e-05,-0.00010694166812834)	(-0.00016870211897083,3.4422845763448e-05)	(7.2524769079951e-05,2.3868840904532e-05)	(0.00093315994577115,0.00040979491708945)	(0.0003827186788641,0.001874630927076)	(-0.0011884440933379,-0.00038285472517884)	(0.00026510322390831,-0.00080585338126727)
-8.2482177386063	(-0.00041886879654272,0)	(5.4461176550208e-05,0.0004924549186005)	(-1.8965109711327e-05,0.00062730498606774)	(-0.00014455307092366,0.00030868905717599)	(0,-0.00041357537489245)	(-0.00061936462184108,-1.8734558875876e-05)	(-0.00048623443456494,5.3743460397754e-05)	(-0.00030479458887609,-0.00014271029812711)	(8.9108745302133e-05,-0.00011876388759062)	(2.5185892770362e-05,-0.00012675234997745)	(-1.9211373297243e-05,2.5182975095077e-05)	(-9.9800575296008e-05,8.2479800206229e-05)	(-0.0013197304541022,-0.00099011676751913)	(0.00027978812441447,0.00021329538319619)	(-0.0014084914626767,-0.00027984943039315)	(0.00091661176369936,0.0011090155094527)
-8.2482181336017	(4.8555288635115e-05,0)	(-0.00044655315817903,0.00055168628730631)	(0.00011876605846276,-0.00035366887354922)	(0.00048762043944609,0.00021885227118354)	(0,4.7943469284053e-05)	(0.00034920522745249,0.00011724690555862)	(-0.00054469442813224,-0.00044091199245799)	(-0.00021609383993901,0.00048146300559799)	(7.5411707313268e-05,0.00013940473981725)	(-8.4957201442822e-05,-2.967672876351e-05)	(4.6607251900666e-05,-8.4938396796582e-05)	(-1.6201026040245e-05,0.00011680135177864)	(0.0015491935371306,-0.00083806119669681)	(-0.00094395620432738,-0.00051771909167688)	(-0.00032971295112037,0.00094398789036257)	(0.0012978610416151,0.00017983511071561)
-8.2482191121558	(-0.0003567756344941,0)	(-5.1758840759082e-05,-0.00042020875163635)	(-0.00034806456916762,0.00021134999410007)	(0.00067451556055289,6.0339924027069e-05)	(0,-0.0003522712564037)	(-0.00020867270494089,-0.00034365486634978)	(0.00041490842871411,-5.109976381528e-05)	(-5.9586403490372e-05,0.00066598698265315)	(-1.2569967867581e-05,-2.7803227177459e-05)	(-0.00011750585039775,-7.2670250560007e-05)	(-5.1638576390563e-05,-0.00011751675393103)	(-4.5824344049407e-05,-0.00013383736177531)	(-0.00030895203680098,0.00013968369834193)	(-0.0013058248474643,0.00057385889580018)	(-0.00080751979963834,0.0013057561329565)	(-0.0014873097473519,0.0005093136659254)
-8.6344220888011	(-0.00080345683582734,0)	(-0.00073808668601637,-0.00040471751787967)	(-0.00044461689922016,0.00043039075433197)	(0.0013121339975125,0.00068234655559322)	(0,0.00061262702807885)	(0.00032810956845264,0.00033899494394799)	(-0.0003086027549397,0.00056275988776716)	(0.00052028205401637,-0.0010003418247686)	(3.3043867405095e-05,0.00025484948381436)	(-0.0010867482618963,-0.0012306039412911)	(-0.00010031140116984,-0.0010867337011949)	(-0.00096776925518796,-0.00070345418095371)	(0.00016725486449919,-2.1669260767105e-05)	(-0.00071303188258963,6.5825262769609e-05)	(-0.00080754802772985,0.00071308736165075)	(-0.00046161291828208,0.000635026746417)
-8.6344223300297	(-0.00072015028875892,0)	(0.00045614080244874,-0.0012206065937264)	(-0.00027447200539062,0.00080154014258265)	(-0.00045726267457333,-0.00088358637358617)	(0,0.00054909134807812)	(0.0006111530843906,0.00020924866639604)	(-0.00093062281789243,-0.00034787256697586)	(-0.00067371372577025,0.00034867959461375)	(-0.00078361960739265,-0.0010416746083898)	(0.00037873935935389,0.00013536810921335)	(-0.0013282757060519,0.0003787119745553)	(-0.00028606073751148,-0.0012382701461037)	(-0.00068359619073386,0.00051419790852639)	(0.00024846960714441,0.00087163073542877)	(8.8836299840653e-05,-0.00024860392082628)	(-0.00081251943931367,0.000187662476534)
-8.6344226895373	(0.0010589376381108,0)	(-0.00050406210321479,-0.001103914113936)	(-0.00022429205525293,-0.00084030956945619)	(0.00051356360164915,-0.000556747986896)	(0,-0.00080742543799628)	(-0.00064069875510655,0.00017100127406771)	(-0.00084172188795132,0.00038426023886519)	(-0.0004244583044545,-0.0003915657538572)	(-0.00072854072792499,0.0011134455841405)	(-0.00042535856524756,0.0013381666443073)	(0.00041594201890262,-0.00042534675393475)	(0.00027850092901305,-0.0011000734170262)	(0.00073060394417081,0.00047809240573773)	(-0.00027909200135654,-0.00027298462520738)	(0.00087809602599835,0.0002791382827434)	(-0.00072187472873816,-0.00018278575692204)
-8.6344233874178	(-0.0012800651967179,0)	(-0.00021031741465518,2.7529134445654e-05)	(0.00024790384170184,-0.0014162017190768)	(-0.00014139540426452,-0.00039177657245476)	(0,0.00097605246196484)	(-0.0010797762400986,-0.0001890835272009)	(2.0963165154943e-05,0.00016032280013427)	(-0.00029875525270825,0.00010782299436155)	(-0.00018253825132929,0.0013471339081036)	(0.00011712138293762,-0.00073571442340433)	(-0.0013846963195675,0.00011710161742621)	(0.00099875610982876,0.00022812925572473)	(0.00088395692150527,0.00011983694929012)	(7.6802234419779e-05,0.00090868369116959)	(-0.0004827775040547,-7.690055606867e-05)	(0.00014972597804561,-0.00065538785446022)
-8.6747332766603	(0.00087514930589378,0)	(-0.00010928968016358,0.0010298051243373)	(-1.0768355297062e-05,-0.00046486268572093)	(0.00064370776908989,-0.00064020456674531)	(0,0.001186741329165)	(0.00063040755287267,-1.4604533012611e-05)	(-0.0013964597814553,-0.00014831366806446)	(0.00086813248773559,0.00087290159531921)	(0.00064681060911447,0.00035687213843187)	(-0.00040010758351128,0.00094193197302052)	(0.00014604306202248,-0.00040013334536273)	(0.00022103119054166,0.00063342708082868)	(-0.00049556951347894,0.00089796508907261)	(0.00055543929511054,0.00020275147721041)	(-0.0013076679543478,-0.00055554855452974)	(-0.00087937598576587,0.00030679009951997)
-8.6747341198395	(0.00080291828802615,0)	(0.00027205048890212,-4.5951684937547e-05)	(0.00084843789937568,0.0011914364051857)	(-0.00013158182049586,-3.4540746651117e-05)	(0,0.0010888209996793)	(-0.0016157218917345,0.0011505162314756)	(6.2281904612892e-05,0.00036888510273763)	(4.6798991441367e-05,-0.00017844919390005)	(-0.00055594238628665,-0.0009096909388926)	(8.1799562657593e-05,0.00052056091258804)	(0.00047760202063852,8.1783727322177e-05)	(-0.00057147624345353,0.00049881369187108)	(0.0012629545078462,-0.00077178899517892)	(-0.00011360493592575,0.00066312202437486)	(-0.0007226767791796,0.0001135080413192)	(-0.00069252700180508,-0.00079345572228141)
-8.6747350402635	(0.00080815009395151,0)	(0.00057135200920661,-0.00098964486623156)	(-0.00044315785620383,-0.00030919007786087)	(0.00070685850772827,0.00035785993594789)	(0,0.0010958467575196)	(0.00041929341681752,-0.00060096896418549)	(0.0013420575874601,0.00077486086809872)	(-0.00048534694834193,0.00095855693720859)	(-0.00033969495027582,-0.00016295310307062)	(-0.00043937156869432,0.00027991323227585)	(0.00072478002989043,-0.00043937859074402)	(0.00054732482705302,-0.00089060823999299)	(0.00022627580174099,-0.00047160932441269)	(0.00060998172053114,0.001006230243477)	(-0.00038850113993479,-0.00061002044594333)	(0.0012364916798486,0.00075993545777012)
-8.674735805734	(0.00090282830901523,0)	(-0.00064742145571013,-7.1477149643295e-05)	(-0.00034746066695806,-0.00033218672497716)	(-0.001139573726836,0.00033094223573521)	(0,0.001224290277601)	(0.00045052146056693,-0.00047114691745807)	(9.695913826363e-05,-0.00087794156447398)	(-0.00044877669089523,-0.0015454419260156)	(0.00017155338447712,0.00060890668741918)	(0.00070833749354602,0.00035548119267871)	(0.00076689768545569,0.0007083420818904)	(-0.00019594993187346,-0.00026040900341744)	(-0.00084540073770264,0.00023811535262294)	(-0.00098348183320727,0.0010646966527842)	(-0.0004935182073096,0.00098348389627741)	(0.00036152990556182,-0.00027199497878715)
-9.0693331738039	(-0.00027471207155075,0)	(0.00015588460512911,-0.00011887325532643)	(5.3662564832223e-05,0.00011987199532034)	(0.00050054830532594,-0.00016064238340456)	(0,-0.00014900758407039)	(-6.5020516465541e-05,2.9105672874395e-05)	(6.4476963424377e-05,8.455556378018e-05)	(8.7136721879944e-05,0.000271498575454)	(0.00015235010827179,0.0002435036468408)	(0.00044201217606614,0.00010073157105525)	(0.00038442364934499,0.00044202012746758)	(-3.1792643046651e-05,5.7584067793351e-05)	(5.0993163701828e-05,-3.1899060869144e-05)	(9.2566732977735e-05,-8.0489283434157e-05)	(2.1095486722083e-05,-9.2558187275602e-05)	(1.2061432242671e-05,6.6549310702755e-06)
-9.0693343524551	(0.00028275827233625,0)	(3.2193322874713e-05,-0.00047359823611827)	(-0.00025622641991141,-0.0001431810388214)	(0.00011292036296549,5.7591167932734e-05)	(0,0.0001533696668391)	(7.7662940535659e-05,-0.00013898313718455)	(0.00025688157540057,1.7459174656315e-05)	(-3.1239166607913e-05,6.124915468003e-05)	(0.00019195988363061,-9.7993478204555e-05)	(9.9717076421458e-05,-0.00019882150159857)	(-0.00030053589547706,9.9705327809679e-05)	(-0.00015487953349518,0.00064446153878512)	(-2.0508353980524e-05,-4.0199319840443e-05)	(2.0870241359259e-05,6.2927492292215e-05)	(-4.1622276889965e-05,-2.0884465949762e-05)	(0.00013494653728172,3.2445380607551e-05)
-9.0693352360529	(0.00027249605044462,0)	(5.8031741693245e-05,-0.00015334084157472)	(0.00040970188787466,0.00035981598439555)	(-4.5498740931946e-06,9.4973546567707e-05)	(0,0.00014780469948915)	(-0.00019515952087079,0.00022222665353057)	(8.3175301892065e-05,3.1478906504065e-05)	(-5.1518753537498e-05,-2.4637016736672e-06)	(0.00049717772427042,0.00036899306749794)	(-4.0111110088195e-06,-0.00015675598929435)	(-0.00032449126168476,-4.0313500992076e-06)	(0.00026650334436888,-0.00022637695065831)	(7.7272105649114e-05,-0.00010409979707691)	(0,6.7951661317734e-05)	(-3.2822004285679e-05,0)	(-4.740230126098e-05,-5.5813087634e-05)
-9.0693368085066	(-0.00042170506165847,0)	(-4.246460605877e-05,-0.00033920048257983)	(5.7985359581519e-05,5.8414035401647e-05)	(-0.0002533055316467,0.00020463258109819)	(0,-0.00022873488302523)	(-3.1686155616403e-05,3.1450873863095e-05)	(0.00018398616297489,-2.3034189613653e-05)	(-0.00011099548742399,-0.0001373974794016)	(0.00035072836488661,1.4104038630222e-05)	(-0.00022368598840215,0.00055306658984211)	(0.00019168868817422,-0.00022366153005741)	(8.9064699330315e-05,0.00024831674287853)	(2.9662679359027e-06,-7.3438826771715e-05)	(-4.6814311370365e-05,-4.0143554237816e-05)	(0.00011579669044678,4.6851133586972e-05)	(5.1985518086839e-05,-1.8634184361351e-05)
-9.1386825729526	(0.00019044911375391,0)	(3.0255291341303e-05,-2.4387006086084e-06)	(-2.9644553826175e-05,0.00018834046529207)	(3.0442698051034e-05,5.7674398191262e-05)	(0,0.00028139348511788)	(-0.00027827061334699,-4.3802912535055e-05)	(3.6012908718428e-06,4.4693952643643e-05)	(-8.5215238672134e-05,4.4982931675988e-05)	(2.7471958092109e-05,-0.00022055455145776)	(-3.0739732149745e-05,0.00013397335410371)	(0.00025037379898467,-3.0691235884596e-05)	(-0.00015951859591596,-3.2386636203104e-05)	(-0.00046362332076655,-5.7729800933996e-05)	(-6.4543814164897e-05,-0.00052629414143253)	(0.00028162178922859,6.4603587478789e-05)	(-6.8060474423299e-05,0.00033530697844225)
-9.1386840940476	(-0.00016346108885523,0)	(6.6763262492221e-05,0.00011291852445212)	(2.8615886113187e-05,0.00015180840823)	(-7.3805382688994e-05,6.748151877818e-05)	(0,-0.00024152107845199)	(-0.00022430423493905,4.227771937488e-05)	(-0.00016684568532931,9.8635102971529e-05)	(-9.9707273263542e-05,-0.00010904532588609)	(8.5085381025975e-05,-0.0002205373906245)	(7.4484328103574e-05,-0.00023303407352552)	(-9.6864505975305e-05,7.4457231426717e-05)	(-8.5832534692959e-05,0.00014281426442219)	(-0.00046358428725281,-0.00017883600320575)	(0.00015651988305476,0.00020359085528414)	(-0.00048984422273795,-0.00015656094968099)	(0.00030020732715888,0.00018041281820505)
-9.1386849447827	(3.8373858491252e-05,0)	(-1.5150320220476e-05,0.00022086787376752)	(9.8017504427252e-06,-6.899890393206e-05)	(0.00014273824339426,4.554851573645e-05)	(0,5.6703618021191e-05)	(0.000101951298409,1.4472049329257e-05)	(-0.00032634022896949,-2.2393296325062e-05)	(-6.7299523869841e-05,0.00021090751923811)	(0.00021298504991026,8.4932787267401e-05)	(-0.00014405217137338,-7.237927274744e-06)	(8.4704707036567e-05,-0.0001440232854664)	(5.4310800956036e-05,0.00023275180730305)	(0.00017852140239983,-0.00044770198711082)	(-0.00030275019977835,-0.00017802661162761)	(-1.5218031678766e-05,0.00030278172487089)	(0.00048925017647487,-0.00011418967723932)
-9.1386859473762	(-0.00011545152254612,0)	(-4.9648376779204e-05,-9.047828934541e-05)	(-8.616466539783e-05,7.2799993654665e-05)	(0.00020217362051038,1.4730205523511e-05)	(0,-0.00017058419397817)	(-0.00010755867994958,-0.00012730867698708)	(0.00013368926644532,-7.335893386824e-05)	(-2.1771006342775e-05,0.00029871384522215)	(-4.3580308863768e-06,-2.335130631697e-05)	(-0.00020398370771728,-0.00013137094727884)	(-0.00010161877640701,-0.00020400203783172)	(-0.00012354267638496,-0.00017824037831533)	(-4.9095183397559e-05,9.1559519059574e-06)	(-0.00042882173605625,0.00021362144056475)	(-0.00027613972444952,0.00042879650443017)	(-0.00037467674497844,0.00025970396208413)
-10.319016754446	(-0.0001220895942487,0)	(-1.3648954192621e-05,-0.00010655587347755)	(1.9068057456563e-05,1.2394040107014e-05)	(-6.8004807861128e-05,6.0591164955035e-05)	(0,-0.00017664850741946)	(-1.7924657477657e-05,2.7576541732692e-05)	(0.00015416922114791,-1.9777015126203e-05)	(-8.767090604714e-05,-9.8396113673541e-05)	(-5.3489989743371e-05,0)	(2.8956178510971e-05,-7.7780088359271e-05)	(-2.6184856200883e-05,2.8950839351254e-05)	(-1.1085222060507e-05,-3.724848634907e-05)	(0,-9.2594139600334e-05)	(-5.0144694283631e-05,-4.5331433583841e-05)	(0.00013466454183317,5.0117542804519e-05)	(6.4497209933833e-05,-1.9209933597042e-05)
-10.319020517312	(7.7030969207596e-05,0)	(-2.9424898477422e-06,-3.9265865408484e-05)	(0.00011064140941163,0.00012279028489309)	(-3.9924030793648e-06,2.1102789013185e-05)	(0,0.00011144773890983)	(-0.00017763560211225,0.00016007381231135)	(5.6816771528775e-05,-4.252138496321e-06)	(-3.0526095193528e-05,-5.7745047591721e-06)	(-6.3826975959002e-05,-5.1032886064213e-05)	(1.6980792990474e-06,2.3813575293271e-05)	(4.1783114889689e-05,1.7045355505434e-06)	(-5.3540836086808e-05,3.0392525427938e-05)	(8.8333208917672e-05,-0.00011049966885863)	(-2.9305567964573e-06,7.2332030338445e-05)	(-4.1226952127498e-05,2.9514095544277e-06)	(-5.2605684332535e-05,-9.2664003069644e-05)
-10.319024249873	(-8.0943791400414e-05,0)	(-4.3936634659735e-05,0.00013048749933403)	(4.4257186479559e-05,5.5682064475318e-05)	(-5.891267260277e-05,-3.499640604293e-05)	(0,-0.00011712356465305)	(-8.0560760410686e-05,6.4036905544754e-05)	(-0.00018877468666523,-6.354314205427e-05)	(5.0624586013077e-05,-8.5233652623959e-05)	(3.6721030581503e-05,-4.9964042147434e-06)	(2.5084928387409e-05,-1.9560873855755e-05)	(-4.9364786195906e-05,2.5084294014035e-05)	(-4.2419652451611e-05,7.4405113779036e-05)	(8.6717402366963e-06,6.3548283577805e-05)	(-4.3425361697267e-05,-8.5463036889836e-05)	(3.3880320077668e-05,4.342246874214e-05)	(-0.0001287991980637,-7.3415946387885e-05)
-10.319027861519	(8.870353841631e-05,0)	(-5.6328664104645e-05,6.5071802977428e-06)	(-2.9434619814717e-05,-3.8768179687023e-05)	(-0.00014392705574112,3.3138650228585e-05)	(0,0.00012833440951012)	(5.6076314613947e-05,-4.2598683135649e-05)	(-9.4160160185e-06,-8.1502533631302e-05)	(-4.7946933833098e-05,-0.00020820407191443)	(1.5301317581887e-05,4.0491260234907e-05)	(6.1287150810421e-05,2.3659747976519e-05)	(5.1878355307252e-05,6.1289234998958e-05)	(-7.4727984582206e-06,-9.7602368632691e-06)	(-7.0091821294888e-05,2.6499745745057e-05)	(-0.00010606958362493,8.9809967686662e-05)	(-4.0955068175851e-05,0.00010607353855419)	(1.6906724019796e-05,-1.2955093341913e-05)
-10.380943002869	(0.00010850956232079,0)	(3.1410915298388e-05,5.7661554743199e-05)	(7.1878333513839e-05,-7.4610838884002e-05)	(-0.00015779854139275,1.4687478148335e-05)	(0,-4.8112514729099e-05)	(-3.3089740133162e-05,-3.1872038017847e-05)	(2.556771783766e-05,-1.3923040775372e-05)	(6.5183730709631e-06,6.9979144904134e-05)	(-1.114052555755e-05,3.3852423810367e-05)	(0.00012364689060627,7.3513214096261e-05)	(9.6532603850887e-05,0.00012364318930615)	(8.3073576087065e-05,0.00010150188694578)	(1.6604726995067e-05,5.4631464001423e-06)	(6.0628937511906e-05,-4.7335099163541e-05)	(3.6042229031165e-05,-6.0637455187527e-05)	(4.97697883831e-05,-4.073427460255e-05)
-10.380943995739	(-5.499338866363e-05,0)	(-7.6781514940485e-05,-0.00016220072328727)	(1.8564857247862e-05,3.6674404114323e-05)	(-0.00011824850488085,3.2264579960067e-05)	(0,2.4364413698114e-05)	(1.6262191291425e-05,-8.218904397491e-06)	(-7.1905572901352e-05,3.4058200120487e-05)	(1.4309566793238e-05,5.2415879632176e-05)	(-0.00014163472323294,3.1426949225535e-05)	(9.2650460856544e-05,-6.8367060592037e-05)	(-1.7806557131049e-05,9.2651745727708e-05)	(-8.8900070687686e-05,-0.00011254632071203)	(1.5415602440644e-05,6.9432723200434e-05)	(4.5425902934931e-05,8.7209262721299e-06)	(-3.3514041063347e-05,-4.5417409035523e-05)	(-5.5185753993252e-05,4.3596861889906e-05)
-10.380945811462	(-0.00014944113568233,0)	(7.4489275625591e-05,9.4749109375778e-05)	(4.7796241762055e-05,7.6549105256395e-05)	(-6.2614024806498e-05,5.4931131664731e-05)	(0,6.6246015582043e-05)	(3.3935376940646e-05,-2.1195349192307e-05)	(4.1998050890816e-05,-3.3035035625969e-05)	(2.4360758846609e-05,2.7764979190251e-05)	(3.6787545522993e-05,-0.00011834561440931)	(4.9060459960948e-05,-0.00016013336794011)	(-7.4050640552386e-05,4.9063129480025e-05)	(-1.6117368081894e-06,0.00011169047244028)	(-5.8028199876258e-05,-1.8029885288078e-05)	(2.4063870229703e-05,3.6299577566225e-05)	(-7.8511222610363e-05,-2.4051474391029e-05)	(5.4758344010946e-05,0)
-10.380948866336	(-0.00012170217449411,0)	(-2.8769538036109e-05,8.3563568342606e-06)	(-2.9824491081403e-06,-0.00017709405870571)	(-1.0398805271527e-05,-6.8932077323822e-05)	(0,5.3950478370065e-05)	(-7.8518196808242e-05,1.33587803859e-06)	(3.711718234489e-06,1.2766066981594e-05)	(-3.0559377231231e-05,4.6081080200048e-06)	(8.8864809612763e-06,0.00016130511061342)	(8.1451665113258e-06,-4.1346477408994e-05)	(-0.00014936951499864,8.1496541567525e-06)	(0.00011621629735881,4.2102124222881e-06)	(7.9094942093091e-05,-4.366604901821e-06)	(3.9988919241389e-06,7.3229536743359e-05)	(-2.0268636754782e-05,-3.985183839692e-06)	(2.0626306499588e-06,-5.6976219344668e-05)
-10.81848015094	(6.457457926733e-05,0)	(-3.4167350980302e-05,4.4132165591976e-05)	(-6.5372342784569e-06,-3.0439247216587e-05)	(-0.00012970573774035,3.9615618641584e-05)	(0,2.4713498775914e-06)	(1.1654261612175e-06,0)	(-1.688684536536e-06,-1.3086861210011e-06)	(-1.5161604380376e-06,-4.9628942057801e-06)	(-1.8362558139827e-05,-2.3414059436997e-05)	(-4.7008725753045e-05,-9.0456357831934e-06)	(-3.775887868484e-05,-4.7007903981594e-05)	(1.3503680416578e-06,-1.3624251817238e-05)	(-4.6497991869571e-06,3.646435660514e-06)	(-9.3374448953761e-06,7.4949253019503e-06)	(-1.7969450047205e-06,9.3343958658459e-06)	(-2.7057574595514e-06,0)
-10.818482667632	(7.5397898042003e-05,0)	(-1.2228432448846e-05,-0.00011371711392792)	(-8.4226961005488e-05,-2.1276917938552e-05)	(1.4648306525947e-05,1.0948037983528e-05)	(0,2.8846931902065e-06)	(0,-3.2241282198311e-06)	(4.3512507022308e-06,0)	(0,0)	(1.0688513931126e-05,-1.2142553249641e-05)	(5.3086509159513e-06,-2.3356849352698e-05)	(-3.1292271270274e-05,5.3084103792602e-06)	(-3.2806321189385e-06,7.1737894051402e-05)	(-2.4086858062863e-06,-2.1246437648605e-06)	(1.0513779429528e-06,6.2123556352542e-06)	(-4.6362255579629e-06,-1.0556416142321e-06)	(1.4245645711648e-05,0)
-10.818483965011	(7.3152822829444e-05,0)	(2.560855643185e-05,-4.7524690131686e-05)	(0.0001103922330307,7.4134378128842e-05)	(-1.3947301824314e-06,2.6401560626724e-05)	(0,2.7999803525996e-06)	(-2.8354709683149e-06,4.2244320599447e-06)	(1.8190171358323e-06,0)	(-1.0118321732627e-06,0)	(5.7230670341213e-05,3.6150668828952e-05)	(0,-1.6942356002016e-05)	(-3.6080269589434e-05,0)	(1.7587582240152e-05,-2.2783785032794e-05)	(7.1825920937174e-06,-1.1362758435107e-05)	(0,7.1655226530317e-06)	(-3.3644263570829e-06,0)	(-4.525488027208e-06,-3.4964612301236e-06)
-10.818487802108	(0.00010696433457432,0)	(1.1733100214585e-05,8.601728104921e-05)	(-1.2181118913179e-05,-1.7325942042115e-05)	(6.8932458857211e-05,-4.9688920954895e-05)	(0,4.0931851616303e-06)	(0,0)	(-3.2917947261327e-06,0)	(1.9009989932688e-06,2.6386787116314e-06)	(-3.5588131349624e-05,-2.0290152885992e-06)	(2.4982210743846e-05,-5.6772443821907e-05)	(-2.0758086337084e-05,2.4981771757629e-05)	(-1.0530703660943e-05,-2.6759881140203e-05)	(0,7.0667992377029e-06)	(4.9560640940307e-06,4.1244523210868e-06)	(-1.1271191168222e-05,-4.9636125215771e-06)	(-5.3110414360539e-06,2.0867320585845e-06)
-10.919471334088	(-1.0192933416254e-05,0)	(-1.0741001730069e-06,0)	(0,-9.3373401226038e-06)	(-2.7295567949742e-06,-3.9035005017201e-06)	(0,-1.2248978182583e-05)	(1.1218936621006e-05,0)	(0,-1.287740647845e-06)	(4.6901272797271e-06,-3.2806868331123e-06)	(0,8.0752251373589e-06)	(2.120770180532e-06,-4.8794792918686e-06)	(-1.0937154387568e-05,2.1121679661196e-06)	(6.4129601172805e-06,0)	(0.00011279879059782,-4.4134294201351e-06)	(2.9548130781491e-05,0.00015278054112118)	(-6.8169837203221e-05,-2.962130282552e-05)	(-2.2103407136284e-06,-8.9564869515781e-05)
-10.919472787814	(-8.7855904020691e-06,0)	(2.9720322488058e-06,1.8373673328181e-06)	(3.6745476303002e-06,8.5039294611014e-06)	(-4.3325984485713e-06,4.5799191352371e-06)	(0,-1.0560130209981e-05)	(-1.0220743228883e-05,4.4150316440421e-06)	(-2.2099894123911e-06,3.569456934384e-06)	(-5.5045700688497e-06,-5.2057642229611e-06)	(-1.4212379923657e-06,-8.903592246947e-06)	(3.363055634346e-06,-1.0371519434617e-05)	(-3.2670322663601e-06,3.359848588212e-06)	(-4.2945439628768e-06,4.2762539662057e-06)	(-0.00012437105393541,1.9875333205649e-05)	(4.692942921942e-05,4.5603398977231e-05)	(-0.00014487594236799,-4.6970358932027e-05)	(5.9750775461349e-05,5.9986603656611e-05)
-10.919473894595	(1.5910639326359e-06,0)	(8.9868597164494e-06,-9.3765393488606e-06)	(0,0)	(-4.9717537024991e-06,-4.336882654596e-06)	(0,1.9110403402095e-06)	(0,0)	(1.1267268992793e-05,1.0803041463179e-05)	(5.2149127228889e-06,-5.9768632159335e-06)	(-7.1523472525349e-06,-7.288421523553e-06)	(3.858971129312e-06,4.6018677603078e-06)	(-2.1346408125182e-06,3.8566172354404e-06)	(6.664455138614e-06,-7.3942768564709e-06)	(-0.0001018046459622,9.9917830593132e-05)	(5.3890141767433e-05,2.9798639681317e-05)	(6.4273165682973e-05,-5.3895536153571e-05)	(-0.00010329939186168,-9.3073161197309e-05)
-10.919476234283	(5.5984654640557e-06,0)	(0,5.733838559711e-06)	(5.2531008288964e-06,-3.7615187928188e-06)	(-1.0357382064684e-05,1.3135733433211e-06)	(0,6.7283620271643e-06)	(4.5191475131038e-06,6.3116478537125e-06)	(-6.8919869456165e-06,0)	(-1.5771835678534e-06,-1.2447120479435e-05)	(0,2.7973456962281e-06)	(8.0336351790823e-06,3.3257990008931e-06)	(5.361169686689e-06,8.0395585999685e-06)	(3.035679102851e-06,8.5237104865939e-06)	(3.9087468266825e-05,-5.2248268969588e-06)	(0.00011229178331273,-7.4904063639121e-05)	(4.6457252133168e-05,-0.00011222816498827)	(0.0001190824550306,-4.242317827985e-05)
-11.6457147866	(4.4091189325497e-05,0)	(1.4961082693383e-05,5.1314461761712e-05)	(2.7783472755802e-05,-2.9842415041227e-05)	(-0.00010592444281552,-1.4437932614938e-05)	(0,-2.3281057860053e-06)	(-1.5746574712863e-06,-1.4674262852001e-06)	(2.7068613725496e-06,0)	(0,5.5866616685999e-06)	(1.1473731825121e-05,7.2563249376138e-06)	(5.1650538411205e-05,2.853996950323e-05)	(1.4459292595615e-05,5.1649699969667e-05)	(2.1846849555226e-05,3.8569637512128e-05)	(0,-1.2088323112922e-06)	(5.4483328278618e-06,-1.5266931473113e-06)	(3.0137615284793e-06,-5.4508815764565e-06)	(4.0707791633318e-06,-2.3034142807437e-06)
-11.64571735889	(3.120722269009e-05,0)	(-5.7964527233195e-05,-1.916926963291e-06)	(9.502125414997e-05,-3.2054265469304e-05)	(3.0960341162879e-05,5.0392422025546e-05)	(0,-1.644764516873e-06)	(-1.6894463739252e-06,-5.0104135576176e-06)	(0,3.0574640150052e-06)	(2.6612174968973e-06,-1.6323977325965e-06)	(-4.7269129112453e-05,4.3894200746088e-05)	(-1.5096821175706e-05,-9.3554483495263e-06)	(3.9789516739112e-05,-1.5095920243907e-05)	(-1.2634779825621e-05,4.5398764438597e-05)	(4.6298449384594e-06,4.9880451637265e-06)	(-1.5894557253039e-06,-4.2001972413849e-06)	(0,1.5939003915795e-06)	(4.7860771940788e-06,1.335591579525e-06)
-11.645718263173	(3.8557339379284e-05,0)	(-5.9433674392245e-06,-0.00010598063082172)	(-1.4091219859727e-05,-5.8613293251297e-05)	(-1.8682252949339e-05,-3.3980206106054e-05)	(0,-2.0352484474854e-06)	(-3.0919627730377e-06,0)	(-5.5933965927874e-06,0)	(-1.7938114464177e-06,0)	(-4.4807324167559e-05,3.1477836407196e-05)	(9.1098915709804e-06,3.5370465794869e-05)	(2.2316988653122e-06,9.1094312459656e-06)	(2.5683269908415e-05,-5.8548759990667e-05)	(3.3185931689311e-06,4.7303417245696e-06)	(0,0)	(3.7338783617245e-06,0)	(-6.1790538418917e-06,-2.7132576241549e-06)
-11.645721501068	(-0.00011613323620213,0)	(-1.186914799935e-05,-1.6219750868902e-05)	(3.1402881461024e-05,-3.9403798393251e-05)	(-3.8097417191705e-05,-3.2217490325367e-06)	(0,6.1282437170394e-06)	(-2.0760560835207e-06,-1.660513370863e-06)	(0,0)	(0,2.0103973565792e-06)	(-2.3222281622319e-05,2.5000958124442e-05)	(1.8577400444546e-05,-5.50575187333e-05)	(-5.8200149205953e-05,1.8576663720204e-05)	(1.342620973831e-05,7.4036612476937e-06)	(2.6343763758908e-06,2.4530955700029e-06)	(1.9566563806379e-06,6.1462380423388e-06)	(-5.8063819459656e-06,-1.963968020395e-06)	(0,-1.4165390119718e-06)
1.4806183763277	(-0.0076277257648899,0)	(-0.15114113262375,0.10003935700539)	(0.34701671816083,-0.19011602805049)	(-0.020566479342459,0.008749565298239)	(0,-0.0062722510887339)	(0.15633171677641,0.2853505822549)	(-0.082261998560697,-0.12428280235436)	(-0.0071947356471924,-0.016911740985855)	(0.18850788159063,-0.26046785881657)	(-0.015697566102763,0.012500127258864)	(-0.00085625497383449,-0.015697566102755)	(-0.029747969359386,-0.34121991298123)	(0.35501983166085,0.25693779145387)	(0.021395911574675,-0.0011670825646226)	(-0.017037776159195,-0.021395911574675)	(0.46508554497403,-0.040546726656439)
1.4806183763277	(0.4357349240782,0)	(-0.0049667420109347,0.0032549176911466)	(0.0046036074999728,-0.0026554862740587)	(-0.0066938041273619,0.00083665499689289)	(0,0.35830323954842)	(0.0021835966822779,0.0037855296642665)	(-0.0026765069512566,-0.0040841338487673)	(-0.00068797835381731,-0.0055042907309312)	(0.0010294006608403,-0.0058177401373041)	(-0.0051091113368737,-0.33194034881744)	(-0.33321751900297,-0.0051091113368934)	(0.0017640885008031,-0.0059980960573704)	(0.0079296276077335,0.0014030815586344)	(0.0069637607304054,-0.45417821623117)	(0.45243742277459,-0.0069637607304033)	(0.008175454208619,0.0024044671209469)
1.4806183763277	(0.0017954795099489,0)	(0.30896628453314,-0.23693713929895)	(0.1454157801807,-0.094241694668275)	(-0.086533845998686,0.029257298996674)	(0,0.001476416255396)	(0.077494601956931,0.11957486591288)	(0.19483254586431,0.25406184939996)	(-0.024058170304139,-0.071156466095756)	(0.29183459785099,0.16389063909127)	(-0.066047802595303,0.020960501771689)	(-0.023701336294139,-0.066047802595289)	(-0.307752425745,0.069854570665774)	(-0.22338428766341,0.39777295468467)	(0.090023697608899,-0.032305116107272)	(-0.028569336133524,-0.090023697608903)	(-0.095212353766665,-0.41946908489059)
1.4806183763277	(-0.0068999190581628,0)	(-0.066171386157776,0.033303688261646)	(-0.055059304396738,0.017950324150302)	(-0.42250039336606,0.050776160532312)	(0,-0.005673778287106)	(-0.014760486108849,-0.045275065280528)	(-0.027385501445175,-0.054412489602241)	(-0.041753051695455,-0.34742053319173)	(-0.067443916637186,-0.036805196251794)	(-0.32247754916495,0.044021830710259)	(-0.03348896957095,-0.32247754916495)	(0.064206716485136,0.016605186366638)	(0.050165784895385,-0.091926612518988)	(0.43953954909858,-0.045645740682125)	(-0.060002116956632,-0.43953954909858)	(-0.022633005451677,0.087514282113779)
1.666379518186	(-0.076141610395763,0)	(0.023935731999822,0.0051908872246827)	(-0.57606677230023,0.24367014846872)	(-0.023602753620293,-0.048664725588651)	(0,0.057608629651427)	(0.18436047342943,0.4358512667048)	(0.0039274175859306,-0.018109739379634)	(-0.036819659302632,0.017857808430861)	(-0.23687672005742,0.10905594480298)	(-0.0096186996769562,0.011197502938421)	(0.050861636016173,-0.0096186996769545)	(0.089547151773317,0.23264589291967)	(0.12871888848365,0.2795859333347)	(-0.011352965061292,-0.060032062133713)	(0.013216428821256,0.011352965061297)	(0.27459228197968,-0.10569263201526)
1.666379518186	(0.61639517922602,0)	(0.0062279647322906,-0.0016525019526909)	(-0.069719055568671,0.018346263400203)	(-0.12302487392753,0.015291675280617)	(0,-0.46636367965416)	(0.013880755715796,0.052749334181747)	(-0.0012502805298746,-0.0047120688921635)	(0.011569658868685,0.093080437400375)	(-0.027738786236976,0.010014599313378)	(-0.050135646634298,-0.24496438730113)	(-0.25742785105184,-0.05013564663432)	(0.0049385032508305,0.029085656204294)	(0.011820245971503,0.032740129286474)	(-0.059175175822275,0.30384246280192)	(-0.28913181861333,0.059175175822269)	(0.034329841845818,-0.0058289224889791)
1.666379518186	(0.011354721524792,0)	(-0.21695804816621,-0.59020255263669)	(-0.018968522586956,-0.0081957395816401)	(0.059299569380283,-0.032689920150438)	(0,-0.0085909654880784)	(-0.0062008844286908,0.014351556094845)	(-0.4465463771708,0.16415013790411)	(-0.024733145168501,-0.044865966364014)	(0.23279184576072,-0.091755678185485)	(0.024166025626391,-0.01794926928732)	(0.0086946155278972,0.024166025626383)	(0.085075749314931,0.24825212001637)	(-0.10829935891561,-0.27476455032792)	(0.028523194799855,-0.010262267211256)	(-0.021185548352567,-0.028523194799853)	(0.29301233426522,-0.10041502926333)
1.666379518186	(0.12116654158947,0)	(0.0036900942844155,0.066977420267363)	(-0.0055525204001821,0.060560856466307)	(0.60545969608586,-0.1053091092119)	(0,-0.091674425905805)	(0.04582025430519,0.0042010287109008)	(0.050675016973456,-0.0027919198701616)	(-0.079676716055488,-0.458089909307)	(-0.029557725682836,0.02618383469879)	(0.24673964219756,-0.092294369726751)	(-0.0064622917368589,0.24673964219756)	(0.023176227258357,-0.02503214980821)	(0.030904817749784,0.034887026130246)	(0.29122715452064,0.0076274522303971)	(-0.10893517731648,-0.29122715452064)	(-0.029545482417197,-0.027354934362631)
3.6855229624433	(-0.018482037928922,0)	(0.0078131596512752,-0.0041268217268884)	(-0.00013335377269084,0.010121336848568)	(0.036170833899114,-0.0025676190257439)	(0,0.001514923976309)	(0.00082961924233788,1.0929770244328e-05)	(-0.00033826428088107,-0.00064042337376507)	(-0.00021046138321801,-0.0029648303225438)	(0.00072697869010822,0.0032648317135551)	(0.0065846113838553,0.0028970921444238)	(0.0038319216414357,0.0065846098655539)	(0.00042018495081788,0.00077553014056417)	(-0.0063238032051838,0.0014081188586215)	(-0.012754029262588,0.0074222241901446)	(-0.0056115091066407,0.012754032514972)	(-0.0015021595227404,0.00081387404929545)
3.6855229640042	(0.016137427132755,0)	(0.002815283077383,-0.033790118776699)	(-0.015834687994608,-0.011112244670615)	(0.0069761264335784,0.0020106628919668)	(0,-0.0013227444870288)	(-0.00091084201607616,0.0012979290756802)	(-0.0027696876238646,-0.00023076048004738)	(0.0001648081720464,-0.00057181579598951)	(0.0032686412583742,-0.0015103958979734)	(0.0012699481181929,-0.002571664993732)	(-0.003303715308611,0.0012699482189227)	(-0.0025353949919483,0.0090337996965073)	(0.0029255550732809,0.006331179606031)	(-0.0024598202900185,-0.0063991170034046)	(0.0049811746970461,0.0024598195161492)	(-0.017497978621904,-0.004910921277123)
3.6855229674693	(-0.016227342863749,0)	(0.011176072083329,0.0071540055270936)	(-0.033965897120934,-0.0025465984681688)	(-0.010126658765631,-0.011615312055936)	(0,0.0013301133666731)	(-0.00020873807384873,0.0027840962286413)	(0.00058639546032178,-0.00091607430804169)	(-0.00095207579657238,0.00083005456135698)	(-0.0074855497035356,0.0015709275124711)	(-0.0018434771923799,0.00083958335191378)	(0.0050685330035926,-0.0018434776764655)	(-0.0024981024844177,0.004880889798509)	(-0.003042801896868,-0.014499101822808)	(0.003570716897161,0.0098174734667892)	(-0.0016262264356248,-0.0035707158243512)	(-0.0094540169938372,-0.0048386877077851)
3.6855229699995	(-0.031172327311958,0)	(-0.0089929007415647,-0.018769983207575)	(0.0095632811360743,-0.010427884990101)	(-0.012562591326053,0.0086097975569326)	(0,0.0025551144020284)	(-0.00085474626159656,-0.00078387498238097)	(-0.0015385275459078,0.0007371268888968)	(0.00070572370062216,0.001029721957083)	(0.00515784443671,-0.0035353996480919)	(-0.0022869188334841,0.0072420189611388)	(0.0041073291623559,-0.0022869205571787)	(-0.00026122644241065,0.0016760079378635)	(0.006847877885743,0.0099904641050987)	(0.0044296396274427,0.0079556747779542)	(-0.014027397311837,-0.0044296398036418)	(-0.0032463345663816,-0.00050598265478422)
3.706629724231	(-0.0019805853532539,0)	(-0.00062944111403825,-0.00023379279509837)	(8.5918698636359e-05,-0.0024414410859414)	(-0.0002443223556221,-0.00070543347153814)	(0,-0.018160054303537)	(0.022385651218611,0.00078773270172253)	(0.0021436547158689,-0.0057714089213401)	(0.0064681439571843,-0.0022402026854969)	(-0.0007203626601235,0.0069193681567191)	(0.00055049770843571,-0.0028731908602184)	(-0.006052176387508,0.00055052278428121)	(0.0040828138964205,-0.00033320672859279)	(-0.0020035811032326,-0.00020858622306128)	(-0.00015940742250666,-0.0017524687203692)	(0.00083196230547137,0.00015939666412109)	(9.6480979111465e-05,0.0011822237492547)
3.7066297266232	(-0.0022993912599012,0)	(0.0010976043292844,0.00062130920319471)	(0.00036300138683543,0.0015702508388162)	(-0.0011593606830974,0.00028176046442802)	(0,-0.02108318683131)	(-0.014397697374805,0.0033283900079903)	(-0.0056967773154774,0.01006398058013)	(-0.0025834952779394,-0.0106302090246)	(0.00058201098792715,-0.006011255853755)	(0.0026122750372113,-0.0058158929990481)	(-0.0045461467496623,0.0026122966966238)	(-0.001064974240169,0.0022178596942137)	(0.0017406201763271,0.00016852676773572)	(-0.00075642037737712,-0.0013163858713765)	(0.0016840533640922,0.00075640657612326)	(-0.00064220143385417,-0.00030837055245995)
3.7066297272862	(0.00027279633133824,0)	(0.0019625154559306,-0.0018269226325615)	(-0.00072426917935519,-4.2809155414455e-05)	(-0.00036606067638744,-0.0017248153971339)	(0,0.0025012692014637)	(0.00039251483869559,-0.0066408703444496)	(0.016751118652928,0.017994382665402)	(0.015814883564839,-0.0033564184559463)	(-0.0024845109771378,-0.0043255115386842)	(0.00082480507292098,0.0045010428088805)	(-0.0032717113333997,0.00082481880196292)	(0.0045184293384109,-0.0057483896979145)	(0.0012524880816445,-0.00071941777176214)	(-0.00023883291640799,-0.00094735819987905)	(-0.0013033218001747,0.00023882975288301)	(0.0016645075947825,0.00130836140882)
3.7066297283254	(0.0012706665040142,0)	(0.00058378336244406,0.0011521194128212)	(0.00094629167556186,-0.00095476005609464)	(-0.0024001970703335,-0.0002193891900653)	(0,0.011650781015347)	(0.0087542497059456,0.0086766044852835)	(-0.010563829848091,0.0053527351163952)	(0.00201155823952,-0.022007539915006)	(0.00046377001252963,0.00083589431516825)	(0.0054081801098089,0.0033574060437965)	(0.0023687594158337,0.005408165587967)	(0.0034666759012845,0.0047281774562056)	(-0.00024204192479155,0.00013428887671645)	(-0.0015659921996638,0.00068589705845335)	(-0.00097216871453059,0.0015659957107441)	(-0.0013690888407868,0.0010038124281428)
3.7264563700012	(-0.0027369943463404,0)	(0.0041505248075416,-0.0040188907700852)	(-0.0076486028574411,0.0027541413511623)	(-0.0059862591378704,0.0017834378798672)	(0,0.0027013625807908)	(0.0027183085354046,0.0075490551094059)	(-0.0039665797108654,-0.0040965060482603)	(0.0017602382280725,0.0059083584896532)	(0.00093406181686141,-0.0017768328945615)	(0.0015404915702382,-0.0011632790592627)	(-0.00024538265089239,0.0015404906159907)	(0.00035934112023758,-0.003002484928748)	(0.011556968562641,0.0060753791416313)	(-0.010019744851519,-0.0015960337554716)	(0.0075662546342862,0.010019745517183)	(0.019528920639778,0.0023372469792214)
3.7264563807996	(0.0043583830989901,0)	(0.0042611896761335,0.0047714595154781)	(0.0046336046415012,0.0052615237975459)	(-0.0060079860342654,-0.00089550580782062)	(0,-0.0043016672002144)	(0.0051930398112686,-0.0045733134031025)	(0.004709361553951,-0.0042057256954751)	(-0.00088383948813789,0.0059297894012706)	(3.5466413439147e-05,-0.0024505493504688)	(0.0015460858607766,0.0013520237891323)	(0.00089113139139821,0.0015460868323032)	(-0.000257419994657,0.0024202812339022)	(0.015938999085375,0.000230710633744)	(-0.010056118213278,0.0057961461207896)	(-0.0087939020237454,0.010056116340141)	(-0.01574211591592,-0.0016743383499608)
3.7264563930516	(-0.010317092791943,0)	(-0.00093473486871632,0.0048493672437299)	(0.0027926834287648,0.00032063872563786)	(-0.0021101135827411,0.0016688590466137)	(0,0.010182813363459)	(0.00031646900990653,-0.0027563411633441)	(0.00478625615503,0.00092256727208771)	(0.0016471313798014,0.0020826497665627)	(0.00052926147501072,0.00015802719384992)	(0.00054300841748934,-0.0030844340581897)	(-0.0022255160052787,0.00054301269323106)	(-0.00032305326708994,0.0019665901955084)	(-0.0010278553957862,0.0034424521771737)	(-0.003531883525545,-0.014475321394404)	(0.02006193773532,0.003531879100914)	(-0.012791193739929,-0.002101227442892)
3.7264563960073	(-0.0036115121376777,0)	(0.0046671985674428,-0.0050493741061554)	(0.0034104549767576,0.0033464027443487)	(0.003314218452619,-0.0071997435823884)	(0,0.003564504417959)	(0.0033028477182803,-0.0033660698350724)	(-0.0049836583836418,-0.0046064554126448)	(-0.0071060408315064,-0.0032710838678261)	(-0.0021770409084843,-0.0020621981285808)	(-0.00085287630968458,0.00092338912455589)	(-0.0027821439305965,-0.00085286890306101)	(0.00033989178259567,-0.00042176021290433)	(0.013413070501108,-0.014159991820284)	(0.0055472870779466,-0.018095761303127)	(-0.0060059539588778,-0.0055473213776707)	(0.0027432175412252,0.002210737276617)
3.8373158207089	(0.0068870471301567,0)	(-0.0091399105177291,0.0056824742336894)	(0.0039676275366768,-0.0059460619626953)	(-0.017991424305856,0.002174587467065)	(0,0.0026128951833474)	(0.0022558934789197,0.0015052883656405)	(-0.0021558974501506,-0.0034676175244857)	(-0.00082502547000582,-0.006825809245699)	(-0.0012257820443668,-0.010783430284318)	(-0.01286022902079,-0.0033684481890907)	(-0.0064772487341716,-0.012860230562822)	(0.0022829569240305,-0.0068978825647518)	(0.0034305915876401,-0.00038996845605826)	(0.0040912816053369,-0.0020606455063415)	(0.0010716168451076,-0.0040912846016162)	(0.0021944607994025,0.00072629155503771)
3.8373158692427	(0.010125397226609,0)	(0.0034104799347384,-0.016787440544664)	(0.0019931455965062,-0.010443741328278)	(0.0014135160784961,0.0056358129838167)	(0,0.0038414983818894)	(0.0039622825541739,0.00075617839430475)	(0.0063690295047539,0.0012939014406705)	(-0.0021381937759371,0.00053627831873835)	(0.013424320178692,-0.0050273818220728)	(0.0010103744014893,-0.003209145143722)	(-0.01126608946698,0.0010103858734973)	(-0.0099029700300305,0.01057494521055)	(0.0015993976776703,0.0042707326128949)	(-0.00032144394282019,-0.0035841351332107)	(0.0010209405626563,0.00032143536785612)	(-0.003364265254275,-0.0031504828910515)
3.8373158895329	(-0.014969325243213,0)	(-0.0044296236923177,0.00016572873918175)	(0.01109773541078,-0.012688907496418)	(0.003427391896101,0.0017700759002409)	(0,-0.0056792483628278)	(0.0048140842892338,0.0042103936933808)	(-6.2877694509601e-05,-0.0016805704099923)	(-0.00067155837128487,0.0013003314462121)	(0.0078141638903573,-0.01223631277277)	(0.0024499002294796,0.011965301667778)	(0.0094348008002748,0.0024498914294693)	(-0.0059037298054631,-0.0080510953004576)	(0.0038928063518352,0.0024859449588629)	(-0.00077939410204018,0.0030015466948639)	(-0.0038065795199006,0.00077939844326568)	(0.0025613214568706,-0.0018781852715934)
3.8373159270454	(0.012990079690832,0)	(-0.0029171486045317,0.010263575626963)	(0.0091314980155504,-0.0033291893975121)	(0.01238645911279,-0.003506087257068)	(0,0.004928345167135)	(0.0012630728448879,0.0034644243695491)	(-0.0038939295106037,-0.0011067445827136)	(0.0013301904497166,0.00469933527688)	(-0.00080921837579916,-0.0044648779831311)	(0.0088538239269236,-0.011791456103134)	(-0.0067791300221722,0.0088538326733021)	(-0.00029454202082504,-0.013863572888942)	(0.0014204389247939,-0.00025744678995853)	(-0.0028167213027313,-0.0021566603318511)	(0.0037512804326683,0.0028167075589426)	(0.0044104811707537,-9.3718159458691e-05)
4.0005404478582	(-0.0017937439162804,0)	(0.001926989833489,0.000913753370667)	(0.00063731570807428,0.00094278966786317)	(0.0021686126566868,0.00023396213949664)	(0,-0.012720545734837)	(-0.006686446257651,0.0045183237336479)	(-0.0064807887952521,0.013664665540684)	(-0.0016602353239094,0.015379639002434)	(-0.0012126577958028,0.012573902148646)	(0.0095019949566201,0.0088852130884779)	(0.0068334766287272,0.0095026806579561)	(-0.0043113752358634,-0.006795706926889)	(0.016931569864444,0.0016326043803502)	(0.012795772494175,-0.0092019404114208)	(0.011964351684392,-0.012795003382933)	(-0.0091509947361946,0.0058057647334902)
4.0005404742718	(-0.0022386423117037,0)	(-0.001251453862658,0.0013273157406753)	(0.0012295363208402,-5.5982269138511e-05)	(-0.0014936478647455,-0.0013168055508292)	(0,-0.015874246180436)	(0.00039660966674984,0.0087193367580623)	(-0.0094130598621862,-0.0088748686769744)	(0.0093390751051554,-0.010591899811452)	(-0.00042864181807298,-0.0057283431720684)	(-0.0065444420275754,0.004037522381833)	(0.015577929188533,-0.0065438185852916)	(0.0052382910531482,-0.011203093912979)	(-0.0077136287471435,0.00057713290958683)	(-0.0088118347352128,-0.020976824471333)	(0.0054371988158062,0.0088125579551839)	(-0.015085640607817,-0.0070536667670255)
4.0005405247364	(0.0015564807872512,0)	(0.00087771596281155,0.00045520431780923)	(0.0016822109947316,0.0024596252648721)	(-0.0012306446133525,-0.0001588771017045)	(0,0.011037320489002)	(-0.017443194491779,0.011927338477704)	(-0.0032291492222156,0.0062238396859275)	(0.001127117467786,-0.0087274939330352)	(0.0053738689637623,0.014622600973661)	(-0.0053916071000529,-0.0075157481115328)	(-0.0061228772372245,-0.0053930338527355)	(0.0069319538982476,-0.0093642521741537)	(0.019690325289041,-0.0072368502985448)	(-0.0072617653812356,0.0082450981282957)	(-0.010120494788622,0.0072602543756826)	(-0.012609869260693,-0.0093341314804763)
4.0005405685957	(0.0017800289464414,0)	(-0.00039940608532861,0.0021922817605729)	(0.00071755208345682,-0.0012708988806786)	(0.0013835127787458,-0.0012815267077502)	(0,0.012622487279544)	(0.0090121705512748,0.0050890661000028)	(-0.015545661663629,-0.0028333305836026)	(0.0090865045744959,0.0098106982528036)	(-0.0064604162299838,-0.0073187101115358)	(0.0060621032583784,-0.013412613973049)	(-0.0021847970976953,0.0060607858661341)	(-0.0038174238902989,-0.012749036703328)	(-0.0098551306943107,0.0086997016304293)	(0.0081615731750546,0.0029417809110871)	(-0.018061437071866,-0.0081629917392726)	(-0.017167576113084,0.0051407142675376)
4.0124427949579	(0.0091992331974372,0)	(0.0033848320090262,0.00066384941950201)	(-0.000991884173828,0.023318933742253)	(-0.0054075222536515,0.015653300137602)	(0,0.0028942733285436)	(-0.0073363458034455,-0.00031172367534527)	(-0.00020889435579274,0.0010649928349892)	(-0.0049248317741705,-0.001701135201204)	(0.000784352348049,-0.012647912065106)	(0.0025611482711419,-0.0030568337492352)	(0.011771071841957,0.0025613045942777)	(-0.0094416676465585,-0.00015549349408229)	(0.016559598475982,0.0010264907434563)	(-0.0033530899332809,0.015411760050392)	(0.0040023168528518,0.0033533043253877)	(0.00020309631413854,-0.012361462640504)
4.0124428870333	(-0.0058763441360185,0)	(0.0062097248202569,-0.015145127834483)	(-0.015771656523073,-0.00065076726283432)	(0.017025690873176,0.0086046779171802)	(0,-0.0018487766254234)	(0.00020460860564873,-0.0049620590666645)	(0.0047648676608395,0.0019537302172304)	(-0.0027071093818696,0.0053566896608638)	(0.00029667103934557,-0.0026328512651225)	(-0.00806386654081,-0.006858750330715)	(0.0012922490222115,-0.0080638875263553)	(0.0032494105333527,-0.014643308837205)	(0.0034474013126902,0.00038855903042312)	(0.010558185502843,0.0016918787086261)	(0.0089799596199886,-0.010558146750386)	(0.019172278749345,0.0042542725568256)
4.0124429180633	(0.019322964459753,0)	(-0.0065153693794726,-0.019262126954327)	(0.0021816832250997,-0.0085277413149119)	(-0.0070407403906737,0.0012797961367889)	(0,0.0060793121223935)	(0.002683072008901,0.00068627524177025)	(0.0060600552770176,-0.0020499988905098)	(-0.00040267338565347,-0.0022151360410433)	(-0.010156722471439,0.0071248418201988)	(0.0033346734206154,0.008545931321629)	(0.0097582094989321,0.0033348007103532)	(0.00095316432911511,-0.0080898885787127)	(-0.0093288426475052,-0.013297635365535)	(-0.0043660820456196,0.012776301266615)	(-0.011188993705563,0.0043662120239785)	(0.01059198870194,0.001247862836951)
4.0124430416351	(0.020567281538751,0)	(0.0063814288894156,0.013472689341402)	(-0.0061121903958165,-0.0026041625708332)	(0.013897849450254,-0.0057452489084221)	(0,0.0064705410575273)	(0.00081924802709288,-0.0019229981539892)	(-0.0042386002424174,0.0020078212606971)	(0.0018076454615267,0.0043723295154971)	(0.0092762275256785,-0.0017889906870496)	(-0.0065827169701993,0.01246273271495)	(0.0070204263208085,-0.0065825560024728)	(0.004255866378599,0.0034861904805355)	(0.0023425598514066,0.0121449542186)	(0.0086183741852646,0.0091911781941692)	(-0.016316946766707,-0.0086181453974529)	(-0.0045643010090312,0.0055722382562903)
4.1182884493669	(-0.028021723244178,0)	(-0.00042761014875227,-0.03095643912241)	(-0.02673506981035,0.014565189529902)	(0.05646704518296,0.0057168979931629)	(0,0.0065811307199846)	(0.0034207650134873,0.0062789516714802)	(-0.0072703985495451,0.00010043899364721)	(0.0013426568018836,-0.013261733100919)	(0.00068130057671242,0.0022815969764578)	(0.0091128842999549,0.005444896329839)	(0.0035996699030042,0.0091129251199741)	(0.0024196326010853,0.0093105375335104)	(0.00049730420353104,-0.00014848241520173)	(0.0019862799144563,-0.00078458299080442)	(0.0011867740640584,-0.0019863017744749)	(0.0020293339870717,-0.0005273878566215)
4.1182886006096	(-0.0085031101690752,0)	(0.035164365692643,-0.04345983122632)	(-0.0089398812353005,0.031225253501296)	(-0.038945008499498,-0.011071890060547)	(0,0.0019969989247456)	(0.0073335605046454,0.002099557798129)	(-0.010206891565652,-0.0082586051320662)	(-0.0026002425964103,0.0091465660178602)	(0.0055710287730726,0.010714218093471)	(-0.0062851374418381,-0.00041451688291963)	(0.0031590386180706,-0.0062851685124219)	(-0.00063565021500704,0.0084564816172104)	(0.0023352834243104,-0.0012142799457259)	(-0.001369937521238,-0.00068859079852227)	(-9.0344797008691e-05,0.0013699396092087)	(0.0018432701833738,0.00013859622643796)
4.1182886692637	(-0.035310226330953,0)	(-0.0011397130983148,0.042120546033478)	(0.00066153852617617,0.047675161484287)	(-0.0087327300508168,0.022802748304394)	(0,0.0082928408712376)	(0.011196900473953,-0.00015541001057552)	(0.0098923309039986,0.00026768534530882)	(0.0053554405121288,0.0020509190831622)	(-0.0066907948827507,0.0075101042264961)	(-0.0014092941876953,0.0093785268584057)	(0.0020184826992105,-0.0014093040471318)	(0.0078779526116949,-0.0069043937856607)	(0.0016369922975503,0.0014583445243663)	(-0.00030722450074427,-0.00043999979644942)	(0.0020441788946183,0.00030717266843969)	(-0.0015049073064408,-0.0017170966134959)
4.1182888060062	(-0.061542763660252,0)	(-0.0040099257882007,-0.0040668932575541)	(0.013028756465467,-0.038299882528062)	(-0.015319464287855,-0.014156400782792)	(0,0.014453796085423)	(-0.0089950154124159,-0.0030598365055704)	(-0.00095514604482242,0.00094176161674178)	(-0.0033247144612384,0.0035979300679268)	(0.0027589105444359,-0.0068281072535487)	(-0.0024723270053354,0.007647407792341)	(0.012216607149257,-0.0024723326251923)	(-0.0055338714997685,-0.0014462802957081)	(-0.0014883569044297,-0.00060135343668466)	(-0.00053887467950849,-0.002662805216418)	(0.0016668851777994,0.00053883548588681)	(-0.00031524228046988,0.0012062077837039)
4.2126279146784	(-0.016063769313987,0)	(0.0040400554165342,-0.015982180623043)	(-0.010518943016354,0.0072463437986928)	(-0.015680186075847,0.0073306884296805)	(0,-0.017720906359479)	(-0.0079939104693549,-0.011603847978321)	(0.017630948262651,0.0044565506867353)	(-0.0080871525166373,-0.017297664321874)	(-0.0012731932749286,-0.0026302282704831)	(0.0036541521882314,-0.0054519432843458)	(-0.0020351280361431,0.003654190472838)	(-0.00074724694666332,-0.0061758869458804)	(-0.015365461499304,0.0074382588810085)	(0.021347793121459,0.011889251401971)	(-0.031850542618499,-0.021347329021717)	(-0.036079506564425,0.0043655987247587)
4.212627995258	(0.017410288986719,0)	(0.0084172619857563,0.0024459041095548)	(-0.0051531973328186,0.023651088520335)	(-0.0047370826440866,-0.0020601557596086)	(0,0.019206297734923)	(-0.026090855956779,-0.0056845620931781)	(-0.0026981279455967,0.0092855700471251)	(0.0022728816395382,-0.0052256284708909)	(0.0017708647930864,-0.007473338144973)	(0.0011039418163084,0.0045374725226223)	(0.0035772946681799,0.0011039233706953)	(-0.0035501397565498,-0.00063086728382226)	(-0.043659185494971,-0.010345235043031)	(0.006448930540558,-0.020898027706731)	(0.026508155237874,-0.0064493357693348)	(-0.0036856095408377,0.020739916351092)
4.2126280418558	(-0.017643468174259,0)	(-0.0034625217151764,0.020661874191336)	(0.0059470516081895,0.011749698861344)	(-0.005389312998935,-0.0063165842718326)	(0,-0.019463727955169)	(-0.012961703312245,0.0065605174122016)	(-0.022793263953172,-0.0038196136734003)	(0.0069680043766404,-0.0059452450018525)	(0.0034291643272516,-0.0019312955575422)	(0.0012559537758701,-0.0026396805690416)	(-0.0055837524998635,0.0012559532958376)	(-0.0035451277989675,0.0062010708260162)	(-0.011282599281844,-0.02003329358072)	(0.0073372725453519,0.032620272589273)	(-0.015421353575073,-0.0073371894616895)	(0.036226473963163,0.020710333327539)
4.2126281250915	(0.010959039319679,0)	(-0.013024910395907,0.005952036457101)	(0.0023428417162873,-0.0080355485219902)	(-0.024135354474865,0.0038490056248202)	(0,0.012089514498027)	(0.0088644626179879,0.002584410725169)	(-0.0065661184786652,-0.014368527885038)	(-0.0042461972429249,-0.026624970966278)	(0.00084111487336651,0.0049080422735433)	(0.0056246008466486,0.0016569449945907)	(0.0034509605956043,0.0056245927061192)	(-0.0011627642917557,0.0019330767205841)	(0.028672682446452,-0.0049140316460552)	(0.032858999299321,-0.020160498923296)	(0.0096796892809035,-0.032858551947084)	(0.011293032617989,0.0067927906460434)
4.2797993887658	(-0.026384224107784,0)	(-0.0065138360664164,-0.024604999489081)	(-0.015207693394105,0.018613449138079)	(0.06147669489262,0.00064923963230536)	(0,0.0048853778618705)	(0.003446565122428,0.0028158780752875)	(-0.0045559599186427,0.0012061474151828)	(0.00012016366976528,-0.011383345932317)	(-0.0034956209829814,-0.0045007694128785)	(-0.022867836219084,-0.010055798892583)	(-0.0095728331460525,-0.022867913628578)	(-0.0093467529446824,-0.014809380737949)	(0.0037855989760403,-0.0029404878830439)	(0.019235343401117,-0.0080520542046202)	(0.0084583753360809,-0.01923485385694)	(0.012456794845207,-0.0078619351702923)
4.2797995015504	(0.017207686494085,0)	(-0.0041424649111787,-0.052610009198843)	(-0.041752463777799,-0.0065086620616022)	(-0.022273519875266,-0.018403173087106)	(0,-0.0031862433951477)	(-0.0012051708461411,0.0077310996961362)	(-0.0097414484474788,0.00076712476327458)	(-0.003407593433652,0.0041242318390104)	(-0.0040387778886126,0.0039619948938863)	(0.008285248777072,0.013246397076364)	(-0.00044467158196349,0.0082852949572394)	(0.00088010168585234,-0.035100670315891)	(-0.0033325651804637,-0.0033972717146083)	(-0.0069693256195886,-0.00037406013535839)	(-0.01114193536732,0.0069689418098554)	(0.029524524741887,0.00074018038951073)
4.2797995516476	(-0.035208497030359,0)	(0.030655933347214,0.025751059967417)	(-0.037895713268127,0.02902918431504)	(-0.019571287335526,-0.014040455474441)	(0,0.0065193752189198)	(0.0053751521818679,0.0070168524519015)	(0.0047680979419718,-0.0056764415801552)	(-0.0025997684192284,0.0036238634328331)	(0.023675133100811,-0.022201533431983)	(0.0072800698362275,-0.0078740556728906)	(-0.018319456175234,0.0072801155988181)	(0.00060505432577084,-0.0045175582793481)	(0.018674560944065,0.019914242401726)	(-0.006123675694154,-0.015409044795697)	(0.0066233116031358,0.0061235508850234)	(0.0038002259944192,0.00050870904791925)
4.2797997031396	(0.058903501774313,0)	(0.016616480036745,0.019740267631556)	(-0.01726604407921,0.027590283748084)	(0.022345250181194,-0.0027255040395713)	(0,-0.01090671191256)	(0.0051087558962365,0.0031969417237215)	(0.0036551193640509,-0.0030768353453941)	(-0.00050474010451546,-0.0041374438800098)	(0.013765489418731,-0.016443968601881)	(-0.0083119419329299,0.022924641175806)	(0.020896952055581,-0.0083119267840582)	(-0.0040820670763356,0.00092031654879895)	(0.013831704305993,0.01157860633456)	(0.0069914117270997,0.017576993376894)	(-0.019282850134326,-0.0069914649125578)	(-0.00077402606754991,-0.0034337786013704)
4.3168514874887	(-0.0099674447555525,0)	(0.0014284379438161,-0.00024310923668218)	(0.00019394097705272,-0.0064623878178721)	(-0.0037026675022227,-0.0032698160474071)	(0,0.023901919566562)	(-0.015496510109832,-0.00046538012925943)	(-0.00058293256932488,-0.0034256422759824)	(-0.0078408918701825,0.0088790711263098)	(-7.4746479189009e-05,0.00086096087918477)	(0.00063313140804196,-0.0011453100376766)	(-0.0022637214772437,0.00063312589578661)	(0.0013494685909344,-8.3800695418396e-06)	(0.02490165941022,0.0021625772353223)	(0.018316814684279,0.065484355264233)	(-0.033133524362357,-0.018317963118003)	(-0.00024260818474365,-0.039035831208821)
4.3168515578644	(0.0068012093526475,0)	(0.0039652520800756,-0.0030559131300602)	(-0.0030151627916924,-0.0074041694388403)	(0.0011164167283898,-0.0055830242029736)	(0,-0.016309451646096)	(-0.017755030525581,0.0072301101608774)	(-0.0073283793058928,-0.0095089558660349)	(-0.013388238408333,-0.0026772046088303)	(-6.9578431211508e-06,0.0005881761393661)	(-0.00019090082965075,0.0021178003489881)	(0.00020837914907438,-0.00019101340701056)	(0.0019442754384352,-0.0010381597720965)	(0.017011274931193,0.00020268933154999)	(-0.0055223686824819,-0.0060262643116791)	(0.061265523567152,0.0055234390191427)	(-0.030033837593738,-0.056244799761614)
4.3168516182359	(0.00046344944304083,0)	(-0.0099637062987057,-0.0043759278354727)	(0.0018295394426344,-0.0055864095749828)	(0.0025557588551399,0.0028147756489372)	(0,-0.0011114669405634)	(-0.01339637110206,-0.0043876038268934)	(-0.010493766384049,0.023892784046204)	(0.006749965537768,-0.0061284196336319)	(-0.0010611572377449,0.0026592243221114)	(-0.00043708959555195,-0.0004021226381308)	(0.00056060883286494,-0.00043707158136096)	(-0.00074865136300776,-0.0004354444352534)	(0.076926366507891,0.030699668370717)	(-0.012642778737021,-0.016217973576432)	(-0.011632144149266,0.012642939889279)	(-0.012596761905462,0.021653710243265)
4.3168517630575	(-0.0046719255946181,0)	(0.00173650108634,-0.0043642104108872)	(-0.0046218025245423,0.0024540125921935)	(0.0097782103869903,-0.00087234890907283)	(0,0.011203448940005)	(0.0058847168750578,0.011083130477222)	(-0.01046558935153,-0.0041641144466593)	(-0.0020917715302147,-0.023448435871633)	(4.4066485075751e-05,-0.00071661453920033)	(-0.001672231357163,-0.00064974285890417)	(-0.00094811608702046,-0.0016721475242313)	(-0.00012268369096276,-0.0015366648039237)	(-0.020730418568974,-0.0012738510963199)	(-0.04837409957269,0.027427580647254)	(-0.018797158744111,0.04837231205024)	(-0.044454363770454,0.0035495810451843)
4.5820369919152	(0.035787624599759,0)	(0.0073766037047325,0.057316649970447)	(0.030909863792244,-0.019999724499454)	(-0.049962837469815,-0.036221875896854)	(0,-0.019119660713872)	(-0.010685394052238,-0.016513837585437)	(0.030622261135226,-0.0039415270886723)	(-0.019352325988093,0.026693240525667)	(-0.011187708164208,-0.0053481108636205)	(-0.021167632561224,-0.030508220497092)	(0.00018385697310283,-0.021167780385133)	(-0.011598357537293,-0.037378844329162)	(-0.0026473851474872,0.0055386770045639)	(-0.010478994142013,-9.1631348284757e-05)	(-0.015103241290947,0.010479421371771)	(-0.018504569482249,0.0057425965410872)
4.5820371485023	(-0.017771703729185,0)	(0.031028561654941,0.0017688338211839)	(-0.066519603864629,0.021989829086302)	(-0.013775327343033,-0.058345122852178)	(0,0.0094950584638854)	(0.011749199740591,0.035539355079379)	(0.00094462153940608,-0.016577810588473)	(-0.031171353058636,0.0073608110915851)	(-0.028931583786923,0.022462030527642)	(-0.0058360510607872,-0.017189764386948)	(0.032248245860256,-0.0058360656664384)	(-0.0038293741440001,0.027432722519352)	(0.011121175348648,0.014322767543286)	(-0.0028903126492023,-0.015964917735879)	(-0.0085094522138977,0.0028900019696157)	(0.013581493720071,0.0018956131044941)
4.5820373949612	(0.026026993459817,0)	(0.0013459389215982,-0.073939762165128)	(0.015357806433953,-0.041124724579526)	(-0.011140571220751,-0.039832435805307)	(0,-0.013904965669734)	(-0.021972131008461,-0.0082044193182328)	(-0.039503279504771,-0.00071854172909921)	(-0.021280629192641,0.0059523078243537)	(0.037832540738333,-0.016852758728654)	(-0.0047198206563984,-0.027902625599158)	(0.0058489192122394,-0.0047199194681379)	(-0.017993407252769,0.024819176204468)	(-0.0083445983126631,-0.018728783948034)	(-0.0023366581699213,-0.002895398513797)	(-0.013812819351916,0.0023370999594942)	(0.012287728824402,0.0089079035855453)
4.582037569226	(0.086660998779674,0)	(0.0029125625080887,-0.0011006206427886)	(-0.031018581455978,0.025119463052874)	(0.021153446369488,0.014956322791818)	(0,-0.046300407055598)	(0.01342106379971,0.016571551247243)	(-0.00058775656871515,-0.0015563709870577)	(0.007989980017599,-0.011301839733827)	(-0.012675234638576,0.011875998567335)	(0.00896207077966,-0.030378571687226)	(-0.043051859522962,0.0089618472515557)	(0.0094082689730377,0.013608007058782)	(0.0058804721490601,0.0062748827569962)	(0.0044374835272139,0.021313401999685)	(-0.015040646095409,-0.004436526623517)	(0.0067360435228989,-0.004658083067783)
4.5999381217023	(-0.028594841271464,0)	(-0.0063271330064043,-0.0181627129709)	(0.0043899925204048,0.0040677175563142)	(-0.017804921110285,0.0099591349973213)	(-1.9781779786919e-06,-0.039019116178516)	(-0.0055503883925971,0.0059907428083736)	(0.02478414287299,-0.0086362864862077)	(-0.013592749074942,-0.024295489508553)	(0.017038918359187,-0.0017077112714311)	(-0.013451254866695,0.029128723193612)	(0.014078763492028,-0.013452239510804)	(0.0078539468035824,0.010405363708666)	(0.0035169454619852,0.035076936452617)	(0.027693789956843,0.028981135961971)	(-0.059966227601923,-0.027689919472325)	(-0.021420448269893,0.016169501070353)
4.5999383457337	(0.023191656303438,0)	(-0.004714757326157,-0.030769043046603)	(-0.0031681424890725,-0.00832208497527)	(-0.0031858406042635,0.0065789059311721)	(0,0.031648436658438)	(0.011357289520749,-0.0043239672620055)	(0.041986724119219,-0.0064357338631209)	(-0.0089774294050896,-0.0043473228015269)	(0.020852758392374,-0.0098502570404845)	(-0.002407084864117,-0.012551573096756)	(-0.02249243625875,-0.002406865903076)	(-0.0027250957984728,0.025640160804676)	(0.020279858890164,0.042927761963335)	(0.0049545146044733,-0.046304685499567)	(0.02583994739953,-0.0049555429122801)	(-0.05278422716552,-0.0056096390244288)
4.5999383989519	(0.011053582079267,0)	(-0.0099424893378793,0.0017146521645821)	(0.032058864896348,0.014510497362176)	(-0.0097925952395178,-0.0090203019095297)	(0,0.015082709582917)	(-0.01979781610037,0.043748261336679)	(-0.0023396758462543,-0.013568603580228)	(0.012310524500609,-0.013364569398655)	(0.022925740676569,0.003450246008545)	(-0.0073987761981784,-0.015166248344331)	(-0.0015356087194108,-0.0073989709898434)	(0.018474246852876,-0.025516760788714)	(-0.0071005053388737,0.047196827619216)	(0.015232763522166,-0.0031600636991507)	(0.031222374206629,-0.015232216477086)	(0.052530410151287,0.038030878618747)
4.5999384720854	(0.01272313292544,0)	(0.0030124111653887,0.013776842953615)	(-0.01221011619584,0.011708179117191)	(-0.025697995115833,0.018227403786144)	(0,0.017363028500069)	(-0.015977268944114,-0.01665972419583)	(-0.018800944718174,0.0041109829872442)	(-0.02487454519285,-0.035066958335332)	(-0.019633408675973,0.011121882997776)	(-0.019415181728175,0.0041586467867261)	(-0.023384225669485,-0.019415141151806)	(0.0065698492208346,-0.0011843217126028)	(-0.022896259514686,-0.040417790993324)	(0.039968549675125,-0.048141558095854)	(-0.0085614325662715,-0.039969163964214)	(0.0024401142949353,0.013525096650794)
4.7016819622281	(-0.0062498217147171,0)	(0.0043715160726171,0.013617350096965)	(-0.010778449303092,-0.04045692447061)	(-0.0062728459677722,-0.033416003909205)	(0,0.0006898837086213)	(-0.0044659548654484,0.0011900299131852)	(0.0015032833797228,-0.00048267740875188)	(-0.0036886508948423,0.00069253681636315)	(0.0021490110315095,0.003178209670353)	(0.00055265915421991,0.0023925094414957)	(-0.0034939980743448,0.0005529268181231)	(0.0039483938438596,0.00024949858469481)	(-0.023770141064931,0.01607070063889)	(-0.0041327544730091,-0.026129788451378)	(-0.017894145590904,0.0041325037863448)	(-0.001868705388145,0.029530262313326)
4.7016822486991	(0.017981365923068,0)	(0.010335046972934,0.027407632366923)	(0.029177050898894,0.0036169129942751)	(-0.033231340432568,0.0016048356468791)	(0,-0.0019848128291787)	(0.00039905665061615,-0.0032208543828306)	(0.003025355121031,-0.001140972849191)	(0.00017717699242581,0.0036686288692765)	(-0.0001558225742896,-0.001228823979944)	(0.0029266921483594,0.0014423563585688)	(0.0017251593631266,0.002926807083236)	(0.00059180751927971,0.0049839514223833)	(0.0091911148064387,-0.0011649634689053)	(-0.021889550198092,0.012901637916402)	(-0.010787666997122,0.021888924047899)	(-0.037273657524266,0.0044252609944611)
4.7016827059205	(-0.033605517066755,0)	(0.021949613124204,0.033223398633543)	(-0.0037639480079679,0.014005389125661)	(0.014468539054238,0.0042375247500631)	(0,0.0037094930921069)	(0.0015460110905653,0.00041523825390038)	(0.0036670421809485,-0.0024232999386265)	(0.00046769650297934,-0.0015971636893586)	(0.0032577187560835,-0.0031671317194384)	(-0.0012743180601431,-0.0033332024179543)	(-0.0025868010264431,-0.0012743646331919)	(0.00069974413228448,0.0025947047311379)	(0.023684482642605,0.024364863200467)	(0.0095309629307922,-0.019345453911461)	(0.024928259522049,-0.0095301715567962)	(-0.019405174593263,0.0052327993534567)
4.701683221623	(0.040752197018884,0)	(0.014210294063462,0.017392210287276)	(-0.017630227743669,0.0037478131859303)	(0.025630777608582,-0.0023386059217925)	(0,-0.0044981376674312)	(0.00041386482760637,0.0019457622031952)	(0.0019196636121619,-0.0015688702491119)	(-0.00025854480644618,-0.0028289803827888)	(0.0030847261990701,-0.0015820663914619)	(-0.0022575121695461,0.0037957999084844)	(0.0033832965826519,-0.0022576450312909)	(0.00092146446878323,-2.115935718224e-05)	(0.011830066945232,0.023070413607317)	(0.016883909700658,0.025303961412897)	(-0.028386696157314,-0.016883958749818)	(0.00015736854284381,0.006891509378095)
4.7518405443721	(0.019411850177702,0)	(-0.0040104738513886,-0.018331297067625)	(-0.010066500166507,-0.0083422360412755)	(-0.010314199912655,-0.00074176406472909)	(0,-0.010292518730442)	(-0.0044232447580593,0.0053370991115695)	(-0.009719712629114,0.0021264131145374)	(-0.00039349397502169,0.0054690350508678)	(-0.00050371571289652,0.00075331892337036)	(0.00062888573006165,0.0012287093472049)	(0.0011382675184581,0.00062871664067923)	(0.0002638888613197,-0.0017314188105832)	(0.011014869220961,0.0073713899578017)	(0.0091985176857859,-0.016648075233011)	(0.017971337945007,-0.009197290849405)	(-0.025322249899408,-0.0038632359503136)
4.7518410298092	(0.0072040368635508,0)	(0.010836972627935,-0.0045290138103089)	(-0.0046286344198986,-0.00030120834237704)	(0.020782736215639,0.019065451312152)	(0,-0.0038196564487967)	(-0.00015958978937678,0.0024541734057962)	(-0.0024016882632564,-0.0057461221607107)	(0.01010900323726,-0.011019575431115)	(6.0275670834866e-06,-0.00064257070868642)	(-0.0012670592760452,-0.00072297270096389)	(0.0016017058984697,-0.0012669512120048)	(0.00067887154036723,-0.00055831932058316)	(-0.0093950421622666,-8.8508847278327e-05)	(-0.018533262525288,-0.023424635026182)	(-0.010578235834487,0.018531916838996)	(-0.0081669396666091,-0.0099329030827947)
4.7518414332875	(-0.021290870077847,0)	(0.0071932653939904,-0.016197113077926)	(-0.01314913560302,0.0050868093159939)	(-0.0055831482524545,0.0030809155381123)	(0,0.011288549417006)	(0.0026971003711774,0.0069718775774926)	(-0.0085879754432994,-0.0038139124244628)	(0.0016336346992079,0.002959724905966)	(-0.00018578969303269,-0.00074840904716933)	(0.00034034168706843,-0.0014858267785627)	(-0.0011104371668993,0.0003403423858583)	(0.00012859238896223,-0.0017890650854092)	(-0.010951070913135,0.0027182770646927)	(0.0049772514146279,0.016237163922429)	(-0.021732529359774,-0.0049791172151784)	(-0.026168322485723,-0.0018781074763147)
4.7518418009231	(0.011172287454642,0)	(0.013689142661103,0.0039052103071896)	(-0.0045836117687687,0.024384182396599)	(-0.0061166740793783,-0.005133974342819)	(0,-0.0059233802901199)	(0.012929004153757,0.0024305567062096)	(0.0020706387229354,-0.0072578841256744)	(-0.0027222575391724,0.0032431613124909)	(0.00051745663431745,-0.002321416322875)	(0.00037301451256462,0.00099422265179015)	(0.00036809376426183,0.00037295454946041)	(-0.00065207169841695,-4.1541171133508e-05)	(-0.033949107272054,-0.0075705372749129)	(0.0054550079877233,-0.0053837737328368)	(0.014540091727752,-0.0054534871921865)	(-0.00060511935846263,0.0095380948893589)
4.9331222918137	(0.0067183375067616,0)	(-0.014547397615989,0.0073384853947115)	(0.0030642066141175,-0.011439346238987)	(-0.01995145745388,0.012001871992125)	(0,0.0060307554537318)	(0.010268925842334,0.0027505938485438)	(-0.0065874944660639,-0.013058564623923)	(-0.010774149846846,-0.017909813899475)	(-0.002174088983521,-0.013215303264415)	(-0.01014595169637,0.0026869740031139)	(-0.0095201829371546,-0.010146070235718)	(0.0015805950201925,-0.0052903499328454)	(0.019998472653997,-0.0032895796481178)	(0.015354206390923,-0.014406723164446)	(-0.004066400028343,-0.01535314307447)	(0.0080054765058215,0.0023915762164181)
4.9331226978397	(-0.026958121994336,0)	(-0.0025570538571947,0.01125857650221)	(0.0078226270758544,0.0067336620397868)	(-0.0049809666188613,0.0012473967129795)	(0,-0.024200750107887)	(-0.0060444602206294,0.0070220501717125)	(-0.010106800595023,-0.0022955077500673)	(-0.0011203728100313,-0.0044714187037578)	(-0.0017472224535111,0.0021239992210392)	(-0.0025327431305774,0.014343699007543)	(0.013074751398264,-0.0025331891325014)	(0.0047245516053263,-0.0097035136396981)	(-0.0032139392121971,-0.0026443746471424)	(0.0038334013666053,0.019786284124555)	(-0.021707283005016,-0.0038331195698079)	(0.014684353269256,0.0071497171498323)
4.9331229126389	(0.012182063045505,0)	(0.0091200358717138,0.020429595125577)	(0.0010337720911255,0.012574503714854)	(-0.0084777358099751,-0.010627147477065)	(0,0.0109358023498)	(-0.011288194794238,0.00092733833965101)	(-0.018339718698378,0.0081873668588875)	(0.0095402265716541,-0.0076099667930221)	(-0.009863148598442,0.011032725152775)	(-0.004311482355737,-0.011599467786624)	(-0.00079045058408783,-0.0043113966582485)	(0.0017564976335134,-0.010915023441228)	(-0.016696025494412,-0.014926884247466)	(0.0065236905092513,-0.0011964561901785)	(0.017553545352499,-0.0065241494746151)	(0.016517363079919,0.0026583780882324)
4.9331234495325	(-0.0085236043762469,0)	(0.0096559984444988,-0.00062471159903498)	(-0.020848538033957,-0.012341581496599)	(-0.012086401452274,-0.0096745285181512)	(0,-0.007652017242359)	(0.011079290849477,-0.018715859115552)	(0.00056133951650472,0.0086685954840371)	(0.0086847806677156,-0.010849845860076)	(-0.010284568836566,-0.0013654681478004)	(-0.0061464241419795,-0.00058515798852402)	(0.0092542822117615,-0.0061463653808519)	(-0.011186444447213,0.01092009415491)	(0.0020663380094128,-0.015563526052928)	(0.0093016114072775,0.014004931527302)	(0.00088520838119824,-0.0093016065360317)	(-0.01652599586488,-0.016928777023932)
4.9788105076172	(-0.0045520887688499,0)	(-0.01005318922293,-0.0024376622851559)	(0.0040636364934119,-0.015181835219013)	(0.0066058939647485,0.0066629141703151)	(0,0.0061436321786735)	(-0.020491395929203,-0.0054849851694891)	(-0.0032904379225533,0.013568222076289)	(0.0089931181115185,-0.0089159813511599)	(0.0073738186801554,-0.028621100911284)	(0.0074922079514706,0.012719961528574)	(-0.0023941474750965,0.0074926723426885)	(-0.0058173638101088,-0.0018440987189161)	(-0.023996639999473,-0.0061827850596395)	(0.0062820607414419,0.002007808409596)	(0.010664694745668,-0.0062815138022419)	(-0.0015464024126082,0.0048777196847373)
4.9788106197678	(-0.011171898908224,0)	(0.0044420262239594,-0.012715249261143)	(-0.0099638939455358,0.0038163243201121)	(0.0048136154187531,0.0044176389801989)	(0,0.01507876271659)	(0.0051512350420887,0.013448303312963)	(-0.017162428924268,-0.0059954604464786)	(0.0059626519180211,-0.006497979619852)	(0.0031208809501489,0.0093668510646044)	(0.0054593603360313,0.0176817241548)	(0.0076606369675735,0.0054600292202541)	(-0.00070958847749078,0.025722712487843)	(0.0078532677218809,-0.0026167659256512)	(0.0045786163578838,-0.0064229164216443)	(0.014824693269153,-0.0045777622316145)	(0.021566703102929,0.00059499714056552)
4.9788109776486	(0.010212142278813,0)	(0.0061785663005496,0.00061218342243123)	(0.0025615663831222,0.0033792790272126)	(0.015986483040673,0.0068101765867517)	(0,-0.013782703706347)	(0.0045609356644271,-0.0034570018869344)	(0.00082582069035846,-0.0083393012101934)	(0.0091917180789196,-0.021577486525791)	(0.0022109184193974,0.010840296587701)	(0.018132017372101,-0.0038581459754454)	(-0.019306240619189,0.018131866827225)	(-0.0031750483061952,-0.0035992063729113)	(0.0090892139003428,-0.0018538837816653)	(0.01520240239409,0.016186888379928)	(-0.0032345220379932,-0.015202196252061)	(-0.0030173357757842,0.0026617945556348)
4.9788113565993	(0.014592851381509,0)	(-0.0040589067595977,-0.010923129612498)	(-0.0081533051794001,-0.0041785064580798)	(-0.0054406636477661,0.00069459216469084)	(0,-0.019695996663768)	(-0.0056399460298014,0.011003869033528)	(-0.014743492084598,0.0054782551058611)	(0.00093730547929214,0.0073438818029688)	(0.0031419622260823,-0.0093429416267777)	(-0.0061708914232526,-0.015763120592345)	(-0.017338843061997,-0.0061710449875977)	(-0.00013569923464133,0.021636328720832)	(-0.0078335330102161,-0.002634668960504)	(-0.0051742494913784,0.014537166639514)	(-0.013216441336955,0.0051740622366927)	(0.018140411355422,0.00011379165846347)
5.1098975355934	(-0.021280089544497,0)	(0.0099919760199119,0.0053383736852165)	(0.0038220979802304,0.01091013730213)	(0.032889415176013,-1.4408900823351e-05)	(0,0.016334378253759)	(0.0083744954279142,-0.002934517895436)	(0.0040978343057599,-0.0076701291598603)	(-1.1498379664157e-05,-0.02524550378226)	(0.0012661033896243,-0.017454070910557)	(-0.027463721720549,-0.017757597336777)	(-0.017781634421439,-0.02746396652608)	(-0.0007666733161696,0.0076491946408251)	(-0.0045458042021538,-0.00032945065349767)	(-0.0071518261048005,0.0046311696284329)	(-0.0046243304051001,0.007152738657037)	(0.0019926729442581,0.00019940196564485)
5.1098975832635	(-0.012811162914053,0)	(-0.010133567380584,0.030689302271792)	(0.014653193149814,0.009646574241903)	(-0.01509797064124,-0.0072221926555973)	(0,0.0098344361778229)	(0.0074047458513947,-0.011248283651464)	(0.023556652245187,0.0077779372278626)	(-0.005543506424398,0.011589204287651)	(0.013390916679581,0.00040672161568544)	(0.012607253387108,-0.004666928664259)	(-0.016728484176746,0.012607371094182)	(-0.016517048344313,0.037862552355668)	(0.00010554075026402,-0.0034867520046294)	(0.003283326667344,0.004356967330371)	(-0.0012159199074329,-0.0032834462935953)	(0.0098609005707858,0.0043014174500766)
5.1098977443769	(0.018946326683929,0)	(-0.012455590279868,-0.0012578277503638)	(0.031549742279967,-0.0034524350569588)	(0.013729742185863,0.0092213315275072)	(0,-0.014543272551016)	(-0.0026503923883873,-0.02421702978141)	(-0.00096562101280266,0.0095611194312274)	(0.0070782007510567,-0.010538923023015)	(-0.027395478700153,0.01328365315292)	(-0.011464838532009,0.0081206867572653)	(0.023520995206466,-0.011464724702584)	(-0.0075179507198494,0.025294874767023)	(0.0034599899648771,0.0071345505031796)	(-0.0029862035240573,-0.0061258090748923)	(0.0021149899143811,0.0029857352837131)	(0.0065872674368579,0.0019578894345288)
5.1098978224725	(-0.028645848467926,0)	(-0.011128791683672,-0.018522776881275)	(0.011474124305665,-0.014702312131039)	(-0.0085991377549915,0.0093396496246445)	(0,0.021988909039835)	(-0.011285626802393,-0.0088067060331822)	(-0.014218083061372,0.0085433469258554)	(0.0071690875638848,0.0066006511840912)	(-0.025048489421163,0.021569871484573)	(0.0071806997648559,-0.031719170397928)	(-0.016121272492698,0.00718039865504)	(0.0029842307208076,-0.0058856064450706)	(0.0056182103460277,0.0065231471306826)	(0.0018706426051663,0.0041990013666861)	(-0.0082611835127946,-0.0018696500193549)	(-0.0015334766989175,-0.00077666815644006)
5.1193729767566	(-0.0091207623565633,0)	(-0.00014515889331529,-0.00017249901581998)	(-0.00043967086296634,-0.010896875934137)	(-0.0018860641148128,-0.0049618823331095)	(-1.7483946611728e-06,-0.026918972113798)	(0.032161957286346,-0.0013002487934805)	(0.00050861132552187,-0.0004300952054406)	(0.014645059759228,-0.005566143646158)	(0.00033794729862606,0.013945696200179)	(0.0023818413788133,-0.0052524687217995)	(-0.017785758301396,0.0023823991847215)	(0.013578682996017,-0.00077362482355019)	(-0.024269772187208,0.0005893365505958)	(-0.0041460612780492,-0.030950957110672)	(0.0091399750636416,0.0041437706598801)	(0.0013468601644805,0.023629581838378)
5.1193731598699	(-0.010738372649004,0)	(0.00065088924028125,0.0041608828379032)	(0.0028122407174503,0.0076163150765276)	(-0.0038569947080498,0.0040640049835668)	(-1.7662132572334e-06,-0.031692748771838)	(-0.022479463576813,0.0083015984022459)	(-0.012279229240458,0.0019221484203192)	(-0.011994819475397,-0.011383235537019)	(0.0017028398914807,-0.010441180442654)	(0.0048708793702753,-0.018694589252809)	(-0.0084290632532196,0.0048712414709134)	(-0.0087969339789346,0.0088068347544842)	(0.018170762083423,0.0029621841285121)	(-0.0084778623373064,-0.014668262648494)	(0.032532442475341,0.0084754424891376)	(-0.015325701760016,-0.015308241426245)
5.1193732291088	(0.0015067347562367,0)	(0.0093768790336477,0.0097420751340282)	(-0.0019326113796189,0.00095117270670412)	(0.0019869754281229,-0.0060549715607369)	(0,0.0044464199126556)	(-0.0028069638540267,-0.0057022261218188)	(-0.028752547126987,0.027676645697496)	(0.017870850303857,0.0058626354861024)	(0.014744270432866,-0.013043988610472)	(-0.0025091792657626,0.0095499286960074)	(-0.0057443587374208,-0.0025091286615244)	(0.010641320210855,0.0098629317968584)	(0.022699886345713,0.025657150551951)	(0.0043657767665647,-0.0099966933856972)	(-0.016618887460926,-0.0043657187219091)	(-0.017164481739253,0.018519366409484)
5.1193733951945	(0.0054396478126368,0)	(-0.0015555662705419,0.0052259420498602)	(0.0053486814446097,-0.0034991731232982)	(-0.011325155034806,0.0013800180216037)	(1.7854671851653e-06,0.016055077930869)	(0.010328589822757,0.015787081678278)	(-0.015424340971958,-0.0045914883337441)	(-0.0040742757798688,-0.033427239340447)	(-0.00015502404702006,0.0063840496965243)	(0.014303342048396,0.0051269463666186)	(0.0086130968549373,0.014302969861911)	(0.0024548089811129,0.0133553443786)	(-0.01111024812204,-0.00026998248586664)	(-0.024890613704093,0.014989374528059)	(-0.0089217094077171,0.02489285560161)	(-0.023241803061918,0.0042721603333872)
5.5188587843602	(-0.0058860291790681,0)	(0.0037975482711306,-0.0053241359445177)	(-0.0057088290767506,0.0040094440111038)	(0.013645861149501,-0.0016865781862051)	(0,-0.00096217483926951)	(-0.00065537279596476,-0.00093317748051652)	(0.00087032540105357,0.00062070280162584)	(0.00027568018436859,0.0022308426600922)	(-0.00025366473447582,0.00514933378339)	(0.0090004270490262,0.0027698407032236)	(0.0049947545751887,0.0090004572442257)	(0.00013979531004039,0.0072771322861483)	(5.3163965431184e-05,2.6338865057878e-06)	(9.2693440313614e-05,-5.1511022321889e-05)	(2.8574428351398e-05,-9.2841954247638e-05)	(7.5072033835473e-05,-1.4048612043605e-06)
5.5188596474916	(0.0020819004096692,0)	(0.003474163621507,-0.015327401859848)	(0.0060606311275141,-0.0026966555165566)	(-0.0022465453422397,0.0038402642551369)	(0,0.00034032599461952)	(0.00044061535642996,0.00099089662602997)	(0.0025057765718214,0.00056807554264741)	(-0.00062766260881566,-0.00036740765958506)	(0.014106984988375,0.00051266796270633)	(-0.0014817891536298,0.0011598472143342)	(-0.0039061891191493,-0.0014817623572223)	(-0.004070086841118,0.0061121507335592)	(5.0870511749532e-06,-0.00014534231386051)	(-1.5174435259635e-05,4.0383961430749e-05)	(1.2068723508424e-05,1.5256806821874e-05)	(6.3094999646615e-05,4.1984372835163e-05)
5.5188599851019	(-0.011595717963351,0)	(-0.0040343821280482,0.00099189630462183)	(0.0071818921134849,0.0077798646735341)	(-0.0019204189180687,0.0069003424627618)	(0,-0.0018959350313904)	(-0.0012719559900924,0.001173946254723)	(-0.0001622843438552,-0.0006595591448377)	(-0.0011280661509231,-0.00031411723485919)	(0.0040828179037001,0.0024703628251021)	(-0.0012665703545405,0.012199563228796)	(0.0030968561167301,-0.0012666410186592)	(0.0077923530170031,-0.005391272657211)	(2.5476936650905e-05,-4.2238348816685e-05)	(-1.3016949414547e-05,-3.1824924727648e-05)	(0.00012564644429843,1.299693610459e-05)	(-5.5539576980578e-05,-8.0303750599687e-05)
5.5188604191365	(-0.011903324434415,0)	(0.0026599363285561,-0.001014330999581)	(-0.0031133924827899,-0.010033084642072)	(-0.0052696948691677,-0.0052163921521536)	(0,-0.0019460654346675)	(0.001640452801573,-0.00050867874750998)	(0.00016581963654994,0.00043500169823252)	(0.00085287177881876,-0.000861353560693)	(-0.0013845662272394,-0.004863070650396)	(-0.0034757933788163,0.0044105712642881)	(0.011291642921871,-0.003475827233266)	(-0.0083719454808175,0.0027226519958457)	(-5.0179517460638e-05,1.4425120778264e-05)	(-3.5912186850525e-05,-0.00011634797581741)	(4.5429216547731e-05,3.5788919438986e-05)	(2.8187017063462e-05,8.6207452935581e-05)
5.5627054865164	(-0.0014841681392235,0)	(6.6051554980618e-05,-0.0015104316230579)	(-0.00024513154543241,0.00058639311043428)	(-0.0010778133480577,0.00081146778680506)	(0,0.0099290881280716)	(0.0039229379400801,0.00164022868394)	(-0.010104654457808,-0.00044279011574036)	(0.0054277974203988,0.0072103566728743)	(0.0041462900359798,0.0021384925555011)	(-0.0035323526708992,0.0075225610762487)	(0.0022048053279808,-0.0035316582885406)	(0.0017047985041156,0.0057531198645359)	(0.0031349074035346,-0.0060782543303568)	(-0.0051772050029688,-0.0032323028087406)	(0.011027719176851,0.0051782295667936)	(0.0084338665951378,-0.0024990913541351)
5.562706070574	(-0.0011697666991078,0)	(-0.00050851853048159,0.00015293205314005)	(-0.00077239645265836,-0.0020822382655784)	(0.00035191075917467,-7.4303255303368e-05)	(0,0.0078251809632145)	(-0.013931472442692,0.0051658381293968)	(0.0010226622169905,0.0034015786912325)	(-0.0004968799550335,-0.0023551380288511)	(-0.0030316776325165,-0.0084904452566344)	(0.001153169443675,0.0035897584079931)	(0.0040767458466354,0.0011539406434947)	(-0.0051578425810954,0.0020296705122078)	(-0.012446733923424,0.0044440729630689)	(0.0016918646689153,-0.0059760661062313)	(0.0052624416924958,-0.0016905529098021)	(0.0029752273382826,0.007561389243483)
5.5627065168209	(0.0013839666952429,0)	(0.00053621193685695,-0.0016075024126254)	(-0.00073713330345383,-0.00065892216766086)	(0.0006993422690245,0.00067732773704264)	(0,-0.0092578620938827)	(-0.0044079130402778,0.0049307178406298)	(-0.010754947962855,-0.0035875481081351)	(0.0045317069600301,-0.0046784800224787)	(0.0028527810793985,-0.00040193540517169)	(0.0022917431211202,-0.0023151382621053)	(-0.0067548903405747,0.0022918026527674)	(-0.0039166380129357,0.0076836807112152)	(-0.0005891452068167,-0.0041822607309976)	(0.0033596929838557,0.0099022854268945)	(-0.0033938595099672,-0.0033595310143827)	(0.011263843233116,0.0057414893700879)
5.562706954259	(-0.0011074122808963,0)	(0.0011186892819588,-0.00014612524797821)	(0.00022345983139112,0.00059009026668694)	(0.0019462945165799,-0.00016252808610248)	(0,0.0074084962052205)	(0.0039482832092137,-0.0014943537287397)	(-0.00097764251648716,-0.0074835105404883)	(-0.0010867076867253,-0.013021711604156)	(0.0012109640254099,0.0055999557863167)	(0.0063785999810986,0.0030967095913368)	(0.0041615151687666,0.0063786482769145)	(-0.0017319025615858,-0.00025316044218761)	(0.0082092254198866,-0.0017752261056001)	(0.0093509319758849,-0.0061004390571302)	(0.0045396364910386,-0.0093507186098319)	(-0.00037104564119016,0.0025387370985694)
5.6809122049497	(-0.0053519609786804,0)	(0.00076618154331939,0.0037762326319726)	(0.0024262469790583,0.00033150147091036)	(1.8615139940053e-06,-0.00015314194549747)	(0,0.0071303640387498)	(0.00044164638420781,-0.00323245197744)	(0.0050310693003651,-0.0010208104836503)	(-0.00020399226782098,-2.5230068204032e-06)	(0.0015439848335262,-0.0012554491912149)	(-2.1434847381194e-06,-0.0059458408312916)	(-0.0062961491518347,-2.1396732159404e-06)	(0.00049719873790741,0.0070938041345243)	(-0.0011326052292725,-0.0013928823873987)	(-1.890824110736e-06,0.0056802016626635)	(-0.005364144695071,1.9510713376141e-06)	(0.0063997688358029,-0.00044856654302172)
5.6809122861217	(-0.0027884063586202,0)	(-0.0022145585353927,-0.002652192706187)	(-0.0010621950465765,-0.0024638764356333)	(-0.0045870091936839,-0.0012478587651426)	(0,0.0037149471853262)	(-0.0032826850785187,0.001415112590129)	(-0.0035334432060532,0.0029504590388924)	(-0.0016625564028685,0.0061112059682744)	(-0.0018184822374387,0.0053508229845179)	(0.0052461920642356,-0.0017619066106246)	(-0.0046163169477078,0.0052460772959049)	(0.00028519617735099,-0.0042480728918373)	(0.0048273025148336,0.0016405242877717)	(0.0047328666756817,0.0041646649664559)	(-0.0015895872299763,-0.004732915013164)	(-0.0038325201107053,-0.00025725288116733)
5.6809124079501	(0.0015733784564921,0)	(-0.0021130143111507,0.0036651948484987)	(-0.0010640932145427,-0.0046707044501044)	(0.0012800648211937,-0.0021330555417856)	(0,-0.0020962162423279)	(-0.0062227509230994,0.0014176411491465)	(0.0048830881130475,0.0028151462961484)	(-0.0028417726566734,-0.0017053811084294)	(0.0054088775051865,0.0077585740275761)	(-0.0014640677930317,0.0042390600244993)	(-0.00064004234557634,-0.0014640533821741)	(0.0029252430091215,0.0029749447479759)	(0.0069994767823389,-0.0048797650315869)	(-0.0013208124280692,0.00057746887059273)	(0.0038243413149649,0.0013208070797284)	(0.0026838596180913,-0.0026390373953717)
5.6809124588491	(0.0032582590369637,0)	(0.00038366047375902,0.0021631499539287)	(0.0035901142786155,0.00069135710617452)	(-0.0045405545430817,-0.00028944794800276)	(0,-0.0043409259661436)	(0.00092112405081115,-0.0047830374660958)	(0.002881954850187,-0.00051115928797846)	(-0.00038561459241832,0.0060494463738448)	(-0.0016319892713469,-0.0012295035759649)	(0.0051930657685464,0.0040575494140025)	(0.0033954519106202,0.0051931511757681)	(-0.00035196604253647,0.0065800253228189)	(-0.001109197116947,0.0014723705280489)	(0.0046849644046462,-0.003063271250031)	(0.0036605288638036,-0.0046849952199519)	(0.0059362476784459,0.00031748130763812)
5.7891989782212	(-0.0026704721125866,0)	(-0.00053075644294301,-0.00050179329203843)	(0.00050402072211327,-0.0017526641034063)	(-0.00085347140635434,-0.00036824275410144)	(0,-0.0021629982000228)	(0.0014195703199374,0.00040823256989744)	(0.00040644949974538,-0.00042988391646525)	(0.00029826976095876,-0.00069130556381391)	(-0.0023071658934278,0.0052378930160706)	(0.0019578005639591,-0.0052810970964573)	(-0.0069704587145624,0.0019578101676821)	(0.0028029668332749,5.0791020643442e-06)	(-0.0048066152070729,-0.0021171273183508)	(-0.0017966127376624,-0.0063964210873714)	(0.0048462277628729,0.0017965029936004)	(-4.6336002034065e-06,0.0025721441162024)
5.7891992930354	(0.0015841729800361,0)	(-0.00040121429249211,-0.00039705731551738)	(3.7327191598367e-05,-0.0025827785674474)	(0.0012413538360536,-0.00090196186519013)	(0,0.0012831049454889)	(0.002091946002256,3.0201930504992e-05)	(0.00032159783995557,-0.00032496098443333)	(0.00073056858273148,0.0010054330995992)	(-0.0009963627766296,0.0068449053957766)	(-0.0028474581054186,0.0057029123632113)	(0.0015647531749443,-0.002847472515155)	(0.0050043124966295,-0.00082528237082873)	(-0.0062812960049351,-0.00091427998309907)	(0.0026130342915656,0.0014359188991102)	(-0.0052333342705351,-0.0026129508292484)	(0.00075730732362832,0.0045922264511351)
5.7891993936109	(-0.001014559266769,0)	(0.0013816367630077,0.0024635742439911)	(-0.0001405711301994,-0.00028481805858911)	(0.0015819338007707,-0.00049404988680866)	(0,-0.00082174247563589)	(0.00023069223939606,-0.00011389971813279)	(-0.0019953968741032,0.0011190425930442)	(0.00040016793186459,0.0012812947432069)	(0.0059736399808214,-0.0025159804706417)	(-0.0036287066317562,-0.0011939472707305)	(-0.0034606373450429,-0.0036287431817687)	(0.0038226429568193,0.005328534926726)	(0.0023088460869809,0.0054817025433246)	(0.0033299458206614,-0.0031756865191299)	(0.0010956289515541,-0.0033299163373192)	(-0.0048897930923685,0.0035079206695304)
5.7891996535202	(-0.001088359551208,0)	(-0.00056963541460254,-0.0016432226371895)	(-0.0010513152504895,0.00080663475419789)	(0.0024263572003223,5.1249562490983e-05)	(0,-0.00088152329890543)	(-0.00065333838524653,-0.00085152221250105)	(0.0013309416153013,-0.00046139322979419)	(-4.1489809199303e-05,0.0019652112184669)	(-0.0013578218939376,-0.00054360245278478)	(-0.0055656589221869,-0.0026140841315021)	(-0.0023790129705631,-0.0055657130233109)	(-0.0031570076451402,-0.0061809097339056)	(0.00049883978069402,-0.0012460105219733)	(0.0051074680983725,-0.0021831342822657)	(0.0023988136408631,-0.0051074343310559)	(0.0056719715849986,-0.0028970961866436)
6.945530093909	(-0.0015583824849871,0)	(0.0007778965858154,-0.0013768907282712)	(-0.0015374346569192,0.0010354771596238)	(0.0035289237819832,-0.00035430171830343)	(0,0.00061620162507833)	(0.00040945503081817,0.00060791418471241)	(-0.00054446713233359,-0.0003076215968301)	(-0.00014009461009758,-0.0013953497383629)	(-0.00012103746296804,0.0013671279094222)	(0.0026605235484483,0.00090778269571786)	(0.0014420486598065,0.0026606058965234)	(0.00019422971172397,0.002197194482523)	(-0.00074321906242208,-6.5827961587648e-05)	(-0.0014465223286208,0.00078399719207278)	(-0.00049352330265797,0.0014463959765985)	(-0.0011945178881298,0.0001056187853648)
6.9455323095846	(-0.00021650296036152,0)	(-0.0041564135360927,-0.00054487361284847)	(-6.0123276036548e-05,-0.00093814091773361)	(0.00097937257507223,0.0012170928414125)	(0,8.5587099732069e-05)	(-0.00037084817520556,2.3855879561559e-05)	(-0.0002153211227883,0.0016434526618252)	(0.00048117415118251,-0.00038740158024684)	(0.00036559068177666,-0.003841068035353)	(0.00073831620975145,0.0010809067137837)	(-0.00075442736406346,0.00073827715073669)	(0.0024262919164061,0.00045614357890409)	(0.0020884033392676,0.00019894609086442)	(-0.00040122597494367,-0.00041020879666954)	(-0.00058773599600385,0.00040129393137462)	(-0.00024803207349925,0.0013190104286535)
6.9455330475924	(-0.0030448714071681,0)	(-0.00036132127591756,0.00081652516174956)	(0.0010267803404445,0.0025372609468133)	(-0.0010951987056228,0.0014776207019755)	(0,0.0012038197862003)	(0.0010032538481552,-0.00040606627913566)	(0.000322767127296,0.00014282938894855)	(0.00058427652851956,0.00043300391647979)	(0.00015842259501005,0.001640473187219)	(-0.00082576762076326,0.0034097901425059)	(0.0011816816609938,-0.00082567914737999)	(0.0021853768499038,-0.001389787181779)	(-0.00089183049933172,8.5997093475232e-05)	(0.00044885820398848,0.00064256041195627)	(-0.0018539366765743,-0.00044904342797247)	(0.0007556377430166,0.0011881699103161)
6.9455346648659	(0.0030325553226142,0)	(-0.00025979325153427,7.3423103130497e-05)	(0.00023671309652007,0.0030127068596234)	(0.00078360246069565,0.0013884442319648)	(0,-0.0011990227164075)	(0.0011912453930487,-9.3772802101757e-05)	(2.9009897229171e-05,0.00010264928744314)	(0.00054895698896748,-0.00030982642911701)	(0.0001230016671725,0.0020754435045558)	(0.00059087025120978,-0.0012396009255438)	(-0.0033332388686328,0.0005907901954276)	(0.0024673133620954,-0.00023375732141986)	(-0.0011282826503199,6.6713695507156e-05)	(-0.00032118923298826,-0.0018123165223578)	(0.00067398446326829,0.00032133701579868)	(0.00012698300452951,0.0013414743722022)
6.9809513261622	(0.0017854802598792,0)	(0.000266070368881,0.0013285437135309)	(-0.0002522297658623,-6.9591210454086e-05)	(0.0010033953156116,-0.00067608816495851)	(0,-0.0030442067109074)	(-0.0001187808963852,0.00043014249690496)	(0.0022652353428374,-0.00045341795336891)	(-0.0011526897829259,-0.0017108109099743)	(0.00055490563157406,-6.8701784130198e-05)	(-0.00035226508262658,0.00086385571164303)	(0.00038933980590032,-0.00035203898015763)	(0.00011771357732761,0.00037770376875086)	(0.00028091062711433,0.0022639709396473)	(0.0014367148703235,0.001588707184944)	(-0.0035250082031928,-0.001437160113053)	(-0.001541277974426,0.00048052779294053)
6.9809531084896	(0.00099160916408169,0)	(7.6760354369109e-06,-0.00066524564328532)	(0.0015074257268151,0.0016084601087803)	(-4.636870808026e-05,0.00051738267153075)	(0,-0.0016907035321507)	(0.0027427097741783,-0.0025702121105556)	(-0.0011341481463921,-1.3065843820694e-05)	(0.00088221486094616,7.9058490793284e-05)	(-0.00076249463596994,-0.0005674328615717)	(1.6195218666491e-05,0.00016639826692417)	(0.00052964688003478,1.6399858838373e-05)	(-0.00056210388045392,0.00029570388334121)	(0.0023147903020603,-0.0031113436614479)	(-6.6599666544795e-05,0.0021610768325868)	(-0.00067904293919791,6.6254658898774e-05)	(-0.0012062702109677,-0.0022928913462222)
6.9809545867535	(-0.0011025995498994,0)	(-0.00031870820277993,0.0018653269112985)	(0.00081198508739862,0.00082344272954138)	(-0.0004667186299953,-0.00045150084987261)	(0,0.0018797652893988)	(0.0014039724259019,-0.0013842934132578)	(0.0031805874334942,0.00054357056826728)	(-0.00076982392741617,0.00079574314643269)	(0.00037000359680712,-0.00017701359283115)	(0.00016379294491622,-0.00022838880459539)	(-0.00054531725627429,0.00016379977730063)	(-0.00040097207473288,0.00093969436780643)	(0.00072258463605835,0.0015089712982595)	(-0.00066835874697089,-0.0022253670824316)	(0.00093217876934868,0.00066835634078987)	(-0.0038341734691118,-0.0016358516168077)
6.9809557671547	(-0.0010813706873204,0)	(0.00077128216165989,-0.000318227078277)	(0.00013826789538753,0.00052043960571534)	(0.0020897499766447,-0.00018152229883111)	(0,0.0018437904191181)	(0.00088741455989003,-0.0002355973605966)	(-0.00054259307533434,-0.0013148776209359)	(-0.00030944220405863,-0.0035631965786903)	(-0.00016014256577229,-0.00045328220904162)	(-0.00073356198668638,-0.0003159027425669)	(-0.00044323710875938,-0.00073363541351514)	(8.7851407444877e-05,-6.3297313070085e-05)	(0.0018497223707664,-0.000653588179015)	(0.0029929752667739,-0.0018085536399079)	(0.0012887923728827,-0.0029928757645957)	(0.0002579513444651,0.00035891446082861)
7.1630493359415	(0.00050376580750566,0)	(-0.00035699913101015,-7.7310678505531e-05)	(0.00093265624481783,0.0009394212003081)	(0.00047788265185802,0.00063927334273751)	(0,0.0011163852942455)	(-0.0020816240420315,0.0020668965511638)	(0.00017131156020998,-0.00079106429393502)	(-0.0014166183924683,0.0010591406025553)	(-0.00036272947555148,-0.00020911130332209)	(-0.00017162178901327,-4.8640180215707e-05)	(0.00041047317790931,-0.00017168659741989)	(-0.00046550521363822,0.00030721472322303)	(-0.00015968118094046,0.00027686981194724)	(-0.0001310262497055,-0.00031334784206035)	(-3.7168734772353e-05,0.00013098615882009)	(0.00023444803230605,0.00035535864100914)
7.1630500193772	(-0.00063785239645439,0)	(-0.00024343163861944,-0.0012111443287447)	(0.00011866356126643,-0.00054632092511558)	(0.00019938624712683,0.00070090283773474)	(0,-0.0014135005894331)	(0.0012107398793532,0.00026290307372967)	(0.0026839364256457,-0.00053945644370095)	(-0.0015532199422365,0.00044189716410435)	(-0.00047752372394663,0.00028365780964708)	(-7.1625017197501e-05,-0.00048078212123976)	(2.2668356236975e-05,-7.1629116360799e-05)	(0.00010877453698711,-0.00039235311998592)	(0.00021646647082483,0.00036452896275605)	(-5.468151192032e-05,-1.7250165281517e-05)	(-0.00036696483341615,5.4650937903003e-05)	(-0.00029949067534674,-8.3060380701146e-05)
7.1630501889766	(-0.0013991420294132,0)	(-0.00021034420300412,0.00064889987934454)	(0.00034963439730249,0.00041707061100954)	(-0.00021655171036262,0.00010247872519219)	(0,-0.0031005907169018)	(-0.00092428428248163,0.00077486882485738)	(-0.0014380164621386,-0.00046613501207315)	(-0.00022710749328469,-0.00047989282795322)	(0.00010745793440022,-7.4253001583829e-05)	(7.7752420514854e-05,-0.00053928074087041)	(-0.00046565201766759,7.7776049364168e-05)	(-0.00022531842575194,0.00035861707699811)	(-5.6681259766244e-05,-8.2028223168212e-05)	(5.9350085305025e-05,0.00035546862375803)	(-0.00041159458943899,-5.9384041253957e-05)	(0.00027373723929368,0.00017201111744169)
7.1630506895707	(-0.00039785325194724,0)	(0.00067794626427887,-0.00043821428225335)	(-0.00023893087702234,0.00059863111680443)	(0.001046872820018,-0.00067460022273234)	(0,-0.00088171907211848)	(-0.0013266771546428,-0.00052947630472733)	(0.00097118828012911,0.0015024465219437)	(0.0014950162815084,0.0023199455259999)	(-7.1620778208138e-05,-0.00045848710219342)	(-0.0003759581998314,9.9392301997953e-05)	(-0.00038518761266182,-0.00037594524126913)	(2.8483655776032e-05,-0.00024320876604911)	(-0.00034997387077192,5.4600371448708e-05)	(-0.0002869711976923,0.00029398519437988)	(7.5855727243824e-05,0.00028704018533483)	(-0.00018562581288395,-2.1753568347546e-05)
7.29236714414	(-0.00030647943504645,0)	(-0.00010081056320762,-0.00025126681005542)	(-0.00018589357021125,0.00023941859978112)	(0.00067583593085971,-1.4100425272584e-05)	(0,-0.0004160328426882)	(-0.00032499340350359,-0.00025236632697858)	(0.00034110485130672,-0.00013688182524715)	(1.9144343712328e-05,0.0009174543994381)	(0.00020265240374415,0.00042973626437821)	(0.0020955321807652,0.00090654856772981)	(0.00099396777438319,0.0020954537622759)	(0.0010549241904672,0.0013554879708586)	(0.00013873094526966,-6.5413173540015e-05)	(0.00067643526303688,-0.00032087337862212)	(0.00029267310515915,-0.00067647163856787)	(0.00043759352228503,-0.00034054394246624)
7.2923678899521	(-0.00026479689827884,0)	(8.5523700014958e-05,0.00068624792512531)	(0.00028896112850135,8.2238094374023e-05)	(0.00020216839096568,0.00019133936884329)	(0,-0.00035942785528302)	(-0.00011160492171467,0.00039222872857444)	(-0.00093152741750327,0.00011605950123156)	(-0.0002597385286313,0.00027442130769825)	(-0.0012317990579797,0.00052005930883777)	(0.00062679597519891,0.0014142725787007)	(0.00022773521160673,0.00062682066622912)	(-1.0135293924541e-05,-0.0030236636344675)	(0.00016785683435137,0.00039766425348938)	(0.00020235375052103,-7.3518506697422e-05)	(0.00045654626827785,-0.00020234118464113)	(-0.00097608063891112,3.2559488852189e-06)
7.2923684079682	(-0.00041922626588714,0)	(0.00031465172798517,-2.0821767637261e-05)	(-0.00024589565079918,0.00047448055979911)	(-0.00038807409210205,-6.8598436242391e-05)	(0,-0.00056904902257198)	(-0.00064411164895159,-0.0003338106183317)	(2.8276518997541e-05,0.00042711433186715)	(9.3082014106267e-05,-0.00052676587328095)	(-0.00069787045072855,0.002446769657764)	(-0.0012032323228733,0.0010871192751466)	(0.0015125059528485,-0.0012032217540011)	(0.00049554996999439,0.00082699885400096)	(0.00078985224759653,0.00022529245880157)	(-0.00038840491169571,-0.00048825311231779)	(0.00035092001967901,0.00038844890949959)	(0.00026694980399314,-0.00015997955874205)
7.292369498197	(0.00061345770375398,0)	(0.00020157977239013,0.00015642833386997)	(-0.00013621009688366,0.00047940013675029)	(0.00015972930304104,2.8688360756056e-05)	(0,0.00083267241417754)	(-0.00065071632610445,-0.0001848624822256)	(-0.00021235643567453,0.00027363072754899)	(-3.8914953685958e-05,0.00021681162254548)	(-0.00090736559422328,0.002111341385108)	(0.00049523371660487,-0.0018130658355749)	(-0.0019909573649972,0.00049526907344992)	(0.00086131211834083,-6.2743646678646e-05)	(0.00068152237234295,0.00029293340426576)	(0.00015986430026595,0.0006427173961716)	(-0.00058526108486247,-0.00015990886979168)	(-2.0245740059765e-05,-0.00027803801676482)
7.7390186356497	(-0.0017252514950022,0)	(-0.00086877399140857,-0.0014691472368843)	(0.00081978313422339,0.00042099084593077)	(-0.0018070087892964,0.000385846528914)	(0,-0.0018545475781936)	(-0.00045250033955959,0.00088109559773279)	(0.0015789948344693,-0.00093341294348491)	(-0.00041450687786637,-0.0019421779145192)	(0.0023898442418517,-0.00046747822189816)	(-0.0018867177022779,0.0022042137003284)	(0.0013985312434251,-0.0018866576715355)	(0.001346583017144,0.00067798388807937)	(0.00042123209572974,0.0021543869714515)	(0.0017006679072835,0.0012609796151546)	(-0.001987072202054,-0.0017009700206125)	(-0.00061116325972258,0.0012137524555929)
7.7390192296692	(-0.0020366361217233,0)	(0.00026005683598094,-0.00032198554656005)	(-0.00096783808375308,0.00085692564412522)	(0.0019619796539223,0.00056139073967449)	(0,-0.0021888143094342)	(-0.00092074979193221,-0.0010401211527887)	(0.00034595434088489,0.00027926804242379)	(-0.00060337016110231,0.0021081730627624)	(-0.00067432089494318,0.0011661424736605)	(0.0020483863578832,0.0027125512393926)	(0.0015402649444134,0.0020484024042935)	(0.00062318507192235,0.0013466580699193)	(-0.0010510006261375,-0.00060789716182295)	(-0.0018463188803404,0.0013884495018168)	(-0.0024452305846949,0.0018462820849356)	(-0.0012138730474727,0.00056176988262468)
7.7390196958086	(-0.0012412077192395,0)	(0.00099087391249992,0.0024552377056334)	(0.00076446823854884,0.00054351170030175)	(-0.00084106186353917,-0.00012665760464299)	(0,-0.0013339798777796)	(-0.00058414950151619,0.00082136178363568)	(-0.0026388145863304,0.0010647982785831)	(0.00013618005318526,-0.00090372599249209)	(-0.0017653603752201,0.001602014254964)	(-0.00087811827703483,0.0011636781386756)	(0.0014281759820123,-0.00087808540539674)	(-0.00046706787672305,-0.0033616045801175)	(-0.0014440750736388,-0.0015915534212905)	(0.00079138712951693,0.001287463301962)	(-0.0010489746967784,-0.00079154842639823)	(0.0030302460985885,-0.00042095171755836)
7.7390212032468	(-0.0012198780199483,0)	(-0.00021357825679365,0.00011726175498458)	(-0.00032152149665599,-0.0025787591621293)	(0.00013638506068275,-0.0013541215524103)	(0,-0.0013111108796666)	(0.0027717312927099,-0.00034513653015718)	(-0.00012597981017623,-0.00022940342389316)	(0.0014553568659872,0.00014665610460624)	(-0.00045805531621051,-0.0029154424657625)	(0.00014237070617698,-0.00014015009338643)	(0.002687477663889,0.00014244467667945)	(-0.0024695185867513,0.00021320681504745)	(0.0026281861867984,-0.00041267880648651)	(-0.00012853872978592,0.0024226959022434)	(0.00012632102239203,0.00012827204802513)	(-0.00019201775672078,-0.002226338035795)
7.7791678255257	(0.0016273333734793,0)	(-0.00019200202851801,0.0028207721808058)	(0.00084893822603068,-0.0011322158409932)	(-0.00027856351516892,-0.001976101428237)	(0,-0.0019395854246718)	(-0.0013494059782421,-0.0010118495038953)	(0.0033619396405488,0.00022902075227876)	(-0.0023551095402917,0.00033209923817972)	(-0.0012668805415381,-0.00085076740449993)	(-0.00017897892484691,-0.0023151668508466)	(0.00022411212166353,-0.00017892998655311)	(-0.00060410775958689,-0.0023577213506885)	(-0.00075784659728742,0.0011282930667767)	(-0.00015957936849969,-0.00019946157708325)	(-0.0020619285311979,0.00015934656691732)	(-0.0020999240018273,0.00053786964521021)
7.7791685532164	(0.00092916889657802,0)	(-3.0825175358691e-05,-0.00030902721845441)	(0.0030728858512094,0.00053269248340809)	(-0.0018375878442213,0.0016012132782994)	(0,-0.0011074767084412)	(0.0006350471793178,-0.0036623352021094)	(-0.0003681658093578,3.6606122645171e-05)	(0.0019083486854851,0.0021903657086091)	(0.0021728634569375,0.00032238032720021)	(-0.0011805845490817,0.00043179537054103)	(-0.0016257408024453,-0.0011805573219557)	(0.00036203835501136,-0.0017757333258702)	(0.00028737046053528,-0.0019350493307809)	(-0.0010517166758961,0.0014479353004412)	(0.00038449347024274,0.0010516393342351)	(-0.0015815738013709,-0.00032248215292886)
7.7791704516351	(0.0013251667508499,0)	(0.0025171151874558,-0.00043759706345969)	(0.0010272503712579,0.0010412674305067)	(0.0024747790967696,-0.00028239241446735)	(0,-0.0015792122167501)	(0.001241194874703,-0.0012240855292452)	(-0.00052148567960715,-0.002999944055435)	(-0.00033642934687238,-0.0029496820536855)	(0.00094119326330756,0.0022861803636649)	(0.0015899622470525,-0.0010328853782162)	(-0.00066996969740493,0.0015900097531762)	(-0.00094825557583077,-0.0003788722069346)	(0.0020362459577386,-0.00083802644191158)	(0.0014160853248899,0.00059667466510375)	(-0.00091966248293095,-0.0014163059806282)	(-0.00033728726634651,0.0008443502384054)
7.7791712734841	(0.0033704665805226,0)	(-0.00088841642778196,-0.0011046538818438)	(-0.0016609410079558,-9.4800102284058e-06)	(-0.00033172271657565,0.00062369525635959)	(0,-0.0040168702454911)	(-1.1497694356624e-05,0.0019794999910644)	(-0.0013167496404422,0.0010588687646325)	(0.00074339020281988,0.00039553731794072)	(-0.00035744792308906,-0.00057685164025847)	(-0.00021310573481087,-0.0017647907687259)	(-0.0025662173310062,-0.00021308472596594)	(0.00056473570891607,0.0017768393077863)	(-0.0005139355664349,0.0003181572680944)	(-0.00018998195336097,0.0022854234109515)	(-0.0015715889030916,0.00018989048389081)	(0.0015825862107913,-0.00050282786043868)
8.1772236658082	(-0.00017046502139187,0)	(-1.9355987288525e-05,-1.6388474732391e-05)	(2.8837182210518e-05,-0.00013091839835259)	(-4.2041119108135e-05,-4.6513488621867e-05)	(0,-0.0017272421086414)	(0.0013263328418417,0.00029223150214317)	(0.00016608952226083,-0.00019597889111498)	(0.00047133413698295,-0.00042615173510047)	(-9.6260839998074e-05,0.00031987147914113)	(8.9546998943418e-05,-0.00026389216786898)	(-0.00046192989072747,8.9539325401083e-05)	(0.0002374932419827,2.6463613508971e-05)	(-0.00056564099228829,-0.00017027388596436)	(-0.00015829317191916,-0.00081688992858861)	(0.00046664910857189,0.00015837802365786)	(-4.6862423124021e-05,0.00042000333383325)
8.1772247544479	(-0.00012427077645515,0)	(1.8571158198613e-05,0.00010101654484231)	(1.5675489848553e-05,0.00014122513392508)	(-4.0818214460489e-05,6.1264605770309e-05)	(0,-0.0012590884771232)	(-0.0014309060994097,0.00015879025962371)	(-0.0010236528069626,0.00018798181077029)	(-0.00062085381443366,-0.00041351436110833)	(0.00018167844864904,-0.00034015940080389)	(8.6898178766291e-05,-0.00039499103631236)	(-0.0001340687001883,8.6850179154957e-05)	(-0.00026115241921823,0.00024845083364752)	(0.00060152664067285,0.00032133393509533)	(-0.00015359173752081,-0.00023713905969852)	(0.00069851198122905,0.00015369481980716)	(-0.00043935369618282,-0.00046181563643192)
8.1772252049416	(1.390756182871e-05,0)	(-0.00010619153591729,0.00014263038290399)	(2.52369862441e-05,-6.7390902174613e-05)	(0.00011093147226762,4.80070361668e-05)	(0,0.00014083917161219)	(0.00068305875394542,0.00025555524734387)	(-0.0014450462337517,-0.0010760059767835)	(-0.0004864136510141,0.0011240122609974)	(0.00024994110668911,0.00036959790956287)	(-0.00023615096771311,-7.2580007260274e-05)	(0.00013176036840879,-0.00023619336696788)	(-8.2537306209618e-05,0.00035731445471374)	(-0.00065357643864589,0.00044197737040597)	(0.00041765759574775,0.00023305128355309)	(0.00012838581187023,-0.0004176380946138)	(-0.00063188845836338,-0.0001459948848092)
8.1772262810048	(8.3106901495026e-05,0)	(5.8380540921609e-06,9.3570427457568e-05)	(7.8375043847981e-05,-4.6066447201447e-05)	(-0.0001658362228829,-1.1827000912933e-05)	(0,0.00084213415911404)	(0.00046674190826552,0.0007941320774136)	(-0.00094816933047681,5.9144209064712e-05)	(0.00011986561802407,-0.0016801993226105)	(3.2367748373442e-05,8.5639534561452e-05)	(0.00035301939313417,0.00020211195723945)	(0.00015176052306614,0.00035304674935885)	(0.0001105091254446,0.00036608369422945)	(-0.00015144808289878,5.7242231328253e-05)	(-0.0006243356517988,0.00026836507663057)	(-0.00035743806447526,0.00062426138560165)	(-0.00064736878600327,0.00019540538559045)
8.2482169776265	(-0.00035852790937134,0)	(0.00029560898387503,-0.00020182055218651)	(1.3946674808307e-05,0.00017284767833172)	(0.00078535657605724,-6.3755369769178e-05)	(0,0.00036312227674399)	(0.00017507056386192,-1.4126988179659e-05)	(-0.0002044180423772,-0.00029939202580419)	(-6.4561928448025e-05,-0.00079542428486619)	(-0.00042309120712548,-0.00091852423129299)	(-0.0015398181492827,-0.00057793676379415)	(-0.00082798572197383,-0.0015398462048676)	(0.00024071220549585,-0.00036837687243351)	(8.2652082510569e-05,-3.8083008957081e-05)	(0.000138580732505,-7.451370147079e-05)	(5.200224928638e-05,-0.00013857338224954)	(3.3146224109714e-05,2.1659116704326e-05)
8.2482176694647	(0.00043713187970127,0)	(7.7485041185089e-05,-0.00068173328098287)	(-0.0002871319064122,-0.00035372031947398)	(9.2134461544482e-05,0.00017230326441882)	(0,-0.00044271762263919)	(-0.00035824693657354,0.00029078380072077)	(-0.00069047803258135,-7.8483159504175e-05)	(0.00017451045525417,-9.3310899847847e-05)	(-0.00077368113441146,0.0005416305452697)	(-0.00018063724390145,0.00051925124802082)	(0.0011949170932446,-0.00018065961129)	(0.00084542442881646,-0.0018996451122445)	(-4.8746643132818e-05,-6.9625416439908e-05)	(1.6260360790475e-05,0.00010753689362023)	(-4.6743229858188e-05,-1.6255377797274e-05)	(0.00017095224123376,7.6070256478039e-05)
8.2482182412552	(0.00038388677534388,0)	(5.650475944932e-05,-0.00025231535709594)	(0.00043376124213475,0.00068826293225256)	(-5.6381282972691e-05,0.00016827408645175)	(0,-0.00038880340608474)	(0.00069711935581803,-0.00043930918179662)	(-0.00025553752236345,-5.7219703688752e-05)	(0.00017042989697176,5.711826991042e-05)	(-0.0013452154799332,-0.0014602371458785)	(0.00011055298215349,0.00042276082056224)	(0.0010826181087557,0.00011054772519184)	(-0.0012386823720451,0.00035577874018238)	(0.00013140029799571,-0.00012106195486921)	(-9.9473131399035e-06,9.7409660581745e-05)	(-3.8050800365839e-05,9.9560947511781e-06)	(-3.2018258321748e-05,-0.00011146873927841)
8.248219346744	(0.00066376484421216,0)	(7.5960706570185e-05,0.00048587757666799)	(-5.4233204485504e-05,-7.1756147446783e-05)	(0.00039613627566035,-0.00024523430805838)	(0,-0.00067226492375537)	(-7.2666904443368e-05,5.4940773812908e-05)	(0.00049208916901028,-7.6919349288638e-05)	(-0.0002483698820552,-0.00040120984091995)	(0.001058993149661,-8.2914849357447e-06)	(-0.00077669736697237,0.0017822856936978)	(0.00082059578437833,-0.00077669656714975)	(0.00028962180696526,0.00084628109913979)	(0,9.5293417422216e-05)	(6.9906993356824e-05,7.3837209592277e-05)	(-0.00016039474133296,-6.9867134557498e-05)	(-7.6162616170255e-05,2.6071763798735e-05)
8.6344218852423	(0.0010210599627379,0)	(0.0002359085442992,0.00070723135915288)	(-7.0731194615396e-05,-0.00023463199985857)	(0.00065711712487709,-0.00043696229175001)	(0,0.001339283019089)	(0.00030771841542974,-9.2740944698789e-05)	(-0.00092759696163257,0.00030934308243482)	(0.0005730173969414,0.00086190809578918)	(-0.00055453883733928,0)	(0.00046839997284341,-0.0010393023037927)	(-0.00041635397349913,0.00046840328107128)	(-0.00033540510162362,-0.00045370373380092)	(-1.3526519791052e-06,-0.00084508417476898)	(-0.00071381805561476,-0.0006346260417696)	(0.0015838370025215,0.00071389744213269)	(0.00069144687217512,-0.00051108074124267)
8.6344225983538	(0.00084073181279717,0)	(-0.00014172316740801,-0.0010853978687779)	(-0.00034316366103757,-0.00037624513350976)	(-3.2163635448435e-05,0.00034052556364119)	(0,0.0011026278708339)	(0.00049343194864991,-0.00045004823976058)	(0.0014235891520041,-0.00018584943297906)	(-0.00044660933857095,-4.2209263519785e-05)	(0.00052907736562149,-0.00036921151755246)	(-2.2928190368035e-05,-0.00035655427466766)	(-0.00084200909596907,-2.2929685980171e-05)	(-0.00016716365774229,0.0010182901203986)	(0.00056261207698495,0.00080631682248305)	(3.4976489744872e-05,-0.0012831380596398)	(0.00054334091141139,-3.4936423750295e-05)	(-0.0015518105217987,-0.00025475086567831)
8.6344228549375	(0.000539694908307,0)	(-0.00047231705019825,-7.7820573250882e-05)	(0.001047042299875,0.00033988528776293)	(-0.00062058583842178,-0.00040500905175985)	(0,0.00070783776378652)	(-0.00044589483963426,0.001373208554052)	(0.00010205652848446,-0.00061940859531234)	(0.00053113554783609,-0.00081386072801151)	(0.00080180282475751,-9.439548510076e-05)	(-0.00044235568082377,-0.00067338728702968)	(-9.6003377505568e-05,-0.00044236297457735)	(0.00057894717896689,-0.00069087325225914)	(0.00014373284043889,0.0012218727348103)	(0.00067406922832709,-0.00014634636408356)	(0.0010261671556969,-0.00067407992103275)	(0.0010528205464222,0.00088231604002569)
8.6344231167194	(-0.00049048296779375,0)	(-0.00027149634033694,-0.00047377752737318)	(0.00041663713580504,-0.0007592495499985)	(0.00063016243079273,-0.00077161489221328)	(0,-0.00064325234470542)	(0.00099582514887515,0.00054659008318461)	(0.00062133690327042,-0.00035605608235752)	(0.0010119434807108,0.00082652562211371)	(0.00063469755731844,-0.00073472687139084)	(0.0004491793471136,-0.00020038957613526)	(0.00089962626025077,0.00044918862771361)	(-0.00034767887391452,4.0718257738654e-05)	(0.001119675655174,0.00096730796216765)	(-0.00068459754056572,0.0013709067655046)	(0.00030536368454678,0.00068450528006684)	(-6.1931459851538e-05,-0.00052987546330083)
8.6747333383745	(0.00089373879630935,0)	(9.9388931272861e-05,0.001404298679692)	(0.00071982079644732,-0.00041848732569142)	(-0.0010085856918632,-0.00089582053972178)	(0,-0.00065908925820914)	(-0.00030858723770859,-0.00053082361643621)	(0.0010355657594278,-7.325835888539e-05)	(-0.00066058095212139,0.00074377910723715)	(-0.00043558527552144,-0.0002030693931017)	(-0.00064183542512753,-0.0011388340074753)	(1.3265894083843e-06,-0.0006418390661002)	(-0.00032956501090634,-0.0013517366874287)	(-0.00014627932011299,0.00031373573300243)	(-0.00046234978581437,0)	(-0.00082029309522402,0.00046230849617886)	(-0.00097365094627186,0.00023734427089893)
8.6747339467662	(0.00037365345036896,0)	(-0.00073129345396766,-0.0001222665212955)	(0.0015051174235767,-0.00065784580725562)	(0.000226231747623,0.0013620306065795)	(0,-0.00027553451626929)	(-0.00048505519235149,-0.0011098943054699)	(-9.0177842423017e-05,0.00053924095603334)	(0.0010044207540109,-0.00016675141721051)	(0.0010356204814159,-0.00088401938960384)	(0.00014397330476732,0.00062897734023326)	(-0.0011045439012756,0.0001439808403261)	(4.6732657379578e-05,-0.0008800132992074)	(-0.00063667858114335,-0.00074594637722824)	(0.00010362025215046,0.00079561433432105)	(0.00045307570040147,-0.00010365377163314)	(-0.00063383747475208,-3.3693884522836e-05)
8.6747351918609	(0.00051699389626615,0)	(0.00097642637635141,-0.0013092786030783)	(0.00088677170089713,-0.00049989545469447)	(0.00049403720270885,-0.0010385070117486)	(0,-0.00038125631966879)	(-0.00036856345998548,-0.00065393749680684)	(-0.00096548029301266,-0.00072005027120751)	(-0.00076581756543857,-0.00036434916919279)	(0.0013975087238068,0.00030324490168309)	(0.00031439053569289,-0.00098988246334885)	(0.0003318779835069,0.00031438920283504)	(-0.00093949725792684,0.0002688769635451)	(0.0002184825448455,-0.0010066196240771)	(0.00022645589310834,-0.00023902905860445)	(-0.00071300835983435,-0.00022650226258644)	(0.00019365230273459,0.00067665961671513)
8.6747358665681	(0.0020219146846036,0)	(-0.00015844738812193,-0.00026335015862018)	(-0.00082306748829012,0.00043440023708548)	(0.00027773042001258,0.00040980550230481)	(0,-0.0014909498874296)	(0.00032029400398657,0.00060697149047202)	(-0.00019423009061157,0.0001168606728126)	(0.00030222673046853,-0.00020476808045859)	(-0.00035618759142441,0.00017560794985304)	(0.00017674326287084,-0.0010259023876626)	(-0.0015474853949072,0.00017674145024621)	(0.00037727521426068,0.00069136864677469)	(0.00012644829081809,0.00025655965595946)	(0.00012726085352723,0.0011146136759075)	(-0.00073888664173494,-0.00012728854450234)	(0.00049802615859005,-0.00027173129914182)
9.0693330822639	(0.00028748139381864,0)	(2.6927592790709e-06,0)	(-8.3163047550014e-05,0.00014300510516888)	(7.0305010561138e-05,7.0179752270329e-05)	(0,-0.00053001163087134)	(0.00026365994427093,0.00015331950094191)	(1.5668896947094e-06,-4.9726857616043e-06)	(0.00012938227561877,-0.00012961077216291)	(-2.8630619718806e-05,4.9688011344313e-05)	(2.3955112211808e-05,-7.4092169975663e-05)	(-0.00012192617215772,2.3984403032486e-05)	(4.7833755416293e-05,2.8039064383205e-05)	(-0.00023723250878367,-0.00013676193025554)	(-0.00011447272656078,-0.00058226837050984)	(0.00035378274732967,0.0001144322120511)	(-0.00013398673662351,0.00022843671036795)
9.0693342464185	(-0.00013156097423022,0)	(-4.482115086719e-05,0.00021599341734765)	(-3.2186345764227e-05,0.00018720063849191)	(-1.4362262939049e-05,0.00013279652963695)	(0,0.00024255059741209)	(0.00034513558624343,5.9336072923478e-05)	(0.00039820903427878,8.2620706574684e-05)	(0.00024482154299497,2.6481730985092e-05)	(-8.4582649916607e-05,4.8556610060149e-05)	(-4.8848616038458e-06,9.0109814283981e-05)	(0,-4.8995059296833e-06)	(7.9094731845624e-05,-6.2666049210309e-05)	(-0.00023183618878853,-0.00040401110844956)	(2.3397513590175e-05,-2.0044973026671e-06)	(-0.00043036012192517,-2.3364520477402e-05)	(0.00029924778850299,0.00037772334969313)
9.0693352991307	(5.0854364101809e-05,0)	(-0.00015900392679888,0.00014421301409684)	(5.0381009594491e-05,-0.00018474489855715)	(0.00017785394861282,5.4043613875723e-05)	(0,-9.3762068492026e-05)	(-0.00034059439235616,-9.2887328735991e-05)	(0.00026588407568166,0.00029314863164259)	(9.9638603042746e-05,-0.00032789692640731)	(-3.2003105615402e-05,-0.00011718581139939)	(6.0626349083148e-05,1.0717221969549e-06)	(-3.5743704960208e-05,6.0638812535657e-05)	(-8.7797011318248e-06,-6.6338547076902e-05)	(0.0005596165941014,-0.00015278098334169)	(-0.00028955845834965,-0.00017076689589816)	(-5.1735739518082e-06,0.00028954934361538)	(0.00031681622826683,-4.1899185058676e-05)
9.0693366597633	(-0.0001317184876838,0)	(-1.074045195109e-05,-0.00015819469407082)	(-0.00012990012912262,5.3827230279209e-05)	(0.00023646471265637,4.1396692577255e-05)	(0,0.0002428360509618)	(9.923826208021e-05,0.00023948869326787)	(-0.00029164631615548,1.9804083808559e-05)	(7.6315593334577e-05,-0.00043595771676497)	(9.6402741664963e-06,1.4684719463662e-05)	(8.0613114715846e-05,5.9000161221298e-05)	(3.078839565497e-05,8.059443485643e-05)	(2.2019781750823e-05,9.8203533315569e-05)	(-7.0143524932167e-05,4.6054012512331e-05)	(-0.00038494974607534,0.00014704181862336)	(-0.00028181472002998,0.00038497618498357)	(-0.00046900794877999,0.00010512698601905)
9.1386830292838	(0.00013785000648943,0)	(-5.9961133273942e-05,0.00014779807512075)	(-4.9789485489496e-05,-2.1144711642613e-05)	(-0.00033968788188815,8.4103957193462e-05)	(0,-9.3297359610123e-05)	(-1.4310688002215e-05,3.3703714700703e-05)	(0.00010003085576809,4.0580481188934e-05)	(5.6918134130201e-05,0.00022990098986718)	(0.0002836501555697,0.00011643113830213)	(0.00048763418722375,7.7144931232715e-05)	(0.0003186408766891,0.00048763592734599)	(-5.5726454111636e-05,0.0001407073679039)	(-5.5386117156119e-05,0.00013494099773625)	(-0.00023198466103936,0.00015159279633265)	(-3.6694279237259e-05,0.00023199031397226)	(-6.6942449326941e-05,-2.6509506928158e-05)
9.1386839805265	(3.8558470461335e-05,0)	(7.5368855670508e-06,6.497440244737e-05)	(0.00034688927780438,0.00020687186868136)	(-2.5388571792286e-05,-1.718674577054e-05)	(0,-2.6099059814496e-05)	(0.00014002173277217,-0.00023477458825307)	(4.3980636899669e-05,-5.0999190611283e-06)	(-1.1630204426289e-05,1.7182392002946e-05)	(-0.00040471369546508,-0.00030777211557999)	(3.6449431283791e-05,8.0025385716956e-05)	(3.0672491245851e-05,3.6444757602815e-05)	(-0.0002861330822808,0.00059125333321272)	(0.00014640518339737,-0.00019253992810927)	(-1.7343965942579e-05,1.4580811148164e-05)	(-3.806798374289e-05,1.7344163902855e-05)	(-0.00028127555063316,-0.0001361106310191)
9.1386842760216	(0.00025303678410835,0)	(-2.7675091679087e-05,-0.00031462648070808)	(2.1501312739289e-05,2.0413573342985e-05)	(-1.6415159346634e-05,6.9993637071523e-05)	(0,-0.0001712550023208)	(1.3822718543654e-05,-1.4558298217424e-05)	(-0.00021294048470495,1.8730281420054e-05)	(4.7371345889446e-05,1.1112070965733e-05)	(-0.00048252609615791,1.0444179938309e-05)	(2.3569278731108e-05,0.00026277215664742)	(0.00046372580294762,2.3555970702967e-05)	(-6.9036491375173e-05,-0.00042079027310966)	(-4.9805264326942e-06,-0.00022954783364628)	(-1.1202252054798e-05,0.00022060662859099)	(-0.00012501430510369,1.1217683580987e-05)	(0.00020018643146385,-3.2843787315463e-05)
9.1386864923356	(-0.00029208592167509,0)	(-5.1279106568078e-05,-0.00019423503980911)	(4.0918685098878e-05,3.5011302585976e-05)	(-0.00017789052080229,9.8060451975574e-05)	(0,0.00019768658944262)	(2.3693354691356e-05,-2.7696985251165e-05)	(-0.00013145602819372,3.4702779333378e-05)	(6.6367467352573e-05,0.00012039832208517)	(-0.00033757377447018,2.3368686378802e-05)	(0.00025535538818649,-0.0005600782548432)	(-0.00027851590934994,0.00025537333299071)	(-0.00012387976989819,-0.00022008262603711)	(-1.1125099822633e-05,-0.00016058688208703)	(-0.00012149423070273,-0.0001324869053097)	(0.0002664448292483,0.00012145969179082)	(0.00010470454646269,-5.8940581496112e-05)
10.31901744025	(0.00010506800084582,0)	(0,0.0001329538375034)	(0.00010699663521376,-3.2411378089948e-05)	(-0.00017295576192205,-5.1814272005366e-05)	(0,-7.2617551904113e-05)	(-2.24053468265e-05,-7.3957277976934e-05)	(9.1891435480885e-05,0)	(-3.5815030317026e-05,0.00011953380404365)	(-1.3225892343359e-05,-1.657042881042e-05)	(-8.81154437745e-05,-7.9927969314008e-05)	(-2.713237692198e-05,-8.8118375499344e-05)	(-1.6455383531531e-05,-0.00012224882539601)	(-9.571003873059e-06,7.6335765749706e-06)	(-5.0887347144468e-05,1.5668558790819e-05)	(-4.616876805491e-05,5.0899761081225e-05)	(-7.0615310965533e-05,9.5099465237408e-06)
10.319020328211	(-3.0056302796034e-05,0)	(0.00013031363270322,-8.7144184526952e-05)	(-3.9267110462231e-05,0.00016873576349602)	(-0.00012876206607412,-4.1671527449848e-05)	(0,2.0772834665163e-05)	(0.00011663355800277,2.7133679236425e-05)	(-6.0246109044851e-05,-9.0076898985802e-05)	(-2.8788019138818e-05,8.9010111222014e-05)	(2.4390740168088e-05,0.00015235517329875)	(-6.5600205943438e-05,-5.9186030742641e-06)	(3.6543662105736e-05,-6.5599958508593e-05)	(1.9576167935314e-05,6.4401254977516e-05)	(8.8017023044448e-05,-1.4104392632945e-05)	(-3.7903946164104e-05,-2.110023589137e-05)	(-3.4097281267794e-06,3.7902054538541e-05)	(3.7208805475949e-05,-1.1305493519775e-05)
10.319024651404	(7.6192452773405e-05,0)	(0.00014540934775051,-8.8104390412819e-05)	(0.00012315938421592,-6.6222613715796e-05)	(9.7181852888395e-05,-0.00010050191424721)	(0,-5.2663721843566e-05)	(-4.5795026408279e-05,-8.5126810651156e-05)	(-6.0899730682486e-05,-0.00010050275034388)	(-6.9467034820109e-05,-6.7164335192583e-05)	(0.00010763131828499,4.0345546957098e-05)	(4.9513328139164e-05,-9.0021147393112e-05)	(1.2385631178284e-05,4.9509989663896e-05)	(-0.00010781831042627,-1.7859055525564e-05)	(2.3286297994671e-05,-6.2179756647919e-05)	(2.8604071556565e-05,-7.1520722476338e-06)	(-5.2001937148797e-05,-2.8587714215167e-05)	(-1.0314893286975e-05,6.2296514261306e-05)
10.319027512676	(-0.00023677219584555,0)	(3.0201985824509e-05,4.1711337258612e-05)	(9.2096870471383e-05,-5.7106899788491e-05)	(-2.9122736393316e-05,-5.0044761644317e-05)	(0,0.0001636667524251)	(-3.948344374751e-05,-6.3651976812947e-05)	(2.8819793026877e-05,-2.0869606852463e-05)	(-3.4586909042469e-05,2.0139156242009e-05)	(2.5668383583786e-05,-1.3704170996045e-05)	(-1.4837308304572e-05,9.5129157102802e-05)	(0.00014612322621579,-1.4835308649323e-05)	(-4.4480673475906e-05,-6.8173142488523e-05)	(-7.931377854322e-06,-1.4834324814063e-05)	(-8.5811214831686e-06,-8.4416429281943e-05)	(5.496497385528e-05,8.5729787851917e-06)	(-3.9370027763564e-05,2.5700446927396e-05)
10.380941375849	(-7.2922577451315e-05,0)	(-1.7328234416421e-05,-4.2877066219786e-05)	(1.5567569249002e-05,6.2672696945983e-06)	(-4.4706586878427e-05,2.1800870941453e-05)	(0,-0.00016444124707036)	(-1.413436917805e-05,3.5100656896771e-05)	(9.6699820925075e-05,-3.9111132361149e-05)	(-4.9185130362827e-05,-0.00010081547745187)	(5.0639552316851e-05,-9.5897049883236e-06)	(-3.8731324723639e-05,8.2077974339928e-05)	(4.4289794423069e-05,-3.8740124820089e-05)	(2.044929395448e-05,2.3663887677305e-05)	(1.9569509616169e-05,0.00010327379736371)	(7.9011936352306e-05,9.0311110058572e-05)	(-0.00016738895248491,-7.8978536812506e-05)	(-4.82638253406e-05,4.1718265207862e-05)
10.380945548332	(-5.9236120529874e-05,0)	(1.7765802840993e-05,7.494226210704e-05)	(-5.7940912224958e-06,2.091541388586e-05)	(1.3623460130517e-05,-1.0561269576486e-05)	(0,-0.00013362028792821)	(-4.7200512005164e-05,-1.3037534152947e-05)	(-0.00016902287271566,4.0098942127853e-05)	(2.3823345787578e-05,3.0727716351118e-05)	(-6.9953052787507e-05,3.3525072213919e-05)	(1.1806495028572e-05,4.2178699785981e-05)	(6.0481331457742e-05,1.1803837066007e-05)	(2.7274682285983e-06,-5.9918819279446e-05)	(-6.839984147586e-05,-0.00014265563727232)	(-2.4068772704667e-05,0.00012336296748429)	(-8.603024449661e-05,2.4084062321049e-05)	(0.0001222187176477,5.5642765962763e-06)
10.38094657981	(-2.1126465143584e-05,0)	(2.7349643752742e-05,-2.1023969031781e-05)	(-8.0207849814463e-05,-3.3087040423808e-05)	(2.2673722656359e-05,2.3046094035075e-05)	(0,-4.7639835577846e-05)	(7.4590232873567e-05,-0.00018091739638019)	(4.7396217052054e-05,6.1696328527199e-05)	(-5.2003930809031e-05,5.1168705045395e-05)	(-5.1285635521454e-05,-4.9647476229824e-06)	(1.9650501004558e-05,3.827638501075e-05)	(-1.6685167457201e-06,1.9651265489624e-05)	(-5.236411789233e-05,8.7716724293898e-05)	(1.0105146237103e-05,-0.00010461710399119)	(-4.0089759204163e-05,-3.4169948157975e-06)	(-7.8074043527479e-05,4.0090841463197e-05)	(-0.00017889540498767,-0.00010678767703973)
10.380947840166	(-3.0625169207449e-05,0)	(-1.1981126097051e-05,-2.8378565461644e-05)	(2.9463872787814e-05,-3.2591513512255e-05)	(6.4403531642012e-05,-4.7372994929492e-05)	(0,-6.9086781879307e-05)	(7.3498534781232e-05,6.6415491436905e-05)	(6.4028287281556e-05,-2.7023538910494e-05)	(0.00010687278941844,0.00014526772167768)	(5.0117704290256e-05,-3.8622097228997e-05)	(5.5807359940421e-05,-1.451325197339e-05)	(6.7589505264887e-05,5.5803792215246e-05)	(-1.7857914473173e-05,0)	(7.8764482044054e-05,0.0001022098701448)	(-0.00011380824536235,0.00013787070032526)	(2.9605636871581e-05,0.00011383583389679)	(1.8740434200238e-06,-3.6417112747215e-05)
10.818479803762	(4.9473053821687e-06,0)	(0,0)	(-1.0822416961809e-06,3.1503352825673e-06)	(1.2780079266081e-06,1.2807416736334e-06)	(0,-0.00012927211193505)	(8.235838606512e-05,2.8302789396806e-05)	(7.9512606870516e-06,-7.49414429268e-06)	(3.3468877207953e-05,-3.3355491431368e-05)	(-2.6056987547336e-06,6.4714275730916e-06)	(2.3959310178836e-06,-6.8971974297538e-06)	(-1.1711212167049e-05,2.4047293738554e-06)	(5.3877485336771e-06,1.4596439996516e-06)	(-3.2564731455066e-05,-1.3137393512209e-05)	(-1.2092323478794e-05,-5.8978526566196e-05)	(3.4720804376899e-05,1.2084131560119e-05)	(-7.3750556310873e-06,2.7132807945298e-05)
10.818484200871	(0,0)	(-3.0228540000553e-06,3.288123148983e-06)	(0,-2.6619707646859e-06)	(3.1600351305023e-06,1.033641046482e-06)	(0,-1.8934552685085e-05)	(-6.9503151857625e-05,-1.6755419653096e-05)	(8.5947129972753e-05,7.8998343371758e-05)	(2.7043792381894e-05,-8.2572108459007e-05)	(-4.9823379452453e-06,-1.0686335410207e-05)	(5.9424375419366e-06,0)	(-3.305645170882e-06,5.9434799719023e-06)	(0,-7.3927127963266e-06)	(5.3817277900063e-05,-2.5077496540064e-05)	(-2.9921067747645e-05,-1.6661991788078e-05)	(-2.9373622851828e-06,2.9932186519704e-05)	(3.7222015805495e-05,3.44054660592e-06)
10.818487318222	(-2.3106100890907e-06,0)	(0,-2.6778991741792e-06)	(-2.254464524843e-06,1.1306814926089e-06)	(4.4654493066956e-06,0)	(0,6.0369764520703e-05)	(2.9543339563978e-05,5.890852568732e-05)	(-6.9953833884381e-05,3.0850811907711e-06)	(1.1658710759061e-05,-0.00011670734536814)	(0,1.9037319088226e-06)	(8.4017390939745e-06,5.1807123074557e-06)	(3.5053513181293e-06,8.3958498644944e-06)	(2.3499208669322e-06,9.2728677837689e-06)	(-9.5891859776965e-06,4.0036488231903e-06)	(-4.229111130141e-05,1.7653396874277e-05)	(-2.610423749463e-05,4.2301626828911e-05)	(-4.6701580086367e-05,1.1825600636798e-05)
10.919471036384	(6.2725040560087e-06,0)	(-1.9256963636184e-06,5.2508460481201e-06)	(0,-2.8354172176796e-06)	(-1.5090944824713e-05,1.9645521907055e-06)	(0,-5.2197257521658e-06)	(-2.3588458619998e-06,0)	(4.3701174254998e-06,1.6014787810383e-06)	(1.6335849684809e-06,1.2556125338237e-05)	(4.2968524018407e-05,4.2944209924066e-05)	(0.00013608872525053,3.8844635071004e-05)	(7.4296799654322e-05,0.00013610200081342)	(8.1985850324265e-06,5.1755130922954e-05)	(-3.0737165540794e-06,3.0768649903828e-06)	(-9.7442879826326e-06,5.3191673924628e-06)	(-2.7795921123086e-06,9.7431506324935e-06)	(-3.7046455090348e-06,0)
10.919472791756	(6.02463895683e-06,0)	(0,-1.2246541842644e-05)	(-8.9920130091886e-06,-6.476905981673e-06)	(0,0)	(0,-5.0112400114676e-06)	(-5.3899790667375e-06,7.4793298832814e-06)	(-1.0191793892197e-05,0)	(0,0)	(-2.9348593831994e-05,6.7062888614482e-05)	(6.2847233500559e-06,5.3533629171652e-05)	(5.5138654824389e-05,6.2842481647936e-06)	(4.9754166857073e-05,-0.00019154563956354)	(-4.8017201932731e-06,-2.0997625628882e-06)	(0,3.9482656394138e-06)	(-3.8333852947301e-06,0)	(1.3712703945226e-05,3.5600642864399e-06)
10.919473793958	(7.8103510816367e-06,0)	(-2.258019096892e-06,-7.6183559287701e-06)	(1.1651235783171e-05,5.8095003066358e-06)	(0,4.0442593776729e-06)	(0,-6.4994932939705e-06)	(4.8376382589068e-06,-9.6977900859382e-06)	(-6.3372973835844e-06,1.8783698668443e-06)	(3.3655312998965e-06,0)	(-0.00017379245309415,-3.2014242987343e-05)	(-6.2666470481568e-06,3.3970392719272e-05)	(0.00010691594724895,-6.2766808663508e-06)	(-7.2753713761247e-05,3.6381224959025e-05)	(2.2896453587075e-06,-1.2441249026273e-05)	(0,7.6526709209879e-06)	(-2.4326544187593e-06,0)	(-2.6040166431332e-06,-5.2083161491497e-06)
10.919477121406	(1.3184467127101e-05,0)	(2.6915789595014e-06,7.6113263690477e-06)	(-3.0243868601188e-06,0)	(7.0855503068962e-06,-3.3715590247713e-06)	(0,-1.0970573509296e-05)	(0,2.5189963069806e-06)	(6.3319547377032e-06,-2.2376461095907e-06)	(-2.8057175025487e-06,-5.8961434997634e-06)	(9.5920603756704e-05,-3.2100961263018e-05)	(-6.3901754162683e-05,0.00014932484706185)	(8.8495964220635e-05,-6.3903906035637e-05)	(1.6462205179285e-05,4.1354648710092e-05)	(2.3001076796817e-06,6.8650792223866e-06)	(4.5762743197868e-06,6.3333965843182e-06)	(-1.0690429729564e-05,-4.5706712833542e-06)	(-2.9615449379624e-06,1.17959979426e-06)
11.645717229202	(4.1036149327195e-06,0)	(1.5077610180256e-06,0)	(-2.2388580497874e-06,4.945843381992e-06)	(0,0)	(0,7.7733081508761e-05)	(-9.3754004635736e-05,-4.2565933245199e-05)	(1.112427679542e-05,2.8582195476658e-05)	(0,-1.7518196356579e-05)	(-1.6125443238825e-06,6.2941166091587e-06)	(0,-4.025244001541e-06)	(-3.9773865944874e-06,0)	(3.3536126672321e-06,2.7587009727756e-06)	(-5.9653211359871e-05,-1.5330418109362e-05)	(8.5628528048328e-06,-3.7687793100389e-05)	(3.8119827512863e-05,-8.5214165897255e-06)	(-2.6179639578106e-05,3.1778898096314e-05)
11.645720997207	(-2.4258619147416e-06,0)	(2.526948474758e-06,-1.719295489371e-06)	(0,1.6972101509324e-06)	(5.5041710023101e-06,0)	(0,-4.5957782620414e-05)	(-3.2160997386713e-05,-1.5207204210822e-05)	(3.2565075923961e-05,4.7863898861417e-05)	(1.6622084005238e-05,0.00010433628712092)	(0,4.1188428288945e-06)	(5.3680170391438e-06,1.5079415982399e-06)	(3.222875119207e-06,5.3685762078334e-06)	(0,2.4584047676993e-06)	(-3.9021923117813e-05,8.4646393965751e-06)	(-5.0861931658641e-05,3.0515424391909e-05)	(-1.4304362634376e-05,5.0889904662248e-05)	(-2.329509254603e-05,-7.6571791846421e-06)

"""
read_cluster_model_instance(solution[0], 0)
