import numpy as np

class LinearRegressionModel:

    def __init__(self):
        self.slope = None
        self.intercept = None

    def fit(self, X, y):
        X = np.array(X)
        y = np.array(y)

        x_mean = np.mean(X)
        y_mean = np.mean(y)

        numerator = np.sum((X - x_mean) * (y - y_mean))
        denominator = np.sum((X - x_mean) ** 2)

        self.slope = numerator / denominator
        self.intercept = y_mean - self.slope * x_mean

    def predict(self, X):
        if self.slope is None or self.intercept is None:
            raise ValueError("Model must be trained using .fit() before prediction.")
        return self.slope * np.array(X) + self.intercept


    def __repr__(self):
        return f"LinearRegressionModel(slope={self.slope:.2f}, intercept={self.intercept:.2f})" if self.slope else "Untrained LinearRegressionModel"

    