from enum import Enum, auto
class BoltTypes(Enum):
	END_ANCHORED = "END_ANCHORED"
	FULLY_BONDED = "FULLY_BONDED"
	PLAIN_STRAND_CABLE = "QUEENS_CABLE"
	SWELLEX = "SHEAR_BOLT"
	TIEBACK = "TIEBACK_BOLT"
class BulgeTypes(Enum):
	GARFORD_BULB_25MM = "PHASE2_BULGE_GARFORD_25"
	NUT_CASE_21MM = "PHASE2_BULGE_NUTCASE_21"
class SecondaryBondLengthType(Enum):
	PERCENTAGE_OF_LENGTH = "P2_BOLT_TIEBACK_SECONDARY_PERCENT"
	LENGTH = "P2_BOLT_TIEBACK_SECONDARY_PHYSICAL"
	FULLY_BONDED = "P2_BOLT_TIEBACK_SECONDARY_FULLY"
class BoltModels(Enum):
	PLASTIC = "P2_BOLT_PLASTIC"
	ELASTIC = "P2_BOLT_ELASTIC"
class LinerTypes(Enum):
	STANDARD_BEAM = "P2_LINER_STANDARD_BEAM"
	GEOSYNTHETIC = "P2_LINER_GEOSYNTHETIC"
	REINFORCED_CONCRETE = "P2_LINER_REINFORCED_CONCRETE"
	CABLE_TRUSS = "P2_LINER_CABLE_TRUSS"
class LinerFormulation(Enum):
	BERNOULLI = "P2_LINER_FORMULATION_BERNOULLI"
	TIMOSHENKO = "P2_LINER_FORMULATION_TIMOSHENKO"
class MaterialType(Enum):
	ELASTIC = "ELASTIC"
	PLASTIC = "PLASTIC"
class GeometryChoice(Enum):
	AREA = "LNP_USE_AREA"
	THICKNESS = "LNP_USE_THICKNESS"
class StaticWaterModes(Enum):
	DRY = "SWM_DRY"
	PORE_WATER_PRESSURE = "SWM_PWP"
	RU = "SWM_RU"
	PIEZO = "SWM_PIEZO"
	GRID = "SWM_GRID"
	INTERPOLATED = "SWM_INTERPOLATED"
class StageFactorDefinitionMethod(Enum):
	ABSOLUTE_STAGE_FACTOR = 0
	RELATIVE_STAGE_FACTOR = 1
class JointTypes(Enum):
	NONE = "JOINT_NONE"
	MOHR_COULOMB = "JOINT_MOHR_COULOMB"
	BARTON_BANDIS = "JOINT_BARTON_BANDIS"
	GEOSYNTHETIC_HYPERBOLIC = "JOINT_HYPERBOLIC_SIMPLE"
	MATERIAL_DEPENDENT = "JOINT_MATERIAL_DEPENDENT"
	HYPERBOLIC_SOFTENING = "JOINT_HYPERBOLIC_SOFTENING"
	DISPLACEMENT_DEPENDENT = "JOINT_DISPLACEMENT_DEPENDENT"
class AdditionalPressureType(Enum):
	PRESSURE = "JOINT_ADDITIONAL_PRESSURE_BY_VALUE"
	PIEZOMETRIC_LINE = "JOINT_ADDITIONAL_PRESSURE_BY_PIEZO"
class DefineStiffness(Enum):
	DEFINE_PARAMETER = "DEFINE_PARAMETER"
	MATERIAL_DEPENDENT = "MATERIAL_DEPENDENT"
class PileApplicationType(Enum):
	CONSTANT = "APPLICATION_CONSTANT"
	DEFINE_BEAM_SEGMENT_BY_LENGTH = "APPLICATION_BY_LENGTH"
class PileEndCondition(Enum):
	NONE = "FP_NONE"
	FORCE = "FP_FORCE"
	DISPLACEMENT = "FP_DISPLACEMENT"
class PileForceApplicationPoint(Enum):
	TOP = "FP_TOP"
	BOTTOM = "FP_BOTTOM"
class PileSkinResistanceType(Enum):
	ELASTIC = "SKIN_RESISTANCE_ELASTIC"
	MOHR_COULOMB = "SKIN_RESISTANCE_C_PHI"
	LINEAR = "SKIN_RESISTANCE_LINEAR"
	MULTI_LINEAR = "SKIN_RESISTANCE_MULTI_LINEAR"
	MATERIAL_DEPENDENT = "SKIN_RESISTANCE_MATERIAL_DEPENDENT"
class PileDefinitionMethod(Enum):
	DISTANCE_FROM_TOP = "DISTANCE_FROM_TOP"
	ELEVATION = "ELEVATION"
class PileConnectionType(Enum):
	FREE = "CONNECT_FREE"
	HINGED = "CONNECT_HINGED"
	RIGID = "CONNECT_RIGID"
	SEMI_RIGID = "CONNECT_SEMIRIGID"
class CompositeJointPlacementTypes(Enum):
	BETWEEN_SOIL_ROCK_AND_FIRST_LINER = "BETWEEN_SOIL_ROCK_AND_FIRST_LINER"
	BETWEEN_FIRST_AND_SECOND_LINER = "BETWEEN_FIRST_AND_SECOND_LINER"
	BETWEEN_SECOND_AND_THIRD_LINER = "BETWEEN_SECOND_AND_THIRD_LINER"
	BETWEEN_THIRD_AND_FOURTH_LINER = "BETWEEN_THIRD_AND_FOURTH_LINER"
class ThermalType(Enum):
	CONSTANT = "THERMAL_CONSTANT"
	JOHANSEN = "THERMAL_JOHANSEN"
	JOHANSEN_LU = "THERMAL_JOHANSEN_LU"
	DE_VRIES = "THERMAL_DEVRIES"
	COTE_AND_KONRAD = "THERMAL_COTE_AND_KONRAD"
	CUSTOM = "THERMAL_TABULAR"
class ThermalWaterContentMethodType(Enum):
	USE_FROM_GROUNDWATER = "THERMAL_WATER_CONTENT_FROM_GROUNDWATER"
	DEFINE = "THERMAL_WATER_CONTENT_DEFINE"
class ThermalHeatCapacityType(Enum):
	CONSTANT = "THERMAL_HEAT_CAPACITY_CONSTANT"
	JAME_NEWMAN = "THERMAL_HEAT_CAPACITY_JAMENEWMAN"
	CUSTOM = "THERMAL_HEAT_CAPACITY_CUSTOM"
class ThermalWaterContentType(Enum):
	KONRAD = "THERMAL_WATER_CONTENT_KONRAD"
	TICE_AND_ANDERSON = "THERMAL_WATER_CONTENT_TICE_ANDERSON"
	SOIL_WATER_CONTENT_IN_HYDRAULIC_PROPERTIES = "THERMAL_WATER_CONTENT_HYDRO_MODEL"
	CUSTOM = "THERMAL_WATER_CONTENT_CUSTOM"
	SIMPLE = "THERMAL_WATER_CONTENT_DEFAULT"
class ThermalVolumetricDepencenceType(Enum):
	TEMPERATURE = "THERMAL_VOLUMETRIC_DEPENDENCE_TEMPERATURE"
	WATER_CONTENT = "THERMAL_VOLUMETRIC_DEPENDENCE_WATER_CONTENT"
class GroundWaterModes(Enum):
	SIMPLE = "SL_WATER_MODE_SIMPLE"
	FREDLUND_AND_XING = "SL_WATER_MODE_FREDLUND"
	VAN_GENUCHTEN = "SL_WATER_MODE_VAN_GENUCHTEN"
	BROOKS_AND_COREY = "SL_WATER_MODE_BROOK"
	USER_DEFINED = "SL_WATER_MODE_USER_DEFINED"
	GARDNER = "SL_WATER_MODE_GARDNER"
	CUSTOM = "SL_WATER_MODE_CONSTANT"
class ThermalSoilType(Enum):
	FINE = "THERMAL_SOIL_FINE"
	COARSE = "THERMAL_SOIL_COARSE"
	CRUSHED_ROCK = "THERMAL_SOIL_CRUSHED_ROCK"
	PEAT = "THERMAL_SOIL_PEAT"
class MVModel(Enum):
	NONE = "MV_NONE"
	CONSTANT = "MV_CONSTANT"
	FLUID = "MV_FLUID"
	ELASTIC_CONSOLIDATION_1D = "MV_1D_ELASTIC"
	ELASTIC_CONSOLIDATION_2D = "MV_2D_ELASTIC"
class WCInputType(Enum):
	BY_WATER_CONTENT = "WC_INPUT_WC"
	BY_DEGREE_OF_SATURATION = "WC_INPUT_DOS"
class UnsaturatedParameterType(Enum):
	NONE = "UNSATURATED_NOT_APPLIED"
	UNSATURATED_SHEAR_STRENGTH = "UNSATURATED_SHEAR_STRESS"
	SINGLE_EFFECTIVE_STRESS = "UNSATURATED_SINGLE_EFFECTIVE_STRESS"
class UnsaturatedShearStrengthType(Enum):
	FREDLUND = "UNSATURATED_FREDLUND"
	VANAPALLI = "UNSATURATED_VANAPALLI"
class UnsaturatedSingleEffectiveStressMethod(Enum):
	BISHOP = "UNSATURATED_BISHOP"
	TABULAR_VALUE = "UNSATURATED_TABULAR_VALUE"
	GUDEHUS_1995 = "UNSATURATED_GUDEHUS_1995"
	KHALILI_2004 = "UNSATURATED_KHALILI_2004"
	BOLZON_1996 = "UNSATURATED_BOLZON_1996"
	AITCHISON_1960 = "UNSATURATED_AITCHISON_1960"
	KOHGO_1993 = "UNSATURATED_KOHGO_1993"
class UnsaturatedTabularValueMethod(Enum):
	WITH_RESPECT_TO_SUCTION = "UNSATURATED_RESPECT_SUCTION"
	WITH_RESPECT_TO_DEGREE_OF_SATURATION = "UNSATURATED_RESPECT_DEGREE_SATURATION"
	WITH_RESPECT_TO_EFFECTIVE_DEGREE_OF_SATURATION = "UNSATURATED_RESPECT_EFFECTIVE_DEGREE_SATURATION"
class InitialElementLoadingType(Enum):
	FIELD_STRESS_ONLY = "INITIAL_MAT_LOADING__FIELD_STRESS_ONLY"
	FIELD_STRESS_AND_BODY_FORCE = "INITIAL_MAT_LOADING__BOTH_FIELD_AND_BODY"
	BODY_FORCE_ONLY = "INITIAL_MAT_LOADING__BODY_FORCE_ONLY"
	NONE = "INITIAL_MAT_LOADING__NONE"
class MaterialElasticityTypes(Enum):
	ISOTROPIC = "ISOTROPIC"
	TRANSVERSELY_ISOTROPIC = "TRANSVERSELY_ISOTROPIC"
	ORTHOTROPIC = "ORTHOTROPIC"
	DUNCAN_CHANG_HYPERBOLIC = "NON_LINEAR_HYPERBOLIC"
	NON_LINEAR_ISOTROPIC = "NON_LINEAR_ISOTROPIC"
	VISCO_ELASTIC = "VISCO_ELASTIC"
	CUSTOM = "CUSTOM_STIFFNESS"
class ElasticParameters(Enum):
	CONSTANT_SHEAR_MODULUS = "CONSTANT_SHEAR_MODULUS"
	CONSTANT_POISSON_RATIO = "CONSTANT_POISSON_RATIO"
class SpecificVolumeAtUnitPressure(Enum):
	CRITICAL_STATE_LINE_GAMMA = "CRITICAL_STATE_LINE"
	NORMAL_COMPRESSION_LINE = "NORMAL_COMPRESSION_LINE"
class InitialStateOfConsolidation(Enum):
	PRECONSOLIDATION_PRESSURE = "PRECONSOLIDATION_PRESSURE"
	OVERCONSOLIDATION_RATIO = "OVERCONSOLIDATION_RATIO"
class TensileCutoffOptions(Enum):
	NONE = "TENSILE_CUTOFF_NONE"
	HOEK_MARTIN_2004 = "TENSILE_CUTOFF_HOEK_MARTIN"
	USER_DEFINED = "TENSILE_CUTOFF_USER_DEFINED"
class NLIFormulaTypes(Enum):
	NLI_TYPE_FORMULA1 = "NLI_TYPE_FORMULA1"
	NLI_TYPE_FORMULA2 = "NLI_TYPE_FORMULA2"
	NLI_TYPE_FORMULA3 = "NLI_TYPE_FORMULA3"
	NLI_TYPE_FORMULA4 = "NLI_TYPE_FORMULA4"
class PoissonRatioType(Enum):
	CONSTANT = "POISSON_RATIO_CONSTANT"
	STRESS_DEPENDENT = "POISSON_RATIO_STRESS_DEPENDENT"
class AnisotropyDefinitions(Enum):
	ANGLE = "ANISOTROPY_DEFINITION_ANGLE"
	SURFACE = "ANISOTROPY_DEFINITION_SURFACE"
class MCCapType(Enum):
	VERTICAL = "MC_CAP_VERTICAL"
	ELLIPTICAL = "MC_CAP_ELLIPTICAL"
class CapHardeningTypes(Enum):
	EXPONENTIAL = "MC_CAP_HARDENING_EXPONENTIAL"
	TABULAR = "MC_CAP_HARDENING_TABULAR"
class CapTypes(Enum):
	NONE = "MC_CAP_TYPE_NOT_ACTIVE"
	VERTICAL = "MC_CAP_TYPE_VERTICAL"
	ELLIPTICAL = "MC_CAP_TYPE_ELLIPTICAL"
class ConeHardeningTypes(Enum):
	HARDENING_PROPERTY = "CONE_HARDENING_EXPONENTIAL"
	TABULAR = "CONE_HARDENING_TABULAR"
class DilationTypes(Enum):
	COMPACTION_DILATION = "DILATION_COMPACTION"
	DILATION_ONLY = "DILATION_ANGLE"
class HatchStyle(Enum):
	HatchStyleVertical = "HatchStyleVertical"
	HatchStyleForwardDiagonal = "HatchStyleForwardDiagonal"
	HatchStyleBackwardDiagonal = "HatchStyleBackwardDiagonal"
	HatchStyleCross = "HatchStyleCross"
	HatchStyleDiagonalCross = "HatchStyleDiagonalCross"
	HatchStyle05Percent = "HatchStyle05Percent"
	HatchStyle10Percent = "HatchStyle10Percent"
	HatchStyle20Percent = "HatchStyle20Percent"
	HatchStyle25Percent = "HatchStyle25Percent"
	HatchStyle30Percent = "HatchStyle30Percent"
	HatchStyle40Percent = "HatchStyle40Percent"
	HatchStyle50Percent = "HatchStyle50Percent"
	HatchStyle60Percent = "HatchStyle60Percent"
	HatchStyle70Percent = "HatchStyle70Percent"
	HatchStyle75Percent = "HatchStyle75Percent"
	HatchStyle80Percent = "HatchStyle80Percent"
	HatchStyle90Percent = "HatchStyle90Percent"
	HatchStyleLightDownwardDiagonal = "HatchStyleLightDownwardDiagonal"
	HatchStyleLightUpwardDiagonal = "HatchStyleLightUpwardDiagonal"
	HatchStyleDarkDownwardDiagonal = "HatchStyleDarkDownwardDiagonal"
	HatchStyleDarkUpwardDiagonal = "HatchStyleDarkUpwardDiagonal"
	HatchStyleWideDownwardDiagonal = "HatchStyleWideDownwardDiagonal"
	HatchStyleWideUpwardDiagonal = "HatchStyleWideUpwardDiagonal"
	HatchStyleLightVertical = "HatchStyleLightVertical"
	HatchStyleLightHorizontal = "HatchStyleLightHorizontal"
	HatchStyleNarrowVertical = "HatchStyleNarrowVertical"
	HatchStyleNarrowHorizontal = "HatchStyleNarrowHorizontal"
	HatchStyleDarkVertical = "HatchStyleDarkVertical"
	HatchStyleDarkHorizontal = "HatchStyleDarkHorizontal"
	HatchStyleDashedDownwardDiagonal = "HatchStyleDashedDownwardDiagonal"
	HatchStyleDashedUpwardDiagonal = "HatchStyleDashedUpwardDiagonal"
	HatchStyleDashedHorizontal = "HatchStyleDashedHorizontal"
	HatchStyleDashedVertical = "HatchStyleDashedVertical"
	HatchStyleSmallConfetti = "HatchStyleSmallConfetti"
	HatchStyleLargeConfetti = "HatchStyleLargeConfetti"
	HatchStyleZigZag = "HatchStyleZigZag"
	HatchStyleWave = "HatchStyleWave"
	HatchStyleDiagonalBrick = "HatchStyleDiagonalBrick"
	HatchStyleHorizontalBrick = "HatchStyleHorizontalBrick"
	HatchStyleWeave = "HatchStyleWeave"
	HatchStylePlaid = "HatchStylePlaid"
	HatchStyleDivot = "HatchStyleDivot"
	HatchStyleDottedGrid = "HatchStyleDottedGrid"
	HatchStyleDottedDiamond = "HatchStyleDottedDiamond"
	HatchStyleShingle = "HatchStyleShingle"
	HatchStyleTrellis = "HatchStyleTrellis"
	HatchStyleSphere = "HatchStyleSphere"
	HatchStyleSmallGrid = "HatchStyleSmallGrid"
	HatchStyleSmallCheckerBoard = "HatchStyleSmallCheckerBoard"
	HatchStyleLargeCheckerBoard = "HatchStyleLargeCheckerBoard"
	HatchStyleOutlinedDiamond = "HatchStyleOutlinedDiamond"
class UnloadingConditions(Enum):
	MEAN_STRESS = "UC_MEAN_STRESS"
	DEVIATORIC_STRESS = "UC_DEVIATORIC_STRESS"
	VOLUMETRIC_STRAIN = "UC_VOLUMETRIC_STRAIN"
	DEVIATORIC_STRAIN = "UC_DEVIATORIC_STRAIN"
class CustomMode(Enum):
	CUSTOM_Q = "CUSTOM_Q"
	CUSTOM_P = "CUSTOM_P"
	CUSTOM_S3 = "CUSTOM_S3"
	CUSTOM_U = "CUSTOM_U"
	CUSTOM_EPSV = "CUSTOM_EPSV"
	CUSTOM_GAMMA = "CUSTOM_GAMMA"
class StressHistoryTypes(Enum):
	OVER_CONSOLIDATION_OCR = "SHT_OCR"
	PRECONSOLIDATION_PRESSURE_PC = "SHT_PC"
class StressHistoryDefinitionMethods(Enum):
	STRESS_HISTORY_CONSTANT = "STRESS_HISTORY_CONSTANT"
	STRESS_HISTORY_DEPTH = "STRESS_HISTORY_DEPTH"
	STRESS_HISTORY_ELEVATION = "STRESS_HISTORY_ELEVATION"
class MaterialBehaviours(Enum):
	DRAINED = "DRAINED"
	UNDRAINED = "UNDRAINED"
class StrengthCriteriaTypes(Enum):
	MOHR_COULOMB = "MOHR_COULOMB"
	HOEK_BROWN = "HOEK_BROWN"
	DRUCKER_PRAGER = "DRUCKER_PRAGER"
	GENERALIZED_HOEK_BROWN = "GENERALIZED_HOEK_BROWN"
	CAM_CLAY = "CAM_CLAY"
	MODIFIED_CAM_CLAY = "MODIFIED_CAM_CLAY"
	DISCRETE_FUNCTION = "DISCRETE_FUNCTION"
	MOHR_COULOMB_CAP = "MOHR_COULOMB_CAP"
	SOFTENING_HARDENING = "SOFTENING_HARDENING"
	BARTON_BANDIS = "BARTON_BANDIS"
	HYPERBOLIC = "HYPERBOLIC"
	POWER_CURVE = "POWER_CURVE"
	SHEAR_NORMAL_FUNCTION = "SHEAR_NORMAL_FUNCTION"
	BOUNDING_SURFACE_PLASTICITY = "BOUNDING_SURFACE_PLASTICITY"
	MANZARI_AND_DAFALIAS = "MANZARI_AND_DAFALIAS"
	SNOWDEN_MODIFIED_ANISOTROPIC_LINEAR = "SNOWDEN_MODIFIED_ANISOTROPIC_LINEAR"
	ANISOTROPIC_LINEAR = "ANISOTROPIC_LINEAR"
	GENERALIZED_ANISOTROPIC = "GENERALIZED_ANISOTROPIC"
	SHANSEP = "SHANSEP"
	VERTICAL_STRESS_RATIO = "VERTICAL_STRESS_RATIO"
	BARCELONA_BASIC = "BARCELONA_BASIC"
	CHSOIL = "CHSOIL"
	CYSOIL = "CYSOIL"
	DOUBLE_YIELD = "DOUBLE_YIELD"
	HARDENING_SOIL = "HARDENING_SOIL"
	HARDENING_SOIL_SMALL_STRAIN_STIFFNESS = "HARDENING_SOIL_SMALL_STRAIN_STIFFNESS"
	SOFT_SOIL = "SOFT_SOIL"
	SOFT_SOIL_CREEP = "SOFT_SOIL_CREEP"
	SWELLING_ROCK = "SWELLING_ROCK"
	JOINTED_MOHR_COULOMB = "JOINTED_MOHR_COULOMB"
	JOINTED_GENERALIZED_HOEK_BROWN = "JOINTED_GENERALIZED_HOEK_BROWN"
	NORSAND = "NORSAND"
	FINN = "FINN"
	PM4_SAND = "PM4_SAND"
	PM4_SILT = "PM4_SILT"
class HuTypes(Enum):
	CUSTOM = "HT_CUSTOM"
	AUTO = "HT_AUTO"
class EnhancedSimpleSoilTypes(Enum):
	GENERAL = "SL_ES_SOIL_TYPE_GENERAL"
	SAND = "SL_ES_SOIL_TYPE_SAND"
	SILT = "SL_ES_SOIL_TYPE_SILT"
	CLAY = "SL_ES_SOIL_TYPE_CLAY"
	LOAM = "SL_ES_SOIL_TYPE_LOAM"
class DilationOption(Enum):
	DILATION_ONLY = "DILATION_ONLY"
	DILATION_ROWES = "DILATION_ROWES"
class CySoilCapOption(Enum):
	NON = "CYS_CAP_NON"
	ELLIPTICAL = "CYS_CAP_ELLIPTICAL"
class Dilatancy(Enum):
	DILATANCY_DEACTIVATED = "DILATANCY_DEACTIVATED"
	DILATANCY_ACTIVATED = "DILATANCY_ACTIVATED"
class InitialConsolidation(Enum):
	OVER_CONSOLIDATION_RATIO = "OVER_CONSOLIDATION_RATIO"
	INITIAL_MEAN_STRESS = "CONSOL_INITIAL_MEAN_STRESS"
class SwellingForm(Enum):
	WITTKE = "WITTKE"
	ANAGNOSTOU = "ANAGNOSTOU"
class WaterCondition(Enum):
	SWELLING = "SWELLING"
	SWELLING_WITH_WATER = "SWELLING_WITH_WATER"
class ViscoElasticTypes(Enum):
	MAXWELL = "VET_MAXWELL"
	BURGERS = "VET_BURGERS"
	STANDARD = "VET_STANDARD"
class NorSandInitialConsolidationCondition(Enum):
	OCR = "NORSAND_OCR"
	INITIAL_MEAN_STRESS = "NORSAND_INITIAL_MEAN_STRESS"
class FinnFormula(Enum):
	FINN_MARTIN = "FINN_MARTIN"
	FINN_BYRNE = "FINN_BYRNE"
class FinnByrneDefinition(Enum):
	FINN_BYRNE_C1_C2 = "FINN_BYRNE_C1_C2"
	FINN_BYRNE_N1 = "FINN_BYRNE_N1"
class DatumType(Enum):
	DATUM_TYPE_DEPTH = "DATUM_TYPE_DEPTH"
	DATUM_TYPE_RADIAL = "DATUM_TYPE_RADIAL"
class SnowdenAnisotropicFunctionType(Enum):
	FUNCTION_TYPE_SHEAR_NORMAL = "FUNCTION_TYPE_SHEAR_NORMAL"
	FUNCTION_TYPE_COHESION_PHI = "FUNCTION_TYPE_COHESION_PHI"
class InterpolationMethod(Enum):
	THIN_PLATE_SPLINE = "BCINTERPOLATE_THINPLATESPLINE"
	MODIFIED_CHUGH = "BCINTERPOLATE_CHUGH"
	LOCAL_THIN_PLATE_SPLINE = "BCINTERPOLATE_LOCALTHINPLATESPLINE"
	TIN_TRIANGULATION = "BCINTERPOLATE_TINTRIANGULATION"
	INVERSE_DISTANCE = "BCINTERPOLATE_INVERSEDISTANCE"
	LINEAR_BY_ELEVATION = "BCINTERPOLATE_LINEARBYELEVATION"
	CHUGH = "BCINTERPOLATE_ORIGINALCHUGH"
class SymbolTypes(Enum):
	SQUARE = "SL_SYMBOL_TYPE_SQUARE"
	TRIANGLE = "SL_SYMBOL_TYPE_TRI"
	RHOMB = "SL_SYMBOL_TYPE_RHOMB"
	CIRCLE = "SL_SYMBOL_TYPE_CIRCLE"
	VERT_CROSS = "SL_SYMBOL_TYPE_CROSS"
	DIAG_CROSS = "SL_SYMBOL_TYPE_X"
	DOT = "SL_SYMBOL_TYPE_DOT"
class DiscreteDrainedMode(Enum):
	UNDRAINED = "SL_DISCRETE_UNDRAINED"
	DRAINED = "SL_DISCRETE_DRAINED"
