# mypy-boto3-discovery

[![PyPI - mypy-boto3-discovery](https://img.shields.io/pypi/v/mypy-boto3-discovery.svg?color=blue)](https://pypi.org/project/mypy-boto3-discovery)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-discovery.svg?color=blue)](https://pypi.org/project/mypy-boto3-discovery)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.ApplicationDiscoveryService 1.13.3](https://boto3.amazonaws.com/v1/documentation/api/1.13.3/reference/services/discovery.html#ApplicationDiscoveryService) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 1.0.9](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-discovery](#mypy-boto3-discovery)
  - [How to use](#how-to-use)
    - [Type checking](#type-checking)
  - [How it works](#how-it-works)

## How to use

### Type checking

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `ApplicationDiscoveryService` service.

```bash
python -m pip install boto3-stubs[discovery]

# update installed packages index
mypy_boto3
```

Use `boto3` with `mypy_boto3` in your project and enjoy type checking and auto-complete.

```python
import boto3

from mypy_boto3 import discovery
# alternative import if you do not want to install mypy_boto3 package
# import mypy_boto3_discovery as discovery

# Use this client as usual, now mypy can check if your code is valid.
# Check if your IDE supports function overloads,
# you probably do not need explicit type annotations
# client = boto3.client("discovery")
client: discovery.ApplicationDiscoveryServiceClient = boto3.client("discovery")

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: discovery.ApplicationDiscoveryServiceClient = session.client("discovery")


# Paginators need type annotation on creation
describe_agents_paginator: discovery.DescribeAgentsPaginator = client.get_paginator("describe_agents")
describe_continuous_exports_paginator: discovery.DescribeContinuousExportsPaginator = client.get_paginator("describe_continuous_exports")
describe_export_configurations_paginator: discovery.DescribeExportConfigurationsPaginator = client.get_paginator("describe_export_configurations")
describe_export_tasks_paginator: discovery.DescribeExportTasksPaginator = client.get_paginator("describe_export_tasks")
describe_tags_paginator: discovery.DescribeTagsPaginator = client.get_paginator("describe_tags")
list_configurations_paginator: discovery.ListConfigurationsPaginator = client.get_paginator("list_configurations")
```

## How it works

Fully automated [builder](https://github.com/vemel/mypy_boto3_builder) carefully generates
type annotations for each service, patiently waiting for `boto3` updates. It delivers
a drop-in type annotations for you and makes sure that:

- All available `boto3` services are covered.
- Each public class and method of every `boto3` service gets valid type annotations
  extracted from the documentation (blame `botocore` docs if types are incorrect).
- Type annotations include up-to-date documentation.
- Link to documentation is provided for every method.
- Code is processed by [black](https://github.com/psf/black) for readability.