"""
Hierarchical Multi-Team Orchestration Example

This example demonstrates a hierarchical orchestration model where:
1. Master/Orchestrator Agent breaks down a complex task into subtasks
2. Each subtask is delegated to a SEPARATE TEAM of specialized agents
3. Teams work collaboratively in their own workspace
4. Results are synthesized back to the master orchestrator

Architecture:
    Master Orchestrator
           |
    -------+-------
    |             |
  Team 1       Team 2
  [WS 1]       [WS 2]
    |             |
  Agents       Agents

Each team is a collaborative workspace (WS) with specialized agents working together.
"""

__version__ = "1.0.0"

