"""Configuration and constants for hierarchical teams orchestration."""

import os
from pathlib import Path
from dotenv import load_dotenv

# Load environment
load_dotenv()
load_dotenv(dotenv_path=Path(__file__).parent.parent / ".env")


class Config:
    """Configuration manager for the application."""
    
    # Port configuration
    PORTS = [8001, 8002, 8003, 8004, 8005, 8006, 8007, 8008]
    
    # API Keys - support multiple keys for load distribution
    @staticmethod
    def get_api_keys():
        """Get all available Anthropic API keys."""
        api_keys = []
        for i in range(1, 4):  # Check for ANTHROPIC_API_KEY, ANTHROPIC_API_KEY_2, ANTHROPIC_API_KEY_3
            key_name = f"ANTHROPIC_API_KEY_{i}" if i > 1 else "ANTHROPIC_API_KEY"
            key = os.getenv(key_name)
            if key:
                api_keys.append(key)
        return api_keys
    
    # Workspace configuration
    MAX_ROUNDS = 2  # Increased for better collaboration with concise outputs
    CONVERGENCE_THRESHOLD = 0.6
    
    # LLM configuration
    MODEL = "claude-sonnet-4-5"
    MAX_TOKENS = 2048
    SYNTHESIS_MAX_TOKENS = 4096
    DEFAULT_TEMPERATURE = 0.3
    SYNTHESIS_TEMPERATURE = 0.5
    RATE_LIMIT_DELAY = 0.3  # seconds between API calls
    
    # Output configuration
    OUTPUTS_DIR = Path(__file__).parent.parent / "outputs"

