#!/usr/bin/env python3
"""
Simple runner script for hierarchical teams orchestration.
Run this directly: python run.py
"""

import sys
from pathlib import Path

# Add parent directory to path so we can import hierarchical_teams as a module
parent_dir = Path(__file__).parent.parent
sys.path.insert(0, str(parent_dir))

# Now import and run the main function
from hierarchical_teams.main import main
import asyncio

if __name__ == "__main__":
    asyncio.run(main())

