"""Port cleanup utilities."""

import subprocess


def cleanup_ports(ports):
    """Kill any processes using the specified ports.
    
    Args:
        ports: List of port numbers to clean up
    """
    try:
        ports_str = ','.join(map(str, ports))
        subprocess.run(
            f"lsof -ti:{ports_str} | xargs kill -9 2>/dev/null",
            shell=True,
            capture_output=True,
            timeout=5
        )
    except Exception:
        pass

