"""
Synqed - A simplified wrapper around A2A for multi-agent systems.

This module provides high-level abstractions for creating, managing,
and coordinating AI agents using the A2A protocol.
"""

import asyncio
import aiohttp

from synqed.agent import Agent
from synqed.agent_card import AgentCardBuilder
from synqed.client import Client
from synqed.delegator import TaskDelegator
from synqed.orchestrator import (
    Orchestrator,
    LLMProvider,
    AgentSelection,
    OrchestrationResult,
)
from synqed.server import AgentServer
from synqed.workspace import (
    Workspace,
    WorkspaceState,
    WorkspaceMessage,
    WorkspaceArtifact,
    WorkspaceParticipant,
    MessageType,
)
from synqed.orchestrated_workspace import (
    OrchestratedWorkspace,
    ExecutionPlan,
    ExecutionResult,
    Subtask,
    CollaborationMode,
)
from synqed.message_model import (
    StructuredMessage,
    MessageType as StructuredMessageType,
    MessagePriority,
    MessageMetadata,
    create_suggestion,
    create_critique,
    create_vote,
    create_final_output_proposal,
)

__version__ = "1.0.8"

__all__ = [
    # === Core Agent Components ===
    "Agent",
    "AgentCardBuilder",
    "AgentServer",
    "Client",
    
    # === Orchestration ===
    "TaskDelegator",
    "Orchestrator",
    "LLMProvider",
    "AgentSelection",
    "OrchestrationResult",
    
    # === Workspaces ===
    "Workspace",
    "WorkspaceState",
    "WorkspaceMessage",
    "WorkspaceArtifact",
    "WorkspaceParticipant",
    "MessageType",
    "OrchestratedWorkspace",
    "ExecutionPlan",
    "ExecutionResult",
    "Subtask",
    "CollaborationMode",
    
    # === Message Model ===
    "StructuredMessage",
    "StructuredMessageType",
    "MessagePriority",
    "MessageMetadata",
    "create_suggestion",
    "create_critique",
    "create_vote",
    "create_final_output_proposal",
    
    # === Utils ===
    "asyncio",
    "aiohttp",
]

