# coding: utf-8

"""
    The Plane REST API

    The Plane REST API  Visit our quick start guide and full API documentation at [developers.plane.so](https://developers.plane.so/api-reference/introduction).

    The version of the API Spec: 0.0.1
    Contact: support@plane.so
    This class is auto generated.

    Do not edit the class manually.
"""  # noqa: E501


import re  # noqa: F401

from pydantic import validate_arguments

from typing_extensions import Annotated
from pydantic import Field, StrictInt, StrictStr

from typing import Optional

from plane.models.intake_issue import IntakeIssue
from plane.models.intake_issue_create_request import IntakeIssueCreateRequest
from plane.models.paginated_intake_issue_response import PaginatedIntakeIssueResponse
from plane.models.patched_intake_issue_update_request import PatchedIntakeIssueUpdateRequest

from plane.api_client import ApiClient
from plane.api_response import ApiResponse
from plane.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class IntakeApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def create_intake_work_item(self, project_id : Annotated[StrictStr, Field(..., description="Project ID")], slug : Annotated[StrictStr, Field(..., description="Workspace slug")], intake_issue_create_request : IntakeIssueCreateRequest, **kwargs) -> IntakeIssue:  # noqa: E501
        """Create intake work item  # noqa: E501

        Submit a new work item to the project's intake queue for review and triage. Automatically creates the work item with default triage state and tracks activity.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_intake_work_item(project_id, slug, intake_issue_create_request, async_req=True)
        >>> result = thread.get()

        :param project_id: Project ID (required)
        :type project_id: str
        :param slug: Workspace slug (required)
        :type slug: str
        :param intake_issue_create_request: (required)
        :type intake_issue_create_request: IntakeIssueCreateRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: IntakeIssue
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the create_intake_work_item_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.create_intake_work_item_with_http_info(project_id, slug, intake_issue_create_request, **kwargs)  # noqa: E501

    @validate_arguments
    def create_intake_work_item_with_http_info(self, project_id : Annotated[StrictStr, Field(..., description="Project ID")], slug : Annotated[StrictStr, Field(..., description="Workspace slug")], intake_issue_create_request : IntakeIssueCreateRequest, **kwargs) -> ApiResponse:  # noqa: E501
        """Create intake work item  # noqa: E501

        Submit a new work item to the project's intake queue for review and triage. Automatically creates the work item with default triage state and tracks activity.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_intake_work_item_with_http_info(project_id, slug, intake_issue_create_request, async_req=True)
        >>> result = thread.get()

        :param project_id: Project ID (required)
        :type project_id: str
        :param slug: Workspace slug (required)
        :type slug: str
        :param intake_issue_create_request: (required)
        :type intake_issue_create_request: IntakeIssueCreateRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(IntakeIssue, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'slug',
            'intake_issue_create_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_intake_work_item" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id'] is not None:
            _path_params['project_id'] = _params['project_id']

        if _params['slug'] is not None:
            _path_params['slug'] = _params['slug']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['intake_issue_create_request'] is not None:
            _body_params = _params['intake_issue_create_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2Authentication', 'OAuth2Authentication']  # noqa: E501

        _response_types_map = {
            '401': None,
            '403': None,
            '404': None,
            '201': "IntakeIssue",
            '400': None,
        }

        return self.api_client.call_api(
            '/api/v1/workspaces/{slug}/projects/{project_id}/intake-issues/', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def delete_intake_work_item(self, issue_id : Annotated[StrictStr, Field(..., description="Issue ID")], project_id : Annotated[StrictStr, Field(..., description="Project ID")], slug : Annotated[StrictStr, Field(..., description="Workspace slug")], **kwargs) -> None:  # noqa: E501
        """Delete intake work item  # noqa: E501

        Permanently remove an intake work item from the triage queue. Also deletes the underlying work item if it hasn't been accepted yet.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_intake_work_item(issue_id, project_id, slug, async_req=True)
        >>> result = thread.get()

        :param issue_id: Issue ID (required)
        :type issue_id: str
        :param project_id: Project ID (required)
        :type project_id: str
        :param slug: Workspace slug (required)
        :type slug: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the delete_intake_work_item_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.delete_intake_work_item_with_http_info(issue_id, project_id, slug, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_intake_work_item_with_http_info(self, issue_id : Annotated[StrictStr, Field(..., description="Issue ID")], project_id : Annotated[StrictStr, Field(..., description="Project ID")], slug : Annotated[StrictStr, Field(..., description="Workspace slug")], **kwargs) -> ApiResponse:  # noqa: E501
        """Delete intake work item  # noqa: E501

        Permanently remove an intake work item from the triage queue. Also deletes the underlying work item if it hasn't been accepted yet.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_intake_work_item_with_http_info(issue_id, project_id, slug, async_req=True)
        >>> result = thread.get()

        :param issue_id: Issue ID (required)
        :type issue_id: str
        :param project_id: Project ID (required)
        :type project_id: str
        :param slug: Workspace slug (required)
        :type slug: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = [
            'issue_id',
            'project_id',
            'slug'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_intake_work_item" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['issue_id'] is not None:
            _path_params['issue_id'] = _params['issue_id']

        if _params['project_id'] is not None:
            _path_params['project_id'] = _params['project_id']

        if _params['slug'] is not None:
            _path_params['slug'] = _params['slug']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2Authentication', 'OAuth2Authentication']  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            '/api/v1/workspaces/{slug}/projects/{project_id}/intake-issues/{issue_id}/', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_intake_work_items_list(self, project_id : Annotated[StrictStr, Field(..., description="Project ID")], slug : Annotated[StrictStr, Field(..., description="Workspace slug")], cursor : Annotated[Optional[StrictStr], Field(description="Pagination cursor for getting next set of results")] = None, expand : Annotated[Optional[StrictStr], Field(description="Comma-separated list of related fields to expand in response")] = None, fields : Annotated[Optional[StrictStr], Field(description="Comma-separated list of fields to include in response")] = None, per_page : Annotated[Optional[StrictInt], Field(description="Number of results per page (default: 20, max: 100)")] = None, **kwargs) -> PaginatedIntakeIssueResponse:  # noqa: E501
        """List intake work items  # noqa: E501

        Retrieve all work items in the project's intake queue. Returns paginated results when listing all intake work items.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_intake_work_items_list(project_id, slug, cursor, expand, fields, per_page, async_req=True)
        >>> result = thread.get()

        :param project_id: Project ID (required)
        :type project_id: str
        :param slug: Workspace slug (required)
        :type slug: str
        :param cursor: Pagination cursor for getting next set of results
        :type cursor: str
        :param expand: Comma-separated list of related fields to expand in response
        :type expand: str
        :param fields: Comma-separated list of fields to include in response
        :type fields: str
        :param per_page: Number of results per page (default: 20, max: 100)
        :type per_page: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PaginatedIntakeIssueResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_intake_work_items_list_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.get_intake_work_items_list_with_http_info(project_id, slug, cursor, expand, fields, per_page, **kwargs)  # noqa: E501

    @validate_arguments
    def get_intake_work_items_list_with_http_info(self, project_id : Annotated[StrictStr, Field(..., description="Project ID")], slug : Annotated[StrictStr, Field(..., description="Workspace slug")], cursor : Annotated[Optional[StrictStr], Field(description="Pagination cursor for getting next set of results")] = None, expand : Annotated[Optional[StrictStr], Field(description="Comma-separated list of related fields to expand in response")] = None, fields : Annotated[Optional[StrictStr], Field(description="Comma-separated list of fields to include in response")] = None, per_page : Annotated[Optional[StrictInt], Field(description="Number of results per page (default: 20, max: 100)")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """List intake work items  # noqa: E501

        Retrieve all work items in the project's intake queue. Returns paginated results when listing all intake work items.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_intake_work_items_list_with_http_info(project_id, slug, cursor, expand, fields, per_page, async_req=True)
        >>> result = thread.get()

        :param project_id: Project ID (required)
        :type project_id: str
        :param slug: Workspace slug (required)
        :type slug: str
        :param cursor: Pagination cursor for getting next set of results
        :type cursor: str
        :param expand: Comma-separated list of related fields to expand in response
        :type expand: str
        :param fields: Comma-separated list of fields to include in response
        :type fields: str
        :param per_page: Number of results per page (default: 20, max: 100)
        :type per_page: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PaginatedIntakeIssueResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'slug',
            'cursor',
            'expand',
            'fields',
            'per_page'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_intake_work_items_list" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id'] is not None:
            _path_params['project_id'] = _params['project_id']

        if _params['slug'] is not None:
            _path_params['slug'] = _params['slug']


        # process the query parameters
        _query_params = []
        if _params.get('cursor') is not None:  # noqa: E501
            _query_params.append(('cursor', _params['cursor']))

        if _params.get('expand') is not None:  # noqa: E501
            _query_params.append(('expand', _params['expand']))

        if _params.get('fields') is not None:  # noqa: E501
            _query_params.append(('fields', _params['fields']))

        if _params.get('per_page') is not None:  # noqa: E501
            _query_params.append(('per_page', _params['per_page']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2Authentication', 'OAuth2Authentication']  # noqa: E501

        _response_types_map = {
            '401': None,
            '403': None,
            '404': None,
            '200': "PaginatedIntakeIssueResponse",
        }

        return self.api_client.call_api(
            '/api/v1/workspaces/{slug}/projects/{project_id}/intake-issues/', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def retrieve_intake_work_item(self, issue_id : Annotated[StrictStr, Field(..., description="Issue ID")], project_id : Annotated[StrictStr, Field(..., description="Project ID")], slug : Annotated[StrictStr, Field(..., description="Workspace slug")], **kwargs) -> IntakeIssue:  # noqa: E501
        """Retrieve intake work item  # noqa: E501

        Retrieve details of a specific intake work item.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.retrieve_intake_work_item(issue_id, project_id, slug, async_req=True)
        >>> result = thread.get()

        :param issue_id: Issue ID (required)
        :type issue_id: str
        :param project_id: Project ID (required)
        :type project_id: str
        :param slug: Workspace slug (required)
        :type slug: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: IntakeIssue
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the retrieve_intake_work_item_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.retrieve_intake_work_item_with_http_info(issue_id, project_id, slug, **kwargs)  # noqa: E501

    @validate_arguments
    def retrieve_intake_work_item_with_http_info(self, issue_id : Annotated[StrictStr, Field(..., description="Issue ID")], project_id : Annotated[StrictStr, Field(..., description="Project ID")], slug : Annotated[StrictStr, Field(..., description="Workspace slug")], **kwargs) -> ApiResponse:  # noqa: E501
        """Retrieve intake work item  # noqa: E501

        Retrieve details of a specific intake work item.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.retrieve_intake_work_item_with_http_info(issue_id, project_id, slug, async_req=True)
        >>> result = thread.get()

        :param issue_id: Issue ID (required)
        :type issue_id: str
        :param project_id: Project ID (required)
        :type project_id: str
        :param slug: Workspace slug (required)
        :type slug: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(IntakeIssue, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'issue_id',
            'project_id',
            'slug'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method retrieve_intake_work_item" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['issue_id'] is not None:
            _path_params['issue_id'] = _params['issue_id']

        if _params['project_id'] is not None:
            _path_params['project_id'] = _params['project_id']

        if _params['slug'] is not None:
            _path_params['slug'] = _params['slug']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2Authentication', 'OAuth2Authentication']  # noqa: E501

        _response_types_map = {
            '401': None,
            '403': None,
            '404': None,
            '200': "IntakeIssue",
        }

        return self.api_client.call_api(
            '/api/v1/workspaces/{slug}/projects/{project_id}/intake-issues/{issue_id}/', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def update_intake_work_item(self, issue_id : Annotated[StrictStr, Field(..., description="Issue ID")], project_id : Annotated[StrictStr, Field(..., description="Project ID")], slug : Annotated[StrictStr, Field(..., description="Workspace slug")], patched_intake_issue_update_request : Optional[PatchedIntakeIssueUpdateRequest] = None, **kwargs) -> IntakeIssue:  # noqa: E501
        """Update intake work item  # noqa: E501

        Modify an existing intake work item's properties or status for triage processing. Supports status changes like accept, reject, or mark as duplicate.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_intake_work_item(issue_id, project_id, slug, patched_intake_issue_update_request, async_req=True)
        >>> result = thread.get()

        :param issue_id: Issue ID (required)
        :type issue_id: str
        :param project_id: Project ID (required)
        :type project_id: str
        :param slug: Workspace slug (required)
        :type slug: str
        :param patched_intake_issue_update_request:
        :type patched_intake_issue_update_request: PatchedIntakeIssueUpdateRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: IntakeIssue
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the update_intake_work_item_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.update_intake_work_item_with_http_info(issue_id, project_id, slug, patched_intake_issue_update_request, **kwargs)  # noqa: E501

    @validate_arguments
    def update_intake_work_item_with_http_info(self, issue_id : Annotated[StrictStr, Field(..., description="Issue ID")], project_id : Annotated[StrictStr, Field(..., description="Project ID")], slug : Annotated[StrictStr, Field(..., description="Workspace slug")], patched_intake_issue_update_request : Optional[PatchedIntakeIssueUpdateRequest] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Update intake work item  # noqa: E501

        Modify an existing intake work item's properties or status for triage processing. Supports status changes like accept, reject, or mark as duplicate.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_intake_work_item_with_http_info(issue_id, project_id, slug, patched_intake_issue_update_request, async_req=True)
        >>> result = thread.get()

        :param issue_id: Issue ID (required)
        :type issue_id: str
        :param project_id: Project ID (required)
        :type project_id: str
        :param slug: Workspace slug (required)
        :type slug: str
        :param patched_intake_issue_update_request:
        :type patched_intake_issue_update_request: PatchedIntakeIssueUpdateRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(IntakeIssue, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'issue_id',
            'project_id',
            'slug',
            'patched_intake_issue_update_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_intake_work_item" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['issue_id'] is not None:
            _path_params['issue_id'] = _params['issue_id']

        if _params['project_id'] is not None:
            _path_params['project_id'] = _params['project_id']

        if _params['slug'] is not None:
            _path_params['slug'] = _params['slug']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['patched_intake_issue_update_request'] is not None:
            _body_params = _params['patched_intake_issue_update_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2Authentication', 'OAuth2Authentication']  # noqa: E501

        _response_types_map = {
            '401': None,
            '403': None,
            '404': None,
            '200': "IntakeIssue",
            '400': None,
        }

        return self.api_client.call_api(
            '/api/v1/workspaces/{slug}/projects/{project_id}/intake-issues/{issue_id}/', 'PATCH',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
