# coding: utf-8

"""
    The Plane REST API

    The Plane REST API  Visit our quick start guide and full API documentation at [developers.plane.so](https://developers.plane.so/api-reference/introduction).

    The version of the API Spec: 0.0.1
    Contact: support@plane.so
    This class is auto generated.

    Do not edit the class manually.
"""  # noqa: E501


import re  # noqa: F401

from pydantic import validate_arguments

from typing_extensions import Annotated
from pydantic import Field, StrictInt, StrictStr

from typing import Optional

from plane.models.paginated_issue_activity_detail_response import PaginatedIssueActivityDetailResponse
from plane.models.paginated_issue_activity_response import PaginatedIssueActivityResponse

from plane.api_client import ApiClient
from plane.api_response import ApiResponse
from plane.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class WorkItemActivityApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def list_work_item_activities(self, issue_id : Annotated[StrictStr, Field(..., description="Issue ID")], project_id : Annotated[StrictStr, Field(..., description="Project ID")], slug : Annotated[StrictStr, Field(..., description="Workspace slug")], cursor : Annotated[Optional[StrictStr], Field(description="Pagination cursor for getting next set of results")] = None, expand : Annotated[Optional[StrictStr], Field(description="Comma-separated list of related fields to expand in response")] = None, fields : Annotated[Optional[StrictStr], Field(description="Comma-separated list of fields to include in response")] = None, order_by : Annotated[Optional[StrictStr], Field(description="Field to order results by. Prefix with '-' for descending order")] = None, per_page : Annotated[Optional[StrictInt], Field(description="Number of results per page (default: 20, max: 100)")] = None, **kwargs) -> PaginatedIssueActivityResponse:  # noqa: E501
        """Endpoints for issue activity/search and fetch issue activity details  # noqa: E501

        Retrieve all activities for a work item. Supports filtering by activity type and date range.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_work_item_activities(issue_id, project_id, slug, cursor, expand, fields, order_by, per_page, async_req=True)
        >>> result = thread.get()

        :param issue_id: Issue ID (required)
        :type issue_id: str
        :param project_id: Project ID (required)
        :type project_id: str
        :param slug: Workspace slug (required)
        :type slug: str
        :param cursor: Pagination cursor for getting next set of results
        :type cursor: str
        :param expand: Comma-separated list of related fields to expand in response
        :type expand: str
        :param fields: Comma-separated list of fields to include in response
        :type fields: str
        :param order_by: Field to order results by. Prefix with '-' for descending order
        :type order_by: str
        :param per_page: Number of results per page (default: 20, max: 100)
        :type per_page: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PaginatedIssueActivityResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_work_item_activities_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.list_work_item_activities_with_http_info(issue_id, project_id, slug, cursor, expand, fields, order_by, per_page, **kwargs)  # noqa: E501

    @validate_arguments
    def list_work_item_activities_with_http_info(self, issue_id : Annotated[StrictStr, Field(..., description="Issue ID")], project_id : Annotated[StrictStr, Field(..., description="Project ID")], slug : Annotated[StrictStr, Field(..., description="Workspace slug")], cursor : Annotated[Optional[StrictStr], Field(description="Pagination cursor for getting next set of results")] = None, expand : Annotated[Optional[StrictStr], Field(description="Comma-separated list of related fields to expand in response")] = None, fields : Annotated[Optional[StrictStr], Field(description="Comma-separated list of fields to include in response")] = None, order_by : Annotated[Optional[StrictStr], Field(description="Field to order results by. Prefix with '-' for descending order")] = None, per_page : Annotated[Optional[StrictInt], Field(description="Number of results per page (default: 20, max: 100)")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Endpoints for issue activity/search and fetch issue activity details  # noqa: E501

        Retrieve all activities for a work item. Supports filtering by activity type and date range.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_work_item_activities_with_http_info(issue_id, project_id, slug, cursor, expand, fields, order_by, per_page, async_req=True)
        >>> result = thread.get()

        :param issue_id: Issue ID (required)
        :type issue_id: str
        :param project_id: Project ID (required)
        :type project_id: str
        :param slug: Workspace slug (required)
        :type slug: str
        :param cursor: Pagination cursor for getting next set of results
        :type cursor: str
        :param expand: Comma-separated list of related fields to expand in response
        :type expand: str
        :param fields: Comma-separated list of fields to include in response
        :type fields: str
        :param order_by: Field to order results by. Prefix with '-' for descending order
        :type order_by: str
        :param per_page: Number of results per page (default: 20, max: 100)
        :type per_page: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PaginatedIssueActivityResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'issue_id',
            'project_id',
            'slug',
            'cursor',
            'expand',
            'fields',
            'order_by',
            'per_page'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_work_item_activities" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['issue_id'] is not None:
            _path_params['issue_id'] = _params['issue_id']

        if _params['project_id'] is not None:
            _path_params['project_id'] = _params['project_id']

        if _params['slug'] is not None:
            _path_params['slug'] = _params['slug']


        # process the query parameters
        _query_params = []
        if _params.get('cursor') is not None:  # noqa: E501
            _query_params.append(('cursor', _params['cursor']))

        if _params.get('expand') is not None:  # noqa: E501
            _query_params.append(('expand', _params['expand']))

        if _params.get('fields') is not None:  # noqa: E501
            _query_params.append(('fields', _params['fields']))

        if _params.get('order_by') is not None:  # noqa: E501
            _query_params.append(('order_by', _params['order_by']))

        if _params.get('per_page') is not None:  # noqa: E501
            _query_params.append(('per_page', _params['per_page']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2Authentication', 'OAuth2Authentication']  # noqa: E501

        _response_types_map = {
            '401': None,
            '403': None,
            '404': None,
            '200': "PaginatedIssueActivityResponse",
            '400': None,
        }

        return self.api_client.call_api(
            '/api/v1/workspaces/{slug}/projects/{project_id}/issues/{issue_id}/activities/', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def retrieve_work_item_activity(self, issue_id : Annotated[StrictStr, Field(..., description="Issue ID")], pk : Annotated[StrictStr, Field(..., description="Activity ID")], project_id : Annotated[StrictStr, Field(..., description="Project ID")], slug : Annotated[StrictStr, Field(..., description="Workspace slug")], cursor : Annotated[Optional[StrictStr], Field(description="Pagination cursor for getting next set of results")] = None, expand : Annotated[Optional[StrictStr], Field(description="Comma-separated list of related fields to expand in response")] = None, fields : Annotated[Optional[StrictStr], Field(description="Comma-separated list of fields to include in response")] = None, order_by : Annotated[Optional[StrictStr], Field(description="Field to order results by. Prefix with '-' for descending order")] = None, per_page : Annotated[Optional[StrictInt], Field(description="Number of results per page (default: 20, max: 100)")] = None, **kwargs) -> PaginatedIssueActivityDetailResponse:  # noqa: E501
        """Endpoints for issue activity/search and fetch issue activity details  # noqa: E501

        Retrieve details of a specific activity.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.retrieve_work_item_activity(issue_id, pk, project_id, slug, cursor, expand, fields, order_by, per_page, async_req=True)
        >>> result = thread.get()

        :param issue_id: Issue ID (required)
        :type issue_id: str
        :param pk: Activity ID (required)
        :type pk: str
        :param project_id: Project ID (required)
        :type project_id: str
        :param slug: Workspace slug (required)
        :type slug: str
        :param cursor: Pagination cursor for getting next set of results
        :type cursor: str
        :param expand: Comma-separated list of related fields to expand in response
        :type expand: str
        :param fields: Comma-separated list of fields to include in response
        :type fields: str
        :param order_by: Field to order results by. Prefix with '-' for descending order
        :type order_by: str
        :param per_page: Number of results per page (default: 20, max: 100)
        :type per_page: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PaginatedIssueActivityDetailResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the retrieve_work_item_activity_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.retrieve_work_item_activity_with_http_info(issue_id, pk, project_id, slug, cursor, expand, fields, order_by, per_page, **kwargs)  # noqa: E501

    @validate_arguments
    def retrieve_work_item_activity_with_http_info(self, issue_id : Annotated[StrictStr, Field(..., description="Issue ID")], pk : Annotated[StrictStr, Field(..., description="Activity ID")], project_id : Annotated[StrictStr, Field(..., description="Project ID")], slug : Annotated[StrictStr, Field(..., description="Workspace slug")], cursor : Annotated[Optional[StrictStr], Field(description="Pagination cursor for getting next set of results")] = None, expand : Annotated[Optional[StrictStr], Field(description="Comma-separated list of related fields to expand in response")] = None, fields : Annotated[Optional[StrictStr], Field(description="Comma-separated list of fields to include in response")] = None, order_by : Annotated[Optional[StrictStr], Field(description="Field to order results by. Prefix with '-' for descending order")] = None, per_page : Annotated[Optional[StrictInt], Field(description="Number of results per page (default: 20, max: 100)")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Endpoints for issue activity/search and fetch issue activity details  # noqa: E501

        Retrieve details of a specific activity.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.retrieve_work_item_activity_with_http_info(issue_id, pk, project_id, slug, cursor, expand, fields, order_by, per_page, async_req=True)
        >>> result = thread.get()

        :param issue_id: Issue ID (required)
        :type issue_id: str
        :param pk: Activity ID (required)
        :type pk: str
        :param project_id: Project ID (required)
        :type project_id: str
        :param slug: Workspace slug (required)
        :type slug: str
        :param cursor: Pagination cursor for getting next set of results
        :type cursor: str
        :param expand: Comma-separated list of related fields to expand in response
        :type expand: str
        :param fields: Comma-separated list of fields to include in response
        :type fields: str
        :param order_by: Field to order results by. Prefix with '-' for descending order
        :type order_by: str
        :param per_page: Number of results per page (default: 20, max: 100)
        :type per_page: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PaginatedIssueActivityDetailResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'issue_id',
            'pk',
            'project_id',
            'slug',
            'cursor',
            'expand',
            'fields',
            'order_by',
            'per_page'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method retrieve_work_item_activity" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['issue_id'] is not None:
            _path_params['issue_id'] = _params['issue_id']

        if _params['pk'] is not None:
            _path_params['pk'] = _params['pk']

        if _params['project_id'] is not None:
            _path_params['project_id'] = _params['project_id']

        if _params['slug'] is not None:
            _path_params['slug'] = _params['slug']


        # process the query parameters
        _query_params = []
        if _params.get('cursor') is not None:  # noqa: E501
            _query_params.append(('cursor', _params['cursor']))

        if _params.get('expand') is not None:  # noqa: E501
            _query_params.append(('expand', _params['expand']))

        if _params.get('fields') is not None:  # noqa: E501
            _query_params.append(('fields', _params['fields']))

        if _params.get('order_by') is not None:  # noqa: E501
            _query_params.append(('order_by', _params['order_by']))

        if _params.get('per_page') is not None:  # noqa: E501
            _query_params.append(('per_page', _params['per_page']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2Authentication', 'OAuth2Authentication']  # noqa: E501

        _response_types_map = {
            '401': None,
            '403': None,
            '404': None,
            '200': "PaginatedIssueActivityDetailResponse",
            '400': None,
        }

        return self.api_client.call_api(
            '/api/v1/workspaces/{slug}/projects/{project_id}/issues/{issue_id}/activities/{pk}/', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
