from typing import overload
import abc
import datetime
import typing

import QuantConnect
import QuantConnect.Data
import QuantConnect.Data.Market
import QuantConnect.Data.UniverseSelection
import QuantConnect.DataSource
import QuantConnect.Orders
import QuantConnect.Util
import System
import System.Collections.Generic

JsonConverter = typing.Any
QuantConnect_DataSource_BrainStockRanking3Day = typing.Any
QuantConnect_DataSource_BrainStockRanking2Day = typing.Any
QuantConnect_DataSource_BrainStockRanking5Day = typing.Any
QuantConnect_DataSource_BrainCompanyFilingLanguageMetricsUniverse10K = typing.Any
QuantConnect_DataSource_BrainSentimentIndicator30Day = typing.Any
QuantConnect_DataSource_BrainStockRanking21Day = typing.Any
QuantConnect_DataSource_BrainCompanyFilingLanguageMetricsAll = typing.Any
QuantConnect_DataSource_BrainSentimentIndicator7Day = typing.Any
QuantConnect_DataSource_BrainStockRanking10Day = typing.Any
QuantConnect_DataSource_BrainCompanyFilingLanguageMetricsUniverseAll = typing.Any
QuantConnect_DataSource_BrainCompanyFilingLanguageMetrics10K = typing.Any
IsoDateTimeConverter = typing.Any

QuantConnect_DataSource_BrainStockRankingBase_T = typing.TypeVar("QuantConnect_DataSource_BrainStockRankingBase_T")
QuantConnect_DataSource_BrainCompanyFilingLanguageMetricsBase_T = typing.TypeVar("QuantConnect_DataSource_BrainCompanyFilingLanguageMetricsBase_T")
QuantConnect_DataSource_BrainCompanyFilingLanguageMetricsUniverse_T = typing.TypeVar("QuantConnect_DataSource_BrainCompanyFilingLanguageMetricsUniverse_T")
QuantConnect_DataSource_BrainSentimentIndicatorBase_T = typing.TypeVar("QuantConnect_DataSource_BrainSentimentIndicatorBase_T")


class QuiverWikipediaUniverse(QuantConnect.Data.BaseData):
    """Universe Selection helper class for QuiverWikipedia dataset"""

    @property
    def Date(self) -> datetime.datetime:
        """The date of the Page View count"""
        ...

    @Date.setter
    def Date(self, value: datetime.datetime):
        """The date of the Page View count"""
        ...

    @property
    def PageViews(self) -> typing.Optional[float]:
        """The company's Wikipedia Page Views on the given date"""
        ...

    @PageViews.setter
    def PageViews(self, value: typing.Optional[float]):
        """The company's Wikipedia Page Views on the given date"""
        ...

    @property
    def WeekPercentChange(self) -> typing.Optional[float]:
        """
        The view count % change over the week prior to the date.
        Represented as a whole number (e.g. 100% = 100.0)
        """
        ...

    @WeekPercentChange.setter
    def WeekPercentChange(self, value: typing.Optional[float]):
        """
        The view count % change over the week prior to the date.
        Represented as a whole number (e.g. 100% = 100.0)
        """
        ...

    @property
    def MonthPercentChange(self) -> typing.Optional[float]:
        """
        The view count % change over the month prior to the date
        Represented as a whole number (e.g. 100% = 100.0)
        """
        ...

    @MonthPercentChange.setter
    def MonthPercentChange(self, value: typing.Optional[float]):
        """
        The view count % change over the month prior to the date
        Represented as a whole number (e.g. 100% = 100.0)
        """
        ...

    @property
    def EndTime(self) -> datetime.datetime:
        """The time the data point ends at and becomes available to the algorithm"""
        ...

    @EndTime.setter
    def EndTime(self, value: datetime.datetime):
        """The time the data point ends at and becomes available to the algorithm"""
        ...

    def GetSource(self, config: QuantConnect.Data.SubscriptionDataConfig, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.SubscriptionDataSource:
        """
        Return the URL string source of the file. This will be converted to a stream
        
        :param config: Configuration object
        :param date: Date of this source file
        :param isLiveMode: true if we're in live mode, false for backtesting mode
        :returns: String URL of source file.
        """
        ...

    def Reader(self, config: QuantConnect.Data.SubscriptionDataConfig, line: str, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.BaseData:
        """
        Parses the data from the line provided and loads it into LEAN
        
        :param config: Subscription configuration
        :param line: Line of data
        :param date: Date
        :param isLiveMode: Is live mode
        :returns: New instance.
        """
        ...


class QuiverWikipedia(QuantConnect.Data.BaseData):
    """Wikipedia Page Views for the specified company"""

    DataSourceId: int
    """Data source ID"""

    @property
    def Date(self) -> datetime.datetime:
        """The date of the Page View count"""
        ...

    @Date.setter
    def Date(self, value: datetime.datetime):
        """The date of the Page View count"""
        ...

    @property
    def PageViews(self) -> typing.Optional[float]:
        """The company's Wikipedia Page Views on the given date"""
        ...

    @PageViews.setter
    def PageViews(self, value: typing.Optional[float]):
        """The company's Wikipedia Page Views on the given date"""
        ...

    @property
    def WeekPercentChange(self) -> typing.Optional[float]:
        """
        The view count % change over the week prior to the date.
        Represented as a whole number (e.g. 100% = 100.0)
        """
        ...

    @WeekPercentChange.setter
    def WeekPercentChange(self, value: typing.Optional[float]):
        """
        The view count % change over the week prior to the date.
        Represented as a whole number (e.g. 100% = 100.0)
        """
        ...

    @property
    def MonthPercentChange(self) -> typing.Optional[float]:
        """
        The view count % change over the month prior to the date
        Represented as a whole number (e.g. 100% = 100.0)
        """
        ...

    @MonthPercentChange.setter
    def MonthPercentChange(self, value: typing.Optional[float]):
        """
        The view count % change over the month prior to the date
        Represented as a whole number (e.g. 100% = 100.0)
        """
        ...

    @property
    def EndTime(self) -> datetime.datetime:
        """The time the data point ends at and becomes available to the algorithm"""
        ...

    @EndTime.setter
    def EndTime(self, value: datetime.datetime):
        """The time the data point ends at and becomes available to the algorithm"""
        ...

    @overload
    def __init__(self) -> None:
        """Required for successful Json.NET deserialization"""
        ...

    @overload
    def __init__(self, csvLine: str) -> None:
        """
        Creates a new instance of QuiverWikipedia from a CSV line
        
        :param csvLine: CSV line
        """
        ...

    def DataTimeZone(self) -> typing.Any:
        """
        Specifies the data time zone for this data type. This is useful for custom data types
        
        :returns: The DateTimeZone of this data type.
        """
        ...

    def GetSource(self, config: QuantConnect.Data.SubscriptionDataConfig, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.SubscriptionDataSource:
        """
        Return the Subscription Data Source gained from the URL
        
        :param config: Configuration object
        :param date: Date of this source file
        :param isLiveMode: true if we're in live mode, false for backtesting mode
        :returns: Subscription Data Source.
        """
        ...

    def Reader(self, config: QuantConnect.Data.SubscriptionDataConfig, line: str, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.BaseData:
        """
        Reader converts each line of the data source into BaseData objects.
        
        :param config: Subscription data config setup object
        :param line: Content of the source document
        :param date: Date of the requested data
        :param isLiveMode: true if we're in live mode, false for backtesting mode
        :returns: Quiver Wikipedia object.
        """
        ...

    def RequiresMapping(self) -> bool:
        """
        Indicates if there is support for mapping
        
        :returns: True indicates mapping should be used.
        """
        ...

    def ToString(self) -> str:
        """Formats a string with the Quiver Wikipedia information."""
        ...


class TradingEconomicsEventFilter(System.Object):
    """Provides methods to filter and standardize Trading Economics calendar event names."""

    @staticmethod
    def FilterEvent(eventName: str) -> str:
        """
        Convert and normalizes the Trading Economics calendar "Event" field.
        
        :param eventName: Raw event name
        :returns: Event name normalized.
        """
        ...


class TradingEconomics(System.Object):
    """TradingEconomics static class contains shortcut definitions of major Trading Economics Indicators available"""

    class Indicator(System.Object):
        """Indicator group"""

        class Afghanistan(System.Object):
            """This class has no documentation."""

            Currency: str = "USDAFN"
            """Afghanistan Currency"""

        class Albania(System.Object):
            """This class has no documentation."""

            Currency: str = "USDALL"
            """Albania Currency"""

        class Algeria(System.Object):
            """This class has no documentation."""

            Currency: str = "USDDZD"
            """Algeria Currency"""

        class Angola(System.Object):
            """This class has no documentation."""

            Currency: str = "USDAOA"
            """Angola Currency"""

        class Argentina(System.Object):
            """This class has no documentation."""

            InterestRate: str = "APDR1T"
            """Argentina Interest Rate"""

            DepositInterestRate: str = "ARGFRINRDPST"
            """Argentina Deposit Interest Rate"""

            StockMarket: str = "MERVAL"
            """Argentina Stock Market"""

            Currency: str = "USDARS"
            """Argentina Currency"""

        class Armenia(System.Object):
            """This class has no documentation."""

            Currency: str = "USDAMD"
            """Armenia Currency"""

        class Australia(System.Object):
            """This class has no documentation."""

            StockMarket: str = "AS51"
            """Australia Stock Market"""

            Currency: str = "AUDUSD"
            """Australia Currency"""

            TwoYearNoteYield: str = "AUSTRALIA2YNY"
            """Australia 2 Year Note Yield"""

            CentralBankBalanceSheet: str = "AUSTRALIACENBANBALSH"
            """Australia Central Bank Balance Sheet"""

            InflationExpectations: str = "AUSTRALIAINFEXP"
            """Australia Inflation Expectations"""

            GovernmentBond10y: str = "GACGB10"
            """Australia Government Bond 10Y"""

            ConsumerConfidence: str = "WMCCCONPCT"
            """Australia Consumer Confidence"""

        class Austria(System.Object):
            """This class has no documentation."""

            StockMarket: str = "ATX"
            """Austria Stock Market"""

            Currency: str = "EURUSD"
            """Austria Currency"""

            GovernmentBond10y: str = "GAGB10YR"
            """Austria Government Bond 10Y"""

        class Bahamas(System.Object):
            """This class has no documentation."""

            Currency: str = "USDBSD"
            """Bahamas Currency"""

        class Bahrain(System.Object):
            """This class has no documentation."""

            InterbankRate: str = "BAHRAININTRAT"
            """Bahrain Interbank Rate"""

            StockMarket: str = "BHSEEI"
            """Bahrain Stock Market"""

            Currency: str = "USDBHD"
            """Bahrain Currency"""

        class Bangladesh(System.Object):
            """This class has no documentation."""

            InterestRate: str = "BANGLADESHINTRATE"
            """Bangladesh Interest Rate"""

            StockMarket: str = "DHAKA"
            """Bangladesh Stock Market"""

            Currency: str = "USDBDT"
            """Bangladesh Currency"""

        class Belarus(System.Object):
            """This class has no documentation."""

            Currency: str = "USDBYR"
            """Belarus Currency"""

        class Belgium(System.Object):
            """This class has no documentation."""

            StockMarket: str = "BEL20"
            """Belgium Stock Market"""

            GovernmentBond10y: str = "GBGB10YR"
            """Belgium Government Bond 10Y"""

        class Bermuda(System.Object):
            """This class has no documentation."""

            StockMarket: str = "BSX"
            """Bermuda Stock Market"""

        class Bolivia(System.Object):
            """This class has no documentation."""

            Currency: str = "USDBOB"
            """Bolivia Currency"""

        class BosniaAndHerzegovina(System.Object):
            """This class has no documentation."""

            StockMarket: str = "SASX10"
            """BosniaAndHerzegovina Stock Market"""

            Currency: str = "USDBIH"
            """BosniaAndHerzegovina Currency"""

        class Botswana(System.Object):
            """This class has no documentation."""

            StockMarket: str = "BGSMDC"
            """Botswana Stock Market"""

            Currency: str = "USDBWP"
            """Botswana Currency"""

        class Brazil(System.Object):
            """This class has no documentation."""

            CashReserveRatio: str = "BRAZILCASRESRAT"
            """Brazil Cash Reserve Ratio"""

            InterbankRate: str = "BRAZILINTRAT"
            """Brazil Interbank Rate"""

            MinimumWages: str = "BRAZILMINWAG"
            """Brazil Minimum Wages"""

            GovernmentBond10y: str = "GEBU10Y"
            """Brazil Government Bond 10Y"""

            StockMarket: str = "IBOV"
            """Brazil Stock Market"""

            Currency: str = "USDBRL"
            """Brazil Currency"""

        class Brunei(System.Object):
            """This class has no documentation."""

            Currency: str = "USDBND"
            """Brunei Currency"""

        class Bulgaria(System.Object):
            """This class has no documentation."""

            GovernmentBond10y: str = "BULGARIAGOVBON10Y"
            """Bulgaria Government Bond 10Y"""

            InterbankRate: str = "BULGARIAINTRAT"
            """Bulgaria Interbank Rate"""

            StockMarket: str = "SOFIX"
            """Bulgaria Stock Market"""

            Currency: str = "USDBGN"
            """Bulgaria Currency"""

        class Burundi(System.Object):
            """This class has no documentation."""

            Currency: str = "USDBIF"
            """Burundi Currency"""

        class Cambodia(System.Object):
            """This class has no documentation."""

            Currency: str = "USDKHR"
            """Cambodia Currency"""

        class Canada(System.Object):
            """This class has no documentation."""

            BankLendingRate: str = "CANADABANLENRAT"
            """Canada Bank Lending Rate"""

            InterbankRate: str = "CANADAINTRAT"
            """Canada Interbank Rate"""

            DepositInterestRate: str = "CANFRINRDPST"
            """Canada Deposit Interest Rate"""

            InterestRate: str = "CCLR"
            """Canada Interest Rate"""

            GovernmentBond10y: str = "GCAN10YR"
            """Canada Government Bond 10Y"""

            ConsumerConfidence: str = "OECAI001"
            """Canada Consumer Confidence"""

            StockMarket: str = "SPTSX"
            """Canada Stock Market"""

            Currency: str = "USDCAD"
            """Canada Currency"""

        class CapeVerde(System.Object):
            """This class has no documentation."""

            Currency: str = "USDCVE"
            """CapeVerde Currency"""

        class CaymanIslands(System.Object):
            """This class has no documentation."""

            Currency: str = "USDKYD"
            """CaymanIslands Currency"""

        class Chile(System.Object):
            """This class has no documentation."""

            GovernmentBond10y: str = "CHILEGOVBON10Y"
            """Chile Government Bond 10y"""

            InterbankRate: str = "CHILEINTRAT"
            """Chile Interbank Rate"""

            StockMarket: str = "IGPA"
            """Chile Stock Market"""

            Currency: str = "USDCLP"
            """Chile Currency"""

        class China(System.Object):
            """This class has no documentation."""

            CashReserveRatio: str = "CHINACASRESRAT"
            """China Cash Reserve Ratio"""

            InterbankRate: str = "CHINAINTRAT"
            """China Interbank Rate"""

            ReverseRepoRate: str = "CHINAREVREPRAT"
            """China Reverse Repo Rate"""

            GovernmentBond10y: str = "GCNY10YR"
            """China Government Bond 10Y"""

            StockMarket: str = "SHCOMP"
            """China Stock Market"""

            Currency: str = "USDCNY"
            """China Currency"""

        class Colombia(System.Object):
            """This class has no documentation."""

            GovernmentBond10y: str = "COGR10Y"
            """Colombia Government Bond 10Y"""

            StockMarket: str = "COLCAP"
            """Colombia Stock Market"""

            InterbankRate: str = "COLOMBIAINTRAT"
            """Colombia Interbank Rate"""

            Currency: str = "USDCOP"
            """Colombia Currency"""

        class Commodity(System.Object):
            """This class has no documentation."""

            BalticExchangeDryIndex: str = "BALTIC"
            """Commodity Baltic Exchange Dry Index"""

            Beef: str = "BEEF"
            """Commodity Beef"""

            Bitumen: str = "BIT"
            """Commodity Bitumen"""

            Corn: str = "C-1"
            """Commodity Corn"""

            Cocoa: str = "CC1"
            """Commodity Cocoa"""

            Cheese: str = "CHEESE1"
            """Commodity Cheese"""

            CrudeOil: str = "CL1"
            """Commodity Crude oil"""

            BrentCrudeOil: str = "CO1"
            """Commodity Brent crude oil"""

            Coal: str = "COAL"
            """Commodity Coal"""

            Cobalt: str = "COBALT"
            """Commodity Cobalt"""

            CrbCommodityIndex: str = "CRB"
            """Commodity CRB Commodity Index"""

            Cotton: str = "CT1"
            """Commodity Cotton"""

            Ethanol: str = "DL1"
            """Commodity Ethanol"""

            FeederCattle: str = "FC1"
            """Commodity Feeder Cattle"""

            GsciCommodityIndex: str = "GSCI"
            """Commodity GSCI Commodity Index"""

            Copper: str = "HG1"
            """Commodity Copper"""

            HeatingOil: str = "HO1"
            """Commodity Heating oil"""

            ManganeseOre: str = "IMR"
            """Commodity Manganese Ore"""

            IronOre: str = "IRONORE"
            """Commodity Iron Ore"""

            Rubber: str = "JN1"
            """Commodity Rubber"""

            OrangeJuice: str = "JO1"
            """Commodity Orange Juice"""

            Coffee: str = "KC1"
            """Commodity Coffee"""

            Lumber: str = "LB1"
            """Commodity Lumber"""

            LiveCattle: str = "LC1"
            """Commodity Live Cattle"""

            LeanHogs: str = "LH1"
            """Commodity Lean Hogs"""

            Lithium: str = "LITHIUM"
            """Commodity Lithium"""

            Aluminum: str = "LMAHDS03"
            """Commodity Aluminum"""

            LmeIndex: str = "LME"
            """Commodity LME Index"""

            Molybdenum: str = "LMMLDS03"
            """Commodity Molybdenum"""

            Nickel: str = "LMNIDS03"
            """Commodity Nickel"""

            Lead: str = "LMPBDS03"
            """Commodity Lead"""

            Tin: str = "LMSNDS03"
            """Commodity Tin"""

            Zinc: str = "LMZSDS03"
            """Commodity Zinc"""

            Milk: str = "MILK"
            """Commodity Milk"""

            Naphtha: str = "NAPHTHA"
            """Commodity Naphtha"""

            NaturalGas: str = "NG1"
            """Commodity Natural gas"""

            Oat: str = "O-1"
            """Commodity Oat"""

            Wool: str = "OL1"
            """Commodity Wool"""

            PalmOil: str = "PALMOIL"
            """Commodity Palm Oil"""

            Propane: str = "PROPANE"
            """Commodity Propane"""

            Rhodium: str = "RHODIUM"
            """Commodity RHODIUM"""

            Rice: str = "RR1"
            """Commodity Rice"""

            Canola: str = "RS1"
            """Commodity Canola"""

            Soybeans: str = "S-1"
            """Commodity Soybeans"""

            Sugar: str = "SB1"
            """Commodity Sugar"""

            SodaAsh: str = "SODASH"
            """Commodity Soda Ash"""

            Neodymium: str = "SREMNDM"
            """Commodity Neodymium"""

            Steel: str = "STEEL"
            """Commodity Steel"""

            IronOre62PercentFe: str = "TIOC"
            """Commodity Iron Ore 62% FE"""

            Uranium: str = "URANIUM"
            """Commodity Uranium"""

            Wheat: str = "W-1"
            """Commodity Wheat"""

            Silver: str = "XAGUSD"
            """Commodity Silver"""

            Gold: str = "XAUUSD"
            """Commodity Gold"""

            Gasoline: str = "XB1"
            """Commodity Gasoline"""

            Palladium: str = "XPDUSD"
            """Commodity Palladium"""

            Platinum: str = "XPTUSD"
            """Commodity Platinum"""

        class Comoros(System.Object):
            """This class has no documentation."""

            Currency: str = "USDKMF"
            """Comoros Currency"""

        class Congo(System.Object):
            """This class has no documentation."""

            Currency: str = "USDCDF"
            """Congo Currency"""

        class CostaRica(System.Object):
            """This class has no documentation."""

            StockMarket: str = "CRSMBCT"
            """CostaRica Stock Market"""

            Currency: str = "USDCRC"
            """CostaRica Currency"""

        class Croatia(System.Object):
            """This class has no documentation."""

            StockMarket: str = "CRO"
            """Croatia Stock Market"""

            GovernmentBond10y: str = "CROATIAGOVD10Y"
            """Croatia Government Bond 10Y"""

            InterbankRate: str = "CROATIAINTRAT"
            """Croatia Interbank Rate"""

            Currency: str = "USDHRV"
            """Croatia Currency"""

        class Cuba(System.Object):
            """This class has no documentation."""

            Currency: str = "USDCUC"
            """Cuba Currency"""

        class Cyprus(System.Object):
            """This class has no documentation."""

            StockMarket: str = "CYSMMAPA"
            """Cyprus Stock Market"""

        class CzechRepublic(System.Object):
            """This class has no documentation."""

            InterbankRate: str = "CZECHREPUINTRAT"
            """CzechRepublic Interbank Rate"""

            GovernmentBond10y: str = "CZGB10YR"
            """CzechRepublic Government Bond 10Y"""

            StockMarket: str = "PX"
            """CzechRepublic Stock Market"""

            Currency: str = "USDCZK"
            """CzechRepublic Currency"""

        class Denmark(System.Object):
            """This class has no documentation."""

            InterbankRate: str = "DENMARKINTRAT"
            """Denmark Interbank Rate"""

            GovernmentBond10y: str = "GDGB10YR"
            """Denmark Government Bond 10Y"""

            StockMarket: str = "KFX"
            """Denmark Stock Market"""

            Currency: str = "USDDKK"
            """Denmark Currency"""

        class Djibouti(System.Object):
            """This class has no documentation."""

            Currency: str = "USDDJF"
            """Djibouti Currency"""

        class DominicanRepublic(System.Object):
            """This class has no documentation."""

            Currency: str = "USDDOP"
            """DominicanRepublic Currency"""

        class Ecuador(System.Object):
            """This class has no documentation."""

            StockMarket: str = "ECU"
            """Ecuador Stock Market"""

            InterbankRate: str = "ECUADORINTRATI"
            """Ecuador Interbank Rate"""

        class Egypt(System.Object):
            """This class has no documentation."""

            StockMarket: str = "CASE"
            """Egypt Stock Market"""

            InterbankRate: str = "EGYPTINTRAT"
            """Egypt Interbank Rate"""

            InterestRate: str = "EGYPTINTRATE"
            """Egypt Interest Rate"""

            LendingRate: str = "EGYPTLENRAT"
            """Egypt Lending Rate"""

            Currency: str = "USDEGP"
            """Egypt Currency"""

        class Eritrea(System.Object):
            """This class has no documentation."""

            Currency: str = "USDERN"
            """Eritrea Currency"""

        class Estonia(System.Object):
            """This class has no documentation."""

            StockMarket: str = "TALSE"
            """Estonia Stock Market"""

        class Ethiopia(System.Object):
            """This class has no documentation."""

            Currency: str = "USDETB"
            """Ethiopia Currency"""

        class EuroArea(System.Object):
            """This class has no documentation."""

            InterbankRate: str = "EMUEVOLVINTRAT"
            """EuroArea Interbank Rate"""

            LendingRate: str = "EUROAREALENRAT"
            """EuroArea Lending Rate"""

            ZewEconomicSentimentIndex: str = "EUROAREAZEWECOSENIND"
            """EuroArea Zew Economic Sentiment Index"""

            StockMarket: str = "SX5E"
            """EuroArea Stock Market"""

        class Fiji(System.Object):
            """This class has no documentation."""

            Currency: str = "USDFJD"
            """Fiji Currency"""

        class Finland(System.Object):
            """This class has no documentation."""

            InterbankRate: str = "FINLANDINTRAT"
            """Finland Interbank Rate"""

            GovernmentBond10y: str = "GFIN10YR"
            """Finland Government Bond 10Y"""

            StockMarket: str = "HEX25"
            """Finland Stock Market"""

        class France(System.Object):
            """This class has no documentation."""

            StockMarket: str = "CAC"
            """France Stock Market"""

            GovernmentBond10y: str = "GFRN10"
            """France Government Bond 10Y"""

        class Gambia(System.Object):
            """This class has no documentation."""

            Currency: str = "USDGMD"
            """Gambia Currency"""

        class Georgia(System.Object):
            """This class has no documentation."""

            Currency: str = "USDGEL"
            """Georgia Currency"""

        class Germany(System.Object):
            """This class has no documentation."""

            StockMarket: str = "DAX"
            """Germany Stock Market"""

            GovernmentBond10y: str = "GDBR10"
            """Germany Government Bond 10Y"""

            TwoYearNoteYield: str = "GERMANY2YNY"
            """Germany 2 Year Note Yield"""

            ZewEconomicSentimentIndex: str = "GERMANYZEWECOSENIND"
            """Germany Zew Economic Sentiment Index"""

            ConsumerConfidence: str = "GRCCI"
            """Germany Consumer Confidence"""

        class Ghana(System.Object):
            """This class has no documentation."""

            StockMarket: str = "GGSECI"
            """Ghana Stock Market"""

            Currency: str = "USDGHS"
            """Ghana Currency"""

        class Greece(System.Object):
            """This class has no documentation."""

            StockMarket: str = "ASE"
            """Greece Stock Market"""

            GovernmentBond10y: str = "GGGB10YR"
            """Greece Government Bond 10Y"""

            TwoYearNoteYield: str = "GREECE2YNY"
            """Greece 2 Year Note Yield"""

        class Guatemala(System.Object):
            """This class has no documentation."""

            Currency: str = "USDGTQ"
            """Guatemala Currency"""

        class Guinea(System.Object):
            """This class has no documentation."""

            Currency: str = "USDGNF"
            """Guinea Currency"""

        class Guyana(System.Object):
            """This class has no documentation."""

            Currency: str = "USDGYD"
            """Guyana Currency"""

        class Haiti(System.Object):
            """This class has no documentation."""

            Currency: str = "USDHTG"
            """Haiti Currency"""

        class Honduras(System.Object):
            """This class has no documentation."""

            InterestRate: str = "HONURASINTTRATE"
            """Honduras Interest Rate"""

            Currency: str = "USDHNL"
            """Honduras Currency"""

        class HongKong(System.Object):
            """This class has no documentation."""

            GovernmentBond10y: str = "GHKGB10Y"
            """HongKong Government Bond 10Y"""

            InterbankRate: str = "HONGKONGINTRAT"
            """HongKong Interbank Rate"""

            StockMarket: str = "HSI"
            """HongKong Stock Market"""

            Currency: str = "USDHKD"
            """HongKong Currency"""

        class Hungary(System.Object):
            """This class has no documentation."""

            StockMarket: str = "BUX"
            """Hungary Stock Market"""

            GovernmentBond10y: str = "GHGB10YR"
            """Hungary Government Bond 10Y"""

            InterbankRate: str = "HUNGARYINTRAT"
            """Hungary Interbank Rate"""

            Currency: str = "USDHUF"
            """Hungary Currency"""

        class Iceland(System.Object):
            """This class has no documentation."""

            GovernmentBond10y: str = "ICELANDGOVBON10Y"
            """Iceland Government Bond 10y"""

            InterbankRate: str = "ICELANDINTRAT"
            """Iceland Interbank Rate"""

            StockMarket: str = "ICEXI"
            """Iceland Stock Market"""

            Currency: str = "USDISK"
            """Iceland Currency"""

        class India(System.Object):
            """This class has no documentation."""

            GovernmentBond10y: str = "GIND10YR"
            """India Government Bond 10Y"""

            CashReserveRatio: str = "INDIACASRESRAT"
            """India Cash Reserve Ratio"""

            InterestRate: str = "RSPOYLD"
            """India Interest Rate"""

            StockMarket: str = "SENSEX"
            """India Stock Market"""

            Currency: str = "USDINR"
            """India Currency"""

        class Indonesia(System.Object):
            """This class has no documentation."""

            GovernmentBond10y: str = "GIDN10YR"
            """Indonesia Government Bond 10Y"""

            InterbankRate: str = "INDONESIAINTRAT"
            """Indonesia Interbank Rate"""

            StockMarket: str = "JCI"
            """Indonesia Stock Market"""

            Currency: str = "USDIDR"
            """Indonesia Currency"""

        class Iraq(System.Object):
            """This class has no documentation."""

            Currency: str = "USDIQD"
            """Iraq Currency"""

        class Ireland(System.Object):
            """This class has no documentation."""

            GovernmentBond10y: str = "GIGB10YR"
            """Ireland Government Bond 10Y"""

            StockMarket: str = "ISEQ"
            """Ireland Stock Market"""

        class Israel(System.Object):
            """This class has no documentation."""

            GovernmentBond10y: str = "GISR10YR"
            """Israel Government Bond 10Y"""

            InterestRate: str = "ISBRATE"
            """Israel Interest Rate"""

            InterbankRate: str = "ISRAELINTRAT"
            """Israel Interbank Rate"""

            StockMarket: str = "TA-100"
            """Israel Stock Market"""

            Currency: str = "USDILS"
            """Israel Currency"""

        class Italy(System.Object):
            """This class has no documentation."""

            StockMarket: str = "FTSEMIB"
            """Italy Stock Market"""

            GovernmentBond10y: str = "GBTPGR10"
            """Italy Government Bond 10Y"""

            TwoYearNoteYield: str = "ITALY2YNY"
            """Italy 2 Year Note Yield"""

        class IvoryCoast(System.Object):
            """This class has no documentation."""

            Currency: str = "USDXOF"
            """IvoryCoast Currency"""

        class Jamaica(System.Object):
            """This class has no documentation."""

            InterestRate: str = "JAMAICAINTTRATE"
            """Jamaica Interest Rate"""

            StockMarket: str = "JMSMX"
            """Jamaica Stock Market"""

            Currency: str = "USDJMD"
            """Jamaica Currency"""

        class Japan(System.Object):
            """This class has no documentation."""

            GovernmentBond10y: str = "GJGB10"
            """Japan Government Bond 10Y"""

            TwoYearNoteYield: str = "JAPAN2YNY"
            """Japan 2 Year Note Yield"""

            InterbankRate: str = "JAPANINTRAT"
            """Japan Interbank Rate"""

            DepositInterestRate: str = "JPNFRINRDPST"
            """Japan Deposit Interest Rate"""

            StockMarket: str = "NKY"
            """Japan Stock Market"""

            Currency: str = "USDJPY"
            """Japan Currency"""

        class Jordan(System.Object):
            """This class has no documentation."""

            StockMarket: str = "JOSMGNFF"
            """Jordan Stock Market"""

            Currency: str = "USDJOR"
            """Jordan Currency"""

        class Kazakhstan(System.Object):
            """This class has no documentation."""

            InterbankRate: str = "KAZAKHSTANINTRAT"
            """Kazakhstan Interbank Rate"""

            InterestRate: str = "KAZAKHSTANINTRATE"
            """Kazakhstan Interest Rate"""

            StockMarket: str = "KZKAK"
            """Kazakhstan Stock Market"""

            Currency: str = "USDKZT"
            """Kazakhstan Currency"""

        class Kenya(System.Object):
            """This class has no documentation."""

            GovernmentBond10y: str = "KENYAGOVBON10Y"
            """Kenya Government Bond 10y"""

            StockMarket: str = "KNSMIDX"
            """Kenya Stock Market"""

            Currency: str = "USDKES"
            """Kenya Currency"""

        class Kuwait(System.Object):
            """This class has no documentation."""

            InterbankRate: str = "KUWAITINTRAT"
            """Kuwait Interbank Rate"""

            Currency: str = "USDKWD"
            """Kuwait Currency"""

        class Kyrgyzstan(System.Object):
            """This class has no documentation."""

            InterestRate: str = "KYRSTANINTTRATE"
            """Kyrgyzstan Interest Rate"""

            Currency: str = "USDKGS"
            """Kyrgyzstan Currency"""

        class Laos(System.Object):
            """This class has no documentation."""

            StockMarket: str = "LSXC"
            """Laos Stock Market"""

            Currency: str = "USDLAK"
            """Laos Currency"""

        class Latvia(System.Object):
            """This class has no documentation."""

            GovernmentBond10y: str = "LATVIAGOVBON10Y"
            """Latvia Government Bond 10y"""

            InterbankRate: str = "LATVIAINTRAT"
            """Latvia Interbank Rate"""

            StockMarket: str = "RIGSE"
            """Latvia Stock Market"""

        class Lebanon(System.Object):
            """This class has no documentation."""

            StockMarket: str = "BLOM"
            """Lebanon Stock Market"""

            Currency: str = "USDLBP"
            """Lebanon Currency"""

        class Lesotho(System.Object):
            """This class has no documentation."""

            Currency: str = "USDLSL"
            """Lesotho Currency"""

        class Liberia(System.Object):
            """This class has no documentation."""

            Currency: str = "USDLRD"
            """Liberia Currency"""

        class Libya(System.Object):
            """This class has no documentation."""

            Currency: str = "USDLYD"
            """Libya Currency"""

        class Lithuania(System.Object):
            """This class has no documentation."""

            GovernmentBond10y: str = "LITHUANIAGOVBON10Y"
            """Lithuania Government Bond 10y"""

            StockMarket: str = "VILSE"
            """Lithuania Stock Market"""

        class Luxembourg(System.Object):
            """This class has no documentation."""

            StockMarket: str = "LUXXX"
            """Luxembourg Stock Market"""

        class Macau(System.Object):
            """This class has no documentation."""

            InterbankRate: str = "MACAOINTRAT"
            """Macau Interbank Rate"""

            Currency: str = "USDMOP"
            """Macau Currency"""

        class Macedonia(System.Object):
            """This class has no documentation."""

            StockMarket: str = "MBI"
            """Macedonia Stock Market"""

            Currency: str = "USDMKD"
            """Macedonia Currency"""

        class Madagascar(System.Object):
            """This class has no documentation."""

            Currency: str = "USDMGA"
            """Madagascar Currency"""

        class Malawi(System.Object):
            """This class has no documentation."""

            Currency: str = "USDMWK"
            """Malawi Currency"""

        class Malaysia(System.Object):
            """This class has no documentation."""

            StockMarket: str = "FBMKLCI"
            """Malaysia Stock Market"""

            InterbankRate: str = "MALAYSIAINTRAT"
            """Malaysia Interbank Rate"""

            InterestRate: str = "MAOPRATE"
            """Malaysia Interest Rate"""

            GovernmentBond10y: str = "MGIY10Y"
            """Malaysia Government Bond 10Y"""

            Currency: str = "USDMYR"
            """Malaysia Currency"""

        class Maldives(System.Object):
            """This class has no documentation."""

            Currency: str = "USDMVR"
            """Maldives Currency"""

        class Malta(System.Object):
            """This class has no documentation."""

            StockMarket: str = "MALTEX"
            """Malta Stock Market"""

        class Mauritius(System.Object):
            """This class has no documentation."""

            StockMarket: str = "SEMDEX"
            """Mauritius Stock Market"""

            Currency: str = "USDMUR"
            """Mauritius Currency"""

        class Mexico(System.Object):
            """This class has no documentation."""

            GovernmentBond10y: str = "GMXN10YR"
            """Mexico Government Bond 10Y"""

            StockMarket: str = "MEXBOL"
            """Mexico Stock Market"""

            InterestRate: str = "MXONBR"
            """Mexico Interest Rate"""

            Currency: str = "USDMXN"
            """Mexico Currency"""

        class Moldova(System.Object):
            """This class has no documentation."""

            Currency: str = "USDMDL"
            """Moldova Currency"""

        class Mongolia(System.Object):
            """This class has no documentation."""

            StockMarket: str = "MSETOP"
            """Mongolia Stock Market"""

            Currency: str = "USDMNT"
            """Mongolia Currency"""

        class Morocco(System.Object):
            """This class has no documentation."""

            StockMarket: str = "MOSENEW"
            """Morocco Stock Market"""

            Currency: str = "USDMAD"
            """Morocco Currency"""

        class Mozambique(System.Object):
            """This class has no documentation."""

            Currency: str = "USDMZN"
            """Mozambique Currency"""

        class Myanmar(System.Object):
            """This class has no documentation."""

            Currency: str = "USDMMK"
            """Myanmar Currency"""

        class Namibia(System.Object):
            """This class has no documentation."""

            StockMarket: str = "FTN098"
            """Namibia Stock Market"""

            Currency: str = "USDNAD"
            """Namibia Currency"""

        class Nepal(System.Object):
            """This class has no documentation."""

            Currency: str = "USDNPR"
            """Nepal Currency"""

        class Netherlands(System.Object):
            """This class has no documentation."""

            StockMarket: str = "AEX"
            """Netherlands Stock Market"""

            GovernmentBond10y: str = "GNTH10YR"
            """Netherlands Government Bond 10Y"""

        class NewCaledonia(System.Object):
            """This class has no documentation."""

            Currency: str = "USDXPF"
            """NewCaledonia Currency"""

        class NewZealand(System.Object):
            """This class has no documentation."""

            GovernmentBond10y: str = "GNZGB10"
            """NewZealand Government Bond 10Y"""

            GlobalDairyTradePriceIndex: str = "NEWZEALANGDTPI"
            """NewZealand Global Dairy Trade Price Index"""

            Currency: str = "NZDUSD"
            """NewZealand Currency"""

            DepositInterestRate: str = "NZLFRINRDPST"
            """NewZealand Deposit Interest Rate"""

            InterestRate: str = "NZOCRS"
            """NewZealand Interest Rate"""

            StockMarket: str = "NZSE50FG"
            """NewZealand Stock Market"""

        class Nicaragua(System.Object):
            """This class has no documentation."""

            Currency: str = "USDNIO"
            """Nicaragua Currency"""

        class Nigeria(System.Object):
            """This class has no documentation."""

            StockMarket: str = "NGSEINDX"
            """Nigeria Stock Market"""

            CashReserveRatio: str = "NIGERIACASRESRAT"
            """Nigeria Cash Reserve Ratio"""

            GovernmentBond10y: str = "NIGERIAGOVBON10Y"
            """Nigeria Government Bond 10y"""

            InterbankRate: str = "NIGERIAINTRAT"
            """Nigeria Interbank Rate"""

            Currency: str = "USDNGN"
            """Nigeria Currency"""

        class NorthKorea(System.Object):
            """This class has no documentation."""

            Currency: str = "NORTHKORECUR"
            """NorthKorea Currency"""

        class Norway(System.Object):
            """This class has no documentation."""

            GovernmentBond10y: str = "GNOR10YR"
            """Norway Government Bond 10Y"""

            InterbankRate: str = "NORWAYINTRAT"
            """Norway Interbank Rate"""

            StockMarket: str = "OSEAX"
            """Norway Stock Market"""

            Currency: str = "USDNOK"
            """Norway Currency"""

        class Oman(System.Object):
            """This class has no documentation."""

            StockMarket: str = "MSM30"
            """Oman Stock Market"""

            Currency: str = "USDOMR"
            """Oman Currency"""

        class Pakistan(System.Object):
            """This class has no documentation."""

            StockMarket: str = "KSE100"
            """Pakistan Stock Market"""

            InterestRate: str = "PAPRSBP"
            """Pakistan Interest Rate"""

            GovernmentBond10y: str = "PKIB10YR"
            """Pakistan Government Bond 10Y"""

            Currency: str = "USDPKR"
            """Pakistan Currency"""

        class Panama(System.Object):
            """This class has no documentation."""

            StockMarket: str = "BVPSBVPS"
            """Panama Stock Market"""

            Currency: str = "USDPAB"
            """Panama Currency"""

        class PapuaNewGuinea(System.Object):
            """This class has no documentation."""

            Currency: str = "USDPGK"
            """PapuaNewGuinea Currency"""

        class Paraguay(System.Object):
            """This class has no documentation."""

            Currency: str = "USDPYG"
            """Paraguay Currency"""

        class Peru(System.Object):
            """This class has no documentation."""

            GovernmentBond10y: str = "GRPE10Y"
            """Peru Government Bond 10Y"""

            StockMarket: str = "IGBVL"
            """Peru Stock Market"""

            InterbankRate: str = "PERUINTRAT"
            """Peru Interbank Rate"""

            InterestRate: str = "PRRRONUS"
            """Peru Interest Rate"""

            Currency: str = "USDPEN"
            """Peru Currency"""

        class Philippines(System.Object):
            """This class has no documentation."""

            StockMarket: str = "PCOMP"
            """Philippines Stock Market"""

            GovernmentBond10y: str = "PHILIPPINEGOVBON10Y"
            """Philippines Government Bond 10y"""

            InterbankRate: str = "PHILIPPINEINTRAT"
            """Philippines Interbank Rate"""

            InterestRate: str = "PHILIPPINESINTRATE"
            """Philippines Interest Rate"""

            Currency: str = "USDPHP"
            """Philippines Currency"""

        class Poland(System.Object):
            """This class has no documentation."""

            GovernmentBond10y: str = "POGB10YR"
            """Poland Government Bond 10Y"""

            InterbankRate: str = "POLANDINTRAT"
            """Poland Interbank Rate"""

            DepositInterestRate: str = "POLFRINRDPST"
            """Poland Deposit Interest Rate"""

            Currency: str = "USDPLN"
            """Poland Currency"""

            StockMarket: str = "WIG"
            """Poland Stock Market"""

        class Portugal(System.Object):
            """This class has no documentation."""

            GovernmentBond10y: str = "GSPT10YR"
            """Portugal Government Bond 10Y"""

            TwoYearNoteYield: str = "PORTUGAL2YNY"
            """Portugal 2 Year Note Yield"""

            StockMarket: str = "PSI20"
            """Portugal Stock Market"""

        class Qatar(System.Object):
            """This class has no documentation."""

            StockMarket: str = "DSM"
            """Qatar Stock Market"""

            GovernmentBond10y: str = "QATARGOVBON10Y"
            """Qatar Government Bond 10y"""

            ReverseRepoRate: str = "QATARREVREPRAT"
            """Qatar Reverse Repo Rate"""

            Currency: str = "USDQAR"
            """Qatar Currency"""

        class Romania(System.Object):
            """This class has no documentation."""

            StockMarket: str = "BET"
            """Romania Stock Market"""

            GovernmentBond10y: str = "ROMANIAGOVBON10Y"
            """Romania Government Bond 10Y"""

            InterbankRate: str = "ROMANIAINTRAT"
            """Romania Interbank Rate"""

            Currency: str = "USDRON"
            """Romania Currency"""

        class Russia(System.Object):
            """This class has no documentation."""

            StockMarket: str = "INDEXCF"
            """Russia Stock Market"""

            GovernmentBond10y: str = "RUGE10Y"
            """Russia Government Bond 10Y"""

            CentralBankBalanceSheet: str = "RUSSIACENBANBALSHE"
            """Russia Central Bank Balance Sheet"""

            Currency: str = "USDRUB"
            """Russia Currency"""

        class Rwanda(System.Object):
            """This class has no documentation."""

            Currency: str = "USDRWF"
            """Rwanda Currency"""

        class SaoTomeAndPrincipe(System.Object):
            """This class has no documentation."""

            Currency: str = "USDSTD"
            """SaoTomeAndPrincipe Currency"""

        class SaudiArabia(System.Object):
            """This class has no documentation."""

            StockMarket: str = "SASEIDX"
            """SaudiArabia Stock Market"""

            ReverseRepoRate: str = "SAUDIARABREVREPRAT"
            """SaudiArabia Reverse Repo Rate"""

            DepositInterestRate: str = "SAUFRINRDPST"
            """SaudiArabia Deposit Interest Rate"""

            Currency: str = "USDSAR"
            """SaudiArabia Currency"""

        class Serbia(System.Object):
            """This class has no documentation."""

            StockMarket: str = "BELEX15"
            """Serbia Stock Market"""

            InterbankRate: str = "SERBIAINTRAT"
            """Serbia Interbank Rate"""

            InterestRate: str = "SERRBIAINTTRATE"
            """Serbia Interest Rate"""

            DepositInterestRate: str = "SRBFRINRDPST"
            """Serbia Deposit Interest Rate"""

            Currency: str = "USDSRB"
            """Serbia Currency"""

        class Seychelles(System.Object):
            """This class has no documentation."""

            Currency: str = "USDSCR"
            """Seychelles Currency"""

        class SierraLeone(System.Object):
            """This class has no documentation."""

            Currency: str = "USDSLL"
            """SierraLeone Currency"""

        class Singapore(System.Object):
            """This class has no documentation."""

            StockMarket: str = "FSSTI"
            """Singapore Stock Market"""

            GovernmentBond10y: str = "MASB10Y"
            """Singapore Government Bond 10Y"""

            InterbankRate: str = "SINGAPOREINTRAT"
            """Singapore Interbank Rate"""

            Currency: str = "USDSGD"
            """Singapore Currency"""

        class Slovakia(System.Object):
            """This class has no documentation."""

            StockMarket: str = "SKSM"
            """Slovakia Stock Market"""

            GovernmentBond10y: str = "SLOVAKIAGOVBON10Y"
            """Slovakia Government Bond 10y"""

        class Slovenia(System.Object):
            """This class has no documentation."""

            StockMarket: str = "SBITOP"
            """Slovenia Stock Market"""

            GovernmentBond10y: str = "SLOVENIAGOVBON10Y"
            """Slovenia Government Bond 10y"""

        class Somalia(System.Object):
            """This class has no documentation."""

            Currency: str = "USDSOS"
            """Somalia Currency"""

        class SouthAfrica(System.Object):
            """This class has no documentation."""

            GovernmentBond10y: str = "GSAB10YR"
            """SouthAfrica Government Bond 10Y"""

            StockMarket: str = "JALSH"
            """SouthAfrica Stock Market"""

            InterbankRate: str = "SOUTHAFRIINTRAT"
            """SouthAfrica Interbank Rate"""

            Currency: str = "USDZAR"
            """SouthAfrica Currency"""

        class SouthKorea(System.Object):
            """This class has no documentation."""

            GovernmentBond10y: str = "GVSK10YR"
            """SouthKorea Government Bond 10Y"""

            StockMarket: str = "KOSPI"
            """SouthKorea Stock Market"""

            InterbankRate: str = "SOUTHKOREINTRAT"
            """SouthKorea Interbank Rate"""

            Currency: str = "USDKRW"
            """SouthKorea Currency"""

        class Spain(System.Object):
            """This class has no documentation."""

            GovernmentBond10y: str = "GSPG10YR"
            """Spain Government Bond 10Y"""

            StockMarket: str = "IBEX"
            """Spain Stock Market"""

            InterbankRate: str = "SPAININTRAT"
            """Spain Interbank Rate"""

        class SriLanka(System.Object):
            """This class has no documentation."""

            StockMarket: str = "CSEALL"
            """SriLanka Stock Market"""

            InterestRate: str = "SRI-LANKAINTRATE"
            """SriLanka Interest Rate"""

            CashReserveRatio: str = "SRILANKACASRESRAT"
            """SriLanka Cash Reserve Ratio"""

            InterbankRate: str = "SRILANKAINTRAT"
            """SriLanka Interbank Rate"""

            LendingRate: str = "SRILANKALENRAT"
            """SriLanka Lending Rate"""

            Currency: str = "USDLKR"
            """SriLanka Currency"""

        class Sudan(System.Object):
            """This class has no documentation."""

            Currency: str = "USDSDG"
            """Sudan Currency"""

        class Suriname(System.Object):
            """This class has no documentation."""

            Currency: str = "USDSRD"
            """Suriname Currency"""

        class Swaziland(System.Object):
            """This class has no documentation."""

            Currency: str = "USDSZL"
            """Swaziland Currency"""

        class Sweden(System.Object):
            """This class has no documentation."""

            GovernmentBond10y: str = "GSGB10YR"
            """Sweden Government Bond 10Y"""

            StockMarket: str = "OMX"
            """Sweden Stock Market"""

            InterbankRate: str = "SWEDENINTRAT"
            """Sweden Interbank Rate"""

            Currency: str = "USDSEK"
            """Sweden Currency"""

        class Switzerland(System.Object):
            """This class has no documentation."""

            GovernmentBond10y: str = "GSWISS10"
            """Switzerland Government Bond 10Y"""

            StockMarket: str = "SMI"
            """Switzerland Stock Market"""

            InterbankRate: str = "SWITZERLANINTRAT"
            """Switzerland Interbank Rate"""

            Currency: str = "USDCHF"
            """Switzerland Currency"""

        class Syria(System.Object):
            """This class has no documentation."""

            Currency: str = "USDSYP"
            """Syria Currency"""

        class Taiwan(System.Object):
            """This class has no documentation."""

            GovernmentBond10y: str = "TAIWANGOVBON10Y"
            """Taiwan Government Bond 10y"""

            InterbankRate: str = "TAIWANINTRAT"
            """Taiwan Interbank Rate"""

            InterestRate: str = "TAIWANIR"
            """Taiwan Interest Rate"""

            StockMarket: str = "TWSE"
            """Taiwan Stock Market"""

            Currency: str = "USDTWD"
            """Taiwan Currency"""

        class Tajikistan(System.Object):
            """This class has no documentation."""

            Currency: str = "USDTJS"
            """Tajikistan Currency"""

        class Tanzania(System.Object):
            """This class has no documentation."""

            StockMarket: str = "DARSDSEI"
            """Tanzania Stock Market"""

            Currency: str = "USDTZS"
            """Tanzania Currency"""

        class Thailand(System.Object):
            """This class has no documentation."""

            InterestRate: str = "BTRR1DAY"
            """Thailand Interest Rate"""

            GovernmentBond10y: str = "GVTL10YR"
            """Thailand Government Bond 10Y"""

            StockMarket: str = "SET50"
            """Thailand Stock Market"""

            InterbankRate: str = "THAILANDINTRAT"
            """Thailand Interbank Rate"""

            Currency: str = "USDTHB"
            """Thailand Currency"""

        class TrinidadAndTobago(System.Object):
            """This class has no documentation."""

            Currency: str = "USDTTD"
            """TrinidadAndTobago Currency"""

        class Tunisia(System.Object):
            """This class has no documentation."""

            StockMarket: str = "TUSISE"
            """Tunisia Stock Market"""

            Currency: str = "USDTND"
            """Tunisia Currency"""

        class Turkey(System.Object):
            """This class has no documentation."""

            GovernmentBond10y: str = "TURKEYGOVBON10Y"
            """Turkey Government Bond 10y"""

            InterbankRate: str = "TURKEYINTRAT"
            """Turkey Interbank Rate"""

            Currency: str = "USDTRY"
            """Turkey Currency"""

            StockMarket: str = "XU100"
            """Turkey Stock Market"""

        class Turkmenistan(System.Object):
            """This class has no documentation."""

            Currency: str = "USDTMT"
            """Turkmenistan Currency"""

        class Uganda(System.Object):
            """This class has no documentation."""

            Currency: str = "USDUGX"
            """Uganda Currency"""

        class Ukraine(System.Object):
            """This class has no documentation."""

            StockMarket: str = "PFTS"
            """Ukraine Stock Market"""

            InterbankRate: str = "UKRAINEINTRAT"
            """Ukraine Interbank Rate"""

            Currency: str = "USDUAH"
            """Ukraine Currency"""

        class UnitedArabEmirates(System.Object):
            """This class has no documentation."""

            StockMarket: str = "ADSMI"
            """UnitedArabEmirates Stock Market"""

            InterbankRate: str = "UNITEDARAINTRAT"
            """UnitedArabEmirates Interbank Rate"""

            Currency: str = "USDAED"
            """UnitedArabEmirates Currency"""

        class UnitedKingdom(System.Object):
            """This class has no documentation."""

            Currency: str = "GBPUSD"
            """UnitedKingdom Currency"""

            GovernmentBond10y: str = "GUKG10"
            """UnitedKingdom Government Bond 10Y"""

            StockMarket: str = "UKX"
            """UnitedKingdom Stock Market"""

            TwoYearNoteYield: str = "UNITEDKIN2YNY"
            """UnitedKingdom 2 Year Note Yield"""

            InterbankRate: str = "UNITEDKININTRAT"
            """UnitedKingdom Interbank Rate"""

        class UnitedStates(System.Object):
            """This class has no documentation."""

            Currency: str = "DXY"
            """UnitedStates Currency"""

            InterestRate: str = "FDTR"
            """UnitedStates Interest Rate"""

            StockMarket: str = "INDU"
            """UnitedStates Stock Market"""

            TwoYearNoteYield: str = "UNITEDSTA2YEANOTYIE"
            """UnitedStates 2 Year Note Yield"""

            EconomicOptimismIndex: str = "UNITEDSTAECOOPTIND"
            """UnitedStates Economic Optimism Index"""

            ForeignDirectInvestment: str = "UNITEDSTAFORDIRINV"
            """UnitedStates Foreign Direct Investment"""

            InterbankRate: str = "UNITEDSTAINTRAT"
            """UnitedStates Interbank Rate"""

            NahbHousingMarketIndex: str = "UNITEDSTANAHHOUMARIN"
            """UnitedStates Nahb Housing Market Index"""

            NyEmpireStateManufacturingIndex: str = "UNITEDSTANYEMPSTAMAN"
            """UnitedStates NY Empire State Manufacturing Index"""

            RedbookIndex: str = "UNITEDSTAREDIND"
            """UnitedStates Redbook Index"""

            GovernmentBond10y: str = "USGG10YR"
            """UnitedStates Government Bond 10Y"""

            CrudeOilRigs: str = "USOILRIGS"
            """UnitedStates Crude Oil Rigs"""

        class Uruguay(System.Object):
            """This class has no documentation."""

            Currency: str = "USDURY"
            """Uruguay Currency"""

        class Uzbekistan(System.Object):
            """This class has no documentation."""

            Currency: str = "USDUZS"
            """Uzbekistan Currency"""

        class Venezuela(System.Object):
            """This class has no documentation."""

            StockMarket: str = "IBVC"
            """Venezuela Stock Market"""

            Currency: str = "USDVES"
            """Venezuela Currency"""

            GovernmentBond10y: str = "VENEZUELAGOVBON10Y"
            """Venezuela Government Bond 10y"""

            DepositInterestRate: str = "VENFRINRDPST"
            """Venezuela Deposit Interest Rate"""

        class Vietnam(System.Object):
            """This class has no documentation."""

            Currency: str = "USDVND"
            """Vietnam Currency"""

            GovernmentBond10y: str = "VIETNAMGOVBON10Y"
            """Vietnam Government Bond 10y"""

            InterbankRate: str = "VIETNAMINTRAT"
            """Vietnam Interbank Rate"""

            StockMarket: str = "VNINDEX"
            """Vietnam Stock Market"""

        class Yemen(System.Object):
            """This class has no documentation."""

            Currency: str = "USDYER"
            """Yemen Currency"""

        class Zambia(System.Object):
            """This class has no documentation."""

            Currency: str = "USDZMK"
            """Zambia Currency"""

            GovernmentBond10y: str = "ZAMBIAGOVBON10Y"
            """Zambia Government Bond 10y"""

            InterestRate: str = "ZAMMBIAINTTRATE"
            """Zambia Interest Rate"""

        class Zimbabwe(System.Object):
            """This class has no documentation."""

            StockMarket: str = "INDZI"
            """Zimbabwe Stock Market"""

    class Calendar(System.Object):
        """Calendar group"""

        class Australia(System.Object):
            """Australia"""

            BalanceOfTrade: str = ...
            """Balance of Trade"""

            BuildingPermits: str = ...
            """Building Permits"""

            BusinessConfidence: str = ...
            """Business Confidence"""

            BusinessInventories: str = ...
            """Business Inventories"""

            Calendar: str = ...
            """Calendar"""

            CarRegistrations: str = ...
            """Car Registrations"""

            CompositePmi: str = ...
            """Composite Pmi"""

            ConstructionOutput: str = ...
            """Construction Output"""

            ConstructionPmi: str = ...
            """Construction Pmi"""

            ConsumerConfidence: str = ...
            """Consumer Confidence"""

            ConsumerPriceIndexCPI: str = ...
            """Consumer Price Index (CPI)"""

            ConsumerSpending: str = ...
            """Consumer Spending"""

            CoreInflationRate: str = ...
            """Core Inflation Rate"""

            CorporateProfits: str = ...
            """Corporate Profits"""

            CurrentAccount: str = ...
            """Current Account"""

            EmploymentChange: str = ...
            """Employment Change"""

            ExportPrices: str = ...
            """Export Prices"""

            Exports: str = ...
            """Exports"""

            FullTimeEmployment: str = ...
            """Full Time Employment"""

            GDPAnnualGrowthRate: str = ...
            """GDP Annual Growth Rate"""

            GDPDeflator: str = ...
            """GDP Deflator"""

            GDPGrowthRate: str = ...
            """GDP Growth Rate"""

            GrossFixedCapitalFormation: str = ...
            """Gross Fixed Capital Formation"""

            Holidays: str = ...
            """Holidays"""

            HomeLoans: str = ...
            """Home Loans"""

            HousingIndex: str = ...
            """Housing Index"""

            ImportPrices: str = ...
            """Import Prices"""

            Imports: str = ...
            """Imports"""

            IndustrialSentiment: str = ...
            """Industrial Sentiment"""

            InflationExpectations: str = ...
            """Inflation Expectations"""

            InflationRate: str = ...
            """Inflation Rate"""

            InflationRateMom: str = ...
            """Inflation Rate Mom"""

            InterestRate: str = ...
            """Interest Rate"""

            JobAdvertisements: str = ...
            """Job Advertisements"""

            LaborForceParticipationRate: str = ...
            """Labor Force Participation Rate"""

            LeadingEconomicIndex: str = ...
            """Leading Economic Index"""

            ManufacturingPmi: str = ...
            """Manufacturing Pmi"""

            NewHomeSales: str = ...
            """New Home Sales"""

            PartTimeEmployment: str = ...
            """Part Time Employment"""

            PrivateInvestment: str = ...
            """Private Investment"""

            PrivateSectorCredit: str = ...
            """Private Sector Credit"""

            ProducerPrices: str = ...
            """Producer Prices"""

            ProducerPricesChange: str = ...
            """Producer Prices Change"""

            RetailSalesMom: str = ...
            """Retail Sales MoM"""

            RetailSalesYoy: str = ...
            """Retail Sales YoY"""

            ServicesPmi: str = ...
            """Services Pmi"""

            ServicesSentiment: str = ...
            """Services Sentiment"""

            TotalVehicleSales: str = ...
            """Total Vehicle Sales"""

            UnemploymentRate: str = ...
            """Unemployment Rate"""

            WageGrowth: str = ...
            """Wage Growth"""

        class Austria(System.Object):
            """Austria"""

            BalanceOfTrade: str = ...
            """Balance of Trade"""

            BusinessConfidence: str = ...
            """Business Confidence"""

            Calendar: str = ...
            """Calendar"""

            ConsumerConfidence: str = ...
            """Consumer Confidence"""

            CurrentAccount: str = ...
            """Current Account"""

            GDPAnnualGrowthRate: str = ...
            """GDP Annual Growth Rate"""

            GDPGrowthRate: str = ...
            """GDP Growth Rate"""

            HarmonisedConsumerPrices: str = ...
            """Harmonised Consumer Prices"""

            Holidays: str = ...
            """Holidays"""

            IndustrialProduction: str = ...
            """Industrial Production"""

            InflationRate: str = ...
            """Inflation Rate"""

            InflationRateMom: str = ...
            """Inflation Rate Mom"""

            InterestRate: str = ...
            """Interest Rate"""

            ManufacturingPmi: str = ...
            """Manufacturing Pmi"""

            ProducerPrices: str = ...
            """Producer Prices"""

            ProducerPricesChange: str = ...
            """Producer Prices Change"""

            RetailSalesMom: str = ...
            """Retail Sales MoM"""

            RetailSalesYoy: str = ...
            """Retail Sales YoY"""

            UnemployedPersons: str = ...
            """Unemployed Persons"""

            UnemploymentRate: str = ...
            """Unemployment Rate"""

            WholesalePrices: str = ...
            """Wholesale Prices"""

        class Belgium(System.Object):
            """Belgium"""

            BalanceOfTrade: str = ...
            """Balance of Trade"""

            BusinessConfidence: str = ...
            """Business Confidence"""

            Calendar: str = ...
            """Calendar"""

            ConsumerConfidence: str = ...
            """Consumer Confidence"""

            CurrentAccount: str = ...
            """Current Account"""

            GDPAnnualGrowthRate: str = ...
            """GDP Annual Growth Rate"""

            GDPGrowthRate: str = ...
            """GDP Growth Rate"""

            Holidays: str = ...
            """Holidays"""

            IndustrialProduction: str = ...
            """Industrial Production"""

            IndustrialProductionMom: str = ...
            """Industrial Production Mom"""

            InflationRate: str = ...
            """Inflation Rate"""

            InflationRateMom: str = ...
            """Inflation Rate Mom"""

            ProducerPricesChange: str = ...
            """Producer Prices Change"""

            RetailSalesMom: str = ...
            """Retail Sales MoM"""

            RetailSalesYoy: str = ...
            """Retail Sales YoY"""

            UnemploymentRate: str = ...
            """Unemployment Rate"""

        class Canada(System.Object):
            """Canada"""

            AdpEmploymentChange: str = ...
            """Adp Employment Change"""

            AverageHourlyEarnings: str = ...
            """Average Hourly Earnings"""

            BalanceOfTrade: str = ...
            """Balance of Trade"""

            BuildingPermits: str = ...
            """Building Permits"""

            BusinessConfidence: str = ...
            """Business Confidence"""

            Calendar: str = ...
            """Calendar"""

            CapacityUtilization: str = ...
            """Capacity Utilization"""

            CarRegistrations: str = ...
            """Car Registrations"""

            CoreInflationRate: str = ...
            """Core Inflation Rate"""

            CurrentAccount: str = ...
            """Current Account"""

            EmploymentChange: str = ...
            """Employment Change"""

            Exports: str = ...
            """Exports"""

            ForeignStockInvestment: str = ...
            """Foreign Stock Investment"""

            FullTimeEmployment: str = ...
            """Full Time Employment"""

            GDPAnnualGrowthRate: str = ...
            """GDP Annual Growth Rate"""

            GDPDeflator: str = ...
            """GDP Deflator"""

            GdpGrowthAnnualized: str = ...
            """Gdp Growth Annualized"""

            GDPGrowthRate: str = ...
            """GDP Growth Rate"""

            GovernmentBudgetValue: str = ...
            """Government Budget Value"""

            Holidays: str = ...
            """Holidays"""

            HousingIndex: str = ...
            """Housing Index"""

            HousingStarts: str = ...
            """Housing Starts"""

            Imports: str = ...
            """Imports"""

            InflationRate: str = ...
            """Inflation Rate"""

            InflationRateMom: str = ...
            """Inflation Rate Mom"""

            InterestRate: str = ...
            """Interest Rate"""

            JobVacancies: str = ...
            """Job Vacancies"""

            LaborForceParticipationRate: str = ...
            """Labor Force Participation Rate"""

            LeadingEconomicIndex: str = ...
            """Leading Economic Index"""

            ManufacturingPMI: str = ...
            """Manufacturing PMI"""

            ManufacturingSales: str = ...
            """Manufacturing Sales"""

            PartTimeEmployment: str = ...
            """Part Time Employment"""

            ProducerPrices: str = ...
            """Producer Prices"""

            ProducerPricesChange: str = ...
            """Producer Prices Change"""

            Productivity: str = ...
            """Productivity"""

            RetailSalesExAutos: str = ...
            """Retail Sales Ex Autos"""

            RetailSalesMom: str = ...
            """Retail Sales MoM"""

            RetailSalesYoy: str = ...
            """Retail Sales YoY"""

            UnemploymentRate: str = ...
            """Unemployment Rate"""

            WageGrowth: str = ...
            """Wage Growth"""

            WholesalePrices: str = ...
            """Wholesale Prices"""

            WholesaleSales: str = ...
            """Wholesale Sales"""

        class China(System.Object):
            """China"""

            BalanceOfTrade: str = ...
            """Balance of Trade"""

            BanksBalanceSheet: str = ...
            """Banks Balance Sheet"""

            BusinessConfidence: str = ...
            """Business Confidence"""

            Calendar: str = ...
            """Calendar"""

            CapacityUtilization: str = ...
            """Capacity Utilization"""

            CapitalFlows: str = ...
            """Capital Flows"""

            CompositePmi: str = ...
            """Composite Pmi"""

            CorporateProfits: str = ...
            """Corporate Profits"""

            CurrentAccount: str = ...
            """Current Account"""

            Exports: str = ...
            """Exports"""

            FixedAssetInvestment: str = ...
            """Fixed Asset Investment"""

            ForeignDirectInvestment: str = ...
            """Foreign Direct Investment"""

            ForeignExchangeReserves: str = ...
            """Foreign Exchange Reserves"""

            GDPAnnualGrowthRate: str = ...
            """GDP Annual Growth Rate"""

            GDPGrowthRate: str = ...
            """GDP Growth Rate"""

            Holidays: str = ...
            """Holidays"""

            HousingIndex: str = ...
            """Housing Index"""

            Imports: str = ...
            """Imports"""

            IndustrialProduction: str = ...
            """Industrial Production"""

            InflationRate: str = ...
            """Inflation Rate"""

            InflationRateMom: str = ...
            """Inflation Rate Mom"""

            InterestRate: str = ...
            """Interest Rate"""

            LoanGrowth: str = ...
            """Loan Growth"""

            LoansToPrivateSector: str = ...
            """Loans to Private Sector"""

            ManufacturingPmi: str = ...
            """Manufacturing Pmi"""

            MniBusinessSentiment: str = ...
            """Mni Business Sentiment"""

            MniConsumerSentiment: str = ...
            """Mni Consumer Sentiment"""

            MoneySupplyMTwo: str = ...
            """Money Supply M2"""

            NonManufacturingPmi: str = ...
            """Non Manufacturing Pmi"""

            ProducerPricesChange: str = ...
            """Producer Prices Change"""

            RetailSalesYoy: str = ...
            """Retail Sales YoY"""

            ServicesPmi: str = ...
            """Services Pmi"""

            TotalVehicleSales: str = ...
            """Total Vehicle Sales"""

        class Cyprus(System.Object):
            """Cyprus"""

            BalanceOfTrade: str = ...
            """Balance of Trade"""

            BusinessConfidence: str = ...
            """Business Confidence"""

            Calendar: str = ...
            """Calendar"""

            ConstructionOutput: str = ...
            """Construction Output"""

            ConsumerConfidence: str = ...
            """Consumer Confidence"""

            CurrentAccount: str = ...
            """Current Account"""

            GDPAnnualGrowthRate: str = ...
            """GDP Annual Growth Rate"""

            GDPGrowthRate: str = ...
            """GDP Growth Rate"""

            HarmonisedConsumerPrices: str = ...
            """Harmonised Consumer Prices"""

            Holidays: str = ...
            """Holidays"""

            IndustrialProduction: str = ...
            """Industrial Production"""

            InflationRate: str = ...
            """Inflation Rate"""

            RetailSalesYoy: str = ...
            """Retail Sales YoY"""

            UnemploymentRate: str = ...
            """Unemployment Rate"""

            WageGrowth: str = ...
            """Wage Growth"""

        class Estonia(System.Object):
            """Estonia"""

            BalanceOfTrade: str = ...
            """Balance of Trade"""

            BusinessConfidence: str = ...
            """Business Confidence"""

            Calendar: str = ...
            """Calendar"""

            CurrentAccount: str = ...
            """Current Account"""

            GDPAnnualGrowthRate: str = ...
            """GDP Annual Growth Rate"""

            GDPGrowthRate: str = ...
            """GDP Growth Rate"""

            Holidays: str = ...
            """Holidays"""

            Imports: str = ...
            """Imports"""

            IndustrialProduction: str = ...
            """Industrial Production"""

            IndustrialProductionMom: str = ...
            """Industrial Production Mom"""

            InflationRate: str = ...
            """Inflation Rate"""

            InflationRateMom: str = ...
            """Inflation Rate Mom"""

            InterestRate: str = ...
            """Interest Rate"""

            ProducerPrices: str = ...
            """Producer Prices"""

            ProducerPricesChange: str = ...
            """Producer Prices Change"""

            RetailSalesMom: str = ...
            """Retail Sales MoM"""

            RetailSalesYoy: str = ...
            """Retail Sales YoY"""

            UnemploymentRate: str = ...
            """Unemployment Rate"""

        class Finland(System.Object):
            """Finland"""

            BalanceOfTrade: str = ...
            """Balance of Trade"""

            BusinessConfidence: str = ...
            """Business Confidence"""

            Calendar: str = ...
            """Calendar"""

            ConsumerConfidence: str = ...
            """Consumer Confidence"""

            CurrentAccount: str = ...
            """Current Account"""

            ExportPrices: str = ...
            """Export Prices"""

            GDPAnnualGrowthRate: str = ...
            """GDP Annual Growth Rate"""

            GDPGrowthRate: str = ...
            """GDP Growth Rate"""

            Holidays: str = ...
            """Holidays"""

            ImportPrices: str = ...
            """Import Prices"""

            IndustrialProduction: str = ...
            """Industrial Production"""

            InflationRate: str = ...
            """Inflation Rate"""

            InflationRateMom: str = ...
            """Inflation Rate Mom"""

            InterestRate: str = ...
            """Interest Rate"""

            LeadingEconomicIndex: str = ...
            """Leading Economic Index"""

            ProducerPricesChange: str = ...
            """Producer Prices Change"""

            RetailSalesMom: str = ...
            """Retail Sales Mom"""

            RetailSalesYoy: str = ...
            """Retail Sales Yoy"""

            UnemploymentRate: str = ...
            """Unemployment Rate"""

        class France(System.Object):
            """France"""

            BalanceOfTrade: str = ...
            """Balance of Trade"""

            BusinessConfidence: str = ...
            """Business Confidence"""

            Calendar: str = ...
            """Calendar"""

            CompositePmi: str = ...
            """Composite Pmi"""

            ConsumerConfidence: str = ...
            """Consumer Confidence"""

            CurrentAccount: str = ...
            """Current Account"""

            FiftyTwoWeekBillYield: str = ...
            """52 Week Bill Yield"""

            FiveYearNoteYield: str = ...
            """5 Year Note Yield"""

            GDPAnnualGrowthRate: str = ...
            """GDP Annual Growth Rate"""

            GDPGrowthRate: str = ...
            """GDP Growth Rate"""

            GovernmentBondTenY: str = ...
            """Government Bond 10Y"""

            GovernmentBudgetValue: str = ...
            """Government Budget Value"""

            HarmonisedConsumerPrices: str = ...
            """Harmonised Consumer Prices"""

            Holidays: str = ...
            """Holidays"""

            IndustrialProduction: str = ...
            """Industrial Production"""

            IndustrialProductionMom: str = ...
            """Industrial Production Mom"""

            InflationRate: str = ...
            """Inflation Rate"""

            InflationRateMom: str = ...
            """Inflation Rate Mom"""

            InitialJoblessClaims: str = ...
            """Initial Jobless Claims"""

            ManufacturingPmi: str = ...
            """Manufacturing Pmi"""

            NonFarmPayrolls: str = ...
            """Non Farm Payrolls"""

            NonfarmPayrollsPrivate: str = ...
            """Nonfarm Payrolls Private"""

            PersonalSpending: str = ...
            """Personal Spending"""

            ProducerPrices: str = ...
            """Producer Prices"""

            RetailSalesMom: str = ...
            """Retail Sales MoM"""

            RetailSalesYoy: str = ...
            """Retail Sales YoY"""

            ServicesPmi: str = ...
            """Services Pmi"""

            SixMonthBillYield: str = ...
            """6 Month Bill Yield"""

            ThreeMonthBillYield: str = ...
            """3 Month Bill Yield"""

            ThreeYearNoteYield: str = ...
            """3 Year Note Yield"""

            UnemployedPersons: str = ...
            """Unemployed Persons"""

            UnemploymentRate: str = ...
            """Unemployment Rate"""

        class Germany(System.Object):
            """Germany"""

            BalanceOfTrade: str = ...
            """Balance of Trade"""

            BusinessConfidence: str = ...
            """Business Confidence"""

            Calendar: str = ...
            """Calendar"""

            CompositePmi: str = ...
            """Composite Pmi"""

            ConstructionPmi: str = ...
            """Construction Pmi"""

            ConsumerConfidence: str = ...
            """Consumer Confidence"""

            CurrentAccount: str = ...
            """Current Account"""

            EmployedPersons: str = ...
            """Employed Persons"""

            Exports: str = ...
            """Exports"""

            FactoryOrders: str = ...
            """Factory Orders"""

            FiftyTwoWeekBillYield: str = ...
            """52 Week Bill Yield"""

            FiveYearNoteYield: str = ...
            """5 Year Note Yield"""

            GDPAnnualGrowthRate: str = ...
            """GDP Annual Growth Rate"""

            GDPGrowthRate: str = ...
            """GDP Growth Rate"""

            GovernmentBondTenY: str = ...
            """Government Bond 10Y"""

            GovernmentBudget: str = ...
            """Government Budget"""

            HarmonisedConsumerPrices: str = ...
            """Harmonised Consumer Prices"""

            Holidays: str = ...
            """Holidays"""

            ImportPrices: str = ...
            """Import Prices"""

            IndustrialProduction: str = ...
            """Industrial Production"""

            IndustrialProductionMom: str = ...
            """Industrial Production Mom"""

            InflationRate: str = ...
            """Inflation Rate"""

            InflationRateMom: str = ...
            """Inflation Rate Mom"""

            InterestRate: str = ...
            """Interest Rate"""

            JobVacancies: str = ...
            """Job Vacancies"""

            ManufacturingPmi: str = ...
            """Manufacturing Pmi"""

            ProducerPrices: str = ...
            """Producer Prices"""

            ProducerPricesChange: str = ...
            """Producer Prices Change"""

            RetailSalesMom: str = ...
            """Retail Sales MoM"""

            RetailSalesYoy: str = ...
            """Retail Sales YoY"""

            ServicesPmi: str = ...
            """Services Pmi"""

            ThirtyYearBondYield: str = ...
            """30 Year Bond Yield"""

            TwoYearNoteYield: str = ...
            """2 Year Note Yield"""

            UnemployedPersons: str = ...
            """Unemployed Persons"""

            UnemploymentChange: str = ...
            """Unemployment Change"""

            UnemploymentRate: str = ...
            """Unemployment Rate"""

            WholesalePrices: str = ...
            """Wholesale Prices"""

            ZewEconomicSentimentIndex: str = ...
            """Zew Economic Sentiment Index"""

        class Greece(System.Object):
            """Greece"""

            BalanceOfTrade: str = ...
            """Balance of Trade"""

            BusinessConfidence: str = ...
            """Business Confidence"""

            Calendar: str = ...
            """Calendar"""

            ConstructionOutput: str = ...
            """Construction Output"""

            ConsumerConfidence: str = ...
            """Consumer Confidence"""

            CurrentAccount: str = ...
            """Current Account"""

            GDPAnnualGrowthRate: str = ...
            """GDP Annual Growth Rate"""

            GDPGrowthRate: str = ...
            """GDP Growth Rate"""

            HarmonisedConsumerPrices: str = ...
            """Harmonised Consumer Prices"""

            Holidays: str = ...
            """Holidays"""

            IndustrialProduction: str = ...
            """Industrial Production"""

            InflationRate: str = ...
            """Inflation Rate"""

            InflationRateMom: str = ...
            """Inflation Rate Mom"""

            LoanGrowth: str = ...
            """Loan Growth"""

            LoansToPrivateSector: str = ...
            """Loans to Private Sector"""

            ManufacturingPmi: str = ...
            """Manufacturing Pmi"""

            PrivateSectorCredit: str = ...
            """Private Sector Credit"""

            ProducerPricesChange: str = ...
            """Producer Prices Change"""

            RetailSalesMom: str = ...
            """Retail Sales MoM"""

            RetailSalesYoy: str = ...
            """Retail Sales YoY"""

            SixMonthBillYield: str = ...
            """6 Month Bill Yield"""

            ThreeMonthBillYield: str = ...
            """3 Month Bill Yield"""

            UnemploymentRate: str = ...
            """Unemployment Rate"""

        class Ireland(System.Object):
            """Ireland"""

            BalanceOfTrade: str = ...
            """Balance of Trade"""

            Calendar: str = ...
            """Calendar"""

            ConstructionOutput: str = ...
            """Construction Output"""

            ConstructionPmi: str = ...
            """Construction Pmi"""

            ConsumerConfidence: str = ...
            """Consumer Confidence"""

            CoreInflationRate: str = ...
            """Core Inflation Rate"""

            CurrentAccount: str = ...
            """Current Account"""

            GDPAnnualGrowthRate: str = ...
            """GDP Annual Growth Rate"""

            GDPGrowthRate: str = ...
            """GDP Growth Rate"""

            GrossNationalProduct: str = ...
            """Gross National Product"""

            HarmonisedConsumerPrices: str = ...
            """Harmonised Consumer Prices"""

            Holidays: str = ...
            """Holidays"""

            HousingIndex: str = ...
            """Housing Index"""

            IndustrialProduction: str = ...
            """Industrial Production"""

            InflationRate: str = ...
            """Inflation Rate"""

            InflationRateMom: str = ...
            """Inflation Rate Mom"""

            InterestRate: str = ...
            """Interest Rate"""

            ManufacturingPmi: str = ...
            """Manufacturing Pmi"""

            PersonalSavings: str = ...
            """Personal Savings"""

            ProducerPrices: str = ...
            """Producer Prices"""

            ProducerPricesChange: str = ...
            """Producer Prices Change"""

            RetailSalesMom: str = ...
            """Retail Sales MoM"""

            RetailSalesYoy: str = ...
            """Retail Sales YoY"""

            ServicesPmi: str = ...
            """Services Pmi"""

            UnemploymentRate: str = ...
            """Unemployment Rate"""

            WageGrowth: str = ...
            """Wage Growth"""

        class Italy(System.Object):
            """Italy"""

            BalanceOfTrade: str = ...
            """Balance of Trade"""

            BusinessConfidence: str = ...
            """Business Confidence"""

            Calendar: str = ...
            """Calendar"""

            ConstructionOutput: str = ...
            """Construction Output"""

            ConsumerConfidence: str = ...
            """Consumer Confidence"""

            CurrentAccount: str = ...
            """Current Account"""

            FactoryOrders: str = ...
            """Factory Orders"""

            FiftyTwoWeekBillYield: str = ...
            """52 Week Bill Yield"""

            FiveYearNoteYield: str = ...
            """5 Year Note Yield"""

            GDPAnnualGrowthRate: str = ...
            """GDP Annual Growth Rate"""

            GDPGrowthRate: str = ...
            """GDP Growth Rate"""

            GovernmentBondTenY: str = ...
            """Government Bond 10Y"""

            GovernmentBudget: str = ...
            """Government Budget"""

            HarmonisedConsumerPrices: str = ...
            """Harmonised Consumer Prices"""

            Holidays: str = ...
            """Holidays"""

            IndustrialProduction: str = ...
            """Industrial Production"""

            IndustrialProductionMom: str = ...
            """Industrial Production Mom"""

            InflationRate: str = ...
            """Inflation Rate"""

            InflationRateMom: str = ...
            """Inflation Rate Mom"""

            InterestRate: str = ...
            """Interest Rate"""

            ManufacturingPmi: str = ...
            """Manufacturing Pmi"""

            ManufacturingSales: str = ...
            """Manufacturing Sales"""

            NewOrders: str = ...
            """New Orders"""

            ProducerPrices: str = ...
            """Producer Prices"""

            ProducerPricesChange: str = ...
            """Producer Prices Change"""

            RetailSalesMom: str = ...
            """Retail Sales MoM"""

            RetailSalesYoy: str = ...
            """Retail Sales YoY"""

            ServicesPmi: str = ...
            """Services Pmi"""

            SevenYearNoteYield: str = ...
            """7 Year Note Yield"""

            SixMonthBillYield: str = ...
            """6 Month Bill Yield"""

            ThirtyYearBondYield: str = ...
            """30 Year Bond Yield"""

            ThreeYearNoteYield: str = ...
            """3 Year Note Yield"""

            UnemploymentRate: str = ...
            """Unemployment Rate"""

            WageGrowth: str = ...
            """Wage Growth"""

        class Japan(System.Object):
            """Japan"""

            AllIndustryActivityIndex: str = ...
            """All Industry Activity Index"""

            BalanceOfTrade: str = ...
            """Balance of Trade"""

            BusinessConfidence: str = ...
            """Business Confidence"""

            Calendar: str = ...
            """Calendar"""

            CapacityUtilization: str = ...
            """Capacity Utilization"""

            CoincidentIndex: str = ...
            """Coincident Index"""

            CompositePmi: str = ...
            """Composite Pmi"""

            ConstructionOrders: str = ...
            """Construction Orders"""

            ConsumerConfidence: str = ...
            """Consumer Confidence"""

            ConsumerSpending: str = ...
            """Consumer Spending"""

            CoreInflationRate: str = ...
            """Core Inflation Rate"""

            CurrentAccount: str = ...
            """Current Account"""

            EconomyWatchersSurvey: str = ...
            """Economy Watchers Survey"""

            Exports: str = ...
            """Exports"""

            ForeignBondInvestment: str = ...
            """Foreign Bond Investment"""

            ForeignExchangeReserves: str = ...
            """Foreign Exchange Reserves"""

            ForeignStockInvestment: str = ...
            """Foreign Stock Investment"""

            GDPAnnualGrowthRate: str = ...
            """GDP Annual Growth Rate"""

            GDPDeflator: str = ...
            """GDP Deflator"""

            GdpGrowthAnnualized: str = ...
            """Gdp Growth Annualized"""

            GDPGrowthRate: str = ...
            """GDP Growth Rate"""

            GovernmentBondTenY: str = ...
            """Government Bond 10Y"""

            GrossFixedCapitalFormation: str = ...
            """Gross Fixed Capital Formation"""

            Holidays: str = ...
            """Holidays"""

            HouseholdSpending: str = ...
            """Household Spending"""

            HousingStarts: str = ...
            """Housing Starts"""

            Imports: str = ...
            """Imports"""

            IndustrialProduction: str = ...
            """Industrial Production"""

            IndustrialProductionMom: str = ...
            """Industrial Production Mom"""

            InflationRate: str = ...
            """Inflation Rate"""

            InflationRateMom: str = ...
            """Inflation Rate Mom"""

            InterestRate: str = ...
            """Interest Rate"""

            JobsToApplicationsRatio: str = ...
            """Jobs To Applications Ratio"""

            LeadingCompositeIndex: str = ...
            """Leading Composite Index"""

            LeadingEconomicIndex: str = ...
            """Leading Economic Index"""

            LoanGrowth: str = ...
            """Loan Growth"""

            MachineryOrders: str = ...
            """Machinery Orders"""

            MachineToolOrders: str = ...
            """Machine Tool Orders"""

            ManufacturingPmi: str = ...
            """Manufacturing Pmi"""

            NonManufacturingPmi: str = ...
            """Non Manufacturing Pmi"""

            PrivateInvestment: str = ...
            """Private Investment"""

            ProducerPrices: str = ...
            """Producer Prices"""

            ProducerPricesChange: str = ...
            """Producer Prices Change"""

            RetailSalesMom: str = ...
            """Retail Sales MoM"""

            RetailSalesYoy: str = ...
            """Retail Sales YoY"""

            ReutersTankanIndex: str = ...
            """Reuters Tankan Index"""

            ServicesPmi: str = ...
            """Services Pmi"""

            SmallBusinessSentiment: str = ...
            """Small Business Sentiment"""

            TertiaryIndustryIndex: str = ...
            """Tertiary Industry Index"""

            ThirtyYearBondYield: str = ...
            """30 Year Bond Yield"""

            TokyoCpi: str = ...
            """Tokyo Cpi"""

            UnemploymentRate: str = ...
            """Unemployment Rate"""

            WageGrowth: str = ...
            """Wage Growth"""

        class Latvia(System.Object):
            """Latvia"""

            BalanceOfTrade: str = ...
            """Balance of Trade"""

            Calendar: str = ...
            """Calendar"""

            CurrentAccount: str = ...
            """Current Account"""

            GDPAnnualGrowthRate: str = ...
            """GDP Annual Growth Rate"""

            GDPGrowthRate: str = ...
            """GDP Growth Rate"""

            Holidays: str = ...
            """Holidays"""

            IndustrialProduction: str = ...
            """Industrial Production"""

            IndustrialProductionMom: str = ...
            """Industrial Production Mom"""

            InflationRate: str = ...
            """Inflation Rate"""

            InflationRateMom: str = ...
            """Inflation Rate Mom"""

            ProducerPrices: str = ...
            """Producer Prices"""

            ProducerPricesChange: str = ...
            """Producer Prices Change"""

            RetailSalesMom: str = ...
            """Retail Sales MoM"""

            RetailSalesYoy: str = ...
            """Retail Sales YoY"""

            UnemploymentRate: str = ...
            """Unemployment Rate"""

        class Lithuania(System.Object):
            """Lithuania"""

            BalanceOfTrade: str = ...
            """Balance of Trade"""

            BusinessConfidence: str = ...
            """Business Confidence"""

            Calendar: str = ...
            """Calendar"""

            ConsumerConfidence: str = ...
            """Consumer Confidence"""

            CurrentAccount: str = ...
            """Current Account"""

            GDPAnnualGrowthRate: str = ...
            """GDP Annual Growth Rate"""

            GDPGrowthRate: str = ...
            """GDP Growth Rate"""

            Holidays: str = ...
            """Holidays"""

            IndustrialProduction: str = ...
            """Industrial Production"""

            IndustrialProductionMom: str = ...
            """Industrial Production Mom"""

            InflationRate: str = ...
            """Inflation Rate"""

            InflationRateMom: str = ...
            """Inflation Rate Mom"""

            ProducerPrices: str = ...
            """Producer Prices"""

            ProducerPricesChange: str = ...
            """Producer Prices Change"""

            RetailSalesMom: str = ...
            """Retail Sales MoM"""

            RetailSalesYoy: str = ...
            """Retail Sales YoY"""

            UnemploymentRate: str = ...
            """Unemployment Rate"""

        class Luxembourg(System.Object):
            """Luxembourg"""

            BalanceOfTrade: str = ...
            """Balance of Trade"""

            BusinessConfidence: str = ...
            """Business Confidence"""

            Calendar: str = ...
            """Calendar"""

            ConsumerConfidence: str = ...
            """Consumer Confidence"""

            CurrentAccount: str = ...
            """Current Account"""

            GDPAnnualGrowthRate: str = ...
            """GDP Annual Growth Rate"""

            GDPGrowthRate: str = ...
            """GDP Growth Rate"""

            Holidays: str = ...
            """Holidays"""

            IndustrialProduction: str = ...
            """Industrial Production"""

            InflationRate: str = ...
            """Inflation Rate"""

            ProducerPricesChange: str = ...
            """Producer Prices Change"""

            RetailSalesMom: str = ...
            """Retail Sales Mom"""

            UnemploymentRate: str = ...
            """Unemployment Rate"""

        class Malta(System.Object):
            """Malta"""

            BalanceOfTrade: str = ...
            """Balance of Trade"""

            BusinessConfidence: str = ...
            """Business Confidence"""

            Calendar: str = ...
            """Calendar"""

            ConsumerConfidence: str = ...
            """Consumer Confidence"""

            GDPAnnualGrowthRate: str = ...
            """GDP Annual Growth Rate"""

            Holidays: str = ...
            """Holidays"""

            IndustrialProduction: str = ...
            """Industrial Production"""

            InflationRate: str = ...
            """Inflation Rate"""

            ProducerPricesChange: str = ...
            """Producer Prices Change"""

            RetailSalesMom: str = ...
            """Retail Sales MoM"""

            RetailSalesYoy: str = ...
            """Retail Sales YoY"""

            UnemploymentRate: str = ...
            """Unemployment Rate"""

        class Netherlands(System.Object):
            """Netherlands"""

            BalanceOfTrade: str = ...
            """Balance of Trade"""

            BusinessConfidence: str = ...
            """Business Confidence"""

            Calendar: str = ...
            """Calendar"""

            ConsumerConfidence: str = ...
            """Consumer Confidence"""

            CurrentAccount: str = ...
            """Current Account"""

            GDPAnnualGrowthRate: str = ...
            """GDP Annual Growth Rate"""

            GDPGrowthRate: str = ...
            """GDP Growth Rate"""

            GovernmentBondTenY: str = ...
            """Government Bond 10Y"""

            Holidays: str = ...
            """Holidays"""

            IndustrialProduction: str = ...
            """Industrial Production"""

            IndustrialProductionMom: str = ...
            """Industrial Production Mom"""

            InflationRate: str = ...
            """Inflation Rate"""

            ManufacturingPmi: str = ...
            """Manufacturing Pmi"""

            ManufacturingProduction: str = ...
            """Manufacturing Production"""

            PersonalSpending: str = ...
            """Personal Spending"""

            RetailSalesMom: str = ...
            """Retail Sales MoM"""

            RetailSalesYoy: str = ...
            """Retail Sales YoY"""

            SixMonthBillYield: str = ...
            """6 Month Bill Yield"""

            ThreeMonthBillYield: str = ...
            """3 Month Bill Yield"""

            UnemploymentRate: str = ...
            """Unemployment Rate"""

        class NewZealand(System.Object):
            """New Zealand"""

            BalanceOfTrade: str = ...
            """Balance of Trade"""

            BuildingPermits: str = ...
            """Building Permits"""

            BusinessConfidence: str = ...
            """Business Confidence"""

            Calendar: str = ...
            """Calendar"""

            CapacityUtilization: str = ...
            """Capacity Utilization"""

            ConsumerConfidence: str = ...
            """Consumer Confidence"""

            CreditCardSpending: str = ...
            """Credit Card Spending"""

            CurrentAccount: str = ...
            """Current Account"""

            EmploymentChange: str = ...
            """Employment Change"""

            ExportPrices: str = ...
            """Export Prices"""

            Exports: str = ...
            """Exports"""

            FoodInflation: str = ...
            """Food Inflation"""

            GDPAnnualGrowthRate: str = ...
            """GDP Annual Growth Rate"""

            GDPGrowthRate: str = ...
            """GDP Growth Rate"""

            GlobalDairyTradePriceIndex: str = ...
            """Global Dairy Trade Price Index"""

            Holidays: str = ...
            """Holidays"""

            HousingIndex: str = ...
            """Housing Index"""

            ImportPrices: str = ...
            """Import Prices"""

            Imports: str = ...
            """Imports"""

            IndustrialProduction: str = ...
            """Industrial Production"""

            InflationExpectations: str = ...
            """Inflation Expectations"""

            InflationRate: str = ...
            """Inflation Rate"""

            InflationRateMom: str = ...
            """Inflation Rate Mom"""

            InterestRate: str = ...
            """Interest Rate"""

            LaborForceParticipationRate: str = ...
            """Labor Force Participation Rate"""

            LabourCosts: str = ...
            """Labour Costs"""

            ManufacturingPmi: str = ...
            """Manufacturing Pmi"""

            ProducerPrices: str = ...
            """Producer Prices"""

            RetailSalesMom: str = ...
            """Retail Sales MoM"""

            RetailSalesYoy: str = ...
            """Retail Sales YoY"""

            ServicesPmi: str = ...
            """Services Pmi"""

            TermsOfTrade: str = ...
            """Terms of Trade"""

            TouristArrivals: str = ...
            """Tourist Arrivals"""

            UnemploymentRate: str = ...
            """Unemployment Rate"""

        class Portugal(System.Object):
            """Portugal"""

            BalanceOfTrade: str = ...
            """Balance of Trade"""

            BusinessConfidence: str = ...
            """Business Confidence"""

            Calendar: str = ...
            """Calendar"""

            ConsumerConfidence: str = ...
            """Consumer Confidence"""

            CurrentAccount: str = ...
            """Current Account"""

            Exports: str = ...
            """Exports"""

            GDPAnnualGrowthRate: str = ...
            """GDP Annual Growth Rate"""

            GDPGrowthRate: str = ...
            """GDP Growth Rate"""

            GovernmentBudgetValue: str = ...
            """Government Budget Value"""

            Holidays: str = ...
            """Holidays"""

            Imports: str = ...
            """Imports"""

            IndustrialProduction: str = ...
            """Industrial Production"""

            IndustrialProductionMom: str = ...
            """Industrial Production Mom"""

            InflationRate: str = ...
            """Inflation Rate"""

            InflationRateMom: str = ...
            """Inflation Rate Mom"""

            InterestRate: str = ...
            """Interest Rate"""

            LeadingEconomicIndex: str = ...
            """Leading Economic Index"""

            PersonalSpending: str = ...
            """Personal Spending"""

            ProducerPrices: str = ...
            """Producer Prices"""

            ProducerPricesChange: str = ...
            """Producer Prices Change"""

            RetailSalesMom: str = ...
            """Retail Sales MoM"""

            RetailSalesYoy: str = ...
            """Retail Sales YoY"""

            UnemploymentRate: str = ...
            """Unemployment Rate"""

        class Slovakia(System.Object):
            """Slovakia"""

            BalanceOfTrade: str = ...
            """Balance of Trade"""

            BusinessConfidence: str = ...
            """Business Confidence"""

            Calendar: str = ...
            """Calendar"""

            ConstructionOutput: str = ...
            """Construction Output"""

            ConsumerConfidence: str = ...
            """Consumer Confidence"""

            CoreConsumerPrices: str = ...
            """Core Consumer Prices"""

            CoreInflationRate: str = ...
            """Core Inflation Rate"""

            CurrentAccount: str = ...
            """Current Account"""

            Exports: str = ...
            """Exports"""

            GDPAnnualGrowthRate: str = ...
            """GDP Annual Growth Rate"""

            GDPGrowthRate: str = ...
            """GDP Growth Rate"""

            HarmonisedConsumerPrices: str = ...
            """Harmonised Consumer Prices"""

            Holidays: str = ...
            """Holidays"""

            Imports: str = ...
            """Imports"""

            IndustrialProduction: str = ...
            """Industrial Production"""

            IndustrialProductionMom: str = ...
            """Industrial Production Mom"""

            InflationRate: str = ...
            """Inflation Rate"""

            InflationRateMom: str = ...
            """Inflation Rate Mom"""

            InterestRate: str = ...
            """Interest Rate"""

            RetailSalesMom: str = ...
            """Retail Sales MoM"""

            RetailSalesYoy: str = ...
            """Retail Sales YoY"""

            UnemploymentRate: str = ...
            """Unemployment Rate"""

            WageGrowth: str = ...
            """Wage Growth"""

        class Slovenia(System.Object):
            """Slovenia"""

            BalanceOfTrade: str = ...
            """Balance of Trade"""

            BusinessConfidence: str = ...
            """Business Confidence"""

            Calendar: str = ...
            """Calendar"""

            ConsumerConfidence: str = ...
            """Consumer Confidence"""

            GDPAnnualGrowthRate: str = ...
            """GDP Annual Growth Rate"""

            GDPGrowthRate: str = ...
            """GDP Growth Rate"""

            HarmonisedConsumerPrices: str = ...
            """Harmonised Consumer Prices"""

            Holidays: str = ...
            """Holidays"""

            IndustrialProduction: str = ...
            """Industrial Production"""

            InflationRate: str = ...
            """Inflation Rate"""

            InterestRate: str = ...
            """Interest Rate"""

            ProducerPricesChange: str = ...
            """Producer Prices Change"""

            RetailSalesMom: str = ...
            """Retail Sales MoM"""

            RetailSalesYoy: str = ...
            """Retail Sales YoY"""

            TouristArrivals: str = ...
            """Tourist Arrivals"""

            UnemploymentRate: str = ...
            """Unemployment Rate"""

        class Spain(System.Object):
            """Spain"""

            BalanceOfTrade: str = ...
            """Balance of Trade"""

            BusinessConfidence: str = ...
            """Business Confidence"""

            Calendar: str = ...
            """Calendar"""

            ConsumerConfidence: str = ...
            """Consumer Confidence"""

            CurrentAccount: str = ...
            """Current Account"""

            FactoryOrders: str = ...
            """Factory Orders"""

            FiftyTwoWeekBillYield: str = ...
            """52 Week Bill Yield"""

            FiveYearNoteYield: str = ...
            """5 Year Note Yield"""

            GDPAnnualGrowthRate: str = ...
            """GDP Annual Growth Rate"""

            GDPGrowthRate: str = ...
            """GDP Growth Rate"""

            GovernmentBondTenY: str = ...
            """Government Bond 10Y"""

            HarmonisedConsumerPrices: str = ...
            """Harmonised Consumer Prices"""

            Holidays: str = ...
            """Holidays"""

            IndustrialProduction: str = ...
            """Industrial Production"""

            InflationRate: str = ...
            """Inflation Rate"""

            InflationRateMom: str = ...
            """Inflation Rate Mom"""

            InterestRate: str = ...
            """Interest Rate"""

            ManufacturingPmi: str = ...
            """Manufacturing Pmi"""

            ProducerPricesChange: str = ...
            """Producer Prices Change"""

            RetailSalesMom: str = ...
            """Retail Sales MoM"""

            RetailSalesYoy: str = ...
            """Retail Sales YoY"""

            ServicesPmi: str = ...
            """Services Pmi"""

            SixMonthBillYield: str = ...
            """6 Month Bill Yield"""

            ThreeMonthBillYield: str = ...
            """3 Month Bill Yield"""

            ThreeYearNoteYield: str = ...
            """3 Year Note Yield"""

            TotalVehicleSales: str = ...
            """Total Vehicle Sales"""

            TouristArrivals: str = ...
            """Tourist Arrivals"""

            UnemploymentChange: str = ...
            """Unemployment Change"""

            UnemploymentRate: str = ...
            """Unemployment Rate"""

        class Sweden(System.Object):
            """Sweden"""

            BalanceOfTrade: str = ...
            """Balance of Trade"""

            BusinessConfidence: str = ...
            """Business Confidence"""

            BusinessInventories: str = ...
            """Business Inventories"""

            Calendar: str = ...
            """Calendar"""

            CapacityUtilization: str = ...
            """Capacity Utilization"""

            ConsumerConfidence: str = ...
            """Consumer Confidence"""

            CoreConsumerPrices: str = ...
            """Core Consumer Prices"""

            CoreInflationRate: str = ...
            """Core Inflation Rate"""

            CurrentAccount: str = ...
            """Current Account"""

            GDPAnnualGrowthRate: str = ...
            """GDP Annual Growth Rate"""

            GDPGrowthRate: str = ...
            """GDP Growth Rate"""

            Holidays: str = ...
            """Holidays"""

            HouseholdSpending: str = ...
            """Household Spending"""

            IndustrialProduction: str = ...
            """Industrial Production"""

            IndustrialProductionMom: str = ...
            """Industrial Production Mom"""

            InflationExpectations: str = ...
            """Inflation Expectations"""

            InflationRate: str = ...
            """Inflation Rate"""

            InflationRateMom: str = ...
            """Inflation Rate Mom"""

            InterestRate: str = ...
            """Interest Rate"""

            LoanGrowth: str = ...
            """Loan Growth"""

            ManufacturingPmi: str = ...
            """Manufacturing Pmi"""

            NewOrders: str = ...
            """New Orders"""

            PrivateSectorCredit: str = ...
            """Private Sector Credit"""

            ProducerPrices: str = ...
            """Producer Prices"""

            ProducerPricesChange: str = ...
            """Producer Prices Change"""

            RetailSalesMom: str = ...
            """Retail Sales MoM"""

            RetailSalesYoy: str = ...
            """Retail Sales YoY"""

            ServicesPmi: str = ...
            """Services Pmi"""

            UnemploymentRate: str = ...
            """Unemployment Rate"""

        class Switzerland(System.Object):
            """Switzerland"""

            BalanceOfTrade: str = ...
            """Balance of Trade"""

            BusinessConfidence: str = ...
            """Business Confidence"""

            Calendar: str = ...
            """Calendar"""

            ConsumerConfidence: str = ...
            """Consumer Confidence"""

            CurrentAccount: str = ...
            """Current Account"""

            FactoryOrders: str = ...
            """Factory Orders"""

            ForeignExchangeReserves: str = ...
            """Foreign Exchange Reserves"""

            GDPAnnualGrowthRate: str = ...
            """GDP Annual Growth Rate"""

            GDPGrowthRate: str = ...
            """GDP Growth Rate"""

            Holidays: str = ...
            """Holidays"""

            IndustrialProduction: str = ...
            """Industrial Production"""

            InflationRate: str = ...
            """Inflation Rate"""

            InflationRateMom: str = ...
            """Inflation Rate Mom"""

            InterestRate: str = ...
            """Interest Rate"""

            ManufacturingPmi: str = ...
            """Manufacturing Pmi"""

            NonFarmPayrolls: str = ...
            """Non Farm Payrolls"""

            ProducerPrices: str = ...
            """Producer Prices"""

            ProducerPricesChange: str = ...
            """Producer Prices Change"""

            RetailSalesMom: str = ...
            """Retail Sales MoM"""

            RetailSalesYoy: str = ...
            """Retail Sales YoY"""

            UnemploymentRate: str = ...
            """Unemployment Rate"""

            ZewEconomicSentimentIndex: str = ...
            """Zew Economic Sentiment Index"""

        class UnitedKingdom(System.Object):
            """United Kingdom"""

            BalanceOfTrade: str = ...
            """Balance of Trade"""

            BusinessConfidence: str = ...
            """Business Confidence"""

            Calendar: str = ...
            """Calendar"""

            CarRegistrations: str = ...
            """Car Registrations"""

            CBIDistributiveTrades: str = ...
            """CBI Distributive Trades"""

            ClaimantCountChange: str = ...
            """Claimant Count Change"""

            CompositePmi: str = ...
            """Composite Pmi"""

            ConstructionOrders: str = ...
            """Construction Orders"""

            ConstructionOutput: str = ...
            """Construction Output"""

            ConstructionPmi: str = ...
            """Construction Pmi"""

            ConsumerConfidence: str = ...
            """Consumer Confidence"""

            ConsumerCredit: str = ...
            """Consumer Credit"""

            CoreConsumerPrices: str = ...
            """Core Consumer Prices"""

            CoreInflationRate: str = ...
            """Core Inflation Rate"""

            CoreProducerPrices: str = ...
            """Core Producer Prices"""

            CurrentAccount: str = ...
            """Current Account"""

            EconomicActivityIndex: str = ...
            """Economic Activity Index"""

            EmploymentChange: str = ...
            """Employment Change"""

            FactoryOrders: str = ...
            """Factory Orders"""

            FiveYearNoteYield: str = ...
            """5 Year Note Yield"""

            GDPAnnualGrowthRate: str = ...
            """GDP Annual Growth Rate"""

            GDPGrowthRate: str = ...
            """GDP Growth Rate"""

            GoodsTradeBalance: str = ...
            """Goods Trade Balance"""

            GovernmentBondTenY: str = ...
            """Government Bond 10Y"""

            GovernmentDebt: str = ...
            """Government Debt"""

            Holidays: str = ...
            """Holidays"""

            HomeLoans: str = ...
            """Home Loans"""

            HousingIndex: str = ...
            """Housing Index"""

            IndustrialProduction: str = ...
            """Industrial Production"""

            IndustrialProductionMom: str = ...
            """Industrial Production Mom"""

            InflationExpectations: str = ...
            """Inflation Expectations"""

            InflationRate: str = ...
            """Inflation Rate"""

            InflationRateMom: str = ...
            """Inflation Rate Mom"""

            InterestRate: str = ...
            """Interest Rate"""

            LabourCosts: str = ...
            """Labour Costs"""

            LeadingEconomicIndex: str = ...
            """Leading Economic Index"""

            ManufacturingPmi: str = ...
            """Manufacturing Pmi"""

            ManufacturingProduction: str = ...
            """Manufacturing Production"""

            MortgageApplications: str = ...
            """Mortgage Applications"""

            MortgageApprovals: str = ...
            """Mortgage Approvals"""

            NationwideHousingPrices: str = ...
            """Nationwide Housing Prices"""

            PrivateInvestment: str = ...
            """Private Investment"""

            ProducerPrices: str = ...
            """Producer Prices"""

            ProducerPricesChange: str = ...
            """Producer Prices Change"""

            Productivity: str = ...
            """Productivity"""

            RetailPriceIndex: str = ...
            """Retail Price Index"""

            RetailSalesExFuel: str = ...
            """Retail Sales Ex Fuel"""

            RetailSalesMom: str = ...
            """Retail Sales MoM"""

            RetailSalesYoy: str = ...
            """Retail Sales YoY"""

            ServicesPmi: str = ...
            """Services Pmi"""

            ThirtyYearBondYield: str = ...
            """30 Year Bond Yield"""

            UnemploymentRate: str = ...
            """Unemployment Rate"""

            WageGrowth: str = ...
            """Wage Growth"""

        class UnitedStates(System.Object):
            """United States"""

            AdpEmploymentChange: str = ...
            """Adp Employment Change"""

            APICrudeOilStockChange: str = ...
            """API Crude Oil Stock Change"""

            AverageHourlyEarnings: str = ...
            """Average Hourly Earnings"""

            AverageWeeklyHours: str = ...
            """Average Weekly Hours"""

            BalanceOfTrade: str = ...
            """Balance of Trade"""

            BuildingPermits: str = ...
            """Building Permits"""

            BusinessConfidence: str = ...
            """Business Confidence"""

            BusinessInventories: str = ...
            """Business Inventories"""

            Calendar: str = ...
            """Calendar"""

            CapacityUtilization: str = ...
            """Capacity Utilization"""

            CapitalFlows: str = ...
            """Capital Flows"""

            CaseShillerHomePriceIndex: str = ...
            """Case Shiller Home Price Index"""

            ChainStoreSales: str = ...
            """Chain Store Sales"""

            ChallengerJobCuts: str = ...
            """Challenger Job Cuts"""

            ChicagoFedNationalActivityIndex: str = ...
            """Chicago Fed National Activity Index"""

            ChicagoPmi: str = ...
            """Chicago Pmi"""

            CompositePmi: str = ...
            """Composite Pmi"""

            ConstructionSpending: str = ...
            """Construction Spending"""

            ConsumerConfidence: str = ...
            """Consumer Confidence"""

            ConsumerCredit: str = ...
            """Consumer Credit"""

            ConsumerPriceIndexCPI: str = ...
            """Consumer Price Index (CPI)"""

            ConsumerSpending: str = ...
            """Consumer Spending"""

            ContinuingJoblessClaims: str = ...
            """Continuing Jobless Claims"""

            CoreConsumerPrices: str = ...
            """Core Consumer Prices"""

            CoreInflationRate: str = ...
            """Core Inflation Rate"""

            CorePcePriceIndex: str = ...
            """Core Pce Price Index"""

            CoreProducerPrices: str = ...
            """Core Producer Prices"""

            CorporateProfits: str = ...
            """Corporate Profits"""

            CrudeOilImports: str = ...
            """Crude Oil Imports"""

            CrudeOilRigs: str = ...
            """Crude Oil Rigs"""

            CrudeOilStocksChange: str = ...
            """Crude Oil Stocks Change"""

            CurrentAccount: str = ...
            """Current Account"""

            CushingCrudeOilStocks: str = ...
            """Cushing Crude Oil Stocks"""

            DallasFedManufacturingIndex: str = ...
            """Dallas Fed Manufacturing Index"""

            DistillateFuelProduction: str = ...
            """Distillate Fuel Production"""

            DistillateStocks: str = ...
            """Distillate Stocks"""

            DurableGoodsOrders: str = ...
            """Durable Goods Orders"""

            DurableGoodsOrdersExDefense: str = ...
            """Durable Goods Orders Ex Defense"""

            DurableGoodsOrdersExTransportation: str = ...
            """Durable Goods Orders Ex Transportation"""

            EconomicOptimismIndex: str = ...
            """Economic Optimism Index"""

            EmploymentCostIndex: str = ...
            """Employment Cost Index"""

            ExistingHomeSales: str = ...
            """Existing Home Sales"""

            ExportPrices: str = ...
            """Export Prices"""

            Exports: str = ...
            """Exports"""

            FactoryOrders: str = ...
            """Factory Orders"""

            FactoryOrdersExTransportation: str = ...
            """Factory Orders Ex Transportation"""

            FiftyTwoWeekBillYield: str = ...
            """52 Week Bill Yield"""

            FiveYearNoteYield: str = ...
            """5 Year Note Yield"""

            ForeignBondInvestment: str = ...
            """Foreign Bond Investment"""

            FourWeekBillYield: str = ...
            """4 Week Bill Yield"""

            GasolineProduction: str = ...
            """Gasoline Production"""

            GasolineStocksChange: str = ...
            """Gasoline Stocks Change"""

            GDPAnnualGrowthRate: str = ...
            """GDP Annual Growth Rate"""

            GdpDeflator: str = ...
            """Gdp Deflator"""

            GDPGrowthRate: str = ...
            """GDP Growth Rate"""

            GoodsTradeBalance: str = ...
            """Goods Trade Balance"""

            GovernmentBondTenY: str = ...
            """Government Bond 10Y"""

            GovernmentBudgetValue: str = ...
            """Government Budget Value"""

            GovernmentPayrolls: str = ...
            """Government Payrolls"""

            Holidays: str = ...
            """Holidays"""

            HousingIndex: str = ...
            """Housing Index"""

            HousingStarts: str = ...
            """Housing Starts"""

            ImportPrices: str = ...
            """Import Prices"""

            Imports: str = ...
            """Imports"""

            IndustrialProduction: str = ...
            """Industrial Production"""

            IndustrialProductionMom: str = ...
            """Industrial Production Mom"""

            InflationExpectations: str = ...
            """Inflation Expectations"""

            InflationRate: str = ...
            """Inflation Rate"""

            InflationRateMom: str = ...
            """Inflation Rate Mom"""

            InitialJoblessClaims: str = ...
            """Initial Jobless Claims"""

            InterestRate: str = ...
            """Interest Rate"""

            IsmNewYorkIndex: str = ...
            """Ism New York Index"""

            JobOffers: str = ...
            """Job Offers"""

            KansasFedManufacturingIndex: str = ...
            """Kansas Fed Manufacturing Index"""

            LaborForceParticipationRate: str = ...
            """Labor Force Participation Rate"""

            LaborMarketConditionsIndex: str = ...
            """Labor Market Conditions Index"""

            LabourCosts: str = ...
            """Labour Costs"""

            LeadingEconomicIndex: str = ...
            """Leading Economic Index"""

            ManufacturingPayrolls: str = ...
            """Manufacturing Payrolls"""

            ManufacturingPmi: str = ...
            """Manufacturing Pmi"""

            ManufacturingProduction: str = ...
            """Manufacturing Production"""

            MortgageApplications: str = ...
            """Mortgage Applications"""

            MortgageRate: str = ...
            """Mortgage Rate"""

            NahbHousingMarketIndex: str = ...
            """Nahb Housing Market Index"""

            NaturalGasStocksChange: str = ...
            """Natural Gas Stocks Change"""

            NetLongTermTicFlows: str = ...
            """Net Long-term Tic Flows"""

            NewHomeSales: str = ...
            """New Home Sales"""

            NfibBusinessOptimismIndex: str = ...
            """Nfib Business Optimism Index"""

            NonFarmPayrolls: str = ...
            """Non Farm Payrolls"""

            NonfarmPayrollsPrivate: str = ...
            """Nonfarm Payrolls - Private"""

            NonManufacturingPmi: str = ...
            """Non Manufacturing Pmi"""

            NyEmpireStateManufacturingIndex: str = ...
            """Ny Empire State Manufacturing Index"""

            PcePriceIndex: str = ...
            """Pce Price Index"""

            PendingHomeSales: str = ...
            """Pending Home Sales"""

            PersonalIncome: str = ...
            """Personal Income"""

            PersonalSpending: str = ...
            """Personal Spending"""

            PhiladelphiaFedManufacturingIndex: str = ...
            """Philadelphia Fed Manufacturing Index"""

            ProducerPrices: str = ...
            """Producer Prices"""

            ProducerPricesChange: str = ...
            """Producer Prices Change"""

            Productivity: str = ...
            """Productivity"""

            RedbookIndex: str = ...
            """Redbook Index"""

            RefineryCrudeRuns: str = ...
            """Refinery Crude Runs"""

            RetailSalesExAutos: str = ...
            """Retail Sales Ex Autos"""

            RetailSalesMom: str = ...
            """Retail Sales MoM"""

            RetailSalesYoy: str = ...
            """Retail Sales YoY"""

            RichmondFedManufacturingIndex: str = ...
            """Richmond Fed Manufacturing Index"""

            ServicesPmi: str = ...
            """Services Pmi"""

            SevenYearNoteYield: str = ...
            """7 Year Note Yield"""

            SixMonthBillYield: str = ...
            """6 Month Bill Yield"""

            ThirtyYearBondYield: str = ...
            """30 Year Bond Yield"""

            ThreeMonthBillYield: str = ...
            """3 Month Bill Yield"""

            ThreeYearNoteYield: str = ...
            """3 Year Note Yield"""

            TotalVehicleSales: str = ...
            """Total Vehicle Sales"""

            TwoYearNoteYield: str = ...
            """2 Year Note Yield"""

            UnemploymentRate: str = ...
            """Unemployment Rate"""

            WholesaleInventories: str = ...
            """Wholesale Inventories"""

        Delimiter: str = "//"
        """Delimiter used to separate country from ticker in TradingEconomics.Calendar entries"""

    class Event(System.Object):
        """The Event class contains all events normalized for your convenience"""

        class Australia(System.Object):
            """Australia"""

            AigPerformanceConstructionIndex: str = "aig performance construction index"
            """AiG Performance Construction Index"""

            AigPerformanceManufacturingIndex: str = "aig performance manufacturing index"
            """AiG Performance of Mfg Index"""

            AigPerformanceServicesIndex: str = "aig performance services index"
            """AiG Performance of Services Index"""

            AnzacDay: str = "anzac day"
            """ANZAC Day"""

            AnzInternetJobAdvertisementsMoM: str = "anz internet job advertisements mom"
            """ANZ Internet Job Ads MoM"""

            AnzJobAdvertisements: str = "anz job advertisements"
            """ANZ Job Advertisements"""

            AnzJobAdvertisementsMoM: str = "anz job advertisements mom"
            """ANZ Job Advertisement MoM"""

            AnzNewspaperJobAdvertisementsMoM: str = "anz newspaper job advertisements mom"
            """ANZ Newspaper Job Ads MoM"""

            AustraliaDay: str = "australia day"
            """Australia Day"""

            AustraliaDayObserved: str = "australia day observed"
            """Australia Day (Observed)"""

            AustraliaDaySubstituteDay: str = "australia day substitute day"
            """Australia Day (substitute day)"""

            BalanceOfTrade: str = "balance of trade"
            """Balance of Trade"""

            BoxingDay: str = "boxing day"
            """Boxing Day"""

            BuildingPermitsMoM: str = "building permits mom"
            """Building Permits (MoM)"""

            BuildingPermitsYoY: str = "building permits yoy"
            """Building Permits (YoY)"""

            BusinessInventoriesQoQ: str = "business inventories qoq"
            """Business Inventories QoQ"""

            CapitalExpenditureQoQ: str = "capital expenditure qoq"
            """Capital Expenditure QoQ"""

            CbLeadingEconomicIndex: str = "cb leading economic index"
            """CB Leading Index"""

            CbLeadingEconomicIndexMoM: str = "cb leading economic index mom"
            """CB Leading Index MoM"""

            CbLeadingEconomicIndicators: str = "cb leading economic indicators"
            """CB Leading Indicator"""

            ChristmasDay: str = "christmas day"
            """Christmas Day"""

            CommbankCompositePurchasingManagersIndexFinal: str = "commbank composite purchasing managers index final"
            """CommBank Composite PMI Final"""

            CommbankCompositePurchasingManagersIndexFlash: str = "commbank composite purchasing managers index flash"
            """CommBank Composite PMI Flash"""

            CommbankManufacturingPurchasingManagersIndexFinal: str = "commbank manufacturing purchasing managers index final"
            """CommBank Manufacturing PMI Final"""

            CommbankManufacturingPurchasingManagersIndexFlash: str = "commbank manufacturing purchasing managers index flash"
            """CommBank Manufacturing PMI Flash"""

            CommbankServicesPurchasingManagersIndexFinal: str = "commbank services purchasing managers index final"
            """CommBank Services PMI Final"""

            CommbankServicesPurchasingManagersIndexFlash: str = "commbank services purchasing managers index flash"
            """CommBank Services PMI Flash"""

            CompanyGrossOperatingProfitsQoQ: str = "company gross operating profits qoq"
            """Company Gross Operating Profits (QoQ)"""

            CompanyGrossProfitsQoQ: str = "company gross profits qoq"
            """Company Gross Profits QoQ"""

            ConstructionWorkDone: str = "construction work done"
            """Construction Work Done"""

            ConstructionWorkDoneQoQ: str = "construction work done qoq"
            """Construction Work Done QoQ"""

            ConsumerInflationExpectations: str = "consumer inflation expectations"
            """Consumer Inflation Expectation"""

            ConsumerPriceIndex: str = "consumer price index"
            """Consumer Price Index"""

            CurrentAccount: str = "current account"
            """Current Account"""

            EasterMonday: str = "easter monday"
            """Easter Monday"""

            EasterSaturday: str = "easter saturday"
            """Easter Saturday"""

            EasterSunday: str = "easter sunday"
            """Easter Sunday"""

            EmploymentChange: str = "employment change"
            """Employment Change"""

            EmploymentChangeSeasonallyAdjusted: str = "employment change seasonally adjusted"
            """Employment Change s.a."""

            ExportPricesQoQ: str = "export prices qoq"
            """Export Price Index QoQ"""

            ExportsMoM: str = "exports mom"
            """Exports MoM"""

            ExportsYoY: str = "exports yoy"
            """Exports YoY"""

            FamilyDay: str = "family day"
            """Family Day"""

            FederalElection: str = "federal election"
            """Federal Election"""

            FullTimeEmploymentChange: str = "full time employment change"
            """Fulltime Employment"""

            GdpAnnualGrowthRateYoY: str = "gdp annual growth rate yoy"
            """GDP Annual Growth Rate YoY"""

            GdpCapitalExpenditure: str = "gdp capital expenditure"
            """GDP Capital Expenditure"""

            GdpCapitalExpenditureQoQ: str = "gdp capital expenditure qoq"
            """GDP Capital Expenditure QoQ"""

            GdpDeflator: str = "gdp deflator"
            """GDP Deflator"""

            GdpDeflatorQoQ: str = "gdp deflator qoq"
            """GDP Deflator QoQ"""

            GdpFinalConsumption: str = "gdp final consumption"
            """GDP Final Consumption"""

            GdpFinalConsumptionQoQ: str = "gdp final consumption qoq"
            """GDP Final Consumption QoQ"""

            GdpGrowthRateQoQ: str = "gdp growth rate qoq"
            """GDP Growth Rate QoQ"""

            GdpGrowthRateYoY: str = "gdp growth rate yoy"
            """GDP Growth Rate YoY"""

            GoodFriday: str = "good friday"
            """Good Friday"""

            GTwentyMeeting: str = "g20 meeting"
            """G20 Meeting"""

            HiaNewHomeSalesMoM: str = "hia new home sales mom"
            """HIA New Home Sales (MoM)"""

            HomeLoansMoM: str = "home loans mom"
            """Home Loans MoM"""

            HousePriceIndexQoQ: str = "house price index qoq"
            """House Price Index QoQ"""

            HousePriceIndexYoY: str = "house price index yoy"
            """House Price Index YoY"""

            ImportPricesQoQ: str = "import prices qoq"
            """Import Price Index QoQ"""

            ImportsMoM: str = "imports mom"
            """Imports MoM"""

            ImportsYoY: str = "imports yoy"
            """Imports YoY"""

            InflationRateQoQ: str = "inflation rate qoq"
            """Inflation Rate QoQ"""

            InflationRateYoY: str = "inflation rate yoy"
            """Inflation Rate YoY"""

            InvestmentLendingForHomes: str = "investment lending for homes"
            """Investment Lending for Homes"""

            LaborDay: str = "labor day"
            """Labour Day"""

            MidYearEconomicAndFiscalOutlook: str = "mid year economic and fiscal outlook"
            """Mid-Year Economic and Fiscal Outlook"""

            NabBusinessConfidence: str = "nab business confidence"
            """NAB Business Confidence"""

            NabBusinessSurvey: str = "nab business survey"
            """NAB Business Survey"""

            NewMotorVehicleSalesMoM: str = "new motor vehicle sales mom"
            """New Motor Vehicle Sales (MoM)"""

            NewMotorVehicleSalesYoY: str = "new motor vehicle sales yoy"
            """New Motor Vehicle Sales (YoY)"""

            NewYearsDay: str = "new years day"
            """New Year's Day"""

            NewYearsDaySubstituteDay: str = "new years day substitute day"
            """New Year's Day (Substitute Day)"""

            ParticipationRate: str = "participation rate"
            """Participation Rate"""

            PartTimeEmploymentChange: str = "part time employment change"
            """Part Time Employment Chg"""

            PrivateCapitalExpenditureQoQ: str = "private capital expenditure qoq"
            """Private Capital Expenditure QoQ"""

            PrivateNewCapitalExpenditureQoQ: str = "private new capital expenditure qoq"
            """Private New Capital Expenditure QoQ"""

            PrivateSectorCreditMoM: str = "private sector credit mom"
            """Private Sector Credit (MoM)"""

            PrivateSectorCreditYoY: str = "private sector credit yoy"
            """Private Sector Credit (YoY)"""

            ProducerPriceIndexQoQ: str = "producer price index qoq"
            """Producer Price Index QoQ"""

            ProducerPriceIndexYoY: str = "producer price index yoy"
            """PPI YoY"""

            QueensBirthday: str = "queens birthday"
            """Queen's Birthday"""

            QueensBirthdayDay: str = "queens birthday day"
            """Queen's Birthday Day"""

            RbaAssistGovEdeySpeech: str = "rba assist gov edey speech"
            """RBA Assist Gov Edey Speech"""

            RbaAssistGovKentSpeech: str = "rba assist gov kent speech"
            """RBA Assist Gov Kent Speech"""

            RbaAylmerSpeech: str = "rba aylmer speech"
            """RBA Aylmer Speech"""

            RbaBoultonSpeech: str = "rba boulton speech"
            """RBA Boulton Speech"""

            RbaBulletin: str = "rba bulletin"
            """RBA Bulletin"""

            RbaBullockSpeech: str = "rba bullock speech"
            """RBA Bullock Speech"""

            RbaChartPack: str = "rba chart pack"
            """RBA Chart Pack"""

            RbaCommodityIndexSdrYoY: str = "rba commodity index sdr yoy"
            """RBA Commodity Index SDR (YoY)"""

            RbaCoombsSpeech: str = "rba coombs speech"
            """RBA Coombs Speech"""

            RbaDebelleSpeech: str = "rba debelle speech"
            """RBA Debelle Speech"""

            RbaDeputyGovLoweSpeech: str = "rba deputy gov lowe speech"
            """RBA Deputy Gov Lowe Speech"""

            RbaEdeySpeech: str = "rba edey speech"
            """RBA Edey Speech"""

            RbaEllisSpeech: str = "rba ellis speech"
            """RBA Ellis Speech"""

            RbaFinancialStabilityReview: str = "rba financial stability review"
            """RBA Financial Stability Review"""

            RbaGirnSpeech: str = "rba girn speech"
            """RBA Girn Speech"""

            RbaGovDebelleSpeech: str = "rba gov debelle speech"
            """RBA Gov Debelle Speech"""

            RbaGovernorStevensSpeaks: str = "rba governor stevens speaks"
            """RBA Governor Stevens Speaks"""

            RbaGovGlennSpeech: str = "rba gov glenn speech"
            """RBA Gov Glenn Speech"""

            RbaGovGlennStevensSpeech: str = "rba gov glenn stevens speech"
            """RBA Gov. Glenn Stevens Speech"""

            RbaGovKentSpeech: str = "rba gov kent speech"
            """RBA Gov Kent Speech"""

            RbaGovLoweSpeech: str = "rba gov lowe speech"
            """RBA Gov Lowe Speech"""

            RbaHeathSpeech: str = "rba heath speech"
            """RBA Heath Speech"""

            RbaInterestRateDecision: str = "rba interest rate decision"
            """RBA Interest Rate Decision"""

            RbaKentSpeech: str = "rba kent speech"
            """RBA Kent Speech"""

            RbaKohlerSpeech: str = "rba kohler speech"
            """RBA Kohler Speech"""

            RbaLoweSpeaksBeforeParliament: str = "rba lowe speaks before parliament"
            """RBA Lowe Speaks before Parliament"""

            RbaLoweSpeech: str = "rba lowe speech"
            """RBA Lowe Speech"""

            RbaMeetingMinutes: str = "rba meeting minutes"
            """RBA Meeting Minutes"""

            RbaMeetingsMinutes: str = "rba meetings minutes"
            """RBA Meetings Minutes"""

            RbaMonetaryPolicyStatement: str = "rba monetary policy statement"
            """RBA Monetary Policy Statement"""

            RbaRateStatement: str = "rba rate statement"
            """RBA Rate Statement"""

            RbaRichardsSpeech: str = "rba richards speech"
            """RBA Richards Speech"""

            RbaRyanSpeech: str = "rba ryan speech"
            """RBA Ryan Speech"""

            RbasGovernorGlennStevensSpeech: str = "rbas governor glenn stevens speech"
            """RBA's Governor Glenn Stevens Speech"""

            RbasGovStevensSpeech: str = "rbas gov stevens speech"
            """RBA's Gov Stevens Speech"""

            RbaSimonSpeech: str = "rba simon speech"
            """RBA Simon Speech"""

            RbaStatementOnMonetaryPolicy: str = "rba statement on monetary policy"
            """RBA Statement on Monetary Policy"""

            RbaTrimmedMeanConsumerPriceIndexQoQ: str = "rba trimmed mean consumer price index qoq"
            """RBA trimmed mean CPI QoQ"""

            RbaTrimmedMeanConsumerPriceIndexYoY: str = "rba trimmed mean consumer price index yoy"
            """RBA trimmed mean CPI YoY"""

            RbaWeightedMeanConsumerPriceIndexQoQ: str = "rba weighted mean consumer price index qoq"
            """RBA Weighted Mean CPI QoQ"""

            RbaWeightedMeanConsumerPriceIndexYoY: str = "rba weighted mean consumer price index yoy"
            """RBA Weighted Mean CPI YoY"""

            ReconciliationDay: str = "reconciliation day"
            """Reconciliation Day"""

            RetailSalesMoM: str = "retail sales mom"
            """Retail Sales MoM"""

            RetailSalesYoY: str = "retail sales yoy"
            """Retail Sales YoY"""

            StatementOnMonetaryPolicy: str = "statement on monetary policy"
            """Statement on Monetary Policy"""

            TdMelbourneInstituteInflationGaugeMoM: str = "td melbourne institute inflation gauge mom"
            """TD-MI Inflation Gauge MoM"""

            TdSecuritiesInflationMoM: str = "td securities inflation mom"
            """TD Securities Inflation MoM"""

            TdSecuritiesInflationYoY: str = "td securities inflation yoy"
            """TD Securities Inflation (YoY)"""

            TwoThousandSeventeenEighteenBudgetRelease: str = "2017 18 budget release"
            """2017-18 Budget Release"""

            UnemploymentRate: str = "unemployment rate"
            """Unemployment Rate"""

            WagePriceIndexQoQ: str = "wage price index qoq"
            """Wage Price Index QoQ"""

            WagePriceIndexYoY: str = "wage price index yoy"
            """Wage Price Index YoY"""

            WestpacConsumerConfidence: str = "westpac consumer confidence"
            """Westpac Consumer Confidence"""

            WestpacConsumerConfidenceChange: str = "westpac consumer confidence change"
            """Westpac Cons. Conf. Change"""

            WestpacConsumerConfidenceMoM: str = "westpac consumer confidence mom"
            """Westpac Consumer Confidence MoM"""

            WestpacLeadingIndex: str = "westpac leading index"
            """Westpac Leading Index"""

            WestpacLeadingIndexMoM: str = "westpac leading index mom"
            """Westpac Leading Index MoM"""

        class Austria(System.Object):
            """Austria"""

            AllSaintsDay: str = "all saints day"
            """All Saint's Day"""

            AscensionDay: str = "ascension day"
            """Ascension Day"""

            AssumptionOfMary: str = "assumption of mary"
            """Assumption of Mary"""

            BalanceOfTrade: str = "balance of trade"
            """Balance of Trade"""

            BankOfAustriaManufacturingPurchasingManagersIndex: str = "bank of austria manufacturing purchasing managers index"
            """Bank Austria Manufacturing PMI"""

            BoxingDay: str = "boxing day"
            """Boxing Day"""

            BusinessConfidence: str = "business confidence"
            """Business Confidence"""

            ChristmasDay: str = "christmas day"
            """Christmas Day"""

            ChristmasEve: str = "christmas eve"
            """Christmas Eve"""

            ConsumerConfidence: str = "consumer confidence"
            """Consumer Confidence"""

            CorpusChristi: str = "corpus christi"
            """Corpus Christi"""

            CurrentAccount: str = "current account"
            """Current Account"""

            EasterMonday: str = "easter monday"
            """Easter Monday"""

            EasterSunday: str = "easter sunday"
            """Easter Sunday"""

            Epiphany: str = "epiphany"
            """Epiphany"""

            FinanceMinisterSchellingSpeech: str = "finance minister schelling speech"
            """Finance Minister Schelling Speech"""

            GdpAnnualGrowthRateYoY: str = "gdp annual growth rate yoy"
            """GDP Annual Growth Rate YoY"""

            GdpGrowthRateQoQ: str = "gdp growth rate qoq"
            """GDP Growth Rate QoQ"""

            GdpGrowthRateQoQFinal: str = "gdp growth rate qoq final"
            """GDP Growth Rate QoQ Final"""

            GdpGrowthRateQoQFlash: str = "gdp growth rate qoq flash"
            """GDP Growth Rate QoQ Flash"""

            GdpGrowthRateYoY: str = "gdp growth rate yoy"
            """GDP Growth Rate YoY"""

            GdpGrowthRateYoYFinal: str = "gdp growth rate yoy final"
            """GDP Growth Rate YoY Final"""

            GdpGrowthRateYoYFlash: str = "gdp growth rate yoy flash"
            """GDP Growth Rate YoY Flash"""

            GoodFriday: str = "good friday"
            """Good Friday"""

            HarmonizedInflationRateMoM: str = "harmonized inflation rate mom"
            """Harmonised Inflation Rate MoM"""

            HarmonizedInflationRateYoY: str = "harmonized inflation rate yoy"
            """Harmonised Inflation Rate YoY"""

            ImfLagardeSpeech: str = "imf lagarde speech"
            """IMF Lagarde Speech"""

            ImmaculateConception: str = "immaculate conception"
            """Immaculate Conception"""

            IndustrialProductionYoY: str = "industrial production yoy"
            """Industrial Production YoY"""

            InflationRateMoM: str = "inflation rate mom"
            """Inflation Rate MoM"""

            InflationRateYoY: str = "inflation rate yoy"
            """Inflation Rate YoY"""

            LaborDay: str = "labor day"
            """Labour Day"""

            NationalDay: str = "national day"
            """National Day"""

            NewYearsDay: str = "new years day"
            """New Year's Day"""

            OenbGovNowotnySpeech: str = "oenb gov nowotny speech"
            """OeNB Gov Nowotny Speech"""

            OpecMeeting: str = "opec meeting"
            """OPEC Meeting"""

            PresidentialElection: str = "presidential election"
            """Presidential Election"""

            PresidentialElections: str = "presidential elections"
            """Presidential Elections"""

            ProducerPriceIndexMoM: str = "producer price index mom"
            """PPI MoM"""

            ProducerPriceIndexYoY: str = "producer price index yoy"
            """PPI YoY"""

            PurchasingManagersIndexManufacturing: str = "purchasing managers index manufacturing"
            """PMI Manufacturing"""

            RegionalElections: str = "regional elections"
            """Regional Elections"""

            RetailSalesMoM: str = "retail sales mom"
            """Retail Sales MoM"""

            RetailSalesYoY: str = "retail sales yoy"
            """Retail Sales YoY"""

            StStephensDay: str = "st stephens day"
            """St Stephen's Day"""

            UnemployedPersons: str = "unemployed persons"
            """Unemployed Persons"""

            UnemploymentRate: str = "unemployment rate"
            """Unemployment Rate"""

            WhitMonday: str = "whit monday"
            """Whit Monday"""

            WholesalePricesMoM: str = "wholesale prices mom"
            """Wholesale Prices MoM"""

            WholesalePricesNotSeasonallyAdjustedMoM: str = "wholesale prices not seasonally adjusted mom"
            """Wholesale Prices n.s.a (MoM)"""

            WholesalePricesNotSeasonallyAdjustedYoY: str = "wholesale prices not seasonally adjusted yoy"
            """Wholesale Prices n.s.a (YoY)"""

            WholesalePricesYoY: str = "wholesale prices yoy"
            """Wholesale Prices YoY"""

        class Belgium(System.Object):
            """Belgium"""

            AllSaintsDay: str = "all saints day"
            """All Saints' Day"""

            ArmisticeDay: str = "armistice day"
            """Armistice Day"""

            AscensionDay: str = "ascension day"
            """Ascension Day"""

            AssumptionOfMary: str = "assumption of mary"
            """Assumption of Mary"""

            BalanceOfTrade: str = "balance of trade"
            """Balance of Trade"""

            BusinessConfidence: str = "business confidence"
            """Business Confidence"""

            ChristmasDay: str = "christmas day"
            """Christmas Day"""

            ConsumerConfidence: str = "consumer confidence"
            """Consumer Confidence"""

            CurrentAccount: str = "current account"
            """Current Account"""

            EasterMonday: str = "easter monday"
            """Easter Monday"""

            EuChinaSummit: str = "eu china summit"
            """EU-China Summit"""

            GdpAnnualGrowthRateYoY: str = "gdp annual growth rate yoy"
            """GDP Annual Growth Rate YoY"""

            GdpGrowthRateQoQ: str = "gdp growth rate qoq"
            """GDP Growth Rate QoQ"""

            GdpGrowthRateQoQAdv: str = "gdp growth rate qoq adv"
            """GDP Growth Rate QoQ Adv"""

            GdpGrowthRateQoQFinal: str = "gdp growth rate qoq final"
            """GDP Growth Rate QoQ Final"""

            GdpGrowthRateQoQSecondEstimate: str = "gdp growth rate qoq second estimate"
            """GDP Growth Rate QoQ 2nd Est"""

            GdpGrowthRateYoY: str = "gdp growth rate yoy"
            """GDP Growth Rate YoY"""

            GdpGrowthRateYoYAdv: str = "gdp growth rate yoy adv"
            """GDP Growth Rate YoY Adv"""

            GdpGrowthRateYoYFinal: str = "gdp growth rate yoy final"
            """GDP Growth Rate YoY Final"""

            GdpGrowthRateYoYSecondEstimate: str = "gdp growth rate yoy second estimate"
            """GDP Growth Rate YoY 2nd Est"""

            IndustrialProductionMoM: str = "industrial production mom"
            """Industrial Production MoM"""

            IndustrialProductionYoY: str = "industrial production yoy"
            """Industrial Production YoY"""

            InflationRateMoM: str = "inflation rate mom"
            """Inflation Rate MoM"""

            InflationRateYoY: str = "inflation rate yoy"
            """Inflation Rate YoY"""

            LaborDay: str = "labor day"
            """Labour Day"""

            LocalElections: str = "local elections"
            """Local Elections"""

            NationalDay: str = "national day"
            """National Day"""

            NatoSummit: str = "nato summit"
            """NATO Summit"""

            NbbBusinessClimate: str = "nbb business climate"
            """NBB Business Climate"""

            NbbBusinessConfidence: str = "nbb business confidence"
            """NBB Business Confidence"""

            NewYearsDay: str = "new years day"
            """New Year’s Day"""

            ParliamentaryElections: str = "parliamentary elections"
            """Parliamentary Elections"""

            ProducerPriceIndexYoY: str = "producer price index yoy"
            """PPI YoY"""

            RetailSalesMoM: str = "retail sales mom"
            """Retail Sales MoM"""

            RetailSalesYoY: str = "retail sales yoy"
            """Retail Sales YoY"""

            UnemploymentRate: str = "unemployment rate"
            """Unemployment Rate"""

            WhitMonday: str = "whit monday"
            """Whit Monday"""

        class Canada(System.Object):
            """Canada"""

            AdpEmploymentChange: str = "adp employment change"
            """ADP Employment Change"""

            AlbertaGeneralElection: str = "alberta general election"
            """Alberta General Election"""

            AverageHourlyWagesYoY: str = "average hourly wages yoy"
            """Average Hourly Wages YoY"""

            AverageWeeklyEarningsYoY: str = "average weekly earnings yoy"
            """Average Weekly Earnings YoY"""

            BalanceOfTrade: str = "balance of trade"
            """Balance of Trade"""

            BankOfCanadaBeaudrySpeech: str = "bank of canada beaudry speech"
            """BoC Beaudry Speech"""

            BankOfCanadaBusinessOutlookSurvey: str = "bank of canada business outlook survey"
            """Bank of Canada Business Outlook Survey"""

            BankOfCanadaConsumerPriceIndexCoreMoM: str = "bank of canada consumer price index core mom"
            """Bank of Canada Consumer Price Index Core MoM"""

            BankOfCanadaConsumerPriceIndexCoreYoY: str = "bank of canada consumer price index core yoy"
            """Bank of Canada Consumer Price Index Core YoY"""

            BankOfCanadaCoreInflationMoM: str = "bank of canada core inflation mom"
            """Bank of Canada Core Inflation MoM"""

            BankOfCanadaCoreInflationYoY: str = "bank of canada core inflation yoy"
            """Bank of Canada Core Inflation YoY"""

            BankOfCanadaDeputyGovPattersonSpeech: str = "bank of canada deputy gov patterson speech"
            """BoC Deputy Gov Patterson Speech"""

            BankOfCanadaDeputyGovSchembriSpeech: str = "bank of canada deputy gov schembri speech"
            """BoC Deputy Gov Schembri Speech"""

            BankOfCanadaDeputyGovWilkinsSpeech: str = "bank of canada deputy gov wilkins speech"
            """BoC Deputy Gov Wilkins Speech"""

            BankOfCanadaFinancialSystemReview: str = "bank of canada financial system review"
            """BoC Financial System Review"""

            BankOfCanadaGovCarneySpeaks: str = "bank of canada gov carney speaks"
            """BoC Gov Carney Speaks"""

            BankOfCanadaGovPolozPressConference: str = "bank of canada gov poloz press conference"
            """BoC Gov Poloz Press Conference"""

            BankOfCanadaGovPolozSpeaks: str = "bank of canada gov poloz speaks"
            """BoC Gov Poloz Speaks"""

            BankOfCanadaGovPolozSpeech: str = "bank of canada gov poloz speech"
            """BoC Gov Poloz Speech"""

            BankOfCanadaGravelleSpeech: str = "bank of canada gravelle speech"
            """BoC Gravelle Speech"""

            BankOfCanadaInterestRateDecision: str = "bank of canada interest rate decision"
            """BoC Interest Rate Decision"""

            BankOfCanadaLaneSpeech: str = "bank of canada lane speech"
            """BoC Lane Speech"""

            BankOfCanadaLeducSpeech: str = "bank of canada leduc speech"
            """BoC Leduc Speech"""

            BankOfCanadaMonetaryPolicyReport: str = "bank of canada monetary policy report"
            """BoC Monetary Policy Report"""

            BankOfCanadaPattersonSpeech: str = "bank of canada patterson speech"
            """BoC Patterson Speech"""

            BankOfCanadaPressConference: str = "bank of canada press conference"
            """BoC Press Conference"""

            BankOfCanadaRateStatement: str = "bank of canada rate statement"
            """BoC Rate Statement"""

            BankOfCanadaReview: str = "bank of canada review"
            """BoC Review"""

            BankOfCanadaSchembriSpeech: str = "bank of canada schembri speech"
            """BoC Schembri Speech"""

            BankOfCanadaWilkinsSpeech: str = "bank of canada wilkins speech"
            """BoC Wilkins Speech"""

            BoxingDay: str = "boxing day"
            """Boxing Day"""

            BudgetBalance: str = "budget balance"
            """Budget Balance"""

            BuildingPermitsMoM: str = "building permits mom"
            """Building Permits (MoM)"""

            CanadaDay: str = "canada day"
            """Canada Day"""

            CanadaDaySubstituteDay: str = "canada day substitute day"
            """Canada Day (Substitute Day)"""

            CanadianInvestmentInForeignSecurities: str = "canadian investment in foreign securities"
            """Canadian portfolio investment in foreign securities"""

            CapacityUtilization: str = "capacity utilization"
            """Capacity Utilization"""

            ChristmasDay: str = "christmas day"
            """Christmas Day"""

            CivicHoliday: str = "civic holiday"
            """Civic Holiday"""

            ConsumerPriceIndexCoreMoM: str = "consumer price index core mom"
            """Consumer Price Index - Core MoM"""

            CoreConsumerPriceIndexYoY: str = "core consumer price index yoy"
            """Core CPI YoY"""

            CoreInflationRateMoM: str = "core inflation rate mom"
            """Core Inflation Rate MoM"""

            CoreInflationRateYoY: str = "core inflation rate yoy"
            """Core Inflation Rate YoY"""

            CoreRetailSalesMoM: str = "core retail sales mom"
            """Core Retail Sales MoM"""

            CurrentAccount: str = "current account"
            """Current Account"""

            EmploymentChange: str = "employment change"
            """Employment Change"""

            Exports: str = "exports"
            """Exports"""

            FamilyDay: str = "family day"
            """Family Day"""

            FederalElection: str = "federal election"
            """Federal Election"""

            FinanceMinisterMorneauSpeech: str = "finance minister morneau speech"
            """Finance Minister Morneau Speech"""

            ForeignInvestmentInCanadianSecurities: str = "foreign investment in canadian securities"
            """Foreign portfolio investment in Canadian securities"""

            ForeignSecuritiesPurchases: str = "foreign securities purchases"
            """Foreign Securities Purchases"""

            ForeignSecuritiesPurchasesByCanadians: str = "foreign securities purchases by canadians"
            """Foreign Securities Purchases by Canadians"""

            FullEmploymentChange: str = "full employment change"
            """Full Employment Change"""

            FullTimeEmploymentChange: str = "full time employment change"
            """Full Time Employment Chg"""

            GdpGrowthRateAnnualized: str = "gdp growth rate annualized"
            """GDP Growth Rate Annualized"""

            GdpGrowthRateQoQ: str = "gdp growth rate qoq"
            """GDP Growth Rate QoQ"""

            GdpGrowthRateYoY: str = "gdp growth rate yoy"
            """GDP Growth Rate YoY"""

            GdpImplicitPriceQoQ: str = "gdp implicit price qoq"
            """GDP Implicit Price QoQ"""

            GdpMoM: str = "gdp mom"
            """GDP MoM"""

            GoodFriday: str = "good friday"
            """Good Friday"""

            GrossDomesticProductMoM: str = "gross domestic product mom"
            """Gross Domestic Product (MoM)"""

            GSevenSummit: str = "g7 summit"
            """G7 Summit"""

            HousingStarts: str = "housing starts"
            """Housing Starts"""

            HousingStartsSeasonallyAdjustedYoY: str = "housing starts seasonally adjusted yoy"
            """Housing Starts s.a YoY"""

            HousingStartsYoY: str = "housing starts yoy"
            """Housing Starts YoY"""

            Imports: str = "imports"
            """Imports"""

            IndustrialProductPriceMoM: str = "industrial product price mom"
            """Industrial Product Price MoM"""

            IndustrialProductPriceYoY: str = "industrial product price yoy"
            """Industrial Product Price YoY"""

            InflationRateMoM: str = "inflation rate mom"
            """Inflation Rate MoM"""

            InflationRateYoY: str = "inflation rate yoy"
            """Inflation Rate YoY"""

            InvestmentInForeignSecurities: str = "investment in foreign securities"
            """Portfolio investment in foreign securities"""

            IveyPurchasingManagersIndexSeasonallyAdjusted: str = "ivey purchasing managers index seasonally adjusted"
            """Ivey PMI s.a"""

            JobVacancies: str = "job vacancies"
            """Job Vacancies"""

            LaborDay: str = "labor day"
            """Labour Day"""

            LaborProductivityQoQ: str = "labor productivity qoq"
            """Labor Productivity QoQ"""

            ManufacturingSalesMoM: str = "manufacturing sales mom"
            """Manufacturing Sales MoM"""

            ManufacturingSalesYoY: str = "manufacturing sales yoy"
            """Manufacturing Sales YoY"""

            ManufacturingShipmentsMoM: str = "manufacturing shipments mom"
            """Manufacturing Shipments MoM"""

            ManufacturingShipmentsYoY: str = "manufacturing shipments yoy"
            """Manufacturing Shipments YoY"""

            MarkitManufacturingPurchasingManagersIndex: str = "markit manufacturing purchasing managers index"
            """Markit Manufacturing PMI"""

            NetChangeInEmployment: str = "net change in employment"
            """Net Change in Employment"""

            NewBrunswickProvincialElections: str = "new brunswick provincial elections"
            """New Brunswick Provincial Elections"""

            NewHousingPriceIndexMoM: str = "new housing price index mom"
            """New Housing Price Index (MoM)"""

            NewHousingPriceIndexYoY: str = "new housing price index yoy"
            """New Housing Price Index (YoY)"""

            NewMotorVehicleSales: str = "new motor vehicle sales"
            """New Motor Vehicle Sales"""

            NewYearsDay: str = "new years day"
            """New Year's Day"""

            NewYearsDaySubstituteDay: str = "new years day substitute day"
            """New Year's Day (Substitute Day)"""

            OntarioProvincialElections: str = "ontario provincial elections"
            """Ontario Provincial Elections"""

            ParliamentaryElections: str = "parliamentary elections"
            """Parliamentary Elections"""

            ParticipationRate: str = "participation rate"
            """Participation rate"""

            PartTimeEmploymentChange: str = "part time employment change"
            """Part Time Employment Chg"""

            ProducerPriceIndexMoM: str = "producer price index mom"
            """PPI MoM"""

            ProducerPriceIndexYoY: str = "producer price index yoy"
            """PPI YoY"""

            QuebecProvincialElections: str = "quebec provincial elections"
            """Quebec Provincial Elections"""

            RawMaterialsPriceIndexMoM: str = "raw materials price index mom"
            """Raw Materials Price Index MoM"""

            RawMaterialsPriceIndexYoY: str = "raw materials price index yoy"
            """Raw Materials Price Index YoY"""

            RbcManufacturingPurchasingManagersIndex: str = "rbc manufacturing purchasing managers index"
            """RBC Manufacturing PMI"""

            RemembranceDay: str = "remembrance day"
            """Remembrance Day"""

            RetailSalesExcludingAutosMoM: str = "retail sales excluding autos mom"
            """Retail Sales Ex Autos MoM"""

            RetailSalesMoM: str = "retail sales mom"
            """Retail Sales MoM"""

            RetailSalesYoY: str = "retail sales yoy"
            """Retail Sales YoY"""

            StockInvestmentByForeigners: str = "stock investment by foreigners"
            """Stock Investment by Foreigners"""

            ThanksgivingDay: str = "thanksgiving day"
            """Thanksgiving Day"""

            TwoThousandSixteenBudgetAnnouncement: str = "2016 budget announcement"
            """2016 Budget Announcement"""

            UnemploymentRate: str = "unemployment rate"
            """Unemployment Rate"""

            VictoriaDay: str = "victoria day"
            """Victoria Day"""

            WholesaleSalesMoM: str = "wholesale sales mom"
            """Wholesale Sales MoM"""

            WholesaleSalesYoY: str = "wholesale sales yoy"
            """Wholesale Sales YoY"""

        class China(System.Object):
            """China"""

            BalanceOfTrade: str = "balance of trade"
            """Balance of Trade"""

            BeltAndRoadForum: str = "belt and road forum"
            """Belt and Road Forum"""

            CaixinCompositePurchasingManagersIndex: str = "caixin composite purchasing managers index"
            """Caixin Composite PMI"""

            CaixinManufacturingPurchasingManagersIndex: str = "caixin manufacturing purchasing managers index"
            """Caixin Manufacturing PMI"""

            CaixinManufacturingPurchasingManagersIndexFinal: str = "caixin manufacturing purchasing managers index final"
            """Caixin Manufacturing PMI Final"""

            CaixinManufacturingPurchasingManagersIndexFlash: str = "caixin manufacturing purchasing managers index flash"
            """Caixin Manufacturing PMI Flash"""

            CaixinServicesPurchasingManagersIndex: str = "caixin services purchasing managers index"
            """Caixin Services PMI"""

            CapitalFlows: str = "capital flows"
            """Capital Flows"""

            CbLeadingEconomicIndex: str = "cb leading economic index"
            """CB Leading Economic Index"""

            CentralEconomicWorkConference: str = "central economic work conference"
            """Central Economic Work Conference"""

            ChineseNewYear: str = "chinese new year"
            """Chinese New Year"""

            ChinesePeoplesPoliticalConsultativeConference: str = "chinese peoples political consultative conference"
            """Chinese People’s Political Consultative Conference"""

            CurrentAccount: str = "current account"
            """Current Account"""

            DragonBoatFestival: str = "dragon boat festival"
            """Dragon Boat Festival"""

            EuChinaSummit: str = "eu china summit"
            """EU-China Summit"""

            Exports: str = "exports"
            """Exports"""

            ExportsYoY: str = "exports yoy"
            """Exports YoY"""

            FirstDayNationalPeoplesCongress: str = "first day national peoples congress"
            """1st Day National People's Congress"""

            FixedAssetInvestmentYtdYoY: str = "fixed asset investment ytd yoy"
            """Fixed Asset Investment (YTD) YoY"""

            ForeignDirectInvestmentYtdYoY: str = "foreign direct investment ytd yoy"
            """FDI (YTD) YoY"""

            ForeignExchangeReserves: str = "foreign exchange reserves"
            """Foreign Exchange Reserves"""

            GdpGrowthRateQoQ: str = "gdp growth rate qoq"
            """GDP Growth Rate QoQ"""

            GdpGrowthRateYoY: str = "gdp growth rate yoy"
            """GDP Growth Rate YoY"""

            GTwentyFinMinistersAndCbGovernorsMeeting: str = "g20 fin ministers and cb governors meeting"
            """G20 Fin Ministers and CB Governors Meeting"""

            GTwentyMeeting: str = "g20 meeting"
            """G20 Meeting"""

            HousePriceIndexMoM: str = "house price index mom"
            """House Price Index MoM"""

            HousePriceIndexYoY: str = "house price index yoy"
            """House Price Index YoY"""

            HsbcChinaServicesPurchasingManagersIndex: str = "hsbc china services purchasing managers index"
            """HSBC China Services PMI"""

            HsbcManufacturingPurchasingManagersIndex: str = "hsbc manufacturing purchasing managers index"
            """HSBC Manufacturing PMI"""

            HsbcManufacturingPurchasingManagersIndexFinal: str = "hsbc manufacturing purchasing managers index final"
            """HSBC Manufacturing PMI Final"""

            HsbcManufacturingPurchasingManagersIndexFlash: str = "hsbc manufacturing purchasing managers index flash"
            """HSBC Manufacturing PMI Flash"""

            HsbcManufacturingPurchasingManagersIndexPreliminary: str = "hsbc manufacturing purchasing managers index preliminary"
            """HSBC Manufacturing PMI Prel."""

            HsbcServicesPurchasingManagersIndex: str = "hsbc services purchasing managers index"
            """HSBC Services PMI"""

            Imports: str = "imports"
            """Imports"""

            ImportsYoY: str = "imports yoy"
            """Imports YoY"""

            IndustrialCapacityUtilization: str = "industrial capacity utilization"
            """Industrial Capacity Capacity Utilization"""

            IndustrialProductionYoY: str = "industrial production yoy"
            """Industrial Production YoY"""

            IndustrialProfitsYtdYoY: str = "industrial profits ytd yoy"
            """Industrial Profits (YTD) YoY"""

            InflationRateMoM: str = "inflation rate mom"
            """Inflation Rate MoM"""

            InflationRateYoY: str = "inflation rate yoy"
            """Inflation Rate YoY"""

            InterestRateDecision: str = "interest rate decision"
            """Interest Rate Decision"""

            LaborDay: str = "labor day"
            """Labour Day"""

            LoanPrimeRateFiveYear: str = "loan prime rate 5y"
            """Loan Prime Rate 5Y"""

            LoanPrimeRateOneYear: str = "loan prime rate 1y"
            """Loan Prime Rate 1Y"""

            MidAutumnFestival: str = "mid autumn festival"
            """Mid-Autumn Festival"""

            MidAutumnHoliday: str = "mid autumn holiday"
            """Mid-Autumn Holiday"""

            MniBusinessSentiment: str = "mni business sentiment"
            """MNI Business Sentiment"""

            MTwoMoneySupplyYoY: str = "m2 money supply yoy"
            """M2 Money Supply YoY"""

            NationalDay: str = "national day"
            """National Day"""

            NationalPeoplesCongress: str = "national peoples congress"
            """National People’s Congress"""

            NbsManufacturingPurchasingManagersIndex: str = "nbs manufacturing purchasing managers index"
            """NBS Manufacturing PMI"""

            NbsPressConference: str = "nbs press conference"
            """NBS Press Conference"""

            NewLoans: str = "new loans"
            """New Loans"""

            NewYearsDay: str = "new years day"
            """New Year's Day"""

            NewYuanLoans: str = "new yuan loans"
            """New Yuan Loans"""

            NonManufacturingPurchasingManagersIndex: str = "non manufacturing purchasing managers index"
            """Non Manufacturing PMI"""

            OutstandingLoanGrowthYoY: str = "outstanding loan growth yoy"
            """Outstanding Loan Growth YoY"""

            PresidentJinpingSpeechAtBoaoForum: str = "president jinping speech at boao forum"
            """President Jinping Speech at Boao Forum"""

            PresidentXiJinpingSpeech: str = "president xi jinping speech"
            """President Xi Jinping Speech"""

            ProducerPriceIndexYoY: str = "producer price index yoy"
            """PPI YoY"""

            QingMingJie: str = "qing ming jie"
            """Qing Ming Jie"""

            RetailSalesYoY: str = "retail sales yoy"
            """Retail Sales YoY"""

            TotalSocialFinancing: str = "total social financing"
            """Total Social Financing"""

            UrbanInvestmentYoY: str = "urban investment yoy"
            """Urban Investment YoY"""

            UrbanInvestmentYtd: str = "urban investment ytd"
            """Urban Investment YTD"""

            UrbanInvestmentYtdYoY: str = "urban investment ytd yoy"
            """Urban investment (YTD) (YoY)"""

            UsChinaTradeTalks: str = "us china trade talks"
            """US-China Trade Talks"""

            VehicleSalesYoY: str = "vehicle sales yoy"
            """Vehicle Sales YoY"""

            VictoryDay: str = "victory day"
            """Victory Day"""

            WestpacMniConsumerSentiment: str = "westpac mni consumer sentiment"
            """Westpac MNI Consumer Sentiment Indicator"""

        class Cyprus(System.Object):
            """Cyprus"""

            AssumptionOfMary: str = "assumption of mary"
            """Assumption of Mary"""

            BalanceOfTrade: str = "balance of trade"
            """Balance of Trade"""

            BoxingDay: str = "boxing day"
            """Boxing Day"""

            BusinessConfidence: str = "business confidence"
            """Business Confidence"""

            CatholicChristmasDay: str = "catholic christmas day"
            """Catholic Christmas Day"""

            ChristmasDay: str = "christmas day"
            """Christmas Day"""

            CleanMonday: str = "clean monday"
            """Clean Monday"""

            ConstructionOutputYoY: str = "construction output yoy"
            """Construction Output YoY"""

            ConsumerConfidence: str = "consumer confidence"
            """Consumer Confidence"""

            CurrentAccount: str = "current account"
            """Current Account"""

            Epiphany: str = "epiphany"
            """Epiphany"""

            GdpAnnualGrowthRateYoY: str = "gdp annual growth rate yoy"
            """GDP Annual Growth Rate YoY"""

            GdpGrowthRateFinal: str = "gdp growth rate final"
            """GDP Growth Rate - Final"""

            GdpGrowthRateQoQ: str = "gdp growth rate qoq"
            """GDP Growth Rate QoQ"""

            GdpGrowthRateQoQFinal: str = "gdp growth rate qoq final"
            """GDP Growth Rate QoQ Final"""

            GdpGrowthRateQoQFlash: str = "gdp growth rate qoq flash"
            """GDP Growth Rate QoQ Flash"""

            GdpGrowthRateYoY: str = "gdp growth rate yoy"
            """GDP Growth Rate YoY"""

            GdpGrowthRateYoYFinal: str = "gdp growth rate yoy final"
            """GDP Growth Rate YoY Final"""

            GdpGrowthRateYoYFlash: str = "gdp growth rate yoy flash"
            """GDP Growth Rate YoY Flash"""

            GreekIndependenceDay: str = "greek independence day"
            """Greek Independence Day"""

            HarmonizedInflationRateYoY: str = "harmonized inflation rate yoy"
            """Harmonised Inflation Rate YoY"""

            IndependenceDay: str = "independence day"
            """Independence Day"""

            IndustrialProduction: str = "industrial production"
            """Industrial Production"""

            IndustrialProductionYoY: str = "industrial production yoy"
            """Industrial Production YoY"""

            InflationRateYoY: str = "inflation rate yoy"
            """Inflation Rate YoY"""

            LaborDay: str = "labor day"
            """Labour Day"""

            NationalDay: str = "national day"
            """National Day"""

            NewYearsDay: str = "new years day"
            """New Year's Day"""

            OchiDay: str = "ochi day"
            """Ochi Day"""

            OrthodoxEasterMonday: str = "orthodox easter monday"
            """Orthodox Easter Monday"""

            OrthodoxEasterSunday: str = "orthodox easter sunday"
            """Orthodox Easter Sunday"""

            OrthodoxEasterTuesday: str = "orthodox easter tuesday"
            """Orthodox Easter Tuesday"""

            OrthodoxGoodFriday: str = "orthodox good friday"
            """Orthodox Good Friday"""

            OrthodoxWhitMonday: str = "orthodox whit monday"
            """Orthodox Whit Monday"""

            ParliamentaryElections: str = "parliamentary elections"
            """Parliamentary Elections"""

            ParliamentVoteOnDepositLevyForBailoutPlan: str = "parliament vote on deposit levy for bailout plan"
            """Parliament Vote on Deposit Levy for Bailout Plan"""

            PresidentialElection: str = "presidential election"
            """Presidential Election"""

            PresidentialElectionRoundTwo: str = "presidential election round 2"
            """Presidential Election Round 2"""

            RetailSalesYoY: str = "retail sales yoy"
            """Retail Sales YoY"""

            UnemploymentRate: str = "unemployment rate"
            """Unemployment Rate"""

            WageGrowthYoY: str = "wage growth yoy"
            """Wage Growth YoY"""

        class Estonia(System.Object):
            """Estonia"""

            BalanceOfTrade: str = "balance of trade"
            """Balance of Trade"""

            BoxingDay: str = "boxing day"
            """Boxing Day"""

            BusinessConfidence: str = "business confidence"
            """Business Confidence"""

            ChristmasDay: str = "christmas day"
            """Christmas Day"""

            ChristmasEve: str = "christmas eve"
            """Christmas Eve"""

            CurrentAccount: str = "current account"
            """Current Account"""

            EasterSunday: str = "easter sunday"
            """Easter Sunday"""

            EestiPankEconomicForecast: str = "eesti pank economic forecast"
            """Eesti Pank Economic Forecast"""

            EestiPankGovHanssonSpeech: str = "eesti pank gov hansson speech"
            """Eesti Pank Gov Hansson Speech"""

            GdpAnnualGrowthRateYoY: str = "gdp annual growth rate yoy"
            """GDP Annual Growth Rate YoY"""

            GdpGrowthRateQoQ: str = "gdp growth rate qoq"
            """GDP Growth Rate QoQ"""

            GdpGrowthRateQoQFinal: str = "gdp growth rate qoq final"
            """GDP Growth Rate QoQ Final"""

            GdpGrowthRateQoQPreliminary: str = "gdp growth rate qoq preliminary"
            """GDP Growth Rate QoQ Prel"""

            GdpGrowthRateQoQSecondEstimate: str = "gdp growth rate qoq second estimate"
            """GDP Growth Rate QoQ Second Estimate"""

            GdpGrowthRateYoY: str = "gdp growth rate yoy"
            """GDP Growth Rate YoY"""

            GdpGrowthRateYoYFinal: str = "gdp growth rate yoy final"
            """GDP Growth Rate YoY Final"""

            GdpGrowthRateYoYPreliminary: str = "gdp growth rate yoy preliminary"
            """GDP Growth Rate YoY Prel"""

            GdpGrowthRateYoYSecondEstimate: str = "gdp growth rate yoy second estimate"
            """GDP Growth Rate YoY 2nd Est"""

            GoodFriday: str = "good friday"
            """Good Friday"""

            Imports: str = "imports"
            """Imports"""

            IndependenceDay: str = "independence day"
            """Independence Day"""

            IndependenceRestorationDay: str = "independence restoration day"
            """Independence Restoration Day"""

            IndustrialProductionMoM: str = "industrial production mom"
            """Industrial Production MoM"""

            IndustrialProductionYoY: str = "industrial production yoy"
            """Industrial Production YoY"""

            InflationRateMoM: str = "inflation rate mom"
            """Inflation Rate MoM"""

            InflationRateYoY: str = "inflation rate yoy"
            """Inflation Rate YoY"""

            MidsummerDay: str = "midsummer day"
            """Midsummer Day"""

            NewYearsDay: str = "new years day"
            """New Year's Day"""

            ParliamentaryElections: str = "parliamentary elections"
            """Parliamentary Elections"""

            Pentecost: str = "pentecost"
            """Pentecost"""

            PresidentialElections: str = "presidential elections"
            """Presidential Elections"""

            ProducerPriceIndexMoM: str = "producer price index mom"
            """PPI MoM"""

            ProducerPriceIndexYoY: str = "producer price index yoy"
            """PPI YoY"""

            RetailSalesMoM: str = "retail sales mom"
            """Retail Sales MoM"""

            RetailSalesYoY: str = "retail sales yoy"
            """Retail Sales YoY"""

            SpringDay: str = "spring day"
            """Spring Day"""

            UnemploymentRate: str = "unemployment rate"
            """Unemployment Rate"""

            VictoryDay: str = "victory day"
            """Victory Day"""

        class Finland(System.Object):
            """Finland"""

            AllSaintsDay: str = "all saints day"
            """All Saints' Day"""

            AscensionDay: str = "ascension day"
            """Ascension Day"""

            BalanceOfTrade: str = "balance of trade"
            """Balance of Trade"""

            BofGovLiikanenSpeech: str = "bof gov liikanen speech"
            """BoF Gov Liikanen Speech"""

            BofLiikanenSpeech: str = "bof liikanen speech"
            """BoF Liikanen Speech"""

            BoxingDay: str = "boxing day"
            """Boxing Day"""

            BusinessConfidence: str = "business confidence"
            """Business Confidence"""

            ChristmasDay: str = "christmas day"
            """Christmas Day"""

            ChristmasEve: str = "christmas eve"
            """Christmas Eve"""

            ConsumerConfidence: str = "consumer confidence"
            """Consumer Confidence"""

            CurrentAccount: str = "current account"
            """Current Account"""

            EasterMonday: str = "easter monday"
            """Easter Monday"""

            EasterSunday: str = "easter sunday"
            """Easter Sunday"""

            Epiphany: str = "epiphany"
            """Epiphany"""

            EpiphanyDay: str = "epiphany day"
            """Epiphany Day"""

            ExportPricesYoY: str = "export prices yoy"
            """Export Prices YoY"""

            GdpGrowthRate: str = "gdp growth rate"
            """GDP Growth Rate"""

            GdpGrowthRateQoQ: str = "gdp growth rate qoq"
            """GDP Growth Rate QoQ"""

            GdpGrowthRateQoQFinal: str = "gdp growth rate qoq final"
            """GDP Growth Rate QoQ Final"""

            GdpGrowthRateQoQFlash: str = "gdp growth rate qoq flash"
            """GDP Growth Rate QoQ - Flash"""

            GdpGrowthRateQoQPreliminary: str = "gdp growth rate qoq preliminary"
            """GDP Growth Rate QoQ Prel"""

            GdpGrowthRateYoY: str = "gdp growth rate yoy"
            """GDP Growth Rate YoY"""

            GdpGrowthRateYoYFinal: str = "gdp growth rate yoy final"
            """GDP Growth Rate YoY Final"""

            GdpGrowthRateYoYPreliminary: str = "gdp growth rate yoy preliminary"
            """GDP Growth Rate YoY Prel"""

            GdpYoY: str = "gdp yoy"
            """GDP YoY"""

            GoodFriday: str = "good friday"
            """Good Friday"""

            ImportPrices: str = "import prices"
            """Import Prices"""

            ImportPricesYoY: str = "import prices yoy"
            """Import Prices YoY"""

            IndependenceDay: str = "independence day"
            """Independence Day"""

            IndustrialProductionMoM: str = "industrial production mom"
            """Industrial Production MoM"""

            IndustrialProductionYoY: str = "industrial production yoy"
            """Industrial Production YoY"""

            InflationRateMoM: str = "inflation rate mom"
            """Inflation Rate MoM"""

            InflationRateYoY: str = "inflation rate yoy"
            """Inflation Rate YoY"""

            MidsummerDay: str = "midsummer day"
            """Midsummer Day"""

            MidsummerEve: str = "midsummer eve"
            """Midsummer Eve"""

            NewYearsDay: str = "new years day"
            """New Year's Day"""

            ParliamentaryElections: str = "parliamentary elections"
            """Parliamentary Elections"""

            Pentecost: str = "pentecost"
            """Pentecost"""

            PresidentialElection: str = "presidential election"
            """Presidential Election"""

            ProducerPriceIndexYoY: str = "producer price index yoy"
            """PPI YoY"""

            RetailSalesMoM: str = "retail sales mom"
            """Retail Sales MoM"""

            RetailSalesYoY: str = "retail sales yoy"
            """Retail Sales YoY"""

            UnemploymentRate: str = "unemployment rate"
            """Unemployment Rate"""

            VappuMayDay: str = "vappu may day"
            """Vappu (May Day)"""

        class France(System.Object):
            """France"""

            AllSaintsDay: str = "all saints day"
            """All Saints' Day"""

            ArmisticeDay: str = "armistice day"
            """Armistice Day"""

            AscensionDay: str = "ascension day"
            """Ascension Day"""

            AssumptionOfMary: str = "assumption of mary"
            """Assumption of Mary"""

            BalanceOfTrade: str = "balance of trade"
            """Balance of Trade"""

            BastilleDay: str = "bastille day"
            """Bastille Day"""

            BudgetBalance: str = "budget balance"
            """Budget balance"""

            BusinessConfidence: str = "business confidence"
            """Business Confidence"""

            ChristmasDay: str = "christmas day"
            """Christmas Day"""

            ConsumerConfidence: str = "consumer confidence"
            """Consumer Confidence"""

            ConsumerSpendingMoM: str = "consumer spending mom"
            """Consumer Spending MoM"""

            CurrentAccount: str = "current account"
            """Current Account"""

            EasterMonday: str = "easter monday"
            """Easter Monday"""

            FinanceSummitTwoThousandNineteen: str = "finance summit 2019"
            """Finance Summit 2019"""

            FiveYearBtanAuction: str = "5 year btan auction"
            """5-Year BTAN Auction"""

            FourYearBtanAuction: str = "4 year btan auction"
            """4-Year BTAN Auction"""

            GdpGrowthRateQoQ: str = "gdp growth rate qoq"
            """GDP Growth Rate QoQ"""

            GdpGrowthRateQoQFinal: str = "gdp growth rate qoq final"
            """GDP Growth Rate QoQ Final"""

            GdpGrowthRateQoQFirstEstimate: str = "gdp growth rate qoq first estimate"
            """GDP Growth Rate QoQ 1st Est"""

            GdpGrowthRateQoQPreliminary: str = "gdp growth rate qoq preliminary"
            """GDP Growth Rate QoQ Prel"""

            GdpGrowthRateQoQSecondEstimate: str = "gdp growth rate qoq second estimate"
            """GDP Growth Rate QoQ 2nd Est"""

            GdpGrowthRateYoY: str = "gdp growth rate yoy"
            """GDP Growth Rate YoY"""

            GdpGrowthRateYoYFinal: str = "gdp growth rate yoy final"
            """GDP Growth Rate YoY Final"""

            GdpGrowthRateYoYFirstEstimate: str = "gdp growth rate yoy first estimate"
            """GDP Growth Rate YoY 1st Est"""

            GdpGrowthRateYoYPreliminary: str = "gdp growth rate yoy preliminary"
            """GDP Growth Rate YoY Prel"""

            GdpGrowthRateYoYSecondEstimate: str = "gdp growth rate yoy second estimate"
            """GDP Growth Rate YoY 2nd Est"""

            GoodFriday: str = "good friday"
            """Good Friday"""

            GSevenFinanceMinistersAndCentralBankGovernorsMeeting: str = "g7 finance ministers and central bank governors meeting"
            """G7 Finance Ministers and Central Bank Governors Meeting"""

            GSevenSummit: str = "g7 summit"
            """G7 Summit"""

            HarmonizedInflationRateMoM: str = "harmonized inflation rate mom"
            """Harmonised Inflation Rate MoM"""

            HarmonizedInflationRateMoMFinal: str = "harmonized inflation rate mom final"
            """Harmonised Inflation Rate MoM Final"""

            HarmonizedInflationRateMoMPreliminary: str = "harmonized inflation rate mom preliminary"
            """Harmonised Inflation Rate MoM Prel"""

            HarmonizedInflationRateYoY: str = "harmonized inflation rate yoy"
            """Harmonised Inflation Rate YoY"""

            HarmonizedInflationRateYoYFinal: str = "harmonized inflation rate yoy final"
            """Harmonised Inflation Rate YoY Final"""

            HarmonizedInflationRateYoYPreliminary: str = "harmonized inflation rate yoy preliminary"
            """Harmonised Inflation Rate YoY Prel"""

            HouseholdConsumptionMoM: str = "household consumption mom"
            """Household Consumption MoM"""

            IeaOilMarketReport: str = "iea oil market report"
            """IEA Oil Market Report"""

            IndustrialProductionMoM: str = "industrial production mom"
            """Industrial Production MoM"""

            IndustrialProductionYoY: str = "industrial production yoy"
            """Industrial Production YoY"""

            InflationRateMoM: str = "inflation rate mom"
            """Inflation Rate MoM"""

            InflationRateMoMFinal: str = "inflation rate mom final"
            """Inflation Rate MoM Final"""

            InflationRateMoMPreliminary: str = "inflation rate mom preliminary"
            """Inflation Rate MoM Prel"""

            InflationRateYoY: str = "inflation rate yoy"
            """Inflation Rate YoY"""

            InflationRateYoYFinal: str = "inflation rate yoy final"
            """Inflation Rate YoY Final"""

            InflationRateYoYPreliminary: str = "inflation rate yoy preliminary"
            """Inflation Rate YoY Prel"""

            JobseekersTotal: str = "jobseekers total"
            """Jobseekers Total"""

            LaborDay: str = "labor day"
            """Labour Day"""

            ManufacturingPurchasingManagersIndex: str = "manufacturing purchasing managers index"
            """Manufacturing PMI"""

            MarkitCompositePurchasingManagersIndexFinal: str = "markit composite purchasing managers index final"
            """Markit Composite PMI Final"""

            MarkitCompositePurchasingManagersIndexFlash: str = "markit composite purchasing managers index flash"
            """Markit Composite PMI Flash"""

            MarkitManufacturingPurchasingManagersIndex: str = "markit manufacturing purchasing managers index"
            """Markit Manufacturing PMI"""

            MarkitManufacturingPurchasingManagersIndexFinal: str = "markit manufacturing purchasing managers index final"
            """Markit Manufacturing Pmi Final"""

            MarkitManufacturingPurchasingManagersIndexFlash: str = "markit manufacturing purchasing managers index flash"
            """Markit Manufacturing PMI Flash"""

            MarkitServicesPurchasingManagersIndex: str = "markit services purchasing managers index"
            """Markit Services PMI"""

            MarkitServicesPurchasingManagersIndexFinal: str = "markit services purchasing managers index final"
            """Markit Services PMI Final"""

            MarkitServicesPurchasingManagersIndexFlash: str = "markit services purchasing managers index flash"
            """Markit Services PMI Flash"""

            NewYearsDay: str = "new years day"
            """New Year's Day"""

            NonFarmPayrollsQoQ: str = "non farm payrolls qoq"
            """Nonfarm Payrolls QoQ"""

            NonFarmPayrollsQoQFinal: str = "non farm payrolls qoq final"
            """Non Farm Payrolls QoQ Final"""

            NonFarmPayrollsQoQPreliminary: str = "non farm payrolls qoq preliminary"
            """Non Farm Payrolls QoQ Prel"""

            ParliamentaryElections: str = "parliamentary elections"
            """Parliamentary Elections"""

            Pentecost: str = "pentecost"
            """Pentecost"""

            PresidentialElections: str = "presidential elections"
            """Presidential Elections"""

            PrivateNonFarmPayrollsQoQFinal: str = "private non farm payrolls qoq final"
            """Private Non Farm Payrolls QoQ Final"""

            PrivateNonFarmPayrollsQoQPreliminary: str = "private non farm payrolls qoq preliminary"
            """Private Non Farm Payrolls QoQ Prel"""

            ProducerPriceIndexMoM: str = "producer price index mom"
            """PPI MoM"""

            RetailSalesMoM: str = "retail sales mom"
            """Retail Sales MoM"""

            RetailSalesYoY: str = "retail sales yoy"
            """Retail Sales YoY"""

            ServicesPurchasingManagersIndex: str = "services purchasing managers index"
            """Services PMI"""

            SixMonthBtfAuction: str = "6 month btf auction"
            """6-Month BTF Auction"""

            TenYearOatAuction: str = "10 year oat auction"
            """10-Year OAT Auction"""

            ThreeMonthBtfAuction: str = "3 month btf auction"
            """3-Month BTF Auction"""

            ThreeYearBtanAuction: str = "3 year btan auction"
            """3-Year BTAN Auction"""

            TwelveMonthBtfAuction: str = "12 month btf auction"
            """12-Month BTF Auction"""

            TwoYearBtanAuction: str = "2 year btan auction"
            """2-Year BTAN Auction"""

            UnemploymentBenefitClaims: str = "unemployment benefit claims"
            """Unemployment Benefit Claims"""

            UnemploymentRate: str = "unemployment rate"
            """Unemployment Rate"""

            WhitMonday: str = "whit monday"
            """Whit Monday"""

            WwiiVictoryDay: str = "wwii victory day"
            """WWII Victory Day"""

        class Germany(System.Object):
            """Germany"""

            AllSaintsDay: str = "all saints day"
            """All Saints' Day"""

            AscensionDay: str = "ascension day"
            """Ascension Day"""

            AsianDevelopmentBankAnnualMeeting: str = "asian development bank annual meeting"
            """Asian Development Bank Annual Meeting"""

            AssumptionOfMary: str = "assumption of mary"
            """Assumption of Mary"""

            BadenWrttembergStateElection: str = "baden wrttemberg state election"
            """Baden-Württemberg State Election"""

            BalanceOfTrade: str = "balance of trade"
            """Balance of Trade"""

            BalanceOfTradeSeasonallyAdjusted: str = "balance of trade seasonally adjusted"
            """Balance of Trade s.a"""

            BoxingDay: str = "boxing day"
            """Boxing Day"""

            BundesbankAnnualReport: str = "bundesbank annual report"
            """Bundesbank Annual Report"""

            BundesbankAnnualReportTwoThousandSeventeen: str = "bundesbank annual report 2017"
            """Bundesbank Annual Report 2017"""

            BundesbankBalzSpeech: str = "bundesbank balz speech"
            """Bundesbank Balz Speech"""

            BundesbankBeermannSpeech: str = "bundesbank beermann speech"
            """Bundesbank Beermann Speech"""

            BundesbankBuchSpeech: str = "bundesbank buch speech"
            """Bundesbank Buch Speech"""

            BundesbankDombretSpeech: str = "bundesbank dombret speech"
            """Bundesbank Dombret Speech"""

            BundesbankMaudererSpeech: str = "bundesbank mauderer speech"
            """Bundesbank Mauderer Speech"""

            BundesbankMonthlyReport: str = "bundesbank monthly report"
            """Bundesbank Monthly Report"""

            BundesbankPresidentWeidmannSpeech: str = "bundesbank president weidmann speech"
            """Bundesbank President Weidmann Speech"""

            BundesbankSemiAnnualForecasts: str = "bundesbank semi annual forecasts"
            """Bundesbank Semi-Annual Forecasts"""

            BundesbankThieleSpeech: str = "bundesbank thiele speech"
            """Bundesbank Thiele Speech"""

            BundesbankWeidmannSpeech: str = "bundesbank weidmann speech"
            """Bundesbank Weidmann Speech"""

            BundesbankWuermelingSpeech: str = "bundesbank wuermeling speech"
            """Bundesbank Wuermeling Speech"""

            BusinessConfidence: str = "business confidence"
            """Business Confidence"""

            ChristmasDay: str = "christmas day"
            """Christmas Day"""

            ConstructionPurchasingManagersIndex: str = "construction purchasing managers index"
            """Construction PMI"""

            CorpusChristi: str = "corpus christi"
            """Corpus Christi"""

            CurrentAccount: str = "current account"
            """Current Account"""

            DayOfGermanUnity: str = "day of german unity"
            """Day of German Unity"""

            EasterMonday: str = "easter monday"
            """Easter Monday"""

            EmployedPersons: str = "employed persons"
            """Employed Persons"""

            Epiphany: str = "epiphany"
            """Epiphany"""

            EuroFinanceWeek: str = "euro finance week"
            """Euro Finance Week"""

            EuroFinanceWeekTwoThousandSeventeen: str = "euro finance week 2017"
            """Euro Finance Week 2017"""

            ExportsMoM: str = "exports mom"
            """Exports MoM"""

            ExportsMoMSeasonallyAdjusted: str = "exports mom seasonally adjusted"
            """Exports MoM s.a"""

            FactoryOrdersMoM: str = "factory orders mom"
            """Factory Orders MoM"""

            FactoryOrdersYoY: str = "factory orders yoy"
            """Factory Orders YoY"""

            FederalElection: str = "federal election"
            """Federal election"""

            FinanceMinisterSchubleSpeech: str = "finance minister schuble speech"
            """Finance Minister Schäuble Speech"""

            FiveYearBoblAuction: str = "5 year bobl auction"
            """5-Year Bobl Auction"""

            FrankfurtFinanceSummitTwoThousandSeventeen: str = "frankfurt finance summit 2017"
            """Frankfurt Finance Summit 2017"""

            FrankfurtFinanceSummitTwoThousandSixteen: str = "frankfurt finance summit 2016"
            """Frankfurt Finance Summit 2016"""

            FullYearGdpGrowth: str = "full year gdp growth"
            """Full Year GDP Growth"""

            GdpGrowthRate: str = "gdp growth rate"
            """GDP Growth Rate"""

            GdpGrowthRateFlash: str = "gdp growth rate flash"
            """GDP Growth Rate 2015 Flash"""

            GdpGrowthRateQoQ: str = "gdp growth rate qoq"
            """GDP Growth Rate QoQ"""

            GdpGrowthRateQoQFinal: str = "gdp growth rate qoq final"
            """GDP Growth Rate QoQ Final"""

            GdpGrowthRateQoQFlash: str = "gdp growth rate qoq flash"
            """GDP Growth Rate QoQ Flash"""

            GdpGrowthRateQoQPreliminary: str = "gdp growth rate qoq preliminary"
            """GDP Growth Rate QoQ Prel"""

            GdpGrowthRateYoY: str = "gdp growth rate yoy"
            """GDP Growth Rate YoY"""

            GdpGrowthRateYoYFinal: str = "gdp growth rate yoy final"
            """GDP Growth Rate YoY Final"""

            GdpGrowthRateYoYFlash: str = "gdp growth rate yoy flash"
            """GDP Growth Rate YoY Flash"""

            GermanBubaPresidentWeidmannSpeech: str = "german buba president weidmann speech"
            """German Buba President Weidmann speech"""

            GfkConsumerConfidence: str = "gfk consumer confidence"
            """Gfk Consumer Confidence"""

            GoodFriday: str = "good friday"
            """Good Friday"""

            GovernmentBudget: str = "government budget"
            """Government Budget"""

            GSevenFinanceMinistersMeeting: str = "g7 finance ministers meeting"
            """G7 Finance Ministers' Meeting"""

            GTwentyConference: str = "g20 conference"
            """G20-Conference"""

            GTwentyFinanceMinistersAndCbGovernorsMeeting: str = "g20 finance ministers and cb governors meeting"
            """G20 Finance Ministers and CB Governors Meeting"""

            GTwentyForeignMinistersMeeting: str = "g20 foreign ministers meeting"
            """G20 Foreign Ministers Meeting"""

            GTwentySummit: str = "g20 summit"
            """G20 Summit"""

            HarmonizedInflationRateMoM: str = "harmonized inflation rate mom"
            """Harmonised Inflation Rate MoM"""

            HarmonizedInflationRateMoMFinal: str = "harmonized inflation rate mom final"
            """Harmonised Inflation Rate MoM Final"""

            HarmonizedInflationRateMoMPreliminary: str = "harmonized inflation rate mom preliminary"
            """Harmonised Inflation Rate MoM Prel"""

            HarmonizedInflationRateYoY: str = "harmonized inflation rate yoy"
            """Harmonised Inflation Rate YoY"""

            HarmonizedInflationRateYoYFinal: str = "harmonized inflation rate yoy final"
            """Harmonised Inflation Rate YoY Final"""

            HarmonizedInflationRateYoYPreliminary: str = "harmonized inflation rate yoy preliminary"
            """Harmonised Inflation Rate YoY Prel"""

            IfoBusinessClimate: str = "ifo business climate"
            """IFO Business Climate"""

            IfoCurrentAssessment: str = "ifo current assessment"
            """IFO - Current Assessment"""

            IfoCurrentConditions: str = "ifo current conditions"
            """IFO Current Conditions"""

            IfoExpectations: str = "ifo expectations"
            """IFO Expectations"""

            ImfLagardeSpeech: str = "imf lagarde speech"
            """IMF Lagarde Speech"""

            ImportPricesMoM: str = "import prices mom"
            """Import Prices MoM"""

            ImportPricesYoY: str = "import prices yoy"
            """Import Prices YoY"""

            ImportsMoMSeasonallyAdjusted: str = "imports mom seasonally adjusted"
            """Imports MoM s.a"""

            IndustrialProductionMoM: str = "industrial production mom"
            """Industrial Production MoM"""

            IndustrialProductionYoY: str = "industrial production yoy"
            """Industrial Production YoY"""

            InflationRateMoM: str = "inflation rate mom"
            """Inflation Rate MoM"""

            InflationRateMoMFinal: str = "inflation rate mom final"
            """Inflation Rate MoM Final"""

            InflationRateMoMFlash: str = "inflation rate mom flash"
            """Inflation Rate MoM Flash"""

            InflationRateMoMPreliminary: str = "inflation rate mom preliminary"
            """Inflation Rate MoM Prel"""

            InflationRateYoY: str = "inflation rate yoy"
            """Inflation Rate YoY"""

            InflationRateYoYFinal: str = "inflation rate yoy final"
            """Inflation Rate YoY Final"""

            InflationRateYoYPreliminary: str = "inflation rate yoy preliminary"
            """Inflation Rate YoY Prel"""

            JobVacancies: str = "job vacancies"
            """Job Vacancies"""

            LaborDay: str = "labor day"
            """Labour Day"""

            MarkitBmeManufacturingPurchasingManagersIndexFinal: str = "markit bme manufacturing purchasing managers index final"
            """Markit/BME Manufacturing Pmi Final"""

            MarkitBmeManufacturingPurchasingManagersIndexFlash: str = "markit bme manufacturing purchasing managers index flash"
            """Markit/BME Manufacturing PMI Flash"""

            MarkitCompositePurchasingManagersIndexFinal: str = "markit composite purchasing managers index final"
            """Markit Composite PMI Final"""

            MarkitCompositePurchasingManagersIndexFlash: str = "markit composite purchasing managers index flash"
            """Markit Composite PMI Flash"""

            MarkitManufacturingPurchasingManagersIndex: str = "markit manufacturing purchasing managers index"
            """Markit Manufacturing PMI"""

            MarkitManufacturingPurchasingManagersIndexFinal: str = "markit manufacturing purchasing managers index final"
            """Markit Manufacturing PMI Final"""

            MarkitManufacturingPurchasingManagersIndexFlash: str = "markit manufacturing purchasing managers index flash"
            """Markit Manufacturing PMI Flash"""

            MarkitServicesPurchasingManagersIndex: str = "markit services purchasing managers index"
            """Markit Services PMI"""

            MarkitServicesPurchasingManagersIndexFinal: str = "markit services purchasing managers index final"
            """Markit Services PMI Final"""

            MarkitServicesPurchasingManagersIndexFlash: str = "markit services purchasing managers index flash"
            """Markit Services PMI Flash"""

            NewYearsDay: str = "new years day"
            """New Year's Day"""

            PresidentialElections: str = "presidential elections"
            """Presidential Elections"""

            ProducerPriceIndexMoM: str = "producer price index mom"
            """PPI MoM"""

            ProducerPriceIndexYoY: str = "producer price index yoy"
            """PPI YoY"""

            ReformationDay: str = "reformation day"
            """Reformation Day"""

            RepentanceDay: str = "repentance day"
            """Repentance Day"""

            RetailSalesMoM: str = "retail sales mom"
            """Retail Sales MoM"""

            RetailSalesYoY: str = "retail sales yoy"
            """Retail Sales YoY"""

            RhinelandPalatinateStateElection: str = "rhineland palatinate state election"
            """Rhineland-Palatinate State Election"""

            SaxonyAnhaltStateElection: str = "saxony anhalt state election"
            """Saxony-Anhalt State Election"""

            ServicesPurchasingManagersIndex: str = "services purchasing managers index"
            """Services PMI"""

            StStephensDay: str = "st stephens day"
            """St Stephen's Day"""

            TenYearBundAuction: str = "10 year bund auction"
            """10-Year Bund Auction"""

            ThirtyYearBundAuction: str = "30 year bund auction"
            """30-Year Bund Auction"""

            TwelveMonthBubillAuction: str = "12 month bubill auction"
            """12-Month Bubill Auction"""

            TwoYearSchatzAuction: str = "2 year schatz auction"
            """2-Year Schatz Auction"""

            UnemployedPersonsNotSeasonallyAdjusted: str = "unemployed persons not seasonally adjusted"
            """Unemployed Persons NSA"""

            UnemploymentChange: str = "unemployment change"
            """Unemployment Change"""

            UnemploymentRate: str = "unemployment rate"
            """Unemployment Rate"""

            UnemploymentRateHarmonized: str = "unemployment rate harmonized"
            """Unemployment Rate Harmonised"""

            WhitMonday: str = "whit monday"
            """Whit Monday"""

            WholesalePricesMoM: str = "wholesale prices mom"
            """Wholesale Prices MoM"""

            WholesalePricesYoY: str = "wholesale prices yoy"
            """Wholesale Prices YoY"""

            ZewCurrentConditions: str = "zew current conditions"
            """ZEW Current Conditions"""

            ZewEconomicSentimentIndex: str = "zew economic sentiment index"
            """ZEW Economic Sentiment Index"""

        class Greece(System.Object):
            """Greece"""

            AssumptionOfMary: str = "assumption of mary"
            """Assumption of Mary"""

            BalanceOfTrade: str = "balance of trade"
            """Balance of Trade"""

            BusinessConfidence: str = "business confidence"
            """Business Confidence"""

            ChristmasDay: str = "christmas day"
            """Christmas Day"""

            CleanMonday: str = "clean monday"
            """Clean Monday"""

            ConstructionOutputYoY: str = "construction output yoy"
            """Construction Output YoY"""

            ConsumerConfidence: str = "consumer confidence"
            """Consumer Confidence"""

            CreditExpansionYoY: str = "credit expansion yoy"
            """Credit Expansion YoY"""

            CurrentAccount: str = "current account"
            """Current Account"""

            DebtRepaymentOfEurThirtyFiveBDueToEcb: str = "debt repayment of eur 35b due to ecb"
            """Debt Repayment of EUR 3.5B Due to ECB"""

            Epiphany: str = "epiphany"
            """Epiphany"""

            EpiphanyDay: str = "epiphany day"
            """Epiphany Day"""

            EuBailoutExpiration: str = "eu bailout expiration"
            """EU Bailout Expiration"""

            GdpAnnualGrowthRateYoY: str = "gdp annual growth rate yoy"
            """GDP Annual Growth Rate YoY"""

            GdpAnnualGrowthRateYoYPreliminary: str = "gdp annual growth rate yoy preliminary"
            """GDP Annual Growth Rate YoY - Preliminary"""

            GdpGrowthRateQoQ: str = "gdp growth rate qoq"
            """GDP Growth Rate QoQ"""

            GdpGrowthRateQoQFinal: str = "gdp growth rate qoq final"
            """GDP Growth Rate QoQ Final"""

            GdpGrowthRateQoQPreliminary: str = "gdp growth rate qoq preliminary"
            """GDP Growth Rate QoQ Prel"""

            GdpGrowthRateYoY: str = "gdp growth rate yoy"
            """GDP Growth Rate YoY"""

            GdpGrowthRateYoYAdv: str = "gdp growth rate yoy adv"
            """GDP Growth Rate YoY Adv"""

            GdpGrowthRateYoYFinal: str = "gdp growth rate yoy final"
            """GDP Growth Rate YoY Final"""

            GdpGrowthRateYoYFlash: str = "gdp growth rate yoy flash"
            """GDP Growth Rate YoY Flash"""

            GdpGrowthRateYoYPreliminary: str = "gdp growth rate yoy preliminary"
            """GDP Growth Rate YoY - P."""

            GdpGrowthRateYoYSecondEstimate: str = "gdp growth rate yoy second estimate"
            """GDP Growth Rate YoY 2nd Est"""

            GreekParliamentElections: str = "greek parliament elections"
            """Greek Parliament Elections"""

            GreekThirdBailoutProgramsVote: str = "greek third bailout programs vote"
            """Greek Third Bailout Program's Vote"""

            HarmonizedInflationRateYoY: str = "harmonized inflation rate yoy"
            """Harmonized Inflation Rate YoY"""

            HolySpiritMonday: str = "holy spirit monday"
            """Holy Spirit Monday"""

            IndependenceDay: str = "independence day"
            """Independence Day"""

            IndustrialProductionYoY: str = "industrial production yoy"
            """Industrial Production YoY"""

            InflationRateMoM: str = "inflation rate mom"
            """Inflation Rate MoM"""

            InflationRateYoY: str = "inflation rate yoy"
            """Inflation Rate YoY"""

            LaborDay: str = "labor day"
            """Labour Day"""

            LaborDaySubstituteDay: str = "labor day substitute day"
            """Labour Day (Substitute Day)"""

            LoansToPrivateSector: str = "loans to private sector"
            """Loans to Private Sector"""

            LoansToPrivateSectorYoY: str = "loans to private sector yoy"
            """Loans to Private Sector YoY"""

            MarkitManufacturingPurchasingManagersIndex: str = "markit manufacturing purchasing managers index"
            """Markit Manufacturing PMI"""

            NewYearsDay: str = "new years day"
            """New Year's Day"""

            OchiDay: str = "ochi day"
            """Ochi Day"""

            OrthodoxEasterMonday: str = "orthodox easter monday"
            """Orthodox Easter Monday"""

            OrthodoxEasterSunday: str = "orthodox easter sunday"
            """Orthodox Easter Sunday"""

            OrthodoxGoodFriday: str = "orthodox good friday"
            """Orthodox Good Friday"""

            OrthodoxWhitMonday: str = "orthodox whit monday"
            """Orthodox Whit Monday"""

            ParliamentaryElections: str = "parliamentary elections"
            """Parliamentary Elections"""

            ProducerPriceIndexYoY: str = "producer price index yoy"
            """PPI YoY"""

            ReferendumOnBailoutTerms: str = "referendum on bailout terms"
            """Referendum on Bailout Terms"""

            RetailSalesMoM: str = "retail sales mom"
            """Retail Sales MoM"""

            RetailSalesYoY: str = "retail sales yoy"
            """Retail Sales YoY"""

            StStephensDay: str = "st stephens day"
            """St Stephen's Day"""

            TheOchiDay: str = "the ochi day"
            """The Ochi Day"""

            ThirteenWeekBillAuction: str = "13 week bill auction"
            """13-Weeks Bill Auction"""

            TotalCreditYoY: str = "total credit yoy"
            """Total Credit YoY"""

            TwentySixWeekBillAuction: str = "26 week bill auction"
            """26-Weeks Bill Auction"""

            UnemploymentRate: str = "unemployment rate"
            """Unemployment Rate"""

        class Ireland(System.Object):
            """Ireland"""

            AibManufacturingPurchasingManagersIndex: str = "aib manufacturing purchasing managers index"
            """AIB Manufacturing PMI"""

            AibServicesPurchasingManagersIndex: str = "aib services purchasing managers index"
            """AIB Services PMI"""

            AugustBankHoliday: str = "august bank holiday"
            """August Bank Holiday"""

            AverageWeeklyEarningsYoY: str = "average weekly earnings yoy"
            """Average Weekly Earnings YoY"""

            BalanceOfTrade: str = "balance of trade"
            """Balance of Trade"""

            BalanceOfTradeFinal: str = "balance of trade final"
            """Balance of Trade-Final"""

            BankHoliday: str = "bank holiday"
            """Bank Holiday"""

            CbiGovLaneSpeech: str = "cbi gov lane speech"
            """CBI Gov Lane Speech"""

            ChristmasDay: str = "christmas day"
            """Christmas Day"""

            ConstructionOutputYoY: str = "construction output yoy"
            """Construction Output YoY"""

            ConstructionPurchasingManagersIndex: str = "construction purchasing managers index"
            """Construction PMI"""

            ConsumerConfidence: str = "consumer confidence"
            """Consumer Confidence"""

            CoreInflationRate: str = "core inflation rate"
            """Core Inflation Rate"""

            CoreInflationRateYoY: str = "core inflation rate yoy"
            """Core Inflation Rate YoY"""

            CurrentAccount: str = "current account"
            """Current Account"""

            EasterMonday: str = "easter monday"
            """Easter Monday"""

            EsriConsumerSentimentIndex: str = "esri consumer sentiment index"
            """ESRI Consumer Sentiment Index"""

            GdpGrowthRateQoQ: str = "gdp growth rate qoq"
            """GDP Growth Rate QoQ"""

            GdpGrowthRateYoY: str = "gdp growth rate yoy"
            """GDP Growth Rate YoY"""

            GnpQoQ: str = "gnp qoq"
            """GNP QoQ"""

            GnpYoY: str = "gnp yoy"
            """GNP YoY"""

            GoodFriday: str = "good friday"
            """Good Friday"""

            HarmonizedInflationRateMoM: str = "harmonized inflation rate mom"
            """Harmonised Inflation Rate MoM"""

            HarmonizedInflationRateYoY: str = "harmonized inflation rate yoy"
            """Harmonised Inflation Rate YoY"""

            HouseholdSavingRatio: str = "household saving ratio"
            """Household Saving Ratio"""

            IndustrialProductionYoY: str = "industrial production yoy"
            """Industrial Production YoY"""

            InflationRate: str = "inflation rate"
            """Inflation Rate"""

            InflationRateMoM: str = "inflation rate mom"
            """Inflation Rate MoM"""

            InflationRateYoY: str = "inflation rate yoy"
            """Inflation Rate YoY"""

            InvestecManufacturingPurchasingManagersIndex: str = "investec manufacturing purchasing managers index"
            """Investec Manufacturing Pmi"""

            InvestecServicesPurchasingManagersIndex: str = "investec services purchasing managers index"
            """Investec Services PMI"""

            JuneBankHoliday: str = "june bank holiday"
            """June Bank Holiday"""

            MarkitServicesPurchasingManagersIndex: str = "markit services purchasing managers index"
            """Markit Services PMI"""

            MayBankHoliday: str = "may bank holiday"
            """May Bank Holiday"""

            MayDay: str = "may day"
            """May Day"""

            NewYearsDay: str = "new years day"
            """New Year’s Day"""

            NewYearsDaySubstituteDay: str = "new years day substitute day"
            """New Year’s Day (Substitute Day)"""

            OctoberBankHoliday: str = "october bank holiday"
            """October Bank Holiday"""

            ParliamentaryElections: str = "parliamentary elections"
            """Parliamentary Elections"""

            PurchasingManagerIndexManufacturing: str = "purchasing manager index manufacturing"
            """Purchasing Manager Index Manufacturing"""

            PurchasingManagerIndexServices: str = "purchasing manager index services"
            """Purchasing Manager Index Services"""

            PurchasingManagersIndexServices: str = "purchasing managers index services"
            """PMI services"""

            ResidentialPropertyPricesMoM: str = "residential property prices mom"
            """Residential Property Prices MoM"""

            ResidentialPropertyPricesYoY: str = "residential property prices yoy"
            """Residential Property Prices YoY"""

            RetailSalesMoM: str = "retail sales mom"
            """Retail Sales MoM"""

            RetailSalesYoY: str = "retail sales yoy"
            """Retail Sales YoY"""

            StPatricksDay: str = "st patricks day"
            """St. Patricks Day"""

            StStephensDay: str = "st stephens day"
            """St Stephen's Day"""

            UnemploymentRate: str = "unemployment rate"
            """Unemployment Rate"""

            WholesalePricesMoM: str = "wholesale prices mom"
            """Wholesale Prices MoM"""

            WholesalePricesYoY: str = "wholesale prices yoy"
            """Wholesale Prices YoY"""

        class Italy(System.Object):
            """Italy"""

            AllSaintsDay: str = "all saints day"
            """All Saints' Day"""

            AssumptionOfMary: str = "assumption of mary"
            """Assumption of Mary"""

            BalanceOfTrade: str = "balance of trade"
            """Balance of Trade"""

            BoiRossiSpeech: str = "boi rossi speech"
            """BoI Rossi Speech"""

            BusinessConfidence: str = "business confidence"
            """Business Confidence"""

            ChristmasDay: str = "christmas day"
            """Christmas Day"""

            ConstructionOutputYoY: str = "construction output yoy"
            """Construction Output YoY"""

            ConsumerConfidence: str = "consumer confidence"
            """Consumer Confidence"""

            ConsumerPriceIndexEuNormMoM: str = "consumer price index eu norm mom"
            """Consumer Price Index (EU Norm) (MoM)"""

            ConsumerPriceIndexEuNormYoY: str = "consumer price index eu norm yoy"
            """Consumer Price Index (EU Norm) (YoY)"""

            ConsumerPriceIndexMoM: str = "consumer price index mom"
            """Consumer Price Index (MoM)"""

            CurrentAccount: str = "current account"
            """Current Account"""

            EasterMonday: str = "easter monday"
            """Easter Monday"""

            EasterSunday: str = "easter sunday"
            """Easter Sunday"""

            EconomyAndFinanceMinisterPadoanSpeech: str = "economy and finance minister padoan speech"
            """Economy and Finance Minister Padoan Speech"""

            Epiphany: str = "epiphany"
            """Epiphany"""

            FiveYBondAuction: str = "5 y bond auction"
            """5-y Bond Auction"""

            FiveYearBtpAuction: str = "5 year btp auction"
            """5-Year BTP Auction"""

            FullYearGdpGrowth: str = "full year gdp growth"
            """Full Year GDP Growth"""

            GdpAnnualGrowthRateYoY: str = "gdp annual growth rate yoy"
            """GDP Annual Growth Rate YoY"""

            GdpGrowthRate: str = "gdp growth rate"
            """GDP Growth Rate 2015"""

            GdpGrowthRateQoQ: str = "gdp growth rate qoq"
            """GDP Growth Rate QoQ"""

            GdpGrowthRateQoQAdv: str = "gdp growth rate qoq adv"
            """GDP Growth Rate QoQ Adv"""

            GdpGrowthRateQoQFinal: str = "gdp growth rate qoq final"
            """GDP Growth Rate QoQ Final"""

            GdpGrowthRateQoQPreliminary: str = "gdp growth rate qoq preliminary"
            """GDP Growth Rate QoQ Prel"""

            GdpGrowthRateYoY: str = "gdp growth rate yoy"
            """GDP Growth Rate YoY"""

            GdpGrowthRateYoYAdv: str = "gdp growth rate yoy adv"
            """GDP Growth Rate YoY Adv"""

            GdpGrowthRateYoYFinal: str = "gdp growth rate yoy final"
            """GDP Growth Rate YoY Final"""

            GeneralElections: str = "general elections"
            """General Elections"""

            GovernmentBudget: str = "government budget"
            """Government Budget"""

            GSevenFinMinistersAndCbGovernorsMeeting: str = "g7 fin ministers and cb governors meeting"
            """G7 Fin Ministers and CB Governors Meeting"""

            GSevenForeignMinistersMeeting: str = "g7 foreign ministers meeting"
            """G7 Foreign Ministers Meeting"""

            GSevenSummit: str = "g7 summit"
            """G7 Summit"""

            HarmonizedInflationRateMoMFinal: str = "harmonized inflation rate mom final"
            """Harmonised Inflation Rate MoM Final"""

            HarmonizedInflationRateMoMPreliminary: str = "harmonized inflation rate mom preliminary"
            """Harmonised Inflation Rate MoM Prel"""

            HarmonizedInflationRateYoYFinal: str = "harmonized inflation rate yoy final"
            """Harmonised Inflation Rate YoY Final"""

            HarmonizedInflationRateYoYPreliminary: str = "harmonized inflation rate yoy preliminary"
            """Harmonised Inflation Rate YoY Prel"""

            ImmaculateConception: str = "immaculate conception"
            """Immaculate Conception"""

            IndustrialOrdersMoM: str = "industrial orders mom"
            """Industrial Orders MoM"""

            IndustrialOrdersYoY: str = "industrial orders yoy"
            """Industrial Orders YoY"""

            IndustrialProductionMoM: str = "industrial production mom"
            """Industrial Production MoM"""

            IndustrialProductionYoY: str = "industrial production yoy"
            """Industrial Production YoY"""

            IndustrialSalesMoM: str = "industrial sales mom"
            """Industrial Sales MoM"""

            IndustrialSalesYoY: str = "industrial sales yoy"
            """Industrial Sales YoY"""

            InflationRateMoM: str = "inflation rate mom"
            """Inflation Rate MoM"""

            InflationRateMoMFinal: str = "inflation rate mom final"
            """Inflation Rate MoM Final"""

            InflationRateMoMPreliminary: str = "inflation rate mom preliminary"
            """Inflation Rate MoM Prel"""

            InflationRateYoY: str = "inflation rate yoy"
            """Inflation Rate YoY"""

            InflationRateYoYFinal: str = "inflation rate yoy final"
            """Inflation Rate YoY Final"""

            InflationRateYoYPreliminary: str = "inflation rate yoy preliminary"
            """Inflation Rate YoY Prel"""

            LaborDay: str = "labor day"
            """Labour Day"""

            LiberationDay: str = "liberation day"
            """Liberation Day"""

            ManufacturingPurchasingManagersIndex: str = "manufacturing purchasing managers index"
            """Manufacturing PMI"""

            MarkitAdaciManufacturingPurchasingManagersIndex: str = "markit adaci manufacturing purchasing managers index"
            """Markit/ADACI Manufacturing PMI"""

            MarkitAdaciServicesPurchasingManagersIndex: str = "markit adaci services purchasing managers index"
            """Markit/ADACI Services PMI"""

            NewYearsDay: str = "new years day"
            """New Year’s Day"""

            PmContePressConference: str = "pm conte press conference"
            """PM Conte Press Conference"""

            PmConteSpeechInTheSenate: str = "pm conte speech in the senate"
            """PM Conte Speech in the Senate"""

            ProducerPriceIndexMoM: str = "producer price index mom"
            """PPI MoM"""

            ProducerPriceIndexYoY: str = "producer price index yoy"
            """PPI YoY"""

            ReferendumOnConstitutionalReform: str = "referendum on constitutional reform"
            """Referendum on Constitutional Reform"""

            RegionalElections: str = "regional elections"
            """Regional Elections"""

            RenziMerkelHollandeMeetOnBrexit: str = "renzi merkel hollande meet on brexit"
            """Renzi, Merkel, Hollande Meet on Brexit"""

            RepublicDay: str = "republic day"
            """Republic Day"""

            RetailSalesMoM: str = "retail sales mom"
            """Retail Sales MoM"""

            RetailSalesYoY: str = "retail sales yoy"
            """Retail Sales YoY"""

            SevenYearBtpAuction: str = "7 year btp auction"
            """7-Year BTP Auction"""

            SixMonthBotAuction: str = "6 month bot auction"
            """6-Month BOT Auction"""

            StStephensDay: str = "st stephens day"
            """St Stephen's Day"""

            TenYearBondAuction: str = "10 year bond auction"
            """10-Year Bond Auction"""

            TenYearBtpAuction: str = "10 year btp auction"
            """10-Year BTP Auction"""

            ThirtyYearBtpAuction: str = "30 year btp auction"
            """30-Year BTP Auction"""

            ThreeYearBtpAuction: str = "3 year btp auction"
            """3-Year BTP Auction"""

            TwelveMonthBotAuction: str = "12 month bot auction"
            """12-Month BOT Auction"""

            UnemploymentRate: str = "unemployment rate"
            """Unemployment Rate"""

            WageInflationMoM: str = "wage inflation mom"
            """Wage Inflation MoM"""

            WageInflationYoY: str = "wage inflation yoy"
            """Wage Inflation YoY"""

        class Japan(System.Object):
            """Japan"""

            AllIndustryActivityIndexMoM: str = "all industry activity index mom"
            """All Industry Activity Index MoM"""

            AutumnEquinoxDay: str = "autumn equinox day"
            """Autumn Equinox Day"""

            AverageCashEarningsYoY: str = "average cash earnings yoy"
            """Average Cash Earnings YoY"""

            BalanceOfTrade: str = "balance of trade"
            """Balance of Trade"""

            BankHoliday: str = "bank holiday"
            """Bank Holiday"""

            BankLendingYoY: str = "bank lending yoy"
            """Bank lending YoY"""

            BankOfJapanAmamiyaSpeech: str = "bank of japan amamiya speech"
            """BoJ Amamiya Speech"""

            BankOfJapanDeputyGovIwataSpeech: str = "bank of japan deputy gov iwata speech"
            """BoJ Deputy Gov Iwata Speech"""

            BankOfJapanDeputyGovNakasoSpeech: str = "bank of japan deputy gov nakaso speech"
            """BoJ Deputy Gov Nakaso Speech"""

            BankOfJapanFunoSpeech: str = "bank of japan funo speech"
            """BoJ Funo Speech"""

            BankOfJapanGovKurodaSpeaks: str = "bank of japan gov kuroda speaks"
            """BoJ Gov Kuroda Speaks"""

            BankOfJapanGovKurodaSpeech: str = "bank of japan gov kuroda speech"
            """BoJ Gov Kuroda Speech"""

            BankOfJapanHaradaSpeech: str = "bank of japan harada speech"
            """BoJ Harada Speech"""

            BankOfJapanInterestRateDecision: str = "bank of japan interest rate decision"
            """BoJ Interest Rate Decision"""

            BankOfJapanIwataSpeech: str = "bank of japan iwata speech"
            """BoJ Iwata Speech"""

            BankOfJapanKataokaSpeech: str = "bank of japan kataoka speech"
            """BoJ Kataoka Speech"""

            BankOfJapanKiuchiSpeech: str = "bank of japan kiuchi speech"
            """BoJ Kiuchi Speech"""

            BankOfJapanKurodaSpeech: str = "bank of japan kuroda speech"
            """BoJ Kuroda Speech"""

            BankOfJapanKuwabaraSpeech: str = "bank of japan kuwabara speech"
            """BoJ Kuwabara Speech"""

            BankOfJapanMasaiSpeech: str = "bank of japan masai speech"
            """BoJ Masai Speech"""

            BankOfJapanMonetaryPolicyMeetingMinutes: str = "bank of japan monetary policy meeting minutes"
            """BoJ Monetary Policy Meeting Minutes"""

            BankOfJapanMonetaryPolicyStatement: str = "bank of japan monetary policy statement"
            """BOJ Monetary Policy Statement"""

            BankOfJapanMonetaryPolicyStatementAndPressConference: str = "bank of japan monetary policy statement and press conference"
            """BoJ Monetary Policy Statement and press conference"""

            BankOfJapanMonthlyReport: str = "bank of japan monthly report"
            """BoJ Monthly Report"""

            BankOfJapanNakasoSpeech: str = "bank of japan nakaso speech"
            """BoJ Nakaso Speech"""

            BankOfJapanPressConference: str = "bank of japan press conference"
            """BoJ Press Conference"""

            BankOfJapanQuarterlyOutlookReport: str = "bank of japan quarterly outlook report"
            """BoJ Quarterly Outlook Report"""

            BankOfJapanQuarterlyReport: str = "bank of japan quarterly report"
            """BoJ Quarterly Report"""

            BankOfJapanSakuraiSpeech: str = "bank of japan sakurai speech"
            """BoJ Sakurai Speech"""

            BankOfJapanSatoSpeech: str = "bank of japan sato speech"
            """BoJ Sato Speech"""

            BankOfJapanSummaryOfOpinions: str = "bank of japan summary of opinions"
            """BoJ Summary of Opinions"""

            BankOfJapanSuzukiSpeech: str = "bank of japan suzuki speech"
            """BoJ Suzuki Speech"""

            BankOfJapanWakatabeSpeech: str = "bank of japan wakatabe speech"
            """BoJ Wakatabe Speech"""

            BusinessSurveyIndexLargeManufacturingQoQ: str = "business survey index large manufacturing qoq"
            """BSI Large Manufacturing QoQ"""

            CapacityUtilizationMoM: str = "capacity utilization mom"
            """Capacity Utilization MoM"""

            CapitalSpendingYoY: str = "capital spending yoy"
            """Capital Spending YoY"""

            ChildrensDay: str = "childrens day"
            """Children's Day"""

            CoincidentIndex: str = "coincident index"
            """Coincident Index"""

            CoincidentIndexFinal: str = "coincident index final"
            """Coincident Index Final"""

            CoincidentIndexPreliminary: str = "coincident index preliminary"
            """Coincident Index Prel"""

            ComingOfAgeDay: str = "coming of age day"
            """Coming of Age Day"""

            ConstitutionDay: str = "constitution day"
            """Constitution Day"""

            ConstructionOrdersYoY: str = "construction orders yoy"
            """Construction Orders YoY"""

            ConsumerConfidence: str = "consumer confidence"
            """Consumer Confidence"""

            ConsumerConfidenceHouseholds: str = "consumer confidence households"
            """Consumer Confidence Households"""

            ConsumerPriceIndexExcludingFreshFoodYoY: str = "consumer price index excluding fresh food yoy"
            """CPI Ex-Fresh Food YoY"""

            CoreInflationRateYoY: str = "core inflation rate yoy"
            """Core Inflation Rate YoY"""

            CorporateServicePriceYoY: str = "corporate service price yoy"
            """Corporate Service Price YoY"""

            CultureDay: str = "culture day"
            """Culture Day"""

            CurrentAccount: str = "current account"
            """Current Account"""

            DomesticCorporateGoodsPriceIndexMoM: str = "domestic corporate goods price index mom"
            """Domestic Corporate Goods Price Index (MoM)"""

            DomesticCorporateGoodsPriceIndexYoY: str = "domestic corporate goods price index yoy"
            """Domestic Corporate Goods Price Index (YoY)"""

            EcoWatchersSurveyCurrent: str = "eco watchers survey current"
            """Eco Watchers Survey Current"""

            EcoWatchersSurveyOutlook: str = "eco watchers survey outlook"
            """Eco Watchers Survey Outlook"""

            EmperorsBirthday: str = "emperors birthday"
            """Emperor's Birthday"""

            EuJapanSummit: str = "eu japan summit"
            """EU-Japan Summit"""

            Exports: str = "exports"
            """Exports"""

            ExportsYoY: str = "exports yoy"
            """Exports YoY"""

            FinanceMinisterAsoSpeech: str = "finance minister aso speech"
            """Finance Minister Aso Speech"""

            ForeignBondInvestment: str = "foreign bond investment"
            """Foreign bond investment"""

            ForeignExchangeReserves: str = "foreign exchange reserves"
            """Foreign Exchange Reserves"""

            ForeignInvestmentInJapanStocks: str = "foreign investment in japan stocks"
            """Foreign investment in Japan stocks"""

            GdpAnnualGrowthRateYoYFinal: str = "gdp annual growth rate yoy final"
            """GDP Annual Growth Rate YoY Final"""

            GdpCapitalExpenditureQoQ: str = "gdp capital expenditure qoq"
            """GDP Capital Expenditure QoQ"""

            GdpCapitalExpenditureQoQFinal: str = "gdp capital expenditure qoq final"
            """GDP Capital Expenditure QoQ Final"""

            GdpCapitalExpenditureQoQPreliminary: str = "gdp capital expenditure qoq preliminary"
            """GDP Capital Expenditure QoQ Prel"""

            GdpDeflatorYoYFinal: str = "gdp deflator yoy final"
            """GDP Deflator YoY Final"""

            GdpDeflatorYoYPreliminary: str = "gdp deflator yoy preliminary"
            """GDP Deflator YoY Prel"""

            GdpExternalDemandQoQ: str = "gdp external demand qoq"
            """GDP External Demand QoQ"""

            GdpExternalDemandQoQFinal: str = "gdp external demand qoq final"
            """GDP External Demand QoQ Final"""

            GdpExternalDemandQoQPreliminary: str = "gdp external demand qoq preliminary"
            """GDP External Demand QoQ Prel"""

            GdpGrowthAnnualizedFinal: str = "gdp growth annualized final"
            """Gdp Growth Annualized Final"""

            GdpGrowthAnnualizedPreliminary: str = "gdp growth annualized preliminary"
            """Gdp Growth Annualized Prel."""

            GdpGrowthAnnualizedQoQ: str = "gdp growth annualized qoq"
            """GDP Growth Annualized QoQ"""

            GdpGrowthAnnualizedQoQFinal: str = "gdp growth annualized qoq final"
            """GDP Growth Annualized QoQ Final"""

            GdpGrowthAnnualizedQoQPreliminary: str = "gdp growth annualized qoq preliminary"
            """GDP Growth Annualized QoQ Prel."""

            GdpGrowthRateQoQ: str = "gdp growth rate qoq"
            """GDP Growth Rate QoQ"""

            GdpGrowthRateQoQFinal: str = "gdp growth rate qoq final"
            """GDP Growth Rate QoQ Final"""

            GdpGrowthRateQoQPreliminary: str = "gdp growth rate qoq preliminary"
            """GDP Growth Rate QoQ Prel"""

            GdpPriceIndexYoYFinal: str = "gdp price index yoy final"
            """GDP Price Index YoY Final"""

            GdpPriceIndexYoYPreliminary: str = "gdp price index yoy preliminary"
            """GDP Price Index YoY Prel"""

            GdpPrivateConsumptionQoQ: str = "gdp private consumption qoq"
            """GDP Private Consumption QoQ"""

            GdpPrivateConsumptionQoQFinal: str = "gdp private consumption qoq final"
            """GDP Private Consumption QoQ Final"""

            GdpPrivateConsumptionQoQPreliminary: str = "gdp private consumption qoq preliminary"
            """GDP Private Consumption QoQ Prel"""

            GeneralElections: str = "general elections"
            """General Elections"""

            GreeneryDay: str = "greenery day"
            """Greenery Day"""

            GrossDomesticProductAnnualizedFinal: str = "gross domestic product annualized final"
            """Gross Domestic Product Annualized Final"""

            GrossDomesticProductAnnualizedRevised: str = "gross domestic product annualized revised"
            """Gross Domestic Product Annualized (R)"""

            GSevenFinanceMinistersAndCentralBankGovernorsMeeting: str = "g7 finance ministers and central bank governors meeting"
            """G7 Finance Ministers and Central Bank Governors’ Meeting"""

            GSevenSummit: str = "g7 summit"
            """G7 Summit"""

            GTwentyMeeting: str = "g20 meeting"
            """G20 Meeting"""

            GTwentySummitMeeting: str = "g20 summit meeting"
            """G20 Summit Meeting"""

            HealthSportsDay: str = "health sports day"
            """Health-Sports Day"""

            Holiday: str = "holiday"
            """Holiday"""

            HouseholdSpendingMoM: str = "household spending mom"
            """Household Spending MoM"""

            HouseholdSpendingYoY: str = "household spending yoy"
            """Household Spending YoY"""

            HouseOfCouncillorsElection: str = "house of councillors election"
            """House of Councillors Election"""

            HousingStartsYoY: str = "housing starts yoy"
            """Housing Starts YoY"""

            Imports: str = "imports"
            """Imports"""

            ImportsYoY: str = "imports yoy"
            """Imports YoY"""

            IndustrialProductionMoM: str = "industrial production mom"
            """Industrial Production MoM"""

            IndustrialProductionMoMFinal: str = "industrial production mom final"
            """Industrial Production MoM Final"""

            IndustrialProductionMoMPreliminary: str = "industrial production mom preliminary"
            """Industrial Production MoM Prel."""

            IndustrialProductionYoY: str = "industrial production yoy"
            """Industrial Production YoY"""

            IndustrialProductionYoYFinal: str = "industrial production yoy final"
            """Industrial Production YoY Final"""

            IndustrialProductionYoYPreliminary: str = "industrial production yoy preliminary"
            """Industrial Production YoY Prel"""

            InflationRateExcludingFoodAndEnergyYoY: str = "inflation rate excluding food and energy yoy"
            """Inflation Rate Ex-Food and Energy YoY"""

            InflationRateExcludingFreshFoodYoY: str = "inflation rate excluding fresh food yoy"
            """Inflation Rate Ex-Fresh Food YoY"""

            InflationRateMoM: str = "inflation rate mom"
            """Inflation Rate MoM"""

            InflationRateYoY: str = "inflation rate yoy"
            """Inflation Rate YoY"""

            JibunBankCompositePurchasingManagersIndexFinal: str = "jibun bank composite purchasing managers index final"
            """Jibun Bank Composite PMI Final"""

            JibunBankCompositePurchasingManagersIndexFlash: str = "jibun bank composite purchasing managers index flash"
            """Jibun Bank Composite PMI Flash"""

            JibunBankManufacturingPurchasingManagersIndexFinal: str = "jibun bank manufacturing purchasing managers index final"
            """Jibun Bank Manufacturing PMI Final"""

            JibunBankManufacturingPurchasingManagersIndexFlash: str = "jibun bank manufacturing purchasing managers index flash"
            """Jibun Bank Manufacturing PMI Flash"""

            JibunBankServicesPurchasingManagersIndex: str = "jibun bank services purchasing managers index"
            """Jibun Bank Services PMI"""

            JibunBankServicesPurchasingManagersIndexFinal: str = "jibun bank services purchasing managers index final"
            """Jibun Bank Services PMI Final"""

            JibunBankServicesPurchasingManagersIndexFlash: str = "jibun bank services purchasing managers index flash"
            """Jibun Bank Services PMI Flash"""

            JobsApplicationsRatio: str = "jobs applications ratio"
            """Jobs/applications ratio"""

            JpForeignReserves: str = "jp foreign reserves"
            """JP Foreign Reserves"""

            LaborThanksgivingDay: str = "labor thanksgiving day"
            """Labour Thanksgiving Day"""

            LargeRetailerSales: str = "large retailer sales"
            """Large Retailer Sales"""

            LargeRetailersSales: str = "large retailers sales"
            """Large Retailer's Sales"""

            LeadingCompositeIndexFinal: str = "leading composite index final"
            """Leading Composite Index Final"""

            LeadingCompositeIndexPreliminary: str = "leading composite index preliminary"
            """Leading Composite Index Prel"""

            LeadingEconomicIndex: str = "leading economic index"
            """Leading Economic Index"""

            LeadingEconomicIndexFinal: str = "leading economic index final"
            """Leading Economic Index Final"""

            LeadingEconomicIndexPreliminary: str = "leading economic index preliminary"
            """Leading Economic Index Prel"""

            MachineryOrdersMoM: str = "machinery orders mom"
            """Machinery Orders (MoM)"""

            MachineryOrdersYoY: str = "machinery orders yoy"
            """Machinery Orders (YoY)"""

            MachineToolOrdersYoY: str = "machine tool orders yoy"
            """Machine Tool Orders YoY"""

            ManufacturingPurchasingManagersIndex: str = "manufacturing purchasing managers index"
            """Manufacturing PMI"""

            MarkitJmmaManufacturingPurchasingManagersIndex: str = "markit jmma manufacturing purchasing managers index"
            """Markit/JMMA Manufacturing PMI"""

            MarkitJmmaManufacturingPurchasingManagersIndexFinal: str = "markit jmma manufacturing purchasing managers index final"
            """Markit/JMMA Manufacturing PMI Final"""

            MarkitJmmaManufacturingPurchasingManagersIndexFlash: str = "markit jmma manufacturing purchasing managers index flash"
            """Markit/JMMA Manufacturing PMI Flash"""

            MarkitNikkeiServicesPurchasingManagersIndex: str = "markit nikkei services purchasing managers index"
            """Nikkei Markit Services PMI"""

            MarkitServicesPurchasingManagersIndex: str = "markit services purchasing managers index"
            """Markit Services PMI"""

            MofAsakawaSpeech: str = "mof asakawa speech"
            """MOF Asakawa Speech"""

            MonetaryBaseYoY: str = "monetary base yoy"
            """Monetary Base (YoY)"""

            MoneySupplyMTwocdYoY: str = "money supply m2cd yoy"
            """Money Supply M2+CD (YoY)"""

            MountainDay: str = "mountain day"
            """Mountain Day"""

            NationalCoreInflationRateYoY: str = "national core inflation rate yoy"
            """National Core Inflation Rate YoY"""

            NationalFoundingDay: str = "national founding day"
            """National Founding Day"""

            NationalHoliday: str = "national holiday"
            """National Holiday"""

            NewYearsDay: str = "new years day"
            """New Year's Day"""

            NewYearssDay: str = "new yearss day"
            """New Years's Day"""

            NikkeiManufacturingPurchasingManagersIndexFinal: str = "nikkei manufacturing purchasing managers index final"
            """Nikkei Manufacturing PMI Final"""

            NikkeiManufacturingPurchasingManagersIndexFlash: str = "nikkei manufacturing purchasing managers index flash"
            """Nikkei Manufacturing PMI Flash"""

            NikkeiServicesPurchasingManagersIndex: str = "nikkei services purchasing managers index"
            """Nikkei Services PMI"""

            NomuraJmmaManufacturingPurchasingManagersIndex: str = "nomura jmma manufacturing purchasing managers index"
            """Nomura/JMMA Manufacturing PMI"""

            OceanDay: str = "ocean day"
            """Ocean Day"""

            OecdHeadAngelGurriaSpeech: str = "oecd head angel gurria speech"
            """OECD Head Angel Gurria Speech"""

            OverallHouseholdSpendingYoY: str = "overall household spending yoy"
            """Overall Household Spending YoY"""

            ParliamentaryElections: str = "parliamentary elections"
            """Parliamentary Elections"""

            PmShinzoAbeToDissolveParliament: str = "pm shinzo abe to dissolve parliament"
            """PM Shinzo Abe to Dissolve Parliament"""

            ProducerPriceIndexMoM: str = "producer price index mom"
            """PPI MoM"""

            ProducerPriceIndexYoY: str = "producer price index yoy"
            """PPI YoY"""

            RespectForTheAgedDay: str = "respect for the aged day"
            """Respect for the Aged Day"""

            RetailSalesMoM: str = "retail sales mom"
            """Retail Sales MoM"""

            RetailSalesYoY: str = "retail sales yoy"
            """Retail Sales YoY"""

            RetailTradeSeasonallyAdjustedMoM: str = "retail trade seasonally adjusted mom"
            """Retail Trade s.a (MoM)"""

            RetailTradeYoY: str = "retail trade yoy"
            """Retail Trade (YoY)"""

            ReutersTankanIndex: str = "reuters tankan index"
            """Reuters Tankan Index"""

            ShowaDay: str = "showa day"
            """Showa Day"""

            SpringEquinoxDay: str = "spring equinox day"
            """Spring Equinox Day"""

            StockInvestmentByForeigners: str = "stock investment by foreigners"
            """Stock Investment by Foreigners"""

            TankanAllLargeIndustryCapitalExpenditure: str = "tankan all large industry capital expenditure"
            """Tankan Large All Industry Capex"""

            TankanAllSmallIndustryCapitalExpenditure: str = "tankan all small industry capital expenditure"
            """Tankan All Small Industry CAPEX"""

            TankanLargeManufacturingIndex: str = "tankan large manufacturing index"
            """Tankan Large Manufacturers Index"""

            TankanLargeManufacturingOutlook: str = "tankan large manufacturing outlook"
            """Tankan Large Manufacturing Outlook"""

            TankanLargeNonManufacturingIndex: str = "tankan large non manufacturing index"
            """Tankan Large Non-Manufacturing Index"""

            TankanNonManufacturingIndex: str = "tankan non manufacturing index"
            """Tankan Non-Manufacturing Index"""

            TankanNonManufacturingOutlook: str = "tankan non manufacturing outlook"
            """Tankan Non-Manufacturing Outlook"""

            TankanSmallManufacturingIndex: str = "tankan small manufacturing index"
            """Tankan Small Manufacturers Index"""

            TankanSmallManufacturingOutlook: str = "tankan small manufacturing outlook"
            """Tankan Small Manufacturing Outlook"""

            TankanSmallNonManufacturingIndex: str = "tankan small non manufacturing index"
            """Tankan Small Non-Manufacturing Index"""

            TankanSmallNonManufacturingOutlook: str = "tankan small non manufacturing outlook"
            """Tankan Small Non-Manufacturing Outlook"""

            TenYearJgbAuction: str = "10 year jgb auction"
            """10-Year JGB Auction"""

            TertiaryIndustryIndexMoM: str = "tertiary industry index mom"
            """Tertiary Industry Index MoM"""

            TheEmperorsBirthday: str = "the emperors birthday"
            """The Emperor's Birthday"""

            ThirtyYearJgbAuction: str = "30 year jgb auction"
            """30-Year JGB Auction"""

            TokyoConsumerPriceIndexYoY: str = "tokyo consumer price index yoy"
            """Tokyo CPI YoY"""

            TokyoCoreConsumerPriceIndexYoY: str = "tokyo core consumer price index yoy"
            """Tokyo Core CPI YoY"""

            UnemploymentRate: str = "unemployment rate"
            """Unemployment Rate"""

            UpperHouseElections: str = "upper house elections"
            """Upper House Elections"""

            UsJapanTradeTalks: str = "us japan trade talks"
            """US-Japan Trade Talks"""

            VehicleSalesYoY: str = "vehicle sales yoy"
            """Vehicle Sales (YoY)"""

            YutakaHaradaSpeech: str = "yutaka harada speech"
            """Yutaka Harada Speech"""

        class Latvia(System.Object):
            """Latvia"""

            BalanceOfTrade: str = "balance of trade"
            """Balance of Trade"""

            BankHoliday: str = "bank holiday"
            """Bank Holiday"""

            BoxingDay: str = "boxing day"
            """Boxing Day"""

            ChristmasDay: str = "christmas day"
            """Christmas Day"""

            ChristmasEve: str = "christmas eve"
            """Christmas Eve"""

            CurrentAccount: str = "current account"
            """Current Account"""

            DeclarationOfIndependence: str = "declaration of independence"
            """Declaration of Independence"""

            EasterMonday: str = "easter monday"
            """Easter Monday"""

            GdpGrowthRateQoQ: str = "gdp growth rate qoq"
            """GDP Growth Rate QoQ"""

            GdpGrowthRateQoQFinal: str = "gdp growth rate qoq final"
            """GDP Growth Rate QoQ Final"""

            GdpGrowthRateQoQFlash: str = "gdp growth rate qoq flash"
            """GDP Growth Rate QoQ Flash"""

            GdpGrowthRateQoQPreliminary: str = "gdp growth rate qoq preliminary"
            """GDP Growth Rate QoQ Prel"""

            GdpGrowthRateQoQSecondEstimate: str = "gdp growth rate qoq second estimate"
            """GDP Growth Rate QoQ 2nd Est"""

            GdpGrowthRateYoY: str = "gdp growth rate yoy"
            """GDP Growth Rate YoY"""

            GdpGrowthRateYoYFinal: str = "gdp growth rate yoy final"
            """GDP Growth Rate YoY Final"""

            GdpGrowthRateYoYFlash: str = "gdp growth rate yoy flash"
            """GDP Growth Rate YoY Flash"""

            GdpGrowthRateYoYPreliminary: str = "gdp growth rate yoy preliminary"
            """GDP Growth Rate YoY Prel"""

            GdpGrowthRateYoYSecondEstimate: str = "gdp growth rate yoy second estimate"
            """GDP Growth Rate YoY 2nd Est"""

            GoodFriday: str = "good friday"
            """Good Friday"""

            IndustrialProductionMoM: str = "industrial production mom"
            """Industrial Production MoM"""

            IndustrialProductionYoY: str = "industrial production yoy"
            """Industrial Production YoY"""

            InflationRateMoM: str = "inflation rate mom"
            """Inflation Rate MoM"""

            InflationRateYoY: str = "inflation rate yoy"
            """Inflation Rate YoY"""

            LaborDay: str = "labor day"
            """Labour Day"""

            MidsummerDay: str = "midsummer day"
            """Midsummer Day"""

            NationalDay: str = "national day"
            """National Day"""

            NewYearsDay: str = "new years day"
            """New Year's Day"""

            NewYearsEve: str = "new years eve"
            """New Year's Eve"""

            ProclemationOfTheRepublic: str = "proclemation of the republic"
            """Proclemation of The Republic"""

            ProducerPriceIndexMoM: str = "producer price index mom"
            """PPI MoM"""

            ProducerPriceIndexYoY: str = "producer price index yoy"
            """PPI YoY"""

            RetailSalesMoM: str = "retail sales mom"
            """Retail Sales MoM"""

            RetailSalesYoY: str = "retail sales yoy"
            """Retail Sales YoY"""

            StJohnsDay: str = "st johns day"
            """St John's Day"""

            UnemploymentRate: str = "unemployment rate"
            """Unemployment Rate"""

        class Lithuania(System.Object):
            """Lithuania"""

            AllSaintsDay: str = "all saints day"
            """All Saint's Day"""

            AssumptionOfMary: str = "assumption of mary"
            """Assumption of Mary"""

            BalanceOfTrade: str = "balance of trade"
            """Balance of Trade"""

            BusinessConfidence: str = "business confidence"
            """Business Confidence"""

            ChristmasDay: str = "christmas day"
            """Christmas Day"""

            ChristmasEve: str = "christmas eve"
            """Christmas Eve"""

            ChristmasHoliday: str = "christmas holiday"
            """Christmas Holiday"""

            ConsumerConfidence: str = "consumer confidence"
            """Consumer Confidence"""

            CurrentAccount: str = "current account"
            """Current Account"""

            EasterMonday: str = "easter monday"
            """Easter Monday"""

            EasterSunday: str = "easter sunday"
            """Easter Sunday"""

            FathersDay: str = "fathers day"
            """Father’s Day"""

            GdpGrowthRateQoQ: str = "gdp growth rate qoq"
            """GDP Growth Rate QoQ"""

            GdpGrowthRateQoQFinal: str = "gdp growth rate qoq final"
            """GDP Growth Rate QoQ - F."""

            GdpGrowthRateQoQFlash: str = "gdp growth rate qoq flash"
            """GDP Growth Rate QoQ Flash"""

            GdpGrowthRateQoQPreliminary: str = "gdp growth rate qoq preliminary"
            """GDP Growth Rate QoQ Prel"""

            GdpGrowthRateQoQSecondEstimate: str = "gdp growth rate qoq second estimate"
            """GDP Growth Rate QoQ 2nd Est"""

            GdpGrowthRateYoY: str = "gdp growth rate yoy"
            """GDP Growth Rate YoY"""

            GdpGrowthRateYoYFinal: str = "gdp growth rate yoy final"
            """GDP Growth Rate YoY - F."""

            GdpGrowthRateYoYFlash: str = "gdp growth rate yoy flash"
            """GDP Growth Rate YoY Flash"""

            GdpGrowthRateYoYPreliminary: str = "gdp growth rate yoy preliminary"
            """GDP Growth Rate YoY Prel"""

            GdpGrowthRateYoYSecondEstimate: str = "gdp growth rate yoy second estimate"
            """GDP Growth Rate YoY 2nd Est"""

            IndependenceDay: str = "independence day"
            """Independence Day"""

            IndependenceRestorationDay: str = "independence restoration day"
            """Independence Restoration Day"""

            IndustrialProduction: str = "industrial production"
            """Industrial Production"""

            IndustrialProductionMoM: str = "industrial production mom"
            """Industrial Production MoM"""

            IndustrialProductionYoY: str = "industrial production yoy"
            """Industrial Production YoY"""

            InflationRateMoM: str = "inflation rate mom"
            """Inflation Rate MoM"""

            InflationRateYoY: str = "inflation rate yoy"
            """Inflation Rate YoY"""

            KingMindaugasCoronationDay: str = "king mindaugas coronation day"
            """King Mindaugas’ Coronation Day"""

            LaborDay: str = "labor day"
            """Labour Day"""

            MothersDay: str = "mothers day"
            """Mother’s Day"""

            NewYearsDay: str = "new years day"
            """New Year's Day"""

            ParliamentaryElections: str = "parliamentary elections"
            """Parliamentary Elections"""

            ParliamentaryElectionsSecondRound: str = "parliamentary elections second round"
            """Parliamentary Elections 2nd Round"""

            PresidentialElection: str = "presidential election"
            """Presidential Election"""

            ProducerPriceIndexMoM: str = "producer price index mom"
            """PPI MoM"""

            ProducerPriceIndexYoY: str = "producer price index yoy"
            """PPI YoY"""

            RestorationOfIndependenceDay: str = "restoration of independence day"
            """Restoration of Independence Day"""

            RetailSalesMoM: str = "retail sales mom"
            """Retail Sales MoM"""

            RetailSalesYoY: str = "retail sales yoy"
            """Retail Sales YoY"""

            SecondDayOfChristmas: str = "second day of christmas"
            """2nd Day of Christmas"""

            StJohnsDay: str = "st johns day"
            """St John's Day"""

            UnemploymentRate: str = "unemployment rate"
            """Unemployment Rate"""

        class Luxembourg(System.Object):
            """Luxembourg"""

            AllSaintsDay: str = "all saints day"
            """All Saint's Day"""

            AscensionDay: str = "ascension day"
            """Ascension Day"""

            AssumptionOfMary: str = "assumption of mary"
            """Assumption of Mary"""

            BalanceOfTrade: str = "balance of trade"
            """Balance of Trade"""

            BoxingDay: str = "boxing day"
            """Boxing Day"""

            BusinessConfidence: str = "business confidence"
            """Business Confidence"""

            ChristmasDay: str = "christmas day"
            """Christmas Day"""

            ChristmasEve: str = "christmas eve"
            """Christmas Eve"""

            ConsumerConfidence: str = "consumer confidence"
            """Consumer Confidence"""

            CurrentAccount: str = "current account"
            """Current Account"""

            EasterMonday: str = "easter monday"
            """Easter Monday"""

            EuropeDay: str = "europe day"
            """Europe Day"""

            GdpGrowthRateQoQ: str = "gdp growth rate qoq"
            """GDP Growth Rate QoQ"""

            GdpGrowthRateYoY: str = "gdp growth rate yoy"
            """GDP Growth Rate YoY"""

            GoodFriday: str = "good friday"
            """Good Friday"""

            IndustrialProductionYoY: str = "industrial production yoy"
            """Industrial Production YoY"""

            InflationRateYoY: str = "inflation rate yoy"
            """Inflation Rate YoY"""

            LaborDay: str = "labor day"
            """Labour Day"""

            NationalDay: str = "national day"
            """National Day"""

            NewYearsDay: str = "new years day"
            """New Year's Day"""

            ParliamentaryElections: str = "parliamentary elections"
            """Parliamentary Elections"""

            ProducerPriceIndexYoY: str = "producer price index yoy"
            """PPI YoY"""

            RetailSalesMoM: str = "retail sales mom"
            """Retail Sales MoM"""

            StStephensDay: str = "st stephens day"
            """St Stephen's Day"""

            UnemploymentRate: str = "unemployment rate"
            """Unemployment Rate"""

            WhitMonday: str = "whit monday"
            """Whit Monday"""

        class Malta(System.Object):
            """Malta"""

            AssumptionOfMary: str = "assumption of mary"
            """Assumption of Mary"""

            BalanceOfTrade: str = "balance of trade"
            """Balance of Trade"""

            BusinessConfidence: str = "business confidence"
            """Business Confidence"""

            ChristmasDay: str = "christmas day"
            """Christmas Day"""

            ConsumerConfidence: str = "consumer confidence"
            """Consumer Confidence"""

            FeastOfOurLadyOfVictories: str = "feast of our lady of victories"
            """Feast of our Lady of Victories"""

            FeastOfStJoseph: str = "feast of st joseph"
            """Feast of St Joseph"""

            FeastOfStPaulsShipwreck: str = "feast of st pauls shipwreck"
            """Feast of St Paul's Shipwreck"""

            FeastOfStPeterAndStPaul: str = "feast of st peter and st paul"
            """Feast of St Peter and St Paul"""

            FreedomDay: str = "freedom day"
            """Freedom Day"""

            GdpGrowthRateYoY: str = "gdp growth rate yoy"
            """GDP Growth Rate YoY"""

            GoodFriday: str = "good friday"
            """Good Friday"""

            ImmaculateConception: str = "immaculate conception"
            """Immaculate Conception"""

            IndependenceDay: str = "independence day"
            """Independence Day"""

            IndustrialProductionYoY: str = "industrial production yoy"
            """Industrial Production YoY"""

            InflationRate: str = "inflation rate"
            """Inflation Rate"""

            InflationRateYoY: str = "inflation rate yoy"
            """Inflation Rate YoY"""

            LaborDay: str = "labor day"
            """Labour Day"""

            NewYearsDay: str = "new years day"
            """New Year's Day"""

            ParliamentaryElections: str = "parliamentary elections"
            """Parliamentary Elections"""

            ProducerPriceIndexYoY: str = "producer price index yoy"
            """PPI YoY"""

            RepublicDay: str = "republic day"
            """Republic Day"""

            RetailSalesMoM: str = "retail sales mom"
            """Retail Sales MoM"""

            RetailSalesYoY: str = "retail sales yoy"
            """Retail Sales YoY"""

            SetteGiugno: str = "sette giugno"
            """Sette Giugno"""

            StJosephsDay: str = "st josephs day"
            """St Joseph's Day"""

            UnemploymentRate: str = "unemployment rate"
            """Unemployment Rate"""

        class Netherlands(System.Object):
            """Netherlands"""

            AscensionDay: str = "ascension day"
            """Ascension Day"""

            BalanceOfTrade: str = "balance of trade"
            """Balance of Trade"""

            BoxingDay: str = "boxing day"
            """Boxing Day"""

            BusinessConfidence: str = "business confidence"
            """Business Confidence"""

            ChristmasDay: str = "christmas day"
            """Christmas Day"""

            ConsumerConfidence: str = "consumer confidence"
            """Consumer Confidence"""

            ConsumerSpendingVolume: str = "consumer spending volume"
            """Consumer Spending Volume"""

            CurrentAccount: str = "current account"
            """Current Account"""

            EasterMonday: str = "easter monday"
            """Easter Monday"""

            EasterSunday: str = "easter sunday"
            """Easter Sunday"""

            GdpGrowthRateQoQ: str = "gdp growth rate qoq"
            """GDP Growth Rate QoQ"""

            GdpGrowthRateQoQFinal: str = "gdp growth rate qoq final"
            """GDP Growth Rate QoQ Final"""

            GdpGrowthRateQoQFlash: str = "gdp growth rate qoq flash"
            """GDP Growth Rate QoQ Flash"""

            GdpGrowthRateQoQPreliminary: str = "gdp growth rate qoq preliminary"
            """GDP Growth Rate QoQ Prel"""

            GdpGrowthRateQoQSecondEstimate: str = "gdp growth rate qoq second estimate"
            """GDP Growth Rate QoQ 2nd Est"""

            GdpGrowthRateYoY: str = "gdp growth rate yoy"
            """GDP Growth Rate YoY"""

            GdpGrowthRateYoYFinal: str = "gdp growth rate yoy final"
            """GDP Growth Rate YoY Final"""

            GdpGrowthRateYoYFlash: str = "gdp growth rate yoy flash"
            """GDP Growth Rate YoY Flash"""

            GdpGrowthRateYoYPreliminary: str = "gdp growth rate yoy preliminary"
            """GDP Growth Rate YoY Prel"""

            GdpGrowthRateYoYSecondEstimate: str = "gdp growth rate yoy second estimate"
            """GDP Growth Rate YoY 2nd Est"""

            GoodFriday: str = "good friday"
            """Good Friday"""

            HouseholdConsumptionYoY: str = "household consumption yoy"
            """Household Consumption YoY"""

            IndustrialProductionMoM: str = "industrial production mom"
            """Industrial Production MoM"""

            IndustrialProductionYoY: str = "industrial production yoy"
            """Industrial Production YoY"""

            InflationRateYoY: str = "inflation rate yoy"
            """Inflation Rate YoY"""

            KingsDay: str = "kings day"
            """King's Day"""

            LiberationDay: str = "liberation day"
            """Liberation Day"""

            LocalElections: str = "local elections"
            """Local Elections"""

            ManufacturingConfidence: str = "manufacturing confidence"
            """Manufacturing Confidence"""

            ManufacturingProductionYoY: str = "manufacturing production yoy"
            """Manufacturing Prod YoY"""

            NeviManufacturingPurchasingManagersIndex: str = "nevi manufacturing purchasing managers index"
            """NEVI Manufacturing PMI"""

            NewYearsDay: str = "new years day"
            """New Year's Day"""

            ParliamentaryElections: str = "parliamentary elections"
            """Parliamentary Elections"""

            Pentecost: str = "pentecost"
            """Pentecost"""

            RetailSalesMoM: str = "retail sales mom"
            """Retail Sales MoM"""

            RetailSalesYoY: str = "retail sales yoy"
            """Retail Sales YoY"""

            SixMonthBillAuction: str = "6 month bill auction"
            """6-Month Bill Auction"""

            TenYearBondAuction: str = "10 year bond auction"
            """10-Year Bond Auction"""

            ThreeMonthBillAuction: str = "3 month bill auction"
            """3-Month Bill Auction"""

            UnemploymentRate: str = "unemployment rate"
            """Unemployment Rate"""

            WhitMonday: str = "whit monday"
            """Whit Monday"""

        class NewZealand(System.Object):
            """New Zealand"""

            AnzacDay: str = "anzac day"
            """ANZAC Day"""

            AnzBusinessConfidence: str = "anz business confidence"
            """ANZ Business Confidence"""

            AnzCommodityPrice: str = "anz commodity price"
            """ANZ Commodity Price"""

            AnzRoyMorganConsumerConfidence: str = "anz roy morgan consumer confidence"
            """ANZ Roy Morgan Consumer Confidence"""

            BalanceOfTrade: str = "balance of trade"
            """Balance of Trade"""

            BoxingDay: str = "boxing day"
            """Boxing Day"""

            BuildingPermitsMoM: str = "building permits mom"
            """Building Permits MoM"""

            BuildingPermitsSeasonallyAdjustedMoM: str = "building permits seasonally adjusted mom"
            """Building Permits s.a. (MoM)"""

            BusinessInflationExpectations: str = "business inflation expectations"
            """Business Inflation Expectations"""

            BusinessNzPurchasingManagersIndex: str = "business nz purchasing managers index"
            """Business NZ PMI"""

            ChristmasDay: str = "christmas day"
            """Christmas Day"""

            CurrentAccount: str = "current account"
            """Current Account"""

            DayAfterNewYearsDay: str = "day after new years day"
            """Day After New Year's Day"""

            EasterMonday: str = "easter monday"
            """Easter Monday"""

            EasterSunday: str = "easter sunday"
            """Easter Sunday"""

            ElectronicCardRetailSalesMoM: str = "electronic card retail sales mom"
            """Electronic Card Retail Sales  (MoM)"""

            ElectronicCardRetailSalesYoY: str = "electronic card retail sales yoy"
            """Electronic Card Retail Sales (YoY)"""

            ElectronicRetailCardSpendingMoM: str = "electronic retail card spending mom"
            """Electronic Retail Card Spending MoM"""

            ElectronicRetailCardSpendingYoY: str = "electronic retail card spending yoy"
            """Electronic Retail Card Spending YoY"""

            EmploymentChangeQoQ: str = "employment change qoq"
            """Employment Change QoQ"""

            ExportPricesQoQ: str = "export prices qoq"
            """Export Prices QoQ"""

            Exports: str = "exports"
            """Exports"""

            FinancialStabilityReport: str = "financial stability report"
            """Financial Stability Report"""

            FirstDayFlagReferendum: str = "first day flag referendum"
            """1st Day Flag Referendum"""

            FoodInflationYoY: str = "food inflation yoy"
            """Food Inflation YoY"""

            FoodPriceIndexMoM: str = "food price index mom"
            """Food Price Index (MoM)"""

            GdpGrowthRateQoQ: str = "gdp growth rate qoq"
            """GDP Growth Rate QoQ"""

            GdpGrowthRateYoY: str = "gdp growth rate yoy"
            """GDP Growth Rate YoY"""

            GeneralElections: str = "general elections"
            """General Elections"""

            GlobalDairyTradePriceIndex: str = "global dairy trade price index"
            """Global Dairy Trade Price Index"""

            GoodFriday: str = "good friday"
            """Good Friday"""

            ImportPricesQoQ: str = "import prices qoq"
            """Import Prices QoQ"""

            Imports: str = "imports"
            """Imports"""

            IndustrialProductionYoY: str = "industrial production yoy"
            """Industrial Production YoY"""

            InflationRateQoQ: str = "inflation rate qoq"
            """Inflation Rate QoQ"""

            InflationRateYoY: str = "inflation rate yoy"
            """Inflation Rate YoY"""

            InterestRateDecision: str = "interest rate decision"
            """Interest Rate Decision"""

            LaborCostsIndexQoQ: str = "labor costs index qoq"
            """Labour cost index QoQ"""

            LaborCostsIndexYoY: str = "labor costs index yoy"
            """Labour cost index YoY"""

            LaborDay: str = "labor day"
            """Labour Day"""

            LastDayFlagReferendum: str = "last day flag referendum"
            """Last Day Flag Referendum"""

            ManufacturingProductionYoY: str = "manufacturing production yoy"
            """Manufacturing Production YoY"""

            ManufacturingSales: str = "manufacturing sales"
            """Manufacturing sales"""

            ManufacturingSalesYoY: str = "manufacturing sales yoy"
            """Manufacturing Sales YoY"""

            MarkitBusinessNzPurchasingManagersIndex: str = "markit business nz purchasing managers index"
            """Business NZ/Markit PMI"""

            MonetaryPolicyStatement: str = "monetary policy statement"
            """Monetary Policy Statement"""

            NewYearsDay: str = "new years day"
            """New Year's Day"""

            NzierBusinessConfidence: str = "nzier business confidence"
            """NZIER Business Confidence"""

            NzierBusinessConfidenceQoQ: str = "nzier business confidence qoq"
            """NZIER Business Confidence QoQ"""

            NzierCapacityUtilization: str = "nzier capacity utilization"
            """NZIER Capacity Utilization"""

            NzierQsboCapacityUtilization: str = "nzier qsbo capacity utilization"
            """NZIER QSBO Capacity Utilization"""

            ParticipationRate: str = "participation rate"
            """Participation Rate"""

            ProducerPriceIndexInputQoQ: str = "producer price index input qoq"
            """PPI Input QoQ"""

            ProducerPriceIndexOutputQoQ: str = "producer price index output qoq"
            """PPI Output QoQ"""

            QueensBirthdayDay: str = "queens birthday day"
            """Queen's Birthday Day"""

            RbnzEconomicAssesment: str = "rbnz economic assesment"
            """RBNZ Economic Assesment"""

            RbnzFinancialStabilityReport: str = "rbnz financial stability report"
            """RBNZ Financial Stability Report"""

            RbnzGovOrrSpeech: str = "rbnz gov orr speech"
            """RBNZ Gov Orr Speech"""

            RbnzGovWheelerSpeech: str = "rbnz gov wheeler speech"
            """RBNZ Gov Wheeler Speech"""

            RbnzInflationExpectationsYoY: str = "rbnz inflation expectations yoy"
            """RBNZ Inflation Expectations (YoY)"""

            RbnzMcdermottSpeech: str = "rbnz mcdermott speech"
            """RBNZ McDermott Speech"""

            RbnzPressConference: str = "rbnz press conference"
            """RBNZ Press Conference"""

            RbnzWheelerSpeech: str = "rbnz wheeler speech"
            """RBNZ Wheeler Speech"""

            ReinzHousePriceIndexMoM: str = "reinz house price index mom"
            """REINZ House Price Index MoM"""

            RetailSalesQoQ: str = "retail sales qoq"
            """Retail Sales QoQ"""

            RetailSalesYoY: str = "retail sales yoy"
            """Retail Sales YoY"""

            ServicesNzPerformanceOfServicesIndex: str = "services nz performance of services index"
            """Services NZ PSI"""

            TermsOfTradeQoQ: str = "terms of trade qoq"
            """Terms of Trade QoQ"""

            TradeBalanceMoM: str = "trade balance mom"
            """Trade Balance (MoM)"""

            TradeBalanceYoY: str = "trade balance yoy"
            """Trade Balance (YoY)"""

            UnemploymentRate: str = "unemployment rate"
            """Unemployment Rate"""

            VisitorArrivalsMoM: str = "visitor arrivals mom"
            """Visitor Arrivals MoM"""

            VisitorArrivalsYoY: str = "visitor arrivals yoy"
            """Visitor Arrivals (YoY)"""

            WaitangiDay: str = "waitangi day"
            """Waitangi Day"""

            WestpacConsumerConfidence: str = "westpac consumer confidence"
            """Consumer Confidence WESTPAC"""

            WestpacConsumerSurvey: str = "westpac consumer survey"
            """Westpac consumer survey"""

        class Portugal(System.Object):
            """Portugal"""

            AllSaintsDay: str = "all saints day"
            """All Saints' Day"""

            AssumptionOfMary: str = "assumption of mary"
            """Assumption of Mary"""

            BalanceOfTrade: str = "balance of trade"
            """Balance of Trade"""

            BdpGovCostaSpeech: str = "bdp gov costa speech"
            """BdP Gov Costa Speech"""

            BudgetBalance: str = "budget balance"
            """Budget Balance"""

            BusinessConfidence: str = "business confidence"
            """Business Confidence"""

            ChristmasDay: str = "christmas day"
            """Christmas Day"""

            ConsumerConfidence: str = "consumer confidence"
            """Consumer Confidence"""

            CorpusChristi: str = "corpus christi"
            """Corpus Christi"""

            CurrentAccount: str = "current account"
            """Current Account"""

            EasterSunday: str = "easter sunday"
            """Easter Sunday"""

            EcbForumOnCentralBanking: str = "ecb forum on central banking"
            """ECB Forum on Central Banking"""

            EconomicActivityYoY: str = "economic activity yoy"
            """Economic Activity YoY"""

            Exports: str = "exports"
            """Exports"""

            GdpAnnualGrowthRateYoY: str = "gdp annual growth rate yoy"
            """GDP Annual Growth Rate YoY"""

            GdpGrowthRateQoQ: str = "gdp growth rate qoq"
            """GDP Growth Rate QoQ"""

            GdpGrowthRateQoQFinal: str = "gdp growth rate qoq final"
            """GDP Growth Rate QoQ Final"""

            GdpGrowthRateQoQPreliminary: str = "gdp growth rate qoq preliminary"
            """GDP Growth Rate QoQ Prel"""

            GdpGrowthRateQoQSecondEstimate: str = "gdp growth rate qoq second estimate"
            """GDP Growth Rate QoQ 2nd Est"""

            GdpGrowthRateYoY: str = "gdp growth rate yoy"
            """GDP Growth Rate YoY"""

            GdpGrowthRateYoYFinal: str = "gdp growth rate yoy final"
            """GDP Growth Rate YoY Final"""

            GdpGrowthRateYoYPreliminary: str = "gdp growth rate yoy preliminary"
            """GDP Growth Rate YoY Prel"""

            GdpGrowthRateYoYSecondEstimate: str = "gdp growth rate yoy second estimate"
            """GDP Growth Rate YoY 2nd Est"""

            GoodFriday: str = "good friday"
            """Good Friday"""

            ImmaculateConception: str = "immaculate conception"
            """Immaculate Conception"""

            Imports: str = "imports"
            """Imports"""

            IndustrialProduction: str = "industrial production"
            """Industrial Production"""

            IndustrialProductionMoM: str = "industrial production mom"
            """Industrial Production MoM"""

            IndustrialProductionYoY: str = "industrial production yoy"
            """Industrial Production YoY"""

            InflationRateMoM: str = "inflation rate mom"
            """Inflation Rate MoM"""

            InflationRateMoMFinal: str = "inflation rate mom final"
            """Inflation Rate MoM Final"""

            InflationRateMoMPreliminary: str = "inflation rate mom preliminary"
            """Inflation Rate MoM Prel"""

            InflationRateYoY: str = "inflation rate yoy"
            """Inflation Rate YoY"""

            InflationRateYoYFinal: str = "inflation rate yoy final"
            """Inflation Rate YoY Final"""

            InflationRateYoYPreliminary: str = "inflation rate yoy preliminary"
            """Inflation Rate YoY Prel"""

            LaborDay: str = "labor day"
            """Labour Day"""

            LibertyDay: str = "liberty day"
            """Liberty Day"""

            NationalDay: str = "national day"
            """National Day"""

            NewYearsDay: str = "new years day"
            """New Year's Day"""

            ParliamentaryElections: str = "parliamentary elections"
            """Parliamentary Elections"""

            PrivateConsumptionYoY: str = "private consumption yoy"
            """Private Consumption YoY"""

            ProducerPriceIndexMoM: str = "producer price index mom"
            """PPI MoM"""

            ProducerPriceIndexYoY: str = "producer price index yoy"
            """PPI YoY"""

            RepublicImplantation: str = "republic implantation"
            """Republic Implantation"""

            RestorationOfIndependence: str = "restoration of independence"
            """Restoration of Independence"""

            RetailSalesMoM: str = "retail sales mom"
            """Retail Sales MoM"""

            RetailSalesYoY: str = "retail sales yoy"
            """Retail Sales YoY"""

            UnemploymentRate: str = "unemployment rate"
            """Unemployment Rate"""

        class Slovakia(System.Object):
            """Slovakia"""

            AllSaintsDay: str = "all saints day"
            """All Saint's Day"""

            BalanceOfTrade: str = "balance of trade"
            """Balance of Trade"""

            BusinessConfidence: str = "business confidence"
            """Business Confidence"""

            ChristmasDay: str = "christmas day"
            """Christmas Day"""

            ChristmasEve: str = "christmas eve"
            """Christmas Eve"""

            ConstitutionDay: str = "constitution day"
            """Constitution Day"""

            ConstructionOutputYoY: str = "construction output yoy"
            """Construction Output YoY"""

            ConsumerConfidence: str = "consumer confidence"
            """Consumer Confidence"""

            CoreInflationRateMoM: str = "core inflation rate mom"
            """Core Inflation Rate MoM"""

            CoreInflationRateYoY: str = "core inflation rate yoy"
            """Core Inflation Rate YoY"""

            CurrentAccount: str = "current account"
            """Current Account"""

            DayOfOurLadyOfSorrows: str = "day of our lady of sorrows"
            """Day of Our Lady of Sorrows"""

            EasterMonday: str = "easter monday"
            """Easter Monday"""

            EndOfWorldWarIi: str = "end of world war ii"
            """End of World War II"""

            Epiphany: str = "epiphany"
            """Epiphany"""

            EpiphanyDay: str = "epiphany day"
            """Epiphany Day"""

            EstablishmentOfTheSlovakRepublic: str = "establishment of the slovak republic"
            """Establishment of the Slovak Republic"""

            EuropeanCouncilMeeting: str = "european council meeting"
            """European Council Meeting"""

            Exports: str = "exports"
            """Exports"""

            FinanceMinistryEconomicForecasts: str = "finance ministry economic forecasts"
            """Finance Ministry Economic Forecasts"""

            GdpAnnualGrowthRateYoY: str = "gdp annual growth rate yoy"
            """GDP Annual Growth Rate YoY"""

            GdpGrowthRateQoQ: str = "gdp growth rate qoq"
            """GDP Growth Rate QoQ"""

            GdpGrowthRateQoQFinal: str = "gdp growth rate qoq final"
            """GDP Growth Rate QoQ Final"""

            GdpGrowthRateQoQFlash: str = "gdp growth rate qoq flash"
            """GDP Growth Rate QoQ Flash"""

            GdpGrowthRateQoQPreliminary: str = "gdp growth rate qoq preliminary"
            """GDP Growth Rate QoQ Prel"""

            GdpGrowthRateQoQSecondEstimate: str = "gdp growth rate qoq second estimate"
            """GDP Growth Rate QoQ 2nd Est"""

            GdpGrowthRateYoY: str = "gdp growth rate yoy"
            """GDP Growth Rate YoY"""

            GdpGrowthRateYoYFinal: str = "gdp growth rate yoy final"
            """GDP Growth Rate YoY Final"""

            GdpGrowthRateYoYFlash: str = "gdp growth rate yoy flash"
            """GDP Growth Rate YoY Flash"""

            GdpGrowthRateYoYPreliminary: str = "gdp growth rate yoy preliminary"
            """GDP Growth Rate YoY Prel"""

            GdpGrowthRateYoYSecondEstimate: str = "gdp growth rate yoy second estimate"
            """GDP Growth Rate YoY 2nd Est"""

            GdpGrowthRateYoYSecondFinal: str = "gdp growth rate yoy second final"
            """GDP Growth Rate YoY 2nd Final"""

            GoodFriday: str = "good friday"
            """Good Friday"""

            HarmonizedInflationRateMoM: str = "harmonized inflation rate mom"
            """Harmonised Inflation Rate MoM"""

            HarmonizedInflationRateYoY: str = "harmonized inflation rate yoy"
            """Harmonised Inflation Rate YoY"""

            Imports: str = "imports"
            """Imports"""

            IndustrialProductionMoM: str = "industrial production mom"
            """Industrial Production MoM"""

            IndustrialProductionYoY: str = "industrial production yoy"
            """Industrial Production YoY"""

            InflationRateMoM: str = "inflation rate mom"
            """Inflation Rate MoM"""

            InflationRateYoY: str = "inflation rate yoy"
            """Inflation Rate YoY"""

            InformalEcofinMeeting: str = "informal ecofin meeting"
            """Informal Ecofin Meeting"""

            LaborDay: str = "labor day"
            """Labour Day"""

            NationalUprisingDay: str = "national uprising day"
            """National Uprising Day"""

            NbsGovMakuchSpeech: str = "nbs gov makuch speech"
            """NBS Gov Makuch Speech"""

            NewYearsDay: str = "new years day"
            """New Year's Day"""

            ParliamentaryElections: str = "parliamentary elections"
            """Parliamentary Elections"""

            PresidentialElection: str = "presidential election"
            """Presidential Election"""

            RealWagesYoY: str = "real wages yoy"
            """Real Wages YoY"""

            RepublicDay: str = "republic day"
            """Republic Day"""

            RetailSalesMoM: str = "retail sales mom"
            """Retail Sales MoM"""

            RetailSalesYoY: str = "retail sales yoy"
            """Retail Sales YoY"""

            StCyrilAndMethodiusDay: str = "st cyril and methodius day"
            """St Cyril and Methodius Day"""

            StruggleForFreedomAndDemocracyDay: str = "struggle for freedom and democracy day"
            """Struggle for Freedom and Democracy Day"""

            StStephensDay: str = "st stephens day"
            """St Stephen's Day"""

            UnemploymentRate: str = "unemployment rate"
            """Unemployment Rate"""

        class Slovenia(System.Object):
            """Slovenia"""

            AllSaintsDay: str = "all saints day"
            """All Saint's Day"""

            AssumptionOfMary: str = "assumption of mary"
            """Assumption of Mary"""

            BalanceOfTrade: str = "balance of trade"
            """Balance of Trade"""

            BosFesticSpeech: str = "bos festic speech"
            """BoS Festic Speech"""

            BusinessConfidence: str = "business confidence"
            """Business Confidence"""

            ChristmasDay: str = "christmas day"
            """Christmas Day"""

            ConsumerConfidence: str = "consumer confidence"
            """Consumer Confidence"""

            DayOfUprisingAgainstOccupation: str = "day of uprising against occupation"
            """Day of Uprising Against Occupation"""

            EasterMonday: str = "easter monday"
            """Easter Monday"""

            EasterSunday: str = "easter sunday"
            """Easter Sunday"""

            FinanceMinisterMramorSpeech: str = "finance minister mramor speech"
            """Finance Minister Mramor Speech"""

            GdpGrowthRateQoQ: str = "gdp growth rate qoq"
            """GDP Growth Rate QoQ"""

            GdpGrowthRateQoQFinal: str = "gdp growth rate qoq final"
            """GDP Growth Rate QoQ Final"""

            GdpGrowthRateYoY: str = "gdp growth rate yoy"
            """GDP Growth Rate YoY"""

            GdpGrowthRateYoYFinal: str = "gdp growth rate yoy final"
            """GDP Growth Rate YoY Final"""

            HarmonizedInflationRateYoY: str = "harmonized inflation rate yoy"
            """Harmonised Inflation Rate YoY"""

            IndependenceAndUnitDay: str = "independence and unit day"
            """Independence and Unit Day"""

            IndustrialProductionMoM: str = "industrial production mom"
            """Industrial Production MoM"""

            IndustrialProductionYoY: str = "industrial production yoy"
            """Industrial Production YoY"""

            InflationRateYoY: str = "inflation rate yoy"
            """Inflation Rate YoY"""

            LaborDay: str = "labor day"
            """Labour Day"""

            LaborDaySubstituteDay: str = "labor day substitute day"
            """Labour Day (Substitute Day)"""

            MayDay: str = "may day"
            """May Day"""

            MayDayHoliday: str = "may day holiday"
            """May Day Holiday"""

            NationalDay: str = "national day"
            """National Day"""

            NewYearsDay: str = "new years day"
            """New Year's Day"""

            NewYearsHoliday: str = "new years holiday"
            """New Year's Holiday"""

            Pentecost: str = "pentecost"
            """Pentecost"""

            PreerenDay: str = "preeren day"
            """Prešeren Day"""

            ProducerPriceIndexYoY: str = "producer price index yoy"
            """PPI YoY"""

            ReformationDay: str = "reformation day"
            """Reformation Day"""

            RetailSalesMoM: str = "retail sales mom"
            """Retail Sales MoM"""

            RetailSalesYoY: str = "retail sales yoy"
            """Retail Sales YoY"""

            RethinkingMonetaryFiscalPolicyCoordinationSeminar: str = "rethinking monetary fiscal policy coordination seminar"
            """Rethinking Monetary-Fiscal Policy Coordination Seminar"""

            TouristArrivalsYoY: str = "tourist arrivals yoy"
            """Tourist Arrivals YoY"""

            UnemploymentRate: str = "unemployment rate"
            """Unemployment Rate"""

            UprisingAgainstTheOccupationDay: str = "uprising against the occupation day"
            """Uprising Against the Occupation Day"""

        class Spain(System.Object):
            """Spain"""

            AllSaintsDay: str = "all saints day"
            """All Saints' Day"""

            AssumptionOfMary: str = "assumption of mary"
            """Assumption of Mary"""

            BalanceOfTrade: str = "balance of trade"
            """Balance of Trade"""

            BdeGovLindeSpeech: str = "bde gov linde speech"
            """BdE Gov Linde Speech"""

            BusinessConfidence: str = "business confidence"
            """Business Confidence"""

            CatalonianParlimentaryElections: str = "catalonian parlimentary elections"
            """Catalonian Parlimentary Elections"""

            CataloniaParliamentaryElection: str = "catalonia parliamentary election"
            """Catalonia Parliamentary Election"""

            ChristmasDay: str = "christmas day"
            """Christmas Day"""

            ConstitutionDay: str = "constitution day"
            """Constitution Day"""

            ConsumerConfidence: str = "consumer confidence"
            """Consumer Confidence"""

            CurrentAccount: str = "current account"
            """Current Account"""

            Epiphany: str = "epiphany"
            """Epiphany"""

            EpiphanyHoliday: str = "epiphany holiday"
            """Epiphany Holiday"""

            FinanceMinisterGuindosSpeech: str = "finance minister guindos speech"
            """Finance Minister Guindos Speech"""

            FiveYearBonosAuction: str = "5 year bonos auction"
            """5-Year Bonos Auction"""

            GdpGrowthRateQoQ: str = "gdp growth rate qoq"
            """GDP Growth Rate QoQ"""

            GdpGrowthRateQoQFinal: str = "gdp growth rate qoq final"
            """GDP Growth Rate QoQ Final"""

            GdpGrowthRateQoQFlash: str = "gdp growth rate qoq flash"
            """GDP Growth Rate QoQ Flash"""

            GdpGrowthRateQoQPreliminary: str = "gdp growth rate qoq preliminary"
            """GDP Growth Rate QoQ Prel"""

            GdpGrowthRateYoY: str = "gdp growth rate yoy"
            """GDP Growth Rate YoY"""

            GdpGrowthRateYoYFinal: str = "gdp growth rate yoy final"
            """GDP Growth Rate YoY Final"""

            GdpGrowthRateYoYFlash: str = "gdp growth rate yoy flash"
            """GDP Growth Rate YoY Flash"""

            GdpGrowthRateYoYPreliminary: str = "gdp growth rate yoy preliminary"
            """GDP Growth Rate YoY Prel"""

            GeneralElection: str = "general election"
            """General Election"""

            GeneralElections: str = "general elections"
            """General Elections"""

            GoodFriday: str = "good friday"
            """Good Friday"""

            HarmonizedInflationRateMoMFinal: str = "harmonized inflation rate mom final"
            """Harmonised Inflation Rate MoM Final"""

            HarmonizedInflationRateMoMPreliminary: str = "harmonized inflation rate mom preliminary"
            """Harmonised Inflation Rate MoM Prel"""

            HarmonizedInflationRateYoYFinal: str = "harmonized inflation rate yoy final"
            """Harmonised Inflation Rate YoY Final"""

            HarmonizedInflationRateYoYPreliminary: str = "harmonized inflation rate yoy preliminary"
            """Harmonised Inflation Rate YoY Prel"""

            HispanicDay: str = "hispanic day"
            """Hispanic Day"""

            IifSpringMembershipMeetingTwoThousandSixteen: str = "iif spring membership meeting 2016"
            """IIF Spring Membership Meeting 2016"""

            ImmaculateConception: str = "immaculate conception"
            """Immaculate Conception"""

            IndustrialOrdersYoY: str = "industrial orders yoy"
            """Industrial Orders YoY"""

            IndustrialProductionYoY: str = "industrial production yoy"
            """Industrial Production YoY"""

            InflationRateMoM: str = "inflation rate mom"
            """Inflation Rate MoM"""

            InflationRateMoMFinal: str = "inflation rate mom final"
            """Inflation Rate MoM Final"""

            InflationRateMoMPreliminary: str = "inflation rate mom preliminary"
            """Inflation Rate MoM Prel"""

            InflationRateYoY: str = "inflation rate yoy"
            """Inflation Rate YoY"""

            InflationRateYoYFinal: str = "inflation rate yoy final"
            """Inflation Rate YoY Final"""

            InflationRateYoYPreliminary: str = "inflation rate yoy preliminary"
            """Inflation Rate YoY Prel"""

            LaborDay: str = "labor day"
            """Labour Day"""

            LaborDaySubstituteDay: str = "labor day substitute day"
            """Labour Day (Substitute Day)"""

            MarkitManufacturingPurchasingManagersIndex: str = "markit manufacturing purchasing managers index"
            """Markit Manufacturing PMI"""

            MarkitServicesPurchasingManagersIndex: str = "markit services purchasing managers index"
            """Markit Services PMI"""

            MaundyThursday: str = "maundy thursday"
            """Maundy Thursday"""

            NationalDay: str = "national day"
            """National Day"""

            NewCarSalesYoY: str = "new car sales yoy"
            """New Car Sales YoY"""

            NewYearsDay: str = "new years day"
            """New Year's Day"""

            NewYearsDaySubstituteDay: str = "new years day substitute day"
            """New Year's Day (Substitute Day)"""

            ParliamentaryElections: str = "parliamentary elections"
            """Parliamentary Elections"""

            ParliamentaryVoteOnTwoThousandNineteenBudget: str = "parliamentary vote on 2019 budget"
            """Parliamentary Vote on 2019 Budget"""

            ProducerPriceIndexYoY: str = "producer price index yoy"
            """PPI YoY"""

            RetailSalesMoM: str = "retail sales mom"
            """Retail Sales MoM"""

            RetailSalesYoY: str = "retail sales yoy"
            """Retail Sales YoY"""

            ServicesPurchasingManagersIndex: str = "services purchasing managers index"
            """Services PMI"""

            SixMonthLetrasAuction: str = "6 month letras auction"
            """6-Month Letras Auction"""

            StJosephsDay: str = "st josephs day"
            """St. Joseph's Day"""

            TenYearObligacionAuction: str = "10 year obligacion auction"
            """10-Year Obligacion Auction"""

            ThreeMonthLetrasAuction: str = "3 month letras auction"
            """3-Month Letras Auction"""

            ThreeYearBonosAuction: str = "3 year bonos auction"
            """3-Year Bonos Auction"""

            TouristArrivalsYoY: str = "tourist arrivals yoy"
            """Tourist Arrivals YoY"""

            TwelveMonthLetrasAuction: str = "12 month letras auction"
            """12-Month Letras Auction"""

            UnemploymentChange: str = "unemployment change"
            """Unemployment Change"""

            UnemploymentRate: str = "unemployment rate"
            """Unemployment Rate"""

        class Sweden(System.Object):
            """Sweden"""

            AllSaintsDay: str = "all saints day"
            """All Saint's Day"""

            AscensionDay: str = "ascension day"
            """Ascension Day"""

            BalanceOfTrade: str = "balance of trade"
            """Balance of Trade"""

            BoxingDay: str = "boxing day"
            """Boxing Day"""

            BusinessConfidence: str = "business confidence"
            """Business Confidence"""

            CapacityUtilizationQoQ: str = "capacity utilization qoq"
            """Capacity Utilization QoQ"""

            ChristmasDay: str = "christmas day"
            """Christmas Day"""

            ChristmasEve: str = "christmas eve"
            """Christmas Eve"""

            ConsumerConfidence: str = "consumer confidence"
            """Consumer Confidence"""

            ConsumerInflationExpectations: str = "consumer inflation expectations"
            """Consumer Inflation Expectations"""

            ConsumerPriceIndexFixedInterestRateMoM: str = "consumer price index fixed interest rate mom"
            """CPIF MoM"""

            ConsumerPriceIndexFixedInterestRateYoY: str = "consumer price index fixed interest rate yoy"
            """CPIF YoY"""

            CurrentAccount: str = "current account"
            """Current Account"""

            EasterEve: str = "easter eve"
            """Easter Eve"""

            EasterMonday: str = "easter monday"
            """Easter Monday"""

            EasterSunday: str = "easter sunday"
            """Easter Sunday"""

            Epiphany: str = "epiphany"
            """Epiphany"""

            EpiphanyDay: str = "epiphany day"
            """Epiphany Day"""

            FinancialStabilityReportTwoThousandEighteen: str = "financial stability report 2018"
            """Financial Stability Report 2018"""

            FinancialStabilityReportTwoThousandSeventeen: str = "financial stability report 2017"
            """Financial Stability Report 2017"""

            GdpGrowthRateQoQ: str = "gdp growth rate qoq"
            """GDP Growth Rate QoQ"""

            GdpGrowthRateQoQFinal: str = "gdp growth rate qoq final"
            """GDP Growth Rate QoQ Final"""

            GdpGrowthRateQoQFlash: str = "gdp growth rate qoq flash"
            """GDP Growth Rate QoQ Flash"""

            GdpGrowthRateYoY: str = "gdp growth rate yoy"
            """GDP Growth Rate YoY"""

            GdpGrowthRateYoYFinal: str = "gdp growth rate yoy final"
            """GDP Growth Rate YoY Final"""

            GdpGrowthRateYoYFlash: str = "gdp growth rate yoy flash"
            """GDP Growth Rate YoY Flash"""

            GeneralElections: str = "general elections"
            """General Elections"""

            GoodFriday: str = "good friday"
            """Good Friday"""

            HouseholdConsumptionMoM: str = "household consumption mom"
            """Household Consumption MM"""

            HouseholdLendingGrowthYoY: str = "household lending growth yoy"
            """Household Lending Growth YoY"""

            IndustrialInventoriesQoQ: str = "industrial inventories qoq"
            """Industrial Inventories QoQ"""

            IndustrialProductionMoM: str = "industrial production mom"
            """Industrial Production MoM"""

            IndustrialProductionYoY: str = "industrial production yoy"
            """Industrial Production YoY"""

            InflationRateMoM: str = "inflation rate mom"
            """Inflation Rate MoM"""

            InflationRateYoY: str = "inflation rate yoy"
            """Inflation Rate YoY"""

            LaborDay: str = "labor day"
            """Labour Day"""

            LendingToHouseholdsYoY: str = "lending to households yoy"
            """Lending to Households YoY"""

            MarkitServicesPurchasingManagersIndex: str = "markit services purchasing managers index"
            """Markit Services PMI"""

            MidsummerDay: str = "midsummer day"
            """Midsummer Day"""

            MidsummerEve: str = "midsummer eve"
            """Midsummer Eve"""

            MonetaryPolicyMeetingMinutes: str = "monetary policy meeting minutes"
            """Monetary Policy Meeting Minutes"""

            MonetaryPolicyReport: str = "monetary policy report"
            """Monetary Policy Report"""

            NationalDay: str = "national day"
            """National Day"""

            NewOrders: str = "new orders"
            """New Orders"""

            NewOrdersYoY: str = "new orders yoy"
            """New Orders Manufacturing YoY"""

            NewYearsDay: str = "new years day"
            """New Year's Day"""

            NewYearsEve: str = "new years eve"
            """New Year's Eve"""

            Pentecost: str = "pentecost"
            """Pentecost"""

            ProducerPriceIndexMoM: str = "producer price index mom"
            """PPI MoM"""

            ProducerPriceIndexYoY: str = "producer price index yoy"
            """PPI YoY"""

            PurchasingManagersIndexServices: str = "purchasing managers index services"
            """PMI Services"""

            RetailSalesMoM: str = "retail sales mom"
            """Retail Sales MoM"""

            RetailSalesYoY: str = "retail sales yoy"
            """Retail Sales YoY"""

            RiksbankGovIngvesSpeech: str = "riksbank gov ingves speech"
            """Riksbank Gov Ingves Speech"""

            RiksbankIngvesSpeaksBeforeParliament: str = "riksbank ingves speaks before parliament"
            """Riksbank Ingves Speaks before Parliament"""

            RiksbankIngvesSpeech: str = "riksbank ingves speech"
            """Riksbank Ingves Speech"""

            RiksbankInterestRate: str = "riksbank interest rate"
            """Riksbank Interest Rate"""

            RiksbankMeetingMinutes: str = "riksbank meeting minutes"
            """Riksbank Meeting Minutes"""

            RiksbankMonetaryPolicyReport: str = "riksbank monetary policy report"
            """Riksbank Monetary Policy Report"""

            RiksbankRateDecision: str = "riksbank rate decision"
            """Riksbank Rate Decision"""

            RiksbankSkingsleySpeech: str = "riksbank skingsley speech"
            """Riksbank Skingsley Speech"""

            ServicesPurchasingManagersIndex: str = "services purchasing managers index"
            """Services PMI"""

            SwedbankManufacturingPurchasingManagersIndex: str = "swedbank manufacturing purchasing managers index"
            """Swedbank Manufacturing PMI"""

            UnemploymentRate: str = "unemployment rate"
            """Unemployment Rate"""

            Whitsun: str = "whitsun"
            """Whitsun"""

        class Switzerland(System.Object):
            """Switzerland"""

            AscensionDay: str = "ascension day"
            """Ascension Day"""

            BalanceOfTrade: str = "balance of trade"
            """Balance of Trade"""

            BusinessConfidence: str = "business confidence"
            """Business Confidence"""

            ChristmasDay: str = "christmas day"
            """Christmas Day"""

            ConsumerConfidence: str = "consumer confidence"
            """Consumer Confidence"""

            CurrentAccount: str = "current account"
            """Current Account"""

            EasterMonday: str = "easter monday"
            """Easter Monday"""

            EconomicSentimentIndex: str = "economic sentiment index"
            """Economic Sentiment Index"""

            EmploymentLevelQoQ: str = "employment level qoq"
            """Employment Level (QoQ)"""

            FederalFastDay: str = "federal fast day"
            """Federal Fast Day"""

            ForeignCurrencyReserves: str = "foreign currency reserves"
            """Foreign Currency Reserves"""

            ForeignExchangeReserves: str = "foreign exchange reserves"
            """Foreign Exchange Reserves"""

            FxReserves: str = "fx reserves"
            """FX Reserves"""

            GdpGrowthRateQoQ: str = "gdp growth rate qoq"
            """GDP Growth Rate QoQ"""

            GdpGrowthRateYoY: str = "gdp growth rate yoy"
            """GDP Growth Rate YoY"""

            GoodFriday: str = "good friday"
            """Good Friday"""

            IndustrialOrdersYoY: str = "industrial orders yoy"
            """Industrial Orders YoY"""

            IndustrialProductionYoY: str = "industrial production yoy"
            """Industrial Production YoY"""

            InflationRateMoM: str = "inflation rate mom"
            """Inflation Rate MoM"""

            InflationRateYoY: str = "inflation rate yoy"
            """Inflation Rate YoY"""

            KofLeadingIndicators: str = "kof leading indicators"
            """KOF Leading Indicator"""

            LaborDay: str = "labor day"
            """Labour Day"""

            NationalDay: str = "national day"
            """National Day"""

            NewYearsDay: str = "new years day"
            """New Year's Day"""

            NonFarmPayrolls: str = "non farm payrolls"
            """Non Farm Payrolls"""

            NuclearWithdrawalInitiativeReferendum: str = "nuclear withdrawal initiative referendum"
            """Nuclear Withdrawal Initiative Referendum"""

            ParliamentaryElections: str = "parliamentary elections"
            """Parliamentary Elections"""

            ProcurechManufacturingPurchasingManagersIndex: str = "procurech manufacturing purchasing managers index"
            """procure.ch Manufacturing PMI"""

            ProducerAndImportPricesMoM: str = "producer and import prices mom"
            """Producer and Import Prices MoM"""

            ProducerAndImportPricesYoY: str = "producer and import prices yoy"
            """Producer and Import Prices YoY"""

            ProducerImportPricesMoM: str = "producer import prices mom"
            """Producer/Import Prices MoM"""

            ProducerImportPricesYoY: str = "producer import prices yoy"
            """Producer/Import Prices YoY"""

            ProducerPriceIndexMoM: str = "producer price index mom"
            """PPI MoM"""

            ProducerPriceIndexYoY: str = "producer price index yoy"
            """PPI YoY"""

            ReferendumOnCorporateTaxUnification: str = "referendum on corporate tax unification"
            """Referendum on Corporate Tax Unification"""

            RetailSalesMoM: str = "retail sales mom"
            """Retail Sales MoM"""

            RetailSalesYoY: str = "retail sales yoy"
            """Retail Sales YoY"""

            SecoEconomicForecasts: str = "seco economic forecasts"
            """SECO Economic Forecasts"""

            SnbAnnualReport: str = "snb annual report"
            """SNB Annual Report"""

            SnbChairJordanSpeaks: str = "snb chair jordan speaks"
            """SNB Chair Jordan Speaks"""

            SnbChairJordanSpeech: str = "snb chair jordan speech"
            """SNB Chair Jordan Speech"""

            SnbChairmanJordanSpeech: str = "snb chairman jordan speech"
            """SNB Chairman Jordan Speech"""

            SnbFinancialStabilityReport: str = "snb financial stability report"
            """SNB Financial Stability Report"""

            SnbInterestRateDecison: str = "snb interest rate decison"
            """SNB Interest Rate Decison"""

            SnbJordanSpeech: str = "snb jordan speech"
            """SNB Jordan Speech"""

            SnbMaechlerSpeech: str = "snb maechler speech"
            """SNB Maechler Speech"""

            SnbMonthlyBulletin: str = "snb monthly bulletin"
            """SNB Monthly Bulletin"""

            SnbMoserSpeech: str = "snb moser speech"
            """SNB Moser Speech"""

            SnbPresidentStuderSpeech: str = "snb president studer speech"
            """SNB President Studer Speech"""

            SnbPressConference: str = "snb press conference"
            """SNB press conference"""

            SnbQuarterlyBulletin: str = "snb quarterly bulletin"
            """SNB Quarterly Bulletin"""

            SnbStuderSpeech: str = "snb studer speech"
            """SNB Studer Speech"""

            SnbZurbrggSpeech: str = "snb zurbrgg speech"
            """SNB Zurbrügg Speech"""

            SnbZurbrueggSpeech: str = "snb zurbruegg speech"
            """SNB Zurbruegg Speech"""

            StBerchtold: str = "st berchtold"
            """St. Berchtold"""

            StStephensDay: str = "st stephens day"
            """St Stephen's Day"""

            SvmeManufacturingPurchasingManagersIndex: str = "svme manufacturing purchasing managers index"
            """SVME - Purchasing Managers Index"""

            SvmePurchasingManagersIndex: str = "svme manufacturing purchasing managers index"
            """SVME - Purchasing Managers  Index"""

            UbsConsumptionIndicators: str = "ubs consumption indicators"
            """UBS Consumption Indicator"""

            UnemploymentRate: str = "unemployment rate"
            """Unemployment Rate"""

            UsdConsumptionIndicators: str = "usd consumption indicators"
            """USD Consumption Indicator"""

            UsPresidentTrumpSpeech: str = "us president trump speech"
            """US President Trump Speech"""

            WhitMonday: str = "whit monday"
            """Whit Monday"""

            WorldEconomicForumAnnualMeeting: str = "world economic forum annual meeting"
            """World Economic Forum Annual Meeting"""

            WorldEconomicForumDavos: str = "world economic forum davos"
            """World Economic Forum - Davos"""

            ZewEconomicSentimentIndex: str = "zew economic sentiment index"
            """ZEW Economic Sentiment Index"""

            ZewExpectations: str = "zew expectations"
            """ZEW Expectations"""

            ZewInvestorSentiment: str = "zew investor sentiment"
            """ZEW investor sentiment"""

            ZewSurveyExpectations: str = "zew survey expectations"
            """ZEW Survey - Expectations"""

        class UnitedKingdom(System.Object):
            """United Kingdom"""

            ArticleFiftyBrexitProcessStarts: str = "article 50 brexit process starts"
            """Article 50 Brexit Process Starts"""

            AutumnBudget: str = "autumn budget"
            """Autumn Budget"""

            AutumnBudgetTwoThousandEighteen: str = "autumn budget 2018"
            """Autumn Budget 2018"""

            AverageEarningsExcludingBonus: str = "average earnings excluding bonus"
            """Average Earnings excl. Bonus"""

            AverageEarningsIncludingBonus: str = "average earnings including bonus"
            """Average Earnings incl. Bonus"""

            BalanceOfTrade: str = "balance of trade"
            """Balance of Trade"""

            BankHoliday: str = "bank holiday"
            """Bank Holiday"""

            BankOfEnglandAssetPurchaseFacility: str = "bank of england asset purchase facility"
            """BoE Asset Purchase Facility"""

            BankOfEnglandBaileySpeech: str = "bank of england bailey speech"
            """BoE Bailey Speech"""

            BankOfEnglandBrazierSpeech: str = "bank of england brazier speech"
            """BoE Brazier Speech"""

            BankOfEnglandBreedenSpeech: str = "bank of england breeden speech"
            """BoE Breeden Speech"""

            BankOfEnglandBroadbentSpeech: str = "bank of england broadbent speech"
            """BoE Broadbent Speech"""

            BankOfEnglandCarneySpeaks: str = "bank of england carney speaks"
            """BoE Carney Speaks"""

            BankOfEnglandCarneySpeaksInParliamentOnBrexit: str = "bank of england carney speaks in parliament on brexit"
            """BoE Carney Speaks in Parliament on Brexit"""

            BankOfEnglandCarneySpeech: str = "bank of england carney speech"
            """BoE Carney Speech"""

            BankOfEnglandChiefEconomistHaldaneSpeech: str = "bank of england chief economist haldane speech"
            """BoE Chief Economist Haldane Speech"""

            BankOfEnglandChurmSpeech: str = "bank of england churm speech"
            """BoE Churm Speech"""

            BankOfEnglandClelandSpeech: str = "bank of england cleland speech"
            """BoE Cleland Speech"""

            BankOfEnglandConsumerCredit: str = "bank of england consumer credit"
            """BoE Consumer Credit"""

            BankOfEnglandCreditConditionsSurvey: str = "bank of england credit conditions survey"
            """BOE Credit Conditions Survey"""

            BankOfEnglandCunliffeSpeech: str = "bank of england cunliffe speech"
            """BoE Cunliffe Speech"""

            BankOfEnglandDeputyGovBaileySpeech: str = "bank of england deputy gov bailey speech"
            """BoE Deputy Gov Bailey Speech"""

            BankOfEnglandDeputyGovBroadbentSpeech: str = "bank of england deputy gov broadbent speech"
            """BoE Deputy Gov Broadbent Speech"""

            BankOfEnglandDeputyGovCunliffeSpeech: str = "bank of england deputy gov cunliffe speech"
            """BoE Deputy Gov Cunliffe Speech"""

            BankOfEnglandDeputyGovWoodsSpeech: str = "bank of england deputy gov woods speech"
            """BoE Deputy Gov Woods Speech"""

            BankOfEnglandFinancialStabilityReport: str = "bank of england financial stability report"
            """BoE Financial Stability Report"""

            BankOfEnglandForbesSpeech: str = "bank of england forbes speech"
            """BoE Forbes Speech"""

            BankOfEnglandFpcMeeting: str = "bank of england fpc meeting"
            """BoE FPC Meeting"""

            BankOfEnglandFpcMinutes: str = "bank of england fpc minutes"
            """BoE FPC Minutes"""

            BankOfEnglandFpcRecord: str = "bank of england fpc record"
            """BoE FPC Record"""

            BankOfEnglandFpcStatement: str = "bank of england fpc statement"
            """BoE FPC Statement"""

            BankOfEnglandGovCarneySpeech: str = "bank of england gov carney speech"
            """BoE Gov Carney Speech"""

            BankOfEnglandGovernorKingSpeech: str = "bank of england governor king speech"
            """BoE Governor King Speech"""

            BankOfEnglandHaldaneSpeech: str = "bank of england haldane speech"
            """BoE Haldane Speech"""

            BankOfEnglandHaskelSpeech: str = "bank of england haskel speech"
            """BoE Haskel Speech"""

            BankOfEnglandHauserSpeech: str = "bank of england hauser speech"
            """BoE Hauser Speech"""

            BankOfEnglandHoggSpeech: str = "bank of england hogg speech"
            """BoE Hogg Speech"""

            BankOfEnglandInflationReport: str = "bank of england inflation report"
            """BoE Inflation Report"""

            BankOfEnglandInflationReportHearings: str = "bank of england inflation report hearings"
            """BoE Inflation Report Hearings"""

            BankOfEnglandInterestRateDecision: str = "bank of england interest rate decision"
            """BoE Interest Rate Decision"""

            BankOfEnglandKohnSpeech: str = "bank of england kohn speech"
            """BoE Kohn Speech"""

            BankOfEnglandMccaffertySpeech: str = "bank of england mccafferty speech"
            """BoE McCafferty Speech"""

            BankOfEnglandMoulderSpeech: str = "bank of england moulder speech"
            """BoE Moulder Speech"""

            BankOfEnglandMpcVoteCut: str = "bank of england mpc vote cut"
            """BoE MPC Vote Cut"""

            BankOfEnglandMpcVoteHike: str = "bank of england mpc vote hike"
            """BoE MPC Vote Hike"""

            BankOfEnglandMpcVoteUnchanged: str = "bank of england mpc vote unchanged"
            """BoE MPC Vote Unchanged"""

            BankOfEnglandPressConference: str = "bank of england press conference"
            """BoE Press Conference"""

            BankOfEnglandProudmanSpeech: str = "bank of england proudman speech"
            """BoE Proudman Speech"""

            BankOfEnglandQuantitativeEasing: str = "bank of england quantitative easing"
            """BOE Quantitative Easing"""

            BankOfEnglandQuarterlyBulletin: str = "bank of england quarterly bulletin"
            """BoE Quarterly Bulletin"""

            BankOfEnglandQuarterlyBulletinQTwo: str = "bank of england quarterly bulletin q2"
            """BoE Quarterly Bulletin Q2"""

            BankOfEnglandQuarterlyInflationReport: str = "bank of england quarterly inflation report"
            """Bank of England Quarterly Inflation Report"""

            BankOfEnglandRamsdenSpeech: str = "bank of england ramsden speech"
            """BoE Ramsden Speech"""

            BankOfEnglandReportOnEuWithdrawalScenarios: str = "bank of england report on eu withdrawal scenarios"
            """BoE Report on EU Withdrawal Scenarios"""

            BankOfEnglandRuleSpeech: str = "bank of england rule speech"
            """BoE Rule Speech"""

            BankOfEnglandSalmonSpeech: str = "bank of england salmon speech"
            """BoE Salmon Speech"""

            BankOfEnglandSaportaSpeech: str = "bank of england saporta speech"
            """BoE Saporta Speech"""

            BankOfEnglandSaundersSpeech: str = "bank of england saunders speech"
            """BoE Saunders Speech"""

            BankOfEnglandShafikSpeech: str = "bank of england shafik speech"
            """BoE Shafik Speech"""

            BankOfEnglandSharpSpeech: str = "bank of england sharp speech"
            """BoE Sharp Speech"""

            BankOfEnglandStressTestResults: str = "bank of england stress test results"
            """BoE Stress Test Results"""

            BankOfEnglandSystemicRiskSurveyResults: str = "bank of england systemic risk survey results"
            """BoE Systemic Risk Survey Results"""

            BankOfEnglandTenreyroSpeech: str = "bank of england tenreyro speech"
            """BoE Tenreyro Speech"""

            BankOfEnglandVliegheSpeech: str = "bank of england vlieghe speech"
            """BoE Vlieghe Speech"""

            BankOfEnglandWealeSpeech: str = "bank of england weale speech"
            """BoE Weale Speech"""

            BankOfEnglandWoodsSpeech: str = "bank of england woods speech"
            """BoE Woods Speech"""

            BankStressTests: str = "bank stress tests"
            """Bank Stress Tests"""

            BbaMortgageApprovals: str = "bba mortgage approvals"
            """BBA Mortgage Approvals"""

            BccQuarterlyEconomicSurvey: str = "bcc quarterly economic survey"
            """BCC Quarterly Economic Survey"""

            BennBillDebate: str = "benn bill debate"
            """Benn Bill Debate"""

            BoesCarneyAndCunliffeSpeakInParliament: str = "boes carney and cunliffe speak in parliament"
            """BoE's Carney and Cunliffe Speak in Parliament"""

            BoesGovCarneySpeech: str = "boes gov carney speech"
            """BOE's Gov Carney speech"""

            BoesGovernorCarneySpeaks: str = "boes governor carney speaks"
            """BoE's Governor Carney Speaks"""

            BoesGovernorCarneySpeaksAtParliament: str = "boes governor carney speaks at parliament"
            """BoE's Governor Carney Speaks at Parliament"""

            BoesGovernorCarneySpeech: str = "boes governor carney speech"
            """BOE's Governor Carney Speech"""

            BoesGovernorKingSpeech: str = "boes governor king speech"
            """BoEs Governor King Speech"""

            BoxingDay: str = "boxing day"
            """Boxing Day"""

            BrcRetailSalesYoY: str = "brc retail sales yoy"
            """BRC Retail Sales Monitor - All (YoY)"""

            BrcShopPriceIndexMoM: str = "brc shop price index mom"
            """BRC Shop Price Index (MoM)"""

            BrcShopPriceIndexYoY: str = "brc shop price index yoy"
            """BRC Shop Price Index YoY"""

            BrexitBillDebate: str = "brexit bill debate"
            """Brexit Bill Debate"""

            BudgetReport: str = "budget report"
            """Budget Report"""

            BusinessConfidence: str = "business confidence"
            """Business Confidence"""

            BusinessInvestmentQoQ: str = "business investment qoq"
            """Business Investment QoQ"""

            BusinessInvestmentQoQFinal: str = "business investment qoq final"
            """Business Investment QoQ Final"""

            BusinessInvestmentQoQPreliminary: str = "business investment qoq preliminary"
            """Business Investment QoQ Prel"""

            BusinessInvestmentYoY: str = "business investment yoy"
            """Business Investment YoY"""

            BusinessInvestmentYoYFinal: str = "business investment yoy final"
            """Business Investment YoY Final"""

            BusinessInvestmentYoYPreliminary: str = "business investment yoy preliminary"
            """Business Investment YoY Prel"""

            CabinetMeetingOnBrexitDraftDeal: str = "cabinet meeting on brexit draft deal"
            """Cabinet Meeting on Brexit Draft Deal"""

            CbiBusinessOptimismIndex: str = "cbi business optimism index"
            """CBI Business Optimism Index"""

            CbiDistributiveTrades: str = "cbi distributive trades"
            """CBI Distributive Trades"""

            CbiIndustrialTrendsOrders: str = "cbi industrial trends orders"
            """CBI Industrial Trends Orders"""

            CbLeadingEconomicIndex: str = "cb leading economic index"
            """CB Leading Index"""

            CbLeadingEconomicIndexMoM: str = "cb leading economic index mom"
            """CB Leading Economic Index MoM"""

            ChancellorHammondBudgetStatement: str = "chancellor hammond budget statement"
            """Chancellor Hammond Budget Statement"""

            ChancellorOsborneBudgetStatement: str = "chancellor osborne budget statement"
            """Chancellor Osborne Budget Statement"""

            ChristmasDay: str = "christmas day"
            """Christmas Day"""

            ChristmasDaySubstituteDay: str = "christmas day substitute day"
            """Christmas Day (Substitute Day)"""

            ClaimantCountChange: str = "claimant count change"
            """Claimant Count Change"""

            ClaimantCountRate: str = "claimant count rate"
            """Claimant Count Rate"""

            ConstructionOrdersYoY: str = "construction orders yoy"
            """Construction Orders YoY"""

            ConstructionOutputYoY: str = "construction output yoy"
            """Construction Output YoY"""

            ConstructionPurchasingManagersIndex: str = "construction purchasing managers index"
            """Construction PMI"""

            ConsumerInflationExpectations: str = "consumer inflation expectations"
            """Consumer Inflation Expectations"""

            CoreInflationRateMoM: str = "core inflation rate mom"
            """Core Inflation Rate MoM"""

            CoreInflationRateYoY: str = "core inflation rate yoy"
            """Core Inflation Rate YoY"""

            CoreRetailPriceIndexMoM: str = "core retail price index mom"
            """Core RPI MoM"""

            CoreRetailPriceIndexYoY: str = "core retail price index yoy"
            """Core RPI YoY"""

            CoreRetailSalesYoY: str = "core retail sales yoy"
            """Core Retail Sales YoY"""

            CurrentAccount: str = "current account"
            """Current Account"""

            EarlyMayBankHoliday: str = "early may bank holiday"
            """Early May Bank Holiday"""

            EasterMonday: str = "easter monday"
            """Easter Monday"""

            EmploymentChange: str = "employment change"
            """Employment Change"""

            EuMembershipReferendumFinalResults: str = "eu membership referendum final results"
            """EU Membership Referendum - Final Results"""

            EuropeanUnionMembershipReferendum: str = "european union membership referendum"
            """European Union Membership Referendum"""

            FinanceMinisterOsborneSpeech: str = "finance minister osborne speech"
            """Finance Minister Osborne Speech"""

            FinanceMinOsborneSpeaksOnBrexit: str = "finance min osborne speaks on brexit"
            """Finance Min Osborne Speaks on Brexit"""

            FinancialStabilityReport: str = "financial stability report"
            """Financial Stability Report"""

            FinMinisterHammondSpeech: str = "fin minister hammond speech"
            """Fin Minister Hammond Speech"""

            FinMinisterOsborneSpeaksInParliament: str = "fin minister osborne speaks in parliament"
            """Fin Minister Osborne Speaks in Parliament"""

            FiveYearTreasuryGiltAuction: str = "5 year treasury gilt auction"
            """5-Year Treasury Gilt Auction"""

            GdpGrowthRate: str = "gdp growth rate"
            """GDP Growth Rate"""

            GdpGrowthRateQoQ: str = "gdp growth rate qoq"
            """GDP Growth Rate QoQ"""

            GdpGrowthRateQoQFinal: str = "gdp growth rate qoq final"
            """GDP Growth Rate QoQ Final"""

            GdpGrowthRateQoQPreliminary: str = "gdp growth rate qoq preliminary"
            """GDP Growth Rate QoQ Prel"""

            GdpGrowthRateQoQSecondEstimate: str = "gdp growth rate qoq second estimate"
            """GDP Growth Rate QoQ 2nd Est"""

            GdpGrowthRateYoY: str = "gdp growth rate yoy"
            """GDP Growth Rate YoY"""

            GdpGrowthRateYoYFinal: str = "gdp growth rate yoy final"
            """GDP Growth Rate YoY Final"""

            GdpGrowthRateYoYPreliminary: str = "gdp growth rate yoy preliminary"
            """GDP Growth Rate YoY Prel"""

            GdpGrowthRateYoYSecondEstimate: str = "gdp growth rate yoy second estimate"
            """GDP Growth Rate YoY 2nd Est"""

            GdpGrowthYoY: str = "gdp growth yoy"
            """GDP Growth YoY"""

            GdpMoM: str = "gdp mom"
            """GDP MoM"""

            GdpThreeMonthAvg: str = "gdp 3 month avg"
            """GDP 3-Month Avg"""

            GdpYoY: str = "gdp yoy"
            """GDP YoY"""

            GeneralElection: str = "general election"
            """General Election"""

            GfkConsumerConfidence: str = "gfk consumer confidence"
            """Gfk Consumer Confidence"""

            GoodFriday: str = "good friday"
            """Good Friday"""

            GoodsTradeBalance: str = "goods trade balance"
            """Goods Trade Balance"""

            GovernmentAutumnForecasts: str = "government autumn forecasts"
            """Government Autumn Forecasts"""

            HalifaxHousePriceIndexMoM: str = "halifax house price index mom"
            """Halifax House Price Index MoM"""

            HalifaxHousePriceIndexYoY: str = "halifax house price index yoy"
            """Halifax House Price Index YoY"""

            HammondPresentsAutumnStatement: str = "hammond presents autumn statement"
            """Hammond Presents Autumn Statement"""

            HometrackHousingPricesMoM: str = "hometrack housing prices mom"
            """Hometrack Housing Prices MoM"""

            HometrackHousingPricesSeasonallyAdjusted: str = "hometrack housing prices seasonally adjusted"
            """Hometrack Housing Prices s.a"""

            HousePriceIndexMoM: str = "house price index mom"
            """House Price Index MoM"""

            HousePriceIndexYoY: str = "house price index yoy"
            """House Price Index YoY"""

            IndexOfServicesThreeMThreeM: str = "index of services 3m 3m"
            """Index of Services (3M/3M)"""

            IndustrialProductionMoM: str = "industrial production mom"
            """Industrial Production MoM"""

            IndustrialProductionYoY: str = "industrial production yoy"
            """Industrial Production YoY"""

            InflationRateMoM: str = "inflation rate mom"
            """Inflation Rate MoM"""

            InflationRateYoY: str = "inflation rate yoy"
            """Inflation Rate YoY"""

            InflationReportHearings: str = "inflation report hearings"
            """Inflation Report Hearings"""

            InterestRateDecision: str = "interest rate decision"
            """Interest Rate Decision"""

            LaborCostsIndexQoQ: str = "labor costs index qoq"
            """Labour Costs QoQ"""

            LaborProductivityQoQ: str = "labor productivity qoq"
            """Labour Productivity QoQ"""

            LaborProductivityQoQFinal: str = "labor productivity qoq final"
            """Labour Productivity QoQ Final"""

            LaborProductivityQoQPreliminary: str = "labor productivity qoq preliminary"
            """Labour Productivity QoQ Prel"""

            LocalElections: str = "local elections"
            """Local Elections"""

            LondonAssemblyElection: str = "london assembly election"
            """London Assembly Election"""

            LondonMayoralElection: str = "london mayoral election"
            """London Mayoral Election"""

            ManufacturingProductionMoM: str = "manufacturing production mom"
            """Manufacturing Production MoM"""

            ManufacturingProductionYoY: str = "manufacturing production yoy"
            """Manufacturing Production YoY"""

            MarkCarneyWillBecomeTheNewBankOfEnglandGovernor: str = "mark carney will become the new bank of england governor"
            """Mark Carney will become the new Bank of England Governor"""

            MarkitCipsCompositePurchasingManagersIndexFinal: str = "markit cips composite purchasing managers index final"
            """Markit/CIPS Composite PMI Final"""

            MarkitCipsCompositePurchasingManagersIndexFlash: str = "markit cips composite purchasing managers index flash"
            """Markit/CIPS Composite PMI Flash"""

            MarkitCipsManufacturingPurchasingManagersIndex: str = "markit cips manufacturing purchasing managers index"
            """Markit/CIPS Manufacturing PMI"""

            MarkitCipsManufacturingPurchasingManagersIndexFinal: str = "markit cips manufacturing purchasing managers index final"
            """Markit/CIPS Manufacturing PMI Final"""

            MarkitCipsManufacturingPurchasingManagersIndexFlash: str = "markit cips manufacturing purchasing managers index flash"
            """Markit/CIPS Manufacturing PMI Flash"""

            MarkitCipsUkServicesPurchasingManagersIndex: str = "markit cips uk services purchasing managers index"
            """Markit/CIPS UK Services PMI"""

            MarkitCipsUkServicesPurchasingManagersIndexFinal: str = "markit cips uk services purchasing managers index final"
            """Markit/CIPS UK Services PMI Final"""

            MarkitCipsUkServicesPurchasingManagersIndexFlash: str = "markit cips uk services purchasing managers index flash"
            """Markit/CIPS UK Services PMI Flash"""

            MarkitManufacturingPurchasingManagersIndex: str = "markit manufacturing purchasing managers index"
            """Markit Manufacturing PMI"""

            MarkitServicesPurchasingManagersIndex: str = "markit services purchasing managers index"
            """Markit Services PMI"""

            MayDay: str = "may day"
            """May Day"""

            MayNoConfidenceVoteResult: str = "may no confidence vote result"
            """May No Confidence Vote Result"""

            MFourMoneySupplyMoM: str = "m4 money supply mom"
            """M4 Money Supply (MoM)"""

            MFourMoneySupplyYoY: str = "m4 money supply yoy"
            """M4 Money Supply (YoY)"""

            MonthlyGdp: str = "monthly gdp"
            """Monthly GDP"""

            MonthlyGdpThreeMonthAvg: str = "monthly gdp 3 month avg"
            """Monthly GDP 3-Month Avg"""

            MortgageApprovals: str = "mortgage approvals"
            """Mortgage Approvals"""

            MortgageLending: str = "mortgage lending"
            """Mortgage Lending"""

            MpcMeetingMinutes: str = "mpc meeting minutes"
            """MPC Meeting Minutes"""

            MpcMemberBeanSpeech: str = "mpc member bean speech"
            """MPC Member Bean Speech"""

            MpcMemberPaulFisherSpeech: str = "mpc member paul fisher speech"
            """MPC Member Paul Fisher Speech"""

            MpsVoteOnBennBill: str = "mps vote on benn bill"
            """MPs Vote on Benn Bill"""

            MpsVoteOnBrexitBill: str = "mps vote on brexit bill"
            """MPs Vote on Brexit Bill"""

            MpsVoteOnBrexitTimetable: str = "mps vote on brexit timetable"
            """MPs Vote on Brexit Timetable"""

            MpsVoteOnPmElectionCall: str = "mps vote on pm election call"
            """MPs Vote on PM Election Call"""

            MpsVoteOnWithdrawalAgreementBill: str = "mps vote on withdrawal agreement bill"
            """MPs Vote on Withdrawal Agreement Bill"""

            NationalAssemblyForWalesElections: str = "national assembly for wales elections"
            """National Assembly for Wales Elections"""

            NationwideHousingPricesMoM: str = "nationwide housing prices mom"
            """Nationwide Housing Prices MoM"""

            NationwideHousingPricesYoY: str = "nationwide housing prices yoy"
            """Nationwide Housing Prices YoY"""

            NetLendingToIndividualsMoM: str = "net lending to individuals mom"
            """Net Lending to Individuals MoM"""

            NewCarSalesYoY: str = "new car sales yoy"
            """New Car Sales YoY"""

            NewYearsDay: str = "new years day"
            """New Year's Day"""

            NewYearsDaySubstituteDay: str = "new years day substitute day"
            """New Year’s Day (Substitute Day)"""

            NiesrGdpEstimateThreeMonths: str = "niesr gdp estimate 3m"
            """NIESR GDP Est (3M)"""

            NiesrMonthlyGdpTracker: str = "niesr monthly gdp tracker"
            """NIESR Monthly GDP Tracker"""

            NorthernIrelandAssemblyElection: str = "northern ireland assembly election"
            """Northern Ireland Assembly Election"""

            ObrFiscalForecasts: str = "obr fiscal forecasts"
            """OBR Fiscal Forecasts"""

            ObrFiscalRisksReport: str = "obr fiscal risks report"
            """OBR Fiscal Risks Report"""

            OecdGurriaSpeechOnUkReferendum: str = "oecd gurria speech on uk referendum"
            """OECD Gurria Speech on UK Referendum"""

            ParliamentaryDebateAndVoteOnPartOfBrexitDeal: str = "parliamentary debate and vote on part of brexit deal"
            """Parliamentary Debate & Vote on Part of Brexit Deal"""

            ParliamentaryElections: str = "parliamentary elections"
            """Parliamentary Elections"""

            ParliamentaryVoteOnArtFiftyExtension: str = "parliamentary vote on art 50 extension"
            """Parliamentary Vote on Art 50 Extension"""

            ParliamentaryVoteOnBrexitAmendments: str = "parliamentary vote on brexit amendments"
            """Parliamentary Vote on Brexit Amendments"""

            ParliamentaryVoteOnBrexitDeal: str = "parliamentary vote on brexit deal"
            """Parliamentary Vote on Brexit Deal"""

            ParliamentaryVoteOnNoDealBrexit: str = "parliamentary vote on no deal brexit"
            """Parliamentary Vote on No-Deal Brexit"""

            ParliamentaryVotesOnBrexitAlternatives: str = "parliamentary votes on brexit alternatives"
            """Parliamentary Votes on Brexit Alternatives"""

            ParliamentDebateOnBrexit: str = "parliament debate on brexit"
            """Parliament Debate on Brexit"""

            ParliamentDebateOnBrexitAlternatives: str = "parliament debate on brexit alternatives"
            """Parliament Debate on Brexit Alternatives"""

            PmMayNoConfidenceVote: str = "pm may no confidence vote"
            """PM May No Confidence Vote"""

            PmMaysPlanBStatementOnBrexit: str = "pm mays plan b statement on brexit"
            """PM May's Plan B Statement on Brexit"""

            PmMaysStatementOnBrexit: str = "pm mays statement on brexit"
            """PM May's Statement on Brexit"""

            PmMayStatementOnNewBrexitDeal: str = "pm may statement on new brexit deal"
            """PM May Statement on New Brexit Deal"""

            PrimeMinisterMaySpeech: str = "prime minister may speech"
            """Prime Minister May Speech"""

            PrimeMinisterMaySpeechOnBrexit: str = "prime minister may speech on brexit"
            """Prime Minister May Speech on Brexit"""

            PrimeMinisterTheresaMaySpeech: str = "prime minister theresa may speech"
            """Prime Minister Theresa May Speech"""

            ProducerPriceIndexCoreOutputMoM: str = "producer price index core output mom"
            """PPI Core Output MoM"""

            ProducerPriceIndexCoreOutputYoY: str = "producer price index core output yoy"
            """PPI Core Output YoY"""

            ProducerPriceIndexInputMoM: str = "producer price index input mom"
            """PPI Input MoM"""

            ProducerPriceIndexInputYoY: str = "producer price index input yoy"
            """PPI Input YoY"""

            ProducerPriceIndexOutputMoM: str = "producer price index output mom"
            """PPI Output MoM"""

            ProducerPriceIndexOutputYoY: str = "producer price index output yoy"
            """PPI Output YoY"""

            PublicSectorBorrowingMoM: str = "public sector borrowing mom"
            """Public Sector Borrowing MoM"""

            PublicSectorNetBorrowing: str = "public sector net borrowing"
            """Public Sector Net Borrowing"""

            QueensSpeechAtTheParliament: str = "queens speech at the parliament"
            """Queen's Speech at The Parliament"""

            RetailPriceIndexMoM: str = "retail price index mom"
            """Retail Price Index MoM"""

            RetailPriceIndexYoY: str = "retail price index yoy"
            """Retail Price Index YoY"""

            RetailSalesExcludingFuelMoM: str = "retail sales excluding fuel mom"
            """Retail Sales ex Fuel MoM"""

            RetailSalesExcludingFuelYoY: str = "retail sales excluding fuel yoy"
            """Retail Sales ex Fuel YoY"""

            RetailSalesMoM: str = "retail sales mom"
            """Retail Sales MoM"""

            RetailSalesYoY: str = "retail sales yoy"
            """Retail Sales YoY"""

            RicsHousePriceBalance: str = "rics house price balance"
            """RICS House Price Balance"""

            ScottishIndependenceReferendum: str = "scottish independence referendum"
            """Scottish Independence Referendum"""

            ScottishParliamentElection: str = "scottish parliament election"
            """Scottish Parliament Election"""

            SpringBankHoliday: str = "spring bank holiday"
            """Spring Bank Holiday"""

            SpringBudgetTwoThousandEighteen: str = "spring budget 2018"
            """Spring Budget 2018"""

            SpringBudgetTwoThousandNineteen: str = "spring budget 2019"
            """Spring Budget 2019"""

            SummerBankHoliday: str = "summer bank holiday"
            """Summer Bank Holiday"""

            TenYearTreasuryGiltAuction: str = "10 year treasury gilt auction"
            """10-Year Treasury Gilt Auction"""

            ThirtyYearTreasuryGiltAuction: str = "30 year treasury gilt auction"
            """30-Year Treasury Gilt Auction"""

            TotalBusinessInvestmentQoQ: str = "total business investment qoq"
            """Total Business Investment (QoQ)"""

            TotalBusinessInvestmentYoY: str = "total business investment yoy"
            """Total Business Investment (YoY)"""

            TreasuryCommitteeHearingInflationReport: str = "treasury committee hearing inflation report"
            """Treasury Committee Hearing – Inflation Report"""

            TreasurySelectCommitteeHearing: str = "treasury select committee hearing"
            """Treasury Select Committee Hearing"""

            TwoThousandSixteenAnnualBudgetAnnouncement: str = "2016 annual budget announcement"
            """2016 Annual Budget Announcement"""

            UkFinanceMortgageApprovals: str = "uk finance mortgage approvals"
            """UK Finance Mortgage Approvals"""

            UkGeneralElection: str = "uk general election"
            """UK General Election"""

            UkMayEuJunckerMeeting: str = "uk may eu juncker meeting"
            """UK May - EU Juncker Meeting"""

            UkPmStatementOnBrexit: str = "uk pm statement on brexit"
            """UK PM Statement on Brexit"""

            UkSupremeCourtRulingOnArticleFifty: str = "uk supreme court ruling on article 50"
            """UK Supreme Court Ruling On Article 50"""

            UnemploymentRate: str = "unemployment rate"
            """Unemployment Rate"""

        class UnitedStates(System.Object):
            """United States"""

            AdpEmploymentChange: str = "adp employment change"
            """ADP Employment Change"""

            AllCarSales: str = "all car sales"
            """All Car Sales"""

            AllTruckSales: str = "all truck sales"
            """All Truck Sales"""

            ApiWeeklyCrudeStockChange: str = "api weekly crude stock change"
            """API Weekly Crude Stock Change"""

            ApiWeeklyGasolineStockChange: str = "api weekly gasoline stock change"
            """API Weekly Gasoline Stock Change"""

            AverageHourlyEarningsMoM: str = "average hourly earnings mom"
            """Average Hourly Earnings MoM"""

            AverageHourlyEarningsYoY: str = "average hourly earnings yoy"
            """Average Hourly Earnings YoY"""

            AverageWeeklyHours: str = "average weekly hours"
            """Average Weekly Hours"""

            BakerHughesOilRigCount: str = "baker hughes oil rig count"
            """Baker Hughes Oil Rig Count"""

            BalanceOfTrade: str = "balance of trade"
            """Balance of Trade"""

            BeigeBook: str = "beige book"
            """Beige Book"""

            BirthdayOfMartinLutherKingJr: str = "birthday of martin luther king jr"
            """Birthday of Martin Luther King, Jr."""

            BuildingPermits: str = "building permits"
            """Building Permits"""

            BuildingPermitsMoM: str = "building permits mom"
            """Building Permits MoM"""

            BusinessInventoriesMoM: str = "business inventories mom"
            """Business Inventories MoM"""

            CapacityUtilization: str = "capacity utilization"
            """Capacity Utilization"""

            CbConsumerConfidence: str = "cb consumer confidence"
            """CB Consumer Confidence"""

            CbEmploymentTrendsIndex: str = "cb employment trends index"
            """CB Employment Trends Index"""

            CbLeadingEconomicIndexMoM: str = "cb leading economic index mom"
            """CB Leading Index MoM"""

            ChainStoresSalesWoW: str = "chain stores sales wow"
            """Chain stores WoW"""

            ChainStoresSalesYoY: str = "chain stores sales yoy"
            """Chain Stores Sales YoY"""

            ChallengerJobCuts: str = "challenger job cuts"
            """Challenger Job Cuts"""

            ChicagoFedNationalActivityIndex: str = "chicago fed national activity index"
            """Chicago Fed National Activity Index"""

            ChicagoPurchasingManagersIndex: str = "chicago purchasing managers index"
            """Chicago PMI"""

            ChristmasDay: str = "christmas day"
            """Christmas Day"""

            ChristmasDaySubstituteDay: str = "christmas day substitute day"
            """Christmas Day (Substitute Day)"""

            ColumbusDay: str = "columbus day"
            """Columbus Day"""

            ConstructionSpendingMoM: str = "construction spending mom"
            """Construction Spending MoM"""

            ConsumerConfidence: str = "consumer confidence"
            """Consumer Confidence"""

            ConsumerCreditChange: str = "consumer credit change"
            """Consumer Credit Change"""

            ConsumerInflationExpectations: str = "consumer inflation expectations"
            """Consumer Inflation Expectations"""

            ConsumerPriceIndex: str = "consumer price index"
            """Consumer Price Index"""

            ConsumerPriceIndexExcludingFoodAndEnergyMoM: str = "consumer price index excluding food and energy mom"
            """Consumer Price Index Ex Food & Energy (MoM)"""

            ConsumerPriceIndexExcludingFoodAndEnergyYoY: str = "consumer price index excluding food and energy yoy"
            """Consumer Price Index Ex Food & Energy (YoY)"""

            ConsumerPriceIndexRealEarningsMoM: str = "consumer price index real earnings mom"
            """CPI Real Earnings MoM"""

            ContinuingJoblessClaims: str = "continuing jobless claims"
            """Continuing Jobless Claims"""

            CoreConsumerPriceIndex: str = "core consumer price index"
            """Core Consumer Price Index"""

            CoreDurableGoodsOrders: str = "core durable goods orders"
            """Core Durable Goods Orders"""

            CoreDurableGoodsOrdersMoM: str = "core durable goods orders mom"
            """Core Durable Goods Orders MoM"""

            CoreInflationRateMoM: str = "core inflation rate mom"
            """Core Inflation Rate MoM"""

            CoreInflationRateYoY: str = "core inflation rate yoy"
            """Core Inflation Rate YoY"""

            CorePersonalConsumptionExpenditurePriceIndexMoM: str = "core personal consumption expenditure price index mom"
            """Core Personal Consumption Expenditure - Price Index (MoM)"""

            CorePersonalConsumptionExpenditurePriceIndexQoQ: str = "core personal consumption expenditure price index qoq"
            """Core Personal Consumption Expenditures QoQ"""

            CorePersonalConsumptionExpenditurePriceIndexQoQAdv: str = "core personal consumption expenditure price index qoq adv"
            """Core PCE Prices QoQ Adv"""

            CorePersonalConsumptionExpenditurePriceIndexQoQFinal: str = "core personal consumption expenditure price index qoq final"
            """Core PCE Prices QoQ Final"""

            CorePersonalConsumptionExpenditurePriceIndexQoQSecondEstimate: str = "core personal consumption expenditure price index qoq second estimate"
            """Core PCE Prices QoQ 2 Est"""

            CorePersonalConsumptionExpenditurePriceIndexYoY: str = "core personal consumption expenditure price index yoy"
            """Core PCE Price Index YoY"""

            CoreProducerPriceIndexMoM: str = "core producer price index mom"
            """Core PPI MoM"""

            CoreProducerPriceIndexYoY: str = "core producer price index yoy"
            """Core PPI YoY"""

            CoreRetailSalesMoM: str = "core retail sales mom"
            """Core Retail Sales MoM"""

            CorporateProfitsQoQ: str = "corporate profits qoq"
            """Corporate Profits QoQ"""

            CorporateProfitsQoQFinal: str = "corporate profits qoq final"
            """Corporate Profits QoQ Final"""

            CorporateProfitsQoQPreliminary: str = "corporate profits qoq preliminary"
            """Corporate Profits QoQ Prel"""

            CurrentAccount: str = "current account"
            """Current Account"""

            DallasFedManufacturingIndex: str = "dallas fed manufacturing index"
            """Dallas Fed Manufacturing Index"""

            DeadlineForFundingForNewFiscalYear: str = "deadline for funding for new fiscal year"
            """Deadline for Funding For New Fiscal Year"""

            DomesticCarSales: str = "domestic car sales"
            """Domestic Car Sales"""

            DomesticTruckSales: str = "domestic truck sales"
            """Domestic Truck Sales"""

            DurableGoodsOrdersExcludingDefenseMoM: str = "durable goods orders excluding defense mom"
            """Durable Goods Orders Ex Defense MoM"""

            DurableGoodsOrdersExcludingTransportationMoM: str = "durable goods orders excluding transportation mom"
            """Durable Goods Orders Ex Transp MoM"""

            DurableGoodsOrdersMoM: str = "durable goods orders mom"
            """Durable Goods Orders MoM"""

            EiaCrudeOilImports: str = "eia crude oil imports"
            """EIA Crude Oil Imports"""

            EiaCrudeOilImportsChange: str = "eia crude oil imports change"
            """EIA Crude Oil Imports Change"""

            EiaCrudeOilStocksChange: str = "eia crude oil stocks change"
            """EIA Crude Oil Stocks Change"""

            EiaCushingCrudeOilStocksChange: str = "eia cushing crude oil stocks change"
            """EIA Cushing Crude Oil Stocks Change"""

            EiaDistillateFuelProductionChange: str = "eia distillate fuel production change"
            """EIA Distillate Fuel Production Change"""

            EiaDistillateStocks: str = "eia distillate stocks"
            """EIA Distillate Stocks"""

            EiaDistillateStocksChange: str = "eia distillate stocks change"
            """EIA Distillate Stocks Change"""

            EiaGasolineProduction: str = "eia gasoline production"
            """EIA Gasoline Production"""

            EiaGasolineProductionChange: str = "eia gasoline production change"
            """EIA Gasoline Production Change"""

            EiaGasolineStocksChange: str = "eia gasoline stocks change"
            """EIA Gasoline Stocks Change"""

            EiaNaturalGasStocksChange: str = "eia natural gas stocks change"
            """EIA Natural Gas Stocks Change"""

            EiaRefineryCrudeRunsChange: str = "eia refinery crude runs change"
            """EIA Refinery Crude Runs Change"""

            EightWeekBillAuction: str = "8 week bill auction"
            """8-Week Bill Auction"""

            EmploymentBenefitsQoQ: str = "employment benefits qoq"
            """Employment Benefits QoQ"""

            EmploymentCostsBenefitsQoQ: str = "employment costs benefits qoq"
            """Employment Cost - Benefits QoQ"""

            EmploymentCostsIndexQoQ: str = "employment costs index qoq"
            """Employment Cost Index QoQ"""

            EmploymentCostsWagesQoQ: str = "employment costs wages qoq"
            """Employment Cost - Wages QoQ"""

            EmploymentWagesQoQ: str = "employment wages qoq"
            """Employment Wages QoQ"""

            ExistingHomeSales: str = "existing home sales"
            """Existing Home Sales"""

            ExistingHomeSalesMoM: str = "existing home sales mom"
            """Existing Home Sales MoM"""

            ExportPricesMoM: str = "export prices mom"
            """Export Prices MoM"""

            ExportPricesYoY: str = "export prices yoy"
            """Export Prices YoY"""

            Exports: str = "exports"
            """Exports"""

            FactoryOrdersExcludingTransportation: str = "factory orders excluding transportation"
            """Factory Orders ex Transportation"""

            FactoryOrdersMoM: str = "factory orders mom"
            """Factory Orders MoM"""

            FedBarkinSpeech: str = "fed barkin speech"
            """Fed Barkin Speech"""

            FedBeigeBook: str = "fed beige book"
            """Fed Beige Book"""

            FedBernankeSpeech: str = "fed bernanke speech"
            """Fed Bernanke Speech"""

            FedBernankeTestifies: str = "fed bernanke testifies"
            """Fed Bernanke testifies"""

            FedBosticSpeech: str = "fed bostic speech"
            """Fed Bostic Speech"""

            FedBowmanSpeech: str = "fed bowman speech"
            """Fed Bowman Speech"""

            FedBowmanTestimony: str = "fed bowman testimony"
            """Fed Bowman Testimony"""

            FedBrainardSpeaks: str = "fed brainard speaks"
            """Fed Brainard Speaks"""

            FedBrainardSpeech: str = "fed brainard speech"
            """Fed Brainard Speech"""

            FedBrainardTestimony: str = "fed brainard testimony"
            """Fed Brainard Testimony"""

            FedBullardSpeaks: str = "fed bullard speaks"
            """Fed Bullard Speaks"""

            FedBullardSpeech: str = "fed bullard speech"
            """Fed Bullard Speech"""

            FedCcarForBigBanks: str = "fed ccar for big banks"
            """Fed CCAR For Big Banks"""

            FedCcarResultsForBigBanks: str = "fed ccar results for big banks"
            """Fed CCAR Results For Big Banks"""

            FedChairmanBernankeSpeaks: str = "fed chairman bernanke speaks"
            """Fed Chairman Bernanke Speaks"""

            FedChairmanBernankeSpeech: str = "fed chairman bernanke speech"
            """Fed Chairman Bernanke Speech"""

            FedChairmanBernankeTestifies: str = "fed chairman bernanke testifies"
            """Fed Chairman Bernanke Testifies"""

            FedChairmanNominationVote: str = "fed chairman nomination vote"
            """Fed Chairman Nomination Vote"""

            FedChairmanYellenSpeaks: str = "fed chairman yellen speaks"
            """Fed Chairman Yellen Speaks"""

            FedChairPowellSpeech: str = "fed chair powell speech"
            """Fed Chair Powell Speech"""

            FedChairPowellTestimony: str = "fed chair powell testimony"
            """Fed Chair Powell Testimony"""

            FedChairYellenSpeaks: str = "fed chair yellen speaks"
            """Fed Chair Yellen Speaks"""

            FedClaridaSpeech: str = "fed clarida speech"
            """Fed Clarida Speech"""

            FedDalySpeech: str = "fed daly speech"
            """Fed Daly Speech"""

            FedDudleySpeech: str = "fed dudley speech"
            """Fed Dudley Speech"""

            FedDukeSpeech: str = "fed duke speech"
            """Fed Duke Speech"""

            FederalBudgetBalance: str = "federal budget balance"
            """Federal Budget Balance"""

            FedEvansSpeaks: str = "fed evans speaks"
            """Fed Evans Speaks"""

            FedEvansSpeech: str = "fed evans speech"
            """Fed Evans Speech"""

            FedFischerSpeech: str = "fed fischer speech"
            """Fed Fischer Speech"""

            FedGeorgeSpeech: str = "fed george speech"
            """Fed George Speech"""

            FedGeorgeTestimony: str = "fed george testimony"
            """Fed George Testimony"""

            FedHarkerMesterAndLockhartSpeech: str = "fed harker mester and lockhart speech"
            """Fed Harker, Mester & Lockhart Speech"""

            FedHarkerSpeech: str = "fed harker speech"
            """Fed Harker Speech"""

            FedInterestRateDecision: str = "fed interest rate decision"
            """Fed Interest Rate Decision"""

            FedKaplanSpeech: str = "fed kaplan speech"
            """Fed Kaplan Speech"""

            FedKashkariSpeech: str = "fed kashkari speech"
            """Fed Kashkari Speech"""

            FedKocherlakotaSpeech: str = "fed kocherlakota speech"
            """Fed Kocherlakota Speech"""

            FedLaborMarketConditionsIndexMoM: str = "fed labor market conditions index mom"
            """Fed Labor Market Conditions Index (MoM)"""

            FedLackerSpeech: str = "fed lacker speech"
            """Fed Lacker Speech"""

            FedLockhartSpeech: str = "fed lockhart speech"
            """Fed Lockhart speech"""

            FedMeetingUnderExpeditedProcedures: str = "fed meeting under expedited procedures"
            """Fed Meeting under Expedited Procedures"""

            FedMesterSpeech: str = "fed mester speech"
            """Fed Mester Speech"""

            FedMonetaryPolicyStatementAndPressConference: str = "fed monetary policy statement and press conference"
            """Fed Monetary Policy Statement and press conference"""

            FedOpenBoardMeeting: str = "fed open board meeting"
            """Fed Open Board Meeting"""

            FedPaceOfMortgageBackedSecuritiesPurchaseProgram: str = "fed pace of mortgage backed securities purchase program"
            """Fed Pace of MBS Purchase Program"""

            FedPaceOfTreasuryPurchaseProgram: str = "fed pace of treasury purchase program"
            """Fed Pace of Treasury Purchase Program"""

            FedPowellSpeech: str = "fed powell speech"
            """Fed Powell Speech"""

            FedPressConference: str = "fed press conference"
            """Fed press conference"""

            FedQuarlesSpeech: str = "fed quarles speech"
            """Fed Quarles Speech"""

            FedQuarlesTestimony: str = "fed quarles testimony"
            """Fed Quarles Testimony"""

            FedRichardFisherSpeech: str = "fed richard fisher speech"
            """Fed Richard Fisher speech"""

            FedRosengrenSpeech: str = "fed rosengren speech"
            """Fed Rosengren Speech"""

            FedsBeigeBook: str = "feds beige book"
            """FED´s Beige Book"""

            FedStressTestResultsForBigBanks: str = "fed stress test results for big banks"
            """Fed Stress Test Results For Big Banks"""

            FedTarulloSpeech: str = "fed tarullo speech"
            """Fed Tarullo Speech"""

            FedTarulloTestifies: str = "fed tarullo testifies"
            """Fed Tarullo Testifies"""

            FedWilliamsSpeech: str = "fed williams speech"
            """Fed Williams Speech"""

            FedYellenAndImfsLagardeSpeech: str = "fed yellen and imfs lagarde speech"
            """Fed Yellen & IMF's Lagarde Speech"""

            FedYellenSpeaks: str = "fed yellen speaks"
            """Fed Yellen Speaks"""

            FedYellenSpeaksAtJacksonHole: str = "fed yellen speaks at jackson hole"
            """Fed Yellen Speaks At Jackson Hole"""

            FedYellenSpeech: str = "fed yellen speech"
            """Fed Yellen Speech"""

            FedYellenTestifies: str = "fed yellen testifies"
            """Fed Yellen testifies"""

            FedYellenTestimony: str = "fed yellen testimony"
            """Fed Yellen Testimony"""

            FedYellenTestimonyBeforeCongress: str = "fed yellen testimony before congress"
            """Fed Yellen Testimony Before Congress"""

            FedYellenTestimonyHfsc: str = "fed yellen testimony hfsc"
            """Fed Yellen Testimony HFSC"""

            FedYellenTestimonySbc: str = "fed yellen testimony sbc"
            """Fed Yellen Testimony SBC"""

            FedYellenTestimonyToTheCongress: str = "fed yellen testimony to the congress"
            """Fed Yellen Testimony to the Congress"""

            FedYellenTestimonyToTheSenate: str = "fed yellen testimony to the senate"
            """Fed Yellen Testimony to the Senate"""

            FedYellenTestymonyHouse: str = "fed yellen testymony house"
            """Fed Yellen Testymony - House"""

            FedYellenTestymonySenate: str = "fed yellen testymony senate"
            """Fed Yellen Testymony - Senate"""

            FiftyTwoWeekBillAuction: str = "52 week bill auction"
            """52-Week Bill Auction"""

            FinancialAccountsOfTheUs: str = "financial accounts of the us"
            """Financial Accounts of the US"""

            FiveYearNoteAuction: str = "5 year note auction"
            """5-Year Note Auction"""

            FiveYearTipsAuction: str = "5 year tips auction"
            """5-Year TIPS Auction"""

            FomcEconomicProjections: str = "fomc economic projections"
            """FOMC Economic Projections"""

            FomcMemberYellenSpeech: str = "fomc member yellen speech"
            """FOMC Member Yellen Speech"""

            FomcMinutes: str = "fomc minutes"
            """FOMC Minutes"""

            FomcPolicyStatementAndPressConference: str = "fomc policy statement and press conference"
            """FOMC Policy Statement and press conference"""

            FomcPressConference: str = "fomc press conference"
            """FOMC Press Conference"""

            ForeignBondInvestment: str = "foreign bond investment"
            """Foreign Bond Investment"""

            FourWeekBillAuction: str = "4 week bill auction"
            """4-Week Bill Auction"""

            GasolineInventories: str = "gasoline inventories"
            """Gasoline Inventories"""

            GdpConsumerSpendingQoQAdv: str = "gdp consumer spending qoq adv"
            """GDP Consumer Spending QoQ Adv"""

            GdpConsumerSpendingQoQFinal: str = "gdp consumer spending qoq final"
            """GDP Consumer Spending QoQ Final"""

            GdpConsumerSpendingYoY: str = "gdp consumer spending yoy"
            """GDP Consumer Spending YoY"""

            GdpDeflatorQoQ: str = "gdp deflator qoq"
            """GDP Deflator QoQ"""

            GdpGrowthRate: str = "gdp growth rate"
            """GDP Growth Rate"""

            GdpGrowthRateQoQAdv: str = "gdp growth rate qoq adv"
            """GDP Growth Rate QoQ Adv"""

            GdpGrowthRateQoQFinal: str = "gdp growth rate qoq final"
            """GDP Growth Rate QoQ Final"""

            GdpGrowthRateQoQSecondEstimate: str = "gdp growth rate qoq second estimate"
            """GDP Growth Rate QoQ 2nd Est"""

            GdpGrowthRateSecondEstimate: str = "gdp growth rate second estimate"
            """GDP Growth Rate 2nd Est"""

            GdpGrowthRateYoYAdv: str = "gdp growth rate yoy adv"
            """GDP Growth Rate YoY Adv"""

            GdpGrowthRateYoYSecondEstimate: str = "gdp growth rate yoy second estimate"
            """GDP Growth Rate YoY Second Est"""

            GdpGrowthRateYoYThirdEstimate: str = "gdp growth rate yoy third estimate"
            """GDP Growth Rate YoY Third Estimate"""

            GdpPriceIndex: str = "gdp price index"
            """GDP Price Index"""

            GdpPriceIndexQoQ: str = "gdp price index qoq"
            """GDP Price Index QoQ"""

            GdpPriceIndexQoQAdv: str = "gdp price index qoq adv"
            """GDP Price Index QoQ Adv"""

            GdpPriceIndexQoQFinal: str = "gdp price index qoq final"
            """GDP Price Index QoQ Final"""

            GdpPriceIndexQoQSecondEstimate: str = "gdp price index qoq second estimate"
            """GDP Price Index QoQ 2nd Est"""

            GoodFriday: str = "good friday"
            """Good Friday"""

            GoodsTradeBalance: str = "goods trade balance"
            """Goods Trade Balance"""

            GoodsTradeBalanceAdv: str = "goods trade balance adv"
            """Goods Trade Balance Adv"""

            GovernmentPayrolls: str = "government payrolls"
            """Government Payrolls"""

            GrossDomesticProductPriceIndex: str = "gross domestic product price index"
            """Gross Domestic Product Price Index"""

            GThirtyInternationalBankingSeminar: str = "g30 international banking seminar"
            """G30 International Banking Seminar"""

            GTwentyFinanceMinistersAndCbGovernorsMeeting: str = "g20 finance ministers and cb governors meeting"
            """G20 Finance Ministers and CB Governors Meeting"""

            GTwentyFinMinistersAndCbGovernorsMeeting: str = "g20 fin ministers and cb governors meeting"
            """G20 Fin Ministers and CB Governors Meeting"""

            GTwentyMeeting: str = "g20 meeting"
            """G20 Meeting"""

            HousePriceIndexMoM: str = "house price index mom"
            """House Price Index MoM"""

            HousePriceIndexYoY: str = "house price index yoy"
            """House Price Index YoY"""

            HousingStarts: str = "housing starts"
            """Housing Starts"""

            HousingStartsMoM: str = "housing starts mom"
            """Housing Starts MoM"""

            HsbcServicesPurchasingManagersIndex: str = "hsbc services purchasing managers index"
            """HSBC Services PMI"""

            IbdTippEconomicOptimism: str = "ibd tipp economic optimism"
            """IBD/TIPP Economic Optimism"""

            IeaOilMarketReport: str = "iea oil market report"
            """IEA Oil Market Report"""

            ImfMeeting: str = "imf meeting"
            """IMF Meeting"""

            ImfSpringMeeting: str = "imf spring meeting"
            """IMF Spring Meeting"""

            ImfWorldBankAnnualMeetings: str = "imf world bank annual meetings"
            """IMF/World Bank Annual Meetings"""

            ImportPricesMoM: str = "import prices mom"
            """Import Prices MoM"""

            ImportPricesYoY: str = "import prices yoy"
            """Import Prices YoY"""

            Imports: str = "imports"
            """Imports"""

            IndependenceDay: str = "independence day"
            """Independence Day"""

            IndependenceDayObserved: str = "independence day observed"
            """Independence Day Observed"""

            IndustrialProductionMoM: str = "industrial production mom"
            """Industrial Production MoM"""

            IndustrialProductionYoY: str = "industrial production yoy"
            """Industrial Production YoY"""

            InflationRateMoM: str = "inflation rate mom"
            """Inflation Rate MoM"""

            InflationRateYoY: str = "inflation rate yoy"
            """Inflation Rate YoY"""

            InitialJoblessClaims: str = "initial jobless claims"
            """Initial Jobless Claims"""

            IsmManufacturingEmployment: str = "ism manufacturing employment"
            """ISM Manufacturing Employment"""

            IsmManufacturingNewOrders: str = "ism manufacturing new orders"
            """ISM Manufacturing New Orders"""

            IsmManufacturingPrices: str = "ism manufacturing prices"
            """ISM Manufacturing Prices"""

            IsmManufacturingPricesPaid: str = "ism manufacturing prices paid"
            """ISM Manufacturing Prices Paid"""

            IsmManufacturingPurchasingManagersIndex: str = "ism manufacturing purchasing managers index"
            """ISM Manufacturing PMI"""

            IsmNewYorkIndex: str = "ism new york index"
            """ISM New York index"""

            IsmNonManufacturingBusinessActivity: str = "ism non manufacturing business activity"
            """ISM Non-Manufacturing Business Activity"""

            IsmNonManufacturingEmployment: str = "ism non manufacturing employment"
            """ISM Non-Manufacturing Employment"""

            IsmNonManufacturingNewOrders: str = "ism non manufacturing new orders"
            """ISM Non-Manufacturing New Orders"""

            IsmNonManufacturingPrices: str = "ism non manufacturing prices"
            """ISM Non-Manufacturing Prices"""

            IsmNonManufacturingPurchasingManagersIndex: str = "ism non manufacturing purchasing managers index"
            """ISM Non-Manufacturing PMI"""

            IsmPricesPaid: str = "ism prices paid"
            """ISM Prices Paid"""

            JacksonHoleEconomicPolicySymposium: str = "jackson hole economic policy symposium"
            """Jackson Hole Economic Policy Symposium"""

            JacksonHoleSymposium: str = "jackson hole symposium"
            """Jackson Hole Symposium"""

            JoltsJobOpenings: str = "jolts job openings"
            """JOLTs Job Openings"""

            KansasFedManufacturingIndex: str = "kansas fed manufacturing index"
            """Kansas Fed Manufacturing Index"""

            LaborCostsIndexQoQ: str = "labor costs index qoq"
            """Labor Costs QoQ"""

            LaborDay: str = "labor day"
            """Labor Day"""

            LoanOfficerSurvey: str = "loan officer survey"
            """Loan Officer Survey"""

            ManufacturingPayrolls: str = "manufacturing payrolls"
            """Manufacturing Payrolls"""

            ManufacturingProductionMoM: str = "manufacturing production mom"
            """Manufacturing Production MoM"""

            ManufacturingProductionYoY: str = "manufacturing production yoy"
            """Manufacturing Production YoY"""

            MarkitCompositePurchasingManagersIndexFinal: str = "markit composite purchasing managers index final"
            """Markit Composite PMI Final"""

            MarkitCompositePurchasingManagersIndexFlash: str = "markit composite purchasing managers index flash"
            """Markit Composite PMI Flash"""

            MarkitManufacturingPurchasingManagersIndex: str = "markit manufacturing purchasing managers index"
            """Markit Manufacturing PMI"""

            MarkitManufacturingPurchasingManagersIndexFinal: str = "markit manufacturing purchasing managers index final"
            """Markit Manufacturing PMI Final"""

            MarkitManufacturingPurchasingManagersIndexFlash: str = "markit manufacturing purchasing managers index flash"
            """Markit Manufacturing PMI Flash"""

            MarkitServicesPurchasingManagersIndexFinal: str = "markit services purchasing managers index final"
            """Markit Services PMI Final"""

            MarkitServicesPurchasingManagersIndexFlash: str = "markit services purchasing managers index flash"
            """Markit Services PMI Flash"""

            MarkitServicesPurchasingManagersIndexPreliminary: str = "markit services purchasing managers index preliminary"
            """Markit Services PMI Prel"""

            MartinLKingDay: str = "martin l king day"
            """Martin L. King Day"""

            MartinLKingsBirthday: str = "martin l kings birthday"
            """Martin L. King's Birthday"""

            MartinLutherKingJrDay: str = "martin luther king jr day"
            """Martin Luther King, Jr. Day"""

            MassLayoffs: str = "mass layoffs"
            """Mass Layoffs"""

            MbaMortgageApplications: str = "mba mortgage applications"
            """MBA Mortgage Applications"""

            MbaMortgageApplicationsWoW: str = "mba mortgage applications wow"
            """MBA Mortgage Applications WoW"""

            MbaThirtyYearMortgageRate: str = "mba 30 year mortgage rate"
            """MBA 30-Year Mortgage Rate"""

            MemorialDay: str = "memorial day"
            """Memorial Day"""

            MemorialDayHoliday: str = "memorial day holiday"
            """Memorial Day Holiday"""

            MichiganConsumerExpectationsFinal: str = "michigan consumer expectations final"
            """Michigan Consumer Expectations Final"""

            MichiganConsumerExpectationsPreliminary: str = "michigan consumer expectations preliminary"
            """Michigan Consumer Expectations Prel"""

            MichiganConsumerSentimentFinal: str = "michigan consumer sentiment final"
            """Michigan Consumer Sentiment Final"""

            MichiganConsumerSentimentPreliminary: str = "michigan consumer sentiment preliminary"
            """Michigan Consumer Sentiment Prel"""

            MichiganCurrentConditionsFinal: str = "michigan current conditions final"
            """Michigan Current Conditions Final"""

            MichiganCurrentConditionsPreliminary: str = "michigan current conditions preliminary"
            """Michigan Current Conditions Prel"""

            MichiganFiveYearInflationExpectationsFinal: str = "michigan 5 year inflation expectations final"
            """Michigan 5 Year Inflation Expectations Final"""

            MichiganFiveYearInflationExpectationsPreliminary: str = "michigan 5 year inflation expectations preliminary"
            """Michigan 5 Year Inflation Expectations Prel"""

            MichiganInflationExpectationsFinal: str = "michigan inflation expectations final"
            """Michigan Inflation Expectations Final"""

            MichiganInflationExpectationsPreliminary: str = "michigan inflation expectations preliminary"
            """Michigan Inflation Expectations Prel"""

            MidtermElections: str = "midterm elections"
            """Midterm Elections"""

            MidTermElections: str = "mid term elections"
            """Mid-Term Elections"""

            MonetaryPolicyReport: str = "monetary policy report"
            """Monetary Policy Report"""

            MonthlyBudgetStatement: str = "monthly budget statement"
            """Monthly Budget Statement"""

            NahbHousingMarketIndex: str = "nahb housing market index"
            """NAHB Housing Market Index"""

            NationalActivityIndex: str = "national activity index"
            """National activity index"""

            NetLongTermTicFlows: str = "net long term tic flows"
            """Net Long-Term Tic Flows"""

            NewHomeSales: str = "new home sales"
            """New Home Sales"""

            NewHomeSalesMoM: str = "new home sales mom"
            """New Home Sales MoM"""

            NewYearsDay: str = "new years day"
            """New Year's Day"""

            NewYearsDaySubstituteDay: str = "new years day substitute day"
            """New Year's Day (Substitute Day)"""

            NfibBusinessOptimismIndex: str = "nfib business optimism index"
            """NFIB Business Optimism Index"""

            NonFarmPayrolls: str = "non farm payrolls"
            """Non Farm Payrolls"""

            NonFarmPayrollsPrivate: str = "non farm payrolls private"
            """Nonfarm Payrolls Private"""

            NonFarmProductivityQoQ: str = "non farm productivity qoq"
            """Nonfarm Productivity QoQ"""

            NonFarmProductivityQoQFinal: str = "non farm productivity qoq final"
            """Nonfarm Productivity QoQ Final"""

            NonFarmProductivityQoQPreliminary: str = "non farm productivity qoq preliminary"
            """Nonfarm Productivity QoQ Prel"""

            NonFarmProductivityYoY: str = "non farm productivity yoy"
            """Nonfarm Productivity YoY"""

            NonManufacturingBusinessActivity: str = "non manufacturing business activity"
            """Non-Manufacturing Business Activity"""

            NyEmpireStateManufacturingIndex: str = "ny empire state manufacturing index"
            """NY Empire State Manufacturing Index"""

            ObamacareRepealVotePulled: str = "obamacare repeal vote pulled"
            """Obamacare Repeal Vote - Pulled"""

            OverallNetCapitalFlows: str = "overall net capital flows"
            """Overall Net Capital Flows"""

            ParticipationRate: str = "participation rate"
            """Participation Rate"""

            PendingHomeSalesMoM: str = "pending home sales mom"
            """Pending Home Sales MoM"""

            PendingHomeSalesYoY: str = "pending home sales yoy"
            """Pending Home Sales YoY"""

            PersonalConsumptionExpenditurePriceIndexMoM: str = "personal consumption expenditure price index mom"
            """PCE Price Index MoM"""

            PersonalConsumptionExpenditurePriceIndexQoQ: str = "personal consumption expenditure price index qoq"
            """PCE Prices QoQ"""

            PersonalConsumptionExpenditurePriceIndexQoQAdv: str = "personal consumption expenditure price index qoq adv"
            """PCE Prices QoQ Adv"""

            PersonalConsumptionExpenditurePriceIndexQoQFinal: str = "personal consumption expenditure price index qoq final"
            """PCE Prices QoQ Final"""

            PersonalConsumptionExpenditurePriceIndexQoQSecondEstimate: str = "personal consumption expenditure price index qoq second estimate"
            """PCE Prices QoQ 2 Est"""

            PersonalConsumptionExpenditurePriceIndexYoY: str = "personal consumption expenditure price index yoy"
            """PCE Price Index YoY"""

            PersonalIncomeMoM: str = "personal income mom"
            """Personal Income (MoM)"""

            PersonalSpendingMoM: str = "personal spending mom"
            """Personal Spending MoM"""

            PhiladelphiaFedManufacturingIndex: str = "philadelphia fed manufacturing index"
            """Philadelphia Fed Manufacturing Index"""

            PhiladelphiaFedPlosserSpeech: str = "philadelphia fed plosser speech"
            """Philadelphia Fed Plosser speech"""

            PresidentElectTrumpSpeech: str = "president elect trump speech"
            """President-Elect Trump Speech"""

            PresidentialElectionResults: str = "presidential election results"
            """Presidential Election Results"""

            PresidentialElections: str = "presidential elections"
            """Presidential Elections"""

            PresidentObamaSpeech: str = "president obama speech"
            """President Obama Speech"""

            PresidentObamaStatementOnTheEconomy: str = "president obama statement on the economy"
            """President Obama Statement on the Economy"""

            PresidentsDay: str = "presidents day"
            """President's Day"""

            PresidentTrumpAndPresidentXiJinpingMeeting: str = "president trump and president xi jinping meeting"
            """President Trump and President Xi Jinping Meeting"""

            PresidentTrumpSpeech: str = "president trump speech"
            """President Trump Speech"""

            PresidentTrumpSpeechOnIranDeal: str = "president trump speech on iran deal"
            """President Trump Speech on Iran Deal"""

            PresidentTrumpStateOfTheUnionSpeech: str = "president trump state of the union speech"
            """President Trump State of the Union Speech"""

            PresidentTrumpTaxSpeech: str = "president trump tax speech"
            """President Trump tax speech"""

            ProducerPriceIndexExcludingFoodAndEnergyMoM: str = "producer price index excluding food and energy mom"
            """Producer Price Index ex Food & Energy (MoM)"""

            ProducerPriceIndexExcludingFoodAndEnergyYoY: str = "producer price index excluding food and energy yoy"
            """Producer Price Index ex Food & Energy (YoY)"""

            ProducerPriceIndexMoM: str = "producer price index mom"
            """PPI MoM"""

            ProducerPriceIndexYoY: str = "producer price index yoy"
            """PPI YoY"""

            QuantitativeEasingMortgageBackedSecurities: str = "quantitative easing mortgage backed securities"
            """QE MBS"""

            QuantitativeEasingTotal: str = "quantitative easing total"
            """QE total"""

            QuantitativeEasingTreasuries: str = "quantitative easing treasuries"
            """QE Treasuries"""

            RealConsumerSpending: str = "real consumer spending"
            """Real Consumer Spending"""

            RedbookMoM: str = "redbook mom"
            """Redbook MoM"""

            RedbookYoY: str = "redbook yoy"
            """Redbook YoY"""

            RetailSalesExcludingAutosMoM: str = "retail sales excluding autos mom"
            """Retail Sales Ex Autos MoM"""

            RetailSalesExcludingGasAutosMoM: str = "retail sales excluding gas autos mom"
            """Retail Sales Ex Gas/Autos  MoM"""

            RetailSalesMoM: str = "retail sales mom"
            """Retail Sales MoM"""

            RetailSalesYoY: str = "retail sales yoy"
            """Retail Sales YoY"""

            ReutersMichiganConsumerExpectations: str = "reuters michigan consumer expectations"
            """Reuters Michigan Consumer Expectations"""

            ReutersMichiganConsumerExpectationsFinal: str = "reuters michigan consumer expectations final"
            """Reuters Michigan Consumer Expectations Final"""

            ReutersMichiganConsumerExpectationsPreliminary: str = "reuters michigan consumer expectations preliminary"
            """Reuters Michigan Consumer Expectations Prel"""

            ReutersMichiganConsumerSentimentFinal: str = "reuters michigan consumer sentiment final"
            """Reuters Michigan Consumer Sentiment Final"""

            ReutersMichiganConsumerSentimentIndex: str = "reuters michigan consumer sentiment index"
            """Reuters/Michigan Consumer Sentiment Index"""

            ReutersMichiganConsumerSentimentPreliminary: str = "reuters michigan consumer sentiment preliminary"
            """Reuters Michigan Consumer Sentiment  Prel"""

            ReutersMichiganCurrentConditions: str = "reuters michigan current conditions"
            """Reuters Michigan Current Conditions"""

            ReutersMichiganCurrentConditionsFinal: str = "reuters michigan current conditions final"
            """Reuters Michigan Current Conditions Final"""

            ReutersMichiganCurrentConditionsPreliminary: str = "reuters michigan current conditions preliminary"
            """Reuters Michigan Current Conditions Prel"""

            ReutersMichiganInflationExpectationsPreliminary: str = "reuters michigan inflation expectations preliminary"
            """Reuters Michigan Inflation Expectations Prel"""

            RichmondFedManufacturingIndex: str = "richmond fed manufacturing index"
            """Richmond Fed Manufacturing Index"""

            SandpCaseShillerHomePriceMoM: str = "sandp case shiller home price mom"
            """S&P/Case-Shiller Home Price MoM"""

            SandpCaseShillerHomePriceYoY: str = "sandp case shiller home price yoy"
            """S&P/Case-Shiller Home Price YoY"""

            SevenYearNoteAuction: str = "7 year note auction"
            """7-Year Note Auction"""

            SixMonthBillAuction: str = "6 month bill auction"
            """6-Month Bill Auction"""

            SpringMeetingOfTheWorldBankGroupImf: str = "spring meeting of the world bank group imf"
            """Spring Meeting of the World Bank Group-IMF"""

            TenYearNoteAuction: str = "10 year note auction"
            """10-Year Note Auction"""

            TenYearTipsAuction: str = "10 year tips auction"
            """10-Year TIPS Auction"""

            ThanksgivingDay: str = "thanksgiving day"
            """Thanksgiving Day"""

            ThirtyYearBondAuction: str = "30 year bond auction"
            """30-Year Bond Auction"""

            ThirtyYearNoteAuction: str = "30 year note auction"
            """30-Year Note Auction"""

            ThreeMonthBillAuction: str = "3 month bill auction"
            """3-Month Bill Auction"""

            ThreeYearNoteAuction: str = "3 year note auction"
            """3-Year Note Auction"""

            TotalNetTicFlows: str = "total net tic flows"
            """Total Net TIC Flows"""

            TotalVehicleSales: str = "total vehicle sales"
            """Total Vehicle Sales"""

            TreasurySecLewSpeaks: str = "treasury sec lew speaks"
            """Treasury Sec Lew Speaks"""

            TreasurySecretaryLewSpeaks: str = "treasury secretary lew speaks"
            """Treasury Secretary Lew Speaks"""

            TreasurySecretaryMnuchinSpeech: str = "treasury secretary mnuchin speech"
            """Treasury Secretary Mnuchin Speech"""

            TwoThousandNineteenUsMonetaryPolicyForum: str = "2019 us monetary policy forum"
            """2019 US Monetary Policy Forum"""

            TwoYearFrnAuction: str = "2 year frn auction"
            """2-Year FRN Auction"""

            TwoYearNoteAuction: str = "2 year note auction"
            """2-Year Note Auction"""

            UnemploymentRate: str = "unemployment rate"
            """Unemployment Rate"""

            UnGeneralAssembly: str = "un general assembly"
            """UN General Assembly"""

            UnitLaborCostsIndexQoQ: str = "unit labor costs index qoq"
            """Unit Labor Costs QoQ"""

            UnitLaborCostsIndexQoQFinal: str = "unit labor costs index qoq final"
            """Unit Labor Costs QoQ Final"""

            UnitLaborCostsIndexQoQPreliminary: str = "unit labor costs index qoq preliminary"
            """Unit Labor Costs QoQ Prel"""

            UnitLaborCostsYoY: str = "unit labor costs yoy"
            """Unit Labor Costs YoY"""

            UsChinaPhaseOneTradeDealSignature: str = "us china phase 1 trade deal signature"
            """US-China Phase 1 Trade Deal Signature"""

            UsChinaTradeTalks: str = "us china trade talks"
            """US-China Trade Talks"""

            UsGovTemporaryFundingExpires: str = "us gov temporary funding expires"
            """US Gov Temporary Funding Expires"""

            UsmcaTradeDealSignature: str = "usmca trade deal signature"
            """USMCA Trade Deal Signature"""

            UsMexicoTradeTalks: str = "us mexico trade talks"
            """US-Mexico Trade Talks"""

            UsMonetaryPolicyForum: str = "us monetary policy forum"
            """US Monetary Policy Forum"""

            UsNorthKoreaSummit: str = "us north korea summit"
            """US-North Korea Summit"""

            UsRussiaSummit: str = "us russia summit"
            """US-Russia Summit"""

            VeteransDay: str = "veterans day"
            """Veterans Day"""

            VeteransDaySubstituteDay: str = "veterans day substitute day"
            """Veterans Day (Substitute Day)"""

            WasdeReport: str = "wasde report"
            """WASDE Report"""

            WashingtonsBirthday: str = "washingtons birthday"
            """Washington's Birthday"""

            WhiteHouseJobsAnnouncement: str = "white house jobs announcement"
            """White House Jobs Announcement"""

            WholesaleInventoriesMoM: str = "wholesale inventories mom"
            """Wholesale Inventories MoM"""

            WholesaleInventoriesMoMAdv: str = "wholesale inventories mom adv"
            """Wholesale Inventories MoM Adv"""


class TradingEconomicsEarnings(QuantConnect.Data.BaseData):
    """
    Represents the Trading Economics Earnings information.
    https://docs.tradingeconomics.com/#earnings
    """

    DataSourceId: int
    """Data source ID"""

    @property
    def EndTime(self) -> datetime.datetime:
        """Release time and date in UTC"""
        ...

    @EndTime.setter
    def EndTime(self, value: datetime.datetime):
        """Release time and date in UTC"""
        ...

    @property
    def Symbol(self) -> str:
        """Unique symbol used by Trading Economics"""
        ...

    @Symbol.setter
    def Symbol(self, value: str):
        """Unique symbol used by Trading Economics"""
        ...

    @property
    def EarningsType(self) -> int:
        """This property contains the int value of a member of the QuantConnect.DataSource.EarningsType enum."""
        ...

    @EarningsType.setter
    def EarningsType(self, value: int):
        """This property contains the int value of a member of the QuantConnect.DataSource.EarningsType enum."""
        ...

    @property
    def Name(self) -> str:
        """Company name"""
        ...

    @Name.setter
    def Name(self, value: str):
        """Company name"""
        ...

    @property
    def Actual(self) -> typing.Optional[float]:
        """Earnings per share"""
        ...

    @Actual.setter
    def Actual(self, value: typing.Optional[float]):
        """Earnings per share"""
        ...

    @property
    def Value(self) -> float:
        """Earnings per share"""
        ...

    @Value.setter
    def Value(self, value: float):
        """Earnings per share"""
        ...

    @property
    def Forecast(self) -> typing.Optional[float]:
        """Average forecast among a representative group of analysts"""
        ...

    @Forecast.setter
    def Forecast(self, value: typing.Optional[float]):
        """Average forecast among a representative group of analysts"""
        ...

    @property
    def FiscalTag(self) -> str:
        """Fiscal year and quarter"""
        ...

    @FiscalTag.setter
    def FiscalTag(self, value: str):
        """Fiscal year and quarter"""
        ...

    @property
    def FiscalReference(self) -> str:
        """Fiscal year and quarter in different format"""
        ...

    @FiscalReference.setter
    def FiscalReference(self, value: str):
        """Fiscal year and quarter in different format"""
        ...

    @property
    def CalendarReference(self) -> str:
        """Calendar quarter for the release"""
        ...

    @CalendarReference.setter
    def CalendarReference(self, value: str):
        """Calendar quarter for the release"""
        ...

    @property
    def Country(self) -> str:
        """Country name"""
        ...

    @Country.setter
    def Country(self, value: str):
        """Country name"""
        ...

    @property
    def Currency(self) -> str:
        """Currency"""
        ...

    @Currency.setter
    def Currency(self, value: str):
        """Currency"""
        ...

    @property
    def LastUpdate(self) -> datetime.datetime:
        """Time when new data was inserted or changed"""
        ...

    @LastUpdate.setter
    def LastUpdate(self, value: datetime.datetime):
        """Time when new data was inserted or changed"""
        ...

    def DataTimeZone(self) -> typing.Any:
        """
        Specifies the data time zone for this data type. This is useful for custom data types
        
        :returns: The DateTimeZone of this data type.
        """
        ...


class EarningsType(System.Enum):
    """Earnings type: earnings, ipo, dividends"""

    Earnings = 0
    """Earnings"""

    IPO = 1
    """IPO"""

    Dividends = 2
    """Dividends"""

    Split = 3
    """Stock Splits"""


class TradingEconomicsIndicator(QuantConnect.Data.BaseData):
    """
    Represents the Trading Economics Indicator information.
    https://docs.tradingeconomics.com/#indicators
    """

    DataSourceId: int
    """Data source ID"""

    @property
    def Country(self) -> str:
        """Country name"""
        ...

    @Country.setter
    def Country(self, value: str):
        """Country name"""
        ...

    @property
    def Category(self) -> str:
        """Indicator category name"""
        ...

    @Category.setter
    def Category(self, value: str):
        """Indicator category name"""
        ...

    @property
    def EndTime(self) -> datetime.datetime:
        """Release time and date in UTC"""
        ...

    @EndTime.setter
    def EndTime(self, value: datetime.datetime):
        """Release time and date in UTC"""
        ...

    @property
    def Value(self) -> float:
        """Value"""
        ...

    @Value.setter
    def Value(self, value: float):
        """Value"""
        ...

    @property
    def Frequency(self) -> str:
        """Frequency of the indicator"""
        ...

    @Frequency.setter
    def Frequency(self, value: str):
        """Frequency of the indicator"""
        ...

    @property
    def LastUpdate(self) -> datetime.datetime:
        """Time when new data was inserted or changed"""
        ...

    @LastUpdate.setter
    def LastUpdate(self, value: datetime.datetime):
        """Time when new data was inserted or changed"""
        ...

    @property
    def HistoricalDataSymbol(self) -> str:
        """Unique symbol used by Trading Economics"""
        ...

    @HistoricalDataSymbol.setter
    def HistoricalDataSymbol(self, value: str):
        """Unique symbol used by Trading Economics"""
        ...

    def Clone(self) -> QuantConnect.Data.BaseData:
        """
        Clones the data. This is required for some custom data
        
        :returns: A new cloned instance.
        """
        ...

    def DataTimeZone(self) -> typing.Any:
        """
        Specifies the data time zone for this data type. This is useful for custom data types
        
        :returns: The DateTimeZone of this data type.
        """
        ...

    def GetSource(self, config: QuantConnect.Data.SubscriptionDataConfig, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.SubscriptionDataSource:
        """
        Return the Subscription Data Source gained from the URL
        
        :param config: Configuration object
        :param date: Date of this source file
        :param isLiveMode: true if we're in live mode, false for backtesting mode
        :returns: Subscription Data Source.
        """
        ...

    def Reader(self, config: QuantConnect.Data.SubscriptionDataConfig, content: str, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.BaseData:
        """
        Reader converts each line of the data source into BaseData objects.
        
        :param config: Subscription data config setup object
        :param content: Content of the source document
        :param date: Date of the requested data
        :param isLiveMode: true if we're in live mode, false for backtesting mode
        :returns: Collection of TradingEconomicsIndicator objects.
        """
        ...

    def ToString(self) -> str:
        """Formats a string with the Trading Economics Indicator information."""
        ...


class TradingEconomicsDateTimeConverter(JsonConverter):
    """DateTime JSON Converter that handles null value"""

    def CanConvert(self, objectType: typing.Type) -> bool:
        """Indicate if we can convert this object."""
        ...

    def ReadJson(self, reader: typing.Any, objectType: typing.Type, existingValue: typing.Any, serializer: typing.Any) -> System.Object:
        """Parse Trading Economics DateTime to C# DateTime"""
        ...

    def WriteJson(self, writer: typing.Any, value: typing.Any, serializer: typing.Any) -> None:
        """Write DateTime objects to JSON"""
        ...


class TradingEconomicsCalendar(QuantConnect.Data.BaseData):
    """
    Represents the Trading Economics Calendar information:
    The economic calendar covers around 1600 events for more than 150 countries a month.
    https://docs.tradingeconomics.com/#events
    """

    DataSourceId: int
    """Data source ID"""

    IsAuthCodeSet: bool
    """Determines if the API key has been set"""

    AuthCode: str
    """API key for Trading Economics"""

    @property
    def CalendarId(self) -> str:
        """Unique calendar ID used by Trading Economics"""
        ...

    @CalendarId.setter
    def CalendarId(self, value: str):
        """Unique calendar ID used by Trading Economics"""
        ...

    @property
    def EndTime(self) -> datetime.datetime:
        """Release time and date in UTC"""
        ...

    @EndTime.setter
    def EndTime(self, value: datetime.datetime):
        """Release time and date in UTC"""
        ...

    @property
    def Country(self) -> str:
        """Country name"""
        ...

    @Country.setter
    def Country(self, value: str):
        """Country name"""
        ...

    @property
    def Category(self) -> str:
        """Indicator category name"""
        ...

    @Category.setter
    def Category(self, value: str):
        """Indicator category name"""
        ...

    @property
    def Event(self) -> str:
        """Specific event name in the calendar"""
        ...

    @Event.setter
    def Event(self, value: str):
        """Specific event name in the calendar"""
        ...

    @property
    def EventRaw(self) -> str:
        """Raw event name as provided by Trading Economics"""
        ...

    @EventRaw.setter
    def EventRaw(self, value: str):
        """Raw event name as provided by Trading Economics"""
        ...

    @property
    def Reference(self) -> str:
        """The period for which released data refers to"""
        ...

    @Reference.setter
    def Reference(self, value: str):
        """The period for which released data refers to"""
        ...

    @property
    def Source(self) -> str:
        """Source of data"""
        ...

    @Source.setter
    def Source(self, value: str):
        """Source of data"""
        ...

    @property
    def Actual(self) -> typing.Optional[float]:
        """Latest released value"""
        ...

    @Actual.setter
    def Actual(self, value: typing.Optional[float]):
        """Latest released value"""
        ...

    @property
    def Previous(self) -> typing.Optional[float]:
        """Value for the previous period after the revision (if revision is applicable)"""
        ...

    @Previous.setter
    def Previous(self, value: typing.Optional[float]):
        """Value for the previous period after the revision (if revision is applicable)"""
        ...

    @property
    def Forecast(self) -> typing.Optional[float]:
        """Average forecast among a representative group of economists"""
        ...

    @Forecast.setter
    def Forecast(self, value: typing.Optional[float]):
        """Average forecast among a representative group of economists"""
        ...

    @property
    def TradingEconomicsForecast(self) -> typing.Optional[float]:
        """TradingEconomics own projections"""
        ...

    @TradingEconomicsForecast.setter
    def TradingEconomicsForecast(self, value: typing.Optional[float]):
        """TradingEconomics own projections"""
        ...

    @property
    def DateSpan(self) -> str:
        """
        0 indicates that the time of the event is known,
        1 indicates that we only know the date of event, the exact time of event is unknown
        """
        ...

    @DateSpan.setter
    def DateSpan(self, value: str):
        """
        0 indicates that the time of the event is known,
        1 indicates that we only know the date of event, the exact time of event is unknown
        """
        ...

    @property
    def Importance(self) -> int:
        """
        Importance of a TradingEconomics information
        
        This property contains the int value of a member of the QuantConnect.DataSource.TradingEconomicsImportance enum.
        """
        ...

    @Importance.setter
    def Importance(self, value: int):
        """
        Importance of a TradingEconomics information
        
        This property contains the int value of a member of the QuantConnect.DataSource.TradingEconomicsImportance enum.
        """
        ...

    @property
    def LastUpdate(self) -> datetime.datetime:
        """Time when new data was inserted or changed"""
        ...

    @LastUpdate.setter
    def LastUpdate(self, value: datetime.datetime):
        """Time when new data was inserted or changed"""
        ...

    @property
    def Revised(self) -> typing.Optional[float]:
        """Value reported in the previous period after revision"""
        ...

    @Revised.setter
    def Revised(self, value: typing.Optional[float]):
        """Value reported in the previous period after revision"""
        ...

    @property
    def OCountry(self) -> str:
        """Country's original name"""
        ...

    @OCountry.setter
    def OCountry(self, value: str):
        """Country's original name"""
        ...

    @property
    def OCategory(self) -> str:
        """Category's original name"""
        ...

    @OCategory.setter
    def OCategory(self, value: str):
        """Category's original name"""
        ...

    @property
    def Ticker(self) -> str:
        """Unique ticker used by Trading Economics"""
        ...

    @Ticker.setter
    def Ticker(self, value: str):
        """Unique ticker used by Trading Economics"""
        ...

    @property
    def IsPercentage(self) -> bool:
        """Indicates whether the Actual, Previous, Forecast, TradingEconomicsForecast fields are reported as percent values"""
        ...

    @IsPercentage.setter
    def IsPercentage(self, value: bool):
        """Indicates whether the Actual, Previous, Forecast, TradingEconomicsForecast fields are reported as percent values"""
        ...

    def Clone(self) -> QuantConnect.Data.BaseData:
        """
        Clones the data. This is required for some custom data
        
        :returns: A new cloned instance.
        """
        ...

    @staticmethod
    def CountryToCurrencyCode(country: str) -> str:
        """
        Converts country name to currency code (ISO 4217)
        
        :param country: Country name
        :returns: ISO 4217 currency code.
        """
        ...

    def DataTimeZone(self) -> typing.Any:
        """
        Specifies the data time zone for this data type. This is useful for custom data types
        
        :returns: The DateTimeZone of this data type.
        """
        ...

    def GetSource(self, config: QuantConnect.Data.SubscriptionDataConfig, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.SubscriptionDataSource:
        """
        Return the Subscription Data Source gained from the URL
        
        :param config: Configuration object
        :param date: Date of this source file
        :param isLiveMode: true if we're in live mode, false for backtesting mode
        :returns: Subscription Data Source.
        """
        ...

    @staticmethod
    def ParseDecimal(value: str, inPercent: bool) -> typing.Optional[float]:
        """
        Parse decimal from calendar data
        
        :param value: Value to parse
        :param inPercent: Is the value a percentage
        :returns: Nullable decimal.
        """
        ...

    @staticmethod
    def ProcessAPIResponse(content: str) -> System.Collections.Generic.List[QuantConnect.DataSource.TradingEconomicsCalendar]:
        """
        Parses the raw Trading Economics calendar API result
        
        :param content: Contents of returned data
        :returns: List of instances of the current class.
        """
        ...

    def Reader(self, config: QuantConnect.Data.SubscriptionDataConfig, line: str, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.BaseData:
        """
        Reader converts each line of the data source into BaseData objects.
        
        :param config: Subscription data config setup object
        :param line: Line from the data source
        :param date: Date of the requested data
        :param isLiveMode: true if we're in live mode, false for backtesting mode
        :returns: TradingEconomicsCalendar or BaseDataCollection object containing TradingEconomicsCalendar as its Data.
        """
        ...

    @staticmethod
    def SetAuthCode(authCode: str) -> None:
        """
        Sets the Trading Economics API key.
        
        :param authCode: The Trading Economics API key
        """
        ...

    def ToCsv(self) -> str:
        """
        Convert this instance to a CSV file
        
        :returns: string as CSV.
        """
        ...

    def ToString(self) -> str:
        """Formats a string with the Trading Economics Calendar information."""
        ...


class TradingEconomicsImportance(System.Enum):
    """Importance of a TradingEconomics information"""

    Low = 0
    """Low importance"""

    Medium = 1
    """Medium importance"""

    High = 2
    """High importance"""


class SmartInsiderExecution(System.Enum):
    """Describes how the transaction was executed"""

    Market = 0
    """Took place via the open market"""

    TenderOffer = 1
    """Via a companywide tender offer to all shareholders"""

    OffMarket = 2
    """Under a specific agreement between the issuer and shareholder"""

    Error = 3
    """Field is not in this enum"""


class SmartInsiderExecutionEntity(System.Enum):
    """Entity that intends to or executed the transaction"""

    Issuer = 0
    """Issuer of the stock"""

    Subsidiary = 1
    """Subsidiary of the issuer"""

    Broker = 2
    """
    Brokers are commonly used to repurchase shares under mandate to avoid insider
    information rules and to allow repurchases to carry on through close periods
    """

    EmployerBenefitTrust = 3
    """Unknown - Transaction"""

    EmployeeBenefitTrust = 4
    """To cater for shares which will need to be transferred to employees as part of remunerative plans"""

    ThirdParty = 5
    """Undisclosed independent third party. Likely to be a broker."""

    Error = 6
    """The field was not found in this enum"""


class SmartInsiderEventType(System.Enum):
    """Describes what will or has taken place in an execution"""

    Authorization = 0
    """Notification that the board has gained the authority to repurchase"""

    Intention = 1
    """Notification of the board that shares will be repurchased."""

    Transaction = 2
    """Repurchase transactions that have been actioned."""

    UpwardsRevision = 3
    """Increase in the scope of the existing plan (extended date, increased value, etc.)"""

    DownwardsRevision = 4
    """Decrease in the scope of the existing plan (shortened date, reduced value, etc.)"""

    RevisedDetails = 5
    """General change of details of the plan (max/min price alteration, etc.)"""

    Cancellation = 6
    """Total cancellation of the plan"""

    SeekAuthorization = 7
    """Announcement by a company that the board of directors or management will be seeking to obtain authorisation for a repurchase plan."""

    PlanSuspension = 8
    """Announcement by a company that a plan of repurchase has been suspended. Further details of the suspension are included in the note."""

    PlanReStarted = 9
    """Announcement by a company that a suspended plan has been re-started. Further details of the suspension are included in the note."""

    NotSpecified = 10
    """Announcement by a company not specified and/or not documented in the other categories. Further details are included in the note."""


class SmartInsiderEvent(QuantConnect.Data.BaseData, metaclass=abc.ABCMeta):
    """
    SmartInsider Intention and Transaction events. These are fields
    that are shared between intentions and transactions.
    """

    @property
    def TransactionID(self) -> str:
        """Proprietary unique field. Not nullable"""
        ...

    @TransactionID.setter
    def TransactionID(self, value: str):
        """Proprietary unique field. Not nullable"""
        ...

    @property
    def EventType(self) -> typing.Optional[QuantConnect.DataSource.SmartInsiderEventType]:
        """Description of what has or will take place in an execution"""
        ...

    @EventType.setter
    def EventType(self, value: typing.Optional[QuantConnect.DataSource.SmartInsiderEventType]):
        """Description of what has or will take place in an execution"""
        ...

    @property
    def LastUpdate(self) -> datetime.datetime:
        """The date when a transaction is updated after it has been reported. Not nullable"""
        ...

    @LastUpdate.setter
    def LastUpdate(self, value: datetime.datetime):
        """The date when a transaction is updated after it has been reported. Not nullable"""
        ...

    @property
    def LastIDsUpdate(self) -> typing.Optional[datetime.datetime]:
        ...

    @LastIDsUpdate.setter
    def LastIDsUpdate(self, value: typing.Optional[datetime.datetime]):
        ...

    @property
    def ISIN(self) -> str:
        """Industry classification number"""
        ...

    @ISIN.setter
    def ISIN(self, value: str):
        """Industry classification number"""
        ...

    @property
    def USDMarketCap(self) -> typing.Optional[float]:
        """The market capitalization at the time of the transaction stated in US Dollars"""
        ...

    @USDMarketCap.setter
    def USDMarketCap(self, value: typing.Optional[float]):
        """The market capitalization at the time of the transaction stated in US Dollars"""
        ...

    @property
    def CompanyID(self) -> typing.Optional[int]:
        """Smart Insider proprietary identifier for the company"""
        ...

    @CompanyID.setter
    def CompanyID(self, value: typing.Optional[int]):
        """Smart Insider proprietary identifier for the company"""
        ...

    @property
    def ICBIndustry(self) -> str:
        """FTSE Russell Sector Classification"""
        ...

    @ICBIndustry.setter
    def ICBIndustry(self, value: str):
        """FTSE Russell Sector Classification"""
        ...

    @property
    def ICBSuperSector(self) -> str:
        """FTSE Russell Sector Classification"""
        ...

    @ICBSuperSector.setter
    def ICBSuperSector(self, value: str):
        """FTSE Russell Sector Classification"""
        ...

    @property
    def ICBSector(self) -> str:
        """FTSE Russell Sector Classification"""
        ...

    @ICBSector.setter
    def ICBSector(self, value: str):
        """FTSE Russell Sector Classification"""
        ...

    @property
    def ICBSubSector(self) -> str:
        """FTSE Russell Sector Classification"""
        ...

    @ICBSubSector.setter
    def ICBSubSector(self, value: str):
        """FTSE Russell Sector Classification"""
        ...

    @property
    def ICBCode(self) -> typing.Optional[int]:
        """Numeric code that is the most granular level in ICB classification"""
        ...

    @ICBCode.setter
    def ICBCode(self, value: typing.Optional[int]):
        """Numeric code that is the most granular level in ICB classification"""
        ...

    @property
    def CompanyName(self) -> str:
        """Company name. PLC is always excluded"""
        ...

    @CompanyName.setter
    def CompanyName(self, value: str):
        """Company name. PLC is always excluded"""
        ...

    @property
    def PreviousResultsAnnouncementDate(self) -> typing.Optional[datetime.datetime]:
        """Announcement date of last results, this will be the end date of the last "Close Period\""""
        ...

    @PreviousResultsAnnouncementDate.setter
    def PreviousResultsAnnouncementDate(self, value: typing.Optional[datetime.datetime]):
        """Announcement date of last results, this will be the end date of the last "Close Period\""""
        ...

    @property
    def NextResultsAnnouncementsDate(self) -> typing.Optional[datetime.datetime]:
        """Announcement date of next results, this will be the end date of the next "Close Period\""""
        ...

    @NextResultsAnnouncementsDate.setter
    def NextResultsAnnouncementsDate(self, value: typing.Optional[datetime.datetime]):
        """Announcement date of next results, this will be the end date of the next "Close Period\""""
        ...

    @property
    def NextCloseBegin(self) -> typing.Optional[datetime.datetime]:
        """Start date of next trading embargo ahead of scheduled results announcment"""
        ...

    @NextCloseBegin.setter
    def NextCloseBegin(self, value: typing.Optional[datetime.datetime]):
        """Start date of next trading embargo ahead of scheduled results announcment"""
        ...

    @property
    def LastCloseEnded(self) -> typing.Optional[datetime.datetime]:
        """Date trading embargo (Close Period) is lifted as results are made public"""
        ...

    @LastCloseEnded.setter
    def LastCloseEnded(self, value: typing.Optional[datetime.datetime]):
        """Date trading embargo (Close Period) is lifted as results are made public"""
        ...

    @property
    def SecurityDescription(self) -> str:
        """Type of security. Does not contain nominal value"""
        ...

    @SecurityDescription.setter
    def SecurityDescription(self, value: str):
        """Type of security. Does not contain nominal value"""
        ...

    @property
    def TickerCountry(self) -> str:
        """Country of local identifier, denoting where the trade took place"""
        ...

    @TickerCountry.setter
    def TickerCountry(self, value: str):
        """Country of local identifier, denoting where the trade took place"""
        ...

    @property
    def TickerSymbol(self) -> str:
        """Local market identifier"""
        ...

    @TickerSymbol.setter
    def TickerSymbol(self, value: str):
        """Local market identifier"""
        ...

    @property
    def AnnouncementDate(self) -> typing.Optional[datetime.datetime]:
        """Date Transaction was entered onto our system. Where a transaction is after the London market close (usually 4.30pm) this will be stated as the next day"""
        ...

    @AnnouncementDate.setter
    def AnnouncementDate(self, value: typing.Optional[datetime.datetime]):
        """Date Transaction was entered onto our system. Where a transaction is after the London market close (usually 4.30pm) this will be stated as the next day"""
        ...

    @property
    def TimeReleased(self) -> typing.Optional[datetime.datetime]:
        """Time the announcement first appeared on a Regulatory News Service or other disclosure system and became available to the market, time stated is local market time"""
        ...

    @TimeReleased.setter
    def TimeReleased(self, value: typing.Optional[datetime.datetime]):
        """Time the announcement first appeared on a Regulatory News Service or other disclosure system and became available to the market, time stated is local market time"""
        ...

    @property
    def TimeProcessed(self) -> typing.Optional[datetime.datetime]:
        """Time the transaction was entered into Smart Insider systems and appeared on their website, time stated is local to London, UK"""
        ...

    @TimeProcessed.setter
    def TimeProcessed(self, value: typing.Optional[datetime.datetime]):
        """Time the transaction was entered into Smart Insider systems and appeared on their website, time stated is local to London, UK"""
        ...

    @property
    def TimeReleasedUtc(self) -> typing.Optional[datetime.datetime]:
        """Time the announcement first appeared on a Regulatory News Service or other disclosure system and became available to the market. Time stated is GMT standard"""
        ...

    @TimeReleasedUtc.setter
    def TimeReleasedUtc(self, value: typing.Optional[datetime.datetime]):
        """Time the announcement first appeared on a Regulatory News Service or other disclosure system and became available to the market. Time stated is GMT standard"""
        ...

    @property
    def TimeProcessedUtc(self) -> typing.Optional[datetime.datetime]:
        """Time the transaction was entered onto our systems and appeared on our website. Time stated is GMT standard"""
        ...

    @TimeProcessedUtc.setter
    def TimeProcessedUtc(self, value: typing.Optional[datetime.datetime]):
        """Time the transaction was entered onto our systems and appeared on our website. Time stated is GMT standard"""
        ...

    @property
    def AnnouncedIn(self) -> str:
        """Market in which the transaction was announced, this can reference more than one country"""
        ...

    @AnnouncedIn.setter
    def AnnouncedIn(self, value: str):
        """Market in which the transaction was announced, this can reference more than one country"""
        ...

    @overload
    def __init__(self) -> None:
        ...

    @overload
    def __init__(self, tsvLine: str) -> None:
        """
        Parses a line of TSV (tab delimited) from Smart Insider data
        
        This method is protected.
        
        :param tsvLine: Tab delimited line of data
        """
        ...

    def DataTimeZone(self) -> typing.Any:
        """
        Specifies the timezone of this data source
        
        :returns: Timezone.
        """
        ...

    def FromRawData(self, line: str, indexes: System.Collections.Generic.Dictionary[str, int]) -> bool:
        """
        Derived class instances populate their fields from raw TSV
        
        :param line: Line of raw TSV (raw with fields 46, 36, 14, 7 removed in descending order)
        :param indexes: Index per header column
        :returns: success of the parsing task.
        """
        ...

    @staticmethod
    def ParseDate(date: str) -> datetime.datetime:
        """
        Attempts to normalize and parse SmartInsider dates that include a time component.
        
        :param date: Date string to parse
        :returns: DateTime object.
        """
        ...

    def ToLine(self) -> str:
        """
        Converts data to TSV
        
        :returns: String of TSV.
        """
        ...


class SmartInsiderIntentionUniverse(QuantConnect.Data.BaseData):
    """Smart Insider Intentions Universe"""

    @property
    def Amount(self) -> typing.Optional[int]:
        """Number of shares to be or authorised to be traded"""
        ...

    @Amount.setter
    def Amount(self, value: typing.Optional[int]):
        """Number of shares to be or authorised to be traded"""
        ...

    @property
    def AmountValue(self) -> typing.Optional[int]:
        """Value of shares to be authorised to be traded"""
        ...

    @AmountValue.setter
    def AmountValue(self, value: typing.Optional[int]):
        """Value of shares to be authorised to be traded"""
        ...

    @property
    def Percentage(self) -> typing.Optional[float]:
        """Percentage of oustanding shares to be authorised to be traded"""
        ...

    @Percentage.setter
    def Percentage(self, value: typing.Optional[float]):
        """Percentage of oustanding shares to be authorised to be traded"""
        ...

    @property
    def MinimumPrice(self) -> typing.Optional[float]:
        """Minimum price shares will or may be purchased at"""
        ...

    @MinimumPrice.setter
    def MinimumPrice(self, value: typing.Optional[float]):
        """Minimum price shares will or may be purchased at"""
        ...

    @property
    def MaximumPrice(self) -> typing.Optional[float]:
        """Maximum price shares will or may be purchased at"""
        ...

    @MaximumPrice.setter
    def MaximumPrice(self, value: typing.Optional[float]):
        """Maximum price shares will or may be purchased at"""
        ...

    @property
    def USDMarketCap(self) -> typing.Optional[float]:
        """Market Capitalization in USD"""
        ...

    @USDMarketCap.setter
    def USDMarketCap(self, value: typing.Optional[float]):
        """Market Capitalization in USD"""
        ...

    @property
    def EndTime(self) -> datetime.datetime:
        """Time the data became available"""
        ...

    @EndTime.setter
    def EndTime(self, value: datetime.datetime):
        """Time the data became available"""
        ...

    def GetSource(self, config: QuantConnect.Data.SubscriptionDataConfig, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.SubscriptionDataSource:
        """
        Specifies the location of the data and directs LEAN where to load the data from
        
        :param config: Subscription configuration
        :param date: Algorithm date
        :param isLiveMode: Is live mode
        :returns: Subscription data source object pointing LEAN to the data location.
        """
        ...

    def Reader(self, config: QuantConnect.Data.SubscriptionDataConfig, line: str, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.BaseData:
        """
        Loads and reads the data to be used in LEAN
        
        :param config: Subscription configuration
        :param line: TSV line
        :param date: Algorithm date
        :param isLiveMode: Is live mode
        :returns: Instance of the object.
        """
        ...

    def ToString(self) -> str:
        """Converts the instance to string"""
        ...


class SmartInsiderTransactionUniverse(QuantConnect.Data.BaseData):
    """Smart Insider Transaction Universe"""

    @property
    def Amount(self) -> typing.Optional[float]:
        """Number of shares traded"""
        ...

    @Amount.setter
    def Amount(self, value: typing.Optional[float]):
        """Number of shares traded"""
        ...

    @property
    def MinimumExecutionPrice(self) -> typing.Optional[float]:
        """Minimum Value of Denominated in Currency of Transaction"""
        ...

    @MinimumExecutionPrice.setter
    def MinimumExecutionPrice(self, value: typing.Optional[float]):
        """Minimum Value of Denominated in Currency of Transaction"""
        ...

    @property
    def MaximumExecutionPrice(self) -> typing.Optional[float]:
        """Maximum Value of Denominated in Currency of Transaction"""
        ...

    @MaximumExecutionPrice.setter
    def MaximumExecutionPrice(self, value: typing.Optional[float]):
        """Maximum Value of Denominated in Currency of Transaction"""
        ...

    @property
    def USDValue(self) -> typing.Optional[float]:
        """Currency conversion rates are updated daily and values are calculated at rate prevailing on the trade date"""
        ...

    @USDValue.setter
    def USDValue(self, value: typing.Optional[float]):
        """Currency conversion rates are updated daily and values are calculated at rate prevailing on the trade date"""
        ...

    @property
    def BuybackPercentage(self) -> typing.Optional[float]:
        """Percentage of value of the trade as part of the issuers total Market Cap"""
        ...

    @BuybackPercentage.setter
    def BuybackPercentage(self, value: typing.Optional[float]):
        """Percentage of value of the trade as part of the issuers total Market Cap"""
        ...

    @property
    def VolumePercentage(self) -> typing.Optional[float]:
        """Percentage of the volume traded on the day of the buyback."""
        ...

    @VolumePercentage.setter
    def VolumePercentage(self, value: typing.Optional[float]):
        """Percentage of the volume traded on the day of the buyback."""
        ...

    @property
    def USDMarketCap(self) -> typing.Optional[float]:
        """Market Capitalization in USD"""
        ...

    @USDMarketCap.setter
    def USDMarketCap(self, value: typing.Optional[float]):
        """Market Capitalization in USD"""
        ...

    @property
    def EndTime(self) -> datetime.datetime:
        """Time the data became available"""
        ...

    @EndTime.setter
    def EndTime(self, value: datetime.datetime):
        """Time the data became available"""
        ...

    def GetSource(self, config: QuantConnect.Data.SubscriptionDataConfig, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.SubscriptionDataSource:
        """
        Specifies the location of the data and directs LEAN where to load the data from
        
        :param config: Subscription configuration
        :param date: Algorithm date
        :param isLiveMode: Is live mode
        :returns: Subscription data source object pointing LEAN to the data location.
        """
        ...

    def Reader(self, config: QuantConnect.Data.SubscriptionDataConfig, line: str, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.BaseData:
        """
        Loads and reads the data to be used in LEAN
        
        :param config: Subscription configuration
        :param line: TSV line
        :param date: Algorithm date
        :param isLiveMode: Is live mode
        :returns: Instance of the object.
        """
        ...

    def ToString(self) -> str:
        """Converts the instance to string"""
        ...


class SmartInsiderExecutionHolding(System.Enum):
    """Details regarding the way holdings will be or were processed in a buyback execution"""

    Treasury = 0
    """Held in treasury until they are sold back to the market"""

    Cancellation = 1
    """Immediately cancelled"""

    Trust = 2
    """Held in trust, generally to cover employee renumerative plans"""

    SatisfyEmployeeTax = 3
    """Shares will be used to satisfy employee tax liabilities"""

    NotReported = 4
    """Not disclosed by the issuer in the announcements"""

    SatisfyStockVesting = 5
    """Shares will be used to satisfy vesting of employee stock"""

    Error = 6
    """The field was not found in the enum, or is representative of a SatisfyStockVesting entry."""


class SmartInsiderIntention(QuantConnect.DataSource.SmartInsiderEvent):
    """Smart Insider Intentions - Intention to execute a stock buyback and details about the future event"""

    DataSourceId: int
    """Data source ID"""

    @property
    def Execution(self) -> typing.Optional[QuantConnect.DataSource.SmartInsiderExecution]:
        """Describes how the transaction was executed"""
        ...

    @Execution.setter
    def Execution(self, value: typing.Optional[QuantConnect.DataSource.SmartInsiderExecution]):
        """Describes how the transaction was executed"""
        ...

    @property
    def ExecutionEntity(self) -> typing.Optional[QuantConnect.DataSource.SmartInsiderExecutionEntity]:
        """Describes which entity intends to execute the transaction"""
        ...

    @ExecutionEntity.setter
    def ExecutionEntity(self, value: typing.Optional[QuantConnect.DataSource.SmartInsiderExecutionEntity]):
        """Describes which entity intends to execute the transaction"""
        ...

    @property
    def ExecutionHolding(self) -> typing.Optional[QuantConnect.DataSource.SmartInsiderExecutionHolding]:
        """Describes what will be done with those shares following repurchase"""
        ...

    @ExecutionHolding.setter
    def ExecutionHolding(self, value: typing.Optional[QuantConnect.DataSource.SmartInsiderExecutionHolding]):
        """Describes what will be done with those shares following repurchase"""
        ...

    @property
    def Amount(self) -> typing.Optional[int]:
        """Number of shares to be or authorised to be traded"""
        ...

    @Amount.setter
    def Amount(self, value: typing.Optional[int]):
        """Number of shares to be or authorised to be traded"""
        ...

    @property
    def ValueCurrency(self) -> str:
        """Currency of the value of shares to be/Authorised to be traded (ISO Code)"""
        ...

    @ValueCurrency.setter
    def ValueCurrency(self, value: str):
        """Currency of the value of shares to be/Authorised to be traded (ISO Code)"""
        ...

    @property
    def AmountValue(self) -> typing.Optional[int]:
        """Value of shares to be authorised to be traded"""
        ...

    @AmountValue.setter
    def AmountValue(self, value: typing.Optional[int]):
        """Value of shares to be authorised to be traded"""
        ...

    @property
    def Percentage(self) -> typing.Optional[float]:
        """Percentage of oustanding shares to be authorised to be traded"""
        ...

    @Percentage.setter
    def Percentage(self, value: typing.Optional[float]):
        """Percentage of oustanding shares to be authorised to be traded"""
        ...

    @property
    def AuthorizationStartDate(self) -> typing.Optional[datetime.datetime]:
        """start of the period the intention/authorisation applies to"""
        ...

    @AuthorizationStartDate.setter
    def AuthorizationStartDate(self, value: typing.Optional[datetime.datetime]):
        """start of the period the intention/authorisation applies to"""
        ...

    @property
    def AuthorizationEndDate(self) -> typing.Optional[datetime.datetime]:
        """End of the period the intention/authorisation applies to"""
        ...

    @AuthorizationEndDate.setter
    def AuthorizationEndDate(self, value: typing.Optional[datetime.datetime]):
        """End of the period the intention/authorisation applies to"""
        ...

    @property
    def PriceCurrency(self) -> str:
        """Currency of min/max prices (ISO Code)"""
        ...

    @PriceCurrency.setter
    def PriceCurrency(self, value: str):
        """Currency of min/max prices (ISO Code)"""
        ...

    @property
    def MinimumPrice(self) -> typing.Optional[float]:
        """Minimum price shares will or may be purchased at"""
        ...

    @MinimumPrice.setter
    def MinimumPrice(self, value: typing.Optional[float]):
        """Minimum price shares will or may be purchased at"""
        ...

    @property
    def MaximumPrice(self) -> typing.Optional[float]:
        """Maximum price shares will or may be purchased at"""
        ...

    @MaximumPrice.setter
    def MaximumPrice(self, value: typing.Optional[float]):
        """Maximum price shares will or may be purchased at"""
        ...

    @property
    def NoteText(self) -> str:
        """Free text which explains further details about the trade"""
        ...

    @NoteText.setter
    def NoteText(self, value: str):
        """Free text which explains further details about the trade"""
        ...

    @overload
    def __init__(self) -> None:
        """Empty constructor required for Slice.Get{T}()"""
        ...

    @overload
    def __init__(self, line: str) -> None:
        """
        Constructs instance of this via a *formatted* TSV line (tab delimited)
        
        :param line: Line of formatted TSV data
        """
        ...

    def Clone(self) -> QuantConnect.Data.BaseData:
        """
        Clones the object to a new instance. This method
        is required for custom data sources that make use
        of properties with more complex types since otherwise
        the values will default to null using the default clone method
        
        :returns: A new cloned instance of this object.
        """
        ...

    def FromRawData(self, line: str, indexes: System.Collections.Generic.Dictionary[str, int]) -> bool:
        """
        Constructs a new instance from unformatted TSV data
        
        :param line: Line of raw TSV (raw with fields 46, 36, 14, 7 removed in descending order)
        :param indexes: Index per header column
        :returns: success of the parsing task.
        """
        ...

    def GetSource(self, config: QuantConnect.Data.SubscriptionDataConfig, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.SubscriptionDataSource:
        """
        Specifies the location of the data and directs LEAN where to load the data from
        
        :param config: Subscription configuration
        :param date: Algorithm date
        :param isLiveMode: Is live mode
        :returns: Subscription data source object pointing LEAN to the data location.
        """
        ...

    def Reader(self, config: QuantConnect.Data.SubscriptionDataConfig, line: str, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.BaseData:
        """
        Loads and reads the data to be used in LEAN
        
        :param config: Subscription configuration
        :param line: TSV line
        :param date: Algorithm date
        :param isLiveMode: Is live mode
        :returns: Instance of the object.
        """
        ...

    def ToLine(self) -> str:
        """
        Converts the data to TSV
        
        :returns: String of TSV.
        """
        ...


class SmartInsiderTransaction(QuantConnect.DataSource.SmartInsiderEvent):
    """Smart Insider Transaction - Execution of a stock buyback and details about the event occurred"""

    DataSourceId: int
    """Data source ID"""

    @property
    def BuybackDate(self) -> typing.Optional[datetime.datetime]:
        """Date traded through the market"""
        ...

    @BuybackDate.setter
    def BuybackDate(self, value: typing.Optional[datetime.datetime]):
        """Date traded through the market"""
        ...

    @property
    def Execution(self) -> typing.Optional[QuantConnect.DataSource.SmartInsiderExecution]:
        """Describes how transaction was executed"""
        ...

    @Execution.setter
    def Execution(self, value: typing.Optional[QuantConnect.DataSource.SmartInsiderExecution]):
        """Describes how transaction was executed"""
        ...

    @property
    def ExecutionEntity(self) -> typing.Optional[QuantConnect.DataSource.SmartInsiderExecutionEntity]:
        """Describes which entity carried out the transaction"""
        ...

    @ExecutionEntity.setter
    def ExecutionEntity(self, value: typing.Optional[QuantConnect.DataSource.SmartInsiderExecutionEntity]):
        """Describes which entity carried out the transaction"""
        ...

    @property
    def ExecutionHolding(self) -> typing.Optional[QuantConnect.DataSource.SmartInsiderExecutionHolding]:
        """Describes what will be done with those shares following repurchase"""
        ...

    @ExecutionHolding.setter
    def ExecutionHolding(self, value: typing.Optional[QuantConnect.DataSource.SmartInsiderExecutionHolding]):
        """Describes what will be done with those shares following repurchase"""
        ...

    @property
    def Currency(self) -> str:
        """Currency of transation (ISO Code)"""
        ...

    @Currency.setter
    def Currency(self, value: str):
        """Currency of transation (ISO Code)"""
        ...

    @property
    def ExecutionPrice(self) -> typing.Optional[float]:
        """Denominated in Currency of Transaction"""
        ...

    @ExecutionPrice.setter
    def ExecutionPrice(self, value: typing.Optional[float]):
        """Denominated in Currency of Transaction"""
        ...

    @property
    def Amount(self) -> typing.Optional[float]:
        """Number of shares traded"""
        ...

    @Amount.setter
    def Amount(self, value: typing.Optional[float]):
        """Number of shares traded"""
        ...

    @property
    def GBPValue(self) -> typing.Optional[float]:
        """Currency conversion rates are updated daily and values are calculated at rate prevailing on the trade date"""
        ...

    @GBPValue.setter
    def GBPValue(self, value: typing.Optional[float]):
        """Currency conversion rates are updated daily and values are calculated at rate prevailing on the trade date"""
        ...

    @property
    def EURValue(self) -> typing.Optional[float]:
        """Currency conversion rates are updated daily and values are calculated at rate prevailing on the trade date"""
        ...

    @EURValue.setter
    def EURValue(self, value: typing.Optional[float]):
        """Currency conversion rates are updated daily and values are calculated at rate prevailing on the trade date"""
        ...

    @property
    def USDValue(self) -> typing.Optional[float]:
        """Currency conversion rates are updated daily and values are calculated at rate prevailing on the trade date"""
        ...

    @USDValue.setter
    def USDValue(self, value: typing.Optional[float]):
        """Currency conversion rates are updated daily and values are calculated at rate prevailing on the trade date"""
        ...

    @property
    def NoteText(self) -> str:
        """Free text which expains futher details about the trade"""
        ...

    @NoteText.setter
    def NoteText(self, value: str):
        """Free text which expains futher details about the trade"""
        ...

    @property
    def BuybackPercentage(self) -> typing.Optional[float]:
        """Percentage of value of the trade as part of the issuers total Market Cap"""
        ...

    @BuybackPercentage.setter
    def BuybackPercentage(self, value: typing.Optional[float]):
        """Percentage of value of the trade as part of the issuers total Market Cap"""
        ...

    @property
    def VolumePercentage(self) -> typing.Optional[float]:
        """Percentage of the volume traded on the day of the buyback."""
        ...

    @VolumePercentage.setter
    def VolumePercentage(self, value: typing.Optional[float]):
        """Percentage of the volume traded on the day of the buyback."""
        ...

    @property
    def ConversionRate(self) -> typing.Optional[float]:
        """Rate used to calculate 'Value (GBP)' from 'Price' multiplied by 'Amount'. Will be 1 where Currency is also 'GBP'"""
        ...

    @ConversionRate.setter
    def ConversionRate(self, value: typing.Optional[float]):
        """Rate used to calculate 'Value (GBP)' from 'Price' multiplied by 'Amount'. Will be 1 where Currency is also 'GBP'"""
        ...

    @property
    def AmountAdjustedFactor(self) -> typing.Optional[float]:
        """Multiplier which can be applied to 'Amount' field to account for subsequent corporate action"""
        ...

    @AmountAdjustedFactor.setter
    def AmountAdjustedFactor(self, value: typing.Optional[float]):
        """Multiplier which can be applied to 'Amount' field to account for subsequent corporate action"""
        ...

    @property
    def PriceAdjustedFactor(self) -> typing.Optional[float]:
        """Multiplier which can be applied to 'Price' and 'LastClose' fields to account for subsequent corporate actions"""
        ...

    @PriceAdjustedFactor.setter
    def PriceAdjustedFactor(self, value: typing.Optional[float]):
        """Multiplier which can be applied to 'Price' and 'LastClose' fields to account for subsequent corporate actions"""
        ...

    @property
    def TreasuryHolding(self) -> typing.Optional[int]:
        """Post trade holding of the Treasury or Trust in the security traded"""
        ...

    @TreasuryHolding.setter
    def TreasuryHolding(self, value: typing.Optional[int]):
        """Post trade holding of the Treasury or Trust in the security traded"""
        ...

    @overload
    def __init__(self) -> None:
        """Empty contsructor required for Slice.Get{T}()"""
        ...

    @overload
    def __init__(self, line: str) -> None:
        """
        Creates an instance of the object by taking a formatted TSV line
        
        :param line: Line of formatted TSV
        """
        ...

    def Clone(self) -> QuantConnect.Data.BaseData:
        """
        Clones the object to a new instance. This method
        is required for custom data sources that make use
        of properties with more complex types since otherwise
        the values will default to null using the default clone method
        
        :returns: A new cloned instance of this object.
        """
        ...

    def FromRawData(self, line: str, indexes: System.Collections.Generic.Dictionary[str, int]) -> bool:
        """
        Creates an instance of the object by taking a formatted TSV line
        
        :param line: Line of formatted TSV
        :param indexes: Index per header column
        :returns: success of the parsing task.
        """
        ...

    def GetSource(self, config: QuantConnect.Data.SubscriptionDataConfig, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.SubscriptionDataSource:
        """
        Specifies the location of the data and directs LEAN where to load the data from
        
        :param config: Subscription configuration
        :param date: Date
        :param isLiveMode: Is live mode
        :returns: Subscription data source object pointing LEAN to the data location.
        """
        ...

    def Reader(self, config: QuantConnect.Data.SubscriptionDataConfig, line: str, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.BaseData:
        """
        Reads the data into LEAN for use in algorithms
        
        :param config: Subscription configuration
        :param line: Line of TSV
        :param date: Algorithm date
        :param isLiveMode: Is live mode
        :returns: Instance of the object.
        """
        ...

    def ToLine(self) -> str:
        """
        Converts the data to TSV
        
        :returns: String of TSV.
        """
        ...


class RegalyticsRegulatoryArticles(QuantConnect.Data.UniverseSelection.BaseDataCollection):
    """Regalytics Regulatory articles collection"""

    def Clone(self) -> QuantConnect.Data.BaseData:
        """
        Clones the data
        
        :returns: A clone of the object.
        """
        ...

    def DataTimeZone(self) -> typing.Any:
        """
        Specifies the data time zone for this data type. This is useful for custom data types
        
        :returns: The NodaTime.DateTimeZone of this data type.
        """
        ...

    def DefaultResolution(self) -> int:
        """
        Gets the default resolution for this data and security type
        
        :returns: This method returns the int value of a member of the QuantConnect.Resolution enum.
        """
        ...

    def GetSource(self, config: QuantConnect.Data.SubscriptionDataConfig, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.SubscriptionDataSource:
        """
        Return the URL string source of the file. This will be converted to a stream
        
        :param config: Configuration object
        :param date: Date of this source file
        :param isLiveMode: true if we're in live mode, false for backtesting mode
        :returns: String URL of source file.
        """
        ...

    def IsSparseData(self) -> bool:
        """
        Indicates whether the data is sparse.
        If true, we disable logging for missing files
        
        :returns: true.
        """
        ...

    def Reader(self, config: QuantConnect.Data.SubscriptionDataConfig, line: str, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.BaseData:
        """
        Parses the data from the line provided and loads it into LEAN
        
        :param config: Subscription configuration
        :param line: Line of data
        :param date: Date
        :param isLiveMode: Is live mode
        :returns: New instance.
        """
        ...

    def RequiresMapping(self) -> bool:
        """
        Indicates whether the data source is tied to an underlying symbol and requires that corporate events be applied to it as well, such as renames and delistings
        
        :returns: false.
        """
        ...

    def SupportedResolutions(self) -> System.Collections.Generic.List[QuantConnect.Resolution]:
        """Gets the supported resolution for this data and security type"""
        ...

    def ToString(self) -> str:
        """
        Formats a string with QuiverCNBC data
        
        :returns: string containing QuiverCNBC information.
        """
        ...


class RegalyticsRegulatoryArticle(QuantConnect.Data.BaseData):
    """Regalytics Regulatory articles"""

    DataSourceId: int
    """Data source ID"""

    @property
    def Id(self) -> int:
        ...

    @Id.setter
    def Id(self, value: int):
        ...

    @property
    def Title(self) -> str:
        ...

    @Title.setter
    def Title(self, value: str):
        ...

    @property
    def Summary(self) -> str:
        ...

    @Summary.setter
    def Summary(self, value: str):
        ...

    @property
    def Status(self) -> str:
        ...

    @Status.setter
    def Status(self, value: str):
        ...

    @property
    def Classification(self) -> str:
        ...

    @Classification.setter
    def Classification(self, value: str):
        ...

    @property
    def FilingType(self) -> str:
        ...

    @FilingType.setter
    def FilingType(self, value: str):
        ...

    @property
    def InFederalRegister(self) -> bool:
        ...

    @InFederalRegister.setter
    def InFederalRegister(self, value: bool):
        ...

    @property
    def FederalRegisterNumber(self) -> str:
        ...

    @FederalRegisterNumber.setter
    def FederalRegisterNumber(self, value: str):
        ...

    @property
    def ProposedCommentsDueDate(self) -> typing.Optional[datetime.datetime]:
        ...

    @ProposedCommentsDueDate.setter
    def ProposedCommentsDueDate(self, value: typing.Optional[datetime.datetime]):
        ...

    @property
    def OriginalPublicationDate(self) -> typing.Optional[datetime.datetime]:
        ...

    @OriginalPublicationDate.setter
    def OriginalPublicationDate(self, value: typing.Optional[datetime.datetime]):
        ...

    @property
    def FederalRegisterPublicationDate(self) -> typing.Optional[datetime.datetime]:
        ...

    @FederalRegisterPublicationDate.setter
    def FederalRegisterPublicationDate(self, value: typing.Optional[datetime.datetime]):
        ...

    @property
    def RuleEffectiveDate(self) -> typing.Optional[datetime.datetime]:
        ...

    @RuleEffectiveDate.setter
    def RuleEffectiveDate(self, value: typing.Optional[datetime.datetime]):
        ...

    @property
    def LatestUpdate(self) -> datetime.datetime:
        ...

    @LatestUpdate.setter
    def LatestUpdate(self, value: datetime.datetime):
        ...

    @property
    def AlertType(self) -> str:
        ...

    @AlertType.setter
    def AlertType(self, value: str):
        ...

    @property
    def States(self) -> System.Collections.Generic.Dictionary[str, System.Collections.Generic.List[str]]:
        ...

    @States.setter
    def States(self, value: System.Collections.Generic.Dictionary[str, System.Collections.Generic.List[str]]):
        ...

    @property
    def Agencies(self) -> System.Collections.Generic.List[str]:
        ...

    @Agencies.setter
    def Agencies(self, value: System.Collections.Generic.List[str]):
        ...

    @property
    def AnnouncementUrl(self) -> str:
        ...

    @AnnouncementUrl.setter
    def AnnouncementUrl(self, value: str):
        ...

    @property
    def CreatedAt(self) -> datetime.datetime:
        ...

    @CreatedAt.setter
    def CreatedAt(self, value: datetime.datetime):
        ...

    @property
    def EndTime(self) -> datetime.datetime:
        ...

    @EndTime.setter
    def EndTime(self, value: datetime.datetime):
        ...

    def Clone(self) -> QuantConnect.Data.BaseData:
        """
        Clones the data
        
        :returns: A clone of the object.
        """
        ...

    def DataTimeZone(self) -> typing.Any:
        """
        Specifies the data time zone for this data type. This is useful for custom data types
        
        :returns: The NodaTime.DateTimeZone of this data type.
        """
        ...

    def DefaultResolution(self) -> int:
        """
        Gets the default resolution for this data and security type
        
        :returns: This method returns the int value of a member of the QuantConnect.Resolution enum.
        """
        ...

    def IsSparseData(self) -> bool:
        """
        Indicates whether the data is sparse.
        If true, we disable logging for missing files
        
        :returns: true.
        """
        ...

    def Reader(self, config: QuantConnect.Data.SubscriptionDataConfig, line: str, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.BaseData:
        """
        Parses the data from the line provided and loads it into LEAN
        
        :param config: Subscription configuration
        :param line: Line of data
        :param date: Date
        :param isLiveMode: Is live mode
        :returns: New instance.
        """
        ...

    def RequiresMapping(self) -> bool:
        """
        Indicates whether the data source is tied to an underlying symbol and requires that corporate events be applied to it as well, such as renames and delistings
        
        :returns: false.
        """
        ...

    def SupportedResolutions(self) -> System.Collections.Generic.List[QuantConnect.Resolution]:
        """Gets the supported resolution for this data and security type"""
        ...

    def ToString(self) -> str:
        """Converts the instance to string"""
        ...


class Tiingo(System.Object):
    """Helper class for Tiingo configuration"""

    AuthCode: str
    """Gets the Tiingo API token."""

    IsAuthCodeSet: bool
    """Returns true if the Tiingo API token has been set."""

    @staticmethod
    def SetAuthCode(authCode: str) -> None:
        """
        Sets the Tiingo API token.
        
        :param authCode: The Tiingo API token
        """
        ...


class TiingoNews(QuantConnect.Data.IndexedBaseData):
    """
    Tiingo news data
    https://api.tiingo.com/documentation/news
    """

    DataSourceId: int
    """Data source ID"""

    @property
    def Source(self) -> str:
        """The domain the news source is from."""
        ...

    @Source.setter
    def Source(self, value: str):
        """The domain the news source is from."""
        ...

    @property
    def CrawlDate(self) -> datetime.datetime:
        """
        The datetime the news story was added to Tiingos database in UTC.
        This is always recorded by Tiingo and the news source has no input on this date.
        """
        ...

    @CrawlDate.setter
    def CrawlDate(self, value: datetime.datetime):
        """
        The datetime the news story was added to Tiingos database in UTC.
        This is always recorded by Tiingo and the news source has no input on this date.
        """
        ...

    @property
    def Url(self) -> str:
        """URL of the news article."""
        ...

    @Url.setter
    def Url(self, value: str):
        """URL of the news article."""
        ...

    @property
    def PublishedDate(self) -> datetime.datetime:
        """
        The datetime the news story was published in UTC. This is usually reported by the news source and not by Tiingo.
        If the news source does not declare a published date, Tiingo will use the time the news story was discovered by our crawler farm.
        """
        ...

    @PublishedDate.setter
    def PublishedDate(self, value: datetime.datetime):
        """
        The datetime the news story was published in UTC. This is usually reported by the news source and not by Tiingo.
        If the news source does not declare a published date, Tiingo will use the time the news story was discovered by our crawler farm.
        """
        ...

    @property
    def Tags(self) -> System.Collections.Generic.List[str]:
        """Tags that are mapped and discovered by Tiingo."""
        ...

    @Tags.setter
    def Tags(self, value: System.Collections.Generic.List[str]):
        """Tags that are mapped and discovered by Tiingo."""
        ...

    @property
    def Description(self) -> str:
        """Long-form description of the news story."""
        ...

    @Description.setter
    def Description(self, value: str):
        """Long-form description of the news story."""
        ...

    @property
    def Title(self) -> str:
        """Title of the news article."""
        ...

    @Title.setter
    def Title(self, value: str):
        """Title of the news article."""
        ...

    @property
    def ArticleID(self) -> str:
        """Unique identifier specific to the news article."""
        ...

    @ArticleID.setter
    def ArticleID(self, value: str):
        """Unique identifier specific to the news article."""
        ...

    @property
    def Symbols(self) -> System.Collections.Generic.List[QuantConnect.Symbol]:
        """What symbols are mentioned in the news story."""
        ...

    @Symbols.setter
    def Symbols(self, value: System.Collections.Generic.List[QuantConnect.Symbol]):
        """What symbols are mentioned in the news story."""
        ...

    def DataTimeZone(self) -> typing.Any:
        """
        Specifies the data time zone for this data type. This is useful for custom data types
        
        :returns: The DateTimeZone of this data type.
        """
        ...

    def GetSource(self, config: QuantConnect.Data.SubscriptionDataConfig, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.SubscriptionDataSource:
        """
        For backtesting returns the index source for a date
        For live trading will return the source url to use, not using the index mechanism
        
        :param config: Configuration object
        :param date: Date of this source file
        :param isLiveMode: true if we're in live mode, false for backtesting mode
        :returns: The SubscriptionDataSource instance to use.
        """
        ...

    def GetSourceForAnIndex(self, config: QuantConnect.Data.SubscriptionDataConfig, date: typing.Union[datetime.datetime, datetime.date], index: str, isLiveMode: bool) -> QuantConnect.Data.SubscriptionDataSource:
        """
        Returns the source for a given index value
        
        :param config: Configuration object
        :param date: Date of this source file
        :param index: The index value for which we want to fetch the source
        :param isLiveMode: true if we're in live mode, false for backtesting mode
        :returns: The SubscriptionDataSource instance to use.
        """
        ...

    def Reader(self, config: QuantConnect.Data.SubscriptionDataConfig, content: str, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.BaseData:
        """
        Reader converts each line of the data source into BaseData objects. Each data type creates its own factory method,
            and returns a new instance of the object
            each time it is called. The returned object is assumed to be time stamped in the config.ExchangeTimeZone.
        
        :param config: Subscription data config setup object
        :param content: Content of the source document
        :param date: Date of the requested data
        :param isLiveMode: true if we're in live mode, false for backtesting mode
        :returns: Instance of the T:BaseData object generated by this line of the CSV.
        """
        ...

    def RequiresMapping(self) -> bool:
        """
        Indicates if there is support for mapping
        
        :returns: True indicates mapping should be used.
        """
        ...


class TiingoNewsJsonConverter(JsonConverter):
    """
    Helper json converter class used to convert a list of Tiingo news data
    into List{TiingoNews}
    """

    def __init__(self, symbol: typing.Union[QuantConnect.Symbol, str] = None) -> None:
        """
        Creates a new instance of the json converter
        
        :param symbol: The Symbol instance associated with this news
        """
        ...

    def CanConvert(self, objectType: typing.Type) -> bool:
        """
        Determines whether this instance can convert the specified object type.
        
        :param objectType: Type of the object.
        :returns: true if this instance can convert the specified object type; otherwise, false.
        """
        ...

    @staticmethod
    def DeserializeNews(token: typing.Any) -> QuantConnect.DataSource.TiingoNews:
        """
        Helper method to deserialize a single json Tiingo news
        
        :param token: The json token containing the Tiingo news to deserialize
        :returns: The deserialized TiingoNews instance.
        """
        ...

    def ReadJson(self, reader: typing.Any, objectType: typing.Type, existingValue: typing.Any, serializer: typing.Any) -> System.Object:
        """
        Reads the JSON representation of the object.
        
        :param reader: The Newtonsoft.Json.JsonReader to read from.
        :param objectType: Type of the object.
        :param existingValue: The existing value of object being read.
        :param serializer: The calling serializer.
        :returns: The object value.
        """
        ...

    def WriteJson(self, writer: typing.Any, value: typing.Any, serializer: typing.Any) -> None:
        """
        Writes the JSON representation of the object.
        
        :param writer: The Newtonsoft.Json.JsonWriter to write to.
        :param value: The value.
        :param serializer: The calling serializer.
        """
        ...


class TiingoSymbolMapper(System.Object):
    """Helper class to map a Lean format ticker to Tiingo format"""

    @staticmethod
    def GetLeanTicker(ticker: str) -> str:
        """Maps a given Tiingo ticker to Lean equivalent"""
        ...

    @staticmethod
    def GetTiingoTicker(symbol: typing.Union[QuantConnect.Symbol, str]) -> str:
        """Maps a given Symbol instance to it's Tiingo equivalent"""
        ...


class Fred(QuantConnect.Data.BaseData):
    """Federal Reserve Economic Data"""

    class CentralBankInterventions(System.Object):
        """Central Bank Interventions"""

        JapaneseBankPurchasesOfDmEuroAgainstJpy: str = "JPINTDDMEJPY"
        """Japan Intervention: Japanese Bank purchases of DM/Euro against JPY (in 100 Million Yen)"""

        JapaneseBankPurchasesOfUsdAgainstDm: str = "JPINTDEXR"
        """Japan Intervention: Japanese Bank purchases of USD against DM (in 100 Million Yen)"""

        JapaneseBankPurchasesOfUsdAgainstRupiah: str = "JPINTDUSDRP"
        """Japan Intervention: Japanese Bank purchases of USD against Rupiah (in 100 Million Yen)"""

        USInterventionInMarketTransactionsInTheJpyUsd: str = "USINTDMRKTJPY"
        """U.S. Intervention: in Market Transactions in the JPY/USD (Millions of USD) (in Millions of USD)"""

        USInterventionWithCustomerTransactionsInOtherCurrencies: str = "USINTDCSOTH"
        """U.S. Intervention: With-Customer Transactions in Other Currencies (Millions of USD) (in Millions of USD)"""

        USInterventionWithCustomerTransactionsInTheJpyUsd: str = "USINTDCSJPY"
        """U.S. Intervention: With-Customer Transactions in the JPY/USD (Millions of USD) (in Millions of USD)"""

        USInterventionWithCustomerTransactionsInTheDemUsdEuro: str = "USINTDCSDM"
        """U.S. Intervention: With-Customer Transactions in the DEM/USD (Euro since 1999) (Millions of USD) (in Millions of USD)"""

        USInterventionInMarketTransactionsInOtherCurrencies: str = "USINTDMRKTOTH"
        """U.S. Intervention: in Market Transactions in Other Currencies (Millions of USD) (in Millions of USD)"""

        CentralBankOfTurkeyPurchasesOfUsd: str = "TRINTDEXR"
        """Turkish Intervention: Central Bank of Turkey Purchases of USD (Millions of USD) (in Millions of USD)"""

        JapaneseBankPurchasesOfUsdAgainstJpy: str = "JPINTDUSDJPY"
        """Japan Intervention: Japanese Bank purchases of USD against JPY (in 100 Million Yen)"""

        USInterventionInMarketTransactionsInTheDemUsdEuro: str = "USINTDMRKTDM"
        """U.S. Intervention: in Market Transactions in the DEM/USD (Euro since 1999) (Millions of USD) (in Millions of USD)"""

        SwissNationalBankPurchasesOfDemAgainstChfMillionsOfDem: str = "CHINTDCHFDM"
        """Swiss Intervention: Swiss National Bank Purchases of DEM against CHF (Millions of DEM) (in Millions of DEM)"""

        SwissNationalBankPurchasesOfUsdAgainstDem: str = "CHINTDUSDDM"
        """Swiss Intervention: Swiss National Bank Purchases of USD against DEM (Millions of USD) (in Millions of USD)"""

        SwissNationalBankPurchasesOfUsdAgainstJpy: str = "CHINTDUSDJPY"
        """Swiss Intervention: Swiss National Bank Purchases of USD against JPY (Millions of USD) (in Millions of USD)"""

        SwissNationalBankPurchasesOfUsdAgainstChf: str = "CHINTDCHFUSD"
        """Swiss Intervention: Swiss National Bank Purchases of USD against CHF (Millions of USD) (in Millions of USD)"""

        BancoDeMexicoPurchaseOnTheUsd: str = "MEXINTDUSD"
        """Mexican Intervention: Banco de Mexico Purchase on the USD (in Millions of USD)"""

    class TradeWeightedIndexes(System.Object):
        """Trade Weight Indexes"""

        MajorCurrenciesGoods: str = "DTWEXM"
        """Trade Weighted U.S. Dollar Index: Major Currencies, Goods (in Index Mar 1973=100)"""

        OtherImportantTradingPartnersGoods: str = "DTWEXO"
        """Trade Weighted U.S. Dollar Index: Other Important Trading Partners, Goods (in Index Jan 1997=100)"""

        BroadGoods: str = "DTWEXB"
        """Trade Weighted U.S. Dollar Index: Broad, Goods (in Index Jan 1997=100)"""

        AdvancedForeignEconomiesGoodsAndServices: str = "DTWEXAFEGS"
        """Trade Weighted U.S. Dollar Index: Advanced Foreign Economies, Goods and Services (in Index Jan 2006=100)"""

        BroadGoodsAndServices: str = "DTWEXBGS"
        """Trade Weighted U.S. Dollar Index: Broad, Goods and Services (in Index Jan 2006=100)"""

        EmergingMarketsEconomiesGoodsAndServices: str = "DTWEXEMEGS"
        """Trade Weighted U.S. Dollar Index: Emerging Markets Economies, Goods and Services (in Index Jan 2006=100)"""

    class CommercialPaper(System.Object):
        """
        Commercial paper (CP) consists of short-term, promissory notes issued primarily by corporations. Maturities range up to 270 days but average about 30 days. Many companies use CP to raise cash needed for current transactions, and many find it to be a lower-cost alternative to bank loans.
        The Federal Reserve Board disseminates information on CP primarily through its World Wide Web site. In addition, the Board publishes one-, two-, and three-month rates on AA nonfinancial and AA financial CP weekly in its H.15 Statistical Release.
        The Federal Reserve Board's CP release is derived from data supplied by The Depository Trust & Clearing Corporation (DTCC), a national clearinghouse for the settlement of securities trades and a custodian for securities. DTCC performs these functions for almost all activity in the domestic CP market. The Federal Reserve Board only considers maturities of 270 days or less. CP is exempt from SEC registration if its maturity does not exceed 270 days.
        Data on CP issuance rates and volumes typically are updated daily and typically posted with a one-day lag. Data on CP outstanding usually are available as of the close of business each Wednesday and as of the last business day of the month; these data are also posted with a one-day lag. The daily CP release will usually be available at 9:45 a.m. EST. However, the Federal Reserve Board makes no guarantee regarding the timing of the daily CP release. This policy is subject to change at any time without notice.
        """

        ThreeMonthAANonfinancialCommercialPaperRate: str = "DCPN3M"
        """3-Month AA Nonfinancial Commercial Paper Rate (in Percent)"""

        OneMonthAANonfinancialCommercialPaperRate: str = "DCPN30"
        """1-Month AA Nonfinancial Commercial Paper Rate (in Percent)"""

        TwoMonthAANonfinancialCommercialPaperRate: str = "DCPN2M"
        """2-Month AA Nonfinancial Commercial Paper Rate (in Percent)"""

        ThreeMonthAAFinancialCommercialPaperRate: str = "DCPF3M"
        """3-Month AA Financial Commercial Paper Rate (in Percent)"""

        TwoMonthAAFinancialCommercialPaperRate: str = "DCPF2M"
        """2-Month AA Financial Commercial Paper Rate (in Percent)"""

        OneMonthAAFinancialCommercialPaperRate: str = "DCPF1M"
        """1-Month AA Financial Commercial Paper Rate (in Percent)"""

        NumberOfIssuesWithMaturityBetween1and4DaysUsedForA2P2Nonfinancial: str = "NONFIN14A2P2VOL"
        """Number of Issues, with a Maturity Between 1 and 4 Days, Used in Calculating the A2/P2 Nonfinancial Commercial Paper Rates (in Number)"""

        NumberOfIssuesWithMaturityBetween5and9DaysUsedForA2P2Nonfinancial: str = "NONFIN59A2P2VOL"
        """Number of Issues, with a Maturity Between 5 and 9 Days, Used in Calculating the A2/P2 Nonfinancial Commercial Paper Rates (in Number)"""

        TotalValueOfIssuesWithMaturityBetween5and9DaysUsedForA2P2Nonfinancial: str = "NONFIN59A2P2AMT"
        """Total Value of Issues, with a Maturity Between 5 and 9 Days, Used in Calculating the A2/P2 Nonfinancial Commercial Paper Rates (in Millions of Dollars)"""

        NumberOfIssuesWithMaturityBetween41and80DaysUsedForAANonfinancial: str = "NONFIN4180AAVOL"
        """Number of Issues, with a Maturity Between 41 and 80 Days, Used in Calculating the AA Nonfinancial Commercial Paper Rates (in Number)"""

        TotalValueOfIssuesWithMaturityGreaterThan80DaysUsedForAAAssetBacked: str = "ABGT80AAAMT"
        """Total Value of Issues, with a Maturity Greater Than 80 Days, Used in Calculating the AA Asset-Backed Commercial Paper Rates (in Millions of Dollars)"""

        TotalValueOfIssuesWithMaturityBetween41and80DaysUsedForAANonfinancial: str = "NONFIN4180AAAMT"
        """Total Value of Issues, with a Maturity Between 41 and 80 Days, Used in Calculating the AA Nonfinancial Commercial Paper Rates (in Millions of Dollars)"""

        NumberOfIssuesWithMaturityBetween41and80DaysUsedForA2P2Nonfinancial: str = "NONFIN4180A2P2VOL"
        """Number of Issues, with a Maturity Between 41 and 80 Days, Used in Calculating the A2/P2 Nonfinancial Commercial Paper Rates (in Number)"""

        TotalValueOfIssuesWithMaturityBetween41and80DaysUsedForA2P2Nonfinancial: str = "NONFIN4180A2P2AMT"
        """Total Value of Issues, with a Maturity Between 41 and 80 Days, Used in Calculating the A2/P2 Nonfinancial Commercial Paper Rates (in Millions of Dollars)"""

        NumberOfIssuesWithMaturityBetween21and40DaysUsedForAANonfinancial: str = "NONFIN2140AAVOL"
        """Number of Issues, with a Maturity Between 21 and 40 Days, Used in Calculating the AA Nonfinancial Commercial Paper Rates (in Number)"""

        TotalValueOfIssuesWithMaturityBetween21and40DaysUsedForAANonfinancial: str = "NONFIN2140AAAMT"
        """Total Value of Issues, with a Maturity Between 21 and 40 Days, Used in Calculating the AA Nonfinancial Commercial Paper Rates (in Millions of Dollars)"""

        NumberOfIssuesWithMaturityBetween21and40DaysUsedForA2P2Nonfinancial: str = "NONFIN2140A2P2VOL"
        """Number of Issues, with a Maturity Between 21 and 40 Days, Used in Calculating the A2/P2 Nonfinancial Commercial Paper Rates (in Number)"""

        TotalValueOfIssuesWithMaturityBetween21and40DaysUsedForA2P2Nonfinancial: str = "NONFIN2140A2P2AMT"
        """Total Value of Issues, with a Maturity Between 21 and 40 Days, Used in Calculating the A2/P2 Nonfinancial Commercial Paper Rates (in Millions of Dollars)"""

        NumberOfIssuesWithMaturityBetween1and4DaysUsedForAANonfinancial: str = "NONFIN14AAVOL"
        """Number of Issues, with a Maturity Between 1 and 4 Days, Used in Calculating the AA Nonfinancial Commercial Paper Rates (in Number)"""

        NumberOfIssuesWithMaturityBetween10And20DaysUsedForA2P2Nonfinancial: str = "NONFIN1020A2P2VOL"
        """Number of Issues, with a Maturity Between 10 and 20 Days, Used in Calculating the A2/P2 Nonfinancial Commercial Paper Rates (in Number)"""

        TotalValueOfIssuesWithMaturityBetween10And20DaysUsedForAANonfinancial: str = "NONFIN1020AAAMT"
        """Total Value of Issues, with a Maturity Between 10 and 20 Days, Used in Calculating the AA Nonfinancial Commercial Paper Rates (in Millions of Dollars)"""

        TotalValueOfIssuesWithMaturityBetween21and40DaysUsedForAAAssetBacked: str = "AB2140AAAMT"
        """Total Value of Issues, with a Maturity Between 21 and 40 Days, Used in Calculating the AA Asset-Backed Commercial Paper Rates (in Millions of Dollars)"""

        NumberOfIssuesWithMaturityBetween10And20DaysUsedForAANonfinancial: str = "NONFIN1020AAVOL"
        """Number of Issues, with a Maturity Between 10 and 20 Days, Used in Calculating the AA Nonfinancial Commercial Paper Rates (in Number)"""

        TotalValueOfIssuesWithMaturityBetween1and4DaysUsedForA2P2Nonfinancial: str = "NONFIN14A2P2AMT"
        """Total Value of Issues, with a Maturity Between 1 and 4 Days, Used in Calculating the A2/P2 Nonfinancial Commercial Paper Rates (in Millions of Dollars)"""

        TotalValueOfIssuesWithMaturityBetween1and4DaysUsedForAANonfinancial: str = "NONFIN14AAAMT"
        """Total Value of Issues, with a Maturity Between 1 and 4 Days, Used in Calculating the AA Nonfinancial Commercial Paper Rates (in Millions of Dollars)"""

        TotalValueofCommercialPaperIssueswithaMaturityBetween1and4Days: str = "MKT14MKTAMT"
        """Total Value of Commercial Paper Issues with a Maturity Between 1 and 4 Days (in Millions of Dollars)"""

        TotalValueOfIssuesWithMaturityBetween10And20DaysUsedForA2P2Nonfinancial: str = "NONFIN1020A2P2AMT"
        """Total Value of Issues, with a Maturity Between 10 and 20 Days, Used in Calculating the A2/P2 Nonfinancial Commercial Paper Rates (in Millions of Dollars)"""

        NumberOfIssuesWithMaturityGreaterThan80DaysUsedForAAFinancial: str = "FINGT80AAVOL"
        """Number of Issues, with a Maturity Greater Than 80 Days, Used in Calculating the AA Financial Commercial Paper Rates (in Number)"""

        NumberOfIssuesWithMaturityBetween10And20DaysUsedForAAFinancial: str = "FIN1020AAVOL"
        """Number of Issues, with a Maturity Between 10 and 20 Days, Used in Calculating the AA Financial Commercial Paper Rates (in Number)"""

        TotalValueOfIssuesWithMaturityBetween1and4DaysUsedForAAFinancial: str = "FIN14AAAMT"
        """Total Value of Issues, with a Maturity Between 1 and 4 Days, Used in Calculating the AA Financial Commercial Paper Rates (in Millions of Dollars)"""

        NumberOfIssuesWithMaturityBetween1and4DaysUsedForAAFinancial: str = "FIN14AAVOL"
        """Number of Issues, with a Maturity Between 1 and 4 Days, Used in Calculating the AA Financial Commercial Paper Rates (in Number)"""

        TotalValueofCommercialPaperIssueswithaMaturityBetween10And20Days: str = "MKT1020MKTAMT"
        """Total Value of Commercial Paper Issues with a Maturity Between 10 and 20 Days (in Millions of Dollars)"""

        NumberofCommercialPaperIssueswithaMaturityBetween10And20Days: str = "MKT1020MKTVOL"
        """Number of Commercial Paper Issues with a Maturity Between 10 and 20 Days (in Number)"""

        TotalValueOfIssuesWithMaturityBetween21and40DaysUsedForAAFinancial: str = "FIN2140AAAMT"
        """Total Value of Issues, with a Maturity Between 21 and 40 Days, Used in Calculating the AA Financial Commercial Paper Rates (in Millions of Dollars)"""

        NumberofCommercialPaperIssueswithaMaturityBetween1and4Days: str = "MKT14MKTVOL"
        """Number of Commercial Paper Issues with a Maturity Between 1 and 4 Days (in Number)"""

        TotalValueofIssuersofCommercialPaperwithaMaturityBetween21and40Days: str = "MKT2140MKTAMT"
        """Total Value of Issuers of Commercial Paper with a Maturity Between 21 and 40 Days (in Millions of Dollars)"""

        NumberofCommercialPaperIssueswithaMaturityBetween21and40Days: str = "MKT2140MKTVOL"
        """Number of Commercial Paper Issues with a Maturity Between 21 and 40 Days (in Number)"""

        NumberOfIssuesWithMaturityBetween21and40DaysUsedForAAFinancial: str = "FIN2140AAVOL"
        """Number of Issues, with a Maturity Between 21 and 40 Days, Used in Calculating the AA Financial Commercial Paper Rates (in Number)"""

        TotalValueofIssuersofCommercialPaperwithaMaturityBetween41and80Days: str = "MKT4180MKTAMT"
        """Total Value of Issuers of Commercial Paper with a Maturity Between 41 and 80 Days (in Millions of Dollars)"""

        TotalValueOfIssuesWithMaturityBetween5and9DaysUsedForAANonfinancial: str = "NONFIN59AAAMT"
        """Total Value of Issues, with a Maturity Between 5 and 9 Days, Used in Calculating the AA Nonfinancial Commercial Paper Rates (in Millions of Dollars)"""

        NumberofCommercialPaperIssueswithaMaturityBetween41and80Days: str = "MKT4180MKTVOL"
        """Number of Commercial Paper Issues with a Maturity Between 41 and 80 Days (in Number)"""

        NumberofCommercialPaperIssueswithaMaturityBetween5and9Days: str = "MKT59MKTVOL"
        """Number of Commercial Paper Issues with a Maturity Between 5 and 9 Days (in Number)"""

        TotalValueofIssuersofCommercialPaperwithaMaturityGreaterThan80Days: str = "MKTGT80MKTAMT"
        """Total Value of Issuers of Commercial Paper with a Maturity Greater Than 80 Days (in Millions of Dollars)"""

        NumberofCommercialPaperIssueswithaMaturityGreaterThan80Days: str = "MKTGT80MKTVOL"
        """Number of Commercial Paper Issues with a Maturity Greater Than 80 Days (in Number)"""

        TotalValueOfIssuesWithMaturityBetween41and80DaysUsedForAAFinancial: str = "FIN4180AAAMT"
        """Total Value of Issues, with a Maturity Between 41 and 80 Days, Used in Calculating the AA Financial Commercial Paper Rates (in Millions of Dollars)"""

        NumberOfIssuesWithMaturityBetween41and80DaysUsedForAAFinancial: str = "FIN4180AAVOL"
        """Number of Issues, with a Maturity Between 41 and 80 Days, Used in Calculating the AA Financial Commercial Paper Rates (in Number)"""

        TotalValueOfIssuesWithMaturityBetween41and80DaysUsedForAAAssetBacked: str = "AB4180AAAMT"
        """Total Value of Issues, with a Maturity Between 41 and 80 Days, Used in Calculating the AA Asset-Backed Commercial Paper Rates (in Millions of Dollars)"""

        TotalValueOfIssuesWithMaturityBetween5and9DaysUsedForAAFinancial: str = "FIN59AAAMT"
        """Total Value of Issues, with a Maturity Between 5 and 9 Days, Used in Calculating the AA Financial Commercial Paper Rates (in Millions of Dollars)"""

        NumberOfIssuesWithMaturityBetween5and9DaysUsedForAAFinancial: str = "FIN59AAVOL"
        """Number of Issues, with a Maturity Between 5 and 9 Days, Used in Calculating the AA Financial Commercial Paper Rates (in Number)"""

        TotalValueOfIssuesWithMaturityGreaterThan80DaysUsedForAAFinancial: str = "FINGT80AAAMT"
        """Total Value of Issues, with a Maturity Greater Than 80 Days, Used in Calculating the AA Financial Commercial Paper Rates (in Millions of Dollars)"""

        TotalValueOfIssuesWithMaturityBetween10And20DaysUsedForAAFinancial: str = "FIN1020AAAMT"
        """Total Value of Issues, with a Maturity Between 10 and 20 Days, Used in Calculating the AA Financial Commercial Paper Rates (in Millions of Dollars)"""

        NumberOfIssuesWithMaturityBetween21and40DaysUsedForAAAssetBacked: str = "AB2140AAVOL"
        """Number of Issues, with a Maturity Between 21 and 40 Days, Used in Calculating the AA Asset-Backed Commercial Paper Rates (in Number)"""

        TotalValueofIssuersofCommercialPaperwithaMaturityBetween5and9Days: str = "MKT59MKTAMT"
        """Total Value of Issuers of Commercial Paper with a Maturity Between 5 and 9 Days (in Millions of Dollars)"""

        NumberOfIssuesWithMaturityGreaterThan80DaysUsedForAAAssetBacked: str = "ABGT80AAVOL"
        """Number of Issues, with a Maturity Greater Than 80 Days, Used in Calculating the AA Asset-Backed Commercial Paper Rates (in Number)"""

        NumberOfIssuesWithMaturityBetween5and9DaysUsedForAANonfinancial: str = "NONFIN59AAVOL"
        """Number of Issues, with a Maturity Between 5 and 9 Days, Used in Calculating the AA Nonfinancial Commercial Paper Rates (in Number)"""

        FifteenDayAAAssetbackedCommercialPaperInterestRate: str = "RIFSPPAAAD15NB"
        """15-Day AA Asset-backed Commercial Paper Interest Rate (in Percent)"""

        TotalValueOfIssuesWithMaturityBetween5and9DaysUsedForAAAssetBacked: str = "AB59AAAMT"
        """Total Value of Issues, with a Maturity Between 5 and 9 Days, Used in Calculating the AA Asset-Backed Commercial Paper Rates (in Millions of Dollars)"""

        NumberOfIssuesWithMaturityBetween41and80DaysUsedForAAAssetBacked: str = "AB4180AAVOL"
        """Number of Issues, with a Maturity Between 41 and 80 Days, Used in Calculating the AA Asset-Backed Commercial Paper Rates (in Number)"""

        FifteenDayA2P2NonfinancialCommercialPaperInterestRate: str = "RIFSPPNA2P2D15NB"
        """15-Day A2/P2 Nonfinancial Commercial Paper Interest Rate (in Percent)"""

        SevenDayA2P2NonfinancialCommercialPaperInterestRate: str = "RIFSPPNA2P2D07NB"
        """7-Day A2/P2 Nonfinancial Commercial Paper Interest Rate (in Percent)"""

        OvernightA2P2NonfinancialCommercialPaperInterestRate: str = "RIFSPPNA2P2D01NB"
        """Overnight A2/P2 Nonfinancial Commercial Paper Interest Rate (in Percent)"""

        NinetyDayAAFinancialCommercialPaperInterestRate: str = "RIFSPPFAAD90NB"
        """90-Day AA Financial Commercial Paper Interest Rate (in Percent)"""

        OvernightAAAssetbackedCommercialPaperInterestRate: str = "RIFSPPAAAD01NB"
        """Overnight AA Asset-backed Commercial Paper Interest Rate (in Percent)"""

        Three0DayA2P2NonfinancialCommercialPaperInterestRate: str = "RIFSPPNA2P2D30NB"
        """30-Day A2/P2 Nonfinancial Commercial Paper Interest Rate (in Percent)"""

        SixtyDayAAFinancialCommercialPaperInterestRate: str = "RIFSPPFAAD60NB"
        """60-Day AA Financial Commercial Paper Interest Rate (in Percent)"""

        Three0DayAAFinancialCommercialPaperInterestRate: str = "RIFSPPFAAD30NB"
        """30-Day AA Financial Commercial Paper Interest Rate (in Percent)"""

        TotalValueOfIssuesWithMaturityGreaterThan80DaysUsedForA2P2Nonfinancial: str = "NONFINGT80A2P2AMT"
        """Total Value of Issues, with a Maturity Greater Than 80 Days, Used in Calculating the A2/P2 Nonfinancial Commercial Paper Rates (in Millions of Dollars)"""

        Three0DayAAAssetbackedCommercialPaperInterestRate: str = "RIFSPPAAAD30NB"
        """30-Day AA Asset-backed Commercial Paper Interest Rate (in Percent)"""

        SixtyDayAAAssetbackedCommercialPaperInterestRate: str = "RIFSPPAAAD60NB"
        """60-Day AA Asset-backed Commercial Paper Interest Rate (in Percent)"""

        NinetyDayAAAssetbackedCommercialPaperInterestRate: str = "RIFSPPAAAD90NB"
        """90-Day AA Asset-backed Commercial Paper Interest Rate (in Percent)"""

        FifteenDayAAFinancialCommercialPaperInterestRate: str = "RIFSPPFAAD15NB"
        """15-Day AA Financial Commercial Paper Interest Rate (in Percent)"""

        SevenDayAAFinancialCommercialPaperInterestRate: str = "RIFSPPFAAD07NB"
        """7-Day AA Financial Commercial Paper Interest Rate (in Percent)"""

        SevenDayAAAssetbackedCommercialPaperInterestRate: str = "RIFSPPAAAD07NB"
        """7-Day AA Asset-backed Commercial Paper Interest Rate (in Percent)"""

        OvernightAAFinancialCommercialPaperInterestRate: str = "RIFSPPFAAD01NB"
        """Overnight AA Financial Commercial Paper Interest Rate (in Percent)"""

        SixtyDayA2P2NonfinancialCommercialPaperInterestRate: str = "RIFSPPNA2P2D60NB"
        """60-Day A2/P2 Nonfinancial Commercial Paper Interest Rate (in Percent)"""

        NumberOfIssuesWithMaturityBetween5and9DaysUsedForAAAssetBacked: str = "AB59AAVOL"
        """Number of Issues, with a Maturity Between 5 and 9 Days, Used in Calculating the AA Asset-Backed Commercial Paper Rates (in Number)"""

        NumberOfIssuesWithMaturityBetween1and4DaysUsedForAAAssetBacked: str = "AB14AAVOL"
        """Number of Issues, with a Maturity Between 1 and 4 Days, Used in Calculating the AA Asset-Backed Commercial Paper Rates (in Number)"""

        NumberOfIssuesWithMaturityGreaterThan80DaysUsedForA2P2Nonfinancial: str = "NONFINGT80A2P2VOL"
        """Number of Issues, with a Maturity Greater Than 80 Days, Used in Calculating the A2/P2 Nonfinancial Commercial Paper Rates (in Number)"""

        TotalValueOfIssuesWithMaturityBetween1and4DaysUsedForAAAssetBacked: str = "AB14AAAMT"
        """Total Value of Issues, with a Maturity Between 1 and 4 Days, Used in Calculating the AA Asset-Backed Commercial Paper Rates (in Millions of Dollars)"""

        NinetyDayA2P2NonfinancialCommercialPaperInterestRate: str = "RIFSPPNA2P2D90NB"
        """90-Day A2/P2 Nonfinancial Commercial Paper Interest Rate (in Percent)"""

        NumberOfIssuesWithMaturityBetween10And20DaysUsedForAAAssetBacked: str = "AB1020AAVOL"
        """Number of Issues, with a Maturity Between 10 and 20 Days, Used in Calculating the AA Asset-Backed Commercial Paper Rates (in Number)"""

        TotalValueOfIssuesWithMaturityGreaterThan80DaysUsedForAANonfinancial: str = "NONFINGT80AAAMT"
        """Total Value of Issues, with a Maturity Greater Than 80 Days, Used in Calculating the AA Nonfinancial Commercial Paper Rates (in Millions of Dollars)"""

        OvernightAANonfinancialCommercialPaperInterestRate: str = "RIFSPPNAAD01NB"
        """Overnight AA Nonfinancial Commercial Paper Interest Rate (in Percent)"""

        TotalValueOfIssuesWithMaturityBetween10And20DaysUsedForAAAssetBacked: str = "AB1020AAAMT"
        """Total Value of Issues, with a Maturity Between 10 and 20 Days, Used in Calculating the AA Asset-Backed Commercial Paper Rates (in Millions of Dollars)"""

        SevenDayAANonfinancialCommercialPaperInterestRate: str = "RIFSPPNAAD07NB"
        """7-Day AA Nonfinancial Commercial Paper Interest Rate (in Percent)"""

        NinetyDayAANonfinancialCommercialPaperInterestRate: str = "RIFSPPNAAD90NB"
        """90-Day AA Nonfinancial Commercial Paper Interest Rate (in Percent)"""

        FifteenDayAANonfinancialCommercialPaperInterestRate: str = "RIFSPPNAAD15NB"
        """15-Day AA Nonfinancial Commercial Paper Interest Rate (in Percent)"""

        Three0DayAANonfinancialCommercialPaperInterestRate: str = "RIFSPPNAAD30NB"
        """30-Day AA Nonfinancial Commercial Paper Interest Rate (in Percent)"""

        SixtyDayAANonfinancialCommercialPaperInterestRate: str = "RIFSPPNAAD60NB"
        """60-Day AA Nonfinancial Commercial Paper Interest Rate (in Percent)"""

        NumberOfIssuesWithMaturityGreaterThan80DaysUsedForAANonfinancial: str = "NONFINGT80AAVOL"
        """Number of Issues, with a Maturity Greater Than 80 Days, Used in Calculating the AA Nonfinancial Commercial Paper Rates (in Number)"""

        ThreeMonthCommercialPaperMinusFederalFundsRate: str = "CPFF"
        """3-Month Commercial Paper Minus Federal Funds Rate (in Percent)"""

    class LIBOR(System.Object):
        """London InterBank Offered Rate"""

        SpotNextBasedOnSwissFranc: str = "CHFONTD156N"
        """Spot Next London Interbank Offered Rate (LIBOR), based on Swiss Franc (in Percent)"""

        SpotNextBasedOnJapaneseYen: str = "JPYONTD156N"
        """Spot Next London Interbank Offered Rate (LIBOR), based on Japanese Yen (in Percent)"""

        SixMonthBasedOnJapaneseYen: str = "JPY6MTD156N"
        """6-Month London Interbank Offered Rate (LIBOR), based on Japanese Yen (in Percent)"""

        ThreeMonthBasedOnJapaneseYen: str = "JPY3MTD156N"
        """3-Month London Interbank Offered Rate (LIBOR), based on Japanese Yen (in Percent)"""

        SixMonthBasedOnUSD: str = "USD6MTD156N"
        """6-Month London Interbank Offered Rate (LIBOR), based on U.S. Dollar (in Percent)"""

        OneMonthBasedOnJapaneseYen: str = "JPY1MTD156N"
        """1-Month London Interbank Offered Rate (LIBOR), based on Japanese Yen (in Percent)"""

        TwelveMonthBasedOnJapaneseYen: str = "JPY12MD156N"
        """12-Month London Interbank Offered Rate (LIBOR), based on Japanese Yen (in Percent)"""

        TwelveMonthBasedOnBritishPound: str = "GBP12MD156N"
        """12-Month London Interbank Offered Rate (LIBOR), based on British Pound (in Percent)"""

        OneMonthBasedOnBritishPound: str = "GBP1MTD156N"
        """1-Month London Interbank Offered Rate (LIBOR), based on British Pound (in Percent)"""

        OneWeekBasedOnBritishPound: str = "GBP1WKD156N"
        """1-Week London Interbank Offered Rate (LIBOR), based on British Pound (in Percent)"""

        TwoMonthBasedOnBritishPound: str = "GBP2MTD156N"
        """2-Month London Interbank Offered Rate (LIBOR), based on British Pound (in Percent)"""

        ThreeMonthBasedOnBritishPound: str = "GBP3MTD156N"
        """3-Month London Interbank Offered Rate (LIBOR), based on British Pound (in Percent)"""

        OneWeekBasedOnJapaneseYen: str = "JPY1WKD156N"
        """1-Week London Interbank Offered Rate (LIBOR), based on Japanese Yen (in Percent)"""

        TwoMonthBasedOnJapaneseYen: str = "JPY2MTD156N"
        """2-Month London Interbank Offered Rate (LIBOR), based on Japanese Yen (in Percent)"""

        SixMonthBasedOnSwissFranc: str = "CHF6MTD156N"
        """6-Month London Interbank Offered Rate (LIBOR), based on Swiss Franc (in Percent)"""

        ThreeMonthBasedOnSwissFranc: str = "CHF3MTD156N"
        """3-Month London Interbank Offered Rate (LIBOR), based on Swiss Franc (in Percent)"""

        OneMonthBasedOnUSD: str = "USD1MTD156N"
        """1-Month London Interbank Offered Rate (LIBOR), based on U.S. Dollar (in Percent)"""

        TwelveMonthBasedOnSwissFranc: str = "CHF12MD156N"
        """12-Month London Interbank Offered Rate (LIBOR), based on Swiss Franc (in Percent)"""

        TwelveMonthBasedOnUSD: str = "USD12MD156N"
        """12-Month London Interbank Offered Rate (LIBOR), based on U.S. Dollar (in Percent)"""

        OneMonthBasedOnSwissFranc: str = "CHF1MTD156N"
        """1-Month London Interbank Offered Rate (LIBOR), based on Swiss Franc (in Percent)"""

        OneWeekBasedOnSwissFranc: str = "CHF1WKD156N"
        """1-Week London Interbank Offered Rate (LIBOR), based on Swiss Franc (in Percent)"""

        TwoMonthBasedOnSwissFranc: str = "CHF2MTD156N"
        """2-Month London Interbank Offered Rate (LIBOR), based on Swiss Franc (in Percent)"""

        TwelveMonthBasedOnEuro: str = "EUR12MD156N"
        """12-Month London Interbank Offered Rate (LIBOR), based on Euro (in Percent)"""

        SixMonthBasedOnBritishPound: str = "GBP6MTD156N"
        """6-Month London Interbank Offered Rate (LIBOR), based on British Pound (in Percent)"""

        OneMonthBasedOnEuro: str = "EUR1MTD156N"
        """1-Month London Interbank Offered Rate (LIBOR), based on Euro (in Percent)"""

        TwoMonthBasedOnEuro: str = "EUR2MTD156N"
        """2-Month London Interbank Offered Rate (LIBOR), based on Euro (in Percent)"""

        ThreeMonthBasedOnEuro: str = "EUR3MTD156N"
        """3-Month London Interbank Offered Rate (LIBOR), based on Euro (in Percent)"""

        SixMonthBasedOnEuro: str = "EUR6MTD156N"
        """6-Month London Interbank Offered Rate (LIBOR), based on Euro (in Percent)"""

        OvernightBasedOnEuro: str = "EURONTD156N"
        """Overnight London Interbank Offered Rate (LIBOR), based on Euro (in Percent)"""

        OneWeekBasedOnUSD: str = "USD1WKD156N"
        """1-Week London Interbank Offered Rate (LIBOR), based on U.S. Dollar (in Percent)"""

        TwoMonthBasedOnUSD: str = "USD2MTD156N"
        """2-Month London Interbank Offered Rate (LIBOR), based on U.S. Dollar (in Percent)"""

        ThreeMonthBasedOnUSD: str = "USD3MTD156N"
        """3-Month London Interbank Offered Rate (LIBOR), based on U.S. Dollar (in Percent)"""

        OvernightBasedOnUSD: str = "USDONTD156N"
        """Overnight London Interbank Offered Rate (LIBOR), based on U.S. Dollar (in Percent)"""

        OneWeekBasedOnEuro: str = "EUR1WKD156N"
        """1-Week London Interbank Offered Rate (LIBOR), based on Euro (in Percent)"""

        OvernightBasedOnBritishPound: str = "GBPONTD156N"
        """Overnight London Interbank Offered Rate (LIBOR), based on British Pound (in Percent)"""

    class CBOE(System.Object):
        """Chicago Board Options Exchange"""

        VIXOnGoogle: str = "VXGOGCLS"
        """CBOE Equity VIX on Google (in Index)"""

        VXD: str = "VXDCLS"
        """CBOE DJIA Volatility Index (in Index)"""

        VIXOnGoldmanSachs: str = "VXGSCLS"
        """CBOE Equity VIX on Goldman Sachs (in Index)"""

        VIXOnIBM: str = "VXIBMCLS"
        """CBOE Equity VIX on IBM (in Index)"""

        VIXOnAmazon: str = "VXAZNCLS"
        """CBOE Equity VIX on Amazon (in Index)"""

        VXO: str = "VXOCLS"
        """CBOE S&P 100 Volatility Index: VXO (in Index)"""

        VXN: str = "VXNCLS"
        """CBOE NASDAQ 100 Volatility Index (in Index)"""

        TenYearTreasuryNoteVolatilityFutures: str = "VXTYN"
        """CBOE 10-Year Treasury Note Volatility Futures (in Index)"""

        RVX: str = "RVXCLS"
        """CBOE Russell 2000 Volatility Index (in Index)"""

        SP500ThreeMonthVolatilityIndex: str = "VXVCLS"
        """CBOE S&P 500 3-Month Volatility Index (in Index)"""

        VIXOnApple: str = "VXAPLCLS"
        """CBOE Equity VIX on Apple (in Index)"""

        GoldMinersETFVolatilityIndex: str = "VXGDXCLS"
        """CBOE Gold Miners ETF Volatility Index (in Index)"""

        ChinaETFVolatilityIndex: str = "VXFXICLS"
        """CBOE China ETF Volatility Index (in Index)"""

        BrazilETFVolatilityIndex: str = "VXEWZCLS"
        """CBOE Brazil ETF Volatility Index (in Index)"""

        EmergingMarketsETFVolatilityIndex: str = "VXEEMCLS"
        """CBOE Emerging Markets ETF Volatility Index (in Index)"""

        EuroCurrencyETFVolatilityIndex: str = "EVZCLS"
        """CBOE EuroCurrency ETF Volatility Index (in Index)"""

        GoldETFVolatilityIndex: str = "GVZCLS"
        """CBOE Gold ETF Volatility Index (in Index)"""

        CrudeOilETFVolatilityIndex: str = "OVXCLS"
        """CBOE Crude Oil ETF Volatility Index (in Index)"""

        SilverETFVolatilityIndex: str = "VXSLVCLS"
        """CBOE Silver ETF Volatility Index (in Index)"""

        EnergySectorETFVolatilityIndex: str = "VXXLECLS"
        """CBOE Energy Sector ETF Volatility Index (in Index)"""

        VIX: str = "VIXCLS"
        """CBOE Volatility Index: VIX (in Index)"""

    class ICEBofAML(System.Object):
        """ICE BofAML"""

        AAAAEmergingMarketsCorporatePlusSubIndexTotalReturnIndexValue: str = "BAMLEM1BRRAAA2ACRPITRIV"
        """ICE BofAML AAA-A Emerging Markets Corporate Plus Sub-Index Total Return Index Value (in Index)"""

        AAAAUSEmergingMarketsLiquidCorporatePlusSubIndexTotalReturnIndexValue: str = "BAMLEM1RAAA2ALCRPIUSTRIV"
        """ICE BofAML AAA-A US Emerging Markets Liquid Corporate Plus Sub-Index Total Return Index Value (in Index)"""

        AsiaEmergingMarketsCorporatePlusSubIndexTotalReturnIndexValue: str = "BAMLEMRACRPIASIATRIV"
        """ICE BofAML Asia Emerging Markets Corporate Plus Sub-Index Total Return Index Value (in Index)"""

        AsiaUSEmergingMarketsLiquidCorporatePlusSubIndexTotalReturnIndexValue: str = "BAMLEMALLCRPIASIAUSTRIV"
        """ICE BofAML Asia US Emerging Markets Liquid Corporate Plus Sub-Index Total Return Index Value (in Index)"""

        BandLowerEmergingMarketsCorporatePlusSubIndexTotalReturnIndexValue: str = "BAMLEM4BRRBLCRPITRIV"
        """ICE BofAML B and Lower Emerging Markets Corporate Plus Sub-Index Total Return Index Value (in Index)"""

        BandLowerUSEmergingMarketsLiquidCorporatePlusSubIndexTotalReturnIndexValue: str = "BAMLEM4RBLLCRPIUSTRIV"
        """ICE BofAML B and Lower US Emerging Markets Liquid Corporate Plus Sub-Index Total Return Index Value (in Index)"""

        BBEmergingMarketsCorporatePlusSubIndexTotalReturnIndexValue: str = "BAMLEM3BRRBBCRPITRIV"
        """ICE BofAML BB Emerging Markets Corporate Plus Sub-Index Total Return Index Value (in Index)"""

        BBUSEmergingMarketsLiquidCorporatePlusSubIndexTotalReturnIndexValue: str = "BAMLEM3RBBLCRPIUSTRIV"
        """ICE BofAML BB US Emerging Markets Liquid Corporate Plus Sub-Index Total Return Index Value (in Index)"""

        BBBEmergingMarketsCorporatePlusSubIndexTotalReturnIndexValue: str = "BAMLEM2BRRBBBCRPITRIV"
        """ICE BofAML BBB Emerging Markets Corporate Plus Sub-Index Total Return Index Value (in Index)"""

        BBBUSEmergingMarketsLiquidCorporatePlusSubIndexTotalReturnIndexValue: str = "BAMLEM2RBBBLCRPIUSTRIV"
        """ICE BofAML BBB US Emerging Markets Liquid Corporate Plus Sub-Index Total Return Index Value (in Index)"""

        CrossoverEmergingMarketsCorporatePlusSubIndexTotalReturnIndexValue: str = "BAMLEM5BCOCRPITRIV"
        """ICE BofAML Crossover Emerging Markets Corporate Plus Sub-Index Total Return Index Value (in Index)"""

        CrossoverUSEmergingMarketsLiquidCorporatePlusSubIndexTotalReturnIndexValue: str = "BAMLEMXOCOLCRPIUSTRIV"
        """ICE BofAML Crossover US Emerging Markets Liquid Corporate Plus Sub-Index Total Return Index Value (in Index)"""

        EmergingMarketsCorporatePlusIndexTotalReturnIndexValue: str = "BAMLEMCBPITRIV"
        """ICE BofAML Emerging Markets Corporate Plus Index Total Return Index Value (in Index)"""

        EuroEmergingMarketsCorporatePlusSubIndexTotalReturnIndexValue: str = "BAMLEMEBCRPIETRIV"
        """ICE BofAML Euro Emerging Markets Corporate Plus Sub-Index Total Return Index Value (in Index)"""

        EMEAEmergingMarketsCorporatePlusSubIndexTotalReturnIndexValue: str = "BAMLEMRECRPIEMEATRIV"
        """ICE BofAML Europe, the Middle East, and Africa (EMEA) Emerging Markets Corporate Plus Sub-Index Total Return Index Value (in Index)"""

        EMEAUSEmergingMarketsLiquidCorporatePlusSubIndexTotalReturnIndexValue: str = "BAMLEMELLCRPIEMEAUSTRIV"
        """ICE BofAML Europe, the Middle East, and Africa (EMEA) US Emerging Markets Liquid Corporate Plus Sub-Index Total Return Index Value (in Index)"""

        FinancialEmergingMarketsCorporatePlusSubIndexTotalReturnIndexValue: str = "BAMLEMFSFCRPITRIV"
        """ICE BofAML Financial Emerging Markets Corporate Plus Sub-Index Total Return Index Value (in Index)"""

        FinancialUSEmergingMarketsLiquidCorporatePlusSubIndexTotalReturnIndexValue: str = "BAMLEMFLFLCRPIUSTRIV"
        """ICE BofAML Financial US Emerging Markets Liquid Corporate Plus Sub-Index Total Return Index Value (in Index)"""

        HighGradeEmergingMarketsCorporatePlusSubIndexTotalReturnIndexValue: str = "BAMLEMIBHGCRPITRIV"
        """ICE BofAML High Grade Emerging Markets Corporate Plus Sub-Index Total Return Index Value (in Index)"""

        HighGradeUSEmergingMarketsLiquidCorporatePlusSubIndexTotalReturnIndexValue: str = "BAMLEMHGHGLCRPIUSTRIV"
        """ICE BofAML High Grade US Emerging Markets Liquid Corporate Plus Sub-Index Total Return Index Value (in Index)"""

        HighYieldEmergingMarketsCorporatePlusSubIndexTotalReturnIndexValue: str = "BAMLEMHBHYCRPITRIV"
        """ICE BofAML High Yield Emerging Markets Corporate Plus Sub-Index Total Return Index Value (in Index)"""

        HighYieldUSEmergingMarketsLiquidCorporatePlusSubIndexTotalReturnIndexValue: str = "BAMLEMHYHYLCRPIUSTRIV"
        """ICE BofAML High Yield US Emerging Markets Liquid Corporate Plus Sub-Index Total Return Index Value (in Index)"""

        LatinAmericaEmergingMarketsCorporatePlusSubIndexTotalReturnIndexValue: str = "BAMLEMRLCRPILATRIV"
        """ICE BofAML Latin America Emerging Markets Corporate Plus Sub-Index Total Return Index Value (in Index)"""

        LatinAmericaUSEmergingMarketsLiquidCorporatePlusSubIndexTotalReturnIndexValue: str = "BAMLEMLLLCRPILAUSTRIV"
        """ICE BofAML Latin America US Emerging Markets Liquid Corporate Plus Sub-Index Total Return Index Value (in Index)"""

        NonFinancialEmergingMarketsCorporatePlusSubIndexTotalReturnIndexValue: str = "BAMLEMNSNFCRPITRIV"
        """ICE BofAML Non-Financial Emerging Markets Corporate Plus Sub-Index Total Return Index Value (in Index)"""

        NonFinancialUSEmergingMarketsLiquidCorporatePlusSubIndexTotalReturnIndexValue: str = "BAMLEMNFNFLCRPIUSTRIV"
        """ICE BofAML Non-Financial US Emerging Markets Liquid Corporate Plus Sub-Index Total Return Index Value (in Index)"""

        USCorporateMasterOptionAdjustedSpread: str = "BAMLC0A0CM"
        """ICE BofAML US Corporate Master Option-Adjusted Spread (in Percent)"""

        USHighYieldMasterIIOptionAdjustedSpread: str = "BAMLH0A0HYM2"
        """ICE BofAML US High Yield Master II Option-Adjusted Spread (in Percent)"""

        USCorporate1To3YearOptionAdjustedSpread: str = "BAMLC1A0C13Y"
        """ICE BofAML US Corporate 1-3 Year Option-Adjusted Spread (in Percent)"""

        USCorporate10To15YearOptionAdjustedSpread: str = "BAMLC7A0C1015Y"
        """ICE BofAML US Corporate 10-15 Year Option-Adjusted Spread (in Percent)"""

        USCorporateMoreThan15YearOptionAdjustedSpread: str = "BAMLC8A0C15PY"
        """ICE BofAML US Corporate 15+ Year Option-Adjusted Spread (in Percent)"""

        USCorporate3To5YearOptionAdjustedSpread: str = "BAMLC2A0C35Y"
        """ICE BofAML US Corporate 3-5 Year Option-Adjusted Spread (in Percent)"""

        USCorporate5To7YearOptionAdjustedSpread: str = "BAMLC3A0C57Y"
        """ICE BofAML US Corporate 5-7 Year Option-Adjusted Spread (in Percent)"""

        USCorporate7To10YearOptionAdjustedSpread: str = "BAMLC4A0C710Y"
        """ICE BofAML US Corporate 7-10 Year Option-Adjusted Spread (in Percent)"""

        PublicSectorIssuersUSEmergingMarketsLiquidCorporatePlusSubIndexTotalReturnIndexValue: str = "BAMLEMPUPUBSLCRPIUSTRIV"
        """ICE BofAML Public Sector Issuers US Emerging Markets Liquid Corporate Plus Sub-Index Total Return Index Value (in Index)"""

        USEmergingMarketsCorporatePlusSubIndexTotalReturnIndexValue: str = "BAMLEMUBCRPIUSTRIV"
        """ICE BofAML US Emerging Markets Corporate Plus Sub-Index Total Return Index Value (in Index)"""

        USEmergingMarketsLiquidCorporatePlusIndexTotalReturnIndexValue: str = "BAMLEMCLLCRPIUSTRIV"
        """ICE BofAML US Emerging Markets Liquid Corporate Plus Index Total Return Index Value (in Index)"""

        EuroHighYieldIndexTotalReturnIndexValue: str = "BAMLHE00EHYITRIV"
        """ICE BofAML Euro High Yield Index Total Return Index Value (in Index)"""

        USCorp1To3YearsTotalReturnIndexValue: str = "BAMLCC1A013YTRIV"
        """ICE BofAML US Corp 1-3yr Total Return Index Value (in Index)"""

        USCorp10To15TotalReturnIndexValue: str = "BAMLCC7A01015YTRIV"
        """ICE BofAML US Corp 10-15yr Total Return Index Value (in Index)"""

        USCorpMoreThan15YearsTotalReturnIndexValue: str = "BAMLCC8A015PYTRIV"
        """ICE BofAML US Corp 15+yr Total Return Index Value (in Index)"""

        USCorpeTo5YearsTotalReturnIndexValue: str = "BAMLCC2A035YTRIV"
        """ICE BofAML US Corp 3-5yr Total Return Index Value (in Index)"""

        USCorp5To7YearsTotalReturnIndexValue: str = "BAMLCC3A057YTRIV"
        """ICE BofAML US Corp 5-7yr Total Return Index Value (in Index)"""

        USCorporate7To10YearsTotalReturnIndexValue: str = "BAMLCC4A0710YTRIV"
        """ICE BofAML US Corporate 7-10yr Total Return Index Value (in Index)"""

        USCorpATotalReturnIndexValue: str = "BAMLCC0A3ATRIV"
        """ICE BofAML US Corp A Total Return Index Value (in Index)"""

        USCorpAATotalReturnIndexValue: str = "BAMLCC0A2AATRIV"
        """ICE BofAML US Corp AA Total Return Index Value (in Index)"""

        USCorpAAATotalReturnIndexValue: str = "BAMLCC0A1AAATRIV"
        """ICE BofAML US Corp AAA Total Return Index Value (in Index)"""

        USHighYieldBTotalReturnIndexValue: str = "BAMLHYH0A2BTRIV"
        """ICE BofAML US High Yield B Total Return Index Value (in Index)"""

        USHighYieldBBTotalReturnIndexValue: str = "BAMLHYH0A1BBTRIV"
        """ICE BofAML US High Yield BB Total Return Index Value (in Index)"""

        USCorpBBBTotalReturnIndexValue: str = "BAMLCC0A4BBBTRIV"
        """ICE BofAML US Corp BBB Total Return Index Value (in Index)"""

        USHighYieldCCCorBelowTotalReturnIndexValue: str = "BAMLHYH0A3CMTRIV"
        """ICE BofAML US High Yield CCC or Below Total Return Index Value (in Index)"""

        USCorpMasterTotalReturnIndexValue: str = "BAMLCC0A0CMTRIV"
        """ICE BofAML US Corp Master Total Return Index Value (in Index)"""

        USHighYieldMasterIITotalReturnIndexValue: str = "BAMLHYH0A0HYM2TRIV"
        """ICE BofAML US High Yield Master II Total Return Index Value (in Index)"""

        AAAAEmergingMarketsCorporatePlusSubIndexOptionAdjustedSpread: str = "BAMLEM1BRRAAA2ACRPIOAS"
        """ICE BofAML AAA-A Emerging Markets Corporate Plus Sub-Index Option-Adjusted Spread (in Percent)"""

        AAAAUSEmergingMarketsLiquidCorporatePlusSubIndexOptionAdjustedSpread: str = "BAMLEM1RAAA2ALCRPIUSOAS"
        """ICE BofAML AAA-A US Emerging Markets Liquid Corporate Plus Sub-Index Option-Adjusted Spread (in Percent)"""

        AsiaEmergingMarketsCorporatePlusSubIndexOptionAdjustedSpread: str = "BAMLEMRACRPIASIAOAS"
        """ICE BofAML Asia Emerging Markets Corporate Plus Sub-Index Option-Adjusted Spread (in Percent)"""

        AsiaUSEmergingMarketsLiquidCorporatePlusSubIndexOptionAdjustedSpread: str = "BAMLEMALLCRPIASIAUSOAS"
        """ICE BofAML Asia US Emerging Markets Liquid Corporate Plus Sub-Index Option-Adjusted Spread (in Percent)"""

        BandLowerEmergingMarketsCorporatePlusSubIndexOptionAdjustedSpread: str = "BAMLEM4BRRBLCRPIOAS"
        """ICE BofAML B and Lower Emerging Markets Corporate Plus Sub-Index Option-Adjusted Spread (in Percent)"""

        BandLowerUSEmergingMarketsLiquidCorporatePlusSubIndexOptionAdjustedSpread: str = "BAMLEM4RBLLCRPIUSOAS"
        """ICE BofAML B and Lower US Emerging Markets Liquid Corporate Plus Sub-Index Option-Adjusted Spread (in Percent)"""

        BBEmergingMarketsCorporatePlusSubIndexOptionAdjustedSpread: str = "BAMLEM3BRRBBCRPIOAS"
        """ICE BofAML BB Emerging Markets Corporate Plus Sub-Index Option-Adjusted Spread (in Percent)"""

        BBUSEmergingMarketsLiquidCorporatePlusSubIndexOptionAdjustedSpread: str = "BAMLEM3RBBLCRPIUSOAS"
        """ICE BofAML BB US Emerging Markets Liquid Corporate Plus Sub-Index Option-Adjusted Spread (in Percent)"""

        BBBEmergingMarketsCorporatePlusSubIndexOptionAdjustedSpread: str = "BAMLEM2BRRBBBCRPIOAS"
        """ICE BofAML BBB Emerging Markets Corporate Plus Sub-Index Option-Adjusted Spread (in Percent)"""

        BBBUSEmergingMarketsLiquidCorporatePlusSubIndexOptionAdjustedSpread: str = "BAMLEM2RBBBLCRPIUSOAS"
        """ICE BofAML BBB US Emerging Markets Liquid Corporate Plus Sub-Index Option-Adjusted Spread (in Percent)"""

        CrossoverEmergingMarketsCorporatePlusSubIndexOptionAdjustedSpread: str = "BAMLEM5BCOCRPIOAS"
        """ICE BofAML Crossover Emerging Markets Corporate Plus Sub-Index Option-Adjusted Spread (in Percent)"""

        CrossoverUSEmergingMarketsLiquidCorporatePlusSubIndexOptionAdjustedSpread: str = "BAMLEMXOCOLCRPIUSOAS"
        """ICE BofAML Crossover US Emerging Markets Liquid Corporate Plus Sub-Index Option-Adjusted Spread (in Percent)"""

        EmergingMarketsCorporatePlusIndexOptionAdjustedSpread: str = "BAMLEMCBPIOAS"
        """ICE BofAML Emerging Markets Corporate Plus Index Option-Adjusted Spread (in Percent)"""

        EuroEmergingMarketsCorporatePlusSubIndexOptionAdjustedSpread: str = "BAMLEMEBCRPIEOAS"
        """ICE BofAML Euro Emerging Markets Corporate Plus Sub-Index Option-Adjusted Spread (in Percent)"""

        EMEAEmergingMarketsCorporatePlusSubIndexOptionAdjustedSpread: str = "BAMLEMRECRPIEMEAOAS"
        """ICE BofAML Europe, the Middle East, and Africa (EMEA) Emerging Markets Corporate Plus Sub-Index Option-Adjusted Spread (in Percent)"""

        EMEAUSEmergingMarketsLiquidCorporatePlusSubIndexOptionAdjustedSpread: str = "BAMLEMELLCRPIEMEAUSOAS"
        """ICE BofAML Europe, the Middle East, and Africa (EMEA) US Emerging Markets Liquid Corporate Plus Sub-Index Option-Adjusted Spread (in Percent)"""

        FinancialEmergingMarketsCorporatePlusSubIndexOptionAdjustedSpread: str = "BAMLEMFSFCRPIOAS"
        """ICE BofAML Financial Emerging Markets Corporate Plus Sub-Index Option-Adjusted Spread (in Percent)"""

        FinancialUSEmergingMarketsLiquidCorporatePlusSubIndexOptionAdjustedSpread: str = "BAMLEMFLFLCRPIUSOAS"
        """ICE BofAML Financial US Emerging Markets Liquid Corporate Plus Sub-Index Option-Adjusted Spread (in Percent)"""

        HighGradeEmergingMarketsCorporatePlusSubIndexOptionAdjustedSpread: str = "BAMLEMIBHGCRPIOAS"
        """ICE BofAML High Grade Emerging Markets Corporate Plus Sub-Index Option-Adjusted Spread (in Percent)"""

        HighGradeUSEmergingMarketsLiquidCorporatePlusSubIndexOptionAdjustedSpread: str = "BAMLEMHGHGLCRPIUSOAS"
        """ICE BofAML High Grade US Emerging Markets Liquid Corporate Plus Sub-Index Option-Adjusted Spread (in Percent)"""

        HighYieldEmergingMarketsCorporatePlusSubIndexOptionAdjustedSpread: str = "BAMLEMHBHYCRPIOAS"
        """ICE BofAML High Yield Emerging Markets Corporate Plus Sub-Index Option-Adjusted Spread (in Percent)"""

        HighYieldUSEmergingMarketsLiquidCorporatePlusSubIndexOptionAdjustedSpread: str = "BAMLEMHYHYLCRPIUSOAS"
        """ICE BofAML High Yield US Emerging Markets Liquid Corporate Plus Sub-Index Option-Adjusted Spread (in Percent)"""

        LatinAmericaEmergingMarketsCorporatePlusSubIndexOptionAdjustedSpread: str = "BAMLEMRLCRPILAOAS"
        """ICE BofAML Latin America Emerging Markets Corporate Plus Sub-Index Option-Adjusted Spread (in Percent)"""

        LatinAmericaUSEmergingMarketsLiquidCorporatePlusSubIndexOptionAdjustedSpread: str = "BAMLEMLLLCRPILAUSOAS"
        """ICE BofAML Latin America US Emerging Markets Liquid Corporate Plus Sub-Index Option-Adjusted Spread (in Percent)"""

        NonFinancialEmergingMarketsCorporatePlusSubIndexOptionAdjustedSpread: str = "BAMLEMNSNFCRPIOAS"
        """ICE BofAML Non-Financial Emerging Markets Corporate Plus Sub-Index Option-Adjusted Spread (in Percent)"""

        NonFinancialUSEmergingMarketsLiquidCorporatePlusSubIndexOptionAdjustedSpread: str = "BAMLEMNFNFLCRPIUSOAS"
        """ICE BofAML Non-Financial US Emerging Markets Liquid Corporate Plus Sub-Index Option-Adjusted Spread (in Percent)"""

        PublicSectorIssuersUSEmergingMarketsLiquidCorporatePlusSubIndexOptionAdjustedSpread: str = "BAMLEMPUPUBSLCRPIUSOAS"
        """ICE BofAML Public Sector Issuers US Emerging Markets Liquid Corporate Plus Sub-Index Option-Adjusted Spread (in Percent)"""

        USEmergingMarketsCorporatePlusSubIndexOptionAdjustedSpread: str = "BAMLEMUBCRPIUSOAS"
        """ICE BofAML US Emerging Markets Corporate Plus Sub-Index Option-Adjusted Spread (in Percent)"""

        USEmergingMarketsLiquidCorporatePlusIndexOptionAdjustedSpread: str = "BAMLEMCLLCRPIUSOAS"
        """ICE BofAML US Emerging Markets Liquid Corporate Plus Index Option-Adjusted Spread (in Percent)"""

        EuroHighYieldIndexOptionAdjustedSpread: str = "BAMLHE00EHYIOAS"
        """ICE BofAML Euro High Yield Index Option-Adjusted Spread (in Percent)"""

        USCorporateAOptionAdjustedSpread: str = "BAMLC0A3CA"
        """ICE BofAML US Corporate A Option-Adjusted Spread (in Percent)"""

        USCorporateAAOptionAdjustedSpread: str = "BAMLC0A2CAA"
        """ICE BofAML US Corporate AA Option-Adjusted Spread (in Percent)"""

        USCorporateAAAOptionAdjustedSpread: str = "BAMLC0A1CAAA"
        """ICE BofAML US Corporate AAA Option-Adjusted Spread (in Percent)"""

        USHighYieldBOptionAdjustedSpread: str = "BAMLH0A2HYB"
        """ICE BofAML US High Yield B Option-Adjusted Spread (in Percent)"""

        USHighYieldBBOptionAdjustedSpread: str = "BAMLH0A1HYBB"
        """ICE BofAML US High Yield BB Option-Adjusted Spread (in Percent)"""

        USCorporateBBBOptionAdjustedSpread: str = "BAMLC0A4CBBB"
        """ICE BofAML US Corporate BBB Option-Adjusted Spread (in Percent)"""

        USHighYieldCCCorBelowOptionAdjustedSpread: str = "BAMLH0A3HYC"
        """ICE BofAML US High Yield CCC or Below Option-Adjusted Spread (in Percent)"""

        AAAAEmergingMarketsCorporatePlusSubIndexEffectiveYield: str = "BAMLEM1BRRAAA2ACRPIEY"
        """ICE BofAML AAA-A Emerging Markets Corporate Plus Sub-Index Effective Yield (in Percent)"""

        AAAAUSEmergingMarketsLiquidCorporatePlusSubIndexEffectiveYield: str = "BAMLEM1RAAA2ALCRPIUSEY"
        """ICE BofAML AAA-A US Emerging Markets Liquid Corporate Plus Sub-Index Effective Yield (in Percent)"""

        AsiaEmergingMarketsCorporatePlusSubIndexEffectiveYield: str = "BAMLEMRACRPIASIAEY"
        """ICE BofAML Asia Emerging Markets Corporate Plus Sub-Index Effective Yield (in Percent)"""

        AsiaUSEmergingMarketsLiquidCorporatePlusSubIndexEffectiveYield: str = "BAMLEMALLCRPIASIAUSEY"
        """ICE BofAML Asia US Emerging Markets Liquid Corporate Plus Sub-Index Effective Yield (in Percent)"""

        BandLowerEmergingMarketsCorporatePlusSubIndexEffectiveYield: str = "BAMLEM4BRRBLCRPIEY"
        """ICE BofAML B and Lower Emerging Markets Corporate Plus Sub-Index Effective Yield (in Percent)"""

        BandLowerUSEmergingMarketsLiquidCorporatePlusSubIndexEffectiveYield: str = "BAMLEM4RBLLCRPIUSEY"
        """ICE BofAML B and Lower US Emerging Markets Liquid Corporate Plus Sub-Index Effective Yield (in Percent)"""

        BBEmergingMarketsCorporatePlusSubIndexEffectiveYield: str = "BAMLEM3BRRBBCRPIEY"
        """ICE BofAML BB Emerging Markets Corporate Plus Sub-Index Effective Yield (in Percent)"""

        BBUSEmergingMarketsLiquidCorporatePlusSubIndexEffectiveYield: str = "BAMLEM3RBBLCRPIUSEY"
        """ICE BofAML BB US Emerging Markets Liquid Corporate Plus Sub-Index Effective Yield (in Percent)"""

        BBBEmergingMarketsCorporatePlusSubIndexEffectiveYield: str = "BAMLEM2BRRBBBCRPIEY"
        """ICE BofAML BBB Emerging Markets Corporate Plus Sub-Index Effective Yield (in Percent)"""

        BBBUSEmergingMarketsLiquidCorporatePlusSubIndexEffectiveYield: str = "BAMLEM2RBBBLCRPIUSEY"
        """ICE BofAML BBB US Emerging Markets Liquid Corporate Plus Sub-Index Effective Yield (in Percent)"""

        CrossoverEmergingMarketsCorporatePlusSubIndexEffectiveYield: str = "BAMLEM5BCOCRPIEY"
        """ICE BofAML Crossover Emerging Markets Corporate Plus Sub-Index Effective Yield (in Percent)"""

        CrossoverUSEmergingMarketsLiquidCorporatePlusSubIndexEffectiveYield: str = "BAMLEMXOCOLCRPIUSEY"
        """ICE BofAML Crossover US Emerging Markets Liquid Corporate Plus Sub-Index Effective Yield (in Percent)"""

        EmergingMarketsCorporatePlusIndexEffectiveYield: str = "BAMLEMCBPIEY"
        """ICE BofAML Emerging Markets Corporate Plus Index Effective Yield (in Percent)"""

        EuroEmergingMarketsCorporatePlusSubIndexEffectiveYield: str = "BAMLEMEBCRPIEEY"
        """ICE BofAML Euro Emerging Markets Corporate Plus Sub-Index Effective Yield (in Percent)"""

        EuroHighYieldIndexEffectiveYield: str = "BAMLHE00EHYIEY"
        """ICE BofAML Euro High Yield Index Effective Yield (in Percent)"""

        EMEAEmergingMarketsCorporatePlusSubIndexEffectiveYield: str = "BAMLEMRECRPIEMEAEY"
        """ICE BofAML Europe, the Middle East, and Africa (EMEA) Emerging Markets Corporate Plus Sub-Index Effective Yield (in Percent)"""

        EMEAUSEmergingMarketsLiquidCorporatePlusSubIndexEffectiveYield: str = "BAMLEMELLCRPIEMEAUSEY"
        """ICE BofAML Europe, the Middle East, and Africa (EMEA) US Emerging Markets Liquid Corporate Plus Sub-Index Effective Yield (in Percent)"""

        FinancialEmergingMarketsCorporatePlusSubIndexEffectiveYield: str = "BAMLEMFSFCRPIEY"
        """ICE BofAML Financial Emerging Markets Corporate Plus Sub-Index Effective Yield (in Percent)"""

        FinancialUSEmergingMarketsLiquidCorporatePlusSubIndexEffectiveYield: str = "BAMLEMFLFLCRPIUSEY"
        """ICE BofAML Financial US Emerging Markets Liquid Corporate Plus Sub-Index Effective Yield (in Percent)"""

        HighGradeEmergingMarketsCorporatePlusSubIndexEffectiveYield: str = "BAMLEMIBHGCRPIEY"
        """ICE BofAML High Grade Emerging Markets Corporate Plus Sub-Index Effective Yield (in Percent)"""

        HighGradeUSEmergingMarketsLiquidCorporatePlusSubIndexEffectiveYield: str = "BAMLEMHGHGLCRPIUSEY"
        """ICE BofAML High Grade US Emerging Markets Liquid Corporate Plus Sub-Index Effective Yield (in Percent)"""

        HighYieldEmergingMarketsCorporatePlusSubIndexEffectiveYield: str = "BAMLEMHBHYCRPIEY"
        """ICE BofAML High Yield Emerging Markets Corporate Plus Sub-Index Effective Yield (in Percent)"""

        HighYieldUSEmergingMarketsLiquidCorporatePlusSubIndexEffectiveYield: str = "BAMLEMHYHYLCRPIUSEY"
        """ICE BofAML High Yield US Emerging Markets Liquid Corporate Plus Sub-Index Effective Yield (in Percent)"""

        LatinAmericaEmergingMarketsCorporatePlusSubIndexEffectiveYield: str = "BAMLEMRLCRPILAEY"
        """ICE BofAML Latin America Emerging Markets Corporate Plus Sub-Index Effective Yield (in Percent)"""

        LatinAmericaUSEmergingMarketsLiquidCorporatePlusSubIndexEffectiveYield: str = "BAMLEMLLLCRPILAUSEY"
        """ICE BofAML Latin America US Emerging Markets Liquid Corporate Plus Sub-Index Effective Yield (in Percent)"""

        NonFinancialEmergingMarketsCorporatePlusSubIndexEffectiveYield: str = "BAMLEMNSNFCRPIEY"
        """ICE BofAML Non-Financial Emerging Markets Corporate Plus Sub-Index Effective Yield (in Percent)"""

        NonFinancialUSEmergingMarketsLiquidCorporatePlusSubIndexEffectiveYield: str = "BAMLEMNFNFLCRPIUSEY"
        """ICE BofAML Non-Financial US Emerging Markets Liquid Corporate Plus Sub-Index Effective Yield (in Percent)"""

        PublicSectorIssuersUSEmergingMarketsLiquidCorporatePlusSubIndexEffectiveYield: str = "BAMLEMPUPUBSLCRPIUSEY"
        """ICE BofAML Public Sector Issuers US Emerging Markets Liquid Corporate Plus Sub-Index Effective Yield (in Percent)"""

        USCorporate1ThreeYearEffectiveYield: str = "BAMLC1A0C13YEY"
        """ICE BofAML US Corporate 1-3 Year Effective Yield (in Percent)"""

        USCorporate10To15YearEffectiveYield: str = "BAMLC7A0C1015YEY"
        """ICE BofAML US Corporate 10-15 Year Effective Yield (in Percent)"""

        USCorporateMoreThan15YearEffectiveYield: str = "BAMLC8A0C15PYEY"
        """ICE BofAML US Corporate 15+ Year Effective Yield (in Percent)"""

        USCorporate3To5YearEffectiveYield: str = "BAMLC2A0C35YEY"
        """ICE BofAML US Corporate 3-5 Year Effective Yield (in Percent)"""

        USCorporate5To7YearEffectiveYield: str = "BAMLC3A0C57YEY"
        """ICE BofAML US Corporate 5-7 Year Effective Yield (in Percent)"""

        USCorporate7To10YearEffectiveYield: str = "BAMLC4A0C710YEY"
        """ICE BofAML US Corporate 7-10 Year Effective Yield (in Percent)"""

        USCorporateAEffectiveYield: str = "BAMLC0A3CAEY"
        """ICE BofAML US Corporate A Effective Yield (in Percent)"""

        USCorporateAAEffectiveYield: str = "BAMLC0A2CAAEY"
        """ICE BofAML US Corporate AA Effective Yield (in Percent)"""

        USCorporateAAAEffectiveYield: str = "BAMLC0A1CAAAEY"
        """ICE BofAML US Corporate AAA Effective Yield (in Percent)"""

        USHighYieldBEffectiveYield: str = "BAMLH0A2HYBEY"
        """ICE BofAML US High Yield B Effective Yield (in Percent)"""

        USHighYieldBBEffectiveYield: str = "BAMLH0A1HYBBEY"
        """ICE BofAML US High Yield BB Effective Yield (in Percent)"""

        USCorporateBBBEffectiveYield: str = "BAMLC0A4CBBBEY"
        """ICE BofAML US Corporate BBB Effective Yield (in Percent)"""

        USHighYieldCCCorBelowEffectiveYield: str = "BAMLH0A3HYCEY"
        """ICE BofAML US High Yield CCC or Below Effective Yield (in Percent)"""

        USCorporateMasterEffectiveYield: str = "BAMLC0A0CMEY"
        """ICE BofAML US Corporate Master Effective Yield (in Percent)"""

        USEmergingMarketsCorporatePlusSubIndexEffectiveYield: str = "BAMLEMUBCRPIUSEY"
        """ICE BofAML US Emerging Markets Corporate Plus Sub-Index Effective Yield (in Percent)"""

        USEmergingMarketsLiquidCorporatePlusIndexEffectiveYield: str = "BAMLEMCLLCRPIUSEY"
        """ICE BofAML US Emerging Markets Liquid Corporate Plus Index Effective Yield (in Percent)"""

        USHighYieldMasterIIEffectiveYield: str = "BAMLH0A0HYM2EY"
        """ICE BofAML US High Yield Master II Effective Yield (in Percent)"""

        AAAAEmergingMarketsCorporatePlusSubIndexSemiAnnualYieldtoWorst: str = "BAMLEM1BRRAAA2ACRPISYTW"
        """ICE BofAML AAA-A Emerging Markets Corporate Plus Sub-Index Semi-Annual Yield to Worst (in Percent)"""

        AAAAUSEmergingMarketsLiquidCorporatePlusSubIndexSemiAnnualYieldtoWorst: str = "BAMLEM1RAAA2ALCRPIUSSYTW"
        """ICE BofAML AAA-A US Emerging Markets Liquid Corporate Plus Sub-Index Semi-Annual Yield to Worst (in Percent)"""

        AsiaEmergingMarketsCorporatePlusSubIndexSemiAnnualYieldtoWorst: str = "BAMLEMRACRPIASIASYTW"
        """ICE BofAML Asia Emerging Markets Corporate Plus Sub-Index Semi-Annual Yield to Worst (in Percent)"""

        AsiaUSEmergingMarketsLiquidCorporatePlusSubIndexSemiAnnualYieldtoWorst: str = "BAMLEMALLCRPIASIAUSSYTW"
        """ICE BofAML Asia US Emerging Markets Liquid Corporate Plus Sub-Index Semi-Annual Yield to Worst (in Percent)"""

        BandLowerEmergingMarketsCorporatePlusSubIndexSemiAnnualYieldtoWorst: str = "BAMLEM4BRRBLCRPISYTW"
        """ICE BofAML B and Lower Emerging Markets Corporate Plus Sub-Index Semi-Annual Yield to Worst (in Percent)"""

        BandLowerUSEmergingMarketsLiquidCorporatePlusSubIndexSemiAnnualYieldtoWorst: str = "BAMLEM4RBLLCRPIUSSYTW"
        """ICE BofAML B and Lower US Emerging Markets Liquid Corporate Plus Sub-Index Semi-Annual Yield to Worst (in Percent)"""

        BBEmergingMarketsCorporatePlusSubIndexSemiAnnualYieldtoWorst: str = "BAMLEM3BRRBBCRPISYTW"
        """ICE BofAML BB Emerging Markets Corporate Plus Sub-Index Semi-Annual Yield to Worst (in Percent)"""

        BBUSEmergingMarketsLiquidCorporatePlusSubIndexSemiAnnualYieldtoWorst: str = "BAMLEM3RBBLCRPIUSSYTW"
        """ICE BofAML BB US Emerging Markets Liquid Corporate Plus Sub-Index Semi-Annual Yield to Worst (in Percent)"""

        BBBEmergingMarketsCorporatePlusSubIndexSemiAnnualYieldtoWorst: str = "BAMLEM2BRRBBBCRPISYTW"
        """ICE BofAML BBB Emerging Markets Corporate Plus Sub-Index Semi-Annual Yield to Worst (in Percent)"""

        BBBUSEmergingMarketsLiquidCorporatePlusSubIndexSemiAnnualYieldtoWorst: str = "BAMLEM2RBBBLCRPIUSSYTW"
        """ICE BofAML BBB US Emerging Markets Liquid Corporate Plus Sub-Index Semi-Annual Yield to Worst (in Percent)"""

        CrossoverEmergingMarketsCorporatePlusSubIndexSemiAnnualYieldtoWorst: str = "BAMLEM5BCOCRPISYTW"
        """ICE BofAML Crossover Emerging Markets Corporate Plus Sub-Index Semi-Annual Yield to Worst (in Percent)"""

        CrossoverUSEmergingMarketsLiquidCorporatePlusSubIndexSemiAnnualYieldtoWorst: str = "BAMLEMXOCOLCRPIUSSYTW"
        """ICE BofAML Crossover US Emerging Markets Liquid Corporate Plus Sub-Index Semi-Annual Yield to Worst (in Percent)"""

        EmergingMarketsCorporatePlusIndexSemiAnnualYieldtoWorst: str = "BAMLEMCBPISYTW"
        """ICE BofAML Emerging Markets Corporate Plus Index Semi-Annual Yield to Worst (in Percent)"""

        EuroEmergingMarketsCorporatePlusSubIndexSemiAnnualYieldtoWorst: str = "BAMLEMEBCRPIESYTW"
        """ICE BofAML Euro Emerging Markets Corporate Plus Sub-Index Semi-Annual Yield to Worst (in Percent)"""

        EuroHighYieldIndexSemiAnnualYieldtoWorst: str = "BAMLHE00EHYISYTW"
        """ICE BofAML Euro High Yield Index Semi-Annual Yield to Worst (in Percent)"""

        EMEAEmergingMarketsCorporatePlusSubIndexSemiAnnualYieldtoWorst: str = "BAMLEMRECRPIEMEASYTW"
        """ICE BofAML Europe, the Middle East, and Africa (EMEA) Emerging Markets Corporate Plus Sub-Index Semi-Annual Yield to Worst (in Percent)"""

        EMEAUSEmergingMarketsLiquidCorporatePlusSubIndexSemiAnnualYieldtoWorst: str = "BAMLEMELLCRPIEMEAUSSYTW"
        """ICE BofAML Europe, the Middle East, and Africa (EMEA) US Emerging Markets Liquid Corporate Plus Sub-Index Semi-Annual Yield to Worst (in Percent)"""

        FinancialEmergingMarketsCorporatePlusSubIndexSemiAnnualYieldtoWorst: str = "BAMLEMFSFCRPISYTW"
        """ICE BofAML Financial Emerging Markets Corporate Plus Sub-Index Semi-Annual Yield to Worst (in Percent)"""

        FinancialUSEmergingMarketsLiquidCorporatePlusSubIndexSemiAnnualYieldtoWorst: str = "BAMLEMFLFLCRPIUSSYTW"
        """ICE BofAML Financial US Emerging Markets Liquid Corporate Plus Sub-Index Semi-Annual Yield to Worst (in Percent)"""

        HighGradeEmergingMarketsCorporatePlusSubIndexSemiAnnualYieldtoWorst: str = "BAMLEMIBHGCRPISYTW"
        """ICE BofAML High Grade Emerging Markets Corporate Plus Sub-Index Semi-Annual Yield to Worst (in Percent)"""

        HighGradeUSEmergingMarketsLiquidCorporatePlusSubIndexSemiAnnualYieldtoWorst: str = "BAMLEMHGHGLCRPIUSSYTW"
        """ICE BofAML High Grade US Emerging Markets Liquid Corporate Plus Sub-Index Semi-Annual Yield to Worst (in Percent)"""

        HighYieldEmergingMarketsCorporatePlusSubIndexSemiAnnualYieldtoWorst: str = "BAMLEMHBHYCRPISYTW"
        """ICE BofAML High Yield Emerging Markets Corporate Plus Sub-Index Semi-Annual Yield to Worst (in Percent)"""

        HighYieldUSEmergingMarketsLiquidCorporatePlusSubIndexSemiAnnualYieldtoWorst: str = "BAMLEMHYHYLCRPIUSSYTW"
        """ICE BofAML High Yield US Emerging Markets Liquid Corporate Plus Sub-Index Semi-Annual Yield to Worst (in Percent)"""

        LatinAmericaEmergingMarketsCorporatePlusSubIndexSemiAnnualYieldtoWorst: str = "BAMLEMRLCRPILASYTW"
        """ICE BofAML Latin America Emerging Markets Corporate Plus Sub-Index Semi-Annual Yield to Worst (in Percent)"""

        LatinAmericaUSEmergingMarketsLiquidCorporatePlusSubIndexSemiAnnualYieldtoWorst: str = "BAMLEMLLLCRPILAUSSYTW"
        """ICE BofAML Latin America US Emerging Markets Liquid Corporate Plus Sub-Index Semi-Annual Yield to Worst (in Percent)"""

        NonFinancialEmergingMarketsCorporatePlusSubIndexSemiAnnualYieldtoWorst: str = "BAMLEMNSNFCRPISYTW"
        """ICE BofAML Non-Financial Emerging Markets Corporate Plus Sub-Index Semi-Annual Yield to Worst (in Percent)"""

        NonFinancialUSEmergingMarketsLiquidCorporatePlusSubIndexSemiAnnualYieldtoWorst: str = "BAMLEMNFNFLCRPIUSSYTW"
        """ICE BofAML Non-Financial US Emerging Markets Liquid Corporate Plus Sub-Index Semi-Annual Yield to Worst (in Percent)"""

        PrivateSectorIssuersEmergingMarketsCorporatePlusSubIndexSemiAnnualYieldtoWorst: str = "BAMLEMPTPRVICRPISYTW"
        """ICE BofAML Private Sector Issuers Emerging Markets Corporate Plus Sub-Index Semi-Annual Yield to Worst (in Percent)"""

        PrivateSectorIssuersUSEmergingMarketsLiquidCorporatePlusSubIndexSemiAnnualYieldtoWorst: str = "BAMLEMPVPRIVSLCRPIUSSYTW"
        """ICE BofAML Private Sector Issuers US Emerging Markets Liquid Corporate Plus Sub-Index Semi-Annual Yield to Worst (in Percent)"""

        PublicSectorIssuersEmergingMarketsCorporatePlusSubIndexSemiAnnualYieldtoWorst: str = "BAMLEMPBPUBSICRPISYTW"
        """ICE BofAML Public Sector Issuers Emerging Markets Corporate Plus Sub-Index Semi-Annual Yield to Worst (in Percent)"""

        PublicSectorIssuersUSEmergingMarketsLiquidCorporatePlusSubIndexSemiAnnualYieldtoWorst: str = "BAMLEMPUPUBSLCRPIUSSYTW"
        """ICE BofAML Public Sector Issuers US Emerging Markets Liquid Corporate Plus Sub-Index Semi-Annual Yield to Worst (in Percent)"""

        USCorporate1To3YearSemiAnnualYieldtoWorst: str = "BAMLC1A0C13YSYTW"
        """ICE BofAML US Corporate 1-3 Year Semi-Annual Yield to Worst (in Percent)"""

        USCorporate10To15YearSemiAnnualYieldtoWorst: str = "BAMLC7A0C1015YSYTW"
        """ICE BofAML US Corporate 10-15 Year Semi-Annual Yield to Worst (in Percent)"""

        USCorporateMoreThan15YearSemiAnnualYieldtoWorst: str = "BAMLC8A0C15PYSYTW"
        """ICE BofAML US Corporate 15+ Year Semi-Annual Yield to Worst (in Percent)"""

        USCorporate3To5YearSemiAnnualYieldtoWorst: str = "BAMLC2A0C35YSYTW"
        """ICE BofAML US Corporate 3-5 Year Semi-Annual Yield to Worst (in Percent)"""

        USCorporate5To7YearSemiAnnualYieldtoWorst: str = "BAMLC3A0C57YSYTW"
        """ICE BofAML US Corporate 5-7 Year Semi-Annual Yield to Worst (in Percent)"""

        USCorporate7To10YearSemiAnnualYieldtoWorst: str = "BAMLC4A0C710YSYTW"
        """ICE BofAML US Corporate 7-10 Year Semi-Annual Yield to Worst (in Percent)"""

        USCorporateASemiAnnualYieldtoWorst: str = "BAMLC0A3CASYTW"
        """ICE BofAML US Corporate A Semi-Annual Yield to Worst (in Percent)"""

        USCorporateAASemiAnnualYieldtoWorst: str = "BAMLC0A2CAASYTW"
        """ICE BofAML US Corporate AA Semi-Annual Yield to Worst (in Percent)"""

        USCorporateAAASemiAnnualYieldtoWorst: str = "BAMLC0A1CAAASYTW"
        """ICE BofAML US Corporate AAA Semi-Annual Yield to Worst (in Percent)"""

        USHighYieldBSemiAnnualYieldtoWorst: str = "BAMLH0A2HYBSYTW"
        """ICE BofAML US High Yield B Semi-Annual Yield to Worst (in Percent)"""

        USHighYieldBBSemiAnnualYieldtoWorst: str = "BAMLH0A1HYBBSYTW"
        """ICE BofAML US High Yield BB Semi-Annual Yield to Worst (in Percent)"""

        USCorporateBBBSemiAnnualYieldtoWorst: str = "BAMLC0A4CBBBSYTW"
        """ICE BofAML US Corporate BBB Semi-Annual Yield to Worst (in Percent)"""

        USHighYieldCCCorBelowSemiAnnualYieldtoWorst: str = "BAMLH0A3HYCSYTW"
        """ICE BofAML US High Yield CCC or Below Semi-Annual Yield to Worst (in Percent)"""

        USCorporateMasterSemiAnnualYieldtoWorst: str = "BAMLC0A0CMSYTW"
        """ICE BofAML US Corporate Master Semi-Annual Yield to Worst (in Percent)"""

        USEmergingMarketsCorporatePlusSubIndexSemiAnnualYieldtoWorst: str = "BAMLEMUBCRPIUSSYTW"
        """ICE BofAML US Emerging Markets Corporate Plus Sub-Index Semi-Annual Yield to Worst (in Percent)"""

        USEmergingMarketsLiquidCorporatePlusIndexSemiAnnualYieldtoWorst: str = "BAMLEMCLLCRPIUSSYTW"
        """ICE BofAML US Emerging Markets Liquid Corporate Plus Index Semi-Annual Yield to Worst (in Percent)"""

        USHighYieldMasterIISemiAnnualYieldtoWorst: str = "BAMLH0A0HYM2SYTW"
        """ICE BofAML US High Yield Master II Semi-Annual Yield to Worst (in Percent)"""

    class Wilshire(System.Object):
        """Wilshire Indexes help clients, investment professionals and researchers accurately measure and better understand the market. The Wilshire Index family leverages more than 40 years of Wilshire performance measurement expertise and employs unbiased construction rules."""

        USSmallCapValuePrice: str = "WILLSMLCAPVALPR"
        """Wilshire US Small-Cap Value Price Index (in Index)"""

        Price2500: str = "WILL2500PR"
        """Wilshire 2500 Price Index (in Index)"""

        Price4500: str = "WILL4500PR"
        """Wilshire 4500 Price Index (in Index)"""

        ValuePrice2500: str = "WILL2500PRVAL"
        """Wilshire 2500 Value Price Index (in Index)"""

        GrowthPrice2500: str = "WILL2500PRGR"
        """Wilshire 2500 Growth Price Index (in Index)"""

        USSmallCapPrice: str = "WILLSMLCAPPR"
        """Wilshire US Small-Cap Price Index (in Index)"""

        Price5000: str = "WILL5000PR"
        """Wilshire 5000 Price Index (in Index)"""

        USSmallCapGrowthPrice: str = "WILLSMLCAPGRPR"
        """Wilshire US Small-Cap Growth Price Index (in Index)"""

        USMidCapValuePrice: str = "WILLMIDCAPVALPR"
        """Wilshire US Mid-Cap Value Price Index (in Index)"""

        USRealEstateSecuritiesPrice: str = "WILLRESIPR"
        """Wilshire US Real Estate Securities Price Index (Wilshire US RESI) (in Index)"""

        USLargeCapPrice: str = "WILLLRGCAPPR"
        """Wilshire US Large-Cap Price Index (in Index)"""

        USMidCapPrice: str = "WILLMIDCAPPR"
        """Wilshire US Mid-Cap Price Index (in Index)"""

        USMidCapGrowthPrice: str = "WILLMIDCAPGRPR"
        """Wilshire US Mid-Cap Growth Price Index (in Index)"""

        USMicroCapPrice: str = "WILLMICROCAPPR"
        """Wilshire US Micro-Cap Price Index (in Index)"""

        USRealEstateInvestmentTrustPrice: str = "WILLREITPR"
        """Wilshire US Real Estate Investment Trust Price Index (Wilshire US REIT) (in Index)"""

        USLargeCapValuePrice: str = "WILLLRGCAPVALPR"
        """Wilshire US Large-Cap Value Price Index (in Index)"""

        USLargeCapGrowthPrice: str = "WILLLRGCAPGRPR"
        """Wilshire US Large-Cap Growth Price Index (in Index)"""

        FullCapPrice5000: str = "WILL5000PRFC"
        """Wilshire 5000 Full Cap Price Index (in Index)"""

        USMidCapValue: str = "WILLMIDCAPVAL"
        """Wilshire US Mid-Cap Value Total Market Index (in Index)"""

        USMidCapGrowth: str = "WILLMIDCAPGR"
        """Wilshire US Mid-Cap Growth Total Market Index (in Index)"""

        USMidCap: str = "WILLMIDCAP"
        """Wilshire US Mid-Cap Total Market Index (in Index)"""

        USRealEstateSecurities: str = "WILLRESIND"
        """Wilshire US Real Estate Securities Total Market Index (Wilshire US RESI) (in Index)"""

        Index4500: str = "WILL4500IND"
        """Wilshire 4500 Total Market Index (in Index)"""

        Index5000: str = "WILL5000IND"
        """Wilshire 5000 Total Market Index (in Index)"""

        USLargeCapGrowth: str = "WILLLRGCAPGR"
        """Wilshire US Large-Cap Growth Total Market Index (in Index)"""

        USMicroCap: str = "WILLMICROCAP"
        """Wilshire US Micro-Cap Total Market Index (in Index)"""

        Value2500: str = "WILL2500INDVAL"
        """Wilshire 2500 Value Total Market Index (in Index)"""

        USSmallCapGrowth: str = "WILLSMLCAPGR"
        """Wilshire US Small-Cap Growth Total Market Index (in Index)"""

        USSmallCapValue: str = "WILLSMLCAPVAL"
        """Wilshire US Small-Cap Value Total Market Index (in Index)"""

        USLargeCapValue: str = "WILLLRGCAPVAL"
        """Wilshire US Large-Cap Value Total Market Index (in Index)"""

        USRealEstateInvestmentTrust: str = "WILLREITIND"
        """Wilshire US Real Estate Investment Trust Total Market Index (Wilshire US REIT) (in Index)"""

        Index2500: str = "WILL2500IND"
        """Wilshire 2500 Total Market Index (in Index)"""

        USSmallCap: str = "WILLSMLCAP"
        """Wilshire US Small-Cap Total Market Index (in Index)"""

        USLargeCap: str = "WILLLRGCAP"
        """Wilshire US Large-Cap Total Market Index (in Index)"""

        Growth2500: str = "WILL2500INDGR"
        """Wilshire 2500 Growth Total Market Index (in Index)"""

        TotalMarketFullCap5000: str = "WILL5000INDFC"
        """Wilshire 5000 Total Market Full Cap Index (in Index)"""

    class OECDRecessionIndicators(System.Object):
        """
        These time series is an interpretation of Organisation of Economic Development (OECD) Composite Leading Indicators: Reference Turning Points and Component Series data, which can be found at http://www.oecd.org/std/leading-indicators/oecdcompositeleadingindicatorsreferenceturningpointsandcomponentseries.htm. The OECD identifies months of turning points without designating a date within the month that turning points occurred. The dummy variable adopts an arbitrary convention that the turning point occurred at a specific date within the month. The arbitrary convention does not reflect any judgment on this issue by the OECD. Our time series is composed of dummy variables that represent periods of expansion and recession. A value of 1 is a recessionary period, while a value of 0 is an expansionary period. For this time series, the recession begins on the 15th day of the month of the peak and ends on the 15th day of the month of the trough. This time series is a disaggregation of the monthly series. For more options on recession shading, see the note and links below.
        The recession shading data that we provide initially comes from the source as a list of dates that are either an economic peak or trough. We interpret dates into recession shading data using one of three arbitrary methods. All of our recession shading data is available using all three interpretations. The period between a peak and trough is always shaded as a recession. The peak and trough are collectively extrema. Depending on the application, the extrema, both individually and collectively, may be included in the recession period in whole or in part. In situations where a portion of a period is included in the recession, the whole period is deemed to be included in the recession period.
        The first interpretation, known as the midpoint method, is to show a recession from the midpoint of the peak through the midpoint of the trough for monthly and quarterly data. For daily data, the recession begins on the 15th of the month of the peak and ends on the 15th of the month of the trough. Daily data is a disaggregation of monthly data. For monthly and quarterly data, the entire peak and trough periods are included in the recession shading. This method shows the maximum number of periods as a recession for monthly and quarterly data. The Federal Reserve Bank of St. Louis uses this method in its own publications. The midpoint method is used for this series.
        The second interpretation, known as the trough method, is to show a recession from the period following the peak through the trough (i.e. the peak is not included in the recession shading, but the trough is). For daily data, the recession begins on the first day of the first month following the peak and ends on the last day of the month of the trough. Daily data is a disaggregation of monthly data. The trough method is used when displaying data on FRED graphs. A version of this time series represented using the trough method can be found at:
        The third interpretation, known as the peak method, is to show a recession from the period of the peak to the trough (i.e. the peak is included in the recession shading, but the trough is not). For daily data, the recession begins on the first day of the month of the peak and ends on the last day of the month preceding the trough. Daily data is a disaggregation of monthly data. A version of this time series represented using the peak method can be found at:
        The OECD CLI system is based on the "growth cycle" approach, where business cycles and turning points are measured and identified in the deviation-from-trend series. The main reference series used in the OECD CLI system for the majority of countries is industrial production (IIP) covering all industry sectors excluding construction. This series is used because of its cyclical sensitivity and monthly availability, while the broad based Gross Domestic Product (GDP) is used to supplement the IIP series for identification of the final reference turning points in the growth cycle.
        Zones aggregates of the CLIs and the reference series are calculated as weighted averages of the corresponding zone member series (i.e. CLIs and IIPs).
        Up to December 2008 the turning points chronologies shown for regional/zone area aggregates or individual countries are determined by the rules established by the National Bureau of Economic Research (NBER) in the United States, which have been formalized and incorporated in a computer routine (Bry and Boschan) and included in the Phase-Average Trend (PAT) de-trending procedure. Starting from December 2008 the turning point detection algorithm is decoupled from the de-trending procedure, and is a simplified version of the original Bry and Boschan routine. (The routine parses local minima and maxima in the cycle series and applies censor rules to guarantee alternating peaks and troughs, as well as phase and cycle length constraints.)
        The components of the CLI are time series which exhibit leading relationship with the reference series (IIP) at turning points. Country CLIs are compiled by combining de-trended smoothed and normalized components. The component series for each country are selected based on various criteria such as economic significance; cyclical behavior; data quality; timeliness and availability.
        OECD data should be cited as follows: OECD Composite Leading Indicators, "Composite Leading Indicators: Reference Turning Points and Component Series", http://www.oecd.org/std/leading-indicators/oecdcompositeleadingindicatorsreferenceturningpointsandcomponentseries.htm
        """

        FourBigEuropeanCountriesFromPeakThroughTheTrough: str = "4BIGEURORECDM"
        """OECD based Recession Indicators for Four Big European Countries from the Peak through the Trough (in +1 or 0)"""

        AustraliaFromPeakThroughTheTrough: str = "AUSRECDM"
        """OECD based Recession Indicators for Australia from the Peak through the Trough (in +1 or 0)"""

        AustriaFromPeakThroughTheTrough: str = "AUTRECDM"
        """OECD based Recession Indicators for Austria from the Peak through the Trough (in +1 or 0)"""

        BelgiumFromPeakThroughTheTrough: str = "BELRECDM"
        """OECD based Recession Indicators for Belgium from the Peak through the Trough (in +1 or 0)"""

        BrazilFromPeakThroughTheTrough: str = "BRARECDM"
        """OECD based Recession Indicators for Brazil from the Peak through the Trough (in +1 or 0)"""

        CanadaFromPeakThroughTheTrough: str = "CANRECDM"
        """OECD based Recession Indicators for Canada from the Peak through the Trough (in +1 or 0)"""

        SwitzerlandFromPeakThroughTheTrough: str = "CHERECDM"
        """OECD based Recession Indicators for Switzerland from the Peak through the Trough (in +1 or 0)"""

        ChileFromPeakThroughTheTrough: str = "CHLRECDM"
        """OECD based Recession Indicators for Chile from the Peak through the Trough (in +1 or 0)"""

        ChinaFromPeakThroughTheTrough: str = "CHNRECDM"
        """OECD based Recession Indicators for China from the Peak through the Trough (in +1 or 0)"""

        CzechRepublicFromPeakThroughTheTrough: str = "CZERECDM"
        """OECD based Recession Indicators for the Czech Republic from the Peak through the Trough (in +1 or 0)"""

        GermanyFromPeakThroughTheTrough: str = "DEURECDM"
        """OECD based Recession Indicators for Germany from the Peak through the Trough (in +1 or 0)"""

        DenmarkFromPeakThroughTheTrough: str = "DNKRECDM"
        """OECD based Recession Indicators for Denmark from the Peak through the Trough (in +1 or 0)"""

        SpainFromPeakThroughTheTrough: str = "ESPRECDM"
        """OECD based Recession Indicators for Spain from the Peak through the Trough (in +1 or 0)"""

        EstoniaFromPeakThroughTheTrough: str = "ESTRECDM"
        """OECD based Recession Indicators for Estonia from the Peak through the Trough (in +1 or 0)"""

        EuroAreaFromPeakThroughTheTrough: str = "EURORECDM"

        FinlandFromPeakThroughTheTrough: str = "FINRECDM"
        """OECD based Recession Indicators for Finland from the Peak through the Trough (in +1 or 0)"""

        FranceFromPeakThroughTheTrough: str = "FRARECDM"
        """OECD based Recession Indicators for France from the Peak through the Trough (in +1 or 0)"""

        UnitedKingdomFromPeakThroughTheTrough: str = "GBRRECDM"
        """OECD based Recession Indicators for the United Kingdom from the Peak through the Trough (in +1 or 0)"""

        GreeceFromPeakThroughTheTrough: str = "GRCRECDM"
        """OECD based Recession Indicators for Greece from the Peak through the Trough (in +1 or 0)"""

        HungaryFromPeakThroughTheTrough: str = "HUNRECDM"
        """OECD based Recession Indicators for Hungary from the Peak through the Trough (in +1 or 0)"""

        IndonesiaFromPeakThroughTheTrough: str = "IDNRECDM"
        """OECD based Recession Indicators for Indonesia from the Peak through the Trough (in +1 or 0)"""

        IndiaFromPeakThroughTheTrough: str = "INDRECDM"
        """OECD based Recession Indicators for India from the Peak through the Trough (in +1 or 0)"""

        IrelandFromPeakThroughTheTrough: str = "IRLRECDM"
        """OECD based Recession Indicators for Ireland from the Peak through the Trough (in +1 or 0)"""

        IsraelFromPeakThroughTheTrough: str = "ISRRECDM"
        """OECD based Recession Indicators for Israel from the Peak through the Trough (in +1 or 0)"""

        ItalyFromPeakThroughTheTrough: str = "ITARECDM"
        """OECD based Recession Indicators for Italy from the Peak through the Trough (in +1 or 0)"""

        JapanFromPeakThroughTheTrough: str = "JPNRECDM"
        """OECD based Recession Indicators for Japan from the Peak through the Trough (in +1 or 0)"""

        KoreaFromPeakThroughTheTrough: str = "KORRECDM"
        """OECD based Recession Indicators for Korea from the Peak through the Trough (in +1 or 0)"""

        LuxembourgFromPeakThroughTheTrough: str = "LUXRECDM"
        """OECD based Recession Indicators for Luxembourg from the Peak through the Trough (in +1 or 0)"""

        MajorFiveAsiaFromPeakThroughTheTrough: str = "MAJOR5ASIARECDM"
        """OECD based Recession Indicators for Major 5 Asia from the Peak through the Trough (in +1 or 0)"""

        MexicoFromPeakThroughTheTrough: str = "MEXRECDM"
        """OECD based Recession Indicators for Mexico from the Peak through the Trough (in +1 or 0)"""

        MajorSevenCountriesFromPeakThroughTheTrough: str = "MSCRECDM"
        """OECD based Recession Indicators for Major Seven Countries from the Peak through the Trough (in +1 or 0)"""

        NAFTAAreaFromPeakThroughTheTrough: str = "NAFTARECDM"
        """OECD based Recession Indicators for NAFTA Area from the Peak through the Trough (in +1 or 0)"""

        NetherlandsFromPeakThroughTheTrough: str = "NDLRECDM"
        """OECD based Recession Indicators for Netherlands from the Peak through the Trough (in +1 or 0)"""

        NorwayFromPeakThroughTheTrough: str = "NORRECDM"
        """OECD based Recession Indicators for Norway from the Peak through the Trough (in +1 or 0)"""

        NewZealandFromPeakThroughTheTrough: str = "NZLRECDM"
        """OECD based Recession Indicators for New Zealand from the Peak through the Trough (in +1 or 0)"""

        OECDEuropeFromPeakThroughTheTrough: str = "OECDEUROPERECDM"
        """OECD based Recession Indicators for OECD Europe from the Peak through the Trough (in +1 or 0)"""

        OECDAndNonmemberEconomiesFromPeakThroughTheTrough: str = "OECDNMERECDM"
        """OECD based Recession Indicators for OECD and Non-member Economies from the Peak through the Trough (in +1 or 0)"""

        OECDTotalAreaFromPeakThroughTheTrough: str = "OECDRECDM"
        """OECD based Recession Indicators for the OECD Total Area from the Peak through the Trough (in +1 or 0)"""

        PolandFromPeakThroughTheTrough: str = "POLRECDM"
        """OECD based Recession Indicators for Poland from the Peak through the Trough (in +1 or 0)"""

        PortugalFromPeakThroughTheTrough: str = "PRTRECDM"
        """OECD based Recession Indicators for Portugal from the Peak through the Trough (in +1 or 0)"""

        RussianFederationFromPeakThroughTheTrough: str = "RUSRECDM"
        """OECD based Recession Indicators for Russian Federation from the Peak through the Trough (in +1 or 0)"""

        SlovakRepublicFromPeakThroughTheTrough: str = "SVKRECDM"
        """OECD based Recession Indicators for the Slovak Republic from the Peak through the Trough (in +1 or 0)"""

        SloveniaFromPeakThroughTheTrough: str = "SVNRECDM"
        """OECD based Recession Indicators for Slovenia from the Peak through the Trough (in +1 or 0)"""

        SwedenFromPeakThroughTheTrough: str = "SWERECDM"
        """OECD based Recession Indicators for Sweden from the Peak through the Trough (in +1 or 0)"""

        TurkeyFromPeakThroughTheTrough: str = "TURRECDM"
        """OECD based Recession Indicators for Turkey from the Peak through the Trough (in +1 or 0)"""

        UnitedStatesFromPeakThroughTheTrough: str = "USARECDM"
        """OECD based Recession Indicators for the United States from the Peak through the Trough (in +1 or 0)"""

        SouthAfricaFromPeakThroughTheTrough: str = "ZAFRECDM"
        """OECD based Recession Indicators for South Africa from the Peak through the Trough (in +1 or 0)"""

        FourBigEuropeanCountriesFromPeriodFollowingPeakThroughTheTrough: str = "4BIGEURORECD"
        """OECD based Recession Indicators for Four Big European Countries from the Period following the Peak through the Trough (in +1 or 0)"""

        AustraliaFromPeriodFollowingPeakThroughTheTrough: str = "AUSRECD"
        """OECD based Recession Indicators for Australia from the Period following the Peak through the Trough (in +1 or 0)"""

        AustriaFromPeriodFollowingPeakThroughTheTrough: str = "AUTRECD"
        """OECD based Recession Indicators for Austria from the Period following the Peak through the Trough (in +1 or 0)"""

        BelgiumFromPeriodFollowingPeakThroughTheTrough: str = "BELRECD"
        """OECD based Recession Indicators for Belgium from the Period following the Peak through the Trough (in +1 or 0)"""

        BrazilFromPeriodFollowingPeakThroughTheTrough: str = "BRARECD"
        """OECD based Recession Indicators for Brazil from the Period following the Peak through the Trough (in +1 or 0)"""

        CanadaFromPeriodFollowingPeakThroughTheTrough: str = "CANRECD"
        """OECD based Recession Indicators for Canada from the Period following the Peak through the Trough (in +1 or 0)"""

        SwitzerlandFromPeriodFollowingPeakThroughTheTrough: str = "CHERECD"
        """OECD based Recession Indicators for Switzerland from the Period following the Peak through the Trough (in +1 or 0)"""

        ChileFromPeriodFollowingPeakThroughTheTrough: str = "CHLRECD"
        """OECD based Recession Indicators for Chile from the Period following the Peak through the Trough (in +1 or 0)"""

        ChinaFromPeriodFollowingPeakThroughTheTrough: str = "CHNRECD"
        """OECD based Recession Indicators for China from the Period following the Peak through the Trough (in +1 or 0)"""

        CzechRepublicFromPeriodFollowingPeakThroughTheTrough: str = "CZERECD"
        """OECD based Recession Indicators for the Czech Republic from the Period following the Peak through the Trough (in +1 or 0)"""

        GermanyFromPeriodFollowingPeakThroughTheTrough: str = "DEURECD"
        """OECD based Recession Indicators for Germany from the Period following the Peak through the Trough (in +1 or 0)"""

        DenmarkFromPeriodFollowingPeakThroughTheTrough: str = "DNKRECD"
        """OECD based Recession Indicators for Denmark from the Period following the Peak through the Trough (in +1 or 0)"""

        SpainFromPeriodFollowingPeakThroughTheTrough: str = "ESPRECD"
        """OECD based Recession Indicators for Spain from the Period following the Peak through the Trough (in +1 or 0)"""

        EstoniaFromPeriodFollowingPeakThroughTheTrough: str = "ESTRECD"
        """OECD based Recession Indicators for Estonia from the Period following the Peak through the Trough (in +1 or 0)"""

        EuroAreaFromPeriodFollowingPeakThroughTheTrough: str = "EURORECD"
        """OECD based Recession Indicators for Euro Area from the Period following the Peak through the Trough (in +1 or 0)"""

        FinlandFromPeriodFollowingPeakThroughTheTrough: str = "FINRECD"
        """OECD based Recession Indicators for Finland from the Period following the Peak through the Trough (in +1 or 0)"""

        FranceFromPeriodFollowingPeakThroughTheTrough: str = "FRARECD"
        """OECD based Recession Indicators for France from the Period following the Peak through the Trough (in +1 or 0)"""

        UnitedKingdomFromPeriodFollowingPeakThroughTheTrough: str = "GBRRECD"
        """OECD based Recession Indicators for the United Kingdom from the Period following the Peak through the Trough (in +1 or 0)"""

        GreeceFromPeriodFollowingPeakThroughTheTrough: str = "GRCRECD"
        """OECD based Recession Indicators for Greece from the Period following the Peak through the Trough (in +1 or 0)"""

        HungaryFromPeriodFollowingPeakThroughTheTrough: str = "HUNRECD"
        """OECD based Recession Indicators for Hungary from the Period following the Peak through the Trough (in +1 or 0)"""

        IndonesiaFromPeriodFollowingPeakThroughTheTrough: str = "IDNRECD"
        """OECD based Recession Indicators for Indonesia from the Period following the Peak through the Trough (in +1 or 0)"""

        IndiaFromPeriodFollowingPeakThroughTheTrough: str = "INDRECD"
        """OECD based Recession Indicators for India from the Period following the Peak through the Trough (in +1 or 0)"""

        IrelandFromPeriodFollowingPeakThroughTheTrough: str = "IRLRECD"
        """OECD based Recession Indicators for Ireland from the Period following the Peak through the Trough (in +1 or 0)"""

        IsraelFromPeriodFollowingPeakThroughTheTrough: str = "ISRRECD"
        """OECD based Recession Indicators for Israel from the Period following the Peak through the Trough (in +1 or 0)"""

        ItalyFromPeriodFollowingPeakThroughTheTrough: str = "ITARECD"
        """OECD based Recession Indicators for Italy from the Period following the Peak through the Trough (in +1 or 0)"""

        JapanFromPeriodFollowingPeakThroughTheTrough: str = "JPNRECD"
        """OECD based Recession Indicators for Japan from the Period following the Peak through the Trough (in +1 or 0)"""

        KoreaFromPeriodFollowingPeakThroughTheTrough: str = "KORRECD"
        """OECD based Recession Indicators for Korea from the Period following the Peak through the Trough (in +1 or 0)"""

        LuxembourgFromPeriodFollowingPeakThroughTheTrough: str = "LUXRECD"
        """OECD based Recession Indicators for Luxembourg from the Period following the Peak through the Trough (in +1 or 0)"""

        MajorFiveAsiaFromPeriodFollowingPeakThroughTheTrough: str = "MAJOR5ASIARECD"
        """OECD based Recession Indicators for Major 5 Asia from the Period following the Peak through the Trough (in +1 or 0)"""

        MexicoFromPeriodFollowingPeakThroughTheTrough: str = "MEXRECD"
        """OECD based Recession Indicators for Mexico from the Period following the Peak through the Trough (in +1 or 0)"""

        MajorSevenCountriesFromPeriodFollowingPeakThroughTheTrough: str = "MSCRECD"
        """OECD based Recession Indicators for Major Seven Countries from the Period following the Peak through the Trough (in +1 or 0)"""

        NAFTAAreaFromPeriodFollowingPeakThroughTheTrough: str = "NAFTARECD"
        """OECD based Recession Indicators for NAFTA Area from the Period following the Peak through the Trough (in +1 or 0)"""

        NetherlandsFromPeriodFollowingPeakThroughTheTrough: str = "NDLRECD"
        """OECD based Recession Indicators for Netherlands from the Period following the Peak through the Trough (in +1 or 0)"""

        NorwayFromPeriodFollowingPeakThroughTheTrough: str = "NORRECD"
        """OECD based Recession Indicators for Norway from the Period following the Peak through the Trough (in +1 or 0)"""

        NewZealandFromPeriodFollowingPeakThroughTheTrough: str = "NZLRECD"
        """OECD based Recession Indicators for New Zealand from the Period following the Peak through the Trough (in +1 or 0)"""

        OECDEuropeFromPeriodFollowingPeakThroughTheTrough: str = "OECDEUROPERECD"
        """OECD based Recession Indicators for OECD Europe from the Period following the Peak through the Trough (in +1 or 0)"""

        OECDandNonmemberEconomiesFromPeriodFollowingPeakThroughTheTrough: str = "OECDNMERECD"
        """OECD based Recession Indicators for OECD and Non-member Economies from the Period following the Peak through the Trough (in +1 or 0)"""

        OECDTotalAreaFromPeriodFollowingPeakThroughTheTrough: str = "OECDRECD"
        """OECD based Recession Indicators for the OECD Total Area from the Period following the Peak through the Trough (in +1 or 0)"""

        PolandFromPeriodFollowingPeakThroughTheTrough: str = "POLRECD"
        """OECD based Recession Indicators for Poland from the Period following the Peak through the Trough (in +1 or 0)"""

        PortugalFromPeriodFollowingPeakThroughTheTrough: str = "PRTRECD"

        RussianFederationFromPeriodFollowingPeakThroughTheTrough: str = "RUSRECD"
        """OECD based Recession Indicators for Russian Federation from the Period following the Peak through the Trough (in +1 or 0)"""

        SlovakRepublicFromPeriodFollowingPeakThroughTheTrough: str = "SVKRECD"
        """OECD based Recession Indicators for the Slovak Republic from the Period following the Peak through the Trough (in +1 or 0)"""

        SloveniaFromPeriodFollowingPeakThroughTheTrough: str = "SVNRECD"
        """OECD based Recession Indicators for Slovenia from the Period following the Peak through the Trough (in +1 or 0)"""

        SwedenFromPeriodFollowingPeakThroughTheTrough: str = "SWERECD"
        """OECD based Recession Indicators for Sweden from the Period following the Peak through the Trough (in +1 or 0)"""

        TurkeyFromPeriodFollowingPeakThroughTheTrough: str = "TURRECD"
        """OECD based Recession Indicators for Turkey from the Period following the Peak through the Trough (in +1 or 0)"""

        UnitedStatesFromPeriodFollowingPeakThroughTheTrough: str = "USARECD"
        """OECD based Recession Indicators for the United States from the Period following the Peak through the Trough (in +1 or 0)"""

        SouthAfricaFromPeriodFollowingPeakThroughTheTrough: str = "ZAFRECD"
        """OECD based Recession Indicators for South Africa from the Period following the Peak through the Trough (in +1 or 0)"""

        FourBigEuropeanCountriesFromPeakThroughThePeriodPrecedingtheTrough: str = "4BIGEURORECDP"
        """OECD based Recession Indicators for Four Big European Countries from the Peak through the Period preceding the Trough (in +1 or 0)"""

        AustraliaFromPeakThroughThePeriodPrecedingtheTrough: str = "AUSRECDP"
        """OECD based Recession Indicators for Australia from the Peak through the Period preceding the Trough (in +1 or 0)"""

        AustriaFromPeakThroughThePeriodPrecedingtheTrough: str = "AUTRECDP"
        """OECD based Recession Indicators for Austria from the Peak through the Period preceding the Trough (in +1 or 0)"""

        BelgiumFromPeakThroughThePeriodPrecedingtheTrough: str = "BELRECDP"
        """OECD based Recession Indicators for Belgium from the Peak through the Period preceding the Trough (in +1 or 0)"""

        BrazilFromPeakThroughThePeriodPrecedingtheTrough: str = "BRARECDP"
        """OECD based Recession Indicators for Brazil from the Peak through the Period preceding the Trough (in +1 or 0)"""

        CanadaFromPeakThroughThePeriodPrecedingtheTrough: str = "CANRECDP"
        """OECD based Recession Indicators for Canada from the Peak through the Period preceding the Trough (in +1 or 0)"""

        SwitzerlandFromPeakThroughThePeriodPrecedingtheTrough: str = "CHERECDP"
        """OECD based Recession Indicators for Switzerland from the Peak through the Period preceding the Trough (in +1 or 0)"""

        ChileFromPeakThroughThePeriodPrecedingtheTrough: str = "CHLRECDP"
        """OECD based Recession Indicators for Chile from the Peak through the Period preceding the Trough (in +1 or 0)"""

        ChinaFromPeakThroughThePeriodPrecedingtheTrough: str = "CHNRECDP"
        """OECD based Recession Indicators for China from the Peak through the Period preceding the Trough (in +1 or 0)"""

        CzechRepublicFromPeakThroughThePeriodPrecedingtheTrough: str = "CZERECDP"
        """OECD based Recession Indicators for the Czech Republic from the Peak through the Period preceding the Trough (in +1 or 0)"""

        GermanyFromPeakThroughThePeriodPrecedingtheTrough: str = "DEURECDP"
        """OECD based Recession Indicators for Germany from the Peak through the Period preceding the Trough (in +1 or 0)"""

        DenmarkFromPeakThroughThePeriodPrecedingtheTrough: str = "DNKRECDP"
        """OECD based Recession Indicators for Denmark from the Peak through the Period preceding the Trough (in +1 or 0)"""

        SpainFromPeakThroughThePeriodPrecedingtheTrough: str = "ESPRECDP"
        """OECD based Recession Indicators for Spain from the Peak through the Period preceding the Trough (in +1 or 0)"""

        EstoniaFromPeakThroughThePeriodPrecedingtheTrough: str = "ESTRECDP"
        """OECD based Recession Indicators for Estonia from the Peak through the Period preceding the Trough (in +1 or 0)"""

        EuroAreaFromPeakThroughThePeriodPrecedingtheTrough: str = "EURORECDP"
        """OECD based Recession Indicators for Euro Area from the Peak through the Period preceding the Trough (in +1 or 0)"""

        FinlandFromPeakThroughThePeriodPrecedingtheTrough: str = "FINRECDP"
        """OECD based Recession Indicators for Finland from the Peak through the Period preceding the Trough (in +1 or 0)"""

        FranceFromPeakThroughThePeriodPrecedingtheTrough: str = "FRARECDP"
        """OECD based Recession Indicators for France from the Peak through the Period preceding the Trough (in +1 or 0)"""

        UnitedKingdomFromPeakThroughThePeriodPrecedingtheTrough: str = "GBRRECDP"
        """OECD based Recession Indicators for the United Kingdom from the Peak through the Period preceding the Trough (in +1 or 0)"""

        GreeceFromPeakThroughThePeriodPrecedingtheTrough: str = "GRCRECDP"
        """OECD based Recession Indicators for Greece from the Peak through the Period preceding the Trough (in +1 or 0)"""

        HungaryFromPeakThroughThePeriodPrecedingtheTrough: str = "HUNRECDP"
        """OECD based Recession Indicators for Hungary from the Peak through the Period preceding the Trough (in +1 or 0)"""

        IndonesiaFromPeakThroughThePeriodPrecedingtheTrough: str = "IDNRECDP"
        """OECD based Recession Indicators for Indonesia from the Peak through the Period preceding the Trough (in +1 or 0)"""

        IndiaFromPeakThroughThePeriodPrecedingtheTrough: str = "INDRECDP"
        """OECD based Recession Indicators for India from the Peak through the Period preceding the Trough (in +1 or 0)"""

        IrelandFromPeakThroughThePeriodPrecedingtheTrough: str = "IRLRECDP"
        """OECD based Recession Indicators for Ireland from the Peak through the Period preceding the Trough (in +1 or 0)"""

        IsraelFromPeakThroughThePeriodPrecedingtheTrough: str = "ISRRECDP"
        """OECD based Recession Indicators for Israel from the Peak through the Period preceding the Trough (in +1 or 0)"""

        ItalyFromPeakThroughThePeriodPrecedingtheTrough: str = "ITARECDP"
        """OECD based Recession Indicators for Italy from the Peak through the Period preceding the Trough (in +1 or 0)"""

        JapanFromPeakThroughThePeriodPrecedingtheTrough: str = "JPNRECDP"
        """OECD based Recession Indicators for Japan from the Peak through the Period preceding the Trough (in +1 or 0)"""

        KoreaFromPeakThroughThePeriodPrecedingtheTrough: str = "KORRECDP"
        """OECD based Recession Indicators for Korea from the Peak through the Period preceding the Trough (in +1 or 0)"""

        LuxembourgFromPeakThroughThePeriodPrecedingtheTrough: str = "LUXRECDP"
        """OECD based Recession Indicators for Luxembourg from the Peak through the Period preceding the Trough (in +1 or 0)"""

        MajorFiveAsiaFromPeakThroughThePeriodPrecedingtheTrough: str = "MAJOR5ASIARECDP"
        """OECD based Recession Indicators for Major 5 Asia from the Peak through the Period preceding the Trough (in +1 or 0)"""

        MexicoFromPeakThroughThePeriodPrecedingtheTrough: str = "MEXRECDP"
        """OECD based Recession Indicators for Mexico from the Peak through the Period preceding the Trough (in +1 or 0)"""

        MajorSevenCountriesFromPeakThroughThePeriodPrecedingtheTrough: str = "MSCRECDP"
        """OECD based Recession Indicators for Major Seven Countries from the Peak through the Period preceding the Trough (in +1 or 0)"""

        NAFTAAreaFromPeakThroughThePeriodPrecedingtheTrough: str = "NAFTARECDP"
        """OECD based Recession Indicators for NAFTA Area from the Peak through the Period preceding the Trough (in +1 or 0)"""

        NetherlandsFromPeakThroughThePeriodPrecedingtheTrough: str = "NDLRECDP"
        """OECD based Recession Indicators for Netherlands from the Peak through the Period preceding the Trough (in +1 or 0)"""

        NorwayFromPeakThroughThePeriodPrecedingtheTrough: str = "NORRECDP"
        """OECD based Recession Indicators for Norway from the Peak through the Period preceding the Trough (in +1 or 0)"""

        NewZealandFromPeakThroughThePeriodPrecedingtheTrough: str = "NZLRECDP"

        OECDEuropeFromPeakThroughThePeriodPrecedingtheTrough: str = "OECDEUROPERECDP"
        """OECD based Recession Indicators for OECD Europe from the Peak through the Period preceding the Trough (in +1 or 0)"""

        OECDandNonmemberEconomiesFromPeakThroughThePeriodPrecedingtheTrough: str = "OECDNMERECDP"
        """OECD based Recession Indicators for OECD and Non-member Economies from the Peak through the Period preceding the Trough (in +1 or 0)"""

        OECDTotalAreaFromPeakThroughThePeriodPrecedingtheTrough: str = "OECDRECDP"
        """OECD based Recession Indicators for the OECD Total Area from the Peak through the Period preceding the Trough (in +1 or 0)"""

        PolandFromPeakThroughThePeriodPrecedingtheTrough: str = "POLRECDP"
        """OECD based Recession Indicators for Poland from the Peak through the Period preceding the Trough (in +1 or 0)"""

        PortugalFromPeakThroughThePeriodPrecedingtheTrough: str = "PRTRECDP"
        """OECD based Recession Indicators for Portugal from the Peak through the Period preceding the Trough (in +1 or 0)"""

        RussianFederationFromPeakThroughThePeriodPrecedingtheTrough: str = "RUSRECDP"
        """OECD based Recession Indicators for Russian Federation from the Peak through the Period preceding the Trough (in +1 or 0)"""

        SlovakRepublicFromPeakThroughThePeriodPrecedingtheTrough: str = "SVKRECDP"
        """OECD based Recession Indicators for the Slovak Republic from the Peak through the Period preceding the Trough (in +1 or 0)"""

        SloveniaFromPeakThroughThePeriodPrecedingtheTrough: str = "SVNRECDP"
        """OECD based Recession Indicators for Slovenia from the Peak through the Period preceding the Trough (in +1 or 0)"""

        SwedenFromPeakThroughThePeriodPrecedingtheTrough: str = "SWERECDP"
        """OECD based Recession Indicators for Sweden from the Peak through the Period preceding the Trough (in +1 or 0)"""

        TurkeyFromPeakThroughThePeriodPrecedingtheTrough: str = "TURRECDP"
        """OECD based Recession Indicators for Turkey from the Peak through the Period preceding the Trough (in +1 or 0)"""

        UnitedStatesFromPeakThroughThePeriodPrecedingtheTrough: str = "USARECDP"
        """OECD based Recession Indicators for the United States from the Peak through the Period preceding the Trough (in +1 or 0)"""

        SouthAfricaFromPeakThroughThePeriodPrecedingtheTrough: str = "ZAFRECDP"
        """OECD based Recession Indicators for South Africa from the Peak through the Period preceding the Trough (in +1 or 0)"""

    DataSourceId: int
    """Data source ID"""

    def Clone(self) -> QuantConnect.Data.BaseData:
        """
        Clones the data
        
        :returns: A clone of the object.
        """
        ...

    def DefaultResolution(self) -> int:
        """
        Gets the default resolution for this data and security type
        
        :returns: This method returns the int value of a member of the QuantConnect.Resolution enum.
        """
        ...

    def GetSource(self, config: QuantConnect.Data.SubscriptionDataConfig, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.SubscriptionDataSource:
        """
        Return the URL string source of the file. This will be converted to a stream
        
        :param config: Configuration object
        :param date: Date of this source file
        :param isLiveMode: true if we're in live mode, false for backtesting mode
        :returns: String URL of source file.
        """
        ...

    def IsSparseData(self) -> bool:
        """
        Indicates whether the data is sparse.
        If true, we disable logging for missing files
        
        :returns: true.
        """
        ...

    def Reader(self, config: QuantConnect.Data.SubscriptionDataConfig, line: str, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.BaseData:
        """
        Parses the data from the line provided and loads it into LEAN
        
        :param config: Subscription configuration
        :param line: Line of data
        :param date: Date
        :param isLiveMode: Is live mode
        :returns: New instance of USEnergy.
        """
        ...

    def RequiresMapping(self) -> bool:
        """
        Indicates whether the data source is tied
        to an underlying symbol and requires that corporate
        events be applied to it as well, such as renames and delistings
        
        :returns: false.
        """
        ...

    def SupportedResolutions(self) -> System.Collections.Generic.List[QuantConnect.Resolution]:
        """Gets the supported resolution for this data and security type"""
        ...

    def ToString(self) -> str:
        """Converts the instance to string"""
        ...


class FredApi(QuantConnect.Data.BaseData):
    """This class has no documentation."""

    class Observation(System.Object):
        """This class has no documentation."""

        @property
        def RealtimeStart(self) -> str:
            ...

        @RealtimeStart.setter
        def RealtimeStart(self, value: str):
            ...

        @property
        def RealtimeEnd(self) -> str:
            ...

        @RealtimeEnd.setter
        def RealtimeEnd(self, value: str):
            ...

        @property
        def Date(self) -> datetime.datetime:
            ...

        @Date.setter
        def Date(self, value: datetime.datetime):
            ...

        @property
        def Value(self) -> str:
            ...

        @Value.setter
        def Value(self, value: str):
            ...

    DataSourceId: int
    """Data source ID"""

    @property
    def RealtimeStart(self) -> str:
        ...

    @RealtimeStart.setter
    def RealtimeStart(self, value: str):
        ...

    @property
    def RealtimeEnd(self) -> str:
        ...

    @RealtimeEnd.setter
    def RealtimeEnd(self, value: str):
        ...

    @property
    def ObservationStart(self) -> str:
        ...

    @ObservationStart.setter
    def ObservationStart(self, value: str):
        ...

    @property
    def ObservationEnd(self) -> str:
        ...

    @ObservationEnd.setter
    def ObservationEnd(self, value: str):
        ...

    @property
    def Units(self) -> str:
        ...

    @Units.setter
    def Units(self, value: str):
        ...

    @property
    def OutputType(self) -> int:
        ...

    @OutputType.setter
    def OutputType(self, value: int):
        ...

    @property
    def FileType(self) -> str:
        ...

    @FileType.setter
    def FileType(self, value: str):
        ...

    @property
    def OrderBy(self) -> str:
        ...

    @OrderBy.setter
    def OrderBy(self, value: str):
        ...

    @property
    def SortOrder(self) -> str:
        ...

    @SortOrder.setter
    def SortOrder(self, value: str):
        ...

    @property
    def Count(self) -> int:
        ...

    @Count.setter
    def Count(self, value: int):
        ...

    @property
    def Offset(self) -> int:
        ...

    @Offset.setter
    def Offset(self, value: int):
        ...

    @property
    def Limit(self) -> int:
        ...

    @Limit.setter
    def Limit(self, value: int):
        ...

    @property
    def Observations(self) -> System.Collections.Generic.IList[QuantConnect.DataSource.FredApi.Observation]:
        ...

    @Observations.setter
    def Observations(self, value: System.Collections.Generic.IList[QuantConnect.DataSource.FredApi.Observation]):
        ...

    AuthCode: str

    IsAuthCodeSet: bool
    """Returns true if the FRED API token has been set."""

    def GetSource(self, config: QuantConnect.Data.SubscriptionDataConfig, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.SubscriptionDataSource:
        """
        Return the URL string source of the file. This will be converted to a stream
        
        :param config: Configuration object
        :param date: Date of this source file
        :param isLiveMode: true if we're in live mode, false for backtesting mode
        :returns: String URL of source file.
        """
        ...

    def Reader(self, config: QuantConnect.Data.SubscriptionDataConfig, content: str, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.BaseData:
        """
        Readers the specified configuration.
        
        :param config: The configuration.
        :param content: The content.
        :param date: The date.
        :param isLiveMode: if set to true [is live mode].
        """
        ...

    @staticmethod
    def SetAuthCode(authCode: str) -> None:
        """
        Sets the EIA API token.
        
        :param authCode: The EIA API token
        """
        ...


class KavoutCompositeFactorBundle(QuantConnect.Data.BaseData):
    """
    Kavout signals are machine-learning enhanced scores that capture the returns
    of systematic factors such as Quality, Value, Momentum, Growth, and Low Volatility.
    There are many different anomalies discovered by researchers and practitioners across
    these factor categories, and there is no good common definition of each style
    across the literature.
    
    Kavout creates an ensemble score for each style that gauges the different factors
    considered in the literature and industry practice.
    
    Each signal is generated by an ensemble model consisting of inputs from hundreds of anomalies.
    """

    @property
    def Growth(self) -> float:
        """Growth factor score"""
        ...

    @Growth.setter
    def Growth(self, value: float):
        """Growth factor score"""
        ...

    @property
    def ValueFactor(self) -> float:
        """Value factor score"""
        ...

    @ValueFactor.setter
    def ValueFactor(self, value: float):
        """Value factor score"""
        ...

    @property
    def Quality(self) -> float:
        """Quality factor score"""
        ...

    @Quality.setter
    def Quality(self, value: float):
        """Quality factor score"""
        ...

    @property
    def Momentum(self) -> float:
        """Momentum factor score"""
        ...

    @Momentum.setter
    def Momentum(self, value: float):
        """Momentum factor score"""
        ...

    @property
    def LowVolatility(self) -> float:
        """Low volatility factor score"""
        ...

    @LowVolatility.setter
    def LowVolatility(self, value: float):
        """Low volatility factor score"""
        ...

    @property
    def EndTime(self) -> datetime.datetime:
        """The time that the data became available to the algorithm"""
        ...

    @EndTime.setter
    def EndTime(self, value: datetime.datetime):
        """The time that the data became available to the algorithm"""
        ...

    def Clone(self) -> QuantConnect.Data.BaseData:
        """
        Return a new instance clone of this object, used in fill forward
        
        :returns: A clone of the current object.
        """
        ...

    def DataTimeZone(self) -> typing.Any:
        """
        Specifies the data time zone for this data type. This is useful for custom data types
        
        :returns: The NodaTime.DateTimeZone of this data type.
        """
        ...

    def GetSource(self, config: QuantConnect.Data.SubscriptionDataConfig, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.SubscriptionDataSource:
        """
        Return the URL string source of the file. This will be converted to a stream
        
        :param config: Configuration object
        :param date: Date of this source file
        :param isLiveMode: true if we're in live mode, false for backtesting mode
        :returns: String URL of source file.
        """
        ...

    def IsSparseData(self) -> bool:
        """
        Indicates that the data set is expected to be sparse
        
        :returns: True if the data set represented by this type is expected to be sparse.
        """
        ...

    def Reader(self, config: QuantConnect.Data.SubscriptionDataConfig, line: str, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.BaseData:
        """
        Reader converts each line of the data source into BaseData objects. Each data type creates its own factory method, and returns a new instance of the object
        each time it is called. The returned object is assumed to be time stamped in the config.ExchangeTimeZone.
        
        :param config: Subscription data config setup object
        :param line: Line of the source document
        :param date: Date of the requested data
        :param isLiveMode: true if we're in live mode, false for backtesting mode
        :returns: Instance of the T:BaseData object generated by this line of the CSV.
        """
        ...

    def RequiresMapping(self) -> bool:
        """
        Indicates if there is support for mapping
        
        :returns: True indicates mapping should be used.
        """
        ...

    def ToString(self) -> str:
        """
        Formats a string with Cross-asset model data
        
        :returns: string containing Cross-asset model information.
        """
        ...


class BrainCompanyFilingLanguageMetricsSimilarityDifference(System.Object):
    """This class has no documentation."""

    @property
    def All(self) -> typing.Optional[float]:
        ...

    @All.setter
    def All(self, value: typing.Optional[float]):
        ...

    @property
    def Positive(self) -> typing.Optional[float]:
        ...

    @Positive.setter
    def Positive(self, value: typing.Optional[float]):
        ...

    @property
    def Negative(self) -> typing.Optional[float]:
        ...

    @Negative.setter
    def Negative(self, value: typing.Optional[float]):
        ...

    @property
    def Uncertainty(self) -> typing.Optional[float]:
        ...

    @Uncertainty.setter
    def Uncertainty(self, value: typing.Optional[float]):
        ...

    @property
    def Litigious(self) -> typing.Optional[float]:
        ...

    @Litigious.setter
    def Litigious(self, value: typing.Optional[float]):
        ...

    @property
    def Constraining(self) -> typing.Optional[float]:
        ...

    @Constraining.setter
    def Constraining(self, value: typing.Optional[float]):
        ...

    @property
    def Interesting(self) -> typing.Optional[float]:
        ...

    @Interesting.setter
    def Interesting(self, value: typing.Optional[float]):
        ...

    @staticmethod
    def Parse(similarityValues: System.Collections.Generic.List[str]) -> QuantConnect.DataSource.BrainCompanyFilingLanguageMetricsSimilarityDifference:
        ...


class BrainCompanyFilingLanguageMetrics(System.Object):
    """This class has no documentation."""

    @property
    def SentenceCount(self) -> typing.Optional[int]:
        ...

    @SentenceCount.setter
    def SentenceCount(self, value: typing.Optional[int]):
        ...

    @property
    def MeanSentenceLength(self) -> typing.Optional[float]:
        ...

    @MeanSentenceLength.setter
    def MeanSentenceLength(self, value: typing.Optional[float]):
        ...

    @property
    def Sentiment(self) -> typing.Optional[float]:
        ...

    @Sentiment.setter
    def Sentiment(self, value: typing.Optional[float]):
        ...

    @property
    def Uncertainty(self) -> typing.Optional[float]:
        ...

    @Uncertainty.setter
    def Uncertainty(self, value: typing.Optional[float]):
        ...

    @property
    def Litigious(self) -> typing.Optional[float]:
        ...

    @Litigious.setter
    def Litigious(self, value: typing.Optional[float]):
        ...

    @property
    def Constraining(self) -> typing.Optional[float]:
        ...

    @Constraining.setter
    def Constraining(self, value: typing.Optional[float]):
        ...

    @property
    def Interesting(self) -> typing.Optional[float]:
        ...

    @Interesting.setter
    def Interesting(self, value: typing.Optional[float]):
        ...

    @property
    def Readability(self) -> typing.Optional[float]:
        ...

    @Readability.setter
    def Readability(self, value: typing.Optional[float]):
        ...

    @property
    def LexicalRichness(self) -> typing.Optional[float]:
        ...

    @LexicalRichness.setter
    def LexicalRichness(self, value: typing.Optional[float]):
        ...

    @property
    def LexicalDensity(self) -> typing.Optional[float]:
        ...

    @LexicalDensity.setter
    def LexicalDensity(self, value: typing.Optional[float]):
        ...

    @property
    def SpecificDensity(self) -> typing.Optional[float]:
        ...

    @SpecificDensity.setter
    def SpecificDensity(self, value: typing.Optional[float]):
        ...

    @property
    def Similarity(self) -> QuantConnect.DataSource.BrainCompanyFilingLanguageMetricsSimilarityDifference:
        ...

    @Similarity.setter
    def Similarity(self, value: QuantConnect.DataSource.BrainCompanyFilingLanguageMetricsSimilarityDifference):
        ...

    @staticmethod
    def Parse(metrics: System.Collections.Generic.List[str], similarity: System.Collections.Generic.List[str] = None) -> QuantConnect.DataSource.BrainCompanyFilingLanguageMetrics:
        ...


class BrainStockRankingBase(typing.Generic[QuantConnect_DataSource_BrainStockRankingBase_T], QuantConnect.Data.BaseData):
    """Brain sentiment on 10-K/10-Q SEC reports"""

    @property
    def Rank(self) -> float:
        ...

    @Rank.setter
    def Rank(self, value: float):
        ...

    @property
    def LookbackDays(self) -> int:
        """This property is protected."""
        ...

    @LookbackDays.setter
    def LookbackDays(self, value: int):
        """This property is protected."""
        ...

    def Clone(self) -> QuantConnect.Data.BaseData:
        """
        Clones the data
        
        :returns: A clone of the object.
        """
        ...

    def CloneData(self) -> QuantConnect_DataSource_BrainStockRankingBase_T:
        """This method is protected."""
        ...

    def DataTimeZone(self) -> typing.Any:
        """
        Specifies the data time zone for this data type. This is useful for custom data types
        
        :returns: The NodaTime.DateTimeZone of this data type.
        """
        ...

    def DefaultResolution(self) -> int:
        """
        Gets the default resolution for this data and security type
        
        :returns: This method returns the int value of a member of the QuantConnect.Resolution enum.
        """
        ...

    def GetSource(self, config: QuantConnect.Data.SubscriptionDataConfig, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.SubscriptionDataSource:
        """
        Return the URL string source of the file. This will be converted to a stream
        
        :param config: Configuration object
        :param date: Date of this source file
        :param isLiveMode: true if we're in live mode, false for backtesting mode
        :returns: String URL of source file.
        """
        ...

    def IsSparseData(self) -> bool:
        """
        Indicates whether the data is sparse.
        If true, we disable logging for missing files
        
        :returns: true.
        """
        ...

    def Reader(self, config: QuantConnect.Data.SubscriptionDataConfig, line: str, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.BaseData:
        """
        Parses the data from the line provided and loads it into LEAN
        
        :param config: Subscription configuration
        :param line: Line of data
        :param date: Date
        :param isLiveMode: Is live mode
        :returns: New instance.
        """
        ...

    def RequiresMapping(self) -> bool:
        """
        Indicates whether the data source is tied to an underlying symbol and requires that corporate events be applied to it as well, such as renames and delistings
        
        :returns: false.
        """
        ...

    def SupportedResolutions(self) -> System.Collections.Generic.List[QuantConnect.Resolution]:
        """Gets the supported resolution for this data and security type"""
        ...

    def ToString(self) -> str:
        """Converts the instance to string"""
        ...


class BrainStockRanking3Day(QuantConnect.DataSource.BrainStockRankingBase[QuantConnect_DataSource_BrainStockRanking3Day]):
    """Brain universe stock rankings on expected returns in the next 3 days"""

    DataSourceId: int
    """Data source ID"""

    @property
    def LookbackDays(self) -> int:
        """This property is protected."""
        ...

    @LookbackDays.setter
    def LookbackDays(self, value: int):
        """This property is protected."""
        ...


class BrainStockRanking2Day(QuantConnect.DataSource.BrainStockRankingBase[QuantConnect_DataSource_BrainStockRanking2Day]):
    """Brain universe stock rankings on expected returns in the next 2 days"""

    DataSourceId: int
    """Data source ID"""

    @property
    def LookbackDays(self) -> int:
        """This property is protected."""
        ...

    @LookbackDays.setter
    def LookbackDays(self, value: int):
        """This property is protected."""
        ...


class BrainStockRankingUniverse(QuantConnect.Data.BaseData):
    """Universe Selection helper class for Brain ML Stock Ranking dataset"""

    @property
    def Rank2Days(self) -> typing.Optional[float]:
        """Rank prediction score in 2 days"""
        ...

    @Rank2Days.setter
    def Rank2Days(self, value: typing.Optional[float]):
        """Rank prediction score in 2 days"""
        ...

    @property
    def Rank3Days(self) -> typing.Optional[float]:
        """Rank prediction score in 3 days"""
        ...

    @Rank3Days.setter
    def Rank3Days(self, value: typing.Optional[float]):
        """Rank prediction score in 3 days"""
        ...

    @property
    def Rank5Days(self) -> typing.Optional[float]:
        """Rank prediction score in 5 days"""
        ...

    @Rank5Days.setter
    def Rank5Days(self, value: typing.Optional[float]):
        """Rank prediction score in 5 days"""
        ...

    @property
    def Rank10Days(self) -> typing.Optional[float]:
        """Rank prediction score in 10 days"""
        ...

    @Rank10Days.setter
    def Rank10Days(self, value: typing.Optional[float]):
        """Rank prediction score in 10 days"""
        ...

    @property
    def Rank21Days(self) -> typing.Optional[float]:
        """Rank prediction score in 21 days"""
        ...

    @Rank21Days.setter
    def Rank21Days(self, value: typing.Optional[float]):
        """Rank prediction score in 21 days"""
        ...

    @property
    def EndTime(self) -> datetime.datetime:
        """Time the data became available"""
        ...

    @EndTime.setter
    def EndTime(self, value: datetime.datetime):
        """Time the data became available"""
        ...

    def DataTimeZone(self) -> typing.Any:
        """
        Specifies the data time zone for this data type. This is useful for custom data types
        
        :returns: The NodaTime.DateTimeZone of this data type.
        """
        ...

    def DefaultResolution(self) -> int:
        """
        Gets the default resolution for this data and security type
        
        :returns: This method returns the int value of a member of the QuantConnect.Resolution enum.
        """
        ...

    def GetSource(self, config: QuantConnect.Data.SubscriptionDataConfig, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.SubscriptionDataSource:
        """
        Return the URL string source of the file. This will be converted to a stream
        
        :param config: Configuration object
        :param date: Date of this source file
        :param isLiveMode: true if we're in live mode, false for backtesting mode
        :returns: String URL of source file.
        """
        ...

    def Reader(self, config: QuantConnect.Data.SubscriptionDataConfig, line: str, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.BaseData:
        """
        Parses the data from the line provided and loads it into LEAN
        
        :param config: Subscription configuration
        :param line: Line of data
        :param date: Date
        :param isLiveMode: Is live mode
        :returns: New instance.
        """
        ...

    def SupportedResolutions(self) -> System.Collections.Generic.List[QuantConnect.Resolution]:
        """Gets the supported resolution for this data and security type"""
        ...

    def ToString(self) -> str:
        """Converts the instance to string"""
        ...


class BrainStockRanking5Day(QuantConnect.DataSource.BrainStockRankingBase[QuantConnect_DataSource_BrainStockRanking5Day]):
    """Brain universe stock rankings on expected returns in the next 5 days"""

    DataSourceId: int
    """Data source ID"""

    @property
    def LookbackDays(self) -> int:
        """This property is protected."""
        ...

    @LookbackDays.setter
    def LookbackDays(self, value: int):
        """This property is protected."""
        ...


class BrainCompanyFilingLanguageMetricsBase(typing.Generic[QuantConnect_DataSource_BrainCompanyFilingLanguageMetricsBase_T], QuantConnect.Data.BaseData):
    """Brain sentiment on 10-K/10-Q SEC reports"""

    @property
    def ReportDate(self) -> datetime.datetime:
        ...

    @ReportDate.setter
    def ReportDate(self, value: datetime.datetime):
        ...

    @property
    def ReportCategory(self) -> str:
        ...

    @ReportCategory.setter
    def ReportCategory(self, value: str):
        ...

    @property
    def ReportPeriod(self) -> typing.Optional[int]:
        ...

    @ReportPeriod.setter
    def ReportPeriod(self, value: typing.Optional[int]):
        ...

    @property
    def PreviousReportDate(self) -> typing.Optional[datetime.datetime]:
        ...

    @PreviousReportDate.setter
    def PreviousReportDate(self, value: typing.Optional[datetime.datetime]):
        ...

    @property
    def PreviousReportCategory(self) -> str:
        ...

    @PreviousReportCategory.setter
    def PreviousReportCategory(self, value: str):
        ...

    @property
    def PreviousReportPeriod(self) -> typing.Optional[int]:
        ...

    @PreviousReportPeriod.setter
    def PreviousReportPeriod(self, value: typing.Optional[int]):
        ...

    @property
    def ReportSentiment(self) -> QuantConnect.DataSource.BrainCompanyFilingLanguageMetrics:
        ...

    @ReportSentiment.setter
    def ReportSentiment(self, value: QuantConnect.DataSource.BrainCompanyFilingLanguageMetrics):
        ...

    @property
    def RiskFactorsStatementSentiment(self) -> QuantConnect.DataSource.BrainCompanyFilingLanguageMetrics:
        ...

    @RiskFactorsStatementSentiment.setter
    def RiskFactorsStatementSentiment(self, value: QuantConnect.DataSource.BrainCompanyFilingLanguageMetrics):
        ...

    @property
    def ManagementDiscussionAnalyasisOfFinancialConditionAndResultsOfOperations(self) -> QuantConnect.DataSource.BrainCompanyFilingLanguageMetrics:
        ...

    @ManagementDiscussionAnalyasisOfFinancialConditionAndResultsOfOperations.setter
    def ManagementDiscussionAnalyasisOfFinancialConditionAndResultsOfOperations(self, value: QuantConnect.DataSource.BrainCompanyFilingLanguageMetrics):
        ...

    @property
    def ReportType(self) -> str:
        """This property is protected."""
        ...

    @ReportType.setter
    def ReportType(self, value: str):
        """This property is protected."""
        ...

    def Clone(self) -> QuantConnect.Data.BaseData:
        ...

    def CloneData(self) -> QuantConnect_DataSource_BrainCompanyFilingLanguageMetricsBase_T:
        """
        Clones the data
        
        This method is protected.
        
        :returns: A clone of the object.
        """
        ...

    def DataTimeZone(self) -> typing.Any:
        """
        Specifies the data time zone for this data type. This is useful for custom data types
        
        :returns: The NodaTime.DateTimeZone of this data type.
        """
        ...

    def DefaultResolution(self) -> int:
        """
        Gets the default resolution for this data and security type
        
        :returns: This method returns the int value of a member of the QuantConnect.Resolution enum.
        """
        ...

    def GetSource(self, config: QuantConnect.Data.SubscriptionDataConfig, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.SubscriptionDataSource:
        """
        Return the URL string source of the file. This will be converted to a stream
        
        :param config: Configuration object
        :param date: Date of this source file
        :param isLiveMode: true if we're in live mode, false for backtesting mode
        :returns: String URL of source file.
        """
        ...

    def IsSparseData(self) -> bool:
        """
        Indicates whether the data is sparse.
        If true, we disable logging for missing files
        
        :returns: true.
        """
        ...

    def Reader(self, config: QuantConnect.Data.SubscriptionDataConfig, line: str, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.BaseData:
        """
        Parses the data from the line provided and loads it into LEAN
        
        :param config: Subscription configuration
        :param line: Line of data
        :param date: Date
        :param isLiveMode: Is live mode
        :returns: New instance.
        """
        ...

    def RequiresMapping(self) -> bool:
        """
        Indicates whether the data source is tied to an underlying symbol and requires that corporate events be applied to it as well, such as renames and delistings
        
        :returns: false.
        """
        ...

    def SupportedResolutions(self) -> System.Collections.Generic.List[QuantConnect.Resolution]:
        """Gets the supported resolution for this data and security type"""
        ...

    def ToString(self) -> str:
        """Converts the instance to string"""
        ...


class BrainCompanyFilingLanguageMetricsUniverse(typing.Generic[QuantConnect_DataSource_BrainCompanyFilingLanguageMetricsUniverse_T], QuantConnect.Data.BaseData):
    """Universe Selection helper class for BrainCompanyFilingLanguageMetrics dataset"""

    @property
    def ReportSentiment(self) -> QuantConnect.DataSource.BrainCompanyFilingLanguageMetrics:
        """Language Metric score by report part"""
        ...

    @ReportSentiment.setter
    def ReportSentiment(self, value: QuantConnect.DataSource.BrainCompanyFilingLanguageMetrics):
        """Language Metric score by report part"""
        ...

    @property
    def RiskFactorsStatementSentiment(self) -> QuantConnect.DataSource.BrainCompanyFilingLanguageMetrics:
        """Language Metric score by risk factor statement part"""
        ...

    @RiskFactorsStatementSentiment.setter
    def RiskFactorsStatementSentiment(self, value: QuantConnect.DataSource.BrainCompanyFilingLanguageMetrics):
        """Language Metric score by risk factor statement part"""
        ...

    @property
    def ManagementDiscussionAnalyasisOfFinancialConditionAndResultsOfOperations(self) -> QuantConnect.DataSource.BrainCompanyFilingLanguageMetrics:
        """Language Metric score by Management Discussion Analyasis Of Financial Condition And Results Of Operations"""
        ...

    @ManagementDiscussionAnalyasisOfFinancialConditionAndResultsOfOperations.setter
    def ManagementDiscussionAnalyasisOfFinancialConditionAndResultsOfOperations(self, value: QuantConnect.DataSource.BrainCompanyFilingLanguageMetrics):
        """Language Metric score by Management Discussion Analyasis Of Financial Condition And Results Of Operations"""
        ...

    @property
    def ReportType(self) -> str:
        """
        Report Type of which the language metric came from
        
        This property is protected.
        """
        ...

    @ReportType.setter
    def ReportType(self, value: str):
        """
        Report Type of which the language metric came from
        
        This property is protected.
        """
        ...

    @property
    def EndTime(self) -> datetime.datetime:
        """Time the data became available"""
        ...

    @EndTime.setter
    def EndTime(self, value: datetime.datetime):
        """Time the data became available"""
        ...

    def DataTimeZone(self) -> typing.Any:
        """
        Specifies the data time zone for this data type. This is useful for custom data types
        
        :returns: The NodaTime.DateTimeZone of this data type.
        """
        ...

    def DefaultResolution(self) -> int:
        """
        Gets the default resolution for this data and security type
        
        :returns: This method returns the int value of a member of the QuantConnect.Resolution enum.
        """
        ...

    def GetSource(self, config: QuantConnect.Data.SubscriptionDataConfig, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.SubscriptionDataSource:
        """
        Return the URL string source of the file. This will be converted to a stream
        
        :param config: Configuration object
        :param date: Date of this source file
        :param isLiveMode: true if we're in live mode, false for backtesting mode
        :returns: String URL of source file.
        """
        ...

    def Reader(self, config: QuantConnect.Data.SubscriptionDataConfig, line: str, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.BaseData:
        """
        Parses the data from the line provided and loads it into LEAN
        
        :param config: Subscription configuration
        :param line: Line of data
        :param date: Date
        :param isLiveMode: Is live mode
        :returns: New instance.
        """
        ...

    def SupportedResolutions(self) -> System.Collections.Generic.List[QuantConnect.Resolution]:
        """Gets the supported resolution for this data and security type"""
        ...

    def ToString(self) -> str:
        """Converts the instance to string"""
        ...


class BrainCompanyFilingLanguageMetricsUniverse10K(QuantConnect.DataSource.BrainCompanyFilingLanguageMetricsUniverse[QuantConnect_DataSource_BrainCompanyFilingLanguageMetricsUniverse10K]):
    """Brain sentiment universe on only 10-K SEC reports"""

    @property
    def ReportType(self) -> str:
        """This property is protected."""
        ...

    @ReportType.setter
    def ReportType(self, value: str):
        """This property is protected."""
        ...


class BrainSentimentIndicatorBase(typing.Generic[QuantConnect_DataSource_BrainSentimentIndicatorBase_T], QuantConnect.Data.BaseData):
    """Brain sentiment on news"""

    @property
    def TotalArticleMentions(self) -> int:
        ...

    @TotalArticleMentions.setter
    def TotalArticleMentions(self, value: int):
        ...

    @property
    def SentimentalArticleMentions(self) -> float:
        ...

    @SentimentalArticleMentions.setter
    def SentimentalArticleMentions(self, value: float):
        ...

    @property
    def Sentiment(self) -> float:
        ...

    @Sentiment.setter
    def Sentiment(self, value: float):
        ...

    @property
    def TotalBuzzVolume(self) -> typing.Optional[float]:
        ...

    @TotalBuzzVolume.setter
    def TotalBuzzVolume(self, value: typing.Optional[float]):
        ...

    @property
    def SentimentalBuzzVolume(self) -> typing.Optional[float]:
        ...

    @SentimentalBuzzVolume.setter
    def SentimentalBuzzVolume(self, value: typing.Optional[float]):
        ...

    @property
    def LookbackDays(self) -> int:
        """This property is protected."""
        ...

    @LookbackDays.setter
    def LookbackDays(self, value: int):
        """This property is protected."""
        ...

    def CloneData(self) -> QuantConnect_DataSource_BrainSentimentIndicatorBase_T:
        """
        Clones the data
        
        This method is protected.
        
        :returns: A clone of the object.
        """
        ...

    def DataTimeZone(self) -> typing.Any:
        """
        Specifies the data time zone for this data type. This is useful for custom data types
        
        :returns: The NodaTime.DateTimeZone of this data type.
        """
        ...

    def DefaultResolution(self) -> int:
        """
        Gets the default resolution for this data and security type
        
        :returns: This method returns the int value of a member of the QuantConnect.Resolution enum.
        """
        ...

    def GetSource(self, config: QuantConnect.Data.SubscriptionDataConfig, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.SubscriptionDataSource:
        """
        Return the URL string source of the file. This will be converted to a stream
        
        :param config: Configuration object
        :param date: Date of this source file
        :param isLiveMode: true if we're in live mode, false for backtesting mode
        :returns: String URL of source file.
        """
        ...

    def IsSparseData(self) -> bool:
        """
        Indicates whether the data is sparse.
        If true, we disable logging for missing files
        
        :returns: true.
        """
        ...

    def Reader(self, config: QuantConnect.Data.SubscriptionDataConfig, line: str, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.BaseData:
        """
        Parses the data from the line provided and loads it into LEAN
        
        :param config: Subscription configuration
        :param line: Line of data
        :param date: Date
        :param isLiveMode: Is live mode
        :returns: New instance.
        """
        ...

    def RequiresMapping(self) -> bool:
        """
        Indicates whether the data source is tied to an underlying symbol and requires that corporate events be applied to it as well, such as renames and delistings
        
        :returns: false.
        """
        ...

    def SupportedResolutions(self) -> System.Collections.Generic.List[QuantConnect.Resolution]:
        """Gets the supported resolution for this data and security type"""
        ...

    def ToString(self) -> str:
        """Converts the instance to string"""
        ...


class BrainSentimentIndicator30Day(QuantConnect.DataSource.BrainSentimentIndicatorBase[QuantConnect_DataSource_BrainSentimentIndicator30Day]):
    """Brain sentiment indicator on 30 days of news"""

    DataSourceId: int
    """Data source ID"""

    @property
    def LookbackDays(self) -> int:
        """This property is protected."""
        ...

    @LookbackDays.setter
    def LookbackDays(self, value: int):
        """This property is protected."""
        ...


class BrainStockRanking21Day(QuantConnect.DataSource.BrainStockRankingBase[QuantConnect_DataSource_BrainStockRanking21Day]):
    """Brain universe stock rankings on expected returns in the next 30 days"""

    DataSourceId: int
    """Data source ID"""

    @property
    def LookbackDays(self) -> int:
        """This property is protected."""
        ...

    @LookbackDays.setter
    def LookbackDays(self, value: int):
        """This property is protected."""
        ...


class BrainCompanyFilingLanguageMetricsAll(QuantConnect.DataSource.BrainCompanyFilingLanguageMetricsBase[QuantConnect_DataSource_BrainCompanyFilingLanguageMetricsAll]):
    """Brain sentiment on 10-K/10-Q SEC reports"""

    DataSourceId: int
    """Data source ID"""

    @property
    def ReportType(self) -> str:
        """This property is protected."""
        ...

    @ReportType.setter
    def ReportType(self, value: str):
        """This property is protected."""
        ...


class BrainSentimentIndicatorUniverse(QuantConnect.Data.BaseData):
    """Universe Selection helper class for Brain Sentiment dataset"""

    @property
    def TotalArticleMentions7Days(self) -> typing.Optional[int]:
        """Total Article Mentions in 7 days"""
        ...

    @TotalArticleMentions7Days.setter
    def TotalArticleMentions7Days(self, value: typing.Optional[int]):
        """Total Article Mentions in 7 days"""
        ...

    @property
    def SentimentalArticleMentions7Days(self) -> typing.Optional[float]:
        """Sentimental Article Mentions in 7 days"""
        ...

    @SentimentalArticleMentions7Days.setter
    def SentimentalArticleMentions7Days(self, value: typing.Optional[float]):
        """Sentimental Article Mentions in 7 days"""
        ...

    @property
    def Sentiment7Days(self) -> typing.Optional[float]:
        """Setiment Score in 7 days"""
        ...

    @Sentiment7Days.setter
    def Sentiment7Days(self, value: typing.Optional[float]):
        """Setiment Score in 7 days"""
        ...

    @property
    def TotalBuzzVolume7Days(self) -> typing.Optional[float]:
        """Total Buzz Volume in 7 days"""
        ...

    @TotalBuzzVolume7Days.setter
    def TotalBuzzVolume7Days(self, value: typing.Optional[float]):
        """Total Buzz Volume in 7 days"""
        ...

    @property
    def SentimentalBuzzVolume7Days(self) -> typing.Optional[float]:
        """Sentimental Buzz Volume in 7 days"""
        ...

    @SentimentalBuzzVolume7Days.setter
    def SentimentalBuzzVolume7Days(self, value: typing.Optional[float]):
        """Sentimental Buzz Volume in 7 days"""
        ...

    @property
    def TotalArticleMentions30Days(self) -> typing.Optional[int]:
        """Total Article Mentions in 30 days"""
        ...

    @TotalArticleMentions30Days.setter
    def TotalArticleMentions30Days(self, value: typing.Optional[int]):
        """Total Article Mentions in 30 days"""
        ...

    @property
    def SentimentalArticleMentions30Days(self) -> typing.Optional[float]:
        """Sentimental Article Mentions in 30 days"""
        ...

    @SentimentalArticleMentions30Days.setter
    def SentimentalArticleMentions30Days(self, value: typing.Optional[float]):
        """Sentimental Article Mentions in 30 days"""
        ...

    @property
    def Sentiment30Days(self) -> typing.Optional[float]:
        """Setiment Score in 30 days"""
        ...

    @Sentiment30Days.setter
    def Sentiment30Days(self, value: typing.Optional[float]):
        """Setiment Score in 30 days"""
        ...

    @property
    def TotalBuzzVolume30Days(self) -> typing.Optional[float]:
        """Total Buzz Volume in 30 days"""
        ...

    @TotalBuzzVolume30Days.setter
    def TotalBuzzVolume30Days(self, value: typing.Optional[float]):
        """Total Buzz Volume in 30 days"""
        ...

    @property
    def SentimentalBuzzVolume30Days(self) -> typing.Optional[float]:
        """Sentimental Buzz Volume in 30 days"""
        ...

    @SentimentalBuzzVolume30Days.setter
    def SentimentalBuzzVolume30Days(self, value: typing.Optional[float]):
        """Sentimental Buzz Volume in 30 days"""
        ...

    @property
    def EndTime(self) -> datetime.datetime:
        """Time the data became available"""
        ...

    @EndTime.setter
    def EndTime(self, value: datetime.datetime):
        """Time the data became available"""
        ...

    def DataTimeZone(self) -> typing.Any:
        """
        Specifies the data time zone for this data type. This is useful for custom data types
        
        :returns: The NodaTime.DateTimeZone of this data type.
        """
        ...

    def DefaultResolution(self) -> int:
        """
        Gets the default resolution for this data and security type
        
        :returns: This method returns the int value of a member of the QuantConnect.Resolution enum.
        """
        ...

    def GetSource(self, config: QuantConnect.Data.SubscriptionDataConfig, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.SubscriptionDataSource:
        """
        Return the URL string source of the file. This will be converted to a stream
        
        :param config: Configuration object
        :param date: Date of this source file
        :param isLiveMode: true if we're in live mode, false for backtesting mode
        :returns: String URL of source file.
        """
        ...

    def Reader(self, config: QuantConnect.Data.SubscriptionDataConfig, line: str, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.BaseData:
        """
        Parses the data from the line provided and loads it into LEAN
        
        :param config: Subscription configuration
        :param line: Line of data
        :param date: Date
        :param isLiveMode: Is live mode
        :returns: New instance.
        """
        ...

    def SupportedResolutions(self) -> System.Collections.Generic.List[QuantConnect.Resolution]:
        """Gets the supported resolution for this data and security type"""
        ...

    def ToString(self) -> str:
        """Converts the instance to string"""
        ...


class BrainSentimentIndicator7Day(QuantConnect.DataSource.BrainSentimentIndicatorBase[QuantConnect_DataSource_BrainSentimentIndicator7Day]):
    """Brain sentiment indicator on 7 days of news"""

    DataSourceId: int
    """Data source ID"""

    @property
    def LookbackDays(self) -> int:
        """This property is protected."""
        ...

    @LookbackDays.setter
    def LookbackDays(self, value: int):
        """This property is protected."""
        ...


class BrainStockRanking10Day(QuantConnect.DataSource.BrainStockRankingBase[QuantConnect_DataSource_BrainStockRanking10Day]):
    """Brain universe stock rankings on expected returns in the next 10 days"""

    DataSourceId: int
    """Data source ID"""

    @property
    def LookbackDays(self) -> int:
        """This property is protected."""
        ...

    @LookbackDays.setter
    def LookbackDays(self, value: int):
        """This property is protected."""
        ...


class BrainCompanyFilingLanguageMetricsUniverseAll(QuantConnect.DataSource.BrainCompanyFilingLanguageMetricsUniverse[QuantConnect_DataSource_BrainCompanyFilingLanguageMetricsUniverseAll]):
    """Brain sentiment universe on 10-K/10-Q SEC reports"""

    @property
    def ReportType(self) -> str:
        """This property is protected."""
        ...

    @ReportType.setter
    def ReportType(self, value: str):
        """This property is protected."""
        ...


class BrainCompanyFilingLanguageMetrics10K(QuantConnect.DataSource.BrainCompanyFilingLanguageMetricsBase[QuantConnect_DataSource_BrainCompanyFilingLanguageMetrics10K]):
    """Brain sentiment on only 10-K SEC reports"""

    DataSourceId: int
    """Data source ID"""

    @property
    def ReportType(self) -> str:
        """This property is protected."""
        ...

    @ReportType.setter
    def ReportType(self, value: str):
        """This property is protected."""
        ...


class CryptoSlamNFTSales(QuantConnect.Data.BaseData):
    """CryptoSlam NFT Sales dataset"""

    @property
    def TotalTransactions(self) -> int:
        """The number of NFT transaction made within this blockchain"""
        ...

    @TotalTransactions.setter
    def TotalTransactions(self, value: int):
        """The number of NFT transaction made within this blockchain"""
        ...

    @property
    def UniqueBuyers(self) -> int:
        """The number of unique buyers of NFT within this blockchain"""
        ...

    @UniqueBuyers.setter
    def UniqueBuyers(self, value: int):
        """The number of unique buyers of NFT within this blockchain"""
        ...

    @property
    def UniqueSellers(self) -> int:
        """The number of unique sellers of NFT within this blockchain"""
        ...

    @UniqueSellers.setter
    def UniqueSellers(self, value: int):
        """The number of unique sellers of NFT within this blockchain"""
        ...

    @property
    def TotalPriceUSD(self) -> float:
        """The total transaction value (in USD) of NFT within this blockchain"""
        ...

    @TotalPriceUSD.setter
    def TotalPriceUSD(self, value: float):
        """The total transaction value (in USD) of NFT within this blockchain"""
        ...

    @property
    def Period(self) -> datetime.timedelta:
        """Time passed between the date of the data and the time the data became available to us"""
        ...

    @Period.setter
    def Period(self, value: datetime.timedelta):
        """Time passed between the date of the data and the time the data became available to us"""
        ...

    @property
    def EndTime(self) -> datetime.datetime:
        """Time the data became available"""
        ...

    @EndTime.setter
    def EndTime(self, value: datetime.datetime):
        """Time the data became available"""
        ...

    def Clone(self) -> QuantConnect.Data.BaseData:
        """
        Clones the data
        
        :returns: A clone of the object.
        """
        ...

    def DataTimeZone(self) -> typing.Any:
        """
        Specifies the data time zone for this data type. This is useful for custom data types
        
        :returns: The NodaTime.DateTimeZone of this data type.
        """
        ...

    def DefaultResolution(self) -> int:
        """
        Gets the default resolution for this data and security type
        
        :returns: This method returns the int value of a member of the QuantConnect.Resolution enum.
        """
        ...

    def GetSource(self, config: QuantConnect.Data.SubscriptionDataConfig, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.SubscriptionDataSource:
        """
        Return the URL string source of the file. This will be converted to a stream
        
        :param config: Configuration object
        :param date: Date of this source file
        :param isLiveMode: true if we're in live mode, false for backtesting mode
        :returns: String URL of source file.
        """
        ...

    def IsSparseData(self) -> bool:
        """
        Indicates whether the data is sparse.
        If true, we disable logging for missing files
        
        :returns: true.
        """
        ...

    def Reader(self, config: QuantConnect.Data.SubscriptionDataConfig, line: str, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.BaseData:
        """
        Parses the data from the line provided and loads it into LEAN
        
        :param config: Subscription configuration
        :param line: Line of data
        :param date: Date
        :param isLiveMode: Is live mode
        :returns: New instance.
        """
        ...

    def RequiresMapping(self) -> bool:
        """
        Indicates whether the data source is tied to an underlying symbol and requires that corporate events be applied to it as well, such as renames and delistings
        
        :returns: false.
        """
        ...

    def SupportedResolutions(self) -> System.Collections.Generic.List[QuantConnect.Resolution]:
        """Gets the supported resolution for this data and security type"""
        ...

    def ToString(self) -> str:
        """Converts the instance to string"""
        ...


class SECReportCompanyData(System.Object):
    """Company Information reported to SEC"""

    @property
    def ConformedName(self) -> str:
        """Current company name"""
        ...

    @ConformedName.setter
    def ConformedName(self, value: str):
        """Current company name"""
        ...

    @property
    def Cik(self) -> str:
        """Company's Central Index Key. Used to uniquely identify company filings in SEC's EDGAR system"""
        ...

    @Cik.setter
    def Cik(self, value: str):
        """Company's Central Index Key. Used to uniquely identify company filings in SEC's EDGAR system"""
        ...

    @property
    def AssignedSic(self) -> str:
        """Standard Industrial Classification"""
        ...

    @AssignedSic.setter
    def AssignedSic(self, value: str):
        """Standard Industrial Classification"""
        ...

    @property
    def IrsNumber(self) -> str:
        """Employer Identification Number"""
        ...

    @IrsNumber.setter
    def IrsNumber(self, value: str):
        """Employer Identification Number"""
        ...

    @property
    def StateOfIncorporation(self) -> str:
        """State of incorporation"""
        ...

    @StateOfIncorporation.setter
    def StateOfIncorporation(self, value: str):
        """State of incorporation"""
        ...

    @property
    def FiscalYearEnd(self) -> str:
        """Day fiscal year ends for given company. Formatted as MMdd"""
        ...

    @FiscalYearEnd.setter
    def FiscalYearEnd(self, value: str):
        """Day fiscal year ends for given company. Formatted as MMdd"""
        ...


class SECReportFilingValues(System.Object):
    """SEC Report Filing information"""

    @property
    def FormType(self) -> str:
        """SEC Form Type (e.g. 10-Q, 8-K, S-1, etc.)"""
        ...

    @FormType.setter
    def FormType(self, value: str):
        """SEC Form Type (e.g. 10-Q, 8-K, S-1, etc.)"""
        ...

    @property
    def Act(self) -> str:
        """Identification of the act(s) under which certain IM filings are made. The form type may be filed under more than one act. Required in each filing values tag nest."""
        ...

    @Act.setter
    def Act(self, value: str):
        """Identification of the act(s) under which certain IM filings are made. The form type may be filed under more than one act. Required in each filing values tag nest."""
        ...

    @property
    def FileNumber(self) -> str:
        """SEC filing number"""
        ...

    @FileNumber.setter
    def FileNumber(self, value: str):
        """SEC filing number"""
        ...

    @property
    def FilmNumber(self) -> str:
        """Used to access documents in the SEC's Virtual Private Reference Room (VPRR)"""
        ...

    @FilmNumber.setter
    def FilmNumber(self, value: str):
        """Used to access documents in the SEC's Virtual Private Reference Room (VPRR)"""
        ...


class SECReportBusinessAddress(System.Object):
    """Business Address reported to the SEC"""

    @property
    def StreetOne(self) -> str:
        """Street Address 1"""
        ...

    @StreetOne.setter
    def StreetOne(self, value: str):
        """Street Address 1"""
        ...

    @property
    def StreetTwo(self) -> str:
        """Street Address 2"""
        ...

    @StreetTwo.setter
    def StreetTwo(self, value: str):
        """Street Address 2"""
        ...

    @property
    def City(self) -> str:
        """City"""
        ...

    @City.setter
    def City(self, value: str):
        """City"""
        ...

    @property
    def State(self) -> str:
        """US State"""
        ...

    @State.setter
    def State(self, value: str):
        """US State"""
        ...

    @property
    def Zip(self) -> str:
        """ZIP Code"""
        ...

    @Zip.setter
    def Zip(self, value: str):
        """ZIP Code"""
        ...

    @property
    def Phone(self) -> str:
        """Business phone number"""
        ...

    @Phone.setter
    def Phone(self, value: str):
        """Business phone number"""
        ...


class SECReportMailAddress(System.Object):
    """SEC Report Mail Address"""

    @property
    def StreetOne(self) -> str:
        """Mailing street address"""
        ...

    @StreetOne.setter
    def StreetOne(self, value: str):
        """Mailing street address"""
        ...

    @property
    def StreetTwo(self) -> str:
        """Mailing street address 2"""
        ...

    @StreetTwo.setter
    def StreetTwo(self, value: str):
        """Mailing street address 2"""
        ...

    @property
    def City(self) -> str:
        """City"""
        ...

    @City.setter
    def City(self, value: str):
        """City"""
        ...

    @property
    def State(self) -> str:
        """US State"""
        ...

    @State.setter
    def State(self, value: str):
        """US State"""
        ...

    @property
    def Zip(self) -> str:
        """ZIP code. Not an integer because ZIP codes with dashes and letters exist"""
        ...

    @Zip.setter
    def Zip(self, value: str):
        """ZIP code. Not an integer because ZIP codes with dashes and letters exist"""
        ...


class SECReportFormerCompany(System.Object):
    """SEC Name Changing Report"""

    @property
    def FormerConformedName(self) -> str:
        """Previous company name"""
        ...

    @FormerConformedName.setter
    def FormerConformedName(self, value: str):
        """Previous company name"""
        ...

    @property
    def Changed(self) -> datetime.datetime:
        """Date the company name was changed to a new name"""
        ...

    @Changed.setter
    def Changed(self, value: datetime.datetime):
        """Date the company name was changed to a new name"""
        ...


class SECReportFiler(System.Object):
    """SEC Filing"""

    @property
    def CompanyData(self) -> QuantConnect.DataSource.SECReportCompanyData:
        """SEC data containing company data such as company name, cik, etc."""
        ...

    @CompanyData.setter
    def CompanyData(self, value: QuantConnect.DataSource.SECReportCompanyData):
        """SEC data containing company data such as company name, cik, etc."""
        ...

    @property
    def Values(self) -> System.Collections.Generic.List[QuantConnect.DataSource.SECReportFilingValues]:
        """Information regarding the filing itself"""
        ...

    @Values.setter
    def Values(self, value: System.Collections.Generic.List[QuantConnect.DataSource.SECReportFilingValues]):
        """Information regarding the filing itself"""
        ...

    @property
    def BusinessAddress(self) -> System.Collections.Generic.List[QuantConnect.DataSource.SECReportBusinessAddress]:
        """Information related to the business' address"""
        ...

    @BusinessAddress.setter
    def BusinessAddress(self, value: System.Collections.Generic.List[QuantConnect.DataSource.SECReportBusinessAddress]):
        """Information related to the business' address"""
        ...

    @property
    def MailingAddress(self) -> System.Collections.Generic.List[QuantConnect.DataSource.SECReportMailAddress]:
        """Company mailing address information"""
        ...

    @MailingAddress.setter
    def MailingAddress(self, value: System.Collections.Generic.List[QuantConnect.DataSource.SECReportMailAddress]):
        """Company mailing address information"""
        ...

    @property
    def FormerCompanies(self) -> System.Collections.Generic.List[QuantConnect.DataSource.SECReportFormerCompany]:
        """
        Former company names. Default to empty list in order to not have null values
        in the case that the company has never had a former name
        """
        ...

    @FormerCompanies.setter
    def FormerCompanies(self, value: System.Collections.Generic.List[QuantConnect.DataSource.SECReportFormerCompany]):
        """
        Former company names. Default to empty list in order to not have null values
        in the case that the company has never had a former name
        """
        ...


class SECReportDocument(System.Object):
    """Business documents reported to the SEC"""

    @property
    def FormType(self) -> str:
        """Report document type, e.g. 10-Q, 8-K, S-1"""
        ...

    @FormType.setter
    def FormType(self, value: str):
        """Report document type, e.g. 10-Q, 8-K, S-1"""
        ...

    @property
    def Sequence(self) -> int:
        """Nth attachment to the form filed"""
        ...

    @Sequence.setter
    def Sequence(self, value: int):
        """Nth attachment to the form filed"""
        ...

    @property
    def Filename(self) -> str:
        """File name that the file had when it was uploaded"""
        ...

    @Filename.setter
    def Filename(self, value: str):
        """File name that the file had when it was uploaded"""
        ...

    @property
    def Description(self) -> str:
        """Attachment content(s) description"""
        ...

    @Description.setter
    def Description(self, value: str):
        """Attachment content(s) description"""
        ...

    @property
    def Text(self) -> str:
        """
        Content of the attachment. This is the field that will most likely contain
        information related to financial reports. Sometimes, XML will
        be present in the data. If the first line starts with "<XML>", then
        XML data will be present in the contents of the document
        """
        ...

    @Text.setter
    def Text(self, value: str):
        """
        Content of the attachment. This is the field that will most likely contain
        information related to financial reports. Sometimes, XML will
        be present in the data. If the first line starts with "<XML>", then
        XML data will be present in the contents of the document
        """
        ...


class SECReportSubmission(System.Object):
    """SEC Report Submission"""

    @property
    def AccessionNumber(self) -> str:
        """Number used to access document filings on the SEC website"""
        ...

    @AccessionNumber.setter
    def AccessionNumber(self, value: str):
        """Number used to access document filings on the SEC website"""
        ...

    @property
    def FormType(self) -> str:
        """SEC form type"""
        ...

    @FormType.setter
    def FormType(self, value: str):
        """SEC form type"""
        ...

    @property
    def PublicDocumentCount(self) -> str:
        """Number of documents made public by the SEC"""
        ...

    @PublicDocumentCount.setter
    def PublicDocumentCount(self, value: str):
        """Number of documents made public by the SEC"""
        ...

    @property
    def Period(self) -> datetime.datetime:
        """End date of reporting period of filing. Optional."""
        ...

    @Period.setter
    def Period(self, value: datetime.datetime):
        """End date of reporting period of filing. Optional."""
        ...

    @property
    def Items(self) -> System.Collections.Generic.List[str]:
        """Identifies 1 or more items declared in 8-K filings. Optional & Repeatable."""
        ...

    @Items.setter
    def Items(self, value: System.Collections.Generic.List[str]):
        """Identifies 1 or more items declared in 8-K filings. Optional & Repeatable."""
        ...

    @property
    def FilingDate(self) -> datetime.datetime:
        """Date report was filed with the SEC"""
        ...

    @FilingDate.setter
    def FilingDate(self, value: datetime.datetime):
        """Date report was filed with the SEC"""
        ...

    @property
    def FilingDateChange(self) -> datetime.datetime:
        """Date when the last Post Acceptance occurred. Optional."""
        ...

    @FilingDateChange.setter
    def FilingDateChange(self, value: datetime.datetime):
        """Date when the last Post Acceptance occurred. Optional."""
        ...

    @property
    def MadeAvailableAt(self) -> datetime.datetime:
        """
        Exact time the report was filed with the SEC and made available to the public (plus 10 minute delay).
        This field is NOT included with the raw SEC report, and should be added during post processing of the data
        """
        ...

    @MadeAvailableAt.setter
    def MadeAvailableAt(self, value: datetime.datetime):
        """
        Exact time the report was filed with the SEC and made available to the public (plus 10 minute delay).
        This field is NOT included with the raw SEC report, and should be added during post processing of the data
        """
        ...

    @property
    def Filers(self) -> System.Collections.Generic.List[QuantConnect.DataSource.SECReportFiler]:
        """Contains information regarding who the filer of the report is."""
        ...

    @Filers.setter
    def Filers(self, value: System.Collections.Generic.List[QuantConnect.DataSource.SECReportFiler]):
        """Contains information regarding who the filer of the report is."""
        ...

    @property
    def Documents(self) -> System.Collections.Generic.List[QuantConnect.DataSource.SECReportDocument]:
        """Attachments/content associated with the report"""
        ...

    @Documents.setter
    def Documents(self, value: System.Collections.Generic.List[QuantConnect.DataSource.SECReportDocument]):
        """Attachments/content associated with the report"""
        ...


class ISECReport(QuantConnect.Data.IBaseData, metaclass=abc.ABCMeta):
    """
    Base interface for all SEC report types.
    Using an interface, we can retrieve all report types with a single
    call to Slice.Get{T}()
    """

    @property
    @abc.abstractmethod
    def Report(self) -> QuantConnect.DataSource.SECReportSubmission:
        """Contents of the actual SEC report"""
        ...


class SECReport10Q(QuantConnect.Data.BaseData, QuantConnect.DataSource.ISECReport):
    """
    SEC 10-Q report (quarterly earnings) BaseData implementation.
    Using this class, you can retrieve SEC report data for a security if it exists.
    If the ticker you want no longer trades, you can also use the CIK of the company
    you want data for as well except for currently traded stocks. This may change in the future.
    """

    DataSourceId: int
    """Data source ID"""

    @property
    def Report(self) -> QuantConnect.DataSource.SECReportSubmission:
        """Contents of the actual SEC report"""
        ...

    @overload
    def __init__(self) -> None:
        """Empty constructor required for Slice.Get{T}()"""
        ...

    @overload
    def __init__(self, report: QuantConnect.DataSource.SECReportSubmission) -> None:
        """
        Constructor used to initialize instance with the given report
        
        :param report: SEC report submission
        """
        ...

    def Clone(self) -> QuantConnect.Data.BaseData:
        """
        Clones the current object into a new object
        
        :returns: BaseData clone of the current object.
        """
        ...

    def DefaultResolution(self) -> int:
        """
        Gets the default resolution for this data and security type
        
        :returns: This method returns the int value of a member of the QuantConnect.Resolution enum.
        """
        ...

    def GetSource(self, config: QuantConnect.Data.SubscriptionDataConfig, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.SubscriptionDataSource:
        """
        Returns a subscription data source pointing towards SEC 10-Q report data
        
        :param config: User configuration
        :param date: Date data has been requested for
        :param isLiveMode: Is livetrading
        """
        ...

    def Reader(self, config: QuantConnect.Data.SubscriptionDataConfig, line: str, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.BaseData:
        """
        Parses the data into BaseData
        
        :param config: User subscription config
        :param line: Line of source file to parse
        :param date: Date data was requested for
        :param isLiveMode: Is livetrading mode
        """
        ...

    def RequiresMapping(self) -> bool:
        """
        Indicates if there is support for mapping
        
        :returns: True indicates mapping should be used.
        """
        ...

    def SupportedResolutions(self) -> System.Collections.Generic.List[QuantConnect.Resolution]:
        """Gets the supported resolution for this data and security type"""
        ...


class SECReportIndexItem(System.Object):
    """SEC Report Index Item"""

    @property
    def LastModified(self) -> datetime.datetime:
        """Date the SEC submission was published"""
        ...

    @LastModified.setter
    def LastModified(self, value: datetime.datetime):
        """Date the SEC submission was published"""
        ...

    @property
    def Name(self) -> str:
        """Name of folder/file. Usually accession number"""
        ...

    @Name.setter
    def Name(self, value: str):
        """Name of folder/file. Usually accession number"""
        ...

    @property
    def FileType(self) -> str:
        """Specifies what kind of file the entry is"""
        ...

    @FileType.setter
    def FileType(self, value: str):
        """Specifies what kind of file the entry is"""
        ...

    @property
    def Size(self) -> str:
        """Size of the file. Empty if directory"""
        ...

    @Size.setter
    def Size(self, value: str):
        """Size of the file. Empty if directory"""
        ...


class SECReportIndexDirectory(System.Object):
    """SEC Report Index Directory, contains a list of Items"""

    @property
    def Items(self) -> System.Collections.Generic.List[QuantConnect.DataSource.SECReportIndexItem]:
        """Contains additional metadata regarding files present on the server"""
        ...

    @Items.setter
    def Items(self, value: System.Collections.Generic.List[QuantConnect.DataSource.SECReportIndexItem]):
        """Contains additional metadata regarding files present on the server"""
        ...

    @property
    def Name(self) -> str:
        """Path directory"""
        ...

    @Name.setter
    def Name(self, value: str):
        """Path directory"""
        ...

    @property
    def ParentDirectory(self) -> str:
        """Parent directory (if one exists)"""
        ...

    @ParentDirectory.setter
    def ParentDirectory(self, value: str):
        """Parent directory (if one exists)"""
        ...


class SECReportIndexFile(System.Object):
    """SEC Report Index"""

    @property
    def Directory(self) -> QuantConnect.DataSource.SECReportIndexDirectory:
        """First and only root entry of SEC index.json"""
        ...

    @Directory.setter
    def Directory(self, value: QuantConnect.DataSource.SECReportIndexDirectory):
        """First and only root entry of SEC index.json"""
        ...


class SECReport8K(QuantConnect.Data.BaseData, QuantConnect.DataSource.ISECReport):
    """
    SEC 8-K report (important investor notices) BaseData implementation.
    Using this class, you can retrieve SEC report data for a security if it exists.
    If the ticker you want no longer trades, you can also use the CIK of the company
    you want data for as well except for currently traded stocks. This may change in the future.
    """

    DataSourceId: int
    """Data source ID"""

    @property
    def Report(self) -> QuantConnect.DataSource.SECReportSubmission:
        """Contents of the actual SEC report"""
        ...

    @overload
    def __init__(self) -> None:
        """Empty constructor required for Slice.Get{T}()"""
        ...

    @overload
    def __init__(self, report: QuantConnect.DataSource.SECReportSubmission) -> None:
        """
        Constructor used to initialize instance with the given report
        
        :param report: SEC report submission
        """
        ...

    def Clone(self) -> QuantConnect.Data.BaseData:
        """
        Clones the current object into a new object
        
        :returns: BaseData clone of the current object.
        """
        ...

    def DefaultResolution(self) -> int:
        """
        Gets the default resolution for this data and security type
        
        :returns: This method returns the int value of a member of the QuantConnect.Resolution enum.
        """
        ...

    def GetSource(self, config: QuantConnect.Data.SubscriptionDataConfig, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.SubscriptionDataSource:
        """
        Returns a subscription data source pointing towards SEC 8-K report data
        
        :param config: User configuration
        :param date: Date data has been requested for
        :param isLiveMode: Is livetrading
        """
        ...

    def Reader(self, config: QuantConnect.Data.SubscriptionDataConfig, line: str, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.BaseData:
        """
        Parses the data into instance of BaseData
        
        :param config: User subscription config
        :param line: Line of source file to parse
        :param date: Date data was requested for
        :param isLiveMode: Is live trading mode
        """
        ...

    def RequiresMapping(self) -> bool:
        """
        Indicates if there is support for mapping
        
        :returns: True indicates mapping should be used.
        """
        ...

    def SupportedResolutions(self) -> System.Collections.Generic.List[QuantConnect.Resolution]:
        """Gets the supported resolution for this data and security type"""
        ...


class SECReportDateTimeConverter(IsoDateTimeConverter):
    """Specifies format for parsing DateTime values from SEC data"""

    def __init__(self) -> None:
        """Constructor, initializes DateTime format"""
        ...


class SECReportFactory(System.Object):
    """SEC Report Factory for deserializing XML formatted data"""

    def CreateSECReport(self, xmlText: str) -> QuantConnect.DataSource.ISECReport:
        """
        Factory method creates SEC report by deserializing XML formatted SEC data to SECReportSubmission
        
        :param xmlText: XML text containing SEC data
        """
        ...


class SECReport10K(QuantConnect.Data.BaseData, QuantConnect.DataSource.ISECReport):
    """
    SEC 10-K report (annual earnings) BaseData implementation.
    Using this class, you can retrieve SEC report data for a security if it exists.
    If the ticker you want no longer trades, you can also use the CIK of the company
    you want data for as well except for currently traded stocks. This may change in the future.
    """

    DataSourceId: int
    """Data source ID"""

    @property
    def Report(self) -> QuantConnect.DataSource.SECReportSubmission:
        """Contents of the actual SEC report"""
        ...

    @overload
    def __init__(self) -> None:
        """Empty constructor required for Slice.Get{T}()"""
        ...

    @overload
    def __init__(self, report: QuantConnect.DataSource.SECReportSubmission) -> None:
        """
        Constructor used to initialize instance with the given report
        
        :param report: SEC report submission
        """
        ...

    def Clone(self) -> QuantConnect.Data.BaseData:
        """
        Clones the current object into a new object
        
        :returns: BaseData clone of the current object.
        """
        ...

    def DefaultResolution(self) -> int:
        """
        Gets the default resolution for this data and security type
        
        :returns: This method returns the int value of a member of the QuantConnect.Resolution enum.
        """
        ...

    def GetSource(self, config: QuantConnect.Data.SubscriptionDataConfig, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.SubscriptionDataSource:
        """
        Returns a subscription data source pointing towards SEC 10-K report data
        
        :param config: User configuration
        :param date: Date data has been requested for
        :param isLiveMode: Is livetrading
        """
        ...

    def Reader(self, config: QuantConnect.Data.SubscriptionDataConfig, line: str, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.BaseData:
        """
        Parses the data into BaseData
        
        :param config: User subscription config
        :param line: Line of source file to parse
        :param date: Date data was requested for
        :param isLiveMode: Is livetrading mode
        """
        ...

    def RequiresMapping(self) -> bool:
        """
        Indicates if there is support for mapping
        
        :returns: True indicates mapping should be used.
        """
        ...

    def SupportedResolutions(self) -> System.Collections.Generic.List[QuantConnect.Resolution]:
        """Gets the supported resolution for this data and security type"""
        ...


class EstimizeRelease(QuantConnect.Data.BaseData):
    """Financial releases for the specified company"""

    DataSourceId: int
    """Data source ID"""

    @property
    def Id(self) -> str:
        """The unique identifier for the release"""
        ...

    @Id.setter
    def Id(self, value: str):
        """The unique identifier for the release"""
        ...

    @property
    def FiscalYear(self) -> int:
        """The fiscal year for the release"""
        ...

    @FiscalYear.setter
    def FiscalYear(self, value: int):
        """The fiscal year for the release"""
        ...

    @property
    def FiscalQuarter(self) -> int:
        """The fiscal quarter for the release"""
        ...

    @FiscalQuarter.setter
    def FiscalQuarter(self, value: int):
        """The fiscal quarter for the release"""
        ...

    @property
    def ReleaseDate(self) -> datetime.datetime:
        """The date of the release"""
        ...

    @ReleaseDate.setter
    def ReleaseDate(self, value: datetime.datetime):
        """The date of the release"""
        ...

    @property
    def Eps(self) -> typing.Optional[float]:
        """The earnings per share for the specified fiscal quarter"""
        ...

    @Eps.setter
    def Eps(self, value: typing.Optional[float]):
        """The earnings per share for the specified fiscal quarter"""
        ...

    @property
    def Revenue(self) -> typing.Optional[float]:
        """The revenue for the specified fiscal quarter"""
        ...

    @Revenue.setter
    def Revenue(self, value: typing.Optional[float]):
        """The revenue for the specified fiscal quarter"""
        ...

    @property
    def WallStreetEpsEstimate(self) -> typing.Optional[float]:
        """The estimated EPS from Wall Street"""
        ...

    @WallStreetEpsEstimate.setter
    def WallStreetEpsEstimate(self, value: typing.Optional[float]):
        """The estimated EPS from Wall Street"""
        ...

    @property
    def WallStreetRevenueEstimate(self) -> typing.Optional[float]:
        """The estimated revenue from Wall Street"""
        ...

    @WallStreetRevenueEstimate.setter
    def WallStreetRevenueEstimate(self, value: typing.Optional[float]):
        """The estimated revenue from Wall Street"""
        ...

    @property
    def ConsensusEpsEstimate(self) -> typing.Optional[float]:
        """The mean EPS consensus by the Estimize community"""
        ...

    @ConsensusEpsEstimate.setter
    def ConsensusEpsEstimate(self, value: typing.Optional[float]):
        """The mean EPS consensus by the Estimize community"""
        ...

    @property
    def ConsensusRevenueEstimate(self) -> typing.Optional[float]:
        """The mean revenue consensus by the Estimize community"""
        ...

    @ConsensusRevenueEstimate.setter
    def ConsensusRevenueEstimate(self, value: typing.Optional[float]):
        """The mean revenue consensus by the Estimize community"""
        ...

    @property
    def ConsensusWeightedEpsEstimate(self) -> typing.Optional[float]:
        """The weighted EPS consensus by the Estimize community"""
        ...

    @ConsensusWeightedEpsEstimate.setter
    def ConsensusWeightedEpsEstimate(self, value: typing.Optional[float]):
        """The weighted EPS consensus by the Estimize community"""
        ...

    @property
    def ConsensusWeightedRevenueEstimate(self) -> typing.Optional[float]:
        """The weighted revenue consensus by the Estimize community"""
        ...

    @ConsensusWeightedRevenueEstimate.setter
    def ConsensusWeightedRevenueEstimate(self, value: typing.Optional[float]):
        """The weighted revenue consensus by the Estimize community"""
        ...

    @overload
    def __init__(self) -> None:
        """
        Without a default constructor, Json.NET will call the
        other constructor with `null` for the string parameter
        """
        ...

    @overload
    def __init__(self, csvLine: str) -> None:
        """
        Creates EstimizeRelease instance from a line of CSV
        
        :param csvLine: CSV line
        """
        ...

    def DataTimeZone(self) -> typing.Any:
        """
        Specifies the data time zone for this data type. This is useful for custom data types
        
        :returns: The DateTimeZone of this data type.
        """
        ...

    def GetSource(self, config: QuantConnect.Data.SubscriptionDataConfig, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.SubscriptionDataSource:
        """
        Return the Subscription Data Source gained from the URL
        
        :param config: Configuration object
        :param date: Date of this source file
        :param isLiveMode: true if we're in live mode, false for backtesting mode
        :returns: Subscription Data Source.
        """
        ...

    def Reader(self, config: QuantConnect.Data.SubscriptionDataConfig, line: str, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.BaseData:
        """
        Reader converts each line of the data source into BaseData objects.
        
        :param config: Subscription data config setup object
        :param line: Content of the source document
        :param date: Date of the requested data
        :param isLiveMode: true if we're in live mode, false for backtesting mode
        :returns: Estimize Release object.
        """
        ...

    def RequiresMapping(self) -> bool:
        """
        Indicates if there is support for mapping
        
        :returns: True indicates mapping should be used.
        """
        ...

    def ToString(self) -> str:
        """Formats a string with the Estimize Release information."""
        ...


class EstimizeEstimate(QuantConnect.Data.BaseData):
    """Financial estimates for the specified company"""

    DataSourceId: int
    """Data source ID"""

    @property
    def Id(self) -> str:
        """The unique identifier for the estimate"""
        ...

    @Id.setter
    def Id(self, value: str):
        """The unique identifier for the estimate"""
        ...

    @property
    def Ticker(self) -> str:
        """The ticker of the company being estimated"""
        ...

    @Ticker.setter
    def Ticker(self, value: str):
        """The ticker of the company being estimated"""
        ...

    @property
    def FiscalYear(self) -> int:
        """The fiscal year of the quarter being estimated"""
        ...

    @FiscalYear.setter
    def FiscalYear(self, value: int):
        """The fiscal year of the quarter being estimated"""
        ...

    @property
    def FiscalQuarter(self) -> int:
        """The fiscal quarter of the quarter being estimated"""
        ...

    @FiscalQuarter.setter
    def FiscalQuarter(self, value: int):
        """The fiscal quarter of the quarter being estimated"""
        ...

    @property
    def CreatedAt(self) -> datetime.datetime:
        """The time that the estimate was created (UTC)"""
        ...

    @CreatedAt.setter
    def CreatedAt(self, value: datetime.datetime):
        """The time that the estimate was created (UTC)"""
        ...

    @property
    def Eps(self) -> typing.Optional[float]:
        """The estimated earnings per share for the company in the specified fiscal quarter"""
        ...

    @Eps.setter
    def Eps(self, value: typing.Optional[float]):
        """The estimated earnings per share for the company in the specified fiscal quarter"""
        ...

    @property
    def Revenue(self) -> typing.Optional[float]:
        """The estimated revenue for the company in the specified fiscal quarter"""
        ...

    @Revenue.setter
    def Revenue(self, value: typing.Optional[float]):
        """The estimated revenue for the company in the specified fiscal quarter"""
        ...

    @property
    def UserName(self) -> str:
        """The unique identifier for the author of the estimate"""
        ...

    @UserName.setter
    def UserName(self, value: str):
        """The unique identifier for the author of the estimate"""
        ...

    @property
    def AnalystId(self) -> str:
        """The author of the estimate"""
        ...

    @AnalystId.setter
    def AnalystId(self, value: str):
        """The author of the estimate"""
        ...

    @property
    def Flagged(self) -> bool:
        """
        A boolean value which indicates whether we have flagged this estimate internally as erroneous
        (spam, wrong accounting standard, etc)
        """
        ...

    @Flagged.setter
    def Flagged(self, value: bool):
        """
        A boolean value which indicates whether we have flagged this estimate internally as erroneous
        (spam, wrong accounting standard, etc)
        """
        ...

    @overload
    def __init__(self) -> None:
        """Required for successful Json.NET deserialization"""
        ...

    @overload
    def __init__(self, csvLine: str) -> None:
        """
        Creates a new instance of EstimizeEstimate from a CSV line
        
        :param csvLine: CSV line
        """
        ...

    def DataTimeZone(self) -> typing.Any:
        """
        Specifies the data time zone for this data type. This is useful for custom data types
        
        :returns: The DateTimeZone of this data type.
        """
        ...

    def GetSource(self, config: QuantConnect.Data.SubscriptionDataConfig, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.SubscriptionDataSource:
        """
        Return the Subscription Data Source gained from the URL
        
        :param config: Configuration object
        :param date: Date of this source file
        :param isLiveMode: true if we're in live mode, false for backtesting mode
        :returns: Subscription Data Source.
        """
        ...

    def Reader(self, config: QuantConnect.Data.SubscriptionDataConfig, line: str, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.BaseData:
        """
        Reader converts each line of the data source into BaseData objects.
        
        :param config: Subscription data config setup object
        :param line: Content of the source document
        :param date: Date of the requested data
        :param isLiveMode: true if we're in live mode, false for backtesting mode
        :returns: Estimize Estimate object.
        """
        ...

    def RequiresMapping(self) -> bool:
        """
        Indicates if there is support for mapping
        
        :returns: True indicates mapping should be used.
        """
        ...

    def ToString(self) -> str:
        """Formats a string with the Estimize Estimate information."""
        ...


class EstimizeConsensus(QuantConnect.Data.BaseData):
    """Consensus of the specified release"""

    class ConsensusSource(System.Enum):
        """Source of the Consensus"""

        WallStreet = 0
        """Consensus from Wall Street"""

        Estimize = 1
        """Consensus from Estimize"""

    class ConsensusType(System.Enum):
        """Type of the consensus"""

        Eps = 0
        """Consensus on earnings per share value"""

        Revenue = 1
        """Consensus on revenue value"""

    DataSourceId: int
    """Data source ID"""

    @property
    def Id(self) -> str:
        """The unique identifier for the estimate"""
        ...

    @Id.setter
    def Id(self, value: str):
        """The unique identifier for the estimate"""
        ...

    @property
    def Source(self) -> typing.Optional[QuantConnect.DataSource.EstimizeConsensus.ConsensusSource]:
        """Consensus source (Wall Street or Estimize)"""
        ...

    @Source.setter
    def Source(self, value: typing.Optional[QuantConnect.DataSource.EstimizeConsensus.ConsensusSource]):
        """Consensus source (Wall Street or Estimize)"""
        ...

    @property
    def Type(self) -> typing.Optional[QuantConnect.DataSource.EstimizeConsensus.ConsensusType]:
        """Type of Consensus (EPS or Revenue)"""
        ...

    @Type.setter
    def Type(self, value: typing.Optional[QuantConnect.DataSource.EstimizeConsensus.ConsensusType]):
        """Type of Consensus (EPS or Revenue)"""
        ...

    @property
    def Mean(self) -> typing.Optional[float]:
        """The mean of the distribution of estimates (the "consensus")"""
        ...

    @Mean.setter
    def Mean(self, value: typing.Optional[float]):
        """The mean of the distribution of estimates (the "consensus")"""
        ...

    @property
    def Value(self) -> float:
        """The mean of the distribution of estimates (the "consensus")"""
        ...

    @Value.setter
    def Value(self, value: float):
        """The mean of the distribution of estimates (the "consensus")"""
        ...

    @property
    def High(self) -> typing.Optional[float]:
        """The highest estimate in the distribution"""
        ...

    @High.setter
    def High(self, value: typing.Optional[float]):
        """The highest estimate in the distribution"""
        ...

    @property
    def Low(self) -> typing.Optional[float]:
        """The lowest estimate in the distribution"""
        ...

    @Low.setter
    def Low(self, value: typing.Optional[float]):
        """The lowest estimate in the distribution"""
        ...

    @property
    def StandardDeviation(self) -> typing.Optional[float]:
        """The standard deviation of the distribution"""
        ...

    @StandardDeviation.setter
    def StandardDeviation(self, value: typing.Optional[float]):
        """The standard deviation of the distribution"""
        ...

    @property
    def Count(self) -> typing.Optional[int]:
        """The number of estimates in the distribution"""
        ...

    @Count.setter
    def Count(self, value: typing.Optional[int]):
        """The number of estimates in the distribution"""
        ...

    @property
    def UpdatedAt(self) -> datetime.datetime:
        """The timestamp of this consensus (UTC)"""
        ...

    @UpdatedAt.setter
    def UpdatedAt(self, value: datetime.datetime):
        """The timestamp of this consensus (UTC)"""
        ...

    @property
    def FiscalYear(self) -> typing.Optional[int]:
        """The fiscal year for the release"""
        ...

    @FiscalYear.setter
    def FiscalYear(self, value: typing.Optional[int]):
        """The fiscal year for the release"""
        ...

    @property
    def FiscalQuarter(self) -> typing.Optional[int]:
        """The fiscal quarter for the release"""
        ...

    @FiscalQuarter.setter
    def FiscalQuarter(self, value: typing.Optional[int]):
        """The fiscal quarter for the release"""
        ...

    @property
    def EndTime(self) -> datetime.datetime:
        """The timestamp of this consensus (UTC)"""
        ...

    @EndTime.setter
    def EndTime(self, value: datetime.datetime):
        """The timestamp of this consensus (UTC)"""
        ...

    @overload
    def __init__(self) -> None:
        """Empty constructor required for successful Json.NET deserialization"""
        ...

    @overload
    def __init__(self, csvLine: str) -> None:
        """
        Creates an instance from CSV lines
        
        :param csvLine: CSV file
        """
        ...

    def DataTimeZone(self) -> typing.Any:
        """
        Specifies the data time zone for this data type. This is useful for custom data types
        
        :returns: The DateTimeZone of this data type.
        """
        ...

    def GetSource(self, config: QuantConnect.Data.SubscriptionDataConfig, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.SubscriptionDataSource:
        """
        Return the Subscription Data Source gained from the URL
        
        :param config: Configuration object
        :param date: Date of this source file
        :param isLiveMode: true if we're in live mode, false for backtesting mode
        :returns: Subscription Data Source.
        """
        ...

    def Reader(self, config: QuantConnect.Data.SubscriptionDataConfig, line: str, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.BaseData:
        """
        Reader converts each line of the data source into BaseData objects.
        
        :param config: Subscription data config setup object
        :param line: Content of the source document
        :param date: Date of the requested data
        :param isLiveMode: true if we're in live mode, false for backtesting mode
        :returns: Estimize consensus object.
        """
        ...

    def RequiresMapping(self) -> bool:
        """
        Indicates if there is support for mapping
        
        :returns: True indicates mapping should be used.
        """
        ...

    def ToString(self) -> str:
        """Formats a string with the Estimize Estimate information."""
        ...


class BitcoinMetadata(QuantConnect.Data.BaseData):
    """Blockchain Bitcoin Metadata dataset"""

    @property
    def Difficulty(self) -> float:
        """A relative measure of how difficult it is to find a new block. The difficulty is adjusted periodically as a function of how much hashing power has been deployed by the network of miners."""
        ...

    @Difficulty.setter
    def Difficulty(self, value: float):
        """A relative measure of how difficult it is to find a new block. The difficulty is adjusted periodically as a function of how much hashing power has been deployed by the network of miners."""
        ...

    @property
    def MyWalletNumberofUsers(self) -> float:
        """Number of wallets hosts using our My Wallet Service."""
        ...

    @MyWalletNumberofUsers.setter
    def MyWalletNumberofUsers(self, value: float):
        """Number of wallets hosts using our My Wallet Service."""
        ...

    @property
    def AverageBlockSize(self) -> float:
        """The average block size in MB."""
        ...

    @AverageBlockSize.setter
    def AverageBlockSize(self, value: float):
        """The average block size in MB."""
        ...

    @property
    def BlockchainSize(self) -> float:
        """The total size of all block headers and transactions. Not including database indexes."""
        ...

    @BlockchainSize.setter
    def BlockchainSize(self, value: float):
        """The total size of all block headers and transactions. Not including database indexes."""
        ...

    @property
    def MedianTransactionConfirmationTime(self) -> float:
        """The median time for a transaction to be accepted into a mined block and added to the public ledger (note: only includes transactions with miner fees)."""
        ...

    @MedianTransactionConfirmationTime.setter
    def MedianTransactionConfirmationTime(self, value: float):
        """The median time for a transaction to be accepted into a mined block and added to the public ledger (note: only includes transactions with miner fees)."""
        ...

    @property
    def MinersRevenue(self) -> float:
        """Total value of coinbase block rewards and transaction fees paid to miners."""
        ...

    @MinersRevenue.setter
    def MinersRevenue(self, value: float):
        """Total value of coinbase block rewards and transaction fees paid to miners."""
        ...

    @property
    def HashRate(self) -> float:
        """The estimated number of tera hashes per second (trillions of hashes per second) the Bitcoin network is performing"""
        ...

    @HashRate.setter
    def HashRate(self, value: float):
        """The estimated number of tera hashes per second (trillions of hashes per second) the Bitcoin network is performing"""
        ...

    @property
    def CostPerTransaction(self) -> float:
        """The miners revenue divided by the number of transactions."""
        ...

    @CostPerTransaction.setter
    def CostPerTransaction(self, value: float):
        """The miners revenue divided by the number of transactions."""
        ...

    @property
    def CostPercentofTransactionVolume(self) -> float:
        """The miners revenue as percentage of the transaction volume."""
        ...

    @CostPercentofTransactionVolume.setter
    def CostPercentofTransactionVolume(self, value: float):
        """The miners revenue as percentage of the transaction volume."""
        ...

    @property
    def EstimatedTransactionVolumeUSD(self) -> float:
        """The Estimated Transaction Value in USD value."""
        ...

    @EstimatedTransactionVolumeUSD.setter
    def EstimatedTransactionVolumeUSD(self, value: float):
        """The Estimated Transaction Value in USD value."""
        ...

    @property
    def EstimatedTransactionVolume(self) -> float:
        """The total estimated value of transactions on the Bitcoin blockchain (does not include coins returned to sender as change)."""
        ...

    @EstimatedTransactionVolume.setter
    def EstimatedTransactionVolume(self, value: float):
        """The total estimated value of transactions on the Bitcoin blockchain (does not include coins returned to sender as change)."""
        ...

    @property
    def TotalOutputVolume(self) -> float:
        """The total value of all transaction outputs per day (includes coins returned to the sender as change)."""
        ...

    @TotalOutputVolume.setter
    def TotalOutputVolume(self, value: float):
        """The total value of all transaction outputs per day (includes coins returned to the sender as change)."""
        ...

    @property
    def NumberofTransactionperBlock(self) -> float:
        """The average number of transactions per block."""
        ...

    @NumberofTransactionperBlock.setter
    def NumberofTransactionperBlock(self, value: float):
        """The average number of transactions per block."""
        ...

    @property
    def NumberofUniqueBitcoinAddressesUsed(self) -> float:
        """The total number of unique addresses used on the Bitcoin blockchain."""
        ...

    @NumberofUniqueBitcoinAddressesUsed.setter
    def NumberofUniqueBitcoinAddressesUsed(self, value: float):
        """The total number of unique addresses used on the Bitcoin blockchain."""
        ...

    @property
    def NumberofTransactionsExcludingPopularAddresses(self) -> float:
        """The total number of Bitcoin transactions, excluding those involving any of the network's 100 most popular addresses."""
        ...

    @NumberofTransactionsExcludingPopularAddresses.setter
    def NumberofTransactionsExcludingPopularAddresses(self, value: float):
        """The total number of Bitcoin transactions, excluding those involving any of the network's 100 most popular addresses."""
        ...

    @property
    def TotalNumberofTransactions(self) -> float:
        """The Total Number of transactions."""
        ...

    @TotalNumberofTransactions.setter
    def TotalNumberofTransactions(self, value: float):
        """The Total Number of transactions."""
        ...

    @property
    def NumberofTransactions(self) -> float:
        """The number of daily confirmed Bitcoin transactions."""
        ...

    @NumberofTransactions.setter
    def NumberofTransactions(self, value: float):
        """The number of daily confirmed Bitcoin transactions."""
        ...

    @property
    def TotalTransactionFeesUSD(self) -> float:
        """The total value of all transaction fees in USD paid to miners (not including the coinbase value of block rewards)."""
        ...

    @TotalTransactionFeesUSD.setter
    def TotalTransactionFeesUSD(self, value: float):
        """The total value of all transaction fees in USD paid to miners (not including the coinbase value of block rewards)."""
        ...

    @property
    def TotalTransactionFees(self) -> float:
        """The total value of all transaction fees in Bitcoin paid to miners (not including the coinbase value of block rewards)."""
        ...

    @TotalTransactionFees.setter
    def TotalTransactionFees(self, value: float):
        """The total value of all transaction fees in Bitcoin paid to miners (not including the coinbase value of block rewards)."""
        ...

    @property
    def MarketCapitalization(self) -> float:
        """The total USD value of bitcoin supply in circulation, as calculated by the daily average market price across major exchanges."""
        ...

    @MarketCapitalization.setter
    def MarketCapitalization(self, value: float):
        """The total USD value of bitcoin supply in circulation, as calculated by the daily average market price across major exchanges."""
        ...

    @property
    def TotalBitcoins(self) -> float:
        """The total number of bitcoins that have already been mined; in other words, the current supply of bitcoins on the network."""
        ...

    @TotalBitcoins.setter
    def TotalBitcoins(self, value: float):
        """The total number of bitcoins that have already been mined; in other words, the current supply of bitcoins on the network."""
        ...

    @property
    def MyWalletNumberofTransactionPerDay(self) -> float:
        """Number of transactions made by My Wallet Users per day."""
        ...

    @MyWalletNumberofTransactionPerDay.setter
    def MyWalletNumberofTransactionPerDay(self, value: float):
        """Number of transactions made by My Wallet Users per day."""
        ...

    @property
    def MyWalletTransactionVolume(self) -> float:
        """24hr Transaction Volume of our web wallet service."""
        ...

    @MyWalletTransactionVolume.setter
    def MyWalletTransactionVolume(self, value: float):
        """24hr Transaction Volume of our web wallet service."""
        ...

    def Clone(self) -> QuantConnect.Data.BaseData:
        """
        Clones the data
        
        :returns: A clone of the object.
        """
        ...

    def DataTimeZone(self) -> typing.Any:
        """
        Specifies the data time zone for this data type. This is useful for custom data types
        
        :returns: The NodaTime.DateTimeZone of this data type.
        """
        ...

    def DefaultResolution(self) -> int:
        """
        Gets the default resolution for this data and security type
        
        :returns: This method returns the int value of a member of the QuantConnect.Resolution enum.
        """
        ...

    def GetSource(self, config: QuantConnect.Data.SubscriptionDataConfig, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.SubscriptionDataSource:
        """
        Return the URL string source of the file. This will be converted to a stream
        
        :param config: Configuration object
        :param date: Date of this source file
        :param isLiveMode: true if we're in live mode, false for backtesting mode
        :returns: String URL of source file.
        """
        ...

    def IsSparseData(self) -> bool:
        """
        Indicates whether the data is sparse.
        If true, we disable logging for missing files
        
        :returns: true.
        """
        ...

    def Reader(self, config: QuantConnect.Data.SubscriptionDataConfig, line: str, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.BaseData:
        """
        Parses the data from the line provided and loads it into LEAN
        
        :param config: Subscription configuration
        :param line: Line of data
        :param date: Date
        :param isLiveMode: Is live mode
        :returns: New instance.
        """
        ...

    def RequiresMapping(self) -> bool:
        """
        Indicates whether the data source is tied to an underlying symbol and requires that corporate events be applied to it as well, such as renames and delistings
        
        :returns: false.
        """
        ...

    def SupportedResolutions(self) -> System.Collections.Generic.List[QuantConnect.Resolution]:
        """Gets the supported resolution for this data and security type"""
        ...

    def ToString(self) -> str:
        """Converts the instance to string"""
        ...


class QuiverEventsBeta(QuantConnect.Data.BaseData):
    """Political beta for the specified company"""

    DataSourceId: int
    """Data source ID"""

    @property
    def Date(self) -> datetime.datetime:
        """The date of the events beta calculation"""
        ...

    @Date.setter
    def Date(self, value: datetime.datetime):
        """The date of the events beta calculation"""
        ...

    @property
    def EventName(self) -> str:
        """Event name (e.g. PresidentialElection2020)"""
        ...

    @EventName.setter
    def EventName(self, value: str):
        """Event name (e.g. PresidentialElection2020)"""
        ...

    @property
    def FirstEventName(self) -> str:
        """Name for first outcome (e.g. TrumpVictory)"""
        ...

    @FirstEventName.setter
    def FirstEventName(self, value: str):
        """Name for first outcome (e.g. TrumpVictory)"""
        ...

    @property
    def SecondEventName(self) -> str:
        """Name for second outcome (e.g. BidenVictory)"""
        ...

    @SecondEventName.setter
    def SecondEventName(self, value: str):
        """Name for second outcome (e.g. BidenVictory)"""
        ...

    @property
    def FirstEventBeta(self) -> typing.Optional[float]:
        """Correlation between daily excess returns and daily changes in first event odds"""
        ...

    @FirstEventBeta.setter
    def FirstEventBeta(self, value: typing.Optional[float]):
        """Correlation between daily excess returns and daily changes in first event odds"""
        ...

    @property
    def FirstEventOdds(self) -> float:
        """Odds of the first event happening, based on betting markets"""
        ...

    @FirstEventOdds.setter
    def FirstEventOdds(self, value: float):
        """Odds of the first event happening, based on betting markets"""
        ...

    @property
    def SecondEventBeta(self) -> typing.Optional[float]:
        """Correlation between daily excess returns and daily changes in second event odds"""
        ...

    @SecondEventBeta.setter
    def SecondEventBeta(self, value: typing.Optional[float]):
        """Correlation between daily excess returns and daily changes in second event odds"""
        ...

    @property
    def SecondEventOdds(self) -> float:
        """Odds of the second event happening, based on betting markets"""
        ...

    @SecondEventOdds.setter
    def SecondEventOdds(self, value: float):
        """Odds of the second event happening, based on betting markets"""
        ...

    @property
    def Period(self) -> datetime.timedelta:
        """The period of time that occurs between the starting time and ending time of the data point"""
        ...

    @Period.setter
    def Period(self, value: datetime.timedelta):
        """The period of time that occurs between the starting time and ending time of the data point"""
        ...

    @property
    def EndTime(self) -> datetime.datetime:
        """The time the data point ends at and becomes available to the algorithm"""
        ...

    @EndTime.setter
    def EndTime(self, value: datetime.datetime):
        """The time the data point ends at and becomes available to the algorithm"""
        ...

    @overload
    def __init__(self) -> None:
        """Required for successful Json.NET deserialization"""
        ...

    @overload
    def __init__(self, csvLine: str) -> None:
        """
        Creates a new instance of QuiverPoliticalBeta from a CSV line
        
        :param csvLine: CSV line
        """
        ...

    def DataTimeZone(self) -> typing.Any:
        """
        Specifies the data time zone for this data type. This is useful for custom data types
        
        :returns: The DateTimeZone of this data type.
        """
        ...

    def GetSource(self, config: QuantConnect.Data.SubscriptionDataConfig, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.SubscriptionDataSource:
        """
        Return the Subscription Data Source gained from the URL
        
        :param config: Configuration object
        :param date: Date of this source file
        :param isLiveMode: true if we're in live mode, false for backtesting mode
        :returns: Subscription Data Source.
        """
        ...

    def Reader(self, config: QuantConnect.Data.SubscriptionDataConfig, line: str, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.BaseData:
        """
        Reader converts each line of the data source into BaseData objects.
        
        :param config: Subscription data config setup object
        :param line: Content of the source document
        :param date: Date of the requested data
        :param isLiveMode: true if we're in live mode, false for backtesting mode
        :returns: Quiver Political Beta object.
        """
        ...

    def RequiresMapping(self) -> bool:
        """
        Indicates if there is support for mapping
        
        :returns: True indicates mapping should be used.
        """
        ...

    def ToString(self) -> str:
        """Formats a string with the Quiver Events Beta information."""
        ...


class BenzingaNews(QuantConnect.Data.IndexedBaseData):
    """News data powered by Benzinga - https://docs.benzinga.io/benzinga/newsfeed-v2.html"""

    DataSourceId: int
    """Data source ID"""

    @property
    def Id(self) -> int:
        """Unique ID assigned to the article by Benzinga"""
        ...

    @Id.setter
    def Id(self, value: int):
        """Unique ID assigned to the article by Benzinga"""
        ...

    @property
    def Author(self) -> str:
        """Author of the article"""
        ...

    @Author.setter
    def Author(self, value: str):
        """Author of the article"""
        ...

    @property
    def CreatedAt(self) -> datetime.datetime:
        """Date the article was published"""
        ...

    @CreatedAt.setter
    def CreatedAt(self, value: datetime.datetime):
        """Date the article was published"""
        ...

    @property
    def UpdatedAt(self) -> datetime.datetime:
        """Date that the article was revised on"""
        ...

    @UpdatedAt.setter
    def UpdatedAt(self, value: datetime.datetime):
        """Date that the article was revised on"""
        ...

    @property
    def Title(self) -> str:
        """Title of the article published"""
        ...

    @Title.setter
    def Title(self, value: str):
        """Title of the article published"""
        ...

    @property
    def Teaser(self) -> str:
        """Summary of the article's contents"""
        ...

    @Teaser.setter
    def Teaser(self, value: str):
        """Summary of the article's contents"""
        ...

    @property
    def Contents(self) -> str:
        """Contents of the article"""
        ...

    @Contents.setter
    def Contents(self, value: str):
        """Contents of the article"""
        ...

    @property
    def Categories(self) -> System.Collections.Generic.List[str]:
        """Categories that relate to the article"""
        ...

    @Categories.setter
    def Categories(self, value: System.Collections.Generic.List[str]):
        """Categories that relate to the article"""
        ...

    @property
    def Symbols(self) -> System.Collections.Generic.List[QuantConnect.Symbol]:
        """Symbols that this news article mentions"""
        ...

    @Symbols.setter
    def Symbols(self, value: System.Collections.Generic.List[QuantConnect.Symbol]):
        """Symbols that this news article mentions"""
        ...

    @property
    def Tags(self) -> System.Collections.Generic.List[str]:
        """
        Additional tags that are not channels/categories, but are reoccuring
        themes including, but not limited to; analyst names, bills being talked
        about in Congress (Dodd-Frank), specific products (iPhone), politicians,
        celebrities, stock movements (i.e. 'Mid-day Losers' & 'Mid-day Gainers').
        """
        ...

    @Tags.setter
    def Tags(self, value: System.Collections.Generic.List[str]):
        """
        Additional tags that are not channels/categories, but are reoccuring
        themes including, but not limited to; analyst names, bills being talked
        about in Congress (Dodd-Frank), specific products (iPhone), politicians,
        celebrities, stock movements (i.e. 'Mid-day Losers' & 'Mid-day Gainers').
        """
        ...

    @property
    def EndTime(self) -> datetime.datetime:
        """Date that the article was revised on"""
        ...

    @EndTime.setter
    def EndTime(self, value: datetime.datetime):
        """Date that the article was revised on"""
        ...

    def Clone(self) -> QuantConnect.Data.BaseData:
        """
        Creates a clone of the instance
        
        :returns: A clone of the instance.
        """
        ...

    def DataTimeZone(self) -> typing.Any:
        """
        Set the data time zone to UTC
        
        :returns: Time zone as UTC.
        """
        ...

    def DefaultResolution(self) -> int:
        """
        Sets the default resolution to Second
        
        :returns: Resolution.Second. This method returns the int value of a member of the QuantConnect.Resolution enum.
        """
        ...

    def GetSource(self, config: QuantConnect.Data.SubscriptionDataConfig, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.SubscriptionDataSource:
        """
        Gets the source of the index file
        
        :param config: Configuration object
        :param date: Date of this source file
        :param isLiveMode: Is live mode
        :returns: SubscriptionDataSource indicating where data is located and how it's stored.
        """
        ...

    def GetSourceForAnIndex(self, config: QuantConnect.Data.SubscriptionDataConfig, date: typing.Union[datetime.datetime, datetime.date], index: str, isLiveMode: bool) -> QuantConnect.Data.SubscriptionDataSource:
        """
        Determines the actual source from an index contained within a ticker folder
        
        :param config: Subscription configuration
        :param date: Date
        :param index: File to load data from
        :param isLiveMode: Is live mode
        :returns: SubscriptionDataSource pointing to the article.
        """
        ...

    def IsSparseData(self) -> bool:
        """
        Indicates whether the data source is sparse.
        If false, it will disable missing file logging.
        
        :returns: true.
        """
        ...

    def Reader(self, config: QuantConnect.Data.SubscriptionDataConfig, line: str, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.BaseData:
        """
        Creates an instance from a line of JSON containing article information read from the `content` directory
        
        :param config: Subscription configuration
        :param line: Line of data
        :param date: Date
        :param isLiveMode: Is live mode
        :returns: New instance of BenzingaNews.
        """
        ...

    def RequiresMapping(self) -> bool:
        """
        Indicates whether the data source can undergo
        rename events/is tied to equities.
        
        :returns: true.
        """
        ...

    def SupportedResolutions(self) -> System.Collections.Generic.List[QuantConnect.Resolution]:
        """
        Gets a list of all the supported Resolutions
        
        :returns: All resolutions.
        """
        ...

    def ToString(self) -> str:
        """
        Converts the instance to string
        
        :returns: Article title and contents.
        """
        ...


class BenzingaNewsJsonConverter(JsonConverter):
    """
    Helper json converter class used to convert Benzinga news data
    into BenzingaNews
    
    An example schema of the data in a serialized format is provided
    to help you better understand this converter.
    """

    ShareClassMappedTickers: System.Collections.Generic.Dictionary[str, System.Collections.Generic.HashSet[str]] = ...
    """
    Sometimes "Berkshire Hathaway" is mentioned as "BRK" in the raw data, although it is
    separated into class A and B shares and should appear as BRK.A and BRK.B. Because our
    map file system does not perform the conversion from BRK -> { BRK.A, BRK.B }, we must
    provide them manually. Note that we don't dynamically try to locate class A and B shares
    because there can exist companies with the same base ticker that class A and B shares have.
    For example, CBS trades under "CBS" and "CBS.A", which means that if "CBS" appears, it will
    be automatically mapped to CBS. However, if we dynamically selected "CBS.A" - we might select
    a different company not associated with the ticker being referenced.
    """

    def __init__(self, symbol: typing.Union[QuantConnect.Symbol, str] = None, liveMode: bool = False) -> None:
        """
        Creates a new instance of the json converter
        
        :param symbol: The Symbol instance associated with this news
        :param liveMode: True if live mode, false for backtesting
        """
        ...

    def CanConvert(self, objectType: typing.Type) -> bool:
        """
        Determines whether this instance can convert the specified object type.
        
        :param objectType: Type of the object.
        :returns: true if this instance can convert the specified object type; otherwise, false.
        """
        ...

    @staticmethod
    def DeserializeNews(item: typing.Any, enableLogging: bool = False) -> QuantConnect.DataSource.BenzingaNews:
        """
        Helper method to deserialize a single json Benzinga news
        
        :param item: The json token containing the Benzinga news to deserialize
        :param enableLogging: true to enable logging (for debug purposes)
        :returns: The deserialized BenzingaNews instance.
        """
        ...

    def ReadJson(self, reader: typing.Any, objectType: typing.Type, existingValue: typing.Any, serializer: typing.Any) -> System.Object:
        """
        Reads the JSON representation of the object.
        
        :param reader: The Newtonsoft.Json.JsonReader to read from.
        :param objectType: Type of the object.
        :param existingValue: The existing value of object being read.
        :param serializer: The calling serializer.
        :returns: The object value.
        """
        ...

    def WriteJson(self, writer: typing.Any, value: typing.Any, serializer: typing.Any) -> None:
        """
        Writes the JSON representation of the object.
        
        :param writer: The Newtonsoft.Json.JsonWriter to write to.
        :param value: The value.
        :param serializer: The calling serializer.
        """
        ...


class QuiverWallStreetBets(QuantConnect.Data.BaseData):
    """Mentions of the given company's ticker in the WallStreetBets daily discussion thread"""

    DataSourceId: int
    """Data source ID"""

    @property
    def Date(self) -> datetime.datetime:
        """Date of the daily discussion thread"""
        ...

    @Date.setter
    def Date(self, value: datetime.datetime):
        """Date of the daily discussion thread"""
        ...

    @property
    def Mentions(self) -> int:
        """The number of mentions on the given date"""
        ...

    @Mentions.setter
    def Mentions(self, value: int):
        """The number of mentions on the given date"""
        ...

    @property
    def Rank(self) -> int:
        """This ticker's rank on the given date (as determined by total number of mentions)"""
        ...

    @Rank.setter
    def Rank(self, value: int):
        """This ticker's rank on the given date (as determined by total number of mentions)"""
        ...

    @property
    def Sentiment(self) -> float:
        """
        Average sentiment of all comments containing the given ticker on this date. Sentiment is calculated using VADER sentiment analysis.
        The value can range between -1 and +1. Negative values imply negative sentiment, whereas positive values imply positive sentiment.
        """
        ...

    @Sentiment.setter
    def Sentiment(self, value: float):
        """
        Average sentiment of all comments containing the given ticker on this date. Sentiment is calculated using VADER sentiment analysis.
        The value can range between -1 and +1. Negative values imply negative sentiment, whereas positive values imply positive sentiment.
        """
        ...

    @property
    def EndTime(self) -> datetime.datetime:
        """The time the data point ends at and becomes available to the algorithm"""
        ...

    @EndTime.setter
    def EndTime(self, value: datetime.datetime):
        """The time the data point ends at and becomes available to the algorithm"""
        ...

    @overload
    def __init__(self) -> None:
        """Required for successful Json.NET deserialization"""
        ...

    @overload
    def __init__(self, csvLine: str) -> None:
        """
        Creates a new instance of QuiverWallStreetBets from a CSV line
        
        :param csvLine: CSV line
        """
        ...

    def DataTimeZone(self) -> typing.Any:
        """
        Specifies the data time zone for this data type. This is useful for custom data types
        
        :returns: The DateTimeZone of this data type.
        """
        ...

    def GetSource(self, config: QuantConnect.Data.SubscriptionDataConfig, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.SubscriptionDataSource:
        """
        Return the Subscription Data Source gained from the URL
        
        :param config: Configuration object
        :param date: Date of this source file
        :param isLiveMode: true if we're in live mode, false for backtesting mode
        :returns: Subscription Data Source.
        """
        ...

    def Reader(self, config: QuantConnect.Data.SubscriptionDataConfig, line: str, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.BaseData:
        """
        Reader converts each line of the data source into BaseData objects.
        
        :param config: Subscription data config setup object
        :param line: Content of the source document
        :param date: Date of the requested data
        :param isLiveMode: true if we're in live mode, false for backtesting mode
        :returns: Quiver WallStreetBets object.
        """
        ...

    def RequiresMapping(self) -> bool:
        """
        Indicates if there is support for mapping
        
        :returns: True indicates mapping should be used.
        """
        ...

    def ToString(self) -> str:
        """Formats a string with the Quiver WallStreetBets information."""
        ...


class QuiverWallStreetBetsUniverse(QuantConnect.Data.BaseData):
    """Universe Selection helper class for QuiverWallStreetBets dataset"""

    @property
    def Symbol(self) -> QuantConnect.Symbol:
        """Symbol of data"""
        ...

    @Symbol.setter
    def Symbol(self, value: QuantConnect.Symbol):
        """Symbol of data"""
        ...

    @property
    def Mentions(self) -> int:
        """The number of mentions on the given date"""
        ...

    @Mentions.setter
    def Mentions(self, value: int):
        """The number of mentions on the given date"""
        ...

    @property
    def Rank(self) -> int:
        """This ticker's rank on the given date (as determined by total number of mentions)"""
        ...

    @Rank.setter
    def Rank(self, value: int):
        """This ticker's rank on the given date (as determined by total number of mentions)"""
        ...

    @property
    def Sentiment(self) -> float:
        """
        Average sentiment of all comments containing the given ticker on this date. Sentiment is calculated using VADER sentiment analysis.
        The value can range between -1 and +1. Negative values imply negative sentiment, whereas positive values imply positive sentiment.
        """
        ...

    @Sentiment.setter
    def Sentiment(self, value: float):
        """
        Average sentiment of all comments containing the given ticker on this date. Sentiment is calculated using VADER sentiment analysis.
        The value can range between -1 and +1. Negative values imply negative sentiment, whereas positive values imply positive sentiment.
        """
        ...

    @property
    def EndTime(self) -> datetime.datetime:
        """The time the data point ends at and becomes available to the algorithm"""
        ...

    @EndTime.setter
    def EndTime(self, value: datetime.datetime):
        """The time the data point ends at and becomes available to the algorithm"""
        ...

    def GetSource(self, config: QuantConnect.Data.SubscriptionDataConfig, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.SubscriptionDataSource:
        """
        Return the URL string source of the file. This will be converted to a stream
        
        :param config: Configuration object
        :param date: Date of this source file
        :param isLiveMode: true if we're in live mode, false for backtesting mode
        :returns: String URL of source file.
        """
        ...

    def Reader(self, config: QuantConnect.Data.SubscriptionDataConfig, line: str, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.BaseData:
        """
        Parses the data from the line provided and loads it into LEAN
        
        :param config: Subscription configuration
        :param line: Line of data
        :param date: Date
        :param isLiveMode: Is live mode
        :returns: New instance.
        """
        ...


class ExtractAlphaFiscalPeriod(System.Object):
    """Fiscal period that the ExtractAlphaTrueBeat instance has forecasts for."""

    @property
    def FiscalYear(self) -> int:
        """Fiscal year (i.e. the year that the financial report applies to in 10-Q and/or 10-K SEC filings)"""
        ...

    @FiscalYear.setter
    def FiscalYear(self, value: int):
        """Fiscal year (i.e. the year that the financial report applies to in 10-Q and/or 10-K SEC filings)"""
        ...

    @property
    def FiscalQuarter(self) -> typing.Optional[int]:
        """
        Fiscal quarter (i.e. the quarter that the financial report applies to in 10-Q filings).
        If this is null, then the fiscal period being reported is for the full year of the FiscalYear
        """
        ...

    @FiscalQuarter.setter
    def FiscalQuarter(self, value: typing.Optional[int]):
        """
        Fiscal quarter (i.e. the quarter that the financial report applies to in 10-Q filings).
        If this is null, then the fiscal period being reported is for the full year of the FiscalYear
        """
        ...

    @property
    def End(self) -> typing.Optional[datetime.datetime]:
        """The date that the fiscal quarter ends"""
        ...

    @End.setter
    def End(self, value: typing.Optional[datetime.datetime]):
        """The date that the fiscal quarter ends"""
        ...

    @property
    def ExpectedReportDate(self) -> typing.Optional[datetime.datetime]:
        """The date that the SEC report for the fiscal period is expected to be released publicly"""
        ...

    @ExpectedReportDate.setter
    def ExpectedReportDate(self, value: typing.Optional[datetime.datetime]):
        """The date that the SEC report for the fiscal period is expected to be released publicly"""
        ...

    @property
    def Annual(self) -> bool:
        """Returns true if the fiscal period is for the whole fiscal year (all quarters)"""
        ...

    @property
    def Quarterly(self) -> bool:
        """Returns true if the fiscal period is for a single quarter only"""
        ...


class ExtractAlphaTrueBeat(QuantConnect.Data.BaseData):
    """
    EPS/Revenue earnings surprise forecasting for upcoming financial reports released
    by regulatory agencies (e.g. United States SEC)
    """

    @property
    def FiscalPeriod(self) -> QuantConnect.DataSource.ExtractAlphaFiscalPeriod:
        """The fiscal period that is being forecasted"""
        ...

    @FiscalPeriod.setter
    def FiscalPeriod(self, value: QuantConnect.DataSource.ExtractAlphaFiscalPeriod):
        """The fiscal period that is being forecasted"""
        ...

    @property
    def EarningsMetric(self) -> int:
        """
        The earnings metric being forecasted (e.g. EPS, revenue)
        
        This property contains the int value of a member of the QuantConnect.DataSource.ExtractAlphaTrueBeatEarningsMetric enum.
        """
        ...

    @EarningsMetric.setter
    def EarningsMetric(self, value: int):
        """
        The earnings metric being forecasted (e.g. EPS, revenue)
        
        This property contains the int value of a member of the QuantConnect.DataSource.ExtractAlphaTrueBeatEarningsMetric enum.
        """
        ...

    @property
    def AnalystEstimatesCount(self) -> int:
        """The number of analyst estimates that the TrueBeat used in its calculation"""
        ...

    @AnalystEstimatesCount.setter
    def AnalystEstimatesCount(self, value: int):
        """The number of analyst estimates that the TrueBeat used in its calculation"""
        ...

    @property
    def TrueBeat(self) -> float:
        """
        The forecasted earnings surprise percentage, relative to consensus estimates.
        TrueBeat is calculated as the total sum of the ExpertBeat, TrendBeat, and ManagementBeat metrics.
        """
        ...

    @TrueBeat.setter
    def TrueBeat(self, value: float):
        """
        The forecasted earnings surprise percentage, relative to consensus estimates.
        TrueBeat is calculated as the total sum of the ExpertBeat, TrendBeat, and ManagementBeat metrics.
        """
        ...

    @property
    def ExpertBeat(self) -> typing.Optional[float]:
        """The component of TrueBeat that is derived from top analyst estimates"""
        ...

    @ExpertBeat.setter
    def ExpertBeat(self, value: typing.Optional[float]):
        """The component of TrueBeat that is derived from top analyst estimates"""
        ...

    @property
    def TrendBeat(self) -> typing.Optional[float]:
        """The component of TrueBeat that is derived from trends in stock and peer surprises"""
        ...

    @TrendBeat.setter
    def TrendBeat(self, value: typing.Optional[float]):
        """The component of TrueBeat that is derived from trends in stock and peer surprises"""
        ...

    @property
    def ManagementBeat(self) -> typing.Optional[float]:
        """The component of TrueBeat that is derived from management activity (e.g. guidance)"""
        ...

    @ManagementBeat.setter
    def ManagementBeat(self, value: typing.Optional[float]):
        """The component of TrueBeat that is derived from management activity (e.g. guidance)"""
        ...

    @property
    def EndTime(self) -> datetime.datetime:
        """The time that the data became available to the algorithm"""
        ...

    @EndTime.setter
    def EndTime(self, value: datetime.datetime):
        """The time that the data became available to the algorithm"""
        ...

    def Clone(self) -> QuantConnect.Data.BaseData:
        """
        Return a new instance clone of this object, used in fill forward
        
        :returns: A clone of the current object.
        """
        ...

    def DataTimeZone(self) -> typing.Any:
        """
        Specifies the data time zone for this data type. This is useful for custom data types
        
        :returns: The NodaTime.DateTimeZone of this data type.
        """
        ...

    def IsSparseData(self) -> bool:
        """
        Indicates that the data set is expected to be sparse
        
        :returns: True if the data set represented by this type is expected to be sparse.
        """
        ...

    def Reader(self, config: QuantConnect.Data.SubscriptionDataConfig, line: str, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.BaseData:
        """
        Reader converts each line of the data source into BaseData objects. Each data type creates its own factory method, and returns a new instance of the object
        each time it is called. The returned object is assumed to be time stamped in the config.ExchangeTimeZone.
        
        :param config: Subscription data config setup object
        :param line: Line of the source document
        :param date: Date of the requested data
        :param isLiveMode: true if we're in live mode, false for backtesting mode
        :returns: Instance of the T:BaseData object generated by this line of the CSV.
        """
        ...

    def RequiresMapping(self) -> bool:
        """
        Indicates if there is support for mapping
        
        :returns: True indicates mapping should be used.
        """
        ...

    def ToString(self) -> str:
        """
        Formats a string with TrueBeat data
        
        :returns: string containing TrueBeat information.
        """
        ...


class ExtractAlphaTrueBeats(QuantConnect.Data.UniverseSelection.BaseDataCollection):
    """A collection of Extra Alpha True Beats for a Symbol and date"""

    def Add(self, newDataPoint: QuantConnect.Data.BaseData) -> None:
        """
        Adds a new data point to this collection
        
        :param newDataPoint: The new data point to add
        """
        ...

    def AddRange(self, newDataPoints: System.Collections.Generic.IEnumerable[QuantConnect.Data.BaseData]) -> None:
        """
        Adds a new data points to this collection
        
        :param newDataPoints: The new data points to add
        """
        ...

    def Clone(self) -> QuantConnect.Data.BaseData:
        """
        Return a new instance clone of this object, used in fill forward
        
        :returns: A clone of the current object.
        """
        ...

    def DataTimeZone(self) -> typing.Any:
        """
        Specifies the data time zone for this data type. This is useful for custom data types
        
        :returns: The NodaTime.DateTimeZone of this data type.
        """
        ...

    def GetSource(self, config: QuantConnect.Data.SubscriptionDataConfig, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.SubscriptionDataSource:
        """
        Return the URL string source of the file. This will be converted to a stream
        
        :param config: Configuration object
        :param date: Date of this source file
        :param isLiveMode: true if we're in live mode, false for backtesting mode
        :returns: String URL of source file.
        """
        ...

    def IsSparseData(self) -> bool:
        """
        Indicates that the data set is expected to be sparse
        
        :returns: True if the data set represented by this type is expected to be sparse.
        """
        ...

    def Reader(self, config: QuantConnect.Data.SubscriptionDataConfig, line: str, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.BaseData:
        """
        Reader converts each line of the data source into BaseData objects. Each data type creates its own factory method, and returns a new instance of the object
        each time it is called. The returned object is assumed to be time stamped in the config.ExchangeTimeZone.
        
        :param config: Subscription data config setup object
        :param line: Line of the source document
        :param date: Date of the requested data
        :param isLiveMode: true if we're in live mode, false for backtesting mode
        :returns: Instance of the T:BaseData object generated by this line of the CSV.
        """
        ...

    def RequiresMapping(self) -> bool:
        """
        Indicates if there is support for mapping
        
        :returns: True indicates mapping should be used.
        """
        ...

    def ToString(self) -> str:
        """
        Formats a string with TrueBeat data
        
        :returns: string containing TrueBeat information.
        """
        ...


class ExtractAlphaTrueBeatEarningsMetric(System.Enum):
    """The earnings metric/type being forecasted"""

    EPS = 0
    """Earnings per share"""

    Revenue = 1
    """Revenue"""


class NasdaqBitfinexDownloader(System.Object, QuantConnect.IDataDownloader):
    """Nasdaq Bitfinex Data Downloader class"""

    @property
    def _apiKey(self) -> str:
        """This field is protected."""
        ...

    def __init__(self, apiKey: str) -> None:
        """
        Initializes a new instance of the NasdaqBitfinexDownloader class
        
        :param apiKey: The nasdaq api key
        """
        ...

    def Get(self, dataDownloaderGetParameters: QuantConnect.DataDownloaderGetParameters) -> System.Collections.Generic.IEnumerable[QuantConnect.Data.BaseData]:
        """
        Get historical data enumerable for Bitfinex from Nasdaq
        
        :param dataDownloaderGetParameters: model class for passing in parameters for historical data
        :returns: Enumerable of base data for this symbol.
        """
        ...


class NasdaqDataLink(QuantConnect.Data.DynamicData):
    """Nasdaq Data Link dataset"""

    @property
    def ValueColumnName(self) -> str:
        """
        Name of the column is going to be used for the field Value
        
        This property is protected.
        """
        ...

    @ValueColumnName.setter
    def ValueColumnName(self, value: str):
        """
        Name of the column is going to be used for the field Value
        
        This property is protected.
        """
        ...

    IsAuthCodeSet: bool
    """Flag indicating whether or not the Nasdaq Data Link auth code has been set yet"""

    @property
    def EndTime(self) -> datetime.datetime:
        """
        The end time of this data. Some data covers spans (trade bars) and as such we want
        to know the entire time span covered
        """
        ...

    @EndTime.setter
    def EndTime(self, value: datetime.datetime):
        """
        The end time of this data. Some data covers spans (trade bars) and as such we want
        to know the entire time span covered
        """
        ...

    @property
    def Period(self) -> datetime.timedelta:
        """Gets a time span of one day"""
        ...

    @overload
    def __init__(self) -> None:
        """Default NasdaqDataLink constructor uses Close as its value column"""
        ...

    @overload
    def __init__(self, valueColumnName: str) -> None:
        """
        Constructor for creating customized NasdaqDataLink instance which doesn't use close, price, settle or value as its value item.
        
        This method is protected.
        
        :param valueColumnName: The name of the column we want to use as reference, the Value property
        """
        ...

    def DataTimeZone(self) -> typing.Any:
        """
        Specifies the data time zone for this data type. This is useful for custom data types
        
        :returns: The NodaTime.DateTimeZone of this data type.
        """
        ...

    def DefaultResolution(self) -> int:
        """
        Gets the default resolution for this data and security type
        
        :returns: This method returns the int value of a member of the QuantConnect.Resolution enum.
        """
        ...

    def GetSource(self, config: QuantConnect.Data.SubscriptionDataConfig, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.SubscriptionDataSource:
        """
        Using the Nasdaq Data Link V3 API automatically set the URL for the dataset.
        
        :param config: Subscription configuration object
        :param date: Date of the data file we're looking for
        :param isLiveMode: true if we're in live mode, false for backtesting mode
        :returns: STRING API Url for Nasdaq Data Link.
        """
        ...

    def IsSparseData(self) -> bool:
        """
        Indicates whether the data is sparse.
        If true, we disable logging for missing files
        
        :returns: true.
        """
        ...

    def Reader(self, config: QuantConnect.Data.SubscriptionDataConfig, line: str, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.BaseData:
        """
        Parses the data from the line provided and loads it into LEAN
        
        :param config: Subscription configuration
        :param line: CSV line of data from the souce
        :param date: Date of the requested line
        :param isLiveMode: Is live mode
        :returns: New instance.
        """
        ...

    @staticmethod
    def SetAuthCode(authCode: str) -> None:
        """Set the auth code for the Nasdaq Data Link set to the QuantConnect auth code."""
        ...

    def SupportedResolutions(self) -> System.Collections.Generic.List[QuantConnect.Resolution]:
        """Gets the supported resolution for this data and security type"""
        ...


class QuandlBitfinexDownloader(QuantConnect.DataSource.NasdaqBitfinexDownloader):
    """Quandl Bitfinex Data Downloader class"""

    def __init__(self, apiKey: str) -> None:
        """
        Initializes a new instance of the QuandlBitfinexDownloader class
        
        :param apiKey: The quandl api key
        """
        ...


class NasdaqBitfinexDownloaderProgram(System.Object):
    """This class has no documentation."""

    @staticmethod
    def NasdaqBitfinexDownloader(fromDate: typing.Union[datetime.datetime, datetime.date], apiKey: str) -> None:
        """Nasdaq Bitfinex Toolbox Project For LEAN Algorithmic Trading Engine."""
        ...


class QuandlBitfinexDownloaderProgram(System.Object):
    """This class has no documentation."""

    @staticmethod
    def QuandlBitfinexDownloader(fromDate: typing.Union[datetime.datetime, datetime.date], apiKey: str) -> None:
        """Quandl Bitfinex Toolbox Project For LEAN Algorithmic Trading Engine."""
        ...


class USEnergy(QuantConnect.Data.BaseData):
    """United States Energy Information Administration (EIA). This loads U.S. Energy data from QuantConnect's cache."""

    class Petroleum(System.Object):
        """Petroleum"""

        class UnitedStates(System.Object):
            """United States"""

            WeeklyRefinerAndBlenderAdjustedNetProductionOfFinishedMotorGasoline: str = "PET.WGFRPUS2.W"
            """U.S. Refiner and Blender Adjusted Net Production of Finished Motor Gasoline in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyEndingStocksOfFinishedMotorGasoline: str = "PET.WGFSTUS1.W"
            """U.S. Ending Stocks of Finished Motor Gasoline in Thousand Barrels (Mbbl)"""

            WeeklyProductSuppliedOfFinishedMotorGasoline: str = "PET.WGFUPUS2.W"
            """U.S. Product Supplied of Finished Motor Gasoline in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyEndingStocksOfCrudeOilInSpr: str = "PET.WCSSTUS1.W"
            """U.S. Ending Stocks of Crude Oil in SPR in Thousand Barrels (Mbbl)"""

            WeeklyRefinerAndBlenderNetProductionOfDistillateFuelOilGreaterThan500PpmSulfur: str = "PET.WDGRPUS2.W"
            """U.S.  Refiner and Blender Net Production of Distillate Fuel Oil Greater than 500 ppm Sulfur in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyEndingStocksOfDistillateFuelOilGreaterThan500PpmSulfur: str = "PET.WDGSTUS1.W"
            """U.S. Ending Stocks of Distillate Fuel Oil, Greater Than 500 ppm Sulfur in Thousand Barrels (Mbbl)"""

            WeeklyExportsOfTotalDistillate: str = "PET.WDIEXUS2.W"
            """U.S. Exports of Total Distillate in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyImportsOfDistillateFuelOil: str = "PET.WDIIMUS2.W"
            """U.S. Imports of Distillate Fuel Oil in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyRefinerAndBlenderNetProductionOfDistillateFuelOil: str = "PET.WDIRPUS2.W"
            """U.S. Refiner and Blender Net Production of Distillate Fuel Oil in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyEndingStocksOfKeroseneTypeJetFuel: str = "PET.WKJSTUS1.W"
            """U.S. Ending Stocks of Kerosene-Type Jet Fuel in Thousand Barrels (Mbbl)"""

            WeeklyProductSuppliedOfKeroseneTypeJetFuel: str = "PET.WKJUPUS2.W"
            """U.S. Product Supplied of Kerosene-Type Jet Fuel in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyImportsOfTotalGasoline: str = "PET.WGTIMUS2.W"
            """U.S. Imports of Total Gasoline in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyEndingStocksOfTotalGasoline: str = "PET.WGTSTUS1.W"
            """U.S. Ending Stocks of Total Gasoline in Thousand Barrels (Mbbl)"""

            WeeklyGrossInputsIntoRefineries: str = "PET.WGIRIUS2.W"
            """U.S. Gross Inputs into Refineries in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyImportsOfReformulatedMotorGasoline: str = "PET.WGRIMUS2.W"
            """U.S. Imports of Reformulated Motor Gasoline in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyRefinerAndBlenderNetProductionOfReformulatedMotorGasoline: str = "PET.WGRRPUS2.W"
            """U.S. Refiner and Blender Net Production of Reformulated Motor Gasoline in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyEndingStocksOfReformulatedMotorGasoline: str = "PET.WGRSTUS1.W"
            """U.S. Ending Stocks of Reformulated Motor Gasoline in Thousand Barrels (Mbbl)"""

            WeeklyEndingStocksOfDistillateFuelOil: str = "PET.WDISTUS1.W"
            """U.S. Ending Stocks of Distillate Fuel Oil in Thousand Barrels (Mbbl)"""

            WeeklyProductSuppliedOfDistillateFuelOil: str = "PET.WDIUPUS2.W"
            """U.S. Product Supplied of Distillate Fuel Oil in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyRefinerAndBlenderNetProductionOfMilitaryKeroseneTypeJetFuel: str = "PET.WKMRPUS2.W"
            """U.S.  Refiner and Blender Net Production of Military Kerosene-Type Jet Fuel in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyOperableCrudeOilDistillationCapacity: str = "PET.WOCLEUS2.W"
            """U. S. Operable Crude Oil Distillation Capacity in Thousand Barrels per Calendar Day (Mbbl/d)"""

            WeeklyPropyleneNonfuelUseStocksAtBulkTerminals: str = "PET.WPLSTUS1.W"
            """U.S. Propylene Nonfuel Use Stocks at Bulk Terminals in Thousand Barrels (Mbbl)"""

            WeeklyEndingStocksOfPropaneAndPropylene: str = "PET.WPRSTUS1.W"
            """U.S. Ending Stocks of Propane and Propylene in Thousand Barrels (Mbbl)"""

            WeeklyPercentUtilizationOfRefineryOperableCapacity: str = "PET.WPULEUS3.W"
            """U.S. Percent Utilization of Refinery Operable Capacity in Percent (%)"""

            WeeklyExportsOfResidualFuelOil: str = "PET.WREEXUS2.W"
            """U.S. Exports of Residual Fuel Oil in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyImportsOfResidualFuelOil: str = "PET.WREIMUS2.W"
            """U.S. Imports of Residual Fuel Oil in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyRefinerAndBlenderNetProductionOfCommercialKeroseneTypeJetFuel: str = "PET.WKCRPUS2.W"
            """U.S.  Refiner and Blender Net Production of Commercial Kerosene-Type Jet Fuel in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyExportsOfKeroseneTypeJetFuel: str = "PET.WKJEXUS2.W"
            """U.S. Exports of Kerosene-Type Jet Fuel in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyImportsOfKeroseneTypeJetFuel: str = "PET.WKJIMUS2.W"
            """U.S. Imports of Kerosene-Type Jet Fuel in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyRefinerAndBlenderNetProductionOfKeroseneTypeJetFuel: str = "PET.WKJRPUS2.W"
            """U.S. Refiner and Blender Net Production of Kerosene-Type Jet Fuel in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyEndingStocksExcludingSprOfCrudeOil: str = "PET.WCESTUS1.W"
            """U.S. Ending Stocks excluding SPR of Crude Oil in Thousand Barrels (Mbbl)"""

            WeeklyExportsOfCrudeOil: str = "PET.WCREXUS2.W"
            """U.S. Exports of Crude Oil in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyFieldProductionOfCrudeOil: str = "PET.WCRFPUS2.W"
            """U.S. Field Production of Crude Oil in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyImportsOfCrudeOil: str = "PET.WCRIMUS2.W"
            """U.S. Imports of Crude Oil in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyNetImportsOfCrudeOil: str = "PET.WCRNTUS2.W"
            """U.S. Net Imports of Crude Oil in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyRefinerNetInputOfCrudeOil: str = "PET.WCRRIUS2.W"
            """U.S. Refiner Net Input of Crude Oil in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyRefinerAndBlenderNetProductionOfResidualFuelOil: str = "PET.WRERPUS2.W"
            """U.S. Refiner and Blender Net Production of Residual Fuel Oil in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyEndingStocksOfResidualFuelOil: str = "PET.WRESTUS1.W"
            """U.S. Ending Stocks of Residual Fuel Oil in Thousand Barrels (Mbbl)"""

            WeeklyProductSuppliedOfResidualFuelOil: str = "PET.WREUPUS2.W"
            """U.S. Product Supplied of Residual Fuel Oil in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyExportsOfTotalPetroleumProducts: str = "PET.WRPEXUS2.W"
            """U.S. Exports of Total Petroleum Products in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyImportsOfTotalPetroleumProducts: str = "PET.WRPIMUS2.W"
            """U.S. Imports of Total Petroleum Products in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyNetImportsOfTotalPetroleumProducts: str = "PET.WRPNTUS2.W"
            """U.S. Net Imports of Total Petroleum Products in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyProductSuppliedOfPetroleumProducts: str = "PET.WRPUPUS2.W"
            """U.S. Product Supplied of Petroleum Products in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyEndingStocksExcludingSprOfCrudeOilAndPetroleumProducts: str = "PET.WTESTUS1.W"
            """U.S. Ending Stocks excluding SPR of Crude Oil and Petroleum Products in Thousand Barrels (Mbbl)"""

            WeeklyExportsOfCrudeOilAndPetroleumProducts: str = "PET.WTTEXUS2.W"
            """U.S. Exports of Crude Oil and Petroleum Products in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyImportsOfCrudeOilAndPetroleumProducts: str = "PET.WTTIMUS2.W"
            """U.S. Imports of Crude Oil and Petroleum Products in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyNetImportsOfCrudeOilAndPetroleumProducts: str = "PET.WTTNTUS2.W"
            """U.S. Net Imports of Crude Oil and Petroleum Products in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyEndingStocksOfCrudeOilAndPetroleumProducts: str = "PET.WTTSTUS1.W"
            """U.S. Ending Stocks of Crude Oil and Petroleum Products in Thousand Barrels (Mbbl)"""

            WeeklyEndingStocksOfUnfinishedOils: str = "PET.WUOSTUS1.W"
            """U.S. Ending Stocks of Unfinished Oils in Thousand Barrels (Mbbl)"""

            WeeklyRefinerAndBlenderNetProductionOfOtherFinishedConventionalMotorGasoline: str = "PET.WG6TP_NUS_2.W"
            """U.S. Refiner and Blender Net Production of Other Finished Conventional Motor Gasoline in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyRefinerAndBlenderNetProductionOfDistillateFuelOil0To15PpmSulfur: str = "PET.WD0TP_NUS_2.W"
            """U.S. Refiner and Blender Net Production of Distillate Fuel Oil, 0 to 15 ppm Sulfur in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyEndingStocksOfDistillateFuelOilGreaterThan15To500PpmSulfur: str = "PET.WD1ST_NUS_1.W"
            """U.S. Ending Stocks of Distillate Fuel Oil, Greater than 15 to 500 ppm Sulfur in Thousand Barrels (Mbbl)"""

            WeeklyProductionOfDistillateFuelOilGreaterThan15To500PpmSulfur: str = "PET.WD1TP_NUS_2.W"
            """U.S. Production of Distillate Fuel Oil, Greater than 15 to 500 ppm Sulfur in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyEndingStocksOfReformulatedMotorGasolineWithFuelAlcohol: str = "PET.WG1ST_NUS_1.W"
            """U.S. Ending Stocks of Reformulated Motor Gasoline with Fuel ALcohol in Thousand Barrels (Mbbl)"""

            WeeklyEndingStocksOfCrudeOil: str = "PET.WCRSTUS1.W"
            """U.S. Ending Stocks of Crude Oil in Thousand Barrels (Mbbl)"""

            WeeklyCrudeOilImportsBySpr: str = "PET.WCSIMUS2.W"
            """U.S. Crude Oil Imports by SPR in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyImportsOfGasolineBlendingComponents: str = "PET.WBCIMUS2.W"
            """U.S. Imports of Gasoline Blending Components in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyEndingStocksOfGasolineBlendingComponents: str = "PET.WBCSTUS1.W"
            """U.S. Ending Stocks of Gasoline Blending Components in Thousand Barrels (Mbbl)"""

            WeeklyCommercialCrudeOilImportsExcludingSpr: str = "PET.WCEIMUS2.W"
            """U.S. Commercial Crude Oil Imports Excluding SPR in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyRefinerBlenderAndGasPlantNetProductionOfPropaneAndPropylene: str = "PET.WPRTP_NUS_2.W"
            """U.S. Refiner, Blender, and Gas Plant Net Production of Propane and Propylene in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyRefinerAndBlenderNetProductionOfFinishedReformulatedMotorGasolineWithEthanol: str = "PET.WG1TP_NUS_2.W"
            """U.S. Refiner and Blender Net Production of Finished Reformulated Motor Gasoline with Ethanol in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyEndingStocksOfReformulatedMotorGasolineNonOxygentated: str = "PET.WG3ST_NUS_1.W"
            """U.S. Ending Stocks of Reformulated Motor Gasoline, Non-Oxygentated in Thousand Barrels (Mbbl)"""

            WeeklyEndingStocksOfConventionalMotorGasoline: str = "PET.WG4ST_NUS_1.W"
            """U.S. Ending Stocks of Conventional Motor Gasoline in Thousand Barrels (Mbbl)"""

            WeeklyRefinerAndBlenderNetProductionOfConventionalMotorGasoline: str = "PET.WG4TP_NUS_2.W"
            """U.S. Refiner and Blender Net Production of Conventional Motor Gasoline in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyEndingStocksOfConventionalMotorGasolineWithFuelEthanol: str = "PET.WG5ST_NUS_1.W"
            """U.S. Ending Stocks of Conventional Motor Gasoline with Fuel Ethanol in Thousand Barrels (Mbbl)"""

            WeeklyRefinerAndBlenderNetProductionOfFinishedConventionalMotorGasolineWithEthanol: str = "PET.WG5TP_NUS_2.W"
            """U.S. Refiner and Blender Net Production of Finished Conventional Motor Gasoline with Ethanol in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyEndingStocksOfOtherConventionalMotorGasoline: str = "PET.WG6ST_NUS_1.W"
            """U.S. Ending Stocks of Other Conventional Motor Gasoline in Thousand Barrels (Mbbl)"""

            WeeklyRefinerAndBlenderNetInputOfConventionalCbobGasolineBlendingComponents: str = "PET.WO6RI_NUS_2.W"
            """U.S. Refiner and Blender Net Input of Conventional CBOB Gasoline Blending Components in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyEndingStocksOfConventionalCbobGasolineBlendingComponents: str = "PET.WO6ST_NUS_1.W"
            """U.S. Ending Stocks of Conventional CBOB Gasoline Blending Components in Thousand Barrels (Mbbl)"""

            WeeklyRefinerAndBlenderNetInputOfConventionalGtabGasolineBlendingComponents: str = "PET.WO7RI_NUS_2.W"
            """U.S. Refiner and Blender Net Input of Conventional GTAB Gasoline Blending Components in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyEndingStocksOfConventionalGtabGasolineBlendingComponents: str = "PET.WO7ST_NUS_1.W"
            """U.S. Ending Stocks of Conventional GTAB Gasoline Blending Components in Thousand Barrels (Mbbl)"""

            WeeklyRefinerAndBlenderNetInputOfConventionalOtherGasolineBlendingComponents: str = "PET.WO9RI_NUS_2.W"
            """U.S. Refiner and Blender Net Input of Conventional Other Gasoline Blending Components in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyEndingStocksOfConventionalOtherGasolineBlendingComponents: str = "PET.WO9ST_NUS_1.W"
            """U.S. Ending Stocks of Conventional Other Gasoline Blending Components in Thousand Barrels (Mbbl)"""

            WeeklyNo2HeatingOilWholesaleResalePrice: str = "PET.W_EPD2F_PWR_NUS_DPG.W"
            """U.S. No. 2 Heating Oil Wholesale/Resale Price in Dollars per Gallon ($/gal)"""

            WeeklyCrudeOilStocksInTransitOnShipsFromAlaska: str = "PET.W_EPC0_SKA_NUS_MBBL.W"
            """U.S. Crude Oil Stocks in Transit (on Ships) from Alaska in Thousand Barrels (Mbbl)"""

            WeeklyDaysOfSupplyOfCrudeOilExcludingSpr: str = "PET.W_EPC0_VSD_NUS_DAYS.W"
            """U.S. Days of Supply of Crude Oil excluding SPR in Number of Days (Days)"""

            WeeklyDaysOfSupplyOfTotalDistillate: str = "PET.W_EPD0_VSD_NUS_DAYS.W"
            """U.S. Days of Supply of Total Distillate in Number of Days (Days)"""

            WeeklyWeeklyNo2HeatingOilResidentialPrice: str = "PET.W_EPD2F_PRS_NUS_DPG.W"
            """U.S. Weekly No. 2 Heating Oil Residential Price in Dollars per Gallon ($/gal)"""

            WeeklyProductSuppliedOfPropaneAndPropylene: str = "PET.WPRUP_NUS_2.W"
            """U.S. Product Supplied of Propane and Propylene in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyProductSuppliedOfOtherOils: str = "PET.WWOUP_NUS_2.W"
            """U.S. Product Supplied of Other Oils in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyRefinerAndBlenderNetInputOfGasolineBlendingComponents: str = "PET.WBCRI_NUS_2.W"
            """U.S. Refiner and Blender Net Input of Gasoline Blending Components in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyEndingStocksOfDistillateFuelOil0To15PpmSulfur: str = "PET.WD0ST_NUS_1.W"
            """U.S. Ending Stocks of Distillate Fuel Oil, 0 to 15 ppm Sulfur in Thousand Barrels (Mbbl)"""

            WeeklyDaysOfSupplyOfKeroseneTypeJetFuel: str = "PET.W_EPJK_VSD_NUS_DAYS.W"
            """U.S. Days of Supply of Kerosene-Type Jet Fuel in Number of Days (Days)"""

            WeeklyDaysOfSupplyOfTotalGasoline: str = "PET.W_EPM0_VSD_NUS_DAYS.W"
            """U.S. Days of Supply of Total Gasoline in Number of Days (Days)"""

            WeeklyEndingStocksOfAsphaltAndRoadOil: str = "PET.W_EPPA_SAE_NUS_MBBL.W"
            """U.S. Ending Stocks of Asphalt and Road Oil in Thousand Barrels (Mbbl)"""

            WeeklyEndingStocksOfKerosene: str = "PET.W_EPPK_SAE_NUS_MBBL.W"
            """U.S. Ending Stocks of Kerosene in Thousand Barrels (Mbbl)"""

            WeeklySupplyAdjustmentOfDistillateFuelOilGreaterThan15To500PpmSulfur: str = "PET.W_EPDM10_VUA_NUS_2.W"
            """U.S. Supply Adjustment of Distillate Fuel Oil, Greater than 15 to 500 ppm Sulfur in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyImportsOfConventionalMotorGasolineWithFuelEthanol: str = "PET.WG5IM_NUS-Z00_2.W"
            """U.S. Imports of Conventional Motor Gasoline with Fuel Ethanol in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyImportsOfOtherConventionalMotorGasoline: str = "PET.WG6IM_NUS-Z00_2.W"
            """U.S. Imports of Other Conventional Motor Gasoline in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyImportsOfDistillateFuelOil0To15PpmSulfur: str = "PET.WD0IM_NUS-Z00_2.W"
            """U.S. Imports of Distillate Fuel Oil, 0 to 15 ppm Sulfur in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyImportsOfDistillateFuelOilGreaterThan15To500PpmSulfur: str = "PET.WD1IM_NUS-Z00_2.W"
            """U.S. Imports of Distillate Fuel Oil, Greater than 15 to 500 ppm Sulfur in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyImportsOfDistillateFuelOilGreaterThan500To2000PpmSulfur: str = "PET.WD2IM_NUS-Z00_2.W"
            """U.S. Imports of Distillate Fuel Oil, Greater than 500 to 2000 ppm Sulfur in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyImportsOfPropaneAndPropylene: str = "PET.WPRIM_NUS-Z00_2.W"
            """U.S. Imports of Propane and Propylene in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyImportsOfConventionalGtabGasolineBlendingComponents: str = "PET.WO7IM_NUS-Z00_2.W"
            """U.S. Imports of Conventional GTAB Gasoline Blending Components in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyImportsOfDistillateFuelOilGreaterThan2000PpmSulfur: str = "PET.WD3IM_NUS-Z00_2.W"
            """U.S. Imports of Distillate Fuel Oil, Greater than 2000 ppm Sulfur in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyImportsOfReformulatedMotorGasolineWithFuelAlcohol: str = "PET.WG1IM_NUS-Z00_2.W"
            """U.S. Imports of Reformulated Motor Gasoline with Fuel ALcohol in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyImportsOfConventionalMotorGasoline: str = "PET.WG4IM_NUS-Z00_2.W"
            """U.S. Imports of Conventional Motor Gasoline in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyImportsOfConventionalOtherGasolineBlendingComponents: str = "PET.WO9IM_NUS-Z00_2.W"
            """U.S. Imports of Conventional Other Gasoline Blending Components in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyImportsOfConventionalCbobGasolineBlendingComponents: str = "PET.WO6IM_NUS-Z00_2.W"
            """U.S. Imports of Conventional CBOB Gasoline Blending Components in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyBlenderNetProductionOfKerosene: str = "PET.W_EPPK_YPB_NUS_MBBLD.W"
            """U.S. Blender Net Production of Kerosene in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyRefinerNetProductionOfKerosene: str = "PET.W_EPPK_YPY_NUS_MBBLD.W"
            """U.S. Refiner Net Production of Kerosene in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyEndingStocksOfOtherOilsExcludingFuelEthanol: str = "PET.W_EPPO6_SAE_NUS_MBBL.W"
            """U.S. Ending Stocks of Other Oils (Excluding Fuel Ethanol) in Thousand Barrels (Mbbl)"""

            WeeklyRefinerNetProductionOfResidualFuelOil: str = "PET.W_EPPR_YPY_NUS_MBBLD.W"
            """U.S. Refiner Net Production of Residual Fuel Oil in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyBlenderNetProductionOfReformulatedMotorGasoline: str = "PET.W_EPM0R_YPB_NUS_MBBLD.W"
            """U.S. Blender Net Production of Reformulated Motor Gasoline in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyRefinerNetProductionOfReformulatedMotorGasoline: str = "PET.W_EPM0R_YPY_NUS_MBBLD.W"
            """U.S. Refiner Net Production of Reformulated Motor Gasoline in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyEndingStocksOfFuelEthanol: str = "PET.W_EPOOXE_SAE_NUS_MBBL.W"
            """U.S. Ending Stocks of Fuel Ethanol in Thousand Barrels (Mbbl)"""

            WeeklyBlenderNetProductionOfDistillateFuelOil: str = "PET.W_EPD0_YPB_NUS_MBBLD.W"
            """U.S. Blender Net Production of Distillate Fuel Oil in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyRefinerNetProductionOfDistillateFuelOil: str = "PET.W_EPD0_YPY_NUS_MBBLD.W"
            """U.S. Refiner Net Production of Distillate Fuel Oil in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyBlenderNetProductionOfKeroseneTypeJetFuel: str = "PET.W_EPJK_YPB_NUS_MBBLD.W"
            """U.S. Blender Net Production of Kerosene-Type Jet Fuel in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyRefinerNetProductionOfKeroseneTypeJetFuel: str = "PET.W_EPJK_YPY_NUS_MBBLD.W"
            """U.S. Refiner Net Production of Kerosene-Type Jet Fuel in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyPropaneResidentialPrice: str = "PET.W_EPLLPA_PRS_NUS_DPG.W"
            """U.S. Propane Residential Price in Dollars per Gallon ($/gal)"""

            WeeklyPropaneWholesaleResalePrice: str = "PET.W_EPLLPA_PWR_NUS_DPG.W"
            """U.S. Propane Wholesale/Resale Price in Dollars per Gallon ($/gal)"""

            WeeklyRefinerAndBlenderNetInputOfMotorGasolineBlendingComponentsRbob: str = "PET.W_EPOBGRR_YIR_NUS_MBBLD.W"
            """U.S. Refiner and Blender Net Input of Motor Gasoline Blending Components, RBOB in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyEndingStocksOfNgplsLrgsExcludingPropanePropylene: str = "PET.W_EPL0XP_SAE_NUS_MBBL.W"
            """U.S. Ending Stocks of NGPLs/LRGs (Excluding Propane/Propylene) in Thousand Barrels (Mbbl)"""

            WeeklyDaysOfSupplyOfPropanePropylene: str = "PET.W_EPLLPZ_VSD_NUS_DAYS.W"
            """U.S. Days of Supply of Propane/Propylene in Number of Days (Days)"""

            WeeklyBlenderNetProductionOfConventionalMotorGasoline: str = "PET.W_EPM0C_YPB_NUS_MBBLD.W"
            """U.S. Blender Net Production of Conventional Motor Gasoline in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyRefinerNetProductionOfConventionalMotorGasoline: str = "PET.W_EPM0C_YPY_NUS_MBBLD.W"
            """U.S. Refiner Net Production of Conventional Motor Gasoline in Thousand Barrels per Day (Mbbl/d)"""

            WeeklySupplyAdjustmentOfFinishedMotorGasoline: str = "PET.W_EPM0F_VUA_NUS_MBBLD.W"
            """U.S. Supply Adjustment of Finished Motor Gasoline in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyBlenderNetProductionOfFinishedMotorGasoline: str = "PET.W_EPM0F_YPB_NUS_MBBLD.W"
            """U.S. Blender Net Production of Finished Motor Gasoline in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyRefinerAndBlenderNetProductionOfFinishedMotorGasoline: str = "PET.W_EPM0F_YPR_NUS_MBBLD.W"
            """U.S. Refiner and Blender Net Production of Finished Motor Gasoline in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyRefinerNetProductionOfFinishedMotorGasoline: str = "PET.W_EPM0F_YPY_NUS_MBBLD.W"
            """U.S. Refiner Net Production of Finished Motor Gasoline in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyBlenderNetProductionOfDistillateFuelOilGreaterThan500PpmSulfur: str = "PET.W_EPD00H_YPB_NUS_MBBLD.W"
            """U.S. Blender Net Production of Distillate Fuel Oil, Greater Than 500 ppm Sulfur in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyRefinerNetProductionOfDistillateFuelOilGreaterThan500PpmSulfur: str = "PET.W_EPD00H_YPY_NUS_MBBLD.W"
            """U.S. Refiner Net Production of Distillate Fuel Oil, Greater Than 500 ppm Sulfur in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyBlenderNetProductionOfDistillateFuelOilGreaterThan15To500PpmSulfur: str = "PET.W_EPDM10_YPB_NUS_MBBLD.W"
            """U.S. Blender Net Production of Distillate Fuel Oil, Greater than 15 to 500 ppm Sulfur in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyRefinerNetProductionOfDistillateFuelOilGreaterThan15To500PpmSulfur: str = "PET.W_EPDM10_YPY_NUS_MBBLD.W"
            """U.S. Refiner Net Production of Distillate Fuel Oil, Greater than 15 to 500 ppm Sulfur in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyBlenderNetProductionOfDistillateFuelOil0To15PpmSulfur: str = "PET.W_EPDXL0_YPB_NUS_MBBLD.W"
            """U.S. Blender Net Production of Distillate Fuel Oil, 0 to 15 ppm Sulfur in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyRefinerNetProductionOfDistillateFuelOil0To15PpmSulfur: str = "PET.W_EPDXL0_YPY_NUS_MBBLD.W"
            """U.S. Refiner Net Production of Distillate Fuel Oil, 0 to 15 ppm Sulfur in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyBlenderNetProductionOfConventionalMotorGasolineWithFuelEthanol: str = "PET.W_EPM0CA_YPB_NUS_MBBLD.W"
            """U.S. Blender Net Production of Conventional Motor Gasoline with Fuel Ethanol in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyRefinerNetProductionOfConventionalMotorGasolineWithFuelEthanol: str = "PET.W_EPM0CA_YPY_NUS_MBBLD.W"
            """U.S. Refiner Net Production of Conventional Motor Gasoline with Fuel Ethanol in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyBlenderNetProductionOfOtherConventionalMotorGasoline: str = "PET.W_EPM0CO_YPB_NUS_MBBLD.W"
            """U.S. Blender Net Production of Other Conventional Motor Gasoline in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyRefinerNetProductionOfOtherConventionalMotorGasoline: str = "PET.W_EPM0CO_YPY_NUS_MBBLD.W"
            """U.S. Refiner Net Production of Other Conventional Motor Gasoline in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyBlenderNetProductionOfReformulatedMotorGasolineWithFuelAlcohol: str = "PET.W_EPM0RA_YPB_NUS_MBBLD.W"
            """U.S. Blender Net Production of Reformulated Motor Gasoline with Fuel ALcohol in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyRefinerNetProductionOfReformulatedMotorGasolineWithFuelAlcohol: str = "PET.W_EPM0RA_YPY_NUS_MBBLD.W"
            """U.S. Refiner Net Production of Reformulated Motor Gasoline with Fuel ALcohol in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyOxygenatePlantProductionOfFuelEthanol: str = "PET.W_EPOOXE_YOP_NUS_MBBLD.W"
            """U.S. Oxygenate Plant Production of Fuel Ethanol in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyBlenderNetProductionOfMotorGasolineFinishedConventionalEd55AndLower: str = "PET.W_EPM0CAL55_YPB_NUS_MBBLD.W"
            """U.S. Blender Net Production of Motor Gasoline, Finished, Conventional, Ed55 and Lower in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyRefinerAndBlenderNetProductionOfFinishedConventionalMotorGasolineEd55AndLower: str = "PET.W_EPM0CAL55_YPT_NUS_MBBLD.W"
            """U.S. Refiner and Blender Net Production of Finished Conventional Motor Gasoline, Ed 55 and Lower in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyRefinerNetProductionOfMotorGasolineFinishedConventionalEd55AndLower: str = "PET.W_EPM0CAL55_YPY_NUS_MBBLD.W"
            """U.S. Refiner Net Production of Motor Gasoline, Finished, Conventional, Ed55 and Lower in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyExportsOfFinishedMotorGasoline: str = "PET.W_EPM0F_EEX_NUS-Z00_MBBLD.W"
            """U.S. Exports of Finished Motor Gasoline in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyImportsOfFinishedMotorGasoline: str = "PET.W_EPM0F_IM0_NUS-Z00_MBBLD.W"
            """U.S. Imports of Finished Motor Gasoline in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyBlenderNetProductionOfOtherReformulatedMotorGasoline: str = "PET.W_EPM0RO_YPB_NUS_MBBLD.W"
            """U.S. Blender Net Production of Other Reformulated Motor Gasoline in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyRefinerAndBlenderNetProductionOfOtherFinishedReformulatedMotorGasoline: str = "PET.W_EPM0RO_YPT_NUS_MBBLD.W"
            """U.S. Refiner and Blender Net Production of Other Finished Reformulated Motor Gasoline in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyRefinerNetProductionOfOtherReformulatedMotorGasoline: str = "PET.W_EPM0RO_YPY_NUS_MBBLD.W"
            """U.S. Refiner Net Production of Other Reformulated Motor Gasoline in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyEndingStocksOfMotorGasolineBlendingComponentsRbob: str = "PET.W_EPOBGRR_SAE_NUS_MBBL.W"
            """U.S. Ending Stocks of Motor Gasoline Blending Components, RBOB in Thousand Barrels (Mbbl)"""

            WeeklyRefinerAndBlenderNetInputOfFuelEthanol: str = "PET.W_EPOOXE_YIR_NUS_MBBLD.W"
            """U.S. Refiner and Blender Net Input of Fuel Ethanol in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyImportsOfMotorGasolineFinishedConventionalGreaterThanEd55: str = "PET.W_EPM0CAG55_IM0_NUS-Z00_MBBLD.W"
            """U.S. Imports of Motor Gasoline, Finished, Conventional, Greater than Ed55 in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyImportsOfMotorGasolineFinishedConventionalEd55AndLower: str = "PET.W_EPM0CAL55_IM0_NUS-Z00_MBBLD.W"
            """U.S. Imports of Motor Gasoline, Finished, Conventional, Ed55 and Lower in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyCrudeOilImportsForSprByOthers: str = "PET.W_EPC0_IMU_NUS-Z00_MBBLD.W"
            """U.S. Crude Oil Imports for SPR by Others in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyEndingStocksOfConventionalMotorGasolineGreaterThanEd55: str = "PET.W_EPM0CAG55_SAE_NUS_MBBL.W"
            """U.S. Ending Stocks of Conventional Motor Gasoline, Greater than Ed55 in Thousand Barrels (Mbbl)"""

            WeeklyImportsOfFuelEthanol: str = "PET.W_EPOOXE_IM0_NUS-Z00_MBBLD.W"
            """U.S. Imports of Fuel Ethanol in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyImportsOfLiquefiedPetroleumGassesLessPropanePropylene: str = "PET.W_EPL0XP_IM0_NUS-Z00_MBBLD.W"
            """U.S. Imports of Liquefied Petroleum Gasses Less Propane/Propylene in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyExportsOfPropaneAndPropylene: str = "PET.W_EPLLPZ_EEX_NUS-Z00_MBBLD.W"
            """U.S. Exports of Propane and Propylene in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyImportsOfOtherReformulatedMotorGasoline: str = "PET.W_EPM0RO_IM0_NUS-Z00_MBBLD.W"
            """U.S. Imports of Other Reformulated Motor Gasoline in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyBlenderNetProductionOfMotorGasolineFinishedConventionalGreaterThanEd55: str = "PET.W_EPM0CAG55_YPB_NUS_MBBLD.W"
            """U.S. Blender Net Production of Motor Gasoline, Finished, Conventional, Greater Than Ed55 in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyRefinerAndBlenderNetProductionOfFinishedConventionalMotorGasolineGreaterThanEd55: str = "PET.W_EPM0CAG55_YPT_NUS_MBBLD.W"
            """U.S. Refiner and Blender Net Production of Finished Conventional Motor Gasoline, Greater than Ed 55 in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyRefinerNetProductionOfFinishedConventionalMotorGasolineGreaterThanEd55: str = "PET.W_EPM0CAG55_YPY_NUS_MBBLD.W"
            """U.S. Refiner Net Production of Finished Conventional Motor Gasoline, Greater than Ed 55 in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyEndingStocksOfConventionalMotorGasolineEd55AndLower: str = "PET.W_EPM0CAL55_SAE_NUS_MBBL.W"
            """U.S. Ending Stocks of Conventional Motor Gasoline, Ed55 and Lower in Thousand Barrels (Mbbl)"""

            WeeklyImportsOfKerosene: str = "PET.W_EPPK_IM0_NUS-Z00_MBBLD.W"
            """U.S. Imports of Kerosene in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyExportsOfOtherOils: str = "PET.W_EPPO4_EEX_NUS-Z00_MBBLD.W"
            """U.S. Exports of Other Oils in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyImportsOfOtherOilsExcludingFuelEthanol: str = "PET.W_EPPO6_IM0_NUS-Z00_MBBLD.W"
            """U.S. Imports of Other Oils (Excluding Fuel Ethanol) in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyImportsFromAllCountriesOfMotorGasolineBlendingComponentsRbob: str = "PET.W_EPOBGRR_IM0_NUS-Z00_MBBLD.W"
            """U.S. Imports from  All Countries of Motor Gasoline Blending Components, RBOB in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyRegularAllFormulationsRetailGasolinePrices: str = "PET.EMM_EPMR_PTE_NUS_DPG.W"
            """U.S. Regular All Formulations Retail Gasoline Prices in Dollars per Gallon ($/gal)"""

            WeeklyMidgradeAllFormulationsRetailGasolinePrices: str = "PET.EMM_EPMM_PTE_NUS_DPG.W"
            """U.S. Midgrade All Formulations Retail Gasoline Prices in Dollars per Gallon ($/gal)"""

            WeeklyPremiumAllFormulationsRetailGasolinePrices: str = "PET.EMM_EPMP_PTE_NUS_DPG.W"
            """U.S. Premium All Formulations Retail Gasoline Prices in Dollars per Gallon ($/gal)"""

            WeeklyAllGradesAllFormulationsRetailGasolinePrices: str = "PET.EMM_EPM0_PTE_NUS_DPG.W"
            """U.S. All Grades All Formulations Retail Gasoline Prices in Dollars per Gallon ($/gal)"""

            WeeklyAllGradesReformulatedRetailGasolinePrices: str = "PET.EMM_EPM0R_PTE_NUS_DPG.W"
            """U.S. All Grades Reformulated Retail Gasoline Prices in Dollars per Gallon ($/gal)"""

            WeeklyMidgradeReformulatedRetailGasolinePrices: str = "PET.EMM_EPMMR_PTE_NUS_DPG.W"
            """U.S. Midgrade Reformulated Retail Gasoline Prices in Dollars per Gallon ($/gal)"""

            WeeklyPremiumReformulatedRetailGasolinePrices: str = "PET.EMM_EPMPR_PTE_NUS_DPG.W"
            """U.S. Premium Reformulated Retail Gasoline Prices in Dollars per Gallon ($/gal)"""

            WeeklyRegularConventionalRetailGasolinePrices: str = "PET.EMM_EPMRU_PTE_NUS_DPG.W"
            """U.S. Regular Conventional Retail Gasoline Prices in Dollars per Gallon ($/gal)"""

            WeeklyRegularReformulatedRetailGasolinePrices: str = "PET.EMM_EPMRR_PTE_NUS_DPG.W"
            """U.S. Regular Reformulated Retail Gasoline Prices in Dollars per Gallon ($/gal)"""

            WeeklyNo2DieselRetailPrices: str = "PET.EMD_EPD2D_PTE_NUS_DPG.W"
            """U.S. No 2 Diesel Retail Prices in Dollars per Gallon ($/gal)"""

            WeeklyPremiumConventionalRetailGasolinePrices: str = "PET.EMM_EPMPU_PTE_NUS_DPG.W"
            """U.S. Premium Conventional Retail Gasoline Prices in Dollars per Gallon ($/gal)"""

            WeeklyMidgradeConventionalRetailGasolinePrices: str = "PET.EMM_EPMMU_PTE_NUS_DPG.W"
            """U.S. Midgrade Conventional Retail Gasoline Prices in Dollars per Gallon ($/gal)"""

            WeeklyAllGradesConventionalRetailGasolinePrices: str = "PET.EMM_EPM0U_PTE_NUS_DPG.W"
            """U.S. All Grades Conventional Retail Gasoline Prices in Dollars per Gallon ($/gal)"""

            WeeklyNo2DieselUltraLowSulfur015PpmRetailPrices: str = "PET.EMD_EPD2DXL0_PTE_NUS_DPG.W"
            """U.S. No 2 Diesel Ultra Low Sulfur (0-15 ppm) Retail Prices in Dollars per Gallon ($/gal)"""

            WeeklyEndingStocksExcludingSprAndIncludingLeaseStockOfCrudeOil: str = "PET.W_EPC0_SAX_NUS_MBBL.W"
            """U.S. Ending Stocks excluding SPR and including Lease Stock of Crude Oil in Thousand Barrels (Mbbl)"""

            WeeklyNo2DieselLowSulfur15500PpmRetailPrices: str = "PET.EMD_EPD2DM10_PTE_NUS_DPG.W"
            """U.S. No 2 Diesel Low Sulfur (15-500 ppm) Retail Prices in Dollars per Gallon ($/gal)"""

            WeeklyImportsOfReformulatedRbobWithAlcoholGasolineBlendingComponents: str = "PET.WO3IM_NUS-Z00_2.W"
            """U.S. Imports of Reformulated RBOB with Alcohol Gasoline Blending Components in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyImportsOfReformulatedRbobWithEtherGasolineBlendingComponents: str = "PET.WO4IM_NUS-Z00_2.W"
            """U.S. Imports of Reformulated RBOB with Ether Gasoline Blending Components in Thousand Barrels per Day (Mbbl/d)"""

            WeeklyEndingStocksOfReformulatedGtabGasolineBlendingComponents: str = "PET.WO2ST_NUS_1.W"
            """U.S. Ending Stocks of Reformulated GTAB Gasoline Blending Components in Thousand Barrels (Mbbl)"""

            WeeklyEndingStocksOfReformulatedRbobWithAlcoholGasolineBlendingComponents: str = "PET.WO3ST_NUS_1.W"
            """U.S. Ending Stocks of Reformulated RBOB with Alcohol Gasoline Blending Components in Thousand Barrels (Mbbl)"""

            WeeklyEndingStocksOfReformulatedRbobWithEtherGasolineBlendingComponents: str = "PET.WO4ST_NUS_1.W"
            """U.S. Ending Stocks of Reformulated RBOB with Ether Gasoline Blending Components in Thousand Barrels (Mbbl)"""

        class EquatorialGuinea(System.Object):
            """Equatorial Guinea"""

            WeeklyImportsFromEquatorialGuineaOfCrudeOil: str = "PET.W_EPC0_IM0_NUS-NEK_MBBLD.W"
            """U.S. Imports from Equatorial Guinea of Crude Oil in Thousand Barrels per Day (Mbbl/d)"""

        class Iraq(System.Object):
            """Iraq"""

            WeeklyImportsFromIraqOfCrudeOil: str = "PET.W_EPC0_IM0_NUS-NIZ_MBBLD.W"
            """U.S. Imports from Iraq of Crude Oil in Thousand Barrels per Day (Mbbl/d)"""

        class Kuwait(System.Object):
            """Kuwait"""

            WeeklyImportsFromKuwaitOfCrudeOil: str = "PET.W_EPC0_IM0_NUS-NKU_MBBLD.W"
            """U.S. Imports from Kuwait of Crude Oil in Thousand Barrels per Day (Mbbl/d)"""

        class Mexico(System.Object):
            """Mexico"""

            WeeklyImportsFromMexicoOfCrudeOil: str = "PET.W_EPC0_IM0_NUS-NMX_MBBLD.W"
            """U.S. Imports from Mexico of Crude Oil in Thousand Barrels per Day (Mbbl/d)"""

        class Nigeria(System.Object):
            """Nigeria"""

            WeeklyImportsFromNigeriaOfCrudeOil: str = "PET.W_EPC0_IM0_NUS-NNI_MBBLD.W"
            """U.S. Imports from Nigeria of Crude Oil in Thousand Barrels per Day (Mbbl/d)"""

        class Norway(System.Object):
            """Norway"""

            WeeklyImportsFromNorwayOfCrudeOil: str = "PET.W_EPC0_IM0_NUS-NNO_MBBLD.W"
            """U.S. Imports from Norway of Crude Oil in Thousand Barrels per Day (Mbbl/d)"""

        class Russia(System.Object):
            """Russia"""

            WeeklyImportsFromRussiaOfCrudeOil: str = "PET.W_EPC0_IM0_NUS-NRS_MBBLD.W"
            """U.S. Imports from Russia of Crude Oil in Thousand Barrels per Day (Mbbl/d)"""

        class SaudiArabia(System.Object):
            """Saudi Arabia"""

            WeeklyImportsFromSaudiArabiaOfCrudeOil: str = "PET.W_EPC0_IM0_NUS-NSA_MBBLD.W"
            """U.S. Imports from Saudi Arabia of Crude Oil in Thousand Barrels per Day (Mbbl/d)"""

        class UnitedKingdom(System.Object):
            """United Kingdom"""

            WeeklyImportsFromUnitedKingdomOfCrudeOil: str = "PET.W_EPC0_IM0_NUS-NUK_MBBLD.W"
            """U.S. Imports from United Kingdom of Crude Oil in Thousand Barrels per Day (Mbbl/d)"""

        class Venezuela(System.Object):
            """Venezuela"""

            WeeklyImportsFromVenezuelaOfCrudeOil: str = "PET.W_EPC0_IM0_NUS-NVE_MBBLD.W"
            """U.S. Imports from Venezuela of Crude Oil in Thousand Barrels per Day (Mbbl/d)"""

        class Algeria(System.Object):
            """Algeria"""

            WeeklyImportsFromAlgeriaOfCrudeOil: str = "PET.W_EPC0_IM0_NUS-NAG_MBBLD.W"
            """U.S. Imports from Algeria of Crude Oil in Thousand Barrels per Day (Mbbl/d)"""

        class Angola(System.Object):
            """Angola"""

            WeeklyImportsFromAngolaOfCrudeOil: str = "PET.W_EPC0_IM0_NUS-NAO_MBBLD.W"
            """U.S. Imports from Angola of Crude Oil in Thousand Barrels per Day (Mbbl/d)"""

        class Brazil(System.Object):
            """Brazil"""

            WeeklyImportsFromBrazilOfCrudeOil: str = "PET.W_EPC0_IM0_NUS-NBR_MBBLD.W"
            """U.S. Imports from Brazil of Crude Oil in Thousand Barrels per Day (Mbbl/d)"""

        class Canada(System.Object):
            """Canada"""

            WeeklyImportsFromCanadaOfCrudeOil: str = "PET.W_EPC0_IM0_NUS-NCA_MBBLD.W"
            """U.S. Imports from Canada of Crude Oil in Thousand Barrels per Day (Mbbl/d)"""

        class Congo(System.Object):
            """Congo"""

            WeeklyImportsFromCongoBrazzavilleOfCrudeOil: str = "PET.W_EPC0_IM0_NUS-NCF_MBBLD.W"
            """U.S. Imports from Congo (Brazzaville) of Crude Oil in Thousand Barrels per Day (Mbbl/d)"""

        class Colombia(System.Object):
            """Colombia"""

            WeeklyImportsFromColombiaOfCrudeOil: str = "PET.W_EPC0_IM0_NUS-NCO_MBBLD.W"
            """U.S. Imports from Colombia of Crude Oil in Thousand Barrels per Day (Mbbl/d)"""

        class Ecuador(System.Object):
            """Ecuador"""

            WeeklyImportsFromEcuadorOfCrudeOil: str = "PET.W_EPC0_IM0_NUS-NEC_MBBLD.W"
            """U.S. Imports from Ecuador of Crude Oil in Thousand Barrels per Day (Mbbl/d)"""

    DataSourceId: int
    """Data source ID"""

    def Clone(self) -> QuantConnect.Data.BaseData:
        """
        Clones the data
        
        :returns: A clone of the object.
        """
        ...

    def DefaultResolution(self) -> int:
        """
        Gets the default resolution for this data and security type
        
        :returns: This method returns the int value of a member of the QuantConnect.Resolution enum.
        """
        ...

    def GetSource(self, config: QuantConnect.Data.SubscriptionDataConfig, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.SubscriptionDataSource:
        """
        Determines the location of the data
        
        :param config: Subscription configuration
        :param date: Date
        :param isLiveMode: Is live mode
        :returns: Location of the data as a SubscriptionDataSource.
        """
        ...

    def IsSparseData(self) -> bool:
        """
        Indicates whether the data is sparse.
        If true, we disable logging for missing files
        
        :returns: true.
        """
        ...

    def Reader(self, config: QuantConnect.Data.SubscriptionDataConfig, line: str, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.BaseData:
        """
        Parses the data from the line provided and loads it into LEAN
        
        :param config: Subscription configuration
        :param line: Line of data
        :param date: Date
        :param isLiveMode: Is live mode
        :returns: New instance of USEnergy.
        """
        ...

    def RequiresMapping(self) -> bool:
        """
        Indicates whether the data source is tied
        to an underlying symbol and requires that corporate
        events be applied to it as well, such as renames and delistings
        
        :returns: false.
        """
        ...

    def SupportedResolutions(self) -> System.Collections.Generic.List[QuantConnect.Resolution]:
        """Gets the supported resolution for this data and security type"""
        ...

    def ToString(self) -> str:
        """Converts the instance to string"""
        ...


class USTreasuryYieldCurveRate(QuantConnect.Data.BaseData):
    """U.S. Treasury yield curve data"""

    DataSourceId: int
    """Data source ID"""

    @property
    def OneMonth(self) -> typing.Optional[float]:
        """One month yield curve"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: typing.Optional[float]):
        """One month yield curve"""
        ...

    @property
    def TwoMonth(self) -> typing.Optional[float]:
        """Two month yield curve"""
        ...

    @TwoMonth.setter
    def TwoMonth(self, value: typing.Optional[float]):
        """Two month yield curve"""
        ...

    @property
    def ThreeMonth(self) -> typing.Optional[float]:
        """Three month yield curve"""
        ...

    @ThreeMonth.setter
    def ThreeMonth(self, value: typing.Optional[float]):
        """Three month yield curve"""
        ...

    @property
    def SixMonth(self) -> typing.Optional[float]:
        """Six month yield curve"""
        ...

    @SixMonth.setter
    def SixMonth(self, value: typing.Optional[float]):
        """Six month yield curve"""
        ...

    @property
    def OneYear(self) -> typing.Optional[float]:
        """One year yield curve"""
        ...

    @OneYear.setter
    def OneYear(self, value: typing.Optional[float]):
        """One year yield curve"""
        ...

    @property
    def TwoYear(self) -> typing.Optional[float]:
        """Two year yield curve"""
        ...

    @TwoYear.setter
    def TwoYear(self, value: typing.Optional[float]):
        """Two year yield curve"""
        ...

    @property
    def ThreeYear(self) -> typing.Optional[float]:
        """Three year yield curve"""
        ...

    @ThreeYear.setter
    def ThreeYear(self, value: typing.Optional[float]):
        """Three year yield curve"""
        ...

    @property
    def FiveYear(self) -> typing.Optional[float]:
        """Five year yield curve"""
        ...

    @FiveYear.setter
    def FiveYear(self, value: typing.Optional[float]):
        """Five year yield curve"""
        ...

    @property
    def SevenYear(self) -> typing.Optional[float]:
        """Seven year yield curve"""
        ...

    @SevenYear.setter
    def SevenYear(self, value: typing.Optional[float]):
        """Seven year yield curve"""
        ...

    @property
    def TenYear(self) -> typing.Optional[float]:
        """Ten year yield curve"""
        ...

    @TenYear.setter
    def TenYear(self, value: typing.Optional[float]):
        """Ten year yield curve"""
        ...

    @property
    def TwentyYear(self) -> typing.Optional[float]:
        """Twenty year yield curve"""
        ...

    @TwentyYear.setter
    def TwentyYear(self, value: typing.Optional[float]):
        """Twenty year yield curve"""
        ...

    @property
    def ThirtyYear(self) -> typing.Optional[float]:
        """Thirty year yield curve"""
        ...

    @ThirtyYear.setter
    def ThirtyYear(self, value: typing.Optional[float]):
        """Thirty year yield curve"""
        ...

    def Clone(self) -> QuantConnect.Data.BaseData:
        """
        Clones the object. This method implementation is required
        so that we don't have any null values for our properties
        when the user attempts to use it in backtesting/live trading
        
        :returns: Cloned instance.
        """
        ...

    def DefaultResolution(self) -> int:
        """
        Gets the default resolution for this data and security type
        
        :returns: This method returns the int value of a member of the QuantConnect.Resolution enum.
        """
        ...

    def GetSource(self, config: QuantConnect.Data.SubscriptionDataConfig, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.SubscriptionDataSource:
        """
        Specifies the location of the data and directs LEAN where to load the data from
        
        :param config: Subscription configuration
        :param date: Algorithm date
        :param isLiveMode: Is live mode
        :returns: Subscription data source object pointing LEAN to the data location.
        """
        ...

    def Reader(self, config: QuantConnect.Data.SubscriptionDataConfig, line: str, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.BaseData:
        """
        Reads and parses yield curve data from a csv file
        
        :param config: Subscription configuration
        :param line: CSV line containing yield curve data
        :param date: Date request was made for
        :param isLiveMode: Is live mode
        :returns: YieldCurve instance.
        """
        ...

    def SupportedResolutions(self) -> System.Collections.Generic.List[QuantConnect.Resolution]:
        """Gets the supported resolution for this data and security type"""
        ...


class CBOE(QuantConnect.Data.Market.TradeBar):
    """CBOE data source"""

    DataSourceId: int
    """Data source ID"""

    def __init__(self) -> None:
        """Creates a new instance of the object"""
        ...

    def DefaultResolution(self) -> int:
        """
        Gets the default resolution for this data and security type
        
        :returns: This method returns the int value of a member of the QuantConnect.Resolution enum.
        """
        ...

    def GetSource(self, config: QuantConnect.Data.SubscriptionDataConfig, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.SubscriptionDataSource:
        """Gets the source location of the CBOE file"""
        ...

    def IsSparseData(self) -> bool:
        """
        Determines if data source is sparse
        
        :returns: false.
        """
        ...

    def Reader(self, config: QuantConnect.Data.SubscriptionDataConfig, line: str, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.BaseData:
        """
        Reads the data from the source and creates a BaseData instance
        
        :param config: Configuration
        :param line: Line of data
        :param date: Date we're requesting data for
        :param isLiveMode: Is live mode
        :returns: New BaseData instance to be used in the algorithm.
        """
        ...

    def RequiresMapping(self) -> bool:
        """
        Determines whether the data source requires mapping
        
        :returns: false.
        """
        ...

    def SupportedResolutions(self) -> System.Collections.Generic.List[QuantConnect.Resolution]:
        """Gets the supported resolution for this data and security type"""
        ...

    def ToString(self) -> str:
        """
        Converts the instance to a string
        
        :returns: String containing open, high, low, close.
        """
        ...


class QuiverCongressDataPoint(QuantConnect.Data.BaseData):
    """Single data point for QuiverCongress data"""

    DataSourceId: int
    """Data source ID"""

    @property
    def ReportDate(self) -> typing.Optional[datetime.datetime]:
        """The date the transaction was reported. Value will always exist."""
        ...

    @ReportDate.setter
    def ReportDate(self, value: typing.Optional[datetime.datetime]):
        """The date the transaction was reported. Value will always exist."""
        ...

    @property
    def TransactionDate(self) -> datetime.datetime:
        """The date the transaction took place"""
        ...

    @TransactionDate.setter
    def TransactionDate(self, value: datetime.datetime):
        """The date the transaction took place"""
        ...

    @property
    def Representative(self) -> str:
        """The Representative making the transaction"""
        ...

    @Representative.setter
    def Representative(self, value: str):
        """The Representative making the transaction"""
        ...

    @property
    def Transaction(self) -> int:
        """
        The type of transaction
        
        This property contains the int value of a member of the QuantConnect.Orders.OrderDirection enum.
        """
        ...

    @Transaction.setter
    def Transaction(self, value: int):
        """
        The type of transaction
        
        This property contains the int value of a member of the QuantConnect.Orders.OrderDirection enum.
        """
        ...

    @property
    def Amount(self) -> typing.Optional[float]:
        """The amount of the transaction (in USD)"""
        ...

    @Amount.setter
    def Amount(self, value: typing.Optional[float]):
        """The amount of the transaction (in USD)"""
        ...

    @property
    def House(self) -> int:
        """
        The House of Congress that the trader belongs to
        
        This property contains the int value of a member of the QuantConnect.DataSource.Congress enum.
        """
        ...

    @House.setter
    def House(self, value: int):
        """
        The House of Congress that the trader belongs to
        
        This property contains the int value of a member of the QuantConnect.DataSource.Congress enum.
        """
        ...

    @property
    def EndTime(self) -> datetime.datetime:
        """The time the data point ends at and becomes available to the algorithm"""
        ...

    @EndTime.setter
    def EndTime(self, value: datetime.datetime):
        """The time the data point ends at and becomes available to the algorithm"""
        ...

    @overload
    def __init__(self) -> None:
        """Creates a new instance of QuiverCongressDataPoint"""
        ...

    @overload
    def __init__(self, csvLine: str) -> None:
        """
        Creates a new instance of QuiverCongressDataPoint from a CSV line
        
        :param csvLine: CSV line
        """
        ...

    def Clone(self) -> QuantConnect.Data.BaseData:
        """
        Clones the data
        
        :returns: A clone of the object.
        """
        ...

    def DataTimeZone(self) -> typing.Any:
        """
        Specifies the data time zone for this data type. This is useful for custom data types
        
        :returns: The DateTimeZone of this data type.
        """
        ...

    def Reader(self, config: QuantConnect.Data.SubscriptionDataConfig, line: str, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.BaseData:
        """
        Reader converts each line of the data source into BaseData objects.
        
        :param config: Subscription data config setup object
        :param line: Content of the source document
        :param date: Date of the requested data
        :param isLiveMode: true if we're in live mode, false for backtesting mode
        :returns: Quiver Congress object.
        """
        ...

    def RequiresMapping(self) -> bool:
        """
        Indicates if there is support for mapping
        
        :returns: True indicates mapping should be used.
        """
        ...

    def ToString(self) -> str:
        """Formats a string with the Quiver Congress information."""
        ...


class TransactionDirectionJsonConverter(QuantConnect.Util.TypeChangeJsonConverter[QuantConnect.Orders.OrderDirection, str]):
    """Converts Quiver Quantitative TransactionDirection to OrderDirection"""

    @overload
    def Convert(self, value: QuantConnect.Orders.OrderDirection) -> str:
        """
        Convert OrderDirection to string
        
        This method is protected.
        
        :param value: OrderDirection to convert
        :returns: Resulting string.
        """
        ...

    @overload
    def Convert(self, value: str) -> int:
        """
        Convert string to OrderDirection
        
        This method is protected.
        
        :param value: string to convert
        :returns: Resulting OrderDirection. This method returns the int value of a member of the QuantConnect.Orders.OrderDirection enum.
        """
        ...


class QuiverCongress(QuantConnect.Data.UniverseSelection.BaseDataCollection):
    """Personal stock transactions by U.S. Representatives"""

    def Clone(self) -> QuantConnect.Data.BaseData:
        """
        Clones the data
        
        :returns: A clone of the object.
        """
        ...

    def DataTimeZone(self) -> typing.Any:
        """
        Specifies the data time zone for this data type. This is useful for custom data types
        
        :returns: The NodaTime.DateTimeZone of this data type.
        """
        ...

    def DefaultResolution(self) -> int:
        """
        Gets the default resolution for this data and security type
        
        :returns: This method returns the int value of a member of the QuantConnect.Resolution enum.
        """
        ...

    def GetSource(self, config: QuantConnect.Data.SubscriptionDataConfig, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.SubscriptionDataSource:
        """
        Return the Subscription Data Source gained from the URL
        
        :param config: Configuration object
        :param date: Date of this source file
        :param isLiveMode: true if we're in live mode, false for backtesting mode
        :returns: Subscription Data Source.
        """
        ...

    def IsSparseData(self) -> bool:
        """
        Indicates that the data set is expected to be sparse
        
        :returns: True if the data set represented by this type is expected to be sparse.
        """
        ...

    def Reader(self, config: QuantConnect.Data.SubscriptionDataConfig, line: str, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.BaseData:
        """
        Reader converts each line of the data source into BaseData objects. Each data type creates its own factory method, and returns a new instance of the object
        each time it is called. The returned object is assumed to be time stamped in the config.ExchangeTimeZone.
        
        :param config: Subscription data config setup object
        :param line: Line of the source document
        :param date: Date of the requested data
        :param isLiveMode: true if we're in live mode, false for backtesting mode
        :returns: Instance of the T:BaseData object generated by this line of the CSV.
        """
        ...

    def RequiresMapping(self) -> bool:
        """
        Indicates if there is support for mapping
        
        :returns: True indicates mapping should be used.
        """
        ...

    def SupportedResolutions(self) -> System.Collections.Generic.List[QuantConnect.Resolution]:
        """Gets the supported resolution for this data and security type"""
        ...

    def ToString(self) -> str:
        """
        Formats a string with the Quiver Congress information.
        
        :returns: string containing Quiver Congress information.
        """
        ...


class Congress(System.Enum):
    """United States of America Legislative Branch House of Congress"""

    Senate = 0
    """The United States Senate"""

    Representatives = 1
    """The United States House of Representatives"""


class QuiverQuantCongressUniverse(QuantConnect.Data.BaseData):
    """Universe Selection helper class for QuiverQuant Congress dataset"""

    @property
    def ReportDate(self) -> datetime.datetime:
        """ReportDate"""
        ...

    @property
    def TransactionDate(self) -> datetime.datetime:
        """TransactionDate"""
        ...

    @TransactionDate.setter
    def TransactionDate(self, value: datetime.datetime):
        """TransactionDate"""
        ...

    @property
    def Representative(self) -> str:
        """Representative"""
        ...

    @Representative.setter
    def Representative(self, value: str):
        """Representative"""
        ...

    @property
    def Transaction(self) -> int:
        """
        Month-over-month change in company's follower count
        
        This property contains the int value of a member of the QuantConnect.Orders.OrderDirection enum.
        """
        ...

    @Transaction.setter
    def Transaction(self, value: int):
        """
        Month-over-month change in company's follower count
        
        This property contains the int value of a member of the QuantConnect.Orders.OrderDirection enum.
        """
        ...

    @property
    def Amount(self) -> typing.Optional[float]:
        """The amount of the transaction (in USD)"""
        ...

    @Amount.setter
    def Amount(self, value: typing.Optional[float]):
        """The amount of the transaction (in USD)"""
        ...

    @property
    def House(self) -> int:
        """
        The House of Congress that the trader belongs to
        
        This property contains the int value of a member of the QuantConnect.DataSource.Congress enum.
        """
        ...

    @House.setter
    def House(self, value: int):
        """
        The House of Congress that the trader belongs to
        
        This property contains the int value of a member of the QuantConnect.DataSource.Congress enum.
        """
        ...

    @property
    def EndTime(self) -> datetime.datetime:
        """Time the data became available"""
        ...

    @EndTime.setter
    def EndTime(self, value: datetime.datetime):
        """Time the data became available"""
        ...

    def DataTimeZone(self) -> typing.Any:
        """
        Specifies the data time zone for this data type. This is useful for custom data types
        
        :returns: The NodaTime.DateTimeZone of this data type.
        """
        ...

    def DefaultResolution(self) -> int:
        """
        Gets the default resolution for this data and security type
        
        :returns: This method returns the int value of a member of the QuantConnect.Resolution enum.
        """
        ...

    def GetSource(self, config: QuantConnect.Data.SubscriptionDataConfig, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.SubscriptionDataSource:
        """
        Return the URL string source of the file. This will be converted to a stream
        
        :param config: Configuration object
        :param date: Date of this source file
        :param isLiveMode: true if we're in live mode, false for backtesting mode
        :returns: String URL of source file.
        """
        ...

    def Reader(self, config: QuantConnect.Data.SubscriptionDataConfig, line: str, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.BaseData:
        """
        Parses the data from the line provided and loads it into LEAN
        
        :param config: Subscription configuration
        :param line: Line of data
        :param date: Date
        :param isLiveMode: Is live mode
        :returns: New instance.
        """
        ...

    def SupportedResolutions(self) -> System.Collections.Generic.List[QuantConnect.Resolution]:
        """Gets the supported resolution for this data and security type"""
        ...

    def ToString(self) -> str:
        """Converts the instance to string"""
        ...


class VIXCentralContango(QuantConnect.Data.BaseData):
    """VIXCentral Contango"""

    DataSourceId: int
    """Data source ID"""

    @property
    def FrontMonth(self) -> int:
        """The month of the front month contract (possible values: 1 - 12)"""
        ...

    @FrontMonth.setter
    def FrontMonth(self, value: int):
        """The month of the front month contract (possible values: 1 - 12)"""
        ...

    @property
    def F1(self) -> float:
        """Front month contract"""
        ...

    @F1.setter
    def F1(self, value: float):
        """Front month contract"""
        ...

    @property
    def F2(self) -> float:
        """Contract 1 month away from the front month contract"""
        ...

    @F2.setter
    def F2(self, value: float):
        """Contract 1 month away from the front month contract"""
        ...

    @property
    def F3(self) -> float:
        """Contract 2 months away from the front month contract"""
        ...

    @F3.setter
    def F3(self, value: float):
        """Contract 2 months away from the front month contract"""
        ...

    @property
    def F4(self) -> float:
        """Contract 3 months away from the front month contract"""
        ...

    @F4.setter
    def F4(self, value: float):
        """Contract 3 months away from the front month contract"""
        ...

    @property
    def F5(self) -> float:
        """Contract 4 months away from the front month contract"""
        ...

    @F5.setter
    def F5(self, value: float):
        """Contract 4 months away from the front month contract"""
        ...

    @property
    def F6(self) -> float:
        """Contract 5 months away from the front month contract"""
        ...

    @F6.setter
    def F6(self, value: float):
        """Contract 5 months away from the front month contract"""
        ...

    @property
    def F7(self) -> float:
        """Contract 6 months away from the front month contract"""
        ...

    @F7.setter
    def F7(self, value: float):
        """Contract 6 months away from the front month contract"""
        ...

    @property
    def F8(self) -> float:
        """Contract 7 months away from the front month contract"""
        ...

    @F8.setter
    def F8(self, value: float):
        """Contract 7 months away from the front month contract"""
        ...

    @property
    def F9(self) -> typing.Optional[float]:
        """Contract 8 months away from the front month contract"""
        ...

    @F9.setter
    def F9(self, value: typing.Optional[float]):
        """Contract 8 months away from the front month contract"""
        ...

    @property
    def F10(self) -> typing.Optional[float]:
        """Contract 9 months away from the front month contract"""
        ...

    @F10.setter
    def F10(self, value: typing.Optional[float]):
        """Contract 9 months away from the front month contract"""
        ...

    @property
    def F11(self) -> typing.Optional[float]:
        """Contract 10 months away from the front month contract"""
        ...

    @F11.setter
    def F11(self, value: typing.Optional[float]):
        """Contract 10 months away from the front month contract"""
        ...

    @property
    def F12(self) -> typing.Optional[float]:
        """Contract 11 months away from the front month contract"""
        ...

    @F12.setter
    def F12(self, value: typing.Optional[float]):
        """Contract 11 months away from the front month contract"""
        ...

    @property
    def Contango_F2_Minus_F1(self) -> float:
        """Percentage change between contract F2 and F1, calculated as: (F2 - F1) / F1"""
        ...

    @Contango_F2_Minus_F1.setter
    def Contango_F2_Minus_F1(self, value: float):
        """Percentage change between contract F2 and F1, calculated as: (F2 - F1) / F1"""
        ...

    @property
    def Contango_F7_Minus_F4(self) -> float:
        """Percentage change between contract F7 and F4, calculated as: (F7 - F4) / F4"""
        ...

    @Contango_F7_Minus_F4.setter
    def Contango_F7_Minus_F4(self, value: float):
        """Percentage change between contract F7 and F4, calculated as: (F7 - F4) / F4"""
        ...

    @property
    def Contango_F7_Minus_F4_Div_3(self) -> float:
        """Percentage change between contract F7 and F4 divided by 3, calculated as: ((F7 - F4) / F4) / 3"""
        ...

    @Contango_F7_Minus_F4_Div_3.setter
    def Contango_F7_Minus_F4_Div_3(self, value: float):
        """Percentage change between contract F7 and F4 divided by 3, calculated as: ((F7 - F4) / F4) / 3"""
        ...

    @property
    def Period(self) -> datetime.timedelta:
        """The timespan that each data point covers"""
        ...

    @Period.setter
    def Period(self, value: datetime.timedelta):
        """The timespan that each data point covers"""
        ...

    @property
    def EndTime(self) -> datetime.datetime:
        """The ending time of the data point"""
        ...

    @EndTime.setter
    def EndTime(self, value: datetime.datetime):
        """The ending time of the data point"""
        ...

    def __init__(self) -> None:
        """Creates a new instance of the object"""
        ...

    def DefaultResolution(self) -> int:
        """
        Gets the default resolution for this data and security type
        
        :returns: This method returns the int value of a member of the QuantConnect.Resolution enum.
        """
        ...

    def GetSource(self, config: QuantConnect.Data.SubscriptionDataConfig, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.SubscriptionDataSource:
        """Gets the source location of the VIXCentral data"""
        ...

    def IsSparseData(self) -> bool:
        """
        Determines if data source is sparse
        
        :returns: false.
        """
        ...

    def Reader(self, config: QuantConnect.Data.SubscriptionDataConfig, line: str, date: typing.Union[datetime.datetime, datetime.date], isLiveMode: bool) -> QuantConnect.Data.BaseData:
        """
        Reads the data from the source and creates a BaseData instance
        
        :param config: Configuration
        :param line: Line of data
        :param date: Date we're requesting data for
        :param isLiveMode: Is live mode
        :returns: New BaseData instance to be used in the algorithm.
        """
        ...

    def RequiresMapping(self) -> bool:
        """
        Determines whether the data source requires mapping
        
        :returns: false.
        """
        ...

    def SupportedResolutions(self) -> System.Collections.Generic.List[QuantConnect.Resolution]:
        """Gets the supported resolution for this data and security type"""
        ...

    def ToString(self) -> str:
        """
        Converts the instance to a string
        
        :returns: String containing open, high, low, close.
        """
        ...


class NullData(QuantConnect.Data.BaseData):
    """Represents a custom data type place holder"""


