# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.metric_definition_execution import MetricDefinitionExecution
from ...types.metric_definition_history_item import MetricDefinitionHistoryItem
from ...types.metric_definition_input import MetricDefinitionInput
from .raw_client import AsyncRawMetricDefinitionsClient, RawMetricDefinitionsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class MetricDefinitionsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawMetricDefinitionsClient(client_wrapper=client_wrapper)

    @property
    def _client_wrapper(self) -> SyncClientWrapper:
        return self._raw_client._client_wrapper

    @property
    def with_raw_response(self) -> RawMetricDefinitionsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawMetricDefinitionsClient
        """
        return self._raw_client

    def execute_metric_definition(
        self,
        id: str,
        *,
        inputs: typing.Sequence[MetricDefinitionInput],
        release_tag: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> MetricDefinitionExecution:
        """
        Parameters
        ----------
        id : str
            Either the Metric Definition's ID or its unique name

        inputs : typing.Sequence[MetricDefinitionInput]

        release_tag : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MetricDefinitionExecution


        Examples
        --------
        from vellum import StringInput, Vellum

        client = Vellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.metric_definitions.execute_metric_definition(
            id="id",
            inputs=[
                StringInput(
                    name="x",
                    value="value",
                ),
                StringInput(
                    name="x",
                    value="value",
                ),
            ],
        )
        """
        _response = self._raw_client.execute_metric_definition(
            id, inputs=inputs, release_tag=release_tag, request_options=request_options
        )
        return _response.data

    def metric_definition_history_item_retrieve(
        self, history_id_or_release_tag: str, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> MetricDefinitionHistoryItem:
        """
        Parameters
        ----------
        history_id_or_release_tag : str
            Either the UUID of Metric Definition History Item you'd like to retrieve, or the name of a Release Tag that's pointing to the Metric Definition History Item you'd like to retrieve.

        id : str
            A UUID string identifying this metric definition.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MetricDefinitionHistoryItem


        Examples
        --------
        from vellum import Vellum

        client = Vellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.metric_definitions.metric_definition_history_item_retrieve(
            history_id_or_release_tag="history_id_or_release_tag",
            id="id",
        )
        """
        _response = self._raw_client.metric_definition_history_item_retrieve(
            history_id_or_release_tag, id, request_options=request_options
        )
        return _response.data


class AsyncMetricDefinitionsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawMetricDefinitionsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawMetricDefinitionsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawMetricDefinitionsClient
        """
        return self._raw_client

    async def execute_metric_definition(
        self,
        id: str,
        *,
        inputs: typing.Sequence[MetricDefinitionInput],
        release_tag: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> MetricDefinitionExecution:
        """
        Parameters
        ----------
        id : str
            Either the Metric Definition's ID or its unique name

        inputs : typing.Sequence[MetricDefinitionInput]

        release_tag : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MetricDefinitionExecution


        Examples
        --------
        import asyncio

        from vellum import AsyncVellum, StringInput

        client = AsyncVellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.metric_definitions.execute_metric_definition(
                id="id",
                inputs=[
                    StringInput(
                        name="x",
                        value="value",
                    ),
                    StringInput(
                        name="x",
                        value="value",
                    ),
                ],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.execute_metric_definition(
            id, inputs=inputs, release_tag=release_tag, request_options=request_options
        )
        return _response.data

    async def metric_definition_history_item_retrieve(
        self, history_id_or_release_tag: str, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> MetricDefinitionHistoryItem:
        """
        Parameters
        ----------
        history_id_or_release_tag : str
            Either the UUID of Metric Definition History Item you'd like to retrieve, or the name of a Release Tag that's pointing to the Metric Definition History Item you'd like to retrieve.

        id : str
            A UUID string identifying this metric definition.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MetricDefinitionHistoryItem


        Examples
        --------
        import asyncio

        from vellum import AsyncVellum

        client = AsyncVellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.metric_definitions.metric_definition_history_item_retrieve(
                history_id_or_release_tag="history_id_or_release_tag",
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.metric_definition_history_item_retrieve(
            history_id_or_release_tag, id, request_options=request_options
        )
        return _response.data
