# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.http_response import AsyncHttpResponse, HttpResponse
from ...core.jsonable_encoder import jsonable_encoder
from ...core.pydantic_utilities import parse_obj_as
from ...core.request_options import RequestOptions
from ...types.workflow_execution_detail import WorkflowExecutionDetail


class RawWorkflowExecutionsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def retrieve_workflow_execution_detail(
        self,
        execution_id: str,
        *,
        prev_span_id: typing.Optional[str] = None,
        span_limit: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[WorkflowExecutionDetail]:
        """
        Parameters
        ----------
        execution_id : str

        prev_span_id : typing.Optional[str]
            Optional keyset cursor span_id to continue from (exclusive)

        span_limit : typing.Optional[int]
            Maximum number of spans to return (for lazy loading)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[WorkflowExecutionDetail]

        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/workflow-executions/{jsonable_encoder(execution_id)}/detail",
            base_url=self._client_wrapper.get_environment().default,
            method="GET",
            params={
                "prev_span_id": prev_span_id,
                "span_limit": span_limit,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    WorkflowExecutionDetail,
                    parse_obj_as(
                        type_=WorkflowExecutionDetail,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawWorkflowExecutionsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def retrieve_workflow_execution_detail(
        self,
        execution_id: str,
        *,
        prev_span_id: typing.Optional[str] = None,
        span_limit: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[WorkflowExecutionDetail]:
        """
        Parameters
        ----------
        execution_id : str

        prev_span_id : typing.Optional[str]
            Optional keyset cursor span_id to continue from (exclusive)

        span_limit : typing.Optional[int]
            Maximum number of spans to return (for lazy loading)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[WorkflowExecutionDetail]

        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/workflow-executions/{jsonable_encoder(execution_id)}/detail",
            base_url=self._client_wrapper.get_environment().default,
            method="GET",
            params={
                "prev_span_id": prev_span_id,
                "span_limit": span_limit,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    WorkflowExecutionDetail,
                    parse_obj_as(
                        type_=WorkflowExecutionDetail,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
