# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .vellum_document import VellumDocument


class ExecutionDocumentVellumValue(UniversalBaseModel):
    """
    A base Vellum primitive value representing a document.
    """

    id: str = pydantic.Field()
    """
    The variable's uniquely identifying internal id.
    """

    name: str
    type: typing.Literal["DOCUMENT"] = "DOCUMENT"
    value: typing.Optional[VellumDocument] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
