# NADF — 나무위키 PDF 보고서 생성기

### 개요
NADF는 나무위키 문서를 자동으로 크롤링하고,
섹션 구조를 유지한 PDF 보고서로 변환하는 파이썬 오픈소스 라이브러리입니다. <br>
이 프로젝트의 핵심 목적은 챗봇 학습을 위한 한국어 데이터 수집 및 검증입니다.<br>
한국어 데이터셋은 여전히 부족하고, 특히 최신성과 범용성을 동시에 확보하기 어렵습니다. <br>
NADF는 방대한 주제를 다루는 나무위키에서 문서를 가져와, 사람이 직접 읽으며 확인할 수 있는 형태의 PDF 보고서로 만들어줍니다.

즉, NADF는 단순한 PDF 변환기를 넘어서, <Strong>한국어 데이터 수집 위한 실용적 도구</Strong>를 목적으로 설계되었습니다.

### 프로젝트 배경 및 필요성
#### 한국어 데이터셋 부족 문제
영어권은 Common Crawl, Wikipedia, OpenWebText 등 다양한 대규모 공개 데이터셋이 존재합니다.
한국어 데이터셋은 제한적이고, 주로 뉴스/학술 중심으로 되어 있어 챗봇 학습에는 한계가 있습니다.
대화형 챗봇에는 실생활 언어, 대중문화, 최신 사건 같은 폭넓은 데이터가 필요합니다.

### 나무위키의 가치
최신성: 시사, 연예, 사건 등 실시간으로 갱신되는 자료
폭넓은 주제: 학문·문화·역사·인물·기술까지 다양한 영역을 포괄
구조화된 데이터: 목차 기반의 섹션 구조를 그대로 보존 가능
한국어 중심: 자연어 처리 및 챗봇 학습에 직접 활용하기 적합

### 보고서 형태의 필요성
데이터셋을 기계가 곧바로 학습하기 전에 사람이 직접 검증하는 단계가 반드시 필요합니다.
NADF는 이 과정을 지원하기 위해 “사람이 읽을 수 있는 PDF 보고서” 형태를 기본 출력물로 제공합니다.
다만 목적은 데이터 수집이므로, PDF는 화려한 디자인을 지향하지 않고 기본적인 가독성만 보장합니다.

### 아키텍처 개요
```bash
nadf/
 ├─ crawler/         # 크롤러 & HTTP/셀레니움 클라이언트
 ├─ decorator/       # URL 검증 등 데코레이터
 ├─ exception/       # 커스텀 예외
 ├─ fonts/           # 한글 폰트
 ├─ parser/          # BeautifulSoup 기반 파서
 └─ pdf/             # PDF 보고서 생성기 
```
### 동작 흐름
```bash
Crawler: URL을 입력받아 나무위키 문서를 크롤링
Parser: HTML → 텍스트 변환, 섹션별 분리
PDF Generator: fpdf2 기반으로 보고서 생성 (폰트 포함, 섹션 구조 반영)

출력: [문서명] 분석 보고서.pdf
```
### 설치
```bash
pip install nadf
```
> Python: 3.10 이상, 크롬 브라우저 설치 필요

### 사용 방법
#### 1. 파이썬 라이브러리로 사용
```python
import asyncio
from nadf.crawler import Crawler
from nadf.pdf import PDF

async def create_pdf(name : str):
    crawler = Crawler()
    name, data = await crawler.get_namuwiki_list(name)

    pdf = PDF(doc_title=f"{name} 분석 보고서")
    await pdf.create_pdf_from_namuwiki_list(data, "./")

if __name__ == "__main__":
    name = "나루토"
    asyncio.run(create_pdf(name))
```
#### 2. CLI 명령어로 사용
라이브러리 설치 후, CLI 명령어도 사용할 수 있습니다.
```bash
nadf invoke -p ./output -u "https://namu.wiki/w/%EC%84%AC%EC%97%90%EC%96%B4"
```
옵션 설명:
-p : PDF 저장 경로
-u : 나무위키 문서 URL
이렇게 실행하면 지정 경로에 [문서명] 분석 보고서.pdf 파일이 생성됩니다.

### 출력물의 특징
섹션 구조 보존: 목차에 따라 본문이 구분되어 출력
한글 폰트 내장: Noto Serif KR Regular/Bold 동봉, 한글 깨짐 문제 없음
읽을 수 있는 수준의 가독성: 기본적인 여백, 줄바꿈, 글꼴 적용
디자인 단순성: 본래 목적은 데이터 검증용이므로 시각적 화려함은 최소화

### 기대되는 활용 시나리오
폭넓은 데이터를 통한 RAG 챗봇
연구/학습 자료
특정 주제를 자동으로 수집해 보고서화
수업 보조 자료로 사용
PDF를 바탕으로 데이터셋 전처리 파이프라인 구축
이후 Q/A 쌍, 요약 데이터로 가공 가능
### 기술적 특징
#### 라이브러리 & CLI 이중 지원 
#### 파이썬 코드에서 직접 사용 가능 
#### Noto Serif KR 내장, 별도 설치 불필요 
#### 크롤러/파서/PDF 생성기가 분리되어 있어 확장성 용이 
> PR 마음껏 올려주세요.

### 기여 방법
PR과 Issue 모두 환영합니다!
버그 리포트 시 Python 버전, 실행 로그, 재현 코드를 함께 제공해 주세요.
새로운 기능/출력 포맷 제안도 적극적으로 검토합니다.

### 라이선스
MIT License (패키지 내 LICENSE 파일 참고)

### 첨언
본 프로젝트는 단순한 PDF 생성기가 아니라,
한국어 챗봇 학습 생태계 확장을 위해 실용적인 도구로 발전하기를 목표로 합니다. <br>
한국어 데이터 활용의 범위를 넓히는 데 기여하기를 기대합니다.
