from . import download
import json
import os
import shutil

cmods_make_template = """ 
# Makefile generated by cpak, do not edit
# Cpak Guillermo Leira Temes (c) 2025

CPACK_CFLAGS = {cflags}
CPACK_SRC = {src}


"""

cmods_make_rule_template = """

.PHONY: {module_name}

{module_name}:
\t$(MAKE) -C $(CPACK_SRC)/{module_name}/ CFLAGS="$(CPACK_CFLAGS)"

"""

cmods_make_all_template = """

.PHONY: cmods_all

cmods_all: {module_list}

"""

def make(path):
    if "src" in os.listdir("."):
        shutil.rmtree("src")
    if "include" in os.listdir("."):
        shutil.rmtree("include")
    if "Makefile" in os.listdir("."):
        os.remove("Makefile")
    if "cmods.json" in os.listdir("."):
        os.remove("cmods.json")
    if "cmods" in os.listdir("."):
        shutil.rmtree("cmods")

    shutil.copytree(os.path.join(path, "src"), "src", dirs_exist_ok=True)
    shutil.copytree(os.path.join(path, "include"), "include", dirs_exist_ok=True)
    shutil.copyfile(os.path.join(path, "Makefile"), "Makefile")
    shutil.copyfile(os.path.join(path, "cmods.json"), "cmods.json")
    os.mkdir("cmods")

    with open("cmods.json", "r") as f:
        cmods_config = json.load(f)
    
    cmods_makefile = cmods_make_template.format(cflags=cmods_config["CFLAGS"], src="src")

    for module in cmods_config["dependencies"].keys():
        cmods_makefile += cmods_make_rule_template.format(module_name=module)
    
    cmods_makefile += cmods_make_all_template.format(module_list=" ".join(cmods_config["dependencies"].keys()))

    with open(os.path.join("cmods", "cmods.mk"), "w") as f:
        f.write(cmods_makefile)

    for module in cmods_config["dependencies"].keys():
        download.cmods_from_repo(cmods_config["repositories"][cmods_config["dependencies"][module]], module)

