import os

from sqlmodel import Field

from bootgraph.dl import Dl, ManyRelation
from bootgraph.models import Graphemy
from bootgraph.router import GraphemyRouter
from bootgraph.setup import Setup

# Expose federation helpers
try:
    from .federation import setup_federation, add_federation_key, id_resolver
    __all__ = [
        "Graphemy",
        "GraphemyRouter",
        "Dl",
        "ManyRelation",
        "setup_federation",
        "add_federation_key"
    ]
except ImportError:
    __all__ = [
        "Graphemy",
        "GraphemyRouter",
        "Dl",
        "ManyRelation",
    ]

def import_files(path):
    """
    Recursively imports all Python files found in the specified directory and its subdirectories,
    excluding `__init__.py`. This function is intended to facilitate the dynamic loading of modules,
    particularly useful in scenarios like automatic model discovery in web applications.

    Args:
        path (str): The directory path from which Python files should be imported.

    Note:
        - This function modifies the global namespace by dynamically importing modules.
        - Import paths are adjusted to be relative, considering the package structure.
    """
    for root, dirs, files in os.walk(path):
        for file in files:
            if file.endswith(".py") and file != "__init__.py":
                module_name = os.path.splitext(file)[0]
                module_path = os.path.join(root, module_name)
                module_path_rel = os.path.relpath(os.path.join(root, module_name))
                module_path = module_path_rel.replace(os.path.sep, ".")
                exec(f"import {module_path}")
