/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.service;

import be.fedict.eid.applet.service.Address;
import be.fedict.eid.applet.service.EIdCertsData;
import be.fedict.eid.applet.service.EIdData;
import be.fedict.eid.applet.service.Identity;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMWriter;
import org.json.simple.JSONObject;

public class JSONServlet
extends HttpServlet {
    private static final Log LOG = LogFactory.getLog(JSONServlet.class);
    private static final long serialVersionUID = 1L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOG.debug((Object)"doGet");
        HttpSession httpSession = request.getSession();
        EIdData eIdData = (EIdData)httpSession.getAttribute("eid");
        if (null == eIdData) {
            throw new ServletException("no eID data available");
        }
        PrintWriter writer = response.getWriter();
        try {
            JSONServlet.outputJSON(eIdData, writer);
        }
        catch (CertificateEncodingException e) {
            throw new ServletException("Certificate encoding error: " + e.getMessage(), (Throwable)e);
        }
    }

    public static void outputJSON(EIdData eIdData, PrintWriter writer) throws IOException, CertificateEncodingException {
        EIdCertsData certsData;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy");
        JSONObject eidJSONObject = new JSONObject();
        JSONObject identityJSONObject = new JSONObject();
        eidJSONObject.put((Object)"identity", (Object)identityJSONObject);
        Identity identity = eIdData.identity;
        identityJSONObject.put((Object)"nationalNumber", (Object)identity.nationalNumber);
        identityJSONObject.put((Object)"name", (Object)identity.name);
        identityJSONObject.put((Object)"firstName", (Object)identity.firstName);
        identityJSONObject.put((Object)"middleName", (Object)identity.middleName);
        identityJSONObject.put((Object)"dateOfBirth", (Object)simpleDateFormat.format(identity.dateOfBirth.getTime()));
        identityJSONObject.put((Object)"placeOfBirth", (Object)identity.placeOfBirth);
        identityJSONObject.put((Object)"gender", (Object)identity.gender.toString());
        JSONObject cardJSONObject = new JSONObject();
        eidJSONObject.put((Object)"card", (Object)cardJSONObject);
        cardJSONObject.put((Object)"cardNumber", (Object)identity.cardNumber);
        cardJSONObject.put((Object)"chipNumber", (Object)identity.chipNumber);
        cardJSONObject.put((Object)"cardDeliveryMunicipality", (Object)identity.cardDeliveryMunicipality);
        cardJSONObject.put((Object)"cardValidityDateBegin", (Object)simpleDateFormat.format(identity.cardValidityDateBegin.getTime()));
        cardJSONObject.put((Object)"cardValidityDateEnd", (Object)simpleDateFormat.format(identity.cardValidityDateEnd.getTime()));
        Address address = eIdData.address;
        if (null != address) {
            JSONObject addressJSONObject = new JSONObject();
            eidJSONObject.put((Object)"address", (Object)addressJSONObject);
            addressJSONObject.put((Object)"streetAndNumber", (Object)address.streetAndNumber);
            addressJSONObject.put((Object)"municipality", (Object)address.municipality);
            addressJSONObject.put((Object)"zip", (Object)address.zip);
        }
        if (null != (certsData = eIdData.certs)) {
            JSONObject certsJSONObject = new JSONObject();
            eidJSONObject.put((Object)"certs", (Object)certsJSONObject);
            X509Certificate authnCertificate = certsData.authn;
            JSONObject authnCertJSONObject = JSONServlet.createCertJSONObject(authnCertificate, simpleDateFormat);
            certsJSONObject.put((Object)"authn", (Object)authnCertJSONObject);
            X509Certificate signCertificate = certsData.sign;
            JSONObject signCertJSONObject = JSONServlet.createCertJSONObject(signCertificate, simpleDateFormat);
            certsJSONObject.put((Object)"sign", (Object)signCertJSONObject);
            X509Certificate citizenCACertificate = certsData.ca;
            JSONObject citizenCACertJSONObject = JSONServlet.createCertJSONObject(citizenCACertificate, simpleDateFormat);
            certsJSONObject.put((Object)"citizenCA", (Object)citizenCACertJSONObject);
            X509Certificate rootCACertificate = certsData.root;
            JSONObject rootCACertJSONObject = JSONServlet.createCertJSONObject(rootCACertificate, simpleDateFormat);
            certsJSONObject.put((Object)"rootCA", (Object)rootCACertJSONObject);
        }
        eidJSONObject.writeJSONString((Writer)writer);
    }

    private static JSONObject createCertJSONObject(X509Certificate certificate, SimpleDateFormat simpleDateFormat) throws CertificateEncodingException, IOException {
        JSONObject certJSONObject = new JSONObject();
        certJSONObject.put((Object)"subject", (Object)certificate.getSubjectX500Principal().toString());
        certJSONObject.put((Object)"issuer", (Object)certificate.getIssuerX500Principal().toString());
        certJSONObject.put((Object)"serialNumber", (Object)certificate.getSerialNumber().toString());
        certJSONObject.put((Object)"notBefore", (Object)certificate.getNotBefore().toString());
        certJSONObject.put((Object)"notAfter", (Object)certificate.getNotAfter().toString());
        certJSONObject.put((Object)"signatureAlgo", (Object)certificate.getSigAlgName());
        certJSONObject.put((Object)"thumbprint", (Object)DigestUtils.shaHex((byte[])certificate.getEncoded()));
        certJSONObject.put((Object)"details", (Object)certificate.toString());
        certJSONObject.put((Object)"pem", (Object)JSONServlet.toPem(certificate));
        return certJSONObject;
    }

    private static String toPem(X509Certificate certificate) throws IOException {
        StringWriter stringWriter = new StringWriter();
        PEMWriter pemWriter = new PEMWriter((Writer)stringWriter, BouncyCastleProvider.PROVIDER_NAME);
        pemWriter.writeObject((Object)certificate);
        pemWriter.close();
        return stringWriter.toString();
    }
}

