/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.service.impl;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.FilterConfig;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceLocator<T> {
    private final String jndiLocation;
    private final String className;

    public ServiceLocator(String initParam, ServletConfig config) throws ServletException {
        this.jndiLocation = config.getInitParameter(initParam);
        this.className = config.getInitParameter(initParam + "Class");
    }

    public ServiceLocator(String initParam, FilterConfig config) {
        this.jndiLocation = config.getInitParameter(initParam);
        this.className = config.getInitParameter(initParam + "Class");
    }

    public T locateService() throws ServletException {
        try {
            Object service;
            if (null != this.jndiLocation) {
                InitialContext initialContext = new InitialContext();
                service = initialContext.lookup(this.jndiLocation);
            } else if (null != this.className) {
                Thread currentThread = Thread.currentThread();
                ClassLoader classLoader = currentThread.getContextClassLoader();
                Class<?> serviceClass = classLoader.loadClass(this.className);
                service = serviceClass.newInstance();
            } else {
                service = null;
            }
            return (T)service;
        }
        catch (NamingException e) {
            throw new ServletException("JNDI error: " + e.getMessage(), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new ServletException("Class not found: " + this.className, (Throwable)e);
        }
        catch (Exception e) {
            throw new ServletException("error: " + e.getMessage(), (Throwable)e);
        }
    }
}

