/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.service;

import be.fedict.eid.applet.service.EIdData;
import be.fedict.eid.applet.service.impl.PdfGenerator;
import com.lowagie.text.DocumentException;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PdfServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog(PdfServlet.class);
    private PdfGenerator pdfGenerator;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.pdfGenerator = new PdfGenerator();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        byte[] document;
        LOG.debug((Object)"doGet");
        HttpSession httpSession = request.getSession();
        EIdData eIdData = (EIdData)httpSession.getAttribute("eid");
        try {
            document = this.pdfGenerator.generatePdf(eIdData);
        }
        catch (DocumentException e) {
            throw new ServletException("PDF generator error: " + e.getMessage(), (Throwable)e);
        }
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
        response.setHeader("Pragma", "public");
        response.setContentType("application/pdf");
        response.setContentLength(document.length);
        ServletOutputStream out = response.getOutputStream();
        out.write(document);
        out.flush();
    }
}

