/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.service.impl;

import be.fedict.eid.applet.shared.protocol.ProtocolState;
import be.fedict.eid.applet.shared.protocol.ProtocolStateListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RequestContext
implements ProtocolStateListener {
    private static final Log LOG = LogFactory.getLog(RequestContext.class);
    private final HttpSession httpSession;
    public static final String INCLUDE_IDENTITY_SESSION_ATTRIBUTE = RequestContext.class.getName() + ".IncludeIdentity";
    public static final String INCLUDE_ADDRESS_SESSION_ATTRIBUTE = RequestContext.class.getName() + ".IncludeAddress";
    public static final String INCLUDE_PHOTO_SESSION_ATTRIBUTE = RequestContext.class.getName() + ".IncludePhoto";
    public static final String INCLUDE_CERTIFICATES_SESSION_ATTRIBUTE = RequestContext.class.getName() + ".IncludeCertificates";
    public static final String TRANSACTION_MESSAGE_SESSION_ATTRIBUTE = RequestContext.class.getName() + ".TransactionMessage";

    public RequestContext(HttpServletRequest request) {
        this(request.getSession());
    }

    public RequestContext(HttpSession httpSession) {
        this.httpSession = httpSession;
    }

    public void protocolStateTransition(ProtocolState newProtocolState) {
    }

    public void startProtocolRun() {
        this.clearRequestContext();
    }

    public void stopProtocolRun() {
        this.clearRequestContext();
    }

    private void clearRequestContext() {
        LOG.debug((Object)"clearing request context");
        this.httpSession.removeAttribute(INCLUDE_IDENTITY_SESSION_ATTRIBUTE);
        this.httpSession.removeAttribute(INCLUDE_ADDRESS_SESSION_ATTRIBUTE);
        this.httpSession.removeAttribute(INCLUDE_PHOTO_SESSION_ATTRIBUTE);
        this.httpSession.removeAttribute(INCLUDE_CERTIFICATES_SESSION_ATTRIBUTE);
        this.httpSession.removeAttribute(TRANSACTION_MESSAGE_SESSION_ATTRIBUTE);
    }

    public void setIncludeIdentity(boolean includeIdentity) {
        this.httpSession.setAttribute(INCLUDE_IDENTITY_SESSION_ATTRIBUTE, (Object)includeIdentity);
    }

    public void setIncludeAddress(boolean includeAddress) {
        this.httpSession.setAttribute(INCLUDE_ADDRESS_SESSION_ATTRIBUTE, (Object)includeAddress);
    }

    public void setIncludePhoto(boolean includePhoto) {
        this.httpSession.setAttribute(INCLUDE_PHOTO_SESSION_ATTRIBUTE, (Object)includePhoto);
    }

    public void setIncludeCertificates(boolean includeCertificates) {
        this.httpSession.setAttribute(INCLUDE_CERTIFICATES_SESSION_ATTRIBUTE, (Object)includeCertificates);
    }

    public void setTransactionMessage(String transactionMessage) {
        this.httpSession.setAttribute(TRANSACTION_MESSAGE_SESSION_ATTRIBUTE, (Object)transactionMessage);
    }

    public boolean includeIdentity() {
        return this.getBoolean(INCLUDE_IDENTITY_SESSION_ATTRIBUTE);
    }

    public boolean includeAddress() {
        return this.getBoolean(INCLUDE_ADDRESS_SESSION_ATTRIBUTE);
    }

    public boolean includePhoto() {
        return this.getBoolean(INCLUDE_PHOTO_SESSION_ATTRIBUTE);
    }

    public boolean includeCertificates() {
        return this.getBoolean(INCLUDE_CERTIFICATES_SESSION_ATTRIBUTE);
    }

    private boolean getBoolean(String attributeName) {
        Object attributeValue = this.httpSession.getAttribute(attributeName);
        if (null == attributeValue) {
            return false;
        }
        return (Boolean)attributeValue;
    }

    public String getTransactionMessage() {
        String transactionMessage = (String)this.httpSession.getAttribute(TRANSACTION_MESSAGE_SESSION_ATTRIBUTE);
        return transactionMessage;
    }
}

