/*
 * Decompiled with CFR 0.152.
 */
package src.eidreader;

import be.fedict.eid.applet.service.Address;
import be.fedict.eid.applet.service.Identity;
import be.fedict.eid.applet.service.impl.tlv.TlvParser;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import javax.smartcardio.ATR;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import org.apache.commons.codec.binary.Base64;

class BelgianReader {
    public static final String ENCODING = "utf-8";
    private CardChannel cardChannel;
    private Identity identity;
    private Address address;
    private byte[] photo;
    private static final int BLOCK_SIZE = 255;
    private static final byte[] ATR_PATTERN = new byte[]{59, -104, 0, 64, 0, 0, 0, 0, 1, 1, -83, 19, 16};
    private static final byte[] ATR_MASK = new byte[]{-1, -1, 0, -1, 0, 0, 0, 0, -1, -1, -1, -1, -16};
    public static final byte[] IDENTITY_FILE_ID = new byte[]{63, 0, -33, 1, 64, 49};
    public static final byte[] ADDRESS_FILE_ID = new byte[]{63, 0, -33, 1, 64, 51};
    public static final byte[] PHOTO_FILE_ID = new byte[]{63, 0, -33, 1, 64, 53};
    public static final String OOPS = "Unexpected end of TLV structure source";
    static final SimpleDateFormat date_format = new SimpleDateFormat("yyyy-MM-dd");
    public final boolean includePhoto = true;

    public static boolean matchesEidAtr(ATR aTR) {
        byte[] byArray = aTR.getBytes();
        if (byArray.length != ATR_PATTERN.length) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            int n = i;
            byArray[n] = (byte)(byArray[n] & ATR_MASK[i]);
        }
        return Arrays.equals(byArray, ATR_PATTERN);
    }

    public static String str2yaml(String string) {
        return string;
    }

    public static String cal2date(Calendar calendar) {
        return date_format.format(calendar.getTime());
    }

    public BelgianReader(CardChannel cardChannel) throws CardException, IOException, UnsupportedEncodingException {
        System.err.println("BelgianReader() constructor started");
        this.cardChannel = cardChannel;
        byte[] byArray = this.readFile(IDENTITY_FILE_ID);
        System.err.println("identityData has been read");
        this.identity = TlvParser.parse(byArray, Identity.class);
        System.err.println("identityData has been parsed");
        byte[] byArray2 = this.readFile(ADDRESS_FILE_ID);
        System.err.println("addressData has been read");
        this.address = TlvParser.parse(byArray2, Address.class);
        System.err.println("addressData has been parsed");
        this.photo = this.readFile(PHOTO_FILE_ID);
    }

    public byte[] readFile(byte[] byArray) throws CardException, IOException {
        this.selectFile(byArray);
        return this.readBinary();
    }

    private void selectFile(byte[] byArray) throws CardException, FileNotFoundException {
        CommandAPDU commandAPDU = new CommandAPDU(0, 164, 8, 12, byArray);
        ResponseAPDU responseAPDU = this.transmit(commandAPDU);
        if (36864 != responseAPDU.getSW()) {
            throw new FileNotFoundException("wrong status word after selecting file: " + Integer.toHexString(responseAPDU.getSW()));
        }
        try {
            Thread.sleep(20L);
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("sleep error: " + interruptedException.getMessage());
        }
    }

    private byte[] readBinary() throws CardException, IOException {
        CommandAPDU commandAPDU;
        ResponseAPDU responseAPDU;
        int n;
        int n2 = 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while (27392 != (n = (responseAPDU = this.transmit(commandAPDU = new CommandAPDU(0, 176, n2 >> 8, n2 & 0xFF, 255))).getSW())) {
            if (36864 != n) {
                throw new IOException("APDU response error: " + responseAPDU.getSW());
            }
            byte[] byArray = responseAPDU.getData();
            byteArrayOutputStream.write(byArray);
            n2 += byArray.length;
            if (255 == byArray.length) continue;
        }
        return byteArrayOutputStream.toByteArray();
    }

    private ResponseAPDU transmit(CommandAPDU commandAPDU) throws CardException {
        ResponseAPDU responseAPDU = this.cardChannel.transmit(commandAPDU);
        if (108 == responseAPDU.getSW1()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException("cannot sleep");
            }
            responseAPDU = this.cardChannel.transmit(commandAPDU);
        }
        return responseAPDU;
    }

    public String resultAsString(Boolean bl) {
        Identity identity = this.identity;
        Address address = this.address;
        String string = "reader: BE";
        string = string + "\nname: " + identity.name;
        string = string + "\nfirstName: " + BelgianReader.str2yaml(identity.firstName);
        string = string + "\nmiddleName: " + BelgianReader.str2yaml(identity.middleName);
        string = string + "\nnationality: " + BelgianReader.str2yaml(identity.nationality);
        string = string + "\nplaceOfBirth: " + BelgianReader.str2yaml(identity.placeOfBirth);
        string = string + "\ndateOfBirth: " + BelgianReader.cal2date(identity.dateOfBirth);
        string = string + "\ngender: " + identity.gender.toString();
        string = string + "\nnationalNumber: " + identity.nationalNumber;
        string = string + "\ncardNumber: " + identity.cardNumber;
        string = string + "\nchipNumber: " + identity.chipNumber;
        string = string + "\ncardDeliveryMunicipality: " + identity.cardDeliveryMunicipality;
        string = string + "\nnobleCondition: " + BelgianReader.str2yaml(identity.nobleCondition);
        string = string + "\ndocumentType: " + Integer.toString(identity.documentType.getKey());
        string = string + "\nspecialStatus: " + identity.specialStatus.toString();
        string = string + "\nduplicate: " + BelgianReader.str2yaml(identity.duplicate);
        string = string + String.format("\nspecialOrganisation: %s", identity.specialOrganisation);
        string = string + "\ncardValidityDateBegin: " + BelgianReader.cal2date(identity.cardValidityDateBegin);
        string = string + "\ncardValidityDateEnd: " + BelgianReader.cal2date(identity.cardValidityDateEnd);
        string = string + "\nstreetAndNumber: " + BelgianReader.str2yaml(address.streetAndNumber);
        string = string + "\nzip: " + address.zip;
        string = string + "\nmunicipality: " + address.municipality;
        if (bl.booleanValue() && this.photo.length > 0) {
            byte[] byArray = Base64.encodeBase64((byte[])this.photo);
            string = string + "\nphoto: " + new String(byArray);
        }
        System.out.println(string);
        return string;
    }
}

