# -*- coding: UTF-8 -*-
# generated by lino.sphinxcontrib.help_text_builder
# fmt: off
from django.utils.translation import gettext_lazy as _

help_texts = {
    'lino_xl.lib.accounting.fields.DcAmountField' : _("""An editable virtual PriceField to get and set an amount of a given booking direction (debit or credit). It may be used only on models that defines a database field amount."""),
    'lino_xl.lib.b2c.Plugin' : _("""See lino.core.plugin.Plugin."""),
    'lino_xl.lib.b2c.Plugin.import_statements_path' : _("""The full name of the directory that Lino should watch for incoming xml files that need to get imported."""),
    'lino_xl.lib.b2c.Plugin.delete_imported_xml_files' : _("""This attribute define whether, Cosi have to delete the SEPA file after it get imported."""),
    'lino_xl.lib.b2c.camt.BankTransaction' : _("""Single transaction that is part of a bank statement."""),
    'lino_xl.lib.b2c.camt.BankStatement' : _("""A bank statement groups data about several bank transactions."""),
    'lino_xl.lib.b2c.camt.BankStatement.create_transaction' : _("""Create and append transaction."""),
    'lino_xl.lib.b2c.camt.CamtParser' : _("""Parser for camt bank statement import files."""),
    'lino_xl.lib.b2c.camt.CamtParser.parse_date' : _("""“Parse a <Bal> element for a <Dt>."""),
    'lino_xl.lib.b2c.camt.CamtParser.parse_amount' : _("""Parse element that contains Amount and CreditDebitIndicator."""),
    'lino_xl.lib.b2c.camt.CamtParser.add_value_from_node' : _("""Add value to object from first or all nodes found with xpath."""),
    'lino_xl.lib.b2c.camt.CamtParser.parse_transaction_details' : _("""Parse transaction details (message, party, account…)."""),
    'lino_xl.lib.b2c.camt.CamtParser.parse_transaction' : _("""Parse transaction (entry) node."""),
    'lino_xl.lib.b2c.camt.CamtParser.parse_balance_amounts' : _("""Return opening and closing balance."""),
    'lino_xl.lib.b2c.camt.CamtParser.parse_statement' : _("""Parse a single Stmt node."""),
    'lino_xl.lib.b2c.camt.CamtParser.check_version' : _("""Validate validity of camt file."""),
    'lino_xl.lib.b2c.camt.CamtParser.parse' : _("""Parse a camt.052 or camt.053 file."""),
    'lino_xl.lib.bevat.Plugin' : _("""This is a subclass of lino.core.plugin.Plugin."""),
    'lino_xl.lib.bevats.Plugin' : _("""See lino.core.plugin.Plugin."""),
    'lino_xl.lib.boards.Plugin' : _("""See lino.core.Plugin."""),
    'lino_xl.lib.boards.BoardDecision' : _("""Mixin for models that represent a board decision. Base class for lino_welfare.modlib.aids.mixins.Confirmation."""),
    'lino_xl.lib.boards.Member' : _("""A Member is when a given ml.contacts.Person belongs to a given Board."""),
    'lino_xl.lib.calview.Plugin' : _("""The descriptor for this plugin. See lino.core.Plugin."""),
    'lino_xl.lib.calview.Plugin.params_layout' : _("""The actor parameter layout to use for filtering calendar views."""),
    'lino_xl.lib.concepts.Plugin' : _("""See /dev/plugins."""),
    'lino_xl.lib.countries.Plugin' : _("""The countries plugin."""),
    'lino_xl.lib.countries.Plugin.get_my_country' : _("""Return the Country instance configured by country_code."""),
    'lino_xl.lib.countries.utils.AddressFormatter' : _("""Format used in BE, DE, FR, NL…"""),
    'lino_xl.lib.countries.utils.EstonianAddressFormatter' : _("""Format used in Estonia."""),
    'lino_xl.lib.cv.Plugin' : _("""Defines plugin configuration settings of this plugin."""),
    'lino_xl.lib.cv.Plugin.person_model' : _("""The database model to use for representing the persons whose career data is being stored."""),
    'lino_xl.lib.cv.Plugin.with_language_history' : _("""Whether language knowledge data should have a history."""),
    'lino_xl.lib.deploy.Plugin' : _("""See lino.core.plugin.Plugin."""),
    'lino_xl.lib.dupable_partners.Plugin' : _("""See lino.core.plugin.Plugin."""),
    'lino_xl.lib.eevat.Plugin' : _("""This is a subclass of lino.core.plugin.Plugin."""),
    'lino_xl.lib.events.Plugin' : _("""See /dev/plugins."""),
    'lino_xl.lib.excerpts.Plugin' : _("""See lino.core.Plugin."""),
    'lino_xl.lib.excerpts.Plugin.responsible_user' : _("""The username of the user responsible for monitoring the excerpts system. This is currently used only by lino_xl.lib.excerpts.fixtures.demo2."""),
    'lino_xl.lib.excerpts.roles.ExcerptsUser' : _("""Can print documents using database excerpts."""),
    'lino_xl.lib.excerpts.roles.ExcerptsStaff' : _("""Can configure database excerpts functionality."""),
    'lino_xl.lib.families.Plugin' : _("""See lino.core.Plugin."""),
    'lino_xl.lib.families.CoupleField' : _("""An editable virtual field that looks like a FK to a contacts.Person but is stored as a Couple instance."""),
    'lino_xl.lib.households.Plugin' : _("""Extends lino.core.plugin.Plugin."""),
    'lino_xl.lib.households.Plugin.person_model' : _("""A string referring to the model that represents a human in your application. Default value is 'contacts.Person' (referring to lino_xl.lib.contacts.models.Person)."""),
    'lino_xl.lib.households.Plugin.adult_age' : _("""The age (in years) a person needs to have in order to be considered adult."""),
    'lino_xl.lib.humanlinks.Plugin' : _("""Extends lino.core.plugin.Plugin."""),
    'lino_xl.lib.humanlinks.Plugin.person_model' : _("""A string referring to the model which represents a human in your application. Default value is 'contacts.Person' (referring to lino_xl.lib.contacts.Person)."""),
    'lino_xl.lib.lists.Plugin' : _("""See lino.core.Plugin."""),
    'lino_xl.lib.notes.Plugin' : _("""See lino.core.Plugin."""),
    'lino_xl.lib.outbox.RecipientTypes' : _("""A list of possible values for the type field of a Recipient."""),
    'lino_xl.lib.outbox.MailableType' : _("""Mixin for Models that serve as type of a Mailable. Concrete examples are cal.EventType, cal.GuestRole, notes.NoteType."""),
    'lino_xl.lib.outbox.MailableType.templates_group' : _("""Should contain a string “<app_label>/<Model>” of the Mailable being typed by this MailableType. Example:"""),
    'lino_xl.lib.outbox.CreateMail' : _("""Creates an outbox mail and displays it."""),
    'lino_xl.lib.outbox.CreateMail.get_action_permission' : _("""This action is not available:"""),
    'lino_xl.lib.outbox.Mailable' : _("""Mixin for models that provide a “Post” button. A Mailable model must also inherit from mixins.Printable or some subclass thereof."""),
    'lino_xl.lib.outbox.Mailable.get_mailable_subject' : _("""Return the content of the subject field for the email to be created."""),
    'lino_xl.lib.postings.Plugin' : _("""See lino.core.Plugin."""),
    'lino_xl.lib.postings.CreatePostings' : _("""Creates a series of new Postings from this Postable. The Postable gives the list of recipients, and there will be one Posting for each recipient."""),
    'lino_xl.lib.postings.Postable' : _("""Mixin for models that provide a “Post” button."""),
    'lino_xl.lib.products.Plugin' : _("""The config descriptor for this plugin."""),
    'lino_xl.lib.properties.Plugin' : _("""See lino.core.Plugin."""),
    'lino_xl.lib.reception.Plugin' : _("""See lino.core.Plugin."""),
    'lino_xl.lib.reception.Plugin.required_user_groups' : _("""The required user groups for viewing actors of this plugin."""),
    'lino_xl.lib.reception.CheckinVisitor' : _("""Mark this visitor as arrived."""),
    'lino_xl.lib.reception.CheckinVisitor.get_notify_recipients' : _("""Yield a list of users to be notified."""),
    'lino_xl.lib.reception.ReceiveVisitor' : _("""The “Receive” action on a Guest."""),
    'lino_xl.lib.reception.CheckoutVisitor' : _("""The “Checkout” action on a Guest."""),
    'lino_xl.lib.reception.AppointmentsByPartner' : _("""Show the participations in upcoming calendar events for a given partner."""),
    'lino_xl.lib.reception.AppointmentsByPartner.model' : _("""alias of Guest"""),
    'lino_xl.lib.reception.AppointmentsByPartner.detail_link' : _("""A single-paragraph of formatted text that describes this database row."""),
    'lino_xl.lib.reception.AppointmentsByPartner.master' : _("""alias of Person"""),
    'lino_xl.lib.reception.ExpectedGuests' : _("""General table of all expected guests."""),
    'lino_xl.lib.reception.ExpectedGuests.model' : _("""alias of Guest"""),
    'lino_xl.lib.reception.Visitors' : _("""Common base class for the following tables:"""),
    'lino_xl.lib.reception.Visitors.model' : _("""alias of Guest"""),
    'lino_xl.lib.reception.BusyVisitors' : _("""Show busy visitors (with any user)."""),
    'lino_xl.lib.reception.BusyVisitors.model' : _("""alias of Guest"""),
    'lino_xl.lib.reception.WaitingVisitors' : _("""Show waiting visitors (for any user)."""),
    'lino_xl.lib.reception.WaitingVisitors.model' : _("""alias of Guest"""),
    'lino_xl.lib.reception.GoneVisitors' : _("""Show gone visitors (for any user)."""),
    'lino_xl.lib.reception.GoneVisitors.model' : _("""alias of Guest"""),
    'lino_xl.lib.reception.MyWaitingVisitors' : _("""Show visitors waiting for me."""),
    'lino_xl.lib.reception.MyWaitingVisitors.model' : _("""alias of Guest"""),
    'lino_xl.lib.reception.MyBusyVisitors' : _("""Show the visitors with whom I am busy."""),
    'lino_xl.lib.reception.MyBusyVisitors.model' : _("""alias of Guest"""),
    'lino_xl.lib.reception.MyGoneVisitors' : _("""Show my visitors who have gone."""),
    'lino_xl.lib.reception.MyGoneVisitors.model' : _("""alias of Guest"""),
    'lino_xl.lib.reception.workflows.CloseMeeting' : _("""Close the meeting (mark it as “took place”) and check out all guests. Ask confirmation naming the guests who need to check out."""),
    'lino_xl.lib.rooms.Plugin' : _("""See lino.core.Plugin."""),
    'lino_xl.lib.sepa.fields.UppercaseTextFieldElement' : _("""A CharFieldElement which accepts only upper-case characters."""),
    'lino_xl.lib.sepa.fields.UppercaseTextField' : _("""A custom CharField that accepts only uppercase caracters."""),
    'lino_xl.lib.sepa.fields.BICField' : _("""Database field used to store a BIC."""),
    'lino_xl.lib.sepa.fields.IBANField' : _("""Database field used to store an IBAN."""),
    'lino_xl.lib.sepa.roles.SepaUser' : _("""Can see imported bank statements and movements per partner."""),
    'lino_xl.lib.sepa.roles.SepaStaff' : _("""Can see imported statements and movements also globally in the Explorer menu."""),
    'lino_xl.lib.stars.Plugin' : _("""See lino.core.plugin.Plugin."""),
    'lino_xl.lib.stars.Star' : _("""Represents the fact that a given database object is starred by a given User."""),
    'lino_xl.lib.stars.Star.owner' : _("""The starred database object"""),
    'lino_xl.lib.stars.Star.user' : _("""The starring user (pointer to :class:lino.modlib.users.models.User`"""),
    'lino_xl.lib.stars.Star.master' : _("""The starred object that caused this stared object"""),
    'lino_xl.lib.stars.Star.for_obj' : _("""Return a queryset of Star instances for the given database object."""),
    'lino_xl.lib.stars.Star.for_model' : _("""Return a queryset of Star instances for the given database model."""),
    'lino_xl.lib.stars.Star.for_master_model' : _("""Return a queryset of master Star instances for the given database model."""),
    'lino_xl.lib.teams.Plugin' : _("""See lino.core.Plugin."""),
    'lino_xl.lib.tickets.Plugin' : _("""The descriptor for this plugin."""),
    'lino_xl.lib.tickets.Plugin.milestone_model' : _("""The model to be used for representing “milestones”."""),
    'lino_xl.lib.tickets.Plugin.end_user_model' : _("""The model to be used for representing “end users”."""),
    'lino_xl.lib.tickets.Plugin.default_priority' : _("""Default priority for new tickets."""),
    'lino_xl.lib.tickets.roles.Reporter' : _("""Can create new tickets and edit their own tickets."""),
    'lino_xl.lib.tickets.roles.Searcher' : _("""Can see all tickets."""),
    'lino_xl.lib.tickets.roles.Triager' : _("""Can modify administrative ticket data like assigned worker, site, ticket type…."""),
    'lino_xl.lib.tickets.roles.TicketsStaff' : _("""Can configure tickets functionality."""),
    'lino_xl.lib.tim2lino.Plugin' : _("""See lino.core.plugin.Plugin."""),
    'lino_xl.lib.tim2lino.Plugin.languages' : _("""The language distribution used in the database to import. Mandatory parameter. No default value."""),
    'lino_xl.lib.tim2lino.Plugin.use_dbfread' : _("""Whether to use Ole Martin Bjorndalen’s dbfread package instead of lino.utils.dbfreader to read DBF files."""),
    'lino_xl.lib.tim2lino.Plugin.use_dbf_py' : _("""Whether to use Ethan Furman’s dbf package instead of lino.utils.dbfreader to read DBF files."""),
    'lino_xl.lib.tim2lino.Plugin.dbf_table_ext' : _("""The file extension of TIM tables. Meaningful values are ‘.DBF’ or .FOX."""),
    'lino_xl.lib.tim2lino.Plugin.timloader_module' : _("""The module that contains the TimLoader class to be used by the tim2lino fixture."""),
    'lino_xl.lib.tim2lino.Plugin.timloader_kwargs' : _("""The options to pass as keyword arguments when instantiating the TimLoader class."""),
    'lino_xl.lib.tim2lino.Plugin.ignore_journals' : _("""A set of journal refs to not import"""),
    'lino_xl.lib.tim2lino.Plugin.ignore_diffs_below' : _("""Don’t warn when a total amount differs from TIM by less then this after registration of an invoice."""),
    'lino_xl.lib.trading.Plugin' : _("""See lino.core.plugin.Plugin."""),
    'lino_xl.lib.trends.Plugin' : _("""See lino.core.plugins.Plugin."""),
    'lino_xl.lib.trends.Plugin.subject_model' : _("""The Django model used to represent the “subject” being observed."""),
    'lino_xl.lib.vatless.Plugin' : _("""See lino.core.plugin.Plugin."""),
    'lino_xl.lib.votes.Plugin' : _("""See lino.core.plugin.Plugin."""),
    'lino_xl.lib.votes.Plugin.votable_model' : _("""The things we are voting about. A string referring to the model that represents a votable in your application."""),
    'lino_xl.lib.votes.Plugin.with_candidatures' : _("""Whether to use votes for implementing a kind of polling: when somebody posts a ticket, other users are asked to vote on it, deciding whether they take it or not."""),
    'lino_xl.lib.accounting.LedgerPartner' : _("""Can see transactions related to their partner account."""),
    'lino_xl.lib.accounting.AccountingReader' : _("""Can read all accounting data and create reports, but cannot change any relevant data."""),
    'lino_xl.lib.accounting.LedgerUser' : _("""Can see all journals, create vouchers of any kind, can see vouchers of other users but cannot edit them."""),
    'lino_xl.lib.accounting.VoucherSupervisor' : _("""Can edit vouchers that have been written by other users."""),
    'lino_xl.lib.accounting.LedgerStaff' : _("""Can configure ledger functionality."""),
    'lino_xl.lib.accounting.Account' : _("""Django model for representing a ledger account."""),
    'lino_xl.lib.accounting.Account.name' : _("""The multilingual designation of this account, as the users see it."""),
    'lino_xl.lib.accounting.Account.ref' : _("""An optional unique name which can be used to reference a given account."""),
    'lino_xl.lib.accounting.Account.type' : _("""The account type of this account. This points to an item of CommonAccounts."""),
    'lino_xl.lib.accounting.Account.needs_partner' : _("""Whether bookings to this account need a partner specified."""),
    'lino_xl.lib.accounting.Account.vat_class' : _("""The default VAT class to use for transactions on this account."""),
    'lino_xl.lib.accounting.Account.default_amount' : _("""The default amount to book in bank statements or journal entries when this account has been selected manually. The default booking direction is that of the type."""),
    'lino_xl.lib.accounting.Account.FOO_allowed' : _("""These checkboxes indicate whether this account can be used on an item of a purchases (or sales or wages or FOO) invoice. There is one such checkbox for every trade type (TradeTypes). They exist only when the accounting plugin is installed as well. See also the get_allowed_accounts method."""),
    'lino_xl.lib.accounting.Account.needs_ana' : _("""Whether transactions on this account require the user to also specify an analytic account."""),
    'lino_xl.lib.accounting.Account.ana_account' : _("""Which analytic account to suggest for transactions on this account."""),
    'lino_xl.lib.accounting.Account.sheet_item' : _("""Pointer to the item of the balance sheet or income statement that will report the movements of this account."""),
    'lino_xl.lib.accounting.CommonAccounts' : _("""The global list of common accounts."""),
    'lino_xl.lib.accounting.CommonAccounts.waiting' : _("""The waiting account, used to temporarily book movements for which you do not know where to book them."""),
    'lino_xl.lib.accounting.CommonAccounts.undeclared_costs' : _("""Used to books costs that will be reculated internally and are irrelevant for VAT declaration and annual report."""),
    'lino_xl.lib.accounting.CommonAccount' : _("""The base class for items of :CommonAccounts."""),
    'lino_xl.lib.accounting.CommonAccount.clearable' : _("""Default value for Account.clearable."""),
    'lino_xl.lib.accounting.CommonAccount.needs_partner' : _("""Default value for Account.needs_partner."""),
    'lino_xl.lib.accounting.CommonAccount.get_object' : _("""Return the database object representing this common account."""),
    'lino_xl.lib.accounting.CommonAccount.set_object' : _("""Set the cached database object representing this common account."""),
    'lino_xl.lib.accounting.DC' : _("""A choicelist with the two values “debit” and “credit”."""),
    'lino_xl.lib.accounting.Balance' : _("""A light-weight object to represent a balance, i.e. an amount together with its booking direction (debiting or crediting)."""),
    'lino_xl.lib.accounting.Balance.d' : _("""The amount of this balance when it is debiting, otherwise zero."""),
    'lino_xl.lib.accounting.Balance.c' : _("""The amount of this balance when it is crediting, otherwise zero."""),
    'lino_xl.lib.accounting.DebitOrCreditField' : _("""After 20201008 this is replaced by DC.field()."""),
    'lino_xl.lib.accounting.DebitOrCreditStoreField' : _("""No longer used after 20201008."""),
    'lino_xl.lib.accounting.Movement' : _("""Django model used to represent a ledger movement"""),
    'lino_xl.lib.accounting.Movement.value_date' : _("""The date at which this movement is to be entered into the accounting. This is usually the voucher’s entry_date, except e.g. for bank statements where each item can have its own value date."""),
    'lino_xl.lib.accounting.Movement.voucher' : _("""Pointer to the numbered voucher that caused this movement."""),
    'lino_xl.lib.accounting.Movement.partner' : _("""Pointer to the partner involved in this movement."""),
    'lino_xl.lib.accounting.Movement.seqno' : _("""Sequential number within a voucher."""),
    'lino_xl.lib.accounting.Movement.account' : _("""Pointer to the Account that is being moved by this movement."""),
    'lino_xl.lib.accounting.Movement.debit' : _("""Virtual field showing amount if dc is DEBIT."""),
    'lino_xl.lib.accounting.Movement.credit' : _("""Virtual field showing amount if dc is CREDIT."""),
    'lino_xl.lib.accounting.Movement.match' : _("""An unique name used to group a set of movements that are to be cleared."""),
    'lino_xl.lib.accounting.Movement.cleared' : _("""Whether this movement “is satisfied” or “has been paid”."""),
    'lino_xl.lib.accounting.Movement.voucher_partner' : _("""A virtual field which returns the partner of the voucher. For incoming invoices this is the supplier, for outgoing invoices this is the customer, for financial vouchers this is empty."""),
    'lino_xl.lib.accounting.Movement.voucher_link' : _("""A virtual field which shows a link to the voucher."""),
    'lino_xl.lib.accounting.Movement.match_link' : _("""A virtual field which shows a clickable variant of the match string. Clicking it will open a table with all movements having that match."""),
    'lino_xl.lib.accounting.Movement.ana_account' : _("""The analytic account to move together with this transactions."""),
    'lino_xl.lib.accounting.Movements' : _("""The base table for all tables having ledger movements as rows."""),
    'lino_xl.lib.accounting.MovementsByPartner' : _("""Shows the ledger movements linked to a given partner."""),
    'lino_xl.lib.accounting.MovementsByAccount' : _("""Shows the ledger movements done on a given general account."""),
    'lino_xl.lib.accounting.MovementsByAccount.description' : _("""A virtual field showing a comma-separated list of the following items:"""),
    'lino_xl.lib.accounting.MovementsByMatch' : _("""Show all movements having a given Movement.match."""),
    'lino_xl.lib.accounting.MovementsByProject' : _("""Show the ledger movements of a project."""),
    'lino_xl.lib.accounting.AllMovements' : _("""Show all the ledger movements in the database."""),
    'lino_xl.lib.accounting.MovementsByVoucher' : _("""Show the ledger movements generated by a given voucher."""),
    'lino_xl.lib.accounting.Voucher' : _("""Django model used to represent a numbered voucher."""),
    'lino_xl.lib.accounting.Voucher.state' : _("""The state of this voucher. It decides among others whether you can edit this voucher or not."""),
    'lino_xl.lib.accounting.Voucher.journal' : _("""The journal into which this voucher has been booked."""),
    'lino_xl.lib.accounting.Voucher.number' : _("""The sequence number of this voucher within its journal."""),
    'lino_xl.lib.accounting.Voucher.entry_date' : _("""The date of the journal entry, i.e. when this voucher is to be booked."""),
    'lino_xl.lib.accounting.Voucher.voucher_date' : _("""The date on the voucher (i.e. when it has been issued by its emitter)."""),
    'lino_xl.lib.accounting.Voucher.accounting_period' : _("""The accounting period to use when booking this voucher. The default value is determined from entry_date."""),
    'lino_xl.lib.accounting.Voucher.narration' : _("""A short explanation to explain the subject matter of this journal entry."""),
    'lino_xl.lib.accounting.Voucher.number_with_year' : _("""Shows the accounting year and the number of this voucher within its journal."""),
    'lino_xl.lib.accounting.Voucher.do_and_clear' : _("""Delete all movements of this voucher, then run the given callable func, passing it a set with all partners who had at least one movement in this voucher. The function is expected to add more partners to this set. Then call check_clearings() for all these partners."""),
    'lino_xl.lib.accounting.Voucher.get_partner' : _("""Return the partner related to this voucher. Overridden by lino_xl.lib.contacts.PartnerRelated vouchers."""),
    'lino_xl.lib.accounting.Voucher.get_movement_description' : _("""Generate a series of HTML chunks to be displayed in the Movment.description field."""),
    'lino_xl.lib.accounting.Voucher.get_wanted_movements' : _("""Subclasses must implement this. Supposed to return or yield a list of unsaved Movement instances."""),
    'lino_xl.lib.accounting.Voucher.make_xml_file' : _("""Write an XML file in an appropriate format for this voucher."""),
    'lino_xl.lib.accounting.LedgerRegistrable.toggle_state' : _("""Toggle between “registered” and “draft” state."""),
    'lino_xl.lib.accounting.LedgerRegistrable.hide_editable_number' : _("""Whether to hide the number that will be used for this voucher in its journal as long as the voucher is in an editable state."""),
    'lino_xl.lib.accounting.ToggleState' : _("""The action behind LedgerRegistrable.toggle_state."""),
    'lino_xl.lib.accounting.Journal' : _("""Django model used to represent a journal."""),
    'lino_xl.lib.accounting.Journal.trade_type' : _("""Pointer to TradeTypes."""),
    'lino_xl.lib.accounting.Journal.voucher_type' : _("""Pointer to an item of VoucherTypes."""),
    'lino_xl.lib.accounting.Journal.journal_group' : _("""Pointer to an item of JournalGroups."""),
    'lino_xl.lib.accounting.Journal.yearly_numbering' : _("""Whether the number of vouchers should restart at 1 every year."""),
    'lino_xl.lib.accounting.Journal.make_ledger_movements' : _("""Whether vouchers in this journal generate ledger movements."""),
    'lino_xl.lib.accounting.Journal.preliminary' : _("""Whether transactions in this journal are considered preliminary."""),
    'lino_xl.lib.accounting.Journal.account' : _("""The account to use for the counter-movements generated by vouchers in this journal."""),
    'lino_xl.lib.accounting.Journal.partner' : _("""The partner to use as default partner for vouchers in this journal."""),
    'lino_xl.lib.accounting.Journal.must_declare' : _("""Whether movements made by this journal should be included in VAT declarations."""),
    'lino_xl.lib.accounting.Journal.dc' : _("""The primary booking direction. Voucher items in this direction increase the total amount of the voucher."""),
    'lino_xl.lib.accounting.Journal.auto_check_clearings' : _("""Whether to automatically check and update the ‘cleared’ status of ledger movements when (de)registering a voucher of this journal."""),
    'lino_xl.lib.accounting.Journal.auto_fill_suggestions' : _("""Whether to automatically fill voucher item from due payments of the partner when entering a financial voucher."""),
    'lino_xl.lib.accounting.Journal.template' : _("""See PrintableType.template."""),
    'lino_xl.lib.accounting.Journal.sepa_account' : _("""Your bank account to specify in payment order."""),
    'lino_xl.lib.accounting.Journal.default_invoiceable_type' : _("""Default value for the type of lino_xl.lib.trading.InvoiceItem.invoiceable."""),
    'lino_xl.lib.accounting.Journals' : _("""List of all Journals. Accessible via Configure ‣ Accounting ‣ Journals."""),
    'lino_xl.lib.accounting.JournalsOverview' : _("""The list of all Journals shown in the dashboard."""),
    'lino_xl.lib.accounting.LedgerInfo' : _("""Django model used to store ledger specific information per user."""),
    'lino_xl.lib.accounting.LedgerInfo.user' : _("""OneToOneField pointing to the user."""),
    'lino_xl.lib.accounting.LedgerInfo.entry_date' : _("""The last value this user typed as entry_date of a voucher. It is the default value for every new voucher."""),
    'lino_xl.lib.accounting.LedgerInfo.get_by_user' : _("""Returns the ledger info entry for a given user."""),
    'lino_xl.lib.accounting.MatchRule' : _("""Django model used to store match rules."""),
    'lino_xl.lib.accounting.PaymentTerm' : _("""Django model used to store payment terms."""),
    'lino_xl.lib.accounting.PaymentTerm.days' : _("""Number of days to add to voucher_date."""),
    'lino_xl.lib.accounting.PaymentTerm.months' : _("""Number of months to add to voucher_date."""),
    'lino_xl.lib.accounting.PaymentTerm.end_of_month' : _("""Whether to move voucher_date to the end of month."""),
    'lino_xl.lib.accounting.PaymentTerm.informal' : _("""Whether to suppress the detail ledger movements."""),
    'lino_xl.lib.accounting.PaymentTerm.payer' : _("""The payer who pays for the invoice instead of the recipient. Usage examples see internal_clearings and invoices_to_emit"""),
    'lino_xl.lib.accounting.PaymentTerm.printed_text' : _("""Used in trading/VatProductInvoice/trailer.html as follows:"""),
    'lino_xl.lib.accounting.PaymentMethod' : _("""Django model used to store payment methods."""),
    'lino_xl.lib.accounting.PaymentMethod.payment_account' : _("""Which ledger account to book."""),
    'lino_xl.lib.accounting.PaymentMethod.is_cash' : _("""Whether this is considered a cash payment."""),
    'lino_xl.lib.accounting.TradeTypes' : _("""The choicelist with the trade types defined for this application."""),
    'lino_xl.lib.accounting.TradeTypes.sales' : _("""When you write an invoice to a customer and when the customer pays it."""),
    'lino_xl.lib.accounting.TradeTypes.purchases' : _("""When you get an invoice from a provider and when you pay it."""),
    'lino_xl.lib.accounting.TradeTypes.wages' : _("""When you write a payroll (declare the fact that you owe some wage to an employee) and later pay it (e.g. via a payment order)."""),
    'lino_xl.lib.accounting.TradeTypes.clearings' : _("""When an employee declares that he paid some invoice for you, and later you pay that money back to his account. Or the employee collects money for a sales invoice and later returns that money to you. See internal_clearings."""),
    'lino_xl.lib.accounting.TradeTypes.bank_po' : _("""When you ask your bank to execute a payment, and later the bank debits your account."""),
    'lino_xl.lib.accounting.TradeType' : _("""Base class for the choices of TradeTypes."""),
    'lino_xl.lib.accounting.TradeType.dc' : _("""The default booking direction."""),
    'lino_xl.lib.accounting.TradeType.main_account' : _("""The common account into which the total amount of partner vouchers (base + taxes) and their payments should be booked."""),
    'lino_xl.lib.accounting.TradeType.base_account' : _("""The default common account into which the base amount of any operation should be booked."""),
    'lino_xl.lib.accounting.TradeType.invoice_account_field_name' : _("""The name of a field to be injected on the Partner model which points to an account to be used instead of the default base_account."""),
    'lino_xl.lib.accounting.TradeType.base_account_field_name' : _("""The name of a field to be injected on the Product database model which points to an account to be used instead of the default base_account."""),
    'lino_xl.lib.accounting.TradeType.price_field' : _("""The name and label of the price field to be defined on the Product database model."""),
    'lino_xl.lib.accounting.TradeType.get_product_base_account' : _("""Return the account into which the base amount of any operation of this rete type should be booked."""),
    'lino_xl.lib.accounting.TradeType.get_catalog_price' : _("""Return the catalog price of the given product for operations with this trade type."""),
    'lino_xl.lib.accounting.TradeType.get_partner_invoice_account' : _("""Return the account to use as default value for account invoice items. This is the invoice_account_field of the given partner and can be None."""),
    'lino_xl.lib.accounting.JournalGroup' : _("""The name of another plugin"""),
    'lino_xl.lib.accounting.JournalGroups' : _("""The list of possible journal groups."""),
    'lino_xl.lib.accounting.JournalGroups.sales' : _("""For sales journals."""),
    'lino_xl.lib.accounting.JournalGroups.purchases' : _("""For purchases journals."""),
    'lino_xl.lib.accounting.JournalGroups.wages' : _("""For wages journals."""),
    'lino_xl.lib.accounting.JournalGroups.financial' : _("""For financial journals (bank statements and cash reports)"""),
    'lino_xl.lib.accounting.PeriodStates' : _("""The list of possible states of an accounting period."""),
    'lino_xl.lib.accounting.VoucherTypes' : _("""The list of voucher types available in this application."""),
    'lino_xl.lib.accounting.VoucherType' : _("""Base class for all items of VoucherTypes."""),
    'lino_xl.lib.accounting.VoucherType.model' : _("""The database model used to store vouchers of this type. A subclass of Voucher`."""),
    'lino_xl.lib.accounting.VoucherType.table_class' : _("""Must be a table on model having master_key set to the journal."""),
    'lino_xl.lib.accounting.VoucherState' : _("""Base class for items of VoucherStates."""),
    'lino_xl.lib.accounting.VoucherState.is_editable' : _("""Whether a voucher in this state is editable."""),
    'lino_xl.lib.accounting.VoucherStates' : _("""The list of possible states of a voucher."""),
    'lino_xl.lib.accounting.VoucherStates.draft' : _("""Draft vouchers can be modified but are not yet visible as movements in the ledger."""),
    'lino_xl.lib.accounting.VoucherStates.registered' : _("""Registered vouchers cannot be modified, but are visible as movements in the ledger."""),
    'lino_xl.lib.accounting.VoucherStates.cancelled' : _("""The Cancelled state is similar to Draft, except that you cannot edit the fields. This is used e.g. for an invoice that has been sent, but the customer signaled that they don’t agree. Instead of writing a credit nota, you can decide to just cancel the invoice."""),
    'lino_xl.lib.accounting.VoucherStates.signed' : _("""The Signed state is similar to registered, but cannot usually be deregistered any more. This state is not visible in the default configuration. In order to make it usable, you must define a custom workflow for VoucherStates."""),
    'lino_xl.lib.accounting.ByJournal' : _("""Mixin for journal-based tables of vouchers."""),
    'lino_xl.lib.accounting.Vouchers' : _("""The base table for all tables working on Voucher."""),
    'lino_xl.lib.accounting.ExpectedMovements' : _("""A virtual table of DueMovement rows, showing all “expected” “movements (payments)”."""),
    'lino_xl.lib.accounting.ExpectedMovements.date_until' : _("""Show only movements whose booking date is before or on the given date."""),
    'lino_xl.lib.accounting.ExpectedMovements.trade_type' : _("""Show only movements in the given trade type."""),
    'lino_xl.lib.accounting.ExpectedMovements.from_journal' : _("""Show only movements generated by a voucher in the given journal."""),
    'lino_xl.lib.accounting.ExpectedMovements.for_journal' : _("""Show only movements that may be matched by the given journal (i.e. for which a match rule exists)."""),
    'lino_xl.lib.accounting.ExpectedMovements.account' : _("""Show only movements on the given account."""),
    'lino_xl.lib.accounting.ExpectedMovements.partner' : _("""Show only movements with the given partner."""),
    'lino_xl.lib.accounting.ExpectedMovements.project' : _("""Show only movements about the given project."""),
    'lino_xl.lib.accounting.ExpectedMovements.show_sepa' : _("""Show only movements whose partner has a SEPA account."""),
    'lino_xl.lib.accounting.ExpectedMovements.same_dc' : _("""Show only movements having the same booking direction as the target voucher."""),
    'lino_xl.lib.accounting.DebtsByAccount' : _("""The ExpectedMovements accessible by clicking the “Debts” action button on an account."""),
    'lino_xl.lib.accounting.DebtsByPartner' : _("""This is the table being printed in a Payment Reminder. Usually this table has one row per sales invoice which is not fully paid. But several invoices (“debts”) may be grouped by match. If the partner has purchase invoices, these are deduced from the balance."""),
    'lino_xl.lib.accounting.PartnerVouchers' : _("""Base class for tables of partner vouchers."""),
    'lino_xl.lib.accounting.AccountsBalance' : _("""A virtual table, the base class for different reports that show a list of accounts with the following columns:"""),
    'lino_xl.lib.accounting.GeneralAccountsBalance' : _("""An AccountsBalance for general accounts."""),
    'lino_xl.lib.accounting.PartnerAccountsBalance' : _("""An AccountsBalance for partner accounts."""),
    'lino_xl.lib.accounting.CustomerAccountsBalance' : _("""A PartnerAccountsBalance for the TradeType “sales”."""),
    'lino_xl.lib.accounting.SuppliersAccountsBalance' : _("""A PartnerAccountsBalance for the TradeType “purchases”."""),
    'lino_xl.lib.accounting.DebtorsCreditors' : _("""Abstract base class for different tables showing a list of partners with the following columns:"""),
    'lino_xl.lib.accounting.Debtors' : _("""Shows partners who have some debt against us. Inherits from DebtorsCreditors."""),
    'lino_xl.lib.accounting.Creditors' : _("""Shows partners who give us some form of credit. Inherits from DebtorsCreditors."""),
    'lino_xl.lib.accounting.SequencedVoucherItem' : _("""A VoucherItem which also inherits from lino.mixins.sequenced.Sequenced."""),
    'lino_xl.lib.accounting.AccountVoucherItem' : _("""Abstract base class for voucher items which point to an account."""),
    'lino_xl.lib.accounting.AccountVoucherItem.account' : _("""ForeignKey pointing to the account (accounting.Account) that is to be moved."""),
    'lino_xl.lib.accounting.VoucherItem' : _("""Model mixin for items of a numbered voucher."""),
    'lino_xl.lib.accounting.VoucherItem.voucher' : _("""A foreign key to the numbered voucher that contains this item. The related_name must be 'items'."""),
    'lino_xl.lib.accounting.Matching' : _("""Model mixin for database objects that are considered matching vouchers. A matching voucher is a voucher that potentially can clear some existing movement (fully or partially)."""),
    'lino_xl.lib.accounting.Matching.match' : _("""An unique name used to group a set of movements that are to be cleared."""),
    'lino_xl.lib.accounting.PaymentRelated' : _("""This is base class for both (1) trade document vouchers (e.g. invoices or offers) and (2) for the individual entries of financial vouchers and ledger movements."""),
    'lino_xl.lib.accounting.PaymentRelated.payment_term' : _("""The payment term to apply for this transaction."""),
    'lino_xl.lib.accounting.PaymentRelated.payment_method' : _("""The payment method to to apply for this transaction."""),
    'lino_xl.lib.accounting.ProjectRelated' : _("""Model mixin for objects that are related to a project."""),
    'lino_xl.lib.accounting.ProjectRelated.project' : _("""Pointer to the “project”. This field exists only if the project_model setting is nonempty."""),
    'lino_xl.lib.accounting.Payable' : _("""Model mixin for objects that represent a payable transaction."""),
    'lino_xl.lib.accounting.Payable.your_ref' : _("""The reference used by the business partner for referring to this voucher."""),
    'lino_xl.lib.accounting.Payable.due_date' : _("""The date when the invoice is expected to have been paid."""),
    'lino_xl.lib.accounting.Payable.get_payable_sums_dict' : _("""To be implemented by subclasses. Expected to return a dict which maps 4-tuples (acc_tuple, project, vat_class, vat_regime) to the payable amount. acc_tuple is itself a tuple (general_account, analytic_account), vat_class is a lino_xl.lib.vat.VatClasses choice and vat_regime a lino_xl.lib.vat.VatRegimes choice."""),
    'lino_xl.lib.accounting.Payable.get_wanted_movements' : _("""Implements Voucher.get_wanted_movements()."""),
    'lino_xl.lib.accounting.PeriodRange' : _("""Model mixin for objects that cover a range of accounting periods."""),
    'lino_xl.lib.accounting.PeriodRange.start_period' : _("""The first period of the range to cover."""),
    'lino_xl.lib.accounting.PeriodRange.end_period' : _("""The last period of the range to cover."""),
    'lino_xl.lib.accounting.PeriodRangeObservable' : _("""Model mixin for objects that can be filtered by a range of accounting periods. This adds two parameter fields start_period and end_period to every table on this model."""),
    'lino_xl.lib.accounting.ItemsByVoucher' : _("""Shows the items of this voucher."""),
    'lino_xl.lib.accounting.AccountBalances' : _("""A table that shows a list of general ledger accounts during the observed period, showing their old and new balances and the sum of debit and credit movements."""),
    'lino_xl.lib.accounting.DueMovement' : _("""A volatile object representing a group of matching movements."""),
    'lino_xl.lib.accounting.DueMovement.match' : _("""The common match name of these movements."""),
    'lino_xl.lib.accounting.DueMovement.dc' : _("""Whether I mean my debts and payments (towards that partner) or those of the partner (towards me)."""),
    'lino_xl.lib.agenda.Item' : _("""The Django model to represent an agenda item."""),
    'lino_xl.lib.agenda.Item.meeting' : _("""The meeting."""),
    'lino_xl.lib.agenda.Item.topic' : _("""The optional topic."""),
    'lino_xl.lib.agenda.Item.title' : _("""The title."""),
    'lino_xl.lib.agenda.Item.description' : _("""A rich-text description."""),
    'lino_xl.lib.ana.Account.ref' : _("""The unique reference."""),
    'lino_xl.lib.ana.Account.group' : _("""The analytic account group this account belongs to."""),
    'lino_xl.lib.ana.Group.ref' : _("""The unique reference."""),
    'lino_xl.lib.ana.AnaAccountInvoice.make_copy' : _("""The MakeCopy action."""),
    'lino_xl.lib.ana.MakeCopy' : _("""You can simplify manual recording of invoices using the ⁂ button which creates an invoice using an existing invoice as template."""),
    'lino_xl.lib.ana.MakeCopy.entry_date' : _("""The entry date of the invoice to create."""),
    'lino_xl.lib.ana.MakeCopy.partner' : _("""The partner of the invoice to create."""),
    'lino_xl.lib.ana.MakeCopy.subject' : _("""The subject of the invoice to create."""),
    'lino_xl.lib.ana.MakeCopy.your_ref' : _("""The “your reference” of the invoice to create."""),
    'lino_xl.lib.ana.MakeCopy.total_incl' : _("""The total amount of the invoice to create. Leave blank if you want to copy all rows."""),
    'lino_xl.lib.ana.MakeCopy.account' : _("""The general account to use for the item of the invoice if you specified a total amount."""),
    'lino_xl.lib.ana.MakeCopy.ana_account' : _("""The analytical account to use for the item of the invoice if you specified a total amount."""),
    'lino_xl.lib.assets.PartnerAsset' : _("""Django model used to represent a partner asset."""),
    'lino_xl.lib.bevat.Declaration' : _("""Django model to represent a Belgian VAT declaration."""),
    'lino_xl.lib.bevat.Declaration.write_intracom_statement' : _("""Generate an XML file for the intra-community statement attached to this VAT declaration."""),
    'lino_xl.lib.bevat.DeclarationFields' : _("""The list of fields in a VAT declaration."""),
    'lino_xl.lib.bevats.Declaration' : _("""Implements lino_xl.lib.vat.VatDeclaration."""),
    'lino_xl.lib.bevats.DeclarationFields' : _("""Implements lino_xl.lib.vat.DeclarationFields."""),
    'lino_xl.lib.blogs.Blog' : _("""The Django model to represent a blog."""),
    'lino_xl.lib.blogs.Entry' : _("""The Django model to represent a blog entry."""),
    'lino_xl.lib.blogs.Entry.pub_date' : _("""The publication date."""),
    'lino_xl.lib.blogs.Entry.user' : _("""The author."""),
    'lino_xl.lib.blogs.Entry.blog' : _("""The blog to which this entry belongs."""),
    'lino_xl.lib.cal.Event' : _("""The Django model that represents a calendar entry."""),
    'lino_xl.lib.cal.Event.start_date' : _("""The starting date of this calendar entry. May not be empty."""),
    'lino_xl.lib.cal.Event.end_date' : _("""The ending date of this calendar entry. Leave empty for same-day entries."""),
    'lino_xl.lib.cal.Event.start_time' : _("""The starting time. If this is empty, the entry is considered an all-day entry."""),
    'lino_xl.lib.cal.Event.end_time' : _("""The ending time. If this is before the starting time, and no ending date is given, Lino considers the entry to end the day after."""),
    'lino_xl.lib.cal.Event.summary' : _("""A one-line descriptive text."""),
    'lino_xl.lib.cal.Event.description' : _("""A longer descriptive text."""),
    'lino_xl.lib.cal.Event.user' : _("""The responsible user."""),
    'lino_xl.lib.cal.Event.assigned_to' : _("""Another user who is expected to take responsibility for this entry."""),
    'lino_xl.lib.cal.Event.event_type' : _("""The type of this calendar entry."""),
    'lino_xl.lib.cal.Event.state' : _("""The state of this entry. The state can change according to rules defined by the workflow."""),
    'lino_xl.lib.cal.Event.owner' : _("""The event generator that generated and controls this calendar entry."""),
    'lino_xl.lib.cal.Event.transparent' : _("""Whether this entry should allow other entries at the same time."""),
    'lino_xl.lib.cal.Event.guests_edited' : _("""Whether the guests list of this event has been modified by an end user."""),
    'lino_xl.lib.cal.Event.when_text' : _("""Shows the start date and time of the calendar entry."""),
    'lino_xl.lib.cal.Event.when_html' : _("""Shows the date and time of the calendar entry with a link that opens all entries on that day."""),
    'lino_xl.lib.cal.Event.show_conflicting' : _("""A ShowSlaveTable button which opens the ConflictingEvents table for this event."""),
    'lino_xl.lib.cal.Event.notify_before' : _("""The multiples of a time unit (notify_unit) before which to send a notification to the corresponding user."""),
    'lino_xl.lib.cal.Event.notify_unit' : _("""The unit of time to compute before sending a notification. Example values are: minute, hour, day, week et cetera."""),
    'lino_xl.lib.cal.Event.notified' : _("""Stores a boolean value as an indication of whether the user has been notified or NOT."""),
    'lino_xl.lib.cal.Event.update_guests' : _("""Populate or update the list of participants for this calendar entry according to the suggestions."""),
    'lino_xl.lib.cal.Event.update_events' : _("""Create or update all other automatic calendar entries of this series."""),
    'lino_xl.lib.cal.Event.show_today' : _("""Show all calendar entries today."""),
    'lino_xl.lib.cal.Event.get_conflicting_events' : _("""Return a QuerySet of calendar entries that conflict with this one. Must work also when called on an unsaved instance. May return None to indicate an empty queryset. Applications may override this to add specific conditions."""),
    'lino_xl.lib.cal.Event.has_conflicting_events' : _("""Whether this entry has any conflicting entries."""),
    'lino_xl.lib.cal.Event.suggest_guests' : _("""Yield the list of unsaved Guest instances to be added to this calendar entry."""),
    'lino_xl.lib.cal.Event.get_event_summary' : _("""How this event should be summarized in contexts where possibly another user is looking (i.e. currently in invitations of guests, or in the extensible calendar panel)."""),
    'lino_xl.lib.cal.Event.before_ui_save' : _("""Mark the entry as “user modified” by setting a default state. This is important because EventGenerators may not modify any user-modified Events."""),
    'lino_xl.lib.cal.Event.auto_type_changed' : _("""Called when the number of this automatically generated entry (auto_type ) has changed."""),
    'lino_xl.lib.cal.Event._get_calendar' : _("""Returns the Calendar which contains this entry, or None if no subscription is found."""),
    'lino_xl.lib.cal.EntryRepeater.repeater' : _("""The calendar entry from which this repeater has been created."""),
    'lino_xl.lib.cal.EntryStates' : _("""The list of possible states of a calendar entry."""),
    'lino_xl.lib.cal.EntryState' : _("""Every calendar entry state is an instance of this and has some attributes."""),
    'lino_xl.lib.cal.EntryState.fill_guests' : _("""Whether the presences of an entry in this state are filled in automatically. If this is True (and if the entry type’s fill_presences is True as well), the presences cannot be modified manually by the used."""),
    'lino_xl.lib.cal.EntryState.guest_state' : _("""Force the given guest state for all guests when an entry is set to this state and when EventType.force_guest_states is True."""),
    'lino_xl.lib.cal.EntryState.transparent' : _("""Whether an entry in this state is considered transparent, i.e. dos not conflict with other entries at the same moment."""),
    'lino_xl.lib.cal.EntryState.fixed' : _("""Whether an entry in this state is considered “stable” when differentiating between “stable” and “pending” entries."""),
    'lino_xl.lib.cal.EntryState.noauto' : _("""Whether switching to this state will clear the entry’s auto_type field, i.e. it is no longer considered an automatically generated entry, IOW it “escapes” from its entry generator."""),
    'lino_xl.lib.cal.EntryState.edit_guests' : _("""Old name for fill_guests."""),
    'lino_xl.lib.cal.EventType' : _("""Django model representing a calendar entry type."""),
    'lino_xl.lib.cal.EventType.default_duration' : _("""An optional default duration for calendar entries of this type."""),
    'lino_xl.lib.cal.EventType.event_label' : _("""Default text for summary of new entries."""),
    'lino_xl.lib.cal.EventType.is_appointment' : _("""Whether entries of this type are considered “appointments” (i.e. whose time and place have been agreed upon with other users or external parties)."""),
    'lino_xl.lib.cal.EventType.max_days' : _("""The maximal number of days allowed as duration. 0 means no limit."""),
    'lino_xl.lib.cal.EventType.locks_user' : _("""Whether calendar entries of this type make the user unavailable for other locking events at the same time."""),
    'lino_xl.lib.cal.EventType.max_conflicting' : _("""How many conflicting events should be tolerated."""),
    'lino_xl.lib.cal.EventType.transparent' : _("""Allow entries of this type to conflict with other events."""),
    'lino_xl.lib.cal.EventType.force_guest_states' : _("""Whether presence states should be forced to those defined by the entry state."""),
    'lino_xl.lib.cal.EventType.fill_presences' : _("""Whether guests should be automatically filled for calendar entries of this type."""),
    'lino_xl.lib.cal.EventType.fill_guests' : _("""Planned name for fill_presences."""),
    'lino_xl.lib.cal.EventTypes' : _("""The list of entry types defined on this site."""),
    'lino_xl.lib.cal.Calendar' : _("""The django model representing a calendar."""),
    'lino_xl.lib.cal.Calendar.name' : _("""A babel field containing the designation of the calendar."""),
    'lino_xl.lib.cal.Calendar.description' : _("""A multi-line description of the calendar."""),
    'lino_xl.lib.cal.Calendar.color' : _("""The color to use for entries of this calendar (in lino_xl.lib.extensible)."""),
    'lino_xl.lib.cal.EventGenerator' : _("""Base class for things that generate a series of events."""),
    'lino_xl.lib.cal.EventGenerator.update_all_guests' : _("""Update the presence lists of all calendar events generated by this."""),
    'lino_xl.lib.cal.EventGenerator.do_update_events' : _("""Create or update the automatic calendar entries controlled by this generator."""),
    'lino_xl.lib.cal.EventGenerator.get_wanted_auto_events' : _("""Return a tuple of (wanted, unwanted), where wanted is a list of calendar entries to be saved, and unwanted a list of events to be deleted."""),
    'lino_xl.lib.cal.EventGenerator.care_about_conflicts' : _("""Whether this event generator should try to resolve conflicts for the given calendar entry we (in resolve_conflicts())"""),
    'lino_xl.lib.cal.EventGenerator.resolve_conflicts' : _("""Check whether given entry we conflicts with other entries and move it to a new date if necessary. Returns (a) the entry’s start_date if there is no conflict, (b) the next available alternative date if the entry conflicts with other existing entries and should be moved, or (c) None if there are conflicts but no alternative date could be found."""),
    'lino_xl.lib.cal.UpdateEntries' : _("""Generate or update the automatic events controlled by this object."""),
    'lino_xl.lib.cal.UpdateEntriesByEvent' : _("""Update all events of this series."""),
    'lino_xl.lib.cal.NotifyBeforeUnits' : _("""The list of choices for Event.notify_unit."""),
    'lino_xl.lib.cal.ShowEntriesByDay' : _("""Show all calendar events of the same day."""),
    'lino_xl.lib.cal.Guest' : _("""The Django model representing a guest."""),
    'lino_xl.lib.cal.Guest.event' : _("""The calendar event to which this presence applies."""),
    'lino_xl.lib.cal.Guest.partner' : _("""The partner to which this presence applies."""),
    'lino_xl.lib.cal.Guest.role' : _("""The role of this partner in this presence."""),
    'lino_xl.lib.cal.Guest.state' : _("""The state of this presence. See GuestStates."""),
    'lino_xl.lib.cal.Guest.waiting_since' : _("""Time when the visitor arrived (checked in)."""),
    'lino_xl.lib.cal.Guest.busy_since' : _("""Time when the visitor was received by agent."""),
    'lino_xl.lib.cal.Guest.gone_since' : _("""Time when the visitor left (checked out)."""),
    'lino_xl.lib.cal.GuestRole' : _("""The role of a guest expresses what the partner is going to do there."""),
    'lino_xl.lib.cal.GuestRoles' : _("""Global table of guest roles."""),
    'lino_xl.lib.cal.GuestState' : _("""The current state of a guest."""),
    'lino_xl.lib.cal.GuestStates' : _("""Global choicelist of possible guest states."""),
    'lino_xl.lib.cal.UpdateGuests' : _("""See Event.update_guests()."""),
    'lino_xl.lib.cal.UpdateAllGuests' : _("""See EventGenerator.update_all_guests()."""),
    'lino_xl.lib.cal.RemoteCalendar' : _("""Django model for representing a remote calendar."""),
    'lino_xl.lib.cal.Room' : _("""Django model for representing a room."""),
    'lino_xl.lib.cal.Room.name' : _("""The designation of the room. This is not required to be unique."""),
    'lino_xl.lib.cal.Room.display_color' : _("""The color to use when displaying entries in this room in the calendar view."""),
    'lino_xl.lib.cal.Rooms' : _("""Base class for all list of rooms."""),
    'lino_xl.lib.cal.AllRooms' : _("""Show a list of all rooms."""),
    'lino_xl.lib.cal.RoomDetail' : _("""The detail layout for Rooms and subclasses."""),
    'lino_xl.lib.cal.BaseSubscription.calendar' : _("""Pointer to the Calendar for the BaseSubscription."""),
    'lino_xl.lib.cal.BaseSubscription.is_hidden' : _("""Whether this subscription should initially be displayed as a hidden calendar."""),
    'lino_xl.lib.cal.Subscription' : _("""Django model for representing a subscription."""),
    'lino_xl.lib.cal.Task' : _("""Django model for representing a subscription."""),
    'lino_xl.lib.cal.Task.priority' : _("""How urgent this task is."""),
    'lino_xl.lib.cal.Task.state' : _("""The state of this Task. one of TaskStates."""),
    'lino_xl.lib.cal.TaskStates' : _("""Possible values for the state of a Task. The list of choices for the Task.state field."""),
    'lino_xl.lib.cal.Tasks' : _("""Global table of all tasks for all users."""),
    'lino_xl.lib.cal.TasksByUser' : _("""Shows the list of tasks for this user."""),
    'lino_xl.lib.cal.MyTasks' : _("""Shows my tasks whose start date is today or in the future."""),
    'lino_xl.lib.cal.EventPolicy' : _("""Django model used to store a recurrency policy."""),
    'lino_xl.lib.cal.EventPolicy.event_type' : _("""Generated calendar entries will have this type."""),
    'lino_xl.lib.cal.EventPolicies' : _("""Global table of all possible recurrency policies."""),
    'lino_xl.lib.cal.RecurrentEvent' : _("""Django model used to store a recurrent event."""),
    'lino_xl.lib.cal.RecurrentEvent.name' : _("""See lino.utils.mldbc.mixins.BabelNamed.name."""),
    'lino_xl.lib.cal.RecurrentEvent.every_unit' : _("""Inherited from RecurrenceSet.every_unit."""),
    'lino_xl.lib.cal.RecurrentEvent.care_about_conflicts' : _("""Recurrent events don’t care about conflicts. A holiday won’t move just because some other event has been created before on that date."""),
    'lino_xl.lib.cal.RecurrentEvents' : _("""The list of all recurrent events (RecurrentEvent)."""),
    'lino_xl.lib.cal.Events' : _("""Table which shows all calendar events."""),
    'lino_xl.lib.cal.Events.show_appointments' : _("""Whether only appointments should be shown. “Yes” means only appointments, “No” means no appointments and leaving it to blank shows both types of events."""),
    'lino_xl.lib.cal.Events.presence_guest' : _("""Show only entries that have a presence for the specified guest."""),
    'lino_xl.lib.cal.Events.project' : _("""Show only entries assigned to this project, where project is defined by lino.core.site.Site.project_model."""),
    'lino_xl.lib.cal.Events.assigned_to' : _("""Show only entries assigned to this user."""),
    'lino_xl.lib.cal.Events.event_type' : _("""Show only entries having this type."""),
    'lino_xl.lib.cal.Events.state' : _("""Show only entries having this state."""),
    'lino_xl.lib.cal.Events.user' : _("""Show only entries having this user as author."""),
    'lino_xl.lib.cal.ConflictingEvents' : _("""Shows events conflicting with this one (the master)."""),
    'lino_xl.lib.cal.EntriesByDay' : _("""This table is usually labelled “Appointments today”. It has no “date” column because it shows events of a given date.It is ordred with increasing times."""),
    'lino_xl.lib.cal.EntriesByRoom' : _("""Displays the calendar entries at a given Room."""),
    'lino_xl.lib.cal.EntriesByController' : _("""Shows the calendar entries controlled by this database object."""),
    'lino_xl.lib.cal.OneEvent' : _("""Show a single calendar event."""),
    'lino_xl.lib.cal.MyEntries' : _("""Shows the appointments for which I am responsible."""),
    'lino_xl.lib.cal.MyEntriesToday' : _("""Like MyEntries, but only today."""),
    'lino_xl.lib.cal.MyAssignedEvents' : _("""Shows the calendar entries that are assigned to me."""),
    'lino_xl.lib.cal.OverdueAppointments' : _("""Shows overdue appointments, i.e. appointments that happened before today and are still in a nonstable state."""),
    'lino_xl.lib.cal.MyOverdueAppointments' : _("""Like OverdueAppointments, but only for myself."""),
    'lino_xl.lib.cal.MyUnconfirmedAppointments' : _("""Shows my appointments in the near future which are in suggested or draft state."""),
    'lino_xl.lib.cal.Guests' : _("""The default table of presences."""),
    'lino_xl.lib.cal.MyPresences' : _("""Shows all my presences in calendar events, independently of their state."""),
    'lino_xl.lib.cal.MyPendingPresences' : _("""Received invitations waiting for my feedback (accept or reject)."""),
    'lino_xl.lib.cal.GuestsByPartner' : _("""Show the calendar entries having this partner as a guest."""),
    'lino_xl.lib.cal.EntriesByGuest' : _("""Show the calendar entries having this partner as a guest."""),
    'lino_xl.lib.cal.Reservation' : _("""Base class for lino_xl.lib.rooms.models.Booking and lino.modlib.courses.models.Course."""),
    'lino_xl.lib.cal.Reservation.max_date' : _("""Don’t generate calendar entries beyond this date."""),
    'lino_xl.lib.cal.AccessClasses' : _("""The sitewide list of access classes."""),
    'lino_xl.lib.cal.Component' : _("""Model mixin inherited by both Event and Task."""),
    'lino_xl.lib.cal.Component.auto_type' : _("""Contains the sequence number if this is an automatically generated component. Otherwise this field is empty."""),
    'lino_xl.lib.cal.ConflictingEventsChecker' : _("""Check whether this entry conflicts with other events."""),
    'lino_xl.lib.cal.ObsoleteEventTypeChecker' : _("""Check whether the type of this calendar entry should be updated."""),
    'lino_xl.lib.cal.LongEntryChecker' : _("""Check for entries which last longer than the maximum number of days allowed by their type."""),
    'lino_xl.lib.cal.EventGuestChecker' : _("""Check for calendar entries without participants."""),
    'lino_xl.lib.cal.CalendarReader' : _("""Can read public calendar entries. This is a kind of minimal calendar functionality that can be given to anonymous users, as done e.g. by vilma."""),
    'lino_xl.lib.cal.GuestOperator' : _("""Can see presences and guests of a calendar entry."""),
    'lino_xl.lib.cal.GuestUser' : _("""Can manage presences."""),
    'lino_xl.lib.cars.Car' : _("""Django model used to represent a car."""),
    'lino_xl.lib.cars.Brand' : _("""Django model used to represent a brand."""),
    'lino_xl.lib.contacts.Partner' : _("""The database model used to represent a business partner."""),
    'lino_xl.lib.contacts.Partner.name' : _("""The full name of this partner."""),
    'lino_xl.lib.contacts.Partner.prefix' : _("""An optional name prefix. For organisations this is inserted before the name, for persons this is inserted between first name and last name."""),
    'lino_xl.lib.contacts.Partner.email' : _("""The primary email address."""),
    'lino_xl.lib.contacts.Partner.phone' : _("""The primary phone number."""),
    'lino_xl.lib.contacts.Partner.gsm' : _("""The primary mobile phone number."""),
    'lino_xl.lib.contacts.Partner.language' : _("""The language to use when communicating with this partner."""),
    'lino_xl.lib.contacts.Partner.purchase_account' : _("""The general account to suggest as default value in purchase invoices from this partner."""),
    'lino_xl.lib.contacts.Partner.vat_regime' : _("""The default VAT regime to use on invoices for this partner."""),
    'lino_xl.lib.contacts.Partner.vat_id' : _("""The national VAT identification number of this partner."""),
    'lino_xl.lib.contacts.Partner.partner_ref' : _("""How this partner refers to us."""),
    'lino_xl.lib.contacts.Partners.detail_layout' : _("""The detail layout of the Partners table is not set by default. Especially accounting applications will set it to 'contacts.PartnerDetail'."""),
    'lino_xl.lib.contacts.Person' : _("""The database model used to represent a person."""),
    'lino_xl.lib.contacts.Person.name' : _("""See Partner.name."""),
    'lino_xl.lib.contacts.Persons' : _("""Shows all persons."""),
    'lino_xl.lib.contacts.Company' : _("""The database model used to represent an organization."""),
    'lino_xl.lib.contacts.Company.type' : _("""Pointer to the CompanyType."""),
    'lino_xl.lib.contacts.Company.get_signers' : _("""Return an iterable over the contact persons who can sign business documents (i.e. exercise a signer function) for this organization."""),
    'lino_xl.lib.contacts.Companies' : _("""Base table for all tables on organizations."""),
    'lino_xl.lib.contacts.Role' : _("""The database model used to represent a contact person."""),
    'lino_xl.lib.contacts.Role.company' : _("""The organization where this person has this role."""),
    'lino_xl.lib.contacts.Role.type' : _("""The function of this person in this organization."""),
    'lino_xl.lib.contacts.Role.person' : _("""The person having this role in this organization."""),
    'lino_xl.lib.contacts.Role.start_date' : _("""When this person started to exercise this function in this organization."""),
    'lino_xl.lib.contacts.Role.end_date' : _("""When this person stopped to exercise this function in this organization."""),
    'lino_xl.lib.contacts.RoleType' : _("""The database model used to represent a contact function."""),
    'lino_xl.lib.contacts.RoleType.name' : _("""A translatable designation. Used e.g. in document templates for contracts."""),
    'lino_xl.lib.contacts.RoleType.can_sign' : _("""Whether this is a signer function."""),
    'lino_xl.lib.contacts.PartnerRelated' : _("""Abstract model mixin for things that are related to one and only one partner."""),
    'lino_xl.lib.contacts.PartnerRelated.partner' : _("""The recipient of this document. This can be a person, an organization or any type of business partner."""),
    'lino_xl.lib.contacts.PartnerRelated.recipient' : _("""Alias for the partner"""),
    'lino_xl.lib.contacts.ExportVCardFile' : _("""Download all records as a .vcf file which you can import to another contacts application."""),
    'lino_xl.lib.contacts.SimpleContactsUser' : _("""A user who has access to basic contacts functionality."""),
    'lino_xl.lib.contacts.ContactsUser' : _("""A user who has access to full contacts functionality."""),
    'lino_xl.lib.contacts.ContactsStaff' : _("""A user who can configure contacts functionality."""),
    'lino_xl.lib.contacts.PartnerEvents' : _("""A choicelist of observable partner events."""),
    'lino_xl.lib.contacts.PartnerEvents.has_open_movements' : _("""See has_open_movements in xl.specs.accounting. This choice exists only when lino_xl.lib.accounting is installed."""),
    'lino_xl.lib.contacts.CompanyType' : _("""A type of organization. Used by Company.type field."""),
    'lino_xl.lib.contacts.ContactRelated' : _("""Model mixin for things that relate to either a private person or a company, the latter potentially represented by a contact person having a given role in that company. Typical usages are invoices or contracts."""),
    'lino_xl.lib.contacts.ContactRelated.company' : _("""Pointer to Company."""),
    'lino_xl.lib.contacts.ContactRelated.contact_person' : _("""Pointer to Person."""),
    'lino_xl.lib.contacts.ContactRelated.contact_role' : _("""The optional Role of the contact_person within company."""),
    'lino_xl.lib.contacts.ContactRelated.partner' : _("""(Virtual field) The “legal partner”, i.e. usually the company, except when that field is empty, in which case partner contains the contact_person. If both fields are empty, then partner contains None."""),
    'lino_xl.lib.contacts.ContactRelated.recipient' : _("""(Virtual field) The Addressable object to use when printing a postal address for this. This is typically either the company or contact_person (if one of these fields is non-empty). It may also be a lino_xl.lib.contacts.models.Role object."""),
    'lino_xl.lib.contacts.PartnerDocument' : _("""Deprecated. Adds two fields ‘partner’ and ‘person’ to this model, making it something that refers to a “partner”. person means a “contact person” for the partner."""),
    'lino_xl.lib.contacts.CivilStates' : _("""The global list of civil states that a person can have. The field pointing to this list is usually named civil_state."""),
    'lino_xl.lib.contacts.CivilStates.single' : _("""célibataire : vous n’avez pas de partenaire auquel vous êtes officiellement lié"""),
    'lino_xl.lib.contacts.CivilStates.married' : _("""marié(e) : vous êtes légalement marié"""),
    'lino_xl.lib.contacts.CivilStates.widowed' : _("""veuf (veuve) / Verwitwet : vous êtes légalement marié mais votre partenaire est décédé"""),
    'lino_xl.lib.contacts.CivilStates.divorced' : _("""divorcé(e) (Geschieden) : votre mariage a été juridiquement dissolu"""),
    'lino_xl.lib.contacts.CivilStates.de_facto_separated' : _("""De facto separated (Séparé de fait, faktisch getrennt)"""),
    'lino_xl.lib.contacts.CivilStates.separated' : _("""Legally separated, aka “Separated as to property” (Séparé de corps et de biens, Getrennt von Tisch und Bett)"""),
    'lino_xl.lib.contacts.CivilStates.cohabitating' : _("""Cohabitating (cohabitant, zusammenlebend)"""),
    'lino_xl.lib.courses.Course' : _("""Django database model to represent an activity."""),
    'lino_xl.lib.courses.Course.max_date' : _("""Don’t generate meeting having their start date beyond this date."""),
    'lino_xl.lib.courses.Course.enrolments_until' : _("""Until when new enrolments are accepted."""),
    'lino_xl.lib.courses.Course.max_places' : _("""Available places. The maximum number of participants to allow in this activity."""),
    'lino_xl.lib.courses.Course.free_places' : _("""Number of free places."""),
    'lino_xl.lib.courses.Course.requested' : _("""Number of requested places."""),
    'lino_xl.lib.courses.Course.trying' : _("""Number of trying places."""),
    'lino_xl.lib.courses.Course.confirmed' : _("""Number of confirmed places."""),
    'lino_xl.lib.courses.Course.get_detail_action' : _("""Custom get_detail_action because the detail_layout to use depends on the activity layout, which is given by the Line.course_area field of the activity’s line."""),
    'lino_xl.lib.courses.Courses' : _("""Base table for all activities."""),
    'lino_xl.lib.courses.Courses.show_exposed' : _("""Whether to show or to hide courses in an exposed state."""),
    'lino_xl.lib.courses.MyActivities' : _("""Show the courses authored by me (i.e. where I am the responsible manager). Compare MyCoursesGiven."""),
    'lino_xl.lib.courses.MyCoursesGiven' : _("""Show the courses given by me (i.e. where I am the teacher). Compare MyActivities."""),
    'lino_xl.lib.courses.ActivitiesByLine' : _("""Show the courses per course line."""),
    'lino_xl.lib.courses.ActivitiesByTopic' : _("""Shows the courses of a given topic."""),
    'lino_xl.lib.courses.Enrolment' : _("""Django database model to represent an activity enrolment."""),
    'lino_xl.lib.courses.Enrolment.state' : _("""One of lino_xl.lib.courses.EnrolmentStates."""),
    'lino_xl.lib.courses.Enrolment.pupil_info' : _("""Virtual HtmlBox field showing the name and address of the participant."""),
    'lino_xl.lib.courses.Enrolments' : _("""Base class for all tables that show Enrolment."""),
    'lino_xl.lib.courses.AllEnrolments' : _("""Show global list of all enrolments."""),
    'lino_xl.lib.courses.PendingRequestedEnrolments' : _("""Show all requested enrolments."""),
    'lino_xl.lib.courses.PendingConfirmedEnrolments' : _("""Show all confirmed enrolments."""),
    'lino_xl.lib.courses.EnrolmentsByPupil' : _("""Show all enrolments of a given pupil."""),
    'lino_xl.lib.courses.EnrolmentsByCourse' : _("""Show the enrolments of a course."""),
    'lino_xl.lib.courses.EnrolmentStates' : _("""The list of possible states of an enrolment."""),
    'lino_xl.lib.courses.EnrolmentStates.cancelled' : _("""The enrolment was cancelled before it even started."""),
    'lino_xl.lib.courses.EnrolmentStates.ended' : _("""The enrolment was was successfully ended."""),
    'lino_xl.lib.courses.EnrolmentStates.abandoned' : _("""The enrolment was abandoned."""),
    'lino_xl.lib.courses.Line' : _("""Django database model to represent an activity line."""),
    'lino_xl.lib.courses.Line.name' : _("""The designation of this activity line as seen by the user e.g. when selecting the line."""),
    'lino_xl.lib.courses.Line.excerpt_title' : _("""The text to print as title in enrolments."""),
    'lino_xl.lib.courses.Line.body_template' : _("""The body template to use when printing an activity of this line. Leave empty to use the site’s default (defined by body_template on the lino_xl.lib.excerpts.models.ExcerptType for Course)"""),
    'lino_xl.lib.courses.Line.course_area' : _("""Pointer to ActivityLayouts. This is used only when an application defines several variants of EnrolmentsByPupil."""),
    'lino_xl.lib.courses.ActivityLayouts' : _("""The global choicelist of activity layouts. Every choice is an instance of ActivityLayout."""),
    'lino_xl.lib.courses.ActivityLayout.text' : _("""The translatable designation used as menu label."""),
    'lino_xl.lib.courses.ActivityLayout.courses_table' : _("""Which table to use for showing activities having this layout."""),
    'lino_xl.lib.courses.Plugin' : _("""The value to use as quick_search_fields for Enrolment."""),
    'lino_xl.lib.eevat.DeclarationFields' : _("""The list of fields in a VAT declaration."""),
    'lino_xl.lib.finan.PaymentOrder' : _("""Django model to represent a payment order."""),
    'lino_xl.lib.finan.PaymentOrder.write_xml' : _("""Write the XML file for the SEPA payment initiation from this payment order."""),
    'lino_xl.lib.finan.PaymentOrder.entry_date' : _("""The date of the ledger entry."""),
    'lino_xl.lib.finan.PaymentOrder.execution_date' : _("""The execution date of payment order. If this is empty, Lino assumes the entry_date when writing the pain_001.xml file."""),
    'lino_xl.lib.finan.PaymentOrder.total' : _("""The total amount. This is automatically computed when you register de voucher."""),
    'lino_xl.lib.finan.PaymentOrderItem' : _("""Django model to represent an individual item of a payment order."""),
    'lino_xl.lib.finan.PaymentOrders' : _("""The base table of all tables on PaymentOrder."""),
    'lino_xl.lib.finan.BankStatement' : _("""Django model to represent a bank statement."""),
    'lino_xl.lib.finan.BankStatement.balance1' : _("""The old (or start) balance."""),
    'lino_xl.lib.finan.BankStatement.balance2' : _("""The new (or end) balance."""),
    'lino_xl.lib.finan.BankStatementItem' : _("""Django model to represent an individual item of a bank statement."""),
    'lino_xl.lib.finan.BankStatements' : _("""The base table of all tables on BankStatement."""),
    'lino_xl.lib.finan.ItemsByBankStatement' : _("""Shows the items of a bank statement."""),
    'lino_xl.lib.finan.JournalEntry' : _("""Django model to represent a journal entry."""),
    'lino_xl.lib.finan.JournalEntryItem' : _("""Django model to represent an individual item of a journal entry."""),
    'lino_xl.lib.finan.JournalEntries' : _("""The base table of all tables on JournalEntry."""),
    'lino_xl.lib.finan.ItemsByJournalEntry' : _("""Shows the items of a journal entry."""),
    'lino_xl.lib.finan.FinancialVoucher' : _("""Base class for all financial vouchers."""),
    'lino_xl.lib.finan.FinancialVoucher.item_account' : _("""The default value to use when FinancialVoucherItem.account of an item is empty."""),
    'lino_xl.lib.finan.FinancialVoucher.item_remark' : _("""The default value to use when FinancialVoucherItem.remark of an item is empty."""),
    'lino_xl.lib.finan.FinancialVoucherItem' : _("""The base class for the items of all types of financial vouchers (FinancialVoucher)."""),
    'lino_xl.lib.finan.FinancialVoucherItem.account' : _("""The general account to be used in the primary booking. If this is empty, use item_account of the voucher."""),
    'lino_xl.lib.finan.FinancialVoucherItem.project' : _("""The “project” related to this transaction. For example in Lino Welfare this is the client."""),
    'lino_xl.lib.finan.FinancialVoucherItem.partner' : _("""The partner account to be used in the primary booking."""),
    'lino_xl.lib.finan.FinancialVoucherItem.amount' : _("""The amount to be booked. If this is empty, then the voucher cannot be registered."""),
    'lino_xl.lib.finan.FinancialVoucherItem.dc' : _("""The direction of the primary booking to create."""),
    'lino_xl.lib.finan.FinancialVoucherItem.remark' : _("""External reference. The description of this transation as seen by the external partner."""),
    'lino_xl.lib.finan.FinancialVoucherItem.match' : _("""An arbitrary string used to group several movements."""),
    'lino_xl.lib.finan.DatedFinancialVoucher' : _("""A FinancialVoucher whose items have a date field."""),
    'lino_xl.lib.finan.DatedFinancialVoucherItem' : _("""A FinancialVoucherItem with an additional date field."""),
    'lino_xl.lib.finan.DatedFinancialVoucherItem.date' : _("""The value date of this item."""),
    'lino_xl.lib.finan.Plugin' : _("""This Plugin class adds some entries to the Explorer menu. It contains the following additional attributes:"""),
    'lino_xl.lib.finan.Plugin.suggest_future_vouchers' : _("""Whether to suggest vouchers whose due_date is in the future."""),
    'lino_xl.lib.finan.FinancialVouchers' : _("""Base class for the default tables of all financial voucher types (JournalEntries , PaymentOrders and BankStatements)."""),
    'lino_xl.lib.finan.ItemsByVoucher' : _("""The base table of all tables which display the items of a given voucher."""),
    'lino_xl.lib.finan.SuggestionsByVoucher' : _("""Shows the suggested items for a given voucher, with a button to fill them into the current voucher."""),
    'lino_xl.lib.finan.SuggestionsByJournalEntry' : _("""A SuggestionsByVoucher table for a JournalEntry."""),
    'lino_xl.lib.finan.SuggestionsByPaymentOrder' : _("""A SuggestionsByVoucher table for a PaymentOrder."""),
    'lino_xl.lib.finan.SuggestionsByBankStatement' : _("""A SuggestionsByVoucher table for a BankStatement."""),
    'lino_xl.lib.finan.SuggestionsByVoucherItem' : _("""Displays the payment suggestions for a given voucher item, with a button to fill them into the current item (creating additional items if more than one suggestion was selected)."""),
    'lino_xl.lib.finan.SuggestionsByPaymentOrderItem' : _("""A SuggestionsByVoucherItem table for a PaymentOrderItem."""),
    'lino_xl.lib.finan.SuggestionsByBankStatementItem' : _("""A SuggestionsByVoucherItem table for a BankStatementItem."""),
    'lino_xl.lib.finan.ShowSuggestions' : _("""Show suggested items for this voucher."""),
    'lino_xl.lib.finan.FillSuggestionsToVoucher' : _("""Fill selected suggestions from a SuggestionsByVoucher table into a financial voucher."""),
    'lino_xl.lib.finan.FillSuggestionsToVoucherItem' : _("""Fill the selected suggestions as items to the voucher. The first selected suggestion does not create a new item but replaces the item for which it was called."""),
    'lino_xl.lib.google.AccessLockable' : _("""A model mixin to lock access to the database object (on each database query), allowing only one transaction to such objects."""),
    'lino_xl.lib.google.AccessLockable.unlock_all' : _("""Unlocks all database objects."""),
    'lino_xl.lib.google.AccessLockable.unlock_objects' : _("""Given a list of pk(s) it unlocks them at the database level."""),
    'lino_xl.lib.google.AccessLockable.get_locked_objects_pk' : _("""Returns a list of pk(s) of the currently locked objects."""),
    'lino_xl.lib.google.AccessLockable._force_get' : _("""Given a pk it returns a locked database object. Use this method only for troubleshooting."""),
    'lino_xl.lib.google.SyncToken' : _("""A model mixin inherits from AccessLockable and UserAuthored."""),
    'lino_xl.lib.google.SyncToken.sync_token' : _("""A CharField to store nextSyncToken retrieved from Google API call."""),
    'lino_xl.lib.google.SyncToken.page_token' : _("""A CharField to store nextPageToken retrieved from Google API call."""),
    'lino_xl.lib.google.GoogleSynchronized' : _("""Google’s related database models inherits from this mixin."""),
    'lino_xl.lib.google.GoogleSynchronized.google_id' : _("""Used in making reference to the object stored in Google’s database."""),
    'lino_xl.lib.google.GoogleSynchronized.synchronize_with_google' : _("""Decides whether the entry is synchronizable with Google."""),
    'lino_xl.lib.google.GoogleCalendarSynchronized' : _("""A subclass of GoogleSynchronized."""),
    'lino_xl.lib.google.GoogleCalendarSynchronized.modified' : _("""Keeps the timestamp of the last modification of the Calendar as an entry."""),
    'lino_xl.lib.google.GoogleCalendarSynchronized.insert_or_update_into_google' : _("""Insert or updates the calendar entry with google."""),
    'lino_xl.lib.google.GoogleCalendarSynchronized.get_outward_insert_update_queryset' : _("""This method returns a queryset of Calendar that are not stored in Google or should be updated."""),
    'lino_xl.lib.google.GoogleCalendarSynchronized.delete_google_calendar' : _("""This method deletes a Calendar at sync time when the calendar is deleted from the Google calendar."""),
    'lino_xl.lib.google.GoogleCalendarSynchronized.sync_deleted_records' : _("""Deletes calendars by looking at DeletedEntry from Google calendar."""),
    'lino_xl.lib.google.GoogleCalendarSynchronized.insert_or_update_google_calendar' : _("""Inserts or updates a calendar entry and the default Room."""),
    'lino_xl.lib.google.GoogleCalendarEventSynchronized' : _("""A subclass of GoogleSynchronized."""),
    'lino_xl.lib.google.GoogleCalendarEventSynchronized.delete_google_event' : _("""This method deletes a Event at sync time when the event is deleted from the Google calendar."""),
    'lino_xl.lib.google.GoogleCalendarEventSynchronized.sync_deleted_records' : _("""Deletes events by looking at DeletedEntry from Google calendar."""),
    'lino_xl.lib.google.GoogleCalendarEventSynchronized.get_outward_insert_update_queryset' : _("""This method yields Event (s) which are not stored in Google or should be updated."""),
    'lino_xl.lib.google.GoogleCalendarEventSynchronized.insert_or_update_into_google' : _("""Insert or updates the events into Google."""),
    'lino_xl.lib.google.GoogleCalendarEventSynchronized.insert_or_update_google_event' : _("""Inserts or updates a calendar entry and related Room and Guest ‘s."""),
    'lino_xl.lib.google.GoogleContactSynchronized' : _("""A subclass of GoogleSynchronized."""),
    'lino_xl.lib.google.GoogleContactSynchronized.delete_google_contact' : _("""This method deletes a Contact at sync time when the contact is deleted from Google."""),
    'lino_xl.lib.google.GoogleContactSynchronized.sync_deleted_records' : _("""Deletes contacts by looking at DeletedContact from Google."""),
    'lino_xl.lib.google.GoogleContactSynchronized.get_outward_insert_update_queryset' : _("""Returns contacts insertable or updatable into Google."""),
    'lino_xl.lib.google.GoogleContactSynchronized.insert_or_update_into_google' : _("""Insert or updates the contact into Google."""),
    'lino_xl.lib.google.GoogleContactSynchronized.insert_or_update_google_contact' : _("""Inserts or updates a contact Contact."""),
    'lino_xl.lib.google.AccessRoles' : _("""Keeps the choices for the type of access to a Google calendar."""),
    'lino_xl.lib.google.CalendarSubscription' : _("""A subclass of BaseSubscription."""),
    'lino_xl.lib.google.CalendarSubscription.primary' : _("""A boolean field which indicated whether calendar referenced in this subscription is the primary calendar for the user in Google."""),
    'lino_xl.lib.google.CalendarSubscription.access_role' : _("""User’s access role on the subscribed calendar."""),
    'lino_xl.lib.google.EventSyncToken' : _("""A subclass of SyncToken, stores necessary tokens to sync the events updated in a user’s google calendar."""),
    'lino_xl.lib.google.EventSyncToken.subscription' : _("""A ForeignKey pointing to a CalendarSubscription object."""),
    'lino_xl.lib.google.CalendarSyncToken' : _("""A subclass of SyncToken, store the necessary tokens to sync the calendars updated on a user’s google account."""),
    'lino_xl.lib.google.DeletedEntry' : _("""Keeps a record of the natively deleted Calendar or Event for deleting from Google when the next sync is run."""),
    'lino_xl.lib.google.DeletedEntry.calendar' : _("""A boolean field which says whether the deleted item is a Calendar if not it is an Event."""),
    'lino_xl.lib.google.DeletedEntry.event_id' : _("""Takes the value of the Event.google_id when the deleted record is an Event otherwise an empty string."""),
    'lino_xl.lib.google.DeletedEntry.calendar_id' : _("""Takes the value of the Calendar.google_id"""),
    'lino_xl.lib.google.Contact' : _("""Keeps a reference to a google contact."""),
    'lino_xl.lib.google.Contact.contact' : _("""A ForeignKey pointing to google.contacts_model."""),
    'lino_xl.lib.google.DeletedContact' : _("""Keeps meta information of a deleted contact to sync with google upon next synchronization."""),
    'lino_xl.lib.google.DeletedContact.contact_id' : _("""The google resourceName."""),
    'lino_xl.lib.google.ContactSyncToken' : _("""Stores the nextSyncToken and nextPageToken from google."""),
    'lino_xl.lib.google.SyncSummary' : _("""Database model to store the summaries of a Synchronizer.sync() session."""),
    'lino_xl.lib.google.SyncSummary.halted' : _("""A BooleanField indicate whether the sync session has failed."""),
    'lino_xl.lib.google.SyncSummary.stats' : _("""A TextField containing the textual representation of synchronization session statistics."""),
    'lino_xl.lib.google.FailedForeignItem' : _("""Database model to store the foreign objects failed to put into the local database."""),
    'lino_xl.lib.google.FailedForeignItem.job' : _("""A ForeignKey pointing to the corresponding SyncSummary."""),
    'lino_xl.lib.google.FailedForeignItem.value' : _("""A JSONField containing the actual remote object."""),
    'lino_xl.lib.google.FailedForeignItem.item_class' : _("""A ForeignKey pointing to the related database model (contenttypes.ContentType) specifying the item synchronization class."""),
    'lino_xl.lib.google.FailedEntries' : _("""A subclass of typing.NamedTuple. And has the following attributes."""),
    'lino_xl.lib.google.FailedEntries.calendars' : _("""Contains reference to the Calendar instance(s) that failed to sync with Google."""),
    'lino_xl.lib.google.FailedEntries.events' : _("""Contains reference to the Event instance(s) that failed to sync with Google."""),
    'lino_xl.lib.google.FailedEntries.contacts' : _("""Contains reference to the Contact instance(s) that failed to sync with Google."""),
    'lino_xl.lib.google.FailedEntries.foreign_item' : _("""Objects fetched from the remote and failed to update (/ put) on the local database."""),
    'lino_xl.lib.google.Synchronizer' : _("""The class that wraps the synchronization functionality."""),
    'lino_xl.lib.google.Synchronizer._failed_entries' : _("""Keeps reference to the database objects that failed to sync with google from the last sync() call."""),
    'lino_xl.lib.google.Synchronizer.failed_entries' : _("""Keeps reference to the database objects that failed to sync with google in the running sync() call."""),
    'lino_xl.lib.google.Synchronizer.user' : _("""The User, whose records should be synchronized."""),
    'lino_xl.lib.google.Synchronizer.setup' : _("""Sets up the user scope and initializes necessary data objects."""),
    'lino_xl.lib.google.Synchronizer.sync' : _("""Synchronizes latest changes with Google."""),
    'lino_xl.lib.invoicing.InvoicingTargetVoucher' : _("""Mixin for Django models that can be used as invoicing.voucher_model."""),
    'lino_xl.lib.invoicing.InvoicingTargetVoucher.invoicing_min_date' : _("""The start date of the period covered by this invoice."""),
    'lino_xl.lib.invoicing.InvoicingTargetVoucher.invoicing_max_date' : _("""The end date of the period covered by this invoice."""),
    'lino_xl.lib.invoicing.InvoicingTargetItem.invoiceable' : _("""A generic foreign key pointing to the generator that caused this item to be generated."""),
    'lino_xl.lib.invoicing.InvoiceGenerator' : _("""Mixin for Django models that represent an invoice generator."""),
    'lino_xl.lib.invoicing.InvoiceGenerator.default_invoiceable_qty' : _("""The default value to return by get_invoiceable_qty()."""),
    'lino_xl.lib.invoicing.InvoiceGenerator.get_wanted_invoice_items' : _("""Yield one or several invoice items generated by this object."""),
    'lino_xl.lib.invoicing.InvoiceGenerator.get_invoiceable_events' : _("""Return a Django query that represents the invoicing events."""),
    'lino_xl.lib.invoicing.InvoiceGenerator.get_invoiceable_event_formatter' : _("""Return a callable that formats an invoicing event as an HTML etree element."""),
    'lino_xl.lib.invoicing.InvoiceGenerator.get_generators_for_plan' : _("""Return a queryset of the database objects (of this model) that potentially will generate an invoice item."""),
    'lino_xl.lib.invoicing.InvoiceGenerator.get_invoiceable_partner' : _("""Return the invoiceable partner."""),
    'lino_xl.lib.invoicing.InvoiceGenerator.get_invoiceable_product' : _("""Return the product to put into the generated invoice item."""),
    'lino_xl.lib.invoicing.InvoiceGenerator.get_invoiceable_qty' : _("""Return the quantity to use for the generated invoice item."""),
    'lino_xl.lib.invoicing.InvoiceGenerator.get_invoiceable_title' : _("""Return the title to put into the generated invoice item."""),
    'lino_xl.lib.invoicing.InvoiceGenerator.invoicings' : _("""A GenericRelation to all invoice items pointing to this invoiceable."""),
    'lino_xl.lib.invoicing.InvoiceGenerator.get_invoicings' : _("""Get a queryset with the invoicings that point to this invoiceable."""),
    'lino_xl.lib.invoicing.InvoiceGenerator.get_last_invoicing' : _("""Return the last invoicing that was created by this generator. According to the invoice’s voucher_date."""),
    'lino_xl.lib.invoicing.InvoiceGenerator.allow_group_invoices' : _("""Whether this is a grouping generator, i.e. the invoicings of which can be grouped together with those of other invoice generators into a same invoice."""),
    'lino_xl.lib.invoicing.InvoicingInfo' : _("""A volatile object in memory that holds information about a given invoicing event."""),
    'lino_xl.lib.invoicing.InvoicingInfo.generator' : _("""The invoice generator this is about."""),
    'lino_xl.lib.invoicing.InvoicingInfo.max_date' : _("""The latest date of events considered when computing this."""),
    'lino_xl.lib.invoicing.InvoicingInfo.invoicings' : _("""Existing invoice items generated by this generator for earlier periods."""),
    'lino_xl.lib.invoicing.InvoicingInfo.invoiced_qty' : _("""Sum of quantities invoiced earlier."""),
    'lino_xl.lib.invoicing.InvoicingInfo.invoiced_events' : _("""Number of events invoiced earlier."""),
    'lino_xl.lib.invoicing.InvoicingInfo.used_events' : _("""A list of the “events” used for computing this."""),
    'lino_xl.lib.invoicing.InvoicingInfo.invoiceable_product' : _("""Which fee to apply. If this is None, no invoicing should get generated."""),
    'lino_xl.lib.invoicing.Tariff' : _("""The Django model used to represent a flatrate."""),
    'lino_xl.lib.invoicing.Tariff.number_of_events' : _("""Number of invoicing events paid per invoicing."""),
    'lino_xl.lib.invoicing.Tariff.min_asset' : _("""The minimum number of invoicing events a customer should pay in advance."""),
    'lino_xl.lib.invoicing.Tariff.max_asset' : _("""Maximum quantity of invoicing events to allow per invoicing."""),
    'lino_xl.lib.invoicing.Plan' : _("""The Django model used to represent an invoicing plan."""),
    'lino_xl.lib.invoicing.Plan.user' : _("""The user who owns this invoicing plan."""),
    'lino_xl.lib.invoicing.Plan.today' : _("""The date to be used for the invoices to generate."""),
    'lino_xl.lib.invoicing.Plan.invoicing_task' : _("""The invoicing task for which this plan is to generate invoices."""),
    'lino_xl.lib.invoicing.Plan.min_date' : _("""Don’t invoice events before this date. May be empty."""),
    'lino_xl.lib.invoicing.Plan.max_date' : _("""Don’t invoice events after this date. If this is empty, Lino will use the day before today."""),
    'lino_xl.lib.invoicing.Plan.partner' : _("""Generate only for this partner."""),
    'lino_xl.lib.invoicing.Plan.order' : _("""Generate only for this invoicing order."""),
    'lino_xl.lib.invoicing.Plan.update_plan' : _("""Update this plan (fill the list of suggestions)."""),
    'lino_xl.lib.invoicing.Plan.execute_plan' : _("""Execute this plan (create an invoice for each selected suggestion)."""),
    'lino_xl.lib.invoicing.Plan.start_plan' : _("""Start an invoicing plan for the given user on the database object defined by k and v. Where k is the name of the field used to select the plan (e.g. ‘partner’ or ‘journal’) and v is the value for that field."""),
    'lino_xl.lib.invoicing.Plan.fill_plan' : _("""Add items to this plan, one for each invoice to generate."""),
    'lino_xl.lib.invoicing.Item' : _("""The Django model used to represent a item of an invoicing plan."""),
    'lino_xl.lib.invoicing.Item.generator' : _("""The invoice generator that suggests this."""),
    'lino_xl.lib.invoicing.Item.preview' : _("""A textual preview of the invoiceable items to be included in the invoice."""),
    'lino_xl.lib.invoicing.Item.invoice' : _("""The invoice that has been generated. This field is empty for new items. When an item has been executed, this field points to the generated invoice."""),
    'lino_xl.lib.invoicing.StartInvoicing' : _("""Start an invoicing plan for the authenticated user."""),
    'lino_xl.lib.invoicing.StartInvoicingByArea' : _("""Start an invoicing plan for this area."""),
    'lino_xl.lib.invoicing.StartInvoicingForPartner' : _("""Start an invoicing plan for this partner."""),
    'lino_xl.lib.invoicing.StartInvoicingForOrder' : _("""Start an invoicing plan for this invoicing order."""),
    'lino_xl.lib.invoicing.ExecutePlan' : _("""Execute this invoicing plan."""),
    'lino_xl.lib.invoicing.ExecuteItem' : _("""Create an invoice for this invoicing suggestion."""),
    'lino_xl.lib.invoicing.ToggleSelection' : _("""Invert selection status for all invoicing suggestions."""),
    'lino_xl.lib.invoicing.Task' : _("""The Django model used to represent an invoicing task."""),
    'lino_xl.lib.invoicing.Task.procedure' : _("""For invoicing tasks, this is always run_invoicing_tasks."""),
    'lino_xl.lib.invoicing.Task.target_journal' : _("""The journal into which invoices are to be generated. Mandatory and unique."""),
    'lino_xl.lib.invoicing.FollowUpRule' : _("""The Django model used to represent an individual “follow-up rule” of an invoicing task."""),
    'lino_xl.lib.invoicing.FollowUpRule.invoice_generator' : _("""The invoice generator to ask for items to invoice."""),
    'lino_xl.lib.invoicing.FollowUpRule.source_journal' : _("""A journal to ask for items to invoice."""),
    'lino_xl.lib.mastodon.MastodonOAuth2' : _("""The backend for mastodon OAuth authentication methods."""),
    'lino_xl.lib.nicknames.Naming' : _("""Django model used to represent a nicknaming."""),
    'lino_xl.lib.nicknames.Naming.named' : _("""The nameable object being named."""),
    'lino_xl.lib.nicknames.Naming.user' : _("""The user who is using this niackname."""),
    'lino_xl.lib.nicknames.Naming.nickname' : _("""The nickname given"""),
    'lino_xl.lib.nicknames.Nameable' : _("""This model mixin adds the editable virtual field my_nickname"""),
    'lino_xl.lib.nicknames.Nameable.my_nickname' : _("""The nickname given to this database row by the current user."""),
    'lino_xl.lib.office.OfficeUser' : _("""Has access to office functionality like calendar, notes and uploads."""),
    'lino_xl.lib.office.OfficeOperator' : _("""Can manage office functionality for other users (but not for himself)."""),
    'lino_xl.lib.office.OfficeStaff' : _("""Can manage configuration of office functionality."""),
    'lino_xl.lib.peppol.Inbox' : _("""Shows the Peppol documents that were received and have not yet been processed."""),
    'lino_xl.lib.peppol.Archive' : _("""Shows the Peppol documents that were received and have been processed."""),
    'lino_xl.lib.peppol.Outbox' : _("""Shows the documents that have been sent to the Peppol network."""),
    'lino_xl.lib.peppol.PeppolPartner.send_peppol' : _("""Whether sales invoices and credit notes to this partner should be sent via the Peppol network."""),
    'lino_xl.lib.peppol.PeppolPartner.peppol_id' : _("""How this partner identifies themselves in the Peppol network. This is a string of style schemaID:value, where schemaID refers to a EAS."""),
    'lino_xl.lib.peppol.PeppolPartner.endpoint_id' : _("""A property that returns an EndpointID instance"""),
    'lino_xl.lib.peppol.PeppolJournal.is_outbound' : _("""Whether vouchers of this journal should be sent via the Peppol network."""),
    'lino_xl.lib.peppol.PeppolJournal.last_sending' : _("""The date of the latest invoice in this journal that has been sent via Peppol."""),
    'lino_xl.lib.peppol.EndpointID' : _("""A lightweight Python object to represent a Peppol endpoint identifier."""),
    'lino_xl.lib.peppol.EndpointID.as_xml' : _("""Used in the peppol-ubl.xml template."""),
    'lino_xl.lib.peppol.Supplier' : _("""Django model used to represent an Ibanity supplier"""),
    'lino_xl.lib.peppol.SuppliersListChecker' : _("""Checks whether all suppliers that were registered by this Peppol hosting provider have a Supplier row on this Lino site."""),
    'lino_xl.lib.peppol.SupplierChecker' : _("""Synchronizes this Supplier row with the data registered in the Ibanity API."""),
    'lino_xl.lib.peppol.OnboardingStates' : _("""A choicelist with values for the Supplier.onboarding_state field."""),
    'lino_xl.lib.products.Product' : _("""Django model to represent a product."""),
    'lino_xl.lib.products.Product.name' : _("""A one-line designation for this product."""),
    'lino_xl.lib.products.Product.body' : _("""The long description of this product."""),
    'lino_xl.lib.products.Product.product_type' : _("""The type of this product."""),
    'lino_xl.lib.products.Product.category' : _("""The category of this product."""),
    'lino_xl.lib.products.Product.delivery_unit' : _("""Pointer to DeliveryUnits"""),
    'lino_xl.lib.products.Product.vat_class' : _("""The VAT class. Injected by lino_xl.lib.vat. If that plugin is not installed, vat_class is a dummy field."""),
    'lino_xl.lib.products.Product.body_short_preview' : _("""See lino.modlib.memo.Previewable.body_short_preview."""),
    'lino_xl.lib.products.Product.body_full_preview' : _("""See lino.modlib.memo.Previewable.body_full_preview."""),
    'lino_xl.lib.products.Product.barcode_svg' : _("""A htmlbox showing the barcode of this product."""),
    'lino_xl.lib.products.Product.get_ruled_price' : _("""Return the product to use for this partner and this selector according to the price rules."""),
    'lino_xl.lib.products.Products' : _("""Base class for all tables of products."""),
    'lino_xl.lib.products.Category' : _("""Django model used to represent a product category."""),
    'lino_xl.lib.products.Category.product_type' : _("""The product type to apply to products of this category."""),
    'lino_xl.lib.products.ProductType.text' : _("""The verbose name of this product type."""),
    'lino_xl.lib.products.ProductType.table_name' : _("""The name of the table to use for displaying a list of products with this type."""),
    'lino_xl.lib.products.ProductTypes' : _("""The list of product types."""),
    'lino_xl.lib.products.DeliveryUnits' : _("""The list of possible delivery units of a product."""),
    'lino_xl.lib.products.PriceFactors' : _("""The choicelist of price factors."""),
    'lino_xl.lib.products.PriceRule' : _("""Every price rule also has one automatic field for each price factor."""),
    'lino_xl.lib.products.PriceRule.seqno' : _("""The sequence number of this rule. Lino loops over price rules in this order and returns the first one that applies."""),
    'lino_xl.lib.products.PriceRule.product' : _("""The product to use for getting the price when this rule applies."""),
    'lino_xl.lib.products.PriceRule.selector' : _("""Either None or an additional selector for this price rule."""),
    'lino_xl.lib.products.PriceRules' : _("""The list of price rules."""),
    'lino_xl.lib.sepa.Account' : _("""A bank account related to a given partner."""),
    'lino_xl.lib.sepa.Account.partner' : _("""The partner who owns this bank account."""),
    'lino_xl.lib.sepa.Account.iban' : _("""IBANField(verbose_name=_(“IBAN”))"""),
    'lino_xl.lib.sepa.Account.bic' : _("""BICField(verbose_name=_(“BIC”), blank=True)"""),
    'lino_xl.lib.sepa.Account.remark' : _("""CharField(_(“Remark”), max_length=200, blank=True)"""),
    'lino_xl.lib.sepa.Account.primary' : _("""Whether this is the primary bank account of this partner."""),
    'lino_xl.lib.sepa.Account.statements' : _("""A virtual field which displays the date of the last imported statement for this account. Clicking on this date will open the B2C account <lino_xl.lib.b2c.models.Account> with same IBAN number."""),
    'lino_xl.lib.sepa.AccountsByPartner' : _("""Shows the bank account(s) known for the given partner."""),
    'lino_xl.lib.sepa.BankAccount' : _("""Defines a field bank_account and its chooser."""),
    'lino_xl.lib.sheets.SheetTypes' : _("""The global list of sheet types ."""),
    'lino_xl.lib.sheets.SheetTypes.results' : _("""https://en.wikipedia.org/wiki/Statement_of_comprehensive_income#Requirements_of_IFRS"""),
    'lino_xl.lib.sheets.CommonItems' : _("""The global list of common sheet items ."""),
    'lino_xl.lib.sheets.CommonItem.value' : _("""Corresponds to the ref field in Item"""),
    'lino_xl.lib.sheets.Item' : _("""In this table the user can configure their local list of items for both sheet types."""),
    'lino_xl.lib.sheets.Report' : _("""Database model used to store an accounting report."""),
    'lino_xl.lib.sheets.ItemEntry' : _("""The computed value of given item for a given report."""),
    'lino_xl.lib.shopping.DeliveryMethod' : _("""Django model used to represent a delivery method."""),
    'lino_xl.lib.shopping.DeliveryMethod.product' : _("""The product to invoice when using this delivery method."""),
    'lino_xl.lib.shopping.Cart' : _("""Django model used to represent a shopping cart."""),
    'lino_xl.lib.shopping.Cart.user' : _("""The end user who created this cart."""),
    'lino_xl.lib.shopping.Cart.date' : _("""The date of last modification."""),
    'lino_xl.lib.shopping.Cart.delivery_address' : _("""The delivery address. A pointer to a shopping address of this user."""),
    'lino_xl.lib.shopping.Cart.invoicing_address' : _("""The invoicing address. A pointer to a shopping address of this user."""),
    'lino_xl.lib.shopping.Cart.invoice' : _("""The invoice that has been created from this shopping cart. This field is empty as long as the user didn’t yet run start_order."""),
    'lino_xl.lib.shopping.CartItem' : _("""Django model used to represent an item of a shopping cart."""),
    'lino_xl.lib.shopping.StartOrder' : _("""Action to create an order from a shopping cart."""),
    'lino_xl.lib.shopping.Address' : _("""Django model used to represent a shopping address."""),
    'lino_xl.lib.shopping.DeliverMethod' : _("""Django model used to represent a delivery method."""),
    'lino_xl.lib.storage.Filler.min_asset' : _("""The minimum quantity to have in provision. When the partner has less than this quantity, the filler gets triggered, i.e. generates a wanted invoice item."""),
    'lino_xl.lib.storage.Filler.fill_asset' : _("""The target quantity to have in provision when this filler has triggered."""),
    'lino_xl.lib.trading.VatProductInvoice' : _("""The Django model representing a product invoice."""),
    'lino_xl.lib.trading.VatProductInvoice.balance_before' : _("""The balance of payments or debts that existed already before this voucher."""),
    'lino_xl.lib.trading.VatProductInvoice.balance_to_pay' : _("""The balance of all movements matching this invoice."""),
    'lino_xl.lib.trading.InvoiceItem' : _("""The Django model representing an item of a product invoice."""),
    'lino_xl.lib.trading.InvoiceItem.invoiceable' : _("""The invoiceable object to which this line applies. Points to the invoice generator that generated this line."""),
    'lino_xl.lib.trading.InvoiceDetail' : _("""The Lino layout representing the detail view of a product invoice."""),
    'lino_xl.lib.trading.InvoicesByJournal' : _("""Shows all invoices of a given journal."""),
    'lino_xl.lib.trading.DueInvoices' : _("""Shows all due product invoices."""),
    'lino_xl.lib.trading.TradingVoucherItem' : _("""Model mixin for voucher items that potentially refer to a product."""),
    'lino_xl.lib.trading.TradingVoucherItem.product' : _("""The product that is being sold or purchased."""),
    'lino_xl.lib.trading.TradingVoucherItem.description' : _("""A multi-line rich text to be printed in the resulting printable document."""),
    'lino_xl.lib.trading.TradingVoucherItem.discount' : _("""The percentage to subtract from the unit price of this item."""),
    'lino_xl.lib.trading.ItemsByInvoicePrint' : _("""The table used to render items in a printable document."""),
    'lino_xl.lib.trading.ItemsByInvoicePrint.description_print' : _("""TODO: write more about it."""),
    'lino_xl.lib.trading.ItemsByInvoicePrintNoQtyColumn' : _("""Alternative column layout to be used when printing an invoice."""),
    'lino_xl.lib.trading.TradingPrintable' : _("""Inherits from PartnerPrintable and Certifiable."""),
    'lino_xl.lib.trading.TradingPrintable.subject' : _("""A single-line text that describes this voucher."""),
    'lino_xl.lib.trading.TradingPrintable.paper_type' : _("""The type of paper to use when printing this voucher."""),
    'lino_xl.lib.trading.TradingVoucher' : _("""Common base class for lino_xl.lib.orders.Order and VatProductInvoice."""),
    'lino_xl.lib.trading.TradingVoucher.intro' : _("""An optional introduction text to be printed on the document."""),
    'lino_xl.lib.trading.TradingVoucher.default_discount' : _("""Default value for discount fields in the items of this voucher."""),
    'lino_xl.lib.trading.TradingVoucher.print_items_table' : _("""The table (column layout) to use in the printed document."""),
    'lino_xl.lib.trading.PaperType' : _("""Describes a paper type (document template) to be used when printing an invoice."""),
    'lino_xl.lib.trading.PaperType.columns_to_print' : _("""The list of columns to appear in the body a printed trade voucher."""),
    'lino_xl.lib.trading.TradingRule' : _("""The Django model used to represent a trading rule."""),
    'lino_xl.lib.trading.TradingRule.partner' : _("""The partner to which this trade rule applies."""),
    'lino_xl.lib.trading.TradingRule.payment_term' : _("""The default payment terms to apply to new trading vouchers for this partner and trade type."""),
    'lino_xl.lib.trading.TradingRule.invoice_recipient' : _("""The partner who should get the invoices caused by this partner."""),
    'lino_xl.lib.trading.TradingRule.paper_type' : _("""The default paper type to be used for invoicing."""),
    'lino_xl.lib.trading.TradingRules' : _("""Shows the list of trading rules."""),
    'lino_xl.lib.userstats.UserStat' : _("""A Summary on SiteConfig."""),
    'lino_xl.lib.userstats.UserStat.active_users' : _("""The number of active users. A user is considered active if their start_date is either empty or before the first day of this month or year, and if their end_date is either empty or after the first day of this month or year."""),
    'lino_xl.lib.vat.VatRegime' : _("""Base class for the items of VatRegimes. Each VAT regime is an instance of this and has two properties:"""),
    'lino_xl.lib.vat.VatRegime.vat_area' : _("""In which VAT area this regime is available."""),
    'lino_xl.lib.vat.VatRegime.item_vat' : _("""No longer used. See item_vat instead."""),
    'lino_xl.lib.vat.VatRegime.needs_vat_id' : _("""Whether this VAT regime requires that partner to have a vat_id."""),
    'lino_xl.lib.vat.VatRegime.reverse_charge' : _("""Whether reverse charge applies for operations under this regime."""),
    'lino_xl.lib.vat.VatRegimes' : _("""The global list of VAT regimes. Each item of this list is an instance of VatRegime."""),
    'lino_xl.lib.vat.VatClasses' : _("""The global list of VAT classes."""),
    'lino_xl.lib.vat.VatRule' : _("""A rule that defines how VAT is to be handled for a given invoice item."""),
    'lino_xl.lib.vat.VatRule.seqno' : _("""The sequence number."""),
    'lino_xl.lib.vat.VatRule.vat_regime' : _("""The regime for which this rule applies."""),
    'lino_xl.lib.vat.VatRule.rate' : _("""The VAT rate to be applied. Note that a VAT rate of 20 percent is stored as 0.20 (not 20)."""),
    'lino_xl.lib.vat.VatRule.vat_account' : _("""The general account where VAT is to be booked."""),
    'lino_xl.lib.vat.VatRule.vat_returnable' : _("""Whether VAT is returnable. Returnable VAT does not increase the total amount of the voucher, it causes an additional movement into the vat_returnable_account. See Returnable VAT."""),
    'lino_xl.lib.vat.VatRule.vat_returnable_account' : _("""Where to book returnable VAT. If this field is empty and vat_returnable is True, then VAT will be added to the base account. See Returnable VAT."""),
    'lino_xl.lib.vat.VatRules' : _("""The table of all VatRule objects."""),
    'lino_xl.lib.vat.VatAreas' : _("""The global list of VAT areas."""),
    'lino_xl.lib.vat.VatAreas.get_for_country' : _("""Return the VAT area for this country."""),
    'lino_xl.lib.vat.VatAccountInvoice' : _("""Django model for storing account vouchers."""),
    'lino_xl.lib.vat.InvoiceItem' : _("""Django model for representing items of an account voucher."""),
    'lino_xl.lib.vat.Invoices' : _("""The table of all VatAccountInvoice objects."""),
    'lino_xl.lib.vat.InvoicesByJournal' : _("""Shows all invoices of a given journal. Works only when the voucher_type of the specified master instance is VatAccountInvoice."""),
    'lino_xl.lib.vat.PrintableInvoicesByJournal' : _("""Purchase journal"""),
    'lino_xl.lib.vat.InvoiceDetail' : _("""The detail layout used by Invoices."""),
    'lino_xl.lib.vat.SalesByDeclaration' : _("""Show a list of all sales invoices whose VAT regime is Intra-Community."""),
    'lino_xl.lib.vat.PurchasesByDeclaration' : _("""Show a list of all purchase invoices whose VAT regime is Intra-Community."""),
    'lino_xl.lib.vat.VatInvoices' : _("""Common base class for SalesByDeclaration and PurchasesByDeclaration"""),
    'lino_xl.lib.vat.IntracomSales' : _("""Show a list of all sales invoices having VAT regime is Intra-Community."""),
    'lino_xl.lib.vat.IntracomPurchases' : _("""Show a list of all purchase invoices having VAT regime is Intra-Community."""),
    'lino_xl.lib.vat.IntracomInvoices' : _("""Common base class for IntracomSales and IntracomPurchases."""),
    'lino_xl.lib.vat.VatSubjectable' : _("""Model mixin that defines the database fields vat_regime and vat_id, and adds related behaviour."""),
    'lino_xl.lib.vat.VatSubjectable.vat_id' : _("""The VAT id used to identify this business partner."""),
    'lino_xl.lib.vat.VatSubjectable.vat_regime' : _("""The default VAT regime to use on invoices for this partner."""),
    'lino_xl.lib.vat.VatTotal' : _("""Model mixin that defines the database fields total_incl, total_base and total_vat and some related behaviour."""),
    'lino_xl.lib.vat.VatTotal.total_incl' : _("""The amount VAT included."""),
    'lino_xl.lib.vat.VatTotal.total_base' : _("""The amount VAT excluded."""),
    'lino_xl.lib.vat.VatTotal.total_vat' : _("""The amount of VAT."""),
    'lino_xl.lib.vat.VatTotal.amount' : _("""The amount VAT excluded or included, depending on item_vat."""),
    'lino_xl.lib.vat.VatTotal.get_trade_type' : _("""Subclasses of VatTotal must implement this method."""),
    'lino_xl.lib.vat.VatTotal.get_vat_rule' : _("""Return the VAT rule for this voucher or voucher item. Called when user edits a total field in the document header when edit_totals is True."""),
    'lino_xl.lib.vat.VatTotal.total_base_changed' : _("""Called when user has edited the total_base field. If total_base has been set to blank, then Lino fills it using reset_totals(). If user has entered a value, compute total_vat and total_incl from this value using the vat rate. If there is no VatRule, total_incl and total_vat are set to None."""),
    'lino_xl.lib.vat.VatTotal.total_vat_changed' : _("""Called when user has edited the total_vat field. If it has been set to blank, then Lino fills it using reset_totals(). If user has entered a value, compute total_incl. If there is no VatRule, total_incl is set to None."""),
    'lino_xl.lib.vat.VatTotal.total_incl_changed' : _("""Called when user has edited the total_incl field. If total_incl has been set to blank, then Lino fills it using reset_totals(). If user enters a value, compute total_base and total_vat from this value using the vat rate. If there is no VatRule, total_incl should be disabled, so this method will never be called."""),
    'lino_xl.lib.vat.VatVoucher' : _("""Model mixin for vouchers that mention VAT."""),
    'lino_xl.lib.vat.VatDocument' : _("""Abstract base class for invoices, offers and other vouchers."""),
    'lino_xl.lib.vat.VatDocument.edit_totals' : _("""Whether total amounts of the voucher are being edited by the end user."""),
    'lino_xl.lib.vat.VatDocument.xml_file_template' : _("""The template to use for generating an XML file from this voucher."""),
    'lino_xl.lib.vat.VatDocument.xml_file_name' : _("""The name of the XML file to generate from this voucher."""),
    'lino_xl.lib.vat.VatDocument.project' : _("""Pointer to a lino_xl.lib.accounting.Plugin.project_model."""),
    'lino_xl.lib.vat.VatDocument.items_edited' : _("""An automatically managed boolean field which says whether the user has manually edited the items of this document. If this is False and edit_totals is True, Lino will automatically update the only invoice item according to partner and vat_regime and total_incl."""),
    'lino_xl.lib.vat.VatDocument.vat_regime' : _("""The VAT regime to be used in this document."""),
    'lino_xl.lib.vat.VatDocument.compute_sums' : _("""Calls ComputeSums for this document."""),
    'lino_xl.lib.vat.VatDocument.vat_subtotals' : _("""A list of (category, rate, base, vat) for every VAT category and rate occurring in this voucher."""),
    'lino_xl.lib.vat.ComputeSums' : _("""Compute the sum fields of a VatDocument based on its items."""),
    'lino_xl.lib.vat.VatItemBase' : _("""Model mixin for items of a VatDocument."""),
    'lino_xl.lib.vat.VatItemBase.vat_class' : _("""The VAT class to use on this voucher item."""),
    'lino_xl.lib.vat.VatItemBase.get_peppol_vat_category' : _("""Return the VAT category code to be applied for this voucher item in a Peppol document."""),
    'lino_xl.lib.vat.VatItemBase.get_vat_rule' : _("""Return the VatRule that applies for this item."""),
    'lino_xl.lib.vat.QtyVatItemBase' : _("""Model mixin for items of a VatTotal. Extends VatItemBase by adding unit_price and qty."""),
    'lino_xl.lib.vat.QtyVatItemBase.unit_price' : _("""The unit price for this item."""),
    'lino_xl.lib.vat.QtyVatItemBase.qty' : _("""The quantity of units of the product for by this item."""),
    'lino_xl.lib.vat.VatColumns' : _("""The list of VAT columns available on this site."""),
    'lino_xl.lib.vat.VatDeclaration' : _("""Abstract base class for models that represent a VAT declaration."""),
    'lino_xl.lib.vat.VatDeclaration.intracom_statement_iterator' : _("""Yield a list of lino_xl.lib.contacts.Partner objects, annotated with a field total_base that contains the sum of intra-community sales operations with this partner during the declared period range."""),
    'lino_xl.lib.vat.VatDeclaration.get_payable_sums_dict' : _("""Implements lino_xl.lib.sepa.Payable.get_payable_sums_dict()."""),
    'lino_xl.lib.vat.MvtDeclarationField' : _("""A declaration field to be computed by analyzing the ledger movements."""),
    'lino_xl.lib.vat.WritableDeclarationField' : _("""A declaration field to be entered manually by the end user."""),
    'lino_xl.lib.vat.SumDeclarationField' : _("""A declaration field that computes the sum of its observed fields."""),
    'lino_xl.lib.vat.DeclarationField' : _("""Base class for all declaration fields."""),
    'lino_xl.lib.vat.DeclarationField.editable' : _("""Whether the value of this field is to be manually entered by the end user."""),
    'lino_xl.lib.vat.DeclarationField.both_dc' : _("""Whether the value of this field is to be manually entered by the end user."""),
    'lino_xl.lib.vat.DeclarationField.fieldnames' : _("""An optional space-separated list of names of observed fields, i.e. other declaration fields to be observed by this field. If a field name is prefixed by a “-”, the observed field will additionally be inverted."""),
    'lino_xl.lib.vat.DeclarationField.is_payable' : _("""Whether the value of this field represents an amount to be paid to the tax office."""),
    'lino_xl.lib.vat.VatColumnsChecker' : _("""Check VAT columns configuration."""),
    'lino_xl.lib.votes.Vote' : _("""Django model for representing a vote. Inherits from UserAuthored, Created, Workable"""),
    'lino_xl.lib.votes.Vote.votable' : _("""The ticket (or other votable) being voted."""),
    'lino_xl.lib.votes.Vote.user' : _("""The user who is voting."""),
    'lino_xl.lib.votes.Vote.state' : _("""The state of this vote. Pointer to VoteStates."""),
    'lino_xl.lib.votes.Vote.priority' : _("""My personal priority for this ticket."""),
    'lino_xl.lib.votes.Vote.rating' : _("""How the ticket author rates my help on this ticket."""),
    'lino_xl.lib.votes.Vote.remark' : _("""Why I am interested in this ticket."""),
    'lino_xl.lib.votes.Vote.nickname' : _("""My nickname for this ticket. Optional."""),
    'lino_xl.lib.votes.Votes' : _("""Table parameters:"""),
    'lino_xl.lib.votes.Votes.observed_event' : _("""There are two class attributes for defining a filter conditions which cannot be removed by the user:"""),
    'lino_xl.lib.votes.Votes.filter_vote_states' : _("""A set of vote states to require (i.e. to filter upon). This must resolve using resolve_states."""),
    'lino_xl.lib.votes.Votes.exclude_vote_states' : _("""A set of vote states to exclude. This must resolve using resolve_states."""),
    'lino_xl.lib.votes.Votes.filter_ticket_states' : _("""A set of ticket states to require (i.e. to filter upon). This must resolve using resolve_states."""),
    'lino_xl.lib.votes.AllVotes' : _("""Show all votes of all users."""),
    'lino_xl.lib.votes.MyVotes' : _("""Show all my votes."""),
    'lino_xl.lib.votes.VotesByVotable' : _("""Show the votes about this object."""),
    'lino_xl.lib.votes.VoteState' : _("""The state of a vote."""),
    'lino_xl.lib.votes.VoteState.vote_name' : _("""Translatable text. How a vote is called when in this state."""),
    'lino_xl.lib.votes.VoteStates' : _("""The list of possible states of a vote. This is used as choicelist for the state field of a vote."""),
    'lino_xl.lib.votes.VoteStates.author' : _("""Reserved for the author’s vote. Lino automatically creates an author vote for every author of a ticket (see get_vote_raters)."""),
    'lino_xl.lib.votes.Ratings' : _("""The list of available ratings."""),
    'lino_xl.lib.votes.Votable' : _("""This model mixin adds two workflow actions ☆ and ★, which are mutually exclusive."""),
    'lino_xl.lib.votes.Votable.create_vote' : _("""Define your vote about this object."""),
    'lino_xl.lib.votes.Votable.edit_vote' : _("""Edit your vote about this object."""),
    'lino_xl.lib.warehouse.Warehouse' : _("""Django model representing a warehouse."""),
    'lino_xl.lib.warehouse.Movement' : _("""Django model representing a warehouse movement."""),
    'lino_xl.lib.warehouse.PurchaseOrder' : _("""Django model representing a purchase order."""),
    'lino_xl.lib.warehouse.GoodsReceipt' : _("""Django model representing a goods receipt posting."""),
    'lino_xl.lib.warehouse.Inventory' : _("""Django model representing an inventory."""),
    'lino_xl.lib.warehouse.ValueMethods' : _("""The list of available methods for computing the value of an inventory line."""),
    'lino_xl.lib.addresses.Address' : _("""Django model to represent an address record."""),
    'lino_xl.lib.addresses.Address.partner' : _("""The owner of this address record. This is business partner to whom this address applies."""),
    'lino_xl.lib.addresses.Address.primary' : _("""Whether this address is the primary address of its owner. Setting this field will automatically uncheck any previousl primary addresses and update the owner’s address fields."""),
    'lino_xl.lib.addresses.Address.address_type' : _("""The type of this address record."""),
    'lino_xl.lib.addresses.Address.data_source' : _("""Pointer to DataSources."""),
    'lino_xl.lib.addresses.Addresses' : _("""Shows all addresses in the database."""),
    'lino_xl.lib.addresses.Addresses.partner' : _("""Show only addresses of the given partner in Address.partner."""),
    'lino_xl.lib.addresses.Addresses.place' : _("""Show only addresses having the given place in Address.city."""),
    'lino_xl.lib.addresses.Addresses.address_type' : _("""Show only addresses having the given type."""),
    'lino_xl.lib.addresses.AddressesByPartner' : _("""Shows all addresses of this partner."""),
    'lino_xl.lib.addresses.AddressOwner' : _("""Base class for the “addressee” of any address."""),
    'lino_xl.lib.addresses.AddressOwner.get_primary_address' : _("""Return the primary address of this address owner. If the owner has no direct address, look up the “address parent” and return its primary address."""),
    'lino_xl.lib.addresses.AddressTypes' : _("""A choicelist with all available address types."""),
    'lino_xl.lib.addresses.DataSources' : _("""A choicelist with all available data sources."""),
    'lino_xl.lib.addresses.AddressOwnerChecker' : _("""Checks for the data problems described below."""),
    'lino_xl.lib.appypod.AppyBuildMethod' : _("""Base class for Build Methods that use .odt templates designed for appy.pod."""),
    'lino_xl.lib.appypod.AppyOdtBuildMethod' : _("""Generates .odt files from .odt templates."""),
    'lino_xl.lib.appypod.AppyPdfBuildMethod' : _("""Generates .pdf files from .odt templates."""),
    'lino_xl.lib.appypod.AppyRtfBuildMethod' : _("""Generates .rtf files from .odt templates."""),
    'lino_xl.lib.appypod.AppyDocBuildMethod' : _("""Generates .doc files from .odt templates."""),
    'lino_xl.lib.appypod.PrintTableAction' : _("""Show this table as a pdf document."""),
    'lino_xl.lib.appypod.PrintLabelsAction' : _("""Add this action to your table, which is expected to execute on a model which implements Addressable."""),
    'lino_xl.lib.appypod.PrintLabelsAction.get_recipients' : _("""Return an iterator over the recipients for which we want to print labels."""),
    'lino_xl.lib.appypod.AppyRenderer' : _("""The extended appy.pod.renderer used by Lino."""),
    'lino_xl.lib.appypod.AppyRenderer.insert_html' : _("""Insert a chunk of HTML (not XHTML) provided as a string or as an etree element."""),
    'lino_xl.lib.appypod.AppyRenderer.insert_table' : _("""This is the function that gets called when a template contains a do text from table(...) statement."""),
    'lino_xl.lib.appypod.AppyRenderer.story2odt' : _("""Yield a sequence of ODT chunks (as utf8 encoded strings)."""),
    'lino_xl.lib.uploads.Upload' : _("""Extends lino.modlib.uploads.Upload by adding some fields."""),
    'lino_xl.lib.uploads.Upload.end_date' : _("""Date until which the original document is valid."""),
    'lino_xl.lib.uploads.Upload.needed' : _("""Whether the responsible user should be reminded when validity of this upload reaches its end."""),
    'lino_xl.lib.uploads.MyExpiringUploads' : _("""Shows the upload files that are marked as Upload.needed and whose Upload.end_date is within a given period."""),
    'lino_xl.lib.b2c.Account' : _("""Django model used to represent an imported bank account."""),
    'lino_xl.lib.b2c.Statement' : _("""Django model used to represent aa statement of an imported bank account."""),
    'lino_xl.lib.b2c.Transaction' : _("""Django model used to represent a transaction of an imported bank account."""),
    'lino_xl.lib.beid.SSIN' : _("""A mixin that adds two fields national_id and nationality."""),
    'lino_xl.lib.beid.SSIN.national_id' : _("""The SSIN. It is a nullable char field declared unique. It is not validated directly because that would cause problems with legacy data where SSINs need manual control. See also BeIdCardHolderChecker."""),
    'lino_xl.lib.beid.SSIN.nationality' : _("""The nationality. This is a pointer to countries.Country which should contain also entries for refugee statuses."""),
    'lino_xl.lib.beid.BeIdCardHolder' : _("""Mixin for models which represent an eid card holder. Currently only Belgian eid cards are tested. Concrete subclasses must also inherit from lino.mixins.Born."""),
    'lino_xl.lib.beid.BeIdCardHolder.nationality_text' : _("""The nationality in plain text as it was on the eid card. For a French citizen the value on the eid card can be “Français”, “Française”, “Frans”, “Franzose”, “Französin”, “French” depending on the sex and the issuing municipality. This field is just informative, Lino does not automatically map it to the nationality field."""),
    'lino_xl.lib.beid.BeIdCardHolder.birth_place' : _("""The birth place in plain text as it was on the eid card."""),
    'lino_xl.lib.beid.BeIdCardHolder.card_type' : _("""The type of id card."""),
    'lino_xl.lib.beid.BeIdCardHolder.card_issuer' : _("""The administration who issued this ID card."""),
    'lino_xl.lib.beid.BeIdCardHolder.noble_condition' : _("""The eventual noble condition of this person."""),
    'lino_xl.lib.beid.BeIdCardHolder.read_beid' : _("""Update card holder data from eID card"""),
    'lino_xl.lib.beid.BeIdCardHolder.find_by_beid' : _("""Find or create card holder from eID card"""),
    'lino_xl.lib.beid.BeIdCardHolder.image' : _("""Virtual field which displays the picture."""),
    'lino_xl.lib.beid.BeIdCardTypes' : _("""A list of Belgian identity card types."""),
    'lino_xl.lib.beid.ResidenceTypes' : _("""The list of Belgian resident registers (Einwohnerregister, Registre de résidents)."""),
    'lino_xl.lib.beid.BeIdCardHolderChecker' : _("""Invalid NISSes are not refused à priori using a ValidationError (see BeIdCardHolder.national_id), but this checker reports them."""),
    'lino_xl.lib.beid.SSINChecker' : _("""A data checker that reports invalid SSINs."""),
    'lino_xl.lib.calview.CalendarView' : _("""Base class for all calendar views."""),
    'lino_xl.lib.calview.DailyView' : _("""Shows a calendar navigator with a configurable daily view."""),
    'lino_xl.lib.calview.DailyView.insert_event' : _("""Custom action for inserting a calendar entry in the DailyView."""),
    'lino_xl.lib.calview.WeeklyView' : _("""Shows a calendar navigator with a configurable weekly view."""),
    'lino_xl.lib.calview.MonthlyView' : _("""Shows a calendar navigator with a configurable monthly view."""),
    'lino_xl.lib.calview.DailyPlanner' : _("""The virtual table used to render the daily planner."""),
    'lino_xl.lib.calview.PlannerColumns' : _("""A choicelist that defines the columns to appear in the daily planner. This list can be modified locally."""),
    'lino_xl.lib.calview.DailyPlannerRow' : _("""A database object that represents one row of the daily planner. The default configuration has “AM”, “PM” and “All day”."""),
    'lino_xl.lib.calview.Day' : _("""An in-memory wrapper around a datetime.date instance."""),
    'lino_xl.lib.calview.DaySlave' : _("""Table mixin for slave tables of tables on Day."""),
    'lino_xl.lib.calview.DayNavigator' : _("""Base class for the three calendar views, but also used for independent tables like working.WorkedHours. A virtual table whose rows are calview.Day instances. Subclasses must set navigation_mode."""),
    'lino_xl.lib.clients.ClientContactBase' : _("""Also used by aids.RefundPartner."""),
    'lino_xl.lib.clients.ClientBase' : _("""Base class for a client. The model specified as client_model must implement this."""),
    'lino_xl.lib.clients.ClientBase.client_state' : _("""Pointer to ClientStates"""),
    'lino_xl.lib.clients.ClientStates' : _("""The list of client states."""),
    'lino_xl.lib.clients.ClientEvents' : _("""The list of observable client events."""),
    'lino_xl.lib.clients.ClientEvents.created' : _("""Select clients whose record has been created during the observed period."""),
    'lino_xl.lib.clients.ClientEvents.modified' : _("""The choice for ClientEvents which selects clients whose main record has been modified during the observed period."""),
    'lino_xl.lib.clients.ClientContact' : _("""A client contact is when a given partner has a given role for a given client."""),
    'lino_xl.lib.clients.ClientContact.client' : _("""The Client."""),
    'lino_xl.lib.clients.ClientContact.type' : _("""The type of contact. Pointer to ClientContactType."""),
    'lino_xl.lib.clients.ClientContact.company' : _("""The organization."""),
    'lino_xl.lib.clients.ClientContact.contact_person' : _("""The contact person in the organization."""),
    'lino_xl.lib.clients.ClientContact.contact_role' : _("""The role of the contact person in the organization."""),
    'lino_xl.lib.clients.ClientContactType' : _("""A client contact type is the type or “role” which must be specified for a given ClientContact."""),
    'lino_xl.lib.coachings.Coaching' : _("""Django model to represent a coaching."""),
    'lino_xl.lib.coachings.Coaching.primary' : _("""Whether this coaching is primary. Enabling this field will automatically make the other coachings non-primary."""),
    'lino_xl.lib.coachings.Coachings' : _("""A table showing a set of coachings."""),
    'lino_xl.lib.coachings.CoachingsByClient' : _("""The Coachings table in a clients detail."""),
    'lino_xl.lib.coachings.Coachable' : _("""Base class for coachable client. The model specified as client_model must implement this."""),
    'lino_xl.lib.coachings.Coachable.get_coachings' : _("""Return a queryset with the coachings of this client. If period is not None, it must be a tuple of two date objects. Any additional arguments are applied as filter of the queryset."""),
    'lino_xl.lib.coachings.Coachable.get_primary_coach' : _("""Return the one and only primary coach of this client (or None if there’s less or more than one)."""),
    'lino_xl.lib.coachings.Coachable.setup_auto_event' : _("""Implements EventGenerator.setup_auto_event."""),
    'lino_xl.lib.coachings.CoachingType' : _("""Django model to represent a coaching."""),
    'lino_xl.lib.coachings.CoachingType.does_integ' : _("""Whether coachings of this type are to be considered as integration work."""),
    'lino_xl.lib.coachings.CoachingEnding' : _("""A Coaching termination reason expresses why a coaching has been terminated."""),
    'lino_xl.lib.coachings.CoachingEndings' : _("""A list of reasons expressing why a coaching was ended."""),
    'lino_xl.lib.coachings.CoachingsUser' : _("""A user who has access to basic coachings functionality."""),
    'lino_xl.lib.coachings.CoachingsStaff' : _("""A user who can configure coachings functionality."""),
    'lino_xl.lib.coachings.ClientCoachingsChecker' : _("""Coached clients should not be obsolete. Only coached clients should have active coachings."""),
    'lino_xl.lib.countries.Country' : _("""Django model to represent a country."""),
    'lino_xl.lib.countries.Country.name' : _("""The designation of this country."""),
    'lino_xl.lib.countries.Country.isocode' : _("""The two-letter code for this country as defined by ISO 3166-1. For countries that no longer exist it may be a 4-letter code."""),
    'lino_xl.lib.countries.Country.short_code' : _("""A short abbreviation for regional usage. Obsolete."""),
    'lino_xl.lib.countries.Country.iso3' : _("""The three-letter code for this country as defined by ISO 3166-1."""),
    'lino_xl.lib.countries.Country.allowed_city_types' : _("""Return the place types that are used in this country."""),
    'lino_xl.lib.countries.Place' : _("""Django model to represent a place."""),
    'lino_xl.lib.countries.Place.parent' : _("""The superordinate geographic place of which this place is a part."""),
    'lino_xl.lib.countries.Place.country' : _("""The country this place is in."""),
    'lino_xl.lib.countries.Place.type' : _("""The type of this place (whether it’s a city. a village, a province…)"""),
    'lino_xl.lib.countries.Place.get_choices_text' : _("""Extends the default behaviour (which would simply diplay this city in the current language) by also adding the name in other languages and the type between parentheses."""),
    'lino_xl.lib.countries.Countries' : _("""The table of all countries."""),
    'lino_xl.lib.countries.Places' : _("""The table of known geographical places. A geographical place can be a city, a town, a suburb, a province, a lake… any named geographic entity, except for countries because these have their own table."""),
    'lino_xl.lib.countries.PlaceTypes' : _("""A choicelist of possible place types."""),
    'lino_xl.lib.countries.CountryCity' : _("""Model mixin that adds two fields country and city and defines a context-sensitive chooser for city, a create_city_choice method, …"""),
    'lino_xl.lib.countries.CountryCity.city' : _("""The locality, i.e. usually a village, city or town."""),
    'lino_xl.lib.countries.CountryCity.municipality' : _("""The municipality, i.e. either the city or a parent of it."""),
    'lino_xl.lib.countries.CountryRegionCity' : _("""Adds a region field to a CountryCity."""),
    'lino_xl.lib.countries.AddressLocation' : _("""A mixin for models than contain a postal address location."""),
    'lino_xl.lib.countries.AddressLocation.addr1' : _("""Address line before street"""),
    'lino_xl.lib.countries.AddressLocation.street_prefix' : _("""Text to print before name of street, but to ignore for sorting."""),
    'lino_xl.lib.countries.AddressLocation.street' : _("""Name of street, without house number."""),
    'lino_xl.lib.countries.AddressLocation.street_no' : _("""House number."""),
    'lino_xl.lib.countries.AddressLocation.street_box' : _("""Text to print after street number on the same line."""),
    'lino_xl.lib.countries.AddressLocation.addr2' : _("""Address line to print below street line."""),
    'lino_xl.lib.countries.AddressLocation.addess_column' : _("""Virtual field which returns the location as a comma-separated one-line string."""),
    'lino_xl.lib.countries.AddressLocation.get_primary_address' : _("""Return the primary address of this partner."""),
    'lino_xl.lib.countries.AddressLocation.address_location' : _("""Return the plain text postal address location part. Lines are separated by linesep which defaults to "\\n"."""),
    'lino_xl.lib.countries.PlaceChecker' : _("""The name of a geographical place should not consist of only digits."""),
    'lino_xl.lib.cv.Study' : _("""Django model representing a study entry."""),
    'lino_xl.lib.cv.Study.education_level' : _("""Pointer to EducationLevel."""),
    'lino_xl.lib.cv.Study.content' : _("""Free-text description of the content."""),
    'lino_xl.lib.cv.Training' : _("""Django model representing a training entry."""),
    'lino_xl.lib.cv.Training.content' : _("""Describes the content of this training. A free one-line text field."""),
    'lino_xl.lib.cv.Experience' : _("""Django model representing a work experience."""),
    'lino_xl.lib.cv.LanguageKnowledge' : _("""Django model to represent a language knowledge."""),
    'lino_xl.lib.cv.LanguageKnowledge.person' : _("""The person to which this entry applies."""),
    'lino_xl.lib.cv.LanguageKnowledge.language' : _("""The language to which this entry applies."""),
    'lino_xl.lib.cv.LanguageKnowledge.cef_level' : _("""The CEF level. A pointer to a choice of CefLevels"""),
    'lino_xl.lib.cv.LanguageKnowledge.has_certificate' : _("""Whether this entry is confirmed by a certificate."""),
    'lino_xl.lib.cv.LanguageKnowledge.entry_date' : _("""When this entry was created."""),
    'lino_xl.lib.cv.StudyType' : _("""Django model representing an education type."""),
    'lino_xl.lib.cv.StudyType.education_level' : _("""Pointer to EducationLevel."""),
    'lino_xl.lib.cv.StudyType.study_regime' : _("""Pointer to StudyRegimes."""),
    'lino_xl.lib.cv.EducationLevel' : _("""Inherits from StudyOrTraining"""),
    'lino_xl.lib.cv.Status' : _("""Django model representing a work status."""),
    'lino_xl.lib.cv.Regime' : _("""Django model representing a work regime."""),
    'lino_xl.lib.cv.Duration' : _("""Django model representing a contract duration."""),
    'lino_xl.lib.cv.Sector' : _("""Django model representing an activity sector."""),
    'lino_xl.lib.cv.Function' : _("""Django model representing a job title."""),
    'lino_xl.lib.cv.StudyOrTraining' : _("""Model mixin inherited by EducationLevel and StudyType."""),
    'lino_xl.lib.cv.StudyOrTraining.is_study' : _("""Whether education entries are considered a study entry."""),
    'lino_xl.lib.cv.StudyOrTraining.is_training' : _("""Whether education entries are considered a training entry."""),
    'lino_xl.lib.cv.PersonHistoryEntry' : _("""Base class for Study, Training and Experience."""),
    'lino_xl.lib.cv.PersonHistoryEntry.person' : _("""The person to whom this entry applies. Pointer to Plugin.person_model."""),
    'lino_xl.lib.cv.PersonHistoryEntry.start_date' : _("""When this entry started."""),
    'lino_xl.lib.cv.PersonHistoryEntry.end_date' : _("""When this entry ended."""),
    'lino_xl.lib.cv.PersonHistoryEntry.duration_text' : _("""Free-text description of the duration of this entry."""),
    'lino_xl.lib.cv.EducationEntry' : _("""Model mixin to represent an education entry. Inherited by Training and Study."""),
    'lino_xl.lib.cv.EducationEntry.language' : _("""Foreign key to lino.modlib.languages.Language."""),
    'lino_xl.lib.cv.EducationEntry.school' : _("""The establishment where the education happened."""),
    'lino_xl.lib.cv.EducationEntry.remarks' : _("""Remarks about this entry."""),
    'lino_xl.lib.cv.EducationEntry.type' : _("""Pointer to StudyType."""),
    'lino_xl.lib.cv.BiographyOwner' : _("""Model mixin usually inherited by the Plugin.person_model. It adds a few virtual fields."""),
    'lino_xl.lib.cv.BiographyOwner.language_knowledge' : _("""A summary of the language knowledges of this person."""),
    'lino_xl.lib.cv.HowWell' : _("""A list of possible answers to questions of type “How well …?”: “not at all”, “a bit”, “moderate”, “quite well” and “very well” which are stored in the database as ‘0’ to ‘4’, and whose __str__() returns their translated text."""),
    'lino_xl.lib.cv.CefLevel' : _("""Levels of the Common European Framework of Reference (CEFR) for Languages."""),
    'lino_xl.lib.cv.EducationEntryStates' : _("""The possible states of an education entry."""),
    'lino_xl.lib.cv.HistoryByPerson' : _("""Table mixin for StudiesByPerson and ExperiencesByPerson."""),
    'lino_xl.lib.cv.SectorFunction' : _("""Model mixin for entries that refer to a Sector and a Function."""),
    'lino_xl.lib.cv.SectorFunction.sector' : _("""Pointer to the Sector."""),
    'lino_xl.lib.cv.SectorFunction.function' : _("""Pointer to the Function."""),
    'lino_xl.lib.deploy.Deployment' : _("""A wish (formerly “deployment”) is the fact that a given ticket is being fixed (or installed or activated) by a given milestone (to a given site)."""),
    'lino_xl.lib.deploy.Deployment.milestone' : _("""The milestone (activity) containing this wish."""),
    'lino_xl.lib.deploy.WishTypes' : _("""When a ticket occurs in a milestone, then we might want to qualify how or why it occured. We call it the “type” of that “wish”."""),
    'lino_xl.lib.deploy.WishTypes.resolution' : _("""a new ticket was created as the result of this milestone"""),
    'lino_xl.lib.deploy.DeploymentsByTicket' : _("""Show the milestones where this ticket occurs as a wish."""),
    'lino_xl.lib.excerpts.Excerpt' : _("""A printable document that describes some aspect of the current situation."""),
    'lino_xl.lib.excerpts.Excerpt.excerpt_type' : _("""The type of this excerpt (ForeignKey to ExcerptType)."""),
    'lino_xl.lib.excerpts.Excerpt.owner' : _("""The object being printed by this excerpt. See Controllable.owner."""),
    'lino_xl.lib.excerpts.Excerpt.company' : _("""The optional company of the recipient of this excerpt. See ContactRelated.company."""),
    'lino_xl.lib.excerpts.Excerpt.contact_person' : _("""The optional contact person of the recipient of this excerpt. See ContactRelated.contact_person."""),
    'lino_xl.lib.excerpts.Excerpt.recipient' : _("""The recipient of this excerpt. See ContactRelated.recipient"""),
    'lino_xl.lib.excerpts.Excerpt.language' : _("""The language used for printing this excerpt."""),
    'lino_xl.lib.excerpts.Excerpt.get_address_html' : _("""See lino_xl.lib.contacts.mixins.ContactRelated.get_address_html()."""),
    'lino_xl.lib.excerpts.Excerpts' : _("""Base class for all tables on Excerpt."""),
    'lino_xl.lib.excerpts.ExcerptsByOwner' : _("""Shows all excerpts whose owner field is this."""),
    'lino_xl.lib.excerpts.ExcerptsByProject' : _("""Only used if lino.core.site.Site.project_model is set."""),
    'lino_xl.lib.excerpts.ExcerptType' : _("""The type of an excerpt. Every excerpt has a mandatory field Excerpt.excerpt_type which points to an ExcerptType instance."""),
    'lino_xl.lib.excerpts.ExcerptType.name' : _("""The designation of this excerpt type. One field for every language."""),
    'lino_xl.lib.excerpts.ExcerptType.content_type' : _("""The database model for which this excerpt type is to be used."""),
    'lino_xl.lib.excerpts.ExcerptType.build_method' : _("""See lino.modlib.printing.mixins.PrintableType.build_method."""),
    'lino_xl.lib.excerpts.ExcerptType.template' : _("""The main template to be used when printing an excerpt of this type."""),
    'lino_xl.lib.excerpts.ExcerptType.body_template' : _("""The body template to use when printing an excerpt of this type."""),
    'lino_xl.lib.excerpts.ExcerptType.email_template' : _("""The template to use when sending this an excerpt of this type by email."""),
    'lino_xl.lib.excerpts.ExcerptType.shortcut' : _("""Optional pointer to a shortcut field. If this is not empty, then the given shortcut field will manage excerpts of this type."""),
    'lino_xl.lib.excerpts.ExcerptTypes' : _("""Displays all rows of ExcerptType."""),
    'lino_xl.lib.excerpts.Certifiable' : _("""Any model that inherits from this mixin becomes “certifiable”."""),
    'lino_xl.lib.excerpts.Certifiable.printed' : _("""Displays information about when this database row has been printed."""),
    'lino_xl.lib.excerpts.Certifiable.printed_by' : _("""Pointer to the database excerpt that certifies this database row."""),
    'lino_xl.lib.excerpts.Certifiable.on_duplicate' : _("""After duplicating e.g. a budget that had been printed, we don’t want the duplicate point to the same excerpt."""),
    'lino_xl.lib.excerpts.Certifiable.get_certifiable_fields' : _("""A class method. Expected to return a string with a space-separated list of field names. These files will automaticaly become disabled (readonly) when the document is “certified”. The default implementation returns an empty string, which means that no field will become disabled when the row is “certified”."""),
    'lino_xl.lib.excerpts.Certifiable.get_excerpt_templates' : _("""Return either None or a list of template names to be used when printing an excerpt controlled by this object."""),
    'lino_xl.lib.excerpts.ExcerptTitle' : _("""Mixin for models like lino_welfare.modlib.aids.AidType and lino_xl.lib.courses.Line."""),
    'lino_xl.lib.excerpts.ExcerptTitle.name' : _("""The designation of this row as seen by the user e.g. when selecting an instance of this model."""),
    'lino_xl.lib.excerpts.ExcerptTitle.excerpt_title' : _("""The text to print as title in confirmations. One field for every language. If this is empty, then name is used."""),
    'lino_xl.lib.excerpts.Shortcuts' : _("""A choicelists of excerpt shortcut fields."""),
    'lino_xl.lib.excerpts.CreateExcerpt' : _("""Create an excerpt in order to print this data record."""),
    'lino_xl.lib.excerpts.ClearPrinted' : _("""Clear any previously generated printable document. Mark this object as not printed. A subsequent call to print will generate a new cache file."""),
    'lino_xl.lib.groups.Group' : _("""Django model representing a user group."""),
    'lino_xl.lib.groups.Group.ref' : _("""The reference. An optional alphanumeric identifier that, unlike the primary key, is editable."""),
    'lino_xl.lib.groups.Group.name' : _("""The designation in different languages."""),
    'lino_xl.lib.groups.Group.user' : _("""The owner of the group"""),
    'lino_xl.lib.groups.Group.private' : _("""Whether this group is considered private. See dg.plugins.comments.visibility."""),
    'lino_xl.lib.groups.Membership' : _("""Django model representing a user membership."""),
    'lino_xl.lib.groups.Groupwise' : _("""Model mixin for things that are to be filtered by group."""),
    'lino_xl.lib.groups.Groups' : _("""Shows all groups."""),
    'lino_xl.lib.healthcare.Plan.ref' : _("""An identifying name understood by every user of the site."""),
    'lino_xl.lib.healthcare.Plan.provider' : _("""The provider who will potentially be invoiced for shared costs."""),
    'lino_xl.lib.healthcare.Tariffs' : _("""The choicelist with healthcare tariffs available in this application."""),
    'lino_xl.lib.healthcare.Rule' : _("""Note that this part is not yet used on the field. The client_fee might be useless, we must maybe rather inject a checkbox field “healthcare_shared” to Product."""),
    'lino_xl.lib.healthcare.Rule.client_fee' : _("""The product for which this rule applies."""),
    'lino_xl.lib.healthcare.Rule.provider_fee' : _("""The provider’s share of the costs which you will invoice to the provider."""),
    'lino_xl.lib.healthcare.HealthcareSubject' : _("""Model mixin which adds database fields about a given healthcare subject."""),
    'lino_xl.lib.healthcare.HealthcareSubject.healthcare_plan' : _("""The health care provider."""),
    'lino_xl.lib.healthcare.HealthcareSubject.healthcare_tariff' : _("""The health care tariff."""),
    'lino_xl.lib.households.Household' : _("""Django model to represent a household."""),
    'lino_xl.lib.households.Household.type' : _("""The type of this household. See household types"""),
    'lino_xl.lib.households.Household.create_household' : _("""Create a household with the given head, partner and type."""),
    'lino_xl.lib.households.Type' : _("""Django model to represent a household type."""),
    'lino_xl.lib.households.Member' : _("""Django model to represent a household membership."""),
    'lino_xl.lib.households.Member.primary' : _("""Whether this is the primary household of this person. Checking this field will automatically disable any other primary memberships."""),
    'lino_xl.lib.households.Member.start_date' : _("""Since when this membership exists. This is usually empty."""),
    'lino_xl.lib.households.Member.end_date' : _("""Until when this membership exists."""),
    'lino_xl.lib.households.PopulateMembers' : _("""Populate household members from data in human links."""),
    'lino_xl.lib.households.MemberRoles' : _("""The list of allowed choices for the role of a household member."""),
    'lino_xl.lib.households.MemberDependencies' : _("""The list of allowed choices for the charge of a household member."""),
    'lino_xl.lib.humanlinks.Link' : _("""A link between two persons."""),
    'lino_xl.lib.humanlinks.Link.parent' : _("""Pointer to the person who is “parent”."""),
    'lino_xl.lib.humanlinks.Link.child' : _("""Pointer to the person who is “child”."""),
    'lino_xl.lib.humanlinks.Link.type' : _("""The type of link. Pointer to LinkTypes."""),
    'lino_xl.lib.humanlinks.Link.type_as_parent' : _("""Displays LinkTypes.as_parent() for this link."""),
    'lino_xl.lib.humanlinks.Link.type_as_child' : _("""Displays LinkTypes.as_child() for this link."""),
    'lino_xl.lib.humanlinks.Link.check_autocreate' : _("""Check whether there is a human link of type “parent” between the given persons. Create one if not. If the child has already another parent of same sex, then it becomes a foster child, otherwise a natural child."""),
    'lino_xl.lib.humanlinks.LinkTypes' : _("""The global list of human link types. This is used as choicelist for the Link.type field of a human link."""),
    'lino_xl.lib.humanlinks.LinkTypes.adoptive_parent' : _("""A person who adopts a child of other parents as his or her own child."""),
    'lino_xl.lib.humanlinks.LinkTypes.stepparent' : _("""Someone that your mother or father marries after the marriage to or relationship with your other parent has ended"""),
    'lino_xl.lib.humanlinks.LinkTypes.foster_parent' : _("""A man (woman) who looks after or brings up a child or children as a father (mother), in place of the natural or adoptive father (mother). [thefreedictionary]"""),
    'lino_xl.lib.humanlinks.LinkType.symmetric' : _("""Whether this link is symmetric (i.e. text is the same for both directions). For example sibling, friend, spouse are symmetric links."""),
    'lino_xl.lib.humanlinks.LinksByHuman' : _("""Show all links for which this human is either parent or child."""),
    'lino_xl.lib.lists.List' : _("""Django model to represent a partner list."""),
    'lino_xl.lib.lists.Member' : _("""Django model to represent a membership of a partner in a list."""),
    'lino_xl.lib.phones.ContactDetailType.field_name' : _("""The name of field on the ContactDetailsOwner where the value of the primary item of this type is to be mirrored."""),
    'lino_xl.lib.phones.ContactDetailTypes' : _("""The list of “built-in” types of contact detail items."""),
    'lino_xl.lib.phones.ContactDetail.primary' : _("""Whether this item is the primary contact detail for this type and this owner. Setting this field will automatically uncheck any previously primary items and update the owner’s contact detail fields."""),
    'lino_xl.lib.phones.ContactDetailsOwner' : _("""Model mixin for the potential owner of contact details."""),
    'lino_xl.lib.phones.ContactDetailsOwnerChecker' : _("""Checks for mismatches between contact details and owner."""),
    'lino_xl.lib.polls.Poll' : _("""A series of questions."""),
    'lino_xl.lib.polls.AllPolls' : _("""Show all polls of all users."""),
    'lino_xl.lib.polls.Question' : _("""A question of a poll."""),
    'lino_xl.lib.polls.Question.number' : _("""The number of this question within this poll."""),
    'lino_xl.lib.polls.Response.toggle_choice' : _("""See ToggleChoice"""),
    'lino_xl.lib.polls.ResponsesByPartner' : _("""Show all responses for a given partner. Default view shows a summary of all responses for a that partner using a bullet list grouped by poll."""),
    'lino_xl.lib.polls.AnswersByResponse' : _("""The table used for answering to a poll. This is a virtual table and its rows are volatile AnswersByResponseRow instances."""),
    'lino_xl.lib.polls.AnswersByResponse.answer_buttons' : _("""A virtual field that displays the currently selected answer(s) for this question, eventually (if editing is permitted) together with buttons to modify the selection."""),
    'lino_xl.lib.polls.AnswersByResponseRow' : _("""Volatile object to represent the one and only answer to a given question in a given response."""),
    'lino_xl.lib.polls.AnswerRemarkField' : _("""An editable virtual field."""),
    'lino_xl.lib.polls.AnswersByQuestion' : _("""The rows of this table are volatile AnswersByQuestionRow instances."""),
    'lino_xl.lib.polls.AnswersByQuestionRow' : _("""Volatile object to represent a row of AnswersByQuestion."""),
    'lino_xl.lib.polls.PollResult' : _("""Shows a summay of responses to this poll."""),
    'lino_xl.lib.polls.PollsUser' : _("""A user who has access to polls functionality."""),
    'lino_xl.lib.polls.PollsStaff' : _("""A user who manages configuration of polls functionality."""),
    'lino_xl.lib.polls.ToggleChoice' : _("""Toggle the given choice for the given question in this response."""),
    'lino_xl.lib.polls.PollStates' : _("""The list of possible states of a Poll."""),
    'lino_xl.lib.polls.ResponseStates' : _("""The list of possible states of a Response."""),
    'lino_xl.lib.properties.PropType' : _("""The type of the values that a property accepts. Each PropType may (or may not) imply a list of choices."""),
    'lino_xl.lib.properties.PropType.default_value' : _("""The default value to set when creating a PropertyOccurence. This is currently used only in some fixture…"""),
    'lino_xl.lib.properties.PropChoice' : _("""A Choice for a given PropType. text is the text to be displayed in combo boxes."""),
    'lino_xl.lib.properties.PropGroup' : _("""A Property Group defines a list of Properties that fit together under a common name. Examples of Property Groups: Skills, Soft Skills, Obstacles There will be one menu entry per Group."""),
    'lino_xl.lib.properties.Property' : _("""Represents a property."""),
    'lino_xl.lib.properties.PropertyOccurence' : _("""A Property Occurence is when a Property occurs, possibly having a certain value."""),
    'lino_xl.lib.properties.HowWell' : _("""A list of possible answers to questions of type “How well …?”: “not at all”, “a bit”, “moderate”, “quite well” and “very well”"""),
    'lino_xl.lib.properties.DoYouLike' : _("""A list of possible answers to questions of type “How much do you like …?”."""),
    'lino_xl.lib.tickets.Ticket' : _("""The Django model used to represent a ticket."""),
    'lino_xl.lib.tickets.Ticket.user' : _("""The author or reporter of this ticket. The user who reported this ticket to the database and is responsible for managing it."""),
    'lino_xl.lib.tickets.Ticket.end_user' : _("""The end user who is asking for help. This may be an external person who is not registered as a system user."""),
    'lino_xl.lib.tickets.Ticket.assigned_to' : _("""The user who has been assigned to work on this ticket."""),
    'lino_xl.lib.tickets.Ticket.description' : _("""A complete and concise description of the ticket. This should describe in more detail what this ticket is about. If the ticket has evolved during time, it should reflect the latest version."""),
    'lino_xl.lib.tickets.Ticket.order' : _("""The business document used by both partners as reference for invoicing this ticket."""),
    'lino_xl.lib.tickets.Ticket.site' : _("""The site this ticket belongs to. You can select only sites you are subscribed to."""),
    'lino_xl.lib.tickets.Ticket.ticket_type' : _("""The type of this ticket. The site manager can configure the list of available ticket types."""),
    'lino_xl.lib.tickets.Ticket.upgrade_notes' : _("""A formatted text field meant for writing instructions for the hoster’s site manager when doing an upgrade where this ticket is being deployed."""),
    'lino_xl.lib.tickets.Ticket.waiting_for' : _("""What to do next. An unformatted one-line text which describes what this ticket is waiting for."""),
    'lino_xl.lib.tickets.Ticket.state' : _("""The workflow state of this ticket."""),
    'lino_xl.lib.tickets.Ticket.duplicate_of' : _("""A pointer to another ticket which is regarded as the first occurence of the same problem."""),
    'lino_xl.lib.tickets.Ticket.deadline' : _("""Specify that the ticket must be done for a given date."""),
    'lino_xl.lib.tickets.Ticket.private' : _("""Whether this ticket is to be treated confidentially."""),
    'lino_xl.lib.tickets.Ticket.urgent' : _("""Whether this ticket is to be treated urgently."""),
    'lino_xl.lib.tickets.Ticket.priority' : _("""An integer number to help the worker decide which ticket he should work on next. The Tickets to work list is sorted by decreasing priority. Suggested meanings of the values:"""),
    'lino_xl.lib.tickets.Ticket.rating' : _("""How the author rates the work which has been done on this ticket."""),
    'lino_xl.lib.tickets.Ticket.reporting_type' : _("""An indication about who is going to pay for work on this site. See ReportingTypes."""),
    'lino_xl.lib.tickets.Ticket.quick_assign_to' : _("""Show the site user who is assigned to work on this ticket, along with other candidates. Click on another candidate in order to quickly reassign the ticket to that user."""),
    'lino_xl.lib.tickets.Ticket.spawn_ticket' : _("""Create a new ticket that will be a child of this ticket."""),
    'lino_xl.lib.tickets.Ticket.quick_assign_to_action' : _("""Ask to pick another user and then assign that user to this ticket."""),
    'lino_xl.lib.tickets.TicketStates' : _("""The choicelist for the state of a ticket."""),
    'lino_xl.lib.tickets.TicketStates.new' : _("""Somebody reported this ticket, but there was no response yet. The ticket needs to be triaged."""),
    'lino_xl.lib.tickets.TicketStates.talk' : _("""Some worker needs discussion with the author. We don’t yet know exactly what to do with it."""),
    'lino_xl.lib.tickets.TicketStates.todo' : _("""The ticket is confirmed and we are working on it. It appears in the todo list of somebody (either the assigned worker, or our general todo list)"""),
    'lino_xl.lib.tickets.TicketStates.testing' : _("""The ticket is theoretically done, but we want to confirm this somehow, and it is not clear who should do the next step. If it is clear that the author should do the testing, then you should rather set the ticket to talk. If it is clear that you (the assignee) must test it, then leave the ticket at todo."""),
    'lino_xl.lib.tickets.TicketStates.sleeping' : _("""Waiting for some external event. We didn’t decide what to do with it."""),
    'lino_xl.lib.tickets.TicketStates.ready' : _("""The ticket is basically done, but some detail still needs to be done by the user (e.g. testing, confirmation, documentation,..)"""),
    'lino_xl.lib.tickets.TicketStates.done' : _("""The ticket has been done."""),
    'lino_xl.lib.tickets.TicketStates.cancelled' : _("""It has been decided that we won’t fix this ticket."""),
    'lino_xl.lib.tickets.Site' : _("""The Django model representing a site."""),
    'lino_xl.lib.tickets.Sites' : _("""Base class for all Sites tables."""),
    'lino_xl.lib.tickets.MySites' : _("""Shows the sites for which I have a subscription."""),
    'lino_xl.lib.tickets.AllSites' : _("""Shows all sites in explorer menu."""),
    'lino_xl.lib.tickets.TicketType' : _("""The Django model used to represent a ticket type."""),
    'lino_xl.lib.tickets.TicketType.reporting_type' : _("""Which reporting type to use in a service report. See :class:ReportingTypes`."""),
    'lino_xl.lib.tickets.TicketTypes' : _("""The list of all ticket types."""),
    'lino_xl.lib.tickets.Tickets' : _("""Base class for all tables of tickets."""),
    'lino_xl.lib.tickets.Tickets.site' : _("""Show only tickets within this project."""),
    'lino_xl.lib.tickets.Tickets.show_private' : _("""Show only (or hide) tickets that are marked private."""),
    'lino_xl.lib.tickets.Tickets.show_todo' : _("""Show only (or hide) tickets that are todo (i.e. state is New or ToDo)."""),
    'lino_xl.lib.tickets.Tickets.show_active' : _("""Show only (or hide) tickets which are active (i.e. state is Talk or ToDo)."""),
    'lino_xl.lib.tickets.Tickets.show_assigned' : _("""Show only (or hide) tickets that are assigned to somebody."""),
    'lino_xl.lib.tickets.Tickets.has_site' : _("""Show only (or hide) tickets which have a site assigned."""),
    'lino_xl.lib.tickets.Tickets.feasable_by' : _("""Show only tickets for which the given supplier is competent."""),
    'lino_xl.lib.tickets.AllTickets' : _("""Shows all tickets."""),
    'lino_xl.lib.tickets.RefTickets' : _("""Shows all tickets that have a reference."""),
    'lino_xl.lib.tickets.PublicTickets' : _("""Shows all public tickets."""),
    'lino_xl.lib.tickets.TicketsToTriage' : _("""Shows tickets that need to be triaged. Currently this is equivalent to those having their state set to new."""),
    'lino_xl.lib.tickets.TicketsNeedingMyFeedback' : _("""Shows tickets that are waiting for my feedback."""),
    'lino_xl.lib.tickets.MyTicketsNeedingFeedback' : _("""Shows tickets assigned to me and waiting for feedback from others."""),
    'lino_xl.lib.tickets.ActiveTickets' : _("""Show all tickets that are in an active state."""),
    'lino_xl.lib.tickets.MyTickets' : _("""Show all active tickets reported by me."""),
    'lino_xl.lib.tickets.TicketsByEndUser' : _("""Show the tickets introduced on behalf of this end user."""),
    'lino_xl.lib.tickets.DuplicatesByTicket' : _("""Shows the tickets which are marked as duplicates of this (i.e. whose duplicate_of field points to this ticket."""),
    'lino_xl.lib.tickets.TicketsSummary' : _("""Abstract base class for ticket tables with a summary."""),
    'lino_xl.lib.tickets.MyTicketsToWork' : _("""Show all active tickets assigned to me."""),
    'lino_xl.lib.tickets.TicketsByGroup' : _("""Show all tickets of this groups.Group."""),
    'lino_xl.lib.tickets.TimeInvestment' : _("""Model mixin for things that represent a time investment."""),
    'lino_xl.lib.tickets.TimeInvestment.closed' : _("""Whether this investment is closed, i.e. certain things should not change anymore."""),
    'lino_xl.lib.tickets.TimeInvestment.planned_time' : _("""The time (in hours) we plan to work on this project or ticket."""),
    'lino_xl.lib.topics.Topic' : _("""Django model representing a topic."""),
    'lino_xl.lib.topics.Topic.ref' : _("""The reference."""),
    'lino_xl.lib.topics.Topic.name' : _("""The designation in different languages."""),
    'lino_xl.lib.topics.Topic.description_text' : _("""Rich text field for a longer multi-line description."""),
    'lino_xl.lib.topics.Topic.description' : _("""Virtual field which includes the formatted structured reference and the description_text."""),
    'lino_xl.lib.topics.Topic.topic_group' : _("""Deprecated. Don’t use."""),
    'lino_xl.lib.topics.Tag' : _("""Django model used to represent a tag."""),
    'lino_xl.lib.topics.Interest' : _("""Django model used to represent an interest."""),
    'lino_xl.lib.topics.Taggable' : _("""Adds an add_tag field."""),
    'lino_xl.lib.topics.Taggable.add_tag' : _("""A virtual field that lets the user select a topic to tag this database row with."""),
    'lino_xl.lib.topics.TopicsUser' : _("""User role required to see the topics plugin."""),
    'lino_xl.lib.trends.TrendArea' : _("""Represents a possible choice for the trend_area field of a TrendStage."""),
    'lino_xl.lib.trends.TrendStage.trend_area' : _("""Pointer to the TrendArea."""),
    'lino_xl.lib.trends.TrendStage.subject_column' : _("""Whether this stage should cause subject column to be added ."""),
    'lino_xl.lib.trends.TrendEvent.subject' : _("""The subject we are talking about."""),
    'lino_xl.lib.trends.TrendEvent.user' : _("""The user who entered this data."""),
    'lino_xl.lib.trends.TrendEvent.event_date' : _("""The date when the subject reached the stage."""),
    'lino_xl.lib.trends.TrendEvent.trend_area' : _("""Pointer to the TrendArea."""),
    'lino_xl.lib.trends.TrendEvent.trend_stage' : _("""Pointer to the TrendStage."""),
    'lino_xl.lib.trends.TrendEvent.remark' : _("""A free text field."""),
    'lino_xl.lib.trends.EventsBySubject' : _("""Shows all trend events of that subject."""),
    'lino_xl.lib.trends.TrendObservable' : _("""Mixin that should be inherited by the Plugin.subject_model so that Lino automatically adds virtual columns for each trend stage having"""),
    'lino_xl.lib.working.ReportingTypes' : _("""The list of reporting types available on this site."""),
    'lino_xl.lib.working.ReportingRule' : _("""Django model used to configure reporting rules."""),
    'lino_xl.lib.working.ReportingRule.seqno' : _("""The sequence number of this rule. Lino looks up reporting rules ordered by their sequence number and uses the first rule that applies."""),
    'lino_xl.lib.working.ReportingRule.reporting_type' : _("""Select the reporting type for which this rule applies. Leave blank if this rule applies independently of the session’s reporting_type."""),
    'lino_xl.lib.working.ReportingRule.urgent' : _("""Select “yes” if this rule applies only to sessions marked as urgent. Select “no” if this rule applies only to sessions that are not marked as urgent. Leave blank if this rule applies independently of the urgent checkbox."""),
    'lino_xl.lib.working.ReportingRule.product' : _("""The product to invoice when this reporting rule applies."""),
    'lino_xl.lib.working.SessionType' : _("""Django model representing the type of a working session."""),
    'lino_xl.lib.working.Session' : _("""Django model representing a working session."""),
    'lino_xl.lib.working.Session.start_date' : _("""The date when you started to work."""),
    'lino_xl.lib.working.Session.start_time' : _("""The time (in hh:mm) when you started working on this session."""),
    'lino_xl.lib.working.Session.end_date' : _("""Leave this field blank if it is the same date as start_date."""),
    'lino_xl.lib.working.Session.end_time' : _("""The time (in hh:mm) when the worker stopped to work."""),
    'lino_xl.lib.working.Session.break_time' : _("""The time (in hh:mm) to remove from the duration resulting from the difference between start_time and end_time."""),
    'lino_xl.lib.working.Session.faculty' : _("""The faculty that has been used during this session. On a new session this defaults to the needed faculty currently specified on the ticket."""),
    'lino_xl.lib.working.Session.duration' : _("""Virtual field returning the computed_duration."""),
    'lino_xl.lib.working.Session.computed_duration' : _("""The duration of this session as a Duration."""),
    'lino_xl.lib.working.Session.duration_decimal' : _("""The computed_duration expressed as a decimal number rather than a Duration. This format can be more convenient when processing the data in a spreadsheet."""),
    'lino_xl.lib.working.Session.reporting_type' : _("""The reporting type to use for this session."""),
    'lino_xl.lib.working.Session.ticket' : _("""The ticket that has been worked on during this session."""),
    'lino_xl.lib.working.Session.end_session' : _("""Tell Lino that you stop this session for now. This will simply set the end_time to the current time."""),
    'lino_xl.lib.working.SessionsByTicket' : _("""Show the working sessions on this ticket."""),
    'lino_xl.lib.working.MySessions' : _("""Shows all my sessions."""),
    'lino_xl.lib.working.MySessionsByDate' : _("""Shows my working sessions of a given day."""),
    'lino_xl.lib.working.SitesByReport' : _("""The list of tickets mentioned in a service report."""),
    'lino_xl.lib.working.StartTicketSession' : _("""The action behind Workable.start_session."""),
    'lino_xl.lib.working.EndSession' : _("""Common base for EndThisSession and EndTicketSession."""),
    'lino_xl.lib.working.EndTicketSession' : _("""The action behind Workable.end_session."""),
    'lino_xl.lib.working.EndThisSession' : _("""The action behind Session.end_session."""),
    'lino_xl.lib.working.Workable' : _("""Base class for things that workers can work on."""),
    'lino_xl.lib.working.Workable.is_workable_for' : _("""Return True if the given user can start a working session on this object."""),
    'lino_xl.lib.working.Workable.on_worked' : _("""This is automatically called when a working session has been created or modified."""),
    'lino_xl.lib.working.Workable.start_session' : _("""Start a working session on this ticket."""),
    'lino_xl.lib.working.Workable.end_session' : _("""Tell Lino that you stop working on this ticket for now. This will simply set the Session.end_time to the current time."""),
    'lino_xl.lib.working.ShowMySessionsByDay' : _("""Shows your working sessions per day."""),
    'lino_xl.lib.working.TicketHasSessions' : _("""Select only tickets for which there has been at least one session during the given period."""),
    'lino_xl.lib.working.ProjectHasSessions' : _("""Select only projects for which there has been at least one session during the given period."""),
    'lino_xl.lib.working.Worker' : _("""A user who is candidate for working on a ticket."""),
    'lino_xl.lib.working.SiteSummary' : _("""An automatically generated record with yearly summary data about a site."""),
    'lino_xl.lib.working.SummariesBySite' : _("""Shows the summary records for a given site."""),
    'lino_xl.lib.working.UserSummary' : _("""An automatically generated record with monthly summary data about a user."""),
    'lino_xl.lib.working.SummariesByUser' : _("""Shows the summary records for a given user."""),
    'lino_xl.lib.working.Contract' : _("""Django model used to represent a worker contract."""),
    'lino_xl.lib.working.Contract.user' : _("""The worker."""),
    'lino_xl.lib.working.Contract.hours_per_week' : _("""How many hours this worker is expected to provide per week."""),
    'lino_xl.lib.working.Contracts' : _("""Shows the list of all worker contracts for managing them."""),
    'lino_xl.lib.working.ActiveContracts' : _("""Shows the list of all worker contracts with statistic data about their activity."""),
    'lino_xl.lib.vat.VatIdChecker' : _("""Validate VAT id from online registry."""),
}
