# {{PROJECT_NAME}} - MoAI-Agentic Development Kit

**SPEC-First TDD Development with Alfred SuperAgent**

---

## ▶◀ Meet Alfred: Your MoAI SuperAgent

**Alfred** orchestrates the MoAI-ADK agentic workflow across a four-layer stack (Commands → Sub-agents → Skills → Hooks). The SuperAgent interprets user intent, activates the right specialists, streams Claude Skills on demand, and enforces the TRUST 5 principles so every project follows the SPEC → TDD → Sync rhythm.

### 4-Layer Architecture (v0.4.0)

| Layer | Owner | Purpose | Examples |
| --- | --- | --- | --- |
| **Commands** | User ↔ Alfred | Workflow entry points that establish the Plan → Run → Sync cadence | `/alfred:0-project`, `/alfred:1-plan`, `/alfred:2-run`, `/alfred:3-sync` |
| **Sub-agents** | Alfred | Deep reasoning and decision making for each phase | project-manager, spec-builder, code-builder pipeline, doc-syncer |
| **Skills (55)** | Claude Skills | Reusable knowledge capsules loaded just-in-time | Foundation (TRUST/TAG/Git), Essentials (debug/refactor/review), Alfred workflow, Domain & Language packs |
| **Hooks** | Runtime guardrails | Fast validation + JIT context hints (<100 ms) | SessionStart status card, PreToolUse destructive-command blocker |

### Core Sub-agent Roster

> Alfred + 10 core sub-agents + 6 zero-project specialists + 2 built-in Claude agents = **19-member team**
>
> **Note on Counting**: The "code-builder pipeline" is counted as 1 conceptual agent but implemented as 2 physical files (`implementation-planner` + `tdd-implementer`) for sequential RED → GREEN → REFACTOR execution. This maintains the 19-member team concept while acknowledging that 20 distinct agent files exist in `.claude/agents/alfred/`.

| Sub-agent | Model | Phase | Responsibility | Trigger |
| --- | --- | --- | --- | --- |
| **project-manager** 📋 | Sonnet | Init | Project bootstrap, metadata interview, mode selection | `/alfred:0-project` |
| **spec-builder** 🏗️ | Sonnet | Plan | Plan board consolidation, EARS-based SPEC authoring | `/alfred:1-plan` |
| **code-builder pipeline** 💎 | Sonnet | Run | Phase 1 `implementation-planner` → Phase 2 `tdd-implementer` to execute RED → GREEN → REFACTOR | `/alfred:2-run` |
| **doc-syncer** 📖 | Haiku | Sync | Living documentation, README/CHANGELOG updates | `/alfred:3-sync` |
| **tag-agent** 🏷️ | Haiku | Sync | TAG inventory, orphan detection, chain repair | `@agent-tag-agent` |
| **git-manager** 🚀 | Haiku | Plan · Sync | GitFlow automation, Draft→Ready PR, auto-merge policy | `@agent-git-manager` |
| **debug-helper** 🔍 | Sonnet | Run | Failure diagnosis, fix-forward guidance | `@agent-debug-helper` |
| **trust-checker** ✅ | Haiku | All phases | TRUST 5 principle enforcement and risk flags | `@agent-trust-checker` |
| **quality-gate** 🛡️ | Haiku | Sync | Coverage delta review, release gate validation | Auto during `/alfred:3-sync` |
| **cc-manager** 🛠️ | Sonnet | Ops | Claude Code session tuning, Skill lifecycle management | `@agent-cc-manager` |

The **code-builder pipeline** runs two Sonnet specialists in sequence: **implementation-planner** (strategy, libraries, TAG design) followed by **tdd-implementer** (RED → GREEN → REFACTOR execution).

### Zero-project Specialists

| Sub-agent | Model | Focus | Trigger |
| --- | --- | --- | --- |
| **language-detector** 🔍 | Haiku | Stack detection, language matrix | Auto during `/alfred:0-project` |
| **backup-merger** 📦 | Sonnet | Backup restore, checkpoint diff | `@agent-backup-merger` |
| **project-interviewer** 💬 | Sonnet | Requirement interviews, persona capture | `/alfred:0-project` Q&A |
| **document-generator** 📝 | Haiku | Project docs seed (`product.md`, `structure.md`, `tech.md`) | `/alfred:0-project` |
| **feature-selector** 🎯 | Haiku | Skill pack recommendation | `/alfred:0-project` |
| **template-optimizer** ⚙️ | Haiku | Template cleanup, migration helpers | `/alfred:0-project` |

> **Implementation Note**: Zero-project specialists may be embedded within other agents (e.g., functionality within `project-manager`) or implemented as dedicated Skills (e.g., `moai-alfred-language-detection`). For example, `language-detector` functionality is provided by the `moai-alfred-language-detection` Skill during `/alfred:0-project` initialization.

### Built-in Claude Agents

| Agent | Model | Specialty | Invocation |
| --- | --- | --- | --- |
| **Explore** 🔍 | Haiku | Repository-wide search & architecture mapping | `@agent-Explore` |
| **general-purpose** | Sonnet | General assistance | Automatic |

#### Explore Agent Guide

The **Explore** agent excels at navigating large codebases.

**Use cases**:
- ✅ **Code analysis** (understand complex implementations, trace dependencies, study architecture)
- ✅ Search for specific keywords or patterns (e.g., "API endpoints", "authentication logic")
- ✅ Locate files (e.g., `src/components/**/*.tsx`)
- ✅ Understand codebase structure (e.g., "explain the project architecture")
- ✅ Search across many files (Glob + Grep patterns)

**Recommend Explore when**:
- 🔍 You need to understand a complex structure
- 🔍 The implementation spans multiple files
- 🔍 You want the end-to-end flow of a feature
- 🔍 Dependency relationships must be analyzed
- 🔍 You're planning a refactor and need impact analysis

**Usage examples**:
```python
# 1. Deep code analysis
Task(
    subagent_type="Explore",
    description="Analyze the full implementation of TemplateProcessor",
    prompt="""Please analyze the TemplateProcessor class implementation:
    - Class definition location
    - Key method implementations
    - Dependent classes/modules
    - Related tests
    thoroughness level: very thorough"""
)

# 2. Domain-specific search (inside commands)
Task(
    subagent_type="Explore",
    description="Find files related to the AUTH domain",
    prompt="""Find every file related to the AUTH domain:
    - SPEC documents, tests, implementation (src), documentation
    thoroughness level: medium"""
)

# 3. Natural language questions (auto-delegated by Alfred)
User: "Where is JWT authentication implemented in this project?"
→ Alfred automatically delegates to Explore
→ Explore returns the relevant file list
→ Alfred reads only the necessary files
```

**thoroughness levels** (declare explicitly inside the prompt text):
- `quick`: fast scan (basic patterns)
- `medium`: moderate sweep (multiple locations + naming rules) — **recommended**
- `very thorough`: exhaustive scan (full codebase analysis)

### Claude Skills (55 packs)

Alfred relies on 55 Claude Skills grouped by tier. Skills load via Progressive Disclosure: metadata is available at session start, full `SKILL.md` content loads when a sub-agent references it, and supporting templates stream only when required.

**Skills Distribution by Tier**:

| Tier | Count | Purpose |
| --- | --- | --- |
| Foundation | 6 | Core TRUST/TAG/SPEC/Git/EARS/Lang principles |
| Essentials | 4 | Debug/Perf/Refactor/Review workflows |
| Alfred | 11 | Internal workflow orchestration |
| Domain | 10 | Specialized domain expertise |
| Language | 23 | Language-specific best practices |
| Claude Code Ops | 1 | Session management |
| **Total** | **55** | Complete knowledge capsule library |

**Foundation Tier (6)**

| Skill | Purpose | Auto-load |
| --- | --- | --- |
| `moai-foundation-trust` | TRUST checklist, coverage gate policies | SessionStart, `/alfred:3-sync` |
| `moai-foundation-tags` | TAG inventory & orphan detection | `/alfred:3-sync` |
| `moai-foundation-specs` | SPEC metadata policy and versioning | `/alfred:1-plan` |
| `moai-foundation-ears` | EARS templates and requirement phrasing | `/alfred:1-plan` |
| `moai-foundation-git` | GitFlow automation & PR policy | Plan/Run/Sync |
| `moai-foundation-langs` | Language detection & Skill preload | SessionStart, `/alfred:2-run` |

**Essentials Tier (4)**

| Skill | Purpose | Auto-load |
| --- | --- | --- |
| `moai-essentials-debug` | Failure diagnosis & reproduction checklist | Auto when `/alfred:2-run` detects failures |
| `moai-essentials-perf` | Performance analysis & profiling strategies | On demand |
| `moai-essentials-refactor` | Refactoring patterns & code-smell remediation | `/alfred:2-run` |
| `moai-essentials-review` | Code review checklist & quality feedback | `/alfred:3-sync` |

**Alfred Tier (11)** — Internal workflow orchestration

| Skill | Purpose | Auto-load |
| --- | --- | --- |
| `moai-alfred-code-reviewer` | Automated code quality review | `/alfred:3-sync` |
| `moai-alfred-debugger-pro` | Advanced debugging strategies | `/alfred:2-run` failures |
| `moai-alfred-ears-authoring` | EARS syntax validation & templates | `/alfred:1-plan` |
| `moai-alfred-git-workflow` | GitFlow automation patterns | Plan/Run/Sync |
| `moai-alfred-language-detection` | Stack detection & Skill preload | SessionStart, `/alfred:0-project` |
| `moai-alfred-performance-optimizer` | Performance profiling & optimization | On demand |
| `moai-alfred-refactoring-coach` | Refactoring guidance & patterns | `/alfred:2-run` |
| `moai-alfred-spec-metadata-validation` | SPEC metadata policy enforcement | `/alfred:1-plan` |
| `moai-alfred-tag-scanning` | TAG integrity & orphan detection | `/alfred:3-sync` |
| `moai-alfred-trust-validation` | TRUST 5 principle verification | All phases |
| `moai-alfred-tui-survey` | Interactive user surveys & menus | On demand |

**Domain Tier (10)** — `moai-domain-backend`, `web-api`, `frontend`, `mobile-app`, `security`, `devops`, `database`, `data-science`, `ml`, `cli-tool`.

**Language Tier (23)** — Python, TypeScript, Go, Rust, Java, Kotlin, Swift, Dart, C/C++, C#, Scala, Haskell, Elixir, Clojure, Lua, Ruby, PHP, JavaScript, SQL, Shell, Julia, R, plus supporting stacks.

**Claude Code Ops (1)** — `moai-claude-code` manages session settings, output styles, and Skill deployment.

Skills keep the core knowledge lightweight while allowing Alfred to assemble the right expertise for each request.

### Agent Collaboration Principles

- **Command precedence**: Command instructions outrank agent guidelines; follow the command if conflicts occur.
- **Single responsibility**: Each agent handles only its specialty.
- **Zero overlapping ownership**: When unsure, hand off to the agent with the most direct expertise.
- **Confidence reporting**: Always share confidence levels and identified risks when completing a task.
- **Escalation path**: When blocked, escalate to Alfred with context, attempted steps, and suggested next actions.

### Model Selection Guide

| Model | Primary use cases | Representative sub-agents | Why it fits |
| --- | --- | --- | --- |
| **Claude 4.5 Haiku** | Documentation sync, TAG inventory, Git automation, rule-based checks | doc-syncer, tag-agent, git-manager, trust-checker, quality-gate, Explore | Fast, deterministic output for patterned or string-heavy work |
| **Claude 4.5 Sonnet** | Planning, implementation, troubleshooting, session ops | Alfred, project-manager, spec-builder, code-builder pipeline, debug-helper, cc-manager | Deep reasoning, multi-step synthesis, creative problem solving |

**Guidelines**:
- Default to **Haiku** when the task is pattern-driven or requires rapid iteration; escalate to **Sonnet** for novel design, architecture, or ambiguous problem solving.
- Record any manual model switch in the task notes (who, why, expected benefit).
- Combine both models when needed: e.g., Sonnet plans a refactor, Haiku formats and validates the resulting docs.

### Alfred Command Execution Pattern (Shared)

Alfred commands follow a three-phase loop, with an optional bootstrap stage for `/alfred:0-project`.

- **Phase 0 — Bootstrap (optional)**
  Capture project metadata, create `.moai/config.json` and project docs, detect languages, and stage the recommended Skill packs.

- **Phase 1 — Analyze & Plan**
  Understand scope, constraints, and desired outputs; review existing context (files, specs, tests); outline the execution plan and surface risks.

- **Phase 2 — Execute**
  Run the approved steps in order, log progress in the task thread, escalate blockers immediately with mitigation options, and record decisions.

- **Phase 3 — Sync & Handoff**
  Update docs, TAG inventory, and reports; verify quality gates; summarize outcomes; and suggest the next command or manual follow-up.

### Alfred's Next-Step Suggestion Principles

#### Pre-suggestion Checklist

Before suggesting the next step, always verify:
- You have the latest status from agents.
- All blockers are documented with context.
- Required approvals or user confirmations are noted.
- Suggested tasks include clear owners and outcomes.
- There is at most one "must-do" suggestion per step.

**cc-manager validation sequence**

1. **SPEC** – Confirm the SPEC file exists and note its status (`draft`, `active`, `completed`, `archived`). If missing, queue `/alfred:1-plan`.
2. **TEST & CODE** – Check whether tests and implementation files exist and whether the latest test run passed. Address failing tests before proposing new work.
3. **DOCS & TAGS** – Ensure `/alfred:3-sync` is not pending, Living Docs and TAG chains are current, and no orphan TAGs remain.
4. **GIT & PR** – Review the current branch, Draft/Ready PR state, and uncommitted changes. Highlight required Git actions explicitly.
5. **BLOCKERS & APPROVALS** – List outstanding approvals, unanswered questions, TodoWrite items, or dependency risks.

> cc-manager enforces this order. Reference the most recent status output when replying, and call out the next mandatory action (or confirm that all gates have passed).

#### Poor Suggestion Examples (❌)

- Suggesting tasks already completed.
- Mixing unrelated actions in one suggestion.
- Proposing work without explaining the problem or expected result.
- Ignoring known blockers or assumptions.

#### Good Suggestion Examples (✅)

- Link the suggestion to a clear goal or risk mitigation.
- Reference evidence (logs, diffs, test output).
- Provide concrete next steps with estimated effort.

#### Suggestion Restrictions

- Do not recommend direct commits; always go through review.
- Avoid introducing new scope without confirming priority.
- Never suppress warnings or tests without review.
- Do not rely on manual verification when automation exists.

#### Suggestion Priorities

1. Resolve production blockers.
2. Restore failing tests or pipelines.
3. Close gaps against the SPEC.
4. Improve developer experience or automation.

#### Status Commands

- `/alfred status`: Summary of current phase and active agents.
- `/alfred queue`: Pending actions with owners.
- `/alfred blockers`: Known blockers and mitigation status.

### Error Message Standard (Shared)

#### Severity Icons

- 🔴 Critical failure (stop immediately)
- 🟠 Major issue (needs immediate attention)
- 🟡 Warning (monitor closely)
- 🔵 Info (no action needed)

#### Message Format

```
🔴 <Title>
- Cause: <root cause>
- Scope: <affected components>
- Evidence: <logs/screenshots/links>
- Next Step: <required action>
```

### Git Commit Message Standard (Locale-aware)

#### TDD Stage Commit Templates

| Stage    | Template                                                   |
| -------- | ---------------------------------------------------------- |
| RED      | `test: add failing test for <feature>`                     |
| GREEN    | `feat: implement <feature> to pass tests`                  |
| REFACTOR | `refactor: clean up <component> without changing behavior` |

#### Commit Structure

```
<type>(scope): <subject>

- Context of the change
- Additional notes (optional)

Refs: @TAG-ID (if applicable)
```

## Context Engineering Strategy

### 1. JIT (Just-in-Time) Retrieval

- Pull only the context required for the immediate step.
- Prefer `Explore` over manual file hunting.
- Cache critical insights in the task thread for reuse.

#### Efficient Use of Explore

- Request call graphs or dependency maps when changing core modules.
- Fetch examples from similar features before implementing new ones.
- Ask for SPEC references or TAG metadata to anchor changes.

### 2. Layered Context Summaries

1. **High-level brief**: purpose, stakeholders, success criteria.
2. **Technical core**: entry points, domain models, shared utilities.
3. **Edge cases**: known bugs, performance constraints, SLAs.

### 3. Living Documentation Sync

- Align code, tests, and docs after each significant change.
- Use `/alfred:3-sync` to update Living Docs and TAG references.
- Record rationale for deviations from the SPEC.

## Clarification & Interactive Prompting

### The "Vibe Coding" Challenge

**Vibe Coding** refers to requesting AI assistance with minimal context, expecting the AI to infer intent from incomplete instructions. While this approach works for experienced developers with high-context understanding of their codebase, it often results in:

- ❌ Ambiguous or conflicting implementations
- ❌ Unnecessary modifications to existing code
- ❌ Multiple rounds of back-and-forth refinement
- ❌ Wasted time clarifying intent

**Root cause**: AI must *guess* user intent without explicit guidance.

### Solution: Interactive Question Tool + TUI Survey Skill

Claude Code now features an **Interactive Question Tool** powered by the `moai-alfred-tui-survey` Skill that transforms vague requests into precise, contextual specifications through guided clarification. Instead of AI making assumptions, the tool actively:

1. **Analyzes** existing code and project context
2. **Identifies** ambiguity and competing approaches
3. **Presents** concrete options with clear trade-offs via **TUI menu**
4. **Captures** explicit user choices (arrow keys, enter)
5. **Executes** with certainty based on confirmed intent

**Implementation**: The `moai-alfred-tui-survey` Skill provides interactive survey menus that render as terminal UI elements, allowing users to navigate options with arrow keys and confirm with enter.

### How It Works

When you provide a high-level request, Alfred may invoke the `moai-alfred-tui-survey` Skill to clarify implementation details through structured TUI menus:

```
User: "Add a completion page for the competition."
         ↓
Alfred analyzes codebase & context
         ↓
[QUESTION 1] How should the completion page be implemented?
┌─────────────────────────────────────────────────────┐
│ ▶ Create a new public page                          │  ← arrow keys to select
│   Modify existing page structure                    │
│   Use environment-based gating                      │
│                                                     │
│ (press ↑↓ to navigate, enter to confirm)           │
└─────────────────────────────────────────────────────┘
         ↓
[QUESTION 2] Who should see the completion page?
┌─────────────────────────────────────────────────────┐
│   Only participants (authenticated users)           │
│ ▶ All visitors (public)                             │
│   Based on time window                              │
│                                                     │
│ (press ↑↓ to navigate, enter to confirm)           │
└─────────────────────────────────────────────────────┘
         ↓
[REVIEW] Summary of your selections
┌─────────────────────────────────────────────────────┐
│ ✓ Implementation: New public page                   │
│ ✓ User experience: All visitors (public)            │
│                                                     │
│ Ready to submit?                                    │
│  [Submit answers] [← Go back]                       │
└─────────────────────────────────────────────────────┘
         ↓
Execution with confirmed specifications
```

**Where it's used**:
- Sub-agents (spec-builder, code-builder pipeline) invoke this skill when ambiguity is detected
- Alfred commands may trigger interactive surveys during Plan/Run/Sync phases
- User approvals and architectural decisions benefit most from TUI-based selection

### Key Benefits

| Benefit | Impact |
| --- | --- |
| **Reduced ambiguity** | AI asks before acting; eliminates guess work |
| **Faster iteration** | Choices are presented upfront, not discovered after implementation |
| **Higher quality** | Implementation matches intent precisely |
| **Lower communication cost** | Answering 3-5 specific questions beats endless refinement |
| **Active collaboration** | AI becomes a partner, not just a code generator |

### When to Use Interactive Questions

**Ideal for**:
- 🎯 Complex features with multiple valid approaches
- 🎯 Architectural decisions with trade-offs
- 🎯 Ambiguous or high-level requirements
- 🎯 Requests that affect multiple existing components
- 🎯 Decisions involving user experience or data flow

**Example triggers**:
- "Add a dashboard" → needs clarification on layout, data sources, authentication
- "Refactor the auth system" → needs clarification on scope, backwards compatibility, migration strategy
- "Optimize performance" → needs clarification on which bottleneck, acceptable trade-offs
- "Add multi-language support" → needs clarification on scope, default language, i18n library

### Best Practices for Interactive Prompting

1. **Provide initial context** (even if vague)
   - ✅ "Add a competition results page"
   - ❌ "Do something"

2. **Trust the guided questions**
   - AI will ask if it detects ambiguity
   - Answer each question honestly, don't over-explain
   - Use "Other" option to provide custom input if preset options don't fit

3. **Review before submission**
   - The summary step lets you verify all choices
   - Use "back" to revise any answer
   - Only submit when you're confident in the selections

4. **Iterative refinement is OK**
   - If implementation doesn't match intent, re-run with clearer guidance
   - Your answers inform Alfred's future prompting
   - This feedback loop improves collaboration quality

5. **Combine with Context Engineering**
   - Provide high-level intent + let interactive questions fill in details
   - Reference existing code patterns ("like the auth flow in `/src/auth.ts`")
   - Mention constraints or non-negotiables upfront

### Example: Competition Completion Page (TUI Survey)

**User Request**: "Competition is over. Add a completion page."

**Step 1: Code Analysis**
Alfred scans the codebase and detects:
- Existing `/end` page (auth required, shows results)
- Need for clarification on scope and user behavior

**Step 2: Interactive Survey (moai-alfred-tui-survey activated)**

```
────────────────────────────────────────────────────────────────
ALFRED: How should the completion page be implemented?
────────────────────────────────────────────────────────────────

┌─ IMPLEMENTATION APPROACH ────────────────────────────────────┐
│                                                              │
│ ▶ Create a new public page (/competition-closed)            │
│   • Unguarded route, visible to all visitors                │
│   • No authentication required                              │
│                                                              │
│   Modify existing /end page with conditional logic          │
│   • Check if competition is active before showing results   │
│                                                              │
│   Use environment-based gating                              │
│   • Set NEXT_PUBLIC_COMPETITION_CLOSED=true                │
│   • Redirect all traffic to completion screen               │
│                                                              │
│ Use ↑↓ arrows to navigate, ENTER to select                 │
│ Type custom answer or press ESC to cancel                   │
└──────────────────────────────────────────────────────────────┘

→ Selection: Create a new public page (/competition-closed)
```

```
────────────────────────────────────────────────────────────────
ALFRED: For logged-in participants accessing the new page?
────────────────────────────────────────────────────────────────

┌─ USER BEHAVIOR ──────────────────────────────────────────────┐
│                                                              │
│   Show submission history                                   │
│   • Redirect to /end page, display results & timeline       │
│                                                              │
│ ▶ Show simple completion message only                       │
│   • Display "Competition concluded" notice                  │
│   • No historical data shown                                │
│                                                              │
│   Custom behavior based on user role                        │
│   • Different experience per role type                      │
│                                                              │
│ Use ↑↓ arrows to navigate, ENTER to select                 │
│ Type custom answer or press ESC to cancel                   │
└──────────────────────────────────────────────────────────────┘

→ Selection: Show simple completion message only
```

**Step 3: Review & Confirmation**

```
────────────────────────────────────────────────────────────────
ALFRED: Review your answers
────────────────────────────────────────────────────────────────

┌─ SUMMARY ────────────────────────────────────────────────────┐
│                                                              │
│ ✓ Implementation approach:                                  │
│   Create a new public page (/competition-closed)            │
│                                                              │
│ ✓ User behavior:                                            │
│   Show simple completion message only                       │
│                                                              │
│ Ready to submit these answers?                              │
│                                                              │
│  [✓ Submit answers]  [← Go back and modify]                │
│                                                              │
└──────────────────────────────────────────────────────────────┘

→ Action: Submit answers (enter)
```

**Step 4: Execution**

Alfred now executes with **confirmed specifications**:
- ✅ Creates `/app/competition-closed/page.tsx` (public route)
- ✅ Implements simple "Competition concluded" message
- ✅ Handles authenticated users appropriately
- ✅ Generates with SPEC → TDD → Sync flow

**Result**: Clean, intentional implementation that exactly matches confirmed specifications.
No guessing. No ambiguity. Direct execution. 🎯

## Commands · Sub-agents · Skills · Hooks

MoAI-ADK assigns every responsibility to a dedicated execution layer.

### Commands — Workflow orchestration

- User-facing entry points that enforce the Plan → Run → Sync cadence.
- Examples: `/alfred:0-project`, `/alfred:1-plan`, `/alfred:2-run`, `/alfred:3-sync`.
- Coordinate multiple sub-agents, manage approvals, and track progress.

### Sub-agents — Deep reasoning & decision making

- Task-focused specialists (Sonnet/Haiku) that analyze, design, or validate.
- Examples: spec-builder, code-builder pipeline, doc-syncer, tag-agent, git-manager.
- Communicate status, escalate blockers, and request Skills when additional knowledge is required.

### Skills — Reusable knowledge capsules (55 packs)

- <500-word playbooks stored under `.claude/skills/`.
- Loaded via Progressive Disclosure only when relevant.
- Provide standard templates, best practices, and checklists across Foundation, Essentials, Alfred, Domain, Language, and Ops tiers.

### Hooks — Guardrails & just-in-time context

- Lightweight (<100 ms) checks triggered by session events.
- Block destructive commands, surface status cards, and seed context pointers.
- Examples: SessionStart project summary, PreToolUse safety checks.

### Selecting the right layer

1. Runs automatically on an event? → **Hook**.
2. Requires reasoning or conversation? → **Sub-agent**.
3. Encodes reusable knowledge or policy? → **Skill**.
4. Orchestrates multiple steps or approvals? → **Command**.

Combine layers when necessary: a command triggers sub-agents, sub-agents activate Skills, and Hooks keep the session safe.

## Core Philosophy

- **SPEC-first**: requirements drive implementation and tests.
- **Automation-first**: trust repeatable pipelines over manual checks.
- **Transparency**: every decision, assumption, and risk is documented.
- **Traceability**: @TAG links code, tests, docs, and history.

## Three-phase Development Workflow

> Phase 0 (`/alfred:0-project`) bootstraps project metadata and resources before the cycle begins.

1. **SPEC**: Define requirements with `/alfred:1-plan`.
2. **BUILD**: Implement via `/alfred:2-run` (TDD loop).
3. **SYNC**: Align docs/tests using `/alfred:3-sync`.

### Fully Automated GitFlow

1. Create feature branch via command.
2. Follow RED → GREEN → REFACTOR commits.
3. Run automated QA gates.
4. Merge with traceable @TAG references.

## On-demand Agent Usage

### Debugging & Analysis

- Use `debug-helper` for error triage and hypothesis testing.
- Attach logs, stack traces, and reproduction steps.
- Ask for fix-forward vs rollback recommendations.

### TAG System Management

- Assign IDs as `<DOMAIN>-<###>` (e.g., `AUTH-003`).
- Update HISTORY with every change.
- Cross-check usage with `rg '@TAG:ID' -n` searches.

### Backup Management

- `/alfred:0-project` and `git-manager` create automatic safety snapshots (e.g., `.moai-backups/`) before risky actions.
- Manual `/alfred:9-checkpoint` commands have been deprecated; rely on Git branches or team-approved backup workflows when additional restore points are needed.

## @TAG Lifecycle

### Core Principles

- TAG IDs never change once assigned.
- Content can evolve; log updates in HISTORY.
- Tie implementations and tests to the same TAG.

### TAG Structure

- `@SPEC:ID` in specs
- `@CODE:ID` in source
- `@TEST:ID` in tests
- `@DOC:ID` in docs

### TAG Block Template

```
// @CODE:AUTH-001 | SPEC: SPEC-AUTH-001.md | TEST: tests/auth/service.test.ts
```

## HISTORY

### v0.0.1 (2025-09-15)

- **INITIAL**: Draft the JWT-based authentication SPEC.

### TAG Core Rules

- **TAG ID**: `<Domain>-<3 digits>` (e.g., `AUTH-003`) — immutable.
- **TAG Content**: Flexible but record changes in HISTORY.
- **Versioning**: Semantic Versioning (`v0.0.1 → v0.1.0 → v1.0.0`).
  - Detailed rules: see `@.moai/memory/spec-metadata.md#versioning`.
- **TAG References**: Use file names without versions (e.g., `SPEC-AUTH-001.md`).
- **Duplicate Check**: `rg "@SPEC:AUTH" -n` or `rg "AUTH-001" -n`.
- **Code-first**: The source of truth lives in code.

### @CODE Subcategories (Comment Level)

- `@CODE:ID:API` — REST/GraphQL endpoints
- `@CODE:ID:UI` — Components and UI
- `@CODE:ID:DATA` — Data models, schemas, types
- `@CODE:ID:DOMAIN` — Business logic
- `@CODE:ID:INFRA` — Infra, databases, integrations

### TAG Validation & Integrity

**Avoid duplicates**:
```bash
rg "@SPEC:AUTH" -n          # Search AUTH specs
rg "@CODE:AUTH-001" -n      # Targeted ID search
rg "AUTH-001" -n            # Global ID search
```

**TAG chain verification** (`/alfred:3-sync` runs automatically):
```bash
rg '@(SPEC|TEST|CODE|DOC):' -n .moai/specs/ tests/ src/ docs/

# Detect orphaned TAGs
rg '@CODE:AUTH-001' -n src/          # CODE exists
rg '@SPEC:AUTH-001' -n .moai/specs/  # SPEC missing → orphan
```

---

## TRUST 5 Principles (Language-agnostic)

> Detailed guide: `@.moai/memory/development-guide.md#trust-5-principles`

Alfred enforces these quality gates on every change:

- **T**est First: Use the best testing tool per language (Jest/Vitest, pytest, go test, cargo test, JUnit, flutter test, ...).
- **R**eadable: Run linters (ESLint/Biome, ruff, golint, clippy, dart analyze, ...).
- **U**nified: Ensure type safety or runtime validation.
- **S**ecured: Apply security/static analysis tools.
- **T**rackable: Maintain @TAG coverage directly in code.

**Language-specific guidance**: `.moai/memory/development-guide.md#trust-5-principles`.

---

## Language-specific Code Rules

**Global constraints**:
- Files ≤ 300 LOC
- Functions ≤ 50 LOC
- Parameters ≤ 5
- Cyclomatic complexity ≤ 10

**Quality targets**:
- Test coverage ≥ 85%
- Intent-revealing names
- Early guard clauses
- Use language-standard tooling

**Testing strategy**:
- Prefer the standard framework per language
- Keep tests isolated and deterministic
- Derive cases directly from the SPEC

---

## TDD Workflow Checklist

**Step 1: SPEC authoring** (`/alfred:1-plan`)
- [ ] Create `.moai/specs/SPEC-<ID>/spec.md` (with directory structure)
- [ ] Add YAML front matter (id, version: 0.0.1, status: draft, created)
- [ ] Include the `@SPEC:ID` TAG
- [ ] Write the **HISTORY** section (v0.0.1 INITIAL)
- [ ] Use EARS syntax for requirements
- [ ] Check for duplicate IDs: `rg "@SPEC:<ID>" -n`

**Step 2: TDD implementation** (`/alfred:2-run`)
- [ ] **RED**: Write `@TEST:ID` under `tests/` and watch it fail
- [ ] **GREEN**: Add `@CODE:ID` under `src/` and make the test pass
- [ ] **REFACTOR**: Improve code quality; document TDD history in comments
- [ ] List SPEC/TEST file paths in the TAG block

**Step 3: Documentation sync** (`/alfred:3-sync`)
- [ ] Scan TAGs: `rg '@(SPEC|TEST|CODE):' -n`
- [ ] Ensure no orphan TAGs remain
- [ ] Regenerate the Living Document
- [ ] Move PR status from Draft → Ready

---

## Project Information

- **Name**: {{PROJECT_NAME}}
- **Description**: {{PROJECT_DESCRIPTION}}
- **Version**: {{PROJECT_VERSION}}
- **Mode**: {{PROJECT_MODE}}
- **Conversation Language**: {{CONVERSATION_LANGUAGE}} ({{CONVERSATION_LANGUAGE_NAME}})
- **Codebase Language**: {{CODEBASE_LANGUAGE}}
- **Toolchain**: Automatically selects the best tools for the chosen language

### Language Configuration

- **Conversation Language** (`{{CONVERSATION_LANGUAGE}}`): All Alfred dialogs, documentation, and project interviews conducted in this language
- **Codebase Language** (`{{CODEBASE_LANGUAGE}}`): Primary programming language(s) detected in this project
- **Documentation**: Generated in the conversation language ({{CONVERSATION_LANGUAGE_NAME}})

---

**Note**: The conversation language is selected at the beginning of `/alfred:0-project` and applies to all subsequent project initialization steps. All generated documentation (product.md, structure.md, tech.md) will be created in the selected language.
