# coding: utf-8

"""
    Seeq REST API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)  # noqa: E501

    OpenAPI spec version: 66.32.1-v202508062319-CD
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import sys
import os
import re

from deprecated import deprecated
# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient
from ..models import *

class ConditionMonitorsApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def archive_condition_monitor(self, **kwargs):
        """
        Archive a condition monitor
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.archive_condition_monitor(id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: ID of the condition monitor to archive. (required)
        :return: ArchiveOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ArchiveOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.archive_condition_monitor_with_http_info(**kwargs)
        else:
            (data) = self.archive_condition_monitor_with_http_info(**kwargs)
            return data

    def archive_condition_monitor_with_http_info(self, **kwargs):
        """
        Archive a condition monitor
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.archive_condition_monitor_with_http_info(id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: ID of the condition monitor to archive. (required)
        :return: ArchiveOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ArchiveOutputV1
        """

        all_params = ['id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method archive_condition_monitor" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `archive_condition_monitor`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/condition-monitors/{id}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'ArchiveOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_condition_monitor(self, **kwargs):
        """
        Create a new condition monitor
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_condition_monitor(body=body_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ConditionMonitorInputV1 body: (required)
        :return: ConditionMonitorOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ConditionMonitorOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_condition_monitor_with_http_info(**kwargs)
        else:
            (data) = self.create_condition_monitor_with_http_info(**kwargs)
            return data

    def create_condition_monitor_with_http_info(self, **kwargs):
        """
        Create a new condition monitor
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_condition_monitor_with_http_info(body=body_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ConditionMonitorInputV1 body: (required)
        :return: ConditionMonitorOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ConditionMonitorOutputV1
        """

        all_params = ['body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_condition_monitor" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_condition_monitor`")


        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/condition-monitors', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'ConditionMonitorOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_condition_monitor(self, **kwargs):
        """
        Get a condition monitor
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_condition_monitor(id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: The Seeq ID for the condition monitor (required)
        :return: ConditionMonitorOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ConditionMonitorOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_condition_monitor_with_http_info(**kwargs)
        else:
            (data) = self.get_condition_monitor_with_http_info(**kwargs)
            return data

    def get_condition_monitor_with_http_info(self, **kwargs):
        """
        Get a condition monitor
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_condition_monitor_with_http_info(id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: The Seeq ID for the condition monitor (required)
        :return: ConditionMonitorOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ConditionMonitorOutputV1
        """

        all_params = ['id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_condition_monitor" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_condition_monitor`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/condition-monitors/{id}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'ConditionMonitorOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_condition_monitor_metadata_list(self, **kwargs):
        """
        Get a list of metadata associated with condition monitors, including various properties that define their current state and behavior
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_condition_monitor_metadata_list(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] creator_ids: Filter items to only those created by the specified user IDs
        :param str name_search: Filter the items to those whose name match any part of the specified string
        :param str workbook_search: Filter the items to those whose condition are scoped to workbooks that match any part of the specified string
        :param list[str] condition_ids: Filter items to only those that are monitoring one of the specified conditions as specified by the list of IDs
        :param bool enabled_filter: Filter items by their enabled status
        :param str workbook_type_filter: Filter items by the type of workbook they are scoped to
        :param int offset: The pagination offset, the number of items that will be skipped.
        :param int limit: The pagination limit, the total number of items that will be returned in this page of results
        :param str sort_by: Order the items by either name, workbook or createdAt
        :param bool sort_asc: Sorts the sort field in ascending order when true and descending when false
        :return: ConditionMonitorMetadataOutputListV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ConditionMonitorMetadataOutputListV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_condition_monitor_metadata_list_with_http_info(**kwargs)
        else:
            (data) = self.get_condition_monitor_metadata_list_with_http_info(**kwargs)
            return data

    def get_condition_monitor_metadata_list_with_http_info(self, **kwargs):
        """
        Get a list of metadata associated with condition monitors, including various properties that define their current state and behavior
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_condition_monitor_metadata_list_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] creator_ids: Filter items to only those created by the specified user IDs
        :param str name_search: Filter the items to those whose name match any part of the specified string
        :param str workbook_search: Filter the items to those whose condition are scoped to workbooks that match any part of the specified string
        :param list[str] condition_ids: Filter items to only those that are monitoring one of the specified conditions as specified by the list of IDs
        :param bool enabled_filter: Filter items by their enabled status
        :param str workbook_type_filter: Filter items by the type of workbook they are scoped to
        :param int offset: The pagination offset, the number of items that will be skipped.
        :param int limit: The pagination limit, the total number of items that will be returned in this page of results
        :param str sort_by: Order the items by either name, workbook or createdAt
        :param bool sort_asc: Sorts the sort field in ascending order when true and descending when false
        :return: ConditionMonitorMetadataOutputListV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ConditionMonitorMetadataOutputListV1
        """

        all_params = ['creator_ids', 'name_search', 'workbook_search', 'condition_ids', 'enabled_filter', 'workbook_type_filter', 'offset', 'limit', 'sort_by', 'sort_asc']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_condition_monitor_metadata_list" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'creator_ids' in params:
            query_params.append(('creatorIds', params['creator_ids']))
            collection_formats['creatorIds'] = 'multi'
        if 'name_search' in params:
            query_params.append(('nameSearch', params['name_search']))
        if 'workbook_search' in params:
            query_params.append(('workbookSearch', params['workbook_search']))
        if 'condition_ids' in params:
            query_params.append(('conditionIds', params['condition_ids']))
            collection_formats['conditionIds'] = 'multi'
        if 'enabled_filter' in params:
            query_params.append(('enabledFilter', params['enabled_filter']))
        if 'workbook_type_filter' in params:
            query_params.append(('workbookTypeFilter', params['workbook_type_filter']))
        if 'offset' in params:
            query_params.append(('offset', params['offset']))
        if 'limit' in params:
            query_params.append(('limit', params['limit']))
        if 'sort_by' in params:
            query_params.append(('sortBy', params['sort_by']))
        if 'sort_asc' in params:
            query_params.append(('sortAsc', params['sort_asc']))

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/condition-monitors/metadata', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'ConditionMonitorMetadataOutputListV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_condition_monitor_suppressions(self, **kwargs):
        """
        Get suppressed conditions for a condition monitor
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_condition_monitor_suppressions(id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: The Seeq ID for the condition monitor (required)
        :return: list[SuppressedConditionOutputV1]
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[SuppressedConditionOutputV1]
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_condition_monitor_suppressions_with_http_info(**kwargs)
        else:
            (data) = self.get_condition_monitor_suppressions_with_http_info(**kwargs)
            return data

    def get_condition_monitor_suppressions_with_http_info(self, **kwargs):
        """
        Get suppressed conditions for a condition monitor
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_condition_monitor_suppressions_with_http_info(id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: The Seeq ID for the condition monitor (required)
        :return: list[SuppressedConditionOutputV1]
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[SuppressedConditionOutputV1]
        """

        all_params = ['id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_condition_monitor_suppressions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_condition_monitor_suppressions`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/condition-monitors/{id}/suppressions', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'list[SuppressedConditionOutputV1]'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_condition_monitors(self, **kwargs):
        """
        Get a list of condition monitors
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_condition_monitors(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] executor_ids: Filter condition monitors to only those created by the specified user IDs
        :param str name_search: Filter the condition monitors to those whose name match any part of the specified string
        :param list[str] condition_ids: Filter condition monitors to only those that are monitoring one of the specified conditions as specified by the list of IDs
        :param bool enabled_filter: Filter condition monitors by their enabled status
        :param int offset: Whether to filter condition monitors to only users who are enabled.
        :param int limit: The pagination limit, the total number of condition monitor that will be returned in this page of results
        :param str sort_field: Orders the condition monitors by either name, createdAt or workbook
        :param bool sort_asc: Sorts the sort field in ascending order when true and descending when false
        :return: GetConditionMonitorItemsOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetConditionMonitorItemsOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_condition_monitors_with_http_info(**kwargs)
        else:
            (data) = self.get_condition_monitors_with_http_info(**kwargs)
            return data

    def get_condition_monitors_with_http_info(self, **kwargs):
        """
        Get a list of condition monitors
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_condition_monitors_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] executor_ids: Filter condition monitors to only those created by the specified user IDs
        :param str name_search: Filter the condition monitors to those whose name match any part of the specified string
        :param list[str] condition_ids: Filter condition monitors to only those that are monitoring one of the specified conditions as specified by the list of IDs
        :param bool enabled_filter: Filter condition monitors by their enabled status
        :param int offset: Whether to filter condition monitors to only users who are enabled.
        :param int limit: The pagination limit, the total number of condition monitor that will be returned in this page of results
        :param str sort_field: Orders the condition monitors by either name, createdAt or workbook
        :param bool sort_asc: Sorts the sort field in ascending order when true and descending when false
        :return: GetConditionMonitorItemsOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetConditionMonitorItemsOutputV1
        """

        all_params = ['executor_ids', 'name_search', 'condition_ids', 'enabled_filter', 'offset', 'limit', 'sort_field', 'sort_asc']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_condition_monitors" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'executor_ids' in params:
            query_params.append(('executorIds', params['executor_ids']))
            collection_formats['executorIds'] = 'multi'
        if 'name_search' in params:
            query_params.append(('nameSearch', params['name_search']))
        if 'condition_ids' in params:
            query_params.append(('conditionIds', params['condition_ids']))
            collection_formats['conditionIds'] = 'multi'
        if 'enabled_filter' in params:
            query_params.append(('enabledFilter', params['enabled_filter']))
        if 'offset' in params:
            query_params.append(('offset', params['offset']))
        if 'limit' in params:
            query_params.append(('limit', params['limit']))
        if 'sort_field' in params:
            query_params.append(('sortField', params['sort_field']))
        if 'sort_asc' in params:
            query_params.append(('sortAsc', params['sort_asc']))

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/condition-monitors', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'GetConditionMonitorItemsOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_monitored_conditions(self, **kwargs):
        """
        Get a list of monitored conditions for a condition monitor
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_monitored_conditions(condition_monitor_id=condition_monitor_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str condition_monitor_id: (required)
        :return: MonitoredConditionOutputListV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: MonitoredConditionOutputListV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_monitored_conditions_with_http_info(**kwargs)
        else:
            (data) = self.get_monitored_conditions_with_http_info(**kwargs)
            return data

    def get_monitored_conditions_with_http_info(self, **kwargs):
        """
        Get a list of monitored conditions for a condition monitor
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_monitored_conditions_with_http_info(condition_monitor_id=condition_monitor_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str condition_monitor_id: (required)
        :return: MonitoredConditionOutputListV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: MonitoredConditionOutputListV1
        """

        all_params = ['condition_monitor_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_monitored_conditions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'condition_monitor_id' is set
        if ('condition_monitor_id' not in params) or (params['condition_monitor_id'] is None):
            raise ValueError("Missing the required parameter `condition_monitor_id` when calling `get_monitored_conditions`")


        collection_formats = {}

        path_params = {}
        if 'condition_monitor_id' in params:
            path_params['conditionMonitorId'] = params['condition_monitor_id']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/condition-monitors/{conditionMonitorId}/conditions', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'MonitoredConditionOutputListV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def run_condition_monitor_job(self, **kwargs):
        """
        Triggers an immediate execution of the condition monitor job if it is not currently running. If the job is already, run after current job completes.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.run_condition_monitor_job(body=body_value, id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param RunConditionMonitorJobInputV1 body: (required)
        :param str id: The Seeq ID for the condition monitor (required)
        :return: StatusMessageBase
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StatusMessageBase
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.run_condition_monitor_job_with_http_info(**kwargs)
        else:
            (data) = self.run_condition_monitor_job_with_http_info(**kwargs)
            return data

    def run_condition_monitor_job_with_http_info(self, **kwargs):
        """
        Triggers an immediate execution of the condition monitor job if it is not currently running. If the job is already, run after current job completes.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.run_condition_monitor_job_with_http_info(body=body_value, id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param RunConditionMonitorJobInputV1 body: (required)
        :param str id: The Seeq ID for the condition monitor (required)
        :return: StatusMessageBase
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StatusMessageBase
        """

        all_params = ['body', 'id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method run_condition_monitor_job" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `run_condition_monitor_job`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `run_condition_monitor_job`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/condition-monitors/{id}/run', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'StatusMessageBase'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def suppress_conditions(self, **kwargs):
        """
        Suppress one or more conditions in a condition monitor
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.suppress_conditions(body=body_value, id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[SuppressConditionInputV1] body: (required)
        :param str id: The Seeq ID for the condition monitor (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.suppress_conditions_with_http_info(**kwargs)
        else:
            (data) = self.suppress_conditions_with_http_info(**kwargs)
            return data

    def suppress_conditions_with_http_info(self, **kwargs):
        """
        Suppress one or more conditions in a condition monitor
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.suppress_conditions_with_http_info(body=body_value, id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[SuppressConditionInputV1] body: (required)
        :param str id: The Seeq ID for the condition monitor (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        all_params = ['body', 'id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method suppress_conditions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `suppress_conditions`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `suppress_conditions`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/condition-monitors/{id}/suppress', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', None),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def unsuppress_conditions(self, **kwargs):
        """
        Unsuppress one or more conditions in a condition monitor
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.unsuppress_conditions(body=body_value, id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] body: Array of condition IDs to unsuppress (required)
        :param str id: The Seeq ID for the condition monitor (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.unsuppress_conditions_with_http_info(**kwargs)
        else:
            (data) = self.unsuppress_conditions_with_http_info(**kwargs)
            return data

    def unsuppress_conditions_with_http_info(self, **kwargs):
        """
        Unsuppress one or more conditions in a condition monitor
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.unsuppress_conditions_with_http_info(body=body_value, id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] body: Array of condition IDs to unsuppress (required)
        :param str id: The Seeq ID for the condition monitor (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        all_params = ['body', 'id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method unsuppress_conditions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `unsuppress_conditions`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `unsuppress_conditions`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/condition-monitors/{id}/unsuppress', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', None),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_condition_monitor(self, **kwargs):
        """
        Update a condition monitor
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_condition_monitor(body=body_value, id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ConditionMonitorInputV1 body: (required)
        :param str id: The Seeq ID for the condition monitor (required)
        :return: ConditionMonitorOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ConditionMonitorOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_condition_monitor_with_http_info(**kwargs)
        else:
            (data) = self.update_condition_monitor_with_http_info(**kwargs)
            return data

    def update_condition_monitor_with_http_info(self, **kwargs):
        """
        Update a condition monitor
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_condition_monitor_with_http_info(body=body_value, id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ConditionMonitorInputV1 body: (required)
        :param str id: The Seeq ID for the condition monitor (required)
        :return: ConditionMonitorOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ConditionMonitorOutputV1
        """

        all_params = ['body', 'id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_condition_monitor" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_condition_monitor`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_condition_monitor`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/condition-monitors/{id}', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'ConditionMonitorOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
