# coding: utf-8

"""
    Seeq REST API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)  # noqa: E501

    OpenAPI spec version: 66.32.1-v202508062319-CD
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import sys
import os
import re

from deprecated import deprecated
# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient
from ..models import *

class FormulasApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    @deprecated(reason="Use the DELETE /items/{id}/cache (itemsApi clearCache) instead")
    def clear_cache(self, **kwargs):
        """
        Clear all formula caches. This method is deprecated
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.clear_cache(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: StatusMessageBase
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StatusMessageBase
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.clear_cache_with_http_info(**kwargs)
        else:
            (data) = self.clear_cache_with_http_info(**kwargs)
            return data

    @deprecated(reason="Use the DELETE /items/{id}/cache (itemsApi clearCache) instead")
    def clear_cache_with_http_info(self, **kwargs):
        """
        Clear all formula caches. This method is deprecated
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.clear_cache_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: StatusMessageBase
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StatusMessageBase
        """

        all_params = []
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method clear_cache" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/formulas/clearCache', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'StatusMessageBase'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    @deprecated(reason="Use the POST /compile (compileFormulaAndParameters) instead, because compileFormula fails on long input.")
    def compile_formula(self, **kwargs):
        """
        Compile a Seeq Formula. This method is deprecated.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.compile_formula(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str formula: A formula to be applied.
        :param list[str] parameters: Parameters for the formula. Each parameter should have a format of 'name=id' where 'name' is the variable identifier, without the leading $ sign, and 'id' is the ID of the item referenced by the variable.
        :return: FormulaCompileOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FormulaCompileOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.compile_formula_with_http_info(**kwargs)
        else:
            (data) = self.compile_formula_with_http_info(**kwargs)
            return data

    @deprecated(reason="Use the POST /compile (compileFormulaAndParameters) instead, because compileFormula fails on long input.")
    def compile_formula_with_http_info(self, **kwargs):
        """
        Compile a Seeq Formula. This method is deprecated.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.compile_formula_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str formula: A formula to be applied.
        :param list[str] parameters: Parameters for the formula. Each parameter should have a format of 'name=id' where 'name' is the variable identifier, without the leading $ sign, and 'id' is the ID of the item referenced by the variable.
        :return: FormulaCompileOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FormulaCompileOutputV1
        """

        all_params = ['formula', 'parameters']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method compile_formula" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'formula' in params:
            query_params.append(('formula', params['formula']))
        if 'parameters' in params:
            query_params.append(('parameters', params['parameters']))
            collection_formats['parameters'] = 'multi'

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/formulas/compile', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'FormulaCompileOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def compile_formula_and_parameters(self, **kwargs):
        """
        Compile a Seeq Formula. Use this endpoint instead of GET /compile when the input is large.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.compile_formula_and_parameters(body=body_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param FormulaCompileInputV1 body: Seeq Formula to compile and its parameters (required)
        :return: FormulaCompileOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FormulaCompileOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.compile_formula_and_parameters_with_http_info(**kwargs)
        else:
            (data) = self.compile_formula_and_parameters_with_http_info(**kwargs)
            return data

    def compile_formula_and_parameters_with_http_info(self, **kwargs):
        """
        Compile a Seeq Formula. Use this endpoint instead of GET /compile when the input is large.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.compile_formula_and_parameters_with_http_info(body=body_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param FormulaCompileInputV1 body: Seeq Formula to compile and its parameters (required)
        :return: FormulaCompileOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FormulaCompileOutputV1
        """

        all_params = ['body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method compile_formula_and_parameters" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `compile_formula_and_parameters`")


        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/formulas/compile', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'FormulaCompileOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_function(self, **kwargs):
        """
        Create a function
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_function(body=body_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param FunctionInputV1 body: Function information (required)
        :return: CalculatedItemOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CalculatedItemOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_function_with_http_info(**kwargs)
        else:
            (data) = self.create_function_with_http_info(**kwargs)
            return data

    def create_function_with_http_info(self, **kwargs):
        """
        Create a function
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_function_with_http_info(body=body_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param FunctionInputV1 body: Function information (required)
        :return: CalculatedItemOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CalculatedItemOutputV1
        """

        all_params = ['body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_function" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_function`")


        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/formulas/functions', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'CalculatedItemOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_item(self, **kwargs):
        """
        Create a formula item
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_item(body=body_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param FormulaItemInputV1 body: Item information (required)
        :return: FormulaItemOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FormulaItemOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_item_with_http_info(**kwargs)
        else:
            (data) = self.create_item_with_http_info(**kwargs)
            return data

    def create_item_with_http_info(self, **kwargs):
        """
        Create a formula item
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_item_with_http_info(body=body_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param FormulaItemInputV1 body: Item information (required)
        :return: FormulaItemOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FormulaItemOutputV1
        """

        all_params = ['body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_item`")


        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/formulas/items', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'FormulaItemOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_formula_doc(self, **kwargs):
        """
        Permanently delete the specified formula doc
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_formula_doc(package_name=package_name_value, doc_name=doc_name_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str package_name: The name of the package (required)
        :param str doc_name: The name of the formula doc (required)
        :return: StatusMessageBase
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StatusMessageBase
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_formula_doc_with_http_info(**kwargs)
        else:
            (data) = self.delete_formula_doc_with_http_info(**kwargs)
            return data

    def delete_formula_doc_with_http_info(self, **kwargs):
        """
        Permanently delete the specified formula doc
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_formula_doc_with_http_info(package_name=package_name_value, doc_name=doc_name_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str package_name: The name of the package (required)
        :param str doc_name: The name of the formula doc (required)
        :return: StatusMessageBase
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StatusMessageBase
        """

        all_params = ['package_name', 'doc_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_formula_doc" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'package_name' is set
        if ('package_name' not in params) or (params['package_name'] is None):
            raise ValueError("Missing the required parameter `package_name` when calling `delete_formula_doc`")
        # verify the required parameter 'doc_name' is set
        if ('doc_name' not in params) or (params['doc_name'] is None):
            raise ValueError("Missing the required parameter `doc_name` when calling `delete_formula_doc`")


        collection_formats = {}

        path_params = {}
        if 'package_name' in params:
            path_params['packageName'] = params['package_name']
        if 'doc_name' in params:
            path_params['docName'] = params['doc_name']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/formulas/docs/{packageName}/{docName}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'StatusMessageBase'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_function(self, **kwargs):
        """
        Permanently delete a specific user defined formula function
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_function(id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: The id of the user defined formula function (required)
        :return: StatusMessageBase
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StatusMessageBase
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_function_with_http_info(**kwargs)
        else:
            (data) = self.delete_function_with_http_info(**kwargs)
            return data

    def delete_function_with_http_info(self, **kwargs):
        """
        Permanently delete a specific user defined formula function
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_function_with_http_info(id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: The id of the user defined formula function (required)
        :return: StatusMessageBase
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StatusMessageBase
        """

        all_params = ['id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_function" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_function`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/formulas/functions/{id}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'StatusMessageBase'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_package(self, **kwargs):
        """
        Permanently delete a specific package
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_package(package_name=package_name_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str package_name: The name of the package (required)
        :return: StatusMessageBase
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StatusMessageBase
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_package_with_http_info(**kwargs)
        else:
            (data) = self.delete_package_with_http_info(**kwargs)
            return data

    def delete_package_with_http_info(self, **kwargs):
        """
        Permanently delete a specific package
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_package_with_http_info(package_name=package_name_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str package_name: The name of the package (required)
        :return: StatusMessageBase
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StatusMessageBase
        """

        all_params = ['package_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_package" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'package_name' is set
        if ('package_name' not in params) or (params['package_name'] is None):
            raise ValueError("Missing the required parameter `package_name` when calling `delete_package`")


        collection_formats = {}

        path_params = {}
        if 'package_name' in params:
            path_params['packageName'] = params['package_name']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/formulas/packages/{packageName}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'StatusMessageBase'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def experimental(self, **kwargs):
        """
        Run an experimental Seeq Formula
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.experimental(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str formula: The formula to be applied.
        :param list[str] parameters: Parameters for the formula. Each parameter should have a format of 'name=value' where 'name' is the variable identifier, without the leading $ sign, and 'value' is the ID of an item or one of the following parameter expressions that can be used to access the properties of other items that are parameters: $signal.property('name') to access any property on an item, $signal.parentProperty('name') can be used if an item is in a tree to to access any property on the parent, and $signal.ancestors(', ') to return a list of all the ancestors, separated by the specified separator. In all of the above examples 'signal' would need to be another parameter that references an item using an ID.
        :param list[str] fragments: Formula fragments for unbound inputs the function. Each parameter should have a format of 'name=formula' where 'name' is the variable identifier, without the leading $ sign, and 'formula' is a self-contained formula fragment
        :return: FormulaGenericOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FormulaGenericOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.experimental_with_http_info(**kwargs)
        else:
            (data) = self.experimental_with_http_info(**kwargs)
            return data

    def experimental_with_http_info(self, **kwargs):
        """
        Run an experimental Seeq Formula
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.experimental_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str formula: The formula to be applied.
        :param list[str] parameters: Parameters for the formula. Each parameter should have a format of 'name=value' where 'name' is the variable identifier, without the leading $ sign, and 'value' is the ID of an item or one of the following parameter expressions that can be used to access the properties of other items that are parameters: $signal.property('name') to access any property on an item, $signal.parentProperty('name') can be used if an item is in a tree to to access any property on the parent, and $signal.ancestors(', ') to return a list of all the ancestors, separated by the specified separator. In all of the above examples 'signal' would need to be another parameter that references an item using an ID.
        :param list[str] fragments: Formula fragments for unbound inputs the function. Each parameter should have a format of 'name=formula' where 'name' is the variable identifier, without the leading $ sign, and 'formula' is a self-contained formula fragment
        :return: FormulaGenericOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FormulaGenericOutputV1
        """

        all_params = ['formula', 'parameters', 'fragments']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method experimental" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'formula' in params:
            query_params.append(('formula', params['formula']))
        if 'parameters' in params:
            query_params.append(('parameters', params['parameters']))
            collection_formats['parameters'] = 'multi'
        if 'fragments' in params:
            query_params.append(('fragments', params['fragments']))
            collection_formats['fragments'] = 'multi'

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/formulas/experimental', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'FormulaGenericOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def formula_explainer(self, **kwargs):
        """
        Compile a Seeq Formula and show details about the execution plan.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.formula_explainer(body=body_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param FormulaCompileInputV1 body: Seeq Formula to compile and its parameters (required)
        :return: FormulaGenericOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FormulaGenericOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.formula_explainer_with_http_info(**kwargs)
        else:
            (data) = self.formula_explainer_with_http_info(**kwargs)
            return data

    def formula_explainer_with_http_info(self, **kwargs):
        """
        Compile a Seeq Formula and show details about the execution plan.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.formula_explainer_with_http_info(body=body_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param FormulaCompileInputV1 body: Seeq Formula to compile and its parameters (required)
        :return: FormulaGenericOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FormulaGenericOutputV1
        """

        all_params = ['body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method formula_explainer" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `formula_explainer`")


        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/formulas/explainer', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'FormulaGenericOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_constant_name_list(self, **kwargs):
        """
        Get a list of the constants available for use in a calculation
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_constant_name_list(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: list[str]
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[str]
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_constant_name_list_with_http_info(**kwargs)
        else:
            (data) = self.get_constant_name_list_with_http_info(**kwargs)
            return data

    def get_constant_name_list_with_http_info(self, **kwargs):
        """
        Get a list of the constants available for use in a calculation
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_constant_name_list_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: list[str]
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[str]
        """

        all_params = []
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_constant_name_list" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/formulas/docs/constants', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'list[str]'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_formula_doc(self, **kwargs):
        """
        Get documentation details about a specific function group or index
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_formula_doc(package_name=package_name_value, doc_name=doc_name_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str package_name: The name of the package (required)
        :param str doc_name: The name of the document for the desired function or index (required)
        :return: FormulaDocOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FormulaDocOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_formula_doc_with_http_info(**kwargs)
        else:
            (data) = self.get_formula_doc_with_http_info(**kwargs)
            return data

    def get_formula_doc_with_http_info(self, **kwargs):
        """
        Get documentation details about a specific function group or index
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_formula_doc_with_http_info(package_name=package_name_value, doc_name=doc_name_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str package_name: The name of the package (required)
        :param str doc_name: The name of the document for the desired function or index (required)
        :return: FormulaDocOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FormulaDocOutputV1
        """

        all_params = ['package_name', 'doc_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_formula_doc" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'package_name' is set
        if ('package_name' not in params) or (params['package_name'] is None):
            raise ValueError("Missing the required parameter `package_name` when calling `get_formula_doc`")
        # verify the required parameter 'doc_name' is set
        if ('doc_name' not in params) or (params['doc_name'] is None):
            raise ValueError("Missing the required parameter `doc_name` when calling `get_formula_doc`")


        collection_formats = {}

        path_params = {}
        if 'package_name' in params:
            path_params['packageName'] = params['package_name']
        if 'doc_name' in params:
            path_params['docName'] = params['doc_name']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/formulas/docs/{packageName}/{docName}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'FormulaDocOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_formula_docs(self, **kwargs):
        """
        Get a list of the functions available for use in a calculation
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_formula_docs(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: FormulaDocSummariesOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FormulaDocSummariesOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_formula_docs_with_http_info(**kwargs)
        else:
            (data) = self.get_formula_docs_with_http_info(**kwargs)
            return data

    def get_formula_docs_with_http_info(self, **kwargs):
        """
        Get a list of the functions available for use in a calculation
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_formula_docs_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: FormulaDocSummariesOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FormulaDocSummariesOutputV1
        """

        all_params = []
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_formula_docs" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/formulas/docs', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'FormulaDocSummariesOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_formula_functions(self, **kwargs):
        """
        Get a collection of Formula Functions
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_formula_functions(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str type: The type of Formula Functions that should be included. Valid options are FormulaFunction, AggregatingFormulaFunction, Chart, and UserDefinedFormulaFunction
        :param int offset: The pagination offset, the index of the first collection item that will be returned in this page of results
        :param int limit: The pagination limit, the total number of collection items that will be returned in this page of results
        :return: ItemPreviewListV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ItemPreviewListV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_formula_functions_with_http_info(**kwargs)
        else:
            (data) = self.get_formula_functions_with_http_info(**kwargs)
            return data

    def get_formula_functions_with_http_info(self, **kwargs):
        """
        Get a collection of Formula Functions
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_formula_functions_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str type: The type of Formula Functions that should be included. Valid options are FormulaFunction, AggregatingFormulaFunction, Chart, and UserDefinedFormulaFunction
        :param int offset: The pagination offset, the index of the first collection item that will be returned in this page of results
        :param int limit: The pagination limit, the total number of collection items that will be returned in this page of results
        :return: ItemPreviewListV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ItemPreviewListV1
        """

        all_params = ['type', 'offset', 'limit']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_formula_functions" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'type' in params:
            query_params.append(('type', params['type']))
        if 'offset' in params:
            query_params.append(('offset', params['offset']))
        if 'limit' in params:
            query_params.append(('limit', params['limit']))

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/formulas/functions', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'ItemPreviewListV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_function(self, **kwargs):
        """
        Get a Formula Function
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_function(id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: ID of the function (required)
        :return: CalculatedItemOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CalculatedItemOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_function_with_http_info(**kwargs)
        else:
            (data) = self.get_function_with_http_info(**kwargs)
            return data

    def get_function_with_http_info(self, **kwargs):
        """
        Get a Formula Function
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_function_with_http_info(id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: ID of the function (required)
        :return: CalculatedItemOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CalculatedItemOutputV1
        """

        all_params = ['id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_function" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_function`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/formulas/functions/{id}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'CalculatedItemOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_item(self, **kwargs):
        """
        Get a Formula Item
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_item(id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: ID of the item (required)
        :return: FormulaItemOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FormulaItemOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_item_with_http_info(**kwargs)
        else:
            (data) = self.get_item_with_http_info(**kwargs)
            return data

    def get_item_with_http_info(self, **kwargs):
        """
        Get a Formula Item
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_item_with_http_info(id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: ID of the item (required)
        :return: FormulaItemOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FormulaItemOutputV1
        """

        all_params = ['id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_item`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/formulas/items/{id}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'FormulaItemOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_package(self, **kwargs):
        """
        Get details of a specific package
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_package(package_name=package_name_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str package_name: The name of the package (required)
        :return: FormulaPackageOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FormulaPackageOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_package_with_http_info(**kwargs)
        else:
            (data) = self.get_package_with_http_info(**kwargs)
            return data

    def get_package_with_http_info(self, **kwargs):
        """
        Get details of a specific package
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_package_with_http_info(package_name=package_name_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str package_name: The name of the package (required)
        :return: FormulaPackageOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FormulaPackageOutputV1
        """

        all_params = ['package_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_package" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'package_name' is set
        if ('package_name' not in params) or (params['package_name'] is None):
            raise ValueError("Missing the required parameter `package_name` when calling `get_package`")


        collection_formats = {}

        path_params = {}
        if 'package_name' in params:
            path_params['packageName'] = params['package_name']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/formulas/packages/{packageName}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'FormulaPackageOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_packages(self, **kwargs):
        """
        Get a collection of packages
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_packages(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int offset: The pagination offset, the index of the first collection item that will be returned in this page of results
        :param int limit: The pagination limit, the total number of collection items that will be returned in this page of results
        :return: ItemPreviewListV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ItemPreviewListV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_packages_with_http_info(**kwargs)
        else:
            (data) = self.get_packages_with_http_info(**kwargs)
            return data

    def get_packages_with_http_info(self, **kwargs):
        """
        Get a collection of packages
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_packages_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int offset: The pagination offset, the index of the first collection item that will be returned in this page of results
        :param int limit: The pagination limit, the total number of collection items that will be returned in this page of results
        :return: ItemPreviewListV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ItemPreviewListV1
        """

        all_params = ['offset', 'limit']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_packages" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'offset' in params:
            query_params.append(('offset', params['offset']))
        if 'limit' in params:
            query_params.append(('limit', params['limit']))

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/formulas/packages', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'ItemPreviewListV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def import_package(self, **kwargs):
        """
        Create or update a package of UDFs with documentation.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.import_package(body=body_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param FormulaPackageImportInputV1 body: Complete package specifications to sync (required)
        :return: FormulaPackageImportOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FormulaPackageImportOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.import_package_with_http_info(**kwargs)
        else:
            (data) = self.import_package_with_http_info(**kwargs)
            return data

    def import_package_with_http_info(self, **kwargs):
        """
        Create or update a package of UDFs with documentation.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.import_package_with_http_info(body=body_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param FormulaPackageImportInputV1 body: Complete package specifications to sync (required)
        :return: FormulaPackageImportOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FormulaPackageImportOutputV1
        """

        all_params = ['body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method import_package" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `import_package`")


        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/formulas/packages/import', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'FormulaPackageImportOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def put_formula_doc(self, **kwargs):
        """
        Create or update the specified formula doc
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_formula_doc(body=body_value, package_name=package_name_value, doc_name=doc_name_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param FormulaDocInputV1 body: The details of the formula doc to create or update (required)
        :param str package_name: The name of the package (required)
        :param str doc_name: The name of the document for the desired function or index (required)
        :return: FormulaDocOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FormulaDocOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.put_formula_doc_with_http_info(**kwargs)
        else:
            (data) = self.put_formula_doc_with_http_info(**kwargs)
            return data

    def put_formula_doc_with_http_info(self, **kwargs):
        """
        Create or update the specified formula doc
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_formula_doc_with_http_info(body=body_value, package_name=package_name_value, doc_name=doc_name_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param FormulaDocInputV1 body: The details of the formula doc to create or update (required)
        :param str package_name: The name of the package (required)
        :param str doc_name: The name of the document for the desired function or index (required)
        :return: FormulaDocOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FormulaDocOutputV1
        """

        all_params = ['body', 'package_name', 'doc_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_formula_doc" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_formula_doc`")
        # verify the required parameter 'package_name' is set
        if ('package_name' not in params) or (params['package_name'] is None):
            raise ValueError("Missing the required parameter `package_name` when calling `put_formula_doc`")
        # verify the required parameter 'doc_name' is set
        if ('doc_name' not in params) or (params['doc_name'] is None):
            raise ValueError("Missing the required parameter `doc_name` when calling `put_formula_doc`")


        collection_formats = {}

        path_params = {}
        if 'package_name' in params:
            path_params['packageName'] = params['package_name']
        if 'doc_name' in params:
            path_params['docName'] = params['doc_name']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/formulas/docs/{packageName}/{docName}', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'FormulaDocOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def put_package(self, **kwargs):
        """
        Create or update a package
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_package(body=body_value, package_name=package_name_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param FormulaPackageInputV1 body: (required)
        :param str package_name: The name of the package (required)
        :return: FormulaPackageOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FormulaPackageOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.put_package_with_http_info(**kwargs)
        else:
            (data) = self.put_package_with_http_info(**kwargs)
            return data

    def put_package_with_http_info(self, **kwargs):
        """
        Create or update a package
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_package_with_http_info(body=body_value, package_name=package_name_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param FormulaPackageInputV1 body: (required)
        :param str package_name: The name of the package (required)
        :return: FormulaPackageOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FormulaPackageOutputV1
        """

        all_params = ['body', 'package_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_package" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_package`")
        # verify the required parameter 'package_name' is set
        if ('package_name' not in params) or (params['package_name'] is None):
            raise ValueError("Missing the required parameter `package_name` when calling `put_package`")


        collection_formats = {}

        path_params = {}
        if 'package_name' in params:
            path_params['packageName'] = params['package_name']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/formulas/packages/{packageName}', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'FormulaPackageOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def run_formula(self, **kwargs):
        """
        Run a Seeq Formula
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.run_formula(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str start: A string representing the starting index of the data to be returned as an ISO 8601 timestamp (YYYY-MM-DDThh:mm:ss.sssssssss±hh:mm).
        :param str end: A string representing the ending index of the data to be returned as an ISO 8601 timestamp (YYYY-MM-DDThh:mm:ss.sssssssss±hh:mm).
        :param str formula: The formula to be applied. This or function is required.
        :param str function: The ID of the function item to be computed. This or formula is required.
        :param list[str] parameters: Parameters for the formula. Each parameter should have a format of 'name=value' where 'name' is the variable identifier, without the leading $ sign, and 'value' is the ID of an item or one of the following parameter expressions that can be used to access the properties of other items that are parameters: $signal.property('name') to access any property on an item, $signal.parentProperty('name') can be used if an item is in a tree to to access any property on the parent, and $signal.ancestors(', ') to return a list of all the ancestors, separated by the specified separator. In all of the above examples 'signal' would need to be another parameter that references an item using an ID.
        :param list[str] fragments: Formula fragments for unbound inputs the function. Each parameter should have a format of 'name=formula' where 'name' is the variable identifier, without the leading $ sign, and 'formula' is a self-contained formula fragment
        :param str root: Used to run a formula across assets, this is the ID of the root asset whose immediate children will be iterated. The formula must produce a table.
        :param str reduce_formula: Used when running a formula across assets, this is a formula that can further reduce the results of each asset result. The variable $result must be used to reference the data. Example of sorting the aggregated results: $result.sort('temperature')'
        :param int limit: The pagination limit, the total number of collection items that will be returned in this page of results
        :param str continuation_token: An opaque token used to query for the next page of results. Only use if returned by a previous call.
        :param str time_format:
        :param list[str] items_to_scale_across: Used as a list of items across which the formula will be run. The formula must produce a table. The formula must contain a single variable named $series. The Header UOM will be that of the first item.
        :return: FormulaRunOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FormulaRunOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.run_formula_with_http_info(**kwargs)
        else:
            (data) = self.run_formula_with_http_info(**kwargs)
            return data

    def run_formula_with_http_info(self, **kwargs):
        """
        Run a Seeq Formula
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.run_formula_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str start: A string representing the starting index of the data to be returned as an ISO 8601 timestamp (YYYY-MM-DDThh:mm:ss.sssssssss±hh:mm).
        :param str end: A string representing the ending index of the data to be returned as an ISO 8601 timestamp (YYYY-MM-DDThh:mm:ss.sssssssss±hh:mm).
        :param str formula: The formula to be applied. This or function is required.
        :param str function: The ID of the function item to be computed. This or formula is required.
        :param list[str] parameters: Parameters for the formula. Each parameter should have a format of 'name=value' where 'name' is the variable identifier, without the leading $ sign, and 'value' is the ID of an item or one of the following parameter expressions that can be used to access the properties of other items that are parameters: $signal.property('name') to access any property on an item, $signal.parentProperty('name') can be used if an item is in a tree to to access any property on the parent, and $signal.ancestors(', ') to return a list of all the ancestors, separated by the specified separator. In all of the above examples 'signal' would need to be another parameter that references an item using an ID.
        :param list[str] fragments: Formula fragments for unbound inputs the function. Each parameter should have a format of 'name=formula' where 'name' is the variable identifier, without the leading $ sign, and 'formula' is a self-contained formula fragment
        :param str root: Used to run a formula across assets, this is the ID of the root asset whose immediate children will be iterated. The formula must produce a table.
        :param str reduce_formula: Used when running a formula across assets, this is a formula that can further reduce the results of each asset result. The variable $result must be used to reference the data. Example of sorting the aggregated results: $result.sort('temperature')'
        :param int limit: The pagination limit, the total number of collection items that will be returned in this page of results
        :param str continuation_token: An opaque token used to query for the next page of results. Only use if returned by a previous call.
        :param str time_format:
        :param list[str] items_to_scale_across: Used as a list of items across which the formula will be run. The formula must produce a table. The formula must contain a single variable named $series. The Header UOM will be that of the first item.
        :return: FormulaRunOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FormulaRunOutputV1
        """

        all_params = ['start', 'end', 'formula', 'function', 'parameters', 'fragments', 'root', 'reduce_formula', 'limit', 'continuation_token', 'time_format', 'items_to_scale_across']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method run_formula" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'start' in params:
            query_params.append(('start', params['start']))
        if 'end' in params:
            query_params.append(('end', params['end']))
        if 'formula' in params:
            query_params.append(('formula', params['formula']))
        if 'function' in params:
            query_params.append(('function', params['function']))
        if 'parameters' in params:
            query_params.append(('parameters', params['parameters']))
            collection_formats['parameters'] = 'multi'
        if 'fragments' in params:
            query_params.append(('fragments', params['fragments']))
            collection_formats['fragments'] = 'multi'
        if 'root' in params:
            query_params.append(('root', params['root']))
        if 'reduce_formula' in params:
            query_params.append(('reduceFormula', params['reduce_formula']))
        if 'limit' in params:
            query_params.append(('limit', params['limit']))
        if 'continuation_token' in params:
            query_params.append(('continuationToken', params['continuation_token']))
        if 'time_format' in params:
            query_params.append(('timeFormat', params['time_format']))
        if 'items_to_scale_across' in params:
            query_params.append(('itemsToScaleAcross', params['items_to_scale_across']))
            collection_formats['itemsToScaleAcross'] = 'multi'

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/formulas/run', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'FormulaRunOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def run_formula_0(self, **kwargs):
        """
        Run a Seeq Formula.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.run_formula_0(body=body_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param FormulaRunInputV1 body: Seeq Formula information (required)
        :return: FormulaRunOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FormulaRunOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.run_formula_0_with_http_info(**kwargs)
        else:
            (data) = self.run_formula_0_with_http_info(**kwargs)
            return data

    def run_formula_0_with_http_info(self, **kwargs):
        """
        Run a Seeq Formula.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.run_formula_0_with_http_info(body=body_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param FormulaRunInputV1 body: Seeq Formula information (required)
        :return: FormulaRunOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: FormulaRunOutputV1
        """

        all_params = ['body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method run_formula_0" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `run_formula_0`")


        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/formulas/run', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'FormulaRunOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_function(self, **kwargs):
        """
        Update a function
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_function(body=body_value, id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param FunctionInputV1 body: Function information (required)
        :param str id: ID of the function to update (required)
        :return: CalculatedItemOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CalculatedItemOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_function_with_http_info(**kwargs)
        else:
            (data) = self.update_function_with_http_info(**kwargs)
            return data

    def update_function_with_http_info(self, **kwargs):
        """
        Update a function
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_function_with_http_info(body=body_value, id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param FunctionInputV1 body: Function information (required)
        :param str id: ID of the function to update (required)
        :return: CalculatedItemOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CalculatedItemOutputV1
        """

        all_params = ['body', 'id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_function" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_function`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_function`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/formulas/functions/{id}', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'CalculatedItemOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
