# coding: utf-8

"""
    Seeq REST API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)  # noqa: E501

    OpenAPI spec version: 66.32.1-v202508062319-CD
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import sys
import os
import re

from deprecated import deprecated
# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient
from ..models import *

class SCIMApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def generate_token(self, **kwargs):
        """
        Generate a new SCIM authentication token for the specified datasource
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.generate_token(body=body_value, datasource_class=datasource_class_value, datasource_id=datasource_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ScimTokenInputV1 body: The token generation parameters (required)
        :param str datasource_class: The datasource class of the user's directory (required)
        :param str datasource_id: The datasource ID of the user's directory (required)
        :return: ScimTokenOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ScimTokenOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.generate_token_with_http_info(**kwargs)
        else:
            (data) = self.generate_token_with_http_info(**kwargs)
            return data

    def generate_token_with_http_info(self, **kwargs):
        """
        Generate a new SCIM authentication token for the specified datasource
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.generate_token_with_http_info(body=body_value, datasource_class=datasource_class_value, datasource_id=datasource_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ScimTokenInputV1 body: The token generation parameters (required)
        :param str datasource_class: The datasource class of the user's directory (required)
        :param str datasource_id: The datasource ID of the user's directory (required)
        :return: ScimTokenOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ScimTokenOutputV1
        """

        all_params = ['body', 'datasource_class', 'datasource_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method generate_token" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `generate_token`")
        # verify the required parameter 'datasource_class' is set
        if ('datasource_class' not in params) or (params['datasource_class'] is None):
            raise ValueError("Missing the required parameter `datasource_class` when calling `generate_token`")
        # verify the required parameter 'datasource_id' is set
        if ('datasource_id' not in params) or (params['datasource_id'] is None):
            raise ValueError("Missing the required parameter `datasource_id` when calling `generate_token`")


        collection_formats = {}

        path_params = {}
        if 'datasource_class' in params:
            path_params['datasourceClass'] = params['datasource_class']
        if 'datasource_id' in params:
            path_params['datasourceId'] = params['datasource_id']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/scim/{datasourceClass}/{datasourceId}/token', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'ScimTokenOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_token(self, **kwargs):
        """
        Retrieve the SCIM authentication token expiration information for the specified datasource
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_token(datasource_class=datasource_class_value, datasource_id=datasource_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str datasource_class: The datasource class of the user's directory (required)
        :param str datasource_id: The datasource ID of the user's directory (required)
        :return: ScimTokenOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ScimTokenOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_token_with_http_info(**kwargs)
        else:
            (data) = self.get_token_with_http_info(**kwargs)
            return data

    def get_token_with_http_info(self, **kwargs):
        """
        Retrieve the SCIM authentication token expiration information for the specified datasource
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_token_with_http_info(datasource_class=datasource_class_value, datasource_id=datasource_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str datasource_class: The datasource class of the user's directory (required)
        :param str datasource_id: The datasource ID of the user's directory (required)
        :return: ScimTokenOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ScimTokenOutputV1
        """

        all_params = ['datasource_class', 'datasource_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_token" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'datasource_class' is set
        if ('datasource_class' not in params) or (params['datasource_class'] is None):
            raise ValueError("Missing the required parameter `datasource_class` when calling `get_token`")
        # verify the required parameter 'datasource_id' is set
        if ('datasource_id' not in params) or (params['datasource_id'] is None):
            raise ValueError("Missing the required parameter `datasource_id` when calling `get_token`")


        collection_formats = {}

        path_params = {}
        if 'datasource_class' in params:
            path_params['datasourceClass'] = params['datasource_class']
        if 'datasource_id' in params:
            path_params['datasourceId'] = params['datasource_id']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/scim/{datasourceClass}/{datasourceId}/token', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'ScimTokenOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def invalidate_token(self, **kwargs):
        """
        Invalidates all SCIM tokens for the specified datasource
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.invalidate_token(datasource_class=datasource_class_value, datasource_id=datasource_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str datasource_class: The datasource class of the user's directory (required)
        :param str datasource_id: The datasource ID of the user's directory (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.invalidate_token_with_http_info(**kwargs)
        else:
            (data) = self.invalidate_token_with_http_info(**kwargs)
            return data

    def invalidate_token_with_http_info(self, **kwargs):
        """
        Invalidates all SCIM tokens for the specified datasource
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.invalidate_token_with_http_info(datasource_class=datasource_class_value, datasource_id=datasource_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str datasource_class: The datasource class of the user's directory (required)
        :param str datasource_id: The datasource ID of the user's directory (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        all_params = ['datasource_class', 'datasource_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method invalidate_token" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'datasource_class' is set
        if ('datasource_class' not in params) or (params['datasource_class'] is None):
            raise ValueError("Missing the required parameter `datasource_class` when calling `invalidate_token`")
        # verify the required parameter 'datasource_id' is set
        if ('datasource_id' not in params) or (params['datasource_id'] is None):
            raise ValueError("Missing the required parameter `datasource_id` when calling `invalidate_token`")


        collection_formats = {}

        path_params = {}
        if 'datasource_class' in params:
            path_params['datasourceClass'] = params['datasource_class']
        if 'datasource_id' in params:
            path_params['datasourceId'] = params['datasource_id']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/scim/{datasourceClass}/{datasourceId}/token', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', None),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
