# coding: utf-8

"""
    Seeq REST API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)  # noqa: E501

    OpenAPI spec version: 66.32.1-v202508062319-CD
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import sys
import os
import re

from deprecated import deprecated
# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient
from ..models import *

class TreesApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def batch_move_nodes_to_parents(self, **kwargs):
        """
        Add the specified items as child nodes of the specified parents within the specified tree. If an item is already a member of this tree, it will move from its current parent to the specified parent. The children of the items being moved will move with each parent. When x-sq-async-job header is set to 'true' the operation runs as an async job that may be queried using the Jobs API.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.batch_move_nodes_to_parents(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param AssetTreeBatchInputV1 body:
        :return: ItemBatchOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ItemBatchOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.batch_move_nodes_to_parents_with_http_info(**kwargs)
        else:
            (data) = self.batch_move_nodes_to_parents_with_http_info(**kwargs)
            return data

    def batch_move_nodes_to_parents_with_http_info(self, **kwargs):
        """
        Add the specified items as child nodes of the specified parents within the specified tree. If an item is already a member of this tree, it will move from its current parent to the specified parent. The children of the items being moved will move with each parent. When x-sq-async-job header is set to 'true' the operation runs as an async job that may be queried using the Jobs API.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.batch_move_nodes_to_parents_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param AssetTreeBatchInputV1 body:
        :return: ItemBatchOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ItemBatchOutputV1
        """

        all_params = ['body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_move_nodes_to_parents" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/trees/assets/batch', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'ItemBatchOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_tree(self, **kwargs):
        """
        Create or update an asset tree
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_tree(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param AssetGroupInputV1 body:
        :return: AssetGroupOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AssetGroupOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_tree_with_http_info(**kwargs)
        else:
            (data) = self.create_tree_with_http_info(**kwargs)
            return data

    def create_tree_with_http_info(self, **kwargs):
        """
        Create or update an asset tree
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_tree_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param AssetGroupInputV1 body:
        :return: AssetGroupOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AssetGroupOutputV1
        """

        all_params = ['body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_tree" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/trees/assets/createTree', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'AssetGroupOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_all_tree_types(self, **kwargs):
        """
        Get a collection of all available tree types
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_all_tree_types(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int offset: The pagination offset, the index of the first collection item that will be returned in this page of results
        :param int limit: The pagination limit, the total number of collection items that will be returned in this page of results
        :return: ItemPreviewListV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ItemPreviewListV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_all_tree_types_with_http_info(**kwargs)
        else:
            (data) = self.get_all_tree_types_with_http_info(**kwargs)
            return data

    def get_all_tree_types_with_http_info(self, **kwargs):
        """
        Get a collection of all available tree types
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_all_tree_types_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int offset: The pagination offset, the index of the first collection item that will be returned in this page of results
        :param int limit: The pagination limit, the total number of collection items that will be returned in this page of results
        :return: ItemPreviewListV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ItemPreviewListV1
        """

        all_params = ['offset', 'limit']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_tree_types" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'offset' in params:
            query_params.append(('offset', params['offset']))
        if 'limit' in params:
            query_params.append(('limit', params['limit']))

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/trees', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'ItemPreviewListV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_tree(self, **kwargs):
        """
        Get the ancestors and children of the specified item within the context of this tree
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_tree(id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: ID of the specified item (required)
        :param list[str] scope: The IDs of the workbooks to which the items are scoped<br>If scope is set to the Empty GUID then the scoped items are excluded.
        :param int offset: The pagination offset, the index of the first collection item that will be returned in this page of results
        :param int limit: The pagination limit, the total number of collection items that will be returned in this page of results
        :param bool include_descendants: If the children of the children should be retrieved. Note that a 400 error will be returned if the total number of children and descendants exceeds the specified limit
        :param bool exclude_globally_scoped: Exclude globally scoped items.
        :return: AssetTreeOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AssetTreeOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_tree_with_http_info(**kwargs)
        else:
            (data) = self.get_tree_with_http_info(**kwargs)
            return data

    def get_tree_with_http_info(self, **kwargs):
        """
        Get the ancestors and children of the specified item within the context of this tree
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_tree_with_http_info(id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: ID of the specified item (required)
        :param list[str] scope: The IDs of the workbooks to which the items are scoped<br>If scope is set to the Empty GUID then the scoped items are excluded.
        :param int offset: The pagination offset, the index of the first collection item that will be returned in this page of results
        :param int limit: The pagination limit, the total number of collection items that will be returned in this page of results
        :param bool include_descendants: If the children of the children should be retrieved. Note that a 400 error will be returned if the total number of children and descendants exceeds the specified limit
        :param bool exclude_globally_scoped: Exclude globally scoped items.
        :return: AssetTreeOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AssetTreeOutputV1
        """

        all_params = ['id', 'scope', 'offset', 'limit', 'include_descendants', 'exclude_globally_scoped']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_tree" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_tree`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = []
        if 'scope' in params:
            query_params.append(('scope', params['scope']))
            collection_formats['scope'] = 'multi'
        if 'offset' in params:
            query_params.append(('offset', params['offset']))
        if 'limit' in params:
            query_params.append(('limit', params['limit']))
        if 'include_descendants' in params:
            query_params.append(('includeDescendants', params['include_descendants']))
        if 'exclude_globally_scoped' in params:
            query_params.append(('excludeGloballyScoped', params['exclude_globally_scoped']))

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/trees/assets/{id}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'AssetTreeOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_tree_root_nodes(self, **kwargs):
        """
        Get a collection of root nodes for the asset tree
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_tree_root_nodes(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] scope: The IDs of the workbooks to which the items are scoped<br>If the scope is set to the Empty GUID, then the scoped items are excluded.
        :param int offset: The pagination offset, the index of the first collection item that will be returned in this page of results
        :param int limit: The pagination limit, the total number of collection items that will be returned in this page of results
        :param list[str] properties: A list of property names and values to filter on.  Arguments should be passed in in the following format Property=Value, with each new property-value pair on a new line. The option to filter out a node by a property can be done by using !=.
        :param bool exclude_globally_scoped: Exclude globally scoped items.
        :return: AssetTreeOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AssetTreeOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_tree_root_nodes_with_http_info(**kwargs)
        else:
            (data) = self.get_tree_root_nodes_with_http_info(**kwargs)
            return data

    def get_tree_root_nodes_with_http_info(self, **kwargs):
        """
        Get a collection of root nodes for the asset tree
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_tree_root_nodes_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] scope: The IDs of the workbooks to which the items are scoped<br>If the scope is set to the Empty GUID, then the scoped items are excluded.
        :param int offset: The pagination offset, the index of the first collection item that will be returned in this page of results
        :param int limit: The pagination limit, the total number of collection items that will be returned in this page of results
        :param list[str] properties: A list of property names and values to filter on.  Arguments should be passed in in the following format Property=Value, with each new property-value pair on a new line. The option to filter out a node by a property can be done by using !=.
        :param bool exclude_globally_scoped: Exclude globally scoped items.
        :return: AssetTreeOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AssetTreeOutputV1
        """

        all_params = ['scope', 'offset', 'limit', 'properties', 'exclude_globally_scoped']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_tree_root_nodes" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'scope' in params:
            query_params.append(('scope', params['scope']))
            collection_formats['scope'] = 'multi'
        if 'offset' in params:
            query_params.append(('offset', params['offset']))
        if 'limit' in params:
            query_params.append(('limit', params['limit']))
        if 'properties' in params:
            query_params.append(('properties', params['properties']))
            collection_formats['properties'] = 'multi'
        if 'exclude_globally_scoped' in params:
            query_params.append(('excludeGloballyScoped', params['exclude_globally_scoped']))

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/trees/assets', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'AssetTreeOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def move_nodes_to_parent(self, **kwargs):
        """
        Add the specified items as child nodes of the specified parent within the specified tree. If an item is already a member of this tree, it will move from its current parent to the specified parent. The children of the item being moved will move with it.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.move_nodes_to_parent(body=body_value, parent_id=parent_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ItemIdListInputV1 body: Item list (required)
        :param str parent_id: ID of the parent node (required)
        :return: StatusMessageBase
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StatusMessageBase
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.move_nodes_to_parent_with_http_info(**kwargs)
        else:
            (data) = self.move_nodes_to_parent_with_http_info(**kwargs)
            return data

    def move_nodes_to_parent_with_http_info(self, **kwargs):
        """
        Add the specified items as child nodes of the specified parent within the specified tree. If an item is already a member of this tree, it will move from its current parent to the specified parent. The children of the item being moved will move with it.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.move_nodes_to_parent_with_http_info(body=body_value, parent_id=parent_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ItemIdListInputV1 body: Item list (required)
        :param str parent_id: ID of the parent node (required)
        :return: StatusMessageBase
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StatusMessageBase
        """

        all_params = ['body', 'parent_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method move_nodes_to_parent" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `move_nodes_to_parent`")
        # verify the required parameter 'parent_id' is set
        if ('parent_id' not in params) or (params['parent_id'] is None):
            raise ValueError("Missing the required parameter `parent_id` when calling `move_nodes_to_parent`")


        collection_formats = {}

        path_params = {}
        if 'parent_id' in params:
            path_params['parentId'] = params['parent_id']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/trees/assets/{parentId}', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'StatusMessageBase'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def move_nodes_to_root_of_tree(self, **kwargs):
        """
        Add the specified items as root nodes of the specified tree. If an item is already a member of this tree, it will move to the root and its children will move with it
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.move_nodes_to_root_of_tree(body=body_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ItemIdListInputV1 body: Item list (required)
        :return: StatusMessageBase
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StatusMessageBase
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.move_nodes_to_root_of_tree_with_http_info(**kwargs)
        else:
            (data) = self.move_nodes_to_root_of_tree_with_http_info(**kwargs)
            return data

    def move_nodes_to_root_of_tree_with_http_info(self, **kwargs):
        """
        Add the specified items as root nodes of the specified tree. If an item is already a member of this tree, it will move to the root and its children will move with it
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.move_nodes_to_root_of_tree_with_http_info(body=body_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ItemIdListInputV1 body: Item list (required)
        :return: StatusMessageBase
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StatusMessageBase
        """

        all_params = ['body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method move_nodes_to_root_of_tree" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `move_nodes_to_root_of_tree`")


        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/trees/assets', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'StatusMessageBase'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    @deprecated(reason="")
    def rebuild_search_index(self, **kwargs):
        """
        Trigger a rebuild of an asset tree search index in the background, starting at the specified root asset. This can be a time consuming and resource intensive operation, especially on large trees. The reindexing is performed in the background, and the API call will return as soon as the rebuild has been triggered.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.rebuild_search_index(root_asset_id=root_asset_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str root_asset_id: ID the root asset of the tree to rebuild (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.rebuild_search_index_with_http_info(**kwargs)
        else:
            (data) = self.rebuild_search_index_with_http_info(**kwargs)
            return data

    @deprecated(reason="")
    def rebuild_search_index_with_http_info(self, **kwargs):
        """
        Trigger a rebuild of an asset tree search index in the background, starting at the specified root asset. This can be a time consuming and resource intensive operation, especially on large trees. The reindexing is performed in the background, and the API call will return as soon as the rebuild has been triggered.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.rebuild_search_index_with_http_info(root_asset_id=root_asset_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str root_asset_id: ID the root asset of the tree to rebuild (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        all_params = ['root_asset_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method rebuild_search_index" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'root_asset_id' is set
        if ('root_asset_id' not in params) or (params['root_asset_id'] is None):
            raise ValueError("Missing the required parameter `root_asset_id` when calling `rebuild_search_index`")


        collection_formats = {}

        path_params = {}
        if 'root_asset_id' in params:
            path_params['rootAssetId'] = params['root_asset_id']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/trees/assets/{rootAssetId}/rebuildSearchIndex', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', None),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def remove_node_from_tree(self, **kwargs):
        """
        Remove an item and its children from the tree. (These items will still exist but not as part of this tree.)
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.remove_node_from_tree(id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: ID of the node to remove (required)
        :return: StatusMessageBase
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StatusMessageBase
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.remove_node_from_tree_with_http_info(**kwargs)
        else:
            (data) = self.remove_node_from_tree_with_http_info(**kwargs)
            return data

    def remove_node_from_tree_with_http_info(self, **kwargs):
        """
        Remove an item and its children from the tree. (These items will still exist but not as part of this tree.)
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.remove_node_from_tree_with_http_info(id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: ID of the node to remove (required)
        :return: StatusMessageBase
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StatusMessageBase
        """

        all_params = ['id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_node_from_tree" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `remove_node_from_tree`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/trees/assets/{id}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'StatusMessageBase'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def scale_across_tree(self, **kwargs):
        """
        Scale a tree item across its asset tree. Asset-swapped copies of the item will be inserted under all assets at the same tree level as its current parent.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.scale_across_tree(id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: ID of the item to be scaled (required)
        :return: ScaleAcrossTreeOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ScaleAcrossTreeOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.scale_across_tree_with_http_info(**kwargs)
        else:
            (data) = self.scale_across_tree_with_http_info(**kwargs)
            return data

    def scale_across_tree_with_http_info(self, **kwargs):
        """
        Scale a tree item across its asset tree. Asset-swapped copies of the item will be inserted under all assets at the same tree level as its current parent.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.scale_across_tree_with_http_info(id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: ID of the item to be scaled (required)
        :return: ScaleAcrossTreeOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ScaleAcrossTreeOutputV1
        """

        all_params = ['id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method scale_across_tree" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `scale_across_tree`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/trees/assets/{id}/scale', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'ScaleAcrossTreeOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def treemap(self, **kwargs):
        """
        Build a treemap
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.treemap(start=start_value, end=end_value, condition_ids=condition_ids_value, swap_id=swap_id_value, parent_id=parent_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str start: The start time under which to compute conditions for the treemap. (required)
        :param str end: The end time under which to compute conditions for the treemap. (required)
        :param list[str] condition_ids: The IDs of the conditions that will be used to create the treemap; must be in order of priority, where the first condition is the highest priority item. (required)
        :param str swap_id: The ID of the asset to swap each treemap leaf node with. (required)
        :param str parent_id: The ID of the parent asset to build the treemap from. (required)
        :param list[str] parameters: Parameters for the display formulas. Each parameter should have a format of 'name=id' where 'name' is the variable identifier, without the leading $ sign, and 'id' is the ID of the item referenced by the variable
        :param list[str] formulas: A list of display scalar formulas
        :return: TreemapOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TreemapOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.treemap_with_http_info(**kwargs)
        else:
            (data) = self.treemap_with_http_info(**kwargs)
            return data

    def treemap_with_http_info(self, **kwargs):
        """
        Build a treemap
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.treemap_with_http_info(start=start_value, end=end_value, condition_ids=condition_ids_value, swap_id=swap_id_value, parent_id=parent_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str start: The start time under which to compute conditions for the treemap. (required)
        :param str end: The end time under which to compute conditions for the treemap. (required)
        :param list[str] condition_ids: The IDs of the conditions that will be used to create the treemap; must be in order of priority, where the first condition is the highest priority item. (required)
        :param str swap_id: The ID of the asset to swap each treemap leaf node with. (required)
        :param str parent_id: The ID of the parent asset to build the treemap from. (required)
        :param list[str] parameters: Parameters for the display formulas. Each parameter should have a format of 'name=id' where 'name' is the variable identifier, without the leading $ sign, and 'id' is the ID of the item referenced by the variable
        :param list[str] formulas: A list of display scalar formulas
        :return: TreemapOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TreemapOutputV1
        """

        all_params = ['start', 'end', 'condition_ids', 'swap_id', 'parent_id', 'parameters', 'formulas']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method treemap" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'start' is set
        if ('start' not in params) or (params['start'] is None):
            raise ValueError("Missing the required parameter `start` when calling `treemap`")
        # verify the required parameter 'end' is set
        if ('end' not in params) or (params['end'] is None):
            raise ValueError("Missing the required parameter `end` when calling `treemap`")
        # verify the required parameter 'condition_ids' is set
        if ('condition_ids' not in params) or (params['condition_ids'] is None):
            raise ValueError("Missing the required parameter `condition_ids` when calling `treemap`")
        # verify the required parameter 'swap_id' is set
        if ('swap_id' not in params) or (params['swap_id'] is None):
            raise ValueError("Missing the required parameter `swap_id` when calling `treemap`")
        # verify the required parameter 'parent_id' is set
        if ('parent_id' not in params) or (params['parent_id'] is None):
            raise ValueError("Missing the required parameter `parent_id` when calling `treemap`")


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'start' in params:
            query_params.append(('start', params['start']))
        if 'end' in params:
            query_params.append(('end', params['end']))
        if 'condition_ids' in params:
            query_params.append(('conditionIds', params['condition_ids']))
            collection_formats['conditionIds'] = 'multi'
        if 'swap_id' in params:
            query_params.append(('swapId', params['swap_id']))
        if 'parent_id' in params:
            query_params.append(('parentId', params['parent_id']))
        if 'parameters' in params:
            query_params.append(('parameters', params['parameters']))
            collection_formats['parameters'] = 'multi'
        if 'formulas' in params:
            query_params.append(('formulas', params['formulas']))
            collection_formats['formulas'] = 'multi'

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/trees/treemap', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'TreemapOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_tree(self, **kwargs):
        """
        Update an asset tree
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_tree(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param AssetGroupInputV1 body:
        :return: AssetGroupOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AssetGroupOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_tree_with_http_info(**kwargs)
        else:
            (data) = self.update_tree_with_http_info(**kwargs)
            return data

    def update_tree_with_http_info(self, **kwargs):
        """
        Update an asset tree
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_tree_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param AssetGroupInputV1 body:
        :return: AssetGroupOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AssetGroupOutputV1
        """

        all_params = ['body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_tree" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/trees/assets/updateTree', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'AssetGroupOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
