# coding: utf-8

"""
    Seeq REST API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)  # noqa: E501

    OpenAPI spec version: 66.32.1-v202508062319-CD
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import sys
import os
import re

from deprecated import deprecated
# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient
from ..models import *

class WorkbooksApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def add_recently_accessed(self, **kwargs):
        """
        Put the specified item at the top of the recently accessed list for the workbook
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.add_recently_accessed(workbook_id=workbook_id_value, item_id=item_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workbook_id: ID of the workbook (required)
        :param str item_id: Item to be added (required)
        :return: ItemSearchPreviewListV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ItemSearchPreviewListV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.add_recently_accessed_with_http_info(**kwargs)
        else:
            (data) = self.add_recently_accessed_with_http_info(**kwargs)
            return data

    def add_recently_accessed_with_http_info(self, **kwargs):
        """
        Put the specified item at the top of the recently accessed list for the workbook
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.add_recently_accessed_with_http_info(workbook_id=workbook_id_value, item_id=item_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workbook_id: ID of the workbook (required)
        :param str item_id: Item to be added (required)
        :return: ItemSearchPreviewListV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ItemSearchPreviewListV1
        """

        all_params = ['workbook_id', 'item_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_recently_accessed" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workbook_id' is set
        if ('workbook_id' not in params) or (params['workbook_id'] is None):
            raise ValueError("Missing the required parameter `workbook_id` when calling `add_recently_accessed`")
        # verify the required parameter 'item_id' is set
        if ('item_id' not in params) or (params['item_id'] is None):
            raise ValueError("Missing the required parameter `item_id` when calling `add_recently_accessed`")


        collection_formats = {}

        path_params = {}
        if 'workbook_id' in params:
            path_params['workbookId'] = params['workbook_id']
        if 'item_id' in params:
            path_params['itemId'] = params['item_id']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/workbooks/{workbookId}/recently-accessed/{itemId}', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'ItemSearchPreviewListV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def archive_workbook(self, **kwargs):
        """
        Archive a workbook by id
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.archive_workbook(id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: ID of the workbook to archive (required)
        :return: ArchiveOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ArchiveOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.archive_workbook_with_http_info(**kwargs)
        else:
            (data) = self.archive_workbook_with_http_info(**kwargs)
            return data

    def archive_workbook_with_http_info(self, **kwargs):
        """
        Archive a workbook by id
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.archive_workbook_with_http_info(id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: ID of the workbook to archive (required)
        :return: ArchiveOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ArchiveOutputV1
        """

        all_params = ['id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method archive_workbook" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `archive_workbook`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/workbooks/{id}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'ArchiveOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def archive_worksheet(self, **kwargs):
        """
        Archive a worksheet
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.archive_worksheet(workbook_id=workbook_id_value, worksheet_id=worksheet_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workbook_id: ID of the workbook on which the worksheet exists (required)
        :param str worksheet_id: ID of the worksheet to archive (required)
        :return: ArchiveOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ArchiveOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.archive_worksheet_with_http_info(**kwargs)
        else:
            (data) = self.archive_worksheet_with_http_info(**kwargs)
            return data

    def archive_worksheet_with_http_info(self, **kwargs):
        """
        Archive a worksheet
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.archive_worksheet_with_http_info(workbook_id=workbook_id_value, worksheet_id=worksheet_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workbook_id: ID of the workbook on which the worksheet exists (required)
        :param str worksheet_id: ID of the worksheet to archive (required)
        :return: ArchiveOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ArchiveOutputV1
        """

        all_params = ['workbook_id', 'worksheet_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method archive_worksheet" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workbook_id' is set
        if ('workbook_id' not in params) or (params['workbook_id'] is None):
            raise ValueError("Missing the required parameter `workbook_id` when calling `archive_worksheet`")
        # verify the required parameter 'worksheet_id' is set
        if ('worksheet_id' not in params) or (params['worksheet_id'] is None):
            raise ValueError("Missing the required parameter `worksheet_id` when calling `archive_worksheet`")


        collection_formats = {}

        path_params = {}
        if 'workbook_id' in params:
            path_params['workbookId'] = params['workbook_id']
        if 'worksheet_id' in params:
            path_params['worksheetId'] = params['worksheet_id']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/workbooks/{workbookId}/worksheets/{worksheetId}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'ArchiveOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_workbook(self, **kwargs):
        """
        Create a workbook
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_workbook(body=body_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param WorkbookInputV1 body: Workbook information (required)
        :return: WorkbookOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WorkbookOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_workbook_with_http_info(**kwargs)
        else:
            (data) = self.create_workbook_with_http_info(**kwargs)
            return data

    def create_workbook_with_http_info(self, **kwargs):
        """
        Create a workbook
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_workbook_with_http_info(body=body_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param WorkbookInputV1 body: Workbook information (required)
        :return: WorkbookOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WorkbookOutputV1
        """

        all_params = ['body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_workbook" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_workbook`")


        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/workbooks', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'WorkbookOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_worksheet(self, **kwargs):
        """
        Create a worksheet
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_worksheet(body=body_value, workbook_id=workbook_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param WorksheetInputV1 body: Worksheet information (required)
        :param str workbook_id: ID of the workbook on which to create the worksheet (required)
        :return: WorksheetOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WorksheetOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_worksheet_with_http_info(**kwargs)
        else:
            (data) = self.create_worksheet_with_http_info(**kwargs)
            return data

    def create_worksheet_with_http_info(self, **kwargs):
        """
        Create a worksheet
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_worksheet_with_http_info(body=body_value, workbook_id=workbook_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param WorksheetInputV1 body: Worksheet information (required)
        :param str workbook_id: ID of the workbook on which to create the worksheet (required)
        :return: WorksheetOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WorksheetOutputV1
        """

        all_params = ['body', 'workbook_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_worksheet" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_worksheet`")
        # verify the required parameter 'workbook_id' is set
        if ('workbook_id' not in params) or (params['workbook_id'] is None):
            raise ValueError("Missing the required parameter `workbook_id` when calling `create_worksheet`")


        collection_formats = {}

        path_params = {}
        if 'workbook_id' in params:
            path_params['workbookId'] = params['workbook_id']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/workbooks/{workbookId}/worksheets', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'WorksheetOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_worksheet_thumbnail(self, **kwargs):
        """
        Forces the thumbnail to be regenerated. Normally new thumbnails are generated automatically as worksteps are added to the worksheet. However, thumbnail generation is normally limited to once a day, so this endpoint can be used to force a new thumbnail to be generated. When the thumbnail is complete a message will be sent over the thumbnail websocket channel.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_worksheet_thumbnail(workbook_id=workbook_id_value, worksheet_id=worksheet_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workbook_id: The ID of the workbook for containing the worksheet (required)
        :param str worksheet_id: The ID of the worksheet (required)
        :return: StatusMessageBase
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StatusMessageBase
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_worksheet_thumbnail_with_http_info(**kwargs)
        else:
            (data) = self.create_worksheet_thumbnail_with_http_info(**kwargs)
            return data

    def create_worksheet_thumbnail_with_http_info(self, **kwargs):
        """
        Forces the thumbnail to be regenerated. Normally new thumbnails are generated automatically as worksteps are added to the worksheet. However, thumbnail generation is normally limited to once a day, so this endpoint can be used to force a new thumbnail to be generated. When the thumbnail is complete a message will be sent over the thumbnail websocket channel.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_worksheet_thumbnail_with_http_info(workbook_id=workbook_id_value, worksheet_id=worksheet_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workbook_id: The ID of the workbook for containing the worksheet (required)
        :param str worksheet_id: The ID of the worksheet (required)
        :return: StatusMessageBase
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StatusMessageBase
        """

        all_params = ['workbook_id', 'worksheet_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_worksheet_thumbnail" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workbook_id' is set
        if ('workbook_id' not in params) or (params['workbook_id'] is None):
            raise ValueError("Missing the required parameter `workbook_id` when calling `create_worksheet_thumbnail`")
        # verify the required parameter 'worksheet_id' is set
        if ('worksheet_id' not in params) or (params['worksheet_id'] is None):
            raise ValueError("Missing the required parameter `worksheet_id` when calling `create_worksheet_thumbnail`")


        collection_formats = {}

        path_params = {}
        if 'workbook_id' in params:
            path_params['workbookId'] = params['workbook_id']
        if 'worksheet_id' in params:
            path_params['worksheetId'] = params['worksheet_id']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/workbooks/{workbookId}/worksheets/{worksheetId}/thumbnail', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'StatusMessageBase'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_workstep(self, **kwargs):
        """
        Append a new workstep to the worksheet
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_workstep(body=body_value, workbook_id=workbook_id_value, worksheet_id=worksheet_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param WorkstepInputV1 body: Workstep information (required)
        :param str workbook_id: ID of the workbook on which the worksheet exists (required)
        :param str worksheet_id: ID of the worksheet on which to append the new workstep (required)
        :param bool no_workstep_message: Option to not send a workstep message notifying clients that the current workstep of the worksheet has been updated. Should only be used when multiple worksteps are being pushed in quick succession and a subsequent call will be made to set the current workstep.
        :return: WorkstepOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WorkstepOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_workstep_with_http_info(**kwargs)
        else:
            (data) = self.create_workstep_with_http_info(**kwargs)
            return data

    def create_workstep_with_http_info(self, **kwargs):
        """
        Append a new workstep to the worksheet
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_workstep_with_http_info(body=body_value, workbook_id=workbook_id_value, worksheet_id=worksheet_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param WorkstepInputV1 body: Workstep information (required)
        :param str workbook_id: ID of the workbook on which the worksheet exists (required)
        :param str worksheet_id: ID of the worksheet on which to append the new workstep (required)
        :param bool no_workstep_message: Option to not send a workstep message notifying clients that the current workstep of the worksheet has been updated. Should only be used when multiple worksteps are being pushed in quick succession and a subsequent call will be made to set the current workstep.
        :return: WorkstepOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WorkstepOutputV1
        """

        all_params = ['body', 'workbook_id', 'worksheet_id', 'no_workstep_message']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_workstep" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_workstep`")
        # verify the required parameter 'workbook_id' is set
        if ('workbook_id' not in params) or (params['workbook_id'] is None):
            raise ValueError("Missing the required parameter `workbook_id` when calling `create_workstep`")
        # verify the required parameter 'worksheet_id' is set
        if ('worksheet_id' not in params) or (params['worksheet_id'] is None):
            raise ValueError("Missing the required parameter `worksheet_id` when calling `create_workstep`")


        collection_formats = {}

        path_params = {}
        if 'workbook_id' in params:
            path_params['workbookId'] = params['workbook_id']
        if 'worksheet_id' in params:
            path_params['worksheetId'] = params['worksheet_id']

        query_params = []
        if 'no_workstep_message' in params:
            query_params.append(('noWorkstepMessage', params['no_workstep_message']))

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/workbooks/{workbookId}/worksheets/{worksheetId}/worksteps', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'WorkstepOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_recently_accessed(self, **kwargs):
        """
        Get the recently accessed list for the workbook
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_recently_accessed(workbook_id=workbook_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workbook_id: ID of the workbook (required)
        :return: ItemSearchPreviewListV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ItemSearchPreviewListV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_recently_accessed_with_http_info(**kwargs)
        else:
            (data) = self.get_recently_accessed_with_http_info(**kwargs)
            return data

    def get_recently_accessed_with_http_info(self, **kwargs):
        """
        Get the recently accessed list for the workbook
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_recently_accessed_with_http_info(workbook_id=workbook_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workbook_id: ID of the workbook (required)
        :return: ItemSearchPreviewListV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ItemSearchPreviewListV1
        """

        all_params = ['workbook_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_recently_accessed" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workbook_id' is set
        if ('workbook_id' not in params) or (params['workbook_id'] is None):
            raise ValueError("Missing the required parameter `workbook_id` when calling `get_recently_accessed`")


        collection_formats = {}

        path_params = {}
        if 'workbook_id' in params:
            path_params['workbookId'] = params['workbook_id']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/workbooks/{workbookId}/recently-accessed', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'ItemSearchPreviewListV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_referenced_items(self, **kwargs):
        """
        Get items referenced by workstep or a journal
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_referenced_items(worksheet_id=worksheet_id_value, workstep_id=workstep_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str worksheet_id: ID of the worksheet associated with journal that references items to return (required)
        :param str workstep_id: ID of the workstep that references items to return (required)
        :return: ReferencedItemsOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ReferencedItemsOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_referenced_items_with_http_info(**kwargs)
        else:
            (data) = self.get_referenced_items_with_http_info(**kwargs)
            return data

    def get_referenced_items_with_http_info(self, **kwargs):
        """
        Get items referenced by workstep or a journal
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_referenced_items_with_http_info(worksheet_id=worksheet_id_value, workstep_id=workstep_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str worksheet_id: ID of the worksheet associated with journal that references items to return (required)
        :param str workstep_id: ID of the workstep that references items to return (required)
        :return: ReferencedItemsOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ReferencedItemsOutputV1
        """

        all_params = ['worksheet_id', 'workstep_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_referenced_items" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'worksheet_id' is set
        if ('worksheet_id' not in params) or (params['worksheet_id'] is None):
            raise ValueError("Missing the required parameter `worksheet_id` when calling `get_referenced_items`")
        # verify the required parameter 'workstep_id' is set
        if ('workstep_id' not in params) or (params['workstep_id'] is None):
            raise ValueError("Missing the required parameter `workstep_id` when calling `get_referenced_items`")


        collection_formats = {}

        path_params = {}
        if 'worksheet_id' in params:
            path_params['worksheetId'] = params['worksheet_id']
        if 'workstep_id' in params:
            path_params['workstepId'] = params['workstep_id']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/workbooks/worksheets/{worksheetId}/worksteps/{workstepId}/referenced-items', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'ReferencedItemsOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_workbook(self, **kwargs):
        """
        Get a workbook
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workbook(id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: ID of the workbook to retrieve (required)
        :param bool full_ancestry: If true, the actual ancestor folders of the workbook will be returned, which includes the home folder of the relevant user. Otherwise, if a workbook is shared, then only the ancestors that are shared will be returned. Requires admin privileges.
        :return: WorkbookOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WorkbookOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_workbook_with_http_info(**kwargs)
        else:
            (data) = self.get_workbook_with_http_info(**kwargs)
            return data

    def get_workbook_with_http_info(self, **kwargs):
        """
        Get a workbook
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workbook_with_http_info(id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: ID of the workbook to retrieve (required)
        :param bool full_ancestry: If true, the actual ancestor folders of the workbook will be returned, which includes the home folder of the relevant user. Otherwise, if a workbook is shared, then only the ancestors that are shared will be returned. Requires admin privileges.
        :return: WorkbookOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WorkbookOutputV1
        """

        all_params = ['id', 'full_ancestry']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workbook" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_workbook`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = []
        if 'full_ancestry' in params:
            query_params.append(('fullAncestry', params['full_ancestry']))

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/workbooks/{id}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'WorkbookOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_workbook_owner(self, **kwargs):
        """
        Get owner information for a workbook, if user has access permissions of the owner
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workbook_owner(id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: ID of the workbook for which to retrieve owner information (required)
        :return: WorkbookOwnerOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WorkbookOwnerOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_workbook_owner_with_http_info(**kwargs)
        else:
            (data) = self.get_workbook_owner_with_http_info(**kwargs)
            return data

    def get_workbook_owner_with_http_info(self, **kwargs):
        """
        Get owner information for a workbook, if user has access permissions of the owner
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workbook_owner_with_http_info(id=id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: ID of the workbook for which to retrieve owner information (required)
        :return: WorkbookOwnerOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WorkbookOwnerOutputV1
        """

        all_params = ['id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workbook_owner" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_workbook_owner`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/workbooks/{id}/owner', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'WorkbookOwnerOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_workbooks(self, **kwargs):
        """
        Get a collection of workbooks
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workbooks(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_id: The user ID to return workbooks for, defaults to the current user if not specified. Only an admin user is allowed to specify a user ID.
        :param bool is_archived: True to filter results to only workbooks that have been archived, false to filter results to workbooks that are not archived.
        :param str sort_order: A field by which to order the workbooks followed by a space and 'asc' or 'desc'. Field name can be one of: createdAt, updatedAt, name
        :param int offset: The pagination offset, the index of the first collection item that will be returned in this page of results
        :param int limit: The pagination limit, the total number of collection items that will be returned in this page of results
        :return: WorkbookOutputListV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WorkbookOutputListV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_workbooks_with_http_info(**kwargs)
        else:
            (data) = self.get_workbooks_with_http_info(**kwargs)
            return data

    def get_workbooks_with_http_info(self, **kwargs):
        """
        Get a collection of workbooks
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workbooks_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_id: The user ID to return workbooks for, defaults to the current user if not specified. Only an admin user is allowed to specify a user ID.
        :param bool is_archived: True to filter results to only workbooks that have been archived, false to filter results to workbooks that are not archived.
        :param str sort_order: A field by which to order the workbooks followed by a space and 'asc' or 'desc'. Field name can be one of: createdAt, updatedAt, name
        :param int offset: The pagination offset, the index of the first collection item that will be returned in this page of results
        :param int limit: The pagination limit, the total number of collection items that will be returned in this page of results
        :return: WorkbookOutputListV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WorkbookOutputListV1
        """

        all_params = ['user_id', 'is_archived', 'sort_order', 'offset', 'limit']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workbooks" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'user_id' in params:
            query_params.append(('userId', params['user_id']))
        if 'is_archived' in params:
            query_params.append(('isArchived', params['is_archived']))
        if 'sort_order' in params:
            query_params.append(('sortOrder', params['sort_order']))
        if 'offset' in params:
            query_params.append(('offset', params['offset']))
        if 'limit' in params:
            query_params.append(('limit', params['limit']))

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/workbooks', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'WorkbookOutputListV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_worksheet(self, **kwargs):
        """
        Get a worksheet
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_worksheet(workbook_id=workbook_id_value, worksheet_id=worksheet_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workbook_id: ID of the workbook for which to retrieve the worksheets (required)
        :param str worksheet_id: ID of the worksheet to retrieve (required)
        :return: WorksheetOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WorksheetOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_worksheet_with_http_info(**kwargs)
        else:
            (data) = self.get_worksheet_with_http_info(**kwargs)
            return data

    def get_worksheet_with_http_info(self, **kwargs):
        """
        Get a worksheet
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_worksheet_with_http_info(workbook_id=workbook_id_value, worksheet_id=worksheet_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workbook_id: ID of the workbook for which to retrieve the worksheets (required)
        :param str worksheet_id: ID of the worksheet to retrieve (required)
        :return: WorksheetOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WorksheetOutputV1
        """

        all_params = ['workbook_id', 'worksheet_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_worksheet" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workbook_id' is set
        if ('workbook_id' not in params) or (params['workbook_id'] is None):
            raise ValueError("Missing the required parameter `workbook_id` when calling `get_worksheet`")
        # verify the required parameter 'worksheet_id' is set
        if ('worksheet_id' not in params) or (params['worksheet_id'] is None):
            raise ValueError("Missing the required parameter `worksheet_id` when calling `get_worksheet`")


        collection_formats = {}

        path_params = {}
        if 'workbook_id' in params:
            path_params['workbookId'] = params['workbook_id']
        if 'worksheet_id' in params:
            path_params['worksheetId'] = params['worksheet_id']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/workbooks/{workbookId}/worksheets/{worksheetId}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'WorksheetOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_worksheet_thumbnail(self, **kwargs):
        """
        Get the thumbnail for this worksheet
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_worksheet_thumbnail(workbook_id=workbook_id_value, worksheet_id=worksheet_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workbook_id: The ID of the workbook for containing the worksheet (required)
        :param str worksheet_id: The ID of the worksheet (required)
        :return: bytes
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: bytes
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_worksheet_thumbnail_with_http_info(**kwargs)
        else:
            (data) = self.get_worksheet_thumbnail_with_http_info(**kwargs)
            return data

    def get_worksheet_thumbnail_with_http_info(self, **kwargs):
        """
        Get the thumbnail for this worksheet
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_worksheet_thumbnail_with_http_info(workbook_id=workbook_id_value, worksheet_id=worksheet_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workbook_id: The ID of the workbook for containing the worksheet (required)
        :param str worksheet_id: The ID of the worksheet (required)
        :return: bytes
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: bytes
        """

        all_params = ['workbook_id', 'worksheet_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_worksheet_thumbnail" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workbook_id' is set
        if ('workbook_id' not in params) or (params['workbook_id'] is None):
            raise ValueError("Missing the required parameter `workbook_id` when calling `get_worksheet_thumbnail`")
        # verify the required parameter 'worksheet_id' is set
        if ('worksheet_id' not in params) or (params['worksheet_id'] is None):
            raise ValueError("Missing the required parameter `worksheet_id` when calling `get_worksheet_thumbnail`")


        collection_formats = {}

        path_params = {}
        if 'workbook_id' in params:
            path_params['workbookId'] = params['workbook_id']
        if 'worksheet_id' in params:
            path_params['worksheetId'] = params['worksheet_id']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json', 'image/png'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/workbooks/{workbookId}/worksheets/{worksheetId}/thumbnail', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'bytes'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_worksheet_usages(self, **kwargs):
        """
        Get a list of reports that reference a given worksheet
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_worksheet_usages(workbook_id=workbook_id_value, worksheet_id=worksheet_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workbook_id: The ID of the workbook for containing the worksheet (required)
        :param str worksheet_id: The ID of the worksheet (required)
        :param int offset: The pagination offset, the index of the first collection item that will be returned in this page of results
        :param int limit: The pagination limit, the total number of collection items that will be returned in this page of results
        :return: AnnotationListOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AnnotationListOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_worksheet_usages_with_http_info(**kwargs)
        else:
            (data) = self.get_worksheet_usages_with_http_info(**kwargs)
            return data

    def get_worksheet_usages_with_http_info(self, **kwargs):
        """
        Get a list of reports that reference a given worksheet
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_worksheet_usages_with_http_info(workbook_id=workbook_id_value, worksheet_id=worksheet_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workbook_id: The ID of the workbook for containing the worksheet (required)
        :param str worksheet_id: The ID of the worksheet (required)
        :param int offset: The pagination offset, the index of the first collection item that will be returned in this page of results
        :param int limit: The pagination limit, the total number of collection items that will be returned in this page of results
        :return: AnnotationListOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AnnotationListOutputV1
        """

        all_params = ['workbook_id', 'worksheet_id', 'offset', 'limit']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_worksheet_usages" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workbook_id' is set
        if ('workbook_id' not in params) or (params['workbook_id'] is None):
            raise ValueError("Missing the required parameter `workbook_id` when calling `get_worksheet_usages`")
        # verify the required parameter 'worksheet_id' is set
        if ('worksheet_id' not in params) or (params['worksheet_id'] is None):
            raise ValueError("Missing the required parameter `worksheet_id` when calling `get_worksheet_usages`")


        collection_formats = {}

        path_params = {}
        if 'workbook_id' in params:
            path_params['workbookId'] = params['workbook_id']
        if 'worksheet_id' in params:
            path_params['worksheetId'] = params['worksheet_id']

        query_params = []
        if 'offset' in params:
            query_params.append(('offset', params['offset']))
        if 'limit' in params:
            query_params.append(('limit', params['limit']))

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/workbooks/{workbookId}/worksheets/{worksheetId}/usages', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'AnnotationListOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_worksheets(self, **kwargs):
        """
        Get a collection of worksheets
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_worksheets(workbook_id=workbook_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workbook_id: The ID of the workbook for which to retrieve the worksheets (required)
        :param int offset: The pagination offset, the index of the first collection item that will be returned in this page of results
        :param int limit: The pagination limit, the total number of collection items that will be returned in this page of results
        :param bool is_archived: Whether to return archived worksheets
        :return: WorksheetOutputListV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WorksheetOutputListV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_worksheets_with_http_info(**kwargs)
        else:
            (data) = self.get_worksheets_with_http_info(**kwargs)
            return data

    def get_worksheets_with_http_info(self, **kwargs):
        """
        Get a collection of worksheets
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_worksheets_with_http_info(workbook_id=workbook_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workbook_id: The ID of the workbook for which to retrieve the worksheets (required)
        :param int offset: The pagination offset, the index of the first collection item that will be returned in this page of results
        :param int limit: The pagination limit, the total number of collection items that will be returned in this page of results
        :param bool is_archived: Whether to return archived worksheets
        :return: WorksheetOutputListV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WorksheetOutputListV1
        """

        all_params = ['workbook_id', 'offset', 'limit', 'is_archived']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_worksheets" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workbook_id' is set
        if ('workbook_id' not in params) or (params['workbook_id'] is None):
            raise ValueError("Missing the required parameter `workbook_id` when calling `get_worksheets`")


        collection_formats = {}

        path_params = {}
        if 'workbook_id' in params:
            path_params['workbookId'] = params['workbook_id']

        query_params = []
        if 'offset' in params:
            query_params.append(('offset', params['offset']))
        if 'limit' in params:
            query_params.append(('limit', params['limit']))
        if 'is_archived' in params:
            query_params.append(('isArchived', params['is_archived']))

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/workbooks/{workbookId}/worksheets', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'WorksheetOutputListV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_workstep(self, **kwargs):
        """
        Get a workstep
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workstep(workbook_id=workbook_id_value, worksheet_id=worksheet_id_value, workstep_id=workstep_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workbook_id: ID of the workbook for which to retrieve the worksteps (required)
        :param str worksheet_id: ID of the worksheet for which to retrieve the worksteps (required)
        :param str workstep_id: ID of the workstep to retrieve (required)
        :return: WorkstepOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WorkstepOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_workstep_with_http_info(**kwargs)
        else:
            (data) = self.get_workstep_with_http_info(**kwargs)
            return data

    def get_workstep_with_http_info(self, **kwargs):
        """
        Get a workstep
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workstep_with_http_info(workbook_id=workbook_id_value, worksheet_id=worksheet_id_value, workstep_id=workstep_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workbook_id: ID of the workbook for which to retrieve the worksteps (required)
        :param str worksheet_id: ID of the worksheet for which to retrieve the worksteps (required)
        :param str workstep_id: ID of the workstep to retrieve (required)
        :return: WorkstepOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WorkstepOutputV1
        """

        all_params = ['workbook_id', 'worksheet_id', 'workstep_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workstep" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workbook_id' is set
        if ('workbook_id' not in params) or (params['workbook_id'] is None):
            raise ValueError("Missing the required parameter `workbook_id` when calling `get_workstep`")
        # verify the required parameter 'worksheet_id' is set
        if ('worksheet_id' not in params) or (params['worksheet_id'] is None):
            raise ValueError("Missing the required parameter `worksheet_id` when calling `get_workstep`")
        # verify the required parameter 'workstep_id' is set
        if ('workstep_id' not in params) or (params['workstep_id'] is None):
            raise ValueError("Missing the required parameter `workstep_id` when calling `get_workstep`")


        collection_formats = {}

        path_params = {}
        if 'workbook_id' in params:
            path_params['workbookId'] = params['workbook_id']
        if 'worksheet_id' in params:
            path_params['worksheetId'] = params['worksheet_id']
        if 'workstep_id' in params:
            path_params['workstepId'] = params['workstep_id']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/workbooks/{workbookId}/worksheets/{worksheetId}/worksteps/{workstepId}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'WorkstepOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_worksteps(self, **kwargs):
        """
        Get a list of worksteps starting from the given workstep, searching in the given direction.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_worksteps(workbook_id=workbook_id_value, worksheet_id=worksheet_id_value, from_workstep_id=from_workstep_id_value, direction=direction_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workbook_id: ID of the workbook for which to retrieve the worksteps (required)
        :param str worksheet_id: ID of the worksheet for which to retrieve the worksteps (required)
        :param str from_workstep_id: ID of the workstep from where the search starts (required)
        :param str direction: The direction of the search to retrieve worksteps starting from the given one (required)
        :param int limit: The maximum number of worksteps to be retrieved during the search.
        :return: WorkstepChronologyOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WorkstepChronologyOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_worksteps_with_http_info(**kwargs)
        else:
            (data) = self.get_worksteps_with_http_info(**kwargs)
            return data

    def get_worksteps_with_http_info(self, **kwargs):
        """
        Get a list of worksteps starting from the given workstep, searching in the given direction.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_worksteps_with_http_info(workbook_id=workbook_id_value, worksheet_id=worksheet_id_value, from_workstep_id=from_workstep_id_value, direction=direction_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workbook_id: ID of the workbook for which to retrieve the worksteps (required)
        :param str worksheet_id: ID of the worksheet for which to retrieve the worksteps (required)
        :param str from_workstep_id: ID of the workstep from where the search starts (required)
        :param str direction: The direction of the search to retrieve worksteps starting from the given one (required)
        :param int limit: The maximum number of worksteps to be retrieved during the search.
        :return: WorkstepChronologyOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WorkstepChronologyOutputV1
        """

        all_params = ['workbook_id', 'worksheet_id', 'from_workstep_id', 'direction', 'limit']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_worksteps" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workbook_id' is set
        if ('workbook_id' not in params) or (params['workbook_id'] is None):
            raise ValueError("Missing the required parameter `workbook_id` when calling `get_worksteps`")
        # verify the required parameter 'worksheet_id' is set
        if ('worksheet_id' not in params) or (params['worksheet_id'] is None):
            raise ValueError("Missing the required parameter `worksheet_id` when calling `get_worksteps`")
        # verify the required parameter 'from_workstep_id' is set
        if ('from_workstep_id' not in params) or (params['from_workstep_id'] is None):
            raise ValueError("Missing the required parameter `from_workstep_id` when calling `get_worksteps`")
        # verify the required parameter 'direction' is set
        if ('direction' not in params) or (params['direction'] is None):
            raise ValueError("Missing the required parameter `direction` when calling `get_worksteps`")


        collection_formats = {}

        path_params = {}
        if 'workbook_id' in params:
            path_params['workbookId'] = params['workbook_id']
        if 'worksheet_id' in params:
            path_params['worksheetId'] = params['worksheet_id']

        query_params = []
        if 'from_workstep_id' in params:
            query_params.append(('fromWorkstepId', params['from_workstep_id']))
        if 'direction' in params:
            query_params.append(('direction', params['direction']))
        if 'limit' in params:
            query_params.append(('limit', params['limit']))

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/workbooks/{workbookId}/worksheets/{worksheetId}/worksteps', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'WorkstepChronologyOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def move_worksheet(self, **kwargs):
        """
        Move a Worksheet to a new location in the same Workbook
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.move_worksheet(workbook_id=workbook_id_value, worksheet_id=worksheet_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workbook_id: ID of the workbook on which the worksheet exists (required)
        :param str worksheet_id: ID of the worksheet on which the workstep exists (required)
        :param str next_worksheet_id: ID of the worksheet that the specified worksheet should precede. If not supplied then the worksheet will be moved to be the last worksheet in the workbook.
        :return: WorksheetOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WorksheetOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.move_worksheet_with_http_info(**kwargs)
        else:
            (data) = self.move_worksheet_with_http_info(**kwargs)
            return data

    def move_worksheet_with_http_info(self, **kwargs):
        """
        Move a Worksheet to a new location in the same Workbook
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.move_worksheet_with_http_info(workbook_id=workbook_id_value, worksheet_id=worksheet_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workbook_id: ID of the workbook on which the worksheet exists (required)
        :param str worksheet_id: ID of the worksheet on which the workstep exists (required)
        :param str next_worksheet_id: ID of the worksheet that the specified worksheet should precede. If not supplied then the worksheet will be moved to be the last worksheet in the workbook.
        :return: WorksheetOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WorksheetOutputV1
        """

        all_params = ['workbook_id', 'worksheet_id', 'next_worksheet_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method move_worksheet" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workbook_id' is set
        if ('workbook_id' not in params) or (params['workbook_id'] is None):
            raise ValueError("Missing the required parameter `workbook_id` when calling `move_worksheet`")
        # verify the required parameter 'worksheet_id' is set
        if ('worksheet_id' not in params) or (params['worksheet_id'] is None):
            raise ValueError("Missing the required parameter `worksheet_id` when calling `move_worksheet`")


        collection_formats = {}

        path_params = {}
        if 'workbook_id' in params:
            path_params['workbookId'] = params['workbook_id']
        if 'worksheet_id' in params:
            path_params['worksheetId'] = params['worksheet_id']

        query_params = []
        if 'next_worksheet_id' in params:
            query_params.append(('nextWorksheetId', params['next_worksheet_id']))

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/workbooks/{workbookId}/worksheets/{worksheetId}/next', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'WorksheetOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def set_current_workstep(self, **kwargs):
        """
        Set the current workstep
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.set_current_workstep(workbook_id=workbook_id_value, worksheet_id=worksheet_id_value, workstep_id=workstep_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workbook_id: ID of the workbook on which the worksheet exists (required)
        :param str worksheet_id: ID of the worksheet on which the workstep exists (required)
        :param str workstep_id: ID of the workstep to set as the current one (required)
        :return: WorkstepOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WorkstepOutputV1
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.set_current_workstep_with_http_info(**kwargs)
        else:
            (data) = self.set_current_workstep_with_http_info(**kwargs)
            return data

    def set_current_workstep_with_http_info(self, **kwargs):
        """
        Set the current workstep
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.set_current_workstep_with_http_info(workbook_id=workbook_id_value, worksheet_id=worksheet_id_value, workstep_id=workstep_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workbook_id: ID of the workbook on which the worksheet exists (required)
        :param str worksheet_id: ID of the worksheet on which the workstep exists (required)
        :param str workstep_id: ID of the workstep to set as the current one (required)
        :return: WorkstepOutputV1
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WorkstepOutputV1
        """

        all_params = ['workbook_id', 'worksheet_id', 'workstep_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_current_workstep" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workbook_id' is set
        if ('workbook_id' not in params) or (params['workbook_id'] is None):
            raise ValueError("Missing the required parameter `workbook_id` when calling `set_current_workstep`")
        # verify the required parameter 'worksheet_id' is set
        if ('worksheet_id' not in params) or (params['worksheet_id'] is None):
            raise ValueError("Missing the required parameter `worksheet_id` when calling `set_current_workstep`")
        # verify the required parameter 'workstep_id' is set
        if ('workstep_id' not in params) or (params['workstep_id'] is None):
            raise ValueError("Missing the required parameter `workstep_id` when calling `set_current_workstep`")


        collection_formats = {}

        path_params = {}
        if 'workbook_id' in params:
            path_params['workbookId'] = params['workbook_id']
        if 'worksheet_id' in params:
            path_params['worksheetId'] = params['worksheet_id']
        if 'workstep_id' in params:
            path_params['workstepId'] = params['workstep_id']

        query_params = []

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/workbooks/{workbookId}/worksheets/{worksheetId}/worksteps/{workstepId}/current', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'WorkstepOutputV1'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def set_renderer(self, **kwargs):
        """
        Set the topic's renderer.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.set_renderer(id=id_value, user_id=user_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: ID of the topic to change the renderer of (required)
        :param str user_id: The user to make the topic's renderer (required)
        :return: StatusMessageBase
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StatusMessageBase
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.set_renderer_with_http_info(**kwargs)
        else:
            (data) = self.set_renderer_with_http_info(**kwargs)
            return data

    def set_renderer_with_http_info(self, **kwargs):
        """
        Set the topic's renderer.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.set_renderer_with_http_info(id=id_value, user_id=user_id_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: ID of the topic to change the renderer of (required)
        :param str user_id: The user to make the topic's renderer (required)
        :return: StatusMessageBase
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StatusMessageBase
        """

        all_params = ['id', 'user_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('_response_type')
        all_params.append('_custom_headers')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_renderer" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `set_renderer`")
        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `set_renderer`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = []
        if 'user_id' in params:
            query_params.append(('userId', params['user_id']))

        header_params = {}

        for key, value in params.get('_custom_headers', {}).items():
            header_params[key] = value


        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/vnd.seeq.v1+json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/vnd.seeq.v1+json', ])

        # Authentication setting
        auth_settings = ['api_key']

        return self.api_client.call_api('/workbooks/{id}/renderer', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=params.get('_response_type', 'StatusMessageBase'),
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
