# Intro

`Variable` is a way to to define inputs to the network, very much similar to the `Input` class in `Keras`. However, since we need to perform differentiation and other operations on the network, we cannot just use `Input`. Instead, we need to define the inputs of the network through `Variable`. 

For scientific computations, a `Variable` has only a dimension of 1. Therefore, if you need to have a three-dimensional coordinate inputs, you need to define three variables:

```python
from sciann import Variable

x = Variable('x')
y = Variable('y')
z = Variable('z')
```

This is precisely because we need to perform differentiation with respect to (x, y, z). 


---

{{autogenerated}}
