# GeoGebra Icon Examples

This page demonstrates the GeoGebra icon role for inline SVG icons.

## What are GeoGebra Icons?

GeoGebra icons represent different tools and modes in GeoGebra. You can reference them inline in your text to show which tool or feature you're discussing.

## Available Icons

Here are all the available GeoGebra icons:

### Intersection Tool
Use the {ggb-icon}`mode_intersect` tool to find intersection points between objects.

### Solve Tool
The {ggb-icon}`mode_solve` tool allows you to solve equations symbolically.

### Numeric Solve Tool
For numeric solutions, use the {ggb-icon}`mode_nsolve` tool.

### Point Tool
Create points with the {ggb-icon}`mode_point` tool.

### Evaluate Tool
Use {ggb-icon}`mode_evaluate` to compute or evaluate expressions.

### Extremum Tool
Find minimum and maximum values with the {ggb-icon}`mode_extremum` tool.

### Numeric Tool
For numeric computations, use {ggb-icon}`mode_numeric`.

## Using in Instructions

Here's how you might use these icons in teaching instructions:

1. Open GeoGebra and select the {ggb-icon}`mode_point` tool
2. Click on the coordinate plane to create two points
3. Then use the {ggb-icon}`mode_intersect` tool to find where two lines meet
4. Finally, click {ggb-icon}`mode_solve` to solve the resulting equation

## Multiple Icons in a Sentence

You can use multiple icons in one sentence: To analyze a function, you might use {ggb-icon}`mode_extremum` to find critical points, {ggb-icon}`mode_numeric` for calculations, and {ggb-icon}`mode_evaluate` to verify your results.

## Technical Notes

- Icons are SVG format for crisp display at any size
- They appear inline with the text
- Alt text is automatically generated for accessibility
- Icons scale with the surrounding text size
