# Jeopardy example





:::{jeopardy}

Category: Potensregler
100:
    Q: Bestem $a$ slik at likningen blir en identitet $$\left(x^3\right)^4 \cdot x^2 = x^a$$ <br> <i> Husk at en identitet er en likning som er sann for alle $x$ i definisjonsmengden.</i>
    A: $$a = 14$$

200:
    Q: Bestem $a$ slik at likningen blir en identitet $$\dfrac{x^{2a}}{x^{3a - 4}} = x^2$$ <br> <i> Husk at en identitet er en likning som er sann for alle $x$ i definisjonsmengden.</i>
    A: $$a = 2$$

300:
    Q: Bestem $a$ slik at likningen blir en identitet $$\left(x^{a + 1}\right)^2 \cdot x^{2a - 1} = x^{5a}$$ <br> <i> Husk at en identitet er en likning som er sann for alle $x$ i definisjonsmengden.</i>
    A: $$a = 1$$

400:
    Q: Bestem $a$ slik at likningen blir en identitet $$\dfrac{x^{2a + 1}}{(x^{a - 2})^3} = x^{4}$$ <br> <i> Husk at en identitet er en likning som er sann for alle $x$ i definisjonsmengden.</i>
    A: $$a = 3$$

500:
    Q: Bestem $a$ slik at likningen blir en identitet $$\left(\dfrac{x^{a + 2}}{x^{2a - 1}}\right)^3 = x^{6}$$ <br> <i> Husk at en identitet er en likning som er sann for alle $x$ i definisjonsmengden.</i>
    A: $$a = 1$$    

Category: Logaritmer

100:
    Q: Bestem $\lg 1000$
    A: $3$

200:
    Q: Bestem $\ln e^5$
    A: $5$

300:
    Q: Anta $x > 0$ og $y > 0$. Bestem $a$ og $b$ slik at likningen blir en identitet $$\lg x^2 y - \lg \dfrac{x^3}{y^2} = \lg x^a y^b$$ <br> <i> Husk at en identitet er en likning som er sann for alle $x$ og $y$ i definisjonsmengden.</i>
    A: $$a = -1 \quad \land \quad b = 3$$

400:
    Q: Grafen til en funksjon $$f(x) = \log_a (x)$$ er vist i figuren nedenfor.<br> <br> Bestem $a$. ![{width="50%", class="adaptive-figure"}](./figurer/jeopardy_1/logaritmer_400/figur.svg)
    A: $$a = 3$$

500:
    Q: Grafen til $$f(x) = \log_a (x) \cdot \left(\log_a(x) - 3\right)$$ er vist i figuren nedenfor.  <br> <br> Bestem $a$. ![{width="50%", class="adaptive-figure"}](./figurer/jeopardy_1/logaritmer_500/figur.svg)
    A: $$a = 2$$



Category: Eksponentiallikninger


100:
    Q: Løs likningen $$3 \cdot 2^x = 5 \cdot 3^x$$
    A: $$x = \dfrac{\ln 3 - \ln 5}{\ln 3 - \ln 2}$$

200:
    Q: Grafen til $f(x) = \ln x$ er vist i figuren nedenfor. <br><br> Bruk grafen til å bestemme en tilnærmet løsning til $$e^x = 12$$ ![{width="60%", class="adaptive-figure"}](./figurer/jeopardy_1/eksponentiallikninger_300/figur.svg)
    A: $$x \approx 2.5$$


300:
    Q: Løs likningen $$9^x - 4\cdot 3^x + 3 = 0$$
    A: $$x = 0 \quad \lor \quad x = 1$$


400:
    Q: Løs likningen $$e^x - 5 = -6e^{-x}$$
    A: $$x = \ln 2 \quad \lor \quad x = \ln 3$$


500:
    Q: En funksjon $f$ er gitt ved $$f(x) = 4^x - 12 \cdot 2^x + 32$$ <br> Bestem hvilken figur nedenfor som viser grafen til $f$. ![{width="80%", class="adaptive-figure"}](./figurer/jeopardy_1/eksponentiallikninger_500/merged_figure.svg)
    A: Figur D.


Category: Logaritmelikninger

100:
    Q: Løs likningen $$\lg (x - 2) + \lg 3 = 1$$
    A: $$x = \dfrac{16}{3}$$

200:
    Q: Løs likningen $$\lg (x - 3) + \lg x = 1$$
    A: $$x = 5$$

300:
    Q: Løs likningen $$(\ln x)^2 - 3 \ln x + 2 = 0$$
    A: $$x = e \quad \lor \quad x = e^2$$

400:
    Q: Løs likningen $$\log_2 (x + 1) + \log_2 (x - 3) = 5$$
    A: $$x = 7$$

500:
    Q: En funksjon $f$ er gitt ved $$f(x) = (\log_3 x)^2 - 4 \log_3 x + 3$$ <br> Bestem hvilken figur nedenfor som viser grafen til $f$. ![{width="80%", class="adaptive-figure"}](./figurer/jeopardy_1/logaritmelikninger_500/merged_figure.svg)
    A: Figur C.

:::




---




:::{jeopardy}
Category: Grenseverdier

100:
    Q: Bestem $$\lim_{x \to 2} 2x - 3$$
    A: $$1$$

200:
    Q: Bestem $$\lim_{x \to \infty} \dfrac{5}{x^3 - 2}$$
    A: $$0$$

300:
    Q: Bestem $$\lim_{x \to -3^{-}} \dfrac{1}{x + 3}$$
    A: $$-\infty$$

400:
    Q: Bestem $$\lim_{x \to \infty} \dfrac{7x^3 + 2x + 1}{3x^3 + 1}$$
    A: $$\dfrac{7}{3}$$

500:
    Q: Bestem $$\lim_{x \to 0^+} x^3 \ln x$$
    A: $$0$$




Category: Kontinuitet
100:
    Q: Avgjør om $f$ er kontinuerlig i $x = 0$ når $$f(x) = \begin{cases} 2x \quad \text{for} \quad x \lt 0 \\ \\ x^2 \quad \text{for} \quad x \geq 0 \end{cases}$$
    A: Ja, funksjonen er kontinuerlig i $x = 0$.

200:
    Q: Avgjør om $f$ er kontinuerlig i $x = 2$ når $$f(x) = \begin{cases} x + 1 \quad \text{for} \quad x \lt 2 \\ \\ 3x - 2 \quad \text{for} \quad x \geq 2 \end{cases}$$
    A: Nei, funksjonen er ikke kontinuerlig i $x = 2$

300:
    Q: Bestem $a$ slik at $f$ er kontinuerlig når $$f(x) = \begin{cases} ax + 1 \quad \text{for} \quad x < 1 \\ \\ 2x - a \quad \text{for} \quad x \geq 1\end{cases}$$
    A: $$a = \dfrac{1}{2}$$

400:
    Q: Bestem $a$ slik at $f$ er kontinuerlig når $$f(x) = \begin{cases} \dfrac{x^2 - 9}{x - 3} \quad \text{for} \quad x < 3 \\ \\ ax - 3 \quad \text{for} \quad x \geq 3\end{cases}$$
    A: $$a = 3$$

500:
    Q: Bestem $a$ slik at $f$ er kontinuerlig når $$f(x) = \begin{cases} \dfrac{x^2 - 4}{x + 2} \quad \text{for} \quad x < -2 \\ \\ ae^{x + 2} - 1 \quad \text{for} \quad x \geq -2\end{cases}$$
    A: $$a = -3$$




Category: Asymptoter

100:
    Q: Bestem den horisontale asymptoten til $f$ når $$f(x) = \dfrac{2x^2 + 3}{x^2 - 1}$$
    A: $$y = 2$$

200:
    Q: Bestem den vertikale asymptoten til $f$ når $$f(x) = \dfrac{x^2 - 4}{x + 2}$$
    A: $$x = -2$$

300:
    Q: Bestem den skrå asymptoten til $f$ når $$f(x) = \dfrac{x^2 + 1}{x - 1}$$
    A: $$y = x + 1$$

400:
    Q: En rasjonal funksjon $f$ tilfredsstiller $$\begin{align*} & \lim_{x \to -2^-} f(x) = -\infty \quad \land \quad \lim_{x \to -2^+} f(x) = \infty \quad \land \quad \lim_{x \to 1^-} f(x) = \infty \quad \land \quad \lim_{x \to 1^+} f(x) = \infty \\ \\ & \lim_{x \to \pm \infty} \left(f(x) - (2x + 1)\right) = 0 \end{align*}$$ Hvilken av figurene nedenfor viser grafen til $f$? ![{width="60%", class="adaptive-figure"}](./figurer/jeopardy_2/asymptoter_400/merged_figure.svg)
    A: Figur A

500:
    Q: En rasjonal funksjon $f$ tilfredsstiller $$\begin{align*} & \lim_{x \to -2^-} f(x) = -\infty \quad \land \quad \lim_{x \to -2^+} f(x) = \infty \quad \land \quad \lim_{x \to 3^-} f(x) = -\infty \quad \land \quad \lim_{x \to 3^+} f(x) = -\infty \\ \\ & \lim_{x \to \pm \infty} \left(f(x) - \left(-3x + 4\right)\right) = 0 \quad \land \quad f(c) = 0 \quad \text{for nøyaktig én} \quad c \in \langle -2, 3 \rangle \end{align*}$$ Lag en skisse av grafen til $f$.
    A: ![{width="60%", class="adaptive-figure"}](./figurer/jeopardy_2/asymptoter_500/figur.svg)


:::



---


:::{jeopardy}
Category: Grunnleggende derivasjonsregler
100:
    Q: Bestem $f'(x)$ når $$f(x) = 6x^3 + 5x^2 + 4x + 3$$
    A: $$f'(x) = 18x^2 + 10x + 4$$
200:
    Q: Bestem $f'(x)$ når $$f(x) = \ln 3x$$
    A: $$f'(x) = \dfrac{1}{x}$$
300:
    Q: Bestem $f'(x)$ når $$f(x) = 3\sqrt{x}$$
    A: $$f'(x) = \dfrac{3}{2\sqrt{x}}$$
400:
    Q: Bestem $f'(x)$ når $$f(x) = \sqrt{x} + \dfrac{1}{\sqrt{x}}$$
    A: $$f'(x) = \dfrac{1}{2\sqrt{x}} - \dfrac{1}{2x\sqrt{x}}$$
500:
    Q: Bestem $f'(x)$ når $$f(x) = \dfrac{2}{e^{2x}}$$
    A: $$f'(x) = -\dfrac{4}{e^{2x}}$$


Category: Kjerneregelen
100:
    Q: Bestem $f'(x)$ når $$f(x) = e^{x^2}$$
    A: $$f'(x) = 2x e^{x^2}$$

200:
    Q: Bestem $f'(x)$ når $$f(x) = \ln (x^3 + 1)$$
    A: $$f'(x) = \dfrac{3x^2}{x^3 + 1}$$

300:
    Q: Bestem $f'(x)$ når $$f(x) = \sqrt{x^2 - 100}$$
    A: $$f'(x) = \dfrac{x}{\sqrt{x^2 - 100}}$$


400:
    Q: Bestem $f'(x)$ når $$f(x) = e^{\sqrt{1 - x}}$$
    A: $$f'(x) = -\dfrac{e^{\sqrt{1 - x}}}{2\sqrt{1 - x}}$$

500:
    Q: Bestem $f'(x)$ når $$f(x) = \sqrt{\ln(x^2 + 1)}$$
    A: $$f'(x) = \dfrac{2x}{(x^2 + 1) \cdot 2\sqrt{\ln(x^2 + 1)}}$$


Category: Produktregelen

100:
    Q: Bestem $f'(x)$ når $$f(x) = x e^x$$
    A: $$f'(x) = e^x (x + 1)$$

200:
    Q: Bestem $f'(x)$ når $$f(x) = x^2 \ln x$$
    A: $$f'(x) = x (2 \ln x + 1)$$

300:
    Q: Bestem $f'(x)$ når $$f(x) = x\sqrt{10 - x^2}$$
    A: $$f'(x) = \dfrac{10 - 2x^2}{\sqrt{10 - x^2}}$$

400:
    Q: Bestem $f'(x)$ når $$f(x) = \sqrt{x} \, e^{-2x}$$
    A: $$f'(x) = \left(\dfrac{1}{2\sqrt{x}} - 2\sqrt{x}\right)e^{-2x}$$

500:
    Q: Bestem $f'(x)$ når $$f(x) = e^{-x} \ln \sqrt{x^2 + 1}$$
    A: $$f'(x) = -e^{-x} \ln \sqrt{x^2 + 1} + \dfrac{x e^{-x}}{x^2 + 1}$$



Category: Brøkregelen
100:
    Q: Bestem $f'(x)$ når $$f(x) = \dfrac{e^x}{x}$$
    A: $$f'(x) = \dfrac{e^x (x - 1)}{x^2}$$

200:
    Q: Bestem $f'(x)$ når $$f(x) = \dfrac{\ln x}{x^2}$$
    A: $$f'(x) = \dfrac{1 - 2 \ln x}{x^3}$$

300:
    Q: Bestem $f'(x)$ når $$f(x) = \dfrac{\ln 2x}{e^x}$$
    A: $$f'(x) = \dfrac{1 - x \ln 2x}{x e^x}$$

400:
    Q: Bestem $f'(x)$ når $$f(x) = \dfrac{e^{2x}}{\sqrt{x}}$$
    A: $$f'(x) = \dfrac{(4x - 1)e^{2x}}{2x\sqrt{x}}$$


500:
    Q: Bestem $f'(x)$ når $$f(x) = \dfrac{e^{-2x}}{\ln x}$$
    A: $$f'(x) = - \dfrac{e^{-2x}(2x \ln x + 1)}{x (\ln x)^2}$$


Category: Blanda drops

100:
    Q: Bestem $f'(x)$ når $$f(x) = x e^{-x^2}$$
    A: $$f'(x) = (1 - 2x^2)e^{-x^2}$$


200:
    Q: Bestem $f'(x)$ når $$f(x) = x\sqrt{100 - x^2}$$
    A: $$f'(x) = \sqrt{100 - x^2} - \dfrac{x^2}{\sqrt{100 - x^2}}$$

300:
    Q: Bestem $f'(x)$ når $$f(x) = \dfrac{\ln x}{xe^x}$$
    A: $$f'(x) = \dfrac{1 - (x + 1) \ln x}{x^2 e^x}$$

400:
    Q: Bestem $f'(x)$ når $$f(x) = \dfrac{x^2 - 1}{e^{x^2}}$$
    A: $$f'(x) = \dfrac{-x^2 + 2x + 1}{e^{x^2}}$$

500:
    Q: Bestem $f'(x)$ når $$f(x) = \dfrac{\sqrt{x} \ln x}{e^{3x}}$$
    A: $$f'(x) = \dfrac{(1 - 6x)\ln x + 2}{2\sqrt{x} \, e^{3x}}$$ 

:::



---



:::{jeopardy}
Category: Størst og minst verdi

100:
    Q: Bestem koordinatene til bunnpunktet til $$f(x) = x^2 - 4x + 5$$
    A: $$(2, 1)$$

200:
    Q: Ekstremalpunktene til $$f(x) = \dfrac{1}{3}x^3 + x^2 - 3x + 2$$
    A: $$x = -3 \quad \lor \quad x = 1$$

300:
    Q: Bestem koordinatene til eventuelle topp- og bunnpunkt til $$f(x) = e^x(2x - 4)^2$$
    A: Toppunkt i $(0, 16)$ og bunnpunkt i $(2, 0)$.

400:
    Q: Bestem koordinatene til eventuelle topp- og bunnpunkter til $$f(x) = e^{-x}(x - 1)^2$$
    A: Bunnpunkt i $(1, 0)$ og toppunkt i $\left(3, \dfrac{4}{e^3}\right)$.

500:
    Q: En funksjon $f$ er gitt ved $$f(x) = x^2 \sqrt[3]{(x - 4)^2}$$ <br> Hvilken av figurene nedenfor viser grafen til $f$? ![{width="70%", class="adaptive-figure"}](./figurer/jeopardy_4/størst_og_minst_verdi_500/merged_figure.svg)
    A: Figur B.

Category: Størst og minst vekst

100:
    Q: En funksjon $f$ oppfyller $f'(2) = 0$ og $f''(2) > 0$. Hva kan du si om punktet $(2, f(2))$ på grafen til $f$?
    A: Punktet er et bunnpunkt.


200:
    Q: Bestem koordinatene til vendepunktet til $$f(x) = (x - 1)(x^2 + 2x + 1)$$
    A: $$\left(-\dfrac{1}{3}, -\dfrac{16}{27}\right)$$

300:
    Q: Bestem likningen til vendetangenten til $$f(x) = x e^{-x}$$
    A: $$y = -\dfrac{1}{e^2}x + \dfrac{4}{e^2}$$

400:
    Q: Bestem koordinatene til eventuelle vendepunkter til $$f(x) = x^3 e^{-x}$$
    A: Vendepunkter i $\left(0, 0\right)$ og $\left(3, \dfrac{27}{e^3}\right)$

500:
    Q: Vendetangenten til en funksjon $f$ skjærer $y$-aksen i et punkt $A$ og $x$-aksen i et punkt $B$ som danner en trekant $\triangle OAB$ der $O$ er origo. Bestem en eksakt verdi for arealet av trekanten når $$f(x) = x e^{-x}$$
    A: $$\text{Areal}_{\triangle OAB} = \dfrac{1}{2e^2}$$


Category: Optimering

100:
    Q: En rasjonal funksjon $f$ er gitt ved $$f(x) = \dfrac{8}{x^2 + 4}$$ <br> Et rektangel har hjørnene i $(0, 0)$, $(k, 0)$, $(0, f(k))$ og $(k, f(k))$ der $k > 0$. Se figuren nedenfor. <br> <br> Bestem $k$ slik at arealet av rektangelet er størst mulig. ![{width="60%", class="adaptive-figure"}](./figurer/jeopardy_4/optimering_100/figur.svg)
    A: $$k = 2$$

200:
    Q: Bestem den korteste mulige lengden til summen av linjestykkene $AB + BC$. Se figuren nedenfor. ![{width="60%", class="adaptive-figure"}](./figurer/jeopardy_4/optimering_200/figur.svg)
    A: $$10 \sqrt{2}$$

300:
    Q: Anna skal reise fra en holme som ligger $8$ km fra strandkanten. $12$ km fra det punktet på stranden som ligger nærmest holmen, ligger en hytte. Anna kan ro med en fart på $2$ km/t og kan gå med fart på $6$ km/t når hun er på land. Anna kan gå i land hvor som helst på stranden. Se figuren nedenfor. <br><br> Bestem den korteste mulige tiden Anna kan bruke på å komme seg til hytta. ![{width="60%", class="adaptive-figure"}](./figurer/jeopardy_4/optimering_300/figur.svg)

400:
    Q: En takrenne skal lages ut av et metallstykke som er $30$ cm langt. Metallstykket brettes opp slik at det danner en takrenne som har tre like lange deler. Takrennen har da en høyde $x$. Se figuren nedenfor. <br><br> Bestem hvilken høyde som gir størst mulig tverrsnittsareal. ![{width="60%", class="adaptive-figure"}](./figurer/jeopardy_4/optimering_400/figur.svg)
    A: $$x = 5 \sqrt{3} \, \mathrm{cm}$$

500:
    Q: En funksjon $f$ er definert ved $$f(x) = 1 - x^2 \quad \text{der} \quad D_f = [0, 1].$$ <br> La $a \in \langle 0, 1\rangle$. En tangent til grafen til $f$ i punktet $P(a, f(a))$ skjærer $y$-aksen i et punkt $A$ og $x$-aksen i et punkt $B$ slik at den danner en rettvinklet trekant $\triangle OAB$ der $O$ er origo. Se figuren nedenfor. <br><br> Bestem det minste mulige arealet $\triangle OAB$ kan ha. ![{width="60%", class="adaptive-figure"}](./figurer/jeopardy_4/optimering_500/figur.svg)
    A: $$\dfrac{9}{4}\sqrt{3}$$


Category: L'Hôpitals regel

100:
    Q: Bestem $$\lim_{x \to 0^+} x^2 \ln x$$
    A: $$0$$

200:
    Q: Bestem $$\lim_{x \to \infty} x\left(e^{1/x} - 1\right)$$
    A: $$1$$

300:
    Q: Bestem $$\lim_{x \to 1} \dfrac{(\ln x)^2}{x^2 - 2x + 1}$$
    A: $$1$$


400:
    Q: Bestem $$\lim_{x \to \infty} \left(1 + \dfrac{2}{x}\right)^x$$
    A: $$e^2$$

500:
    Q: En funksjon $f$ er gitt ved $$f(x) = \begin{cases} \dfrac{\ln x}{x - 1} \quad \text{hvis} \quad x \neq 1 \\ \\ 1 \quad \text{hvis} \quad x = 1 \end{cases}$$ <br> Bestem $f'(1)$
    A: $$f'(1) = -\dfrac{1}{2}$$


Category: Deriverbarhet


100:
    Q: En funksjon $f$ er gitt ved $$f(x) = \begin{cases} x^2 \quad \text{hvis} \quad x \leq 1 \\ \\ 2x + 1 \quad \text{hvis} \quad x > 1 \end{cases}$$ <br> Bestem $f'(1)$ dersom den eksisterer.
    A: $$f'(1) = 2$$

200:
    Q: En funksjon $f$ er gitt ved $$f(x) = \begin{cases} x^3 \quad \text{hvis} \quad x \leq 0 \\ \\ 3x + 1 \quad \text{hvis} \quad x > 0 \end{cases}$$ <br> Avgjør om $f$ er deriverbar i $x = 0$.
    A: Funksjonen er ikke deriverbar i $x = 0$.

300:
    Q: En funksjon $f$ er gitt ved $$f(x) = \begin{cases} \dfrac{x^2 - 4}{x - 2} \quad \text{hvis} \quad x \neq 2 \\ \\ a \quad \text{hvis} \quad x = 2 \end{cases}$$ <br> Bestem $a$ slik at $f$ er deriverbar i $x = 2$ og bestem $f'(2)$.
    A: $$a = 4 \quad \land \quad f'(2) = 1$$

400:
    Q: En funksjon $f$ er gitt ved $$f(x) = \begin{cases} \dfrac{e^x - 1 - x}{x} \quad \text{for} \quad x < 0 \\ \\ 0 \quad \text{for} \quad x = 0 \\ \\ \dfrac{1}{2} \ln (1 + x) \quad \text{for} \quad x > 0 \end{cases}$$ <br> <br> Bestem $f'(0)$ dersom den eksisterer.
    A: $$f'(0) = \dfrac{1}{2}$$

500:
    Q: En elev jobber med en funksjon og har skrevet programmet nedenfor for å bestemme en størrelse ved funksjonen: <pre><code class="python">
def f(x):
    if x != 3:        
        return (x**3 - 27) / (x - 3)
    else:        
        return 27

x = 3

for i in range(1, 20):
    h = 1 / 2**i
    dfdx = (f(x + h) - f(x)) / h

    print(dfdx)
    
    </code></pre> <br> <br> Bestem hvilken verdi utskriften til programmet nærmer seg.
    A: $$9$$
:::

